﻿
//=================================================================
// console.cs
//=================================================================
// PowerSDR is a C# implementation of a Software Defined Radio. 
// Copyright (C) 2003-2013  FlexRadio Systems.  
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// You may contact us via email at: gpl@flexradio.com.
// Paper mail may be sent to: 
//    FlexRadio Systems
//    4616 W. Howard Lane  Suite 1-150
//    Austin, TX 78728
//    USA
//=================================================================

// ke9ns things to remember:

// FWCEEPROM.RX2OK
// if (FWCEEPROM.VUOK)

// Invoke(new MethodInvoker(radRX2ModeCWU.Select)); // switch RX2 to CWU mode  

//  if ((Display.CurrentDisplayModeBottom != DisplayMode.OFF) && (rx2_enabled) && (e.Y > H7)) to check if your clicked inside RX2 pan area

// skin is in

// this.txtMultiText.SetStyle(ControlStyles.SupportsTransparentBackColor, true);
// CONDITIONALS   NO_WIDETX;NO_MCL_PM;NO_KE9NS;NO_DJ
// btnhidden.focus  for items that steal focus away from the display.

// AutoClosingMessageBox.Show("Database Updated\nPowerSDR now Closed.", "PowerSDR Closed.", 2000);   this allows for a messagebox that automatically closes after a specified amount of 
// Messagebox(new Form { TopMost = true },"message");
// g.TextRenderingHint = TextRenderingHint.ClearTypeGridFit;
// g.CompositingMode = CompositingMode.SourceOver;
// g.CompositingQuality = CompositingQuality.HighQuality;
// g.InterpolationMode = InterpolationMode.HighQualityBicubic;
// g.SmoothingMode = SmoothingMode.HighQuality;
// g.PixelOffsetMode = PixelOffsetMode.HighQuality;

// System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator;
//  t.CurrentCulture = System.Globalization.CultureInfo.CreateSpecificCulture("en-US");
//  t.CurrentUICulture = System.Globalization.CultureInfo.CreateSpecificCulture("en-US");
//  CultureInfo.InvariantCulture
//
// example of how to disable and EVENT
//setupForm.gridBoxTS.CheckedChanged -= setupForm.gridBoxTS_CheckedChanged;  // ke9ns turn off checkchanged temporarily   
// 
// setupForm.gridBoxTS.CheckedChanged += setupForm.gridBoxTS_CheckedChanged;

//  txtVFOAFreq_LostFocus(this, EventArgs.Empty);    (ke9ns this is how to generate an event programatically)
//
// ke9ns console_closing(), then Dispose(), then ExitConsole(), then back to Displose() to finish
//
// console.Console_Resize(this, e);
// Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)  ==   %userprofile%\AppData\Roaming
//
// string master_path = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\";  // %userprofile%\AppData\Roaming\FlexRadio Systems\
//
// File.Exists(app_data_path + "wisdom"))  // look for %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\wisdom
// File.Exists(master_path + "production")    production = true;   // this allows PA calibration
// File.Exists(master_path + "test_equip")    test_equip = true;   // this allows ?
// File.Exists(master_path + "master.xml");                        // this is list of your PowerSDR radios
//
// path = Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData) + "\\FlexRadio Systems\\PowerSDR";  // ke9ns this is the ProgramData folder
// Application.StartupPath  = \Program Files (x86)\FlexRadio Systems\PowerSDR v2.8.0

//  current_region = FWCEEPROM.Region; or //  current_region = HIDEEPROM.Region;
//
//  extended = FWC.GetStatus(); or  extended = USBHID.GetStatus(); or (File.Exists("extended.edf")		// Check for extended capabilities file
//
//  a.Add("Version/"+this.Text);		    // save the current title bar string
//  a.Add("VersionNumber/" + ver_num);      // PowerSDR version number in a.b.c format
//  a.Add("RadioType/" + CurrentModel);     // radio model string (ex. FLEX1500)
//  a.Add("BandTextID/" + current_region);  // TURF Region
//  a.Add("Opened/" + extended);            // has the radio been opened?

/*
         if (!this.InvokeRequired)
         {
            txtVFOAFreq.Text = value.ToString("f6");
            txtVFOAFreq_LostFocus(this, EventArgs.Empty);
         }
         else
         {
            VFOUpdateDel del = new VFOUpdateDel(VFOAUpdate);
            Invoke(del, new object[] { value });
         }

*/
/*
Class Console
{
   import gdi32.dll here

   public Console
   {
       InitializeComponents();
       InitConsole();

   } // public console

   Dispose()
   {
   }
   InitializeComponents
   {
      select property info for console items here
   }
   Main
   {
      embed fonts here
   }
   InitConsole
   {

   } 
   Flexcontrolscan
   {
   }
   Flexcontrolscan_threadfunction
   {
   }
   SyncDsp
   {
   }
   Exitconsole
   {
   }
   SaveState
   {
   }
   Getstate
   {
   } 






} // class console



*/

//
// SoftRock Modifications Copyright (C) 2005, 2006, 2007 Bill Tracey (kd5tfd)
//

//#define INTERLEAVED
//#define SPLIT_INTERLEAVED
//#define SDRX
#define FLEX1500_BUFFER_MUTE                             // Enables muting audio as buffers switch in RX/TX transitions
//#define WRITE_FFT_TEST

using System;

using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Drawing.Text;
using System.Globalization;
using System.IO;
using System.IO.Ports;
using System.Net;
using System.Net.Sockets; // ke9ns add
using System.Reflection;
using System.Runtime.InteropServices;
using System.Management;
using System.Threading;
using System.Text;
using System.Media; // ke9ns for system Beep
using System.Net.Http; // ke9ns add
using System.Xml.Linq;
using Microsoft.Win32;

//using System.Text.Json; // ke9ns add
//using System.Text.Json.Serialization; // ke9ns add

//System.Windows.Media.Effects; // ke9ns add

using System.Windows.Forms;
using System.Windows.Forms.Design; // ke9ns add


using HttpServer; // rn3kk add

//using System.Threading.Tasks; // ke9ns add net 4.5

using System.Speech.Synthesis; // ke9ns add





using PortTalk;
//using System.Object;
//using System.Windows.Threading.DispatcherObject;
using System.Windows.Media.Imaging;

using FlexCW;
using System.Linq; // ke9ns add
using NAudio.Wave; // ke9ns add
using NAudio.Lame; // ke9ns add

//using MahApps.Metro.Controls; // ke9ns add


#if (!NO_TNF)
using Flex.TNF;
#endif

using Flex.Control;

//using CefSharp;            // ke9ns add to allow embedded chrome browser (for help videos)
//using CefSharp.WinForms;

//using Syncfusion.Windows.Forms.Tools; // ke9ns add
//using Syncfusion.Windows.Forms.HTMLUI; // ke9ns add


namespace PowerSDR
{

    #region Enums

    public enum FWCATUMode
    {
        FIRST = -1,
        Bypass,
        SemiAutomatic,
        Automatic,
        LAST,
    }

    public enum AntMode
    {
        Simple = 0,
        Expert,
    }

    public enum Window
    {
        FIRST = -1,
        RECTANGULAR,
        HANNING,
        WELCH,
        PARZEN,
        BARTLETT,
        HAMMING,
        BLACKMAN2,
        BLACKMAN3,
        BLACKMAN4,
        EXPONENTIAL,
        RIEMANN,
        BLKHARRIS,
        LAST,
    }

    public enum FWCAnt
    {
        NC = 0,
        ANT1,
        ANT2,
        ANT3,
        RX1IN,
        RX2IN,
        RX1TAP,
        SIG_GEN,
        VHF,
        UHF,  // 9      
    }

    public enum HIDAnt
    {
        PA = 0,
        XVTX_COM,
        XVRX,
        BITE,
    }

    public enum RenderType
    {
        HARDWARE = 0,
        SOFTWARE,
        NONE,
    }

    public enum MultiMeterDisplayMode // means 0=first item, 1=second item, 3= thrid item
    {
        Original = 0,    // was a bargraph now ke9ns added tr7
        Edge,            // analog meter with straight needle
        Analog,          // ke9ns added
        Bar,             // ke9ns add back bar graph

    }

    public enum FilterWidthMode
    {
        Linear = 0,
        Log,
        Log10,
    }

    public enum DisplayEngine
    {
        GDI_PLUS = 0,
        DIRECT_X,
    }

    public enum Model
    {
        SDR1000 = 0,
        SOFTROCK40,
        DEMO,
        FLEX5000,
        SDRX,
        FLEX3000,
        FLEX1500,
    }

    public enum BPFBand
    {
        NONE = -1,
        B160,
        B60,
        B20,
        B40,
        B10,
        B6,
    }

    public enum RFELPFBand
    {
        NONE = -1,
        AUX,
        B6,
        B60,
        B20,
        B30,
        B40,
        B1210,
        B80,
        B1715,
        B160,
    }

    public enum PAFBand
    {
        NONE = 0,
        B1210,
        B1715,
        B3020,
        B6040,
        B80,
        B160,
    }

    public enum XVTRTRMode
    {
        NEGATIVE = 0,   // DEMI144-28FRS
        POSITIVE,       // 25W DEMI
        NONE,           // For Elecraft or similar XVTR
    }

    public enum SoundCard
    {
        FIRST = -1,
        UNSUPPORTED_CARD,
        DELTA_44,
        FIREBOX,
        EDIROL_FA_66,
        AUDIGY,
        AUDIGY_2,
        AUDIGY_2_ZS,
        EXTIGY,
        MP3_PLUS,
        SANTA_CRUZ,
        LAST,
    }

    public enum DisplayMode  // ke9ns  rearrange order of display modes
    {
        FIRST = -1,
        PANADAPTER,
        PANAFALL,
        PANAFALL8020,
        WATERFALL,
        PANASCOPE,
        SPECTRUM,
        SCOPE,
        PHASE,
        PHASE2,
        HISTOGRAM,
        OFF,
        CONTINUUM,
        LAST,
    }
    /*
    FIRST = -1,
		SPECTRUM,
		PANADAPTER,
		SCOPE,
		PHASE,
		PHASE2,
		WATERFALL,
		HISTOGRAM,
		PANAFALL,
		PANASCOPE,
		OFF,
		LAST,
      */
    public enum AGCMode
    {
        FIRST = -1,
        FIXD,
        LONG,
        SLOW,
        MED,
        FAST,
        CUSTOM,
        LAST,
    }

    public enum MeterRXMode
    {
        FIRST = -1,
        SIGNAL_STRENGTH,
        SIGNAL_AVERAGE,
        SIGNAL_PEAK,        // ke9ns ADD
        ADC_L,
        ADC_R,
        ADC2_L,
        ADC2_R,
        OFF,
        LAST,
    }

    public enum MeterTXMode
    {
        FIRST = -1,
        FORWARD_POWER,
        REVERSE_POWER,
        MIC,
        EQ,
        LEVELER,
        LVL_G,
        COMP,
        CPDR,
        ALC,
        ALC_G,
        SWR,
        Combo, // ke9ns add
        OFF,
        LAST,
    }

    public enum KeyerLine
    {
        None = 0,
        DTR,
        RTS,
    }

    public enum DateTimeMode
    {
        OFF = 0,
        LOCAL,
        UTC,
        LAST,
    }

    //================================================================================
    // w4tme modify Regions to match SmartSDR March 2017
    public enum FRSRegion
    {
        FIRST = -1,
        US = 0,           // USA  USA, CA, ROW 
        UK = 1,           // EU01 UK, Slovakia, France, Malta  
        Europe = 2,       // EU00 Germany, European Union, IARU1   (5351.5 - 5366.5 kHz)
        UK_Plus = 3,      // EU02 UK+ (adds 60m band)
        Italy = 4,        // EU10 
        Norway = 5,       // EU03 Norway, Czech Rep.
        Denmark = 6,      // EU03  Denmark, Czech Rep.
        Latvia = 7,       // EU08 
        Slovakia = 8,     // EU01 UK, Slovakia, France, Malta (UK,SK,FR,MT)
        Bulgaria = 9,     // EU07 
        Greece = 10,      // EU09 
        Hungary = 11,     // EU05 
        Belgium = 12,     // EU04
        France = 13,      // EU01 UK, Slovakia, France, Malta
        Russia = 14,      // RUSS  
        Sweden = 15,      // EU06 
        IARU3 = 16,       // IARU3 China, Australia, New Zealand
        Japan = 17,       // JPN  
        Italy_Plus = 18,  // EU11 Italy+ (40m band)
        ES_CH_FIN = 19,   // EU12 Spain, Switzerland, Finland (ES,CH,FIN)   5351.5 - 5366.5 kHz
        Netherlands = 20, // EU13 
        EU_Travel = 21,   // EU14 
        Luxembourg = 22,  // EU15
        IARU2 = 23,       // IARU2 (Central & South America)	 (NOTE: 4/17/18 Canada to get IARU1 60m band plan in addition to the 4 existing channels) 5351.5 - 5366.5 kHz
        Australia = 24,   // AUS
        China = 25,       // China (similar to IARU3 except for 60m)
        LAST,
    }


    /*  ke9ns  ORIGINAL 2.7.2 FRSRegion list
        US = 0,           // IARU 2
        Spain_UK = 1,     // now just UK
        Europe = 2,       // IARU 1  
        UK_Plus = 3,      //  
        Italy = 4,        // 
        Norway = 5,       // 
        Denmark = 6,      // 
        Latvia = 7,       // 
        Slovakia = 8,     // 
        Bulgaria = 9,     // 
        Greece = 10,      // 
        Hungary = 11,     // 
        Netherlands = 12, //  now belgium
        France = 13,      // 
        Russia = 14,      // 
        Sweden = 15,      // 
        Region_3 = 16,    // IARU 3
        Japan = 17,       // 
        Italy_Plus = 18,  // 
                         

     */

    public enum PreampMode
    {
        FIRST = -1,
        OFF,
        LOW,
        MED,
        HIGH,
        LAST,
    }

    public enum FLEX1500PreampMode
    {
        FIRST = -1,
        MINUS_10,
        ZERO,
        PLUS_10,
        PLUS_20,
        PLUS_30,
        LAST,
    }

    public enum StatusPin
    {
        PIN_12 = 0x08,      //S3
        Dash = 0x10,        //S4
        Dot = 0x20,     //S5
        PA_DATA = 0x40,     //S6
        PIN_11 = 0x80,      //S7\
    }

    public enum ATUTuneMode
    {
        FIRST = -1,
        BYPASS,
        MEMORY,
        FULL,
        LAST,
    }

    public enum DSPISB // ke9ns add for LSB-AM, USB-AM
    {
        FIRST = -1,
        AML,
        AMU,
        LAST,

    } // DSPISB


    public enum DSPMode
    {
        FIRST = -1,
        LSB, // 0
        USB, // 1
        DSB,
        CWL,
        CWU,
        FM,
        AM,
        DIGU,
        SPEC,
        DIGL,
        SAM, // = 10
        DRM,

        LAST,
    } // DSPMODE

    public enum Band
    {
        FIRST = -1,
        GEN, // 0
        B160M, // 1
        B80M,
        B60M,
        B40M,
        B30M,
        B20M,
        B17M,
        B15M,
        B12M,
        B10M,
        B6M,
        B2M,
        WWV, // 13

        VHF0,
        VHF1,

        VHF2, //16
        VHF3,
        VHF4,
        VHF5,
        VHF6,
        VHF7,
        VHF8,
        VHF9,
        VHF10,
        VHF11,
        VHF12,
        VHF13, // 27

        BLMF, // 28 ke9ns move down below vhf
        B120M,
        B90M,
        B61M,
        B49M,
        B41M,
        B31M,
        B25M,
        B22M,
        B19M,
        B16M,
        B14M,
        B13M,
        B11M, // 41

        LAST,
    }

    public enum Filter
    {
        FIRST = -1,
        F1,
        F2,
        F3,
        F4,
        F5,
        F6,
        F7,
        F8,
        F9,
        F10,
        VAR1,
        VAR2,
        NONE,
        LAST,
    }

    public enum PTTMode
    {
        FIRST = -1,
        NONE,
        MANUAL,
        MIC,
        CW,
        X2,
        CAT,
        VOX,
        LAST,
    }

    public enum DisplayLabelAlignment
    {
        FIRST = -1,
        LEFT,
        CENTER,
        RIGHT,
        AUTO,
        Sunit, // ke9ns add
        OFF,
        LAST,
    }

    public enum ClickTuneMode
    {
        Off = 0,
        VFOA,
        VFOB,
    }

    public enum FMTXMode
    {
        // Order is chosen carefully here for memory form -- take care before rearranging
        High = 0,   // +
        Simplex,    // S
        Low,        // -     
    }

    public enum FlexControlMode
    {
        Basic = 0,
        Advanced,
    }

    public enum FlexControlKnobFunction
    {
        TuneVFOA,
        TuneVFOB,
        TuneVFOASub,
        TuneRIT,
        TuneXIT,
        TuneAF,
        TuneAGCT,
        None,
    }

    #endregion


    sealed unsafe public partial class Console : System.Windows.Forms.Form
    {

        //  public static event Microsoft.Win32.SessionEndingEventHandler SessionEnding; // ke9ns add


        //==================================================================================
        //==================================================================================
        // ke9ns add (copied from cwx precision multimedia msec timer)
        //       everything below

        #region Win32 Multimedia Timer Functions

        //  private int tel;            // time of one element in ms

        // Represents the method that is called by Windows when a timer event occurs.
        private delegate void TimeProc(int id, int msg, int user, int param1, int param2);

        // Specifies constants for multimedia timer event types.

        public enum TimerMode
        {
            OneShot,    // Timer event occurs once.w
            Periodic    // Timer event occurs periodically.
        };

        // Represents information about the timer's capabilities.
        [StructLayout(LayoutKind.Sequential)]
        public struct TimerCaps
        {
            public int periodMin;   // Minimum supported period in milliseconds.
            public int periodMax;   // Maximum supported period in milliseconds.
        }

        // ke9ns add wndProc
        [DllImport("user32.dll", SetLastError = true)]
        static extern bool ShutdownBlockReasonDestroy(IntPtr hWnd);

        [DllImport("user32.dll", SetLastError = true)]
        static extern bool ShutdownBlockReasonCreate(IntPtr hWnd, [MarshalAs(UnmanagedType.LPWStr)] string reason);

        [DllImport("kernel32.dll", SetLastError = true)]
        static extern bool SetProcessShutdownParameters(uint dwLevel, uint dwFlags);




        // Gets timer capabilities.
        [DllImport("winmm.dll")]
        private static extern int timeGetDevCaps(ref TimerCaps caps, int sizeOfTimerCaps);

        // Creates and starts the timer.
        [DllImport("winmm.dll")]
        private static extern int timeSetEvent(int delay, int resolution, TimeProc proc, int user, int mode);


        // Stops and destroys the timer.
        [DllImport("winmm.dll")]
        private static extern int timeKillEvent(int id);

        // Indicates that the operation was successful.
        private const int TIMERR_NOERROR = 0;

        // Timer identifier.
        private int timerID;

        private TimeProc timeProcPeriodic;   // ke9ns add to use windows based multimedia timer

        //   Stopwatch WATCH1 = new Stopwatch();
        //    Stopwatch WATCH2 = new Stopwatch();


        #endregion



     

        //============================================================================ ke9ns add
        //============================================================================ ke9ns add
        // ke9ns ADD font
        // import gdi32.dll because this allows you to embed fonts into PowerSDR
        //============================================================================ ke9ns add
        //============================================================================ ke9ns add
        [DllImport("gdi32.dll")]
        private static extern IntPtr AddFontMemResourceEx(IntPtr pbFont, uint cbFont,
               IntPtr pdv, [In] ref uint pcFonts); // this imports the addfont call

        private static FontFamily S1, S2, S3, S4;    // setup 3 font families
        private static Font ff, ff1, ff2, ff3, ff4, ff5, ff6, ff7, ff8, ff9, ff9a;  // 8 different font sizes and styles


        //============================================================================ ke9ns ad
        //============================================================================ ke9ns add
        // ke9nd ADD images
        // the purpose of this is to embed an image file into PowerSDR
        // make sure to put the jpg in powersdr.resources and set the properties of the jpg to "embed resource"
        //============================================================================ ke9ns add
        //============================================================================ ke9ns add
        private static System.Reflection.Assembly myAssembly = System.Reflection.Assembly.GetExecutingAssembly();
        // this code allows you to embed an image.

        public static Stream meter_image = myAssembly.GetManifestResourceStream("PowerSDR.Resources.met3.jpg"); // ke9ns add tr7 meter image
        public static Stream meter_image1 = myAssembly.GetManifestResourceStream("PowerSDR.Resources.meterback1.png"); // ke9ns add light color analog meter background
        public static Stream meter_image2 = myAssembly.GetManifestResourceStream("PowerSDR.Resources.meterback2.png");// ke9ns add dark color analog meter background

        //  public static Stream meter_image3 = myAssembly.GetManifestResourceStream("PowerSDR.Resources.Black_combo.png");// ke9ns add  meter 
        public static Stream meter_image4 = myAssembly.GetManifestResourceStream("PowerSDR.Resources.Black_TXonly.png");// ke9ns add  meter 

        public static Stream antpic = myAssembly.GetManifestResourceStream("PowerSDR.Resources.ant2.png");// ke9ns add clip art of antenna symbol
        public static Stream antpic3 = myAssembly.GetManifestResourceStream("PowerSDR.Resources.ant3.png");// ke9ns add clip art of antenna symbol

        public static Stream dialpic = myAssembly.GetManifestResourceStream("PowerSDR.Resources.disk3.png");// ke9ns add dial graphic
        public static Stream vfoApic = myAssembly.GetManifestResourceStream("PowerSDR.Resources.arrowA.png");// ke9ns add vfoA graphic
        public static Stream vfoBpic = myAssembly.GetManifestResourceStream("PowerSDR.Resources.arrowB.png");// ke9ns add vfoB graphic


        public static Stream Black_image = myAssembly.GetManifestResourceStream("PowerSDR.Resources.black2.png");// ke9ns add black needle analog meter
        public static Stream Red_image = myAssembly.GetManifestResourceStream("PowerSDR.Resources.red2.png");// ke9ns add red needle analog meter
        public static Stream Yellow_image = myAssembly.GetManifestResourceStream("PowerSDR.Resources.yell2.png");// ke9ns add yellow needle analog meter
        public static Stream White_image = myAssembly.GetManifestResourceStream("PowerSDR.Resources.white2.png");// ke9ns add yellow needle analog meter

        public static Stream Map_image2 = myAssembly.GetManifestResourceStream("PowerSDR.Resources.Wmap1.jpg");     // MAP with lat / long on it


        Image TR7 = new Bitmap(meter_image);         // pre-can the images 
        Image meterback1 = new Bitmap(meter_image1);
        Image meterback2 = new Bitmap(meter_image2);

        //   Image meterback3 = new Bitmap(meter_image3); // ke9ns combo meter
        Image meterback4 = new Bitmap(meter_image4);

        Image ant2 = new Bitmap(antpic); // image of antenna symbol
        Image ant3 = new Bitmap(antpic3); // image of antenna symbol

        Image dial = new Bitmap(dialpic); // image of vfo a
        Image dial1 = new Bitmap(dialpic); // image of vfo b
        Image vfoA = new Bitmap(vfoApic); // image of vfo a
        Image vfoB = new Bitmap(vfoBpic); // image of vfo b

        public Image Wmap1 = new Bitmap(Map_image2); // image of world map


        int yell = 1;
        int red = 3;
        int white = 0;
        int black = 2;

        Bitmap yell1 = new Bitmap(Yellow_image);   // pre-can the images into bitmaps so they can be rotated later
        Bitmap white1 = new Bitmap(White_image);
        Bitmap black1 = new Bitmap(Black_image);
        Bitmap red1 = new Bitmap(Red_image);

        //==================================================================================================

        // ======================================================
        // Variable Declarations 
        // ======================================================

        #region Variable Declarations


        // ======================================================
        // Form Declarations 
        // ======================================================

        public FlexControlBasicForm flexControlBasicForm;
        public FlexControlAdvancedForm flexControlAdvancedForm;
        public Http httpFile;                           // ke9ns add
        public HttpServer httpServer = null;           // rn3kk add

        public Setup setupForm;                        // ke9ns communications with setupform  (i.e. allow combometertype.text update from inside console.cs) 
        public SwlControl SwlForm;                         // ke9ns add band swl form

        public Skin skin1; // ke9ns add

      
        public IDBOX IDBOXForm;                          // ke9ns add ID Timer function function (idtimer)
        public TOTBOX TOTBOXForm;                          // ke9ns add Timeout Timer function function (tottimer)

        private CATParser parser;                       // ke9ns: add to allow serial port (but currently only used in setup for CATURL
        private CATCommands commands;                   // ke9ns: add


        public SpotControl SpotForm;                       // ke9ns add DX spotter function
        public SpotDecoder SpotDecoderForm;                // ke9ns add decoder function

        public ScanControl ScanForm;                       // ke9ns add freq Scanner function
        public StackControl StackForm;                     // ke9ns add band stack form

        public helpbox helpboxForm;                         // ke9ns add helpbox form
        public helpbox1 helpbox1Form;                         // ke9ns add helpbox1 form

        public CWX cwxForm;
        public UCBForm ucbForm;
        public XVTRForm xvtrForm;
        public VUForm vuForm;
        public EQForm eqForm;
        public FilterForm filterRX1Form;
        public FilterForm filterRX2Form;
        public FLEX5000LLHWForm flex5000LLHWForm;
        public FLEX5000DebugForm flex5000DebugForm;
        public FWCMixForm fwcMixForm;
        public FLEX3000MixerForm flex3000MixerForm;
        public FLEX1500MixerForm flex1500MixerForm;
        public FWCAntForm fwcAntForm;
        public FLEX5000RelayForm flex5000RelayForm;
        public FWCATUForm fwcAtuForm;
        public FLEX3000ATUForm flex3000ATUForm;
        public FWCTestForm fwcTestForm;
        public FLEX5000LPFForm flex5000LPFForm;
        public FWCCalForm fwcCalForm;
        public FLEX5000ProdTestForm flex5000ProdTestForm;
        public FLEX5000FinalTestForm flex5000FinalTestForm;
        public FLEX5000RX2CalForm flex5000RX2CalForm;
        public FLEX3000TestForm flex3000TestForm;
        public DSPTestForm dspTestForm;
        public PreSelForm preSelForm;
        public FLEX1500DebugForm flex1500DebugForm;
        public FLEX5000VUCalForm flex5000VUCalForm;
        public DiversityForm diversityForm;

        private AboutForm aboutForm;

        public HIDAntForm hidAntForm;

        public MemoryForm memoryForm;

        public WaveControl WaveForm;                       // ke9ns    communication with the waveform (i.e. allows audio to be played from console.cs)


        public PAQualify PAQualForm;
        public ProductionTest ProdTestForm;

      
        public HidDevice.PowerMate PowerMate;              // ke9ns add communicate with powermate HID

        HidDevice.PowerMate powerMate = new HidDevice.PowerMate();  // ke9ns add link back to PowerMate.cpp and PowerMate.h

        // ======================================================
        // thread Declarations 
        // ======================================================

      
        private Thread[] audio_process_thread;              // threads to run DttSP functions
        private Thread draw_display_thread;                 // draws the main display 
        private Thread multimeter_thread;                   // updates the rx1/tx meter data
        private Thread rx2_meter_thread;                    // updates the rx2 meter data
        private Thread poll_ptt_thread;                     // polls the PTT line on the parallel port
        private Thread poll_RXOnly_thread;  // ke9ns add
        private Thread poll_pa_pwr_thread;                  // polls the FWD and REV power if the PA is installed
        private Thread sql_update_thread;                   // polls the RX signal strength
        private Thread rx2_sql_update_thread;               // polls the RX2 signal strength
        private Thread vox_update_thread;                   // polls the mic input
        private Thread noise_gate_update_thread;			// polls the mic input during TX
        private Thread f3k_temp_thread;				        // polls the temp on the FLEX-3000 to turn fan on/off
        private Thread f3k_mic_function_thread;				// handles the FLEX-3000 mic inputs (Up, Down, Fast)
        //private Thread wbir_thread;
        //private Thread wbir_rx2_thread;
        private Thread update_rx1_dds_thread;
        private Thread update_rx2_dds_thread;
        private Thread update_tx_dds_thread;
        private Thread audio_watchdog_thread;
        //private HiPerfTimer polltimer;
        public Mutex calibration_mutex = new Mutex();

        private Mutex psdr2_mutex;                                  // Mutex for INNO installer
        private string psdr2_mutex_name = "PowerSDRv2.x_Mutex";     // Mutex name
        private bool psdr2_mutex_exists = false;                    // is true when Mutex has been created
        private bool dax_audio_enum = false;

        // ======================================================
        // variables Declarations 
        // ======================================================


        public int KBON = 0; // ke9ns add 1=knob present 0=knob not present
        public int speed = 0; // ke9ns add speed of knob freq change
        public int lastvalue = 0; // ke9ns add knob

        SpeechSynthesizer speaker = new SpeechSynthesizer(); // ke9ns add 

        public DSP dsp;
        private SIOListenerII siolisten = null;              // original CAT port

        private SIOListenerII2 siolisten2 = null;              // ke9ns.180  CAT port2
        private SIOListenerII3 siolisten3 = null;              // ke9ns CAT port3
        private SIOListenerII4 siolisten4 = null;              // ke9ns CAT port4
        private SIOListenerII5 siolisten5 = null;              // ke9ns CAT port5
        private SIOListenerII6 siolisten6 = null;              // ke9ns CAT port6 .200 spoof VFOA to B

        private bool calibration_running = false;
        private bool displaydidit = false;
        //private bool calibrationdidit = false;
      
        private SIOListenerIII siolisten1 = null;          // ke9ns add for ant rotor control

        public bool fwc_init = false;
        public int fwc_index = -1;
        private long fwc_last_cal_date_time = 0;
        private uint fwc_serial_num = 0;
        private uint fwc_trx_serial_num = 0;
        private uint rx2_trx_match_serial = 0;

        private int rx1_squelch_threshold_scroll = -160;
        private int rx2_squelch_threshold_scroll = -160;
        private bool rx1_squelch_on = false;
        private bool rx2_squelch_on = false;
        private int rx1_fm_squelch_threshold_scroll = 0;
        private int rx2_fm_squelch_threshold_scroll = 0;

        private long rx2_last_cal_date_time = 0;
        private uint rx2_serial_num = 0;

        public bool hid_init = false;
        public int hid_index = -1;
        private long hid_last_cal_date_time = 0;
        private uint hid_serial_num = 0;
        private uint hid_trx_serial_num = 0;

     
        private MemoryList memoryList;

        public MemoryList MemoryList
        {
            get { return memoryList; }
        }



        //====================================================================================
        // ke9ns add  dx cluster list
        private DXMemList dxmemList; // ke9ns add

        public DXMemList DXMemList // ke9ns add
        {
            get { return dxmemList; }
        }

        //=======================================================================================


        private HW hw;                                      // will eventually be an array of rigs to support multiple radios


      
        private bool run_setup_wizard;						// Used to run the wizard the first time the software comes up
        private bool show_alpha_warning = false;
        private bool show_beta_warning = true;
        private bool show_mobile_warning = true;

        //    public int[] band = new int[100];

        //   [StructLayout(LayoutKind.Explicit)]
        //  public struct UnionTest

        // {

        //   [FieldOffset(0)]  public int band_160m_index;                     // These band indexes are used to keep track of which
        //  [FieldOffset(0)]  band[0];
        // }


        public int[] band_index = new int[100];  //  replaces band_160m_index; 
        public int[] band_register = new int[100]; // replaces band_160m_register;	


        public int band_160m_index;                     // These band indexes are used to keep track of which
        public int band_80m_index;                          // location in the bandstack was last saved/recalled
        public int band_60m_index;
        public int band_40m_index;
        public int band_30m_index;
        public int band_20m_index;
        public int band_17m_index;
        public int band_15m_index;
        public int band_12m_index;
        public int band_10m_index;
        public int band_6m_index;
        public int band_2m_index;
        public int band_wwv_index;
        public int band_gen_index;

        public int band_LMF_index; // ke9ns add
        public int band_120m_index;
        public int band_90m_index;
        public int band_61m_index;
        public int band_49m_index;
        public int band_41m_index;
        public int band_31m_index;
        public int band_25m_index;
        public int band_22m_index;
        public int band_19m_index;
        public int band_16m_index;
        public int band_14m_index;
        public int band_13m_index;
        public int band_11m_index;

        public int band_vhf0_index;
        public int band_vhf1_index;
        public int band_vhf2_index;
        public int band_vhf3_index;
        public int band_vhf4_index;
        public int band_vhf5_index;
        public int band_vhf6_index;
        public int band_vhf7_index;
        public int band_vhf8_index;
        public int band_vhf9_index;
        public int band_vhf10_index;
        public int band_vhf11_index;
        public int band_vhf12_index;
        public int band_vhf13_index;



        public int band_160m_register;                      // These integers are the number of band stack registers
        public int band_80m_register;                       // found in the database for each band
        public int band_60m_register;
        public int band_40m_register;
        public int band_30m_register;
        public int band_20m_register;
        public int band_17m_register;
        public int band_15m_register;
        public int band_12m_register;
        public int band_10m_register;
        public int band_6m_register;
        public int band_2m_register;
        public int band_wwv_register;
        public int band_gen_register;

        public int band_LMF_register; // ke9ns add
        public int band_120m_register;
        public int band_90m_register;
        public int band_61m_register;
        public int band_49m_register;
        public int band_41m_register;
        public int band_31m_register;
        public int band_25m_register;
        public int band_22m_register;
        public int band_19m_register;
        public int band_16m_register;
        public int band_14m_register;
        public int band_13m_register;
        public int band_11m_register;

        public int band_vhf0_register;
        public int band_vhf1_register;
        public int band_vhf2_register;
        public int band_vhf3_register;
        public int band_vhf4_register;
        public int band_vhf5_register;
        public int band_vhf6_register;
        public int band_vhf7_register;
        public int band_vhf8_register;
        public int band_vhf9_register;
        public int band_vhf10_register;
        public int band_vhf11_register;
        public int band_vhf12_register;
        public int band_vhf13_register;



        //   private RadioButtonTS[] gen_text; // ke9ns add


        private bool was_panadapter = false;                // used to restore panadater when switching to spectrum DSP mode
        private bool was_waterfall = false;                 // used to restore waterfall when switching to spectrum DSP mode

        public float[] rx1_preamp_offset;                   // offset values for each preamp mode in dB
        public float[] rx2_preamp_offset;                   // offset values for each preamp mode in dB
        public float rx1_meter_cal_offset;                  // multimeter calibration offset per volume setting in dB
        public float rx2_meter_cal_offset;                  // multimeter calibration offset per volume setting in dB
        public float rx1_filter_size_cal_offset = 3;        // filter offset based on DSP filter size
        public float rx2_filter_size_cal_offset = 3;        // filter offset based on DSP filter size

        private bool meter_data_ready;                      // used to synchronize the new DSP data with the multimeter
                                                            //  private bool meter_data_ready2;                      // ke9ns add for using rx2 for extra tx meter

        public float new_meter_data;                       // new data for the multimeter from the DSP
        private float new_meter_data2;                       // ke9ns add for using RX2 for extra TX meter

        private float current_meter_data;                   // current data for the multimeter
        private int meter_peak_count;                       // Counter for peak hold on multimeter
        private float meter_peak_value;                     // Value for peak hold on multimeter
        private float[] meter_text_history;                 // Array used to output the peak power over a period of time
        private int meter_text_history_index;               // index used with above variable to do peak power

        private bool rx2_meter_data_ready;                  // used to synchronize the new DSP data with the multimeter
        private float rx2_meter_new_data;					// new data for the multimeter from the DSP
        private double tx2_meter_new_data;                  // ke9ns add to allow MIC dBm values while in RX mode
        private float rx2_meter_current_data;               // current data for the multimeter
        private int rx2_meter_peak_count;                   // Counter for peak hold on multimeter
        private float rx2_meter_peak_value;                 // Value for peak hold on multimeter

        public float[][] power_table;						// table used to store power in new power cal routine
        public float[] vhf_power_table;                     // table used to store VHF power (Audio.RadioVolume) in VU cal routine
        public float[] uhf_power_table;                     // table used to store UHF power (Audio.RadioVolume) in VU cal routine
        public double[] freqs_2m = { 144.0, 144.3, 144.6, 144.9, 145.2, 145.5, 145.8, 146.1, 146.4, 146.7, 147.0, 147.3, 147.9, 148.0 };
        public double[] freqs_70cm = { 430.0, 431.5, 433.0, 434.5, 436.0, 437.5, 439.0, 440.5, 442.0, 443.5, 445.0, 445.5, 446.0, 446.5, 447.0, 447.5, 448.0, 448.5, 449.0, 449.5, 449.975, 450.0 };

        public int pa_fwd_power;                            // forward power as read by the ADC on the PA
        public int pa_rev_power;                            // reverse power as read by the ADC on the PA
        public bool tuning;                                 // true when the TUN button is active
        public bool atu_tuning;                             // true while the atu is tuning
        private Band tuned_band;                            // last band that the atu was tuned on

        public float[] rx1_image_gain_table;                // table used to store image cal info
        public float[] rx1_image_phase_table;               // table used to store image cal info
        public float[] rx2_image_gain_table;                // table used to store image cal info
        public float[] rx2_image_phase_table;               // table used to store image cal info
        public float[] tx_image_gain_table;                 // table used to store image cal info
        public float[] tx_image_phase_table;                // table used to store image cal info
        public int[][] pa_bias_table;                       // table used to store PA Bias settings
        public float[][] rx1_level_table;                   // table used to store RX1 Level cal settings
        public float[][] rx2_level_table;                   // table used to store RX2 Level cal settings
        public float[][] pa_bridge_table;                   // table used to store PA Bridge cal settings
        public float[] swr_table;							// table used to calibrate SWR
        public float[] atu_swr_table;                       // table used to cal SWR at ATU power
        public float rx2_res_offset;
        public float[] vhf_level_table;
        public float[] uhf_level_table;

        //public int[][] tx_carrier_table;					// table used to store tx carrier cal info
        public SortedDictionary<double, uint> tx_carrier_cal;

        public byte rx1_level_checksum;
        public byte rx1_image_gain_checksum;
        public byte rx1_image_phase_checksum;
        public byte tx_image_gain_checksum;
        public byte tx_image_phase_checksum;
        public byte tx_carrier_checksum;
        public byte pa_bias_checksum;
        public byte pa_bridge_checksum;
        public byte pa_power_checksum;
        public byte pa_swr_checksum;
        public byte atu_swr_checksum;
        public byte vu_level_checksum;
        public byte vu_power_checksum;

        public byte rx2_level_checksum;
        public byte rx2_image_gain_checksum;
        public byte rx2_image_phase_checksum;


        public double[] CTCSS_array =  {
            67.0 , 69.3 , 71.9 , 74.4 , 77.0 , 79.7 , 82.5 , 85.4 , 88.5 , 91.5 ,
            94.8 , 97.4 , 100.0, 103.5, 107.2, 110.9, 114.8, 118.8, 123.0, 127.3,
            131.8, 136.5, 141.3, 146.2, 151.4, 156.7, 159.8, 162.2, 165.5, 167.9,
            171.3, 173.8, 177.3, 179.9, 183.5, 186.2, 189.9, 192.8, 199.5, 203.5,
            206.5, 210.7, 218.1, 225.7, 229.1, 233.6, 241.8, 250.3, 254.1};

        public double[] FM_deviation_array = { 9000, 5000, 2500 }; // ke9ns mod  was 5000, 2500. add 9000 (used my memoryform.cs)

        public bool oldATU = true;

        private bool shift_down;                            // used to modify tuning rate
        private bool calibrating;                           // true if running a calibration routine
        public bool manual_mox;                         // True if the MOX button was clicked on (not PTT)		

        public DSPMode vfob_dsp_mode;                       // Saves control pointer for last mode used on VFO B 
        private Filter vfob_filter;                         // Saves control pointer for last filter used on VFO B

        // txtVFOAFreq.Font (Standard VFO font size)
        private int vfo_char_width;                         // "0"                 (pixel width of large characters)                  Used to calibrate mousewheel tuning
        private int vfo_char_space;                         // "00" - 2*"0"        (pixel space in between 2 large characters)          Used to calibrate mousewheel tuning
        private int vfo_decimal_space;                      // "0.0"- 2*"0"        (pixel width of seperator char)                    Used to calibrate mousewheel tuning		
        private int vfo_pixel_offset;                       // "1234.678901"       (pixel width of this string)                       Used to calibrate mousewheel tuning

        // txtVFOALSD.Font (small VFO font size)
        private int vfo_small_char_width;                   // "0"                 (pixel width of small characters)                  Used to calibrate mousewheel tuning
        private int vfo_small_char_space;                   // "00" - 2*"0"        (pixel space in between small characters)          Used to calibrate mousewheel tuning

        // txtVFOABand.Font (veru small bandtext font size)
        private int vfo_sub_char_width;                     // "0"                 (pixel width of large char)                        Used to calibrate mousewheel tuning
        private int vfo_sub_char_space;                     // "00" - 2*"0"        (pixel space in between 2 large characters)         Used to calibrate mousewheel tuning
        private int vfo_sub_decimal_space;                  // "0.0" - 2*"0"       (pixel width of seperator char)   Used to calibrate mousewheel tuning	
        private int vfo_sub_pixel_offset;                   // "1234.678901"       (pixel width of this string)

        private int vfoa_hover_digit;                       // -1                  Digit for hover display
        private int vfoa_sub_hover_digit;                   // Digit for VFOA sub hover display
        private int vfob_hover_digit;                       // Digit for hover display

        public string last_band;							// Used in bandstacking algorithm
        public int last_band_index;                         // ke9ns add for display of bandstack frequencies
        public int last_band_index_size;                    // ke9ns add

        public string last_band2;							// Used in bandstacking algorithm .209 for VFOB
        public int last_band_index2;                         // ke9ns add for display of bandstack frequencies
        public int last_band_index_size2;                    // ke9ns add


        private DSPMode quick_save_mode;                    // Quick Save Mode
        private Filter quick_save_filter;                   // Quick Save Filter

        private int vfo_sub_decimal_width;                  // NOT USED  
        private int vfo_decimal_width;                      // NOT USED

        private string separator;                           // contains the locations specific decimal separator

        private int last_filter_shift;                      // VK6APH
        private int last_var1_shift;                        // VK6APH 
        private int last_var2_shift;                        // VK6APH

        public string[] CmdLineArgs;

        private double rx1_avg_last_ddsfreq = 0;                // Used to move the display average when tuning
        private double rx1_avg_last_dttsp_osc = 0;
        private double rx1_last_bin_shift_leftover = 0;

        private double rx2_avg_last_ddsfreq = 0;                // Used to move the display average when tuning
        private double rx2_avg_last_dttsp_osc = 0;
        private double rx2_last_bin_shift_leftover = 0;

        private HiPerfTimer break_in_timer;
        public double avg_vox_pwr = 0.0;

        // BT 11/05/2007
        public PowerSDR.RemoteProfiles ProfileForm; // CAT

        //EHR 25Mar08
        private TDxInput.Device TDxDevice;
        private TDxInput.Sensor TDxSensor;

        public bool initializing = true;

        private int h_delta = 0;        //k6jca 1/15/08
        private int v_delta = 0;        //k6jca 1/15/08

        private int previous_delta = 0;  //k6jca

        private Size console_basis_size = new Size(100, 100);       //k6jca
        private Point gr_filter_basis_location = new Point(100, 100);       //k6jca
        private Point gr_Multimeter_basis_location = new Point(100, 100);       //k6jca
        private Point gr_BandHF_basis_location = new Point(100, 100);       //k6jca
        private Point gr_BandGEN_basis_location = new Point(100, 100);       //ke9ns add
        private Point gr_BandVHF_basis_location = new Point(100, 100);      //k6jca

        private Point gr_BandHFRX2_basis_location = new Point(100, 100);      
        private Point gr_BandGENRX2_basis_location = new Point(100, 100);       //ke9ns add
        private Point gr_BandVHFRX2_basis_location = new Point(100, 100);      


        private Point gr_Mode_basis_location = new Point(100, 100);     //k6jca
        private Point gr_VFOB_basis_location = new Point(100, 100);     //k6jca
        private Point gr_VFOA_basis_location = new Point(100, 100);		//k6jca

        private Point gr_VFODialA_location = new Point(100, 100);     //ke9ns add
        private Point gr_VFODialB_location = new Point(100, 100);     //ke9ns add

        private Point gr_VFODialAA_location = new Point(100, 100);     //ke9ns add
        private Point gr_VFODialBB_location = new Point(100, 100);     //ke9ns add

        private Point gr_screencap_location = new Point(100, 100);     //ke9ns add
        private Point gr_buttoncall_location = new Point(100, 100);     //ke9ns add
        private Point gr_buttonVK1_location = new Point(100, 100);     //ke9ns add .189
        private Point gr_buttonVK2_location = new Point(100, 100);     //ke9ns add

        private Point gr_buttoncq_location = new Point(100, 100);     //ke9ns add
      
        private Point gr_udcqcqrepeat_location = new Point(100, 100);     //ke9ns add
        private Point autobrightbox_basis = new Point(100, 100);               // ke9ns add autobrightbox

        private Point gr_ModePhone_basis_location = new Point(100, 100);        //k6jca
        private Point gr_ModeCW_basis_location = new Point(100, 100);       //k6jca
        private Point gr_ModeDig_basis_location = new Point(100, 100);		//k6jca
        private Point gr_ModeFM_basis_location = new Point(100, 100);  // anonymous
        private Point gr_VFO_basis_location = new Point(100, 100);      //k6jca
        private Point gr_vfobetween_basis_location = new Point(100, 100);       //k6jca
        private Point btn_display_pan_center_basis = new Point(100, 100);       //k6jca
        private Point tb_display_pan_basis = new Point(100, 100);       //k6jca
      
        private Size tb_display_pan_size_basis = new Size(100, 100);        //k6jca
        private Size tb_display_pan2_size_basis = new Size(100, 100);        //.219

        private Point btn_display_zoom_4x_basis = new Point(100, 100);      //k6jca
        private Point btn_display_zoom_2x_basis = new Point(100, 100);      //k6jca
        private Point btn_display_zoom_1x_basis = new Point(100, 100);      //k6jca
        private Point btn_display_zoom_05_basis = new Point(100, 100);      //k6jca
        private Point tb_display_zoom_basis = new Point(100, 100);      //k6jca
        private Point tb2_display_zoom_basis = new Point(100, 100);      //.219

        private Point txt_display_peak_freq_basis = new Point(100, 100);        //k6jca
        private Point txt_display_peak_power_basis = new Point(100, 100);       //k6jca
        private Point txt_display_peak_offset_basis = new Point(100, 100);		//k6jca
        private Point lbl_display_zoom_basis = new Point(100, 100);     //k6jca
        private Size gr_display_size_basis = new Size(100, 100);        //k6jca
        private Size pic_display_size_basis = new Size(100, 100);       //k6jca
        private Size textbox1_size_basis = new Size(100, 100);      //k6jca
        private Point textbox1_basis = new Point(100, 100);     //k6jca
        private Point gr_display2_basis = new Point(100, 100);      //k6jca
        private Point gr_dsp_basis = new Point(100, 100);       //k6jca
        private Point tb_displaypan_basis = new Point(100, 100);        //k6jca
        private Point tb_displaypan2_basis = new Point(100, 100);        //.219

        private Point lbl_displaypan_basis = new Point(100, 100);       //k6jca
        private Point buttonVK1_basis = new Point(100, 100); //ke9ns
        private Point buttonVK2_basis = new Point(100, 100); //ke9ns
        private Point txt_display_cursor_freq_basis = new Point(100, 100);      //k6jca
        private Point txt_display_cursor_power_basis = new Point(100, 100);     //k6jca
        private Point txt_display_cursor_offset_basis = new Point(100, 100);        //k6jca
        private Point txt_screen_save_offset_basis = new Point(100, 100);        //ke9ns add

        private Point chk_power_basis = new Point(100, 100);        //k6jca
        private Point gr_multirx_basis = new Point(100, 100);       //k6jca

        private Point pan_rx2_divider_basis = new Point(100, 100);
        private Size pan_rx2_divider_size_basis = new Size(100, 100);

        private Point gr_display_split_basis = new Point(100, 100); // KE5DTO
        private Point gr_options_basis = new Point(100, 100);       //k6jca
        private Point gr_sound_controls_basis = new Point(100, 100);        //k6jca
        private Point chk_squelch_basis = new Point(100, 100);      //k6jca
        private Point ud_squelch_basis = new Point(100, 100);       //k6jca
        private Point pic_sql_basis = new Point(100, 100);      //k6jca
        private Point tb_sql_basis = new Point(100, 100);       //k6jca
        private Point gr_antenna_basis = new Point(100, 100);       //k6jca
        private Point chk_bci_basis = new Point(100, 100);      //k6jca
        private Point button1_basis = new Point(100, 100);      //k6jca
        private Point gr_date_time_basis = new Point(100, 100);     //k6jca
                                                                    //private Point lbl_cpu_meter_basis = new Point (100,100);		//k6jca

        private Point gr_rx2_meter_basis = new Point(100, 100);
        private Point gr_rx2_filter_basis = new Point(100, 100);
        private Point gr_rx2_mode_basis = new Point(100, 100);
        private Point gr_rx2_display_basis = new Point(100, 100);
        private Point gr_rx2_dsp_basis = new Point(100, 100);

        private Point lbl_rx2_rf_basis = new Point(100, 100);
        private Point ud_rx2_rf_basis = new Point(100, 100);
        private Point tb_rx2_rf_basis = new Point(100, 100);
        private Point chk_rx2_squelch_basis = new Point(100, 100);
        private Point ud_rx2_squelch_basis = new Point(100, 100);
        private Point tb_rx2_squelch_basis = new Point(100, 100);
        private Point pic_rx2_squelch_basis = new Point(100, 100);

        private Point gr_rx2_mixer_basis = new Point(100, 100);
        private Point chk_rx2_enable_basis = new Point(100, 100);
        private Point chk_rx2_preamp_basis = new Point(100, 100);
        private Point lbl_rx2_band_basis = new Point(100, 100);
        private Point combo_rx2_band_basis = new Point(100, 100);

        public bool swapping = false;   //used to supress V/U on both RX1/RX2 error while swapping

        public int AGCTAdj = 55; // ke9ns add: default AGCT gain adjustment for green line


#if (NO_DJ)
        //mod DH1TW
        public DJConsole DJConsoleObj;
        public DJConsoleUI.DJConsoleSelect DJConsoleConfigurator;

#endif




        #endregion 

      
        #region Constructor and Destructor
        // ======================================================
        // Constructor and Destructor
        // ======================================================
        public Console(string[] args)                  // ke9ns: Main() called first
        {

            Debug.WriteLine("===START=== Console here");

            //====================================================================================
            //====================================================================================
            //====================================================================================
            // KE9NS ADD: the purpose of this function is to embed the fonts into the resource (PowerSDR.exe)
            // this for some reason requires using unmanaged memory as opposed to simply reading the file.
            //====================================================================================
            //====================================================================================
            //====================================================================================
            // Embed Swis721 BlkEx BT Font
            byte[] fontArray = Properties.Resources.swissek;  //  swissek buffer to hold Font file
            int dataLength = Properties.Resources.swissek.Length; //  swissek get length of Font file


            byte[] fontArray1 = Properties.Resources.swissb;  // swissbi  buffer to hold Font file     SWIS721 Bold
            int dataLength1 = Properties.Resources.swissb.Length; // swissbi  get length of Font file

            byte[] fontArray2 = Properties.Resources.swisscki;  // swisscki  buffer to hold Font file    SWIS721 Condensed Kerfed Italic FONT
            int dataLength2 = Properties.Resources.swisscki.Length; // swisscki  get length of Font file


            byte[] fontArray3 = Properties.Resources.swissbo;  // swisscbo  buffer to hold Font file     SWIS721 OUTLINE FONT
            int dataLength3 = Properties.Resources.swissbo.Length; // swisscbo  get length of Font file

            //  byte[] fontArray3 = Properties.Resources.napoli;  //   buffer to hold Font file
            //  int dataLength3 = Properties.Resources.napoli.Length; //   get length of Font file

            IntPtr ptrData = Marshal.AllocCoTaskMem(dataLength); //int pointer to a allocated block of unmanaged memory the size of the Font File
            IntPtr ptrData1 = Marshal.AllocCoTaskMem(dataLength1); //int pointer to a allocated block of unmanaged memory the size of the Font File
            IntPtr ptrData2 = Marshal.AllocCoTaskMem(dataLength2); //int pointer to a allocated block of unmanaged memory the size of the Font File
            IntPtr ptrData3 = Marshal.AllocCoTaskMem(dataLength3); //int pointer to a allocated block of unmanaged memory the size of the Font File


            Marshal.Copy(fontArray, 0, ptrData, dataLength); // copy Font File bytes source -> into unmanged memory block
            Marshal.Copy(fontArray1, 0, ptrData1, dataLength1); // copy Font File bytes source -> into unmanged memory block
            Marshal.Copy(fontArray2, 0, ptrData2, dataLength2); // copy Font File bytes source -> into unmanged memory block
            Marshal.Copy(fontArray3, 0, ptrData3, dataLength3); // copy Font File bytes source -> into unmanged memory block

            uint cFonts = 0;


            AddFontMemResourceEx(ptrData, (uint)fontArray.Length, IntPtr.Zero, ref cFonts); // class part of gdi32.dll add Font from unmanged memory block
            AddFontMemResourceEx(ptrData1, (uint)fontArray1.Length, IntPtr.Zero, ref cFonts); // class part of gdi32.dll add Font from unmanged memory block
            AddFontMemResourceEx(ptrData2, (uint)fontArray2.Length, IntPtr.Zero, ref cFonts); // class part of gdi32.dll add Font from unmanged memory block
            AddFontMemResourceEx(ptrData3, (uint)fontArray3.Length, IntPtr.Zero, ref cFonts); // class part of gdi32.dll add Font from unmanged memory block

            PrivateFontCollection pfc = new PrivateFontCollection();  // class to provide client provided fonts
            PrivateFontCollection pfc1 = new PrivateFontCollection();  // class to provide client provided fonts
            PrivateFontCollection pfc3 = new PrivateFontCollection();  // class to provide client provided fonts


            pfc.AddMemoryFont(ptrData, dataLength); // add Font from unmanaged memory block
            pfc.AddMemoryFont(ptrData1, dataLength1); // add Font from unmanaged memory block
            pfc1.AddMemoryFont(ptrData2, dataLength2); // add Font from unmanaged memory block
            pfc3.AddMemoryFont(ptrData3, dataLength3); // add Font from unmanaged memory block

            Marshal.FreeCoTaskMem(ptrData);  // release unmanaged memory block (safe again)
            Marshal.FreeCoTaskMem(ptrData1);  // release unmanaged memory block (safe again)
            Marshal.FreeCoTaskMem(ptrData2);  // release unmanaged memory block (safe again)
            Marshal.FreeCoTaskMem(ptrData3);  // release unmanaged memory block (safe again)

            S1 = pfc.Families[0]; // swissek
            S2 = pfc.Families[1]; // swissb  Swis721 BT Bold

            S3 = pfc1.Families[0]; //swisscki
            S4 = pfc3.Families[0]; //swisscbo

            ff = new Font(S1, 7.0f, FontStyle.Bold | FontStyle.Italic); // Swis721 BlkEx B  // analog meters
            ff1 = new Font(S1, 6.9f, FontStyle.Bold | FontStyle.Italic); // Swis721 BlkEx B // white numbers
            ff2 = new Font(S1, 5.5f, FontStyle.Bold | FontStyle.Italic); // Swis721 BlkEx B // red +numbers

            ff3 = new Font(S2, 14.0f, FontStyle.Bold); // Swis721 BT // digital meter values
            ff4 = new Font(S2, 12.0f, FontStyle.Bold); // Swis721 BT
            ff5 = new Font(S2, 8.25f, FontStyle.Bold); // Swis721 BT

            ff8 = new Font(S2, 11.0f, FontStyle.Bold | FontStyle.Italic); // Swis721 BT  font for meter indication

            //    f6 = new Font(S2, 32.0f, FontStyle.Italic); // Swis721 BT for txtVFOAMSD (A and B)
            //    f7 = new Font(S2, 27.0f, FontStyle.Italic); // Swis721 BT for txtVFOALSD (A and B)

            //   f6 = new Font(S3, 32.0f, FontStyle.Regular); // Swis721 BI for txtVFOAMSD (A and B) its already a Bold and Italic font
            //  f7 = new Font(S3, 27.0f, FontStyle.Regular); // Swis721 BI for txtVFOALSD (A and B)


            ff6 = new Font(S3, 32.0f, FontStyle.Bold | FontStyle.Italic); // Swis721 BI for txtVFOAMSD (A and B) its already a Bold and Italic font
            ff7 = new Font(S3, 27.0f, FontStyle.Bold | FontStyle.Italic); // Swis721 BI for txtVFOALSD (A and B)

            ff9 = new Font(S4, 32.5f, FontStyle.Bold); // Swis721 BO for txtVFOAMSD (A and B) its already a Open and Italic font
            ff9a = new Font(S4, 27.0f, FontStyle.Bold); // Swis721 BO for txtVFOAMSD (A and B) its already a Open and Italic font


            //============================================================================================================ ke9ns add end


            foreach (string s in args)
            {
                if (s.StartsWith("-datapath:"))
                {
                    string path = s.Trim().Substring(s.Trim().IndexOf(":") + 1);

                    if (path.EndsWith("\"")) path = path.Substring(0, path.Length - 1);

                    if (!path.EndsWith("\\")) path += "\\";

                    if (Directory.Exists(path)) AppDataPath = path;
                    else
                    {
                        DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "-datapath: command line option found, but the folder specified was not found.\n" +
                            "Would you like to create this folder?  If not, the default folder will be used.\n\n" +
                            "(" + s + ")",
                            "Command Line Option: Create Folder?",
                            MessageBoxButtons.YesNo,
                            MessageBoxIcon.Question);

                        if (dr == DialogResult.Yes)
                        {
                            Directory.CreateDirectory(path);
                            AppDataPath = path;
                        }
                    }
                }
            }


            //---------------------------------------------------------------------------------
            // ke9ns info:    Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)  ==   %userprofile%\AppData\Roaming

            if (app_data_path == "") // ke9ns: %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\
            {
                Assembly assembly = Assembly.GetExecutingAssembly();
                FileVersionInfo fvi = FileVersionInfo.GetVersionInfo(assembly.Location);
                string version = fvi.FileVersion.Substring(0, fvi.FileVersion.LastIndexOf("."));

                //  AppDataPath = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\PowerSDR" + version + "\\"; // ke9ns original
                AppDataPath = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\PowerSDR v2.8.0\\"; // keep it the same otherwise everyone starts with a new database
                                                                                                                                               //  AppDataPath1 = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\PowerSDR v2.7.2\\"; // keep it the same otherwise everyone starts with a new database

            }
			
			if (app_data_path1 == "")
            {
				AppDataPath1 = Environment.GetFolderPath(Environment.SpecialFolder.MyMusic) + "\\PowerSDR"; // Store recorded sound to C:\User Profile\Music
            }

            // identify all detectable radios (FLEX-5000s, FLEX-3000s, FLEX-1500s)
            RadiosAvailable.Init();

            // check for existence of master file
            string master_path = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\";  // %userprofile%\AppData\Roaming\FlexRadio Systems\
            string common_data_path = Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData) + "\\FlexRadio Systems\\PowerSDR\\"; // C:\ProgramData\FlexRadio Systems\PowerSDR\

            if (File.Exists(master_path + "production")) production = true;  // ke9ns if an empty file called production is found in the  %userprofile%\AppData\Roaming\FlexRadio Systems\ folder

            if (File.Exists(master_path + "test_equip")) test_equip = true;   // ke9ns if an empty file called test_quip is found in the  %userprofile%\AppData\Roaming\FlexRadio Systems\ folder


             Debug.WriteLine("COMMON: " + common_data_path);
            Debug.WriteLine("Production: " + production);

            Master.Init();

            Debug.Assert(File.Exists(master_path + "master.xml"));

            // decide whether to present a choice of radios to the user
            Pal.Init();  // ke9ns: Performance Analysis Logger tool (PerfMon) currently at 4.1.3.17357 Flex Radio 1/30/2013

            RadiosAvailable.ScanPal(); // gather info on Pal radios

            if (RadiosAvailable.NumPresent == 0) // handle v1.x firmware
            {
                if (FWCMidi.Open())
                {
                    /*MessageBox.Show(new Form { TopMost = true }, "Error communicating with radio.  The program will now be closed.\n" +
                        "Please update the radio firmware to v2.0+ to prevent this issue.\n" +
                        "For instructions, visit:\n\n http://kc.flexradio.com/KnowledgebaseArticle50441.aspx",
                        "Communication Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    Process.GetCurrentProcess().Kill();
                    return;*/

                    uint model;
                    int ret = FWC.GetModelMidi(out model);
                    if (model == 3) current_model = Model.FLEX3000;
                    else current_model = Model.FLEX5000;

                    DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "A radio firmware update is required in order to continue.\n\n" +
                        "Would you like to update your firmware now?\n" +
                        "If not, PowerSDR will be closed.",
                        "Update Firmware Now?",
                        MessageBoxButtons.YesNo,
                        MessageBoxIcon.Question);

                    if (dr == DialogResult.No)
                    {
                        Process.GetCurrentProcess().Kill(); // program ends here
                        return; // this is just for code clarity
                    }

                    if (current_model == Model.FLEX5000)
                    {
                        dr = MessageBox.Show(new Form { TopMost = true }, "Is the radio in use a FLEX-5000?",
                            "FLEX-5000?",
                            MessageBoxButtons.YesNo,
                            MessageBoxIcon.Question);

                        if (dr == DialogResult.No)
                        {
                            dr = MessageBox.Show(new Form { TopMost = true }, "Is the radio in use a FLEX-3000?",
                                "FLEX-3000?",
                            MessageBoxButtons.YesNo,
                            MessageBoxIcon.Question);

                            if (dr == DialogResult.No)
                            {
                                MessageBox.Show(new Form { TopMost = true }, "The radio was not recognized.  Please try again.",
                                    "Radio Model Confusion",
                                    MessageBoxButtons.OK,
                                    MessageBoxIcon.Error);

                                Process.GetCurrentProcess().Kill(); // program ends here
                                return; // this is just for code clarity
                            }

                            current_model = Model.FLEX3000;
                        }
                    }

                    LoadFWCFirmware(VerToString(GetMinVersion(current_model)));

                    MessageBox.Show(new Form { TopMost = true }, "Update complete.  The program will now close.\n" +
                        "Please restart PowerSDR to continue.",
                        "Restart Required",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Information);

                    Process.GetCurrentProcess().Kill();
                }
            } // radiosavailable == 0

            Flex1500.Init();
            RadiosAvailable.Scan1500();



            int list_det_num = 0;
            int list_undet_num = 0; // ignore demo
            int list_det_present = 0;

            foreach (Radio r in RadiosAvailable.RadioList)
            {
                switch (r.Model)
                {
                    case Model.FLEX5000:
                    case Model.FLEX3000:
                    case Model.FLEX1500:
                        list_det_num++;
                        if (r.Present) list_det_present++;
                        break;
                    case Model.SDR1000:
                    case Model.SOFTROCK40:
                        list_undet_num++; break;
                }
            }

            if ((list_det_num == 1 && list_undet_num == 0) || (production && list_det_present == 1)) // skip form
            {
                foreach (Radio r in RadiosAvailable.RadioList)
                {
                    bool found = false;
                    switch (r.Model)
                    {
                        case Model.FLEX5000:
                        case Model.FLEX3000:
                            if (r.Present)
                            {
                                Pal.SelectDevice((uint)r.AccessObj);
                                found = true;
                            }
                            break;
                        case Model.FLEX1500:
                            if (r.Present)
                            {
                                Flex1500.SetActiveRadio((IntPtr)r.AccessObj);
                                found = true;
                            }
                            break;
                    }

                    if (found) // if a Flex radio found
                    {
                        radio_to_use = r;
                        //  DBFileName = app_data_path + r.GetDBFilename();  // ke9ns original this line of code

                        DBFileName = app_data_path + r.GetDBFilename1();  // ke9ns mod  this tells PowerSDR to look for a databaseRevQ_F5K_1610-2780.xml file

                        DBFileName1 = app_data_path + r.GetDBFilename(); // ke9ns add  this is the old original name database_F5K_1610-2780.xml file that we copy use to copy over to the RevQ when needed
                                                                         //            we do this just in case you need your original database for running an older copy of PowerSDR


                        break;
                    }

                } // foreach(radio)

                // add any new radios found to the master list
                foreach (Radio r in RadiosAvailable.RadioList)
                    Master.AddRadio(r);

                Master.Commit();

            } //  if ((list_det_num == 1 && list_undet_num == 0) || (production && list_det_present == 1)) // skip form

            // use one database for each model in production (not each serial)
            /*if (db_file_name != "" && production && radio_to_use.Model != Model.DEMO) 
            {
                int index = db_file_name.LastIndexOf("_");
                DBFileName = db_file_name.Substring(0, index) + ".xml";
            }*/

            if (radio_to_use == null)
            {
                RadioChoice choiceForm = new RadioChoice(this);
                choiceForm.ShowDialog();
            }

            foreach (string s in args)
            {
                if (s.StartsWith("-dbfilename:"))
                {
                    string path = s.Trim().Substring(s.Trim().IndexOf(":") + 1);

                    if (File.Exists(path))
                    {
                        DBFileName = path;
                    }
                    else
                    {
                        DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "-dbfilename: command line option found, but the file specified was not found.\n" +
                            "Would you like to create this file?  If not, the default database will be used.\n\n" +
                            "(" + s + ")",
                            "Command Line Option: Create File?",
                            MessageBoxButtons.YesNo,
                            MessageBoxIcon.Question);

                        if (dr == DialogResult.Yes)
                            DBFileName = path;
                    }
                }
            }

#if (DEBUG)
            AppDataPath += "Debug\\";
#endif
            if (!Directory.Exists(app_data_path))
            {
                Directory.CreateDirectory(app_data_path); //%userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\wisdom
            }

            if (db_file_name == "")
            {
                DBFileName = AppDataPath + "database.xml";
            }

            if (File.Exists(db_file_name))
            {
                if (Keyboard.IsKeyDown(Keys.LShiftKey) || Keyboard.IsKeyDown(Keys.RShiftKey))
                {
                    Thread.Sleep(500); // ensure this is intentional
                    if (Keyboard.IsKeyDown(Keys.LShiftKey) || Keyboard.IsKeyDown(Keys.RShiftKey))
                    {
                        DialogResult dr = MessageBox.Show(
                            "The Factory Defaults function has been tiggered.  Would you like to Reset to Factory Defaults?\n\n" +
                            "If so, a copy of the current database will be placed on the desktop with " +
                            "a date and time stamp in the file name before creating a brand new " +
                            "database for active use.",
                            "Factory Defaults?",
                            MessageBoxButtons.YesNo, MessageBoxIcon.Warning);

                        if (dr == DialogResult.Yes)
                        {
                            string desktop = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
                            string datetime = DateTime.Now.ToShortDateString().Replace("/", "-") + "_" +
                                DateTime.Now.ToShortTimeString().Replace(":", ".");

                            string file = db_file_name.Substring(db_file_name.LastIndexOf("\\") + 1);
                            file = file.Substring(0, file.Length - 4);

                            File.Copy(db_file_name, desktop + "\\PowerSDR_" + file + "_" + datetime + ".xml");

                            File.Delete(db_file_name);
                            Thread.Sleep(500);
                        }
                    }
                }
            } // file exists

            //===========================================================================================
            //===========================================================================================
            //===========================================================================================
            //===========================================================================================
            // SPLASH SCREEN STARTUP

            CmdLineArgs = args;

            Splash.ShowSplashScreen();							// Start splash screen

            Splash.SetStatus("Initializing Components");        // Set progress point

            InitializeComponent();                              // Windows Forms Generated Code

            //  SetProcessShutdownParameters(0x3FF, 0x00000001);  // ke9ns add: part of wndProc to allow shutdown
            //   ShutdownBlockReasonDestroy(this.Handle);

            // for resizing
            GrabConsoleSizeBasis();
            MinimumSize = this.Size;

            Splash.SetStatus("Initializing Database");			// Set progress point
            DB_Exists = DB.Init(radio_to_use.Model);		    // Initialize the database and pass the current radio model

            InitCTCSS();
            Splash.SetStatus("Initializing Hardware");			// Set progress point

            // check model in Options table
            ArrayList list = DB.GetVars("Options");				// Get the saved list of controls
            list.Sort();


            Splash.SetStatus("Enumerating Radio Hardware");     // Set progress point

            if (radio_to_use != null)
            {
                switch (radio_to_use.Model)
                {
                    case Model.FLEX5000:
                        current_model = Model.FLEX5000;
                        fwc_init = true;
                        hid_init = false;
                        FWC.SetPalCallback();
                        FWCMidi.Open();

                        if (list.Count == 0)
                        {
                            list.Add("radGenModelFLEX5000/True");
                            DB.SaveVars("Options", ref list);
                        }
                        break;
                    case Model.FLEX3000:
                        current_model = Model.FLEX3000;
                        fwc_init = true;
                        hid_init = false;
                        FWC.SetPalCallback();
                        FWCMidi.Open();

                        if (list.Count == 0)
                        {
                            list.Add("radGenModelFLEX5000/True");
                            DB.SaveVars("Options", ref list);
                        }
                        break;
                    case Model.FLEX1500:
                        current_model = Model.FLEX1500;
                        fwc_init = false;
                        hid_init = true;
                        if (list.Count == 0)
                        {
                            list.Add("radGenModelFLEX1500/True");
                            DB.SaveVars("Options", ref list);
                        }
                        break;
                    case Model.SDR1000:
                        current_model = Model.SDR1000;
                        fwc_init = false;
                        hid_init = false;
                        if (list.Count == 0)
                        {
                            list.Add("radGenModelSDR1000/True");
                            DB.SaveVars("Options", ref list);
                        }
                        run_setup_wizard = true;
                        break;
                    case Model.SOFTROCK40:
                        current_model = Model.SOFTROCK40;
                        fwc_init = false;
                        hid_init = false;
                        if (list.Count == 0)
                        {
                            list.Add("radGenModelSoftRock40/True");
                            DB.SaveVars("Options", ref list);
                        }
                        break;

                    default:
                        current_model = Model.DEMO;
                        fwc_init = false;
                        hid_init = false;
                        if (list.Count == 0)
                        {
                            list.Add("radGenModelDemoNone/True");
                            DB.SaveVars("Options", ref list);
                        }
                        break;
                }
            }

            if (fwc_init)
            {
                FWCEEPROM.Init();
                current_region = FWCEEPROM.Region;


                if (!db_exists) // modify bandtext and bandstack for non-US regions
                {
                    if (current_region != FRSRegion.US) // for Flex-3000 and 5000
                    {
                        Splash.SetStatus("Harmonizing BandText");
                        DB.UpdateRegion(current_region);
                    }
                }

                if (FWCEEPROM.NeedDump())
                {
                    Splash.HideForm();

                    FWCEEPROM.StartDump(); // fwc_eeprom.cs

                    Splash.UnHideForm();
                }

                switch (FWCEEPROM.Model)
                {
                    case 0:
                    case 1:
                    case 2:
                        current_model = Model.FLEX5000;
                        break;
                    case 3:
                        current_model = Model.FLEX3000;
                        break;
                }

                InitRadio();
            }
            if (hid_init)
            {
                HIDEEPROM.Init();
                current_region = HIDEEPROM.Region;

                if (!db_exists) // modify bandtext and bandstack for non-US regions
                {
                    if (current_region != FRSRegion.US) // for Flex-1500
                    {
                        Splash.SetStatus("Harmonizing BandText");
                        DB.UpdateRegion(current_region);
                    }
                }

                if (HIDEEPROM.NeedDump()) HIDEEPROM.StartDump();

                current_model = Model.FLEX1500;

                InitFLEX1500();
            }

            // ke9ns add
            if ((hid_init == false) && (fwc_init == false)) // ke9ns SDR1000 or softrock
            {
                if (File.Exists("TURF.txt")) // where powersdr.exe resides
                {
                    StreamReader sr = File.OpenText("TURF.txt");
                    string data = sr.ReadLine();
                    int x = Int32.Parse(data);

                    current_region = (FRSRegion)x;
                    sr.Close();
                }

            }

            //====================================================================================
            // ke9ns  this is where you determine if you have RX2  .210 and .212
            //====================================================================================

            if (fwc_init && current_model == Model.FLEX5000 && FWCEEPROM.RX2OK)  // original
            {
                chkRX2.Visible = true;
                lblAntRX2.Visible = true;
                lblAntRX2a.Visible = true;
                lblAntTX2.Visible = true; // .212
                lblAntTX2a.Visible = true;

                //  radBandVHF0RX2.Enabled = true; //.212
                //  radBandVHF1RX2.Enabled = true;
               // vhf_text2[index].Enabled = b;

                //   panelRX2Divider.Visible = true;

                //  RX2BandButton = true;
                //  comboRX2Band_SelectedIndexChanged(this, EventArgs.Empty); //.210

                this.MinimumSize = new Size(this.MinimumSize.Width, this.MinimumSize.Height - (panelRX2Filter.Height + 0));
               // panelAntenna.Size = new Size(115, 78); // ke9ns add .212 enlarge ant panel if 2nd rx
                panelAntenna.Size = new Size(115, 58); // ke9ns add .212 enlarge ant panel if 2nd rx(assume SO2R in Ant panel is off at start)

            }
            else // this is for 1500 and 3000 and 5000 with only RX1
            {
                panelAntenna.Size = new Size(115, 44); // ke9ns add .212 shrink ant panel if not 2nd rx

                textBox1.Size = new System.Drawing.Size(161, 200); //.228 was 151 ke9ns add .209 no need to have VFOB bandstack if no 2nd receiver RX2
                textBox2.Size = new System.Drawing.Size(1, 1);

                console_basis_size.Height -= (panelRX2Filter.Height + 8); // panelRX2Filter

                grpRX2Meter.Visible = false;

                panelRX2Mode.Visible = false;
                panelRX2Display.Visible = false;

                panelRX2DSP.Visible = false;

                panelRX2Mixer.Visible = false;

                lblRX2Band.Visible = false;

                chkRX2Preamp.Visible = false;

                ptbRX2RF.Visible = false;

                ptbRX2Squelch.Visible = false;

                comboRX2Band.Visible = false;

                panelBandHFRX2.Visible = false;
                panelBandVHFRX2.Visible = false;
                panelBandGNRX2.Visible = false;


                lblRX2RF.Visible = false;

                this.MinimumSize = new Size(this.MinimumSize.Width, this.MinimumSize.Height - (panelRX2Filter.Height + 8));

                if (chkRX2.Checked) chkRX2.Checked = false;

                this.Height -= (panelRX2Filter.Height + 8);
                panelRX2Filter.Visible = false;
                chkRX2Squelch.Visible = false;
            }

            Splash.SetStatus("Initializing Radio");				// Set progress point
            dsp = new DSP();								    // Initialize the Radio processor

            Splash.SetStatus("Initializing PortAudio");			// Set progress point
            PA19.PA_Initialize();								// Initialize the audio interface
            if (fwc_init) Thread.Sleep(600);

            Splash.SetStatus("Loading Main Form");				// Set progress point
            Splash.SplashForm.Owner = this;						// So that main form will show/focus when splash disappears
            break_in_timer = new HiPerfTimer();

#if (NO_DJ)
            //mod DH1TW
            DJConsoleObj = new DJConsole(this);

            //endmod
#endif



            InitConsole();										// Initialize all forms and main variables            

            Splash.SetStatus("Finished");                       // Set progress point
                                                                // Activates double buffering
                                                                //SetStyle(ControlStyles.DoubleBuffer, true);

           


            //===================================================================================

            this.SetStyle(ControlStyles.UserPaint | ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer, true);
            this.UpdateStyles();

            Splash.CloseForm();									// End splash screen

            // create a Windows Mutex for PowerSDR.  Do not create a second Mutex if one already exists
            // ke9ns: Mutex prevents 2 or more threads from simultaneously accessing a resource
            try
            {
                psdr2_mutex = Mutex.OpenExisting(psdr2_mutex_name);
            }
            catch (WaitHandleCannotBeOpenedException)
            {
                psdr2_mutex = new Mutex(true, psdr2_mutex_name, out psdr2_mutex_exists);
            }




            // ke9ns: Extended capabilities Flex radio check

            if (fwc_init && (current_model == Model.FLEX3000 || current_model == Model.FLEX5000))
            {
                extended = FWC.GetStatus();
                //  Debug.WriteLine("EXTENDED " + FWC.GetStatus());

            }
            else if (hid_init && current_model == Model.FLEX1500) extended = USBHID.GetStatus();
            else if (File.Exists("extended.edf"))						// Check for extended capabilities file (where PowerSDR.exe file resides
            {

                ArrayList a = DB.GetVars("State");
                a.Sort();
                ArrayList names = new ArrayList();
                ArrayList vals = new ArrayList();

                foreach (string s in a)
                {
                    string[] str = s.Split('/');
                    if (str.Length > 2)
                    {
                        for (int j = 2; j < str.Length; j++)
                            str[1] += "/" + str[j];
                    }
                    names.Add(str[0]);
                    vals.Add(str[1]);
                }

                int i = names.BinarySearch("extended");

                if (i < 0) // If not found, prompt for logon info
                {
                    LogOn LogOnForm = new LogOn(this);
                    LogOnForm.ShowDialog();
                }
                else  // If found, check for existing logon info
                {
                    string text = (string)vals[i];

                    StreamReader sr = File.OpenText("extended.edf");
                    string data = sr.ReadLine();
                    sr.Close();

                    if (text == data) extended = true;
                    else	// Logon information found, but doesn't match
                    {
                        MessageBox.Show(new Form { TopMost = true }, "Error reading logon information.", "Logon Error",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                        LogOn LogOnForm = new LogOn(this);
                        LogOnForm.ShowDialog();
                    }
                }
            } // check for extended file
            else if (File.Exists("extended1.edf"))
            {
                extended = true;
            }


            Rectangle screenRectangle = RectangleToScreen(this.ClientRectangle);

            int titleHeight = screenRectangle.Top - this.Top;

            //  int BorderWidth = (this.Width – this.ClientSize.Width) / 2;
            //  int TitlebarHeight = this.Height – this.ClientSize.Height – 2 * BorderWidth;

            Debug.WriteLine("titlebar " + titleHeight);

            // update titlebar
            this.Text = TitleBar.GetString();

            setupForm.UpdateCustomTitle();

            if (radio_to_use != null)
            {
                string s = "";

                switch (radio_to_use.Model)
                {
                    case Model.FLEX5000: s = "FLEX-5000"; break;
                    case Model.FLEX3000: s = "FLEX-3000"; break;
                    case Model.FLEX1500: s = "FLEX-1500"; break;
                    case Model.SDR1000: s = "SDR-1000"; break;
                    case Model.SOFTROCK40: s = "SoftRock"; break;
                    case Model.DEMO: s = "Demo"; break;
                }

                if (radio_to_use.Nickname == null || radio_to_use.Nickname == "")
                {
                    if ((radio_to_use.SerialNumber != null) && (radio_to_use.SerialNumber != ""))
                        s += ": " + radio_to_use.SerialNumber;
                }
                else
                {
                    if ((radio_to_use.Nickname != null) && (radio_to_use.Nickname != ""))
                        s += ": " + radio_to_use.Nickname;
                }

                this.Text += "   " + s + " : " + current_region + " ";  // ke9ns mod:  added FRSRegion to top line of console window
                if (extended == true) this.Text += "Extended";

                labelPowerSDR.Text = this.Text; // ke9ns add

            }



            if (show_alpha_warning && this.Text.ToLower().Contains("alpha") && !production)
            {
                AlphaWarnForm form = new AlphaWarnForm(this);
                form.ShowDialog();
            }

            if (show_beta_warning && this.Text.ToLower().Contains("beta") && !production)
            {
                BetaWarnForm form = new BetaWarnForm(this);
                form.ShowDialog();
            }

            if (show_mobile_warning && !production)
            {
                MobileWarnForm form = new MobileWarnForm(this);
                form.ShowDialog();
            }

            reportBugToolStripMenuItem.Visible = true;

            if (run_setup_wizard)
            {
                SetupWizard w = new SetupWizard(this, 0);
                w.ShowDialog();
                if (fwc_init && (current_model == Model.FLEX5000 || current_model == Model.FLEX3000))
                {
                    setupForm.ResetFLEX5000();
                    CheckCalData();
                    for (int i = 0; i < 8; i++)
                        flex5000DebugForm.SetPAPot(i, (byte)pa_bias_table[0][i]);
                    if (!FWCEEPROM.TRXChecksumPresent)
                    {
                        WriteTRXChecksums();
                        VerifyTRXChecksums();
                    }
                    RX1Band = RX2Band = TXBand = rx1_band;

                    switch (current_model)
                    {
                        case Model.FLEX5000:

                            Debug.WriteLine("rx1_band " + rx1_band);

                            fwcAntForm.SetBand(rx1_band);


                            fwcAntForm.CurrentAntMode = current_ant_mode;
                            fwcAntForm.RX1Ant = rx1_ant;
                            fwcAntForm.RX1Loop = rx1_loop;
                            fwcAntForm.RX2Ant = rx2_ant;
                            fwcAntForm.TXAnt = tx_ant;
                            fwcAntForm.TXAnt2 = tx_ant2; // ke9ns add .205
                            CheckRX2CalData();
                            break;
                    }
                }
                else if (hid_init && current_model == Model.FLEX1500)
                {
                    Check1500CalData();
                    Verify1500Checksums();

                    hidAntForm.SetBand(rx1_band);
                    hidAntForm.RXAnt = rx_ant_1500;
                    hidAntForm.TXAnt = tx_ant_1500;
                }
            } //  if (run_setup_wizard)

            if (rx1_meter_cal_offset == 0.0f)
            {
                switch (current_soundcard)
                {
                    case SoundCard.SANTA_CRUZ:
                        rx1_meter_cal_offset = -26.39952f;
                        break;
                    case SoundCard.AUDIGY_2_ZS:
                        rx1_meter_cal_offset = 1.024933f;
                        break;
                    case SoundCard.MP3_PLUS:
                        rx1_meter_cal_offset = -33.40224f;
                        break;
                    case SoundCard.EXTIGY:
                        rx1_meter_cal_offset = -29.30501f;
                        break;
                    case SoundCard.DELTA_44:
                        rx1_meter_cal_offset = -25.13887f;
                        break;
                    case SoundCard.FIREBOX:
                        rx1_meter_cal_offset = -20.94611f;
                        break;
                    case SoundCard.EDIROL_FA_66:
                        rx1_meter_cal_offset = -46.82864f;
                        break;
                    case SoundCard.UNSUPPORTED_CARD:
                        rx1_meter_cal_offset = -22.43533f;
                        break;
                }
            }

            if (rx1_display_cal_offset == 0.0f)
            {
                switch (current_soundcard)
                {
                    case SoundCard.SANTA_CRUZ:
                        RX1DisplayCalOffset = -56.56675f;
                        break;
                    case SoundCard.AUDIGY_2_ZS:
                        RX1DisplayCalOffset = -29.20928f;
                        break;
                    case SoundCard.MP3_PLUS:
                        RX1DisplayCalOffset = -62.84578f;
                        break;
                    case SoundCard.EXTIGY:
                        RX1DisplayCalOffset = -62.099f;
                        break;
                    case SoundCard.DELTA_44:
                        RX1DisplayCalOffset = -57.467f;
                        break;
                    case SoundCard.FIREBOX:
                        RX1DisplayCalOffset = -54.019f;
                        break;
                    case SoundCard.EDIROL_FA_66:
                        RX1DisplayCalOffset = -80.429f;
                        break;
                    case SoundCard.UNSUPPORTED_CARD:
                        RX1DisplayCalOffset = -48.62103f;
                        break;
                }
            }

            /*if(notify_on_beta || notify_on_release)
            {
                Thread t = new Thread(new ThreadStart(CheckForUpdates));
                t.IsBackground = true;
                t.Priority = ThreadPriority.Lowest;
                t.Name = "Update Check Thread";
                t.Start();
            }*/

            foreach (string s in CmdLineArgs)
            {
                if (s == "-autostart")
                    chkPower.Checked = true;
                else if (s.StartsWith("-datapath:"))
                {
                    string path = s.Substring(s.IndexOf(":") + 1);
                    if (Directory.Exists(path)) AppDataPath = path;
                }
            }

            if ((current_model == Model.FLEX5000 || current_model == Model.FLEX3000) && !fwc_init)
                MessageBox.Show(new Form { TopMost = true }, "Error opening radio driver.", "Driver Error", MessageBoxButtons.OK, MessageBoxIcon.Error);

            if (current_model == Model.FLEX1500 && !hid_init)
                MessageBox.Show(new Form { TopMost = true }, "Error opening radio driver.", "Driver Error", MessageBoxButtons.OK, MessageBoxIcon.Error);

            if (!fwc_init || !FWCEEPROM.RX2OK)
            {
                chkRX2.Checked = false;
                chkSplitDisplay.Checked = false;
            }
            /*
             Common.RestoreForm(XVTRForm, "XVTR", false);
             if (FWCEEPROM.VUOK)
             {
                 FWC.SetEN2M(true); //XVINT
                 XVTRForm.udUCBAddr0.Value = 0;
                 XVTRForm.txtButtonText0.Text = "2m";
                 XVTRForm.udLOOffset0.Value = 125;
                 XVTRForm.udLOError0.Value = 0;
                 XVTRForm.udFreqBegin0.Value = 144;
                 XVTRForm.udFreqEnd0.Value = 148;
                 //XVTRForm.udRXGain0.Value = 32;
                 XVTRForm.chkRXOnly0.Checked = false;
                 XVTRForm.udPower0.Value = 100;
                 XVTRForm.chkXVTRRF0.Checked = false;

                 XVTRForm.udUCBAddr1.Value = 1;
                 XVTRForm.txtButtonText1.Text = "70cm";
                 XVTRForm.udLOOffset1.Value = 400;
                 XVTRForm.udLOError1.Value = 0;
                 XVTRForm.udFreqBegin1.Value = 430;
                 XVTRForm.udFreqEnd1.Value = 450;
                 //XVTRForm.udRXGain1.Value = 28;
                 XVTRForm.chkRXOnly1.Checked = false;
                 XVTRForm.udPower1.Value = 100;
                 XVTRForm.chkXVTRRF1.Checked = false;

                 XVTRForm.chkEnable0.Checked = true;
                 XVTRForm.chkEnable1.Checked = true;
                 XVTRForm.chkVHFIFGain.Enabled = true;
                 XVTRForm.chkUHFIFGain.Enabled = true;
                 XVTRForm.chkVHFPAEnable.Enabled = true;
                 XVTRForm.chkUHFPAEnable.Enabled = true;
                 XVTRForm.label_VUModulePresent.Visible = true;
                 XVTRForm.label_VUModuleNotPresent.Visible = false;

             }
             else
             {
                 XVTRForm.chkEnable0.Checked = false;
                 XVTRForm.chkEnable1.Checked = false;
                 XVTRForm.chkVHFIFGain.Enabled = false;
                 XVTRForm.chkUHFIFGain.Enabled = false;
                 XVTRForm.chkVHFPAEnable.Enabled = false;
                 XVTRForm.chkUHFPAEnable.Enabled = false;
                 XVTRForm.chkEnable0.Checked = false;
                 XVTRForm.chkEnable1.Checked = false;
                 XVTRForm.label_VUModulePresent.Visible = false;
                 XVTRForm.label_VUModuleNotPresent.Visible = true;
             }
              */

#if (DEBUG)
            //button1.Visible = true;
            //buttonTS1.Visible = true;
#endif
            SyncDSP();

            initializing = false;

#if (NO_DJ)
            //mod DH1TW
            //    this.Text = "PowerSDR-UI 0.997 based on FlexRadio Systems™ PowerSDR™ 2.7.2";
            //endmod

#endif
            txtVFOAFreq_LostFocus(this, EventArgs.Empty);
            txtVFOBFreq_LostFocus(this, EventArgs.Empty);

            if (setupForm != null)
            {
                if (setupForm.chkBoxAutoStart.Checked == true)
                {
                    chkPower.Checked = true;
                }
            }

            if (chkBoxBS.Checked == true) // ke9ns add: .153 turn on at startup if on when shut down last time.
            {
                BandStackMove(); // toggle on
            }


            // maximize3

          
            if (CONSOLEM == true)
            {
              //  Debug.WriteLine("MAXIMUM2" + CONSOLEL);
                this.Top = CONSOLET;
                this.Left = CONSOLEL;
                this.Width = CONSOLEW;
                this.Height = CONSOLEH;

              //  this.WindowState = FormWindowState.Normal;
               
               
             //   this.WindowState = FormWindowState.Maximized;


              //  Debug.WriteLine("MAXIMUM2");
            }
           
            // ke9ns .194  SS1 = panafall8020 = .833333  , SS2 = panafall = .5

            mouseholdY = (int)setupForm.udSS1H.Value; // ke9ns .197
            mouseholdYY = (int)setupForm.udSS2H.Value; // ke9ns .197


            if (!FWCEEPROM.RX2OK)
            {
                panelBandHFRX2.Enabled = false;
                panelBandGNRX2.Enabled = false;
                panelBandVHFRX2.Enabled = false;

                panelBandHFRX2.Visible = false;
                panelBandGNRX2.Visible = false;
                panelBandVHFRX2.Visible = false;
            }

            if (fwc_init && current_model == Model.FLEX5000 && FWCEEPROM.RX2OK)  // original
            {

                RX2BandButton = true;
                comboRX2Band_SelectedIndexChanged(this, EventArgs.Empty); //.210
            }

            if (radFMDeviation2kHz.Checked) //.236
            {
                lastdeviation = 2500;
                FMSEQ = 0;
                FMDeviation_Hz = 2500;
                radRX2ModeFMN.Text = "2FM";
                radModeFMN.Text = "2FM";
                dsp.GetDSPTX(0).TXFMDataMode = false;
                FMData = false;
            }
            else if (radFMDeviation5kHz.Checked)
            {
                lastdeviation = 5000;
                FMSEQ = 1;
                FMDeviation_Hz = 5000;
                radRX2ModeFMN.Text = "5FM";
                radModeFMN.Text = "5FM";
                dsp.GetDSPTX(0).TXFMDataMode = false;
                FMData = false;
            }
            else
            {
                lastdeviation = FMDataDeviation;
                FMSEQ = 2;
                radRX2ModeFMN.Text = "WFM";
                radModeFMN.Text = "WFM";
                FMDeviation_Hz = FMDataDeviation;
                FMData = true;
                FMDeviation10khz(); //.236
                dsp.GetDSPTX(0).TXFMDataMode = true;
            }

            dsp.GetDSPTX(0).TXFMDeviation = lastdeviation;

            Debug.WriteLine("===END=== Console here");

        } // public console


        //    protected override void OnClosed(EventArgs e)
        //    {
        //  base.OnClosed(e);

        //  Console.systemShutDown = true;

        //   }

        // protected override void OnClosing(CancelEventArgs e)
        //  {
        //  base.OnClosing(e);
        //   Console.systemShutDown = true;
        //  }



        //=============================================================================
        // ke9ns console_closing(), then formclosing, then Dispose(), then ExitConsole(), then back to Displose() to finish

        public bool reset_db = false;
        protected override void Dispose(bool disposing)
        {

            Debug.WriteLine("((((((((ENTER DISPOSE ROUTINE))))))))))))))))");

            StreamWriter writer = new StreamWriter(app_data_path + "shutdown2.log"); //   // look for %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\
            writer.AutoFlush = true;

            writer.WriteLine("Dispose: 1-5");

            writer.WriteLine("1) USB exit");

            USB.Exit(); // for 1500
            Thread.Sleep(300);

            writer.WriteLine("1) Done");

            writer.WriteLine("2) Disposing of components " + disposing);

          

                //   if (disposing)
                //  {
            if (components != null)
                {
                    components.Dispose();
                    writer.WriteLine("2a) Disposing of components " + disposing);

                }
            //  }


            Debug.WriteLine("disposed of components here");

            base.Dispose(disposing);
            

            writer.WriteLine("2) Done");


#if (NO_DJ)
            //mod DH1TW

            writer.WriteLine("3) Write DJConsole updates");

            try
            {
                if (DJConsoleObj != null) DJConsoleObj.Close(); //DJConsoleObj.Close();

            }
            catch (Exception e)
            {
                Debug.WriteLine("DJ exit fail " + e);
            }

            writer.WriteLine("3) Done");


            Thread.Sleep(200);
#endif

            Debug.WriteLine("((((((((Go to EXITCONSOLE here))))))))))))))))");

            writer.WriteLine("4) ExitConsole here... View PowerDown_3of3.log file for details");

            ExitConsole();   // ke9ns shutdown3.log    (PAL exit, TXProfile data, DB exit, DTTSP exit, and .Dispose of forms)

            writer.WriteLine("4) Done");
            Debug.WriteLine("((((((((return from EXITCONSOLE here))))))))))))))))");


            //-------------------------------------------------------------------------
            // ke9ns for a setup->factory defaults (reset the database)
            if (reset_db)
            {

                writer.WriteLine("5) reseting to factory defaults");

                string desktop = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
                string datetime = DateTime.Now.ToShortDateString().Replace("/", "-") + "_" + DateTime.Now.ToShortTimeString().Replace(":", ".");

                string file = db_file_name.Substring(db_file_name.LastIndexOf("\\") + 1);
                file = file.Substring(0, file.Length - 4);

                File.Copy(db_file_name, desktop + "\\PowerSDR_" + file + "_" + datetime + ".xml");
                File.Delete(db_file_name);

                writer.WriteLine("5) Done EXIT HERE");

            }
            else
            {
                writer.WriteLine("5) No Factory Defaults. done EXIT HERE");
            }

        

            Debug.WriteLine("((((((((TERMINATE PROGRM .......EXIT HERE.....))))))))))))))))");

            writer.Close(); // 2

            //    AutoClosingMessageBox.Show("Database Updated\nPowerSDR now Closed.", "PowerSDR Closed.", 2000);


        } // dispose


        #endregion

 
        #region Main
        // ======================================================
        // Main (this is called first, before Console()
        // ======================================================

        [STAThread]
        static void Main(string[] args)
        {

            Debug.WriteLine("===START=== Main here");

            string app_data_path = "";
            string app_data_path1 = ""; // ke9ns add for original 2.7.2 folder

            foreach (string s in args)
            {
                if (s.StartsWith("-datapath:"))
                {
                    string path = s.Trim().Substring(s.Trim().IndexOf(":") + 1);

                    if (path.EndsWith("\"")) path = path.Substring(0, path.Length - 1);

                    if (!path.EndsWith("\\")) path += "\\";
#if (DEBUG)
                    path += "Debug\\";
                  
#endif
                    if (Directory.Exists(path))
                        app_data_path = path;
                    else
                    {
                        DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "-datapath: command line option found, but the folder specified was not found.\n" +
                            "Would you like to create this folder?  If not, the default folder will be used.\n\n" +
                            "(" + s + ")",
                            "Command Line Option: Create Folder?",
                            MessageBoxButtons.YesNo,
                            MessageBoxIcon.Question);

                        if (dr == DialogResult.Yes)
                        {
                            Directory.CreateDirectory(path);
                            app_data_path = path;
                        }
                    }
                }
            }




            //---------------------------------------------------------------------------------
            // ke9ns info:    Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)  ==   %userprofile%\AppData\Roaming


            if (app_data_path == "")
            {
                Assembly assembly = Assembly.GetExecutingAssembly();
                FileVersionInfo fvi = FileVersionInfo.GetVersionInfo(assembly.Location);
                string version = fvi.FileVersion.Substring(0, fvi.FileVersion.LastIndexOf("."));
                //   app_data_path = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)  + "\\FlexRadio Systems\\PowerSDR v" + version + "\\"; // ke9ns 2.8.0
                app_data_path = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\PowerSDR v2.8.0\\"; // ke9ns add to copy over the old 2.7.2 folder into 2.8.0
                app_data_path1 = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\PowerSDR v2.7.2\\"; // ke9ns add to copy over the old 2.7.2 folder into 2.8.0

#if (DEBUG)
                app_data_path += "Debug\\"; // ke9ns: this is what it will be:  %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\Debug\     C:\Users\RADIO\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\Debug\

#endif
            }

            try
            {
                if (!File.Exists(app_data_path + "wisdom"))  // look for %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\wisdom
                {
                    // Need to create the directory in %appdata% before we go run wisdom


                    if (!Directory.Exists(app_data_path))
                    {
                        Directory.CreateDirectory(app_data_path);   // create the new folder for the database and quickaudio:  %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\

                    }

                    if (!Directory.Exists(app_data_path+ "\\QuickAudio")) // ke9ns add .190
                    {
                        Directory.CreateDirectory(app_data_path+"\\QuickAudio");   // create the new folder for the database and quickaudio:  %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\

                    }

                    /* 
                           ke9ns removed on 2/4/20 v2.7.2 causing issues with v2.8.0 database corruption

                                        if (Directory.Exists(app_data_path1)) // if 2.7.2 folder exists then copy is contents to new  2.8.0 folder
                                        {
                                            //  MessageBox.Show(new Form { TopMost = true }, "Found your 2.7.2 database and quickaudio files folder.\nFiles will be copied over so you dont lose anything.");

                                            DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "Found your 2.7.2 database and quickaudio files folder.\nFiles will be copied over so you dont lose anything.",
                                              "Option:Copy 2.7.2 database and files to 2.8.0 Folder?",
                                              MessageBoxButtons.YesNo,
                                              MessageBoxIcon.Question);

                                            if (dr == DialogResult.Yes)
                                            {

                                                foreach (string dirPath in Directory.GetDirectories(app_data_path1, "*", SearchOption.AllDirectories))
                                                    Directory.CreateDirectory(dirPath.Replace(app_data_path1, app_data_path));

                                                //Copy all the files & Replaces any files with the same name
                                                foreach (string newPath in Directory.GetFiles(app_data_path1, "*.*", SearchOption.AllDirectories))
                                                    File.Copy(newPath, newPath.Replace(app_data_path1, app_data_path), true);

                                            }
                                        }
                                        else
                                        {
                                            MessageBox.Show(new Form { TopMost = true }, "No previous 2.7.2 folder found\nA new database file will be created and additional files will be installed");

                                        }

                    */
                    // ke9ns memory does not need to be copied, its back up 1 folder level in the  %userprofile%\AppData\Roaming\FlexRadio Systems\ folder

                    //-------------------------------------------------------------------------------------------
                    // ke9ns add: copy voacap and ke9ns folders from program files to roaming folder (THIS IS REQUIRED)

                    string path = Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData) + "\\FlexRadio Systems\\PowerSDR";  // ke9ns this is the ProgramData folder
                                                                                                                                                 // Application.StartupPath  = \Program Files (x86)\FlexRadio Systems\PowerSDR v2.8.0

                    try
                    {
                        File.Copy(path + "\\ke9ns\\SWL.csv", app_data_path + "SWL.csv", true);
                    }
                    catch (Exception)
                    {

                    }
                   
                    try
                    {
                        File.Copy(path + "\\ke9ns\\SWL2.csv", app_data_path + "SWL2.csv", true);
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                        File.Copy(path + "\\ke9ns\\DXLOC.txt", app_data_path + "DXLOC.txt", true);
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                        File.Copy(path + "\\ke9ns\\test24.bmp", app_data_path + "test24.bmp", true);
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                        File.Copy(path + "\\ke9ns\\OP.bmp", app_data_path + "OP.bmp", true);
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                        File.Copy(path + "\\ke9ns\\arrl.bmp", app_data_path + "arrl.bmp", true);
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                        File.Copy(path + "\\ke9ns\\FCCDATA.dat", app_data_path + "FCCDATA.dat", true);
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                        File.Copy(path + "\\ke9ns\\PowerSDR TX Waterfall ID.pdf", app_data_path + "PowerSDR TX Waterfall ID.pdf", true);
                    }
                    catch (Exception)
                    {

                    }

                    try
                    {
                        File.Copy(path + "\\ke9ns\\PowerSDR ke9ns v2.8 features_white.pdf", app_data_path + "PowerSDR ke9ns v2.8 features_white.pdf", true);
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                        File.Copy(path + "\\ke9ns\\PowerSDR ke9ns keyboard shortcuts.pdf", app_data_path + "PowerSDR ke9ns keyboard shortcuts.pdf", true);
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                       
                        File.Copy(path + "\\ke9ns\\Quindar_tone_end.wav", app_data_path + "\\QuickAudio\\Quindar_tone_end.wav", true); // ke9ns add .190
                    }
                    catch (Exception)
                    {

                    }
                    try
                    {
                        File.Copy(path + "\\ke9ns\\Quindar_tone_start.wav", app_data_path + "\\QuickAudio\\Quindar_tone_start.wav", true);
                    }
                    catch (Exception)
                    {

                    }

                    foreach (string dirPath in Directory.GetDirectories(path + "\\itshfbc", "*", SearchOption.AllDirectories))
                        Directory.CreateDirectory(dirPath.Replace(path + "\\itshfbc", app_data_path + "\\itshfbc"));

                    foreach (string newPath in Directory.GetFiles(path + "\\itshfbc", "*.*", SearchOption.AllDirectories))
                        File.Copy(newPath, newPath.Replace(path + "\\itshfbc", app_data_path + "\\itshfbc"), true);


                    //-------------------------------------------------------------------------------------------------

                    Process p = Process.Start(Application.StartupPath + "\\fftw_wisdom.exe", "\"" + app_data_path);  //ke9ns  C:\Program Files (x86)\FlexRadio Systems\PowerSDR v2.8.0

                    // ke9ns creates wisdom file. used by sdr.c file

                    MessageBox.Show(new Form { TopMost = true }, "Running one time optimization.  Please wait patiently for " +
                        "this process to finish.\nTypically the optimization takes no more than 3-5 minutes.",
                        "Optimizing...",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Information);

                    p.WaitForExit();

                    /*    foreach (string dirPath in Directory.GetDirectories(SourcePath, "*",
                            SearchOption.AllDirectories))
                            Directory.CreateDirectory(dirPath.Replace(SourcePath, DestinationPath));

                        //Copy all the files & Replaces any files with the same name
                        foreach (string newPath in Directory.GetFiles(SourcePath, "*.*",
                            SearchOption.AllDirectories))
                            File.Copy(newPath, newPath.Replace(SourcePath, DestinationPath), true);
                    */

                }
                /*				else 
                                {
                                    string path = "wisdom";
                                    using (StreamReader sr = new StreamReader(path)) 
                                    {
                                        char [] block = new char[12];
                                        sr.ReadBlock(block,0,11);
                                        Debug.WriteLine("the block is "+block + "so let's check it");
                                        if (block.ToString() != "(fftw-3.2al")
                                        {
                                            sr.Close();
                                            File.Delete(Application.StartupPath+"\\wisdom");
                                            Process p = Process.Start(Application.StartupPath+"\\fftw_wisdom.exe");
                                            MessageBox.Show(new Form { TopMost = true }, "Running one time optimization.  Wisdom is from wrong version. Please wait patiently for "+
                                                "this process to finish.\nTypically the optimization takes no more than 3-5 minutes.",
                                                "Optimizing...",
                                                MessageBoxButtons.OK,
                                                MessageBoxIcon.Information);
                                            p.WaitForExit();
                                        }
                                    }

                                } */
                try
                {
                    if (!CheckForOpenProcesses()) // ke9ns check if another powersdr instance is running
                        return;
                }
                catch (Exception)
                {

                }
                Application.EnableVisualStyles();
                Application.DoEvents();

                //Application.Run(new Console(args));
                // wjt hacked

                Debug.WriteLine("===Start=== create Console() here "); // ke9ns: 

                theConsole = new Console(args);  // ke9ns: run Console here
                Application.Run(theConsole);
            }
            catch (Exception ex)
            {
                string msg = ex.Message + "\n\n" + ex.StackTrace.ToString();
                if (ex.InnerException != null) msg += "\n\n" + ex.InnerException.Message;
                MessageBox.Show(msg, "Fatal Error",
                    MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            Debug.WriteLine("===END=== MAIN here"); // ke9ns: never gets here
        } // main 

        #endregion


        #region Misc Routines
        // ======================================================
        // Misc Routines
        // ======================================================

        private void InitConsole()
        {


            commands = new CATCommands(this, parser); // ke9ns add

            flexControlBasicForm = new FlexControlBasicForm(this);
            flexControlAdvancedForm = new FlexControlAdvancedForm(this);

            //--------------------------------------------------------------
            SetCurrentFlexControlMode(null, current_flexcontrol_mode);
            FlexControlScan_ThreadFunction();// FlexControlScan();


#if (DEBUG)
            uCBToolStripMenuItem.Visible = true;
            //button1.Visible = true;
#endif

#if (NO_TNF)
            btnTNFAdd.Visible = false;
            this.Controls.Remove(btnTNFAdd);
            btnTNFAdd = null;

            chkTNF.Visible = false;
            this.Controls.Remove(chkTNF);
            chkTNF = null;
#endif

            // EHR add nav support
            try
            {
                TDxDevice = new TDxInput.DeviceClass();
                TDxSensor = TDxDevice.Sensor;
                TDxDevice.Connect();
                if (TDxDevice.IsConnected)
                {
                    this.timer_navigate.Interval = 100; // 100mseconds
                    this.timer_navigate.Enabled = true;
                }
            }
            catch (Exception)
            {
                //MessageBox.Show(new Form { TopMost = true }, "SpaceNavigator not installed.", "No Navigator",
                //MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            // EHR end

            Thread.Sleep(300);
            UpdateBandStackRegisters();

            Audio.console = this;
            //FWCMidi.console = this;
            FWC.console = this;
            Display.console = this;  //

            Http.console = this;                   // ke9ns add


            Setup.console = this;                 // ke9ns add  setup.cs to this console so setup can talk to console
            IDBOX.console = this;                 // ke9ns add IDBOX to this console
            TOTBOX.console = this;                 // ke9ns add TOTBOX to this console


            SpotControl.console = this;           // ke9ns add  spot.cs to this console so spot can talk to console

            ScanControl.console = this;           // ke9ns add  scan.cs to this console so scan can talk to console
            StackControl.console = this;          // ke9ns add  stack.cs to this console so stack can talk to console
            SwlControl.console = this;            // ke9ns add  swl.cs to this console so stack can talk to console

            helpbox.console = this;            // ke9ns add  helpbox.cs to this console so stack can talk to console
            helpbox1.console = this;            // ke9ns add  helpbox1.cs to this console so stack can talk to console

            if (hid_init) Flex1500.Console = this;



            //--------------------------------------------------------------------------------------------------------
            // ke9ns: preload OFF defaults 

            chkDSPNB2.Enabled = true;

            vfoa_hover_digit = -1;
            vfob_hover_digit = -1;

            rx1_ant_by_band = new FWCAnt[(int)Band.LAST];

            for (int i = 0; i < (int)Band.LAST; i++) rx1_ant_by_band[i] = FWCAnt.ANT1;

            rx2_ant_by_band = new FWCAnt[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++) rx2_ant_by_band[i] = FWCAnt.RX2IN;

            tx_ant_by_band = new FWCAnt[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++) tx_ant_by_band[i] = FWCAnt.ANT1;

            tx_ant_by2_band = new FWCAnt[(int)Band.LAST]; // ke9ns add .205
            for (int i = 0; i < (int)Band.LAST; i++) tx_ant_by2_band[i] = FWCAnt.ANT1; // ke9ns add .205

            rx1_loop_by_band = new bool[(int)Band.LAST];
            rx1_preamp_by_band = new PreampMode[(int)Band.LAST];
            rx_ant_1500_by_band = new HIDAnt[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++) rx_ant_1500_by_band[i] = HIDAnt.PA;
            tx_ant_1500_by_band = new HIDAnt[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++) tx_ant_1500_by_band[i] = HIDAnt.PA;

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                switch (current_model)
                {
                    case Model.FLEX1500:
                        switch ((Band)i)
                        {
                            case Band.B160M:
                            case Band.B80M:
                            case Band.B60M:
                            case Band.B40M:
                            case Band.B20M:
                                rx1_preamp_by_band[i] = (PreampMode)FLEX1500PreampMode.ZERO;
                                break;
                            case Band.B17M:
                            case Band.B15M:
                                rx1_preamp_by_band[i] = (PreampMode)FLEX1500PreampMode.PLUS_10;
                                break;
                            case Band.B12M:
                            case Band.B10M:
                                rx1_preamp_by_band[i] = (PreampMode)FLEX1500PreampMode.PLUS_20;
                                break;
                            case Band.B6M:
                                rx1_preamp_by_band[i] = (PreampMode)FLEX1500PreampMode.PLUS_30;
                                break;
                            default:
                                rx1_preamp_by_band[i] = (PreampMode)FLEX1500PreampMode.ZERO;
                                break;
                        }
                        break;
                    case Model.FLEX3000:
                        switch ((Band)i)
                        {
                            case Band.B6M:
                            case Band.B10M:
                                rx1_preamp_by_band[i] = PreampMode.HIGH;
                                break;
                            case Band.B12M:
                            case Band.B15M:
                                rx1_preamp_by_band[i] = PreampMode.MED;
                                break;
                            default:
                                rx1_preamp_by_band[i] = PreampMode.LOW;
                                break;
                        }
                        break;
                    case Model.FLEX5000:
                        switch ((Band)i)
                        {
                            case Band.B6M:
                            case Band.B10M:
                            case Band.B12M:
                            case Band.B15M:
                                rx1_preamp_by_band[i] = PreampMode.HIGH;
                                break;
                            default:
                                rx1_preamp_by_band[i] = PreampMode.OFF;
                                break;
                        }
                        break;
                    default:
                        rx1_preamp_by_band[i] = PreampMode.HIGH;
                        break;
                }
            }

            rx2_preamp_by_band = new PreampMode[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++) rx2_preamp_by_band[i] = PreampMode.HIGH;

            power_by_band = new int[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++) power_by_band[i] = 50;

            //=============================================
            // ke9ns add
            power_by_mode_by_band = new int[(int)Band.LAST, (int)DSPMode.LAST]; // set drive slider based on Mode and Band

            limit_by_mode_by_band = new int[(int)Band.LAST, (int)DSPMode.LAST]; // set TX max drive based on mode and band

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                for (int ii = 0; ii < (int)DSPMode.LAST; ii++)
                {
                    power_by_mode_by_band[i, ii] = 50;    // default driver slider to 50
                    limit_by_mode_by_band[i, ii] = 100; // default drive limit to 100
                }
            }



            fm_tx_offset_by_band_mhz = new double[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++) // setup default FM offsets
            {
                switch ((Band)i)
                {
                    case Band.B6M: fm_tx_offset_by_band_mhz[i] = 1; break; // 1MHz
                    case Band.B10M: fm_tx_offset_by_band_mhz[i] = 0.1; break; // 100kHz
                    case Band.VHF0: fm_tx_offset_by_band_mhz[i] = 0.6; break; // 600kHz
                    case Band.VHF1: fm_tx_offset_by_band_mhz[i] = 5; break; // 5MHz
                    default: fm_tx_offset_by_band_mhz[i] = 0.1; break; // 100kHz
                }
            }

            rx1_agct_by_band = new int[(int)Band.LAST];
            rx2_agct_by_band = new int[(int)Band.LAST];

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                switch ((Band)i)
                {
                    case Band.B160M:
                    case Band.B80M:
                    case Band.B60M:
                        rx1_agct_by_band[i] = 75;
                        rx2_agct_by_band[i] = 75;
                        break;
                    case Band.B40M:
                    case Band.B30M:
                        rx1_agct_by_band[i] = 80;
                        rx2_agct_by_band[i] = 80;
                        break;
                    case Band.B20M:
                    case Band.B17M:
                        rx1_agct_by_band[i] = 85;
                        rx2_agct_by_band[i] = 85;
                        break;
                    case Band.B10M:
                        rx1_agct_by_band[i] = 95;
                        rx2_agct_by_band[i] = 95;
                        break;
                    case Band.B6M:
                        switch (current_model)
                        {
                            case Model.FLEX3000:
                                rx1_agct_by_band[i] = 100;
                                break;
                            default:
                                rx1_agct_by_band[i] = 110;
                                break;
                        }
                        rx2_agct_by_band[i] = 110;
                        break;
                    default:
                        rx1_agct_by_band[i] = 90;
                        rx2_agct_by_band[i] = 90;
                        break;
                }
            }
            tx1_by_band = new bool[(int)Band.LAST];
            tx2_by_band = new bool[(int)Band.LAST];
            tx3_by_band = new bool[(int)Band.LAST];

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                tx1_by_band[i] = tx2_by_band[i] = tx3_by_band[i] = true;
            }

            // ke9ns add .206
            tx1_by2_band = new bool[(int)Band.LAST];
            tx2_by2_band = new bool[(int)Band.LAST];
            tx3_by2_band = new bool[(int)Band.LAST];

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                tx1_by2_band[i] = tx2_by2_band[i] = tx3_by2_band[i] = true;
            }


            vhf_text = new RadioButtonTS[15];
            vhf_text[0] = radBandVHF0;
            vhf_text[1] = radBandVHF1;
            vhf_text[2] = radBandVHF2;
            vhf_text[3] = radBandVHF3;
            vhf_text[4] = radBandVHF4;
            vhf_text[5] = radBandVHF5;
            vhf_text[6] = radBandVHF6;
            vhf_text[7] = radBandVHF7;
            vhf_text[8] = radBandVHF8;
            vhf_text[9] = radBandVHF9;
            vhf_text[10] = radBandVHF10;
            vhf_text[11] = radBandVHF11;
            vhf_text[12] = radBandVHF12;
            vhf_text[13] = radBandVHF13; //  vhf_text[index].Enabled = b;

            vhf_text2 = new RadioButtonTS[15]; //.212

            vhf_text2[0] = radBandVHF0RX2;
            vhf_text2[1] = radBandVHF1RX2;
            vhf_text2[2] = radBandVHF2RX2;
            vhf_text2[3] = radBandVHF3RX2;
            vhf_text2[4] = radBandVHF4RX2;
            vhf_text2[5] = radBandVHF5RX2;
            vhf_text2[6] = radBandVHF6RX2;
            vhf_text2[7] = radBandVHF7RX2;
            vhf_text2[8] = radBandVHF8RX2;
            vhf_text2[9] = radBandVHF9RX2;
            vhf_text2[10] = radBandVHF10RX2;
            vhf_text2[11] = radBandVHF11RX2;
            vhf_text2[12] = radBandVHF12RX2;
            vhf_text2[13] = radBandVHF13RX2; //  vhf_text2[index].Enabled = b;


            //   gen_text = new RadioButtonTS[15];  // ke9ns add dont know why yet
            //   gen_text[0] = radBandGEN0;
            //   gen_text[1] = radBandGEN1;
            //  gen_text[2] = radBandGEN2;
            //   gen_text[3] = radBandGEN3;
            //   gen_text[4] = radBandGEN4;
            //   gen_text[5] = radBandGEN5;
            //  gen_text[6] = radBandGEN6;
            //  gen_text[7] = radBandGEN7;
            //  gen_text[8] = radBandGEN8;
            //  gen_text[9] = radBandGEN9;
            //   gen_text[10] = radBandGEN10;
            //   gen_text[11] = radBandGEN11;
            //    gen_text[12] = radBandGEN12;
            //   gen_text[13] = radBandGEN13;



            radBandGN0.Enabled = true; // ke9ns add turn on all the buttons for GEN SWL
            radBandGN1.Enabled = true;
            radBandGN2.Enabled = true;
            radBandGN3.Enabled = true;
            radBandGN4.Enabled = true;
            radBandGN5.Enabled = true;
            radBandGN6.Enabled = true;
            radBandGN7.Enabled = true;
            radBandGN8.Enabled = true;
            radBandGN9.Enabled = true;
            radBandGN10.Enabled = true;
            radBandGN11.Enabled = true;
            radBandGN12.Enabled = true;
            radBandGN13.Enabled = true;

            radBandGN0RX2.Enabled = true; // ke9ns add turn on all the buttons for GEN SWL
            radBandGN1RX2.Enabled = true;
            radBandGN2RX2.Enabled = true;
            radBandGN3RX2.Enabled = true;
            radBandGN4RX2.Enabled = true;
            radBandGN5RX2.Enabled = true;
            radBandGN6RX2.Enabled = true;
            radBandGN7RX2.Enabled = true;
            radBandGN8RX2.Enabled = true;
            radBandGN9RX2.Enabled = true;
            radBandGN10RX2.Enabled = true;
            radBandGN11RX2.Enabled = true;
            radBandGN12RX2.Enabled = true;
            radBandGN13RX2.Enabled = true;


            vhf_power_table = new float[freqs_2m.Length];

            for (int i = 0; i < vhf_power_table.Length; i++)
            {
                vhf_power_table[i] = 0.0f;
            }
            uhf_power_table = new float[freqs_70cm.Length];

            for (int i = 0; i < vhf_power_table.Length; i++)
            {
                uhf_power_table[i] = 0.0f;
            }

            power_table = new float[(int)Band.LAST][];


            for (int i = 0; i < (int)Band.LAST; i++)
            {
                power_table[i] = new float[13];
            }

            rx1_image_gain_table = new float[(int)Band.LAST];
            rx1_image_phase_table = new float[(int)Band.LAST];
            rx2_image_gain_table = new float[(int)Band.LAST];
            rx2_image_phase_table = new float[(int)Band.LAST];
            tx_image_gain_table = new float[(int)Band.LAST];
            tx_image_phase_table = new float[(int)Band.LAST];

            tx_carrier_cal = new SortedDictionary<double, uint>();

            pa_bias_table = new int[4][]; // 4 groups of 8 pot settings
            for (int i = 0; i < 4; i++)
            {
                pa_bias_table[i] = new int[8];
                for (int j = 0; j < 8; j++)
                    pa_bias_table[i][j] = 0;
            }

            rx1_level_table = new float[(int)Band.LAST][]; // 3 settings per band (display_offset, preamp, multimeter offset)
            switch (current_model)
            {
                case Model.FLEX3000:
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        rx1_level_table[i] = new float[3];
                        rx1_level_table[i][0] = -71.0f;	// setup defaults;
                        rx1_level_table[i][1] = 19.8f;
                        rx1_level_table[i][2] = -26.0f;
                    }
                    break;
                case Model.FLEX1500:
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        rx1_level_table[i] = new float[3];
                        rx1_level_table[i][0] = -90.0f;	// setup defaults;
                        rx1_level_table[i][1] = 19.8f;
                        rx1_level_table[i][2] = 0.0f;
                    }
                    break;
                default:
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        rx1_level_table[i] = new float[3];
                        rx1_level_table[i][0] = -59.2f;	// setup defaults;
                        rx1_level_table[i][1] = -13.5f;
                        rx1_level_table[i][2] = -32.0f;
                    }
                    break;
            }

            rx2_level_table = new float[(int)Band.LAST][]; // 3 settings per band (display_offset, preamp, multimeter offset)
            for (int i = 0; i < (int)Band.LAST; i++)
            {
                rx2_level_table[i] = new float[3];
                rx2_level_table[i][0] = -59.2f; // setup defaults;
                rx2_level_table[i][1] = -13.5f;
                rx2_level_table[i][2] = -32.0f;
            }

            pa_bridge_table = new float[(int)Band.LAST][];
            for (int i = 0; i < (int)Band.LAST; i++)
            {
                pa_bridge_table[i] = new float[6]; // 1, 2, 5, 10, 20, 90
                for (int j = 0; j < 6; j++)
                    pa_bridge_table[i][j] = 0.0f;
            }

            swr_table = new float[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++)
                swr_table[i] = 1.0f;

            atu_swr_table = new float[(int)Band.LAST];
            for (int i = 0; i < (int)Band.LAST; i++)
                atu_swr_table[i] = 1.0f;

            uhf_level_table = new float[2];
            //uhf_level_table[0] = ??? // TODO: add default values
            //uhf_level_table[1] = ???

            vhf_level_table = new float[2];
            //vhf_level_table[0] = ???
            //vhf_level_table[1] = ???

            atu_tuning = false;
            tune_power = 10;
            calibrating = false;

            // get culture specific decimal separator
            separator = CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator;

            last_band = "";						// initialize bandstack
            last_band2 = "";                    // .209

            tune_step_list = new List<TuneStep>();  // initialize wheel tuning list array
            tune_step_list.Add(new TuneStep(1, "1Hz")); //0
            tune_step_list.Add(new TuneStep(10, "10Hz")); //1
            tune_step_list.Add(new TuneStep(50, "50Hz")); //2
            tune_step_list.Add(new TuneStep(100, "100Hz")); //3
            tune_step_list.Add(new TuneStep(250, "250Hz")); //4
            tune_step_list.Add(new TuneStep(500, "500Hz")); //5
            tune_step_list.Add(new TuneStep(1000, "1kHz")); //6
            tune_step_list.Add(new TuneStep(5000, "5kHz")); //7
            tune_step_list.Add(new TuneStep(9000, "9kHz")); //8
            tune_step_list.Add(new TuneStep(10000, "10kHz")); //9
            tune_step_list.Add(new TuneStep(100000, "100kHz")); //10
            tune_step_list.Add(new TuneStep(250000, "250kHz")); //11
            tune_step_list.Add(new TuneStep(500000, "500kHz")); //12
            tune_step_list.Add(new TuneStep(1000000, "1MHz"));  //13
            tune_step_list.Add(new TuneStep(10000000, "10MHz")); //14

            tune_step_index = 2;


            //  setupForm.tune_step_index2 = 2; // ke9ns add


            meter_text_history = new float[multimeter_text_peak_samples];

            current_meter_data = -200.0f;

            rx1_preamp_offset = new float[5];
            rx1_preamp_offset[(int)PreampMode.OFF] = 10.0f;
            rx1_preamp_offset[(int)PreampMode.LOW] = 0.0f;
            rx1_preamp_offset[(int)PreampMode.MED] = -16.0f;
            rx1_preamp_offset[(int)PreampMode.HIGH] = -26.0f;
            rx1_preamp_offset[(int)PreampMode.LAST] = -36.0f;

            rx2_preamp_offset = new float[4];
            rx2_preamp_offset[(int)PreampMode.OFF] = 0.0f;
            rx2_preamp_offset[(int)PreampMode.HIGH] = -14.0f;            // ke9ns mod  was 14.0f should be -14  not +14
                                                                         // when set to +14 it would cause the waterfall signal to jump up


            //--------------------------------------------------------------------------------------------------------
            // ke9ns: 


            this.ActiveControl = chkPower;      // Power has focus initially

            Display.Target = picDisplay;         // ke9ns: resize to fill properly on startup?
            Display.Init();                     // Initialize Display variables
            InitDisplayModes();                 // Initialize Display Modes
            InitAGCModes();                     // Initialize AGC Modes
            InitMultiMeterModes();              // Initialize MultiMeter Modes


            //--------------------------------------------------------------------------------------------------------
            // ke9ns: Start Threads up NOW
            ProcessSampleThreadController[] pstc = new ProcessSampleThreadController[3]; // DttSP.ProcessSamplesThread(thread); -> MUTE, Pass, Play, switch threads


            audio_process_thread = new Thread[3]; //  threads to run DttSP functions


            for (uint proc_thread = 0; proc_thread < 3; proc_thread++)
            {
                pstc[proc_thread] = new ProcessSampleThreadController(proc_thread);
                audio_process_thread[proc_thread] = new Thread(new ThreadStart(pstc[proc_thread].ProcessSampleThread));
                audio_process_thread[proc_thread].Name = "Audio Process Thread " + proc_thread.ToString();
                audio_process_thread[proc_thread].Priority = ThreadPriority.Highest;
                audio_process_thread[proc_thread].IsBackground = true;
                audio_process_thread[proc_thread].Start();

                /*				DttSP.SetThreadCom(proc_thread);

								audio_process_thread = new Thread(	// create audio process thread
									new ThreadStart(DttSP.ProcessSamplesThread));
								audio_process_thread.Name = "Audio Process Thread ";
								audio_process_thread.Priority = ThreadPriority.Highest;
								audio_process_thread.IsBackground = true;
								audio_process_thread.Start();
				*/
            }




            if(current_model == Model.SDR1000)              hw = new HW(0x378);				// create hardware object

            //BT 5/3/10 moved siolistener to last init item to prevent default data
            //being sent via CAT
            //EW 5/20/10 undid this change due to crashes when the secondary Keyer input was set to CAT
            siolisten = new SIOListenerII(this);    // original CAT
            siolisten2 = new SIOListenerII2(this);    // ke9ns .180 CAT port2
            siolisten3 = new SIOListenerII3(this);    // ke9ns CAT port3
            siolisten4 = new SIOListenerII4(this);    // ke9ns CAT port4
            siolisten5 = new SIOListenerII5(this);    // ke9ns CAT port5
            siolisten6 = new SIOListenerII6(this);    // ke9ns CAT port6 .200 spoof VFOA to B

            siolisten1 = new SIOListenerIII(this); // ke9ns add for rotor control


            CWSensorItem.Init();
            CWPTT.Init();
            CWPTT.MoxChanged += new CWPTT.MoxCallback(SetConsoleMox);
            CWPTT.MuteChanged += new CWPTT.MuteCallback(SetTRMute);

            eqForm = new EQForm(this);

            InitFilterPresets();                // Initialize filter values

            SwlForm = new SwlControl(this);         // ke9ns add communicate with swl list controls


            StackForm = new StackControl(this);     // ke9ns add communicate with bandstack controls
            helpboxForm = new helpbox(this);         // ke9ns add communicate with helpbox list controls
            helpbox1Form = new helpbox1(this);         // ke9ns add communicate with helpbox1 list controls

            httpFile = new Http(this);              // ke9ns add

            httpServer = new HttpServer(this);      // rn3kk add

            setupForm = new Setup(this);        // ke9ns  create Setup form (needed so you can send data to setup form) Repeat for any form you want to send data too

            skin1 = new Skin(this);

            IDBOXForm = new IDBOX(this);         // ke9ns create id timer message box now

            IDBOXForm.Show();
            IDBOXForm.Close();

           
            TOTBOXForm = new TOTBOX(this);         // ke9ns create TOT timer message box now

            TOTBOXForm.Show();
            TOTBOXForm.Close();


            setupForm.StartPosition = FormStartPosition.Manual;
            SwlForm.StartPosition = FormStartPosition.Manual;

            switch (current_model)
            {
                case Model.SDR1000:
                    Hdw.Init();                         // Power down hardware
                    Hdw.StandBy();                      // initialize hardware device
                    break;
                /*case Model.SDRX:
                    if(fwc_init)
                    {
                        byte mask;
                        FWC.GetRXPresentMask(out mask);
                        for(int i=0; i<8; i++)
                        {
                            if((mask>>i & 1) == 1)
                            {
                                fwc_index = i;
                                break;
                            }
                        }
                    }
                    break;*/
                case Model.FLEX5000:
                    if (fwc_init)
                        fwcMixForm = new FWCMixForm(this);
                    break;
                case Model.FLEX3000:
                    if (fwc_init)
                        flex3000MixerForm = new FLEX3000MixerForm(this);
                    break;
                case Model.FLEX1500:
                    if (hid_init)
                        flex1500MixerForm = new FLEX1500MixerForm(this);
                    break;
            }

            //SetupForm.GetTxProfiles();
            UpdateTXProfile(setupForm.TXProfile);

            Common.RestoreForm(eqForm, "EQForm", false);



            vuForm = new VUForm(this);
            xvtrForm = new XVTRForm(this);
            ucbForm = new UCBForm(this);

            WaveForm = new WaveControl(this);   // create Wave form

            WaveForm.StartPosition = FormStartPosition.Manual;

            ScanForm = new ScanControl(this);   // ke9ns add create Scan form
            ScanForm.StartPosition = FormStartPosition.Manual;

            memoryList = MemoryList.Restore();
            memoryList.CheckVersion();

            dxmemList = DXMemList.Restore1(); // ke9ns add for dx spotter
            dxmemList.CheckVersion1(); // ke9ns add


            InitMemoryFrontPanel();

            //rx1_filter = Filter.F2600;            

            //RX1AGCMode = AGCMode.MED;				// Initialize front panel controls
            comboPreamp.Text = "High";
            chkRX1Preamp.Checked = true;
            vfob_dsp_mode = DSPMode.LSB;
            vfob_filter = Filter.F3;
            comboDisplayMode.Text = "Panadapter";
            comboRX2DisplayMode.Text = "Panadapter";
            comboMeterRXMode.SelectedIndex = 0;
            comboRX2MeterMode.SelectedIndex = 0;
            comboTuneMode.SelectedIndex = 0;
            quick_save_filter = Filter.F3;
            quick_save_mode = DSPMode.LSB;
            ptbPWR.Value = 50;
            ptbTune.Value = 10; // ke9ns add
            btnDisplayPanCenter_Click(this, EventArgs.Empty);
            comboTXProfile.Text = setupForm.TXProfile;
            comboDigTXProfile.Text = setupForm.TXProfile;
            comboFMTXProfile.Text = setupForm.TXProfile;
            comboCWTXProfile.Text = setupForm.TXProfile;  // ke9ns add
            comboFMCTCSS.Text = "100.0";

            GetState();                         // recall saved state



            chkFullDuplex.Checked = false;
            if (rx1_dsp_mode == DSPMode.FIRST || rx1_dsp_mode == DSPMode.LAST)
                radModeSAM.Checked = true;
            if (rx2_dsp_mode == DSPMode.FIRST || rx2_dsp_mode == DSPMode.LAST)
                radRX2ModeSAM.Checked = true;
            if (rx1_filter == Filter.FIRST || rx1_filter == Filter.LAST ||
                (rx1_filter == Filter.NONE && rx1_dsp_mode != DSPMode.DRM && rx1_dsp_mode != DSPMode.SPEC))
                radFilter3.Checked = true;
            if (rx2_filter == Filter.FIRST || rx2_filter == Filter.LAST ||
                (rx2_filter == Filter.NONE && rx2_dsp_mode != DSPMode.DRM && rx2_dsp_mode != DSPMode.SPEC))
                radRX2Filter3.Checked = true;

            chkVFOATX_CheckedChanged(this, EventArgs.Empty);
            chkVFOBTX_CheckedChanged(this, EventArgs.Empty);

            txtVFOAFreq_LostFocus(this, EventArgs.Empty);
            txtVFOBFreq_LostFocus(this, EventArgs.Empty);


            if (fwc_init && !run_setup_wizard &&
                (current_model == Model.FLEX5000 || current_model == Model.FLEX3000))
            {
                CheckCalData();

                if (!FWCEEPROM.TRXChecksumPresent)  WriteTRXChecksums();

                VerifyTRXChecksums();

                if (fwcAntForm != null && !fwcAntForm.IsDisposed)
                {
                    Debug.WriteLine("1rx1_band " + rx1_band);

                    fwcAntForm.SetBand(rx1_band);
                    fwcAntForm.CurrentAntMode = current_ant_mode;
                    fwcAntForm.RX1Ant = rx1_ant;
                    fwcAntForm.RX1Loop = rx1_loop;
                    fwcAntForm.RX2Ant = rx2_ant;
                    fwcAntForm.TXAnt = tx_ant;
                    fwcAntForm.TXAnt2 = tx_ant2; // ke9ns add .205
                }
                RX1Ant = rx1_ant;
                if (FWCEEPROM.RX2OK)
                {
                    CheckRX2CalData();
                    if (!FWCEEPROM.RX2ChecksumPresent)
                        WriteRX2Checksums();
                    VerifyRX2Checksums();
                    RX2Ant = rx2_ant;
                }
            }
            else if (hid_init && !run_setup_wizard && current_model == Model.FLEX1500)
            {
                Check1500CalData();
                Verify1500Checksums();

                if (hidAntForm != null && !hidAntForm.IsDisposed)
                {
                    hidAntForm.SetBand(rx1_band);
                    hidAntForm.CurrentAntMode = current_ant_mode;
                    hidAntForm.RXAnt = rx_ant_1500;
                    hidAntForm.TXAnt = tx_ant_1500;
                }
                RXAnt1500 = rx_ant_1500;
                TXAnt1500 = tx_ant_1500;
            }
            else PAPresent = pa_present;

            if (comboAGC.SelectedIndex < 0) RX1AGCMode = AGCMode.MED;
            if (comboRX2AGC.SelectedIndex < 0) comboRX2AGC.Text = "Med";


            // ke9ns: call these routines to force initial updates to their values

            txtVFOBFreq_LostFocus(this, EventArgs.Empty);
            txtVFOAFreq_LostFocus(this, EventArgs.Empty);
            ptbTune_Scroll(this, EventArgs.Empty); // ke9ns add		
            ptbPWR_Scroll(this, EventArgs.Empty);

            ptbMON_Scroll(this, EventArgs.Empty); // ke9ns add

            ptbAF_Scroll(this, EventArgs.Empty);
            ptbSquelch_Scroll(this, EventArgs.Empty);
            ptbMic_Scroll(this, EventArgs.Empty);
            ptbDX_Scroll(this, EventArgs.Empty);
            ptbCPDR_Scroll(this, EventArgs.Empty);
            ptbVOX_Scroll(this, EventArgs.Empty);
            ptbNoiseGate_Scroll(this, EventArgs.Empty);
            ptbCWSpeed_Scroll(this, EventArgs.Empty);
            ptbPanMainRX_Scroll(this, EventArgs.Empty);
            ptbPanSubRX_Scroll(this, EventArgs.Empty);
            ptbRX2RF_Scroll(this, EventArgs.Empty);
            ptbRX2Squelch_Scroll(this, EventArgs.Empty);
            initializing = false;
            RX1PreampMode = rx1_preamp_mode;
            RX2PreampMode = rx2_preamp_mode;
            initializing = true;
            ptbDisplayZoom_Scroll(this, EventArgs.Empty);
            ptbRX0Gain_Scroll(this, EventArgs.Empty);
            ptbRX1Gain_Scroll(this, EventArgs.Empty);
            ptbPanMainRX_Scroll(this, EventArgs.Empty);
            ptbPanSubRX_Scroll(this, EventArgs.Empty);
            ptbRX2Pan_Scroll(this, EventArgs.Empty);
            ptbRX2Gain_Scroll(this, EventArgs.Empty);
            chkRX2Preamp_CheckedChanged(this, EventArgs.Empty);
            ptbRF_Scroll(this, EventArgs.Empty);
            ptbVACRXGain_Scroll(this, EventArgs.Empty);
            ptbVACTXGain_Scroll(this, EventArgs.Empty);


            CalcDisplayFreq();

            tune_step_index--;                  // Setup Mouse wheel tuning
            ChangeTuneStepUp();


            setupForm.tune_step_index2--;   // ke9ns add Powermate and Flexcontrol knob alt tuning #1
            setupForm.ChangeTuneStepUp2(); // ke9ns add

            setupForm.tune_step_index3--;   // ke9ns addadd Powermate  knob alt tuning #2
            setupForm.ChangeTuneStepUp3(); // ke9ns add

            setupForm.tune_step_index4 = setupForm.tune_step_index2;


            UpdateDisplayOffsets();

            setupForm.initCATandPTTprops();   // wjt added -- get console props setup for cat and ptt 
            if (CmdLineArgs != null)
            {
                for (int i = 0; i < CmdLineArgs.Length; i++)
                {

                }
            }

            if (comboMeterTXMode.Items.Count > 0 && comboMeterTXMode.SelectedIndex < 0) comboMeterTXMode.SelectedIndex = 0;

            if (comboMeterTX1Mode.Items.Count > 0 && comboMeterTX1Mode.SelectedIndex < 0) comboMeterTX1Mode.SelectedIndex = 0; // ke9ns add


            chkMOX.Enabled = false;

            //SyncDSP(); in a different location

            if (this.setupForm.FlexProfilerInstalled) remoteProfilesToolStripMenuItem.Visible = true;

            //EW 5/20/10 Moved this back up to where it was before to prevent crashes
            //siolisten = new SIOListenerII(this);

            if ((current_model == Model.FLEX1500) && !db_exists)    // for 1500 display centering
            {
                if_freq = 0.003800;
                setupForm.IFFreq = if_freq;
                chkSR.Checked = false;
                radDisplayZoom05.Checked = true;
            }


            Debug.WriteLine("Console: Create SpotControl Instance here");

            if (SpotForm == null || SpotForm.IsDisposed) SpotForm = new SpotControl(this);  // create spotform

            SpotForm.Show();
            SpotForm.Hide();


            if ((SpotForm.chkMapOn.Checked == true) && (SpotForm.mapon == false))
            {
                SpotForm.btnTrack_Click(this, EventArgs.Empty); // if box is checked and world map was OFF, Go turn ON
            }

          
            if ((SpotForm.chkDXOn.Checked == true) && (SpotForm.dxon == false))
            {
                SpotForm.SpotControl_Load(this, EventArgs.Empty);
                SpotForm.spotSSB_Click(this, EventArgs.Empty); // if box is checked and DX spotting OFF, Go turn ON
            }

            SpotForm.SWLLoad(); // ke9ns add preload up the SWL listing


            if (setupForm != null) // ke9ns add
            {
                Display.AGCT_Adj_Ratio = (double)setupForm.tbAGCTadj.Value / (double)1000.00;

                if (setupForm.chkBoxHERO.Checked == true)
                {
                    if ((fwc_init && (current_model == Model.FLEX5000 || current_model == Model.FLEX3000)) ||
                               (hid_init && current_model == Model.FLEX1500))
                    {
                        if (preSelForm == null || preSelForm.IsDisposed) preSelForm = new PreSelForm(this);

                        //  preSelForm.Show();
                        // preSelForm.Focus();
                        // preSelForm.WindowState = FormWindowState.Normal; // ke9ns add
                    }
                }
            }

            AutoWaterPan(); // ke9ns add .189 to force on/off
            setupForm.ChkSpectrumHiRes_CheckedChanged(this, EventArgs.Empty); // ke9ns add .189 to force on/off
            setupForm.chkBoxTOT_CheckedChanged(this, EventArgs.Empty); // ke9ns add .189 to force on/off

            if ((SpotForm.chkVoacap.Checked == true) && (SpotForm.voaon == false))
            {
                SpotForm.checkBoxMUF.Checked = true; // turn on voacap

              
                Debug.WriteLine("TURN ON MUF");

            }

            Debug.WriteLine("===END=== INITCONSOLE routine");

        } //Initconsole (from inside Console()  )


        //==================================================================
        // ke9ns disable this. caused a timing issue with CAT COM routines
        private void FlexControlScan()
        {
            //   Thread t = new Thread(new ThreadStart(FlexControlScan_ThreadFunction));
            //   t.Name = "FlexControl Scan";
            //   t.IsBackground = true;
            //   t.Priority = ThreadPriority.Normal;
            //  t.Start();
        }


        //===============================================================
        // ke9ns: no longer a thread. just do it and get over it.
        private void FlexControlScan_ThreadFunction()
        {

            FlexControlManager.Rescan();

            if (FlexControlManager.DeviceCount == 0) return;

            if (flexControlBasicForm.FlexControl == null) flexControlBasicForm.FlexControl = FlexControlManager.GetFlexControl(0);

            if (flexControlAdvancedForm.FlexControl == null) flexControlAdvancedForm.FlexControl = FlexControlManager.GetFlexControl(0);


        } // FlexControlScan_ThreadFunction()


        //================================================================
        // ke9ns: Get DSP up and running
        private void SyncDSP()
        {
            for (int i = 0; i < 2; i++)
            {
                for (int j = 0; j < 2; j++)
                {
                    DSPRX dsp_rx = dsp.GetDSPRX(i, j);
                    dsp_rx.Update = true;
                    dsp_rx.Force = true;
                    dsp_rx.BufferSize = dsp_rx.BufferSize;
                    dsp_rx.Force = false;
                }
            }

            for (int i = 0; i < 1; i++)
            {
                DSPTX dsp_tx = dsp.GetDSPTX(i);
                dsp_tx.Update = true;
                dsp_tx.Force = true;
                dsp_tx.BufferSize = dsp_tx.BufferSize;
                dsp_tx.Force = false;
            }

            DSP.SyncStatic();

            for (int i = 0; i < 2; i++)
            {
                for (int j = 0; j < 2; j++)
                {
                    DSPRX dsp_rx = dsp.GetDSPRX(i, j);
                    dsp_rx.Update = false;
                    dsp_rx.Force = true;
                    dsp_rx.Update = true;
                    dsp_rx.Force = false;
                }
            }

            for (int i = 0; i < 1; i++)
            {
                DSPTX dsp_tx = dsp.GetDSPTX(i);
                dsp_tx.Update = false;
                dsp_tx.Force = true;
                dsp_tx.Update = true;
                dsp_tx.Force = false;
            }
        } // SYNCDSP()


        //================================================================
        // ke9ns: Console_Closing(),  then Dispose() then ExitConsole();

        public void ExitConsole()
        {

            Debug.WriteLine("((((((((EXIT CONSOLE ENTER))))))))))))))))");

            StreamWriter writer = new StreamWriter(app_data_path + "shutdown3.log"); //   // look for %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\

            writer.AutoFlush = true;

            writer.WriteLine("ExitConsole(): 1-31");

            writer.WriteLine("1) PAL and FWCMIDI exit");

            try
            {   // always close Pal as it was open to detect radios
                //if (current_model == Model.FLEX5000 || current_model == Model.FLEX3000)
                {
                    Pal.Exit();
                    Thread.Sleep(100);
                    FWCMidi.Close();
                    Thread.Sleep(100);
                }
            }
            catch (Exception e)
            {
                Debug.WriteLine("PAL exit fail " + e);
                writer.WriteLine("1) PAL and FWCMIDI FAILURE");

            }

            writer.WriteLine("1) Done");


            //----------------------------------------------------------------------------------


            writer.WriteLine("2) Check for SaveTX profile on exit here");

            Debug.WriteLine("((((((((CHECK...SAVETXPROFILEDATA))))))))))))))))");

            if (setupForm != null)
            {
                if (SaveTXProfileOnExit == true)    // save the tx profile
                {
                    Debug.WriteLine("((((((((SAVETXPROFILEDATA))))))))))))))))");

                    setupForm.SaveTXProfileData();

                    writer.WriteLine("2) Saving TXPROFILE variables to ArrayList Database XML ");
                }
            }
            writer.WriteLine("2) Done");


            writer.WriteLine("3) SAVE DATABASE TO FILE NAME: " + db_file_name);
            writer.WriteLine("3) Check PowerDown3.log for DB details ");



            Thread.Sleep(100);

            Debug.WriteLine("((((((((SAVING DATABASE))))))))))))))))");

            DB.Exit();                  // close and save database

            writer.WriteLine("3) Done");
            Thread.Sleep(100);
            //----------------------------------------------------------------

          


            Debug.WriteLine("((((((((BEGIN DISPOSING FORMS))))))))))))))))");


            try
            {
                writer.WriteLine("5) Dispose memoryform");
                if (memoryForm != null) memoryForm.Dispose();
                writer.WriteLine("5) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("5) Failure " + e);
                Debug.WriteLine("Dispose failure14 " + e);
            }
            try
            {
                writer.WriteLine("6) Dispose cxw");
                if (cwxForm != null) cwxForm.Dispose();
                writer.WriteLine("6) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("6) Failure " + e);
                Debug.WriteLine("Dispose failure2 " + e);
            }

            try
            {
                writer.WriteLine("7) Dispose cxw");
                if (StackForm != null) StackForm.Dispose(); // ke9ns add
                writer.WriteLine("7) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("7) Failure " + e);
                Debug.WriteLine("Dispose failure18 " + e);
            }

            /*       try
                   {
                       writer.WriteLine("7a) Dispose SPOTFORM");
                       if (SpotForm != null) SpotForm.Dispose(); // ke9ns add
                       writer.WriteLine("7a) Done");
                   }
                   catch (Exception e)
                   {
                       writer.WriteLine("7a) Failure " + e);
                       Debug.WriteLine("Dispose failure18 " + e);
                   }
       */

            Debug.WriteLine("(((((((DISPOSING FORMS5))))))))))))))))");

            try
            {
                writer.WriteLine("8) Dispose scan");
                if (ScanForm != null) ScanForm.Dispose(); // ke9ns add scanner form
                writer.WriteLine("8) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("8) Failure " + e);
                Debug.WriteLine("Dispose failure20 " + e);
            }


            try
            {
                writer.WriteLine("9) Dispose scan");
                if (IDBOXForm != null) IDBOXForm.Dispose(); // ke9ns add ID timer box
                writer.WriteLine("9) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("9) Failure " + e);
                Debug.WriteLine("Dispose failure21 " + e);
            }

            try
            {
                writer.WriteLine("10) Dispose help");
                if (helpboxForm != null) helpboxForm.Dispose(); // ke9ns add help screen
                writer.WriteLine("10) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("10) Failure " + e);
                Debug.WriteLine("Dispose failure22 " + e);
            }

            try
            {
                writer.WriteLine("11) Dispose help1");
                if (helpbox1Form != null) helpbox1Form.Dispose(); // ke9ns add help screen
                writer.WriteLine("11) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("11) Failure " + e);
                Debug.WriteLine("Dispose failure22a " + e);
            }

            try
            {
                writer.WriteLine("12) Dispose totbox");
                if (TOTBOXForm != null) TOTBOXForm.Dispose(); // ke9ns add time out timer
                writer.WriteLine("12) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("12) failure " + e);
                Debug.WriteLine("Dispose failure " + e);
            }

            try
            {
                writer.WriteLine("13) Dispose eq");
                if (eqForm != null) eqForm.Dispose();
                writer.WriteLine("13) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("13) failure " + e);
                Debug.WriteLine("Dispose failure3 " + e);
            }

            try
            {
                writer.WriteLine("14) Dispose ucb");
                if (ucbForm != null) ucbForm.Dispose();
                writer.WriteLine("14) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("14) failure " + e);
                Debug.WriteLine("Dispose failure4 " + e);
            }

            try
            {
                writer.WriteLine("15) Dispose 3000mixer");
                if (flex3000MixerForm != null) flex3000MixerForm.Dispose();
                writer.WriteLine("15) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("15) failure " + e);
                Debug.WriteLine("Dispose failure5 " + e);
            }

            try
            {
                writer.WriteLine("16) Dispose xvtr");
                if (xvtrForm != null) xvtrForm.Dispose();
                writer.WriteLine("16) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("16) failure " + e);
                Debug.WriteLine("Dispose failure6 " + e);
            }

            try
            {
                writer.WriteLine("17) Dispose prodtest");
                if (ProdTestForm != null) ProdTestForm.Dispose();
                writer.WriteLine("17) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("17) failure " + e);
                Debug.WriteLine("Dispose failure7 " + e);
            }
            Debug.WriteLine("(((((((DISPOSING FORMS15))))))))))))))))");

            try
            {
                writer.WriteLine("18) Dispose fwcmix");
                if (fwcMixForm != null) fwcMixForm.Dispose();
                writer.WriteLine("18) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("18) failure " + e);
                Debug.WriteLine("Dispose failure8 " + e);
            }

            try
            {
                writer.WriteLine("19) Dispose 1500mix");
                if (flex1500MixerForm != null) flex1500MixerForm.Dispose();
                writer.WriteLine("19) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("19) failure " + e);
                Debug.WriteLine("Dispose failure9 " + e);
            }

            try
            {
                writer.WriteLine("20) Dispose 5000LLH");
                if (flex5000LLHWForm != null) flex5000LLHWForm.Dispose();
                writer.WriteLine("20) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("20) failure " + e);
                Debug.WriteLine("Dispose failure10 " + e);
            }

            try
            {
                writer.WriteLine("21) Dispose 5000debug");
                if (flex5000DebugForm != null) flex5000DebugForm.Dispose();
                writer.WriteLine("21) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("21) failure " + e);
                Debug.WriteLine("Dispose failure11 " + e);
            }

            try
            {
                writer.WriteLine("22) Dispose flexcontrolbasic");
                if (flexControlBasicForm != null) flexControlBasicForm.Dispose();
                writer.WriteLine("22) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("22) failure " + e);
                Debug.WriteLine("Dispose failure12 " + e);
            }

            try
            {
                writer.WriteLine("23) Dispose flexcontroladv");
                if (flexControlAdvancedForm != null) flexControlAdvancedForm.Dispose();
                writer.WriteLine("23) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("23) failure " + e);
                Debug.WriteLine("Dispose failure13 " + e);
            }


            try
            {
                writer.WriteLine("24) Dispose presel");
                if (preSelForm != null) preSelForm.Dispose();
                writer.WriteLine("24) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("24) failure " + e);
                Debug.WriteLine("Dispose failure15 " + e);
            }

            try
            {
                writer.WriteLine("25) Dispose wave");
                if (WaveForm != null) WaveForm.Dispose(); // ke9ns add
                writer.WriteLine("25) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("25) failure " + e);
                Debug.WriteLine("Dispose failure16 " + e);
            }

            try
            {
                writer.WriteLine("26) Dispose swl");
                if (SwlForm != null) SwlForm.Dispose(); // ke9ns add
                writer.WriteLine("26) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("26) failure " + e);
                Debug.WriteLine("Dispose failure17 " + e);
            }

            try
            {
                writer.WriteLine("27) Dispose fwcatu");
                if (fwcAtuForm != null) fwcAtuForm.Dispose();
                writer.WriteLine("27) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("27) failure " + e);
                Debug.WriteLine("Dispose failure30 " + e);
            }


            //-------------------------------------------------------------------
            if (chkPower.Checked == true) chkPower.Checked = false;   // make sure power is off		
            if (ckQuickRec.Checked == true) ckQuickRec.Checked = false; // make sure recording is stopped

            Thread.Sleep(100);

            writer.WriteLine("28) PA Terminate");

            Debug.WriteLine("((((((((PA TERMINATE))))))))))))))))");


            //			if(draw_display_thread != null)
            //				draw_display_thread.Abort();

            //Parallel.ExitPortTalk();	// close parallel port driver (SDR-1000 ?)
            PA19.PA_Terminate();        // terminate audio interface
                                        //Mixer.RestoreState();		// restore initial mixer state

            writer.WriteLine("28) Done");
            writer.WriteLine("29) DttSP Exit");
            Thread.Sleep(100);


            writer.WriteLine("29) DTTSP NOW");


            DttSP.Exit();               // deallocate DSP variables

            writer.WriteLine("29) Done");
            Debug.WriteLine("((((((((DTTSP EXIT))))))))))))))))");


            Thread.Sleep(100);

            writer.WriteLine("30) ReleaseMutex");
            //-----------------------------------------------------------------------------------
            // release PowerSDR Mutex from instance that created it
            try
            {
                if (psdr2_mutex_exists)
                {
                    psdr2_mutex.ReleaseMutex();
                }
                writer.WriteLine("30) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("30) Failure " + e);
                Debug.WriteLine("Mutex exit fail " + e);

            }


            try
            {
                writer.WriteLine("4) Dispose Setupform");
                if (setupForm != null && !setupForm.IsDisposed) setupForm.Dispose();
                writer.WriteLine("4) Done");
            }
            catch (Exception e)
            {
                writer.WriteLine("4) Failure " + e);
                Debug.WriteLine("Dispose failure1 " + e);
            }


            writer.WriteLine("31) EXITCONSOLE DONE. Rejoin back to shutdown");

            writer.Close();

           

            // ke9ns return back to dispose()
        } // ExitConsole()



        //==============================================================================================
        //==============================================================================================
        //ke9ns   SAVE in DATABASE 
        //==============================================================================================
        //==============================================================================================
        public void SaveState()
        {
            // Automatically saves all control settings to the database in the tab
            // pages on this form of the following types: CheckBox, ComboBox,
            // NumericUpDown, RadioButton, TextBox, and TrackBar (slider)



            string s;

            if (chkPower.Checked == true)
            {
                chkPower.Checked = false;       // turn off the power first
                Thread.Sleep(300);
            }

            //-------------------------------------------------------------------
            // ke9ns add  create database to store my stuff in

            SWR_Logger_Write(); // save SWR data


            //-------------------------------------------------------------------------------

            string file_name2 = AppDataPath + "ke9ns8.dat"; // save data for my mods

            FileStream stream2 = new FileStream(file_name2, FileMode.Create); // open  file
            BinaryWriter writer2 = new BinaryWriter(stream2);

            //    if (Audio.MON_PRE == 1) Debug.WriteLine("Saving PRE = 1");
            //    else Debug.WriteLine("Saving PRE = 0");

            writer2.Write((double)WaterfallLowThresholdMic);      // TX low level waterfall threshold
            writer2.Write(setupForm.checkWaterMoveSize.Checked);  // large waterfall move
            writer2.Write(Display.GrayScale);                    // color or grayscale watetfall
            writer2.Write((byte)WaveForm.BandL);                 // save mode for check of valid waterfall ID later  // RX1DSPMode != BandL
            writer2.Write(Display.PW_AVG);                       // save avgP or avgB  RX1
            writer2.Write(Display.PW_AVG2);                      // save avgp or avgB RX2
            writer2.Write(Audio.MON_PRE);                        // save MONitor pre or post audio

            if (setupForm.gridBoxTS.Checked == true) Display.GridOff = 1; // gridlines OFF
            else Display.GridOff = 0; // gridlines ON

            writer2.Write(Display.GridOff);                      // save panadapter grid on/off
            writer2.Write(WaveControl.QAC);                      // QUickaudio file #

            writer2.Write(SpotControl.nameB);               // name for dx spotter
            writer2.Write(SpotControl.callB);               // call sign for dx spotter
            writer2.Write(SpotControl.nodeB);               // node  for dx spotter
            writer2.Write(SpotControl.portB);               // port for dx spotter

            writer2.Write(callsign);                             // callsign for waterfall ID
            writer2.Write(lastcallsign);                         // last callsign test for valid waterfall ID

            writer2.Write((byte)PAON);                           // temp/volts on/off console display
            writer2.Write((byte)noaaON);                          // space weather console display

            writer2.Write((byte)setupForm.tune_step_index2);      // save Powermate knob index

            writer2.Write((byte)setupForm.tune_step_index3);      // save Powermate knob index

            writer2.Write("end");

            //  writer2.Write(callsign);                  // callsign test
            //  writer2.Write(Display.samplesPerSecondL);  // last samplerate


            writer2.Close();    // close  file
            stream2.Close();   // close stream
                               //   Debug.WriteLine("save database file on exit");

            PAON = 0;       // shut down PAON thread
                            //--------------------------------------------------------------------

            //   Debug.WriteLine("-nameB " + SpotControl.nameB);
            //   Debug.WriteLine("-portB " + SpotControl.portB);
            //  Debug.WriteLine("-callB " + SpotControl.callB);
            //  Debug.WriteLine("-nodeB " + SpotControl.nodeB);


            //   MessageBox.Show(new Form { TopMost = true }, "Done saving SWL_Logger, and ke9ns8.dat, now Put STATE variables into ArrayList database XML structure");


            Debug.WriteLine("KE9NS FILE CLOSED ");


            //   Debug.WriteLine("mic " + WaterfallLowThresholdMic);
            //   Debug.WriteLine("large " + setupForm.checkWaterMoveSize.Checked);
            //   Debug.WriteLine("call " + callsign);
            //   Debug.WriteLine("callL " + LastCall);

            ArrayList a = new ArrayList();     // storage for saving everything


            foreach (Control c in this.Controls)            // For each control
            {
                // if it is a groupbox or panel, check for sub controls
                if (c.GetType() == typeof(GroupBoxTS) || c.GetType() == typeof(PanelTS))
                {
                    foreach (Control c2 in c.Controls)  // for each sub-control
                    {   // check to see if it is a value type we need to save
                        if (c2.Enabled)
                        {
                            if (c2.GetType() == typeof(CheckBoxTS))
                                a.Add(c2.Name + "/" + ((CheckBoxTS)c2).Checked.ToString());
                            else if (c2.GetType() == typeof(ComboBoxTS))
                            {
                                if (((ComboBoxTS)c2).Items.Count > 0)
                                    a.Add(c2.Name + "/" + ((ComboBoxTS)c2).Text);
                            }
                            else if (c2.GetType() == typeof(NumericUpDownTS))
                                a.Add(c2.Name + "/" + ((NumericUpDownTS)c2).Value.ToString());
                            else if (c2.GetType() == typeof(RadioButtonTS))
                                a.Add(c2.Name + "/" + ((RadioButtonTS)c2).Checked.ToString());
                            else if (c2.GetType() == typeof(TextBoxTS))
                            {
                                if (((TextBoxTS)c2).ReadOnly == false)
                                    a.Add(c2.Name + "/" + ((TextBoxTS)c2).Text);
                            }
                            else if (c2.GetType() == typeof(TrackBarTS))
                                a.Add(c2.Name + "/" + ((TrackBarTS)c2).Value.ToString());
                            else if (c2.GetType() == typeof(PrettyTrackBar))
                                a.Add(c2.Name + "/" + ((PrettyTrackBar)c2).Value.ToString());
#if (DEBUG)
                            else if (c2.GetType() == typeof(GroupBox) ||
                                c2.GetType() == typeof(CheckBox) ||
                                c2.GetType() == typeof(ComboBox) ||
                                c2.GetType() == typeof(NumericUpDown) ||
                                c2.GetType() == typeof(RadioButton) ||
                                c2.GetType() == typeof(TextBox) ||
                                c2.GetType() == typeof(TrackBar))
                                Debug.WriteLine(c2.Name + " needs to be converted to a Thread Safe control.");
#endif
                        }
                    }
                }
                else // it is not a group box
                {   // check to see if it is a value type we need to save
                    if (c.Enabled)
                    {
                        if (c.GetType() == typeof(CheckBoxTS))
                            a.Add(c.Name + "/" + ((CheckBoxTS)c).Checked.ToString());
                        else if (c.GetType() == typeof(ComboBoxTS))
                        {
                            if (((ComboBoxTS)c).SelectedIndex >= 0)
                                a.Add(c.Name + "/" + ((ComboBoxTS)c).Text);
                        }
                        else if (c.GetType() == typeof(NumericUpDownTS))
                            a.Add(c.Name + "/" + ((NumericUpDownTS)c).Value.ToString());
                        else if (c.GetType() == typeof(RadioButtonTS))
                            a.Add(c.Name + "/" + ((RadioButtonTS)c).Checked.ToString());
                        else if (c.GetType() == typeof(TextBoxTS))
                        {
                            if (((TextBoxTS)c).ReadOnly == false)
                                a.Add(c.Name + "/" + ((TextBoxTS)c).Text);
                        }
                        else if (c.GetType() == typeof(TrackBarTS))
                            a.Add(c.Name + "/" + ((TrackBarTS)c).Value.ToString());
                        else if (c.GetType() == typeof(PrettyTrackBar))
                            a.Add(c.Name + "/" + ((PrettyTrackBar)c).Value.ToString());
#if (DEBUG)
                        else if (c.GetType() == typeof(GroupBox) ||
                            c.GetType() == typeof(CheckBox) ||
                            c.GetType() == typeof(ComboBox) ||
                            c.GetType() == typeof(NumericUpDown) ||
                            c.GetType() == typeof(RadioButton) ||
                            c.GetType() == typeof(TextBox) ||
                            c.GetType() == typeof(TrackBar))
                            Debug.WriteLine(c.Name + " needs to be converted to a Thread Safe control.");
#endif
                    }
                }
            }

            string ver_num = TitleBar.GetVerNum();

            a.Add("current_datetime_mode/" + (int)current_datetime_mode);
            a.Add("rx1_display_cal_offset/" + rx1_display_cal_offset.ToString("f3"));
            a.Add("rx1_meter_cal_offset/" + rx1_meter_cal_offset);

            a.Add("txtMemoryQuick/" + txtMemoryQuick.Text);     // save quick memory settings
            a.Add("quick_save_mode/" + (int)quick_save_mode);
            a.Add("quick_save_filter/" + (int)quick_save_filter);

            a.Add("hid_last_cal_date_time/" + hid_last_cal_date_time);
            a.Add("hid_serial_num/" + hid_serial_num);
            a.Add("hid_trx_serial_num/" + hid_trx_serial_num);

            a.Add("fwc_last_cal_date_time/" + fwc_last_cal_date_time);
            a.Add("fwc_serial_num/" + fwc_serial_num);
            a.Add("fwc_trx_serial_num/" + fwc_trx_serial_num);

            a.Add("rx2_last_cal_date_time/" + rx2_last_cal_date_time);
            a.Add("rx2_serial_num/" + rx2_serial_num);
            a.Add("rx2_trx_match_serial/" + rx2_trx_match_serial);

            //FM Squelch Save
            a.Add("rx1_squelch_on/" + rx1_squelch_on);
            a.Add("rx1_squelch_threshold_scroll/" + rx1_squelch_threshold_scroll);
            a.Add("rx1_fm_squelch_threshold_scroll/" + rx1_fm_squelch_threshold_scroll);

            a.Add("rx2_squelch_on/" + rx2_squelch_on);
            a.Add("rx2_squelch_threshold_scroll/" + rx2_squelch_threshold_scroll);
            a.Add("rx2_fm_squelch_threshold_scroll/" + rx2_fm_squelch_threshold_scroll);

            a.Add("current_flex_control_mode/" + current_flexcontrol_mode.ToString());
            a.Add("flexcontrol_autodetect/" + flexcontrol_autodetect);

            a.Add("waterfall_high_threshold_160m/" + waterfall_high_threshold_160m); // ke9ns: save these values to the database at power down.
            a.Add("waterfall_low_threshold_160m/" + waterfall_low_threshold_160m);
            a.Add("waterfall_high_threshold_80m/" + waterfall_high_threshold_80m);
            a.Add("waterfall_low_threshold_80m/" + waterfall_low_threshold_80m);
            a.Add("waterfall_high_threshold_60m/" + waterfall_high_threshold_60m);
            a.Add("waterfall_low_threshold_60m/" + waterfall_low_threshold_60m);
            a.Add("waterfall_high_threshold_40m/" + waterfall_high_threshold_40m);
            a.Add("waterfall_low_threshold_40m/" + waterfall_low_threshold_40m);
            a.Add("waterfall_high_threshold_30m/" + waterfall_high_threshold_30m);
            a.Add("waterfall_low_threshold_30m/" + waterfall_low_threshold_30m);
            a.Add("waterfall_high_threshold_20m/" + waterfall_high_threshold_20m);
            a.Add("waterfall_low_threshold_20m/" + waterfall_low_threshold_20m);
            a.Add("waterfall_high_threshold_17m/" + waterfall_high_threshold_17m);
            a.Add("waterfall_low_threshold_17m/" + waterfall_low_threshold_17m);
            a.Add("waterfall_high_threshold_15m/" + waterfall_high_threshold_15m);
            a.Add("waterfall_low_threshold_15m/" + waterfall_low_threshold_15m);
            a.Add("waterfall_high_threshold_12m/" + waterfall_high_threshold_12m);
            a.Add("waterfall_low_threshold_12m/" + waterfall_low_threshold_12m);
            a.Add("waterfall_high_threshold_10m/" + waterfall_high_threshold_10m);
            a.Add("waterfall_low_threshold_10m/" + waterfall_low_threshold_10m);
            a.Add("waterfall_high_threshold_6m/" + waterfall_high_threshold_6m);
            a.Add("waterfall_low_threshold_6m/" + waterfall_low_threshold_6m);
            a.Add("waterfall_high_threshold_wwv/" + waterfall_high_threshold_wwv);
            a.Add("waterfall_low_threshold_wwv/" + waterfall_low_threshold_wwv);
            a.Add("waterfall_high_threshold_gen/" + waterfall_high_threshold_gen);
            a.Add("waterfall_low_threshold_gen/" + waterfall_low_threshold_gen);
            a.Add("waterfall_high_threshold_xvtr/" + waterfall_high_threshold_xvtr);
            a.Add("waterfall_low_threshold_xvtr/" + waterfall_low_threshold_xvtr);

            a.Add("waterfall_high_threshold_LMF/" + waterfall_high_threshold_LMF); // ke9ns: .158 save SWL bands these values to the database at power down.
            a.Add("waterfall_low_threshold_LMF/" + waterfall_low_threshold_LMF);
            a.Add("waterfall_high_threshold_120m/" + waterfall_high_threshold_120m);
            a.Add("waterfall_low_threshold_120m/" + waterfall_low_threshold_120m);
            a.Add("waterfall_high_threshold_90m/" + waterfall_high_threshold_90m);
            a.Add("waterfall_low_threshold_90m/" + waterfall_low_threshold_90m);
            a.Add("waterfall_high_threshold_61m/" + waterfall_high_threshold_61m);
            a.Add("waterfall_low_threshold_61m/" + waterfall_low_threshold_61m);
            a.Add("waterfall_high_threshold_49m/" + waterfall_high_threshold_49m);
            a.Add("waterfall_low_threshold_49m/" + waterfall_low_threshold_49m);
            a.Add("waterfall_high_threshold_41m/" + waterfall_high_threshold_41m);
            a.Add("waterfall_low_threshold_41m/" + waterfall_low_threshold_41m);
            a.Add("waterfall_high_threshold_31m/" + waterfall_high_threshold_31m);
            a.Add("waterfall_low_threshold_31m/" + waterfall_low_threshold_31m);
            a.Add("waterfall_high_threshold_25m/" + waterfall_high_threshold_25m);
            a.Add("waterfall_low_threshold_25m/" + waterfall_low_threshold_25m);
            a.Add("waterfall_high_threshold_22m/" + waterfall_high_threshold_22m);
            a.Add("waterfall_low_threshold_22m/" + waterfall_low_threshold_22m);
            a.Add("waterfall_high_threshold_19m/" + waterfall_high_threshold_19m);
            a.Add("waterfall_low_threshold_19m/" + waterfall_low_threshold_19m);
            a.Add("waterfall_high_threshold_16m/" + waterfall_high_threshold_16m);
            a.Add("waterfall_low_threshold_16m/" + waterfall_low_threshold_16m);
            a.Add("waterfall_high_threshold_14m/" + waterfall_high_threshold_14m);
            a.Add("waterfall_low_threshold_14m/" + waterfall_low_threshold_14m);
            a.Add("waterfall_high_threshold_13m/" + waterfall_high_threshold_13m);
            a.Add("waterfall_low_threshold_13m/" + waterfall_low_threshold_13m);
            a.Add("waterfall_high_threshold_11m/" + waterfall_high_threshold_11m);
            a.Add("waterfall_low_threshold_11m/" + waterfall_low_threshold_11m);

            a.Add("waterfall_update_period/" + waterfall_update_period);
            a.Add("lsb_txprofile/" + lsb_txprofile);
            a.Add("usb_txprofile/" + usb_txprofile);
            a.Add("dsb_txprofile/" + dsb_txprofile);
            a.Add("cwl_txprofile/" + cwl_txprofile);
            a.Add("cwu_txprofile/" + cwu_txprofile);
            a.Add("fm_txprofile/" + fm_txprofile);
            a.Add("am_txprofile/" + am_txprofile);
            a.Add("sam_txprofile/" + sam_txprofile);
            a.Add("spec_txprofile/" + spec_txprofile);
            a.Add("digl_txprofile/" + digl_txprofile);
            a.Add("digu_txprofile/" + digu_txprofile);
            a.Add("drm_txprofile/" + drm_txprofile);

            for (int m = (int)DSPMode.FIRST + 1; m < (int)DSPMode.LAST; m++)
            {   // save filter settings per mode
                for (Filter f = Filter.FIRST + 1; f < Filter.LAST; f++)
                {
                    a.Add("rx1_filters[" + m.ToString() + "][" + ((int)f).ToString() + "]/" + rx1_filters[m].ToString(f));
                }
                a.Add("last_rx1_filter[" + m.ToString() + "]/" + rx1_filters[m].LastFilter.ToString());
            }

            for (int m = (int)DSPMode.FIRST + 1; m < (int)DSPMode.LAST; m++)
            {   // save filter settings per mode
                for (Filter f = Filter.FIRST + 1; f < Filter.LAST; f++)
                {
                    a.Add("rx2_filters[" + m.ToString() + "][" + ((int)f).ToString() + "]/" + rx2_filters[m].ToString(f));
                }
                a.Add("last_rx2_filter[" + m.ToString() + "]/" + rx2_filters[m].LastFilter.ToString());
            }

#if (!NO_TNF)
            for (int i = 0; i < NotchList.List.Count; i++)
            {
                // only save off the permanent notches (ones where a right-click remember has been performed)
                if (NotchList.List[i].Permanent)
                {
                    a.Add("notchlist[" + i + "]/" + NotchList.List[i].ToString());
                }
            }
#endif

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                s = "power_table[" + i + "]/";
                for (int j = 0; j < 13; j++)
                    s += power_table[i][j].ToString("f4") + "|";
                s = s.Substring(0, s.Length - 1);
                a.Add(s);
            }

            s = "vhf_power_table/";
            for (int j = 0; j < vhf_power_table.Length; j++)
                s += vhf_power_table[j].ToString("f4") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "uhf_power_table/";
            for (int j = 0; j < uhf_power_table.Length; j++)
                s += uhf_power_table[j].ToString("f4") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "tx_carrier_cal/";
            foreach (KeyValuePair<double, uint> pair in tx_carrier_cal)
                s += Math.Round(pair.Key, 3).ToString("f3") + "#" + pair.Value.ToString("X") + "|";
            s = s.Substring(0, s.Length - 1); // remove last '|'
            a.Add(s);

            for (int i = 0; i < 4; i++)
            {
                s = "pa_bias_table[" + i + "]/";
                for (int j = 0; j < 8; j++)
                    s += pa_bias_table[i][j].ToString() + "|";
                s = s.Substring(0, s.Length - 1);
                a.Add(s);
            }

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                s = "rx1_level_table[" + i + "]/";
                for (int j = 0; j < 3; j++)
                    s += rx1_level_table[i][j].ToString("f3") + "|";
                s = s.Substring(0, s.Length - 1);
                a.Add(s);
            }

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                s = "rx2_level_table[" + i + "]/";
                for (int j = 0; j < 3; j++)
                    s += rx2_level_table[i][j].ToString("f3") + "|";
                s = s.Substring(0, s.Length - 1);
                a.Add(s);
            }

            if (FWCEEPROM.RX2OK)
            {
                a.Add("rx2_res_offset/" + rx2_res_offset.ToString("f6"));
            }

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                s = "pa_bridge_table[" + i + "]/";
                for (int j = 0; j < 6; j++)
                    s += pa_bridge_table[i][j].ToString("f4") + "|";
                s = s.Substring(0, s.Length - 1);
                a.Add(s);
            }

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                s = "swr_table[" + i + "]/";
                s += swr_table[i].ToString("f4");
                a.Add(s);
            }

            for (int i = 0; i < (int)Band.LAST; i++)
            {
                s = "atu_swr_table[" + i + "]/";
                s += atu_swr_table[i].ToString("f4");
                a.Add(s);
            }

            s = "vhf_level_table/";
            for (int i = 0; i < 2; i++)
                s += vhf_level_table[i].ToString("f1") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "uhf_level_table/";
            for (int i = 0; i < 2; i++)
                s += uhf_level_table[i].ToString("f1") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            a.Add("current_ant_mode/" + ((int)current_ant_mode).ToString());

            a.Add("rx1_ant/" + ((int)rx1_ant).ToString());
            s = "rx1_ant_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += ((int)rx1_ant_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);
            a.Add("rx1_loop/" + rx1_loop.ToString());

            a.Add("rx2_ant/" + ((int)rx2_ant).ToString());
            s = "rx2_ant_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += ((int)rx2_ant_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            a.Add("tx_ant/" + ((int)tx_ant).ToString());
            s = "tx_ant_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += ((int)tx_ant_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            // ke9ns add .205
            a.Add("tx_ant2/" + ((int)tx_ant2).ToString());
            s = "tx_ant_by2_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += ((int)tx_ant_by2_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            a.Add("rx_ant_1500/" + ((int)rx_ant_1500).ToString());
            s = "rx_ant_1500_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += ((int)rx_ant_1500_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            a.Add("tx_ant_1500/" + ((int)tx_ant_1500).ToString());
            s = "tx_ant_1500_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += ((int)tx_ant_1500_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "rx1_loop_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += Convert.ToUInt16(rx1_loop_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            rx1_preamp_by_band[(int)rx1_band] = rx1_preamp_mode;
            for (int i = 0; i < (int)Band.LAST; i++)
            {
                if (rx1_preamp_by_band[i] == PreampMode.FIRST)
                    rx1_preamp_by_band[i] = PreampMode.OFF;
            }
            s = "rx1_preamp_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += ((int)rx1_preamp_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            rx2_preamp_by_band[(int)rx2_band] = rx2_preamp_mode;
            s = "rx2_preamp_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += ((int)rx2_preamp_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "power_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += power_by_band[i].ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            //==========================================
            // ke9ns add
            s = "power_by_mode_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
            {
                for (int ii = 0; ii < (int)DSPMode.LAST; ii++)
                {
                    s += power_by_mode_by_band[i, ii].ToString() + "|";
                }
            }
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            //==========================================
            // ke9ns add
            s = "limit_by_mode_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
            {
                for (int ii = 0; ii < (int)DSPMode.LAST; ii++)
                {
                    s += limit_by_mode_by_band[i, ii].ToString() + "|";
                }
            }
            s = s.Substring(0, s.Length - 1);
            a.Add(s);


            //==========================================

            s = "fm_tx_offset_by_band_mhz/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += fm_tx_offset_by_band_mhz[i].ToString("R") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "rx1_agct_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += rx1_agct_by_band[i].ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "rx2_agct_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += rx2_agct_by_band[i].ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);



            s = "tx1_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += Convert.ToUInt16(tx1_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "tx2_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += Convert.ToUInt16(tx2_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "tx3_by_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += Convert.ToUInt16(tx3_by_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);


            // ke9ns add .206 for RX2
            s = "tx1_by2_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += Convert.ToUInt16(tx1_by2_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "tx2_by2_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += Convert.ToUInt16(tx2_by2_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "tx3_by2_band/";
            for (int i = 0; i < (int)Band.LAST; i++)
                s += Convert.ToUInt16(tx3_by2_band[i]).ToString() + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);


            s = "rx1_image_gain_table/";
            for (int i = 0; i <= (int)Band.B6M; i++)
                s += rx1_image_gain_table[i].ToString("R") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "rx1_image_phase_table/";
            for (int i = 0; i <= (int)Band.B6M; i++)
                s += rx1_image_phase_table[i].ToString("R") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "rx2_image_gain_table/";
            for (int i = 0; i <= (int)Band.B6M; i++)
                s += rx2_image_gain_table[i].ToString("R") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "rx2_image_phase_table/";
            for (int i = 0; i <= (int)Band.B6M; i++)
                s += rx2_image_phase_table[i].ToString("R") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "tx_image_gain_table/";
            for (int i = 0; i <= (int)Band.B6M; i++)
                s += tx_image_gain_table[i].ToString("R") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            s = "tx_image_phase_table/";
            for (int i = 0; i <= (int)Band.B6M; i++)
                s += tx_image_phase_table[i].ToString("R") + "|";
            s = s.Substring(0, s.Length - 1);
            a.Add(s);

            a.Add("rx1_level_checksum/" + rx1_level_checksum.ToString());
            a.Add("rx1_image_gain_checksum/" + rx1_image_gain_checksum.ToString());
            a.Add("rx1_image_phase_checksum/" + rx1_image_phase_checksum.ToString());
            a.Add("tx_image_gain_checksum/" + tx_image_gain_checksum.ToString());
            a.Add("tx_image_phase_checksum/" + tx_image_phase_checksum.ToString());
            a.Add("tx_carrier_checksum/" + tx_carrier_checksum.ToString());
            a.Add("pa_bias_checksum/" + pa_bias_checksum.ToString());
            a.Add("pa_bridge_checksum/" + pa_bridge_checksum.ToString());
            a.Add("pa_power_checksum/" + pa_power_checksum.ToString());
            a.Add("pa_swr_checksum/" + pa_swr_checksum.ToString());
            a.Add("atu_swr_checksum/" + atu_swr_checksum.ToString());
            a.Add("rx2_level_checksum/" + rx2_level_checksum.ToString());
            a.Add("rx2_image_gain_checksum/" + rx2_image_gain_checksum.ToString());
            a.Add("rx2_image_phase_checksum/" + rx2_image_phase_checksum.ToString());




            //------------------------------------------------------------------------
            // ke9ns      this saves the stuff here
            try
            {
                StreamWriter writer = new StreamWriter(app_data_path + "power.csv"); // "\\power.csv"  // look for %userprofile%\AppData\Roaming\FlexRadio Systems\PowerSDR v2.8.0\

                writer.WriteLine("Band, 1, 2, 5, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100");

                for (int i = 1; i <= (int)Band.B6M; i++)
                {
                    writer.Write(((Band)i).ToString() + ",");
                    for (int j = 0; j < 13; j++)
                        writer.Write(power_table[i][j].ToString("f4") + ",");
                    writer.WriteLine("");
                }
                writer.Close();
            }
            catch (Exception)
            {
                MessageBox.Show(new Form { TopMost = true }, "Error writing power.csv file.  Please make sure this file is not open and try again.",
                    "Error writing power.csv",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }


            //   MessageBox.Show(new Form { TopMost = true }, "Done updating Power.CSV file");

            /*try
			{
				StreamWriter writer = new StreamWriter(app_data_path+"\\rx1_level.csv");
				writer.WriteLine("Band, 0, 1, 2");
				for(int i=1; i<=(int)Band.B6M; i++)
				{
					writer.Write(((Band)i).ToString()+",");
					for(int j=0; j<3; j++)
						writer.Write(rx1_level_table[i][j].ToString("f10")+",");
					writer.WriteLine("");
				}
				writer.Close();
			}
			catch(Exception)
			{
				MessageBox.Show(new Form { TopMost = true }, "Error writing rx1_level.csv file.  Please make sure this file is not open and try again.",
					"Error writing rx1_level.csv",
					MessageBoxButtons.OK,
					MessageBoxIcon.Error);
			}*/

            a.Add("rx2_fixed_gain/" + rx2_fixed_gain.ToString());
            a.Add("rx2_max_gain/" + rx2_max_gain.ToString());

            a.Add("band_160m_index/" + band_160m_index.ToString());
            a.Add("band_80m_index/" + band_80m_index.ToString());
            a.Add("band_60m_index/" + band_60m_index.ToString());
            a.Add("band_40m_index/" + band_40m_index.ToString());
            a.Add("band_30m_index/" + band_30m_index.ToString());
            a.Add("band_20m_index/" + band_20m_index.ToString());
            a.Add("band_17m_index/" + band_17m_index.ToString());
            a.Add("band_15m_index/" + band_15m_index.ToString());
            a.Add("band_12m_index/" + band_12m_index.ToString());
            a.Add("band_10m_index/" + band_10m_index.ToString());
            a.Add("band_6m_index/" + band_6m_index.ToString());
            a.Add("band_2m_index/" + band_2m_index.ToString());
            a.Add("band_wwv_index/" + band_wwv_index.ToString());
            a.Add("band_gen_index/" + band_gen_index.ToString());

            a.Add("band_LMF_index/" + band_LMF_index.ToString()); // ke9ns add
            a.Add("band_120m_index/" + band_120m_index.ToString());
            a.Add("band_90m_index/" + band_90m_index.ToString());
            a.Add("band_61m_index/" + band_61m_index.ToString());
            a.Add("band_49m_index/" + band_49m_index.ToString());
            a.Add("band_41m_index/" + band_41m_index.ToString());
            a.Add("band_31m_index/" + band_31m_index.ToString());
            a.Add("band_25m_index/" + band_25m_index.ToString());
            a.Add("band_22m_index/" + band_22m_index.ToString());
            a.Add("band_19m_index/" + band_19m_index.ToString());
            a.Add("band_16m_index/" + band_16m_index.ToString());
            a.Add("band_14m_index/" + band_14m_index.ToString());
            a.Add("band_13m_index/" + band_13m_index.ToString());
            a.Add("band_11m_index/" + band_11m_index.ToString());

            a.Add("band_vhf0_index/" + band_vhf0_index.ToString());
            a.Add("band_vhf1_index/" + band_vhf1_index.ToString());
            a.Add("band_vhf2_index/" + band_vhf2_index.ToString());
            a.Add("band_vhf3_index/" + band_vhf3_index.ToString());
            a.Add("band_vhf4_index/" + band_vhf4_index.ToString());
            a.Add("band_vhf5_index/" + band_vhf5_index.ToString());
            a.Add("band_vhf6_index/" + band_vhf6_index.ToString());
            a.Add("band_vhf7_index/" + band_vhf7_index.ToString());
            a.Add("band_vhf8_index/" + band_vhf8_index.ToString());
            a.Add("band_vhf9_index/" + band_vhf9_index.ToString());
            a.Add("band_vhf10_index/" + band_vhf10_index.ToString());
            a.Add("band_vhf11_index/" + band_vhf11_index.ToString());
            a.Add("band_vhf12_index/" + band_vhf12_index.ToString());
            a.Add("band_vhf13_index/" + band_vhf13_index.ToString());


          

            for (int i = (int)PreampMode.FIRST + 1; i < (int)PreampMode.LAST; i++)
                a.Add("rx1_preamp_offset[" + i.ToString() + "]/" + rx1_preamp_offset[i].ToString("f3"));

            //a.Add("fwc_preamp_offset/"+fwc_preamp_offset.ToString());
            /*for(int i=0; i<32; i++)
				a.Add("fwc_att_offset["+i.ToString()+"]/"+fwc_att_offset[i].ToString());*/

            a.Add("wheel_tune_index/" + tune_step_index.ToString());      // Save wheel tune value



            a.Add("vfob_dsp_mode/" + ((int)vfob_dsp_mode).ToString());  // Save VFO B values
            a.Add("vfob_filter/" + ((int)vfob_filter).ToString());

            a.Add("console_zaximize/" + this.WindowState.ToString()); // ke9ns add: for max detection

            a.Add("console_top/" + this.Top.ToString());                    // save form positions
            a.Add("console_left/" + this.Left.ToString());
            a.Add("console_width/" + this.Width.ToString());
            a.Add("console_height/" + this.Height.ToString());

            a.Add("setup_top/" + setupForm.Top.ToString());
            a.Add("setup_left/" + setupForm.Left.ToString());
            a.Add("saved_rx_only/" + saved_rx_only.ToString());
            a.Add("mon_recall/" + mon_recall.ToString());

            a.Add("Version/" + this.Text);		    // save the current title bar string
            a.Add("VersionNumber/" + ver_num);      // PowerSDR version number in a.b.c format
            a.Add("RadioType/" + CurrentModel);     // radio model string (ex. FLEX1500)
            a.Add("BandTextID/" + current_region);  // TURF Region
            a.Add("Opened/" + extended);            // has the radio been opened?


            // ke9ns add .186 (for scanner low/high edge save
            for (int i = 0; i < 50; i++)
            {
               // Debug.WriteLine("SCANNER: " + i);
                a.Add("SLowScan[" + i.ToString() + "]/" + SLowScan[i]);
             
            }
            for (int i = 0; i < 50; i++)
            {
                // Debug.WriteLine("SCANNER: " + i);
                a.Add("SHighScan[" + i.ToString() + "]/" + SHighScan[i]);

            }

            DB.PurgeNotches();                      // remove old notches from DB

            DB.SaveVars("State", ref a);            // save the "State" values to the DB

            //  MessageBox.Show(new Form { TopMost = true }, "Done updating the STATE variables ArrayList database XML structure");


        }  // SaveState()    




        public static byte moninit = 1;               // ke9ns used for chkMON startup

        public double[,,,] SWR_READ = new double[7, 11, 45, 3000]; //ke9ns: ScanControl Test# 1-5, Ant=1,2,3, band=1-30,freq slot = swr on band
        public int swr_testrun = 1; // ke9ns

        public int SWR_TESTRUN  // ke9ns: SWR scanner
        {
            get
            {
                return swr_testrun;
            }
            set
            {
                swr_testrun = value;
            }
        } // TESTRUN

        //=======================================================================================
        //=======================================================================================
        // ke9ns mod  LOAD UP DATABASE into PowerSDR 
        //=======================================================================================
        //=======================================================================================

        bool CONSOLEM = false; // ke9ns add: true = maximized size when restoring PowerSDR
        int CONSOLEH = 0;
        int CONSOLEW = 0;
        int CONSOLEL = 0;
        int CONSOLET = 0;

        public void GetState()
        {
            // Automatically restores all controls from the database in the
            // tab pages on this form of the following types: CheckBox, ComboBox,
            // NumericUpDown, RadioButton, TextBox, and TrackBar (slider)


            //--------------------------------------------------------
            // ke9ns add  open up database for my stuff  here
            // AppDataPath = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\";
            string file_name3 = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\" + "mem.bak"; // save original Memory.xml file just in case T10
            string file_name4 = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\FlexRadio Systems\\" + "memory.xml"; // save original Memory.xml file just in case T10

            if ((!File.Exists(file_name3)) && (File.Exists(file_name4)))
            {
                Debug.WriteLine("Backing up Memory file 1 time");

                System.IO.File.Copy(file_name4, file_name3); // old > new

            }


            //------------------------------------------------------------------
            // ke9ns RECALL SWR PLOTS
            string file_nameSWR = AppDataPath + "ke9ns_SWR1.dat"; // save data for my mods


            if (!File.Exists(file_nameSWR))
            {

                Debug.WriteLine("Create new SWR database file");

                SWR_Logger_Write();

            } //   ke9ns_SWR.dat file does NOT exist
            else //   ke9ns_SWR.dat file exists
            {

                Debug.WriteLine("READ SWR database file");

                SWR_Logger_Read();

            }  // ke9ns_SWR.dat file exists



            //----------------------------------------------------------------------------

            string file_name2 = AppDataPath + "ke9ns8.dat"; // save data for my mods


            if (!File.Exists(file_name2))
            {

                Debug.WriteLine("Create new database file");

                FileStream stream2 = new FileStream(file_name2, FileMode.Create); // open BMP  file
                BinaryWriter writer2 = new BinaryWriter(stream2);

                writer2.Write((double)WaterfallLowThresholdMic);      // TX low level waterfall threshold
                writer2.Write(setupForm.checkWaterMoveSize.Checked);  // large waterfall move
                writer2.Write(Display.GrayScale);                    // color or grayscale watetfall
                writer2.Write((byte)WaveForm.BandL);                 // save mode for check of valid waterfall ID later  // RX1DSPMode != BandL
                writer2.Write(Display.PW_AVG);                       // save avgP or avgB  RX1
                writer2.Write(Display.PW_AVG2);                      // save avgp or avgB RX2
                writer2.Write(Audio.MON_PRE);                        // save MONitor pre or post audio
                writer2.Write(Display.GridOff);                      // save panadapter grid on/off
                writer2.Write(WaveControl.QAC);                      // QUickaudio file #

                writer2.Write(SpotControl.nameB);               // name for dx spotter
                writer2.Write(SpotControl.callB);               // call sign for dx spotter
                writer2.Write(SpotControl.nodeB);               // node  for dx spotter
                writer2.Write(SpotControl.portB);               // port for dx spotter


                writer2.Write(callsign);                             // callsign for waterfall ID
                writer2.Write(lastcallsign);                         // last callsign test for valid waterfall ID

                writer2.Write((byte)PAON);                           // temp/volts on/off console display
                writer2.Write((byte)noaaON);                          // space weather console display

                writer2.Write((byte)setupForm.tune_step_index2);      // save Powermate knob index
                writer2.Write((byte)setupForm.tune_step_index3);      // save Powermate knob index

                writer2.Write("end");


                writer2.Close();    // close  file
                stream2.Close();   // close stream
                Debug.WriteLine("Create new database file");

            }
            else // yes ke9ns.dat file does exist
            {

                FileStream stream2 = new FileStream(file_name2, FileMode.Open); // open ke9ns file
                BinaryReader reader2 = new BinaryReader(stream2);

                WaterfallLowThresholdMic = (float)reader2.ReadDouble();            //  TX low level waterfall threshold
                setupForm.checkWaterMoveSize.Checked = reader2.ReadBoolean();      // large waterfall move
                Display.GrayScale = reader2.ReadByte();                            // color or grayscale waterfall 
                WaveForm.BandL = (DSPMode)reader2.ReadByte();                      // for check of valid waterfall id
                Display.PW_AVG = reader2.ReadByte();                               // avgP or avgB RX1
                Display.PW_AVG2 = reader2.ReadByte();                              // avgP or avgB RX2
                Audio.MON_PRE = reader2.ReadByte();                                // MONitor pre or post
                Display.GridOff = reader2.ReadByte();                              // panadapter grid on / off
                WaveControl.QAC = reader2.ReadInt32();                             // QUickaudio file #

                SpotControl.DXNAME = reader2.ReadString();                     // name for dx spotter
                SpotControl.DXCALL = reader2.ReadString();                     // call sign for dx spotter
                SpotControl.DXNODE = reader2.ReadString();                     // node for dx spotter
                SpotControl.DXPORT = reader2.ReadString();                     // port for dx spotter


                callsign = reader2.ReadString();                                   // callsign for waterfall ID
                lastcallsign = reader2.ReadString();                               // last callsign test of waterfall ID valid

                PAON = reader2.ReadByte();                                       // temp/volt on/off display
                noaaON = reader2.ReadByte();                                // space weather console display

                try
                {
                    setupForm.tune_step_index2 = reader2.ReadByte();            // Powermate knob index
                }
                catch (Exception)
                {
                    setupForm.tune_step_index2 = 2;
                    setupForm.tune_step_index2--;   // ke9ns add
                    setupForm.ChangeTuneStepUp2(); // ke9ns add


                }

                try
                {
                    setupForm.tune_step_index3 = reader2.ReadByte();            // Powermate knob index
                }
                catch (Exception)
                {
                    setupForm.tune_step_index3 = 2;
                    setupForm.tune_step_index3--;   // ke9ns add
                    setupForm.ChangeTuneStepUp3(); // ke9ns add


                }


                reader2.Close();    // close  file
                stream2.Close();   // close stream
                                   //   Debug.WriteLine("Read database file");

            } // yes ke9ns.dat file does exist


            //ke9ns add
            if (setupForm.chkBoxHTTP.Checked == true)
            {
                //   HttpServer2(); // ke9ns  start server

                Debug.WriteLine("ke9ns8 httplaunch");

                HttpServer = true;

                //  httpFile.HttpServer1();

            }

            //   Debug.WriteLine("1nameB " + SpotControl.nameB);
            //   Debug.WriteLine("1portB " + SpotControl.portB);
            //   Debug.WriteLine("1callB " + SpotControl.callB);
            //    Debug.WriteLine("1nodeB " + SpotControl.nodeB);

            if (Display.GridOff == 1)
            {
                setupForm.gridBoxTS.CheckedChanged -= setupForm.gridBoxTS_CheckedChanged;  // ke9ns turn off checkchanged temporarily    // ke9ns turn off valuechanged temporarily 
                setupForm.gridBoxTS.Checked = true;
                setupForm.gridBoxTS.CheckedChanged += setupForm.gridBoxTS_CheckedChanged;


            }

            //  if (Audio.MON_PRE == 1)
            //  {

            //   Audio.MON_PRE = 2;// initial startup

            //   chkMON.CheckedChanged -= chkMON_CheckedChanged;
            //    chkMON.Text = "MONpr";
            //   panelDisplay.Invalidate();
            //   chkMON.Invalidate();
            //   panelDisplay.Update();
            //    chkMON.CheckedChanged -= chkMON_CheckedChanged;

            //  }
            //  else
            //  {
            //   Debug.WriteLine("recall PRE = 0");
            //  Audio.MON_PRE = 1;

            //  chkMON.CheckedChanged -= chkMON_CheckedChanged;
            //   chkMON.Text = "MONps";
            //    panelDisplay.Invalidate();
            //  chkMON.Invalidate();
            //   panelDisplay.Update();
            //  chkMON.CheckedChanged += chkMON_CheckedChanged;

            // }




            if (Display.PW_AVG == 1)
            {
                //  Debug.WriteLine("avgP ");

                chkDisplayAVG.CheckedChanged -= chkDisplayAVG_CheckedChanged; // turn eventoff
                                                                              //  chkDisplayAVG.Checked = true;
                chkDisplayAVG.Enabled = true;

                chkDisplayAVG.Text = "AvgP"; // ke9ns 
                panelDisplay.Invalidate();
                chkDisplayAVG.Invalidate();
                panelDisplay.Update();

                chkDisplayAVG.CheckedChanged += chkDisplayAVG_CheckedChanged; // turn eventoff


            }
            else
            {
                //  chkDisplayAVG.Text = "AvgB"; // ke9ns 

            }
            if (Display.PW_AVG2 == 1)
            {
                // Debug.WriteLine("avgP ");

                chkRX2DisplayAVG.CheckedChanged -= chkRX2DisplayAVG_CheckedChanged; // turn eventoff
                                                                                    //  chkRX2DisplayAVG.Checked = true;

                chkRX2DisplayAVG.Enabled = true;

                chkRX2DisplayAVG.Text = "AvgP"; // ke9ns 
                panelRX2Display.Invalidate();
                chkRX2DisplayAVG.Invalidate();

                panelRX2Display.Update();
                chkRX2DisplayAVG.CheckedChanged += chkRX2DisplayAVG_CheckedChanged; // turn eventoff

            }
            else
            {
                // chkRX2DisplayAVG.Text = "AvgB"; // ke9ns 

            }

            if (Display.GrayScale == 1)
            {
                this.GrayMenuItem.Text = "ColorWtr";

            }
            if (setupForm.checkWaterMoveSize.Checked)
            {
                Display.WMS = 1;
            }
            callsignTextBox.Text = callsign;

            if ((callsign == lastcallsign) && (WaveForm.BandL == RX1DSPMode))
            {

                callsignTextBox.BackColor = Color.MediumSpringGreen;  // green if you created it or its still a valid wave
                menuStrip1.Invalidate();
                menuStrip1.Update();
            }



            //  Debug.WriteLine("mic " + WaterfallLowThresholdMic);
            //  Debug.WriteLine("large " + setupForm.checkWaterMoveSize.Checked);
            //  Debug.WriteLine("large " + Display.WMS);
            //  Debug.WriteLine("call " + callsign);
            //  Debug.WriteLine("callL " + LastCall);


            ArrayList a1 = DB.GetVars("WaveOptions");                          // Get the saved list of controls
            a1.Sort();

            foreach (string s in a1)             // string is in the format "name,value"
            {
                string[] vals = s.Split('/');
                if (vals.Length > 2)
                {
                    for (int i = 2; i < vals.Length; i++)
                        vals[1] += "/" + vals[i];
                }

                string name = vals[0];
                string val = vals[1];

                if (name.StartsWith("chkQuickAudioFolder"))
                {
                    // Debug.WriteLine("val======= " + val);

                    if (val.Contains("True")) WaveForm.chkQuickAudioFolder.Checked = true;


                }
            }
            //--------------------------------------------------------kes9ns mod end
            //=========================================================================================================




            ArrayList checkbox_list = new ArrayList();
            ArrayList combobox_list = new ArrayList();
            ArrayList numericupdown_list = new ArrayList();
            ArrayList radiobutton_list = new ArrayList();
            ArrayList textbox_list = new ArrayList();
            ArrayList trackbar_list = new ArrayList();
            ArrayList prettytrackbar_list = new ArrayList();

            //ArrayList controls = new ArrayList();	// list of controls to restore
            foreach (Control c in this.Controls)
            {
                // if control is a groupbox or panel, retrieve all subcontrols
                if (c.GetType() == typeof(GroupBoxTS) || c.GetType() == typeof(PanelTS))
                {
                    foreach (Control c2 in c.Controls)
                    {
                        if (c2.Enabled)
                        {
                            if (c2.GetType() == typeof(CheckBoxTS))			// the control is a CheckBox
                                checkbox_list.Add(c2);
                            else if (c2.GetType() == typeof(ComboBoxTS))		// the control is a ComboBox
                                combobox_list.Add(c2);
                            else if (c2.GetType() == typeof(NumericUpDownTS))	// the control is a NumericUpDown
                                numericupdown_list.Add(c2);
                            else if (c2.GetType() == typeof(RadioButtonTS))	// the control is a RadioButton
                                radiobutton_list.Add(c2);
                            else if (c2.GetType() == typeof(TextBoxTS))		// the control is a TextBox
                                textbox_list.Add(c2);
                            else if (c2.GetType() == typeof(TrackBarTS))		// the control is a TrackBar (slider)
                                trackbar_list.Add(c2);
                            else if (c2.GetType() == typeof(PrettyTrackBar))
                                prettytrackbar_list.Add(c2);
                        }
                    }
                }
                else
                {
                    if (c.Enabled)
                    {
                        if (c.GetType() == typeof(CheckBoxTS))              // the control is a CheckBox
                            checkbox_list.Add(c);
                        else if (c.GetType() == typeof(ComboBoxTS))     // the control is a ComboBox
                            combobox_list.Add(c);
                        else if (c.GetType() == typeof(NumericUpDownTS))    // the control is a NumericUpDown
                            numericupdown_list.Add(c);
                        else if (c.GetType() == typeof(RadioButtonTS))      // the control is a RadioButton
                            radiobutton_list.Add(c);
                        else if (c.GetType() == typeof(TextBoxTS))          // the control is a TextBox
                            textbox_list.Add(c);
                        else if (c.GetType() == typeof(TrackBarTS))     // the control is a TrackBar (slider)
                            trackbar_list.Add(c);
                        else if (c.GetType() == typeof(PrettyTrackBar))
                            prettytrackbar_list.Add(c);
                    }
                }
            }



            //=============================================================================================

            ArrayList a = DB.GetVars("State");                          // Get the saved list of controls
            a.Sort();
            int num_controls = checkbox_list.Count + combobox_list.Count +
                numericupdown_list.Count + radiobutton_list.Count +
                textbox_list.Count + trackbar_list.Count;

            foreach (string s in a)             // string is in the format "name,value"
            {
                string[] vals = s.Split('/');
                if (vals.Length > 2)
                {
                    for (int i = 2; i < vals.Length; i++)
                        vals[1] += "/" + vals[i];
                }

                string name = vals[0];
                string val = vals[1];
                int num = 0;

                if (name.StartsWith("rx1_filters["))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int mode_index = Int32.Parse(name.Substring(start, length));

                    start = name.LastIndexOf("[") + 1;
                    length = name.LastIndexOf("]") - start;
                    int filter_mode = Int32.Parse(name.Substring(start, length));

                    length = val.IndexOf(":");
                    string n = val.Substring(0, length);

                    if (!val.Contains("|")) val = val.Replace(",", "|");

                    start = val.IndexOf(":") + 2;
                    length = val.IndexOf("|") - start;
                    int low = Int32.Parse(val.Substring(start, length));

                    start = val.IndexOf("|") + 1;
                    int high = Int32.Parse(val.Substring(start));

                    rx1_filters[mode_index].SetFilter((Filter)filter_mode, low, high, n);
                }
                else if (name.StartsWith("rx2_filters["))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int mode_index = Int32.Parse(name.Substring(start, length));

                    start = name.LastIndexOf("[") + 1;
                    length = name.LastIndexOf("]") - start;
                    int filter_mode = Int32.Parse(name.Substring(start, length));

                    length = val.IndexOf(":");
                    string n = val.Substring(0, length);

                    if (!val.Contains("|"))
                        val = val.Replace(",", "|");

                    start = val.IndexOf(":") + 2;
                    length = val.IndexOf("|") - start;
                    int low = Int32.Parse(val.Substring(start, length));

                    start = val.IndexOf("|") + 1;
                    int high = Int32.Parse(val.Substring(start));

                    rx2_filters[mode_index].SetFilter((Filter)filter_mode, low, high, n);
                }
#if (!NO_TNF)
                else if (name.StartsWith("notchlist"))
                {
                    NotchList.List.Add(Notch.Parse(val));
                }
#endif
                else if (name.StartsWith("last_rx1_filter["))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int mode_index = Int32.Parse(name.Substring(start, length));

                    rx1_filters[mode_index].LastFilter = (Filter)Enum.Parse(typeof(Filter), val);
                }
                else if (name.StartsWith("last_rx2_filter["))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int mode_index = Int32.Parse(name.Substring(start, length));

                    rx2_filters[mode_index].LastFilter = (Filter)Enum.Parse(typeof(Filter), val);
                }
                else if (name.StartsWith("rx1_preamp_offset["))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = Int32.Parse(name.Substring(start, length));

                    rx1_preamp_offset[index] = (float)Math.Round(float.Parse(val), 3);
                }
                else if (name.StartsWith("SLowScan[")) // ke9ns add .186
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = Int32.Parse(name.Substring(start, length));

                    SLowScan[index] = val;
                }
                else if (name.StartsWith("SHighScan[")) // ke9ns add .186
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = Int32.Parse(name.Substring(start, length));

                    SHighScan[index] = val;
                }

                /*else if(name.StartsWith("fwc_att_offset"))
                {
                    int start = name.IndexOf("[")+1;
                    int length = name.IndexOf("]")-start;
                    int index = int.Parse(name.Substring(start, length));

                    fwc_att_offset[index] = float.Parse(val);
                }*/
                else if (name.StartsWith("power_table"))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = int.Parse(name.Substring(start, length));

                    string[] list = val.Split('|');
                    for (int i = 0; i < 13 && i < list.Length; i++)
                        power_table[index][i] = (float)Math.Round(float.Parse(list[i]), 4);
                }
                else if (name.StartsWith("vhf_power_table"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < list.Length; i++)
                        vhf_power_table[i] = (float)Math.Round(float.Parse(list[i]), 4);
                }
                else if (name.StartsWith("uhf_power_table"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < list.Length; i++)
                        uhf_power_table[i] = (float)Math.Round(float.Parse(list[i]), 4);
                }
                else if (name.StartsWith("tx_carrier_cal"))
                {
                    string[] pairs = val.Split('|');
                    tx_carrier_cal.Clear();
                    foreach (string p in pairs)
                    {
                        int index = p.IndexOf("#");
                        double freq = Math.Round(double.Parse(p.Substring(0, index)), 3);
                        uint x = uint.Parse(p.Substring(index + 1), NumberStyles.HexNumber);

                        if (tx_carrier_cal.ContainsKey(freq))
                            tx_carrier_cal[freq] = x;
                        else
                            tx_carrier_cal.Add(freq, x);
                    }
                }
                else if (name.StartsWith("pa_bias_table"))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = int.Parse(name.Substring(start, length));

                    string[] list = val.Split('|');
                    for (int i = 0; i < 8 && i < list.Length; i++)
                        pa_bias_table[index][i] = int.Parse(list[i]);

                    if (fwc_init && index == 0 &&
                        (current_model == Model.FLEX5000 || current_model == Model.FLEX3000))
                    {
                        if (flex5000DebugForm != null && !flex5000DebugForm.IsDisposed)
                        {
                            for (int i = 0; i < 8; i++)
                                flex5000DebugForm.SetPAPot(i, (byte)pa_bias_table[index][i]);
                        }
                    }
                }
                else if (name.StartsWith("rx1_level_table"))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = int.Parse(name.Substring(start, length));

                    string[] list = val.Split('|');
                    for (int i = 0; i < 3; i++)
                        rx1_level_table[index][i] = (float)Math.Round(float.Parse(list[i]), 3);
                }
                else if (name.StartsWith("rx2_level_table"))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = int.Parse(name.Substring(start, length));

                    string[] list = val.Split('|');
                    for (int i = 0; i < 3; i++)
                        rx2_level_table[index][i] = (float)Math.Round(float.Parse(list[i]), 3);
                }
                else if (name.StartsWith("pa_bridge_table"))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = int.Parse(name.Substring(start, length));

                    string[] list = val.Split('|');
                    for (int i = 0; i < 6; i++)
                        pa_bridge_table[index][i] = (float)Math.Round(float.Parse(list[i]), 4);
                }
                else if (name.StartsWith("swr_table"))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = int.Parse(name.Substring(start, length));

                    swr_table[index] = (float)Math.Round(float.Parse(val), 4);
                }
                else if (name.StartsWith("atu_swr_table"))
                {
                    int start = name.IndexOf("[") + 1;
                    int length = name.IndexOf("]") - start;
                    int index = int.Parse(name.Substring(start, length));

                    atu_swr_table[index] = (float)Math.Round(float.Parse(val), 4);
                }
                else if (name.StartsWith("vhf_level_table"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < 2; i++)
                        vhf_level_table[i] = float.Parse(list[i]);
                }
                else if (name.StartsWith("uhf_level_table"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < 2; i++)
                        uhf_level_table[i] = float.Parse(list[i]);
                }
                else if (name.StartsWith("rx1_ant_by_band"))  // ke9ns when you add bands, you need to add more values inside xml
                {
                    string[] list = val.Split('|');


                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length) // ke9ns add to prevent index out of bounds
                        {
                            rx1_ant_by_band[i] = (FWCAnt)int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("tx_ant_by_band")) // ke9ns add .205
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx_ant_by_band[i] = (FWCAnt)int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short2");
                    }
                }
                else if (name.StartsWith("rx2_ant_by_band"))
                {
                    string[] list = val.Split('|');

                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            rx2_ant_by_band[i] = (FWCAnt)int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("tx_ant_by2_band")) // ke9ns add .205
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx_ant_by2_band[i] = (FWCAnt)int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short2");
                    }
                }
                else if (name.StartsWith("rx_ant_1500_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            rx_ant_1500_by_band[i] = (HIDAnt)int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("tx_ant_1500_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx_ant_1500_by_band[i] = (HIDAnt)int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("rx1_loop_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            rx1_loop_by_band[i] = Convert.ToBoolean(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("rx1_preamp_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            rx1_preamp_by_band[i] = (PreampMode)(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");

                        if (rx1_preamp_by_band[i] == PreampMode.FIRST) rx1_preamp_by_band[i] = PreampMode.OFF;
                    }
                }
                else if (name.StartsWith("rx2_preamp_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            rx2_preamp_by_band[i] = (PreampMode)(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("power_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            power_by_band[i] = int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short");
                    }
                }

                //========================================================
                else if (name.StartsWith("power_by_mode_by_band")) // ke9ns add
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        for (int ii = 0; ii < (int)DSPMode.LAST; ii++)
                        {
                            if (((i * (int)DSPMode.LAST) + ii) < list.Length)
                            {
                                power_by_mode_by_band[i, ii] = int.Parse(list[(i * (int)DSPMode.LAST) + ii]); // (i * dspmode.last)+ii
                            }
                            else Debug.WriteLine("index short");
                        }
                    }
                }
                //========================================================
                else if (name.StartsWith("limit_by_mode_by_band")) // ke9ns add
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        for (int ii = 0; ii < (int)DSPMode.LAST; ii++)
                        {
                            if (((i * (int)DSPMode.LAST) + ii) < list.Length)
                            {
                                limit_by_mode_by_band[i, ii] = int.Parse(list[(i * (int)DSPMode.LAST) + ii]); // 
                            }
                            else Debug.WriteLine("index short");
                        }
                    }
                }
                else if (name.StartsWith("fm_tx_offset_by_band_mhz"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            fm_tx_offset_by_band_mhz[i] = double.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("rx1_agct_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            rx1_agct_by_band[i] = int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("rx2_agct_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            rx2_agct_by_band[i] = int.Parse(list[i]);
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("tx1_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx1_by_band[i] = Convert.ToBoolean(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("tx2_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx2_by_band[i] = Convert.ToBoolean(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("tx3_by_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx3_by_band[i] = Convert.ToBoolean(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");
                    }
                }

                else if (name.StartsWith("tx1_by2_band")) // ke9ns add .206
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx1_by2_band[i] = Convert.ToBoolean(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("tx2_by2_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx2_by2_band[i] = Convert.ToBoolean(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");
                    }
                }
                else if (name.StartsWith("tx3_by2_band"))
                {
                    string[] list = val.Split('|');
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        if (i < list.Length)
                        {
                            tx3_by2_band[i] = Convert.ToBoolean(int.Parse(list[i]));
                        }
                        else Debug.WriteLine("index short");
                    }
                }


                switch (name)
                {
                    case "rx2_res_offset":
                        rx2_res_offset = float.Parse(val);
                        break;
                    case "current_ant_mode":
                        current_ant_mode = (AntMode)int.Parse(val);
                        break;
                    /*case "rx1_ant":
						rx1_ant = (FWCAnt)int.Parse(val);
						break;
					case "rx1_loop":
						rx1_loop = bool.Parse(val);
						break;
					case "rx2_ant":
						rx2_ant = (FWCAnt)int.Parse(val);
						break;
					case "tx_ant":
						tx_ant = (FWCAnt)int.Parse(val);
						break;*/
                    case "fwc_preamp_offset":
                        fwc_preamp_offset = float.Parse(val);
                        break;
                    case "fwc_last_cal_date_time":
                        fwc_last_cal_date_time = long.Parse(val);
                        break;
                    case "hid_last_cal_date_time":
                        hid_last_cal_date_time = long.Parse(val);
                        break;
                    case "fwc_serial_num":
                        fwc_serial_num = uint.Parse(val);
                        break;
                    case "hid_serial_num":
                        hid_serial_num = uint.Parse(val);
                        break;
                    case "fwc_trx_serial_num":
                        fwc_trx_serial_num = uint.Parse(val);
                        break;
                    case "hid_trx_serial_num":
                        hid_trx_serial_num = uint.Parse(val);
                        break;
                    case "rx2_last_cal_date_time":
                        rx2_last_cal_date_time = long.Parse(val);
                        break;
                    case "rx2_serial_num":
                        rx2_serial_num = uint.Parse(val);
                        break;
                    case "rx2_trx_match_serial":
                        rx2_trx_match_serial = uint.Parse(val);
                        break;
                    case "rx2_fixed_gain":
                        rx2_fixed_gain = int.Parse(val);
                        break;
                    case "rx2_max_gain":
                        rx2_max_gain = int.Parse(val);
                        break;



                    case "band_160m_index":
                        band_160m_index = Int32.Parse(val);
                        break;
                    case "band_80m_index":
                        band_80m_index = Int32.Parse(val);
                        break;
                    case "band_60m_index":
                        band_60m_index = Int32.Parse(val);
                        break;
                    case "band_40m_index":
                        band_40m_index = Int32.Parse(val);
                        break;
                    case "band_30m_index":
                        band_30m_index = Int32.Parse(val);
                        break;
                    case "band_20m_index":
                        band_20m_index = Int32.Parse(val);
                        break;
                    case "band_17m_index":
                        band_17m_index = Int32.Parse(val);
                        break;
                    case "band_15m_index":
                        band_15m_index = Int32.Parse(val);
                        break;
                    case "band_12m_index":
                        band_12m_index = Int32.Parse(val);
                        break;
                    case "band_10m_index":
                        band_10m_index = Int32.Parse(val);
                        break;
                    case "band_6m_index":
                        band_6m_index = Int32.Parse(val);
                        break;
                    case "band_2m_index":
                        band_2m_index = Int32.Parse(val);
                        break;
                    case "band_wwv_index":
                        band_wwv_index = Int32.Parse(val);
                        break;
                    case "band_gen_index":
                        band_gen_index = Int32.Parse(val);
                        break;


                    case "band_LMF_index":                     // ke9ns add
                        band_LMF_index = Int32.Parse(val);
                        break;
                    case "band_120m_index":
                        band_120m_index = Int32.Parse(val);
                        break;
                    case "band_90m_index":
                        band_90m_index = Int32.Parse(val);
                        break;
                    case "band_61m_index":
                        band_61m_index = Int32.Parse(val);
                        break;
                    case "band_49m_index":
                        band_49m_index = Int32.Parse(val);
                        break;
                    case "band_41m_index":
                        band_41m_index = Int32.Parse(val);
                        break;
                    case "band_31m_index":
                        band_31m_index = Int32.Parse(val);
                        break;
                    case "band_25m_index":
                        band_25m_index = Int32.Parse(val);
                        break;
                    case "band_22m_index":
                        band_22m_index = Int32.Parse(val);
                        break;
                    case "band_19m_index":
                        band_19m_index = Int32.Parse(val);
                        break;
                    case "band_16m_index":
                        band_16m_index = Int32.Parse(val);
                        break;
                    case "band_14m_index":
                        band_14m_index = Int32.Parse(val);
                        break;
                    case "band_13m_index":
                        band_13m_index = Int32.Parse(val);
                        break;
                    case "band_11m_index":
                        band_11m_index = Int32.Parse(val);
                        break;

                    case "band_vhf0_index":
                        band_vhf0_index = Int32.Parse(val);
                        break;
                    case "band_vhf1_index":
                        band_vhf1_index = Int32.Parse(val);
                        break;
                    case "band_vhf2_index":
                        band_vhf2_index = Int32.Parse(val);
                        break;
                    case "band_vhf3_index":
                        band_vhf3_index = Int32.Parse(val);
                        break;
                    case "band_vhf4_index":
                        band_vhf4_index = Int32.Parse(val);
                        break;
                    case "band_vhf5_index":
                        band_vhf5_index = Int32.Parse(val);
                        break;
                    case "band_vhf6_index":
                        band_vhf6_index = Int32.Parse(val);
                        break;
                    case "band_vhf7_index":
                        band_vhf7_index = Int32.Parse(val);
                        break;
                    case "band_vhf8_index":
                        band_vhf8_index = Int32.Parse(val);
                        break;
                    case "band_vhf9_index":
                        band_vhf9_index = Int32.Parse(val);
                        break;
                    case "band_vhf10_index":
                        band_vhf10_index = Int32.Parse(val);
                        break;
                    case "band_vhf11_index":
                        band_vhf11_index = Int32.Parse(val);
                        break;
                    case "band_vhf12_index":
                        band_vhf12_index = Int32.Parse(val);
                        break;
                    case "band_vhf13_index":
                        band_vhf13_index = Int32.Parse(val);
                        break;


                    case "current_datetime_mode":
                        CurrentDateTimeMode = (DateTimeMode)(Int32.Parse(val));
                        break;
                    case "wheel_tune_index":
                        tune_step_index = Int32.Parse(val);
                        break;
                    case "txtMemoryQuick":
                        txtMemoryQuick.Text = val;
                        break;
                    case "rx1_display_cal_offset":
                        RX1DisplayCalOffset = float.Parse(val);
                        break;
                    case "rx1_meter_cal_offset":
                        rx1_meter_cal_offset = float.Parse(val);
                        break;
                    case "quick_save_mode":
                        quick_save_mode = (DSPMode)(Int32.Parse(val));
                        break;
                    case "quick_save_filter":
                        quick_save_filter = (Filter)(Int32.Parse(val));
                        break;
                    case "vfob_dsp_mode":
                        vfob_dsp_mode = (DSPMode)(Int32.Parse(val));
                        break;
                    case "vfob_filter":
                        vfob_filter = (Filter)(Int32.Parse(val));
                        break;
                  
                    case "console_top":
                        num = Int32.Parse(val);
                        CONSOLET = num;

                        this.Top = num;
                        Debug.WriteLine("TOPP" + num);

                        break;
                    case "console_left":
                        num = Int32.Parse(val);

                        CONSOLEL = num;
                        this.Left = num;
                        Debug.WriteLine("LEFTT" + num);

                        break;
                    case "console_width":

                       // if (dpi <= 96)
                               this.Width = CONSOLEW = int.Parse(val);
                        Debug.WriteLine("WIDTHH" + val);

                        break;
                    case "console_height":

                       // if (dpi <= 96) 
                        this.Height = CONSOLEH = int.Parse(val);
                        Debug.WriteLine("HEIGHTT" + val);

                        break;
                    case "console_zaximize":  //   a.Add("console_zaximize/" +this.WindowState.ToString()); // ke9ns add: for maximum form size detection _z so it loads after the top -8 and left 1912 settings

                        if (val == "Maximized")
                        {
                            CONSOLEM = true;
                            //  this.WindowState = FormWindowState.Maximized;
                           // this.WindowState = FormWindowState.Normal;
                            Debug.WriteLine("MAXIMUM1");
                        }
                        break;
                    case "setup_top":
                        num = Int32.Parse(val);
                        /*if((num < 0) || (num > Screen.PrimaryScreen.Bounds.Height && Screen.AllScreens.Length == 1))
							num = 0;*/
                        setupForm.Top = num;
                        break;
                    case "setup_left":
                        num = Int32.Parse(val);
                        /*if((num < 0) || (num > Screen.PrimaryScreen.Bounds.Width && Screen.AllScreens.Length == 1))
							num = 0;*/
                        setupForm.Left = num;
                        break;
                    case "SetupWizard":
                        if (val == "1")
                            run_setup_wizard = false;
                        break;
                    case "show_alpha_warning":
                        show_alpha_warning = bool.Parse(val);
                        break;
                    case "show_beta_warning":
                        show_beta_warning = bool.Parse(val);
                        break;
                    case "show_mobile_warning":
                        show_mobile_warning = bool.Parse(val);
                        break;
                    case "rx1_image_gain_table":
                        string[] list = val.Split('|');
                        for (int i = 0; i <= (int)Band.B6M && i < list.Length; i++)
                            rx1_image_gain_table[i] = float.Parse(list[i]);
                        break;
                    case "rx1_image_phase_table":
                        list = val.Split('|');
                        for (int i = 0; i <= (int)Band.B6M && i < list.Length; i++)
                            rx1_image_phase_table[i] = float.Parse(list[i]);
                        break;
                    case "rx2_image_gain_table":
                        list = val.Split('|');
                        for (int i = 0; i <= (int)Band.B6M && i < list.Length; i++)
                            rx2_image_gain_table[i] = float.Parse(list[i]);
                        break;
                    case "rx2_image_phase_table":
                        list = val.Split('|');
                        for (int i = 0; i <= (int)Band.B6M && i < list.Length; i++)
                            rx2_image_phase_table[i] = float.Parse(list[i]);
                        break;
                    case "tx_image_gain_table":
                        list = val.Split('|');
                        for (int i = 0; i <= (int)Band.B6M && i < list.Length; i++)
                            tx_image_gain_table[i] = float.Parse(list[i]);
                        break;
                    case "tx_image_phase_table":
                        list = val.Split('|');
                        for (int i = 0; i <= (int)Band.B6M && i < list.Length; i++)
                            tx_image_phase_table[i] = float.Parse(list[i]);
                        break;
                    case "rx1_level_checksum":
                        rx1_level_checksum = byte.Parse(val);
                        break;
                    case "rx1_image_gain_checksum":
                        rx1_image_gain_checksum = byte.Parse(val);
                        break;
                    case "rx1_image_phase_checksum":
                        rx1_image_phase_checksum = byte.Parse(val);
                        break;
                    case "tx_image_gain_checksum":
                        tx_image_gain_checksum = byte.Parse(val);
                        break;
                    case "tx_image_phase_checksum":
                        tx_image_phase_checksum = byte.Parse(val);
                        break;
                    case "tx_carrier_checksum":
                        tx_carrier_checksum = byte.Parse(val);
                        break;
                    case "pa_bias_checksum":
                        pa_bias_checksum = byte.Parse(val);
                        break;
                    case "pa_bridge_checksum":
                        pa_bridge_checksum = byte.Parse(val);
                        break;
                    case "pa_power_checksum":
                        pa_power_checksum = byte.Parse(val);
                        break;
                    case "pa_swr_checksum":
                        pa_swr_checksum = byte.Parse(val);
                        break;
                    case "atu_swr_checksum":
                        atu_swr_checksum = byte.Parse(val);
                        break;
                    case "rx2_level_checksum":
                        rx2_level_checksum = byte.Parse(val);
                        break;
                    case "rx2_image_gain_checksum":
                        rx2_image_gain_checksum = byte.Parse(val);
                        break;
                    case "rx2_image_phase_checksum":
                        rx2_image_phase_checksum = byte.Parse(val);
                        break;
                    case "saved_rx_only":
                        saved_rx_only = bool.Parse(val);
                        break;
                    case "mon_recall":
                        mon_recall = bool.Parse(val);
                        break;
                    case "rx1_squelch_on":
                        rx1_squelch_on = bool.Parse(val);
                        break;
                    case "rx1_squelch_threshold_scroll":
                        rx1_squelch_threshold_scroll = int.Parse(val);
                        break;
                    case "rx1_fm_squelch_threshold_scroll":
                        rx1_fm_squelch_threshold_scroll = int.Parse(val);
                        break;
                    case "rx2_squelch_on":
                        rx1_squelch_on = bool.Parse(val);
                        break;
                    case "rx2_squelch_threshold_scroll":
                        rx2_squelch_threshold_scroll = int.Parse(val);
                        break;
                    case "rx2_fm_squelch_threshold_scroll":
                        rx2_fm_squelch_threshold_scroll = int.Parse(val);
                        break;
                    case "current_flex_control_mode":
                        current_flexcontrol_mode = (FlexControlMode)Enum.Parse(typeof(FlexControlMode), val);
                        break;
                    case "flexcontrol_autodetect":
                        flexcontrol_autodetect = bool.Parse(val);
                        break;

                    case "waterfall_high_threshold_160m":
                        waterfall_high_threshold_160m = float.Parse(val);   // ke9ns: GET value from database
                        break;
                    case "waterfall_low_threshold_160m":
                        waterfall_low_threshold_160m = float.Parse(val);
                        waterfall_lowRX2_threshold_160m = float.Parse(val); // 
                        break;
                    case "waterfall_high_threshold_80m":
                        waterfall_high_threshold_80m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_80m":
                        waterfall_low_threshold_80m = float.Parse(val);
                        waterfall_lowRX2_threshold_80m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_60m":
                        waterfall_high_threshold_60m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_60m":
                        waterfall_low_threshold_60m = float.Parse(val);
                        waterfall_lowRX2_threshold_60m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_40m":
                        waterfall_high_threshold_40m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_40m":
                        waterfall_low_threshold_40m = float.Parse(val);
                        waterfall_lowRX2_threshold_40m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_30m":
                        waterfall_high_threshold_30m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_30m":
                        waterfall_low_threshold_30m = float.Parse(val);
                        waterfall_lowRX2_threshold_30m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_20m":
                        waterfall_high_threshold_20m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_20m":
                        waterfall_low_threshold_20m = float.Parse(val);
                        waterfall_lowRX2_threshold_40m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_17m":
                        waterfall_high_threshold_17m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_17m":
                        waterfall_low_threshold_17m = float.Parse(val);
                        waterfall_lowRX2_threshold_17m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_15m":
                        waterfall_high_threshold_15m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_15m":
                        waterfall_low_threshold_15m = float.Parse(val);
                        waterfall_lowRX2_threshold_15m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_12m":
                        waterfall_high_threshold_12m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_12m":
                        waterfall_low_threshold_12m = float.Parse(val);
                        waterfall_lowRX2_threshold_12m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_10m":
                        waterfall_high_threshold_10m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_10m":
                        waterfall_low_threshold_10m = float.Parse(val);
                        waterfall_lowRX2_threshold_10m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_6m":
                        waterfall_high_threshold_6m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_6m":
                        waterfall_low_threshold_6m = float.Parse(val);
                        waterfall_lowRX2_threshold_6m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_wwv":
                        waterfall_high_threshold_wwv = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_wwv":
                        waterfall_low_threshold_wwv = float.Parse(val);
                        waterfall_lowRX2_threshold_wwv = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_gen":
                        waterfall_high_threshold_gen = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_gen":
                        waterfall_low_threshold_gen = float.Parse(val);
                        waterfall_lowRX2_threshold_gen = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_xvtr":
                        waterfall_high_threshold_xvtr = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_xvtr":
                        waterfall_low_threshold_xvtr = float.Parse(val);
                        waterfall_lowRX2_threshold_xvtr = float.Parse(val);
                        break;


                    case "waterfall_high_threshold_LMF":
                        waterfall_high_threshold_LMF = float.Parse(val);   // ke9ns: GET SWL value from database
                        break;
                    case "waterfall_low_threshold_LMF":
                        waterfall_low_threshold_LMF = float.Parse(val);
                        waterfall_lowRX2_threshold_LMF = float.Parse(val); // 
                        break;
                    case "waterfall_high_threshold_120m":
                        waterfall_high_threshold_120m = float.Parse(val);   // ke9ns: GET SWL value from database
                        break;
                    case "waterfall_low_threshold_120m":
                        waterfall_low_threshold_120m = float.Parse(val);
                        waterfall_lowRX2_threshold_120m = float.Parse(val); // 
                        break;
                    case "waterfall_high_threshold_90m":
                        waterfall_high_threshold_90m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_90m":
                        waterfall_low_threshold_90m = float.Parse(val);
                        waterfall_lowRX2_threshold_90m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_61m":
                        waterfall_high_threshold_61m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_61m":
                        waterfall_low_threshold_61m = float.Parse(val);
                        waterfall_lowRX2_threshold_61m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_49m":
                        waterfall_high_threshold_49m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_49m":
                        waterfall_low_threshold_49m = float.Parse(val);
                        waterfall_lowRX2_threshold_49m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_41m":
                        waterfall_high_threshold_41m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_41m":
                        waterfall_low_threshold_41m = float.Parse(val);
                        waterfall_lowRX2_threshold_41m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_31m":
                        waterfall_high_threshold_31m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_31m":
                        waterfall_low_threshold_31m = float.Parse(val);
                        waterfall_lowRX2_threshold_31m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_25m":
                        waterfall_high_threshold_25m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_25m":
                        waterfall_low_threshold_25m = float.Parse(val);
                        waterfall_lowRX2_threshold_25m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_22m":
                        waterfall_high_threshold_22m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_22m":
                        waterfall_low_threshold_22m = float.Parse(val);
                        waterfall_lowRX2_threshold_22m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_19m":
                        waterfall_high_threshold_19m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_19m":
                        waterfall_low_threshold_19m = float.Parse(val);
                        waterfall_lowRX2_threshold_19m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_16m":
                        waterfall_high_threshold_16m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_16m":
                        waterfall_low_threshold_16m = float.Parse(val);
                        waterfall_lowRX2_threshold_16m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_14m":
                        waterfall_high_threshold_14m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_14m":
                        waterfall_low_threshold_14m = float.Parse(val);
                        waterfall_lowRX2_threshold_14m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_13m":
                        waterfall_high_threshold_13m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_13m":
                        waterfall_low_threshold_13m = float.Parse(val);
                        waterfall_lowRX2_threshold_13m = float.Parse(val);
                        break;
                    case "waterfall_high_threshold_11m":
                        waterfall_high_threshold_11m = float.Parse(val);
                        break;
                    case "waterfall_low_threshold_11m":
                        waterfall_low_threshold_11m = float.Parse(val);
                        waterfall_lowRX2_threshold_11m = float.Parse(val);
                        break;


                    case "waterfall_update_period":
                        waterfall_update_period = int.Parse(val);
                        Display.WaterfallUpdatePeriod = waterfall_update_period;
                        break;
                    case "lsb_txprofile":
                        lsb_txprofile = val;
                        break;
                    case "usb_txprofile":
                        usb_txprofile = val;
                        break;
                    case "dsb_txprofile":
                        dsb_txprofile = val;
                        break;
                    case "cwl_txprofile":
                        cwl_txprofile = val;
                        break;
                    case "cwu_txprofile":
                        cwu_txprofile = val;
                        break;
                    case "fm_txprofile":
                        fm_txprofile = val;
                        break;
                    case "am_txprofile":
                        am_txprofile = val;
                        break;
                    case "sam_txprofile":
                        sam_txprofile = val;
                        break;
                    case "spec_txprofile":
                        spec_txprofile = val;
                        break;
                    case "digu_txprofile":
                        digu_txprofile = val;
                        break;
                    case "digl_txprofile":
                        digl_txprofile = val;
                        break;
                    case "drm_txprofile":
                        drm_txprofile = val;
                        break;
                }
            } // foreach item in the XML file here get items with state in name




            //==============================================================================================================================
            // restore saved values to the controls
            foreach (string s in a)             // string is in the format "name,value"
            {
                string[] vals = s.Split('/');
                string name = vals[0];
                string val = vals[1];

                if (s.StartsWith("chk"))            // control is a CheckBox
                {
                    for (int i = 0; i < checkbox_list.Count; i++)
                    {   // look through each control to find the matching name
                        CheckBoxTS c = (CheckBoxTS)checkbox_list[i];
                        if (c.Name.Equals(name))        // name found
                        {
                            c.Checked = bool.Parse(val);    // restore value
                            i = checkbox_list.Count + 1;
                        }
                        if (i == checkbox_list.Count)
                            MessageBox.Show(new Form { TopMost = true }, "Control not found: " + name, "GetState Error",
                                MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else if (s.StartsWith("combo")) // control is a ComboBox
                {
                    for (int i = 0; i < combobox_list.Count; i++)
                    {   // look through each control to find the matching name
                        ComboBoxTS c = (ComboBoxTS)combobox_list[i];
                        if (c.Name.Equals(name))        // name found
                        {
                            c.Text = val;   // restore value
                            i = combobox_list.Count + 1;
                        }
                        if (i == combobox_list.Count)
                            MessageBox.Show(new Form { TopMost = true }, "Control not found: " + name, "GetState Error",
                                MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else if (s.StartsWith("ud"))
                {
                    for (int i = 0; i < numericupdown_list.Count; i++)
                    {   // look through each control to find the matching name
                        NumericUpDownTS c = (NumericUpDownTS)numericupdown_list[i];
                        if (c.Name.Equals(name))        // name found
                        {
                            decimal num = decimal.Parse(val);

                            if (num > c.Maximum) num = c.Maximum;       // check endpoints
                            else if (num < c.Minimum) num = c.Minimum;
                            c.Value = num;          // restore value
                            i = numericupdown_list.Count + 1;
                        }
                        if (i == numericupdown_list.Count)
                            MessageBox.Show(new Form { TopMost = true }, "Control not found: " + name, "GetState Error",
                                MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else if (s.StartsWith("rad"))
                {   // look through each control to find the matching name
                    for (int i = 0; i < radiobutton_list.Count; i++)
                    {
                        RadioButtonTS c = (RadioButtonTS)radiobutton_list[i];
                        if (c.Name.Equals(name))        // name found
                        {
                            if (!val.ToLower().Equals("true") && !val.ToLower().Equals("false"))
                                val = "True";
                            c.Checked = bool.Parse(val);    // restore value
                            i = radiobutton_list.Count + 1;
                        }
                        if (i == radiobutton_list.Count)
                            MessageBox.Show(new Form { TopMost = true }, "Control not found: " + name, "GetState Error",
                                MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else if (s.StartsWith("txt")) // .186
                {   // look through each control to find the matching name
                    for (int i = 0; i < textbox_list.Count; i++)
                    {
                        TextBoxTS c = (TextBoxTS)textbox_list[i];
                        if (c.Name.Equals(name))        // name found
                        {
                            c.Text = val;   // restore value
                            i = textbox_list.Count + 1;
                        }
                        if (i == textbox_list.Count)
                            MessageBox.Show(new Form { TopMost = true }, "Control not found: " + name, "GetState Error",
                                MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
               

                else if (s.StartsWith("tb"))
                {
                    // look through each control to find the matching name
                    for (int i = 0; i < trackbar_list.Count; i++)
                    {
                        TrackBarTS c = (TrackBarTS)trackbar_list[i];
                        if (c.Name.Equals(name))        // name found
                        {
                            c.Value = Int32.Parse(val);
                            i = trackbar_list.Count + 1;
                        }
                        if (i == trackbar_list.Count)
                            MessageBox.Show(new Form { TopMost = true }, "Control not found: " + name, "GetState Error",
                                MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else if (s.StartsWith("ptb"))
                {
                    // look through each control to find the matching name
                    for (int i = 0; i < prettytrackbar_list.Count; i++)
                    {
                        PrettyTrackBar c = (PrettyTrackBar)prettytrackbar_list[i];
                        if (c.Name.Equals(name))		// name found
                        {
                            c.Value = Int32.Parse(val);
                            i = prettytrackbar_list.Count + 1;
                        }
                        if (i == prettytrackbar_list.Count)
                            MessageBox.Show(new Form { TopMost = true }, "Control not found: " + name, "GetState Error",
                                MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }

            } // foreach


            Common.ForceFormOnScreen(this);
            Common.ForceFormOnScreen(setupForm);

            tempVFOAFreq = VFOAFreq; // ke9ns add get CTUN ready quickly




        } // getstate

        private string VerToString(uint ver)
        {
            string s = "";
            s += ((byte)(ver >> 24)).ToString() + ".";
            s += ((byte)(ver >> 16)).ToString() + ".";
            s += ((byte)(ver >> 8)).ToString() + ".";
            s += ((byte)(ver >> 0)).ToString();
            return s;
        }

        private bool LessThan1GBRam()
        {
            bool ret = true;
            double installed_ram = 0;
            try
            {
                ObjectQuery objectQuery = new ObjectQuery("select * from Win32_PhysicalMemory");
                ManagementObjectSearcher searcher = new ManagementObjectSearcher(objectQuery);
                ManagementObjectCollection vals = searcher.Get();
                foreach (ManagementObject val in vals)
                {
                    installed_ram += System.Convert.ToDouble(val.GetPropertyValue("Capacity"));
                }
                if ((installed_ram / 1073741824) > 1) ret = false;
            }
            catch (Exception)
            {
                ret = false;
            }
            return ret;
        }

        //=============================================================
        // ke9ns add 01/04/17 From Eric
        // Firmware upate: Flex-5000 2017-01-04 2.1.4.4   Added 60m to several EU regions
        // Firmware upate: Flex-3000 2017-01-04 2.1.4.4   Added 60m to several EU regions
        // Firmware upate: Flex-1500 2017-01-04 0.5.3.13   Added 60m to several EU regions


        //========================================================================================
        // ke9ns add 05/08/17 From Eric and Tim to align with FRSRegions in SmartSDR
        // Firmware upate: Flex-5000 2017-05-07 2.1.4.5   
        // Firmware upate: Flex-3000 2017-05-07 2.1.4.5   
        // Firmware upate: Flex-1500 2017-05-07 0.5.3.14   

        //========================================================================================
        // ke9ns add 7/21/17 From Tim to align with FRSRegions in SmartSDR v2.0
        // Firmware upate: Flex-5000 2017-07-20 2.1.4.6   
        // Firmware upate: Flex-3000 2017-07-20 2.1.4.6   
        // Firmware upate: Flex-1500 2017-07-20 0.5.3.15   

        //========================================================================================
        // ke9ns add 9/6/17 From Tim to fix Aus 20m region
        // Firmware upate: Flex-5000 2017-07-20 2.1.4.7   
        // Firmware upate: Flex-3000 2017-07-20 2.1.4.7   
        // Firmware upate: Flex-1500 2017-07-20 0.5.3.16   

        //========================================================================================
        // ke9ns add 5/25/18 From Tim 
        // The following TURF change were made in SmartSDR v2.2.8
        //TURF: Modification to Belgium(EU04)
        //Belgium has increased the frequency allocations for the 160m band to 1.810 - 2.0

        //TURF: Modification to Netherlands(EU13)
        //The Netherlands have changed the frequency allocations for the 60m band to 5.351.5 to 5.366.5

        //TURF: add CDEMA(Caribbean Disaster Emergency Response Agency) frequencies to IARU 2 TURF
        //7.453.5 to 7.456.5MHz USB CDEMA Caribbean Disaster Emergency Response Agency
        //7.850 to 7.853MHz USB CDEMA Caribbean Disaster Emergency Response Agency
        //13.998 to 14.001MHz USB Caribbean Red Cross
        //14.415 to 14.418MHz USB CDEMA Caribbean Disaster Emergency Response Agency

        // Firmware upate: Flex-5000 2018-05-14 2.1.4.8   
        // Firmware upate: Flex-3000 2018-05-14 2.1.4.8   
        // Firmware upate: Flex-1500 2018-05-25 0.5.3.20   

        //========================================================================================
        // ke9ns add  11/8/2018  From Tim 
        //   v2.1.4.10 (2018-10-30)
        //   -Updated Hungary 40m increase, 60m add, Italy 60m add, and Belgium regions

        //    v2.1.4.9 (2018-05-30)
        //   -Added China region (same as IARU3 except for 60m tx)
        //  -Removed CB band in Russia (firmware only)

        // Firmware upate: Flex-5000 2017-07-20 2.1.4.10  
        // Firmware upate: Flex-3000 2017-07-20 2.1.4.10   
        // Firmware upate: Flex-1500 2017-07-20 0.5.3.22   

        //========================================================================================
        // ke9ns add 04/12/2019 From Tim
        // 

        // - expanded 12m for Norway
        // - Add 60m for Greece, EU Travel, France, Hungary
        // - Mod 40m for Hungary

        // Firmware upate: Flex-5000 2017-07-20 2.1.4.12  
        // Firmware upate: Flex-3000 2017-07-20 2.1.4.12   
        // Firmware upate: Flex-1500 2017-07-20 0.5.3.24   

        //========================================================================================



        private uint GetMinVersion(Model m)
        {
            uint MIN_VERSION = 0;
            switch (m)
            {
                case Model.FLEX5000: MIN_VERSION = 0x0201040c; break; // 0x0201040c = .12
                case Model.FLEX3000: MIN_VERSION = 0x0201040c; break; //  0x0201040c = .12
                case Model.FLEX1500: MIN_VERSION = 0x00050318; break;  //  0x00050318 = .24  EEPROM = 012d5-012d8


            }
            return MIN_VERSION;
        }

        private uint GetMaxVersion(Model m)
        {
            uint MAX_VERSION = 0;
            switch (m)
            {
                case Model.FLEX5000: MAX_VERSION = 0x0201FFFF; break;  // 0x0201FFFF
                case Model.FLEX3000: MAX_VERSION = 0x0201FFFF; break;  //  0x0201FFFF
                case Model.FLEX1500: MAX_VERSION = 0x0005FFFF; break;  // 0x0005FFFF
            }
            return MAX_VERSION;
        }

        private void InitRadio()
        {
            uint val;
            FWC.GetFirmwareRev(out val);

            if (val == 0)
            {
                Splash.HideForm();
                MessageBox.Show(new Form { TopMost = true }, "Error communicating with the radio.  Please reload PowerSDR to try again.\n" +
                    "Note that starting PowerSDR too quickly after powering on the radio can cause this problem.",
                    "Error: Radio Communication Problem",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                fwc_init = false;
                return;
            }

            uint MIN_VERSION = GetMinVersion(current_model);
            uint MAX_VERSION = GetMaxVersion(current_model);

            if (val < MIN_VERSION || val > MAX_VERSION) // revs outside of v2.1.*.*
            {
                Splash.HideForm();
                DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "A radio firmware update is required in order to continue.\n" +
                    "(Looked for v" + VerToString(MIN_VERSION) + " and found v" + VerToString(val) + ")\n\n" +
                    "Would you like to update your firmware now?\n" +
                    "If not, PowerSDR will be closed.",
                    "Update Firmware Now?",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question);

                if (dr == DialogResult.No)
                {
                    Process.GetCurrentProcess().Kill(); // program ends here
                    return; // this is just for code clarity
                }

                Application.DoEvents(); // clear the dialog sooner

                LoadFWCFirmware(VerToString(MIN_VERSION));
            }

            FWC.Initialize();
            FWC.SetTRXPreamp(false);

            if (current_model == Model.FLEX3000) FWC.SetRXAttn(false);

        } // InitRadio();

        private void InitFLEX1500()
        {
            if (!hid_init || current_model != Model.FLEX1500) return;
            uint val;
            USBHID.GetFirmwareRev(out val);
            if (val == 0)
            {
                Splash.HideForm();
                MessageBox.Show(new Form { TopMost = true }, "Error communicating with the radio.  Please reload PowerSDR to try again.",
                    "Error: Radio Communication Problem",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                hid_init = false;
                return;
            }

            uint MIN_VERSION = GetMinVersion(current_model);
            uint MAX_VERSION = GetMaxVersion(current_model);
            if (val < MIN_VERSION || val > MAX_VERSION)
            {
                Splash.HideForm();
                DialogResult dr = MessageBox.Show(
                    "A radio firmware update is required in order to continue.\n" +
                    "(Looked for v" + VerToString(MIN_VERSION) + " and found v" + VerToString(val) + ")\n\n" +
                    "Would you like to update your firmware now?\n" +
                    "If not, PowerSDR will be closed.",
                    "Update Firmware Now?",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question);

                if (dr == DialogResult.No)
                {
                    Process.GetCurrentProcess().Kill();
                    return;
                }

                Application.DoEvents(); // clear the dialog sooner

                Load1500Firmware(VerToString(MIN_VERSION));
                USBHID.Initialize();
                USBHID.SetPreamp(FLEX1500PreampMode.ZERO);
                //USBHID.WriteI2C2Value(0x30, 0x0C, 0x50);
            }
        }

        private void LoadFWCFirmware(string version)
        {
            // load firmware image
            string path = Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData)
                + "\\FlexRadio Systems\\FLEX Firmware\\";

            string file_name = path;
            switch (current_model)
            {
                case Model.FLEX5000: file_name = path + "FLEX-5000\\FLEX-5000_Firmware_v"; break;
                case Model.FLEX3000: file_name = path + "FLEX-3000\\FLEX-3000_Firmware_v"; break;
            }

            file_name += version + ".bin";

            if (!File.Exists(file_name))
            {
                DialogResult dr = MessageBox.Show(
                    "Unable to locate the firmware file in the default location.\n" +
                    "Would you like to try to locate the file manually?\n" +
                    "Otherwise, the application will close.\n\n" +
                    "(Default Path: " + file_name + ")",
                    "Try to locate file?",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question);

                if (dr == DialogResult.No)
                    Process.GetCurrentProcess().Kill();

                OpenFileDialog dialog = new OpenFileDialog();
                dialog.Filter = "Firmware files (*.bin)|*.bin|All files (*.*)|*.*";
                dialog.Multiselect = false;
                dialog.InitialDirectory = file_name.Substring(0, file_name.LastIndexOf("\\") + 1);
                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    file_name = dialog.FileName;
                }

                if (!File.Exists(file_name))
                {
                    MessageBox.Show(new Form { TopMost = true }, "File not chosen.  The program will now close");
                    Process.GetCurrentProcess().Kill();
                    return; // this is just for code clarity
                }
            }

            string tool_path = path + "tool.exe";

            if (!File.Exists(tool_path))
            {
                MessageBox.Show(new Form { TopMost = true }, "Firmware Update tool not found.  Please contact support.\n\n" +
                    "(Looked in " + tool_path + ")",
                    "Error: Update Tool Not Found",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                Process.GetCurrentProcess().Kill();
                return;
            }

            ProcessStartInfo proc_info = new ProcessStartInfo();
            proc_info.FileName = tool_path;
            proc_info.Arguments = "\"dfu" + file_name + "\"";
            proc_info.CreateNoWindow = true;
            proc_info.UseShellExecute = false;
            proc_info.RedirectStandardOutput = true;
            proc_info.WindowStyle = ProcessWindowStyle.Hidden;

            Progress p = new Progress("Firmware Update");
            p.PercentDigits = 0;
            p.SetPercent(0.0f);
            p.Show();
            p.Focus();
            Application.DoEvents();

            using (Process proc = Process.Start(proc_info))
            {
                StreamReader reader = proc.StandardOutput;
                string result = "";
                while ((result = reader.ReadLine()) != null)
                {
                    if (result.Contains("Uploading Binary"))
                    {
                        int start = result.IndexOf(":") + 1;
                        int end = result.IndexOf("%");
                        int progress = int.Parse(result.Substring(start, end - start));
                        p.SetPercent(progress / 100.0f * 0.33f);
                        Application.DoEvents();
                    }
                    else if (result.Contains("Programing Flash Image"))
                    {
                        int start = result.IndexOf(":") + 1;
                        int end = result.IndexOf("%");
                        int progress = int.Parse(result.Substring(start, end - start));
                        p.SetPercent(0.33f + progress / 100.0f * 0.67f);
                        Application.DoEvents();
                    }
                }
            }

            Thread.Sleep(3000); // wait for radio to reboot

            p.Hide();
            Application.DoEvents();

            MessageBox.Show(new Form { TopMost = true }, "Update complete.  The program will now close.\n" +
                         "Please restart PowerSDR to continue.",
                         "Restart Required",
                         MessageBoxButtons.OK,
                         MessageBoxIcon.Information);

            Process.GetCurrentProcess().Kill();
            return; // this is just for code clarity


            /*Thread.Sleep(2000); // wait for computer to redetect

            if (radio_to_use == null) return;

            // reinitialize Pal interface
            Pal.Exit();
            Pal.Init();
            Thread.Sleep(2000);

            // check that new version is within acceptable range
            uint val;
            FWC.GetFirmwareRev(out val);
            if (val < GetMinVersion(current_model) || val > GetMaxVersion(current_model))
            {
                MessageBox.Show(new Form { TopMost = true }, "The firmware revision chosen does not meet the requirements of this\n"+
                    "version of PowerSDR.  Please obtain firmware v" + version + " and try again.",
                    "Error: Firmware Revision",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                Process.GetCurrentProcess().Kill();
                return;
            }*/
        }

        private void Load1500Firmware(string version)
        {
            string file_name = Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData) +
                    "\\FlexRadio Systems\\FLEX Firmware\\FLEX-1500\\FLEX-1500_Firmware_v" + version + ".bin";

            if (!File.Exists(file_name))
            {
                DialogResult dr = MessageBox.Show(
                    "Unable to locate the firmware file in the default location.\n" +
                    "Would you like to try to locate the file manually?\n" +
                    "Otherwise, the application will close.\n\n" +
                    "(Default Path: " + file_name,
                    "Try to locate file?",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question);

                if (dr == DialogResult.No)
                    Process.GetCurrentProcess().Kill();

                OpenFileDialog dialog = new OpenFileDialog();
                dialog.Filter = "Firmware files (*.bin)|*.bin|All files (*.*)|*.*";
                dialog.Multiselect = false;
                dialog.InitialDirectory = file_name.Substring(0, file_name.LastIndexOf("\\") + 1);
                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    file_name = dialog.FileName;
                }

                if (!File.Exists(file_name))
                {
                    MessageBox.Show(new Form { TopMost = true }, "File not chosen.  The program will now close");
                    Process.GetCurrentProcess().Kill();
                }
            }

            FileStream fs = File.Open(file_name, FileMode.Open, FileAccess.Read);
            BinaryReader reader = new BinaryReader(fs);

            int total_writes = (int)Math.Ceiling(fs.Length / 32.0);
            int write_count = 0;

            byte[] data = new byte[32];
            byte[] check = new byte[32];
            ushort offset = 0;
            bool eof = false;

            Progress p = new Progress("Firmware Update");
            p.PercentDigits = 0;
            p.SetPercent(0.0f);
            p.Show();
            p.Focus();
            Application.DoEvents();

            do
            {
                int num_read = reader.Read(data, 0, 32);
                bool validated = true;
                int count = 0;

                if (num_read == 0) break;
                do
                {
                    count++;
                    Flex1500.WriteEEPROM(offset, data);
                    Thread.Sleep(10);

                    Flex1500.ReadEEPROM(offset, (byte)num_read, out check);

                    validated = true;
                    for (int i = 0; i < num_read; i++)
                    {
                        if (check[i] != data[i])
                        {
                            validated = false;
                            break;
                        }
                    }
                }
                while (!validated && count < 10);

                if (count == 10)
                    MessageBox.Show(new Form { TopMost = true }, "Error writing firmware (0x" + offset.ToString("X").PadLeft(4, '0') + ")");

                offset += (ushort)num_read;
                eof = (num_read != 32);

                p.SetPercent(++write_count / (float)total_writes);
                Application.DoEvents();
            } while (!eof);

            p.Hide();
            Application.DoEvents();
            reader.Close();
            fs.Close();

            uint old_ver;
            USBHID.GetFirmwareRev(out old_ver);

            Thread.Sleep(500);
            Flex1500.StopListener(); // keep old object from causing problems

            // pause to allow reboot
            MessageBox.Show(new Form { TopMost = true }, "Please cycle power to the radio for the firmware change to take effect.",
                "Cycle Power",
                MessageBoxButtons.OK,
                MessageBoxIcon.Information);

            // reconnect the radio
            uint new_ver = old_ver;

            p.Text = "Cycle Radio Power...";
            p.SetPercent(0.0f);
            p.Show();
            p.Focus();
            Application.DoEvents();
            int wait_count = 0;

            // wait for radio to be powered off
            while (Flex1500.IsRadioPresent())
            {
                Thread.Sleep(1000);
                p.SetPercent(++wait_count / 60.0f);
                Application.DoEvents();
                if (wait_count > 60)
                {
                    p.Hide();
                    Application.DoEvents();
                    break;
                }
            }

            if (wait_count > 60) // timeout
            {
                MessageBox.Show(new Form { TopMost = true }, "Still waiting for radio power to be cycled...");
                p.SetPercent(0.0f);
                p.Show();
                p.Focus();
                wait_count = 0;

                while (Flex1500.IsRadioPresent())
                {
                    Thread.Sleep(1000);
                    p.SetPercent(++wait_count / 60.0f);
                    Application.DoEvents();
                    if (wait_count > 60)
                    {
                        p.Hide();
                        Application.DoEvents();
                        break;
                    }
                }

                if (wait_count > 60)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Detecting radio power cycle failed.  The program will now close.");
                    Process.GetCurrentProcess().Kill();
                }
            }

            // by here, the radio has at least detached.  Time to look for it again.
            p.SetPercent(0.0f);
            wait_count = 0;
            while (!Flex1500.SetActiveRadio(radio_to_use.SerialNumber))
            {
                Thread.Sleep(1000);
                p.SetPercent(++wait_count / 60.0f);
                Application.DoEvents();
                if (wait_count > 60)
                {
                    p.Hide();
                    Application.DoEvents();
                    break;
                }
            }

            if (wait_count > 60) // timeout
            {
                MessageBox.Show(new Form { TopMost = true }, "Still waiting for radio power to be cycled...");
                p.SetPercent(0.0f);
                p.Show();
                p.Focus();
                wait_count = 0;

                while (!Flex1500.SetActiveRadio(radio_to_use.SerialNumber))
                {
                    Thread.Sleep(1000);
                    p.SetPercent(++wait_count / 60.0f);
                    Application.DoEvents();
                    if (wait_count > 60)
                    {
                        p.Hide();
                        Application.DoEvents();
                        break;
                    }
                }

                if (wait_count > 60)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Detecting radio power cycle failed.  The program will now close.");
                    Process.GetCurrentProcess().Kill();
                }
            }

            p.Hide();
            Application.DoEvents();

            // radio has been rebooted -- verify new version
            USBHID.GetFirmwareRev(out new_ver);
            if (VerToString(new_ver) == version)
                return;

            // should never get here
            MessageBox.Show(new Form { TopMost = true }, "An error occurred while attempting to update the radio firmware.\n" +
                "If this is the first time this message has appeared, please try again.\n" +
                "Otherwise, please contact our support team using the information at\n" +
                "http://www.flexradio.com.",
                "Firmware Update Error",
                MessageBoxButtons.OK,
                MessageBoxIcon.Error);

            Process.GetCurrentProcess().Kill();
        }

        private void CheckCalData()
        {
            if (!fwc_init || (current_model != Model.FLEX5000 && current_model != Model.FLEX3000)) return;
            if (FWCEEPROM.LastCalDateTime == unchecked((long)0xffffffffffffffff))
            {
                //MessageBox.Show(new Form { TopMost = true }, "No Calibration Date/Time Found.");
                return;
            }

            if (fwc_serial_num != FWCEEPROM.SerialNumber)
            {
                if (fwc_serial_num != 0)
                {
                    /*string old_s = FWCEEPROM.SerialToString(fwc_serial_num);
					string new_s = FWCEEPROM.SerialToString(FWCEEPROM.SerialNumber);

					Splash.HideForm();
					DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "New Radio Detected: Old Serial: "+old_s+"  New Serial: "+new_s+"\n"+
						"Do you want to update the PowerSDR calibration data from the EEPROM?\n"+
						"(Note that this may take as long as 90 seconds)",
						"New Radio: Update Cal?",
						MessageBoxButtons.YesNo,
						MessageBoxIcon.Question);

					if(dr == DialogResult.No) return;*/
                }
                else
                {
                    /*MessageBox.Show(new Form { TopMost = true }, "Please wait patiently while a one-time transfer of the\n"+
						"calibration data from the EEPROM is performed.  This\n"+
						"can take as long as 90 seconds.  Click OK to continue.",
						"Please wait for Cal Data Transfer",
						MessageBoxButtons.OK,
						MessageBoxIcon.Information);*/
                }
            }
            else if (fwc_trx_serial_num != FWCEEPROM.TRXSerial)
            {
                /*string old_s = FWCEEPROM.SerialToString(fwc_trx_serial_num);
				string new_s = FWCEEPROM.SerialToString(FWCEEPROM.TRXSerial);

				Splash.HideForm();
				DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "New Radio Detected: Old TRX Serial: "+old_s+"  New Serial: "+new_s+"\n"+
					"Do you want to update the PowerSDR calibration data from the EEPROM?\n"+
					"(Note that this may take as long as 90 seconds)",
					"New Radio: Update Cal?",
					MessageBoxButtons.YesNo,
					MessageBoxIcon.Question);

				if(dr == DialogResult.No) return;*/
            }
            else if (fwc_last_cal_date_time < FWCEEPROM.LastCalDateTime)
            {
                /*try
				{
					DateTime old_date = DateTime.FromFileTimeUtc(fwc_last_cal_date_time);
					string old_d = old_date.ToShortDateString()+" "+old_date.ToShortTimeString();
					DateTime new_date = DateTime.FromFileTimeUtc(FWCEEPROM.LastCalDateTime);
					string new_d = new_date.ToShortDateString()+" "+new_date.ToShortTimeString();
				
					Splash.HideForm();
					DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "Updated Calibration Data Detected:  Old: "+old_d+"  New: "+new_d+"\n"+
						"Do you want to update the PowerSDR calibration data from the EEPROM?\n"+
						"(Note that this may take as long as 90 seconds)",
						"New Data: Update Cal?",
						MessageBoxButtons.YesNo,
						MessageBoxIcon.Question);

					if(dr == DialogResult.No) return;
				}
				catch(Exception) { }*/
            }
            else return;

            // download cal data from EEPROM
            RestoreCalData();
        }

        private void Check1500CalData()
        {
            if (!hid_init || current_model != Model.FLEX1500) return;
            if (HIDEEPROM.LastCalDateTime == unchecked((long)0xffffffffffffffff))
            {
                //MessageBox.Show(new Form { TopMost = true }, "No Calibration Date/Time Found.");
                return;
            }

            if (hid_serial_num == HIDEEPROM.SerialNumber &&
                hid_trx_serial_num == HIDEEPROM.TRXSerial &&
                hid_last_cal_date_time >= HIDEEPROM.LastCalDateTime)
                return;

            // download cal data from EEPROM
            Restore1500CalData();
        }

        private void CheckRX2CalData()
        {
            if (!fwc_init || current_model != Model.FLEX5000 || !FWCEEPROM.RX2OK) return;
            if (FWCEEPROM.LastRX2CalDateTime == unchecked((long)0xffffffffffffffff))
            {
                //MessageBox.Show(new Form { TopMost = true }, "No Calibration Date/Time Found.");
                return;
            }

            if (rx2_serial_num != FWCEEPROM.RX2Serial)
            {
                if (rx2_serial_num != 0)
                {
                    /*string old_s = FWCEEPROM.SerialToString(rx2_serial_num);
					string new_s = FWCEEPROM.SerialToString(FWCEEPROM.RX2Serial);

					Splash.HideForm();
					DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "New RX2 Detected: Old Serial: "+old_s+"  New Serial: "+new_s+"\n"+
						"Do you want to update the PowerSDR calibration data from the EEPROM?\n"+
						"(Note that this may take as long as 30 seconds)",
						"New RX2: Update Cal?",
						MessageBoxButtons.YesNo,
						MessageBoxIcon.Question);

					if(dr == DialogResult.No) return;*/
                }
                else
                {
                    /*MessageBox.Show(new Form { TopMost = true }, "Please wait patiently while a one-time transfer of the\n"+
						 "RX2 calibration data from the EEPROM is performed.  This\n"+
						 "can take as long as 30 seconds.  Click OK to continue.",
						 "Please wait for Cal Data Transfer",
						 MessageBoxButtons.OK,
						 MessageBoxIcon.Information);*/
                }
            }
            else if (rx2_last_cal_date_time < FWCEEPROM.LastRX2CalDateTime)
            {
                /*try
				{
					DateTime old_date = DateTime.FromFileTimeUtc(rx2_last_cal_date_time);
					string old_d = old_date.ToShortDateString()+" "+old_date.ToShortTimeString();
					DateTime new_date = DateTime.FromFileTimeUtc(FWCEEPROM.LastRX2CalDateTime);
					string new_d = new_date.ToShortDateString()+" "+new_date.ToShortTimeString();
				
					Splash.HideForm();
					DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "Updated RX2 Calibration Data Detected:  Old: "+old_d+"  New: "+new_d+"\n"+
						"Do you want to update the PowerSDR calibration data from the EEPROM?\n"+
						"(Note that this may take as long as 30 seconds)",
						"New Data: Update Cal?",
						MessageBoxButtons.YesNo,
						MessageBoxIcon.Question);

					if(dr == DialogResult.No) return;
				}
				catch(Exception) { }*/
            }
            else return;

            // download cal data from EEPROM
            RX2RestoreCalData();
        }

        public void SyncCalDateTime()
        {
            switch (current_model)
            {
                case Model.FLEX5000:
                case Model.FLEX3000:
                    fwc_serial_num = FWCEEPROM.SerialNumber;
                    fwc_trx_serial_num = FWCEEPROM.TRXSerial;
                    fwc_last_cal_date_time = FWCEEPROM.LastCalDateTime;
                    break;
                case Model.FLEX1500:
                    hid_serial_num = HIDEEPROM.SerialNumber;
                    hid_trx_serial_num = HIDEEPROM.TRXSerial;
                    hid_last_cal_date_time = HIDEEPROM.LastCalDateTime;
                    break;
            }
        }

        public void RX2SyncCalDateTime()
        {
            rx2_serial_num = FWCEEPROM.RX2Serial;
            rx2_last_cal_date_time = FWCEEPROM.LastRX2CalDateTime;
        }

        public void WriteTRXChecksums()
        {
            rx1_level_checksum = Checksum.Calc(rx1_level_table);
            FWCEEPROM.WriteRXLevelChecksum(rx1_level_checksum);

            rx1_image_gain_checksum = Checksum.CalcHF(rx1_image_gain_table);
            FWCEEPROM.WriteRXImageGainChecksum(rx1_image_gain_checksum);

            rx1_image_phase_checksum = Checksum.CalcHF(rx1_image_phase_table);
            FWCEEPROM.WriteRXImagePhaseChecksum(rx1_image_phase_checksum);

            tx_image_gain_checksum = Checksum.CalcHF(tx_image_gain_table);
            FWCEEPROM.WriteTXImageGainChecksum(tx_image_gain_checksum);

            tx_image_phase_checksum = Checksum.CalcHF(tx_image_phase_table);
            FWCEEPROM.WriteTXImagePhaseChecksum(tx_image_phase_checksum);

            tx_carrier_checksum = Checksum.Calc(tx_carrier_cal);
            FWCEEPROM.WriteTXCarrierChecksum(tx_carrier_checksum);

            if (FWCEEPROM.PAOK)
            {
                pa_bias_checksum = Checksum.Calc(pa_bias_table, false);
                FWCEEPROM.WritePABiasChecksum(pa_bias_checksum);

                pa_bridge_checksum = Checksum.Calc(pa_bridge_table);
                FWCEEPROM.WritePABridgeChecksum(pa_bridge_checksum);

                pa_power_checksum = Checksum.Calc(power_table);
                FWCEEPROM.WritePAPowerChecksum(pa_power_checksum);

                pa_swr_checksum = Checksum.CalcHF(swr_table);
                FWCEEPROM.WritePASWRChecksum(pa_swr_checksum);

                if (current_model == Model.FLEX3000)
                {
                    atu_swr_checksum = Checksum.CalcHF(atu_swr_table);
                    FWCEEPROM.WriteATUSWRChecksum(atu_swr_checksum);
                }
            }

            if (FWCEEPROM.VUOK)
            {
                vu_level_checksum = Checksum.Calc(vhf_level_table, uhf_level_table);
                FWCEEPROM.WriteVULevelChecksum(vu_level_checksum);

                vu_power_checksum = Checksum.Calc(vhf_power_table, uhf_power_table);
                FWCEEPROM.WriteVUPowerChecksum(vu_power_checksum);
            }

            FWCEEPROM.TRXChecksumPresent = true;
        }

        public void Verify1500Checksums()
        {
            byte calc = 0, eeprom = 0;
            bool error_flag = false;
            string error = "";

            eeprom = HIDEEPROM.ReadRXLevelChecksum();
            calc = Checksum.Calc(rx1_level_table);
            if (rx1_level_checksum != eeprom ||
                rx1_level_checksum != calc)
            {
                error_flag = true;
                error += "RX1 Level Checksum Error " +
                    "DB: " + rx1_level_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + "\n";
            }

            eeprom = HIDEEPROM.ReadRXImageGainChecksum();
            calc = Checksum.CalcHF(rx1_image_gain_table);
            if (rx1_image_gain_checksum != eeprom ||
                rx1_image_gain_checksum != calc)
            {
                error_flag = true;
                error += "RX Image Gain Checksum Error " +
                    "DB: " + rx1_image_gain_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + "\n"; ;
            }

            eeprom = HIDEEPROM.ReadRXImagePhaseChecksum();
            calc = Checksum.CalcHF(rx1_image_phase_table);
            if (rx1_image_phase_checksum != eeprom ||
                rx1_image_phase_checksum != calc)
            {
                error_flag = true;
                error += "RX1 Image Phase Checksum Error " +
                    "DB: " + rx1_image_phase_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + "\n";
            }

            eeprom = HIDEEPROM.ReadTXImageGainChecksum();
            calc = Checksum.CalcHF(tx_image_gain_table);
            if (tx_image_gain_checksum != eeprom ||
                tx_image_gain_checksum != calc)
            {
                error_flag = true;
                error += "TX Image Gain Checksum Error " +
                    "DB: " + tx_image_gain_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + "\n";
            }

            eeprom = HIDEEPROM.ReadTXImagePhaseChecksum();
            calc = Checksum.CalcHF(tx_image_phase_table);
            if (tx_image_phase_checksum != eeprom ||
                tx_image_phase_checksum != calc)
            {
                error_flag = true;
                error += "TX Image Phase Checksum Error " +
                    "DB: " + tx_image_phase_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + "\n";
            }

            eeprom = HIDEEPROM.ReadPAPowerChecksum();
            calc = Checksum.Calc(power_table);
            if (pa_power_checksum != eeprom ||
                pa_power_checksum != calc)
            {
                error_flag = true;
                error += "PA Power Checksum Error " +
                    "DB: " + pa_power_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + "\n";
            }

            if (error_flag)
            {
                TextWriter writer = new StreamWriter(app_data_path + "checksum_error.log", true);    //  "\\checksum_error.log"
                string s = DateTime.Now.ToShortDateString() + "  " + DateTime.Now.ToShortTimeString();
                writer.WriteLine(s + "  " + error);
                writer.Close();
            }
        }

        public void VerifyTRXChecksums()
        {
            byte calc = 0, eeprom = 0;
            bool error_flag = false;
            string error = "";

            eeprom = FWCEEPROM.ReadRXLevelChecksum();
            calc = Checksum.Calc(rx1_level_table);
            if (rx1_level_checksum != eeprom ||
                rx1_level_checksum != calc)
            {
                error_flag = true;
                error += "RX1 Level Checksum Error " +
                    "DB: " + rx1_level_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            eeprom = FWCEEPROM.ReadRXImageGainChecksum();
            calc = Checksum.CalcHF(rx1_image_gain_table);
            if (rx1_image_gain_checksum != eeprom ||
                rx1_image_gain_checksum != calc)
            {
                error_flag = true;
                error += "RX1 Image Gain Checksum Error " +
                    "DB: " + rx1_image_gain_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            eeprom = FWCEEPROM.ReadRXImagePhaseChecksum();
            calc = Checksum.CalcHF(rx1_image_phase_table);
            if (rx1_image_phase_checksum != eeprom ||
                rx1_image_phase_checksum != calc)
            {
                error_flag = true;
                error += "RX1 Image Phase Checksum Error " +
                    "DB: " + rx1_image_phase_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            eeprom = FWCEEPROM.ReadTXImageGainChecksum();
            calc = Checksum.CalcHF(tx_image_gain_table);
            if (tx_image_gain_checksum != eeprom ||
                tx_image_gain_checksum != calc)
            {
                error_flag = true;
                error += "TX Image Gain Checksum Error " +
                    "DB: " + tx_image_gain_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            eeprom = FWCEEPROM.ReadTXImagePhaseChecksum();
            calc = Checksum.CalcHF(tx_image_phase_table);
            if (tx_image_phase_checksum != eeprom ||
                tx_image_phase_checksum != calc)
            {
                error_flag = true;
                error += "TX Image Phase Checksum Error " +
                    "DB: " + tx_image_phase_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            eeprom = FWCEEPROM.ReadTXCarrierChecksum();
            calc = Checksum.Calc(tx_carrier_cal);
            if (tx_carrier_checksum != eeprom ||
                tx_carrier_checksum != calc)
            {
                error_flag = true;
                error += "TX Carrier Checksum Error " +
                    "DB: " + tx_carrier_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            if (FWCEEPROM.PAOK)
            {
                eeprom = FWCEEPROM.ReadPABiasChecksum();
                calc = Checksum.Calc(pa_bias_table, false);
                if (pa_bias_checksum != eeprom ||
                    pa_bias_checksum != calc)
                {
                    error_flag = true;
                    error += "PA Bias Checksum Error " +
                        "DB: " + pa_bias_checksum.ToString("X") +
                        " EEPROM: " + eeprom.ToString("X") +
                        " Calculated: " + calc.ToString("X") + " | \n";
                }

                eeprom = FWCEEPROM.ReadPABridgeChecksum();
                calc = Checksum.Calc(pa_bridge_table);
                if (pa_bridge_checksum != eeprom ||
                    pa_bridge_checksum != calc)
                {
                    error_flag = true;
                    error += "PA Bridge Checksum Error " +
                        "DB: " + pa_bridge_checksum.ToString("X") +
                        " EEPROM: " + eeprom.ToString("X") +
                        " Calculated: " + calc.ToString("X") + " | \n";
                }

                eeprom = FWCEEPROM.ReadPAPowerChecksum();
                calc = Checksum.Calc(power_table);
                if (pa_power_checksum != eeprom ||
                    pa_power_checksum != calc)
                {
                    error_flag = true;
                    error += "PA Power Checksum Error " +
                        "DB: " + pa_power_checksum.ToString("X") +
                        " EEPROM: " + eeprom.ToString("X") +
                        " Calculated: " + calc.ToString("X") + " | \n";
                }

                eeprom = FWCEEPROM.ReadPASWRChecksum();
                calc = Checksum.CalcHF(swr_table);
                if (pa_swr_checksum != eeprom ||
                    pa_swr_checksum != calc)
                {
                    error_flag = true;
                    error += "PA SWR Checksum Error " +
                        "DB: " + pa_swr_checksum.ToString("X") +
                        " EEPROM: " + eeprom.ToString("X") +
                        " Calculated: " + calc.ToString("X") + " | \n";
                }

                if (current_model == Model.FLEX3000)
                {
                    eeprom = FWCEEPROM.ReadATUSWRChecksum();
                    calc = Checksum.CalcHF(atu_swr_table);
                    if (atu_swr_checksum != eeprom ||
                        atu_swr_checksum != calc)
                    {
                        error_flag = true;
                        error += "ATU SWR Checksum Error " +
                            "DB: " + atu_swr_checksum.ToString("X") +
                            " EEPROM: " + eeprom.ToString("X") +
                            " CAlculated: " + calc.ToString("X") + " | \n";
                    }
                }
            }

            if (current_model == Model.FLEX5000 && FWCEEPROM.VUOK)
            {
                eeprom = FWCEEPROM.ReadVULevelChecksum();
                calc = Checksum.Calc(vhf_level_table, uhf_level_table);
                if (vu_level_checksum != eeprom ||
                    vu_level_checksum != calc)
                {
                    error_flag = true;
                    error += "VU Level Checksum Error " +
                        "DB: " + vu_level_checksum.ToString("X") +
                        " EEPROM: " + eeprom.ToString("X") +
                        " Calculated: " + calc.ToString("X") + " | \n";
                }

                eeprom = FWCEEPROM.ReadVUPowerChecksum();
                calc = Checksum.Calc(vhf_power_table, uhf_power_table);
                if (vu_power_checksum != eeprom ||
                    vu_power_checksum != calc)
                {
                    error_flag = true;
                    error += "VU Power Checksum Error " +
                        "DB: " + vu_level_checksum.ToString("X") +
                        " EEPROM: " + eeprom.ToString("X") +
                        " Calculated: " + calc.ToString("X") + " | \n";
                }
            }

            if (error_flag)
            {
                TextWriter writer = new StreamWriter(app_data_path + "checksum_error.log", true); // "\\checksum_error.log"
                string s = DateTime.Now.ToShortDateString() + "  " + DateTime.Now.ToShortTimeString();
                writer.WriteLine(s + "  " + error);
                writer.Close();
                FWCEEPROM.TRXChecksumPresent = false;
            }
        }

        public void WriteRX2Checksums()
        {
            rx2_level_checksum = Checksum.Calc(rx2_level_table);
            FWCEEPROM.WriteRX2LevelChecksum(rx2_level_checksum);

            rx2_image_gain_checksum = Checksum.CalcHF(rx2_image_gain_table);
            FWCEEPROM.WriteRX2ImageGainChecksum(rx2_image_gain_checksum);

            rx2_image_phase_checksum = Checksum.CalcHF(rx2_image_phase_table);
            FWCEEPROM.WriteRX2ImagePhaseChecksum(rx2_image_phase_checksum);

            FWCEEPROM.RX2ChecksumPresent = true;
        }

        public void VerifyRX2Checksums()
        {
            byte calc = 0, eeprom = 0;
            bool error_flag = false;
            string error = "";

            eeprom = FWCEEPROM.ReadRX2LevelChecksum();
            calc = Checksum.Calc(rx2_level_table);
            if (rx2_level_checksum != eeprom ||
                rx2_level_checksum != calc)
            {
                error_flag = true;
                error += "RX2 Level Checksum Error " +
                    "DB: " + rx2_level_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            eeprom = FWCEEPROM.ReadRX2ImageGainChecksum();
            calc = Checksum.CalcHF(rx2_image_gain_table);
            if (rx2_image_gain_checksum != eeprom ||
                rx2_image_gain_checksum != calc)
            {
                error_flag = true;
                error += "RX2 Image Gain Checksum Error " +
                    "DB: " + rx2_image_gain_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            eeprom = FWCEEPROM.ReadRX2ImagePhaseChecksum();
            calc = Checksum.CalcHF(rx2_image_phase_table);
            if (rx2_image_phase_checksum != eeprom ||
                rx2_image_phase_checksum != calc)
            {
                error_flag = true;
                error += "RX2 Image Phase Checksum Error.\n" +
                    "DB: " + rx2_image_phase_checksum.ToString("X") +
                    " EEPROM: " + eeprom.ToString("X") +
                    " Calculated: " + calc.ToString("X") + " | \n";
            }

            if (error_flag)
            {
                TextWriter writer = new StreamWriter(app_data_path + "checksum_error.log", true); //"\\checksum_error.log"
                string s = DateTime.Now.ToShortDateString() + "  " + DateTime.Now.ToShortTimeString();
                writer.WriteLine(s + "  " + error);
                writer.Close();
                FWCEEPROM.RX2ChecksumPresent = false;
            }
        }

        public void Restore1500CalData()
        {
            int checksum_error = 0;
            bool error_flag = false;
            string error = "";
            Progress p = new Progress("Retrieving Calibration Data from EEPROM");
            p.SetPercent(0.0f);
            this.Invoke(new MethodInvoker(p.Show));
            Application.DoEvents();
            float total_reads = 7.0f;
            int count = 0;

            checksum_error = 0;
            while (true)
            {
                HIDEEPROM.ReadPAPower(power_table); // 1 read
                pa_power_checksum = Checksum.Calc(power_table);
                if (Checksum.Match(power_table, HIDEEPROM.ReadPAPowerChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "PA Power Checksum verification error.\n" +
                        "DB: " + pa_power_checksum.ToString("X") +
                        " EEPROM: " + HIDEEPROM.ReadPAPowerChecksum().ToString("X") +
                        " Calculated: " + Checksum.Calc(power_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 1) / total_reads);
            Application.DoEvents();


            checksum_error = 0;
            while (true)
            {
                HIDEEPROM.ReadRXLevel(rx1_level_table); // 2 reads
                rx1_level_checksum = Checksum.Calc(rx1_level_table);
                if (Checksum.Match(rx1_level_table, HIDEEPROM.ReadRXLevelChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "RX1 Level Checksum verification error.\n" +
                        "DB: " + rx1_level_checksum.ToString("X") +
                        " EEPROM: " + HIDEEPROM.ReadRXLevelChecksum().ToString("X") +
                        " Calculated: " + Checksum.Calc(rx1_level_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 2) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                HIDEEPROM.ReadRXImage(rx1_image_gain_table, rx1_image_phase_table); // 22 reads
                rx1_image_gain_checksum = Checksum.CalcHF(rx1_image_gain_table);
                rx1_image_phase_checksum = Checksum.CalcHF(rx1_image_phase_table);
                if (Checksum.MatchHF(rx1_image_gain_table, HIDEEPROM.ReadRXImageGainChecksum()) &&
                    Checksum.MatchHF(rx1_image_phase_table, HIDEEPROM.ReadRXImagePhaseChecksum()))
                    break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "RX Image Gain/Phase Checksum verification error.\n" +
                        "DB: " + rx1_image_gain_checksum.ToString("X") + "/" + rx1_image_phase_checksum.ToString("X") +
                        " EEPROM: " + HIDEEPROM.ReadRXImageGainChecksum().ToString("X") + "/" + HIDEEPROM.ReadRXImagePhaseChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(rx1_image_gain_table).ToString("X") + "/" + Checksum.CalcHF(rx1_image_phase_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 2) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                HIDEEPROM.ReadTXImage(tx_image_gain_table, tx_image_phase_table); // 22 reads
                tx_image_gain_checksum = Checksum.CalcHF(tx_image_gain_table);
                tx_image_phase_checksum = Checksum.CalcHF(tx_image_phase_table);
                if (Checksum.MatchHF(tx_image_gain_table, HIDEEPROM.ReadTXImageGainChecksum()) &&
                    Checksum.MatchHF(tx_image_phase_table, HIDEEPROM.ReadTXImagePhaseChecksum()))
                    break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "TX Image Gain/Phase Checksum verification error.\n" +
                        "DB: " + tx_image_gain_checksum.ToString("X") + "/" + tx_image_phase_checksum.ToString("X") +
                        " EEPROM: " + HIDEEPROM.ReadTXImageGainChecksum().ToString("X") + "/" + HIDEEPROM.ReadTXImagePhaseChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(tx_image_gain_table).ToString("X") + "/" + Checksum.CalcHF(tx_image_phase_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 2) / total_reads);
            Application.DoEvents();


            if (error_flag)
            {
                TextWriter writer = new StreamWriter(app_data_path + "checksum_error.log", true); // "\\checksum_error.log"
                string s = DateTime.Now.ToShortDateString() + "  " + DateTime.Now.ToShortTimeString();
                writer.WriteLine(s + "  " + error);
                writer.Close();
            }

            SyncCalDateTime();
            p.Hide();
            p.Close();
            Application.DoEvents();

            bool save_init = initializing;
            initializing = true;
            RX1Band = rx1_band;
            TXBand = tx_band;
            initializing = save_init;
        } // restor 1500 call data

        public void RestoreCalData()
        {
            bool trx_checksum_present = FWCEEPROM.TRXChecksumPresent;
            int checksum_error = 0;
            bool error_flag = false;
            string error = "";
            Progress p = new Progress("Retrieving Calibration Data from TRX EEPROM");
            p.SetPercent(0.0f);
            this.Invoke(new MethodInvoker(p.Show));
            Application.DoEvents();
            float total_reads = 324.0f;
            if (current_model == Model.FLEX3000)
                total_reads += 11.0f;  // for ATU SWR table
            else if (current_model == Model.FLEX5000 && FWCEEPROM.VUOK)
                total_reads += 40.0f; // for all VU tables
            int count = 0;

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadRXLevel(rx1_level_table); // 33 reads
                rx1_level_checksum = Checksum.Calc(rx1_level_table);
                if (!trx_checksum_present) FWCEEPROM.WriteRXLevelChecksum(rx1_level_checksum);
                if (Checksum.Match(rx1_level_table, FWCEEPROM.ReadRXLevelChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "RX1 Level Checksum verification error.\n" +
                        "DB: " + rx1_level_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadRXLevelChecksum().ToString("X") +
                        " Calculated: " + Checksum.Calc(rx1_level_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 33) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadRXImage(rx1_image_gain_table, rx1_image_phase_table); // 22 reads
                rx1_image_gain_checksum = Checksum.CalcHF(rx1_image_gain_table);
                if (!trx_checksum_present) FWCEEPROM.WriteRXImageGainChecksum(rx1_image_gain_checksum);
                if (Checksum.MatchHF(rx1_image_gain_table, FWCEEPROM.ReadRXImageGainChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "RX1 Image Gain Checksum verification error.\n" +
                        "DB: " + rx1_image_gain_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadRXImageGainChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(rx1_image_gain_table).ToString("X") + "\n";
                    break;
                }
            }

            checksum_error = 0;
            do
            {
                rx1_image_phase_checksum = Checksum.CalcHF(rx1_image_phase_table);
                if (!trx_checksum_present) FWCEEPROM.WriteRXImagePhaseChecksum(rx1_image_phase_checksum);
                if (Checksum.MatchHF(rx1_image_phase_table, FWCEEPROM.ReadRXImagePhaseChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "RX1 Image Phase Checksum verification error.\n" +
                        "DB: " + rx1_image_phase_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadRXImagePhaseChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(rx1_image_phase_table).ToString("X") + "\n";
                    break;
                }
                FWCEEPROM.ReadRXImage(rx1_image_gain_table, rx1_image_phase_table); // 22 reads
            } while (true);
            p.SetPercent((count += 22) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadTXImage(tx_image_gain_table, tx_image_phase_table); // 22 reads
                tx_image_gain_checksum = Checksum.CalcHF(tx_image_gain_table);
                if (!trx_checksum_present) FWCEEPROM.WriteTXImageGainChecksum(tx_image_gain_checksum);
                if (Checksum.MatchHF(tx_image_gain_table, FWCEEPROM.ReadTXImageGainChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "TX Image Gain Checksum verification error.\n" +
                        "DB: " + tx_image_gain_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadTXImageGainChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(tx_image_gain_table).ToString("X") + "\n";
                    break;
                }
            }

            checksum_error = 0;
            do
            {
                tx_image_phase_checksum = Checksum.CalcHF(tx_image_phase_table);
                if (!trx_checksum_present) FWCEEPROM.WriteTXImagePhaseChecksum(tx_image_phase_checksum);
                if (Checksum.MatchHF(tx_image_phase_table, FWCEEPROM.ReadTXImagePhaseChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "TX Image Phase Checksum verification error.\n" +
                        "DB: " + tx_image_phase_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadTXImagePhaseChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(tx_image_phase_table).ToString("X") + "\n";
                    break;
                }
                FWCEEPROM.ReadTXImage(tx_image_gain_table, tx_image_phase_table); // 22 reads
            } while (true);
            p.SetPercent((count += 22) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadTXCarrier(tx_carrier_cal); // 11 reads
                tx_carrier_checksum = Checksum.Calc(tx_carrier_cal);
                if (!trx_checksum_present) FWCEEPROM.WriteTXCarrierChecksum(tx_carrier_checksum);
                if (Checksum.Match(tx_carrier_cal, FWCEEPROM.ReadTXCarrierChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "TX Carrier Checksum verification error.\n" +
                        "DB: " + tx_carrier_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadTXCarrierChecksum().ToString("X") +
                        " Calculated: " + Checksum.Calc(tx_carrier_cal).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 11) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadPABias(pa_bias_table); // 8 reads
                pa_bias_checksum = Checksum.Calc(pa_bias_table, false);
                if (!trx_checksum_present) FWCEEPROM.WritePABiasChecksum(pa_bias_checksum);
                if (Checksum.Match(pa_bias_table, FWCEEPROM.ReadPABiasChecksum(), false)) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "PA Bias Checksum verification error.\n" +
                        "DB: " + pa_bias_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadPABiasChecksum().ToString("X") +
                        " Calculated: " + Checksum.Calc(pa_bias_table, false).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 8) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadPAPower(power_table); // 143 reads
                pa_power_checksum = Checksum.Calc(power_table);
                if (!trx_checksum_present) FWCEEPROM.WritePAPowerChecksum(pa_power_checksum);
                if (Checksum.Match(power_table, FWCEEPROM.ReadPAPowerChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "PA Power Checksum verification error.\n" +
                        "DB: " + pa_power_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadPAPowerChecksum().ToString("X") +
                        " Calculated: " + Checksum.Calc(power_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 143) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadPABridge(pa_bridge_table); // 66 reads
                pa_bridge_checksum = Checksum.Calc(pa_bridge_table);
                if (!trx_checksum_present) FWCEEPROM.WritePABridgeChecksum(pa_bridge_checksum);
                if (Checksum.Match(pa_bridge_table, FWCEEPROM.ReadPABridgeChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "PA Bridge Checksum verification error.\n" +
                        "DB: " + pa_bridge_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadPABridgeChecksum().ToString("X") +
                        " Calculated: " + Checksum.Calc(pa_bridge_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 66) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadPASWR(swr_table); // 11 reads
                pa_swr_checksum = Checksum.CalcHF(swr_table);
                if (!trx_checksum_present) FWCEEPROM.WritePASWRChecksum(pa_swr_checksum);
                if (Checksum.MatchHF(swr_table, FWCEEPROM.ReadPASWRChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "PA SWR Checksum verification error.\n" +
                        "DB: " + pa_swr_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadPASWRChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(swr_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 11) / total_reads);
            Application.DoEvents();

            if (current_model == Model.FLEX3000)
            {
                checksum_error = 0;
                while (true)
                {
                    FWCEEPROM.ReadATUSWR(atu_swr_table); // 11 reads
                    atu_swr_checksum = Checksum.CalcHF(atu_swr_table);
                    if (!trx_checksum_present) FWCEEPROM.WriteATUSWRChecksum(atu_swr_checksum);
                    if (Checksum.MatchHF(atu_swr_table, FWCEEPROM.ReadATUSWRChecksum())) break;

                    checksum_error++;
                    if (checksum_error > 2)
                    {
                        error_flag = true;
                        error += "ATU SWR Checksum verification error.\n" +
                            "DB: " + atu_swr_checksum.ToString("X") +
                            " EEPROM: " + FWCEEPROM.ReadATUSWRChecksum().ToString("X") +
                            " Calculated: " + Checksum.CalcHF(atu_swr_table).ToString("X") + "\n";
                        break;
                    }
                }
                p.SetPercent((count += 11) / total_reads);
                Application.DoEvents();
            }

            if (current_model == Model.FLEX5000 && FWCEEPROM.VUOK)
            {
                checksum_error = 0;
                while (true)
                {
                    FWCEEPROM.ReadVULevel(vhf_level_table, uhf_level_table); // 4 reads
                    vu_level_checksum = Checksum.Calc(vhf_level_table, uhf_level_table);
                    if (!trx_checksum_present) FWCEEPROM.WriteATUSWRChecksum(atu_swr_checksum);
                    if (Checksum.Match(vhf_level_table, uhf_level_table, FWCEEPROM.ReadVULevelChecksum())) break;

                    checksum_error++;
                    if (checksum_error > 2)
                    {
                        error_flag = true;
                        error += "VU Level Checksum verification error.\n" +
                            "DB: " + atu_swr_checksum.ToString("X") +
                            " EEPROM: " + FWCEEPROM.ReadVULevelChecksum().ToString("X") +
                            " Calculated: " + Checksum.Calc(vhf_level_table, uhf_level_table).ToString("X") + "\n";
                        break;
                    }
                }
                p.SetPercent((count += 4) / total_reads);
                Application.DoEvents();

                checksum_error = 0;
                while (true)
                {
                    FWCEEPROM.ReadVUPower(vhf_power_table, uhf_power_table); // 36 reads
                    vu_power_checksum = Checksum.Calc(vhf_power_table, uhf_power_table);
                    if (!trx_checksum_present) FWCEEPROM.WriteVUPowerChecksum(vu_power_checksum);
                    if (Checksum.Match(vhf_power_table, uhf_power_table, FWCEEPROM.ReadVUPowerChecksum())) break;

                    checksum_error++;
                    if (checksum_error > 2)
                    {
                        error_flag = true;
                        error += "VU Power Checksum verification error.\n" +
                            "DB: " + vu_power_checksum.ToString("X") +
                            " EEPROM: " + FWCEEPROM.ReadVUPowerChecksum().ToString("X") +
                            " Calculated: " + Checksum.Calc(vhf_power_table, uhf_power_table).ToString("X") + "\n";
                        break;
                    }
                }
                p.SetPercent((count += 36) / total_reads);
                Application.DoEvents();
            }

            if (error_flag)
            {
                TextWriter writer = new StreamWriter(app_data_path + "checksum_error.log", true); // "\\checksum_error.log"
                string s = DateTime.Now.ToShortDateString() + "  " + DateTime.Now.ToShortTimeString();
                writer.WriteLine(s + "  " + error);
                writer.Close();
                FWCEEPROM.TRXChecksumPresent = false;
            }

            if (flex5000DebugForm != null && !flex5000DebugForm.IsDisposed)
            {
                for (int i = 0; i < 8; i++)
                    flex5000DebugForm.SetPAPot(i, (byte)pa_bias_table[0][i]);
            }
            p.SetPercent((count += 8) / total_reads);
            Application.DoEvents();

            SyncCalDateTime();
            p.Hide();
            p.Close();
            Application.DoEvents();

            for (int i = (int)Band.B2M; i < (int)Band.LAST; i++)
                for (int j = 0; j < 13; j++)
                    power_table[i][j] = power_table[10][j];

            bool save_init = initializing;
            initializing = true;
            RX1Band = rx1_band;
            TXBand = tx_band;
            initializing = save_init;
        } // RestoreCalData

        public void RX2RestoreCalData()
        {
            bool rx2_checksum_present = FWCEEPROM.RX2ChecksumPresent;
            int checksum_error = 0;
            bool error_flag = false;
            string error = "";
            Progress p = new Progress("Retrieving Calibration Data from RX2 EEPROM");
            p.SetPercent(0.0f);
            this.Invoke(new MethodInvoker(p.Show));
            Application.DoEvents();
            float total_reads = 55.0f;
            int count = 0;

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadRX2Level(rx2_level_table); // 33 reads
                rx2_level_checksum = Checksum.Calc(rx2_level_table);
                if (!rx2_checksum_present) FWCEEPROM.WriteRX2LevelChecksum(rx2_level_checksum);
                if (Checksum.Match(rx2_level_table, FWCEEPROM.ReadRX2LevelChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "RX2 Level Checksum verification error.\n" +
                        "DB: " + rx2_level_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadRX2LevelChecksum().ToString("X") +
                        " Calculated: " + Checksum.Calc(rx2_level_table).ToString("X") + "\n";
                    break;
                }
            }
            p.SetPercent((count += 33) / total_reads);
            Application.DoEvents();

            checksum_error = 0;
            while (true)
            {
                FWCEEPROM.ReadRX2Image(rx2_image_gain_table, rx2_image_phase_table); // 22 reads
                rx2_image_gain_checksum = Checksum.CalcHF(rx2_image_gain_table);
                if (!rx2_checksum_present) FWCEEPROM.WriteRX2ImageGainChecksum(rx2_image_gain_checksum);
                if (Checksum.MatchHF(rx2_image_gain_table, FWCEEPROM.ReadRX2ImageGainChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "RX2 Image Gain Checksum verification error.\n" +
                        "DB: " + rx2_image_gain_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadRX2ImageGainChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(rx2_image_gain_table).ToString("X") + "\n";
                    break;
                }
            }

            checksum_error = 0;
            do
            {
                rx2_image_phase_checksum = Checksum.CalcHF(rx2_image_phase_table);
                if (!rx2_checksum_present) FWCEEPROM.WriteRX2ImagePhaseChecksum(rx2_image_phase_checksum);
                if (Checksum.MatchHF(rx2_image_phase_table, FWCEEPROM.ReadRX2ImagePhaseChecksum())) break;

                checksum_error++;
                if (checksum_error > 2)
                {
                    error_flag = true;
                    error += "RX2 Image Phase Checksum verification error.\n" +
                        "DB: " + rx2_image_phase_checksum.ToString("X") +
                        " EEPROM: " + FWCEEPROM.ReadRX2ImagePhaseChecksum().ToString("X") +
                        " Calculated: " + Checksum.CalcHF(rx2_image_phase_table).ToString("X") + "\n";
                    break;
                }
                FWCEEPROM.ReadRX2Image(rx2_image_gain_table, rx2_image_phase_table); // 22 reads
            } while (true);
            p.SetPercent((count += 22) / total_reads);
            Application.DoEvents();

            if (error_flag)
            {
                TextWriter writer = new StreamWriter(app_data_path + "checksum_error.log", true); // "\\checksum_error.log"
                string s = DateTime.Now.ToShortDateString() + "  " + DateTime.Now.ToShortTimeString();
                writer.WriteLine(s + "  " + error);
                writer.Close();
                FWCEEPROM.RX2ChecksumPresent = false;
            }

            RX2SyncCalDateTime();
            p.Hide();
            p.Close();

            bool save_init = initializing;
            initializing = true;
            RX2Band = rx2_band;
            initializing = save_init;
        }

        public void Write1500CalData() // ke9ns write EEPROM data from 0x3000 and up
        {
            if (!hid_init || current_model != Model.FLEX1500) return;

            HIDEEPROM.WriteRXLevel(rx1_level_table, out rx1_level_checksum);
            HIDEEPROM.WriteRXImage(rx1_image_gain_table, rx1_image_phase_table, out rx1_image_gain_checksum, out rx1_image_phase_checksum);
            HIDEEPROM.WriteTXImage(tx_image_gain_table, tx_image_phase_table, out tx_image_gain_checksum, out tx_image_phase_checksum);
            HIDEEPROM.WritePAPower(power_table, out pa_power_checksum);

            SyncCalDateTime();
        }

        public void WriteCalData()
        {
            if (!fwc_init || (current_model != Model.FLEX5000 && current_model != Model.FLEX3000)) return;

            FWCEEPROM.WriteRXLevel(rx1_level_table, out rx1_level_checksum);
            FWCEEPROM.WriteRXImage(rx1_image_gain_table, rx1_image_phase_table, out rx1_image_gain_checksum, out rx1_image_phase_checksum);
            FWCEEPROM.WriteTXImage(tx_image_gain_table, tx_image_phase_table, out tx_image_gain_checksum, out tx_image_phase_checksum);
            FWCEEPROM.WriteTXCarrier(tx_carrier_cal, out tx_carrier_checksum);
            FWCEEPROM.WritePABias(pa_bias_table, out pa_bias_checksum);
            FWCEEPROM.WritePABridge(pa_bridge_table, out pa_bridge_checksum);
            FWCEEPROM.WritePAPower(power_table, out pa_power_checksum);
            FWCEEPROM.WritePASWR(swr_table, out pa_swr_checksum);
            FWCEEPROM.WriteATUSWR(atu_swr_table, out atu_swr_checksum);

            if (FWCEEPROM.VUOK)
            {
                FWCEEPROM.WriteVULevel(vhf_level_table, uhf_level_table, out vu_level_checksum);
                FWCEEPROM.WriteVUPower(vhf_power_table, uhf_power_table, out vu_power_checksum);
            }

            SyncCalDateTime();
        }

        public void WriteRX2CalData()
        {
            if (!fwc_init || current_model != Model.FLEX5000 || !FWCEEPROM.RX2OK) return;

            FWCEEPROM.WriteRX2Level(rx2_level_table, out rx2_level_checksum);
            FWCEEPROM.WriteRX2Image(rx2_image_gain_table, rx2_image_phase_table, out rx2_image_gain_checksum, out rx2_image_phase_checksum);

            SyncCalDateTime();
        }

        public float GetRX1Level(Band b, int index)
        {
            return rx1_level_table[(int)b][index];
        }

        public float GetRX2Level(Band b, int index)
        {
            return rx2_level_table[(int)b][index];
        }

        public FilterPreset[] rx1_filters = new FilterPreset[(int)DSPMode.LAST];
        public FilterPreset[] rx2_filters = new FilterPreset[(int)DSPMode.LAST];

        private void InitFilterPresets()
        {
            InitFilterPresets(rx1_filters);
            InitFilterPresets(rx2_filters);
        }

        private void InitFilterPresets(FilterPreset[] preset)
        {
            // used to initialize all the filter variables
            // changed digi mode preset filters to center on digi mode click tune offset - W4TME

            for (int m = (int)DSPMode.FIRST + 1; m < (int)DSPMode.LAST; m++)
            {
                preset[m] = new FilterPreset();
                for (Filter f = Filter.F1; f != Filter.LAST; f++)
                {
                    switch (m)
                    {
                        case (int)DSPMode.LSB:
                            switch (f)
                            {
                                case Filter.F1:
                                    preset[m].SetFilter(f, -5150, -150, "5.0k");
                                    break;
                                case Filter.F2:
                                    preset[m].SetFilter(f, -4550, -150, "4.4k");
                                    break;
                                case Filter.F3:
                                    preset[m].SetFilter(f, -3950, -150, "3.8k");
                                    break;
                                case Filter.F4:
                                    preset[m].SetFilter(f, -3450, -150, "3.3k");
                                    break;
                                case Filter.F5:
                                    preset[m].SetFilter(f, -3050, -150, "2.9k");
                                    break;
                                case Filter.F6:
                                    preset[m].SetFilter(f, -2850, -150, "2.7k");
                                    break;
                                case Filter.F7:
                                    preset[m].SetFilter(f, -2550, -150, "2.4k");
                                    break;
                                case Filter.F8:
                                    preset[m].SetFilter(f, -2250, -150, "2.1k");
                                    break;
                                case Filter.F9:
                                    preset[m].SetFilter(f, -1950, -150, "1.8k");
                                    break;
                                case Filter.F10:
                                    preset[m].SetFilter(f, -1150, -150, "1.0k");
                                    break;
                                case Filter.VAR1:
                                    preset[m].SetFilter(f, -2850, -150, "Var 1");
                                    break;
                                case Filter.VAR2:
                                    preset[m].SetFilter(f, -2850, -150, "Var 2");
                                    break;
                            }
                            preset[m].LastFilter = Filter.F6;
                            break; // lsb
                        case (int)DSPMode.USB:
                            switch (f)
                            {
                                case Filter.F1:
                                    preset[m].SetFilter(f, 150, 5150, "5.0k");
                                    break;
                                case Filter.F2:
                                    preset[m].SetFilter(f, 150, 4550, "4.4k");
                                    break;
                                case Filter.F3:
                                    preset[m].SetFilter(f, 150, 3950, "3.8k");
                                    break;
                                case Filter.F4:
                                    preset[m].SetFilter(f, 150, 3450, "3.3k");
                                    break;
                                case Filter.F5:
                                    preset[m].SetFilter(f, 150, 3050, "2.9k");
                                    break;
                                case Filter.F6:
                                    preset[m].SetFilter(f, 150, 2850, "2.7k");
                                    break;
                                case Filter.F7:
                                    preset[m].SetFilter(f, 150, 2550, "2.4k");
                                    break;
                                case Filter.F8:
                                    preset[m].SetFilter(f, 150, 2250, "2.1k");
                                    break;
                                case Filter.F9:
                                    preset[m].SetFilter(f, 150, 1950, "1.8k");
                                    break;
                                case Filter.F10:
                                    preset[m].SetFilter(f, 150, 1150, "1.0k");
                                    break;
                                case Filter.VAR1:
                                    preset[m].SetFilter(f, 150, 2850, "Var 1");
                                    break;
                                case Filter.VAR2:
                                    preset[m].SetFilter(f, 150, 2850, "Var 2");
                                    break;
                            }
                            preset[m].LastFilter = Filter.F6;
                            break; //usb
                        case (int)DSPMode.DIGL:
                            switch (f)
                            {
                                case Filter.F1:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 1500, -digl_click_tune_offset + 1500, "3.0k");
                                    break;
                                case Filter.F2:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 1250, -digl_click_tune_offset + 1250, "2.5k");
                                    break;
                                case Filter.F3:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 1000, -digl_click_tune_offset + 1000, "2.0k");
                                    break;
                                case Filter.F4:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 750, -digl_click_tune_offset + 750, "1.5k");
                                    break;
                                case Filter.F5:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 500, -digl_click_tune_offset + 500, "1.0k");
                                    break;
                                case Filter.F6:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 400, -digl_click_tune_offset + 400, "800");
                                    break;
                                case Filter.F7:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 300, -digl_click_tune_offset + 300, "600");
                                    break;
                                case Filter.F8:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 150, -digl_click_tune_offset + 150, "300");
                                    break;
                                case Filter.F9:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 75, -digl_click_tune_offset + 75, "150");
                                    break;
                                case Filter.F10:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 38, -digl_click_tune_offset + 38, "75");
                                    break;
                                case Filter.VAR1:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 400, -digl_click_tune_offset + 400, "Var 1");
                                    break;
                                case Filter.VAR2:
                                    preset[m].SetFilter(f, -digl_click_tune_offset - 400, -digl_click_tune_offset + 400, "Var 2");
                                    break;
                            }
                            preset[m].LastFilter = Filter.F5;
                            break; //digl
                        case (int)DSPMode.DIGU:
                            switch (f)
                            {
                                case Filter.F1:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 1500, digu_click_tune_offset + 1500, "3.0k");
                                    break;
                                case Filter.F2:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 1250, digu_click_tune_offset + 1250, "2.5k");
                                    break;
                                case Filter.F3:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 1000, digu_click_tune_offset + 1000, "2.0k");
                                    break;
                                case Filter.F4:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 750, digu_click_tune_offset + 750, "1.5k");
                                    break;
                                case Filter.F5:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 500, digu_click_tune_offset + 500, "1.0k");
                                    break;
                                case Filter.F6:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 400, digu_click_tune_offset + 400, "800");
                                    break;
                                case Filter.F7:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 300, digu_click_tune_offset + 300, "600");
                                    break;
                                case Filter.F8:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 150, digu_click_tune_offset + 150, "300");
                                    break;
                                case Filter.F9:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 75, digu_click_tune_offset + 75, "150");
                                    break;
                                case Filter.F10:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 38, digu_click_tune_offset + 38, "75");
                                    break;
                                case Filter.VAR1:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 400, digu_click_tune_offset + 400, "Var 1");
                                    break;
                                case Filter.VAR2:
                                    preset[m].SetFilter(f, digu_click_tune_offset - 400, digu_click_tune_offset + 400, "Var 2");
                                    break;
                            }
                            preset[m].LastFilter = Filter.F5;
                            break;  // digu
                        case (int)DSPMode.CWL:
                            switch (f)
                            {
                                case Filter.F1:
                                    preset[m].SetFilter(f, -cw_pitch - 500, -cw_pitch + 500, "1.0k");
                                    break;
                                case Filter.F2:
                                    preset[m].SetFilter(f, -cw_pitch - 400, -cw_pitch + 400, "800");
                                    break;
                                case Filter.F3:
                                    preset[m].SetFilter(f, -cw_pitch - 375, -cw_pitch + 375, "750");
                                    break;
                                case Filter.F4:
                                    preset[m].SetFilter(f, -cw_pitch - 300, -cw_pitch + 300, "600");
                                    break;
                                case Filter.F5:
                                    preset[m].SetFilter(f, -cw_pitch - 250, -cw_pitch + 250, "500");
                                    break;
                                case Filter.F6:
                                    preset[m].SetFilter(f, -cw_pitch - 200, -cw_pitch + 200, "400");
                                    break;
                                case Filter.F7:
                                    preset[m].SetFilter(f, -cw_pitch - 125, -cw_pitch + 125, "250");
                                    break;
                                case Filter.F8:
                                    preset[m].SetFilter(f, -cw_pitch - 50, -cw_pitch + 50, "100");
                                    break;
                                case Filter.F9:
                                    preset[m].SetFilter(f, -cw_pitch - 25, -cw_pitch + 25, "50");
                                    break;
                                case Filter.F10:
                                    preset[m].SetFilter(f, -cw_pitch - 13, -cw_pitch + 13, "25");
                                    break;
                                case Filter.VAR1:
                                    preset[m].SetFilter(f, -cw_pitch - 250, -cw_pitch + 250, "Var 1");
                                    break;
                                case Filter.VAR2:
                                    preset[m].SetFilter(f, -cw_pitch - 250, -cw_pitch + 250, "Var 2");
                                    break;
                            }
                            preset[m].LastFilter = Filter.F5;
                            break; // cwl
                        case (int)DSPMode.CWU:
                            switch (f)
                            {
                                case Filter.F1:
                                    preset[m].SetFilter(f, cw_pitch - 500, cw_pitch + 500, "1.0k");
                                    break;
                                case Filter.F2:
                                    preset[m].SetFilter(f, cw_pitch - 400, cw_pitch + 400, "800");
                                    break;
                                case Filter.F3:
                                    preset[m].SetFilter(f, cw_pitch - 375, cw_pitch + 375, "750");
                                    break;
                                case Filter.F4:
                                    preset[m].SetFilter(f, cw_pitch - 300, cw_pitch + 300, "600");
                                    break;
                                case Filter.F5:
                                    preset[m].SetFilter(f, cw_pitch - 250, cw_pitch + 250, "500");
                                    break;
                                case Filter.F6:
                                    preset[m].SetFilter(f, cw_pitch - 200, cw_pitch + 200, "400");
                                    break;
                                case Filter.F7:
                                    preset[m].SetFilter(f, cw_pitch - 125, cw_pitch + 125, "250");
                                    break;
                                case Filter.F8:
                                    preset[m].SetFilter(f, cw_pitch - 50, cw_pitch + 50, "100");
                                    break;
                                case Filter.F9:
                                    preset[m].SetFilter(f, cw_pitch - 25, cw_pitch + 25, "50");
                                    break;
                                case Filter.F10:
                                    preset[m].SetFilter(f, cw_pitch - 13, cw_pitch + 13, "25");
                                    break;
                                case Filter.VAR1:
                                    preset[m].SetFilter(f, cw_pitch - 250, cw_pitch + 250, "Var 1");
                                    break;
                                case Filter.VAR2:
                                    preset[m].SetFilter(f, cw_pitch - 250, cw_pitch + 250, "Var 2");
                                    break;
                            }
                            preset[m].LastFilter = Filter.F5;
                            break; //cwu
                        case (int)DSPMode.AM:
                        case (int)DSPMode.SAM:
                        case (int)DSPMode.DSB:
                            switch (f)
                            {
                                case Filter.F1:
                                    preset[m].SetFilter(f, -8000, 8000, "16k");
                                    break;
                                case Filter.F2:
                                    preset[m].SetFilter(f, -6000, 6000, "12k");
                                    break;
                                case Filter.F3:
                                    preset[m].SetFilter(f, -5000, 5000, "10k");
                                    break;
                                case Filter.F4:
                                    preset[m].SetFilter(f, -4000, 4000, "8.0k");
                                    break;
                                case Filter.F5:
                                    preset[m].SetFilter(f, -3300, 3300, "6.6k");
                                    break;
                                case Filter.F6:
                                    preset[m].SetFilter(f, -2600, 2600, "5.2k");
                                    break;
                                case Filter.F7:
                                    preset[m].SetFilter(f, -2000, 2000, "4.0k");
                                    break;
                                case Filter.F8:
                                    preset[m].SetFilter(f, -1550, 1550, "3.1k");
                                    break;
                                case Filter.F9:
                                    preset[m].SetFilter(f, -1450, 1450, "2.9k");
                                    break;
                                case Filter.F10:
                                    preset[m].SetFilter(f, -1200, 1200, "2.4k");
                                    break;
                                case Filter.VAR1:
                                    preset[m].SetFilter(f, -3300, 3300, "Var 1");
                                    break;
                                case Filter.VAR2:
                                    preset[m].SetFilter(f, -3300, 3300, "Var 2");
                                    break;
                            }
                            preset[m].LastFilter = Filter.F5;
                            break; // am,dsb
                        default:
                            preset[m].LastFilter = Filter.NONE;
                            break;
                    }
                }
            }
        } // initfilterpresets

        private void InitDisplayModes()
        {
            // populate the display mode list
            for (DisplayMode dm = DisplayMode.FIRST + 1; dm < DisplayMode.LAST; dm++)
            {
                string s = dm.ToString().ToLower();

                s = s.Substring(0, 1).ToUpper() + s.Substring(1, s.Length - 1);

                comboDisplayMode.Items.Add(s);
            }
        }

        private void InitAGCModes()
        {
            // populate the AGC mode list
            for (AGCMode agc = AGCMode.FIRST + 1; agc < AGCMode.LAST; agc++)
            {
                string s = agc.ToString().ToLower();
                s = s.Substring(0, 1).ToUpper() + s.Substring(1, s.Length - 1);
                comboAGC.Items.Add(s);
            }

            for (AGCMode agc = AGCMode.FIRST + 1; agc < AGCMode.CUSTOM; agc++) //ke9ns mod to add custom for (AGCMode agc = AGCMode.FIRST + 1; agc < AGCMode.CUSTOM; agc++)
            {
                string s = agc.ToString().ToLower();
                s = s.Substring(0, 1).ToUpper() + s.Substring(1, s.Length - 1);
                comboRX2AGC.Items.Add(s);
            }
        }

        private void InitMultiMeterModes()
        {
            comboMeterRXMode.Items.Add("Signal");
            comboMeterRXMode.Items.Add("Sig Avg");
            comboMeterRXMode.Items.Add("Sig Pk"); // ke9ns ADD new meter mode (Signal Peak hold reading)
            comboMeterRXMode.Items.Add("ADC L");
            comboMeterRXMode.Items.Add("ADC R");
            comboMeterRXMode.Items.Add("ADC2 L");
            comboMeterRXMode.Items.Add("ADC2 R");
            comboMeterRXMode.Items.Add("Off");

            comboRX2MeterMode.Items.Add("Signal");
            comboRX2MeterMode.Items.Add("Sig Avg");
            comboRX2MeterMode.Items.Add("Sig Pk"); // ke9ns ADD new meter mode (Signal Peak hold reading)
            comboRX2MeterMode.Items.Add("ADC L");
            comboRX2MeterMode.Items.Add("ADC R");
            comboRX2MeterMode.Items.Add("ADC2 L");
            comboRX2MeterMode.Items.Add("ADC2 R");
            comboRX2MeterMode.Items.Add("Off");

            comboMeterTXMode.Items.Add("Fwd Pwr");
            comboMeterTXMode.Items.Add("Ref Pwr");
            comboMeterTXMode.Items.Add("SWR");
            comboMeterTXMode.Items.Add("Mic");
            comboMeterTXMode.Items.Add("EQ");
            comboMeterTXMode.Items.Add("Leveler");
            comboMeterTXMode.Items.Add("Lev Gain");
            comboMeterTXMode.Items.Add("ALC");
            comboMeterTXMode.Items.Add("ALC Comp");
            comboMeterTXMode.Items.Add("CPDR");

            comboMeterTXMode.Items.Add("Off");


            //ke9ns add block below
            comboMeterTX1Mode.Items.Add("Fwd Pwr");
            comboMeterTX1Mode.Items.Add("Ref Pwr");
            comboMeterTX1Mode.Items.Add("SWR");
            comboMeterTX1Mode.Items.Add("Mic");
            comboMeterTX1Mode.Items.Add("EQ");
            comboMeterTX1Mode.Items.Add("Leveler");
            comboMeterTX1Mode.Items.Add("Lev Gain");
            comboMeterTX1Mode.Items.Add("ALC");
            comboMeterTX1Mode.Items.Add("ALC Comp");
            comboMeterTX1Mode.Items.Add("CPDR");
            comboMeterTX1Mode.Items.Add("Combo"); // ke9ns add for combo meter
            comboMeterTX1Mode.Items.Add("Off");

        }// initmultimeterModes()

        private void DisableAllFilters()
        {
            foreach (Control c in panelFilter.Controls)
            {
                if (c.GetType() == typeof(RadioButtonTS))
                {
                    c.Enabled = false;
                }
            }
        }

        private void DisableAllRX2Filters()
        {
            foreach (Control c in panelRX2Filter.Controls)
            {
                if (c.GetType() == typeof(RadioButtonTS))
                {
                    c.Enabled = false;
                }
            }
        }

        private void EnableAllFilters()
        {
            foreach (Control c in panelFilter.Controls)
            {
                if (c.GetType() == typeof(RadioButtonTS))
                {
                    c.Enabled = true;

                    if (c.BackColor == vfo_text_dark_color)
                    {
                        c.BackColor = button_selected_color;
                    }
                }
            }
        }

        private void EnableAllRX2Filters()
        {
            foreach (Control c in panelRX2Filter.Controls)
            {
                if (c.GetType() == typeof(RadioButtonTS))
                {
                    c.Enabled = true;

                    if (c.BackColor == vfo_text_dark_color)
                    {
                        c.BackColor = button_selected_color;
                    }
                }
            }
        }

        //=============================================================
        // ke9ns used to disable all the buttons on the HF,VHF,SWL band panel
        private void DisableAllBands()
        {
            foreach (Control c in panelBandHF.Controls)
            {
                c.Enabled = false;

                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.BackColor == button_selected_color)
                    {
                        b.BackColor = vfo_text_dark_color;
                    }
                }
            }


            foreach (Control c in panelBandVHF.Controls)
            {
                c.Enabled = false;

                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.BackColor == button_selected_color)
                    {
                        b.BackColor = vfo_text_dark_color;
                    }
                }
            }

            foreach (Control c in panelBandGN.Controls)
            {
                //   c.Enabled = false;

                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.BackColor == button_selected_color)
                    {
                        b.BackColor = vfo_text_dark_color;
                    }
                }
            }

            foreach (Control c in panelBandHFRX2.Controls)
            {
                c.Enabled = false;

                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.BackColor == button_selected_color)
                    {
                        b.BackColor = vfo_text_dark_color;
                    }
                }
            }


            foreach (Control c in panelBandVHFRX2.Controls)
            {
                c.Enabled = false;

                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.BackColor == button_selected_color)
                    {
                        b.BackColor = vfo_text_dark_color;
                    }
                }
            }

            foreach (Control c in panelBandGNRX2.Controls)
            {
                //   c.Enabled = false;

                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.BackColor == button_selected_color)
                    {
                        b.BackColor = vfo_text_dark_color;
                    }
                }
            }

        } // DisableAllBands()


        //=================================================================================
        // ke9ns turns on buttons on all 3 band panels HF,VHF, SWL

        private void EnableAllBands()
        {
          

            foreach (Control c in panelBandHF.Controls)
            {
                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.Text == "2") b.Enabled = XVTRPresent;
                    else b.Enabled = true;

                    if (b.BackColor == vfo_text_dark_color) b.BackColor = button_selected_color;
                }
                else c.Enabled = true;
            }

         
            foreach (Control c in panelBandGN.Controls) // ke9ns add
            {
                RadioButtonTS b = c as RadioButtonTS;
                //   Debug.WriteLine("enableallbands");

                if (b != null)
                {

                    if (b.Name == "panelBandHF")
                    {
                        b.Enabled = true;
                    }
                    else
                    {
                        b.Enabled = true;

                    }

                    if (b.BackColor == vfo_text_dark_color) b.BackColor = button_selected_color;
                }
                else
                {
                    c.Enabled = true;

                }
            }
          

            foreach (Control c in panelBandVHF.Controls)
            {
                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.Name == "panelBandHF") b.Enabled = true;
                    else
                    {
                        int index = Int32.Parse(b.Name.Substring(10));
                        if (xvtrForm.GetEnabled(index))
                            b.Enabled = true;
                    }

                    if (b.BackColor == vfo_text_dark_color)
                        b.BackColor = button_selected_color;
                }
                else c.Enabled = true;
            }

            //...........................

          

            foreach (Control c in panelBandHFRX2.Controls)
            {
                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.Text == "2") b.Enabled = XVTRPresent;
                    else b.Enabled = true;

                    if (b.BackColor == vfo_text_dark_color) b.BackColor = button_selected_color;
                }
                else c.Enabled = true;
            }

           
            foreach (Control c in panelBandGNRX2.Controls) // ke9ns add
            {
                RadioButtonTS b = c as RadioButtonTS;
                //   Debug.WriteLine("enableallbands");

                if (b != null)
                {

                    if (b.Name == "panelBandHFRX2")
                    {
                        b.Enabled = true;
                    }
                    else
                    {
                        b.Enabled = true;

                    }

                    if (b.BackColor == vfo_text_dark_color) b.BackColor = button_selected_color;
                }
                else
                {
                    c.Enabled = true;

                }
            }

         //   Debug.WriteLine("NOW VHFRX2");

            foreach (Control c in panelBandVHFRX2.Controls)
            {
                RadioButtonTS b = c as RadioButtonTS;
                if (b != null)
                {
                    if (b.Name == "panelBandHFRX2") b.Enabled = true;
                    else
                    {
                        int e = b.Name.IndexOf("RX2"); // ke9ns 

                        string d = b.Name.Substring(10, (e - 10));
                        //  int index = Int32.Parse(b.Name.Substring(10));
                        int index = Int32.Parse(d);

                        if (xvtrForm.GetEnabled(index))  b.Enabled = true;
                    }

                    if (b.BackColor == vfo_text_dark_color) b.BackColor = button_selected_color;
                }
                else c.Enabled = true;
            }

        } // EnableAllBands()



        //============================================================================================
        private void DisableAllModes()
        {
            foreach (RadioButtonTS r in panelMode.Controls)
            {
                r.Enabled = false;
                if (r.BackColor == button_selected_color)
                    r.BackColor = vfo_text_dark_color;
            }
        }

        private void EnableAllModes()
        {
            foreach (RadioButtonTS r in panelMode.Controls)
            {
                if (r.Text != "") r.Enabled = true;
                if (r.BackColor == vfo_text_dark_color) r.BackColor = button_selected_color;
            }
        }

        private void DisableFilters(int lowcutoff)
        {
            // Disables all filters below the number passed in. 
            // For example, DisableFilters(100) would cause the
            // 100Hz, 50Hz and 25Hz filters to be disabled.

            foreach (Control c in panelFilter.Controls)
            {
                if (c.GetType() == typeof(RadioButtonTS) && c.Name.IndexOf("Var") < 0)
                {
                    string name = c.Name;
                    int begin, len;
                    begin = name.IndexOf("Filter") + 6;
                    len = name.Length - begin;

                    int filter_width = Int32.Parse(name.Substring(begin, len));
                    if (filter_width < lowcutoff)
                    {
                        c.Enabled = false;
                        ((RadioButtonTS)c).Checked = false;
                    }
                }
            }
        }

        private void GetVFOCharWidth()
        {
            // This function calculates the pixel width of the VFO display.
            // This information is used for mouse wheel hover tuning.

            Graphics g = txtVFOAFreq.CreateGraphics();

            SizeF size = g.MeasureString("0", txtVFOAFreq.Font, 1000, StringFormat.GenericTypographic);
            vfo_char_width = (int)Math.Round(size.Width - 2.0f, 0); // subtract 2 since measure string includes 1 pixel border on each side
            float float_char_width = size.Width - 2.0f;

            size = g.MeasureString("00", txtVFOAFreq.Font, 1000, StringFormat.GenericTypographic);
            vfo_char_space = (int)Math.Round(size.Width - 2.0f - 2 * float_char_width, 0);

            size = g.MeasureString(separator, txtVFOAFreq.Font, 1000, StringFormat.GenericTypographic);
            vfo_decimal_width = (int)(size.Width - 2.0f);

            size = g.MeasureString("0" + separator + "0", txtVFOAFreq.Font, 1000, StringFormat.GenericTypographic);
            vfo_decimal_space = (int)Math.Round(size.Width - 2.0f - 2 * float_char_width, 0);


            size = g.MeasureString("1234.678901", txtVFOAFreq.Font, 1000, StringFormat.GenericTypographic); // ke9ns: only setup for 9999.999999 ghz max (you lose 1hz digit at 10ghz)
            vfo_pixel_offset = (int)Math.Round(size.Width - 2.0f, 0);

            size = g.MeasureString("0", txtVFOALSD.Font, 1000, StringFormat.GenericTypographic);
            vfo_small_char_width = (int)Math.Round(size.Width - 2.0f, 0);
            float_char_width = size.Width - 2.0f;

            size = g.MeasureString("00", txtVFOALSD.Font, 1000, StringFormat.GenericTypographic);
            vfo_small_char_space = (int)Math.Round(size.Width - 2.0f - 2 * float_char_width, 0);

            g.Dispose();
        } // GetVFOCharWidth()

        private void GetVFOSubCharWidth()
        {
            // This function calculates the pixel width of the VFO display.
            // This information is used for mouse wheel hover tuning.

            Graphics g = txtVFOABand.CreateGraphics();

            SizeF size = g.MeasureString("0", txtVFOABand.Font, 1000, StringFormat.GenericTypographic);
            vfo_sub_char_width = (int)Math.Round(size.Width - 2.0f, 0); // subtract 2 since measure string includes 1 pixel border on each side
            float float_char_width = size.Width - 2.0f;

            size = g.MeasureString("00", txtVFOABand.Font, 1000, StringFormat.GenericTypographic);
            vfo_sub_char_space = (int)Math.Round(size.Width - 2.0f - 2 * float_char_width, 0);

            size = g.MeasureString(separator, txtVFOABand.Font, 1000, StringFormat.GenericTypographic);
            vfo_sub_decimal_width = (int)(size.Width - 2.0f);

            size = g.MeasureString("0" + separator + "0", txtVFOABand.Font, 1000, StringFormat.GenericTypographic);
            vfo_sub_decimal_space = (int)Math.Round(size.Width - 2.0f - 2 * float_char_width, 0);


            size = g.MeasureString("1234.678901", txtVFOABand.Font, 1000, StringFormat.GenericTypographic);
            vfo_sub_pixel_offset = (int)Math.Round(size.Width - 2.0f, 0);

            /*size = g.MeasureString("0", txtVFOALSD.Font, 1000, StringFormat.GenericTypographic);
			vfo_small_char_width = (int)Math.Round(size.Width-2.0f, 0);
			float_char_width = size.Width-2.0f;

			size = g.MeasureString("00", txtVFOALSD.Font, 1000, StringFormat.GenericTypographic);
			vfo_small_char_space = (int)Math.Round(size.Width-2.0f - 2*float_char_width, 0);*/

            g.Dispose();
        }  // GetVFOsubcharwidth()

        public string[] filter2 = new string[20]; // ke9ns add for bandstack locking (= "@" if locked)
        public string[] filter22 = new string[20]; // ke9ns add for bandstack locking .209 vfoB
        public int iii = 0;
        public int iii2 = 0; // .209


        //==================================================================================
        // ke9ns add   VFOA and B
        public bool SaveBandAA()
        {
            //---------------------------- VFOA
            try
            {
               
                StackForm.bandstackupdate(); // ke9ns add: to update filter2[]
              

                iii = Convert.ToInt32((string)regBox1.Text);
                Debug.WriteLine("LOCK STATUS filter2[] = " + filter2[iii]);

                iii = iii - 1;

                Debug.WriteLine("index status = " + iii);

                if (iii < 0) return false; // ke9ns add  usually only happens after a new installation

            }
            catch (Exception)
            {
                Debug.WriteLine("Cant get bandstack info");
                iii = 0;
                filter2[0] = "";
                return false;
            }

            if (filter2[iii] == "@")
            {
                BandStackLock = 1;
            }
            else
            {
                BandStackLock = 0;
            }

            return true;

        } // SaveBandAA()


        //=====================================================
        public bool SaveBandBB() //.209 VFOB
        {
          
            try
            {
                 StackForm.bandstackupdate(); // ke9ns add: to update filter22[]

                iii2 = Convert.ToInt32((string)regBox12);
                Debug.WriteLine("LOCK STATUS filter22[] = " + filter22[iii2]);

                iii2 = iii2 - 1;

                Debug.WriteLine("index status = " + iii2);

                if (iii2 < 0) return false; // ke9ns add  usually only happens after a new installation

            }
            catch (Exception)
            {
                Debug.WriteLine("Cant get bandstack info");
                iii2 = 0;
                filter22[0] = "";
                return false;
            }

            if (filter22[iii2] == "@")
            {
                BandStackLock2 = 1;
            }
            else
            {
                BandStackLock2 = 0;
            }

            return true;

        } // SaveBandBB()


        //======================================================================================
        public void SaveBandA()
        {
            checkBoxIICPTT.Checked = false; // ke9ns add

            if (SaveBandAA() == false) // get bandstack Locking info
            {
                return; // prior bandstack has a problem so dont try to save.
            }

            // Used in Bandstacking algorithm
            double freq = Math.Round(VFOAFreq, 6);

            string filter = rx1_filter.ToString() + filter2[iii]; // ke9ns mod:  (add filter2 for bandstack locking)

            Debug.WriteLine("filterA save " + filter);

            string mode = rx1_dsp_mode.ToString();

            switch (rx1_band)
            {
                case Band.B160M:
                    if (freq >= 1.8 && freq < 2.0)
                        DB.SaveBandStack("160M", band_160m_index, mode, filter, freq);
                    break;
                case Band.B80M:
                    if (freq >= 3.5 && freq < 4.0)
                        DB.SaveBandStack("80M", band_80m_index, mode, filter, freq);
                    break;
                case Band.B60M:
                  
                    if (extended || (current_region != FRSRegion.US))
                    {
                        if (freq >= 5.25 && freq < 5.45) //   if (freq >= 5.0 && freq < 6.0)
                        {
                            switch (current_region)
                            {
                                case FRSRegion.UK_Plus:     // do not save 60m bandstack changes for non-channelized EU using band segments

                                    break;
                                default:
                                    DB.SaveBandStack("60M", band_60m_index, mode, filter, freq);
                                    break;
                            }
                        }
                    }
                    else
                    {
                        if (RX1IsOn60mChannel())
                            DB.SaveBandStack("60M", band_60m_index, mode, filter, freq);
                    }
                    break;
                case Band.B40M:
                    if (freq >= 7.0 && freq < 7.3)
                        DB.SaveBandStack("40M", band_40m_index, mode, filter, freq);
                    break;
                case Band.B30M:
                    if (freq >= 10.1 && freq < 10.15)
                        DB.SaveBandStack("30M", band_30m_index, mode, filter, freq);
                    break;
                case Band.B20M:
                    if (freq >= 14.0 && freq < 14.350)
                        DB.SaveBandStack("20M", band_20m_index, mode, filter, freq);
                    break;
                case Band.B17M:
                    if (freq >= 18.068 && freq < 18.168)
                        DB.SaveBandStack("17M", band_17m_index, mode, filter, freq);
                    break;
                case Band.B15M:
                    if (freq >= 21.0 && freq < 21.45)
                        DB.SaveBandStack("15M", band_15m_index, mode, filter, freq);
                    break;
                case Band.B12M:
                    if (freq >= 24.890 && freq < 24.990)
                        DB.SaveBandStack("12M", band_12m_index, mode, filter, freq);
                    break;
                case Band.B10M:
                    if (freq >= 28.0 && freq < 29.7)
                        DB.SaveBandStack("10M", band_10m_index, mode, filter, freq);
                    break;
                case Band.B6M:
                    if (freq >= 50.0 && freq < 54.0)
                        DB.SaveBandStack("6M", band_6m_index, mode, filter, freq);
                    break;
                case Band.B2M:
                    if (freq >= 134.0 && freq < 163.0) // ke9ns test was 144.0 and 148.0 .217
                        DB.SaveBandStack("2M", band_2m_index, mode, filter, freq);
                    break;
                case Band.WWV:
                    if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)  // ke9ns mod added 25mhz
                        DB.SaveBandStack("WWV", band_wwv_index, mode, filter, freq);
                    break;
                case Band.GEN:
                    DB.SaveBandStack("GEN", band_gen_index, mode, filter, freq);
                    break;


                case Band.VHF0:
                    if (freq >= xvtrForm.GetBegin(0) && freq <= xvtrForm.GetEnd(0))
                        DB.SaveBandStack("VHF0", band_vhf0_index, mode, filter, freq);
                    break;
                case Band.VHF1:
                    if (freq >= xvtrForm.GetBegin(1) && freq <= xvtrForm.GetEnd(1))
                        DB.SaveBandStack("VHF1", band_vhf1_index, mode, filter, freq);
                    break;
                case Band.VHF2:

                    if (freq >= xvtrForm.GetBegin(2) && freq <= xvtrForm.GetEnd(2)) // displays as 1240,001 in europe or 1240.001 in US
                        DB.SaveBandStack("VHF2", band_vhf2_index, mode, filter, freq);
                    break;
                case Band.VHF3:
                    if (freq >= xvtrForm.GetBegin(3) && freq <= xvtrForm.GetEnd(3))
                        DB.SaveBandStack("VHF3", band_vhf3_index, mode, filter, freq);
                    break;
                case Band.VHF4:
                    if (freq >= xvtrForm.GetBegin(4) && freq <= xvtrForm.GetEnd(4))
                        DB.SaveBandStack("VHF4", band_vhf4_index, mode, filter, freq);
                    break;
                case Band.VHF5:
                    if (freq >= xvtrForm.GetBegin(5) && freq <= xvtrForm.GetEnd(5))
                        DB.SaveBandStack("VHF5", band_vhf5_index, mode, filter, freq);
                    break;
                case Band.VHF6:
                    if (freq >= xvtrForm.GetBegin(6) && freq <= xvtrForm.GetEnd(6))
                        DB.SaveBandStack("VHF6", band_vhf6_index, mode, filter, freq);
                    break;
                case Band.VHF7:
                    if (freq >= xvtrForm.GetBegin(7) && freq <= xvtrForm.GetEnd(7))
                        DB.SaveBandStack("VHF7", band_vhf7_index, mode, filter, freq);
                    break;
                case Band.VHF8:
                    if (freq >= xvtrForm.GetBegin(8) && freq <= xvtrForm.GetEnd(8))
                        DB.SaveBandStack("VHF8", band_vhf8_index, mode, filter, freq);
                    break;
                case Band.VHF9:
                    if (freq >= xvtrForm.GetBegin(9) && freq <= xvtrForm.GetEnd(9))
                        DB.SaveBandStack("VHF9", band_vhf9_index, mode, filter, freq);
                    break;
                case Band.VHF10:
                    if (freq >= xvtrForm.GetBegin(10) && freq <= xvtrForm.GetEnd(10))
                        DB.SaveBandStack("VHF10", band_vhf10_index, mode, filter, freq);
                    break;
                case Band.VHF11:
                    if (freq >= xvtrForm.GetBegin(11) && freq <= xvtrForm.GetEnd(11))
                        DB.SaveBandStack("VHF11", band_vhf11_index, mode, filter, freq);
                    break;
                case Band.VHF12:
                    if (freq >= xvtrForm.GetBegin(12) && freq <= xvtrForm.GetEnd(12))
                        DB.SaveBandStack("VHF12", band_vhf12_index, mode, filter, freq);
                    break;
                case Band.VHF13:
                    if (freq >= xvtrForm.GetBegin(13) && freq <= xvtrForm.GetEnd(13))
                        DB.SaveBandStack("VHF13", band_vhf13_index, mode, filter, freq);
                    break;



                case Band.BLMF:                                                                     // ke9ns add down below vhf
                    if (freq >= 0.20 && freq < 1.80)
                        DB.SaveBandStack("LMF", band_LMF_index, mode, filter, freq);
                    break;
                case Band.B120M:
                    if (freq >= 2.0 && freq < 3.0)
                        DB.SaveBandStack("120M", band_120m_index, mode, filter, freq);
                    break;
                case Band.B90M:
                    if (freq >= 3.0 && freq < 3.50)
                        DB.SaveBandStack("90M", band_90m_index, mode, filter, freq);
                    break;
                case Band.B61M:
                    if (freq > 4.00 && freq < 5.25) // was 5.06
                        DB.SaveBandStack("61M", band_61m_index, mode, filter, freq);
                    break;
                case Band.B49M:
                    if (freq >= 5.45 && freq < 7.00)
                        DB.SaveBandStack("49M", band_49m_index, mode, filter, freq);
                    break;
                case Band.B41M:
                    if (freq >= 7.30 && freq < 9.0)
                        DB.SaveBandStack("41M", band_41m_index, mode, filter, freq);
                    break;
                case Band.B31M:
                    if (freq >= 9.0 && freq < 10.0 || freq >= 10.0 && freq < 10.1) // ke9ns mod 
                        DB.SaveBandStack("31M", band_31m_index, mode, filter, freq);
                    break;
                case Band.B25M:
                    if (freq > 10.15 && freq < 13.57)
                        DB.SaveBandStack("25M", band_25m_index, mode, filter, freq);
                    break;
                case Band.B22M:
                    if (freq >= 13.57 && freq < 14.00) // was 13.87
                        DB.SaveBandStack("22M", band_22m_index, mode, filter, freq);
                    break;

                case Band.B19M:
                    if (freq >= 14.350 && freq < 17.0)
                        DB.SaveBandStack("19M", band_19m_index, mode, filter, freq);
                    break;

                case Band.B16M:
                    if (freq >= 17.0 && freq < 18.0)
                        DB.SaveBandStack("16M", band_16m_index, mode, filter, freq);
                    break;
                case Band.B14M:
                    if (freq >= 18.0 && freq < 21.0)
                        DB.SaveBandStack("14M", band_14m_index, mode, filter, freq);
                    break;

                case Band.B13M:
                    if (freq >= 21.00 && freq < 25.0)
                        DB.SaveBandStack("13M", band_13m_index, mode, filter, freq);
                    break;

                case Band.B11M:
                    if (freq >= 25.0 && freq < 28.0)
                        DB.SaveBandStack("11M", band_11m_index, mode, filter, freq);
                    break;

            } // switch rx1band



        } // saveband


        //======================================================================================
        // ke9ns add .209
        public void SaveBandB()
        {

           // checkBoxIICPTT.Checked = false; // ke9ns add

            if (SaveBandBB() == false) // get bandstack Locking info
            {
                return; // prior bandstack has a problem so dont try to save.
            }

            // Used in Bandstacking algorithm
            double freq = Math.Round(VFOBFreq, 6);

            string filter = rx2_filter.ToString() + filter22[iii2]; // ke9ns mod:  (add filter2 for bandstack locking)

            Debug.WriteLine("filter22");

            string mode = rx2_dsp_mode.ToString();


            switch (rx2_band)
            {
                case Band.B160M:
                    if (freq >= 1.8 && freq < 2.0)
                        DB.SaveBandStack2("160M", band_160m_index, mode, filter, freq);
                    break;
                case Band.B80M:
                    if (freq >= 3.5 && freq < 4.0)
                        DB.SaveBandStack2("80M", band_80m_index, mode, filter, freq);
                    break;
                case Band.B60M:

                    if (extended || (current_region != FRSRegion.US))
                    {
                        if (freq >= 5.25 && freq < 5.45) //   if (freq >= 5.0 && freq < 6.0)
                        {
                            switch (current_region)
                            {
                                case FRSRegion.UK_Plus:     // do not save 60m bandstack changes for non-channelized EU using band segments

                                    break;
                                default:
                                    DB.SaveBandStack2("60M", band_60m_index, mode, filter, freq);
                                    break;
                            }
                        }
                    }
                    else
                    {
                        if (RX2IsOn60mChannel())
                            DB.SaveBandStack2("60M", band_60m_index, mode, filter, freq);
                    }
                    break;
                case Band.B40M:
                    if (freq >= 7.0 && freq < 7.3)
                        DB.SaveBandStack2("40M", band_40m_index, mode, filter, freq);
                    break;
                case Band.B30M:
                    if (freq >= 10.1 && freq < 10.15)
                        DB.SaveBandStack2("30M", band_30m_index, mode, filter, freq);
                    break;
                case Band.B20M:
                    if (freq >= 14.0 && freq < 14.350)
                        DB.SaveBandStack2("20M", band_20m_index, mode, filter, freq);
                    break;
                case Band.B17M:
                    if (freq >= 18.068 && freq < 18.168)
                        DB.SaveBandStack2("17M", band_17m_index, mode, filter, freq);
                    break;
                case Band.B15M:
                    if (freq >= 21.0 && freq < 21.45)
                        DB.SaveBandStack2("15M", band_15m_index, mode, filter, freq);
                    break;
                case Band.B12M:
                    if (freq >= 24.890 && freq < 24.990)
                        DB.SaveBandStack2("12M", band_12m_index, mode, filter, freq);
                    break;
                case Band.B10M:
                    if (freq >= 28.0 && freq < 29.7)
                        DB.SaveBandStack2("10M", band_10m_index, mode, filter, freq);
                    break;
                case Band.B6M:
                    if (freq >= 50.0 && freq < 54.0)
                        DB.SaveBandStack2("6M", band_6m_index, mode, filter, freq);
                    break;
                case Band.B2M:
                    if (freq >= 134.0 && freq < 163.0) // ke9ns test was 144.0 and 148.0 .217
                        DB.SaveBandStack2("2M", band_2m_index, mode, filter, freq);
                    break;
                case Band.WWV:
                    if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)  // ke9ns mod added 25mhz
                        DB.SaveBandStack2("WWV", band_wwv_index, mode, filter, freq);
                    break;
                case Band.GEN:
                    DB.SaveBandStack2("GEN", band_gen_index, mode, filter, freq);
                    break;


                case Band.VHF0:
                    if (freq >= xvtrForm.GetBegin(0) && freq <= xvtrForm.GetEnd(0))
                        DB.SaveBandStack2("VHF0", band_vhf0_index, mode, filter, freq);
                    break;
                case Band.VHF1:
                    if (freq >= xvtrForm.GetBegin(1) && freq <= xvtrForm.GetEnd(1))
                        DB.SaveBandStack2("VHF1", band_vhf1_index, mode, filter, freq);
                    break;
                case Band.VHF2:

                    if (freq >= xvtrForm.GetBegin(2) && freq <= xvtrForm.GetEnd(2)) // displays as 1240,001 in europe or 1240.001 in US
                        DB.SaveBandStack2("VHF2", band_vhf2_index, mode, filter, freq);
                    break;
                case Band.VHF3:
                    if (freq >= xvtrForm.GetBegin(3) && freq <= xvtrForm.GetEnd(3))
                        DB.SaveBandStack2("VHF3", band_vhf3_index, mode, filter, freq);
                    break;
                case Band.VHF4:
                    if (freq >= xvtrForm.GetBegin(4) && freq <= xvtrForm.GetEnd(4))
                        DB.SaveBandStack2("VHF4", band_vhf4_index, mode, filter, freq);
                    break;
                case Band.VHF5:
                    if (freq >= xvtrForm.GetBegin(5) && freq <= xvtrForm.GetEnd(5))
                        DB.SaveBandStack2("VHF5", band_vhf5_index, mode, filter, freq);
                    break;
                case Band.VHF6:
                    if (freq >= xvtrForm.GetBegin(6) && freq <= xvtrForm.GetEnd(6))
                        DB.SaveBandStack2("VHF6", band_vhf6_index, mode, filter, freq);
                    break;
                case Band.VHF7:
                    if (freq >= xvtrForm.GetBegin(7) && freq <= xvtrForm.GetEnd(7))
                        DB.SaveBandStack2("VHF7", band_vhf7_index, mode, filter, freq);
                    break;
                case Band.VHF8:
                    if (freq >= xvtrForm.GetBegin(8) && freq <= xvtrForm.GetEnd(8))
                        DB.SaveBandStack2("VHF8", band_vhf8_index, mode, filter, freq);
                    break;
                case Band.VHF9:
                    if (freq >= xvtrForm.GetBegin(9) && freq <= xvtrForm.GetEnd(9))
                        DB.SaveBandStack2("VHF9", band_vhf9_index, mode, filter, freq);
                    break;
                case Band.VHF10:
                    if (freq >= xvtrForm.GetBegin(10) && freq <= xvtrForm.GetEnd(10))
                        DB.SaveBandStack2("VHF10", band_vhf10_index, mode, filter, freq);
                    break;
                case Band.VHF11:
                    if (freq >= xvtrForm.GetBegin(11) && freq <= xvtrForm.GetEnd(11))
                        DB.SaveBandStack2("VHF11", band_vhf11_index, mode, filter, freq);
                    break;
                case Band.VHF12:
                    if (freq >= xvtrForm.GetBegin(12) && freq <= xvtrForm.GetEnd(12))
                        DB.SaveBandStack2("VHF12", band_vhf12_index, mode, filter, freq);
                    break;
                case Band.VHF13:
                    if (freq >= xvtrForm.GetBegin(13) && freq <= xvtrForm.GetEnd(13))
                        DB.SaveBandStack2("VHF13", band_vhf13_index, mode, filter, freq);
                    break;



                case Band.BLMF:                                                                     // ke9ns add down below vhf
                    if (freq >= 0.20 && freq < 1.80)
                        DB.SaveBandStack2("LMF", band_LMF_index, mode, filter, freq);
                    break;
                case Band.B120M:
                    if (freq >= 2.0 && freq < 3.0)
                        DB.SaveBandStack2("120M", band_120m_index, mode, filter, freq);
                    break;
                case Band.B90M:
                    if (freq >= 3.0 && freq < 3.50)
                        DB.SaveBandStack2("90M", band_90m_index, mode, filter, freq);
                    break;
                case Band.B61M:
                    if (freq > 4.00 && freq < 5.25) // was 5.06
                        DB.SaveBandStack2("61M", band_61m_index, mode, filter, freq);
                    break;
                case Band.B49M:
                    if (freq >= 5.45 && freq < 7.00)
                        DB.SaveBandStack2("49M", band_49m_index, mode, filter, freq);
                    break;
                case Band.B41M:
                    if (freq >= 7.30 && freq < 9.0)
                        DB.SaveBandStack2("41M", band_41m_index, mode, filter, freq);
                    break;
                case Band.B31M:
                    if (freq >= 9.0 && freq < 10.0 || freq >= 10.0 && freq < 10.1) // ke9ns mod 
                        DB.SaveBandStack2("31M", band_31m_index, mode, filter, freq);
                    break;
                case Band.B25M:
                    if (freq > 10.15 && freq < 13.57)
                        DB.SaveBandStack2("25M", band_25m_index, mode, filter, freq);
                    break;
                case Band.B22M:
                    if (freq >= 13.57 && freq < 14.00) // was 13.87
                        DB.SaveBandStack2("22M", band_22m_index, mode, filter, freq);
                    break;

                case Band.B19M:
                    if (freq >= 14.350 && freq < 17.0)
                        DB.SaveBandStack2("19M", band_19m_index, mode, filter, freq);
                    break;

                case Band.B16M:
                    if (freq >= 17.0 && freq < 18.0)
                        DB.SaveBandStack2("16M", band_16m_index, mode, filter, freq);
                    break;
                case Band.B14M:
                    if (freq >= 18.0 && freq < 21.0)
                        DB.SaveBandStack2("14M", band_14m_index, mode, filter, freq);
                    break;

                case Band.B13M:
                    if (freq >= 21.00 && freq < 25.0)
                        DB.SaveBandStack2("13M", band_13m_index, mode, filter, freq);
                    break;

                case Band.B11M:
                    if (freq >= 25.0 && freq < 28.0)
                        DB.SaveBandStack2("11M", band_11m_index, mode, filter, freq);
                    break;

            } // switch rx2band



        } // saveband2



        public void SetBand(string mode, string filter, double freq)
        {
            if (filter.Contains("@"))
            {
                filter = filter.Substring(0, (filter.Length) - 1); // ke9ns add: for bandstack lockout
            }
            if (freq > 9999.999999) // .228
            {
                if (setupForm != null && setupForm.chkVFOLargeWindow.Checked == false) setupForm.chkVFOLargeWindow.Checked = true;
            }

            // Set mode, filter, and frequency according to passed parameters
            RX1DSPMode = (DSPMode)Enum.Parse(typeof(DSPMode), mode, true);

            if (rx1_dsp_mode != DSPMode.DRM && rx1_dsp_mode != DSPMode.SPEC)
            {
                RX1Filter = (Filter)Enum.Parse(typeof(Filter), filter, true);
            }

            VFOAFreq = freq;

            tempVFOAFreq = VFOAFreq; // ke9ns add  CTUN operation changed freq so update temp value

            if (SpotForm != null) // ke9ns add .157
            {
                if (SpotControl.SP_Active > 2)
                {
                    SpotForm.processTCPMessage(); // upate the spotter that you changed bands
                }

            }

            // voacap

        } // setband

        // ke9ns add .206 band stack to vfoB
        public void SetBand2(string mode, string filter, double freq)
        {
            if (filter.Contains("@"))
            {
                filter = filter.Substring(0, (filter.Length) - 1); // ke9ns add: for bandstack lockout
            }

            if (freq > 9999.999999) // .228
            {
                if (setupForm != null && setupForm.chkVFOLargeWindow.Checked == false) setupForm.chkVFOLargeWindow.Checked = true;
            }

            // Set mode, filter, and frequency according to passed parameters
            RX2DSPMode = (DSPMode)Enum.Parse(typeof(DSPMode), mode, true);

            if (rx2_dsp_mode != DSPMode.DRM && rx2_dsp_mode != DSPMode.SPEC)
            {
                RX2Filter = (Filter)Enum.Parse(typeof(Filter), filter, true);
            }

            VFOBFreq = freq;

          //  tempVFOAFreq = VFOAFreq; // ke9ns add  CTUN operation changed freq so update temp value

            if (SpotForm != null) // ke9ns add .157
            {
                if (SpotControl.SP_Active > 2)
                {
                    SpotForm.processTCPMessage(); // upate the spotter that you changed bands
                }

            }

           

        } // setband2




        public int last_MHZ = 0; // ke9ns  used on voacap routine
        public DSPMode last_MODE = DSPMode.LAST;

        private void ChangeTuneStepUp()
        {
            tune_step_index = (tune_step_index + 1) % tune_step_list.Count;
            txtWheelTune.Text = tune_step_list[tune_step_index].Name;

        }

        private void ChangeTuneStepDown()
        {
            tune_step_index = (tune_step_index - 1 + tune_step_list.Count) % tune_step_list.Count;
            txtWheelTune.Text = tune_step_list[tune_step_index].Name;

        }

        private void UpdateBandButtonColors()
        {
            /*SetRX1BandButtonColor(rx1_band);
			SetTXBandButtonColor(tx_band);
			SetRX2BandButtonColor(rx2_band);*/

           
            SetRX1BandButton(rx1_band);
            
            if (FWCEEPROM.RX2OK)  SetRX2BandButton(rx2_band);
        }

        private void DeselectHF()
        {
            radBand160.Checked = false;
            radBand80.Checked = false;
            radBand60.Checked = false;
            radBand40.Checked = false;
            radBand30.Checked = false;
            radBand20.Checked = false;
            radBand17.Checked = false;
            radBand15.Checked = false;
            radBand12.Checked = false;
            radBand10.Checked = false;
            radBand6.Checked = false;
            radBandWWV.Checked = false;
            radBandGEN.Checked = false;
            radBand2.Checked = false;
        }

        // ke9ns .203
        private void DeselectHFRX2()
        {
            radBand160RX2.Checked = false;
            radBand80RX2.Checked = false;
            radBand60RX2.Checked = false;
            radBand40RX2.Checked = false;
            radBand30RX2.Checked = false;
            radBand20RX2.Checked = false;
            radBand17RX2.Checked = false;
            radBand15RX2.Checked = false;
            radBand12RX2.Checked = false;
            radBand10RX2.Checked = false;
            radBand6RX2.Checked = false;
            radBandWWVRX2.Checked = false;
            radBandGENRX2.Checked = false;
            radBand2RX2.Checked = false;
        }

        private void DeselectGEN()  // ke9ns add
        {
            radBandGN0.Checked = false;
            radBandGN1.Checked = false;
            radBandGN2.Checked = false;
            radBandGN3.Checked = false;
            radBandGN4.Checked = false;
            radBandGN5.Checked = false;
            radBandGN6.Checked = false;
            radBandGN7.Checked = false;
            radBandGN8.Checked = false;
            radBandGN9.Checked = false;
            radBandGN10.Checked = false;
            radBandGN11.Checked = false;
            radBandGN12.Checked = false;
            radBandGN13.Checked = false;

        }
        private void DeselectGENRX2()  // ke9ns add
        {
            radBandGN0RX2.Checked = false;
            radBandGN1RX2.Checked = false;
            radBandGN2RX2.Checked = false;
            radBandGN3RX2.Checked = false;
            radBandGN4RX2.Checked = false;
            radBandGN5RX2.Checked = false;
            radBandGN6RX2.Checked = false;
            radBandGN7RX2.Checked = false;
            radBandGN8RX2.Checked = false;
            radBandGN9RX2.Checked = false;
            radBandGN10RX2.Checked = false;
            radBandGN11RX2.Checked = false;
            radBandGN12RX2.Checked = false;
            radBandGN13RX2.Checked = false;

        }

        private void DeselectVHF()
        {
            radBandVHF0.Checked = false;
            radBandVHF1.Checked = false;
            radBandVHF2.Checked = false;
            radBandVHF3.Checked = false;
            radBandVHF4.Checked = false;
            radBandVHF5.Checked = false;
            radBandVHF6.Checked = false;
            radBandVHF7.Checked = false;
            radBandVHF8.Checked = false;
            radBandVHF9.Checked = false;
            radBandVHF10.Checked = false;
            radBandVHF11.Checked = false;
            radBandVHF12.Checked = false;
            radBandVHF13.Checked = false;

        }

        private void DeselectVHFRX2()
        {
            radBandVHF0RX2.Checked = false;
            radBandVHF1RX2.Checked = false;
            radBandVHF2RX2.Checked = false;
            radBandVHF3RX2.Checked = false;
            radBandVHF4RX2.Checked = false;
            radBandVHF5RX2.Checked = false;
            radBandVHF6RX2.Checked = false;
            radBandVHF7RX2.Checked = false;
            radBandVHF8RX2.Checked = false;
            radBandVHF9RX2.Checked = false;
            radBandVHF10RX2.Checked = false;
            radBandVHF11RX2.Checked = false;
            radBandVHF12RX2.Checked = false;
            radBandVHF13RX2.Checked = false;

        }

       
        //===================================================
     

      


        //====================================================================
        // ke9ns mod  change the band button as you click them for RX1
        private void SetRX1BandButton(Band b)
        {

            SpotControl.VFOLOW = 0;   // ke9ns add default values (used in spot.cs for mapping dx spots)
            SpotControl.VFOHIGH = 1;  // ke9ns add default values

            switch (b)
            {
                case Band.B160M:
                    SpotControl.VFOLOW = 1800000; // ke9ns add
                    SpotControl.VFOHIGH = 2000000;// ke9ns add

                    last_band = "160M"; // ke9ns add
                    radBand160.Checked = true;
                    regBox.Text = band_160m_register.ToString();     // ke9ns add box to show the total # of bankstacks in memory
                    regBox1.Text = (band_160m_index + 1).ToString();  // ke9ns add box to show which bandstack your on
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B80M:
                    last_band = "80M";// ke9ns add
                    SpotControl.VFOLOW = 3500000;
                    SpotControl.VFOHIGH = 4000000;
                    radBand80.Checked = true;
                    regBox.Text = band_80m_register.ToString();
                    regBox1.Text = (band_80m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B60M:
                    last_band = "60M";// ke9ns add
                    SpotControl.VFOLOW = 5250000; // was  5000000
                    SpotControl.VFOHIGH = 5450000; // was 6000000
                    radBand60.Checked = true;
                    regBox.Text = band_60m_register.ToString();
                    regBox1.Text = (band_60m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B40M:
                    last_band = "40M";// ke9ns add
                    SpotControl.VFOLOW = 7000000;
                    SpotControl.VFOHIGH = 7300000;
                    radBand40.Checked = true;
                    regBox.Text = band_40m_register.ToString();
                    regBox1.Text = (band_40m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B30M:
                    last_band = "30M";// ke9ns add
                    SpotControl.VFOLOW = 10100000;
                    SpotControl.VFOHIGH = 10150000;
                    radBand30.Checked = true;
                    regBox.Text = band_30m_register.ToString();
                    regBox1.Text = (band_30m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B20M:
                    last_band = "20M";// ke9ns add
                    SpotControl.VFOLOW = 14000000;
                    SpotControl.VFOHIGH = 14350000;
                    radBand20.Checked = true;
                    regBox.Text = band_20m_register.ToString();
                    regBox1.Text = (band_20m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B17M:
                    last_band = "17M";// ke9ns add
                    SpotControl.VFOLOW = 18000000; // 18.068
                    SpotControl.VFOHIGH = 18200000; // 18.168
                    radBand17.Checked = true;
                    regBox.Text = band_17m_register.ToString();
                    regBox1.Text = (band_17m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B15M:
                    last_band = "15M";// ke9ns add
                    SpotControl.VFOLOW = 21000000; // 
                    SpotControl.VFOHIGH = 21450000; // 
                    radBand15.Checked = true;
                    regBox.Text = band_15m_register.ToString();
                    regBox1.Text = (band_15m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B12M:
                    last_band = "12M";// ke9ns add
                    SpotControl.VFOLOW = 24890000; // 24.89
                    SpotControl.VFOHIGH = 24990000; // 24.99
                    radBand12.Checked = true;
                    regBox.Text = band_12m_register.ToString();
                    regBox1.Text = (band_12m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B10M:
                    last_band = "10M";// ke9ns add
                    SpotControl.VFOLOW = 28000000; // 
                    SpotControl.VFOHIGH = 30000000; // 
                    radBand10.Checked = true;
                    regBox.Text = band_10m_register.ToString();
                    regBox1.Text = (band_10m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B6M:
                    last_band = "6M";// ke9ns add
                    SpotControl.VFOLOW = 50000000; // 
                    SpotControl.VFOHIGH = 54000000; //
                    radBand6.Checked = true;
                    regBox.Text = band_6m_register.ToString();
                    regBox1.Text = (band_6m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.B2M:
                    //  last_band = "2M";// ke9ns add // ke9ns mod
                    //  SpotControl.VFOLOW = 144000000; // 
                    //  SpotControl.VFOHIGH = 146000000; // 
                    //  radBand2.Checked = true;
                    //   regBox.Text = band_2m_register.ToString();
                    //  regBox1.Text = (band_2m_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.WWV:
                    last_band = "WWV";// ke9ns add
                    radBandWWV.Checked = true;
                    regBox.Text = band_wwv_register.ToString();
                    regBox1.Text = (band_wwv_index + 1).ToString();
                    DeselectVHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.GEN:
                    last_band = "GEN";// ke9ns add
                                      //   Debug.WriteLine("gen pushed");
                    radBandGEN.Checked = true;
                    DeselectVHF();
                    DeselectHF(); // ke9ns add
                    break;


                case Band.VHF0:
                    last_band = "VHF0";// ke9ns add
                    SpotControl.VFOLOW = 144000000; // 
                    SpotControl.VFOHIGH = 146000000; // 
                    radBandVHF0.Checked = true;
                    regBox.Text = band_vhf0_register.ToString();
                    regBox1.Text = (band_vhf0_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF1:
                    last_band = "VHF1";// ke9ns add
                    SpotControl.VFOLOW = 430000000; // 
                    SpotControl.VFOHIGH = 445000000; // 
                    radBandVHF1.Checked = true;
                    regBox.Text = band_vhf1_register.ToString();
                    regBox1.Text = (band_vhf1_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF2:
                    last_band = "VHF2";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 990000000; //
                    radBandVHF2.Checked = true;
                    regBox.Text = band_vhf2_register.ToString();
                    regBox1.Text = (band_vhf2_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF3:
                    last_band = "VHF3";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF3.Checked = true;
                    regBox.Text = band_vhf3_register.ToString();
                    regBox1.Text = (band_vhf3_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF4:
                    last_band = "VHF4";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF4.Checked = true;
                    regBox.Text = band_vhf4_register.ToString();
                    regBox1.Text = (band_vhf4_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF5:
                    last_band = "VHF5";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF5.Checked = true;
                    regBox.Text = band_vhf5_register.ToString();
                    regBox1.Text = (band_vhf5_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF6:
                    last_band = "VHF6";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF6.Checked = true;
                    regBox.Text = band_vhf6_register.ToString();
                    regBox1.Text = (band_vhf6_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF7:
                    last_band = "VHF7";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF7.Checked = true;
                    regBox.Text = band_vhf7_register.ToString();
                    regBox1.Text = (band_vhf7_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF8:
                    last_band = "VHF8";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF8.Checked = true;
                    regBox.Text = band_vhf8_register.ToString();
                    regBox1.Text = (band_vhf8_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF9:
                    last_band = "VHF9";// ke9ns add 
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF9.Checked = true;
                    regBox.Text = band_vhf9_register.ToString();
                    regBox1.Text = (band_vhf9_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF10:
                    last_band = "VHF10";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF10.Checked = true;
                    regBox.Text = band_vhf10_register.ToString();
                    regBox1.Text = (band_vhf10_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF11:
                    last_band = "VHF11";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF11.Checked = true;
                    regBox.Text = band_vhf11_register.ToString();
                    regBox1.Text = (band_vhf11_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF12:
                    last_band = "VHF12";// ke9ns add
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF12.Checked = true;
                    regBox.Text = band_vhf12_register.ToString();
                    regBox1.Text = (band_vhf12_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;
                case Band.VHF13:
                    last_band = "VHF13";// ke9ns add 
                    SpotControl.VFOLOW = 445000000; // 
                    SpotControl.VFOHIGH = 9999999999; //
                    radBandVHF13.Checked = true;
                    regBox.Text = band_vhf13_register.ToString();
                    regBox1.Text = (band_vhf13_index + 1).ToString();
                    DeselectHF();
                    DeselectGEN(); // ke9ns add
                    break;


                case Band.BLMF:
                    last_band = "LMF";// ke9ns add
                    radBandGN0.Checked = true;
                    regBox.Text = band_LMF_register.ToString();
                    regBox1.Text = (band_LMF_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B120M:
                    last_band = "120M";// ke9ns add
                    radBandGN1.Checked = true;
                    regBox.Text = band_120m_register.ToString();
                    regBox1.Text = (band_120m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B90M:
                    last_band = "90M";// ke9ns add
                    radBandGN2.Checked = true;
                    regBox.Text = band_90m_register.ToString();
                    regBox1.Text = (band_90m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B61M:
                    last_band = "61M";// ke9ns add
                    radBandGN3.Checked = true;
                    regBox.Text = band_61m_register.ToString();
                    regBox1.Text = (band_61m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B49M:
                    //   Debug.WriteLine("================49==============");
                    last_band = "49M";// ke9ns add
                    radBandGN4.Checked = true;
                    regBox.Text = band_49m_register.ToString();
                    regBox1.Text = (band_49m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B41M:
                    last_band = "41M";// ke9ns add
                                      //  Debug.WriteLine("================41==============");

                    radBandGN5.Checked = true;
                    regBox.Text = band_41m_register.ToString();
                    regBox1.Text = (band_41m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B31M:
                    last_band = "31M";// ke9ns add
                    radBandGN6.Checked = true;
                    regBox.Text = band_31m_register.ToString();
                    regBox1.Text = (band_31m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B25M:
                    last_band = "25M";// ke9ns add
                    radBandGN7.Checked = true;
                    regBox.Text = band_25m_register.ToString();
                    regBox1.Text = (band_25m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B22M:
                    last_band = "22M";// ke9ns add
                    radBandGN8.Checked = true;
                    regBox.Text = band_22m_register.ToString();
                    regBox1.Text = (band_22m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B19M:
                    last_band = "19M";// ke9ns add
                    radBandGN9.Checked = true;
                    regBox.Text = band_19m_register.ToString();
                    regBox1.Text = (band_19m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B16M:
                    last_band = "16M";// ke9ns add
                    radBandGN10.Checked = true;
                    regBox.Text = band_16m_register.ToString();
                    regBox1.Text = (band_16m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B14M:
                    last_band = "14M";// ke9ns add
                    radBandGN11.Checked = true;
                    regBox.Text = band_14m_register.ToString();
                    regBox1.Text = (band_14m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B13M:
                    last_band = "13M";// ke9ns add
                    radBandGN12.Checked = true;
                    regBox.Text = band_13m_register.ToString();
                    regBox1.Text = (band_13m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;
                case Band.B11M:
                    last_band = "11M";// ke9ns add
                    radBandGN13.Checked = true;
                    regBox.Text = band_11m_register.ToString();
                    regBox1.Text = (band_11m_index + 1).ToString();
                    DeselectHF();
                    DeselectVHF(); // ke9ns add
                    break;


            }

           
            StackForm.bandstackupdate(); // ke9ns add update band stack screen 

          


        } // setrx1 band button
        public string regBox2 = "";
        public string regBox12 = "";

        //====================================================================
        // ke9ns mod  change the band button as you click them for RX2 .209
        private void SetRX2BandButton(Band b)
        {
          
            switch (b)
            {
                case Band.B160M:
                    last_band2 = "160M"; // ke9ns add
                    radBand160RX2.Checked = true;
                    regBox2  = band_160m_register.ToString();     // ke9ns add box to show the total # of bankstacks in memory
                    regBox12  = (band_160m_index + 1).ToString();  // ke9ns add box to show which bandstack your on
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B80M:
                    last_band2 = "80M";// ke9ns add
                     radBand80RX2.Checked = true;
                    regBox2  = band_80m_register.ToString();
                    regBox12  = (band_80m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B60M:
                    last_band2 = "60M";// ke9ns add
                      radBand60RX2.Checked = true;
                    regBox2  = band_60m_register.ToString();
                    regBox12  = (band_60m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B40M:
                    last_band2 = "40M";// ke9ns add
                     radBand40RX2.Checked = true;
                    regBox2  = band_40m_register.ToString();
                    regBox12  = (band_40m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B30M:
                    last_band2 = "30M";// ke9ns add
                    radBand30RX2.Checked = true;
                    regBox2  = band_30m_register.ToString();
                    regBox12  = (band_30m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B20M:
                    last_band2 = "20M";// ke9ns add
                    radBand20RX2.Checked = true;
                    regBox2  = band_20m_register.ToString();
                    regBox12  = (band_20m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B17M:
                    last_band2 = "17M";// ke9ns add
                     radBand17RX2.Checked = true;
                    regBox2  = band_17m_register.ToString();
                    regBox12  = (band_17m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B15M:
                    last_band2 = "15M";// ke9ns add
                     radBand15RX2.Checked = true;
                    regBox2  = band_15m_register.ToString();
                    regBox12  = (band_15m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B12M:
                    last_band2 = "12M";// ke9ns add
                    SpotControl.VFOLOW = 24890000; // 24.89
                    SpotControl.VFOHIGH = 24990000; // 24.99
                    radBand12RX2.Checked = true;
                    regBox2  = band_12m_register.ToString();
                    regBox12  = (band_12m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B10M:
                    last_band2 = "10M";// ke9ns add
                    radBand10RX2.Checked = true;
                    regBox2  = band_10m_register.ToString();
                    regBox12  = (band_10m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B6M:
                    last_band2 = "6M";// ke9ns add
                     radBand6RX2.Checked = true;
                    regBox2  = band_6m_register.ToString();
                    regBox12  = (band_6m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.B2M:
                    //  last_band2 = "2M";// ke9ns add // ke9ns mod
                      //  radBand2RX2.Checked = true;
                    //   regBox2  = band_2m_register.ToString();
                    //  regBox12  = (band_2m_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.WWV:
                    last_band2 = "WWV";// ke9ns add
                    radBandWWVRX2.Checked = true;
                    regBox2  = band_wwv_register.ToString();
                    regBox12  = (band_wwv_index + 1).ToString();
                    DeselectVHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.GEN:
                    last_band2 = "GEN";// ke9ns add
                                      //   Debug.WriteLine("gen pushed");
                    radBandGENRX2.Checked = true;
                    DeselectVHFRX2();
                    DeselectHFRX2(); // ke9ns add
                    break;


                case Band.VHF0:
                    last_band2 = "VHF0";// ke9ns add
                    radBandVHF0RX2.Checked = true;
                    regBox2  = band_vhf0_register.ToString();
                    regBox12  = (band_vhf0_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF1:
                    last_band2 = "VHF1";// ke9ns add
                    radBandVHF1RX2.Checked = true;
                    regBox2  = band_vhf1_register.ToString();
                    regBox12  = (band_vhf1_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF2:
                    last_band2 = "VHF2";// ke9ns add
                    radBandVHF2RX2.Checked = true;
                    regBox2  = band_vhf2_register.ToString();
                    regBox12  = (band_vhf2_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF3:
                    last_band2 = "VHF3";// ke9ns add
                     radBandVHF3RX2.Checked = true;
                    regBox2  = band_vhf3_register.ToString();
                    regBox12  = (band_vhf3_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF4:
                    last_band2 = "VHF4";// ke9ns add
                     radBandVHF4RX2.Checked = true;
                    regBox2  = band_vhf4_register.ToString();
                    regBox12  = (band_vhf4_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF5:
                    last_band2 = "VHF5";// ke9ns add
                     radBandVHF5RX2.Checked = true;
                    regBox2  = band_vhf5_register.ToString();
                    regBox12  = (band_vhf5_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF6:
                    last_band2 = "VHF6";// ke9ns add
                    radBandVHF6RX2.Checked = true;
                    regBox2  = band_vhf6_register.ToString();
                    regBox12  = (band_vhf6_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF7:
                    last_band2 = "VHF7";// ke9ns add
                     radBandVHF7RX2.Checked = true;
                    regBox2  = band_vhf7_register.ToString();
                    regBox12  = (band_vhf7_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF8:
                    last_band2 = "VHF8";// ke9ns add
                     radBandVHF8RX2.Checked = true;
                    regBox2  = band_vhf8_register.ToString();
                    regBox12  = (band_vhf8_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF9:
                    last_band2 = "VHF9";// ke9ns add 
                    radBandVHF9RX2.Checked = true;
                    regBox2  = band_vhf9_register.ToString();
                    regBox12  = (band_vhf9_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF10:
                    last_band2 = "VHF10";// ke9ns add
                     radBandVHF10RX2.Checked = true;
                    regBox2  = band_vhf10_register.ToString();
                    regBox12  = (band_vhf10_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF11:
                    last_band2 = "VHF11";// ke9ns add
                    radBandVHF11RX2.Checked = true;
                    regBox2  = band_vhf11_register.ToString();
                    regBox12  = (band_vhf11_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF12:
                    last_band2 = "VHF12";// ke9ns add
                     radBandVHF12RX2.Checked = true;
                    regBox2  = band_vhf12_register.ToString();
                    regBox12  = (band_vhf12_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;
                case Band.VHF13:
                    last_band2 = "VHF13";// ke9ns add 
                     radBandVHF13RX2.Checked = true;
                    regBox2  = band_vhf13_register.ToString();
                    regBox12  = (band_vhf13_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectGENRX2(); // ke9ns add
                    break;


                case Band.BLMF:
                    last_band2 = "LMF";// ke9ns add
                    radBandGN0RX2.Checked = true;
                    regBox2  = band_LMF_register.ToString();
                    regBox12  = (band_LMF_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B120M:
                    last_band2 = "120M";// ke9ns add
                    radBandGN1RX2.Checked = true;
                    regBox2  = band_120m_register.ToString();
                    regBox12  = (band_120m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B90M:
                    last_band2 = "90M";// ke9ns add
                    radBandGN2RX2.Checked = true;
                    regBox2  = band_90m_register.ToString();
                    regBox12  = (band_90m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B61M:
                    last_band2 = "61M";// ke9ns add
                    radBandGN3RX2.Checked = true;
                    regBox2  = band_61m_register.ToString();
                    regBox12  = (band_61m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B49M:
                    //   Debug.WriteLine("================49==============");
                    last_band2 = "49M";// ke9ns add
                    radBandGN4RX2.Checked = true;
                    regBox2  = band_49m_register.ToString();
                    regBox12  = (band_49m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B41M:
                    last_band2 = "41M";// ke9ns add
                                      //  Debug.WriteLine("================41==============");

                    radBandGN5RX2.Checked = true;
                    regBox2  = band_41m_register.ToString();
                    regBox12  = (band_41m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B31M:
                    last_band2 = "31M";// ke9ns add
                    radBandGN6RX2.Checked = true;
                    regBox2  = band_31m_register.ToString();
                    regBox12  = (band_31m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B25M:
                    last_band2 = "25M";// ke9ns add
                    radBandGN7RX2.Checked = true;
                    regBox2  = band_25m_register.ToString();
                    regBox12  = (band_25m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B22M:
                    last_band2 = "22M";// ke9ns add
                    radBandGN8RX2.Checked = true;
                    regBox2  = band_22m_register.ToString();
                    regBox12  = (band_22m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B19M:
                    last_band2 = "19M";// ke9ns add
                    radBandGN9RX2.Checked = true;
                    regBox2  = band_19m_register.ToString();
                    regBox12  = (band_19m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B16M:
                    last_band2 = "16M";// ke9ns add
                    radBandGN10RX2.Checked = true;
                    regBox2  = band_16m_register.ToString();
                    regBox12  = (band_16m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B14M:
                    last_band2 = "14M";// ke9ns add
                    radBandGN11RX2.Checked = true;
                    regBox2  = band_14m_register.ToString();
                    regBox12  = (band_14m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B13M:
                    last_band2 = "13M";// ke9ns add
                    radBandGN12RX2.Checked = true;
                    regBox2  = band_13m_register.ToString();
                    regBox12  = (band_13m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;
                case Band.B11M:
                    last_band2 = "11M";// ke9ns add
                    radBandGN13RX2.Checked = true;
                    regBox2  = band_11m_register.ToString();
                    regBox12  = (band_11m_index + 1).ToString();
                    DeselectHFRX2();
                    DeselectVHFRX2(); // ke9ns add
                    break;


            }

            StackForm.bandstackupdate(); // ke9ns add update band stack screen 


        } // setrx2 band button



        private void SetRX1BandButtonColor(Band b)
        {
            // Sets band button color based on passed band.

            /*Button btn = null;
			switch(b)
			{
				case Band.GEN:
					btn = btnBandGEN;
					break;
				case Band.B160M:
					btn = btnBand160;
					break;
				case Band.B80M:
					btn = btnBand80;
					break;
				case Band.B60M:
					btn = btnBand60;
					break;
				case Band.B40M:
					btn = btnBand40;
					break;
				case Band.B30M:
					btn = btnBand30;
					break;
				case Band.B20M:
					btn = btnBand20;
					break;
				case Band.B17M:
					btn = btnBand17;
					break;
				case Band.B15M:
					btn = btnBand15;
					break;
				case Band.B12M:
					btn = btnBand12;
					break;
				case Band.B10M:
					btn = btnBand10;
					break;
				case Band.B6M:
					btn = btnBand6;
					break;
				case Band.B2M:
					btn = btnBand2;
					break;
				case Band.WWV:
					btn = btnBandWWV;
					break;
				case Band.VHF0:
					btn = btnBandVHF0;
					break;
				case Band.VHF1:
					btn = btnBandVHF1;
					break;
				case Band.VHF2:
					btn = btnBandVHF2;
					break;
				case Band.VHF3:
					btn = btnBandVHF3;
					break;
				case Band.VHF4:
					btn = btnBandVHF4;
					break;
				case Band.VHF5:
					btn = btnBandVHF5;
					break;
				case Band.VHF6:
					btn = btnBandVHF6;
					break;
				case Band.VHF7:
					btn = btnBandVHF7;
					break;
				case Band.VHF8:
					btn = btnBandVHF8;
					break;
				case Band.VHF9:
					btn = btnBandVHF9;
					break;
				case Band.VHF10:
					btn = btnBandVHF10;
					break;
				case Band.VHF11:
					btn = btnBandVHF11;
					break;
				case Band.VHF12:
					btn = btnBandVHF12;
					break;
				case Band.VHF13:
					btn = btnBandVHF13;
					break;
			}

			foreach(Button b2 in panelBandHF.Controls)
			{
				if(b2 == btn)
				{
					b2.BackColor = rx1_band_color;
				}
				else
				{
					if(b2.BackColor == rx1_band_color)
						b2.BackColor = SystemColors.Control;
				}
			}

			foreach(Button b2 in panelBandVHF.Controls)
			{
				if(b2 == btn)
				{
					b2.BackColor = rx1_band_color;
				}
				else
				{
					if(b2.BackColor == rx1_band_color)
						b2.BackColor = SystemColors.Control;
				}
			}*/
        }

        private void SetRX2BandButtonColor(Band b)
        {
            /*// Sets band button color based on passed band.
			if(!rx2_enabled) b = Band.FIRST;
			Button btn = null;
			switch(b)
			{
				case Band.GEN:
					btn = btnBandGEN;
					break;
				case Band.B160M:
					btn = btnBand160;
					break;
				case Band.B80M:
					btn = btnBand80;
					break;
				case Band.B60M:
					btn = btnBand60;
					break;
				case Band.B40M:
					btn = btnBand40;
					break;
				case Band.B30M:
					btn = btnBand30;
					break;
				case Band.B20M:
					btn = btnBand20;
					break;
				case Band.B17M:
					btn = btnBand17;
					break;
				case Band.B15M:
					btn = btnBand15;
					break;
				case Band.B12M:
					btn = btnBand12;
					break;
				case Band.B10M:
					btn = btnBand10;
					break;
				case Band.B6M:
					btn = btnBand6;
					break;
				case Band.B2M:
					btn = btnBand2;
					break;
				case Band.WWV:
					btn = btnBandWWV;
					break;
				case Band.VHF0:
					btn = btnBandVHF0;
					break;
				case Band.VHF1:
					btn = btnBandVHF1;
					break;
				case Band.VHF2:
					btn = btnBandVHF2;
					break;
				case Band.VHF3:
					btn = btnBandVHF3;
					break;
				case Band.VHF4:
					btn = btnBandVHF4;
					break;
				case Band.VHF5:
					btn = btnBandVHF5;
					break;
				case Band.VHF6:
					btn = btnBandVHF6;
					break;
				case Band.VHF7:
					btn = btnBandVHF7;
					break;
				case Band.VHF8:
					btn = btnBandVHF8;
					break;
				case Band.VHF9:
					btn = btnBandVHF9;
					break;
				case Band.VHF10:
					btn = btnBandVHF10;
					break;
				case Band.VHF11:
					btn = btnBandVHF11;
					break;
				case Band.VHF12:
					btn = btnBandVHF12;
					break;
				case Band.VHF13:
					btn = btnBandVHF13;
					break;
			}

			foreach(Button b2 in panelBandHF.Controls)
			{
				if(b2 == btn && b2.BackColor != rx1_band_color && b2.BackColor != tx_band_color)
				{
					b2.BackColor = rx2_band_color;
				}
				else
				{
					if(b2.BackColor == rx2_band_color)
						b2.BackColor = SystemColors.Control;
				}
			}

			foreach(Button b2 in panelBandVHF.Controls)
			{
				if(b2 == btn && b2.BackColor != rx1_band_color && b2.BackColor != tx_band_color)
				{
					b2.BackColor = rx2_band_color;
				}
				else
				{
					if(b2.BackColor == rx2_band_color)
						b2.BackColor = SystemColors.Control;
				}
			}
			/*if(b < Band.VHF0)
			{
//				if(!grpBandHF.Visible)
//				{
//					grpBandHF.Visible = true;
//					grpBandVHF.Visible = false;
//				}

				foreach(Button b2 in grpBandVHF.Controls)
					b2.BackColor = SystemColors.Control;

				foreach(Button b2 in grpBandHF.Controls)
				{
					if(b2 == btn && b2.BackColor != rx1_band_color && b2.BackColor != tx_band_color)
					{
						b2.BackColor = rx2_band_color;
					}
					else
					{
						if(b2.BackColor == rx2_band_color)
							b2.BackColor = SystemColors.Control;
					}

//					Color c = SystemColors.Control;
//					if(b2 == btn)
//						c = button_selected_color;
//
//					b2.BackColor = c;
				}
			}
			else
			{
//				if(!grpBandVHF.Visible)
//				{
//					grpBandVHF.Visible = true;
//					grpBandHF.Visible = false;
//				}

				foreach(Button b2 in grpBandHF.Controls)
					b2.BackColor = SystemColors.Control;

				foreach(Button b2 in grpBandVHF.Controls)
				{
					if(b2 == btn && b2.BackColor != rx1_band_color && b2.BackColor != tx_band_color)
					{
						b2.BackColor = rx2_band_color;
					}
					else
					{
						if(b2.BackColor == rx2_band_color)
							b2.BackColor = SystemColors.Control;
					}

//					Color c = SystemColors.Control;
//					if(b2 == btn)
//						c = button_selected_color;
//
//					b2.BackColor = c;
				}
			}*/
        }

        private void SetTXBandButtonColor(Band b)
        {
            /*// Sets band button color based on passed band.

			Button btn = null;
			switch(b)
			{
				case Band.GEN:
					btn = btnBandGEN;
					break;
				case Band.B160M:
					btn = btnBand160;
					break;
				case Band.B80M:
					btn = btnBand80;
					break;
				case Band.B60M:
					btn = btnBand60;
					break;
				case Band.B40M:
					btn = btnBand40;
					break;
				case Band.B30M:
					btn = btnBand30;
					break;
				case Band.B20M:
					btn = btnBand20;
					break;
				case Band.B17M:
					btn = btnBand17;
					break;
				case Band.B15M:
					btn = btnBand15;
					break;
				case Band.B12M:
					btn = btnBand12;
					break;
				case Band.B10M:
					btn = btnBand10;
					break;
				case Band.B6M:
					btn = btnBand6;
					break;
				case Band.B2M:
					btn = btnBand2;
					break;
				case Band.WWV:
					btn = btnBandWWV;
					break;
				case Band.VHF0:
					btn = btnBandVHF0;
					break;
				case Band.VHF1:
					btn = btnBandVHF1;
					break;
				case Band.VHF2:
					btn = btnBandVHF2;
					break;
				case Band.VHF3:
					btn = btnBandVHF3;
					break;
				case Band.VHF4:
					btn = btnBandVHF4;
					break;
				case Band.VHF5:
					btn = btnBandVHF5;
					break;
				case Band.VHF6:
					btn = btnBandVHF6;
					break;
				case Band.VHF7:
					btn = btnBandVHF7;
					break;
				case Band.VHF8:
					btn = btnBandVHF8;
					break;
				case Band.VHF9:
					btn = btnBandVHF9;
					break;
				case Band.VHF10:
					btn = btnBandVHF10;
					break;
				case Band.VHF11:
					btn = btnBandVHF11;
					break;
				case Band.VHF12:
					btn = btnBandVHF12;
					break;
				case Band.VHF13:
					btn = btnBandVHF13;
					break;
			}

			foreach(Button b2 in panelBandHF.Controls)
			{
				if(b2 == btn && b2.BackColor != rx1_band_color)
				{
					b2.BackColor = tx_band_color;
				}
				else
				{
					if(b2.BackColor == tx_band_color)
						b2.BackColor = SystemColors.Control;
				}
			}
			/*if(b < Band.VHF0)
			{
//				if(!grpBandHF.Visible)
//				{
//					grpBandHF.Visible = true;
//					grpBandVHF.Visible = false;
//				}

				foreach(Button b2 in grpBandVHF.Controls)
					b2.BackColor = SystemColors.Control;

				foreach(Button b2 in grpBandHF.Controls)
				{
					if(b2 == btn && b2.BackColor != rx1_band_color)
					{
						b2.BackColor = tx_band_color;
					}
					else
					{
						if(b2.BackColor == tx_band_color)
							b2.BackColor = SystemColors.Control;
					}

//					Color c = SystemColors.Control;
//					if(b2 == btn)
//						c = button_selected_color;
//
//					b2.BackColor = c;
				}
			}
			else
			{
//				if(!grpBandVHF.Visible)
//				{
//					grpBandVHF.Visible = true;
//					grpBandHF.Visible = false;
//				}

				foreach(Button b2 in grpBandHF.Controls)
					b2.BackColor = SystemColors.Control;

				foreach(Button b2 in grpBandVHF.Controls)
				{
					if(b2 == btn && b2.BackColor != rx1_band_color)
					{
						b2.BackColor = tx_band_color;
					}
					else
					{
						if(b2.BackColor == tx_band_color)
							b2.BackColor = SystemColors.Control;
					}

//					Color c = SystemColors.Control;
//					if(b2 == btn)
//						c = button_selected_color;
//
//					b2.BackColor = c;
				}
			}*/
        }

        //=====================================================================================
        private Band BandByFreq(double freq, int xvtr_index, bool tx, FRSRegion region)
        {

            // ke9ns add: A   because both VFOA and VFOB call this routine, but panelBandGN,HF, and VHF are only for VFOA
            // panelBandGNRX2 is for VFOB
            // ke9ns: But freq here is after conversion to 28mhz region (if its an xvtr) xvtrForm.TranslateFreq(VFOAFreq)

            bool A = false;

         
                if (freq == VFOAFreq)
                {
                    Debug.WriteLine("VFO.....A " + freq + " , " + xvtr_index);
                    A = true; // 
                }
                else if (freq == VFOBFreq)
                {
                    Debug.WriteLine("VFO.....B " + freq + " , " + xvtr_index); 
                   A = false;
                }
                else if (freq == xvtrForm.TranslateFreq(VFOAFreq)) // .217
                {
                    Debug.WriteLine("VFO..xvtr....A " + freq + " , " + xvtr_index +  " , " + xvtrForm.TranslateFreq(VFOAFreq));
                    A = true; // 
                }
                else if (freq == xvtrForm.TranslateFreq(VFOBFreq))
                {
                    Debug.WriteLine("VFO..xvtr....B " + freq + " , " + xvtr_index + " , " + xvtrForm.TranslateFreq(VFOBFreq));
                    A = false; // 
                }



            if (xvtr_index >= 0)
            {
                if (A)
                {
                    panelBandGN.Visible = false;
                    panelBandHF.Visible = false;
                    panelBandVHF.Visible = true; // ke9ns add keep VHF panel open when VHF button selected
                }
                else  // vfob below
                {
                   
                        panelBandGNRX2.Visible = false; // .203
                        panelBandHFRX2.Visible = false;
                    if (FWCEEPROM.RX2OK)
                    {
                        if (FWCEEPROM.VUOK) panelBandVHFRX2.Visible = true; // ke9ns add keep VHF panel open when VHF button selected
                    }
                   

                }
                 

                  Debug.WriteLine("VHF HERE======>" + (Band)(Band.VHF0 + xvtr_index));

                return (Band)(Band.VHF0 + xvtr_index); // 14 t0 27
            }

            //  Debug.WriteLine("REGION=========================== " + region+ " freq " + freq + " ,VFOA:" + A);

            if (extended && tx) // ke9ns this is for Flex radios with extended MARS capability
            {
                //   Debug.WriteLine("EXTENDED========================");
                /*
                                if (Band.BLMF) tx_band = Band.B160M;
                                else if (Band.B120M) tx_band = Band.B160M;
                                else if (Band.B90M) tx_band = Band.B80M;
                                else if (Band.B61M) tx_band = Band.B80M;
                                else if (Band.B49M) tx_band = Band.B60M;
                                else if (Band.B41M) tx_band = Band.B40M;
                                else if (Band.B31M) tx_band = Band.B30M;
                                else if (Band.B25M) tx_band = Band.B20M;
                                else if (Band.B22M) tx_band = Band.B20M;
                                else if (Band.B19M) tx_band = Band.B17M;
                                else if (Band.B16M) tx_band = Band.B17M;
                                else if (Band.B14M) tx_band = Band.B15M;
                                else if (Band.B13M) tx_band = Band.B12M;
                                else if (Band.B11M) tx_band = Band.B10M;
                */

                // ke9ns add
                if (freq >= 0.20 && freq < 1.80)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK)
                        {
                            panelBandHFRX2.Visible = false;
                            if (FWCEEPROM.RX2OK) if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                        }
                    }

                    return Band.BLMF;
                    //  return Band.B160M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                       freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK)
                        {
                            if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                            panelBandGNRX2.Visible = false;
                        }

                    }

                    return Band.WWV;
                }


                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK)
                        {
                            panelBandHFRX2.Visible = false;
                            if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                        }
                    }
                    return Band.B120M;
                    //  return Band.B160M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK)
                        {
                            panelBandHFRX2.Visible = false;
                            if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                        }
                    }

                    return Band.B90M;
                    // return Band.B80M;
                }

                else if (freq > 4.00 && freq < 5.25)
                {
                   
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK)
                        {
                            panelBandHFRX2.Visible = false;
                            if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                        }
                    }
                    return Band.B61M;
                    //  return Band.B80M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                   
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B49M;
                    //  return Band.B60M;
                }

                else if (freq >= 7.30 && freq < 9.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }

                    return Band.B41M;
                    //  return Band.B40M;
                }

                else if (freq >= 9.0 && freq < 10.1) // EXTENDED and TX
                {
                   
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }


                    return Band.B31M;
                    // return Band.B30M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }

                    return Band.B25M;
                    //  return Band.B20M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B22M;
                    //  return Band.B20M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B19M;
                    // return Band.B17M;
                }

                else if (freq >= 17.0 && freq < 18.068)
                {

                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B16M;
                    //return Band.B17M;
                }

                else if (freq >= 18.168 && freq < 21.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B14M;
                    //  return Band.B15M;
                }
                else if (freq >= 21.450 && freq < 24.89)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B13M;
                    //  return Band.B12M;
                }

                else if (freq >= 24.99 && freq < 28.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B11M;
                    // return Band.B10M;
                }

                // original code below 
                else if (freq >= 0.0 && freq <= 2.75)
                {
                   
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }


                    return Band.B160M;
                }
                else if (freq > 2.75 && freq < 5.3305)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 8.7)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B40M;
                }
                else if (freq >= 8.7 && freq <= 12.075)  //   else if (freq > 10 && freq <= 10.15)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B30M;
                }
                else if (freq >= 12.075 && freq <= 16.209)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B20M;
                }
                else if (freq >= 16.209 && freq <= 19.584)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B17M;
                }
                else if (freq >= 19.584 && freq <= 23.17)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B15M;
                }
                else if (freq >= 23.17 && freq <= 26.495)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B12M;
                }
                else if (freq >= 26.495 && freq <= 29.7)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 54.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0) // ke9ns test was 144.0 and 148.0 .217  extended here
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B2M;
                }


                else
                    return Band.GEN;
            } // extened above

            if (region == FRSRegion.US)
            {
                //   Debug.WriteLine("US BAND========================");

                if (freq >= 1.8 && freq <= 2.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }

                    return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 4.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }

                    return Band.B80M;
                }
                else if (freq >= 5.25 && freq <= 5.45) // else if (freq >= 5.1 && freq <= 5.5)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }

                    return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.3)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }

                    return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }

                    return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }

                    return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }

                    return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.450)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }


                    return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }

                    return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 54.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0) // ke9ns test was 144.0 148.0 .217  US region here
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0) // FRSRegion.US
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.5)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B90M;
                }

                else if (freq > 4.00 && freq < 5.25)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    //   Debug.WriteLine("bandbyfreq 49");
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    //  Debug.WriteLine("bandbyfreq 41");
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1) // us band plan
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            }

            else if (region == FRSRegion.UK)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} 
                    return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;}
                    return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B90M;
                }

                else if (freq > 3.8 && freq < 5.25)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = false;
                        panelBandGN.Visible = true;
                    }
                    else
                    {
                        panelBandHFRX2.Visible = false;
                        if (FWCEEPROM.RX2OK) panelBandGNRX2.Visible = true;
                    }
                    return Band.B11M;
                }


                else
                    return Band.GEN;
            }
            else if (region == FRSRegion.Europe)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns                             // else if (freq >= 5.3515 && freq < 5.3665) // w4tme - matches region allocation
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B10M;
                }
                else if (freq >= 50.03 && freq <= 51.0)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;}
                    return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A)
                    {
                        panelBandHF.Visible = true;
                        panelBandGN.Visible = false;
                    }
                    else
                    {
                        if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;
                        panelBandGNRX2.Visible = false;
                    }
                    return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            }
            else if (region == FRSRegion.UK_Plus)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.80 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }


                else
                    return Band.GEN;
            }
            else if (region == FRSRegion.Italy)
            {
                if (freq >= 1.83 && freq <= 1.85)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.00 && freq <= 51.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.83) // italy
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 1.85 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }


                else
                    return Band.GEN;
            } // italy
            else if (region == FRSRegion.Norway)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.74 && freq <= 24.99) // was 24.89
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81) // norway
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.80 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            }
            else if (region == FRSRegion.Denmark)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.80 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            }
            else if (region == FRSRegion.Latvia)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 51.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }
                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.80 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }


                else
                    return Band.GEN;
            } // Latvia
            else if (region == FRSRegion.Slovakia)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.80 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Slovakia
            else if (region == FRSRegion.Bulgaria)
            {
                if (freq >= 1.81 && freq <= 1.85)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.05 && freq <= 50.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }
                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 1.85 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.80 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Bulgaria
            else if (region == FRSRegion.Greece)
            {
                if (freq >= 1.81 && freq <= 1.85)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 1.850 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.80 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.20)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }


                else
                    return Band.GEN;
            } // Greece
            else if (region == FRSRegion.Hungary)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.201)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }


                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.10 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Hungary
            else if (region == FRSRegion.Belgium)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0) // Tim wanted     else if (freq >= 5.350 && freq < 5.450)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81) // Belgium
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Belgium
            else if (region == FRSRegion.France)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // France
            else if (region == FRSRegion.Russia)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 25.14)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 26.97 && freq <= 27.86)
                {
                    if (A) panelBandHF.Visible = false; if (A) panelBandGN.Visible = true; return Band.B11M; // ke9ns add  return Band.B11M;
                }
                else if (freq >= 28.00 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Russia
            else if (region == FRSRegion.Sweden)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }
                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81) // sweden
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Sweden
            else if (region == FRSRegion.IARU3)
            {
                if (freq >= 1.8 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.9)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M; // ke9ns add An interim bandplan was adopted by IARU Region 1 in April 2016, for the WRC-15 allocation (5351.5 - 5366.5 kHz)
                }
                else if (freq >= 7.0 && freq <= 7.3)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 54.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80) // IARU3
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.9 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.30 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // IARU3
            else if (region == FRSRegion.Japan)
            {
                if (freq >= 1.81 && freq <= 1.9125)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.805)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0) //else if (freq >= 4.629995 && freq <= 4.630005)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 54.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 1.912 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.805 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Japan
            else if (region == FRSRegion.Italy_Plus)
            {
                if (freq >= 1.83 && freq <= 1.85)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 6.975 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.00 && freq <= 51.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }
                // ke9ns add
                else if (freq >= 0.20 && freq < 1.83)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 6.975)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;

            }// italy+
            else if (region == FRSRegion.ES_CH_FIN) // Spain switz and finland
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.3515 && freq < 5.3665) // w4tme - matches region allocation
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }
                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.80 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Spain, Switz, Finland
            else if (region == FRSRegion.Netherlands)
            {
                if (freq >= 1.81 && freq <= 1.88)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0), w4tme changed lower freq to 5.350
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M; // ke9ns
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 1.88 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Netherlands
            else if (region == FRSRegion.EU_Travel)
            {
                if (freq >= 1.80 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450) // ke9ns was else if (freq >= 5.3305 && freq < 7.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80) // EU travel
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // EU travel
            else if (region == FRSRegion.Luxembourg)
            {
                if (freq >= 1.81 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.3515 && freq < 5.3665) // w4tme - matches region allocation
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.2)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 52.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }
                // ke9ns add
                else if (freq >= 0.20 && freq < 1.81)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.20 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            }
            else if (region == FRSRegion.IARU2) // 
            {
                if (freq >= 1.8 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 4.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.25 && freq <= 5.45) // else if (freq >= 5.1 && freq <= 5.5)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.3)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.450)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 54.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0) // ke9ns test was 144.0 148.0
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }
                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.00 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 4.00 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.30 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // region_2
            else if (region == FRSRegion.Australia) // ke9ns add
            {
                if (freq >= 1.8 && freq <= 1.875)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.8)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.25 && freq <= 5.45) // else if (freq >= 5.1 && freq <= 5.5)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.3)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.450)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 54.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0) // ke9ns 
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }
                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 1.875 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq > 3.8 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.30 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // Australia
            else if (region == FRSRegion.China)
            {
                if (freq >= 1.8 && freq <= 2.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B160M;
                }
                else if (freq >= 3.5 && freq <= 3.9)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B80M;
                }
                else if (freq >= 5.250 && freq < 5.450)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B60M;
                }
                else if (freq >= 7.0 && freq <= 7.3)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B40M;
                }
                else if (freq >= 10.1 && freq <= 10.15)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B30M;
                }
                else if (freq >= 14.0 && freq <= 14.35)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B20M;
                }
                else if (freq >= 18.068 && freq <= 18.168)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B17M;
                }
                else if (freq >= 21.0 && freq <= 21.45)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B15M;
                }
                else if (freq >= 24.89 && freq <= 24.99)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B12M;
                }
                else if (freq >= 28.0 && freq <= 29.7)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B10M;
                }
                else if (freq >= 50.0 && freq <= 54.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B6M;
                }
                else if (freq >= 134.0 && freq <= 163.0)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.B2M;
                }
                else if (freq == 2.5 || freq == 5.0 || freq == 10.0 || freq == 15.0 ||
                        freq == 20.0 || freq == 25.0 || freq == 3.33 || freq == 7.85 || freq == 14.67)
                {
                    if (A){panelBandHF.Visible = true; panelBandGN.Visible = false;}else{if (FWCEEPROM.RX2OK) panelBandHFRX2.Visible = true;panelBandGNRX2.Visible = false;} return Band.WWV;
                }

                // ke9ns add
                else if (freq >= 0.20 && freq < 1.80) // china
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.BLMF;
                }

                else if (freq >= 2.0 && freq < 3.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B120M;
                }

                else if (freq >= 3.0 && freq < 3.50)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B90M;
                }

                else if (freq >= 3.9 && freq < 5.25)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B61M;
                }

                else if (freq >= 5.45 && freq < 7.00)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B49M;
                }

                else if (freq >= 7.30 && freq < 9.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B41M;
                }

                else if (freq >= 9.0 && freq < 10.1)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B31M;
                }

                else if (freq > 10.15 && freq < 13.57)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B25M;
                }

                else if (freq >= 13.57 && freq < 14.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B22M;
                }

                else if (freq >= 14.350 && freq < 17.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B19M;
                }

                else if (freq >= 17.0 && freq < 18.0)
                {

                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B16M;
                }

                else if (freq >= 18.0 && freq < 21.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B14M;
                }
                else if (freq >= 21.00 && freq < 25.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B13M;
                }

                else if (freq >= 25.0 && freq < 28.0)
                {
                    if (A) panelBandHF.Visible = false;
                    if (A) panelBandGN.Visible = true;
                    return Band.B11M;
                }

                else
                    return Band.GEN;
            } // China





            // if nothing matched to this point, just put it in the GEN band
            return Band.GEN;


        } // bandbyfreq


        //==================================================================================
        private void SetRX1Band(Band b)
        {

            //   panelBandHF.Invalidate(); // ke9ns add
            //  panelBandVHF.Invalidate(); // ke9ns add
            // panelBandGN.Invalidate(); // ke9ns add


            if (disable_split_on_bandchange)
            {
                if (RX1Band != b && !tuning)
                {
                    if (chkVFOSplit.Checked)
                        chkVFOSplit.Checked = false;
                }
            }

            Band old_band = rx1_band;
            RX1Band = b;
            if (old_band != b)
            {
                UpdateBandButtonColors();
                UpdateWaterfallLevelValues();

                if (current_model == Model.FLEX3000 && chkFWCATU.Checked && flex3000ATUForm.chkAutoMode.Checked) //band change atu
                {
                    flex3000ATUForm.autoMode = true;
                    flex3000ATUForm.DoTune();   //make sure autoMode=true is passed
                }

                if (current_model == Model.FLEX5000 && chkFWCATU.Checked && fwcAtuForm.ATUEnabledOnBandChange()) // atu tune on band change
                {
                    switch (b)
                    {
                        case Band.B160M:
                        case Band.B80M:
                        case Band.B60M:
                        case Band.B40M:
                        case Band.B30M:
                        case Band.B20M:
                        case Band.B17M:
                        case Band.B15M:
                        case Band.B12M:
                        case Band.B10M:
                        case Band.B6M:
                            {
                                fwcAtuForm.DoTuneMemory();
                                FWCATUTuned();
                                break;
                            }
                        default: break;
                    }
                }

                if (setupForm != null) // ke9ns add: Force UPDATE of ANT Display .119
                {
                    if (current_model == Model.FLEX5000)
                    {
                        if (fwcAntForm.radModeExpert.Checked)
                        {
                            CurrentAntMode = AntMode.Expert;
                            fwcAntForm.CurrentAntMode = current_ant_mode;
                            fwcAntForm.RX1Ant = rx1_ant;
                            fwcAntForm.RX1Loop = rx1_loop;
                            fwcAntForm.RX2Ant = rx2_ant;
                            fwcAntForm.TXAnt = tx_ant;
                            fwcAntForm.TXAnt2 = tx_ant2; // ke9ns add .205
                        }
                        else CurrentAntMode = AntMode.Simple;
                    }
                }

            }

            if (rx1_xvtr_index >= 0)
            {
                panelBandHF.Visible = false;
                panelBandGN.Visible = false; // ke9ns add

                panelBandVHF.Visible = true;

            }
            else
            {
                panelBandGN.Visible = true; //ke9ns add
                                            //   Debug.WriteLine("bandchange");
                                            //  panelBandHF.Visible = true;

                panelBandVHF.Visible = false;
            }

        } //SETRX1BAND

        private void SetRX2Band(Band b)
        {
            Band old_band = rx2_band;
            RX2Band = b;
            if (old_band != b)
                UpdateBandButtonColors();

            if (setupForm != null) // ke9ns add: Force UPDATE of ANT Display .119
            {
                if (current_model == Model.FLEX5000)
                {
                    if (fwcAntForm.radModeExpert.Checked)
                    {
                        CurrentAntMode = AntMode.Expert;
                        fwcAntForm.CurrentAntMode = current_ant_mode;
                        fwcAntForm.RX1Ant = rx1_ant;
                        fwcAntForm.RX1Loop = rx1_loop;
                        fwcAntForm.RX2Ant = rx2_ant;
                        fwcAntForm.TXAnt = tx_ant;
                        fwcAntForm.TXAnt2 = tx_ant2; // ke9ns add .205
                    }
                    else CurrentAntMode = AntMode.Simple;
                }

            }

        } //  SetRX2Band(Band b)

        private void SetTXBand(Band b)
        {
            // panelBandHF.Invalidate(); // ke9ns add
            // panelBandVHF.Invalidate(); // ke9ns add
            // panelBandGN.Invalidate(); // ke9ns add


            if (disable_split_on_bandchange)
            {
                if (TXBand != b && !tuning)
                {
                    if (chkVFOSplit.Checked) chkVFOSplit.Checked = false;
                }
            }

            Band old_band = tx_band;

          //  Debug.WriteLine("HIGH-LOW " + " Tband: " + tx_band + " new tx band " + b);

            TXBand = b;

            if (old_band != b) UpdateBandButtonColors();

            if (!(fwc_init && (current_model == Model.FLEX5000 || current_model == Model.FLEX3000)))
            {
                if (atu_present && xvtr_present)
                {
                    if (b == Band.B2M) comboTuneMode.Enabled = false;
                    else
                        comboTuneMode.Enabled = true;
                }

                if (xvtr_present)
                {
                    if (atu_present &&
                        comboTuneMode.SelectedIndex > 0 &&
                        (ATUTuneMode)comboTuneMode.SelectedIndex != ATUTuneMode.BYPASS &&
                        (tuned_band != b) &&
                        tuned_band != Band.FIRST)
                    {
                        Hdw.PA_ATUTune(ATUTuneMode.BYPASS);
                        tuned_band = Band.FIRST;
                        chkTUN.BackColor = SystemColors.Control;
                    }

                    if (b == Band.B2M)
                    {
                        if (comboPreamp.Items.Contains("Off"))
                            comboPreamp.Items.Remove("Off");
                        if (comboPreamp.Items.Contains("Med"))
                            comboPreamp.Items.Remove("Med");
                        if (comboPreamp.SelectedIndex < 0)
                            comboPreamp.Text = "High";
                    }
                    else
                    {
                        if (!comboPreamp.Items.Contains("Off"))
                            comboPreamp.Items.Insert(0, "Off");
                        if (!comboPreamp.Items.Contains("Med"))
                            comboPreamp.Items.Insert(2, "Med");
                    }
                }
            }
        } //settxband

        private float GainByBand(Band b)
        {
            float retval = 0;
            switch (b)
            {
                case Band.B160M:
                    retval = setupForm.PAGain160;
                    break;
                case Band.B80M:
                    retval = setupForm.PAGain80;
                    break;
                case Band.B60M:
                    retval = setupForm.PAGain60;
                    break;
                case Band.B40M:
                    retval = setupForm.PAGain40;
                    break;
                case Band.B30M:
                    retval = setupForm.PAGain30;
                    break;
                case Band.B20M:
                    retval = setupForm.PAGain20;
                    break;
                case Band.B17M:
                    retval = setupForm.PAGain17;
                    break;
                case Band.B15M:
                    retval = setupForm.PAGain15;
                    break;
                case Band.B12M:
                    retval = setupForm.PAGain12;
                    break;
                case Band.B10M:
                    retval = setupForm.PAGain10;
                    break;
                case Band.B6M:
                    if (current_model == Model.FLEX5000 || current_model == Model.FLEX3000)
                        retval = setupForm.PAGain10;
                    else retval = 1000;
                    break;
                default:
                    retval = 1000;
                    break;
            }

            return retval;
        }

        public void CheckSelectedButtonColor()
        {
            // used when changing the background color of selected buttons
            foreach (Control c in this.Controls)
            {
                if (c.GetType() == typeof(GroupBoxTS))
                {
                    foreach (Control c2 in ((GroupBoxTS)c).Controls)
                    {
                        if (c2.GetType() == typeof(RadioButtonTS))
                        {
                            RadioButtonTS r = (RadioButtonTS)c2;
                            if (r.Checked && r.BackColor != SystemColors.Control)
                            {
                                c2.BackColor = button_selected_color;
                            }
                        }
                        else if (c2.GetType() == typeof(CheckBoxTS))
                        {
                            CheckBoxTS chk = (CheckBoxTS)c2;
                            if (chk.Checked && chk.BackColor != SystemColors.Control)
                            {
                                c2.BackColor = button_selected_color;
                            }
                        }
                        else if (c2.GetType() == typeof(NumericUpDownTS))
                        {
                            NumericUpDownTS ud = (NumericUpDownTS)c2;
                            if (ud.BackColor != SystemColors.Window)
                            {
                                c2.BackColor = button_selected_color;
                            }
                        }
                        else if (c2.GetType() == typeof(ButtonTS))
                        {
                            ButtonTS b = (ButtonTS)c2;
                            if (b.BackColor != SystemColors.Control)
                            {
                                c2.BackColor = button_selected_color;
                            }
                        }
                    }
                }
                else if (c.GetType() == typeof(RadioButtonTS))
                {
                    RadioButtonTS r = (RadioButtonTS)c;
                    if (r.Checked && r.BackColor != SystemColors.Control)
                        c.BackColor = button_selected_color;
                }
                else if (c.GetType() == typeof(CheckBoxTS))
                {
                    CheckBoxTS chk = (CheckBoxTS)c;
                    if (chk.Checked && chk.BackColor != SystemColors.Control)
                        c.BackColor = button_selected_color;
                }
                else if (c.GetType() == typeof(NumericUpDownTS))
                {
                    NumericUpDownTS ud = (NumericUpDownTS)c;
                    if (ud.BackColor != SystemColors.Window)
                        c.BackColor = button_selected_color;
                }
                else if (c.GetType() == typeof(ButtonTS))
                {
                    ButtonTS b = (ButtonTS)c;
                    if (b.BackColor != SystemColors.Control)
                        c.BackColor = button_selected_color;
                }
            }
        }

        private double PABandOffset(Band b)
        {
            double num = 0;
            switch (b)
            {
                case Band.B160M:
                    num = setupForm.PAADC160;
                    break;
                case Band.B80M:
                    num = setupForm.PAADC80;
                    break;
                case Band.B60M:
                    num = setupForm.PAADC60;
                    break;
                case Band.B40M:
                    num = setupForm.PAADC40;
                    break;
                case Band.B30M:
                    num = setupForm.PAADC30;
                    break;
                case Band.B20M:
                    num = setupForm.PAADC20;
                    break;
                case Band.B17M:
                    num = setupForm.PAADC17;
                    break;
                case Band.B15M:
                    num = setupForm.PAADC15;
                    break;
                case Band.B12M:
                    num = setupForm.PAADC12;
                    break;
                case Band.B10M:
                    num = setupForm.PAADC10;
                    break;
            }

            if (num == 0) return 0;
            //return 100000 / Math.Pow(num, 2);
            return (double)108 / num;
        }

        private double SWR(int adc_fwd, int adc_rev)
        {
            if (adc_fwd == 0 && adc_rev == 0) return 1.0;
            else if (adc_rev > adc_fwd) return 50.0;

            double Ef = ScaledVoltage(adc_fwd);
            double Er = ScaledVoltage(adc_rev);

            double swr = (Ef + Er) / (Ef - Er);

            if (swr >= 19) // try 1 more time before displaying SWR
            {
                for (int q = 0; q < 5; q++) // ke9ns copy from .184 to .191
                {
                    Thread.Sleep(10);
                    swr = FWCSWR(pa_fwd_power, pa_rev_power);
                    if (swr < 19) break;
                } // for loop

            } // if SWR >=19
            return swr;
        }

        //=====================================================================
        // ke9ns mod

        int swrF = 0;
        double lastswr = 0.0;
        double lastfwdpower = 0.0;
        double lastrevpower = 0.0;
        double lastalc = 0.0;
        double lastmic = 0.0;
        double lasteq = 0.0;


        int swrcount = 0;

        public double FWCSWR(int adc_fwd, int adc_rev)
        {            

            //  double f = FWCPAPower(adc_fwd);   // ke9ns using this line allows r to get bigger then f and therefore produce neg swr readings????? very strange, but Flex Radio does not remember why?
            double f = FWCPAPower(adc_fwd) * swr_table[(int)tx_band]; // ke9ns version
            double r = FWCPAPower(adc_rev) * swr_table[(int)tx_band]; // swr_table[(int)tx_band] = 2.10=3mhz  1.64=7mhz  1.095=10mhz

            //   Debug.Write("FWCSWR: fwd:" + adc_fwd+" rev:"+adc_rev+" f:"+f.ToString("f2")+" r:"+r.ToString("f2") + " === "  + swr_table[(int)tx_band].ToString());

            if ((adc_fwd == 0 && adc_rev == 0) || (f <= 1.0 && r <= 1.0))  //(f <= 0.0002 && r <= 0.0002))
            {
                swrF = 0;
                return 0.0001;
            }


            //  if ((f < 1.0 && r < 1.0)) return 1.0;
            if ((adc_rev == adc_fwd) || (r >= f))
            {

                if (swrF > 1) // prevent jumpy swr operation on switchover from RX to TX and back
                {
                    lastswr = 0.0001;
                  //  return 25.0;
                    return 0.0001;
                }
                else
                {
                    swrF++;
                    return lastswr;
                }

            }
            else
            {
                swrF = 0;
            }

            double sqrt_r_over_f = Math.Sqrt(r / f); // ke9ns: standard SWR routine
            double temp = (1.0 + sqrt_r_over_f) / (1.0 - sqrt_r_over_f); // ke9ns: standard SWR routine

            if (temp > 25)
            {
                temp = 25; // ke9ns if SWR over 25:1 then just make it 25:1
            }

            if (temp < 0) temp = temp * -1.0; // ke9ns: if SWR neg then make it positive

            lastswr = temp;

            //  Debug.WriteLine("swr temp" + temp);
            return temp;

        } // FWCSWR(int adc_fwd, int adc_rev)




        private double ScaledVoltage(int adc)
        {
            double v_det = adc * 0.062963;          // scale factor in V/bit including pot ratio
            double v_out = v_det * 10.39853;        // scale factor in V/V for bridge output to detector voltage
            return v_out * PABandOffset(tx_band);
            //double v_det = adc * 0.0304;
            //			double v_out = 0;
            //			if(v_det >= 1.6)
            //				v_out = (-0.241259304*v_det+12.07915098)*v_det*PABandOffset(CurrentBand);
            //			else if(v_det > 0.35)
            //				v_out = (1/Math.Pow(v_det, 2)+11.3025111)*v_det*PABandOffset(CurrentBand);
            //return v_out;
        }

        private double ADCtodBm(int adc_data)
        {
            if (adc_data == 0)
                return 0;

            double mult = 100000 / Math.Pow(225 / PABandOffset(tx_band), 2);
            return 10 * Math.Log10(mult * Math.Pow(adc_data, 2));
        }

        private double PAPower(int adc)
        {
            double v_out = ScaledVoltage(adc);
            double pow = Math.Pow(v_out, 2) / 50;
            pow = Math.Max(pow, 0.0);
            return pow;
        }

        private double WattsTodBm(double watts)
        {
            return 10 * Math.Log10(watts / 0.001);
        }

        private double dBmToWatts(double dBm)
        {
            return Math.Pow(10, dBm / 10) * 0.001;
        }

        public double FWCPAPower(int adc) // adc in, watts out
        {
            if (adc < 2) return 0.0;

            double[] table = { 1.0, 2.0, 5.0, 10.0, 20.0, 90.0 };

            double watts = 0.0;
            double volts = (double)adc / 4096 * 2.5;
            double v2 = Math.Pow(volts, 2);

            int high_index = 0;
            for (int i = 0; i < 6; i++)
            {
                if (volts < pa_bridge_table[(int)tx_band][i])
                {
                    high_index = i;
                    break;
                }
                if (i == 5) high_index = 6;
            }

            if (high_index != 6)
            {
                double v_low = 0.0, v_high = 0.0;
                double p_low = 0.0, p_high = 0.0;

                if (high_index != 0) v_low = pa_bridge_table[(int)tx_band][high_index - 1];

                v_high = pa_bridge_table[(int)tx_band][high_index];

                if (high_index != 0) p_low = table[high_index - 1];

                p_high = table[high_index];

                Debug.Assert(v_low <= volts && v_high >= volts);

                double v_low_2 = Math.Pow(v_low, 2.0);
                double v_high_2 = Math.Pow(v_high, 2.0);

                watts = p_low + (p_high - p_low) * ((v2 - v_low_2) / (v_high_2 - v_low_2));
            }
            else
            {
                double v_low_2 = Math.Pow(pa_bridge_table[(int)tx_band][4], 2.0);
                double v_high_2 = Math.Pow(pa_bridge_table[(int)tx_band][5], 2.0);

                if (v_low_2 != v_high_2)
                {
                    double a = 70.0 / (v_high_2 - v_low_2);
                    double b = 90.0 / (a * v_high_2);

                    watts = a * v2 + b;
                }
            }

            return watts;
        }

        private static bool CheckForOpenProcesses()
        {
            // find all open PowerSDR processes
            Process[] p = Process.GetProcessesByName("PowerSDR");
            if (p.Length > 1)
            {
                DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "There are other PowerSDR instances running.\n" +
                    "Are you sure you want to continue?",
                    "Continue?",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question);
                if (dr == DialogResult.No)
                {
                    return false;
                }
            }
            return true;
        }

        public int VersionTextToInt(string version) // takes a version string like "1.0.6" 
        {                                           // and converts it to an int like 010006.
            string[] nums = version.Split('.');
            if (nums.Length < 3 || nums.Length > 4) return -1;

            int num1 = Int32.Parse(nums[0]);
            int num2 = Int32.Parse(nums[1]);
            int num3 = Int32.Parse(nums[2]);
            int num4 = 0;
            if (nums.Length == 4) num4 = Int32.Parse(nums[3]);

            return num1 * 1000000 + num2 * 10000 + num3 * 100 + num4;
        } // versiontextotint

        // ==============================================================================================
        //  PUBLIC Face of freq check
        // ==============================================================================================
        public bool CheckValidTXFreq(FRSRegion r, double f, DSPMode mode)
        {
            bool retval = false;

            if (extended || (tx_xvtr_index > -1 && (current_model != Model.FLEX1500)) ||
                (current_model == Model.FLEX1500 && tx_ant_1500 != HIDAnt.PA))
                return true;

            if (chkTUN.Checked) mode = DSPMode.CWU;

            switch (mode)
            {
                case DSPMode.LSB:
                case DSPMode.DIGL:
                case DSPMode.USB:
                case DSPMode.DIGU:
                case DSPMode.DSB:
                case DSPMode.AM:
                case DSPMode.SAM:
                case DSPMode.FM:
                    retval = (CheckValidTXFreq_Private(r, f + Display.TXFilterLow * 1e-6) &&
                        CheckValidTXFreq_Private(r, f + Display.TXFilterHigh * 1e-6));
                    break;
                case DSPMode.CWL:
                case DSPMode.CWU:
                    retval = CheckValidTXFreq_Private(r, f);
                    break;
                case DSPMode.DRM:
                    retval = (CheckValidTXFreq_Private(r, f - 0.012 + Display.TXFilterLow * 1e-6) &&
                        CheckValidTXFreq_Private(r, f - 0.012 + Display.TXFilterHigh * 1e-6));
                    break;
            }

            return retval;
        } // CheckValidTXFreq


        // ==============================================================================================
        // INTERNAL (PRIVATE) part of freq check (in cannot override firmware in Flex radio)
        // ==============================================================================================

        private bool CheckValidTXFreq_Private(FRSRegion r, double f)
        {
            if ((extended) || ((tx_xvtr_index > -1) && (current_model != Model.FLEX1500)))
                return true;

            bool ret_val = false;

            f = Math.Round(f, 6);

            switch (r)
            {
                case FRSRegion.US: // 0
                    if (f >= 1.8 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 4.0) ret_val = true;

                    else if (f >= 5.3305 && f <= 5.3335) ret_val = true; // allow for max 2.8 kHz
                    else if (f >= 5.3465 && f <= 5.3495) ret_val = true;
                    else if (f >= 5.3570 && f <= 5.3600) ret_val = true;
                    else if (f >= 5.3715 && f <= 5.3745) ret_val = true;
                    else if (f >= 5.4035 && f <= 5.4065) ret_val = true;

                    else if (f >= 7.0 && f <= 7.3) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 25.0 && f <= 29.7) ret_val = true;     // change
                    else if (f >= 50.0 && f <= 54.0) ret_val = true;

                    else if (FWCEEPROM.VUOK && f >= 134.0 && f <= 163.0) ret_val = true;  // ke9ns test was 144.0 and 148.0  .217
                    else if (FWCEEPROM.VUOK && f >= 430.0 && f <= 470.0) ret_val = true;  // ke9ns was 450 .224
                    // {
                    //     if (xvtr_present)
                    //         ret_val = true;
                    //     else
                    //         ret_val = false;
                    // }
                    else ret_val = false;
                    break;
                case FRSRegion.UK: // 1
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Europe: // 2
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.03 && f <= 51.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.UK_Plus: // 3
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 5.2585 && f <= 5.264) ret_val = true;
                    else if (f >= 5.276 && f <= 5.284) ret_val = true;
                    else if (f >= 5.2885 && f <= 5.292) ret_val = true;
                    else if (f >= 5.298 && f <= 5.307) ret_val = true;
                    else if (f >= 5.313 && f <= 5.323) ret_val = true;
                    else if (f >= 5.333 && f <= 5.338) ret_val = true;
                    else if (f >= 5.354 && f <= 5.358) ret_val = true;
                    else if (f >= 5.362 && f <= 5.3745) ret_val = true;
                    else if (f >= 5.378 && f <= 5.382) ret_val = true;
                    else if (f >= 5.395 && f <= 5.4015) ret_val = true;
                    else if (f >= 5.4035 && f <= 5.4065) ret_val = true;

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;


                    else ret_val = false;
                    break;
                case FRSRegion.Italy: // 4
                    if (f >= 1.83 && f <= 1.85) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 51.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Norway: // 5
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 5.25 && f <= 5.45) ret_val = true;

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.74 && f <= 24.99) ret_val = true; // was 24.89
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Denmark: // 6
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 5.25 && f <= 5.45) ret_val = true;

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Latvia: // 7
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 51.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Slovakia: // 8
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Bulgaria: // 9
                    if (f >= 1.81 && f <= 1.85) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.05 && f <= 50.2) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Greece: // 10
                    if (f >= 1.81 && f <= 1.85) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Hungary: // 11
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                    else if (f >= 7.0 && f <= 7.201) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Belgium: // 12
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.France: // 13
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Russia: // 14
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 25.14) ret_val = true;
                    else if (f >= 26.97 && f <= 27.86) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Sweden: // 15
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;

                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band

                    else if (f >= 5.31 && f <= 5.313) ret_val = true;
                    else if (f >= 5.32 && f <= 5.323) ret_val = true;
                    else if (f >= 5.38 && f <= 5.383) ret_val = true;
                    else if (f >= 5.39 && f <= 5.393) ret_val = true;
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.IARU3: // 16
                    if (f >= 1.8 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.9) ret_val = true;
                    else if (f >= 7.0 && f <= 7.3) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 54.0) ret_val = true;
                    else ret_val = false;
                    break;

                case FRSRegion.Japan: // 17
                    if (f >= 1.81 && f <= 1.9125) ret_val = true;
                    else if (f >= 3.5 && f <= 3.805) ret_val = true;
                    else if (f >= 4.629995 && f <= 4.630005) ret_val = true;    // Japan national emergency frequency 4.630 +/- 5 Hz
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 54.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Italy_Plus: //18
                    if (f >= 1.83 && f <= 1.85) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                    else if (f >= 6.975 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 51.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.ES_CH_FIN: // 19
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.00 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Netherlands: // 20
                    if (f >= 1.81 && f <= 1.88) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                                                                         //  else if (f >= 5.35 && f <= 5.45) ret_val = true; // New IARU 1 60m band
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.EU_Travel: // 21
                    if (f >= 1.80 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.250 && f <= 5.450) ret_val = true;
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.00 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.Luxembourg: // 22
                    if (f >= 1.81 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                    else if (f >= 7.0 && f <= 7.2) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.00 && f <= 52.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.IARU2: // 23
                    if (f >= 1.8 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 4.0) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 2 60m band
                    else if (f >= 7.0 && f <= 7.3) ret_val = true;

                    else if (f >= 7.4535 && f <= 7.4565) ret_val = true; // ke9ns USB CDEMA Caribbean Disaster Emergency Response Agency
                    else if (f >= 7.850 && f <= 7.853) ret_val = true; // ke9ns USB CDEMA Caribbean Disaster Emergency Response Agency

                    else if (f >= 10.1 && f <= 10.15) ret_val = true;

                    else if (f >= 13.998 && f <= 14.0) ret_val = true; // ke9ns USB USB Caribbean Red Cross

                    else if (f >= 14.0 && f <= 14.35) ret_val = true;

                    else if (f >= 14.415 && f <= 14.418) ret_val = true; // ke9ns USB CDEMA Caribbean Disaster Emergency Response Agency


                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 27.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 54.0) ret_val = true;
                    else if (FWCEEPROM.VUOK && f >= 144.0 && f <= 148.0) ret_val = true;
                    else if (FWCEEPROM.VUOK && f >= 430.0 && f <= 450.0) ret_val = true;
                    else ret_val = false;
                    break;

                case FRSRegion.Australia: // 24  (no 60m transmit)
                    if (f >= 1.8 && f <= 1.875) ret_val = true;
                    else if (f >= 3.5 && f <= 3.8) ret_val = true;
                    else if (f >= 7.0 && f <= 7.3) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 27.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 54.0) ret_val = true;
                    else if (FWCEEPROM.VUOK && f >= 144.0 && f <= 147.975) ret_val = true;
                    else if (FWCEEPROM.VUOK && f >= 430.0 && f <= 450.0) ret_val = true;
                    else ret_val = false;
                    break;
                case FRSRegion.China: // 25
                    if (f >= 1.8 && f <= 2.0) ret_val = true;
                    else if (f >= 3.5 && f <= 3.9) ret_val = true;
                    else if (f >= 5.3515 && f <= 5.3665) ret_val = true; // New IARU 1 60m band
                    else if (f >= 7.0 && f <= 7.3) ret_val = true;
                    else if (f >= 10.1 && f <= 10.15) ret_val = true;
                    else if (f >= 14.0 && f <= 14.35) ret_val = true;
                    else if (f >= 18.068 && f <= 18.168) ret_val = true;
                    else if (f >= 21.0 && f <= 21.45) ret_val = true;
                    else if (f >= 24.89 && f <= 24.99) ret_val = true;
                    else if (f >= 28.0 && f <= 29.7) ret_val = true;
                    else if (f >= 50.0 && f <= 54.0) ret_val = true;
                    else ret_val = false;
                    break;

                default:
                    ret_val = false;
                    break;
            }

            return ret_val;
        }

        public void SetHWFilters(double freq)
        {
            //Use shift registers on RFE to control BPF and LPF banks
            if (freq <= 2.5)                    // DC to 2.5MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B160;

                if (!mox && chkBCI.Checked) //rx & BCI
                    Hdw.BPFRelay = BPFBand.B60;     //sets next higher BPF for improved 160M operation
                else
                    Hdw.BPFRelay = BPFBand.B160;

                if (freq <= 0.3 && enable_LPF0)
                    Hdw.RFE_LPF = RFELPFBand.AUX;
                else
                    Hdw.RFE_LPF = RFELPFBand.B160;
            }
            else if (freq <= 4)             // 2.5MHz to 4MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B80;

                Hdw.BPFRelay = BPFBand.B60;
                Hdw.RFE_LPF = RFELPFBand.B80;
            }
            else if (freq <= 6)             // 4MHz to 6MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B6040;

                Hdw.BPFRelay = BPFBand.B60;
                Hdw.RFE_LPF = RFELPFBand.B60;
            }
            else if (freq <= 7.3)           // 6MHz to 7.3MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B6040;

                Hdw.BPFRelay = BPFBand.B40;
                Hdw.RFE_LPF = RFELPFBand.B40;
            }
            else if (freq <= 10.2)          // 7.3MHz to 10.2MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B3020;

                Hdw.BPFRelay = BPFBand.B40;
                Hdw.RFE_LPF = RFELPFBand.B30;
            }
            else if (freq <= 12)                // 10.2MHz to 12MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.NONE;

                Hdw.BPFRelay = BPFBand.B40;
                Hdw.RFE_LPF = RFELPFBand.B30;
            }
            else if (freq <= 14.5)          // 12MHz to 14.5MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B3020;

                Hdw.BPFRelay = BPFBand.B20;
                Hdw.RFE_LPF = RFELPFBand.B20;
            }
            else if (freq <= 21.5)          // 14.5MHz to 21.5MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B1715;

                Hdw.BPFRelay = BPFBand.B20;
                Hdw.RFE_LPF = RFELPFBand.B1715;
            }
            else if (freq <= 24)                // 21.5MHz to 24MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B1210;

                Hdw.BPFRelay = BPFBand.B20;
                Hdw.RFE_LPF = RFELPFBand.B1210;
            }
            else if (freq <= 30)                // 24MHz to 30MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.B1210;

                Hdw.BPFRelay = BPFBand.B10;
                Hdw.RFE_LPF = RFELPFBand.B1210;
            }
            else if (freq <= 36)                // 30MHz to 36MHz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.NONE;

                Hdw.BPFRelay = BPFBand.B10;
                Hdw.RFE_LPF = RFELPFBand.B6;
            }
            else if (freq <= 65)                // 36MHz to 65Mhz
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.NONE;

                Hdw.BPFRelay = BPFBand.B6;
                Hdw.RFE_LPF = RFELPFBand.B6;
            }
            else if (xvtr_present && freq >= 134 && freq <= 146)            //28MHz IF for transverter // ke9ns test was 144 and 146 .217
            {
                if (pa_present)
                    Hdw.PA_LPF = PAFBand.NONE;

                Hdw.BPFRelay = BPFBand.B10;
                Hdw.RFE_LPF = RFELPFBand.B1210;
                Hdw.XVTR_RF = true;
            }
          //  if (xvtr_present && freq < 144) Hdw.XVTR_RF = false; // ke9ns test this was not commented out .217

            if (rx1_xvtr_index >= 0)
            {
                Hdw.XVTR_RF = xvtrForm.GetXVTRRF(rx1_xvtr_index);
            }

        } // SetHwFilters

        // kb9yig sr40 mod 		
        // check and see if the band data includes alias data -- if so 
        // zero out (very negative) the portions of the data that are 
        // aliased 
        public void AdjustDisplayDataForBandEdge(ref float[] display_data)
        {

            return;

            	if ( current_model != Model.SOFTROCK40)  // -- no aliasing going on 
                    return;   

                if ( rx1_dsp_mode == DSPMode.DRM )  // for now don't worry about aliasing in DRM land 
                {
                    return; 
                }

                double hz_per_bin = sample_rate1/Display.BUFFER_SIZE; 
                double data_center_freq = tuned_freq; 
                if ( data_center_freq == 0 ) 
                { 
                    return; 
                } 
                double data_low_edge_hz = (1e6 * data_center_freq) - sample_rate1/2; 
                double data_high_edge_hz = (1e6 * data_center_freq) + sample_rate1/2; 
                double alias_free_low_edge_hz = (1e6 * soft_rock_center_freq) - sample_rate1/2; 
                double alias_free_high_edge_hz = (1e6 * soft_rock_center_freq) + sample_rate1/2; 
                if ( data_low_edge_hz < alias_free_low_edge_hz )   // data we have goes below alias free region -- zero it 
                {				
                    double hz_this_bin = data_low_edge_hz; 
                    int bin_num = 0; 
                    while ( hz_this_bin < alias_free_low_edge_hz ) 
                    {
                        display_data[bin_num] = -200.0f; 
                        ++bin_num; 
                        hz_this_bin += hz_per_bin; 
                    }
                    // Debug.WriteLine("data_low: " + bin_num); 
                } 
                else if ( data_high_edge_hz > alias_free_high_edge_hz ) 
                { 				
                    double hz_this_bin = data_high_edge_hz; 
                    int bin_num = Display.BUFFER_SIZE - 1; 
                    while ( hz_this_bin > alias_free_high_edge_hz ) 
                    {
                        display_data[bin_num] = -200.0f; 
                        --bin_num; 
                        hz_this_bin -= hz_per_bin; 
                    }					
                    // Debug.WriteLine("data_high: " + bin_num); 
                }
                return;		
        }
        // end kb9yig sr40 mod 

        public void SelectRX1VarFilter()
        {
            if (rx1_filter == Filter.VAR1) return;
            if (rx1_filter == Filter.VAR2) return;

            // save current filter bounds, reset to var, set filter bounds 
            int high = (int)udFilterHigh.Value;
            int low = (int)udFilterLow.Value;
            radFilterVar1.Checked = true;
            //SetFilter(Filter.VAR1); 
            UpdateRX1Filters(low, high);
        }

        public void SelectRX2VarFilter()
        {
            if (rx2_filter == Filter.VAR1) return;
            if (rx2_filter == Filter.VAR2) return;

            // save current filter bounds, reset to var, set filter bounds 
            int high = (int)udRX2FilterHigh.Value;
            int low = (int)udRX2FilterLow.Value;
            radRX2FilterVar1.Checked = true;
            //SetFilter(Filter.VAR1); 
            UpdateRX2Filters(low, high);
        }

        private void UpdateExtCtrl()
        {
              if (current_model != Model.SDR1000) return;

              switch(TXBand)
              {
                  case Band.B160M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_160_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_160_tx);
                      break;
                  case Band.B80M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_80_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_80_tx);
                      break;
                  case Band.B60M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_60_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_60_tx);
                      break;
                  case Band.B40M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_40_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_40_tx);
                      break;
                  case Band.B30M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_30_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_30_tx);
                      break;
                  case Band.B20M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_20_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_20_tx);
                      break;
                  case Band.B17M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_17_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_17_tx);
                      break;
                  case Band.B15M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_15_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_15_tx);
                      break;
                  case Band.B12M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_12_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_12_tx);
                      break;
                  case Band.B10M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_10_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_10_tx);
                      break;
                  case Band.B6M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_6_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_6_tx);
                      break;
                  case Band.B2M:
                      if(!mox)
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_2_rx);
                      else
                          Hdw.X2 = (byte)((Hdw.X2 & 0xC0) | x2_2_tx);
                      break;
              }
        } // UpdateExtCtrl()

        // Added 06/24/05 BT for CAT commands
        public void CATMemoryQS()
        {
            btnMemoryQuickSave_Click(this.btnMemoryQuickSave, EventArgs.Empty);
        }

        // Added 06/25/05 BT for CAT commands
        public void CATMemoryQR()
        {
            btnMemoryQuickRestore_Click(this.btnMemoryQuickRestore, EventArgs.Empty);
        }

        // BT 06/30/05 Added for CAT commands
        public int CATBandGroup
        {
            get
            {
                if (panelBandHF.Visible)
                    return 0;
                else
                    return 1;
            }
            set
            {
                if (value == 0)
                    btnBandHF_Click(btnBandHF, EventArgs.Empty);
                else if (value == 1)
                    btnBandVHF_Click(btnBandVHF, EventArgs.Empty);
            }
        }

        //BT 06/17/05 added for CAT commands
        public void SetCATBand(Band pBand)
        {
            Band b = pBand;
            switch (b)
            {
                case Band.B160M:
                    radBand160_Click(this, EventArgs.Empty);
                    break;
                case Band.B80M:
                    radBand80_Click(this, EventArgs.Empty);
                    break;
                case Band.B60M:
                    radBand60_Click(this, EventArgs.Empty);
                    break;
                case Band.B40M:
                    radBand40_Click(this, EventArgs.Empty);
                    break;
                case Band.B30M:
                    radBand30_Click(this, EventArgs.Empty);
                    break;
                case Band.B20M:
                    radBand20_Click(this, EventArgs.Empty);
                    break;
                case Band.B17M:
                    radBand17_Click(this, EventArgs.Empty);
                    break;
                case Band.B15M:
                    radBand15_Click(this, EventArgs.Empty);
                    break;
                case Band.B12M:
                    radBand12_Click(this, EventArgs.Empty);
                    break;
                case Band.B10M:
                    radBand10_Click(this, EventArgs.Empty);
                    break;
                case Band.B6M:
                    radBand6_Click(this, EventArgs.Empty);
                    break;
                case Band.B2M:
                    radBand2_Click(this, EventArgs.Empty);
                    break;
                case Band.GEN:
                    radBandGEN_Click(this, EventArgs.Empty);
                    break;
                case Band.WWV:
                    radBandWWV_Click(this, EventArgs.Empty);
                    break;
                case Band.VHF0:
                    radBandVHF0.PerformClick();
                    break;
                case Band.VHF1:
                    radBandVHF1.PerformClick();
                    break;
                case Band.VHF2:
                    radBandVHF2.PerformClick();
                    break;
                case Band.VHF3:
                    radBandVHF3.PerformClick();
                    break;
                case Band.VHF4:
                    radBandVHF4.PerformClick();
                    break;
                case Band.VHF5:
                    radBandVHF5.PerformClick();
                    break;
                case Band.VHF6:
                    radBandVHF6.PerformClick();
                    break;
                case Band.VHF7:
                    radBandVHF7.PerformClick();
                    break;
                case Band.VHF8:
                    radBandVHF8.PerformClick();
                    break;
                case Band.VHF9:
                    radBandVHF9.PerformClick();
                    break;
                case Band.VHF10:
                    radBandVHF10.PerformClick();
                    break;
                case Band.VHF11:
                    radBandVHF11.PerformClick();
                    break;
                case Band.VHF12:
                    radBandVHF12.PerformClick();
                    break;
                case Band.VHF13:
                    radBandVHF13.PerformClick();
                    break;
                case Band.BLMF:
                    radBandGEN0_Click(this, EventArgs.Empty);
                    break;
                case Band.B120M:
                    radBandGEN1_Click(this, EventArgs.Empty);
                    break;
                case Band.B90M:
                    radBandGEN2_Click(this, EventArgs.Empty);
                    break;
                case Band.B61M:
                    radBandGEN3_Click(this, EventArgs.Empty);
                    break;
                case Band.B49M:
                    radBandGEN4_Click(this, EventArgs.Empty);
                    break;
                case Band.B41M:
                    radBandGEN5_Click(this, EventArgs.Empty);
                    break;
                case Band.B31M:
                    radBandGEN6_Click(this, EventArgs.Empty);
                    break;
                case Band.B25M:
                    radBandGEN7_CheckedChanged(this, EventArgs.Empty);
                    break;
                case Band.B22M:
                    radBandGEN8_Click(this, EventArgs.Empty);
                    break;
                case Band.B19M:
                    radBandGEN9_Click(this, EventArgs.Empty);
                    break;
                case Band.B16M:
                    radBandGEN10_Click(this, EventArgs.Empty);
                    break;
                case Band.B14M:
                    radBandGEN11_Click(this, EventArgs.Empty);
                    break;
                case Band.B13M:
                    radBandGEN12_Click(this, EventArgs.Empty);
                    break;
                case Band.B11M:
                    radBandGEN13_Click(this, EventArgs.Empty);
                    break;

                default:
                    radBandGEN_Click(this, EventArgs.Empty);
                    break;
            }
        } // setcatband


        public void SetVHFText(int index, string text)
        {
            vhf_text[index].Text = text;
            vhf_text2[index].Text = text;


        }

        public void SetVHFEnabled(int index, bool b)
        {
            vhf_text[index].Enabled = b;

            //   if (index < 2)  vhf_text2[index].Enabled = b; // .213 
            vhf_text2[index].Enabled = b; // .217 but xtvr on rx2 can only use RX2 input (RX ONLY)
        }



        //=============================================================================
        // ke9ns mod add GEN SWL bands
        public int[] band_stacks; // ke9ns add each entry contains the # of bandstack entries for each band listed below 
        public int[] band_sort; // ke9ns add lowest to highest sorted freq list of the current bandstack  

        public void UpdateBandStackRegisters()
        {
            band_stacks = DB.GetBandStackNum(); // ke9ns mod

            band_160m_register = band_stacks[0];
            band_80m_register = band_stacks[1];
            band_60m_register = band_stacks[2];
            band_40m_register = band_stacks[3];
            band_30m_register = band_stacks[4];
            band_20m_register = band_stacks[5];
            band_17m_register = band_stacks[6];
            band_15m_register = band_stacks[7];
            band_12m_register = band_stacks[8];
            band_10m_register = band_stacks[9];
            band_6m_register = band_stacks[10];
            band_2m_register = band_stacks[11];
            band_wwv_register = band_stacks[12];
            band_gen_register = band_stacks[13];

            band_LMF_register = band_stacks[14]; // ke9ns add
            band_120m_register = band_stacks[15];
            band_90m_register = band_stacks[16];
            band_61m_register = band_stacks[17];
            band_49m_register = band_stacks[18];
            band_41m_register = band_stacks[19];
            band_31m_register = band_stacks[20];
            band_25m_register = band_stacks[21];
            band_22m_register = band_stacks[22];
            band_19m_register = band_stacks[23];
            band_16m_register = band_stacks[24];
            band_14m_register = band_stacks[25];
            band_13m_register = band_stacks[26];
            band_11m_register = band_stacks[27];

            band_vhf0_register = band_stacks[28];
            band_vhf1_register = band_stacks[29];
            band_vhf2_register = band_stacks[30];
            band_vhf3_register = band_stacks[31];
            band_vhf4_register = band_stacks[32];
            band_vhf5_register = band_stacks[33];
            band_vhf6_register = band_stacks[34];
            band_vhf7_register = band_stacks[35];
            band_vhf8_register = band_stacks[36];
            band_vhf9_register = band_stacks[37];
            band_vhf10_register = band_stacks[38];
            band_vhf11_register = band_stacks[39];
            band_vhf12_register = band_stacks[40];
            band_vhf13_register = band_stacks[41];




        } // UpdateBandStackRegisters()



        public void UpdateRX1Filters(int low, int high)
        {
            // System.Console.WriteLine("updf lo: " + low + " hi: " + high); 
            // qualify settings
            //if(low > high) return;

            switch (rx1_dsp_mode)
            {
                case DSPMode.LSB:
                case DSPMode.DIGL:
                case DSPMode.CWL:
                    if (low > high - 10) low = high - 10;
                    break;
                case DSPMode.USB:
                case DSPMode.DIGU:
                case DSPMode.CWU:
                    if (high < low + 10) high = low + 10;
                    break;
                case DSPMode.AM:
                case DSPMode.SAM:
                case DSPMode.DSB:
                    if (high < low + 20)
                    {
                        if (Math.Abs(high) < Math.Abs(low))
                            high = low + 20;
                        else
                            low = high - 20;
                    }
                    break;
                case DSPMode.FM:

                    if (dsp.GetDSPTX(0).TXFMDeviation == FMDataDeviation) // ke9ns add FMData == true  WFM
                    {
                        low = -FMDataLowHigh; // -11000 (now 20k .218)
                        high = FMDataLowHigh; // 11000
                    }
                    else if (dsp.GetDSPTX(0).TXFMDeviation == 5000)
                    {
                        low = -8000;
                        high = 8000;
                    }
                    else if (dsp.GetDSPTX(0).TXFMDeviation == 2500)
                    {
                        low = -4000;
                        high = 4000;
                    }
                    break;
            }

            if (current_model == Model.FLEX1500) // .217
            {
                if (low < -14999) low = -14999; // ke9ns add
                if (high > 14999) high = 14999;
            }
            else
            {
                if (low < -52000) low = -52000; // ke9ns .217
                if (high > 52000) high = 52000;
            }

            //	if(low < -9999)	low = -9999;
            //	if(high > 9999)	high = 9999; // ke9ns test. this was original


            // send the settings to the DSP
            dsp.GetDSPRX(0, 0).SetRXFilter(low, high);
            dsp.GetDSPRX(0, 1).SetRXFilter(low, high);

            // send the setting to the display
            Display.RX1FilterLow = low;
            Display.RX1FilterHigh = high;

            // update var filter controls
            udFilterLow.Value = low;
            udFilterHigh.Value = high;

            // update Filter Shift
            ptbFilterShift_Update(low, high);

            // update Filter Width
            ptbFilterWidth_Update(low, high);

            // Update Display data if not in panadapter mode
            if (!dsp.GetDSPRX(0, 0).SpectrumPreFilter)
                UpdateRXDisplayVars(low, high);

            // update display
            if (!chkPower.Checked)
                Display.DrawBackground();

            // reset average and peak
            switch (Display.CurrentDisplayMode)
            {
                case DisplayMode.SPECTRUM:
                case DisplayMode.HISTOGRAM:
                case DisplayMode.WATERFALL:
                    if (chkDisplayAVG.Checked) Display.ResetRX1DisplayAverage();
                    if (chkDisplayPeak.Checked) Display.ResetRX1DisplayPeak();
                    break;
                case DisplayMode.PANADAPTER:
                    break;
            }

            // set XIT step rate
            if ((high - low) > 250)
            {
                udXIT.Increment = 10;
                udRIT.Increment = 10;
            }
            else
            {
                udXIT.Increment = 5;
                udRIT.Increment = 5;
            }

            if (filterRX1Form != null && !filterRX1Form.IsDisposed)
            {
                if (filterRX1Form.DSPMode == rx1_dsp_mode)
                    filterRX1Form.CurrentFilter = rx1_filter;
            }
        } // updaterx1fitlers

        public void UpdateRX2Filters(int low, int high)
        {
            switch (rx2_dsp_mode)
            {
                case DSPMode.LSB:
                case DSPMode.DIGL:
                case DSPMode.CWL:
                    if (low > high - 10) low = high - 10;
                    break;
                case DSPMode.USB:
                case DSPMode.DIGU:
                case DSPMode.CWU:
                    if (high < low + 10) high = low + 10;
                    break;
                case DSPMode.AM:
                case DSPMode.SAM:
                case DSPMode.DSB:
                    if (high < low + 20)
                    {
                        if (Math.Abs(high) < Math.Abs(low))
                            high = low + 20;
                        else
                            low = high - 20;
                    }
                    break;
                case DSPMode.FM:

                    if (dsp.GetDSPTX(0).TXFMDeviation == FMDataDeviation)  // FMData == true) 9khz dev WFM
                    {
                        low = -FMDataLowHigh; // -11000
                        high = FMDataLowHigh; // +11000
                    }
                    else if (dsp.GetDSPTX(0).TXFMDeviation == 5000)
                    {
                        low = -8000;
                        high = 8000;
                    }
                    else if (dsp.GetDSPTX(0).TXFMDeviation == 2500)
                    {
                        low = -4000;
                        high = 4000;
                    }
                    break;

                
            }

            if (current_model == Model.FLEX1500) // .217
            {
                if (low < -14999) low = -14999; // ke9ns add
                if (high > 14999) high = 14999;
            }
            else
            {
                if (low < -52000) low = -52000; // ke9ns .217
                if (high > 52000) high = 52000;
            }
           

            //  if (low < -9999)
            //		low = -9999;
            //	if(high > 9999) 
            //	high = 9999;

            // send the settings to the DSP
            dsp.GetDSPRX(1, 0).SetRXFilter(low, high);
            dsp.GetDSPRX(1, 1).SetRXFilter(low, high);

            // send the setting to the display
            Display.RX2FilterLow = low; 
            Display.RX2FilterHigh = high;

            // update var filter controls
            udRX2FilterLow.Value = low;
            udRX2FilterHigh.Value = high;

            // update display
            if (!chkPower.Checked) Display.DrawBackground();

            if (filterRX2Form != null && !filterRX2Form.IsDisposed)
            {
                if (filterRX2Form.DSPMode == rx2_dsp_mode)
                    filterRX2Form.CurrentFilter = rx2_filter;
            }
        } //update RX2 Filters

        public void UpdateRX1FilterNames(Filter f)
        {
            switch (f)
            {
                case Filter.F1:
                    radFilter1.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F1);
                    break;
                case Filter.F2:
                    radFilter2.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F2);
                    break;
                case Filter.F3:
                    radFilter3.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F3);
                    break;
                case Filter.F4:
                    radFilter4.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F4);
                    break;
                case Filter.F5:
                    radFilter5.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F5);
                    break;
                case Filter.F6:
                    radFilter6.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F6);
                    break;
                case Filter.F7:
                    radFilter7.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F7);
                    break;
                case Filter.F8:
                    radFilter8.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F8);
                    break;
                case Filter.F9:
                    radFilter9.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F9);
                    break;
                case Filter.F10:
                    radFilter10.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.F10);
                    break;
                case Filter.VAR1:
                    radFilterVar1.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.VAR1);
                    break;
                case Filter.VAR2:
                    radFilterVar2.Text = rx1_filters[(int)rx1_dsp_mode].GetName(Filter.VAR2);
                    break;
            }

            if (f == rx1_filter)
                panelFilter.Text = "Filter - " + rx1_filters[(int)rx1_dsp_mode].GetName(f);
        }

        public void UpdateRX1FilterPresetLow(int val)
        {
            UpdateRX1Filters(val, (int)udFilterHigh.Value);
        }

        public void UpdateRX1FilterPresetHigh(int val)
        {
            UpdateRX1Filters((int)udFilterLow.Value, val);
        }

        public void UpdateRX2FilterNames(Filter f)
        {
            switch (f)
            {
                case Filter.F1:
                    radRX2Filter1.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.F1);
                    break;
                case Filter.F2:
                    radRX2Filter2.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.F2);
                    break;
                case Filter.F3:
                    radRX2Filter3.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.F3);
                    break;
                case Filter.F4:
                    radRX2Filter4.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.F4);
                    break;
                case Filter.F5:
                    radRX2Filter5.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.F5);
                    break;
                case Filter.F6:
                    radRX2Filter6.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.F6);
                    break;
                case Filter.F7:
                    radRX2Filter7.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.F7);
                    break;
                case Filter.VAR1:
                    radRX2FilterVar1.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.VAR1);
                    break;
                case Filter.VAR2:
                    radRX2FilterVar2.Text = rx2_filters[(int)rx2_dsp_mode].GetName(Filter.VAR2);
                    break;
            }

            if (f == rx2_filter)
                panelRX2Filter.Text = "RX2 Filter - " + rx2_filters[(int)rx2_dsp_mode].GetName(f);
        }

        public void UpdateRX2FilterPresetLow(int val)
        {
            UpdateRX2Filters(val, (int)udRX2FilterHigh.Value);
        }

        public void UpdateRX2FilterPresetHigh(int val)
        {
            UpdateRX2Filters((int)udRX2FilterLow.Value, val);
        }


        public void UpdateVFOAFreq(string freq)
        {   // only do this routine if there are six digits after the decimal point. or decimal comma


            dialcheckA = true;  // update DIAL if active

         //   if (VFOAFreq > 9999.999999)
          //  {
             //   txtVFOALSD.Visible = false;
             //   txtVFOAMSD.Visible = false;

           // }
          //  else
          //  {
                txtVFOALSD.Visible = SmallLSD;
                txtVFOAMSD.Visible = SmallLSD;
          //  }

            txtVFOAFreq.Text = freq;
            txtVFOAMSD.Text = freq;


            string temp = freq;
            int index = temp.IndexOf(separator) + 4; //


            index = temp.IndexOf(separator) + 4; // 3 digits
            txtVFOALSD.Width = 75; // default is 73
         //   txtVFOALSD.Location = new Point(184, 17); // default is 184,17 .228


            txtVFOALSD.Text = temp.Remove(0, index);  // 3 small orange digits (remove digits xxx.xxx)

            if (KWAutoInformation) BroadcastFreqChange("A", freq);
            if (KWAutoInformation2) BroadcastFreqChange2("A", freq);  //.214
            if (KWAutoInformation3) BroadcastFreqChange3("A", freq);
            if (KWAutoInformation4) BroadcastFreqChange4("A", freq);
            if (KWAutoInformation5) BroadcastFreqChange5("A", freq);
            if (KWAutoInformation6) BroadcastFreqChange6("A", freq);

            if (KWAutoInformation7) BroadcastFreqChange7("A", freq); // TCP/IP CAT



        } // update vfoA freq


        public bool SpoofAB = false; // ke9ns: add .200 use special CAT port to spoof VFOB data as VFOA (to run 2 instances of a digitial mode program and use RX2 VFOB as VFOA
        public bool LastVFOBTX = false; // ke9ns add .200  true = SpoofAB caused the TX on VFOB, so return TX to VFOA after TX is over.
        public bool SpoofTX = false; // ke9ns add .200 true=TX in spoof mode, false=not in TX with spoof

        private void BroadcastFreqChange(string vfo, string freq)
        {
            freq = "F" + vfo + freq.Replace(separator, "").PadLeft(11, '0') + ";";
            try
            {
                siolisten.SIO.put(freq);
                
            }
            catch { }
        } // BroadcastFreqChange

        private void BroadcastFreqChange2(string vfo, string freq) // ke9ns add .214
        {
            freq = "F" + vfo + freq.Replace(separator, "").PadLeft(11, '0') + ";";
            try
            {
                siolisten2.SIO2.put(freq); // ke9ns .180 port2
            }
            catch { }
        } //BroadcastFreqChange2

        private void BroadcastFreqChange3(string vfo, string freq) // ke9ns add .214
        {
            freq = "F" + vfo + freq.Replace(separator, "").PadLeft(11, '0') + ";";
            try
            {
                siolisten3.SIO3.put(freq); // ke9ns .180 port2
            }
            catch { }
        } //BroadcastFreqChange3

        private void BroadcastFreqChange4(string vfo, string freq) // ke9ns add .214
        {
            freq = "F" + vfo + freq.Replace(separator, "").PadLeft(11, '0') + ";";
            try
            {
                siolisten4.SIO4.put(freq); // ke9ns .180 port2
            }
            catch { }
        } //BroadcastFreqChange4

        private void BroadcastFreqChange5(string vfo, string freq) // ke9ns add .214
        {
            freq = "F" + vfo + freq.Replace(separator, "").PadLeft(11, '0') + ";";
            try
            {
                siolisten5.SIO5.put(freq); // ke9ns .180 port2
            }
            catch { }
        } //BroadcastFreqChange5

        private void BroadcastFreqChange6(string vfo, string freq) // ke9ns add .214
        {
            freq = "F" + vfo + freq.Replace(separator, "").PadLeft(11, '0') + ";";
            try
            {
                siolisten6.SIO6.put(freq); // ke9ns .180 port2
            }
            catch { }
        } //BroadcastFreqChange6

        private void BroadcastFreqChange7(string vfo, string freq) // ke9ns add .214
        {
            freq = "F" + vfo + freq.Replace(separator, "").PadLeft(11, '0') + ";";
            try
            { 
                KWAI7 = true; //ke9ns: CATURL() should detect this
                CATURLFREQ = freq; //                           
            }
            catch { }
        } //BroadcastFreqChange7

        //=========================================================================
        public void UpdateVFOBFreq(string freq)
        {   // only do this routine if there are six digits after the decimal point.


            dialcheckB = true; // there was a update to the VFOB freq, so notify DIALB

         //   if (VFOBFreq > 9999.999999)
          //  {
            //    txtVFOBLSD.Visible = false;
             //   txtVFOBMSD.Visible = false;

          //  }
          //  else
          //  {
                txtVFOBLSD.Visible = SmallLSD;
                txtVFOBMSD.Visible = SmallLSD;
         //   }


            txtVFOBFreq.Text = freq;
            txtVFOBMSD.Text = freq;

            string temp = freq;
            int index = temp.IndexOf(separator) + 4;



            index = temp.IndexOf(separator) + 4; // 3 digits
            txtVFOBLSD.Width = 75;
          //  txtVFOBLSD.Location = new Point(184, 17); //.228



            txtVFOBLSD.Text = temp.Remove(0, index);
            if (KWAutoInformation) BroadcastFreqChange("B", freq);
            if (KWAutoInformation2) BroadcastFreqChange2("B", freq); // .214
            if (KWAutoInformation3) BroadcastFreqChange3("B", freq);
            if (KWAutoInformation4) BroadcastFreqChange4("B", freq);
            if (KWAutoInformation5) BroadcastFreqChange5("B", freq);
            if (KWAutoInformation6) BroadcastFreqChange6("B", freq);

            if (KWAutoInformation7) BroadcastFreqChange7("B", freq); // TCP/IP CAT




        }

        //===============================================================================
        //ke9ns: comes here when you change zoom levels or anything that would change your viewing left/right frequency limits
        public void CalcDisplayFreq()
        {

            if (Display.CurrentDisplayMode != DisplayMode.PANADAPTER &&
                Display.CurrentDisplayMode != DisplayMode.WATERFALL &&
                Display.CurrentDisplayMode != DisplayMode.PANAFALL &&
                Display.CurrentDisplayMode != DisplayMode.PANASCOPE)
                return;


            //double edge_alias = 7200.0;
            //double if_freq = 11025.0;

            double spur_tune_width = 0;
            switch (current_model)
            {
                case Model.SDR1000:
                    spur_tune_width = 200e6 / Math.Pow(2, 16);
                    break;
                case Model.FLEX5000:
                    spur_tune_width = 7629.39453125;   // 500e6 / Math.Pow(2, 16); // ke9ns 500mhz / 65536 = 7629.39453125
                    break;
                case Model.FLEX3000:
                    spur_tune_width = 7617.20275879; //  499.201e6 / Math.Pow(2, 16);
                    break;
                case Model.FLEX1500:
                    double clock = 384e6;
                    if (flex_1500_xref) clock = 400e6;

                    spur_tune_width = clock / Math.Pow(2, 16);
                    if (!chkSR.Checked) spur_tune_width = 2000;

                    break;
            } // switch current_model

            double zoom_factor = (ptbDisplayZoom.Maximum + ptbDisplayZoom.Minimum - ptbDisplayZoom.Value) * 0.01; // (260+1-value)*.01    range from LEFT= 2.6 RIGHT = .01

            int low = (int)(-10000.0 * sample_rate1 / 48000.0 * zoom_factor); //-40000 with zoom =1 or -96000 with zoom=.5
            int high = -low;
            int width = high - low; // ke9ns: in hz    40000- -40000 = +80000 at 192k SR and Zoom = 1x

            if (width > sample_rate1 - 2 * spur_tune_width) width = (int)(sample_rate1 - 2 * spur_tune_width);

            // ke9ns: below calculates the +/- hz of the full absolute widest the display could be (with no zoom at all)
            int abs_low = (int)(-(double)sample_rate1 * 0.5 - if_freq * 1e6 + spur_tune_width); // (-192000 * .5) - (0.009000 * 1000000) + 7629.39453125 = -96000 - 9000 + 7629.39453125  = -97373
            int abs_high = (int)((double)sample_rate1 * 0.5 - if_freq * 1e6 - spur_tune_width); // +97373 

            if (high > abs_high)
            {
                //Debug.WriteLine("high: "+high+"  abs_high: "+abs_high);
                high = abs_high;
                low = high - width;
            }

            if (low < abs_low)
            {
                //Debug.WriteLine("low: "+low+"  abs_low: "+abs_low);
                low = abs_low;
                high = low + width;
            }

            // ke9ns: this would get you 192k across the pan, but signals drop off on the edges.
            //  high = abs_high+8000;
            //  low = abs_low-8000;
            //  width = high - low;

            // ke9ns Factor in the PAN slider (which allows you to slide around within the absolute limits)
            int max_pan_width = (int)(sample_rate1 - 2 * spur_tune_width - width); // ke9ns  192000 - (2 * 7629.39453125) - 80000 = 96741

            int pan_freq = max_pan_width * ptbDisplayPan.Value / ptbDisplayPan.Maximum; // ke9ns 96741 * 593 / 1000 = 57367

            low = abs_low + pan_freq; // ke9ns: -97373 + 57367 = -40000

            low = low - (int)CTUN1_HZ; // ke9ns add: CTUN (adjust display so it appears as if the VFOA bandpass is moving but not the panadapter and not the waterfall 

            high = low + width; // -4000 + 8000 = 40000

            //   if (CTUN == true) CTUN3 = 1; // ke9ns add: dont allow rundisplay() thread from updating display while in CTUN mode

            Display.RXDisplayLow = Display.TXDisplayLow = low; // ke9ns at 192k SR  low = -96000 with zoom =.5 (different for Spectrum display)
            Display.RXDisplayHigh = Display.TXDisplayHigh = high;

            //  Debug.WriteLine("Display Limits: " + low + ", " + high);


            if (CTUN == true) // ke9ns add
            {
                VFOAFreq = tempVFOAFreq; // CTUN operation changed freq
            }

            //-------------------------------------------------------
            // ke9ns for RX2

           if (current_model == Model.FLEX5000 && FWCEEPROM.RX2OK)  //.220 corrected
           {
                double zoom_factor2 = (ptbDisplayZoom2.Maximum + ptbDisplayZoom2.Minimum - ptbDisplayZoom2.Value) * 0.01; // (260+1-value)*.01    range from LEFT= 2.6 RIGHT = .01

                int low2 = (int)(-10000.0 * sample_rate1 / 48000.0 * zoom_factor2); //-40000 with zoom =1 or -96000 with zoom=.5
                int high2 = -low2;
                int width2 = high2 - low2; // ke9ns: in hz    40000- -40000 = +80000 at 192k SR and Zoom = 1x

                if (width2 > sample_rate1 - 2 * spur_tune_width) width2 = (int)(sample_rate1 - 2 * spur_tune_width);

                // ke9ns: below calculates the +/- hz of the full absolute widest the display could be (with no zoom at all)
                int abs_low2 = (int)(-(double)sample_rate1 * 0.5 - if_freq * 1e6 + spur_tune_width); // (-192000 * .5) - (0.009000 * 1000000) + 7629.39453125 = -96000 - 9000 + 7629.39453125  = -97373
                int abs_high2 = (int)((double)sample_rate1 * 0.5 - if_freq * 1e6 - spur_tune_width); // +97373 

                if (high2 > abs_high2)
                {
                    //Debug.WriteLine("high: "+high+"  abs_high: "+abs_high);
                    high2 = abs_high2;
                    low2 = high - width2;
                }

                if (low2 < abs_low2)
                {
                    //Debug.WriteLine("low: "+low+"  abs_low: "+abs_low);
                    low2 = abs_low2;
                    high2 = low2 + width2;
                }

                // ke9ns: this would get you 192k across the pan, but signals drop off on the edges.
                //  high = abs_high+8000;
                //  low = abs_low-8000;
                //  width = high - low;

                // ke9ns Factor in the PAN slider (which allows you to slide around within the absolute limits)
                int max_pan_width2 = (int)(sample_rate1 - 2 * spur_tune_width - width2); // ke9ns  192000 - (2 * 7629.39453125) - 80000 = 96741

                int pan_freq2 = max_pan_width2 * ptbDisplayPan2.Value / ptbDisplayPan2.Maximum; // ke9ns 96741 * 593 / 1000 = 57367

                low2 = abs_low2 + pan_freq2; // ke9ns: -97373 + 57367 = -40000

                low2 = low2 - (int)CTUN1_HZ; // ke9ns add: CTUN (adjust display so it appears as if the VFOB bandpass is moving but not the panadapter and not the waterfall 

                high2 = low2 + width2; // -4000 + 8000 = 40000

                //   if (CTUN == true) CTUN3 = 1; // ke9ns add: dont allow rundisplay() thread from updating display while in CTUN mode

                Display.RXDisplayLow2 = Display.TXDisplayLow2 = low2; // ke9ns at 192k SR  low = -96000 with zoom =.5 (different for Spectrum display)
                Display.RXDisplayHigh2 = Display.TXDisplayHigh2 = high2;

            } // rx2 //.219


            //  Debug.WriteLine("Display Limits: " + low + ", " + high);

            UpdateDisplay(); // force a redraw of the picDisplay since you have new freq edges based on new zoom level


            //  CTUN3 = 0;

        } //CalcDisplayFreq()



        private void UpdateRXDisplayVars(int l, int h)
        {
            int low = 0, high = 0;
            if (l < 0 && h <= 0)
            {
                high = 0;
                if (l >= -910)
                    low = -1000;
                else
                    low = (int)(l * 1.1);
            }
            else if (l >= 0 && h > 0)
            {
                low = 0;
                if (h <= 910)
                    high = 1000;
                else
                    high = (int)(h * 1.1);
            }
            else if (l < 0 && h > 0)
            {
                int max_edge = Math.Max(-l, h);
                low = (int)(max_edge * -1.1);
                high = (int)(max_edge * 1.1);
            }
            Display.RXDisplayLow = low;
            Display.RXDisplayHigh = high;
        } // UpdateRXDisplayVars

        private void UpdateRXDisplayVars2(int l, int h) //.219
        {
            int low = 0, high = 0;
            if (l < 0 && h <= 0)
            {
                high = 0;
                if (l >= -910)
                    low = -1000;
                else
                    low = (int)(l * 1.1);
            }
            else if (l >= 0 && h > 0)
            {
                low = 0;
                if (h <= 910)
                    high = 1000;
                else
                    high = (int)(h * 1.1);
            }
            else if (l < 0 && h > 0)
            {
                int max_edge = Math.Max(-l, h);
                low = (int)(max_edge * -1.1);
                high = (int)(max_edge * 1.1);
            }
            Display.RXDisplayLow2 = low;
            Display.RXDisplayHigh2 = high;
        } // UPdatedisplayvars


        public static void UpdateTXDisplayVars(int l, int h)
        {
            int low = 0, high = 0;
            if (l < 0 && h <= 0)
            {
                high = 0;
                if (l >= -910)
                    low = -1000;
                else
                    low = (int)(l * 1.1);
            }
            else if (l >= 0 && h > 0)
            {
                low = 0;
                if (h <= 910)
                    high = 1000;
                else
                    high = (int)(h * 1.1);
            }
            else if (l < 0 && h > 0)
            {
                int max_edge = Math.Max(-l, h);
                low = (int)(max_edge * -1.1);
                high = (int)(max_edge * 1.1);
            }

            Display.TXDisplayLow = low;
            Display.TXDisplayHigh = high;

         
        } //UpdateTXDisplayVars

        public static void UpdateTXDisplayVars2(int l, int h) //.219 add
        {
            int low = 0, high = 0;
            if (l < 0 && h <= 0)
            {
                high = 0;
                if (l >= -910)
                    low = -1000;
                else
                    low = (int)(l * 1.1);
            }
            else if (l >= 0 && h > 0)
            {
                low = 0;
                if (h <= 910)
                    high = 1000;
                else
                    high = (int)(h * 1.1);
            }
            else if (l < 0 && h > 0)
            {
                int max_edge = Math.Max(-l, h);
                low = (int)(max_edge * -1.1);
                high = (int)(max_edge * 1.1);
            }

            Display.TXDisplayLow2 = low;
            Display.TXDisplayHigh2 = high;


        } //UpdateTXDisplayVars2

        // ke9ns modify for ISB  LSB-AM and USB-AM
        public void SetTXFilters(DSPMode mode, int low, int high)
        {
          //  Debug.WriteLine("... HIGH-LOW: " + high + " , " + low + " mode: " + mode + " band: " + rx1_band + " Tband: " + tx_band);

            int l = 0, h = 0;

            low = (int)Math.Max(low, 15);  // ke9ns mod:  was 50  I guess this is the lowest of the low  50hz

            switch (mode)
            {
                case DSPMode.CWL: // ke9ns moved (to allow smaller tx window)
                    l = -high;
                    h = -low;

                    break;
                case DSPMode.CWU: // ke9ns moved (to allow smaller tx window)
                    l = low;
                    h = high;

                    break;
                case DSPMode.LSB:
                case DSPMode.DIGL:
                    l = -high;
                    h = -low;
                    break;
                case DSPMode.USB:
                case DSPMode.DIGU:
                    l = low;
                    h = high;
                    break;
                case DSPMode.DSB:
                    l = -high;
                    h = high;
                    break;
                case DSPMode.AM:

                    if (AMMODE == DSPISB.AML) // ke9ns add
                    {
                        l = -high;
                        h = 130; //  needs 130 to allow full power of carrier
                    }
                    else if (AMMODE == DSPISB.AMU)
                    {
                        l = -130; // needs -130 to allow full power of carrier
                        h = high;
                    }
                    else
                    {
                        l = -high;  // ke9ns normal AM mode
                        h = high;
                    }


                    break; // AM

                case DSPMode.SAM:

                    if (SAMMODE == DSPISB.AML) // ke9ns add
                    {
                        l = -high;
                        h = 130; //  needs 130 to allow full power of carrier
                    }
                    else if (SAMMODE == DSPISB.AMU)
                    {
                        l = -130; // needs -130 to allow full power of carrier
                        h = high;
                    }
                    else
                    {
                        l = -high;  // ke9ns normal AM mode
                        h = high;
                    }

                    break; // SAM

                case DSPMode.FM:
                    if (dsp.GetDSPTX(0).TXFMDeviation == FMDataDeviation)     //FMData == true) // ke9ns add (FM data mode with larger freq window) WFM
                    {
                        l = -FMDataLowHigh; // -11000 (change to 20k .218)
                        h = FMDataLowHigh;  // 11000
                    }
                    else if (dsp.GetDSPTX(0).TXFMDeviation == 5000)
                    {
                        l = -8000;
                        h = 8000;
                    }
                    else if (dsp.GetDSPTX(0).TXFMDeviation == 2500)
                    {
                        l = -4000;
                        h = 4000;
                    }
                    break;
                case DSPMode.DRM:
                    l = 7000;
                    h = 17000;
                    break;
            }

            switch (Display.CurrentDisplayMode)
            {
                case DisplayMode.PANADAPTER:
                case DisplayMode.WATERFALL:
                case DisplayMode.PANAFALL:
                case DisplayMode.PANASCOPE:
                    break;
                default:
                    UpdateTXDisplayVars(l, h);
                    UpdateTXDisplayVars2(l, h); //.219 add
                    break;
            }

            dsp.GetDSPTX(0).SetTXFilter(l, h);

            //  dsp.GetDSPTX(0).SetTXFilter(-90000, 0); // ke9ns testdsp limited to about 90khz


            if (fwc_init && (current_model == Model.FLEX5000 || current_model == Model.FLEX3000))
            {
                FWC.SetTXDSPFilter(l, h);
            }

            Display.TXFilterLow = l;
            Display.TXFilterHigh = h;

         //   Debug.WriteLine("SET HIGH-LOW: " + h + " , " + l + " mode: " + mode + " band: " + rx1_band + " Tband: " + tx_band);


            if (chkVFOSplit.Checked == true)
            {
                Display.SplitEnabled = true; // ke9ns reset the SPLIT TX for AM-U and AM-L 

            }

        } // set txfilters


        public void UpdateTXProfile(string name)
        {
            if (setupForm == null) return;

            //string old = comboTXProfile.Text;
            comboTXProfile.Items.Clear();
            comboDigTXProfile.Items.Clear();
            comboFMTXProfile.Items.Clear();
            comboCWTXProfile.Items.Clear(); // ke9ns
            string[] s = setupForm.GetTXProfileStrings();

            comboTXProfile.Items.AddRange(s);
            comboDigTXProfile.Items.AddRange(s);
            comboFMTXProfile.Items.AddRange(s);
            comboCWTXProfile.Items.AddRange(s); // ke9ns add

            if (name != "") comboTXProfile.Text = name;
        }



        //=================================================================================================
        public void UpdateWaterfallLevelValues()
        {

            if (!initializing)
            {

                UpdateBandButtonColors(); // ke9ns add to update the regBOX bandstack values on screen

                if (StackForm != null)
                {
                    int value;
                    StackForm.textBox1.Focus();

                    if (int.TryParse(regBox1.Text, out value))
                    {

                        if (value > 0)
                        {
                            StackForm.textBox1.SelectionStart = (value - 1) * StackForm.BSLength;       // start of each bandstack line
                            StackForm.textBox1.SelectionLength = StackForm.BSLength;                    // length of each bandstack line

                            textBox1.SelectionStart = (value - 1) * StackForm.BSLength;       // start of each bandstack line
                            textBox1.SelectionLength = StackForm.BSLength;                    // length of each bandstack line

                        }
                        else
                        {
                            StackForm.textBox1.SelectionStart = 0;
                            StackForm.textBox1.SelectionLength = StackForm.BSLength;

                            textBox1.SelectionStart = 0;
                            textBox1.SelectionLength = StackForm.BSLength;

                        }

                    }
                    else
                    {
                        Debug.WriteLine("no value");
                        StackForm.textBox1.SelectionStart = 0;
                        StackForm.textBox1.SelectionLength = StackForm.BSLength;

                        textBox1.SelectionStart = 0;
                        textBox1.SelectionLength = StackForm.BSLength;

                    }
                }

                //
                switch (RX1Band)
                {
                    case Band.B160M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold160m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold160m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold160m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold160m;


                        break;
                    case Band.B80M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold80m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold80m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold80m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold80m;



                        break;
                    case Band.B60M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold60m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold60m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold60m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold60m;


                        break;
                    case Band.B40M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold40m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold40m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold40m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold40m;


                        break;
                    case Band.B30M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold30m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold30m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold30m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold30m;


                        break;
                    case Band.B20M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold20m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold20m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold20m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold20m;
                        break;

                    // ----------------------
                    // ke9ns add
                    case Band.BLMF:
                        setupForm.WaterfallLowThreshold = WaterfallLowThresholdLMF;
                        setupForm.WaterfallHighThreshold = WaterfallHighThresholdLMF;
                        Display.WaterfallLowThreshold = WaterfallLowThresholdLMF;
                        Display.WaterfallHighThreshold = WaterfallHighThresholdLMF;
                        break;
                    case Band.B120M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold120m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold120m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold120m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold120m;
                        break;
                    case Band.B90M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold90m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold90m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold90m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold90m;
                        break;
                    case Band.B61M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold61m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold61m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold61m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold61m;
                        break;
                    case Band.B49M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold49m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold49m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold49m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold49m;
                        break;
                    case Band.B41M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold41m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold41m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold41m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold41m;
                        break;
                    case Band.B31M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold31m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold31m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold31m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold31m;
                        break;
                    case Band.B25M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold25m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold25m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold25m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold25m;
                        break;
                    case Band.B22M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold22m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold22m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold22m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold22m;
                        break;
                    case Band.B19M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold19m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold19m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold19m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold19m;
                        break;
                    case Band.B16M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold16m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold16m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold16m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold16m;
                        break;
                    case Band.B14M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold14m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold14m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold14m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold14m;
                        break;
                    case Band.B13M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold13m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold13m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold13m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold13m;
                        break;
                    case Band.B11M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold11m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold11m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold11m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold11m;

                        //----------------------


                        break;
                    case Band.B17M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold17m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold17m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold17m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold17m;


                        break;
                    case Band.B15M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold15m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold15m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold15m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold15m;


                        break;
                    case Band.B12M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold12m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold12m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold12m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold12m;


                        break;
                    case Band.B10M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold10m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold10m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold10m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold10m;



                        break;
                    case Band.B6M:
                        setupForm.WaterfallLowThreshold = WaterfallLowThreshold6m;
                        setupForm.WaterfallHighThreshold = WaterfallHighThreshold6m;
                        Display.WaterfallLowThreshold = WaterfallLowThreshold6m;
                        Display.WaterfallHighThreshold = WaterfallHighThreshold6m;


                        break;
                    case Band.WWV:
                        setupForm.WaterfallLowThreshold = WaterfallLowThresholdWWV;
                        setupForm.WaterfallHighThreshold = WaterfallHighThresholdWWV;
                        Display.WaterfallLowThreshold = WaterfallLowThresholdWWV;
                        Display.WaterfallHighThreshold = WaterfallHighThresholdWWV;


                        break;
                    case Band.GEN:
                        setupForm.WaterfallLowThreshold = WaterfallLowThresholdGEN;
                        setupForm.WaterfallHighThreshold = WaterfallHighThresholdGEN;
                        Display.WaterfallLowThreshold = WaterfallLowThresholdGEN;
                        Display.WaterfallHighThreshold = WaterfallHighThresholdGEN;


                        break;
                    default:
                        setupForm.WaterfallLowThreshold = WaterfallLowThresholdXVTR;
                        setupForm.WaterfallHighThreshold = WaterfallHighThresholdXVTR;
                        Display.WaterfallLowThreshold = WaterfallLowThresholdXVTR;
                        Display.WaterfallHighThreshold = WaterfallHighThresholdXVTR;

                        break;

                } // RX1Band

                //   UpdateBandButtonColors(); // ke9ns add to update the regBOX bandstack values on screen

                //================================================================
                //================================================================
                // ke9ns add: copy low waterfall value from standard RX1 position into RX2 low 
                //================================================================
                //================================================================

                int value2;
               // StackForm.textBox2.Focus();

                if (int.TryParse(regBox12, out value2))
                {

                    if (value2 > 0)
                    {
                      //  StackForm.textBox2.SelectionStart = (value - 1) * StackForm.BSLength;       // start of each bandstack line
                     //   StackForm.textBox2.SelectionLength = StackForm.BSLength;                    // length of each bandstack line

                        textBox2.SelectionStart = (value2 - 1) * StackForm.BSLength;       // start of each bandstack line
                        textBox2.SelectionLength = StackForm.BSLength;                    // length of each bandstack line

                    }
                    else
                    {
                      //  StackForm.textBox2.SelectionStart = 0;
                      //  StackForm.textBox2.SelectionLength = StackForm.BSLength;

                        textBox2.SelectionStart = 0;
                        textBox2.SelectionLength = StackForm.BSLength;

                    }

                }
                else
                {
                    Debug.WriteLine("no value");
                  //  StackForm.textBox1.SelectionStart = 0;
                   // StackForm.textBox1.SelectionLength = StackForm.BSLength;

                    textBox2.SelectionStart = 0;
                    textBox2.SelectionLength = StackForm.BSLength;

                }
           


                rx2_band = StringToBand(comboRX2Band.Text);  // ke9ns add  get band even if OFF, just in case you turn it on later

                switch (RX2Band)  // ke9ns ADD (not reading correctly here when RX2 is off)
                {

                    case Band.B160M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold160m;  // ke9ns ADD rx2
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold160m;
                        break;
                    case Band.B80M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold80m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold80m;
                        break;
                    case Band.B60M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold60m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold60m;
                        break;
                    case Band.B40M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold40m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold40m;
                        break;
                    case Band.B30M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold30m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold30m;
                        break;
                    case Band.B20M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold20m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold20m;
                        break;


                    //--------------------------
                    // ke9ns add

                    case Band.BLMF:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThresholdLMF;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThresholdLMF;
                        break;
                    case Band.B120M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold120m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold120m;
                        break;

                    case Band.B90M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold90m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold90m;
                        break;
                    case Band.B61M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold61m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold61m;
                        break;

                    case Band.B49M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold49m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold49m;
                        break;

                    case Band.B41M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold41m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold41m;
                        break;
                    case Band.B31M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold31m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold31m;
                        break;

                    case Band.B25M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold25m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold25m;
                        break;

                    case Band.B22M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold22m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold22m;
                        break;

                    case Band.B19M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold19m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold19m;
                        break;

                    case Band.B16M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold16m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold16m;
                        break;

                    case Band.B14M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold14m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold14m;
                        break;

                    case Band.B13M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold13m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold13m;
                        break;

                    case Band.B11M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold11m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold11m;
                        break;

                    //-----------------------

                    case Band.B17M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold17m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold17m;
                        break;
                    case Band.B15M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold15m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold15m;
                        break;
                    case Band.B12M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold12m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold12m;
                        break;
                    case Band.B10M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold10m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold10m;
                        break;
                    case Band.B6M:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThreshold6m;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThreshold6m;
                        break;
                    case Band.WWV:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThresholdWWV;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThresholdWWV;
                        break;
                    case Band.GEN:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThresholdGEN;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThresholdGEN;
                        break;
                    default:
                        setupForm.WaterfallLowRX2Threshold = WaterfallLowThresholdXVTR;
                        Display.WaterfallLowRX2Threshold = WaterfallLowThresholdXVTR;
                        break;
                } // RX2Band

                //    Debug.WriteLine("rX2 low upateband " + RX2Band);
                //    Debug.WriteLine("rX2 low upatevalue " + Display.WaterfallLowRX2Threshold);

                setupForm.UpdateWaterfallBandInfo();

                AA.Restart(); // ke9ns
                autoadjust1 = true; // ke9ns add for automatic water and pan level updates

            } // !initializing



        } // UpdateWaterfallLevelValues()



        public void ShowRemoteProfileMenu(bool action)
        {
            remoteProfilesToolStripMenuItem.Visible = action;
        }

        public string CATGetXVTRBandNames()
        {
            string names = "";
            for (int n = 0; n < 14; n++)
            {
                if (xvtrForm.GetEnabled(n) == true)
                    names += vhf_text[n].Text.ToString().PadLeft(5, ' ');

                else
                    names += "     ";
            }
            return names;
        }

        public string GetFilterPresets(int mode_ndx)
        {
            string mode_info = "";
            for (Filter f = Filter.F1; f < Filter.NONE; f++)
            {

                mode_info += rx1_filters[mode_ndx].GetName(f).PadLeft(5, ' ').Substring(0, 5);
                mode_info += rx1_filters[mode_ndx].GetHigh(f).ToString().PadLeft(5, ' ');
                mode_info += rx1_filters[mode_ndx].GetLow(f).ToString().PadLeft(5, ' ');
            }
            return mode_info;
        }

        private void Set1500Filters(double freq)
        {
            // set TRX Filter
            int trx_filter = 0;
            if (freq < 0.48) // bypass
                trx_filter = 0;
            else if (freq < 0.88)
                trx_filter = 11; // AM 1
            else if (freq < 1.6)
                trx_filter = 10; // AM 2
            else if (freq < 2.3)
                trx_filter = 9;  // 160m
            else if (freq < 3.5)
                trx_filter = 8;  // 80m
            else if (freq < 5.2)
                trx_filter = 7;  // ??
            else if (freq < 7.7)
                trx_filter = 6;  // 60/40m
            else if (freq < 11.4)
                trx_filter = 5;  // 30m
            else if (freq < 17.0)
                trx_filter = 4;  // 20m
            else if (freq < 25.3)
                trx_filter = 3;  // 15/12m
            else if (freq < 37.6)
                trx_filter = 2;  // 10m
            else if (freq < 56.0)
                trx_filter = 1;  // 6m

            HIDTRXFilter = trx_filter;

            if (tx_ant_1500 == HIDAnt.PA)
            {
                int pa_filter = 0;
                if (freq < 0.0)
                    pa_filter = 0; // bypass
                else if (freq < 2.5)
                    pa_filter = 7; // 160m
                else if (freq < 5.0)
                    pa_filter = 6; // 80m
                else if (freq < 8.8)
                    pa_filter = 5; // 60/40m
                else if (freq < 17.5)
                    pa_filter = 4; // 30/20m
                else if (freq < 24.0)
                    pa_filter = 3; // 17/15m
                else if (freq < 35.0)
                    pa_filter = 2; // 12/10m
                else
                    pa_filter = 1; // 6m

                HIDPAFilter = pa_filter;
            }
        }

        private int SetVURXPath()
        {
            /*				Von		Uon		VRX2	URX2
            0   VU not used	0		0		0		0
            1	URX1		0		1		0		0
            2	URX2		0		1		0		1
            3	VRX1*		1		0		0		0
            4	VRX2		1		0		1		0
            5	VRX1, URX2*	1		1		0		1
            6	VRX2, URX1	1		1		1		0
            -  Invalid     1       1       1       1
            -  Invalid     1       1       0       0 (Split)
            */
            if (swapping) return 0;
            int rx2_xvtr_index_local = rx2_xvtr_index;
            if (!rx2_enabled)
                rx2_xvtr_index_local = -1;

            if (rx1_xvtr_index == 0)
            {
                if (rx2_xvtr_index_local == 0)
                {
                    //MessageBox.Show(new Form { TopMost = true }, "ERROR 15489",
                    //                "VU Error",
                    //                MessageBoxButtons.OK,
                    //                MessageBoxIcon.Error);
                    return 0;                  //Invalid
                }
                else if (rx2_xvtr_index_local == 1)   //URX2
                {
                    FWC.SetVU_RXPath(5);        //VRX1, URX2
                }
                else
                {
                    FWC.SetVU_RXPath(3);        //VRX1
                }
            }
            else if (rx1_xvtr_index == 1)
            {
                if (rx2_xvtr_index_local == 1)
                {
                    //MessageBox.Show(new Form { TopMost = true }, "ERROR 15488",
                    //                "VU Error",
                    //                MessageBoxButtons.OK,
                    //                MessageBoxIcon.Error);
                    return 0;                   //Invalid
                }
                else if (rx2_xvtr_index_local == 0)   //VRX2
                {
                    FWC.SetVU_RXPath(6);        //VRX2, URX1
                }
                else
                {
                    FWC.SetVU_RXPath(1);        //URX1
                }
            }
            else
            {
                if (rx2_xvtr_index_local == 0)
                {
                    FWC.SetVU_RXPath(4);        //VRX2
                }
                else if (rx2_xvtr_index_local == 1)
                {
                    FWC.SetVU_RXPath(2);        //URX2
                }
                else
                {
                    FWC.SetVU_RXPath(0);        //VU not used
                }
            }
            return 1;   //successful state
        }

        public bool FindNearestKey<T>(double f, SortedDictionary<double, T> dict, out double key)
        {
            if (dict == null || dict.Count == 0)
            {
                key = f;
                return false;
            }

            if (dict.ContainsKey(f))
            {
                key = f;
                return true;
            }

            double low = double.MinValue;
            double high = double.MaxValue;

            foreach (double next_key in dict.Keys)
            {
                if (next_key < f && next_key > low)
                    low = next_key;

                if (next_key > f && next_key < high)
                    high = next_key;
            }

            double low_delta = Math.Abs(low - f);
            double high_delta = Math.Abs(high - f);

            if (low_delta < high_delta)
                key = low;
            else key = high;
            return true;
        }

        public int CurrentTuneStepHz
        {
            get { return tune_step_list[tune_step_index].StepHz; }
        }

        //==============================================================
        // ke9ns add for PowerMate
        public int CurrentTuneStepHz2
        {
            get { return tune_step_list[setupForm.tune_step_index4].StepHz; } // ke9ns was index2
        }


        public double CurrentTuneStepMHz
        {
            get { return tune_step_list[tune_step_index].StepHz * 1e-6; }
        }

        #endregion

        #region Test and Calibration Routines

        private Progress p;
        public bool CalibratePABias(Progress progress, float driver_target, float final_target, float tol, int index)
        {
            bool ret_val = false;
            float driver_limit = 10.0f;
            float final_limit = 10.0f;

            if (!(fwc_init && (current_model == Model.FLEX5000 || current_model == Model.FLEX3000)))
            {
                progress.Text = "";
                progress.Hide();
                return false;
            }

            if (rx_only)
            {
                progress.Text = "";
                progress.Hide();
                MessageBox.Show(new Form { TopMost = true }, "Cannot run this calibration while RX Only is selected\n(Setup Form -> General Tab)",
                    "Error: RX Only is active",
                    MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }

            if (chkPower.Checked && (rx1_dsp_mode == DSPMode.CWL || rx1_dsp_mode == DSPMode.CWU))
                RX1DSPMode = DSPMode.DSB;

            int val = 0;
            float volts = 0.0f;
            float current = 0.0f;
            int counter = 0;

            // read 13.8V for a sanity check of the ADC
            FWC.ReadPAADC(2, out val);
            volts = (float)val / 4096 * 2.5f;
            float v138 = volts * 11;

            if (v138 < 13.0 || v138 > 14.5)
            {
                progress.Hide();
                MessageBox.Show(new Form { TopMost = true }, "13.8V not within tolerance [13.0, 14.5] -- (read " + v138.ToString("f1") + ")",
                    "ADC/Power Problem",
                    MessageBoxButtons.OK, MessageBoxIcon.Error);
                calibration_running = false;
                return false;
            }

            Thread.Sleep(100);

            int chan = 4;
            switch (current_model)
            {
                case Model.FLEX5000:
                    chan = 4;
                    break;
                case Model.FLEX3000:
                    chan = 3;
                    break;
            }
            FWC.ReadPAADC(chan, out val);
            volts = (float)val / 4096 * 2.5f;
            double temp_c = 301 - volts * 1000 / 2.2;
            if (temp_c > 50 || temp_c < 18)
            {
                progress.Hide();
                MessageBox.Show(new Form { TopMost = true }, "Temperature (" + temp_c.ToString("f0") + "°C) is outside of normal range (18-50°C).",
                    "PA Bias Cal Error: Temp",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                calibration_running = false;
                return false;
            }

            for (int i = 0; i < 8; i++)
                flex5000DebugForm.SetPAPot(i, 0);

            FWC.SetPABias(true);
            tx_cal = true;

            byte Q2 = 128, Q3 = 128;
            // find point where Q2 and Q3 just tickle the driver bias current
            float baseline = 0.0f;
            Thread.Sleep(50);
            baseline = ReadDriverBias(3);
            /*if(baseline > 0.020)
			{
				Thread.Sleep(50);
				baseline = ReadDriverBias(3);
			}
			if(baseline > 0.020) goto error;*/
            //MessageBox.Show(new Form { TopMost = true }, "Driver Baseline: "+baseline.ToString("f3"));
            Debug.WriteLine("baseline: " + baseline.ToString("f3"));

            for (int i = 0; i < 4; i++)
                flex5000DebugForm.SetPAPot(i, 128);

            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(0, Q2 += 10);
                if (Q2 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q2.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadDriverBias(3);
                if (current > driver_limit) goto high_current;
                if (Q2 == 255) goto error;
            }
            while (current < baseline + 0.002);
            progress.SetPercent(++counter / (float)16);
            flex5000DebugForm.SetPAPot(0, 0);
            Q2 -= 10;

            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(2, Q3 += 10);
                if (Q3 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q3.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadDriverBias(3);
                if (current > driver_limit) goto high_current;
                if (Q3 == 255) goto error;
            }
            while (current < baseline + 0.002);
            progress.SetPercent(++counter / (float)16);
            flex5000DebugForm.SetPAPot(2, 0);
            Q3 -= 10;
            Debug.WriteLine("Starting points  Q2:" + Q2 + "  Q3:" + Q3);
            //MessageBox.Show(new Form { TopMost = true }, "Starting points  Q2:"+Q2.ToString()+"  Q3:"+Q3.ToString());

            // add half of one driver's target current to Q2
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(0, Q2 += 5);
                if (Q2 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q2.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadDriverBias(3);
                if (current > driver_limit) goto high_current;
                if (Q2 == 255) goto error;
            }
            while (current < baseline + driver_target / 4);

            Q2 -= 5;
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(0, Q2 += 1);
                if (Q2 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q2.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadDriverBias(3);
                if (current > driver_limit) goto high_current;
                if (Q2 == 255) goto error;
            }
            while (current < baseline + driver_target / 4);
            progress.SetPercent(++counter / (float)16);

            float q2_current = current - baseline;
            Debug.WriteLine("Q2 Current: " + q2_current.ToString("f3") + "  Q2:" + Q2);
            //MessageBox.Show(new Form { TopMost = true }, "Q2 Current: "+q2_current.ToString("f3")+"  Q2:"+Q2.ToString());

            // add half of one driver's target current to Q3
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(2, Q3 += 5);
                Thread.Sleep(50);
                current = ReadDriverBias(3);
                if (current > driver_limit) goto high_current;
                if (Q3 == 255) goto error;
            }
            while (current < baseline + q2_current + driver_target / 4);
            Q3 -= 5;

            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(2, Q3 += 1);
                Thread.Sleep(50);
                current = ReadDriverBias(3);
                if (current > driver_limit) goto high_current;
                if (Q3 == 255) goto error;
            }
            while (current < baseline + q2_current + driver_target / 4);
            progress.SetPercent(++counter / (float)16);

            float q3_current = current - baseline - q2_current;
            Debug.WriteLine("Q3 Current: " + q3_current.ToString("f3") + "  Q3:" + Q3);
            //MessageBox.Show(new Form { TopMost = true }, "Q3 Current: "+q3_current.ToString("f3")+"  Q3:"+Q3.ToString());

            // add another half of one driver's target current to Q2
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(0, ++Q2);
                Thread.Sleep(50);
                current = ReadDriverBias(3);
                if (current > driver_limit) goto high_current;
                if (Q2 == 255) goto error;
            }
            while (current < baseline + q3_current + driver_target / 2);

            // tweak for just above target
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(0, --Q2);
                Thread.Sleep(100);
                current = ReadDriverBias(5);
                if (current > driver_limit) goto high_current;
            }
            while (current > baseline + q3_current + driver_target / 2);
            progress.SetPercent(++counter / (float)16);
            flex5000DebugForm.SetPAPot(0, ++Q2);
            current = ReadDriverBias(5);
            q2_current = current - q3_current - baseline;
            Debug.WriteLine("Q2 Current: " + q2_current.ToString("f3") + "  Q2:" + Q2);
            //MessageBox.Show(new Form { TopMost = true }, "Q2 Current: "+q2_current.ToString("f3")+"  Q2:"+Q2.ToString());

            // add another half of one driver's target current to Q3
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(2, ++Q3);
                Thread.Sleep(50);
                current = ReadDriverBias(3);
                if (current > driver_limit) goto high_current;
                if (Q3 == 255) goto error;
            }
            while (current < baseline + q2_current + driver_target / 2);

            // tweak for just above target
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(2, --Q3);
                Thread.Sleep(100);
                current = ReadDriverBias(5);
                if (current > driver_limit) goto high_current;
            }
            while (current > baseline + q2_current + driver_target / 2);
            progress.SetPercent(++counter / (float)16);
            flex5000DebugForm.SetPAPot(2, ++Q3);
            current = ReadDriverBias(5);
            q3_current = current - q2_current - baseline;
            Debug.WriteLine("Q3 Current: " + q3_current.ToString("f3") + "  Q3:" + Q3);
            //MessageBox.Show(new Form { TopMost = true }, "Q3 Current: "+q3_current.ToString("f3")+"  Q3:"+Q3.ToString());

            // tweak fine controls if available
            uint pa_rev;
            FWC.GetPARev(out pa_rev);

            byte Q2_fine = 128, Q3_fine = 128;
            if ((byte)(pa_rev >> 8) != 0) // not a beta radio
            {
                while (Math.Abs(q2_current - driver_target / 2) > 0.005)
                {
                    if (!progress.Visible) goto end;
                    if (q2_current > driver_target / 2) Q2_fine--;
                    else Q2_fine++;
                    flex5000DebugForm.SetPAPot(1, Q2_fine);
                    Thread.Sleep(50);
                    current = ReadDriverBias(5);
                    q2_current = current - q3_current - baseline;
                    if (current > driver_limit) goto high_current;
                    if (Q2_fine == 255 || Q2_fine == 0) goto error;
                }

                progress.SetPercent(++counter / (float)16);
                Debug.WriteLine("Q2 Current: " + q2_current.ToString("f3") + "  Q2_fine:" + Q2_fine);
                //MessageBox.Show(new Form { TopMost = true }, "Q2 Current: "+q2_current.ToString("f3")+"  Q2_fine:"+Q2_fine.ToString());

                while (Math.Abs(q3_current - driver_target / 2) > 0.005)
                {
                    if (!progress.Visible) goto end;
                    if (q3_current > driver_target / 2) Q3_fine--;
                    else Q3_fine++;
                    flex5000DebugForm.SetPAPot(3, Q3_fine);
                    Thread.Sleep(50);
                    current = ReadDriverBias(5);
                    q3_current = current - q2_current - baseline;
                    if (current > driver_limit) goto high_current;
                    if (Q3_fine == 255 || Q3_fine == 0) goto error;
                }

                progress.SetPercent(++counter / (float)16);
                Debug.WriteLine("Q3 Current: " + q3_current.ToString("f3") + "  Q3_fine:" + Q3_fine);
                //MessageBox.Show(new Form { TopMost = true }, "Q3 Current: "+q3_current.ToString("f3")+"  Q3_fine:"+Q3_fine.ToString());
            }
            else counter += 2;

            byte Q4 = 128, Q1 = 128;
            // find point where Q4 and Q1 just tickle the final bias current
            Thread.Sleep(50);
            baseline = ReadFinalBias(3, true);
            /*if(baseline > 0.100) 
			{
				Thread.Sleep(50);
				baseline = ReadFinalBias(3);
			}
			if(baseline > 0.100) goto error;*/
            //MessageBox.Show(new Form { TopMost = true }, "Final baseline: "+baseline.ToString("f3"));
            Debug.WriteLine("baseline: " + baseline.ToString("f3"));
            for (int i = 4; i < 8; i++)
                flex5000DebugForm.SetPAPot(i, 128);

            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(4, Q4 += 10);
                if (Q4 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q4.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadFinalBias(3, true);
                if (current > final_limit) goto high_current;
                if (Q4 == 255) goto error;
            }
            while (current < baseline + 0.005);
            progress.SetPercent(++counter / (float)16);
            flex5000DebugForm.SetPAPot(4, Q4 -= 10);

            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(6, Q1 += 10);
                if (Q1 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q1.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadFinalBias(3, true);
                if (current > final_limit) goto high_current;
                if (Q1 == 255) goto error;
            }
            while (current < baseline + 0.005);
            progress.SetPercent(++counter / (float)16);
            flex5000DebugForm.SetPAPot(6, Q1 -= 10);
            Debug.WriteLine("Starting points  Q4:" + Q4 + "  Q1:" + Q1);
            //MessageBox.Show(new Form { TopMost = true }, "Starting points  Q4:"+Q4.ToString()+"  Q1:"+Q1.ToString());

            // add half of one finals target current to Q4
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(4, Q4 += 5);
                if (Q4 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q4.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadFinalBias(3, true);
                if (current > final_limit) goto high_current;
                if (Q4 == 255) goto error;
            }
            while (current < baseline + final_target / 4);
            Q4 -= 5;

            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(4, Q4 += 1);
                if (Q4 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q4.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadFinalBias(3, true);
                if (current > final_limit) goto high_current;
                if (Q4 == 255) goto error;
            }
            while (current < baseline + final_target / 4);
            progress.SetPercent(++counter / (float)16);

            float q4_current = current - baseline;
            Debug.WriteLine("Q4 Current: " + q4_current.ToString("f3") + "  Q4:" + Q4);
            //MessageBox.Show(new Form { TopMost = true }, "Q4 Current: "+q4_current.ToString("f3")+"  Q4:"+Q4.ToString());

            // add half of one finals target current to Q1
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(6, Q1 += 5);
                if (Q1 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q1.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadFinalBias(3, true);
                if (current > final_limit) goto high_current;
                if (Q1 == 255) goto error;
            }
            while (current < baseline + q4_current + final_target / 4);
            Q1 -= 5;

            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(6, Q1 += 1);
                if (Q1 < 128)
                {
                    FWC.SetPABias(false);
                    progress.Hide();
                    MessageBox.Show(new Form { TopMost = true }, "PA Bias Error: Unable to hit target bias on Q1.  Likely hardware problem.",
                        "PA Bias Error",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                    calibration_running = false;
                    return false;
                }
                Thread.Sleep(50);
                current = ReadFinalBias(3, true);
                if (current > final_limit) goto high_current;
                if (Q1 == 255) goto error;
            }
            while (current < baseline + q4_current + final_target / 4);
            progress.SetPercent(++counter / (float)16);

            float q1_current = current - baseline - q4_current;
            Debug.WriteLine("Q1 Current: " + q1_current.ToString("f3") + "  Q1:" + Q1);
            //MessageBox.Show(new Form { TopMost = true }, "Q1 Current: "+q1_current.ToString("f3")+"  Q1:"+Q1.ToString());

            // add another half of one finals target current to Q4
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(4, ++Q4);
                Thread.Sleep(50);
                current = ReadFinalBias(3, true);
                if (current > final_limit) goto high_current;
                if (Q4 == 255) goto error;
            }
            while (current < baseline + q1_current + final_target / 2);

            // tweak for just above target
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(4, --Q4);
                Thread.Sleep(100);
                current = ReadFinalBias(5, true);
                if (current > final_limit) goto high_current;
            }
            while (current > baseline + q1_current + final_target / 2);
            progress.SetPercent(++counter / (float)16);
            flex5000DebugForm.SetPAPot(4, ++Q4);
            current = ReadFinalBias(5, true);
            q4_current = current - q1_current - baseline;
            Debug.WriteLine("Q4 Current: " + q4_current.ToString("f3") + "  Q4:" + Q4);
            //MessageBox.Show(new Form { TopMost = true }, "Q4 Current: "+q4_current.ToString("f3")+"  Q4:"+Q4.ToString());

            // add another half of one finals target current to Q1
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(6, ++Q1);
                Thread.Sleep(50);
                current = ReadFinalBias(3, true);
                if (current > final_limit) goto high_current;
                if (Q1 == 255) goto error;
            }
            while (current < baseline + q4_current + final_target / 2);

            // tweak for just above target
            do
            {
                if (!progress.Visible) goto end;
                flex5000DebugForm.SetPAPot(6, --Q1);
                Thread.Sleep(100);
                current = ReadFinalBias(5, true);
                if (current > final_limit) goto high_current;
            }
            while (current > baseline + q4_current + final_target / 2);
            progress.SetPercent(++counter / (float)16);
            flex5000DebugForm.SetPAPot(6, ++Q1);
            current = ReadFinalBias(5, true);
            q1_current = current - q4_current - baseline;
            Debug.WriteLine("Q1 Current: " + q1_current.ToString("f3") + "  Q1:" + Q1);
            //MessageBox.Show(new Form { TopMost = true }, "Q1 Current: "+q1_current.ToString("f3")+"  Q1:"+Q1.ToString());

            // tweak fine controls if available
            byte Q4_fine = 128, Q1_fine = 128;
            if ((byte)(pa_rev >> 8) != 0) // not a beta radio
            {
                while (Math.Abs(q4_current - final_target / 2) > tol)
                {
                    if (!progress.Visible) goto end;
                    if (q4_current > final_target / 2) Q4_fine--;
                    else Q4_fine++;
                    flex5000DebugForm.SetPAPot(5, Q4_fine);
                    Thread.Sleep(50);
                    current = ReadFinalBias(5, true);
                    q4_current = current - q1_current - baseline;
                    if (current > final_limit) goto high_current;
                    if (Q4_fine == 255 || Q4_fine == 0) goto error;
                }

                progress.SetPercent(++counter / (float)16);
                Debug.WriteLine("Q4 Current: " + q4_current.ToString("f3") + "  Q4_fine:" + Q4_fine);
                //MessageBox.Show(new Form { TopMost = true }, "Q4 Current: "+q4_current.ToString("f3")+"  Q4_fine:"+Q4_fine.ToString());

                while (Math.Abs(q1_current - final_target / 2) > tol)
                {
                    if (!progress.Visible) goto end;
                    if (q1_current > final_target / 2) Q1_fine--;
                    else Q1_fine++;
                    flex5000DebugForm.SetPAPot(7, Q1_fine);
                    Thread.Sleep(50);
                    current = ReadFinalBias(5, true);
                    q1_current = current - q4_current - baseline;
                    if (current > final_limit) goto high_current;
                    if (Q1_fine == 255 || Q1_fine == 0) goto error;
                }

                progress.SetPercent(++counter / (float)16);
                Debug.WriteLine("Q1 Current: " + q1_current.ToString("f3") + "  Q1_fine:" + Q1_fine);
                //MessageBox.Show(new Form { TopMost = true }, "Q1 Current: "+q1_current.ToString("f3")+"  Q1_fine:"+Q1_fine.ToString());
            }
            else counter += 2;

            ret_val = true;
        end:
            FWC.SetPABias(false);
            tx_cal = false;
            progress.Hide();
            if (progress.Text != "")
            {
                for (int i = 0; i < 8; i++)
                    pa_bias_table[index][i] = flex5000DebugForm.GetPAPot(i);
            }
            return ret_val;
        high_current:
            FWC.SetPABias(false);
            tx_cal = false;
            progress.Hide();
            MessageBox.Show(new Form { TopMost = true }, "Error in PA Bias Calibration: High Current Detected.",
                "PA Bias: High Current Detected",
                MessageBoxButtons.OK,
                MessageBoxIcon.Error);
            return false;
        error:
            FWC.SetPABias(false);
            tx_cal = false;
            progress.Hide();
            MessageBox.Show(new Form { TopMost = true }, "Error in PA Bias Calibration: Unable to reach current.",
                "PA Bias: Current Error",
                MessageBoxButtons.OK,
                MessageBoxIcon.Error);
            return false;
        }

        public float ReadDriverBias(int num_avg)
        {
            int val;
            int sum = 0;
            for (int i = 0; i < num_avg; i++)
            {
                FWC.ReadPAADC(1, out val);
                sum += val;
                if (i != num_avg - 1) Thread.Sleep(100);
            }
            sum /= num_avg;
            float current = (float)sum / 4096 * 2.5f; // 50 milliohm
            if (((byte)(FWCEEPROM.PARev >> 8)) == 0) current /= 2; // 100 milliohm
            flex5000DebugForm.SetADCText(current.ToString("f3") + " A");
            if (flex5000FinalTestForm != null)
                flex5000FinalTestForm.UpdateDriverBiasDebug(current);
            return current;
        }

        public float ReadFinalBias(int num_avg, bool show_debug)
        {
            int val;
            int sum = 0;
            for (int i = 0; i < num_avg; i++)
            {
                FWC.ReadPAADC(0, out val);
                sum += val;
                if (i != num_avg - 1) Thread.Sleep(100);
            }
            sum /= num_avg;
            float current = (float)sum / 4096 * 2.5f * 10;
            flex5000DebugForm.SetADCText(current.ToString("f3") + " A");
            if (flex5000FinalTestForm != null && show_debug)
                flex5000FinalTestForm.UpdateFinalBiasDebug(current);
            return current;
        }

        public double ReadFwdPower(int num_avg)
        {
            if (current_model != Model.FLEX5000 && current_model != Model.FLEX3000) return 0.0;
            int val;
            int sum = 0;
            int chan = 0;
            switch (current_model)
            {
                case Model.FLEX5000:
                    chan = 7;
                    break;
                case Model.FLEX3000:
                    chan = 5;
                    break;
            }

            for (int i = 0; i < num_avg; i++)
            {
                FWC.ReadPAADC(chan, out val);
                sum += val;
                if (i != num_avg - 1) Thread.Sleep(200);
            }
            sum /= num_avg;

            return FWCPAPower(sum);

        } //  ReadFwdPower(int num_avg)

        public float ReadFwdPowerVolts(int num_avg)
        {
            if (current_model != Model.FLEX5000 && current_model != Model.FLEX3000) return 0.0f;
            int val;
            int sum = 0;
            int chan = 0;
            switch (current_model)
            {
                case Model.FLEX5000:
                    chan = 7;
                    break;
                case Model.FLEX3000:
                    chan = 5;
                    break;
            }

            for (int i = 0; i < num_avg; i++)
            {
                FWC.ReadPAADC(chan, out val);
                sum += val;
                if (i != num_avg - 1) Thread.Sleep(100);
            }
            sum /= num_avg;
            float volts = (float)sum / 4096 * 2.5f;
            return volts;
        }

        public float ReadRefPowerVolts(int num_avg)
        {
            if (current_model != Model.FLEX5000 && current_model != Model.FLEX3000) return 0.0f;
            int val;
            int sum = 0;
            int chan = 0;
            switch (current_model)
            {
                case Model.FLEX5000:
                    chan = 6;
                    break;
                case Model.FLEX3000:
                    chan = 4;
                    break;
            }

            for (int i = 0; i < num_avg; i++)
            {
                FWC.ReadPAADC(chan, out val);
                sum += val;
                if (i != num_avg - 1) Thread.Sleep(100);
            }
            sum /= num_avg;
            float volts = (float)sum / 4096 * 2.5f;
            return volts;
        }

        public double ReadRefPower(int num_avg)
        {
            if (current_model != Model.FLEX5000 && current_model != Model.FLEX3000) return 0.0;
            int val;
            int sum = 0;
            int chan = 0;
            switch (current_model)
            {
                case Model.FLEX5000:
                    chan = 6;
                    break;
                case Model.FLEX3000:
                    chan = 4;
                    break;
            }

            for (int i = 0; i < num_avg; i++)
            {
                FWC.ReadPAADC(chan, out val);
                sum += val;
                if (i != num_avg - 1) Thread.Sleep(200);
            }
            sum /= num_avg;

            return FWCPAPower(sum) * swr_table[(int)tx_band];

        } // ReadRefPower(int num_avg)

        public float tx_carrier_min = float.MaxValue;
        public float[] min_tx_carrier = new float[(int)Band.LAST];
        public bool CalibrateTXCarrier(double freq, Progress progress, bool suppress_errors)
        {
            if (!(fwc_init && (current_model == Model.FLEX5000 || current_model == Model.FLEX3000)))
            {
                progress.Text = "";
                progress.Hide();
                return false;
            }

            if (!chkPower.Checked)
            {
                MessageBox.Show(new Form { TopMost = true }, "Power must be on in order to calibrate TX Carrier.", "Power Is Off",
                    MessageBoxButtons.OK, MessageBoxIcon.Stop);
                calibration_running = false;
                progress.Text = "";
                return false;
            }

            HiPerfTimer t1 = new HiPerfTimer();
            t1.Start();
            HiPerfTimer t2 = new HiPerfTimer();

            bool ret_val = false;
            calibration_running = true;
            progress.SetPercent(0.0f);

            // Setup hardware
            FWC.SetQSD(true);
            //Thread.Sleep(50);
            FWC.SetQSE(true);
            //Thread.Sleep(50);
            FWC.SetTR(true);
            //Thread.Sleep(50);
            FWC.SetSig(true);
            //Thread.Sleep(50);
            FWC.SetGen(false);
            //Thread.Sleep(50);
            FWC.SetTest(true);
            //Thread.Sleep(50);
            FWC.SetTXMon(false);
            //Thread.Sleep(50);
            FWC.SetPDrvMon(true);

            bool duplex = full_duplex;
            FullDuplex = true;

            bool spur_red = chkSR.Checked;                  // save current spur reduction setting
            chkSR.Checked = false;                          // turn spur reduction off

            bool polyphase = setupForm.Polyphase;           // save current polyphase setting
            setupForm.Polyphase = false;                    // disable polyphase

            int dsp_buf_size = setupForm.DSPPhoneRXBuffer;      // save current DSP buffer size
            setupForm.DSPPhoneRXBuffer = 4096;					// set DSP Buffer Size to 4096

            bool rx2_on = chkRX2.Checked;
            chkRX2.Checked = false;

            // setup display mode
            string display = comboDisplayMode.Text;
            comboDisplayMode.Text = "Spectrum";

            // setup dsp mode
            DSPMode dsp_mode = RX1DSPMode;
            RX1DSPMode = DSPMode.DSB;

            /*bool rx1_preamp = chkRX1Preamp.Checked;
            chkRX1Preamp.Checked = true;*/
            PreampMode preamp = rx1_preamp_mode;
            switch (current_model)
            {
                case Model.FLEX5000:
                    RX1PreampMode = PreampMode.HIGH;
                    break;
                case Model.FLEX3000:
                    if (BandByFreq(freq, -1, true, current_region) == Band.B160M)
                        RX1PreampMode = PreampMode.LOW;
                    else RX1PreampMode = PreampMode.HIGH;
                    break;
            }

            // setup filter
            Filter filter = RX1Filter;
            UpdateRX1Filters(-1000, 1000);

            double vfoa = VFOAFreq;
            VFOAFreq = freq;

            double vfob = VFOBFreq;
            VFOBFreq = freq;

            // setup transmit to be carrier only
            Audio.TXInputSignal = Audio.SignalSource.SILENCE;

            // default pots to force carrier to show
            Thread.Sleep(100);
            FWC.SetTRXPot(0x00FF00FF);
            Thread.Sleep(100);
            FWC.SetTRXPot(0x00FF00FF);
            Thread.Sleep(100);
            /*for(int i=1; i<4; i++)
				FWC.TRXPotSetRDAC(i, 0);*/

            // find carrier peak
            float[] a = new float[Display.BUFFER_SIZE];
            for (int i = 0; i < 5; i++)
            {

                calibration_mutex.WaitOne();
                fixed (float* ptr = &a[0])
                    DttSP.GetSpectrum(0, ptr);// get the spectrum values
                calibration_mutex.ReleaseMutex();
                Thread.Sleep(50);
            }

            // find peak bin
            int peak_bin = 2048 + (int)(0.0 / sample_rate1 * 4096.0);
            float max_signal = float.MinValue;
            float sum = 0.0f;
            int filt_low_bin = 2048 + (int)(-1000.0 / sample_rate1 * 4096.0);
            int filt_high_bin = 2048 + (int)(1000.0 / sample_rate1 * 4096.0);
            for (int i = 0; i < 20; i++)
            {
                calibration_mutex.WaitOne();
                fixed (float* ptr = &a[0])
                    DttSP.GetSpectrum(0, ptr);// get the spectrum values
                calibration_mutex.ReleaseMutex();

                if (i == 19)
                {
                    for (int j = 0; j < Display.BUFFER_SIZE; j++)
                    {
                        if (a[j] > max_signal)
                        {
                            max_signal = a[j];
                            peak_bin = j;
                        }
                    }
                }
                for (int j = filt_low_bin; j < filt_high_bin; j++)
                {
                    if (j < peak_bin - 8 || j > peak_bin + 8)
                        sum += a[j];
                }
                Thread.Sleep(100);
            }
            float noise_floor = (sum / (float)(((filt_high_bin - filt_low_bin) - 17) * 20));
            Debug.WriteLine("noise_floor: " + (noise_floor + Display.RX1DisplayCalOffset + Display.RX1PreampOffset).ToString("f1") + " peak_bin:" + peak_bin);

            //int c0_step=1, c1_step=1, c2_step=1, c3_step=1;  //old
            int c0_step = 4, c1_step = 4, c2_step = 4, c3_step = 4;  //new
            int c0_global_min = 128, c1_global_min = 128, c2_global_min = 128, c3_global_min = 128;
            int c0_index = 128, c1_index = 128, c2_index = 128, c3_index = 128;
            int c0_dir = 1, c1_dir = 1, c2_dir = 1, c3_dir = 1;
            int c0_count = 1, c1_count = 1, c2_count = 1, c3_count = 1;
            float global_min_value = float.MaxValue;
            float start = 0.0f;
            int wrong_direction_count;
            int switch_direction_count;

            if (max_signal < noise_floor + 5.0)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Carrier not found (max signal < noise floor + 5dB).  Please try again.\n" +
                        DateTime.Now.ToShortTimeString(),
                        "Carrier Not Found",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                }
                calibration_running = false;
                //progress.Text = "";

                goto end2;
            }

            for (int i = 0; i < 4; i++)
            {
                flex5000DebugForm.SetTRXPot(i, 128);
                FWC.TRXPotSetRDAC(i, 128);
            }

            float tol = 10.0f;
            bool first_time;
            // null 3 of 4 pots (leave first pot alone...pot index 0)
            bool progressing = true;
            while (progressing)
            {
                //find minimum of the peak signal over the range of C1 settings
                float min_signal = float.MaxValue;
                max_signal = float.MinValue;
                wrong_direction_count = switch_direction_count = 0;
                first_time = true;
                t2.Start();
                for (int i = c1_global_min; i >= 0 && i <= 255; i += (c1_step * c1_dir))
                {
                    flex5000DebugForm.SetTRXPot(1, (byte)i);
                    FWC.TRXPotSetRDAC(1, i);
                    Thread.Sleep(200);

                    sum = 0.0f;
                    int num_avg = (int)Math.Min(4, (1.0 / (c1_step / 8.0)));
                    for (int j = 0; j < num_avg; j++)
                    {
                        calibration_mutex.WaitOne();
                        fixed (float* ptr = &a[0])
                            DttSP.GetSpectrum(0, ptr);
                        calibration_mutex.ReleaseMutex();
                        sum += a[peak_bin];
                        if (j < num_avg - 1) Thread.Sleep(50);
                    }
                    sum /= num_avg;
                    a[peak_bin] = sum;

                    if (a[peak_bin] < min_signal)           // if carrier is less than minimum
                    {
                        min_signal = a[peak_bin];
                        c1_index = i;
                        if (min_signal < global_min_value)
                        {
                            global_min_value = a[peak_bin];
                            c1_global_min = c1_index;
                        }
                    }

                    if (first_time)
                    {
                        first_time = false;
                        start = a[peak_bin];
                        max_signal = a[peak_bin];
                    }
                    else
                    {
                        if (a[peak_bin] > max_signal && a[peak_bin] > start + 1.0)
                        {
                            max_signal = a[peak_bin];
                            wrong_direction_count++; Debug.Write("W");
                            if (wrong_direction_count > 1)
                            {
                                wrong_direction_count = 0;
                                if (++switch_direction_count > 1)
                                {
                                    // handle switched direction twice
                                    c1_step /= 2;
                                    if (c1_step < 1) c1_step = 1;
                                    c1_dir *= -1;
                                    Debug.WriteLine("c1 exit dir - c1_step:" + c1_step.ToString("f4") + "  distance:" + (global_min_value - noise_floor).ToString("f1"));
                                    break;
                                }

                                min_signal = start;
                                max_signal = start;
                                c1_dir *= -1;
                                i = c1_global_min;
                            }
                        }
                        else
                        {
                            if (min_signal > noise_floor + 20.0) tol = 3.0f;
                            else tol = 5.0f;
                            if (min_signal < start - 3.0 && a[peak_bin] > min_signal + tol)
                            {
                                c1_step /= 2;
                                if (c1_step < 1) c1_step = 1;
                                c1_dir *= -1;
                                Debug.WriteLine("c1 thresh - c1_step:" + c1_step.ToString("f4") + "  distance:" + (global_min_value - noise_floor).ToString("f1"));
                                break;
                            }
                        }
                    }

                    if (!progress.Visible) goto end;
                    else
                    {
                        t1.Stop();
                        if (t1.Duration > 120.0)
                        {
                            /*MessageBox.Show(new Form { TopMost = true }, "TX Carrier Calibration Failed.  Values have been returned to previous settings.\n"+
								DateTime.Now.ToShortTimeString(),
								"TX Carrier Failed",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);*/
                            goto end;
                        }
                        else progress.SetPercent((float)(t1.Duration / 45.0));
                    }
                }

                t2.Stop();
                c1_count++;
                Debug.WriteLine("t2 c1(" + c1_count + "): " + t2.Duration);

                flex5000DebugForm.SetTRXPot(1, (byte)c1_global_min);
                FWC.TRXPotSetRDAC(1, c1_global_min);

                if (!progressing) break;

                //find minimum of the peak signal over the range of C2 settings
                min_signal = float.MaxValue;
                max_signal = float.MinValue;
                wrong_direction_count = switch_direction_count = 0;
                first_time = true;
                t2.Start();
                for (int i = c2_global_min; i >= 0 && i <= 255; i += (c2_step * c2_dir))
                {
                    flex5000DebugForm.SetTRXPot(2, (byte)i);
                    FWC.TRXPotSetRDAC(2, i);
                    Thread.Sleep(200);

                    sum = 0.0f;
                    int num_avg = (int)Math.Max(4, (1.0 / (c2_step / 8.0)));
                    for (int j = 0; j < num_avg; j++)
                    {
                        calibration_mutex.WaitOne();
                        fixed (float* ptr = &a[0])
                            DttSP.GetSpectrum(0, ptr);
                        calibration_mutex.ReleaseMutex();
                        sum += a[peak_bin];
                        if (j < num_avg - 1) Thread.Sleep(50);
                    }
                    sum /= num_avg;
                    a[peak_bin] = sum;

                    if (a[peak_bin] < min_signal)           // if carrier is less than minimum
                    {
                        min_signal = a[peak_bin];
                        c2_index = i;
                        if (min_signal < global_min_value)
                        {
                            global_min_value = a[peak_bin];
                            c2_global_min = c2_index;
                        }
                    }

                    if (first_time)
                    {
                        first_time = false;
                        start = a[peak_bin];
                        max_signal = a[peak_bin];
                    }
                    else
                    {
                        if (a[peak_bin] > max_signal && a[peak_bin] > start + 1.0)
                        {
                            max_signal = a[peak_bin];
                            wrong_direction_count++; Debug.Write("W");
                            if (wrong_direction_count > 1)
                            {
                                wrong_direction_count = 0;
                                if (++switch_direction_count > 1)
                                {
                                    // handle switched direction twice
                                    c2_step /= 2;
                                    if (c2_step < 1) c2_step = 1;
                                    c2_dir *= -1;
                                    Debug.WriteLine("c2 exit dir - c2_step:" + c2_step.ToString("f4") + "  distance:" + (global_min_value - noise_floor).ToString("f1"));
                                    break;
                                }

                                min_signal = start;
                                max_signal = start;
                                c2_dir *= -1;
                                i = c2_global_min;
                            }
                        }
                        else
                        {
                            if (min_signal > noise_floor + 20.0) tol = 3.0f;
                            else tol = 5.0f;
                            if (min_signal < start - 3.0 && a[peak_bin] > min_signal + tol)
                            {
                                c2_step /= 2;
                                if (c2_step < 1) c2_step = 1;
                                c2_dir *= -1;
                                Debug.WriteLine("c2 thresh - c2_step:" + c2_step.ToString("f4") + "  distance:" + (global_min_value - noise_floor).ToString("f1"));
                                break;
                            }
                        }
                    }

                    if (!progress.Visible) goto end;
                    else
                    {
                        t1.Stop();
                        if (t1.Duration > 120.0)
                        {
                            /*MessageBox.Show(new Form { TopMost = true }, "TX Carrier Calibration Failed.  Values have been returned to previous settings.\n"+
								DateTime.Now.ToShortTimeString(),
								"TX Carrier Failed",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);*/
                            goto end;
                        }
                        else progress.SetPercent((float)(t1.Duration / 45.0));
                    }
                }

                t2.Stop();
                c2_count++;
                Debug.WriteLine("t2 c2(" + c2_count + "): " + t2.Duration);

                flex5000DebugForm.SetTRXPot(2, (byte)c2_global_min);
                FWC.TRXPotSetRDAC(2, c2_global_min);

                if (!progressing) break;

                //find minimum of the peak signal over the range of C3 settings
                min_signal = float.MaxValue;
                max_signal = float.MinValue;
                wrong_direction_count = switch_direction_count = 0;
                first_time = true;
                t2.Start();
                for (int i = c3_global_min; i >= 0 && i <= 255; i += (c3_step * c3_dir))
                {
                    flex5000DebugForm.SetTRXPot(3, (byte)i);
                    FWC.TRXPotSetRDAC(3, i);
                    Thread.Sleep(200);

                    sum = 0.0f;
                    int num_avg = (int)Math.Min(4, (1.0 / (c3_step / 8.0)));
                    for (int j = 0; j < num_avg; j++)
                    {
                        calibration_mutex.WaitOne();
                        fixed (float* ptr = &a[0])
                            DttSP.GetSpectrum(0, ptr);
                        calibration_mutex.ReleaseMutex();
                        sum += a[peak_bin];
                        if (j < num_avg - 1) Thread.Sleep(50);
                    }
                    sum /= num_avg;
                    a[peak_bin] = sum;

                    if (a[peak_bin] < min_signal)           // if carrier is less than minimum
                    {
                        min_signal = a[peak_bin];
                        c3_index = i;
                        if (min_signal < global_min_value)
                        {
                            global_min_value = a[peak_bin];
                            c3_global_min = c3_index;
                        }
                    }

                    if (first_time)
                    {
                        first_time = false;
                        start = a[peak_bin];
                        max_signal = a[peak_bin];
                    }
                    else
                    {
                        if (a[peak_bin] > max_signal && a[peak_bin] > start + 1.0)
                        {
                            max_signal = a[peak_bin];
                            wrong_direction_count++; Debug.Write("W");
                            if (wrong_direction_count > 1)
                            {
                                wrong_direction_count = 0;
                                if (++switch_direction_count > 1)
                                {
                                    // handle switched direction twice
                                    c3_step /= 2;
                                    if (c3_step < 1) c3_step = 1;
                                    c3_dir *= -1;
                                    Debug.WriteLine("c3 exit dir - c3_step:" + c3_step.ToString("f4") + "  distance:" + (global_min_value - noise_floor).ToString("f1"));
                                    break;
                                }

                                min_signal = start;
                                max_signal = start;
                                c3_dir *= -1;
                                i = c3_global_min;
                            }
                        }
                        else
                        {
                            if (min_signal > noise_floor + 20.0) tol = 3.0f;
                            else tol = 5.0f;
                            if (min_signal < start - 3.0 && a[peak_bin] > min_signal + tol)
                            {
                                c3_step /= 2;
                                if (c3_step < 1) c3_step = 1;
                                c3_dir *= -1;
                                Debug.WriteLine("c3 thresh - c3_step:" + c3_step.ToString("f4") + "  distance:" + (global_min_value - noise_floor).ToString("f1"));
                                break;
                            }
                        }
                    }

                    if (!progress.Visible) goto end;
                    else
                    {
                        t1.Stop();
                        if (t1.Duration > 120.0)
                        {
                            /*MessageBox.Show(new Form { TopMost = true }, "TX Carrier Calibration Failed.  Values have been returned to previous settings.\n"+
								DateTime.Now.ToShortTimeString(),
								"TX Carrier Failed",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);*/
                            goto end;
                        }
                        else progress.SetPercent((float)(t1.Duration / 45.0));
                    }
                }

                t2.Stop();
                c3_count++;
                Debug.WriteLine("t2 c3(" + c3_count + "): " + t2.Duration);

                flex5000DebugForm.SetTRXPot(3, (byte)c3_global_min);
                FWC.TRXPotSetRDAC(3, c3_global_min);

                if (!progressing) break;

                //find minimum of the peak signal over the range of C1 settings
                min_signal = float.MaxValue;
                max_signal = float.MinValue;
                wrong_direction_count = switch_direction_count = 0;
                first_time = true;
                t2.Start();
                for (int i = c0_global_min; i >= 0 && i <= 255; i += (c0_step * c0_dir))
                {
                    flex5000DebugForm.SetTRXPot(0, (byte)i);
                    FWC.TRXPotSetRDAC(0, i);
                    Thread.Sleep(200);

                    sum = 0.0f;
                    int num_avg = (int)Math.Min(4, (1.0 / (c0_step / 8.0)));
                    for (int j = 0; j < num_avg; j++)
                    {
                        calibration_mutex.WaitOne();
                        fixed (float* ptr = &a[0])
                            DttSP.GetSpectrum(0, ptr);
                        calibration_mutex.ReleaseMutex();
                        sum += a[peak_bin];
                        if (j < num_avg - 1) Thread.Sleep(50);
                    }
                    sum /= num_avg;
                    a[peak_bin] = sum;

                    if (a[peak_bin] < min_signal)           // if carrier is less than minimum
                    {
                        min_signal = a[peak_bin];
                        c0_index = i;
                        if (min_signal < global_min_value)
                        {
                            global_min_value = a[peak_bin];
                            c0_global_min = c0_index;
                        }
                    }

                    if (first_time)
                    {
                        first_time = false;
                        start = a[peak_bin];
                        max_signal = a[peak_bin];
                    }
                    else
                    {
                        if (a[peak_bin] > max_signal && a[peak_bin] > start + 1.0)
                        {
                            max_signal = a[peak_bin];
                            wrong_direction_count++; Debug.Write("W");
                            if (wrong_direction_count > 1)
                            {
                                wrong_direction_count = 0;
                                if (++switch_direction_count > 1)
                                {
                                    // handle switched direction twice
                                    c0_step /= 2;
                                    if (c0_step < 1) c0_step = 1;
                                    c0_dir *= -1;
                                    Debug.WriteLine("c0 exit dir - c0_step:" + c0_step.ToString("f4") + "  distance:" + (global_min_value - noise_floor).ToString("f1"));
                                    break;
                                }

                                min_signal = start;
                                max_signal = start;
                                c0_dir *= -1;
                                i = c0_global_min;
                            }
                        }
                        else
                        {
                            if (min_signal > noise_floor + 20.0) tol = 3.0f;
                            else tol = 5.0f;
                            if (min_signal < start - 3.0 && a[peak_bin] > min_signal + tol)
                            {
                                c0_step /= 2;
                                if (c0_step < 1) c0_step = 1;
                                c0_dir *= -1;
                                Debug.WriteLine("c0 thresh - c0_step:" + c0_step.ToString("f4") + "  distance:" + (global_min_value - noise_floor).ToString("f1"));
                                break;
                            }
                        }
                    }

                    if (!progress.Visible) goto end;
                    else
                    {
                        t1.Stop();
                        if (t1.Duration > 120.0)
                        {
                            /*MessageBox.Show(new Form { TopMost = true }, "TX Carrier Calibration Failed.  Values have been returned to previous settings.\n"+
								DateTime.Now.ToShortTimeString(),
								"TX Carrier Failed",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);*/
                            goto end;
                        }
                        else progress.SetPercent((float)(t1.Duration / 45.0));
                    }
                }

                t2.Stop();
                c0_count++;
                Debug.WriteLine("t2 c0(" + c0_count + "): " + t2.Duration);

                flex5000DebugForm.SetTRXPot(0, (byte)c0_global_min);
                FWC.TRXPotSetRDAC(0, c0_global_min);

                if (!progressing) break;

                //if(c0_count > 2 && c1_count > 2 && c2_count > 2 && c3_count > 2)//old
                if (c0_count > 4 && c1_count > 4 && c2_count > 4 && c3_count > 4)//new
                    progressing = false;
            }
            ret_val = true;
            Debug.WriteLine("Carrier Null: [" + c0_global_min + ", " + c1_global_min + ", " + c2_global_min + ", " + c3_global_min + "]");

        end:
            if (!progress.Visible) progress.Text = "";
            else
            {
                /*flex5000DebugForm.SetTRXPot(0, (byte)c0_global_min);
                flex5000DebugForm.SetTRXPot(1, (byte)c1_global_min);
                flex5000DebugForm.SetTRXPot(2, (byte)c2_global_min);
                flex5000DebugForm.SetTRXPot(3, (byte)c3_global_min);*/

                uint val = (uint)((c0_global_min & 0xFF) << 24 |
                    (c1_global_min & 0xFF) << 16 |
                    (c2_global_min & 0xFF) << 8 |
                    (c3_global_min & 0xFF) << 0);

                FWC.SetTRXPot(val);

                double f = 0.0;
                if (tx_xvtr_index < 0)
                    f = Math.Round(freq, 3);
                else
                    f = Math.Round(xvtrForm.TranslateFreq(freq), 3);

                double f2 = 0.0;
                FindNearestKey<uint>(f, tx_carrier_cal, out f2);
                if (Math.Abs(f2 - f) < 0.001)
                    f = f2;

                tx_carrier_cal[f] = val;
            }
        end2:
            progress.Hide();
            // return output tone
            Audio.TXInputSignal = Audio.SignalSource.RADIO;

            tx_carrier_min = global_min_value + Display.RX1DisplayCalOffset + Display.RX1PreampOffset;
            min_tx_carrier[(int)tx_band] = global_min_value + Display.RX1DisplayCalOffset + Display.RX1PreampOffset;

            // return hardware to normal operation
            //Thread.Sleep(50);
            FWC.SetQSD(true);
            //Thread.Sleep(50);
            FWC.SetQSE(false);
            //Thread.Sleep(50);
            FWC.SetTR(false);
            //Thread.Sleep(50);
            FWC.SetSig(false);
            //Thread.Sleep(50);
            FWC.SetGen(false);
            //Thread.Sleep(50);
            FWC.SetTest(false);
            //Thread.Sleep(50);
            FWC.SetTXMon(false);
            //Thread.Sleep(50);
            FWC.SetPDrvMon(false);
            //Thread.Sleep(50);

            if (current_model == Model.FLEX3000)
                FWC.SetFan(false);

            setupForm.Polyphase = polyphase;
            setupForm.DSPPhoneRXBuffer = dsp_buf_size;
            chkSR.Checked = spur_red;
            FullDuplex = duplex;

            VFOAFreq = vfoa;
            VFOBFreq = vfob;

            comboDisplayMode.Text = display;

            RX1DSPMode = dsp_mode;
            RX1Filter = filter;
            RX1PreampMode = preamp;

            chkRX2.Checked = rx2_on;

            calibration_running = false;
            return ret_val;
        }

        public void CallCalSigGen()
        {
            p = new Progress("Calibrate Signal Generator");
            Thread t = new Thread(new ThreadStart(CalSigGen));
            t.Name = "Calibrate Signal Generator Thread";
            t.IsBackground = true;
            t.Priority = ThreadPriority.Normal;
            t.Start();
            p.Show();
        }

        private void CalSigGen()
        {
            if (!(fwc_init && current_model == Model.FLEX5000))
            {
                p.Hide();
                return;
            }

            double low = 1.0;
            double high = 65.0;
            double step = 0.1;
            int num_steps = (int)((high - low) / step);
            int count = 0;
            StreamWriter sw = new StreamWriter(app_data_path + "sig_gen.csv"); // "\\sig_gen.csv"

            FullDuplex = true;
            FWC.SetSig(true);
            FWC.SetGen(true);
            FWC.SetTest(true);
            RX1DSPMode = DSPMode.USB;
            RX1Filter = Filter.VAR2;
            UpdateRX1Filters(480, 520);

            for (double i = low; i <= high; i += step)
            {
                VFOAFreq = i;
                //Thread.Sleep(20);
                VFOBFreq = i + 0.0005;
                Thread.Sleep(200);
                float sum = 0.0f;
                for (int j = 0; j < 10; j++)
                {
                    sum += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                    sum = sum +
                        rx1_meter_cal_offset +
                        rx1_preamp_offset[(int)rx1_preamp_mode] +
                        rx1_filter_size_cal_offset;
                    Thread.Sleep(50);
                }
                sum /= 10;

                sw.WriteLine(i.ToString("f6") + "," + sum.ToString("f3"));
                p.SetPercent(count++ / (float)num_steps);
                if (!p.Visible) break;
            }
            sw.Close();
            FWC.SetSig(false);
            FWC.SetGen(false);
            FWC.SetTest(false);
            p.Hide();
        }


        //====================================================================================
        // ke9ns  setup->general->calibration->freq cal->START (comes here as a thread in setup.cs)
        public bool CalibrateFreq(float freq, Progress progress, bool suppress_errors)
        {
            bool retval = false;

            calibration_running = true;

            if (!chkPower.Checked)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Power must be on in order to calibrate Frequency.", "Power Is Off",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                }
                calibration_running = false;
                return false;
            }
            string Lastcombo = comboDisplayMode.Text;

            comboDisplayMode.Text = "Spectrum";
            comboDisplayMode_SelectedIndexChanged(this, EventArgs.Empty);  // .201


            string vfo_freq_text = txtVFOAFreq.Text;		// save current frequency

            bool polyphase = setupForm.Polyphase;			// save current polyphase setting
            setupForm.Polyphase = false;					// disable polyphase

            int dsp_buf_size = setupForm.DSPPhoneRXBuffer;	// save current DSP buffer size
            setupForm.DSPPhoneRXBuffer = 4096;				// set DSP Buffer Size to 4096

            Filter filter = RX1Filter;						// save current filter

            DSPMode dsp_mode = rx1_dsp_mode;				// save current demod mode
            RX1DSPMode = DSPMode.SAM;						// set DSP to AM

            bool rit_on = chkRIT.Checked;					// save current RIT state
            chkRIT.Checked = false;							// set RIT to Off

            int rit_value = (int)udRIT.Value;				// save current RIT value
            udRIT.Value = 0;								// set RIT Value to 0

            Filter am_filter = RX1Filter;					// save am filter
            //RX1Filter = Filter.F5;						// set filter to 6600Hz
            RX1Filter = Filter.F10;							// set filter to 2400Hz

            VFOAFreq = freq;								// set frequency to passed value (in mhz  10.000000)

            progress.SetPercent(0.0f);

            double old_clock = FWCDDSClockCorrection;
            setupForm.ClockOffset = 0;
            FWCDDSClockCorrection = 0;

            Thread.Sleep(200);
            //int ret = 0;


            //------------------------------------------------------------
            // ke9ns: First find the peak carrier signal (in case your offset is way off) based on the peak signal spot in the spectrum, this will get you in the ballpark, then use DSP PLL to find the real offset freq (lock onto the carrier)

            float[] buf = new float[Display.BUFFER_SIZE];
            float[] sum = new float[Display.BUFFER_SIZE];

            for (int i = 0; i < 10; i++)
            {
                calibration_mutex.WaitOne();

                fixed (float* ptr = &buf[0])            // ke9ns: (fixed) prevent garbage collecion from moving this pointer data
                {
                    DttSP.GetSpectrum(0, ptr);      // get the spectrum values and dump in buf[]
                   
                }

                for (int j = 0; j < Display.BUFFER_SIZE; j++) // sum up 10 lines of spectrum data (4096 points each line or 16384 if using hi-res option)
                {
                    sum[j] += buf[j];
                }

                calibration_mutex.ReleaseMutex();

                Thread.Sleep(50);
            }

            float max = float.MinValue;

            int max_index = 0;

            for (int i = 0; i < Display.BUFFER_SIZE; i++)						// find the maximum signal
            {

                if (sum[i] > max)
                {
                    max = sum[i]; // ke9ns: find index of the highest signal found
                    max_index = i;
                }
            }

            /*avg -= max;
            avg /= (high - low - 1);

            if(max < (avg + 30))
            {
                MessageBox.Show(new Form { TopMost = true }, "Peak is less than 30dB from the noise floor.  " +
                    "Please use a larger signal for frequency calibration.",
                    "Calibration Error - Weak Signal",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                retval = false;
                goto end;
            }*/


            // Calculate the difference between the known signal and the measured signal
            float diff = (float)((double)sample_rate1 / Display.BUFFER_SIZE * (Display.BUFFER_SIZE / 2 - max_index)); // sample_rate1 is your current SR (ie. 192k, 96k, 48k)

            Debug.WriteLine("SR: " + sample_rate1 + " , " + Display.BUFFER_SIZE + " , " + max_index + " , " + diff);

            // Calculate the DDS offset
            int offset = 0;
            switch (current_model)
            {
                case Model.FLEX5000:
                    offset = (int)(500.0 / freq * diff);
                 
                    break;
                case Model.FLEX3000:
                    offset = (int)(499.201 / freq * diff);
                    break;
                case Model.FLEX1500:
                    if (flex_1500_xref)
                        offset = (int)(400.0 / freq * diff);
                    else offset = (int)(384.0 / freq * diff);
                    break;
                default:
                    offset = (int)(200.0 / freq * diff);
                    break;
            }

            Debug.WriteLine("offset1: " + offset + " , freq: " + freq + " , diff: "+ diff); // course offset

            if (Math.Abs(offset) > 40000)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Peak is outside valid range.",
                        "Calibration Error - Range",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                }
                retval = false;
                goto end;
            }

            if (Math.Abs(offset) > 20000)
            {
                if (!suppress_errors)
                {
                    DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "This value is outside the specifications of the oscillator.",
                        "Outside Specifications",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                }
                retval = false;
                goto end;
            }

            setupForm.ClockOffset = offset;				// Offset the clock based on the difference. ke9ns: This will get you in the ballpark in case your offset was way off. Use PLL routine below to lock onto carrier
            Thread.Sleep(200);


            //--------------------------------------------------------------------------------------------------
            // ke9ns: SECOND   Narrow up the software PLL (am_demod.c) to allow the PLL to lock onto the carrier used to calibrate freq

            float a, b;
            DttSP.GetSAMPLLvals(0, 0, &a, &b);     // ke9ns: save original a and b values to put back after you getfreq


            Debug.WriteLine("before CalibrateFreq a=alpha, b=beta " + a + " , " + b + ", freq: " + freq); // ke9ns: 0.002945243 , 2.168614E-06 (FOR FLEX-5000)
            // ke9ns: alpha = PLL Bandwidth, beta=2nd order alpha term

            float a1 = a * 0.10f;               // ke9ns: take 10% of original value  0.0002945243  (i.e. shift 1 decimal point smaller) NARROW up the PLL BANDWIDTH
            float b1 = 0.25f * a1 * a1;         // ke9ns: take 25% of new a^2 value   2.168614e-8  (i.e. 0.0000000216) 2nd order term is always (alpha^2)*.25

            DttSP.SetSAMPLLvals(0, 0, a1, b1);     // ke9ns: Narrow up PLL Loop filter constants: to get better accuracy

            Debug.WriteLine("after CalibrateFreq alpha, beta " + a1 + " , " + b1);


            Thread.Sleep(200);

            int counter = 0;
            int samples = 200; // 200 samples to allow time to find a PLL Lock on carrier (or should I say, to find how far from a LOCK we are (offset)
            float sum1 = 0.0f;

            for (int i = 0; i < samples; i++)                     // ke9ns loop 200 times
            {
                float temp;

                DttSP.GetSAMFreq(0, 0, &temp);                   // ke9ns: update.c & am_demod.c PLL routine returns a frequency where a LOCK would occur (offset for the CLOCK). The smaller the freq, the closer to PLL LOCK
                                                                 // temp = rx[thread][subrx].am.gen -> pll.freq.f;    static void pll (AMD am, COMPLEX sig)

                Debug.WriteLine("CalibrateFreq temp " + i + " , " + temp);

                sum1 += temp;
                Thread.Sleep(50);
                progress.SetPercent((float)((float)++counter / samples));
            }

            Debug.WriteLine("CalibrateFreq sum1 " + sum1);

            diff = -(float)((sum1 / samples) * sample_rate1 / (2 * Math.PI));  //ke9ns: - getSAMFreq * 192k / 6.28 = (for close LOCK signal) = - -.0000648 * 192000 / 6.28 = 1.98
                                                                               // 2PI = 1 full phase rotation


            DttSP.SetSAMPLLvals(0, 0, a, b);                    // reset PLL values back when done (keep the PLL Loop filter widers for use with SAM syncronous carrier detection lock

            // Calculate the DDS offset
            offset = 0;
            switch (current_model)
            {
                case Model.FLEX5000:
                    offset = (int)(500.0 / freq * diff); // ke9ns: 500/10 * -1.98 = -99         (500/MHZ) * ((getSAMFreq * 192000) /  6.28)
                    break;
                case Model.FLEX3000:
                    offset = (int)(499.201 / freq * diff);
                    break;
                case Model.FLEX1500:
                    if (flex_1500_xref)
                        offset = (int)(400.0 / freq * diff);
                    else offset = (int)(384.0 / freq * diff);
                    break;
                default:
                    offset = (int)(200.0 / freq * diff);
                    break;
            }

            Debug.WriteLine("  offset2: " + offset);

            int current_clock = setupForm.ClockOffset;

            if (Math.Abs(current_clock + offset) > 40000 || Math.Abs(current_clock - offset) > 40000)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Peak is outside valid range.",
                        "Calibration Error - Range",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                }
                retval = false;
                goto end;
            }

            if (Math.Abs(current_clock + offset) > 20000 || Math.Abs(current_clock - offset) > 20000)
            {
                if (!suppress_errors)
                {
                    DialogResult dr = MessageBox.Show(new Form { TopMost = true }, "This value is outside the specifications of the oscillator.",
                        "Outside Specifications",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                }
                retval = false;
                goto end;
            }

            setupForm.ClockOffset += offset;				// Offset the clock based on the difference            
            retval = true;

        //----------------------------------------------------------

        end:

            comboDisplayMode.Text = Lastcombo;
           comboDisplayMode_SelectedIndexChanged(this, EventArgs.Empty);  // .201

            //SetupForm.RXOnly = rx_only;					// restore RX Only setting
            RX1Filter = am_filter;							// restore AM filter
            RX1DSPMode = dsp_mode;							// restore DSP mode
            RX1Filter = filter;								// restore filter
            chkRIT.Checked = rit_on;						// restore RIT state
            RITValue = rit_value;							// restore RIT value
            VFOAFreq = double.Parse(vfo_freq_text);			// restore frequency ke9ns was float
            setupForm.DSPPhoneRXBuffer = dsp_buf_size;		// restore DSP buffer size
            setupForm.Polyphase = polyphase;				// restore polyphase
            calibration_running = false;
            progress.Hide();
            return retval;

        } //CalibrateFreq




        public bool CalibrateLevel(float level, float freq, Progress progress, bool suppress_errors)
        {
            // Calibration routine called by Setup Form.
            bool ret_val = false;
            calibration_running = true;
            if (!chkPower.Checked)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Power must be on in order to calibrate RX Level.", "Power Is Off",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                }
                calibration_running = false;
                return false;
            }
            float[] a = new float[Display.BUFFER_SIZE];
            switch (current_model)
            {
                case Model.SDR1000:
                case Model.DEMO:
                case Model.SOFTROCK40:
                    //bool rx_only = SetupForm.RXOnly;					// Save RX Only Setting
                    //SetupForm.RXOnly = true;

                    double vfoa = VFOAFreq;								// save current VFOA

                    bool rit_on = chkRIT.Checked;						// save current RIT On
                    chkRIT.Checked = false;								// turn RIT off
                    int rit_val = (int)udRIT.Value;	    				// save current RIT value

                    string display = comboDisplayMode.Text;
                    comboDisplayMode.Text = "Spectrum";

                    bool polyphase = setupForm.Polyphase;				// save current polyphase setting
                    setupForm.Polyphase = false;						// disable polyphase

                    int dsp_buf_size = setupForm.DSPPhoneRXBuffer;		// save current DSP buffer size
                    setupForm.DSPPhoneRXBuffer = 4096;					// set DSP Buffer Size to 2048

                    Filter filter = RX1Filter;							// save current filter

                    DSPMode dsp_mode = rx1_dsp_mode;					// save current DSP demod mode
                    RX1DSPMode = DSPMode.AM;							// set mode to CWU

                    VFOAFreq = freq;									// set VFOA frequency

                    Filter am_filter = RX1Filter;						// save current AM filter
                    RX1Filter = Filter.F1;								// set filter to 500Hz

                    PreampMode preamp = RX1PreampMode;					// save current preamp mode
                    RX1PreampMode = PreampMode.HIGH;					// set to high

                    MeterRXMode rx_meter = CurrentMeterRXMode;			// save current RX Meter mode
                    CurrentMeterRXMode = MeterRXMode.OFF;				// turn RX Meter off

                    bool display_avg = chkDisplayAVG.Checked;			// save current average state
                    chkDisplayAVG.Checked = false;
                    chkDisplayAVG.Checked = true;						// set average state to off

                    float old_multimeter_cal = rx1_meter_cal_offset;
                    float old_display_cal = rx1_display_cal_offset;

                    comboPreamp.Enabled = false;
                    comboDisplayMode.Enabled = false;
                    comboMeterRXMode.Enabled = false;

                    progress.SetPercent(0.0f);
                    int counter = 0;

                    Thread.Sleep(2000);
                    btnZeroBeat_Click(this, EventArgs.Empty);
                    RX1Filter = Filter.F6;
                    chkDisplayAVG.Checked = false;
                    Thread.Sleep(200);

                    DisableAllFilters();
                    DisableAllModes();
                    VFOLock = true;

                    calibration_mutex.WaitOne();

                    fixed (float* ptr = &a[0])
                        DttSP.GetSpectrum(0, ptr);		// get the spectrum values
                    calibration_mutex.ReleaseMutex();
                    float max = float.MinValue;
                    float avg = 0;
                    int max_index = 0;

                    for (int i = 0; i < 4095; i++)						// find the maximum signal
                    {
                        avg += a[i];
                        if (a[i] > max)
                        {
                            max = a[i];
                            max_index = i;
                        }
                    }
                    avg -= max;
                    avg /= 4095;

                   /* if (max < (avg + 30))
                    {
                        if (!suppress_errors)
                        {
                            MessageBox.Show(new Form { TopMost = true }, "Peak is less than 30dB from the noise floor.  " +
                                "Please use a larger signal for frequency calibration.",
                                "Calibration Error - Weak Signal",
                                MessageBoxButtons.OK,
                                MessageBoxIcon.Error);
                        }
                        ret_val = false;
                        goto end;
                    } */

                    rx1_meter_cal_offset = 0.0f;
                    rx1_display_cal_offset = 0.0f;
                    float num = 0.0f, num2 = 0.0f, avg2 = 0.0f;
                    avg = 0.0f;
                    // get the value of the signal strength meter
                    for (int i = 0; i < 50; i++)
                    {
                        num += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg = num / 50.0f;

                    RX1PreampMode = PreampMode.MED;
                    Thread.Sleep(100);

                    // get the value of the signal strength meter
                    num2 = 0.0f;
                    for (int i = 0; i < 50; i++)
                    {
                        num2 += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg2 = num2 / 50.0f;

                    float att_offset = avg2 - avg;

                    RX1PreampMode = PreampMode.LOW;
                    Thread.Sleep(100);

                    // get the value of the signal strength meter
                    num2 = 0.0f;
                    for (int i = 0; i < 50; i++)
                    {
                        num2 += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg2 = num2 / 50.0f;

                    float gain_offset = avg2 - avg;

                    rx1_preamp_offset[(int)PreampMode.OFF] = -gain_offset - att_offset;
                    rx1_preamp_offset[(int)PreampMode.LOW] = -gain_offset;
                    rx1_preamp_offset[(int)PreampMode.MED] = -att_offset;
                    rx1_preamp_offset[(int)PreampMode.HIGH] = 0.0f;

                    RX1PreampMode = PreampMode.HIGH;
                    Thread.Sleep(100);

                    num2 = 0.0f;
                    for (int i = 0; i < 20; i++)
                    {
                        calibration_mutex.WaitOne();
                        fixed (float* ptr = &a[0])
                            DttSP.GetSpectrum(0, ptr);		// read again to clear out changed DSP
                        calibration_mutex.ReleaseMutex();
                        max = float.MinValue;						// find the max spectrum value
                        for (int j = 0; j < Display.BUFFER_SIZE; j++)
                            if (a[j] > max) max = a[j];

                        num2 += max;

                        Thread.Sleep(100);

                        if (!progress.Visible)
                            goto end;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg2 = num2 / 20.0f;

                    // calculate the difference between the current value and the correct multimeter value
                    float diff = level - (avg + rx1_meter_cal_offset + rx1_preamp_offset[(int)rx1_preamp_mode]);
                    rx1_meter_cal_offset += diff;

                    // calculate the difference between the current value and the correct spectrum value
                    diff = level - (avg2 + rx1_display_cal_offset + rx1_preamp_offset[(int)rx1_preamp_mode]);
                    for (int i = 0; i < (int)Band.LAST; i++)
                    {
                        rx1_level_table[i][0] = (float)Math.Round(diff, 3);
                        //rx1_level_table[i][1] = rx1_preamp_offset((int)PreampMode.MED
                        rx1_level_table[i][2] = (float)Math.Round(rx1_meter_cal_offset, 3);
                    }
                    RX1DisplayCalOffset += diff;

                    ret_val = true;

                end:
                    if (!progress.Visible) progress.Text = "";
                    progress.Hide();
                    EnableAllFilters();
                    EnableAllModes();
                    VFOLock = false;
                    comboPreamp.Enabled = true;
                    comboDisplayMode.Enabled = true;
                    comboMeterRXMode.Enabled = true;

                    if (ret_val == false)
                    {
                        rx1_meter_cal_offset = old_multimeter_cal;
                        rx1_display_cal_offset = old_display_cal;
                    }

                    comboDisplayMode.Text = display;
                    chkRIT.Checked = rit_on;							// restore RIT on
                    udRIT.Value = rit_val;								// restore RIT value
                    //SetupForm.RXOnly = rx_only;						// restore RX Only			
                    DisplayAVG = display_avg;							// restore AVG value
                    //RX1PreampMode = preamp;						// restore preamp value
                    RX1Filter = am_filter;							// restore AM filter
                    RX1DSPMode = dsp_mode;							// restore DSP mode
                    RX1Filter = filter;								// restore filter
                    if (dsp_buf_size != 4096)
                        chkPower.Checked = false;						// go to standby
                    setupForm.DSPPhoneRXBuffer = dsp_buf_size;				// restore DSP Buffer Size
                    VFOAFreq = vfoa;									// restore vfo frequency
                    if (dsp_buf_size != 4096)
                    {
                        Thread.Sleep(100);
                        chkPower.Checked = true;
                    }
                    CurrentMeterRXMode = rx_meter;						// restore RX Meter mode
                    setupForm.Polyphase = polyphase;					// restore polyphase

                    //			Debug.WriteLine("rx1_meter_cal_offset: "+rx1_meter_cal_offset);
                    //			Debug.WriteLine("display_cal_offset: "+display_cal_offset);
                    //			MessageBox.Show(new Form { TopMost = true }, "rx1_meter_cal_offset: "+rx1_meter_cal_offset.ToString()+"\n"+
                    //				"display_cal_offset: "+display_cal_offset.ToString());
                    break;
                #region SDRX
                /*case Model.SDRX:
			
						if(!fwc_init) return false;
						rx_only = SetupForm.RXOnly;					// Save RX Only Setting
						SetupForm.RXOnly = true;

						rit_on = chkRIT.Checked;						// save current RIT On
						chkRIT.Checked = false;								// turn RIT off
						rit_val = (int)udRIT.Value;						// save current RIT value

						vfoa = VFOAFreq;								// save current VFOA

						polyphase = SetupForm.Polyphase;				// save current polyphase setting
						SetupForm.Polyphase = false;						// disable polyphase

						dsp_buf_size = SetupForm.DSPBufferSize;			// save current DSP buffer size
						SetupForm.DSPBufferSize = 4096;						// set DSP Buffer Size to 2048

						filter = RX1Filter;						// save current filter

						dsp_mode = current_dsp_mode;				// save current DSP demod mode
						CurrentDSPMode = DSPMode.AM;						// set mode to AM

						VFOAFreq = freq;									// set VFOA frequency
				
						am_filter = RX1Filter;					// save current AM filter
						RX1Filter = Filter.F1;							// set filter to 500Hz

						bool fwc_preamp = fwc_preamp_on;						// save current preamp mode
						FWCPreampOn = false;								// turn preamp off

						bool att_on = fwc_att_on;							// save current atten on
						FWCATTOn = false;									// turn atten off

						int att_val = fwc_att_val;							// save current atten val
						FWCATTVal = 0;										// set atten val to 0dB

						rx_meter = CurrentMeterRXMode;			// save current RX Meter mode
						CurrentMeterRXMode = MeterRXMode.OFF;				// turn RX Meter off

						display_avg = chkDisplayAVG.Checked;			// save current average state
						chkDisplayAVG.Checked = false;
						chkDisplayAVG.Checked = true;						// set average state to off

						old_multimeter_cal = rx1_meter_cal_offset;
						old_display_cal = display_cal_offset;

						comboPreamp.Enabled = false;
						comboDisplayMode.Enabled = false;
						comboMeterRXMode.Enabled = false;

						progress.SetPercent(0.0f);
						counter = 0;

						Thread.Sleep(2000);
						btnZeroBeat_Click(this, EventArgs.Empty);
						RX1Filter = Filter.F6;
						chkDisplayAVG.Checked = false;
						Thread.Sleep(200);

						DisableAllFilters();
						DisableAllModes();
						VFOLock = true;

						fixed(float* ptr = &a[0])
							DttSP.GetSpectrum(0, ptr);		// get the spectrum values

						max = float.MinValue;
						avg = 0;
						max_index = 0;

						for(int i=0; i<4095; i++)						// find the maximum signal
						{
							avg += a[i];
							if(a[i] > max)
							{
								max = a[i];
								max_index = i;
							}
						}
						avg -= max;
						avg /= 4095;

						if(max < (avg + 30))
						{
							MessageBox.Show(new Form { TopMost = true }, "Peak is less than 30dB from the noise floor.  " +
								"Please use a larger signal for frequency calibration.",
								"Calibration Error - Weak Signal",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);
							ret_val = false;
							goto end;
						}

						rx1_meter_cal_offset = 0.0f;
						DisplayCalOffset = 0.0f;
						num=0.0f; num2=0.0f; avg2=0.0f;
						avg=0.0f;
						// get the value of the signal strength meter
						for(int i=0; i<50; i++)
						{
							num += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
							Thread.Sleep(50);
							if(!progress.Visible)
								goto end;
							else progress.SetPercent((float)((float)++counter/760));
						}
						avg = num / 50.0f;

						FWCPreampOn = true;
						Thread.Sleep(100);
									
						// get the value of the signal strength meter
						num2=0.0f;
						for(int i=0; i<50; i++)
						{
							num2 += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
							Thread.Sleep(50);
							if(!progress.Visible)
								goto end3;
							else progress.SetPercent((float)((float)++counter/760));
						}
						avg2 = num2 / 50.0f;

						fwc_preamp_offset = avg2 - avg;

						FWCPreampOn = false;
						FWCATTOn = true;
						for(int j=0; j<32; j++)
						{
							FWCATTVal = j;
							Thread.Sleep(100);

							// get the value of the signal strength meter
							num2=0.0f;
							for(int i=0; i<20; i++)
							{
								num2 += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
								Thread.Sleep(50);
								if(!progress.Visible)
									goto end3;
								else progress.SetPercent((float)((float)++counter/760));
							}
							avg2 = num2 / 20.0f;
							fwc_att_offset[j] = avg2 - avg;
						}
						FWCATTOn = false;

						num2 = 0.0f;
						for(int i=0; i<20; i++)
						{
							fixed(float* ptr = &a[0])
								DttSP.GetSpectrum(0, ptr);		// read again to clear out changed DSP

							max = float.MinValue;						// find the max spectrum value
							for(int j=0; j<Display.BUFFER_SIZE; j++)
								if(a[j] > max) max = a[j];

							num2 += max;

							Thread.Sleep(100);

							if(!progress.Visible)
								goto end3;
							else progress.SetPercent((float)((float)++counter/760));
						}
						avg2 = num2 / 20.0f;

						// calculate the difference between the current value and the correct multimeter value
						diff = level - (avg + rx1_meter_cal_offset);
						rx1_meter_cal_offset = diff;

						// calculate the difference between the current value and the correct spectrum value
						diff = level - (avg2 + DisplayCalOffset);
						DisplayCalOffset = diff - 1.6f;

						UpdateDisplayOffset();

						ret_val = true;

					end3:
						progress.Hide();
						EnableAllFilters();
						EnableAllModes();
						VFOLock = false;
						comboPreamp.Enabled = true;
						comboDisplayMode.Enabled = true;
						comboMeterRXMode.Enabled = true;

						if(ret_val == false)
						{
							rx1_meter_cal_offset = old_multimeter_cal;
							display_cal_offset = old_display_cal;
						}

						chkRIT.Checked = rit_on;							// restore RIT on
						udRIT.Value = rit_val;								// restore RIT value
						SetupForm.RXOnly = rx_only;							// restore RX Only			
						DisplayAVG = display_avg;							// restore AVG value
						FWCPreampOn = fwc_preamp;							// restore preamp value
						FWCATTOn = att_on;									// restore ATT on
						FWCATTVal = att_val;								// restore ATT val
						RX1Filter = am_filter;							// restore AM filter
						CurrentDSPMode = dsp_mode;							// restore DSP mode
						RX1Filter = filter;								// restore filter
						if(dsp_buf_size != 4096)
							chkPower.Checked = false;						// go to standby
						SetupForm.DSPBufferSize = dsp_buf_size;				// restore DSP Buffer Size
						VFOAFreq = vfoa;									// restore vfo frequency
						if(dsp_buf_size != 4096)
						{
							Thread.Sleep(100);
							chkPower.Checked = true;
						}
						CurrentMeterRXMode = rx_meter;						// restore RX Meter mode
						SetupForm.Polyphase = polyphase;					// restore polyphase

						//			Debug.WriteLine("rx1_meter_cal_offset: "+rx1_meter_cal_offset);
						//			Debug.WriteLine("display_cal_offset: "+display_cal_offset);
						//			MessageBox.Show(new Form { TopMost = true }, "rx1_meter_cal_offset: "+rx1_meter_cal_offset.ToString()+"\n"+
						//				"display_cal_offset: "+display_cal_offset.ToString());
						break;*/
                #endregion
                case Model.FLEX5000:
                    //rx_only = SetupForm.RXOnly;						// Save RX Only Setting
                    //SetupForm.RXOnly = true;

                    bool rx2 = rx2_enabled;
                    RX2Enabled = false;

                    vfoa = VFOAFreq;									// save current VFOA

                    rit_on = chkRIT.Checked;							// save current RIT On
                    chkRIT.Checked = false;								// turn RIT off
                    rit_val = (int)udRIT.Value;							// save current RIT value					

                    display = comboDisplayMode.Text;
                    comboDisplayMode.Text = "Spectrum";

                    polyphase = setupForm.Polyphase;					// save current polyphase setting
                    setupForm.Polyphase = false;						// disable polyphase

                    dsp_buf_size = setupForm.DSPPhoneRXBuffer;			// save current DSP buffer size
                    setupForm.DSPPhoneRXBuffer = 4096;					// set DSP Buffer Size to 2048

                    filter = RX1Filter;									// save current filter

                    preamp = rx1_preamp_mode;

                    dsp_mode = rx1_dsp_mode;							// save current DSP demod mode
                    RX1DSPMode = DSPMode.DSB;							// set mode to DSB

                    VFOAFreq = freq;									// set VFOA frequency
                    VFOBFreq = freq;

                    bool duplex = full_duplex;
                    FullDuplex = true;
                    Thread.Sleep(50);
                    FWC.SetGen(true);
                    Thread.Sleep(50);
                    FWC.SetTest(true);
                    Thread.Sleep(50);
                    FWC.SetSig(true);
                    Thread.Sleep(50);

                    am_filter = RX1Filter;								// save current AM filter
                    RX1Filter = Filter.F1;								// set filter to 500Hz

                    /*bool p_amp = chkRX1Preamp.Checked;					// save current preamp mode
                    chkRX1Preamp.Checked = false;						// turn preamp off*/

                    rx_meter = CurrentMeterRXMode;						// save current RX Meter mode
                    CurrentMeterRXMode = MeterRXMode.OFF;				// turn RX Meter off

                    display_avg = chkDisplayAVG.Checked;				// save current average state
                    chkDisplayAVG.Checked = false;
                    chkDisplayAVG.Checked = true;						// set average state to off

                    old_multimeter_cal = rx1_meter_cal_offset;
                    old_display_cal = rx1_display_cal_offset;

                    chkRX1Preamp.Enabled = false;
                    comboDisplayMode.Enabled = false;
                    comboMeterRXMode.Enabled = false;

                    progress.SetPercent(0.0f);
                    counter = 0;

                    RX1Filter = Filter.F6;
                    chkDisplayAVG.Checked = false;

                    FWC.SetTRXPreamp(false);
                    Thread.Sleep(200);

                    DisableAllFilters();
                    DisableAllModes();
                    VFOLock = true;

                    calibration_mutex.WaitOne();
                    fixed (float* ptr = &a[0])
                        DttSP.GetSpectrum(0, ptr);		// get the spectrum values
                    calibration_mutex.ReleaseMutex();

                    max = float.MinValue;
                    avg = 0;
                    max_index = 0;

                    for (int i = 0; i < 4095; i++)						// find the maximum signal
                    {
                        avg += a[i];
                        if (a[i] > max)
                        {
                            max = a[i];
                            max_index = i;
                        }
                    }
                    avg -= max;
                    avg /= 4095;

                    if (max < (avg + 30))
                    {
                        if (!suppress_errors)
                        {
                            MessageBox.Show(new Form { TopMost = true }, "Peak is less than 30dB from the noise floor.  " +
                                "Please use a larger signal for frequency calibration.",
                                "Calibration Error - Weak Signal",
                                MessageBoxButtons.OK,
                                MessageBoxIcon.Error);
                        }
                        ret_val = false;
                        goto end2;
                    }

                    rx1_meter_cal_offset = 0.0f;
                    RX1DisplayCalOffset = 0.0f;
                    num = 0.0f; num2 = 0.0f; avg2 = 0.0f;
                    avg = 0.0f;
                    // get the value of the signal strength meter
                    for (int i = 0; i < 50; i++)
                    {
                        num += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end2;
                        else progress.SetPercent((float)((float)++counter / 120));
                    }
                    avg = num / 50.0f;

                    FWC.SetTRXPreamp(true);
                    Thread.Sleep(200);

                    // get the value of the signal strength meter
                    num2 = 0.0f;
                    for (int i = 0; i < 50; i++)
                    {
                        num2 += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end2;
                        else progress.SetPercent((float)((float)++counter / 120));
                    }
                    avg2 = num2 / 50.0f;

                    fwc_preamp_offset = avg2 - avg;
                    rx1_preamp_offset[(int)PreampMode.OFF] = 0.0f;
                    rx1_preamp_offset[(int)PreampMode.HIGH] = -fwc_preamp_offset;

                    Debug.WriteLine("fwc_preamp_offset: " + fwc_preamp_offset.ToString("f6"));

                    FWC.SetTRXPreamp(false);
                    Thread.Sleep(200);

                    num2 = 0.0f;
                    for (int i = 0; i < 20; i++)
                    {
                        calibration_mutex.WaitOne();
                        fixed (float* ptr = &a[0])
                            DttSP.GetSpectrum(0, ptr);		// read again to clear out changed DSP
                        calibration_mutex.ReleaseMutex();

                        /*max = float.MinValue;						// find the max spectrum value
                        for(int j=0; j<Display.BUFFER_SIZE; j++)
                            if(a[j] > max) max = a[j];*/

                        //num2 += max;
                        num2 += a[max_index];
                        Thread.Sleep(100);

                        if (!progress.Visible)
                            goto end2;
                        else progress.SetPercent((float)((float)++counter / 120));
                    }
                    avg2 = num2 / 20.0f;

                    // calculate the difference between the current value and the correct multimeter value
                    diff = level - (avg + rx1_meter_cal_offset);
                    rx1_meter_cal_offset = diff;

                    // calculate the difference between the current value and the correct spectrum value
                    diff = level - (avg2 + RX1DisplayCalOffset);
                    RX1DisplayCalOffset = diff;

                    UpdateDisplayOffsets();

                    rx1_level_table[(int)rx1_band][0] = (float)Math.Round(rx1_display_cal_offset, 3);
                    rx1_level_table[(int)rx1_band][1] = (float)Math.Round(-fwc_preamp_offset, 3);
                    rx1_level_table[(int)rx1_band][2] = (float)Math.Round(rx1_meter_cal_offset, 3);

                    ret_val = true;

                end2:
                    if (!progress.Visible) progress.Text = "";
                    progress.Hide();
                    EnableAllFilters();
                    EnableAllModes();
                    VFOLock = false;

                    FullDuplex = duplex;
                    Thread.Sleep(50);
                    FWC.SetGen(false);
                    Thread.Sleep(50);
                    FWC.SetTest(false);
                    Thread.Sleep(50);
                    FWC.SetSig(false);
                    Thread.Sleep(50);

                    fwc_rx1_preamp = false;
                    chkRX1Preamp.Enabled = true;
                    RX1PreampMode = preamp;
                    chkRX1Preamp_CheckedChanged(this, EventArgs.Empty);
                    comboDisplayMode.Enabled = true;
                    comboMeterRXMode.Enabled = true;

                    if (ret_val == false)
                    {
                        rx1_meter_cal_offset = old_multimeter_cal;
                        rx1_display_cal_offset = old_display_cal;
                    }

                    //RX2Enabled = rx2;
                    comboDisplayMode.Text = display;
                    chkRIT.Checked = rit_on;						// restore RIT on
                    udRIT.Value = rit_val;							// restore RIT value
                    //SetupForm.RXOnly = rx_only					// restore RX Only			
                    DisplayAVG = display_avg;						// restore AVG value
                    RX1Filter = am_filter;							// restore AM filter
                    RX1DSPMode = dsp_mode;							// restore DSP mode
                    RX1Filter = filter;								// restore filter
                    if (dsp_buf_size != 4096)
                        chkPower.Checked = false;					// go to standby
                    setupForm.DSPPhoneRXBuffer = dsp_buf_size;		// restore DSP Buffer Size
                    VFOAFreq = vfoa;								// restore vfo frequency
                    if (dsp_buf_size != 4096)
                    {
                        Thread.Sleep(100);
                        chkPower.Checked = true;
                    }
                    CurrentMeterRXMode = rx_meter;					// restore RX Meter mode
                    setupForm.Polyphase = polyphase;				// restore polyphase

                    UpdateDisplayOffsets();

                    //			Debug.WriteLine("rx1_meter_cal_offset: "+rx1_meter_cal_offset);
                    //			Debug.WriteLine("display_cal_offset: "+display_cal_offset);
                    //			MessageBox.Show(new Form { TopMost = true }, "rx1_meter_cal_offset: "+rx1_meter_cal_offset.ToString()+"\n"+
                    //				"display_cal_offset: "+display_cal_offset.ToString());
                    break;
                case Model.FLEX3000:
                    vfoa = VFOAFreq;									// save current VFOA

                    rit_on = chkRIT.Checked;							// save current RIT On
                    chkRIT.Checked = false;								// turn RIT off
                    rit_val = (int)udRIT.Value;							// save current RIT value					

                    display = comboDisplayMode.Text;
                    comboDisplayMode.Text = "Spectrum";

                    polyphase = setupForm.Polyphase;					// save current polyphase setting
                    setupForm.Polyphase = false;						// disable polyphase

                    dsp_buf_size = setupForm.DSPPhoneRXBuffer;			// save current DSP buffer size
                    setupForm.DSPPhoneRXBuffer = 4096;					// set DSP Buffer Size to 2048

                    filter = RX1Filter;									// save current filter

                    dsp_mode = rx1_dsp_mode;							// save current DSP demod mode
                    RX1DSPMode = DSPMode.DSB;							// set mode to DSB

                    VFOAFreq = freq;									// set VFOA frequency
                    VFOBFreq = freq;

                    duplex = full_duplex;
                    FullDuplex = true;
                    Thread.Sleep(50);
                    FWC.SetGen(true);
                    Thread.Sleep(50);
                    FWC.SetTest(true);
                    Thread.Sleep(50);
                    FWC.SetSig(true);
                    Thread.Sleep(50);

                    am_filter = RX1Filter;								// save current AM filter
                    RX1Filter = Filter.F1;								// set filter to 500Hz

                    preamp = RX1PreampMode;								// save current preamp mode
                    RX1PreampMode = PreampMode.LOW;						// set to Low (preamp off, attn off)

                    rx_meter = CurrentMeterRXMode;						// save current RX Meter mode
                    CurrentMeterRXMode = MeterRXMode.OFF;				// turn RX Meter off

                    display_avg = chkDisplayAVG.Checked;				// save current average state
                    chkDisplayAVG.Checked = false;
                    chkDisplayAVG.Checked = true;						// set average state to off

                    old_multimeter_cal = rx1_meter_cal_offset;
                    old_display_cal = rx1_display_cal_offset;

                    comboPreamp.Enabled = false;
                    comboDisplayMode.Enabled = false;
                    comboMeterRXMode.Enabled = false;

                    progress.SetPercent(0.0f);
                    counter = 0;

                    //RX1Filter = Filter.F6;					
                    UpdateRX1Filters(-500, 500);
                    chkDisplayAVG.Checked = false;

                    /*FWC.SetTRXPreamp(false);
                    FWC.SetRXAttn(false);*/
                    Thread.Sleep(200);

                    DisableAllFilters();
                    DisableAllModes();
                    VFOLock = true;

                    calibration_mutex.WaitOne();
                    fixed (float* ptr = &a[0])
                        DttSP.GetSpectrum(0, ptr);		// get the spectrum values
                    calibration_mutex.ReleaseMutex();

                    max = float.MinValue;
                    avg = 0;
                    max_index = 0;

                    for (int i = 0; i < 4095; i++)						// find the maximum signal
                    {
                        avg += a[i];
                        if (a[i] > max)
                        {
                            max = a[i];
                            max_index = i;
                        }
                    }
                    avg -= max;
                    avg /= 4095;

                    if (max < (avg + 30))
                    {
                        if (!suppress_errors)
                        {
                            MessageBox.Show(new Form { TopMost = true }, "Peak is less than 30dB from the noise floor.  " +
                                "Please use a larger signal for frequency calibration.",
                                "Calibration Error - Weak Signal",
                                MessageBoxButtons.OK,
                                MessageBoxIcon.Error);
                        }
                        ret_val = false;
                        goto end3;
                    }

                    rx1_meter_cal_offset = 0.0f;
                    RX1DisplayCalOffset = 0.0f;
                    num = 0.0f; num2 = 0.0f; avg2 = 0.0f;
                    avg = 0.0f;
                    float avg3 = 0.0f;
                    // get the value of the signal strength meter
                    for (int i = 0; i < 50; i++)
                    {
                        num += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end3;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg = num / 50.0f;

                    FWC.SetTRXPreamp(true);
                    Thread.Sleep(200);

                    // get the value of the signal strength meter
                    num2 = 0.0f;
                    for (int i = 0; i < 50; i++)
                    {
                        num2 += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end3;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg2 = num2 / 50.0f;

                    FWC.SetTRXPreamp(false);
                    FWC.SetRXAttn(true);
                    Thread.Sleep(200);

                    // get the value of the signal strength meter
                    num2 = 0.0f;
                    for (int i = 0; i < 50; i++)
                    {
                        num2 += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end3;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg3 = num2 / 50.0f;

                    float pre = avg2 - avg;
                    float attn = avg3 - avg;

                    rx1_preamp_offset[(int)PreampMode.OFF] = -attn;
                    rx1_preamp_offset[(int)PreampMode.LOW] = 0.0f;
                    rx1_preamp_offset[(int)PreampMode.MED] = attn - pre;
                    rx1_preamp_offset[(int)PreampMode.HIGH] = -pre;

                    FWC.SetTRXPreamp(false);
                    FWC.SetRXAttn(false);
                    Thread.Sleep(200);

                    num2 = 0.0f;
                    for (int i = 0; i < 20; i++)
                    {
                        calibration_mutex.WaitOne();
                        fixed (float* ptr = &a[0])
                            DttSP.GetSpectrum(0, ptr);		// read again to clear out changed DSP
                        calibration_mutex.ReleaseMutex();

                        /*max = float.MinValue;						// find the max spectrum value
                        for(int j=0; j<Display.BUFFER_SIZE; j++)
                            if(a[j] > max) max = a[j];*/

                        //num2 += max;
                        num2 += a[max_index];
                        Thread.Sleep(100);

                        if (!progress.Visible)
                            goto end3;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg2 = num2 / 20.0f;

                    // calculate the difference between the current value and the correct multimeter value
                    diff = level - (avg + rx1_meter_cal_offset);
                    rx1_meter_cal_offset = diff;

                    // calculate the difference between the current value and the correct spectrum value
                    diff = level - (avg2 + RX1DisplayCalOffset);
                    RX1DisplayCalOffset = diff;

                    rx1_level_table[(int)rx1_band][0] = (float)Math.Round(rx1_display_cal_offset, 3);
                    rx1_level_table[(int)rx1_band][1] = (float)Math.Round(rx1_preamp_offset[(int)PreampMode.OFF], 3);
                    rx1_level_table[(int)rx1_band][2] = (float)Math.Round(rx1_preamp_offset[(int)PreampMode.HIGH], 3);

                    ret_val = true;

                end3:
                    if (!progress.Visible) progress.Text = "";
                    progress.Hide();
                    EnableAllFilters();
                    EnableAllModes();
                    VFOLock = false;

                    FullDuplex = duplex;
                    Thread.Sleep(50);
                    FWC.SetGen(false);
                    Thread.Sleep(50);
                    FWC.SetTest(false);
                    Thread.Sleep(50);
                    FWC.SetSig(false);
                    Thread.Sleep(50);

                    /*FWC.SetTRXPreamp(false);
                    FWC.SetRXAttn(true);*/
                    comboPreamp.Enabled = true;
                    RX1PreampMode = preamp;

                    comboDisplayMode.Enabled = true;
                    comboMeterRXMode.Enabled = true;

                    if (ret_val == false)
                    {
                        rx1_meter_cal_offset = old_multimeter_cal;
                        rx1_display_cal_offset = old_display_cal;
                    }

                    comboDisplayMode.Text = display;
                    chkRIT.Checked = rit_on;						// restore RIT on
                    udRIT.Value = rit_val;							// restore RIT value
                    //SetupForm.RXOnly = rx_only					// restore RX Only			
                    DisplayAVG = display_avg;						// restore AVG value
                    RX1Filter = am_filter;							// restore AM filter
                    RX1DSPMode = dsp_mode;							// restore DSP mode
                    RX1Filter = filter;								// restore filter
                    if (dsp_buf_size != 4096)
                        chkPower.Checked = false;					// go to standby
                    setupForm.DSPPhoneRXBuffer = dsp_buf_size;		// restore DSP Buffer Size
                    VFOAFreq = vfoa;								// restore vfo frequency
                    if (dsp_buf_size != 4096)
                    {
                        Thread.Sleep(100);
                        chkPower.Checked = true;
                    }
                    CurrentMeterRXMode = rx_meter;					// restore RX Meter mode
                    setupForm.Polyphase = polyphase;				// restore polyphase

                    UpdateDisplayOffsets();

                    //			Debug.WriteLine("rx1_meter_cal_offset: "+rx1_meter_cal_offset);
                    //			Debug.WriteLine("display_cal_offset: "+display_cal_offset);
                    //			MessageBox.Show(new Form { TopMost = true }, "rx1_meter_cal_offset: "+rx1_meter_cal_offset.ToString()+"\n"+
                    //				"display_cal_offset: "+display_cal_offset.ToString());
                    break;
                case Model.FLEX1500:
                    vfoa = VFOAFreq;									// save current VFOA

                    rit_on = chkRIT.Checked;							// save current RIT On
                    chkRIT.Checked = false;								// turn RIT off
                    rit_val = (int)udRIT.Value;							// save current RIT value					

                    display = comboDisplayMode.Text;
                    comboDisplayMode.Text = "Spectrum";

                    polyphase = setupForm.Polyphase;					// save current polyphase setting
                    setupForm.Polyphase = false;						// disable polyphase

                    /*dsp_buf_size = SetupForm.DSPPhoneRXBuffer;			// save current DSP buffer size
                    SetupForm.DSPPhoneRXBuffer = 2048;					// set DSP Buffer Size to 2048*/

                    filter = RX1Filter;									// save current filter

                    dsp_mode = rx1_dsp_mode;							// save current DSP demod mode
                    RX1DSPMode = DSPMode.DSB;							// set mode to DSB

                    VFOAFreq = freq;									// set VFOA frequency
                    Thread.Sleep(100);
                    VFOBFreq = freq;

                    bool sr = chkSR.Checked;
                    chkSR.Checked = false;

                    HIDAnt hid_ant = RXAnt1500;
                    RXAnt1500 = HIDAnt.BITE;
                    Thread.Sleep(100);

                    USBHID.SetGen(true);
                    Thread.Sleep(100);

                    USBHID.SetQSE(true);
                    Thread.Sleep(100);

                    USBHID.SetTest(true);
                    Thread.Sleep(100);

                    am_filter = RX1Filter;								// save current AM filter
                    RX1Filter = Filter.F1;								// set filter to 500Hz

                    preamp = RX1PreampMode;								// save current preamp mode
                    RX1PreampMode = (PreampMode)FLEX1500PreampMode.ZERO;// set to Off

                    rx_meter = CurrentMeterRXMode;						// save current RX Meter mode
                    CurrentMeterRXMode = MeterRXMode.OFF;				// turn RX Meter off

                    display_avg = chkDisplayAVG.Checked;				// save current average state
                    chkDisplayAVG.Checked = false;
                    chkDisplayAVG.Checked = true;						// set average state to off

                    old_multimeter_cal = rx1_meter_cal_offset;
                    old_display_cal = rx1_display_cal_offset;

                    comboPreamp.Enabled = false;
                    comboDisplayMode.Enabled = false;
                    //comboMeterRXMode.Enabled = false;

                    progress.SetPercent(0.0f);
                    counter = 0;

                    //RX1Filter = Filter.F6;					
                    UpdateRX1Filters(-(int)(if_freq * 1e6) + cw_pitch - 100, -(int)(if_freq * 1e6) + cw_pitch + 100);
                    chkDisplayAVG.Checked = false;

                    DisableAllFilters();
                    DisableAllModes();
                    VFOLock = true;

                    DttSP.SetCorrectIQEnable(0); // turn off I/Q correction
                    DttSP.SetCorrectRXIQw(0, 0, 0.0f, 0.0f, 0);
                    DttSP.SetCorrectRXIQw(0, 0, 0.0f, 0.0f, 1);

                    double scale = Audio.SourceScale;
                    Audio.SourceScale = 0.01;

                    Audio.RX1OutputSignal = Audio.SignalSource.SINE;

                    bool mute = chkMUT.Checked;
                    chkMUT.Checked = false;

                    Thread.Sleep(400);

                    calibration_mutex.WaitOne();
                    fixed (float* ptr = &a[0])
                        DttSP.GetSpectrum(0, ptr);		// get the spectrum values
                    calibration_mutex.ReleaseMutex();

                    calibration_mutex.WaitOne();
                    fixed (float* ptr = &a[0])
                        DttSP.GetSpectrum(0, ptr);		// get the spectrum values again to clear out the old ones
                    calibration_mutex.ReleaseMutex();

                    max = float.MinValue;
                    avg = 0;
                    max_index = 0;

                    for (int i = 0; i < 4095; i++)						// find the maximum signal
                    {
                        avg += a[i];
                        if (a[i] > max)
                        {
                            max = a[i];
                            max_index = i;
                        }
                    }
                    avg -= max;
                    avg /= 4095;

                    if (max < (avg + 30))
                    {
                        if (!suppress_errors)
                        {
                            MessageBox.Show(new Form { TopMost = true }, "Peak is less than 30dB from the noise floor.  " +
                                "Please use a larger signal for frequency calibration.",
                                "Calibration Error - Weak Signal",
                                MessageBoxButtons.OK,
                                MessageBoxIcon.Error);
                        }
                        ret_val = false;
                        goto end4;
                    }

                    rx1_meter_cal_offset = 0.0f;
                    RX1DisplayCalOffset = 0.0f;
                    num = 0.0f; num2 = 0.0f; avg2 = 0.0f;
                    avg = 0.0f;
                    avg3 = 0.0f;
                    // get the value of the signal strength meter
                    for (int i = 0; i < 50; i++)
                    {
                        num += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end4;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg = num / 50.0f;

                    /*while (progress.Visible)
                    {
                        progress.SetPercent((float)((float)++counter / 170));
                        Thread.Sleep(100);
                    }
                    progress.Show();*/

                    RX1PreampMode = (PreampMode)FLEX1500PreampMode.PLUS_20;
                    Thread.Sleep(200);

                    // get the value of the signal strength meter
                    num2 = 0.0f;
                    for (int i = 0; i < 50; i++)
                    {
                        num2 += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                        Thread.Sleep(50);
                        if (!progress.Visible)
                            goto end4;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg2 = num2 / 50.0f;
                    attn = avg2 - avg;

                    /*while (progress.Visible)
                    {
                        progress.SetPercent((float)((float)++counter / 170));
                        Thread.Sleep(100);
                    }
                    progress.Show();*/

                    Debug.WriteLine("attn: " + attn.ToString("f1") + " max_index: " + max_index);

                    rx1_preamp_offset[(int)PreampMode.OFF] = attn + 10.0f; // -10
                    rx1_preamp_offset[(int)PreampMode.LOW] = attn; // 0
                    rx1_preamp_offset[(int)PreampMode.MED] = +10.0f; // +10
                    rx1_preamp_offset[(int)PreampMode.HIGH] = 0.0f; // +20
                    rx1_preamp_offset[(int)PreampMode.LAST] = -10.0f; // +30

                    /*RX1PreampMode = (PreampMode)FLEX1500PreampMode.PLUS_20;
                    Thread.Sleep(200); */

                    num = 0.0f;
                    for (int i = 0; i < 20; i++)
                    {
                        calibration_mutex.WaitOne();
                        fixed (float* ptr = &a[0])
                            DttSP.GetSpectrum(0, ptr);		// read again to clear out changed DSP
                        calibration_mutex.ReleaseMutex();

                        /*max = float.MinValue;						// find the max spectrum value
                        for(int j=0; j<Display.BUFFER_SIZE; j++)
                            if(a[j] > max) max = a[j];*/

                        //num2 += max;
                        num += a[max_index];
                        Thread.Sleep(100);

                        if (!progress.Visible)
                            goto end4;
                        else progress.SetPercent((float)((float)++counter / 170));
                    }
                    avg = num / 20.0f;

                    // calculate the difference between the current value and the correct multimeter value
                    diff = level - (avg2 + rx1_meter_cal_offset);
                    rx1_meter_cal_offset = diff;

                    // calculate the difference between the current value and the correct spectrum value
                    diff = level - (avg + RX1DisplayCalOffset);
                    RX1DisplayCalOffset = diff;

                    rx1_level_table[(int)rx1_band][0] = (float)Math.Round(rx1_display_cal_offset, 1);
                    rx1_level_table[(int)rx1_band][1] = (float)Math.Round(attn, 1);
                    rx1_level_table[(int)rx1_band][2] = (float)Math.Round(0.0f, 1);

                    ret_val = true;

                end4:
                    if (!progress.Visible) progress.Text = "";
                    progress.Hide();
                    EnableAllFilters();
                    EnableAllModes();
                    VFOLock = false;

                    USBHID.SetTest(false); Thread.Sleep(10);
                    USBHID.SetGen(false); Thread.Sleep(10);
                    USBHID.SetQSE(false); Thread.Sleep(10);
                    RXAnt1500 = hid_ant; Thread.Sleep(10);

                    Audio.SourceScale = scale;
                    Audio.RX1OutputSignal = Audio.SignalSource.RADIO;

                    RX1PreampMode = preamp;

                    DttSP.SetCorrectIQEnable(1); // turn on I/Q correction

                    comboDisplayMode.Enabled = true;
                    comboMeterRXMode.Enabled = true;
                    comboPreamp.Enabled = true;

                    if (ret_val == false)
                    {
                        rx1_meter_cal_offset = old_multimeter_cal;
                        rx1_display_cal_offset = old_display_cal;
                    }

                    chkMUT.Checked = mute;
                    comboDisplayMode.Text = display;
                    chkRIT.Checked = rit_on;						// restore RIT on
                    udRIT.Value = rit_val;							// restore RIT value
                    //SetupForm.RXOnly = rx_only					// restore RX Only			
                    DisplayAVG = display_avg;						// restore AVG value
                    RX1Filter = am_filter;							// restore AM filter
                    RX1DSPMode = dsp_mode;							// restore DSP mode
                    RX1Filter = filter;								// restore filter
                    /*if (dsp_buf_size != 4096)
                        chkPower.Checked = false;					// go to standby
                    SetupForm.DSPPhoneRXBuffer = dsp_buf_size;		// restore DSP Buffer Size*/
                    VFOAFreq = vfoa; Thread.Sleep(10);								// restore vfo frequency
                    /*if (dsp_buf_size != 4096)
                    {
                        Thread.Sleep(100);
                        chkPower.Checked = true;
                    }*/
                    CurrentMeterRXMode = rx_meter;					// restore RX Meter mode
                    setupForm.Polyphase = polyphase;				// restore polyphase

                    UpdateDisplayOffsets();
                    break;
            }
            calibration_running = false;
            return ret_val;
        }

        /*public void FLEX5000DetectTapResistor()
		{
			Thread t = new Thread(new ThreadStart(RunFLEX5000DetectTapResistor));
			t.Name = "Run FLEX5000 Detect Tap Resistor Thread";
			t.IsBackground = true;
			t.Priority = ThreadPriority.Normal;
			Application.DoEvents();
			Thread.Sleep(100);
			t.Start();
		}

		public void RunFLEX5000DetectTapResistor()
		{
			//bool ret_val = false;
			calibration_running = true;

			if(!chkPower.Checked || !fwc_init || current_model != Model.FLEX5000)
			{
				calibration_running = false;
				return;
			}

			bool rx1_sr = SpurReduction;
			SpurReduction = true;

			bool rx2_sr = RX2SpurReduction;
			RX2SpurReduction = true;

			bool rit_on = chkRIT.Checked;						// save current RIT On
			chkRIT.Checked = false;								// turn RIT off
			int rit_val = (int)udRIT.Value;						// save current RIT value

			double vfoa = VFOAFreq;								// save current VFOA

			int dsp_buf_size = SetupForm.DSPPhoneRXBuffer;		// save current DSP buffer size
			SetupForm.DSPPhoneRXBuffer = 4096;					// set DSP Buffer Size to 2048

			Filter filter = RX1Filter;						// save current filter

			DSPMode dsp_mode = rx1_dsp_mode;				// save current DSP demod mode
			DSPMode dsp2_mode = rx2_dsp_mode;				// save current DSP demod mode

			RX1DSPMode = DSPMode.DSB;						// set mode to DSB
			RX2DSPMode = DSPMode.DSB;						// set mode to DSB

			VFOAFreq = 14.2;								// set VFOA frequency
			VFOBFreq = 14.2;

			bool duplex = full_duplex;
			FullDuplex = true;
			Thread.Sleep(50);
			FWC.SetGen(true);
			Thread.Sleep(50);
			FWC.SetTest(true);
			Thread.Sleep(50);
			FWC.SetSig(true);
			Thread.Sleep(50);
				
			bool rx2 = rx2_enabled;
			RX2Enabled = true;

			FWCAnt rx2_antenna = rx2_ant;
			RX2Ant = FWCAnt.RX1TAP;

			Filter rx1_filter = RX1Filter;					// save current AM filter
			UpdateRX1Filters(-500, 500);
			
			Filter rx2_filter = RX2Filter;
			UpdateRX2Filters(-500, 500);

			//string preamp_s = comboPreamp.Text;					// save current preamp mode
			//comboPreamp.Text = "Off";							// turn preamp off
			bool preamp = chkRX1Preamp.Checked;
			chkRX1Preamp.Checked = false;

			MeterRXMode rx_meter = CurrentMeterRXMode;			// save current RX Meter mode
			CurrentMeterRXMode = MeterRXMode.OFF;				// turn RX Meter off

			MeterRXMode rx2_meter = RX2MeterMode;
			RX2MeterMode = MeterRXMode.OFF;

			chkRX1Preamp.Enabled = false;
			chkRX2Preamp.Enabled = false;
			comboMeterRXMode.Enabled = false;
			comboRX2MeterMode.Enabled = false;

			//progress.SetPercent(0.0f);
			//int counter = 0;

			FWC.SetRX2Preamp(false);
			Thread.Sleep(200);

			float num = 0.0f;
			// get the value of the signal strength meter
			for(int i=0; i<50; i++)
			{
				num += DttSP.CalculateRXMeter(2, 0, DttSP.MeterType.ADC_REAL);
				Thread.Sleep(50);
				//if(!progress.Visible)
				//	goto end2;
				//else progress.SetPercent((float)((float)++counter/120));
			}
			float avg = num / 50.0f;

			num = 0.0f;
			for(int i=0; i<50; i++)
			{
				num += DttSP.CalculateRXMeter(0, 0, DttSP.MeterType.ADC_REAL);
				Thread.Sleep(50);
				//if(!progress.Visible)
				//	goto end2;
				//else progress.SetPercent((float)((float)++counter/120));
			}
			float avg2 = num / 50.0f;

			rx2_res_offset = avg2-avg;
			rx2_trx_match_serial = FWCEEPROM.TRXSerial;

			//ret_val = true;

			//end2:
				//if(!progress.Visible) progress.Text = "";
			//progress.Hide();
			EnableAllFilters();
			EnableAllModes();
			VFOLock = false;

			FullDuplex = duplex;
			Thread.Sleep(50);
			FWC.SetGen(false);
			Thread.Sleep(50);
			FWC.SetTest(false);
			Thread.Sleep(50);
			FWC.SetSig(false);
			Thread.Sleep(50);

			chkRX1Preamp.Enabled = true;
			chkRX2Preamp.Enabled = true;
			comboMeterRXMode.Enabled = true;
			comboRX2MeterMode.Enabled = true;

			SpurReduction = rx1_sr;
			RX2SpurReduction = rx2_sr;
			RX2Enabled = rx2;
			RX2Ant = rx2_antenna;
			chkRIT.Checked = rit_on;							// restore RIT on
			udRIT.Value = rit_val;								// restore RIT value
			//SetupForm.RXOnly = rx_only;							// restore RX Only			
			chkRX1Preamp.Checked = preamp;						// restore preamp value
			RX1Filter = rx1_filter;							// restore AM filter
			RX1DSPMode = dsp_mode;							// restore DSP mode
			RX2DSPMode = dsp2_mode;							// restore DSP mode
			RX1Filter = filter;								// restore filter
			if(dsp_buf_size != 4096)
				chkPower.Checked = false;						// go to standby
			SetupForm.DSPPhoneRXBuffer = dsp_buf_size;				// restore DSP Buffer Size
			VFOAFreq = vfoa;									// restore vfo frequency
			if(dsp_buf_size != 4096)
			{
				Thread.Sleep(100);
				chkPower.Checked = true;
			}
			CurrentMeterRXMode = rx_meter;						// restore RX Meter mode
			RX2MeterMode = rx2_meter;

			calibration_running = false;
		}*/

        public bool CalibrateRX2Level(float level, float freq, Progress progress, bool suppress_errors)
        {
            // Calibration routine called by Setup Form.
            bool ret_val = false;
            calibration_running = true;
            if (!chkPower.Checked)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Power must be on in order to calibrate RX2 Level.", "Power Is Off",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                }
                calibration_running = false;
                return false;
            }

            if (!fwc_init || current_model != Model.FLEX5000)
            {
                calibration_running = false;
                return false;
            }

            float[] a = new float[Display.BUFFER_SIZE];

            bool rx1_sr = SpurReduction;
            SpurReduction = true;
            //Thread.Sleep(50);

            bool rx2_sr = RX2SpurReduction;
            RX2SpurReduction = true;
            //Thread.Sleep(50);

            bool rit_on = chkRIT.Checked;                       // save current RIT On
            chkRIT.Checked = false;                             // turn RIT off
            int rit_val = (int)udRIT.Value;                     // save current RIT value

            double vfoa = VFOAFreq;                             // save current VFOA

            string display = comboDisplayMode.Text;
            comboDisplayMode.Text = "Spectrum";

            bool polyphase = setupForm.Polyphase;               // save current polyphase setting
            setupForm.Polyphase = false;                        // disable polyphase

            int dsp_buf_size = setupForm.DSPPhoneRXBuffer;      // save current DSP buffer size
            setupForm.DSPPhoneRXBuffer = 4096;                  // set DSP Buffer Size to 2048

            Filter filter = RX1Filter;                      // save current filter

            DSPMode dsp_mode = rx1_dsp_mode;                // save current DSP demod mode
            DSPMode dsp2_mode = rx2_dsp_mode;               // save current DSP demod mode

            RX1DSPMode = DSPMode.DSB;                       // set mode to DSB
                                                            //Thread.Sleep(50);
            RX2DSPMode = DSPMode.DSB;                       // set mode to DSB

            VFOAFreq = freq;                                    // set VFOA frequency
                                                                //Thread.Sleep(100);
            VFOBFreq = freq;
            //Thread.Sleep(100);

            bool duplex = full_duplex;
            FullDuplex = true;
            //Thread.Sleep(50);
            FWC.SetGen(true);
            //Thread.Sleep(50);
            FWC.SetTest(true);
            //Thread.Sleep(50);
            FWC.SetSig(true);
            //Thread.Sleep(50);

            bool rx2 = rx2_enabled;
            RX2Enabled = true;

            FWCAnt rx2_antenna = rx2_ant;
            RX2Ant = FWCAnt.RX1TAP;
            //Thread.Sleep(50);

            Filter rx1_filter = RX1Filter;                  // save current AM filter
            UpdateRX1Filters(-500, 500);

            Filter rx2_filter = RX2Filter;
            UpdateRX2Filters(-500, 500);

            bool rx1_preamp = chkRX1Preamp.Checked;                 // save current preamp mode
            chkRX1Preamp.Checked = false;                           // turn preamp off
                                                                    //Thread.Sleep(50);

            bool rx2_preamp = chkRX2Preamp.Checked;                 // save current preamp mode
            chkRX2Preamp.Checked = false;                           // turn preamp off
                                                                    //Thread.Sleep(50);

            MeterRXMode rx_meter = CurrentMeterRXMode;          // save current RX Meter mode
            CurrentMeterRXMode = MeterRXMode.OFF;               // turn RX Meter off

            MeterRXMode rx2_meter = RX2MeterMode;
            RX2MeterMode = MeterRXMode.OFF;

            bool display_avg = chkDisplayAVG.Checked;           // save current average state
            chkDisplayAVG.Checked = false;
            chkDisplayAVG.Checked = true;                       // set average state to off

            float old_multimeter_cal = rx2_meter_cal_offset;
            float old_display_cal = rx2_display_cal_offset;

            chkRX1Preamp.Enabled = false;
            chkRX2Preamp.Enabled = false;
            comboDisplayMode.Enabled = false;
            comboMeterRXMode.Enabled = false;
            comboRX2MeterMode.Enabled = false;

            progress.SetPercent(0.0f);
            int counter = 0;

            Thread.Sleep(2000);
            btnZeroBeat_Click(this, EventArgs.Empty);
            RX1Filter = Filter.F6;
            chkDisplayAVG.Checked = false;

            FWC.SetRX2Preamp(false);
            Thread.Sleep(200);

            DisableAllFilters();
            DisableAllModes();
            VFOLock = true;

            calibration_mutex.WaitOne();
            fixed (float* ptr = &a[0])
                DttSP.GetSpectrum(2, ptr);      // get the spectrum values
            calibration_mutex.ReleaseMutex();

            float max = float.MinValue;
            float avg = 0;
            int max_index = 0;

            for (int i = 0; i < 4095; i++)                      // find the maximum signal
            {
                avg += a[i];
                if (a[i] > max)
                {
                    max = a[i];
                    max_index = i;
                }
            }
            avg -= max;
            avg /= 4095;

            if (max < (avg + 30))
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Peak is less than 30dB from the noise floor.  " +
                        "Please use a larger signal for frequency calibration.",
                        "Calibration Error - Weak Signal",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                }
                ret_val = false;
                goto end2;
            }

            rx2_meter_cal_offset = 0.0f;
            RX2DisplayCalOffset = 0.0f;
            float num = 0.0f; float num2 = 0.0f; float avg2 = 0.0f;
            avg = 0.0f;
            // get the value of the signal strength meter
            for (int i = 0; i < 50; i++)
            {
                num += DttSP.CalculateRXMeter(2, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                Thread.Sleep(50);
                if (!progress.Visible)
                    goto end2;
                else progress.SetPercent((float)((float)++counter / 120));
            }
            avg = num / 50.0f;

            FWC.SetRX2Preamp(true);
            Thread.Sleep(200);

            // get the value of the signal strength meter
            num2 = 0.0f;
            for (int i = 0; i < 50; i++)
            {
                num2 += DttSP.CalculateRXMeter(2, 0, DttSP.MeterType.SIGNAL_STRENGTH);
                Thread.Sleep(50);
                if (!progress.Visible)
                    goto end2;
                else progress.SetPercent((float)((float)++counter / 120));
            }
            avg2 = num2 / 50.0f;

            fwc_preamp_offset = avg2 - avg;
            rx2_preamp_offset[(int)PreampMode.OFF] = 0.0f;
            rx2_preamp_offset[(int)PreampMode.HIGH] = -fwc_preamp_offset;

            Debug.WriteLine("fwc_preamp_offset: " + fwc_preamp_offset.ToString("f6"));

            FWC.SetRX2Preamp(false);
            Thread.Sleep(200);

            num2 = 0.0f;
            for (int i = 0; i < 20; i++)
            {
                calibration_mutex.WaitOne();
                fixed (float* ptr = &a[0])
                    DttSP.GetSpectrum(2, ptr);      // read again to clear out changed DSP
                calibration_mutex.ReleaseMutex();

                //max = float.MinValue;						// find the max spectrum value
                //		for(int j=0; j<Display.BUFFER_SIZE; j++)
                //			if(a[j] > max) max = a[j];

                //num2 += max;
                num2 += a[max_index];
                Thread.Sleep(100);

                if (!progress.Visible)
                    goto end2;
                else progress.SetPercent((float)((float)++counter / 120));
            }
            avg2 = num2 / 20.0f;

            // calculate the difference between the current value and the correct multimeter value
            float diff = level - (avg + rx2_meter_cal_offset);
            rx2_meter_cal_offset = diff;

            // calculate the difference between the current value and the correct spectrum value
            diff = level - (avg2 + RX2DisplayCalOffset);
            RX2DisplayCalOffset = diff;

            UpdateDisplayOffsets();

            rx2_level_table[(int)rx2_band][0] = (float)Math.Round(rx2_display_cal_offset, 3);
            rx2_level_table[(int)rx2_band][1] = (float)Math.Round(-fwc_preamp_offset, 3);
            rx2_level_table[(int)rx2_band][2] = (float)Math.Round(rx2_meter_cal_offset, 3);

            ret_val = true;

        end2:
            if (!progress.Visible) progress.Text = "";
            progress.Hide();
            EnableAllFilters();
            EnableAllModes();
            VFOLock = false;

            FullDuplex = duplex;
            //Thread.Sleep(50);
            FWC.SetGen(false);
            //Thread.Sleep(50);
            FWC.SetTest(false);
            //Thread.Sleep(50);
            FWC.SetSig(false);
            //Thread.Sleep(50);

            chkRX1Preamp.Enabled = true;
            chkRX2Preamp.Enabled = true;
            comboDisplayMode.Enabled = true;
            comboMeterRXMode.Enabled = true;
            comboRX2MeterMode.Enabled = true;

            if (ret_val == false)
            {
                rx2_meter_cal_offset = old_multimeter_cal;
                rx2_display_cal_offset = old_display_cal;
            }

            SpurReduction = rx1_sr;
            //Thread.Sleep(50);
            RX2SpurReduction = rx2_sr;
            //Thread.Sleep(50);
            RX2Enabled = rx2;
            RX2Ant = rx2_antenna;
            //Thread.Sleep(50);
            comboDisplayMode.Text = display;
            chkRIT.Checked = rit_on;                            // restore RIT on
            udRIT.Value = rit_val;                              // restore RIT value
                                                                //SetupForm.RXOnly = rx_only;						// restore RX Only			
            DisplayAVG = display_avg;                           // restore AVG value
            chkRX1Preamp.Checked = rx1_preamp;                  // restore preamp value
            chkRX2Preamp.Checked = rx2_preamp;
            FWC.SetRX2Preamp(rx2_preamp);
            RX1Filter = rx1_filter;                         // restore AM filter
            RX1DSPMode = dsp_mode;                          // restore DSP mode
                                                            //Thread.Sleep(50);
            RX2DSPMode = dsp2_mode;                         // restore DSP mode
            RX1Filter = filter;                             // restore filter
            if (dsp_buf_size != 4096)
                chkPower.Checked = false;                       // go to standby
            setupForm.DSPPhoneRXBuffer = dsp_buf_size;              // restore DSP Buffer Size
            VFOAFreq = vfoa;                                    // restore vfo frequency
                                                                //Thread.Sleep(100);
            if (dsp_buf_size != 4096)
            {
                Thread.Sleep(100);
                chkPower.Checked = true;
            }
            CurrentMeterRXMode = rx_meter;                      // restore RX Meter mode
            RX2MeterMode = rx2_meter;
            setupForm.Polyphase = polyphase;                    // restore polyphase

            //			Debug.WriteLine("rx1_meter_cal_offset: "+rx1_meter_cal_offset);
            //			Debug.WriteLine("display_cal_offset: "+display_cal_offset);
            //			MessageBox.Show(new Form { TopMost = true }, "rx1_meter_cal_offset: "+rx1_meter_cal_offset.ToString()+"\n"+
            //				"display_cal_offset: "+display_cal_offset.ToString());

            calibration_running = false;
            return ret_val;
        }

        public float[] rx_image_rejection = new float[(int)Band.LAST];
        public float[] rx_image_from_floor = new float[(int)Band.LAST];
        public bool CalibrateRXImage(float freq, Progress progress, bool suppress_errors)
        {
            HiPerfTimer t1 = new HiPerfTimer();
            t1.Start();
            HiPerfTimer t2 = new HiPerfTimer();

            // Setup Rig for Image Null Cal
            bool ret_val = false;
            calibration_running = true;

            if (!chkPower.Checked)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Power must be on in order to calibrate RX Image.", "Power Is Off",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                }
                calibration_running = false;
                progress.Text = "";
                return false;
            }

            if (hid_init && current_model == Model.FLEX1500)
            {
                if (!Flex1500.ProdTestPresent())
                {
                    MessageBox.Show(new Form { TopMost = true }, "Production Gen Unit not found.  Aborting Test.");
                    calibration_running = false;
                    progress.Text = "";
                    return false;
                }
            }

            bool spur_red = chkSR.Checked;					// save current spur reduction setting
            chkSR.Checked = false;							// turn spur reduction off

            //bool rx_only = SetupForm.RXOnly;				// save RX Only Setting
            //SetupForm.RXOnly = true;

            bool split = chkVFOSplit.Checked;
            chkVFOSplit.Checked = false;

            bool polyphase = setupForm.Polyphase;			// save current polyphase setting
            setupForm.Polyphase = false;					// disable polyphase

            int dsp_buf_size = setupForm.DSPPhoneRXBuffer;		// save current DSP buffer size
            setupForm.DSPPhoneRXBuffer = 4096;					// set DSP Buffer Size to 4096

            string display_mode = comboDisplayMode.Text;
            comboDisplayMode.Text = "Spectrum";

            bool avg = chkDisplayAVG.Checked;		// save current average state
            chkDisplayAVG.Checked = true;

            DSPMode dsp_mode = rx1_dsp_mode;			// save current dsp mode
            RX1DSPMode = DSPMode.DSB;					// set dsp mode to DSB

            int filt_low = RX1FilterLow;
            int filt_high = RX1FilterHigh;
            Filter filter = rx1_filter;					// save current filter
            RX1Filter = Filter.F1;						// set filter to 6kHz

            DttSP.SetCorrectIQEnable(0); // turn off I/Q correction
            DttSP.SetCorrectRXIQw(0, 0, 0.0f, 0.0f, 0);
            DttSP.SetCorrectRXIQw(0, 0, 0.0f, 0.0f, 1);

            PreampMode preamp = rx1_preamp_mode;		// save current preamp setting
            switch (current_model)
            {
                case Model.SDR1000:
                case Model.FLEX5000:
                    RX1PreampMode = PreampMode.HIGH;			// set preamp to high
                    break;
                case Model.FLEX3000:
                    if (FWCEEPROM.TRXRev >> 8 < 6) // before rev G
                    {
                        if (BandByFreq(freq, -1, true, current_region) == Band.B160M)
                            RX1PreampMode = PreampMode.LOW;
                        else RX1PreampMode = PreampMode.HIGH;
                    }
                    else // rev G+
                    {
                        switch (BandByFreq(freq, -1, true, current_region))
                        {
                            case Band.B160M:
                            case Band.B80M:
                            case Band.B60M:
                                RX1PreampMode = PreampMode.LOW;
                                break;
                            default:
                                RX1PreampMode = PreampMode.HIGH;
                                break;
                        }
                    }
                    break;
                case Model.FLEX1500:
                    RX1PreampMode = (PreampMode)FLEX1500PreampMode.PLUS_20;
                    break;
            }

            bool duplex = full_duplex;
            FullDuplex = true;

            bool rx2 = chkRX2.Checked;
            if (fwc_init && current_model == Model.FLEX5000 && FWCEEPROM.RX2OK)
                chkRX2.Checked = false;

            HIDAnt ant = RXAnt1500;

            switch (current_model)
            {
                case Model.FLEX5000:
                case Model.FLEX3000:
                    if (fwc_init)
                    {
                        VFOBFreq = freq;
                        //Thread.Sleep(50);
                        FWC.SetTest(true);
                        //Thread.Sleep(50);
                        FWC.SetGen(true);
                        //Thread.Sleep(50);
                        FWC.SetSig(true);
                        //Thread.Sleep(50);
                        FWC.SetQSE(false);
                        //Thread.Sleep(50);
                    }
                    break;
                case Model.FLEX1500:
                    if (hid_init)
                    {
                        Flex1500.ProdTestWriteOp(USBHID.Opcode.USB_OP_SET_RX1_FREQ_TW, (uint)Freq2TW(freq / 2), 0);
                        Thread.Sleep(20);
                        RXAnt1500 = HIDAnt.XVTX_COM;
                        Thread.Sleep(20);
                    }
                    break;
            }

            double vfo_freq = VFOAFreq;						    // save current frequency
            VFOAFreq = freq + 2 * (float)if_freq;				// was   VFOAFreq = freq + 2 * (float)if_freq;      set frequency to passed value + 2*IF

            DisableAllFilters();
            DisableAllModes();
            VFOLock = true;
            comboPreamp.Enabled = false;
            comboDisplayMode.Enabled = false;

            //int retval = 0;
            progress.SetPercent(0.0f);

            float[] a = new float[Display.BUFFER_SIZE];
            float[] init_max = new float[4];

            Thread.Sleep(200);
            float sum = 0.0f;
            int peak_bin = -1;
            float max_signal = float.MinValue;

            for (int i = 0; i < 5; i++)
            {
                calibration_mutex.WaitOne();
                fixed (float* ptr = &a[0])
                    DttSP.GetSpectrum(0, ptr);// get the spectrum values
                calibration_mutex.ReleaseMutex();
                Thread.Sleep(50);
            }

            for (int i = 0; i < 5; i++)
            {
                calibration_mutex.WaitOne();
                fixed (float* ptr = &a[0])
                    DttSP.GetSpectrum(0, ptr);// get the spectrum values
                calibration_mutex.ReleaseMutex();

                for (int j = 0; i == 4 && j < Display.BUFFER_SIZE; j++)
                {
                    if (a[j] > max_signal)
                    {
                        max_signal = a[j];
                        peak_bin = j;
                    }
                }

                for (int j = 1948; j < 2148; j++) // TODO: Fix limits for 48/96kHz
                {
                    if (j < 2040 || j > 2055)
                        sum += a[j];
                }
                Thread.Sleep(50);
            }

            float noise_floor = (sum / 925.0f);
            float worst_image = max_signal;
            Debug.WriteLine("noise_floor: " + (noise_floor + Display.RX1DisplayCalOffset + Display.RX1PreampOffset).ToString("f6") + " peak_bin: " + peak_bin);

            if (max_signal < noise_floor + 25.0)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Image not found (max signal < noise floor + 25dB).  Please try again.\n" +
                        DateTime.Now.ToShortTimeString(),
                        "Image Not Found",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                }
                calibration_running = false;
                DttSP.SetCorrectIQEnable(1); // turn on I/Q correction
                progress.Hide();
                goto end;
            }

            calibrating = true;
            DttSP.SetCorrectIQEnable(1); // turn on I/Q correction

            int count = 0;
            for (int i = 0; i < 15; i++)
            {
                if (i < 9) DttSP.SetCorrectIQMu(0, 0, 0.1 - i * 0.01);
                if (!progress.Visible) goto end;
                progress.SetPercent(count++ / 15.0f);
                Thread.Sleep(100);
            }

            //if (current_model == Model.FLEX1500)
            //    DttSP.SetCorrectIQMu(0, 0, 0.0);

            // Finish the algorithm and reset the values
            ret_val = true;
        end:

            if (!progress.Visible)
            {
                progress.Text = "";
                rx_image_rejection[(int)rx1_band] = 0.0f;
                rx_image_from_floor[(int)rx1_band] = 100.0f;
            }
            else
            {
                float real, imag;
                //DttSP.SetCorrectIQMu(0, 0, 0);
                DttSP.GetCorrectRXIQw(0, 0, &real, &imag, 1);
                DttSP.SetCorrectRXIQw(0, 0, real, imag, 0);
                DttSP.SetCorrectRXIQw(0, 0, 0.0f, 0.0f, 1);
                Debug.WriteLine("RX Image Real: " + real.ToString("f6") + "  Imag: " + imag.ToString("f6"));
                rx1_image_gain_table[(int)rx1_band] = real;
                rx1_image_phase_table[(int)rx1_band] = imag;

                rx_image_rejection[(int)rx1_band] = (float)(-24.0 - (noise_floor + Display.RX1DisplayCalOffset + Display.RX1PreampOffset));
                rx_image_from_floor[(int)rx1_band] = 0.0f;
            }

            progress.Hide();
            calibration_running = false;
            calibrating = false;

            WBIRRX1Holdoff();

            switch (current_model)
            {
                case Model.FLEX5000:
                case Model.FLEX3000:
                    if (fwc_init)
                    {
                        VFOBFreq = vfo_freq;
                        //Thread.Sleep(50);
                        FWC.SetTest(false);
                        //Thread.Sleep(50);
                        FWC.SetGen(false);
                        //Thread.Sleep(50);
                        FWC.SetSig(false);
                        //Thread.Sleep(50);
                    }
                    break;
                case Model.FLEX1500:
                    if (hid_init)
                    {
                        RXAnt1500 = ant;
                        Flex1500.ProdTestWriteOp(USBHID.Opcode.USB_OP_SET_RX1_FREQ_TW, 0, 0);
                    }
                    break;
            }

            EnableAllFilters();
            EnableAllModes();
            VFOLock = false;
            FullDuplex = duplex;
            comboPreamp.Enabled = true;
            comboDisplayMode.Enabled = true;

            chkVFOSplit.Checked = split;
            chkSR.Checked = spur_red;							// restore spur reduction setting
            RX1PreampMode = preamp;							    // restore preamp mode
            comboDisplayMode.Text = display_mode;				// restore display mode
            //SetupForm.RXOnly = rx_only;						// restore RX Only setting
            RX1DSPMode = dsp_mode;							    // restore dsp mode
            RX1Filter = filter;								    // restore filter
            if (filter == Filter.VAR1 || filter == Filter.VAR2)
                UpdateRX1Filters(filt_low, filt_high);

            VFOAFreq = vfo_freq;								// restore frequency
            txtVFOAFreq_LostFocus(this, EventArgs.Empty);
            chkDisplayAVG.Checked = avg;						// restore average state
            setupForm.DSPPhoneRXBuffer = dsp_buf_size;	        // restore DSP Buffer Size
            setupForm.Polyphase = polyphase;					// restore polyphase

            if (fwc_init && current_model == Model.FLEX5000 && FWCEEPROM.RX2OK)
                chkRX2.Checked = rx2;

            t1.Stop();
            //MessageBox.Show(t1.Duration.ToString());
            Debug.WriteLine("timer: " + t1.Duration);
            return ret_val;
        }

        public bool CalibrateRX2Image(float freq, Progress progress, bool suppress_errors)
        {
            if (!fwc_init || current_model != Model.FLEX5000 || !FWCEEPROM.RX2OK) return false;

            HiPerfTimer t1 = new HiPerfTimer();
            t1.Start();
            HiPerfTimer t2 = new HiPerfTimer();

            //float global_min_value = float.MaxValue;

            // Setup Rig for Image Null Cal
            bool ret_val = false;
            calibration_running = true;

            if (!chkPower.Checked)
            {
                if (!suppress_errors)
                {
                    MessageBox.Show(new Form { TopMost = true }, "Power must be on in order to calibrate RX Image.", "Power Is Off",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                }
                calibration_running = false;
                progress.Text = "";
                return false;
            }

            double vfoa = VFOAFreq;
            double vfob = VFOBFreq;

            DttSP.SetCorrectIQEnable(0);					// turn off I/Q correction
            DttSP.SetCorrectRXIQw(2, 0, 0.0f, 0.0f, 0);
            DttSP.SetCorrectRXIQw(2, 0, 0.0f, 0.0f, 1);

            bool spur_red = chkSR.Checked;					// save current spur reduction setting
            chkSR.Checked = false;							// turn spur reduction off
            //Thread.Sleep(50);

            bool rx2_sr = chkRX2SR.Checked;
            chkRX2SR.Checked = false;
            //Thread.Sleep(50);

            //bool rx_only = SetupForm.RXOnly;				// save RX Only Setting
            //SetupForm.RXOnly = true;

            bool split = chkVFOSplit.Checked;
            chkVFOSplit.Checked = false;

            bool polyphase = setupForm.Polyphase;			// save current polyphase setting
            setupForm.Polyphase = false;					// disable polyphase

            int dsp_buf_size = setupForm.DSPPhoneRXBuffer;	// save current DSP buffer size
            setupForm.DSPPhoneRXBuffer = 4096;				// set DSP Buffer Size to 4096

            bool rx2 = rx2_enabled;
            RX2Enabled = true;

            string display_mode = comboDisplayMode.Text;
            comboDisplayMode.Text = "Spectrum";

            bool avg = chkDisplayAVG.Checked;				// save current average state
            chkDisplayAVG.Checked = true;

            DSPMode dsp_mode = rx1_dsp_mode;				// save current dsp mode
            DSPMode dsp2_mode = rx2_dsp_mode;				// save current dsp mode

            RX1DSPMode = DSPMode.DSB;						// set dsp mode to DSB
            //Thread.Sleep(50);
            RX2DSPMode = DSPMode.DSB;						// set dsp mode to DSB

            int filt1_low = RX1FilterLow;
            int filt1_high = RX1FilterHigh;
            Filter filter1 = rx1_filter;					// save current filter

            int filt2_low = RX1FilterLow;
            int filt2_high = RX1FilterHigh;
            Filter filter2 = rx1_filter;					// save current filter

            /*PreampMode preamp = rx1_preamp_mode;			// save current preamp setting
            RX1PreampMode = PreampMode.HIGH;				// set preamp to high*/
            bool preamp = fwc_rx2_preamp;
            FWC.SetRX2Preamp(true);
            //Thread.Sleep(50);

            bool duplex = full_duplex;
            FullDuplex = true;

            VFOAFreq = freq;
            //Thread.Sleep(50);
            FWC.SetTest(true);
            //Thread.Sleep(50);
            FWC.SetGen(true);
            //Thread.Sleep(50);
            FWC.SetSig(true);
            //Thread.Sleep(50);
  