//=================================================================
// display.cs
//=================================================================
// PowerSDR is a C# implementation of a Software Defined Radio.
// Copyright (C) 2003-2013  FlexRadio Systems
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// You may contact us via email at: gpl@flexradio.com.
// Paper mail may be sent to: 
//    FlexRadio Systems
//    4616 W. Howard Lane  Suite 1-150
//    Austin, TX 78728
//    USA
//=================================================================

using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Threading;
using System.Windows.Forms;
using System.Text;  // ke9ns add for stringbuilder
using System.Text.RegularExpressions;
using System.Globalization;
using System.IO;
using System.IO.Ports;
using FlexCW;
using System.Drawing.Text;
using System.Windows.Media.Media3D;

#if (!NO_TNF)
using Flex.TNF;
#endif

//using Microsoft.DirectX;
//using Microsoft.DirectX.Direct3D;


namespace PowerSDR
{
    sealed class Display
    {

        #region Variable Declaration

        public static Console console;


        public Setup setupForm;                        // ke9ns communications with setupform  (i.e. allow combometertype.text update from inside console.cs) 

        public static SpotControl SpotForm;                     // ke9ns add  communications with spot.cs and dx spotter
        public static SpotDecoder spotDecoder;
        public ScanControl ScanForm;                            // ke9ns add freq Scanner function

        //private static Mutex background_image_mutex;			// used to lock the base display image
        //private static Bitmap background_bmp;					// saved background picture for display
        //private static Bitmap display_bmp;					// Bitmap for use when drawing
        //private static int waterfall_counter;
        private static Bitmap waterfall_bmp;                    // RX1 saved waterfall picture for display
        private static Bitmap waterfall_bmp2;                   // RX2
        private static int[] histogram_data;                    // histogram display buffer
        private static int[] histogram_history;                 // histogram counter
                                                                //private static Graphics display_graphics;				// GDI graphics object
        public const float CLEAR_FLAG = -999.999F;              // for resetting buffers



        public static int BUFFER_SIZE = 4096;                    // ke9ns: was always 4096, now can be switched (setupForm.chkSpectrumHiRes)
        public static int DATA_BUFFER_SIZE = 4096;               // ke9ns: was always 4096, now can be switched (setupForm.chkSpectrumHiRes)


        public const int abright = 5;                           // ke9ns add  used by auto water level, how much db to subtract from the actual avg determined by a scan of the waterfall
        public const int abrightpan = 15;                       // ke9ns add  used by auto water level, how much db to subtract from the actual avg determined by a scan of the panadapter

        public static float[] PAN_DATA;   // ke9ns add: .183

        public static float[] PAN_DATA2;   // ke9ns add: .219 for RX2

        public static float[] new_display_data;                 // Buffer used to store the new data from the DSP for the display
        public static float[] current_display_data;             // Buffer used to store the current data for the display
        public static float[] current_display_data1;            // ke9ns add this is data that is never avg
        public static float[] current_display_data2;            // ke9ns add this is data 

        public static float[] new_display_data_bottom;          // RX2
        public static float[] current_display_data_bottom;      // RX2 
        public static float[] current_display_data_bottom1;     // ke9ns add this is data that is never avg


        public static float[] rx1_average_buffer;                   // Averaged display data buffer
        public static float[] rx2_average_buffer;

        public static float[] rx1_peak_buffer;                      // Peak hold display data buffer
        public static float[] rx2_peak_buffer;

        private static List<Channel> channels_60m;


        #endregion

        #region Properties

        public static List<Channel> Channels60m
        {
            get { return channels_60m; }
        }




        private static bool tnf_zoom = false;
        public static bool TNFZoom
        {
            get { return tnf_zoom; }
            set
            {
                tnf_zoom = value;
                if (current_display_mode == DisplayMode.PANADAPTER) DrawBackground();
            }
        }

        private static bool tnf_active = true;
        public static bool TNFActive
        {
            get { return tnf_active; }
            set
            {
                tnf_active = value;
                if (current_display_mode == DisplayMode.PANADAPTER)
                    DrawBackground();
            }
        }

        //Color notch_on_color = Color.DarkGreen;
        //Color notch_highlight_color = Color.Chartreuse;
        //Color notch_perm_on_color = Color.DarkRed;
        //Color notch_perm_highlight_color = Color.DeepPink;

        private static Color notch_on_color = Color.Olive;
        private static Color notch_on_color_zoomed = Color.FromArgb(190, 128, 128, 0);
        private static Color notch_highlight_color = Color.YellowGreen;
        private static Color notch_highlight_color_zoomed = Color.FromArgb(190, 154, 205, 50);
        private static Color notch_perm_on_color = Color.DarkGreen;
        private static Color notch_perm_highlight_color = Color.Chartreuse;
        private static Color notch_off_color = Color.Gray;

        private static Color channel_background_on = Color.FromArgb(128, Color.DodgerBlue); // ke9ns darkens up when inside channel
        private static Color channel_background_off = Color.FromArgb(32, Color.RoyalBlue); // ke9ns: very faint area inside the channel
        private static Color channel_foreground = Color.Cyan; // ke9ns: lines on edges of channel

        private static double notch_zoom_start_freq;
        public static double NotchZoomStartFreq // in mhz or hz?
        {
            get { return notch_zoom_start_freq; }
            set { notch_zoom_start_freq = value; }
        }

        private static bool pan_fill = true;
        public static bool PanFill  // standard panadapter line underfill
        {
            get { return pan_fill; }
            set { pan_fill = value; }
        }

        private static bool tx_on_vfob = false;
        public static bool TXOnVFOB
        {
            get { return tx_on_vfob; }
            set
            {
                tx_on_vfob = value;
                if (current_display_mode == DisplayMode.PANADAPTER)
                    DrawBackground();
            }
        }
        private static bool split_display = false;
        public static bool SplitDisplay
        {
            get { return split_display; }
            set
            {
                split_display = value;
                DrawBackground();
            }
        }

        /*private static DisplayMode current_display_mode_top = DisplayMode.PANADAPTER;
		public static DisplayMode CurrentDisplayModeTop
		{
			get { return current_display_mode_top; }
			set 
			{
				current_display_mode_top = value;
				if(split_display) DrawBackground();
			}
		}*/

        private static DisplayMode current_display_mode_bottom = DisplayMode.PANADAPTER;
        public static DisplayMode CurrentDisplayModeBottom
        {
            get { return current_display_mode_bottom; }
            set
            {
                current_display_mode_bottom = value;

                if (console.chkRX2.Checked) // dont check auto wtr level if rx2 isnt even on
                {
                    switch (current_display_mode_bottom)  //ke9ns add  (change visability of autobrightbox on console
                    {
                        case DisplayMode.PANADAPTER:
                        case DisplayMode.PANAFALL:
                        case DisplayMode.WATERFALL:
                            console.autoBrightBox.Text = "Auto Wtr/Pan Lvl";
                            autoBright5 = 1;

                            break;
                        default:
                            if (continuum == 0)
                            {
                                if (autoBright4 == 0)
                                {
                                    console.autoBrightBox.Text = "";
                                    //   Debug.WriteLine("off======");
                                }
                            }
                            autoBright5 = 0;
                            break;

                    }

                    //   Debug.WriteLine("ab4 " + autoBright4 + " ab5 " + autoBright5);

                }
                else autoBright5 = 0;


                if (split_display) DrawBackground();
            }
        } // DisplayMode CurrentDisplayModeBottom

        private static int rx1_filter_low;
        public static int RX1FilterLow
        {
            get { return rx1_filter_low; }
            set { rx1_filter_low = value; }
        }

        private static int rx1_filter_high;
        public static int RX1FilterHigh
        {
            get { return rx1_filter_high; }
            set { rx1_filter_high = value; }
        }

        private static int rx2_filter_low;
        public static int RX2FilterLow
        {
            get { return rx2_filter_low; }
            set { rx2_filter_low = value; }
        }

        private static int rx2_filter_high;
        public static int RX2FilterHigh
        {
            get { return rx2_filter_high; }
            set { rx2_filter_high = value; }
        }

        private static int tx_filter_low;
        public static int TXFilterLow
        {
            get { return tx_filter_low; }
            set { tx_filter_low = value; }
        }

        private static int tx_filter_high;
        public static int TXFilterHigh
        {
            get { return tx_filter_high; }
            set { tx_filter_high = value; }
        }

        private static Color sub_rx_zero_line_color = Color.LightSkyBlue;
        public static Color SubRXZeroLine
        {
            get { return sub_rx_zero_line_color; }
            set
            {
                sub_rx_zero_line_color = value;
                if (current_display_mode == DisplayMode.PANADAPTER && sub_rx1_enabled)
                    DrawBackground();
            }
        }

        private static Color sub_rx_filter_color = Color.Blue;
        public static Color SubRXFilterColor
        {
            get { return sub_rx_filter_color; }
            set
            {
                sub_rx_filter_color = value;
                if (current_display_mode == DisplayMode.PANADAPTER && sub_rx1_enabled)
                    DrawBackground();
            }
        }

        private static bool sub_rx1_enabled = false;
        public static bool SubRX1Enabled
        {
            get { return sub_rx1_enabled; }
            set
            {
                sub_rx1_enabled = value;
                if (current_display_mode == DisplayMode.PANADAPTER)
                    DrawBackground();
            }
        }

        private static bool split_enabled = false;
        public static bool SplitEnabled
        {
            get { return split_enabled; }
            set
            {
                split_enabled = value;
                if (current_display_mode == DisplayMode.PANADAPTER && draw_tx_filter) DrawBackground();
            }
        }

        private static bool show_freq_offset = false;
        public static bool ShowFreqOffset
        {
            get { return show_freq_offset; }
            set
            {
                show_freq_offset = value;
                if (current_display_mode == DisplayMode.PANADAPTER)
                    DrawBackground();
            }
        }

        private static Color band_box_color = Color.Lime;
        public static Color BandBoxColor
        {
            get { return band_box_color; }
            set
            {
                band_box_color = value;
                if (current_display_mode == DisplayMode.PANADAPTER)
                    DrawBackground();
            }
        }

        private static float band_box_width = 1.0F;
        public static float BandBoxWidth
        {
            get { return band_box_width; }
            set
            {
                band_box_width = value;
                if (current_display_mode == DisplayMode.PANADAPTER)
                    DrawBackground();
            }
        }

        private static Color band_edge_color = Color.Red;
        public static Color BandEdgeColor
        {
            get { return band_edge_color; }
            set
            {
                band_edge_color = value;
                if (current_display_mode == DisplayMode.PANADAPTER)
                    DrawBackground();
            }
        }

        private static long vfoa_hz;
        public static long VFOA
        {
            get
            {
                return vfoa_hz;
            }
            set
            {
                vfoa_hz = value;

                //if(current_display_mode == DisplayMode.PANADAPTER)
                //	DrawBackground();
            }
        }




        private static long vfoa_sub_hz;
        public static long VFOASub
        {
            get { return vfoa_sub_hz; }
            set
            {
                vfoa_sub_hz = value; // value is in hz (full vfob value)
                                     //   Debug.WriteLine("vfoa_sub_hz" + vfoa_sub_hz);

                //if(current_display_mode == DisplayMode.PANADAPTER)
                //	DrawBackground();
            }
        }

        private static long vfob_hz;
        public static long VFOB
        {
            get { return vfob_hz; }
            set
            {
                vfob_hz = value;
                //if((current_display_mode == DisplayMode.PANADAPTER && split_enabled && draw_tx_filter) ||
                //	(current_display_mode == DisplayMode.PANADAPTER && sub_rx1_enabled))
                //	DrawBackground();
            }
        }

        private static long vfob_sub_hz;
        public static long VFOBSub
        {
            get { return vfob_sub_hz; }
            set
            {
                vfob_sub_hz = value;
                //if(current_display_mode == DisplayMode.PANADAPTER)
                //	DrawBackground();
            }
        }

        private static int rit_hz;
        public static int RIT
        {
            get { return rit_hz; }
            set
            {
                rit_hz = value;
                //if(current_display_mode == DisplayMode.PANADAPTER)
                //	DrawBackground();
            }
        }

        private static int xit_hz;
        public static int XIT
        {
            get { return xit_hz; }
            set
            {
                xit_hz = value;
                //if(current_display_mode == DisplayMode.PANADAPTER && (draw_tx_filter || mox))
                //	DrawBackground();
            }
        }

        private static int cw_pitch = 600;
        public static int CWPitch
        {
            get { return cw_pitch; }
            set { cw_pitch = value; }
        }


        private static int H = 0;   // target height
        private static int W = 0;   // target width

        //=======================================================

        private static PixelFormat WtrColor = PixelFormat.Format24bppRgb;  //          


        public static int map = 0; // ke9ns add 1=map mode (panafall but only a small waterfall) and only when just in RX1 mode)

        public static int H1 = 0;  //  ke9ns add used to fool draw routines when displaying in 3rds 
        public static int H2 = 0;  //  ke9ns add used to fool draw routines when displaying in 4ths   

        public static int K9 = 0;  // ke9ns add: rx1 display mode selector:  1=water,2=pan,3=panfall, 5=panfall with RX2 on any mode, 7=special map viewing panafall
        public static int K10 = 0; // ke9ns add: rx2 display mode selector: 0=off 1=water,2=pan, 5=panfall

        private static int K11 = 0; // ke9ns add: set to 5 in RX1 in panfall, otherwise 0


        private static int K10LAST = 0; // ke9ns add: flag to check for only changes in display mode rx2
        private static int K9LAST = 0;  // ke9ns add: flag to check for only changes in display mode rx1

        private static int K13 = 0; // ke9ns add: original H size before being reduced and past onto drawwaterfall to create bmp file size correctly
        public static int K14 = 0; // ke9ns add: used to draw the bmp waterfall 1 time when you changed display modes.
        private static int K15 = 1; // ke9ns add: used to pass the divider factor back to the init() routine to keep the bmp waterfall size correct

        private static float temp_low_threshold = 0; // ke9ns add: to switch between TX and RX low level waterfall levels
        private static float temp_high_threshold = 0; // ke9ns add: for TX upper level

        public static int DIS_X = 0; // ke9ns add: always the size of picdisplay
        public static int DIS_Y = 0; // ke9ns add:

        //========================================================

        private static Control target = null;
        public static Control Target                 // ke9ns come here when picdisplay is resized (ie. console is resized)
        {
            get { return target; }
            set
            {
                target = value;
                DIS_Y = H = target.Height; // ke9ns mod
                DIS_X = W = target.Width; // ke9ns mod
                Audio.ScopeDisplayWidth = W;


            }
        }

        private static int rx_display_low = -4000; // in hz
        public static int RXDisplayLow
        {
            get { return rx_display_low; }  // ke9ns -96000 at 192k SR and zoom = .5
            set { rx_display_low = value; }
        }

        private static int rx_display_high = 4000;
        public static int RXDisplayHigh
        {
            get { return rx_display_high; } // ke9ns panadapter +96000 at 192k SR and zoom = .5 (different for spectrum display)
            set { rx_display_high = value; }
        }

        private static int tx_display_low = -4000;
        public static int TXDisplayLow
        {
            get { return tx_display_low; }
            set { tx_display_low = value; }
        }

        private static int tx_display_high = 4000;
        public static int TXDisplayHigh
        {
            get { return tx_display_high; }
            set { tx_display_high = value; }
        }


        //-------------------------------------
        // ke9ns .219
        private static int rx_display_low2 = -4000; // in hz
        public static int RXDisplayLow2
        {
            get { return rx_display_low2; }  // ke9ns -96000 at 192k SR and zoom = .5
            set { rx_display_low2 = value; }
        }

        private static int rx_display_high2 = 4000;
        public static int RXDisplayHigh2
        {
            get { return rx_display_high2; } // ke9ns panadapter +96000 at 192k SR and zoom = .5 (different for spectrum display)
            set { rx_display_high2 = value; }
        }

        private static int tx_display_low2 = -4000;
        public static int TXDisplayLow2
        {
            get { return tx_display_low2; }
            set { tx_display_low2 = value; }
        }

        private static int tx_display_high2 = 4000;
        public static int TXDisplayHigh2
        {
            get { return tx_display_high2; }
            set { tx_display_high2 = value; }
        }

        //--------------------------------------------------

        private static float rx1_preamp_offset = 0.0f;
        public static float RX1PreampOffset
        {
            get { return rx1_preamp_offset; }
            set { rx1_preamp_offset = value; }
        }

        private static float rx2_preamp_offset = 0.0f;
        public static float RX2PreampOffset
        {
            get { return rx2_preamp_offset; }
            set { rx2_preamp_offset = value; }
        }

        private static float rx1_display_cal_offset;                    // display calibration offset in dB
        public static float RX1DisplayCalOffset
        {
            get { return rx1_display_cal_offset; }
            set { rx1_display_cal_offset = value; }
        }

        private static float rx2_display_cal_offset;                    // display calibration offset in dB
        public static float RX2DisplayCalOffset
        {
            get { return rx2_display_cal_offset; }
            set { rx2_display_cal_offset = value; }
        }

        private static Model current_model = Model.FLEX5000;
        public static Model CurrentModel
        {
            get { return current_model; }
            set { current_model = value; }
        }

        private static int display_cursor_x;                        // x-coord of the cursor when over the display
        public static int DisplayCursorX
        {
            get { return display_cursor_x; }
            set { display_cursor_x = value; }
        }

        private static int display_cursor_y;                        // y-coord of the cursor when over the display
        public static int DisplayCursorY
        {
            get { return display_cursor_y; }
            set { display_cursor_y = value; }
        }

        private static ClickTuneMode current_click_tune_mode = ClickTuneMode.Off;
        public static ClickTuneMode CurrentClickTuneMode
        {
            get { return current_click_tune_mode; }
            set { current_click_tune_mode = value; }
        }

        private static int scope_time = 50;
        public static int ScopeTime
        {
            get { return scope_time; }
            set { scope_time = value; }
        }

        private static int sample_rate = 48000;
        public static int SampleRate
        {
            get { return sample_rate; }
            set { sample_rate = value; }
        }

        private static bool high_swr = false;
        public static bool HighSWR
        {
            get { return high_swr; }
            set { high_swr = value; }
        }

        private static DisplayEngine current_display_engine = DisplayEngine.GDI_PLUS;
        public static DisplayEngine CurrentDisplayEngine
        {
            get { return current_display_engine; }
            set { current_display_engine = value; }
        }

        private static bool mox = false;
        public static bool MOX
        {
            get { return mox; }
            set { mox = value; }
        }

        private static DSPMode rx1_dsp_mode = DSPMode.USB;
        public static DSPMode RX1DSPMode
        {
            get { return rx1_dsp_mode; }
            set { rx1_dsp_mode = value; }
        }

        private static DSPMode rx2_dsp_mode = DSPMode.USB;
        public static DSPMode RX2DSPMode
        {
            get { return rx2_dsp_mode; }
            set { rx2_dsp_mode = value; }
        }


        public static byte continuum = 0; // ke9ns add

        public static byte autoBright4 = 0; // ke9ns add 1=rx1 in panafall or waterfall mode when RX2 ON
        public static byte autoBright5 = 0; // ke9ns add 1=rx2 in panafall or waterfall mode when RX1 ON

        public static DisplayMode current_display_mode = DisplayMode.PANADAPTER;
        public static DisplayMode CurrentDisplayMode
        {
            get { return current_display_mode; }
            set
            {
                //PrepareDisplayVars(value);

                current_display_mode = value;


                switch (current_display_mode)  //ke9ns add  (change visability of autobrightbox on console
                {

                    case DisplayMode.PANADAPTER:
                    case DisplayMode.PANAFALL:
                    case DisplayMode.WATERFALL:
                        console.autoBrightBox.Text = "Auto Wtr/Pan Lvl";
                        autoBright4 = 1;


                        break;
                    default:
                        if (continuum == 0)
                        {

                            if (autoBright5 == 0)
                            {
                                console.autoBrightBox.Text = "";
                                //  Debug.WriteLine("1off======");
                            }
                        }
                        autoBright4 = 0;
                        break;

                }


                if (current_display_mode == DisplayMode.CONTINUUM)
                {
                    continuum = 1; // ke9ns add  this is a waterfall mode where the data is MaxY txtDisplayPeakPower data from the console.
                    current_display_mode = DisplayMode.WATERFALL;

                }
                else
                {
                    continuum = 0; // ke9ns add continuum mode is off
                }



                //  Debug.WriteLine("1ab4 " + autoBright4 + " 1ab5 " + autoBright5);

                /*switch(current_display_mode)
				{
					case DisplayMode.PANADAPTER:
					case DisplayMode.WATERFALL:
						DttSP.SetPWSmode(0, 0, 1);
						DttSP.NotPan = false;
						break;
					default:
						DttSP.SetPWSmode(0, 0, 0);
						DttSP.NotPan = true;
						break;
				}*/

                switch (current_display_mode)
                {
                    case DisplayMode.PHASE2:
                        Audio.phase = true;
                        break;
                    default:
                        Audio.phase = false;
                        break;
                }

                if (average_on) ResetRX1DisplayAverage();
                if (peak_on) ResetRX1DisplayPeak();

                DrawBackground();
            }

        } // DisplayMode CurrentDisplayMode

        private static float max_x;                             // x-coord of maxmimum over one display pass
        public static float MaxX
        {
            get { return max_x; }
            set { max_x = value; }
        }

        static int MaxYLast = 0; // ke9ns add for continuum mode
        private static float max_y;                             // y-coord of maxmimum over one display pass
        public static float MaxY
        {
            get { return max_y; }
            set { max_y = value; }
        }

        private static bool average_on;                         // True if the Average button is pressed
        public static bool AverageOn // ke9ns:  Display.AverageOn = chkDisplayAVG.Checked; // Tell display avg is turned on or off
        {
            get { return average_on; }
            set
            {
                average_on = value;
                if (!average_on) ResetRX1DisplayAverage();
            }
        }

        private static bool rx2_avg_on;
        public static bool RX2AverageOn
        {
            get { return rx2_avg_on; }
            set
            {
                rx2_avg_on = value;
                if (!rx2_avg_on) ResetRX2DisplayAverage();
            }
        }

        private static bool peak_on;                            // True if the Peak button is pressed
        public static bool PeakOn
        {
            get { return peak_on; }
            set
            {
                peak_on = value;
                if (!peak_on) ResetRX1DisplayPeak();
            }
        }

        private static bool rx2_peak_on;
        public static bool RX2PeakOn
        {
            get { return rx2_peak_on; }
            set
            {
                rx2_peak_on = value;
                if (!rx2_peak_on) ResetRX2DisplayPeak();
            }
        }

        private static bool data_ready;                 // True when there is new display data ready from the DSP
        public static bool DataReady
        {
            get { return data_ready; }
            set { data_ready = value; }
        }

        private static bool data_ready_bottom;
        public static bool DataReadyBottom
        {
            get { return data_ready_bottom; }
            set { data_ready_bottom = value; }
        }

        public static float display_avg_mult_old = 1 - (float)1 / 5; // .8
        public static float display_avg_mult_new = (float)1 / 5;      // .2
        private static int display_avg_num_blocks = 5;

        public static int DisplayAvgBlocks   // ke9ns = (avgtime * .001)/(1/fps)  = 4 for my settings 
        {
            get { return display_avg_num_blocks; }
            set
            {
                display_avg_num_blocks = value;
                display_avg_mult_old = 1 - (float)1 / display_avg_num_blocks;   // ke9ns   =  .75
                display_avg_mult_new = (float)1 / display_avg_num_blocks;     // ke9ns = .25

                // old + new must always equal 1.0

            
            }
        }



        public static float waterfall_avg_mult_old = 1 - (float)1 / 18;  // ke9ns ?
        public static float waterfall_avg_mult_new = (float)1 / 18;
        private static int waterfall_avg_num_blocks = 18;
        public static int WaterfallAvgBlocks
        {
            get { return waterfall_avg_num_blocks; }
            set
            {
                waterfall_avg_num_blocks = value;
                waterfall_avg_mult_old = 1 - (float)1 / waterfall_avg_num_blocks;
                waterfall_avg_mult_new = (float)1 / waterfall_avg_num_blocks;
            }
        }



        private static int spectrum_grid_max1 = 0; // ke9ns add to adjust grid during transmit (this is just a holder of the original value to put back when done transmitting)
        private static int spectrum_grid_max = 0;
        public static int SpectrumGridMax
        {
            get { return spectrum_grid_max; }
            set
            {
                spectrum_grid_max1 = spectrum_grid_max = value;
                DrawBackground();
            }
        }


        private static int spectrum_grid_min1 = -160; // ke9ns add
        private static int spectrum_grid_min = -160;
        public static int SpectrumGridMin
        {
            get { return spectrum_grid_min; }
            set
            {
                spectrum_grid_min1 = spectrum_grid_min = value;
                DrawBackground();
            }
        }
        private static int spectrum_grid_step1 = 10;
        private static int spectrum_grid_step = 10;
        public static int SpectrumGridStep
        {
            get { return spectrum_grid_step; }
            set
            {
                spectrum_grid_step1 = spectrum_grid_step = value;
                DrawBackground();
            }
        }

        private static Color grid_text_color = Color.Yellow;
        public static Color GridTextColor
        {
            get { return grid_text_color; }
            set
            {
                grid_text_color = value;
                DrawBackground();
            }
        }

        private static Color grid_zero_color = Color.Red; // ke9ns this is the 0hz red line
        public static Color GridZeroColor
        {
            get { return grid_zero_color; }
            set
            {
                grid_zero_color = value;
                DrawBackground();
            }
        }

        private static Color grid_color = Color.Purple;
        public static Color GridColor
        {
            get { return grid_color; }
            set
            {
                grid_color = value;
                DrawBackground();
            }
        }


        private static Color BT_color = Color.Purple;
        public static Color BandTextColor
        {
            get { return BT_color; }
            set
            {
                BT_color = value;

            }
        }

        private static Pen data_line_pen = new Pen(new SolidBrush(Color.White), display_line_width);

        private static Color temp = Color.Aquamarine;
        public static int Pan3DSteps = 29;
        public static int Pan3DAlphaStep = (int)((255f / (float)Pan3DSteps) + .5f);



        private static Pen data_3dline_pen30 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 29), temp), display_line_width);
        private static Pen data_3dline_pen29 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 28), temp), display_line_width);
        private static Pen data_3dline_pen28 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 27), temp), display_line_width);
        private static Pen data_3dline_pen27 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 26), temp), display_line_width);
        private static Pen data_3dline_pen26 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 25), temp), display_line_width);
        private static Pen data_3dline_pen25 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 24), temp), display_line_width);
        private static Pen data_3dline_pen24 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 23), temp), display_line_width);
        private static Pen data_3dline_pen23 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 22), temp), display_line_width);
        private static Pen data_3dline_pen22 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 21), temp), display_line_width);
        private static Pen data_3dline_pen21 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 20), temp), display_line_width);
        private static Pen data_3dline_pen20 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 19), temp), display_line_width);

        private static Pen data_3dline_pen19 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 18), temp), display_line_width);
        private static Pen data_3dline_pen18 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 17), temp), display_line_width);
        private static Pen data_3dline_pen17 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 16), temp), display_line_width);
        private static Pen data_3dline_pen16 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 15), temp), display_line_width);
        private static Pen data_3dline_pen15 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 14), temp), display_line_width);
        private static Pen data_3dline_pen14 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 13), temp), display_line_width);
        private static Pen data_3dline_pen13 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 12), temp), display_line_width);
        private static Pen data_3dline_pen12 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 11), temp), display_line_width);
        private static Pen data_3dline_pen11 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 10), temp), display_line_width);
        private static Pen data_3dline_pen10 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 9), temp), display_line_width);
        private static Pen data_3dline_pen9 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 8), temp), display_line_width);
        private static Pen data_3dline_pen8 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 7), temp), display_line_width);
        private static Pen data_3dline_pen7 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 6), temp), display_line_width);
        private static Pen data_3dline_pen6 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 5), temp), display_line_width);
        private static Pen data_3dline_pen5 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 4), temp), display_line_width);
        private static Pen data_3dline_pen4 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 3), temp), display_line_width);
        private static Pen data_3dline_pen3 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 2), temp), display_line_width);
        private static Pen data_3dline_pen2 = new Pen(Color.FromArgb(Pan3DAlphaStep * (Pan3DSteps - 1), temp), display_line_width);


        private static Pen IDENT_pen = new Pen(new SolidBrush(Color.PaleGreen), 1); // ke9ns add
        private static Pen IDENT_pen2 = new Pen(new SolidBrush(Color.PaleGoldenrod), 1); // ke9ns add
        private static Pen IDENT_pen3 = new Pen(new SolidBrush(Color.PaleVioletRed), 1); // ke9ns add

        private static Font IDENT_Font = new System.Drawing.Font("Arial", 12, FontStyle.Bold);// ke9ns add
        private static SolidBrush IDENT_Brush = new SolidBrush(Color.PaleVioletRed); // ke9ns add

        private static Color data_line_color = Color.White;
        private static Color data_3Dline_color = Color.Aquamarine;
        private static int data_3Dline_Alpha = 100;

        public static int Data3DLineAlpha
        {
            get { return data_3Dline_Alpha; }
            set
            {
                if (value >= 0 && value <= 255) data_3Dline_Alpha = value;
                else data_3Dline_Alpha = 100;

            }
        }
        public static Color Data3DLineColor
        {
            get { return data_3Dline_color; }
            set
            {

                data_3Dline_color = value;
                Pan3DSteps = 23;
                Pan3DAlphaStep = (int)(((float)data_3Dline_Alpha / (float)Pan3DSteps) + .5f);

                int[] Alpha3D = new int[Pan3DSteps + 10];

                for (int ww = 0; ww < Pan3DSteps; ww++)
                {
                    Alpha3D[ww] = Pan3DAlphaStep * (Pan3DSteps - ww);


                }


                data_3dline_pen30 = new Pen(Color.FromArgb(Alpha3D[29], data_3Dline_color), display_line_width);
                data_3dline_pen29 = new Pen(Color.FromArgb(Alpha3D[28], data_3Dline_color), display_line_width);
                data_3dline_pen28 = new Pen(Color.FromArgb(Alpha3D[27], data_3Dline_color), display_line_width);
                data_3dline_pen27 = new Pen(Color.FromArgb(Alpha3D[26], data_3Dline_color), display_line_width);
                data_3dline_pen26 = new Pen(Color.FromArgb(Alpha3D[25], data_3Dline_color), display_line_width);
                data_3dline_pen25 = new Pen(Color.FromArgb(Alpha3D[24], data_3Dline_color), display_line_width);
                data_3dline_pen24 = new Pen(Color.FromArgb(Alpha3D[23], data_3Dline_color), display_line_width);
                data_3dline_pen23 = new Pen(Color.FromArgb(Alpha3D[22], data_3Dline_color), display_line_width);
                data_3dline_pen22 = new Pen(Color.FromArgb(Alpha3D[21], data_3Dline_color), display_line_width);
                data_3dline_pen21 = new Pen(Color.FromArgb(Alpha3D[20], data_3Dline_color), display_line_width);
                data_3dline_pen20 = new Pen(Color.FromArgb(Alpha3D[19], data_3Dline_color), display_line_width);

                data_3dline_pen19 = new Pen(Color.FromArgb(Alpha3D[18], data_3Dline_color), display_line_width);
                data_3dline_pen18 = new Pen(Color.FromArgb(Alpha3D[17], data_3Dline_color), display_line_width);
                data_3dline_pen17 = new Pen(Color.FromArgb(Alpha3D[16], data_3Dline_color), display_line_width);
                data_3dline_pen16 = new Pen(Color.FromArgb(Alpha3D[15], data_3Dline_color), display_line_width);
                data_3dline_pen15 = new Pen(Color.FromArgb(Alpha3D[14], data_3Dline_color), display_line_width);
                data_3dline_pen14 = new Pen(Color.FromArgb(Alpha3D[13], data_3Dline_color), display_line_width);
                data_3dline_pen13 = new Pen(Color.FromArgb(Alpha3D[12], data_3Dline_color), display_line_width);
                data_3dline_pen12 = new Pen(Color.FromArgb(Alpha3D[11], data_3Dline_color), display_line_width);
                data_3dline_pen11 = new Pen(Color.FromArgb(Alpha3D[10], data_3Dline_color), display_line_width);
                data_3dline_pen10 = new Pen(Color.FromArgb(Alpha3D[9], data_3Dline_color), display_line_width);
                data_3dline_pen9 = new Pen(Color.FromArgb(Alpha3D[8], data_3Dline_color), display_line_width);
                data_3dline_pen8 = new Pen(Color.FromArgb(Alpha3D[7], data_3Dline_color), display_line_width);
                data_3dline_pen7 = new Pen(Color.FromArgb(Alpha3D[6], data_3Dline_color), display_line_width);
                data_3dline_pen6 = new Pen(Color.FromArgb(Alpha3D[5], data_3Dline_color), display_line_width);
                data_3dline_pen5 = new Pen(Color.FromArgb(Alpha3D[4], data_3Dline_color), display_line_width);
                data_3dline_pen4 = new Pen(Color.FromArgb(Alpha3D[3], data_3Dline_color), display_line_width);
                data_3dline_pen3 = new Pen(Color.FromArgb(Alpha3D[2], data_3Dline_color), display_line_width);
                data_3dline_pen2 = new Pen(Color.FromArgb(Alpha3D[1], data_3Dline_color), display_line_width);

                DrawBackground();

            }
        } // set 3D color


        public static Color DataLineColor
        {
            get { return data_line_color; }
            set
            {
                data_line_color = value;
                data_line_pen = new Pen(new SolidBrush(data_line_color), display_line_width);

                DrawBackground();
            }
        }

        private static Color display_filter_color = Color.FromArgb(65, 255, 255, 255);
        public static Color DisplayFilterColor
        {
            get { return display_filter_color; }
            set
            {
                display_filter_color = value;
                DrawBackground();
            }
        }

        // ke9ns add for panadapter fill color and alpha
        private static Color display_pan_color = Color.FromArgb(70, Color.White);
        public static Color DisplayPanFillColor
        {
            get { return display_pan_color; }
            set
            {
                display_pan_color = value;
                DrawBackground();
            }
        }

        // ke9ns add for panadapter fill color and alpha
        private static int panfillalpha = 150;

        public static int PanFillAlpha
        {
            get { return panfillalpha; }
            set
            {
                panfillalpha = value;

            }
        }

        //  Display.DisplayPanFillColor = Color.FromArgb(tbPanAlpha.Value, clrbtnPan.Color); // ke9ns  combine color and alpha here

        // ke9ns add for Pan Fill Gradient color (instead of just 1 color)
        private static bool panfillgradient = false; // underfill is gradient color
        public static bool PanFillGradient
        {
            get { return panfillgradient; }
            set
            {
                panfillgradient = value;

            }
        }



        // ke9ns add  autobright                        helper to keep thread safe
        private static int wateroffset = 20;
        public static int WATEROFFSET
        {
            get { return wateroffset; }
            set
            {
                wateroffset = value;

            }
        }

        // ke9ns add autobright  
        private static int gridoffset = 20;
        public static int GRIDOFFSET
        {
            get { return gridoffset; }
            set
            {
                gridoffset = value;

            }
        }



        private static Color display_filter_tx_color = Color.Yellow;
        public static Color DisplayFilterTXColor
        {
            get { return display_filter_tx_color; }
            set
            {
                display_filter_tx_color = value;
                DrawBackground();
            }
        }

        private static bool draw_tx_filter = false;
        public static bool DrawTXFilter
        {
            get { return draw_tx_filter; }
            set
            {
                draw_tx_filter = value;
                DrawBackground();
            }
        }

        private static bool draw_tx_cw_freq = false;
        public static bool DrawTXCWFreq
        {
            get { return draw_tx_cw_freq; }
            set
            {
                draw_tx_cw_freq = value;
                DrawBackground();
            }
        }

        private static Color display_background_color = Color.Black;
        public static Color DisplayBackgroundColor
        {
            get { return display_background_color; }
            set
            {
                display_background_color = value;
                DrawBackground();
            }
        }

        private static Color waterfall_low_color = Color.Black;
        public static Color WaterfallLowColor
        {
            get { return waterfall_low_color; }
            set { waterfall_low_color = value; }
        }

        private static Color waterfall_mid_color = Color.Red;
        public static Color WaterfallMidColor
        {
            get { return waterfall_mid_color; }
            set { waterfall_mid_color = value; }
        }

        private static Color waterfall_high_color = Color.Yellow;
        public static Color WaterfallHighColor
        {
            get { return waterfall_high_color; }
            set { waterfall_high_color = value; }
        }

        private static float waterfall_high_threshold = -80.0F;
        public static float WaterfallHighThreshold
        {
            get { return waterfall_high_threshold; }
            set { waterfall_high_threshold = value; }
        }

        private static float waterfall_low_threshold = -130.0F;
        public static float WaterfallLowThreshold
        {
            get { return waterfall_low_threshold; }
            set { waterfall_low_threshold = value; }


        }

        private static float waterfall_lowRX2_threshold = -130.0F; // ke9ns ADD for RX2
        public static float WaterfallLowRX2Threshold
        {
            get { return waterfall_lowRX2_threshold; }
            set { waterfall_lowRX2_threshold = value; }
        }

        private static float waterfall_lowMic_threshold = -100.0F; //  ke9ns ADD
        public static float WaterfallLowMicThreshold
        {
            get { return waterfall_lowMic_threshold; }
            set { waterfall_lowMic_threshold = value; }
        }

        //================================================================
        // ke9ns add signal from console about Grayscale ON/OFF
        private static byte Gray_Scale = 0; //  ke9ns ADD from console 0=RGB  1=Gray
        public static byte GrayScale       // this is called or set in console
        {
            get { return Gray_Scale; }
            set
            {
                Gray_Scale = value;
            } // set
        } // grayscale


        //================================================================
        // kes9ns add signal from setup grid lines on/off
        private static byte grid_off = 0; //  ke9ns ADD from setup 0=normal  1=gridlines off
        public static byte GridOff       // this is called or set in setup
        {
            get { return grid_off; }
            set
            {
                grid_off = value;
            } // set

        } // grid_off


        //================================================================
        //ke9ns 1=automatic bright adjustment (takes a snapshot of the overall avg and adjust RX1 and RX2 Low threshold for proper value, every time you push the button.)
        //      request comes from console.
        private static byte autobright = 0; //  ke9ns ADD: from console rx1 waterfall bright adjust
        private static byte autobright2 = 0; //  ke9ns ADD: from console rx2 waterfall bright adjust
        private static byte autobright3 = 0; //  ke9ns ADD: from console TX waterfall bright adjust 1=adjust tx waterfall brightness
        private static byte autobright6 = 0; //  ke9ns ADD: from console rx1 panadapter bright adjust 2=rx1 adjust
        private static byte autobright7 = 0; //  ke9ns ADD: from console rx1 panadapter ZOOM scale adjust (for small signal or standard signal)


        public static byte AutoBright       // this is called or set in console 1=adjust waterfall, 2=adjust Pan level, 3=adjust Pan scale (small signal), 4=adjust Pan scale (standard)
        {
            get { return autobright; }
            set
            {
                if (mox)
                {
                    autobright3 = 1;   // ke9ns: TX water adjust
                    autobright = autobright2 = 0;
                }
                else
                {
                    autobright3 = 0;


                    if ((console.chkPower.Checked) && ((current_display_mode == DisplayMode.PANADAPTER) || (current_display_mode == DisplayMode.PANAFALL) || (current_display_mode == DisplayMode.PANAFALL8020)))// PANADAPTER
                    {
                        if (value == 2)
                        {
                            autobright6 = value; // RX1 adjust 
                            return;
                        }
                        else if (value == 3) // ZOOM
                        {
                            autobright7 = value; // RX1 adjust small signal scale
                            return;
                        }
                        else if (value == 4) // UNZOOM
                        {
                            AB_Peak = -200;
                            AB_Count = 0;
                            AB_Total = 0;
                            autobright7 = value; // RX1 adjust standard signal scale
                            return;
                        }
                        else // = 1
                        {
                            autobright7 = 0;
                            autobright6 = 0;
                        }
                    }

                    if ((console.chkPower.Checked) && ((current_display_mode == DisplayMode.WATERFALL) || (current_display_mode == DisplayMode.PANAFALL)))
                    {

                        autobright = value; // RX1 adjust
                    }
                    else autobright = 0;

                    if ((console.chkRX2.Checked) && ((current_display_mode_bottom == DisplayMode.WATERFALL) || (current_display_mode_bottom == DisplayMode.PANAFALL)))
                    {

                        autobright2 = value;   // RX2 adjust
                    }
                    else autobright2 = 0;


                } // RX mode above

                //   Debug.WriteLine("hereasdfadsf===========");

            } // set

        } // autobright


        //================================================================
        // signal from console about wider watermove ON/OFF
        private static byte wm = 0; //  ke9ns ADD from console 0=RGB  1=Gray
        public static byte WMS       // this is called or set in console
        {
            get { return wm; }
            set
            {
                if (value == 1)
                {
                    WaterMove = 5;
                    WaterMove1 = 2;
                    K9LAST = 0;

                    PWaterMove = 5;
                    PWaterMove1 = 2;

                }
                else
                {
                    WaterMove = 3;
                    WaterMove1 = 1;
                    K9LAST = 0;

                    PWaterMove = 3;
                    PWaterMove1 = 1;

                }


            } // set
        } // watermove

        //================================================================
        // signal from console chkPower switch ON/OFF
        private static byte DP = 0; //  ke9ns ADD  0=OFF, 1=ON
        public static byte Power           // this is called or set in console
        {
            get { return DP; }
            set
            {
                DP = value;

            } // set
        } // Power

        //================================================================
        // signal from console waterfall ID transmit
        //    private static byte TX_ID = 0; //  ke9ns ADD from console 0=off  1=TX
        //   public static byte TXID            // this is called or set in console
        //  {
        //  get { return TX_ID; }
        //  set
        //  {
        //   TX_ID = value;

        //  } // set
        //  } // tx id

        //================================================================
        // RX1 signal from console if "Panafall Mode" AVG mode  ( 0=no panafall mode and/or avg ON waterfall if its on panadater, 1=panafall mode and avg off in waterfall)
        private static byte pw_avg = 0; //  ke9ns ADD 
        public static byte PW_AVG  // this is called or set in console
        {
            get { return pw_avg; }
            set
            {
                pw_avg = value;

            } // set
        } // pw_avg

        //================================================================
        // RX2 signal from console if "Panafall Mode" AVG mode 
        private static byte pw_avg2 = 0; //  ke9ns ADD 
        public static byte PW_AVG2  // this is called or set in console
        {
            get { return pw_avg2; }
            set
            {
                pw_avg2 = value;

            } // set
        } // pw_avg2


        private static float display_line_width = 1.0F;
        public static float DisplayLineWidth
        {
            get { return display_line_width; }
            set
            {
                display_line_width = value;
                data_line_pen = new Pen(new SolidBrush(data_line_color), display_line_width);
            }
        }

        private static DisplayLabelAlignment display_label_align = DisplayLabelAlignment.LEFT;
        public static DisplayLabelAlignment DisplayLabelAlign
        {
            get { return display_label_align; }
            set
            {
                display_label_align = value;
                DrawBackground();
            }
        }

        private static int phase_num_pts = 100;
        public static int PhaseNumPts
        {
            get { return phase_num_pts; }
            set { phase_num_pts = value; }
        }

        #endregion

        #region General Routines



        public static void Init()
        {
            histogram_data = new int[W];
            histogram_history = new int[W];
            for (int i = 0; i < W; i++)
            {
                histogram_data[i] = Int32.MaxValue;
                histogram_history[i] = 0;
            }

            //display_bmp = new Bitmap(W, H);
            //display_graphics = Graphics.FromImage(display_bmp);


            //    waterfall_bmp = new Bitmap(W, H/K15 - 16, PixelFormat.Format24bppRgb);  // initialize waterfall display
            //    waterfall_bmp2 = new Bitmap(W, H/K15 - 16, PixelFormat.Format24bppRgb);  // ke9ns BMP

            if (WaterMove == 0)
            {
                waterfall_bmp = new Bitmap(W, H / K15 - 16, WtrColor);  // initialize waterfall display
                waterfall_bmp2 = new Bitmap(W, H / K15 - 16, WtrColor);  // ke9ns BMP
            }
            else if (continuum == 1)
            {
                waterfall_bmp = new Bitmap(W, H / K15 - 16, WtrColor);  // initialize waterfall display for continuum
                waterfall_bmp2 = new Bitmap(W * WaterMove, H / K15 - 16, WtrColor);  // was *3 ke9ns BMP

            }
            else
            {
                waterfall_bmp = new Bitmap(W * WaterMove, H / K15 - 16, WtrColor);  // was *3 initialize waterfall display
                waterfall_bmp2 = new Bitmap(W * WaterMove, H / K15 - 16, WtrColor);  // was *3 ke9ns BMP

                //   waterfall_bmp.MakeTransparent(Color.FromArgb(0,0, 0, 0)); // ke9ns test


            }

            // BUFFER_SIZE was always 4096, now can be switched (setupForm.chkSpectrumHiRes)

            rx1_average_buffer = new float[BUFFER_SIZE];    // initialize averaging buffer array
            rx1_average_buffer[0] = CLEAR_FLAG;     // set the clear flag

            rx2_average_buffer = new float[BUFFER_SIZE];    // initialize averaging buffer array
            rx2_average_buffer[0] = CLEAR_FLAG;     // set the clear flag

            rx1_peak_buffer = new float[BUFFER_SIZE];
            rx1_peak_buffer[0] = CLEAR_FLAG;

            rx2_peak_buffer = new float[BUFFER_SIZE];
            rx2_peak_buffer[0] = CLEAR_FLAG;



            //background_image_mutex = new Mutex(false);

            PAN_DATA = new float[Display.BUFFER_SIZE];   // ke9ns add: .183

            PAN_DATA2 = new float[Display.BUFFER_SIZE];   // ke9ns add: .219

            new_display_data = new float[BUFFER_SIZE]; // 
            current_display_data = new float[BUFFER_SIZE];
            current_display_data1 = new float[BUFFER_SIZE];  // ke9ns add
            new_display_data_bottom = new float[BUFFER_SIZE];
            current_display_data_bottom = new float[BUFFER_SIZE];
            current_display_data_bottom1 = new float[BUFFER_SIZE]; // ke9ns add

            for (int i = 0; i < BUFFER_SIZE; i++) // fill the buffer with base data
            {
                new_display_data[i] = -200.0f;
                current_display_data1[i] = -200.0f;// ke9ns add
                current_display_data[i] = -200.0f;
                new_display_data_bottom[i] = -200.0f;
                current_display_data_bottom1[i] = -200.0f;// ke9ns add
                current_display_data_bottom[i] = -200.0f;
            }





            /*if(!DirectXInit()) console.SetupForm.DirectX = false;
			if(current_display_engine != DisplayEngine.DIRECT_X)
				DirectXRelease();*/

            channels_60m = new List<Channel>();



            switch (console.CurrentRegion)
            {
                case FRSRegion.UK_Plus:
                    /* channels_60m.Add(new Channel(5.2600, 2800));
                    channels_60m.Add(new Channel(5.2800, 2800));
                    channels_60m.Add(new Channel(5.2900, 2800));
                    channels_60m.Add(new Channel(5.3680, 2800));
                    channels_60m.Add(new Channel(5.3730, 2800));
                    channels_60m.Add(new Channel(5.4000, 2800));
                    channels_60m.Add(new Channel(5.4050, 2800));
                    */
                    break;
                //  5.351500, 5.335999, "60M 200hz Narrow Band Modes",    true,
                //          5.354000, 5.356999, "60M USB Voice",            true,
                //          5.357000, 5.359999, "60M USB Voice (US CH 3)",  true,
                //         5.360000, 5.362999, "60M USB Voice",            true,
                //          5.363000, 5.365999, "60M USB Voice",            true,
                //         5.366000, 5.366500, "60M 20hz Narrow Band Modes",    true,

                case FRSRegion.US:


                    channels_60m.Add(new Channel(5.1690, 2800)); // ke9ns emergency only   5.1675

                    channels_60m.Add(new Channel(5.3320, 2800)); // channel 1   5.3305
                    channels_60m.Add(new Channel(5.3480, 2800)); // channel 2   5.3465
                    channels_60m.Add(new Channel(5.3585, 2800)); // channel 3   5.3570 
                    channels_60m.Add(new Channel(5.3730, 2800)); // channel 4   5.3715
                    channels_60m.Add(new Channel(5.4050, 2800)); // channel 5   5.4035




                    break;

                default:
                    /*
                    channels_60m.Add(new Channel(5.3320, 2800));
                    channels_60m.Add(new Channel(5.3480, 2800));
                    channels_60m.Add(new Channel(5.3585, 2800));
                    channels_60m.Add(new Channel(5.3730, 2800));
                    channels_60m.Add(new Channel(5.4050, 2800));
                     */
                    break;
            } //  switch (console.CurrentRegion)



            // draw channels for all regions for common are

            channels_60m.Add(new Channel(26.9600, 6000)); // channel 1 cb  AM +/- 3khz
            channels_60m.Add(new Channel(26.9700, 6000)); // channel 2 cb
            channels_60m.Add(new Channel(26.9800, 6000)); // channel 3 cb
            channels_60m.Add(new Channel(27.0000, 6000)); // channel 4 cb
            channels_60m.Add(new Channel(27.0100, 6000)); // channel 5 cb
            channels_60m.Add(new Channel(27.0200, 6000)); // channel 6 cb
            channels_60m.Add(new Channel(27.0300, 6000)); // channel 7 cb
            channels_60m.Add(new Channel(27.0500, 6000)); // channel 8 cb
            channels_60m.Add(new Channel(27.0600, 6000)); // channel 9 cb
			
            channels_60m.Add(new Channel(27.0700, 6000)); // channel 10 cb
            channels_60m.Add(new Channel(27.0800, 6000)); // channel 11 cb
            channels_60m.Add(new Channel(27.1000, 6000)); // channel 12 cb
            channels_60m.Add(new Channel(27.1100, 6000)); // channel 13 cb
            channels_60m.Add(new Channel(27.1200, 6000)); // channel 14 cb
            channels_60m.Add(new Channel(27.1300, 6000)); // channel 15 cb

            channels_60m.Add(new Channel(27.1500, 6000)); // channel 16 cb
            channels_60m.Add(new Channel(27.1600, 6000)); // channel 17 cb
            channels_60m.Add(new Channel(27.1700, 6000)); // channel 18 cb
            channels_60m.Add(new Channel(27.1800, 6000)); // channel 19 cb
            channels_60m.Add(new Channel(27.2000, 6000)); // channel 20 cb
            channels_60m.Add(new Channel(27.2100, 6000)); // channel 21 cb

            channels_60m.Add(new Channel(27.2200, 6000)); // channel 22 cb

            channels_60m.Add(new Channel(27.2300, 6000)); // channel 24 cb
            channels_60m.Add(new Channel(27.2400, 6000)); // channel 25 cb

            channels_60m.Add(new Channel(27.2500, 6000)); // channel 23 cb

            channels_60m.Add(new Channel(27.2600, 6000)); // channel 26 cb
            channels_60m.Add(new Channel(27.2700, 6000)); // channel 27 cb

            channels_60m.Add(new Channel(27.2800, 6000)); // channel 28 cb
            channels_60m.Add(new Channel(27.2900, 6000)); // channel 29 cb
            channels_60m.Add(new Channel(27.3000, 6000)); // channel 30 cb
            channels_60m.Add(new Channel(27.3100, 6000)); // channel 31 cb
            channels_60m.Add(new Channel(27.3200, 6000)); // channel 32 cb
            channels_60m.Add(new Channel(27.3300, 6000)); // channel 33 cb

            channels_60m.Add(new Channel(27.3400, 6000)); // channel 34 cb
            channels_60m.Add(new Channel(27.3500, 6000)); // channel 35 cb
            channels_60m.Add(new Channel(27.3600, 6000)); // channel 36 cb
            channels_60m.Add(new Channel(27.3700, 6000)); // channel 37 cb
            channels_60m.Add(new Channel(27.3800, 6000)); // channel 38 cb
            channels_60m.Add(new Channel(27.3900, 6000)); // channel 39 cb
            channels_60m.Add(new Channel(27.4000, 6000)); // channel 40 cb

        } // init()

        // ke9ns add


        public static void DrawBackground()
        {
            // draws the background image for the display based
            // on the current selected display mode.

            if (current_display_engine == DisplayEngine.GDI_PLUS)
            {
                /*switch(current_display_mode)
				{
					case DisplayMode.SPECTRUM:
						DrawSpectrumGrid(ref background_bmp, W, H);
						break;
					case DisplayMode.PANADAPTER:
						DrawPanadapterGrid(ref background_bmp, W, H);
						break;
					case DisplayMode.SCOPE:
						DrawScopeGrid(ref background_bmp, W, H);
						break;
					case DisplayMode.PHASE:
						DrawPhaseGrid(ref background_bmp, W, H);
						break;	
					case DisplayMode.PHASE2:
						DrawPhaseGrid(ref background_bmp, W, H);
						break;
					case DisplayMode.WATERFALL:
						DrawWaterfallGrid(ref background_bmp, W, H);
						break;
					case DisplayMode.HISTOGRAM:
						DrawSpectrumGrid(ref background_bmp, W, H);
						break;
					case DisplayMode.OFF:
						DrawOffBackground(ref background_bmp, W, H);
						break;
					default:
						break;
				}
*/
                target.Invalidate();
            }
            /*else if(current_display_engine == DisplayEngine.DIRECT_X)
			{
				switch(current_display_mode)
				{
					case DisplayMode.SPECTRUM:
						current_background = SetupSpectrum();
						break;
					case DisplayMode.PANADAPTER:
						break;
					case DisplayMode.SCOPE:
						current_background = SetupScope();
						break;
					case DisplayMode.PHASE:
						break;	
					case DisplayMode.PHASE2:
						break;
					case DisplayMode.WATERFALL:
						break;
					case DisplayMode.HISTOGRAM:
						break;
					case DisplayMode.OFF:
						break;
					default:
						break;
				}				
				
				// redraw screen now if not starting up and if in standby
				//if(console.SetupForm != null && !console.PowerOn) RenderDirectX();
			}*/
        } // drawbackground

#if (!NO_TNF)
        // This draws a little callout on the notch to show it's frequency and bandwidth
        // xlimit is the right side of the picDisplay

        static Color c = Color.DarkOliveGreen;
        static Pen p = new Pen(Color.DarkOliveGreen, 1);
        static Brush b = new SolidBrush(Color.Chartreuse);

        private static void drawNotchStatus(Graphics g, Notch n, int x, int y, int x_limit, int height)
        {

            // if we're not supposed to be drawing this, return to caller
            if (!n.Details) return;
            // in case notch is showing on RX1 & RX2, just show it for the one that was clicked
            if ((y < height && n.RX == 2) || (y > height && n.RX == 1)) return;
            // first we need to test if it is OK to draw the box to the right of the notch ... I don't
            // know the panadapter limits in x, so I will use a constant.  This needs to be replaced
            int x_distance_from_notch = 40;
            int y_distance_from_bot = 20;
            int box_width = 120;
            int box_height = 55;
            int x_start, y_start, x_pin, y_pin;
            // determine if it will fit in the panadapter to the right of the notch
            if (x + box_width + x_distance_from_notch > x_limit)
            {
                // draw to the left
                x_pin = x - x_distance_from_notch;
                y_pin = y - y_distance_from_bot;
                x_start = x_pin - box_width;
                y_start = y_pin - (box_height / 2);
            }
            else
            {
                // draw to the right
                x_start = x + x_distance_from_notch;
                x_pin = x_start;
                y_pin = y - y_distance_from_bot;
                y_start = y_pin - (box_height / 2);
            }

            // such pretty colors of green, hardcoded for your viewing pleasure

            //  Color c = Color.DarkOliveGreen;
            //   Pen p = new Pen(Color.DarkOliveGreen, 1);
            //   Brush b = new SolidBrush(Color.Chartreuse);

            // Draw a nice rectangle to write into
            g.FillRectangle(new SolidBrush(c), x_start, y_start, box_width, box_height);
            // draw a left and right line on the side of the rectancle
            g.DrawLine(p, x, y, x_pin, y_pin);
            // get the Hz part of the frequency because we want to set it off from the actual number so it looks neato
            int right_three = (int)(n.Freq * 1e6) - (int)(n.Freq * 1e3) * 1000;
            double left_three = (((int)(n.Freq * 1e3)) / 1e3);
            //string perm = n.Permanent ? "*" : "";
            g.DrawString("RF Tracking Notch", // + perm,
                new Font("Trebuchet MS", 9, FontStyle.Underline),
                b, new Point(x_start + 5, y_start + 5));
            g.DrawString(left_three.ToString("f3") + " " + right_three.ToString("d3") + " MHz",
                new Font("Trebuchet MS", 9, FontStyle.Regular),
                b, new Point(x_start + 5, y_start + 20));
            g.DrawString(n.BW.ToString("d") + " Hz wide",
                new Font("Trebuchet MS", 9, FontStyle.Regular),
                b, new Point(x_start + 5, y_start + 35));
        }

        /// <summary>
        /// draws the vertical bar to highlight where a notch is on the panadapter
        /// </summary>
        /// <param name="g">Graphics object reference</param>
        /// <param name="n">Notch object reference</param>
        /// <param name="left">left side of notch in pixel location</param>
        /// <param name="right">right side of notch, pixel location</param>
        /// <param name="top">top of bar</param>
        /// <param name="H">height of bar</param>
        /// <param name="on">color for notch on</param>
        /// <param name="off">color for notch off</param>
        /// <param name="highlight">highlight color to draw highlights on bar</param>
        /// <param name="active">true if notches are turned on</param>
        static void drawNotchBar(Graphics g, Notch n, int left, int right, int top, int height, Color c, Color h)
        {
            int width = right - left;
            int hash_spacing_pixels = 1;
            switch (n.Depth)
            {
                case 1:
                    hash_spacing_pixels = 12;
                    break;
                case 2:
                    hash_spacing_pixels = 8;
                    break;
                case 3:
                    hash_spacing_pixels = 4;
                    break;
            }

            // get a purty pen to draw with 
            Pen p = new Pen(h, 1);

            // shade in the notch
            g.FillRectangle(new SolidBrush(c), left, top, width, height);

            // draw a left and right line on the side of the rectancle if wide enough
            if (width > 2 && tnf_active)
            {
                g.DrawLine(p, left, top, left, top + height - 1);
                g.DrawLine(p, right, top, right, top + height - 1);

                // first draw down left side of notch indicator horizontal lines -- a series of 45-degree hashes
                for (int y = top + hash_spacing_pixels; y < top + height - 1 + width; y += hash_spacing_pixels)
                {
                    int start_y = y;
                    int start_x = left;
                    int end_x = right;
                    int end_y = start_y - width;

                    int min_y = top;
                    int _max_y = top + height - 1;

                    // if we are about to over-draw past the top of the rectangle, we must restrain ourselves!
                    if (end_y < min_y)
                    {
                        end_x -= (min_y - end_y);
                        end_y = top;
                    }

                    // if we are about to over-draw past the bottom of the rectangle, we must restrain ourselves!
                    if (start_y > _max_y)
                    {
                        start_x += (start_y - _max_y);
                        start_y = _max_y;
                    }

                    g.DrawLine(p, start_x, start_y, end_x, end_y);
                }
            }
        }
#endif
        /// <summary>
        /// draws the vertical bar to highlight where a channel is on the panadapter
        /// </summary>
        /// <param name="g">Graphics object reference</param>
        /// <param name="n">Channel object reference</param>
        /// <param name="left">left side of notch in pixel location</param>
        /// <param name="right">right side of notch, pixel location</param>
        /// <param name="top">top of bar</param>
        /// <param name="H">height of bar</param>
        /// <param name="on">color for notch on</param>
        /// <param name="off">color for notch off</param>
        /// <param name="highlight">highlight color to draw highlights on bar</param>
        /// <param name="active">true if notches are turned on</param>
        static void drawChannelBar(Graphics g, Channel chan, int left, int right, int center, int top, int height, Color c, Color h)
        {
            int width = right - left;

            // get a purty pen to draw with 
            Pen p = new Pen(h, 1);

            // shade in the notch
            g.FillRectangle(new SolidBrush(c), left, top, width, height);

            // draw a left and right line on the side of the rectancle if wide enough
            if (width > 2)
            {
                //g.DrawLine(p, left - 1, top, left - 1, top + height - 1);
                g.DrawLine(p, left, top, left, top + height - 1);
                g.DrawLine(p, right, top, right, top + height - 1);

                if (center > 0) g.DrawLine(p, center, top, center, top + (height / 4) - 1);

                //g.DrawLine(p, right+1, top, right+1, top + height - 1);
            }
        }

        #endregion

        #region GDI+

        unsafe public static void RenderGDIPlus(ref PaintEventArgs e)
        {


            /*BitmapData display_bmpData = display_bmp.LockBits(
				new Rectangle(0, 0, W, H),
				ImageLockMode.WriteOnly,
				display_bmp.PixelFormat);

			background_image_mutex.WaitOne();			// get background image

			BitmapData background_bmpData = background_bmp.LockBits(
				new Rectangle(0, 0, background_bmp.Width, background_bmp.Height),
				ImageLockMode.ReadOnly,
				background_bmp.PixelFormat);
				
			int total_size = background_bmpData.Stride * background_bmpData.Height;		// find buffer size

			byte *srcptr = (byte *)background_bmpData.Scan0.ToPointer();
			byte *destptr = (byte *)display_bmpData.Scan0.ToPointer();

			Win32.memcpy(destptr, srcptr, total_size);

			background_bmp.UnlockBits(background_bmpData);
			background_image_mutex.ReleaseMutex();

			display_bmp.UnlockBits(display_bmpData);*/

            //Graphics g = Graphics.FromImage(display_bitmap);
            //g.SmoothingMode = SmoothingMode.AntiAlias;
            bool update = true;

            //======================================================
            // ke9ns RX1 only TOP of panel to bottom of panel H
            //======================================================

            K13 = H;  // used to create special BMP file size

            if (!split_display)
            {
                switch (current_display_mode) // ke9ns full screen display (only RX1)
                {
                    case DisplayMode.SPECTRUM:
                        K9 = 4;
                        K11 = 0;
                        update = DrawSpectrum(e.Graphics, W, H, false);
                        break;
                    case DisplayMode.PANADAPTER:
                        K9 = 2;
                        K11 = 0;

                        update = DrawPanadapter(e.Graphics, W, H, 1, false);
                        break;
                    case DisplayMode.SCOPE:
                        K9 = 4;
                        K11 = 0;
                        update = DrawScope(e.Graphics, W, H, false);
                        break;
                    case DisplayMode.PHASE:
                        K9 = 4;
                        K11 = 0;
                        update = DrawPhase(e.Graphics, W, H, false);
                        break;
                    case DisplayMode.PHASE2:
                        K9 = 4;
                        K11 = 0;
                        DrawPhase2(e.Graphics, W, H, false);
                        break;
                    case DisplayMode.WATERFALL:   // RX1: full H waterfall
                        K9 = 1;
                        K11 = 0;
                        update = DrawWaterfall(e.Graphics, W, H, 1, false); // ke9ns was just H, false
                        break;
                    case DisplayMode.HISTOGRAM:
                        K9 = 4;
                        K11 = 0;
                        update = DrawHistogram(e.Graphics, W, H);
                        break;
                    case DisplayMode.PANAFALL:

                        if (map == 1) // ke9ns add:  if in special map viewing panafall mode PanaFall8020
                        {

                            K9 = 7;             //special panafall mode for sun/grayline tracking mode
                            K11 = 0;

                          //  float SS1 = .8333f; this was the 8020 default ke9ns mod .193 to allow adustment of display

                           update = DrawPanadapter(e.Graphics, W, (int)console.setupForm.udSS1H.Value + ( H * 5 / 6), 1, false);    // .197 5/6    in pure panadapter mode: update = DrawPanadapter(e.Graphics, W, H, 1, false);
                            update = DrawWaterfall(e.Graphics, W, (int)console.setupForm.udSS1H.Value + (H * 5 / 6), 1, true);        // bottom half RX2 is not on  5 * H / 6

                            split_display = false;
                        }
                        else // standard Panafall mode
                        {
                            K9 = 3;
                            K11 = 0;

                            split_display = true; // use wide vertgrid because your saying split
                          //  update = DrawPanadapter(e.Graphics, W, H / 2, 1, false); //top half 
                         //   update = DrawWaterfall(e.Graphics, W, H / 2, 1, true); // bottom half RX2 is not on

                            update = DrawPanadapter(e.Graphics, W, (int)console.setupForm.udSS2H.Value + (H / 2), 1, false); // .197 ke9ns mod .193 top half 
                            update = DrawWaterfall(e.Graphics, W, (int)console.setupForm.udSS2H.Value + (H /2), 1, true); // ke9ns mod bottom half RX2 is not on

                            split_display = false;
                        }

                        break;

                    case DisplayMode.PANASCOPE:
                        K9 = 4;
                        K11 = 0;
                        split_display = true;
                        update = DrawPanadapter(e.Graphics, W, H / 2, 1, false);
                        update = DrawScope(e.Graphics, W, H / 2, true);
                        split_display = false;
                        break;
                    case DisplayMode.OFF:
                        K9 = 0;
                        K11 = 0;
                        //Thread.Sleep(1000);
                        break;
                    default:
                        break;
                }
            } // !split_display
            else
            {

                //======================================================
                // ke9ns RX1 TOP of panel and RX2 bottom of panel H
                // this is only RX1 here, RX2 is futher down below
                //======================================================

                switch (current_display_mode) // ke9ns split display (RX1 top  and RX2 on bottom)
                {
                    case DisplayMode.SPECTRUM:
                        K9 = 4;
                        K11 = 0;
                        update = DrawSpectrum(e.Graphics, W, H / 2, false);
                        break;
                    case DisplayMode.PANADAPTER:
                        K9 = 2;
                        K11 = 0;
                        update = DrawPanadapter(e.Graphics, W, H / 2, 1, false); //ke9ns just as original
                        break;
                    case DisplayMode.SCOPE:
                        K9 = 4;
                        K11 = 0;
                        update = DrawScope(e.Graphics, W, H / 2, false);
                        break;
                    case DisplayMode.PHASE:
                        K9 = 4;
                        K11 = 0;
                        update = DrawPhase(e.Graphics, W, H / 2, false);
                        break;
                    case DisplayMode.PHASE2:
                        K9 = 4;
                        K11 = 0;
                        DrawPhase2(e.Graphics, W, H / 2, false);
                        break;
                    case DisplayMode.WATERFALL:
                        K9 = 6;
                        K11 = 0;
                        update = DrawWaterfall(e.Graphics, W, H / 2, 1, false);  // ke9ns was /2
                        break;

                    case DisplayMode.HISTOGRAM:
                        K9 = 4;
                        K11 = 0;
                        update = DrawHistogram(e.Graphics, W, H / 2);
                        break;

                    case DisplayMode.PANAFALL:   // ke9ns pan rX1 (KE9NS ADDED CODE)
                        K9 = 5;
                        K11 = 5;

                        switch (current_display_mode_bottom)  // ke9ns check RX2 to see what to do with both RX1 and RX2
                        {
                            case DisplayMode.PANADAPTER:
                                K10 = 2;
                                update = DrawPanadapter(e.Graphics, W, H / 3, 1, false); // RX1 panadapter top 1/3
                                update = DrawWaterfall(e.Graphics, W, H / 3, 1, true);     // RX1 waterfall middle 1/3

                                update = DrawPanadapter(e.Graphics, W, 2 * H / 3, 2, true); // RX2  bottom 1/3

                                break;

                            case DisplayMode.WATERFALL:
                                K10 = 1;

                                update = DrawPanadapter(e.Graphics, W, H / 3, 1, false); // RX1 panadapter top 1/3
                                update = DrawWaterfall(e.Graphics, W, H / 3, 1, true);     // RX1 waterfall middle 1/3

                                update = DrawWaterfall(e.Graphics, W, 2 * H / 3, 2, true);  // RX2 bottom 1/3

                                break;
                            case DisplayMode.PANAFALL:   // ke9ns pan (KE9NS ADDED CODE)  rx2 panafall with RX1 panafall as well
                                K10 = 5;
                                update = DrawPanadapter(e.Graphics, W, H / 4, 1, false); // RX1 panadapter top 1/4
                                update = DrawWaterfall(e.Graphics, W, H / 4, 1, true);     // RX1 waterfall middle 1/4

                                update = DrawPanadapter(e.Graphics, W, 2 * H / 4, 2, true);
                                update = DrawWaterfall(e.Graphics, W, 3 * H / 4, 2, true);

                                break;

                            case DisplayMode.OFF:
                                K10 = 0;
                                DrawOffBackground(e.Graphics, W, H / 2, true);
                                K9 = 3;
                                K11 = 0;

                                split_display = true; // use wide vertgrid because your saying split
                                update = DrawPanadapter(e.Graphics, W, H / 2, 1, false); //top half 
                                update = DrawWaterfall(e.Graphics, W, H / 2, 1, true); // bottom half RX2 is not on
                                split_display = false;

                                break; // rx2 off


                        } // switch (current_display_mode_bottom)

                        break;  // rx1 panafall


                    case DisplayMode.OFF:
                        K9 = 0;
                        K11 = 0;
                        DrawOffBackground(e.Graphics, W, H / 2, false);
                        break;


                    default:

                        break;

                } // RX1 switch(current_display_mode)   ke9ns split display (RX1 top  and RX2 on bottom)

                //=========================================
                // ke9ns display RX2 on bottom of screen
                //=========================================
                if (K11 == 0) //if rx1 is in panafall skip below
                {
                    switch (current_display_mode_bottom)  // ke9ns pan
                    {
                        case DisplayMode.SPECTRUM:
                            K10 = 0;
                            update = DrawSpectrum(e.Graphics, W, H / 2, true);   // RX1 on bottom half of screen
                            break;
                        case DisplayMode.PANADAPTER:
                            K10 = 2;
                            update = DrawPanadapter(e.Graphics, W, H / 2, 2, true); // RX2  (standard mode)
                            break;
                        case DisplayMode.SCOPE:
                            K10 = 0;
                            update = DrawScope(e.Graphics, W, H / 2, true);     // RX1 on bottom half of screen
                            break;
                        case DisplayMode.PHASE:
                            K10 = 0;
                            update = DrawPhase(e.Graphics, W, H / 2, true);  // RX1 on bottom half of screen
                            break;
                        case DisplayMode.PHASE2:
                            K10 = 0;
                            DrawPhase2(e.Graphics, W, H / 2, true);  // RX1 on bottom half of screen
                            break;

                        case DisplayMode.WATERFALL:
                            K10 = 1;
                            update = DrawWaterfall(e.Graphics, W, H / 2, 2, true);  // RX2
                            break;

                        case DisplayMode.HISTOGRAM:
                            K10 = 0;
                            update = DrawHistogram(e.Graphics, W, H / 2);  // RX1 on bottom half of screen
                            break;
                        case DisplayMode.OFF:
                            K10 = 0;
                            DrawOffBackground(e.Graphics, W, H / 2, true);

                            switch (current_display_mode) // ke9ns split display (RX1 top  and RX2 on bottom)
                            {

                                case DisplayMode.PANAFALL:
                                    K9 = 3;
                                    K11 = 0;

                                    split_display = true; // use wide vertgrid because your saying split
                                    update = DrawPanadapter(e.Graphics, W, H / 2, 1, false); //top half 
                                    update = DrawWaterfall(e.Graphics, W, H / 2, 1, true); // bottom half RX2 is not on
                                    split_display = false;

                                    break;
                            }


                            break; // RX2 OFF

                        case DisplayMode.PANAFALL:
                            K10 = 2;
                            update = DrawPanadapter(e.Graphics, W, H / 2, 2, true); // RX2  (standard mode)
                            break;
                        default:
                            K10 = 2;
                            update = DrawPanadapter(e.Graphics, W, H / 2, 2, true); // RX2  (standard mode)
                            break;


                    } // switch(current_display_mode_bottom)
                } // K11 == 0
                else // rx1 in panafall mode
                {
                    switch (current_display_mode_bottom)  // ke9ns pan
                    {

                        case DisplayMode.OFF:
                            K10 = 0;

                            DrawOffBackground(e.Graphics, W, H / 2, true);

                            break; // RX2 OFF

                    } // check rx2


                } // K11==5

            } // split_display


            if (update)
            {
                //e.Graphics.DrawImage(display_bmp, 0, 0);
            }
            else
            {
                Debug.WriteLine("display update = false");
            }


            if (Console.CTUN == true)
            {
              if (Console.UPDATEOFF > 0) Console.UPDATEOFF--;
             //  Debug.WriteLine("UPDATEOFF--------------" + Console.UPDATEOFF);

            }

        } // renderGDIPLUs


        private static void UpdateDisplayPeak(float[] buffer, float[] new_data)
        {
            if (buffer[0] == CLEAR_FLAG)
            {
                //Debug.WriteLine("Clearing peak buf"); 
                for (int i = 0; i < BUFFER_SIZE; i++)
                {
                    buffer[i] = new_data[i];
                }
            }
            else
            {
                for (int i = 0; i < BUFFER_SIZE; i++)
                {
                    if (new_data[i] > buffer[i]) buffer[i] = new_data[i];
                    new_data[i] = buffer[i];
                }
            }
        }

        #region Drawing Routines
        // ======================================================
        // Drawing Routines
        // ======================================================


        private static void DrawPhaseGrid(ref Graphics g, int W, int H, bool bottom)
        {
            // draw background
            if (bottom) g.FillRectangle(new SolidBrush(display_background_color), 0, H, W, H);
            else g.FillRectangle(new SolidBrush(display_background_color), 0, 0, W, H);

            for (double i = 0.50; i < 3; i += .50)  // draw 3 concentric circles
            {
                if (bottom) g.DrawEllipse(new Pen(grid_color), (int)(W / 2 - H * i / 2), H + (int)(H / 2 - H * i / 2), (int)(H * i), (int)(H * i));
                else g.DrawEllipse(new Pen(grid_color), (int)(W / 2 - H * i / 2), (int)(H / 2 - H * i / 2), (int)(H * i), (int)(H * i));
            }

            if (high_swr && !bottom)
                g.DrawString("High SWR", new System.Drawing.Font("Arial", 14, FontStyle.Bold), new SolidBrush(Color.Red), 245, 20);
        }

        private static void DrawScopeGrid(ref Graphics g, int W, int H, bool bottom)
        {
            // draw background
            //if(bottom) g.FillRectangle(new SolidBrush(display_background_color), 0, H, W, H);
            //else g.FillRectangle(new SolidBrush(display_background_color), 0, 0, W, H);

            if (bottom)
            {
                g.DrawLine(new Pen(grid_color), 0, H + H / 2, W, H + H / 2);    // draw horizontal line
                g.DrawLine(new Pen(grid_color), W / 2, H, W / 2, H + H);    // draw vertical line
            }
            else
            {
                g.DrawLine(new Pen(grid_color), 0, H / 2, W, H / 2);    // draw horizontal line
                g.DrawLine(new Pen(grid_color), W / 2, 0, W / 2, H);    // draw vertical line
            }

            if (high_swr && !bottom)
                g.DrawString("High SWR", new System.Drawing.Font("Arial", 14, FontStyle.Bold), new SolidBrush(Color.Red), 245, 20);
        }

        //================================================
        // ke9ns spectrum
        //================================================


        private static void DrawSpectrumGrid(ref Graphics g, int W, int H, bool bottom)
        {

            //   g.TextRenderingHint = TextRenderingHint.ClearTypeGridFit;
            //  g.CompositingMode = CompositingMode.SourceOver;
            //   g.CompositingQuality = CompositingQuality.HighQuality;
            //   g.InterpolationMode = InterpolationMode.HighQualityBicubic;
            //  g.SmoothingMode = SmoothingMode.HighQuality;
            //  g.PixelOffsetMode = PixelOffsetMode.HighQuality;

            System.Drawing.Font font = new System.Drawing.Font("Swis721 BT", 9, FontStyle.Italic);
            SolidBrush grid_text_brush = new SolidBrush(grid_text_color);
            Pen grid_pen = new Pen(grid_color);

            // draw background
            if (bottom) g.FillRectangle(new SolidBrush(display_background_color), 0, H, W, H);
            else g.FillRectangle(new SolidBrush(display_background_color), 0, 0, W, H);

            int low = 0;                                // init limit variables
            int high = 0;

            int center_line_x = (int)(-(double)low / (high - low) * W);

            if (!mox)
            {
                low = rx_display_low;               // get RX display limits  based on sample rate  (left to right freq range)
                high = rx_display_high;
            }
            else
            {
                if (rx1_dsp_mode == DSPMode.CWL || rx1_dsp_mode == DSPMode.CWU)
                {
                    low = rx_display_low;
                    high = rx_display_high;
                }
                else
                {
                    low = tx_display_low;           // get RX display limits
                    high = tx_display_high;
                }
            }

            int mid_w = W / 2;
            int[] step_list = { 10, 20, 25, 50 };
            int step_power = 1;
            int step_index = 0;
            int freq_step_size = 50;
            int y_range = spectrum_grid_max - spectrum_grid_min;
            int grid_step = spectrum_grid_step;

            if (split_display) grid_step *= 2;

            if (high == 0)
            {
                int f = -low;
                // Calculate horizontal step size
                while (f / freq_step_size > 7)
                {
                    freq_step_size = step_list[step_index] * (int)Math.Pow(10.0, step_power);
                    step_index = (step_index + 1) % 4;
                    if (step_index == 0) step_power++;
                }
                float pixel_step_size = (float)(W * freq_step_size / f);

                int num_steps = f / freq_step_size;

                // Draw vertical lines
                for (int i = 1; i <= num_steps; i++)
                {
                    int x = W - (int)Math.Floor(i * pixel_step_size);   // for negative numbers


                    if (bottom) g.DrawLine(grid_pen, x, H, x, H + H);
                    else g.DrawLine(grid_pen, x, 0, x, H);              // draw right line


                    // Draw vertical line labels
                    int num = i * freq_step_size;
                    string label = num.ToString();
                    int offset = (int)((label.Length + 1) * 4.1);
                    if (x - offset >= 0)
                    {
                        if (bottom) g.DrawString("-" + label, font, grid_text_brush, x - offset, H + (float)Math.Floor(H * .01));
                        else g.DrawString("-" + label, font, grid_text_brush, x - offset, (float)Math.Floor(H * .01));
                    }
                }

                // Draw horizontal lines
                int V = (int)(spectrum_grid_max - spectrum_grid_min);
                num_steps = V / grid_step;
                pixel_step_size = H / num_steps;

                for (int i = 1; i < num_steps; i++)
                {
                    int xOffset = 0;
                    int num = spectrum_grid_max - i * grid_step;
                    int y = (int)Math.Floor((double)(spectrum_grid_max - num) * H / y_range);

                    if (bottom) g.DrawLine(grid_pen, 0, H + y, W, H + y);
                    else g.DrawLine(grid_pen, 0, y, W, y);

                    // Draw horizontal line labels
                    if (i != 1) // avoid intersecting vertical and horizontal labels
                    {
                        string label = num.ToString();
                        if (label.Length == 3) xOffset = (int)g.MeasureString("-", font).Width - 2;
                        int offset = (int)(label.Length * 4.1);
                        SizeF size = g.MeasureString(label, font);

                        int x = 0;
                        switch (display_label_align)
                        {
                            case DisplayLabelAlignment.LEFT:
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.CENTER:
                                x = center_line_x + xOffset;
                                break;
                            case DisplayLabelAlignment.RIGHT:
                                x = (int)(W - size.Width - 3);
                                break;
                            case DisplayLabelAlignment.AUTO:
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.Sunit: // ke9ns add
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.OFF:
                                x = W;
                                break;
                        }

                        y -= 8;
                        if (y + 9 < H)
                        {
                            if (bottom) g.DrawString(label, font, grid_text_brush, x, H + y);
                            g.DrawString(label, font, grid_text_brush, x, y);
                        }
                    }
                }

                // Draw middle vertical line
                if (bottom)
                {
                    g.DrawLine(new Pen(grid_zero_color), W - 1, H, W - 1, H + H);
                    g.DrawLine(new Pen(grid_zero_color), W - 2, H, W - 2, H + H);
                }
                else
                {
                    g.DrawLine(new Pen(grid_zero_color), W - 1, 0, W - 1, H);
                    g.DrawLine(new Pen(grid_zero_color), W - 2, 0, W - 2, H);
                }
            }
            else if (low == 0)
            {
                int f = high;
                // Calculate horizontal step size
                while (f / freq_step_size > 7)
                {
                    freq_step_size = step_list[step_index] * (int)Math.Pow(10.0, step_power);
                    step_index = (step_index + 1) % 4;
                    if (step_index == 0) step_power++;
                }
                float pixel_step_size = (float)(W * freq_step_size / f);
                int num_steps = f / freq_step_size;

                // Draw vertical lines
                for (int i = 1; i <= num_steps; i++)
                {
                    int x = (int)Math.Floor(i * pixel_step_size);// for positive numbers

                    if (bottom) g.DrawLine(grid_pen, x, H, x, H + H);
                    else g.DrawLine(grid_pen, x, 0, x, H);              // draw right line

                    // Draw vertical line labels
                    int num = i * freq_step_size;
                    string label = num.ToString();
                    int offset = (int)(label.Length * 4.1);
                    if (x - offset + label.Length * 7 < W)
                    {
                        if (bottom) g.DrawString(label, font, grid_text_brush, x - offset, H + (float)Math.Floor(H * .01));
                        else g.DrawString(label, font, grid_text_brush, x - offset, (float)Math.Floor(H * .01));
                    }
                }

                // Draw horizontal lines
                int V = (int)(spectrum_grid_max - spectrum_grid_min);
                int numSteps = V / grid_step;
                pixel_step_size = H / numSteps;
                for (int i = 1; i < numSteps; i++)
                {
                    int xOffset = 0;
                    int num = spectrum_grid_max - i * grid_step;
                    int y = (int)Math.Floor((double)(spectrum_grid_max - num) * H / y_range);

                    if (bottom) g.DrawLine(grid_pen, 0, H + y, W, H + y);
                    else g.DrawLine(grid_pen, 0, y, W, y);

                    // Draw horizontal line labels
                    if (i != 1) // avoid intersecting vertical and horizontal labels
                    {
                        string label = num.ToString();
                        if (label.Length == 3)
                            xOffset = (int)g.MeasureString("-", font).Width - 2;
                        int offset = (int)(label.Length * 4.1);
                        SizeF size = g.MeasureString(label, font);

                        int x = 0;
                        switch (display_label_align)
                        {
                            case DisplayLabelAlignment.LEFT:
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.CENTER:
                                x = center_line_x + xOffset;
                                break;
                            case DisplayLabelAlignment.RIGHT:
                                x = (int)(W - size.Width - 3);
                                break;
                            case DisplayLabelAlignment.AUTO:
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.Sunit: // ke9ns add
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.OFF:
                                x = W;
                                break;
                        }

                        y -= 8;
                        if (y + 9 < H)
                        {
                            if (bottom) g.DrawString(label, font, grid_text_brush, x, H + y);
                            g.DrawString(label, font, grid_text_brush, x, y);
                        }
                    }
                }

                // Draw middle vertical line
                if (bottom)
                {
                    g.DrawLine(new Pen(grid_zero_color), 0, H, 0, H + H);
                    g.DrawLine(new Pen(grid_zero_color), 1, H, 1, H + H);
                }
                else
                {
                    g.DrawLine(new Pen(grid_zero_color), 0, 0, 0, H);
                    g.DrawLine(new Pen(grid_zero_color), 1, 0, 1, H);
                }
            }
            else if (low < 0 && high > 0)
            {
                int f = high;

                // Calculate horizontal step size
                while (f / freq_step_size > 4)
                {
                    freq_step_size = step_list[step_index] * (int)Math.Pow(10.0, step_power);
                    step_index = (step_index + 1) % 4;
                    if (step_index == 0) step_power++;
                }
                int pixel_step_size = W / 2 * freq_step_size / f;
                int num_steps = f / freq_step_size;

                // Draw vertical lines
                for (int i = 1; i <= num_steps; i++)
                {
                    int xLeft = mid_w - (i * pixel_step_size);          // for negative numbers
                    int xRight = mid_w + (i * pixel_step_size);     // for positive numbers
                    if (bottom)
                    {
                        g.DrawLine(grid_pen, xLeft, H, xLeft, H + H);       // draw left line
                        g.DrawLine(grid_pen, xRight, H, xRight, H + H);     // draw right line
                    }
                    else
                    {
                        g.DrawLine(grid_pen, xLeft, 0, xLeft, H);       // draw left line
                        g.DrawLine(grid_pen, xRight, 0, xRight, H);     // draw right line
                    }

                    // Draw vertical line labels
                    int num = i * freq_step_size;
                    string label = num.ToString();
                    int offsetL = (int)((label.Length + 1) * 4.1);
                    int offsetR = (int)(label.Length * 4.1);
                    if (xLeft - offsetL >= 0)
                    {
                        if (bottom)
                        {
                            g.DrawString("-" + label, font, grid_text_brush, xLeft - offsetL, H + (float)Math.Floor(H * .01));
                            g.DrawString(label, font, grid_text_brush, xRight - offsetR, H + (float)Math.Floor(H * .01));
                        }
                        else
                        {
                            g.DrawString("-" + label, font, grid_text_brush, xLeft - offsetL, (float)Math.Floor(H * .01));
                            g.DrawString(label, font, grid_text_brush, xRight - offsetR, (float)Math.Floor(H * .01));
                        }
                    }
                }

                // Draw horizontal lines
                int V = (int)(spectrum_grid_max - spectrum_grid_min);
                int numSteps = V / grid_step;
                pixel_step_size = H / numSteps;
                for (int i = 1; i < numSteps; i++)
                {
                    int xOffset = 0;
                    int num = spectrum_grid_max - i * grid_step;
                    int y = (int)Math.Floor((double)(spectrum_grid_max - num) * H / y_range);
                    if (bottom) g.DrawLine(grid_pen, 0, H + y, W, H + y);
                    else g.DrawLine(grid_pen, 0, y, W, y);

                    // Draw horizontal line labels
                    if (i != 1) // avoid intersecting vertical and horizontal labels
                    {
                        string label = num.ToString();
                        if (label.Length == 3) xOffset = (int)g.MeasureString("-", font).Width - 2;
                        int offset = (int)(label.Length * 4.1);
                        SizeF size = g.MeasureString(label, font);

                        int x = 0;
                        switch (display_label_align)
                        {
                            case DisplayLabelAlignment.LEFT:
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.CENTER:
                                x = center_line_x + xOffset;
                                break;
                            case DisplayLabelAlignment.RIGHT:
                                x = (int)(W - size.Width - 3);
                                break;
                            case DisplayLabelAlignment.AUTO:
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.Sunit: // ke9ns add
                                x = xOffset + 3;
                                break;
                            case DisplayLabelAlignment.OFF:
                                x = W;
                                break;
                        }

                        y -= 8;
                        if (y + 9 < H)
                        {
                            if (bottom) g.DrawString(label, font, grid_text_brush, x, H + y);
                            g.DrawString(label, font, grid_text_brush, x, y);
                        }
                    }
                }

                // Draw middle vertical line
                if (bottom)
                {
                    g.DrawLine(new Pen(grid_zero_color), mid_w, H, mid_w, H + H);
                    g.DrawLine(new Pen(grid_zero_color), mid_w - 1, H, mid_w - 1, H + H);
                }
                else
                {
                    g.DrawLine(new Pen(grid_zero_color), mid_w, 0, mid_w, H);
                    g.DrawLine(new Pen(grid_zero_color), mid_w - 1, 0, mid_w - 1, H);
                }
            }

            if (high_swr && !bottom)
                g.DrawString("High SWR", new System.Drawing.Font("Arial", 14, FontStyle.Bold), new SolidBrush(Color.Red), 245, 20);
        }

#if(!NO_TNF)
        static float zoom_height = 1.5f;   // Should be > 1.  H = H/zoom_height  (1.0 would cover entire pan, 2.0 covers half of pan)
#endif


        //==========================================================================================================================================================
        // ke9ns draw panadapter grid
        //==========================================================================================================================================================

        public static int[] holder2 = new int[100];                           // ke9ns add MEMORY Spot used to allow the vertical lines to all be drawn first so the call sign text can draw over the top of it.
        public static int[] holder3 = new int[100];                          // ke9ns add

        public static int[] holder = new int[100];                           // ke9ns add DX Spot used to allow the vertical lines to all be drawn first so the call sign text can draw over the top of it.
        public static int[] holder1 = new int[100];                          // ke9ns add
        private static Font font1 = new Font("Ariel", 9, FontStyle.Regular);  // ke9ns add dx spot call sign font style

        private static Pen p1 = new Pen(Color.YellowGreen, 2.0f);             // ke9ns add vert line color and thickness  DXSPOTTER
        private static Pen p3 = new Pen(Color.Blue, 2.5f);                   // ke9ns add vert line color and thickness    MEMORY
        private static Pen p2 = new Pen(Color.Purple, 2.0f);                  // ke9ns add color for vert line of SWL list

        //   private static Pen p4 = new Pen(Color.White, 2.0f);                  // ke9ns add color for vert line for TIME UTC pos

        private static SizeF length;                                          // ke9ns add length of call sign so we can do usb/lsb and define a box to click into
        private static SizeF length1;                                          // ke9ns add length of call sign so we can do usb/lsb and define a box to click into

        private static bool low = false;                                     // ke9ns add true=LSB, false=USB
        private static int rx2 = 0;                                          // ke9ns add 0-49 spots for rx1 panadapter window for qrz callup  (50-100 for rx2)
        private static int rx3 = 0;                                          // ke9ns add 0-49 spots for rx1 panadapter window for qrz callup  (50-100 for rx2)

        public static int VFOLow = 0;                                       // ke9ns low freq (left side of screen) in HZ (used in DX_spot)
        public static int VFOHigh = 0;                                      // ke9ns high freq (right side of screen) in HZ
        public static int VFODiff = 0;                                      // ke9ns diff high-low

        static Color c1;
        static Color c2;

        static bool SUNIT = false;                                          // ke9ns add true= S-Unit scale was activated


        // ke9ns ADD BELOW for Display of SWR PLOT INFO

        // using console.SWR_READ[TEST,ANT,BAND,SLOT] = SWR
        // SLOT0 = LOW FREQ OF THE FOLLOWING SWR SLOTS
        // SLOT1 = HIGH FREQ OF THE FOLLOWING SWR SLOTS
        // SLOT2 = STEP RATE (in khz) OF THE FOLLOWING SWR SLOTS (.001 = 1khz)
        // SLOT3-9 = RESERVED
        // SLOT10-3000 SWR FREQ SLOT POSTIONS From LOW to HIGH for the particular ANT and BAND

        // actual_fgrid_label = 3.93,3.94,3.94,3.95 (across the visible display area of the screen)
        // Low = -40003, High = 39997 at 192k, -20037 & 19963 for 96k (this is hz to the left of the VFO freq at the Sr and zoom level)
        //  VFOLow = vfo_hz + RXDisplayLow;    // low freq (left side) in hz
        //  VFOHigh = vfo_hz + RXDisplayHigh; // high freq (right side) in hz
        //  VFODiff = VFOHigh - VFOLow;       // diff in hz

        static int TESTRUN = 1; // Test# to display
        static Band BAND1; // Band place holder
        static FWCAnt ANT1;// Ant place holder (only used for the 5000)
        static int SLOT;// Freq Slot place holder (SLOT = 1khz steps)
        static double SWRF; // Actual SWR value (i.e. 1.5)
        static double Freq_Low; //  low end of the band SWR data
        static double Freq_High; // high end of the band SWR data
        static double Freq_Step; // STEP RATE of the recorded data
        static Pen SWR_pen = new Pen(new SolidBrush(Color.Yellow), 2.0f);  // TEXT COLORS
        static Pen SWR_pen_green = new Pen(new SolidBrush(Color.LawnGreen), 2.0f);
        static Pen SWR_pen_red = new Pen(new SolidBrush(Color.Red), 2.0f);
        static Pen SWR_pen_yellow = new Pen(new SolidBrush(Color.Yellow), 2.0f);
        static SolidBrush SWR_Brush = new SolidBrush(Color.Red);//SWR >= 3            // LINE COLORS
        static SolidBrush SWR_Brush_green = new SolidBrush(Color.LawnGreen); // SWR <= 2
        static SolidBrush SWR_Brush_red = new SolidBrush(Color.Red);//SWR >= 3
        static SolidBrush SWR_Brush_yellow = new SolidBrush(Color.Yellow); // 2 < SWR < 3

        static double SWR_HIGH = 3.0; // Red Color SWR  
        static double SWR_MED = 2.0; // Yellow Color SWR, otherwise Green

        static double SWRLINE = 20; // length of SWR graphics line 

        static int SWR_Y = 25; // position of SWR Plot
        static int SWR_YS = 15; // position of SWR Plot
        static int SWR_Step = 55; // y between each SWR plot

        static bool SWR_Multi = false; // true = Panadapter screen only (no waterfall) will display up to 5 SWR plots simultaneously
        static int SWR_Count = 1; //
        static int SWR_C = 1; //

        static decimal freqlast1 = 0; // ke9ns add for bandtext
        static decimal freqlast2 = 0; // ke9ns add .210 for rx2
        static string[] bandtext = new string[2000]; // ke9ns add for bandtext
        static string[] bandtext2 = new string[2000]; // ke9ns add for bandtext .210
        static decimal[] bandfreq = new decimal[2000]; // ke9ns add for bandtext
        static decimal[] bandfreq2 = new decimal[2000]; // ke9ns add for bandtext .210
        static bool[] bandhere = new bool[2000]; // ke9ns add for bandtext
        static bool[] bandhere2 = new bool[2000]; // ke9ns add for bandtext .210

        static int bandtext_counter = 0; // ke9ns add for bandtext
        static int bandtext_counter2 = 0; // ke9ns add for bandtext .210
        static int cw_line_x; // ke9ns used to move the 0hz line over by the pitch mount of hz
        static int top1; // ke9ns

        private static void DrawPanadapterGrid(ref Graphics g, int W, int H, int rx, bool bottom)
        {

         
            // ke9ns add for SWR plotting)
            if (console.ScanForm.checkBoxSWR.Checked)
            {
                BAND1 = console.RX1Band; // B160M = 1, B80M = 2,B60M = 3,
                ANT1 = console.GetRX1Ant(BAND1); //ANT1 = 1, ANT2 = 2, ANT3 = 3, RX1IN=4, RX2IN=5, RX1TAP=6, SIG_GEN=7, VHF=8, UHF=9,
                TESTRUN = console.SWR_TESTRUN; // select which swr scan test to display 1-5  (4= display 1 through 4)


                Freq_Low = console.SWR_READ[TESTRUN, (int)ANT1, (int)BAND1, 0];  // low freq of SWR plot data (3.500)
                Freq_High = console.SWR_READ[TESTRUN, (int)ANT1, (int)BAND1, 1]; // high freq of SWR plot data (4.00)
                Freq_Step = console.SWR_READ[TESTRUN, (int)ANT1, (int)BAND1, 2]; // .001=1khz, 002=2khz value 1,2,3

                if ((current_display_mode == DisplayMode.PANADAPTER) && (TESTRUN > 1) && (console.RX2Enabled == false))
                {
                    SWR_Multi = true;
                    SWRLINE = 10; // reduce size of SWR plot since you have up to 5 to display
                    Debug.WriteLine("SWR MULTI");
                }
                else
                {
                    SWR_Multi = false;
                }

                //   Debug.WriteLine(" SWR STARTUP: " + VFOLow + " , " + VFOHigh + " , " + ANT1 + " , " + BAND1 + " , " + Freq_Low + " , " + Freq_High + " , " + Freq_Step);

            } //  if (console.ScanForm.checkBoxSWR.Checked)


            if ((K9 == 5) && (K10 != 5) && (bottom)) H1 = H - (H / 2); // to help RX2 pan display in 1/3 instead of 1/2

            if ((K9 == 5) && (K10 == 5) && (bottom)) H1 = H - (H / 2); // to help RX2 pan display in 1/4 instead of 1/2


            // draw background
            /*if(bottom) g.FillRectangle(new SolidBrush(display_background_color), 0, H, W, H);
			else g.FillRectangle(new SolidBrush(display_background_color), 0, 0, W, H);*/

            bool local_mox = false;

            if (mox && rx == 1 && !tx_on_vfob) local_mox = true;
            if (mox && rx == 2 && tx_on_vfob) local_mox = true;

            int Low = rx_display_low;           // ke9ns: low= -96000 at 192k SR and zoom = .5  (this is hz to the left of the VFO freq at the Sr and zoom level)
            int High = rx_display_high;         // ke9ns: high= +96000 at 192k SR and zoom = .5 (this is hz to the right of the VFO freq at the Sr and zoom level)
          
           if (rx == 2) //.219
           {
                Low = rx_display_low2;           // ke9ns: low= -96000 at 192k SR and zoom = .5  (this is hz to the left of the VFO freq at the Sr and zoom level)
                High = rx_display_high2;         // ke9ns: high= +96000 at 192k SR and zoom = .5 (this is hz to the right of the VFO freq at the Sr and zoom level)

           }

            int mid_w = W / 2;
            int[] step_list = { 10, 20, 25, 50 };
            int step_power = 1;
            int step_index = 0;
            int freq_step_size = 50;
            int inbetweenies = 5; // ke9ns number of lines from 1 freq label to the next (a line every 2khz)

            int grid_step = 0;  // 

          

            //------------------------------------------------------------------------------
            // ke9ns add   this S-Unit scale is designed to display a Grid based on the the S unit dBm
            if ((display_label_align == DisplayLabelAlignment.Sunit) && (!local_mox)) // if in S unit mode then draw lines only on the S unit point
            {

                if (SUNIT == false) SUNIT = true; // let code know we are now in special S-Unit mode on right side (S unit value for current BIN size, and not the S meter Bandpass)




                if ((K9 == 5)) // if rx2 is enabled cut the number of grids down in half
                {
                    if (VFOA < 30000000) // HF     dBm num = spectrum_grid_max - (i * grid_step);
                    {
                        spectrum_grid_max = -49;
                        spectrum_grid_min = -139; // S0 is -133 to -122
                    }
                    else // VHF
                    {
                        spectrum_grid_max = -69;
                        spectrum_grid_min = -159; // S0 is -153 to -142
                    }

                    if (bottom)
                    {
                        spectrum_grid_step = 6; // 6
                        grid_step = 6;  // 6
                    }
                    else
                    {
                        spectrum_grid_step = 6;  // 6
                        grid_step = 12;  // 12
                    }

                }
                else // just RX1
                {
                    if (VFOA < 30000000) // HF     dBm num = spectrum_grid_max - (i * grid_step);
                    {
                        spectrum_grid_max = -43;   // -43
                        spectrum_grid_min = -139; // S0 is -133 to -122
                    }
                    else // VHF
                    {
                        spectrum_grid_max = -63;  // -63
                        spectrum_grid_min = -159; // S0 is -153 to -142
                    }

                    spectrum_grid_step = 6;
                    grid_step = 6;

                } // just rx1


            } // special dBm and S-Unit display
            else // use normal setup->display setpoints
            {
                if ((SUNIT == true) && (!local_mox)) // if you were in S-Unit mode, then put back normal values but only in RX mode
                {
                    spectrum_grid_max = spectrum_grid_max1; // use setupform orignal values over again
                    spectrum_grid_min = spectrum_grid_min1;
                    spectrum_grid_step = spectrum_grid_step1;
                    SUNIT = false;
                }

                grid_step = spectrum_grid_step; // you maybe in TX mode here

                if (split_display) grid_step = grid_step * 2; // increase grid_step since you have less space on screen

                if ((K9 == 5) && (K10 != 5) && (bottom)) grid_step = spectrum_grid_step; // 1.5 ke9ns ADDED THIS CODE increase grid_step again since you have even less space on screen
                if ((K9 == 5) && (K10 == 5) && (bottom)) grid_step = spectrum_grid_step; // 1.5 ke9ns ADDED THIS CODE increase grid_step again since you have even less space on screen


            } // standard dBm display

            //----------------------------------------------------------------------------------------

            //  if (bottom) Debug.WriteLine("bottom...top " + top + " H " + H);
            //  else Debug.WriteLine("top...top " + top + " H " + H);

            bool is_first = true;
            int _x = 0;
            int _y = 0;
            int _width = 0;
            int _height = 0;

            System.Drawing.Font font = new System.Drawing.Font("Swis721 BT", 9, FontStyle.Italic);
            SolidBrush grid_text_brush = new SolidBrush(grid_text_color);

            Pen grid_pen = new Pen(Color.FromArgb(42, Color.White));

            Pen grid_pen_dark = new Pen(Color.FromArgb(16, Color.White));

            Pen tx_filter_pen = new Pen(display_filter_tx_color);


            int y_range = spectrum_grid_max - spectrum_grid_min; // ke9ns H grid span min to max


            int filter_low, filter_high;     // filter bandwidth        


            int center_line_x = (int)(-(double)Low / (High - Low) * W); // center of display window


            if (local_mox) // get filter limits
            {
                filter_low = tx_filter_low;
                filter_high = tx_filter_high;
            }
            else if (rx == 1)
            {
                filter_low = rx1_filter_low;
                filter_high = rx1_filter_high;
            }
            else //if(rx == 2)
            {
                filter_low = rx2_filter_low;
                filter_high = rx2_filter_high;
            }

            if ((rx1_dsp_mode == DSPMode.DRM && rx == 1) || (rx2_dsp_mode == DSPMode.DRM && rx == 2))
            {
                filter_low = -5000;
                filter_high = 5000;
            }


            //===========================================================
            // Calculate horizontal step size
            //===========================================================

            int width = High - Low;

            while (width / freq_step_size > 10)
            {
                /*inbetweenies = step_list[step_index] / 10;
                if (inbetweenies == 1) inbetweenies = 10;*/

                freq_step_size = step_list[step_index] * (int)Math.Pow(10.0, step_power);
                step_index = (step_index + 1) % 4;
                if (step_index == 0) step_power++;
            }
            double w_pixel_step = (double)W * freq_step_size / width;
            int w_steps = width / freq_step_size;



            //===========================================================
            // calculate vertical step size
            //===========================================================


            int h_steps = (spectrum_grid_max - spectrum_grid_min) / grid_step; // if display area shrinks, grid step goes up, so h_steps goes down.


            if ((SUNIT) && (!local_mox)) // if in S unit mode then draw lines only on the S unit point
            {
                if ((K9 == 5)) // if RX2 is enabled
                {
                    if (bottom) h_steps = 23; // 23 if RX2 enabled
                    else h_steps = 11; // 11 if RX2 enabled
                }
                else h_steps = 18; // 18 show all S units all the time in Sunit mode

            }


            double h_pixel_step = (double)H / h_steps; // ke9ns ?

            //  Debug.WriteLine("spectrum_grid_max, min, stp, hstp =" + spectrum_grid_max + " ," + spectrum_grid_min + " , " + spectrum_grid_step + " , " + grid_step + " , " + h_steps);


            if ((SUNIT) && (!local_mox))
            {

                if ((K9 == 5))
                {
                    if (bottom) h_steps = 11; // 11 if RX2 enabled
                    else h_steps = 11; // 11 if RX2 enabled
                }
                else h_steps = 18; // 18 show all S units all the time in Sunit mode

            }
            else // if in special dBm S-Unit mode
            {
                if ((K9 == 5) && (K10 != 5) && (bottom)) h_steps = (spectrum_grid_max - spectrum_grid_min) / (spectrum_grid_step * 2); // ke9ns ADDED CODE area are in thirds so hstep for RX1 and RX2 should be the same
                if ((K9 == 5) && (K10 == 5) && (bottom)) h_steps = (spectrum_grid_max - spectrum_grid_min) / (spectrum_grid_step * 2); // ke9ns ADDED CODE area are in 1/4rs so hstep for RX1 and RX2 should be the same

            }


            int top = top1 = (int)((double)grid_step * H / y_range); // find top of each window for the panadapter




            //===========================================================
            // draw sub filter
            //===========================================================
            if (!local_mox && sub_rx1_enabled && rx == 1)
            {

                // draw Sub RX filter
                // get filter screen coordinates

                int filter_left_x = (int)((float)(filter_low - Low + vfoa_sub_hz - vfoa_hz - rit_hz) / (High - Low) * W);
                int filter_right_x = (int)((float)(filter_high - Low + vfoa_sub_hz - vfoa_hz - rit_hz) / (High - Low) * W);

                // make the filter display at least one pixel wide.
                if (filter_left_x == filter_right_x) filter_right_x = filter_left_x + 1;

                // draw rx filter
                if (bottom)
                {
                    g.FillRectangle(new SolidBrush(sub_rx_filter_color),    // draw filter overlay
                        filter_left_x, H + top, filter_right_x - filter_left_x, H + H - top);
                }
                else
                {
                    g.FillRectangle(new SolidBrush(sub_rx_filter_color),    // draw filter overlay
                        filter_left_x, top, filter_right_x - filter_left_x, H - top);

                }


                //===============================================================
                // draw Sub RX 0Hz line
                //===============================================================
                int x = (int)((float)(vfoa_sub_hz - vfoa_hz - Low) / (High - Low) * W);  // ke9ns draw red line

                if (bottom)
                {
                    g.DrawLine(new Pen(sub_rx_zero_line_color), x, H + top, x, H + H); // ke9ns draw red line
                    g.DrawLine(new Pen(sub_rx_zero_line_color), x - 1, H + top, x - 1, H + H);
                }
                else
                {
                    g.DrawLine(new Pen(sub_rx_zero_line_color), x, top, x, H);         // ke9ns draw red line
                    g.DrawLine(new Pen(sub_rx_zero_line_color), x - 1, top, x - 1, H);
                }

            } // draw sub filter


            //============================================================================================
            //============================================================================================
            //============================================================================================

            if (rx == 1)
            {
                //============================================================================================
                // ke9ns RX1 draw main filter bandpass display
                //============================================================================================

                if (!(local_mox && (rx1_dsp_mode == DSPMode.CWL || rx1_dsp_mode == DSPMode.CWU)))  // draw bandpass for RX or bandpass for TX (but not in cW TX mode)) 
                {
                    // get filter screen coordinates

                    int filter_left_x;
                    int filter_right_x;


                    filter_left_x = (int)((float)(filter_low - Low) / (High - Low) * W); // original
                    filter_right_x = (int)((float)(filter_high - Low) / (High - Low) * W);


                    // make the filter display at least one pixel wide.
                    if (filter_left_x == filter_right_x) filter_right_x = filter_left_x + 1;


                    g.FillRectangle(new SolidBrush(display_filter_color),   // draw filter overlay
                            filter_left_x, top, filter_right_x - filter_left_x, H - top);

                    // }
                } // main RX1 filter
                else if ((local_mox) && (rx1_dsp_mode == DSPMode.CWL || rx1_dsp_mode == DSPMode.CWU) && (!split_enabled)) // draw CW rx box when you tx.
                {

                    int filter_left_x;
                    int filter_right_x;


                    filter_left_x = (int)((float)(rx1_filter_low - Low) / (High - Low) * W); // original
                    filter_right_x = (int)((float)(rx1_filter_high - Low) / (High - Low) * W);


                    // make the filter display at least one pixel wide.
                    if (filter_left_x == filter_right_x) filter_right_x = filter_left_x + 1;



                    g.FillRectangle(new SolidBrush(display_filter_color),   // draw filter overlay
                        filter_left_x, top, filter_right_x - filter_left_x, H - top);

                }

                //============================================================================================
                // ke9ns  RX1 draw tx line for everything but cw
                //============================================================================================
                if (!local_mox && draw_tx_filter && (rx1_dsp_mode != DSPMode.CWL && rx1_dsp_mode != DSPMode.CWU))
                {
                    // get tx filter limits
                    int filter_left_x;
                    int filter_right_x;

                    if (tx_on_vfob)
                    {
                        if (!split_enabled)
                        {
                            filter_left_x = (int)((float)(tx_filter_low - Low + xit_hz - rit_hz) / (High - Low) * W); //original
                            filter_right_x = (int)((float)(tx_filter_high - Low + xit_hz - rit_hz) / (High - Low) * W); // 
                        }
                        else
                        {
                            filter_left_x = (int)((float)(tx_filter_low - Low + xit_hz - rit_hz + (vfob_sub_hz - vfoa_hz)) / (High - Low) * W);
                            filter_right_x = (int)((float)(tx_filter_high - Low + xit_hz - rit_hz + (vfob_sub_hz - vfoa_hz)) / (High - Low) * W);
                        }
                    }
                    else // TX on VFOA
                    {
                        if (!split_enabled)
                        {
                            //Transmit profile high=4000, low = 70  results in:
                            // tx_filter_low = -4000 lsb or +70 usb hz
                            // tx_filter_high = -70 lsb or +4000 usb hz
                            // filter_left_x = 658 lsb or 732 usb pixel
                            // filter_right_x = 740 lsb or 804 usb  pixel
                            // W = 1463 based on size of console and resolution, HIGH = 40000, Low = - 40000  at Zoom=1 and 192k SR


                            filter_left_x = (int)((float)(tx_filter_low - Low + xit_hz - rit_hz) / (High - Low) * W);
                            filter_right_x = (int)((float)(tx_filter_high - Low + xit_hz - rit_hz) / (High - Low) * W);

                            //  Debug.Write(" txfilterlow=" + tx_filter_low); // 
                            //  Debug.Write(" txfilterhigh=" + tx_filter_high);
                            //  Debug.Write(" filter_left_x=" + filter_left_x);
                            //   Debug.Write(" filter_right_x=" + filter_right_x);
                            //   Debug.Write(" High" + High);
                            //   Debug.Write(" Low" + Low);
                            //  Debug.Write(" W" + W);
                        }
                        else // split on vfoa
                        {
                            filter_left_x = (int)((float)(tx_filter_low - Low + xit_hz - rit_hz + (vfoa_sub_hz - vfoa_hz)) / (High - Low) * W);
                            filter_right_x = (int)((float)(tx_filter_high - Low + xit_hz - rit_hz + (vfoa_sub_hz - vfoa_hz)) / (High - Low) * W);

                        }
                    }

                    if (bottom) // && tx_on_vfob)  // if transmitting on RX2 then draw lines on bottom
                    {
                        // draw tx filter overlay
                        g.DrawLine(tx_filter_pen, filter_left_x, H + top, filter_left_x, H + H);
                        g.DrawLine(tx_filter_pen, filter_right_x, H + top, filter_right_x, H + H);  // draw tx filter overlay

                    }
                    else if ((!tx_on_vfob) && (!bottom)) // ke9ns if transmitting on normal RX1 draw lines // KE9NS ADD  fix mistake made by flex  makes the line thicker
                    {
                        // ke9ns pgrid ORANGE LEFT and RIGHT TX WIDTH LINES for TRANSMITTER ONLY
                        g.DrawLine(tx_filter_pen, filter_left_x, top, filter_left_x, H);        // LEFT draw tx filter overlay
                        g.DrawLine(tx_filter_pen, filter_right_x, top, filter_right_x, H);      // RIGHT draw tx filter ovelay
                    }

                } // draw ssb TX1 filter width lines


                //============================================================================================
                // ke9ns  RX1 draw tx line for cw
                //============================================================================================
                //   if ((!local_mox) && (draw_tx_cw_freq || console.setupForm.chkCWDisplay.Checked) && (rx1_dsp_mode == DSPMode.CWL || rx1_dsp_mode == DSPMode.CWU)) // ke9ns mod
                if ((draw_tx_cw_freq || console.setupForm.chkCWDisplay.Checked) && (rx1_dsp_mode == DSPMode.CWL || rx1_dsp_mode == DSPMode.CWU)) // ke9ns mod
                {
                    int pitch = cw_pitch;
                    if ((rx1_dsp_mode == DSPMode.CWL)) pitch = -cw_pitch;

                    //   int cw_line_x; // ke9ns used to move the 0hz line over by the pitch mount of hz

                    if (!split_enabled)
                    {
                        cw_line_x = (int)((float)(pitch - Low + xit_hz - rit_hz) / (High - Low) * W);
                    }
                    else
                    {
                        if ((!local_mox)) // rx
                        {
                            cw_line_x = (int)((float)(pitch - Low + xit_hz - rit_hz + (vfoa_sub_hz - vfoa_hz)) / (High - Low) * W); // in RX show the TX line
                        }
                        else // tx
                        {
                            cw_line_x = (int)((float)(pitch - Low + xit_hz - rit_hz) / (High - Low) * W);

                        }

                    }

                    //  if (draw_tx_cw_freq) // ke9ns add
                    if ((!local_mox) && (draw_tx_cw_freq))
                    {
                        if ((bottom) && tx_on_vfob) // KE9NS ADD  fix mistake made by flex
                        {
                            g.DrawLine(tx_filter_pen, cw_line_x, H + top, cw_line_x, H + H);
                            g.DrawLine(tx_filter_pen, cw_line_x + 1, H + top, cw_line_x + 1, H + H);

                        }
                        else if ((!tx_on_vfob) && (!bottom))
                        {
                            g.DrawLine(tx_filter_pen, cw_line_x, top, cw_line_x, H);
                            g.DrawLine(tx_filter_pen, cw_line_x + 1, top, cw_line_x + 1, H);

                        }
                    }

                } // cw filter lines

            } // rx == 1
            else // rx == 2
            {
                //============================================================================================
                // ke9ns RX2 draw main filter bandpass display
                //============================================================================================
                if (!(local_mox && (rx2_dsp_mode == DSPMode.CWL || rx2_dsp_mode == DSPMode.CWU)))  // draw bandpass for RX or bandpass for TX (but not in cW mode)) 
                {
                    // get filter screen coordinates

                    int filter_left_x;
                    int filter_right_x;

                    filter_left_x = (int)((float)(filter_low - Low) / (High - Low) * W); // original
                    filter_right_x = (int)((float)(filter_high - Low) / (High - Low) * W);

                    // make the filter display at least one pixel wide.
                    if (filter_left_x == filter_right_x) filter_right_x = filter_left_x + 1;


                    // rx2 always on the bottom
                    g.FillRectangle(new SolidBrush(display_filter_color),   // draw filter overlay
                        filter_left_x, H + top, filter_right_x - filter_left_x, H + H - top);

                } // filter
                else if ((local_mox) && (rx2_dsp_mode == DSPMode.CWL || rx2_dsp_mode == DSPMode.CWU)) // draw CW rx box
                {

                    int filter_left_x;
                    int filter_right_x;


                    filter_left_x = (int)((float)(rx2_filter_low - Low) / (High - Low) * W); // original
                    filter_right_x = (int)((float)(rx2_filter_high - Low) / (High - Low) * W);


                    // make the filter display at least one pixel wide.
                    if (filter_left_x == filter_right_x) filter_right_x = filter_left_x + 1;



                    g.FillRectangle(new SolidBrush(display_filter_color),   // draw filter overlay
                        filter_left_x, top, filter_right_x - filter_left_x, H - top);

                }

                //============================================================================================
                // ke9ns  RX2 draw tx line for everything but cw
                //============================================================================================
                if (!local_mox && draw_tx_filter && (rx2_dsp_mode != DSPMode.CWL && rx2_dsp_mode != DSPMode.CWU) && (tx_on_vfob))
                {
                    // get tx filter limits
                    int filter_left_x;
                    int filter_right_x;


                    if (!split_enabled)
                    {
                        filter_left_x = (int)((float)(tx_filter_low - Low + xit_hz - rit_hz) / (High - Low) * W); //original
                        filter_right_x = (int)((float)(tx_filter_high - Low + xit_hz - rit_hz) / (High - Low) * W); // 
                    }
                    else
                    {
                        filter_left_x = (int)((float)(tx_filter_low - Low + xit_hz - rit_hz + (vfob_sub_hz - vfoa_hz)) / (High - Low) * W);
                        filter_right_x = (int)((float)(tx_filter_high - Low + xit_hz - rit_hz + (vfob_sub_hz - vfoa_hz)) / (High - Low) * W);
                    }


                    // draw tx filter overlay
                    g.DrawLine(tx_filter_pen, filter_left_x, H + top, filter_left_x, H + H);
                    g.DrawLine(tx_filter_pen, filter_right_x, H + top, filter_right_x, H + H);  // draw tx filter overlay


                } // draw filter width lines


                //============================================================================================
                // ke9ns  RX2 draw tx line for cw
                //============================================================================================
                if (!local_mox && (draw_tx_cw_freq || console.setupForm.chkCWDisplay.Checked) && (rx2_dsp_mode == DSPMode.CWL || rx2_dsp_mode == DSPMode.CWU) && (tx_on_vfob)) // ke9ns mod
                {
                    int pitch = cw_pitch;
                    if (rx2_dsp_mode == DSPMode.CWL) pitch = -cw_pitch;

                    int cw_line_x;

                    if (!split_enabled)

                        cw_line_x = (int)((float)(pitch - Low + xit_hz - rit_hz) / (High - Low) * W);

                    else
                        cw_line_x = (int)((float)(pitch - Low + xit_hz - rit_hz + (vfoa_sub_hz - vfoa_hz)) / (High - Low) * W);

                    if (draw_tx_cw_freq) // ke9ns add
                    {
                        g.DrawLine(tx_filter_pen, cw_line_x, H + top, cw_line_x, H + H);
                        g.DrawLine(tx_filter_pen, cw_line_x + 1, H + top, cw_line_x + 1, H + H);
                    }

                } // cw filter line

            } // rx == 2



            //===============================================================
            // draw 60m channels if in view (for any FRSregion, channels are only added if the region warrents it)
            //===============================================================

            if (console.setupForm != null && console.setupForm.chkBoxChannels.Checked == true) // ke9ns add: on/off option for channels
            {
                foreach (Channel c in channels_60m)
                {
                    long rf_freq = vfoa_hz;
                    int rit = rit_hz;
                    if (local_mox) rit = 0;

                    if (bottom)
                    {
                        rf_freq = vfob_hz;
                    }

                    if (c.InBW((rf_freq + Low) * 1e-6, (rf_freq + High) * 1e-6)) // is channel visible?
                    {
                        bool on_channel = console.RX1IsOn60mChannel(c); // only true if you are on channel and are in an acceptable mode

                        if (bottom) on_channel = console.RX2IsOn60mChannel(c);

                        DSPMode mode = rx1_dsp_mode;
                        if (bottom) mode = rx2_dsp_mode;

                        switch (mode)
                        {
                            case DSPMode.USB:
                            case DSPMode.DIGU:
                            case DSPMode.CWL:
                            case DSPMode.CWU:
                                break;

                            case DSPMode.AM:
                            case DSPMode.SAM:

                                if (rf_freq < 25000000) on_channel = false; // make sure other modes do not look as if they could transmit
                                break;
                            default:
                                on_channel = false; // make sure other modes do not look as if they could transmit
                                break;
                        }

                        // offset for CW Pitch to align display
                        if (bottom)
                        {
                            switch (rx2_dsp_mode)
                            {
                                case (DSPMode.CWL):
                                    rf_freq += cw_pitch;
                                    break;
                                case (DSPMode.CWU):
                                    rf_freq -= cw_pitch;
                                    break;
                            }
                        }
                        else
                        {
                            switch (rx1_dsp_mode)
                            {
                                case (DSPMode.CWL):
                                    rf_freq += cw_pitch;
                                    break;
                                case (DSPMode.CWU):
                                    rf_freq -= cw_pitch;
                                    break;
                            }
                        }



                        int chan_left_x = (int)((float)(c.Freq * 1e6 - rf_freq - c.BW / 2 - Low - rit) / (High - Low) * W);
                        int chan_right_x = (int)((float)(c.Freq * 1e6 - rf_freq + c.BW / 2 - Low - rit) / (High - Low) * W);

                        int chan_center_x = ((chan_right_x - chan_left_x) / 2) + chan_left_x; // ke9ns add

                        if (rf_freq < 25000000) chan_center_x = 0; // 25mhz check

                        if (chan_right_x == chan_left_x) chan_right_x = chan_left_x + 1;



                        // decide colors to draw notch
                        c1 = channel_background_off;
                        c2 = channel_foreground;

                        if (on_channel)
                        {
                            c1 = channel_background_on; // ke9ns darkens up when inside channel
                        }

                        if (bottom)
                            drawChannelBar(g, c, chan_left_x, chan_right_x, chan_center_x, H + top, H - top, c1, c2); // draw box and lines on RX2
                        else
                            drawChannelBar(g, c, chan_left_x, chan_right_x, chan_center_x, top, H - top, c1, c2);// draw box and lines on RX1

                        //if (bottom)
                        //    drawNotchStatus(g, n, (notch_left_x + notch_right_x) / 2, H + top + 75, W, H);
                        //else
                        //    drawNotchStatus(g, n, (notch_left_x + notch_right_x) / 2, top + 75, W, H);
                    }
                }  // for loop 60m channels

            } // setform.chkBoxChannels


#if (!NO_TNF)

            //===============================================================
            // Draw TNF NOTCH
            //===============================================================


            // draw notches if in RX
            if (!local_mox)
            {
                List<Notch> notches;
                if (!bottom)
                    notches = NotchList.NotchesInBW((double)vfoa_hz * 1e-6, Low, High);
                else
                    notches = NotchList.NotchesInBW((double)vfob_hz * 1e-6, Low, High);


                //draw notch bars in this for loop
                foreach (Notch n in notches)
                {
                    long rf_freq = vfoa_hz;
                    int rit = rit_hz;

                    if (bottom)
                    {
                        rf_freq = vfob_hz;
                    }

                    if (bottom)
                    {
                        switch (rx2_dsp_mode)
                        {
                            case (DSPMode.CWL):
                                rf_freq += cw_pitch;
                                break;
                            case (DSPMode.CWU):
                                rf_freq -= cw_pitch;
                                break;
                        }
                    }
                    else
                    {
                        switch (rx1_dsp_mode)
                        {
                            case (DSPMode.CWL):
                                rf_freq += cw_pitch;
                                break;
                            case (DSPMode.CWU):
                                rf_freq -= cw_pitch;
                                break;
                        }
                    }

                    int notch_left_x = (int)((float)(n.Freq * 1e6 - rf_freq - n.BW / 2 - Low - rit) / (High - Low) * W);
                    int notch_right_x = (int)((float)(n.Freq * 1e6 - rf_freq + n.BW / 2 - Low - rit) / (High - Low) * W);

                    if (notch_right_x == notch_left_x)
                        notch_right_x = notch_left_x + 1;

                    if (tnf_zoom && n.Details && ((bottom && n.RX == 2) || (!bottom && n.RX == 1)))
                    {
                        int zoomed_notch_center_freq = (int)(notch_zoom_start_freq * 1e6 - rf_freq - rit);

                        int original_bw = High - Low;
                        int zoom_bw = original_bw / 10;

                        int low = zoomed_notch_center_freq - zoom_bw / 2;
                        int high = zoomed_notch_center_freq + zoom_bw / 2;

                        if (low < Low) // check left limit
                        {
                            low = Low;
                            high = Low + zoom_bw;
                        }
                        else if (high > High) // check right limit
                        {
                            high = High;
                            low = High - zoom_bw;
                        }

                        int zoom_bw_left_x = (int)((float)(low - Low) / (High - Low) * W);
                        int zoom_bw_right_x = (int)((float)(high - Low) / (High - Low) * W);

                        Pen p = new Pen(Color.White, 2.0f);

                        if (!bottom)
                        {
                            // draw zoomed bandwidth outline TNF ZOOM
                            Point[] left_zoom_line_points = {
                                new Point(0, (int)(H/zoom_height)),
                                new Point(zoom_bw_left_x-1,(int)(0.5*H*(1+1/zoom_height))),
                                new Point(zoom_bw_left_x-1, H) };

                            g.DrawLines(p, left_zoom_line_points);

                            Point[] right_zoom_line_points = {
                                new Point(W, (int)(H/zoom_height)),
                                new Point(zoom_bw_right_x+1, (int)(0.5*H*(1+1/zoom_height))),
                                new Point(zoom_bw_right_x+1, H) };
                            g.DrawLines(p, right_zoom_line_points);

                            //grey out non-zoomed in area on actual panadapter
                            g.FillRectangle(new SolidBrush(Color.FromArgb(150, 0, 0, 0)), 0, H / zoom_height, zoom_bw_left_x, H - H / zoom_height);
                            g.FillRectangle(new SolidBrush(Color.FromArgb(150, 0, 0, 0)), zoom_bw_right_x, H / zoom_height, W - zoom_bw_right_x, H - H / zoom_height);
                        }
                        else
                        {
                            // draw zoomed bandwidth outline
                            Point[] left_zoom_line_points = {
                                new Point(0, H+(int)(H/zoom_height)),
                                new Point(zoom_bw_left_x-1, H+(int)(0.5*H*(1+1/zoom_height))),
                                new Point(zoom_bw_left_x-1, H+H) };
                            g.DrawLines(p, left_zoom_line_points);

                            Point[] right_zoom_line_points = {
                                new Point(W, H+(int)(H/zoom_height)),
                                new Point(zoom_bw_right_x+1, H+(int)(0.5*H*(1+1/zoom_height))),
                                new Point(zoom_bw_right_x+1, H+H) };
                            g.DrawLines(p, right_zoom_line_points);

                            g.FillRectangle(new SolidBrush(Color.FromArgb(160, 0, 0, 0)), 0, H + H / zoom_height, zoom_bw_left_x, H + H - H / zoom_height);
                            g.FillRectangle(new SolidBrush(Color.FromArgb(160, 0, 0, 0)), zoom_bw_right_x, H + H / zoom_height, W - zoom_bw_right_x, H + H - H / zoom_height);
                        }
                    } // tnf zoom

                    // decide colors to draw notch
                    c1 = notch_on_color;
                    c2 = notch_highlight_color;

                    if (!tnf_active)
                    {
                        c1 = notch_off_color;
                        c2 = Color.Black;
                    }
                    else if (n.Permanent)
                    {
                        c1 = notch_perm_on_color;
                        c2 = notch_perm_highlight_color;
                    }

                    if (bottom)
                        drawNotchBar(g, n, notch_left_x, notch_right_x, H + top, H - top, c1, c2);
                    else
                        drawNotchBar(g, n, notch_left_x, notch_right_x, top, H - top, c1, c2);
                }

                //draw notch statuses in this for loop
                if (!tnf_zoom)
                {
                    foreach (Notch n in notches)
                    {
                        long rf_freq = vfoa_hz;
                        int rit = rit_hz;

                        if (bottom)
                        {
                            rf_freq = vfob_hz;
                        }

                        if (bottom)
                        {
                            switch (rx2_dsp_mode)
                            {
                                case (DSPMode.CWL):
                                    rf_freq += cw_pitch;
                                    break;
                                case (DSPMode.CWU):
                                    rf_freq -= cw_pitch;
                                    break;
                            }
                        }
                        else
                        {
                            switch (rx1_dsp_mode)
                            {
                                case (DSPMode.CWL):
                                    rf_freq += cw_pitch;
                                    break;
                                case (DSPMode.CWU):
                                    rf_freq -= cw_pitch;
                                    break;
                            }
                        }

                        int notch_left_x = (int)((float)(n.Freq * 1e6 - rf_freq - n.BW / 2 - Low - rit) / (High - Low) * W);
                        int notch_right_x = (int)((float)(n.Freq * 1e6 - rf_freq + n.BW / 2 - Low - rit) / (High - Low) * W);

                        if (notch_right_x == notch_left_x)
                            notch_right_x = notch_left_x + 1;

                        if (bottom)
                            drawNotchStatus(g, n, (notch_left_x + notch_right_x) / 2, H + top + 75, W, H);
                        else
                            drawNotchStatus(g, n, (notch_left_x + notch_right_x) / 2, top + 75, W, H);
                    }
                }
            } // tnf
#endif // TNF



            //===============================================================
            // Draw VFO
            //===============================================================

            double vfo;
            if (rx == 1)
            {
                if (local_mox && !tx_on_vfob)
                {
                    if (split_enabled) vfo = vfoa_sub_hz;
                    else vfo = vfoa_hz;

                    vfo += xit_hz;
                }
                else
                {
                    vfo = vfoa_hz + rit_hz;

                }
            }
            else //if(rx==2)
            {
                if (local_mox && tx_on_vfob) vfo = vfob_hz + xit_hz;
                else vfo = vfob_hz + rit_hz;
            }

            if (!bottom)
            {
                switch (rx1_dsp_mode)
                {
                    case DSPMode.CWL:
                        vfo += cw_pitch;
                        break;
                    case DSPMode.CWU:
                        vfo -= cw_pitch;
                        break;
                    default:
                        break;
                }
            }
            else
            {
                switch (rx2_dsp_mode)
                {
                    case DSPMode.CWL:
                        vfo += cw_pitch;
                        break;
                    case DSPMode.CWU:
                        vfo -= cw_pitch;
                        break;
                    default:
                        break;
                }
            }



            //===============================================================
            // Draw vertical lines - band edge markers and freq text
            //===============================================================


            long vfo_round = ((long)(vfo / freq_step_size)) * freq_step_size;
            long vfo_delta = (long)(vfo - vfo_round);

            int f_steps = (width / freq_step_size) + 1; // freq_step_size = 50


            switch (console.CurrentRegion)
            {
                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                #region US
                case FRSRegion.US: // 

                    for (int i = 0; i < f_steps + 1; i++) // ke9ns: step to each freq label across the display
                    {
                        string label;
                        int offsetL; // X pixel offset for every 10khz based on screen size and zoom etc 
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;


                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 0.1357 || actual_fgrid == 0.1358 ||   // 2200m band edges
                                actual_fgrid == 0.472 || actual_fgrid == 0.479 ||   // 630m band edges
                                actual_fgrid == 1.8 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 4.0 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||
                                actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 26.960 || actual_fgrid == 27.410 || // ke9ns add CB
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 148.0)
                            {


                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------
                                // US region 

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;



                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5 (2khz per vertical line
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);


                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);

                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge (below)
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    //   if (PON == true)
                                    //  {
                                    //       if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // draw vertical lines below the freq labels
                                    //       else g.DrawLine(grid_pen, vgrid, H, vgrid + (((H - top) / Y1) * X1), top);            
                                    //   }
                                    //   else
                                    //   {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // draw vertical lines below the freq labels
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                                                                                //   }
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;



                                // ke9ns: draw the vert lines in between the freq labels
                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        //  if (PON == true)
                                        //  {
                                        //      if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        //      else g.DrawLine(grid_pen_dark, x3, H, x3 + (((H-top)/Y1)*X1 ), top);
                                        //  }
                                        //  else
                                        //  {
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                        //  }
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)


                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));



                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps



                    int[] band_edge_list_r2 = {  0135700, 0137800, 0472000, 0479000,  1800000, 2000000, 3500000, 4000000, 5250000,5450000,
                                                7000000, 7300000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 26960000, 27410000, 28000000, 29700000, 50000000, 54000000, 144000000, 148000000 }; // ke9ns add CB

                    for (int i = 0; i < band_edge_list_r2.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r2[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }

                    } // for (int i = 0; i < f_steps + 1; i++)


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges (NOT FOR US), BUT FOR CANADA

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14 = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 }; //  5351.5 - 5366.5 kHz  

                        bool onetime = false;
                        bool onetime1 = false;

                        for (int i = 0; i < band_edge_list_r14.Length; i++)
                        {

                            double band_edge_offset = band_edge_list_r14[i] - vfo; // in hz

                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;

                                    StringFormat SF = new StringFormat();
                                    SF.Alignment = StringAlignment.Near;
                                    SF.FormatFlags = StringFormatFlags.DirectionVertical;

                                    if (onetime == false) g.DrawString("IARU1/2 only", font1, grid_text_brush, _x, _y + 10, SF); // draw bandtext vertically
                                    onetime = true;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {

                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;

                                    StringFormat SF1 = new StringFormat();
                                    SF1.Alignment = StringAlignment.Near;
                                    SF1.FormatFlags = StringFormatFlags.DirectionVertical;

                                    if (onetime1 == false) g.DrawString("IARU1/2 only", font1, grid_text_brush, _x, _y + 10, SF1); // draw bandtext vertically
                                    onetime1 = true;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }

                            }


                        } // 60m europe

                    }

                    break; // case FRSRegion.US:
                #endregion


                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                #region UK

                case FRSRegion.UK_Plus:

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 || // ke9ns fix from 50.08
                                actual_fgrid == 144.0 || actual_fgrid == 147.0) // 147 is an experimental portion of 2m
                            {

                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block

                    // draw band edge markers for bands not 60m
                    int[] band_edge_list_r3 = { 18068000, 18168000, 1810000, 2000000, 3500000, 3800000, 5250000,5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 147000000 }; // ke9ns fix 50080000

                    for (int i = 0; i < band_edge_list_r3.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r3[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }
                    // draw 60m band segment rectangles - UK+ only
                    int[] band_edge_list_r4 = { 5258500, 5264000, 5276000, 5284000, 5288500, 5292000,
                                                5298000, 5307000, 5313000, 5323000, 5333000, 5338000,
                                                5354000, 5358000, 5362000, 5374500, 5378000, 5382000,
                                                5395000, 5401500, 5403500, 5406500 };

                    for (int i = 0; i < band_edge_list_r4.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r4[i] - vfo;
                        if (bottom)
                        {
                            if (is_first)
                            {
                                _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                _y = H + top;
                                is_first = false;
                            }
                            else
                            {
                                _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                _height = (H + H) - _y;
                                g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                is_first = true;
                            }
                        }
                        else
                        {
                            if (is_first)
                            {
                                _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                _y = top;
                                is_first = false;
                            }
                            else
                            {
                                _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                _height = H - _y;
                                g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                is_first = true;
                            }
                        }
                    } //  for (int i = 0; i < band_edge_list_r4.Length; i++)

                    break; //   case FRSRegion.UK_Plus:

                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                #region EU

                case FRSRegion.Europe:      // EU00 (IARU1 60m) & 51mhz 6m Germany


                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.03 || actual_fgrid == 51.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {

                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    //---------------------------------------------------------------------------------------------------EU00
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1 = { 1810000, 2000000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50030000, 51000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }

                    // draw 60m band segment rectangles - Sweden
                    //  int[] band_edge_list_r6 = { 5310000, 5313000, 5320000, 5323000, 5380000, 5383000, 5390000, 5393000 }; // ke9ns this was the old band plan before adopting IARU region 1 60m

                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges for europe

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r19 = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 }; //  5351.5 - 5366.5 kHz

                        for (int i = 0; i < band_edge_list_r19.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r19[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m europe
                    }
                    break; // EU00


                #endregion

                #region France

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                case FRSRegion.UK:          // EU01 (no 60m) & 52mhz 6m(UK+ has its own special segments)
                case FRSRegion.France:      // EU01 (no 60m)
                case FRSRegion.Slovakia:    // EU01 (no 60m)
                case FRSRegion.ES_CH_FIN:   // EU12 (IARU1 60m) & (52mhz for 6m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {

                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    //---------------------------------------------------------------------------------------------------EU01 and EU12
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1a = { 1810000, 2000000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1a.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1a[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges  for UK, france, slovakia and es_ch_fin

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14a = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14a.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14a[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m uk 

                    }
                    break; // EU01, EU12


                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                #region Norway

                case FRSRegion.Norway:      // EU03  (5.25 to 5.45 60m) & 52mhz 6m) (also includes Czech rep)
                case FRSRegion.Denmark:     // EU03  (5.25 to 5.45 60m) & 52mhz 6m)
                case FRSRegion.EU_Travel:   // EU14 (5.25 to 5.45) & 52mhz for 6m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.74 || actual_fgrid == 24.99 || // was 24.89
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {

                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    //---------------------------------------------------------------------------------------------------EU03 and EU14
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1b = { 1810000, 2000000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1b.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1b[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }

                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges  for norway denmark, eu_travel

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14aa = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14aa.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14aa[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m uk 
                    }
                    break; // EU03, EU14

                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region Belgium
                case FRSRegion.Belgium:     // EU04 (IARU1 60m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 1.88 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {

                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    //---------------------------------------------------------------------------------------------------EU04
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1c = { 1810000, 2000000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1c.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1c[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges  belgium

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14c = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14c.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14c[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m  
                    }
                    break; // EU04

                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region Hungary

                case FRSRegion.Hungary:     // EU05 

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.201 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {

                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    //---------------------------------------------------------------------------------------------------EU05
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1d = { 1810000, 2000000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1d.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1d[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges  hungary 

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14d = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14d.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14d[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m  
                    }
                    break; // EU05

                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region sweden
                case FRSRegion.Sweden:      // EU06 (IARU1 60m) & (52mhz for 6m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block



                    //--------------------------------------------------------------------------------------------------- EU06
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1e = { 1810000, 2000000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1e.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1e[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges  sweden

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14e = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14e.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14e[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m 
                    }

                    break; // EU06


                #endregion
                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region Bul                
                case FRSRegion.Bulgaria:    // EU07 (no 60m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 1.85 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.05 || actual_fgrid == 50.2 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    //---------------------------------------------------------------------------------------------------EU07
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1f = { 1810000, 1850000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50050000, 50200000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1f.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1f[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges  bulgaria

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14f = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14f.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14f[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m 
                    }
                    break; // EU07


                #endregion


                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                #region Lat  

                case FRSRegion.Latvia:      // EU08 (no 60m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.00 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 51.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block



                    //---------------------------------------------------------------------------------------------------EU08
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1g = { 1810000, 2000000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 51000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1g.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1g[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges latvia 

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14g = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14g.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14g[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m 
                    }
                    break; // EU08

                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                #region Greece

                case FRSRegion.Greece:      // EU09 (no 60m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 1.85 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block

                    //--------------------------------------------------------------------------------------------------- EU09
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1h = { 1810000, 1850000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1h.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1h[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges  greece

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14h = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14h.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14h[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m 
                    }
                    break; // EU09

                #endregion
                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region Italy
                case FRSRegion.Italy:       // EU10 (no 60m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.83 || actual_fgrid == 1.85 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 51.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 148.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    // EU10
                    int[] band_edge_list_r9 = {  1830000, 1850000, 3500000, 3800000, 5250000,5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 51000000, 144000000, 148000000 };

                    for (int i = 0; i < band_edge_list_r9.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r9[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    // draw 60m italy

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        // draw 60m band segment rectangles - European ( Germany, Belgium, Spain, Switzerland, Finland, Luxembourg)
                        int[] band_edge_list_r7 = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 }; // but no TX on 60m

                        for (int i = 0; i < band_edge_list_r7.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r7[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                        } // for loop for 60m
                    }
                    break; //EU10
                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                #region Italyplus
                case FRSRegion.Italy_Plus: // EU11 (no 60m)
                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.83 || actual_fgrid == 1.85 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 6.975 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 51.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 148.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    // EU11
                    int[] band_edge_list_r9a = {  1830000, 1850000, 3500000, 3800000, 5250000,5450000,
                                                6975000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 51000000, 144000000, 148000000 };

                    for (int i = 0; i < band_edge_list_r9a.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r9a[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }

                    if (vfo > 5000000 && vfo < 6000000)
                    {

                        // draw 60m band segment rectangles - European ( Germany, Belgium, Spain, Switzerland, Finland, Luxembourg)
                        int[] band_edge_list_r7a = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 }; // but no TX on 60m

                        for (int i = 0; i < band_edge_list_r7a.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r7a[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                        } // for loop for 60m
                    }
                    break; //EU11

                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region nether
                case FRSRegion.Netherlands: // EU13 (5.35 to 5.45 60m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 1.88 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block



                    //--------------------------------------------------------------------------------------------------- EU13
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1j = { 1810000, 1880000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1j.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1j[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }

                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges for europe

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r19a = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 }; //  5351.5 - 5366.5 kHz

                        for (int i = 0; i < band_edge_list_r19a.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r19a[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m europe
                    }

                    break; // EU13


                #endregion
                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region Lux
                case FRSRegion.Luxembourg:  // EU15 (IARU1 60m) & 52mhz for 6m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block



                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1k = { 1810000, 2000000, 3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000,  50000000, 52000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1k.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1k[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }



                    // 60m luxumbourg

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14l = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14l.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14l[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                        } // for loop for 60m

                    }
                    break; //EU15

                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region IARU2
                case FRSRegion.IARU2:  // IARU2

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.80 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 4.0 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 148.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block



                    //---------------------------------------------------------------------------------------------------IARU2
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1r = { 1800000, 2000000, 3500000, 4000000, 5250000, 5450000,
                                                7000000, 7300000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000,  50000000, 54000000, 144000000, 148000000 };

                    for (int i = 0; i < band_edge_list_r1r.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1r[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }



                    //---------------------------------------------------------------------------------------------------EU15
                    //---------------------------------------------------------------------------------------------------
                    // 60m IARU1

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14r = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14r.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14r[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                        } // for loop for 60m
                    }

                    break; // IARU 2

                #endregion
                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region Aus 
                case FRSRegion.Australia:  // 

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 1.875 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 147.975)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block


                    //---------------------------------------------------------------------------------------------------IARU2
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1z = { 1810000, 2000000, 3500000, 3400000, 5250000, 5450000,
                                                7000000, 7300000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000,  50000000, 54000000, 144000000, 147975000 };

                    for (int i = 0; i < band_edge_list_r1z.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1z[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }



                    //---------------------------------------------------------------------------------------------------EU15
                    //---------------------------------------------------------------------------------------------------

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14z = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14z.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14z[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                        } // for loop for 60m

                    }
                    break; // Australia


                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                #region Russia

                case FRSRegion.Russia:      // RUSS (no 60m)

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 25.14 ||
                                actual_fgrid == 26.97 || actual_fgrid == 27.86 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 146.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block



                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    int[] band_edge_list_r1q = { 1810000, 2000000,  3500000, 3800000, 5250000, 5450000,
                                                7000000, 7200000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 25140000, 26970000, 27860000, 28000000, 29700000, 50000000, 54000000, 144000000, 146000000 };

                    for (int i = 0; i < band_edge_list_r1q.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r1q[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }


                    //---------------------------------------------------------------------------------------------------
                    //---------------------------------------------------------------------------------------------------
                    // 60m edges  

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        int[] band_edge_list_r14q = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 };

                        for (int i = 0; i < band_edge_list_r14q.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r14q[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }


                        } // 60m uk 
                    }
                    break; //RUSS


                #endregion

                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================
                #region Japan

                case FRSRegion.IARU3: // (no 60m)
                case FRSRegion.Japan:

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.8 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.9 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 148.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    // end of FRSRegion common block



                    int[] band_edge_list_r8 = {  1800000, 2000000, 3500000, 3900000, 5250000,5450000,
                                                7000000, 7300000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 54000000, 144000000, 148000000 };

                    for (int i = 0; i < band_edge_list_r8.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r8[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }

                    if (console.CurrentRegion == FRSRegion.Japan) // 
                    {
                        if (vfo < 6000000)
                        {
                            // draw special 80 segments, emergency channel, and 60m band segment rectangles - European ( Germany, Belgium, Spain, Switzerland, Finland, Luxembourg) NO TX in 60m
                            int[] band_edge_list_r15 = { 1810000, 1825000, 1907500, 1912500, 3500000, 3575000, 3599000, 3612000, 3680000, 3687000, 3702000, 3716000, 3745000, 3770000, 3791000, 3805000, 4629995, 4630005, 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 }; // no TX

                            for (int i = 0; i < band_edge_list_r15.Length; i++)
                            {
                                double band_edge_offset = band_edge_list_r15[i] - vfo;
                                if (bottom)
                                {
                                    if (is_first)
                                    {
                                        _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                        _y = H + top;
                                        is_first = false;
                                    }
                                    else
                                    {
                                        _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                        _height = (H + H) - _y;
                                        g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                        is_first = true;
                                    }
                                }
                                else
                                {
                                    if (is_first)
                                    {
                                        _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                        _y = top;
                                        is_first = false;
                                    }
                                    else
                                    {
                                        _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                        _height = H - _y;
                                        g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                        is_first = true;
                                    }
                                }
                            } // for loop for 60m
                        }
                    } // Japan
                    else // Region 3 (asia)
                    {

                        if (vfo > 5000000 && vfo < 6000000)
                        {
                            // draw 60m band segment rectangles - European ( Germany, Belgium, Spain, Switzerland, Finland, Luxembourg)
                            int[] band_edge_list_r15 = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 }; // no TX

                            for (int i = 0; i < band_edge_list_r15.Length; i++)
                            {
                                double band_edge_offset = band_edge_list_r15[i] - vfo;
                                if (bottom)
                                {
                                    if (is_first)
                                    {
                                        _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                        _y = H + top;
                                        is_first = false;
                                    }
                                    else
                                    {
                                        _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                        _height = (H + H) - _y;
                                        g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                        is_first = true;
                                    }
                                }
                                else
                                {
                                    if (is_first)
                                    {
                                        _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                        _y = top;
                                        is_first = false;
                                    }
                                    else
                                    {
                                        _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                        _height = H - _y;
                                        g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                        is_first = true;
                                    }
                                }
                            } // for loop for 60m
                        }
                    }

                    break;  // FRSRegion.IARU3 &  Japan 

                #endregion
                //============================================================================================================
                //============================================================================================================
                //============================================================================================================
                //===============================================

                #region China
                case FRSRegion.China:

                    for (int i = 0; i < f_steps + 1; i++)
                    {
                        string label;
                        int offsetL;
                        int offsetR;

                        int fgrid = i * freq_step_size + (Low / freq_step_size) * freq_step_size;
                        double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                        int vgrid = (int)((double)(fgrid - vfo_delta - Low) / (High - Low) * W);

                        if (!show_freq_offset)
                        {
                            if (actual_fgrid == 1.8 || actual_fgrid == 2.0 ||
                                actual_fgrid == 3.5 || actual_fgrid == 3.9 ||
                                actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                actual_fgrid == 144.0 || actual_fgrid == 148.0)
                            {
                                // BEGIN of FRSRegion common block
                                if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // draw vertical scale lines
                                else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                label = actual_fgrid.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {

                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {                                                                                       // Debug.WriteLine("=DISPLAY SWR SLOT: " + SLOT + " , " + Math.Round(actual_fgrid, 4));
                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > 0.6) // values of 0.5 are place in the SWR_READ[] array as filler for empty data areas of the ke9ns_SWR file, so ignore, but keep going until you get to actual SWR data
                                            {
                                                //  Debug.WriteLine("=DISPLAY SWR: " + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } // if (SWRF > 0.6)

                                        } // SWR_Multi

                                    } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                } //  if (console.ScanForm.checkBoxSWR.Checked)
                                //----------------------------------------------------------------


                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;

                                for (int j = 1; j < inbetweenies; j++)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 )
                                    {
                                        float x3 = (float)vgrid + (j * scale);

                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // ke9ns vertical lines
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = SLOT + 2; // 2khz per line
                                                             //   Debug.WriteLine(">DISPLAY SWR SLOT: " + SLOT);
                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {
                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                                if (SWRF > .6)
                                                {
                                                    // Debug.WriteLine(">DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF);
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }
                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } // if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0) 

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //----------------------------------------------------------------

                                } // for loop inbetweenies
                            } // band edge
                            else // not band edge
                            {
                                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                {
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H); // vertical lines on the label
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                }

                                int fgrid_2 = ((i + 1) * freq_step_size) + (int)((Low / freq_step_size) * freq_step_size);
                                int x_2 = (int)(((float)(fgrid_2 - vfo_delta - Low) / width * W));
                                float scale = (float)(x_2 - vgrid) / inbetweenies;


                                for (int j = 1; j < inbetweenies; j++) // inbetweenies = 5  (so 4 (2khz) spaced vert lines inbetween labels)
                                {
                                    if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if (bottom) g.DrawLine(grid_pen_dark, x3, H + top, x3, H + H); // vertical lines in between the labels
                                        else g.DrawLine(grid_pen_dark, x3, top, x3, H);
                                    }

                                    //----------------------------------------------------------------
                                    // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                    if (console.ScanForm.checkBoxSWR.Checked)
                                    {
                                        float x3 = (float)vgrid + (j * scale);
                                        if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                        {
                                            SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value

                                            SLOT = SLOT + 2 * j; // 2khz per line

                                            // Debug.WriteLine("#DISPLAY SWR SLOT: " + SLOT);

                                            if (SWR_Multi == false) SWR_C = TESTRUN;
                                            else SWR_C = 1;

                                            for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                            {

                                                SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot
                                                if (SWRF > .6)
                                                {
                                                    //  Debug.WriteLine("#DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF );
                                                    if (SWRF >= SWR_HIGH)
                                                    {
                                                        SWR_Brush = SWR_Brush_red;
                                                        SWR_pen = SWR_pen_red;
                                                    }
                                                    else if (SWRF > SWR_MED)
                                                    {
                                                        SWR_Brush = SWR_Brush_yellow;
                                                        SWR_pen = SWR_pen_yellow;
                                                    }
                                                    else
                                                    {
                                                        SWR_Brush = SWR_Brush_green;
                                                        SWR_pen = SWR_pen_green;
                                                    }

                                                    if (bottom) g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                    g.DrawLine(SWR_pen, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y, x3, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                    if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                    g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, x3 - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                                } //  if (SWRF > .6)
                                            } // SWR_MULTI

                                        } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                    } //  if (console.ScanForm.checkBoxSWR.Checked)
                                    //---------------------------------------------------------------------

                                } //  for (int j = 1; j < inbetweenies; j++)

                                // make freq grid labels (white freq labels not the red band edges)
                                double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                label = actual_fgrid_label.ToString("f4");
                                label = label.Replace(",", ".");    // handle Windows localization issues
                                int offset = label.IndexOf('.') + 4;
                                label = label.Insert(offset, ".");

                                if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                else offsetL = (int)((label.Length) * 4.1) - 8;

                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));

                                //----------------------------------------------------------------
                                // ke9ns add Check for SWR PLOT Display (ANT and BAND at top of this routine)
                                if (console.ScanForm.checkBoxSWR.Checked)
                                {
                                    if ((Freq_Low > 0) && (Freq_High > 0) && (Freq_Step > 0) && (Freq_Low <= Math.Round(actual_fgrid, 4)) && (Freq_High >= Math.Round(actual_fgrid, 4))) // 3.5 < 3.9 (example)
                                    {
                                        SLOT = 10 + (int)(((decimal)Math.Round(actual_fgrid, 4) - (decimal)Freq_Low) * 1000); // convert difference in freq to 1 khz SLOT value
                                                                                                                              // Debug.WriteLine("DISPLAY SWR SLOT: " + SLOT + " , " + actual_fgrid_label.ToString() + " , " + Freq_Low.ToString() );
                                        if (SWR_Multi == false) SWR_C = TESTRUN;
                                        else SWR_C = 1;

                                        for (SWR_Count = TESTRUN, SWR_Y = 0, SWR_YS = 0; SWR_C <= SWR_Count; SWR_C++, SWR_Y += SWR_Step, SWR_YS += SWR_Step)
                                        {

                                            SWRF = console.SWR_READ[SWR_C, (int)ANT1, (int)BAND1, SLOT]; // grab SWR value for current antenna and band at this particular slot

                                            if (SWRF > .6)
                                            {
                                                //   Debug.WriteLine("DISPLAY SWR: "  + Math.Round(actual_fgrid, 4) + " , " + SWRF + " , " + vgrid + " , " + offsetL);
                                                if (SWRF >= SWR_HIGH)
                                                {
                                                    SWR_Brush = SWR_Brush_red;
                                                    SWR_pen = SWR_pen_red;
                                                }
                                                else if (SWRF > SWR_MED)
                                                {
                                                    SWR_Brush = SWR_Brush_yellow;
                                                    SWR_pen = SWR_pen_yellow;
                                                }
                                                else
                                                {
                                                    SWR_Brush = SWR_Brush_green;
                                                    SWR_pen = SWR_pen_green;
                                                }

                                                if (bottom) g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + H + 25 + SWR_Y + (int)(SWRF * SWRLINE));
                                                g.DrawLine(SWR_pen, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y, vgrid, (float)Math.Floor(H * .01) + 25 + SWR_Y + (int)(SWRF * SWRLINE));

                                                if (bottom) g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, H + (float)Math.Floor(H * .01) + 15 + SWR_YS);
                                                g.DrawString(SWRF.ToString("#0.0"), font, SWR_Brush, vgrid - 10, (float)Math.Floor(H * .01) + 15 + SWR_YS);

                                            } //  if (SWRF > .6) 
                                        } // SWR_MULTI
                                    } //  if ((Freq_Low > 0) && (Freq_High > 0)

                                } //  if (console.ScanForm.checkBoxSWR.Checked)

                                //---------------------------------------------------

                            } //not band edge (above)

                        }  //  if (!show_freq_offset)
                        else
                        {
                            vgrid = Convert.ToInt32((double)-(fgrid - Low) / (Low - High) * W); //wa6ahl

                            if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                            {
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                            }

                            double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                            label = fgrid.ToString();
                            offsetL = (int)((label.Length + 1) * 4.1);
                            offsetR = (int)(label.Length * 4.1);
                            if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                            {
                                if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .01));
                                else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .01));
                            }
                        }
                    } // for loop f_steps

                    //---------------------------------------------------------------


                    int[] band_edge_list_r8a = {  1800000, 2000000, 3500000, 3900000, 5250000,5450000,
                                                7000000, 7300000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                                24890000, 24990000, 28000000, 29700000, 50000000, 54000000, 144000000, 148000000 };

                    for (int i = 0; i < band_edge_list_r8a.Length; i++)
                    {
                        double band_edge_offset = band_edge_list_r8a[i] - vfo;
                        if (band_edge_offset >= Low && band_edge_offset <= High)
                        {
                            int temp_vline = (int)((double)(band_edge_offset - Low) / (High - Low) * W);//wa6ahl
                            if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H + top, temp_vline, H + H);//wa6ahl
                            else g.DrawLine(new Pen(band_edge_color), temp_vline, top, temp_vline, H);//wa6ahl
                        }
                    }

                    if (vfo > 5000000 && vfo < 6000000)
                    {
                        // draw 60m band segment rectangles - European ( Germany, Belgium, Spain, Switzerland, Finland, Luxembourg, China, IARU2)
                        int[] band_edge_list_r15a = { 5351500, 5353999, 5354000, 5365999, 5366000, 5366500 }; // no TX

                        for (int i = 0; i < band_edge_list_r15a.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r15a[i] - vfo;
                            if (bottom)
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = H + top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = (H + H) - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                            else
                            {
                                if (is_first)
                                {
                                    _x = (int)((double)(band_edge_offset - Low) / (High - Low) * W);
                                    _y = top;
                                    is_first = false;
                                }
                                else
                                {
                                    _width = ((int)((double)(band_edge_offset - Low) / (High - Low) * W)) - _x;
                                    _height = H - _y;
                                    g.DrawRectangle(new Pen(band_box_color, band_box_width), new Rectangle(_x, _y, _width, _height));
                                    is_first = true;
                                }
                            }
                        } // for loop for 60m
                    }

                    break;  // FRSRegion.China

                    #endregion // china


            } // switch Band edges (all regions)



            //===============================================================
            // Draw horizontal lines  ke9ns hstep
            //===============================================================

            for (int i = 1; i < h_steps; i++)  // h_steps number of times
            {
                int xOffset = 0;

                int num;


                if ((K9 == 5) & (K10 != 5) && (bottom)) num = spectrum_grid_max - (i * (spectrum_grid_step * 2));  //ke9ns mod we want RX2 step to be the same as RX1 while in panafall
                else if ((K9 == 5) & (K10 == 5) && (bottom)) num = spectrum_grid_max - (i * (spectrum_grid_step * 2));  // ke9ns mod we want RX2 step to be the same as RX1 while in panafall 
                else num = spectrum_grid_max - (i * grid_step);                // generate the proper db number

                int y;
                if ((K9 == 5) & (K10 != 5) && (bottom)) y = (int)((double)(spectrum_grid_max - num) * H1 / y_range);   // ke9ns mod
                else if ((K9 == 5) & (K10 == 5) && (bottom)) y = (int)((double)(spectrum_grid_max - num) * H1 / y_range); // ke9ns mod
                else y = (int)((double)(spectrum_grid_max - num) * H / y_range);

                if (grid_off == 0) // ke9ns add (dont draw grid lines if =1 
                {
                    if (bottom) g.DrawLine(grid_pen, 0, H + y, W, H + y);  // draw lines 
                    else g.DrawLine(grid_pen, 0, y, W, y);
                }


                if ((console.BeaconSigAvg == true)) // ke9ns add draw blue line to show 0 and 1 threshold for BCD time signal from WWV
                {


                    if ((bottom == false))
                    {
                        if ((SpotForm.WTime == true) && (SpotForm.WWVPitch == false))
                        {
                            int thres = (int)((double)(spectrum_grid_max - SpotForm.WWVThreshold) * H / y_range);

                            g.DrawLine(p3, 100, thres, W - 100, thres);

                            string temp = IndexS.ToString(); // SpotForm.IndexS

                            g.DrawString(temp, font, grid_text_brush, 600, thres - 15);

                            // g.DrawLine(p3, 100, thres, W - 100, thres);
                        }


                    } // if bottom = false

                } //  if ((console.BeaconSigAvg == true)) 
                else if ((console.RTTY == true)) // draw Mark and Space lines for RTTY decoding
                {

                    // int center_line_x = (int)(-(double)low / (high - low) * W); // ke9ns 885 full screen (shrunk 643) =(97370/(176741))*1607
                    // g.DrawLine(new Pen(grid_zero_color), center_line_x, top, center_line_x, H); // 0hz line position on screen, Mark = 1000hz Space = 1170hz
                    // filter_left_x = (int)((float)(tx_filter_low - Low + xit_hz - rit_hz) / (High - Low) * W); //original

                    if ((bottom == false))
                    {

                        int Mark = (int)((float)(SpotForm.RTTYBASE - Low + xit_hz - rit_hz) / (High - Low) * W); // 
                        int Space = (int)((float)((SpotForm.RTTYBASE + SpotForm.RTTYSHIFT) - Low + xit_hz - rit_hz) / (High - Low) * W); // 

                        g.DrawLine(new Pen(Color.Orange, 1.0f), Mark, H, Mark, top); // Mark = 1000hz
                        g.DrawLine(new Pen(Color.Orange, 1.0f), Space, H, Space, top); // Mark = 1000hz
                    }

                } // RTTY
                else if ((console.RXCW == true)) // draw Mark and Space lines for RTTY decoding
                {
                    if ((bottom == false))
                    {
                        int Mark = (int)((float)(SpotForm.CWBase - Low + xit_hz - rit_hz) / (High - Low) * W); // 
                        g.DrawLine(new Pen(Color.Orange, 1.0f), Mark, H, Mark, top); // Mark = 600hz usually
                    }

                } // CW

                //   if (bottom) Debug.WriteLine("bottom..H " + H + " hpstep " + h_pixel_step + " hstep "+ h_steps + " top " + top + " num "+num + " gstep "+ grid_step + " Y "+ y + " yrange " + y_range);
                //   else Debug.WriteLine("top..H " + H + " hpstep " + h_pixel_step + " hstep " + h_steps + " top " + top + " num " + num + " gstep " + grid_step + " Y " + y + " yrange " + y_range);


                //===============================================================
                // Draw horizontal line labels
                //===============================================================
                if (i != 1) // avoid intersecting vertical and horizontal labels
                {

                    if ((K9 == 5) & (K10 != 5) && (bottom)) num = spectrum_grid_max - (i * (spectrum_grid_step * 2)); // ke9ns mod (lines based on area of panadapter and waterfall etc)
                    else if ((K9 == 5) & (K10 == 5) && (bottom)) num = spectrum_grid_max - (i * (spectrum_grid_step * 2)); // ke9ns mod
                    else num = spectrum_grid_max - (i * grid_step);

                    string label = num.ToString();
                    if (label.Length == 3) xOffset = (int)g.MeasureString("-", font).Width - 2;

                    int offset = (int)(label.Length * 4.1);
                    SizeF size = g.MeasureString(label, font);

                    int x = 0;
                    switch (display_label_align)
                    {
                        case DisplayLabelAlignment.LEFT:
                            x = xOffset + 3;
                            break;
                        case DisplayLabelAlignment.CENTER:
                            x = center_line_x + xOffset;
                            break;
                        case DisplayLabelAlignment.RIGHT:
                            x = (int)(W - size.Width - 3);
                            break;
                        case DisplayLabelAlignment.AUTO:
                            x = xOffset + 3;
                            break;
                        case DisplayLabelAlignment.Sunit: // ke9ns add
                            x = xOffset + 3;
                            break;
                        case DisplayLabelAlignment.OFF:
                            x = W;
                            break;
                    }

                    y -= 8;

                    if ((y + 9) < H)
                    {

                        if (bottom) g.DrawString(label, font, grid_text_brush, x, H + y);  // draw dBm readings
                        else g.DrawString(label, font, grid_text_brush, x, y);


                        //-----------------------------------------------------------------------------
                        // ke9ns add to show S units for both HF and VHF
                        //  was if (grid_off == 1) // ke9ns add  (when grid off then draw dBm number on right side )
                        if ((!local_mox) && ((display_label_align == DisplayLabelAlignment.LEFT) || (display_label_align == DisplayLabelAlignment.AUTO) || (display_label_align == DisplayLabelAlignment.Sunit))) // ke9ns add 
                        {

                            string SS;

                            if (VFOA < 30000000)
                            {
                                if (num >= -68) // wait until your 5dbm over s9
                                {
                                    SS = "+" + (num + 73).ToString();
                                }

                                else if (num >= -73) SS = "S9"; // S9 is -73 to -64
                                else if (num >= -79) SS = "S8"; // S8 is -79 to -74
                                else if (num >= -85) SS = "S7"; // S7 is -85 to -80
                                else if (num >= -91) SS = "S6"; // S6 is -91 to -86
                                else if (num >= -97) SS = "S5"; // S5 is -97 to -92
                                else if (num >= -103) SS = "S4"; // S4 is -103 to -98
                                else if (num >= -109) SS = "S3"; // S3 is -109 to -104 
                                else if (num >= -115) SS = "S2"; // S2 is -115 to -110
                                else if (num >= -121) SS = "S1"; // S1 is -121 to -114 
                                else SS = "<S1";                  // S0 is -133 to -122
                            }
                            else // VHF S readings
                            {

                                if (num >= -88) // wait until your 5dbm over s9
                                {
                                    SS = "+" + (num + 93).ToString();
                                }

                                else if (num >= -93) SS = "S9";  // S9 is -93 to -82
                                else if (num >= -99) SS = "S8";  // S8 is -99 to -94
                                else if (num >= -105) SS = "S7"; // S7 is -105 to -100
                                else if (num >= -111) SS = "S6"; // S6 is -111 to -106
                                else if (num >= -117) SS = "S5"; // S5 is -117 to -112
                                else if (num >= -123) SS = "S4"; // S4 is -123 to -118
                                else if (num >= -129) SS = "S3"; // S3 is -129 to -124 
                                else if (num >= -135) SS = "S2"; // S2 is -135 to -130
                                else if (num >= -141) SS = "S1"; // S1 is -141 to -134 
                                else SS = "<S1";                  // S0 is -153 to -142
                            }


                            size = g.MeasureString(SS, font);

                            x = (int)(W - size.Width - 3); //draw on right side

                            if (bottom) g.DrawString(SS, font, grid_text_brush, x, H + y); // draw S meter readings on Right side of screen only
                            else g.DrawString(SS, font, grid_text_brush, x, y);

                        } //  display dbm on left


                    } // if( (y+9) < H)



                } // i != 0

            } // for loop to draw hor lines and db numbers



            //===============================================================
            // Draw 0Hz vertical line if visible
            //===============================================================

            if (center_line_x >= 0 && center_line_x <= W)
            {
                if (bottom)
                {
                    g.DrawLine(new Pen(grid_zero_color), center_line_x, H + top, center_line_x, H + H);
                    g.DrawLine(new Pen(grid_zero_color), center_line_x + 1, H + top, center_line_x + 1, H + H);
                }
                else
                {
                    g.DrawLine(new Pen(grid_zero_color), center_line_x, top, center_line_x, H);
                    g.DrawLine(new Pen(grid_zero_color), center_line_x + 1, top, center_line_x + 1, H);
                }
            }

            if (show_freq_offset)
            {
                if (bottom) g.DrawString("0", font, new SolidBrush(grid_zero_color), center_line_x - 5, H + (float)Math.Floor(H * .01));
                else g.DrawString("0", font, new SolidBrush(grid_zero_color), center_line_x - 5, (float)Math.Floor(H * .01));
            }

            if (high_swr && rx == 1)
                g.DrawString("High SWR", new System.Drawing.Font("Arial", 14, FontStyle.Bold), new SolidBrush(Color.Red), 245, 20);



            //===============================================================================================================================================================
            //===============================================================================================================================================================
            //===============================================================================================================================================================
            //===============================================================================================================================================================
            //=====================================================================
            //=====================================================================
            // ke9ns add DRAW BandText ON PANADAPTER
            //=====================================================================
            //=====================================================================


            if ((!mox) && (console.chkPower.Checked == true) && (SpotForm.chkBoxBandText.Checked == true))
            {

                if (!bottom) // RX1
                {
                    VFOLow = (int)vfoa_hz + RXDisplayLow; // low freq (left side) in hz
                    VFOHigh = (int)vfoa_hz + RXDisplayHigh; // high freq (right side) in hz
                    VFODiff = VFOHigh - VFOLow; // diff in hz

                    decimal VFOLowB = (decimal)((float)VFOLow / 1000000); // freq in mhz
                    decimal VFOHighB = (decimal)((float)VFOHigh / 1000000); // freq in mhz
                    decimal VFOC = (decimal)((float)vfoa_hz / 1000000); // freq in mhz

                    int tempL = (int)(VFOLowB * 1000);
                    int tempH = (int)(VFOHighB * 1000);
                    int tempC = (int)(VFOC * 1000); // current freq in mhz 7.128 (down to khz only)

                    VFOLowB = (decimal)tempL / 1000;
                    VFOHighB = (decimal)tempH / 1000; // ke9ns only allow freq in MHZ down to khz 7.123456 becomes 7.123 mhz
                    VFOC = (decimal)tempC / 1000;

                    float XPOS = (float)W / (float)VFODiff; // generate a conversion factor (pixels per hz) to be able to select the pixel based on the freq
                    int H1a = H * 2 / 3; // vert line length from top down

                    string bandInfo;

                    //  Debug.WriteLine("START BANDTEXT: " + bandtext_counter + " , " + freqlast1 + ", " + vfoa_hz);

                    //---------------------------------------------------
                    // ke9ns RX1 determine the bandtext to display for the current pan
                    if (freqlast1 != VFOC)  // if last freq is not equal to the current VFOA freq
                    {
                        bandtext_counter = 0; // reset the bandtext counter
                        freqlast1 = VFOC;

                        //   Debug.WriteLine("LOOP BANDTEXT2 " + VFOLow + " , " + VFOHigh + " , " + VFOLowB + ", " + VFOHighB + " , " + XPOS + " , " + VFODiff);

                        for (decimal ii = VFOLowB; ii < VFOHighB; ii = ii + 0.0005m) // for loop through each 1khz to find all the bandtext for the current display 0.001m
                        {
                            DB.BandText((double)ii, out bandInfo);

                            //   Debug.WriteLine("BANDINFO: " + bandInfo + " , " + ii + " , " + bandtext[bandtext_counter]);

                            if (bandInfo == bandtext[bandtext_counter])
                            {
                                bandtext_counter++;
                                bandtext[bandtext_counter] = bandInfo;
                                bandfreq[bandtext_counter] = ii;
                                bandhere[bandtext_counter] = false;
                            }
                            else
                            {
                                bandtext_counter++;
                                bandtext[bandtext_counter] = bandInfo;
                                bandfreq[bandtext_counter] = ii;
                                bandhere[bandtext_counter] = true;
                                //  Debug.WriteLine("ADD BANDTEXT " + " , " + ii + " , "+ bandtext_counter + " , " + bandInfo);
                            }

                        } // for 

                        //  Debug.WriteLine("FINISHED BANDTEXT: " + bandtext_counter + " , " + freqlast1 + ", " + vfoa_hz);
                        //   Debug.WriteLine("--------------------------");

                    } //  if (console.UpdateBandText == true)


                    //----------------------------------------------------------------------
                    // ke9ns RX1 display the bandtext on the pan XPOS = 0.00701875 , 

                    int temp9 = 0;
                    int temp10 = 0;


                    for (int zz = 0; zz < bandtext_counter; zz++) // scan through all the bandtext that appear
                    {
                        int VFO_bandtext = (int)(((XPOS) * (float)((int)(bandfreq[zz] * 1000000) - VFOLow)));

                        if (bandhere[zz] == true) // if your on the exact freq (not just inside the area defined)
                        {
                            //  Debug.WriteLine("Display Band text: " + VFO_bandtext + " , " + bandfreq[zz] + " , " + bandtext[zz] + " , " + XPOS + " , " +VFOLow  );

                            temp9 = zz;
                            temp10 = VFO_bandtext;

                            g.DrawLine(p2, VFO_bandtext, 20, VFO_bandtext, H1a);   // draw vertical line

                            // draw after the fill rectangle so its easier to see the text

                            StringFormat SF = new StringFormat();
                            SF.Alignment = StringAlignment.Near;
                            SF.FormatFlags = StringFormatFlags.DirectionVertical;


                            g.DrawString(bandtext[zz], font1, grid_text_brush, VFO_bandtext, 20, SF); // draw bandtext vertically

                        }
                        else // draw a transparent box in the area of freq that the bandtext refers to.
                        {
                            int zz1 = zz;
                            int zz4 = 0;
                            for (; zz1 < bandtext_counter; zz1++)   // find next value bandtext (and how wide the open space is in khz)
                            {
                                zz4++;
                                if (bandhere[zz1] == true) break;

                            } // for loop

                            int zz2 = zz; // save the current ZZ position

                            if (zz != 0) zz2--; // get the position before (as long as your not at the start)

                            int VFO_bandtext2 = 0;


                            int VFO_bandtext0 = (int)(((XPOS) * (float)((int)(bandfreq[zz2] * 1000000) - VFOLow)));   // LEFT SIDE X PIXEL POS of Rectangle
                            int VFO_bandtext1 = (int)(((XPOS) * (float)((int)(bandfreq[zz1 - 1] * 1000000) - VFOLow))); // RIGHT SIDE X PIXEL POS of Rectangle
                            int VFO_bandtext3 = (int)(((XPOS) * (float)((int)(bandfreq[zz1] * 1000000) - VFOLow))); // RIGHT SIDE X PIXEL POS of Rectangle

                            VFO_bandtext1 = ((VFO_bandtext3 - VFO_bandtext1) * 1 / 2) + VFO_bandtext1; // dont allow shaded area to bump up to the next bandtext (leave a gap) was 3/4


                            //  Brush B9 = new SolidBrush(Color.FromArgb(42, grid_color));
                            Brush B9 = new SolidBrush(BT_color);

                            g.FillRectangle(B9, VFO_bandtext0, 20, VFO_bandtext1 - VFO_bandtext0, H1a / 2); // draw shaded rectangle area 


                            StringFormat SF1 = new StringFormat();
                            SF1.Alignment = StringAlignment.Near;
                            SF1.FormatFlags = StringFormatFlags.DirectionVertical;

                            g.DrawString(bandtext[temp9], font1, grid_text_brush, temp10, 20, SF1); // draw bandtext vertically


                            if (((zz1 - 1) > zz2))
                            {
                                int zz3 = (int)((decimal)((zz1 - 1) - zz2) / 1.5m) + zz2; // print extra label around 2/3rds of the way to the end

                                VFO_bandtext2 = (int)(((XPOS) * (float)((int)(bandfreq[zz3] * 1000000) - VFOLow))); // x pixel position

                                if (((VFO_bandtext1 - VFO_bandtext0) > 400) && (VFO_bandtext2 > 40) && (VFO_bandtext2 < (W - 40))) // keep away from the left and right vertical dbM and S meter text
                                {

                                    StringFormat SF = new StringFormat();
                                    SF.Alignment = StringAlignment.Near;
                                    SF.FormatFlags = StringFormatFlags.DirectionVertical;
                                    g.DrawString(bandtext[zz], font1, grid_text_brush, VFO_bandtext2, 20, SF); // draw bandtext vertically
                                }
                            }


                            zz = zz1 - 1; // jump directly to next bandtext label

                        } // else

                    } // for loop

                    //  Debug.WriteLine("=============================");


                } // top RX1 draw bandtext to pan
                else // bottom rX2
                {

                    VFOLow = (int)vfob_hz + RXDisplayLow2; // low freq (left side) in hz  //.219 mod to 2
                    VFOHigh = (int)vfob_hz + RXDisplayHigh2; // high freq (right side) in hz
                    VFODiff = VFOHigh - VFOLow; // diff in hz

                    decimal VFOLowB = (decimal)((float)VFOLow / 1000000); // freq in mhz
                    decimal VFOHighB = (decimal)((float)VFOHigh / 1000000); // freq in mhz
                    decimal VFOC = (decimal)((float)vfob_hz / 1000000); // freq in mhz

                    int tempL = (int)(VFOLowB * 1000);
                    int tempH = (int)(VFOHighB * 1000);
                    int tempC = (int)(VFOC * 1000); // current freq in mhz 7.128 (down to khz only)

                    VFOLowB = (decimal)tempL / 1000;
                    VFOHighB = (decimal)tempH / 1000; // ke9ns only allow freq in MHZ down to khz 7.123456 becomes 7.123 mhz
                    VFOC = (decimal)tempC / 1000;

                    float XPOS = (float)W / (float)VFODiff; // generate a conversion factor (pixels per hz) to be able to select the pixel based on the freq
                    //  int H1a = H * 2 / 3; // vert line length from top down
                    // below is for rx2 only
                    int H1a = H / 2;            // length of vertical line (based on rx1 and rx2 display window configuration)
                    int H1b = 20;               // starting point of vertical line

                    // RX3/RX4 PanF/Pan = 5,2 (K9,K10)(short)  PanF/PanF = 5,5, (short) Pan/Pan 2,2 (long)

                    if ((K9 == 2) && (K10 == 2)) H1a = H + (H / 2); // long
                    else H1a = H + (H / 4); // short

                    H1b = H + 20;


                    string bandInfo;

                    //  Debug.WriteLine("START BANDTEXT: " + bandtext_counter + " , " + freqlast1 + ", " + vfoa_hz);

                    
                    //---------------------------------------------------
                    // ke9ns RX2 determine the bandtext to display for the current pan
                    if (freqlast2 != VFOC)
                    {
                        bandtext_counter2 = 0; // reset the bandtext counter
                        freqlast2 = VFOC;

                        //   Debug.WriteLine("LOOP BANDTEXT2 " + VFOLow + " , " + VFOHigh + " , " + VFOLowB + ", " + VFOHighB + " , " + XPOS + " , " + VFODiff);

                        for (decimal ii = VFOLowB; ii < VFOHighB; ii = ii + 0.0005m) // for loop through each 1khz to find all the bandtext for the current display
                        {
                            DB.BandText((double)ii, out bandInfo);

                            //   Debug.WriteLine("BANDINFO: " + bandInfo + " , " + ii + " , " + bandtext[bandtext_counter]);

                            if (bandInfo == bandtext2[bandtext_counter2])
                            {
                                bandtext_counter2++;
                                bandtext2[bandtext_counter2] = bandInfo;
                                bandfreq2[bandtext_counter2] = ii;
                                bandhere2[bandtext_counter2] = false;
                            }
                            else
                            {
                                bandtext_counter2++;
                                bandtext2[bandtext_counter2] = bandInfo;
                                bandfreq2[bandtext_counter2] = ii;
                                bandhere2[bandtext_counter2] = true;
                                //  Debug.WriteLine("ADD BANDTEXT " + " , " + ii + " , "+ bandtext_counter + " , " + bandInfo);
                            }

                        } // for 

                        //  Debug.WriteLine("FINISHED BANDTEXT: " + bandtext_counter + " , " + freqlast1 + ", " + vfoa_hz);
                        //   Debug.WriteLine("--------------------------");

                    } //  if (console.UpdateBandText == true)


                    //----------------------------------------------------------------------
                    // ke9ns RX2 display the bandtext on the pan XPOS = 0.00701875 , 

                    int temp9 = 0;
                    int temp10 = 0;

                    for (int zz = 0; zz < bandtext_counter2; zz++) // scan through all the bandtext that appear
                    {
                      


                        int VFO_bandtext = (int)(((XPOS) * (float)((int)(bandfreq2[zz] * 1000000) - VFOLow)));

                        if (bandhere2[zz] == true)
                        {
                            //  Debug.WriteLine("Display Band text: " + VFO_bandtext + " , " + bandfreq[zz] + " , " + bandtext[zz] + " , " + XPOS + " , " +VFOLow  );
                            temp9 = zz;
                            temp10 = VFO_bandtext;

                            g.DrawLine(p2, VFO_bandtext, H1b, VFO_bandtext, H1a);   // draw vertical line

                            StringFormat SF = new StringFormat();
                            SF.Alignment = StringAlignment.Near;
                            SF.FormatFlags = StringFormatFlags.DirectionVertical;

                            g.DrawString(bandtext2[zz], font1, grid_text_brush, VFO_bandtext, H1b, SF); // draw bandtext vertically

                        }
                        else // draw a transparent box in the area of freq that the bandtext refers to.
                        {
                            int zz1 = zz;
                            int zz4 = 0;
                            for (; zz1 < bandtext_counter2; zz1++)   // find next value bandtext (and how wide the open space is in khz)
                            {
                                zz4++;
                                if (bandhere2[zz1] == true) break;

                            } // for loop

                            int zz2 = zz; // save the current ZZ position

                            if (zz != 0) zz2--; // get the position before (as long as your not at the start)

                            int VFO_bandtext2 = 0;


                            int VFO_bandtext0 = (int)(((XPOS) * (float)((int)(bandfreq2[zz2] * 1000000) - VFOLow)));   // LEFT SIDE X PIXEL POS of Rectangle
                            int VFO_bandtext1 = (int)(((XPOS) * (float)((int)(bandfreq2[zz1 - 1] * 1000000) - VFOLow))); // RIGHT SIDE X PIXEL POS of Rectangle
                            int VFO_bandtext3 = (int)(((XPOS) * (float)((int)(bandfreq2[zz1] * 1000000) - VFOLow))); // RIGHT SIDE X PIXEL POS of Rectangle

                            VFO_bandtext1 = ((VFO_bandtext3 - VFO_bandtext1) * 3 / 4) + VFO_bandtext1;


                            //   Brush B9 = new SolidBrush(Color.FromArgb(42, grid_color));
                            Brush B9 = new SolidBrush(BT_color);

                            g.FillRectangle(B9, VFO_bandtext0, H1b, VFO_bandtext1 - VFO_bandtext0, H1a / 8);

                            StringFormat SF1 = new StringFormat();
                            SF1.Alignment = StringAlignment.Near;
                            SF1.FormatFlags = StringFormatFlags.DirectionVertical;

                          //  g.DrawString(bandtext[temp9], font1, grid_text_brush, temp10, 20, SF1); // draw bandtext vertically


                            if (((zz1 - 1) > zz2))
                            {
                                int zz3 = (int)((decimal)((zz1 - 1) - zz2) / 1.5m) + zz2; // print extra label around 2/3rds of the way to the end

                                VFO_bandtext2 = (int)(((XPOS) * (float)((int)(bandfreq[zz3] * 1000000) - VFOLow))); // x pixel position

                                if (((VFO_bandtext1 - VFO_bandtext0) > 400) && (VFO_bandtext2 > 40) && (VFO_bandtext2 < (W - 40))) // keep away from the left and right vertical dbM and S meter text
                                {

                                    StringFormat SF = new StringFormat();
                                    SF.Alignment = StringAlignment.Near;
                                    SF.FormatFlags = StringFormatFlags.DirectionVertical;
                                    g.DrawString(bandtext2[zz], font1, grid_text_brush, VFO_bandtext2, H1b, SF); // draw bandtext vertically
                                }
                            }


                            zz = zz1 - 1; // jump directly to next bandtext label

                        } // else

                    } // for loop

                    //  Debug.WriteLine("=============================");


                } // bottom RX2


            } //Draw Band text if SpotForm.chkBoxBandText.Checked == true 
            else
            {

                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //=====================================================================
                //=====================================================================
                // ke9ns add DRAW MEMORY SPOTS ON PANADAPTER
                //=====================================================================
                //=====================================================================

                // if ((SpotControl.SP6_Active != 0) && (!mox) && (console.chkPower.Checked == true))// do memory spot if active and not transmitting
                if ((SpotControl.SP6_Active != 0) && (console.chkPower.Checked == true))// do memory spot if active 
                {

                    int iii = 0;                          // ke9ns add stairstep holder

                    int kk = 0;                           // ke9ns add index for holder[] after you draw the vert line, then draw calls (so calls can overlap the vert lines)

                    int vfo_hz = (int)vfoa_hz;    // vfo freq in hz

                    int H1a = H / 2;            // length of vertical line (based on rx1 and rx2 display window configuration)
                    int H1b = 20;               // starting point of vertical line

                    // RX3/RX4 PanF/Pan = 5,2 (K9,K10)(short)  PanF/PanF = 5,5, (short) Pan/Pan 2,2 (long)
                    if (bottom)                 // if your drawing to the bottom 
                    {
                        if ((K9 == 2) && (K10 == 2)) H1a = H + (H / 2); // long
                        else H1a = H + (H / 4); // short

                        H1b = H + 20;

                        vfo_hz = (int)vfob_hz;
                        Console.MMK4 = 0;        // RX4 index to allow call signs to draw after all the vert lines on the screen

                    }
                    else
                    {
                        Console.MMK3 = 0;        // RX3 index to allow call signs to draw after all the vert lines on the screen
                    }

                    if (bottom) //.219 add bottom 2
                    {
                        VFOLow = vfo_hz + RXDisplayLow2;    // low freq (left side) in hz
                        VFOHigh = vfo_hz + RXDisplayHigh2; // high freq (right side) in hz
                    }
                    else
                    {
                        VFOLow = vfo_hz + RXDisplayLow;    // low freq (left side) in hz
                        VFOHigh = vfo_hz + RXDisplayHigh; // high freq (right side) in hz
                    }

                    VFODiff = VFOHigh - VFOLow;       // diff in hz

                    int gg = SpotForm.dataGridView2.Rows.Count;  // get current # of memories we have available
                                                                 //  int gg = console.comboFMMemory.Items.Count;

                    //-------------------------------------------------------------------------------------------------
                    //-------------------------------------------------------------------------------------------------
                    // draw MEMORY SPOTS
                    //-------------------------------------------------------------------------------------------------
                    //-------------------------------------------------------------------------------------------------


                    for (int ii = 0; ii < gg; ii++)     // Index through entire DXspot to find what is on this panadapter (draw vert lines first)
                    {

                        int hh = (int)(Convert.ToDouble(SpotForm.dataGridView2[1, ii].Value, CultureInfo.InvariantCulture) * 1000000);  // MEMORY "RXFREQ"  convert to hz

                        if ((hh >= VFOLow) && (hh <= VFOHigh)) // find MEMORIES that appear on PAN
                        {

                            int VFO_DXPos = (int)((((float)W / (float)VFODiff) * (float)(hh - VFOLow))); // determine MEMORY spot line pos on current panadapter screen

                            holder2[kk] = ii;                    // ii is the actual MEMORY INDEX pos the the KK holds
                            holder3[kk] = VFO_DXPos;

                            kk++;

                            g.DrawLine(p3, VFO_DXPos, H1b, VFO_DXPos, H1a);   // draw vertical line

                        }

                    } // for loop through MEMORIES


                    if (bottom) Console.MMK4 = kk; // keep a count for the bottom MEMORY 
                    else Console.MMK3 = kk; // count of spots in current panadapter


                    //--------------------------------------------------------------------------------------------
                    for (int ii = 0; ii < kk; ii++) // draw call signs to screen in order to draw over the vert lines
                    {

                        string ll = (string)SpotForm.dataGridView2[2, holder2[ii]].Value;  // Name of MEMORY
                        string mm = (string)SpotForm.dataGridView2[0, holder2[ii]].Value;  // GROUP of MEMORY
                        string cc = (string)SpotForm.dataGridView2[9, holder2[ii]].Value;  // comments for hyperlinking of MEMORY

                        DSPMode nn = (DSPMode)SpotForm.dataGridView2[3, holder2[ii]].Value;  // DSPMODE of MEMORY

                        if ((nn == DSPMode.LSB) || (nn == DSPMode.DIGL) || (nn == DSPMode.CWL)) low = true;
                        else low = false;

                        // font
                        if (low) // 1=LSB so draw on left side of line
                        {

                            length = g.MeasureString(ll, font1);             //  temp used to determine the size of the string when in LSB and you need to reserve a certain space//  (cl.Width);
                            length1 = g.MeasureString(mm, font1);             //  length of "GROUP" string from Memory (to create a virtual box around the Memory Name & Group) to click on


                            g.DrawString(ll, font1, grid_text_brush, holder3[ii] - length.Width, H1b + iii);    // Memory Name
                            g.DrawString(mm, font1, grid_text_brush, holder3[ii] - length1.Width, H1b + iii + 11); // Memory Group

                            if (bottom) rx3 = 50; // allow only 50 spots per Receiver
                            else rx3 = 0;

                            if (!mox) // only do when not transmitting
                            {

                                if (length1.Width > length.Width) length.Width = length1.Width; // make virtual box as wide as the widest text

                                Console.MMW[ii + rx3] = (int)length.Width;           // Width,Height,X,Y of upper left corner to locate where text actually is 
                                Console.MMH[ii + rx3] = (int)length.Height * 2;       // * 2 because of 2 lines of text
                                Console.MMX[ii + rx3] = holder3[ii] - (int)length.Width;
                                Console.MMY[ii + rx3] = H1b + iii;
                                Console.MMS[ii + rx3] = ll;
                                Console.MMC[ii + rx3] = cc; // comments
                                Console.MMM[ii + rx3] = holder2[ii];

                            }


                        } // LSB side
                        else   // 0=usb so draw on righ side of line (normal)
                        {

                            length = g.MeasureString(ll, font1); //  not needed here but used for MEMORY NAME
                            length1 = g.MeasureString(mm, font1); //  length of "GROUP" string from Memory (to create a virtual box around the Memory Name & Group) to click on


                            g.DrawString(ll, font1, grid_text_brush, holder3[ii], H1b + iii); // Memory Name
                            g.DrawString(mm, font1, grid_text_brush, holder3[ii], H1b + iii + 11); // Memory Group

                            if (bottom) rx3 = 50;
                            else rx3 = 0;

                            if (!mox) // only do when not transmitting
                            {
                                if (length1.Width > length.Width) length.Width = length1.Width;

                                Console.MMW[ii + rx3] = (int)length.Width;    // Width,Height,X,Y of upper left corner to locate where text actually is 
                                Console.MMH[ii + rx3] = (int)length.Height * 2;  // H
                                Console.MMX[ii + rx3] = holder3[ii];         // X
                                Console.MMY[ii + rx3] = H1b + iii;           // Y
                                Console.MMS[ii + rx3] = ll;                  // Name of Memory showing up in Pan
                                Console.MMC[ii + rx3] = cc;                  // comments
                                Console.MMM[ii + rx3] = holder2[ii];         // index in memory.xml file
                            }

                        } // USB side

                        iii = iii + 22; // 11
                        if (iii > 90) iii = 0;


                    }// for loop through MEMORIES


                } // MEMORY SPOTTING


                SpotForm.hpos = H; // ke9ns add height of panadapter part of picDisplay screen. 573max=full pan, 477max=8020, 286max=panafall


                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //=====================================================================
                //=====================================================================
                // ke9ns add DRAW SWL SPOTS ON PANADAPTER
                //=====================================================================
                //=====================================================================

                //   if ((!mox) && (console.chkPower.Checked == true) && (SpotControl.SP1_Active != 0))
                if ((console.chkPower.Checked == true) && (SpotControl.SP1_Active != 0)) // ke9ns: no longer turns off when transmitting .166
                {
                    DateTime UTCD = DateTime.SpecifyKind(DateTime.UtcNow, DateTimeKind.Utc); // used by both RX1 and RX2 SWL display
                    byte UTCDD = (byte)(1 << ((byte)UTCD.DayOfWeek));   // this is the day. Sun = 0, Mon = 1
                    SpotControl.UTCNEW1 = Convert.ToInt16(UTCD.ToString("HHmm"), CultureInfo.InvariantCulture); // convert 24hr UTC to int


                    /*
                                        //=============================
                                        // W=1605 full HD, W=1447 full HD with bandstack screen open
                                        // 1440 min / day
                                        // UTC time is time in London
                                        // international date line is off of Alaska coast which is 720min from UTC
                                        // day change takes place wherever 0 utc is (0300UTC= 0 Day line is 180min back)(2300UTC= 0 Day line is 1380min back)
                                        //

                                        bool day = false;

                                        double minfact =  (double)W / 1440.0; // minfact = 1.114 or 1.004 this is the scaling factor the the current Width of the picDisplay area

                                        int mins = UTCD.Hour * 60 + UTCD.Minute; // minutes of the current UTC day (ie current time in London): 0 UTC would place the DAY line over London

                                        if (mins >= 720)
                                        {
                                            day = true; //<- UTCDAY | UTCDAY+1 ->
                                        }
                                        else day = false; // <- UTCDAY-1 | UTCDAY ->

                                        int minpos = (int)((double)mins * minfact); // scale the UTC Day line to the Display area

                                        int minpos1 = (int)(((double)W / 2) - minpos); // 1605/2 = 802 - 1174

                                        if (minpos1 < 0) minpos1 = W + minpos1; // move over to the left side

                                        g.DrawLine(p4, minpos1, H-35, minpos1, H);   // draw vertical line


                                        if (day == false)
                                        {
                                            SizeF length1 = g.MeasureString("<- " + UTCD.AddDays(-1).ToString("dddd"), font1); //  used for google lookups of SWL stations
                                            g.DrawString("<- " + UTCD.AddDays(-1).ToString("dddd"), font1, grid_text_brush, minpos1 - (length1.Width + 8), H - 15);
                                            g.DrawString(UTCD.ToString("dddd") + " ->", font1, grid_text_brush, minpos1 + 8, H - 15);
                                        }
                                        else
                                        {
                                            SizeF length1 = g.MeasureString("<- " + UTCD.ToString("dddd"), font1); //  used for google lookups of SWL stations
                                            g.DrawString("<- " + UTCD.ToString("dddd"), font1, grid_text_brush, minpos1 - (length1.Width + 8), H - 15);
                                            g.DrawString(UTCD.AddDays(1).ToString("dddd") + " ->", font1, grid_text_brush, minpos1 + 8, H - 15);

                                        }

                                        //   Debug.WriteLine("day: " + W + " , "+ console.picDisplay.Width + " , " + minpos);
                    */

                    if ((!bottom) && (vfoa_hz < 170000000))// do SWL spot if active and not transmitting (was 54000000  .219)
                    {

                        VFOLow = (int)vfoa_hz + RXDisplayLow; // low freq (left side) in hz
                        VFOHigh = (int)vfoa_hz + RXDisplayHigh; // high freq (right side) in hz
                        VFODiff = VFOHigh - VFOLow; // diff in hz

                        byte VFOLowB = (byte)(VFOLow / 1000000); // freq in mhz
                        byte VFOHighB = (byte)(VFOHigh / 1000000); // freq in mhz

                      //  Debug.WriteLine("VFOLowB "+ VFOLowB + " , " + VFOHighB);

                        int iii = 0; // stairstep the swl stations on the screen

                        int L_index = 0;                                              // 0Mhz in index
                        if (VFOLowB != 0) L_index = SpotControl.SWL_BandL[VFOLowB - 1]; // Left side  index position corresponding to the Left side Mhz
                        int H_index = SpotControl.SWL_BandL[VFOHighB];                // Right side index position corresponding to the right side Mhz

                       //   Debug.WriteLine("VFOLOW:" + VFOLowB + " , " + VFOHighB + " , " + L_index + " , " + H_index);


                        float XPOS = (float)W / (float)VFODiff;

                        int H1a = H * 2 / 3; // vert line length from top down

                        // DayOfWeek UTCDD = UTCD.DayOfWeek; // day is spelled out: Monday, Tuesday


                        if ((VFOHigh != SpotControl.VFOHLast)) // check if moved frequency
                        {
                            //  Debug.WriteLine("1VFOLOW:" + VFOLowB + " , " + VFOHighB + " , " + L_index + " , " + H_index);

                            Debug.WriteLine("SWL CHange Freq");
                            
                            SpotControl.VFOHLast = VFOHigh;
                          //  SpotControl.Lindex = 0; // bottom of index to display spots
                          //  SpotControl.Hindex = 0; // top of index to display spots
                          
                            SpotControl.Lindex = L_index; // bottom of index to display spots //.219
                            SpotControl.Hindex = L_index; // top of index to display spots

                            Console.SXK = 0;


                            for (int ii = L_index; ii <= H_index; ii++) // start by checking spots that fall within the mhz range of the panadapter
                            {
                                SpotControl.Hindex = ii; // get top index spot

                                if ((SpotControl.SWL_Freq[ii] > VFOHigh))
                                {
                                    SpotControl.Hindex--; // get top index spot

                                    break; // once a SWL spot if found off the right side of screen then DONE
                                }

                                if ((SpotControl.SWL_Freq[ii] >= VFOLow)) // find all swl spot within the screen area
                                {
                                    if (SpotControl.Lindex == L_index) SpotControl.Lindex = ii; // capture index of first valid spot on screen  // fix .224 was == 0

                                    //  Debug.Write(" FREQ-SWL " + ii);


                                    // ke9ns check that the UTC day falls within the stations days listed at ON the air, then check the UTC time

                                    if (
                                    ((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (((SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1)) ||
                                    ((SpotControl.SWL_TimeN[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] < SpotControl.SWL_TimeN[ii])))
                                     )
                                    //   if ( ((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1)) // ke9ns check if stations on the panadapter are on the air (based on time)
                                    {


                                        int VFO_SWLPos = (int)(((XPOS) * (float)(SpotControl.SWL_Freq[ii] - VFOLow)));

                                        g.DrawLine(p2, VFO_SWLPos, 20, VFO_SWLPos, H1a);   // draw vertical line

                                        if ((Console.MMK3 > 0) && (SpotControl.SP6_Active != 0))
                                        {
                                            int x2 = VFO_SWLPos;
                                            int y2 = 20 + iii;

                                            SizeF length = g.MeasureString(SpotControl.SWL_Station[ii], font1); //  used for google lookups of SWL stations

                                            for (int jj = 0; jj < Console.MMK3; jj++)
                                            {

                                                if (((x2 + length.Width) >= Console.MMX[jj]) && (x2 < (Console.MMX[jj] + Console.MMW[jj])))
                                                {
                                                    if (((y2 + length.Height) >= Console.MMY[jj]) && (y2 < (Console.MMY[jj] + Console.MMH[jj])))
                                                    {
                                                        iii = iii + 33;
                                                        break;
                                                    }
                                                }

                                            } // for loop to check if DX text will draw over top of Memory text

                                        } //  if ((Console.MMK3 > 0) && (SpotControl.SP6_Active != 0))

                                        g.DrawString(SpotControl.SWL_Station[ii], font1, grid_text_brush, VFO_SWLPos, 20 + iii);
                                        
                                       

                                         //  Debug.WriteLine(" FINDSWL "+ ii );

                                        if (Console.SXK < 99)
                                        {

                                            SizeF length = g.MeasureString(SpotControl.SWL_Station[ii], font1); //  used for google lookups of SWL stations

                                            Console.SXW[Console.SXK] = (int)length.Width;
                                            Console.SXH[Console.SXK] = (int)length.Height;
                                            Console.SXX[Console.SXK] = VFO_SWLPos;
                                            Console.SXY[Console.SXK] = 20 + iii;
                                            Console.SXS[Console.SXK] = SpotControl.SWL_Station[ii];
                                            Console.SXF[Console.SXK] = SpotControl.SWL_Freq[ii];
                                            Console.SXM[Console.SXK] = SpotControl.SWL_Mode[ii];
                                           
                                          //  g.DrawString(Console.SXW[Console.SXK].ToString() , font1, grid_text_brush, VFO_SWLPos, 30 + iii); // ke9ns add .224
                                          //  g.DrawString(Console.SXH[Console.SXK].ToString(), font1, grid_text_brush, VFO_SWLPos + 30, 30 + iii); // ke9ns add .224
                                           // g.DrawString(Console.SXX[Console.SXK].ToString(), font1, grid_text_brush, VFO_SWLPos + 60, 30 + iii); // ke9ns add .224
                                           // g.DrawString(Console.SXY[Console.SXK].ToString(), font1, grid_text_brush, VFO_SWLPos + 90, 30 + iii); // ke9ns add .224

                                         //   Debug.WriteLine("-STATION " + Console.SXK + " , " + SpotControl.SWL_Station[ii] + " , " + SpotControl.SWL_Freq[ii]);

                                            Console.SXK++;
                                        }
                                        else Debug.Write(" -SXK OVERLIMIT ");

                                      
                                        iii = iii + 11; // stairstep spots
                                        if (iii > 90) iii = 0;

                                    } // check time

                                } // make sure spot is > then left side of screen

                            } // for loop through SWL_Index

                           //   Debug.WriteLine(" L_index " + SpotControl.Lindex);
                           //   Debug.WriteLine(" H_index " + SpotControl.Hindex);

                            //  Debug.WriteLine(" VFOLow " + VFOLow);
                            //  Debug.WriteLine(" VFOHigh " + VFOHigh);


                        } //   if ((VFOHigh != SpotControl.VFOHLast))  //if you change vfo freq do above
                        else // if you dont change freq, then do below
                        {
                        
                           //  int temp79 = 0;

                            //  Debug.WriteLine("2VFOLOW:" + VFOLowB + " , " + VFOHighB + " , " + L_index + " , " + H_index + " , " + SpotControl.Lindex + " , " + SpotControl.Hindex);

                            for (int ii = SpotControl.Lindex; ii <= SpotControl.Hindex; ii++) // now check only spots that fit exactly on panadapter
                            {
                                //  Debug.Write(" drawSWL " + ii);

                                 if (
                                 ((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (((SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1)) ||
                                 ((SpotControl.SWL_TimeN[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] < SpotControl.SWL_TimeN[ii])))
                                  )
                                    //     if (((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1))
                                {
                                    int VFO_SWLPos = (int)(((XPOS) * (float)(SpotControl.SWL_Freq[ii] - VFOLow)));

                                    g.DrawLine(p2, VFO_SWLPos, 20, VFO_SWLPos, H1a);   // draw vertical line

                                    iii = iii + 11; // stairstep spots
                                    if (iii > 90) iii = 0;

                                } // check time

                            } // for loop to display all current swl spots
                            iii = 0;

                           
                            for (int ii = SpotControl.Lindex; ii <= SpotControl.Hindex; ii++) // now check only spots that fit exactly on panadapter
                            {
                                //   Debug.Write(" drawSWL " + ii);

                                if (
                                   ((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (((SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1)) ||
                                   ((SpotControl.SWL_TimeN[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] < SpotControl.SWL_TimeN[ii])))
                                    )
                                //    if (((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1))
                                {
                                    int VFO_SWLPos = (int)(((XPOS) * (float)(SpotControl.SWL_Freq[ii] - VFOLow)));

                                    //   Debug.WriteLine("SWL - MMK3 value " + Console.MMK3);

                                    if ((Console.MMK3 > 0) && (SpotControl.SP6_Active != 0))
                                    {
                                        int x2 = VFO_SWLPos;
                                        int y2 = 20 + iii;

                                        SizeF length = g.MeasureString(SpotControl.SWL_Station[ii], font1); //  used for google lookups of SWL stations

                                        for (int jj = 0; jj < Console.MMK3; jj++)
                                        {

                                            if (((x2 + length.Width) >= Console.MMX[jj]) && (x2 < (Console.MMX[jj] + Console.MMW[jj])))
                                            {
                                                if (((y2 + length.Height) >= Console.MMY[jj]) && (y2 < (Console.MMY[jj] + Console.MMH[jj])))
                                                {
                                                    iii = iii + 33;
                                                    break;
                                                }
                                            }

                                        } // for loop to check if DX text will draw over top of Memory text
                                    } //  if ((Console.MMK3 > 0) && (SpotControl.SP6_Active != 0))

                                    g.DrawString(SpotControl.SWL_Station[ii], font1, grid_text_brush, VFO_SWLPos, 20 + iii); // draw station Name
                                                                                                                             // temp79++;
                                  //  g.DrawString(Console.SXW[temp79].ToString(), font1, grid_text_brush, VFO_SWLPos, 30 + iii); // ke9ns add .224
                                  //  g.DrawString(Console.SXH[temp79].ToString(), font1, grid_text_brush, VFO_SWLPos + 30, 30 + iii); // ke9ns add .224
                                  //  g.DrawString(Console.SXX[temp79].ToString(), font1, grid_text_brush, VFO_SWLPos + 60, 30 + iii); // ke9ns add .224
                                   // g.DrawString(Console.SXY[temp79].ToString(), font1, grid_text_brush, VFO_SWLPos + 90, 30 + iii); // ke9ns add .224
                                      //  Debug.WriteLine("STATION " + temp79 + " , " + SpotControl.SWL_Station[ii] + " , " + SpotControl.SWL_Freq[ii]);
                                  //  temp79++;

                                    iii = iii + 11; // stairstep spots
                                    if (iii > 90) iii = 0;

                                } // check time

                            } // for loop to display all current swl spots


                        } //do this above until you move freq again


                    } // DISPLAY RX1 SWL SPots only


                    //======================================================
                    //======================================================
                    //ke9ns add SWL spots to RX2

                    if ((bottom) && (vfob_hz < 170000000))// do SWL spot if active and not transmitting (was 60000000 .219)
                    {

                        VFOLow = (int)vfob_hz + RXDisplayLow2; // low freq (left side) in hz //.219 mod 2
                        VFOHigh = (int)vfob_hz + RXDisplayHigh2; // high freq (right side) in hz
                        VFODiff = VFOHigh - VFOLow; // diff in hz

                        byte VFOLowB = (byte)(VFOLow / 1000000); // freq in mhz
                        byte VFOHighB = (byte)(VFOHigh / 1000000); // freq in mhz

                        int iii = 0; // stairstep the swl stations on the screen

                        int L_index = 0;                                              // 0Mhz in index
                        if (VFOLowB != 0) L_index = SpotControl.SWL_BandL[VFOLowB - 1]; // Left side  index position corresponding to the Left side Mhz
                        int H_index = SpotControl.SWL_BandL[VFOHighB];                // Right side index position corresponding to the right side Mhz

                        float XPOS = (float)W / (float)VFODiff;


                        // below is for rx2 only
                        int H1a = H / 2;            // length of vertical line (based on rx1 and rx2 display window configuration)
                        int H1b = 20;               // starting point of vertical line

                        // RX3/RX4 PanF/Pan = 5,2 (K9,K10)(short)  PanF/PanF = 5,5, (short) Pan/Pan 2,2 (long)

                        if ((K9 == 2) && (K10 == 2)) H1a = H + (H / 2); // long
                        else H1a = H + (H / 4); // short

                        H1b = H + 20;


                        if ((VFOHigh != SpotControl.VFOHLast)) // check if moved frequency
                        {

                            SpotControl.VFOHLast = VFOHigh;
                            SpotControl.Lindex = 0; // bottom of index to display spots
                            SpotControl.Hindex = 0; // top of index to display spots

                            SpotControl.Lindex = L_index; // bottom of index to display spots //.219
                            SpotControl.Hindex = L_index; // top of index to display spots


                            Console.SXK2 = 0;


                            for (int ii = L_index; ii <= H_index; ii++) // start by checking spots that fall within the mhz range of the panadapter
                            {
                                SpotControl.Hindex = ii; // get top index spot

                                if ((SpotControl.SWL_Freq[ii] > VFOHigh))
                                {
                                    SpotControl.Hindex--; // get top index spot

                                    break; // once a SWL spot if found off the right side of screen then DONE
                                }

                                if ((SpotControl.SWL_Freq[ii] >= VFOLow)) // find all swl spot within the screen area
                                {
                                    if (SpotControl.Lindex == L_index) SpotControl.Lindex = ii; // capture index of first valid spot on screen   fix .224 was  == 0

                                    //   Debug.Write(" FREQ-SWL " + ii);


                                    // ke9ns check that the UTC day falls within the stations days listed at ON the air, then check the UTC time

                                    if (
                                            ((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (((SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1)) ||
                                            ((SpotControl.SWL_TimeN[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] < SpotControl.SWL_TimeN[ii])))
                                       )
                                    {


                                        int VFO_SWLPos = (int)(((XPOS) * (float)(SpotControl.SWL_Freq[ii] - VFOLow)));

                                        g.DrawLine(p2, VFO_SWLPos, H1b, VFO_SWLPos, H1a);   // draw RX2 vertical line


                                        if ((Console.MMK4 > 0) && (SpotControl.SP6_Active != 0))
                                        {
                                            int x2 = VFO_SWLPos;
                                            int y2 = 20 + iii;

                                            SizeF length = g.MeasureString(SpotControl.SWL_Station[ii], font1); //  used for google lookups of SWL stations

                                            for (int jj = 0; jj < Console.MMK4; jj++)
                                            {

                                                if (((x2 + length.Width) >= Console.MMX[jj + rx3]) && (x2 < (Console.MMX[jj + rx3] + Console.MMW[jj + rx3])))
                                                {
                                                    if (((y2 + length.Height) >= Console.MMY[jj + rx3]) && (y2 < (Console.MMY[jj + rx3] + Console.MMH[jj + rx3])))
                                                    {
                                                        iii = iii + 33;
                                                        break;
                                                    }
                                                }

                                            } // for loop to check if DX text will draw over top of Memory text
                                        }

                                        // for RX2
                                        g.DrawString(SpotControl.SWL_Station[ii], font1, grid_text_brush, VFO_SWLPos, H1b + iii); // 20+iii

                                        //   Debug.WriteLine(" FINDSWL "+ ii );

                                        if (Console.SXK2 < 99)
                                        {

                                            SizeF length = g.MeasureString(SpotControl.SWL_Station[ii], font1); //  used for google lookups of SWL stations

                                            Console.SXW[Console.SXK2 + 100] = (int)length.Width;
                                            Console.SXH[Console.SXK2 + 100] = (int)length.Height;
                                            Console.SXX[Console.SXK2 + 100] = VFO_SWLPos;
                                            Console.SXY[Console.SXK2 + 100] = 20 + iii;
                                            Console.SXS[Console.SXK2 + 100] = SpotControl.SWL_Station[ii];
                                            Console.SXF[Console.SXK2 + 100] = SpotControl.SWL_Freq[ii];
                                            Console.SXM[Console.SXK2 + 100] = SpotControl.SWL_Mode[ii];

                                            Console.SXK2++;
                                        }
                                        else Debug.Write(" SXK2 OVERLIMIT ");


                                        iii = iii + 11; // stairstep spots
                                        if (iii > 90) iii = 0;

                                    } // check time

                                } // make sure spot is > then left side of screen

                            } // for loop through SWL_Index

                            //   Debug.WriteLine(" L_index " + SpotControl.Lindex);
                            //   Debug.WriteLine(" H_index " + SpotControl.Hindex);

                            //   Debug.WriteLine(" VFOLow " + VFOLow);
                            //   Debug.WriteLine(" VFOHigh " + VFOHigh);


                        } // if you change vfo freq do above
                        else // if you dont change freq, then do below
                        {


                            for (int ii = SpotControl.Lindex; ii <= SpotControl.Hindex; ii++) // now check only spots that fit exactly on panadapter
                            {
                                //  Debug.Write(" drawSWL " + ii);

                                if (
                             ((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (((SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1)) ||
                             ((SpotControl.SWL_TimeN[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] < SpotControl.SWL_TimeN[ii])))
                              )
                                {
                                    int VFO_SWLPos = (int)(((XPOS) * (float)(SpotControl.SWL_Freq[ii] - VFOLow)));

                                    g.DrawLine(p2, VFO_SWLPos, H1b, VFO_SWLPos, H1a);   // draw RX2 vertical line

                                    iii = iii + 11; // stairstep spots
                                    if (iii > 90) iii = 0;

                                } // check time

                            } // for loop to display all current swl spots
                            iii = 0;
                            for (int ii = SpotControl.Lindex; ii <= SpotControl.Hindex; ii++) // now check only spots that fit exactly on panadapter
                            {
                                //  Debug.Write(" drawSWL " + ii);

                                if (
                           ((SpotControl.SWL_Day1[ii] & SpotControl.UTCDD) > 0) && (((SpotControl.SWL_TimeN[ii] <= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1)) ||
                           ((SpotControl.SWL_TimeN[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] >= SpotControl.UTCNEW1) && (SpotControl.SWL_TimeF[ii] < SpotControl.SWL_TimeN[ii])))
                            )
                                {
                                    int VFO_SWLPos = (int)(((XPOS) * (float)(SpotControl.SWL_Freq[ii] - VFOLow)));

                                    if ((Console.MMK4 > 0) && (SpotControl.SP6_Active != 0))
                                    {
                                        int x2 = VFO_SWLPos;
                                        int y2 = 20 + iii;

                                        SizeF length = g.MeasureString(SpotControl.SWL_Station[ii], font1); //  used for google lookups of SWL stations

                                        for (int jj = 0; jj < Console.MMK4; jj++)
                                        {

                                            if (((x2 + length.Width) >= Console.MMX[jj + rx3]) && (x2 < (Console.MMX[jj + rx3] + Console.MMW[jj + rx3])))
                                            {
                                                if (((y2 + length.Height) >= Console.MMY[jj + rx3]) && (y2 < (Console.MMY[jj + rx3] + Console.MMH[jj + rx3])))
                                                {
                                                    iii = iii + 33;
                                                    break;
                                                }
                                            }

                                        } // for loop to check if DX text will draw over top of Memory text
                                    }

                                    g.DrawString(SpotControl.SWL_Station[ii], font1, grid_text_brush, VFO_SWLPos, H1b + iii); // draw station Name  20+iii

                                    iii = iii + 11; // stairstep spots
                                    if (iii > 90) iii = 0;

                                } // check time

                            } // for loop to display all current swl spots


                        } //do this above until you move freq again


                    } // DISPLAY RX2 spots 


                } // CHECK FOR SWL listing   SP1_Active SWL CLUSTER




                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //===============================================================================================================================================================
                //=====================================================================
                //=====================================================================
                // ke9ns add draw DX SPOTS on pandapter
                //=====================================================================
                //=====================================================================


                if ((SpotControl.SP_Active != 0) && (SpotForm.beacon1 == false)) // make sure DX cluster is running but Beacon chk is OFF so as to not crowd the screen.
                {

                    int CWPitch1 = 0;
                 
                    bool Pitch1 = false;
                    bool Pitch2 = false;


                   
                    if (bottom)
                    {
                        if (rx2_dsp_mode == DSPMode.CWL)
                        {
                            CWPitch1 = CWPitch;
                        }
                        else if (rx2_dsp_mode == DSPMode.CWU)
                        {
                            CWPitch1 = -CWPitch;
                        }
                    }
                    else
                    {
                        if (rx1_dsp_mode == DSPMode.CWL)
                        {
                            CWPitch1 = CWPitch;
                           
                           
                        }
                        else if (rx1_dsp_mode == DSPMode.CWU)
                        {
                            CWPitch1 = -CWPitch;
                        }

                    }


                    int iii = 0;                          // ke9ns add stairstep holder

                    int kk = 0;                           // ke9ns add index for holder[] after you draw the vert line, then draw calls (so calls can overlap the vert lines)

                    int vfo_hz = (int)vfoa_hz;    // vfo freq in hz

                    int H1a = H / 2;            // length of vertical line (based on rx1 and rx2 display window configuration)
                    int H1b = 20;               // starting point of vertical line

                    // RX1/RX2 PanF/Pan = 5,2 (K9,K10)(short)  PanF/PanF = 5,5, (short) Pan/Pan 2,2 (long)
                    if (bottom)                 // if your drawing to the bottom 
                    {
                        if ((K9 == 2) && (K10 == 2)) H1a = H + (H / 2); // long
                        else H1a = H + (H / 4); // short

                        H1b = H + 20;

                        vfo_hz = (int)vfob_hz;
                        Console.DXK2 = 0;        // RX2 index to allow call signs to draw after all the vert lines on the screen

                    }
                    else
                    {
                        Console.DXK = 0;        // RX1 index to allow call signs to draw after all the vert lines on the screen
                    }

                    if (bottom)
                    {
                        VFOLow = vfo_hz + RXDisplayLow2;    // low freq (left side) in hz //.219 mod 2
                        VFOHigh = vfo_hz + RXDisplayHigh2; // high freq (right side) in hz
                    }
                    else
                    {
                        VFOLow = vfo_hz + RXDisplayLow;    // low freq (left side) in hz
                        VFOHigh = vfo_hz + RXDisplayHigh; // high freq (right side) in hz
                    }

                    VFODiff = VFOHigh - VFOLow;       // diff in hz

                    if ((vfo_hz < 5000000) || ((vfo_hz > 6000000) && (vfo_hz < 8000000))) low = true; // LSB
                    else low = false;     // usb

                    //-------------------------------------------------------------------------------------------------
                    //-------------------------------------------------------------------------------------------------
                    // draw DX spots
                    //-------------------------------------------------------------------------------------------------
                    //-------------------------------------------------------------------------------------------------

                    /*    frequencies
                                   (DX_Freq[ii] != 1840000) && (DX_Freq[ii] != 3573000) && (DX_Freq[ii] != 7074000) && (DX_Freq[ii] != 10136000) &&
                                    (DX_Freq[ii] != 14074000) && (DX_Freq[ii] != 18100000) && (DX_Freq[ii] != 21074000) && (DX_Freq[ii] != 24915000) &&
                                     (DX_Freq[ii] != 50313000) && (DX_Freq[ii] != 50323000) 
                     */


                    for (int ii = 0; ii < SpotControl.DX_Index; ii++)     // Index through entire DXspot to find what is on this panadapter (draw vert lines first)
                    {

                        if ((SpotControl.DX_Freq[ii] >= VFOLow) && (SpotControl.DX_Freq[ii] <= VFOHigh))
                        {
                            int VFO_DXPos = (int)((((float)W / (float)VFODiff) * (float)(SpotControl.DX_Freq[ii] -CWPitch1 - VFOLow))); // determine DX spot line pos on current panadapter screen

                            holder[kk] = ii;                    // ii is the actual DX_INdex pos the the KK holds
                            holder1[kk] = VFO_DXPos;

                            kk++;

                            g.DrawLine(p1, VFO_DXPos , H1b, VFO_DXPos , H1a);   // draw vertical line

                        }

                    } // for loop through DX_Index


                    int bb = 0;
                    if (bottom)
                    {
                        Console.DXK2 = kk; // keep a count for the bottom QRZ hyperlink
                        bb = Console.MMK4;
                    }
                    else
                    {
                        Console.DXK = kk; // count of spots in current panadapter
                        bb = Console.MMK3;
                    }


                    //--------------------------------------------------------------------------------------------
                    for (int ii = 0; ii < kk; ii++) // draw call signs to screen in order to draw over the vert lines
                    {

                        // font
                        if (low) // 1=LSB so draw on left side of line
                        {

                            if (Console.DXR == 0) // display Spotted on Pan
                            {
                                length = g.MeasureString(SpotControl.DX_Station[holder[ii]], font1); //  temp used to determine the size of the string when in LSB and you need to reserve a certain space//  (cl.Width);

                                if ((bb > 0) && (SpotControl.SP6_Active != 0))
                                {
                                    int x2 = holder1[ii] - (int)length.Width;
                                    int y2 = H1b + iii;

                                    for (int jj = 0; jj < bb; jj++)
                                    {

                                        if (((x2 + length.Width) >= Console.MMX[jj]) && (x2 < (Console.MMX[jj] + Console.MMW[jj])))
                                        {
                                            if (((y2 + length.Height) >= Console.MMY[jj]) && (y2 < (Console.MMY[jj] + Console.MMH[jj])))
                                            {
                                                iii = iii + 33;
                                                break;
                                            }
                                        }

                                    } // for loop to check if DX text will draw over top of Memory text
                                }

                                g.DrawString(SpotControl.DX_Station[holder[ii]], font1, grid_text_brush, holder1[ii] - (int)length.Width , H1b + iii); // DX call sign to panadapter

                            }
                            else // display SPOTTER on Pan (not the Spotted)
                            {
                                length = g.MeasureString(SpotControl.DX_Spotter[holder[ii]], font1); //  temp used to determine the size of the string when in LSB and you need to reserve a certain space//  (cl.Width);

                                if ((bb > 0) && (SpotControl.SP6_Active != 0))
                                {
                                    int x2 = holder1[ii] - (int)length.Width;
                                    int y2 = H1b + iii;

                                    for (int jj = 0; jj < bb; jj++)
                                    {

                                        if (((x2 + length.Width) >= Console.MMX[jj]) && (x2 < (Console.MMX[jj] + Console.MMW[jj])))
                                        {
                                            if (((y2 + length.Height) >= Console.MMY[jj]) && (y2 < (Console.MMY[jj] + Console.MMH[jj])))
                                            {
                                                iii = iii + 33;
                                                break;
                                            }
                                        }

                                    } // for loop to check if DX text will draw over top of Memory text
                                }

                                g.DrawString(SpotControl.DX_Spotter[holder[ii]], font1, grid_text_brush, holder1[ii] - (int)length.Width , H1b + iii);

                            }

                            if (bottom) rx2 = 50; // allow only 50 qrz spots per Receiver
                            else rx2 = 0;

                            if (!mox) // only do when not transmitting
                            {
                                Console.DXW[ii + rx2] = (int)length.Width;    // this is all for QRZ hyperlinking 
                                Console.DXH[ii + rx2] = (int)length.Height;
                                Console.DXX[ii + rx2] = holder1[ii] - (int)length.Width;
                                Console.DXY[ii + rx2] = H1b + iii;
                                Console.DXS[ii + rx2] = SpotControl.DX_Station[holder[ii]];

                            }


                        } // LSB side


                        else   // 0=usb so draw on right side of line (normal)
                        {
                            if (Console.DXR == 0) // spot
                            {
                                length = g.MeasureString(SpotControl.DX_Station[holder[ii]], font1); //  not needed here but used for qrz hyperlinking

                                if ((bb > 0) && (SpotControl.SP6_Active != 0))
                                {
                                    int x2 = holder1[ii];
                                    int y2 = H1b + iii;

                                    for (int jj = 0; jj < bb; jj++)
                                    {

                                        if (((x2 + length.Width) >= Console.MMX[jj]) && (x2 < (Console.MMX[jj] + Console.MMW[jj])))
                                        {
                                            if (((y2 + length.Height) >= Console.MMY[jj]) && (y2 < (Console.MMY[jj] + Console.MMH[jj])))
                                            {
                                                iii = iii + 33;
                                                break;
                                            }
                                        }

                                    } // for loop to check if DX text will draw over top of Memory text
                                }

                                g.DrawString(SpotControl.DX_Station[holder[ii]], font1, grid_text_brush, holder1[ii] , H1b + iii); // DX station name
                            }
                            else // spotter
                            {
                                length = g.MeasureString(SpotControl.DX_Spotter[holder[ii]], font1); //  not needed here but used for qrz hyperlinking

                                if ((bb > 0) && (SpotControl.SP6_Active != 0))
                                {
                                    int x2 = holder1[ii];
                                    int y2 = H1b + iii;

                                    for (int jj = 0; jj < bb; jj++)
                                    {

                                        if (((x2 + length.Width) >= Console.MMX[jj]) && (x2 < (Console.MMX[jj] + Console.MMW[jj])))
                                        {
                                            if (((y2 + length.Height) >= Console.MMY[jj]) && (y2 < (Console.MMY[jj] + Console.MMH[jj])))
                                            {
                                                iii = iii + 33;
                                                break;
                                            }
                                        }

                                    } // for loop to check if DX text will draw over top of Memory text
                                }

                                g.DrawString(SpotControl.DX_Spotter[holder[ii]], font1, grid_text_brush, holder1[ii] , H1b + iii); // DX station name

                            }

                            if (bottom) rx2 = 50;
                            else rx2 = 0;

                            if (!mox) // only do when not transmitting
                            {
                                Console.DXW[ii + rx2] = (int)length.Width;   // this is all for QRZ hyperlinking 
                                Console.DXH[ii + rx2] = (int)length.Height;
                                Console.DXX[ii + rx2] = holder1[ii];
                                Console.DXY[ii + rx2] = H1b + iii;
                                Console.DXS[ii + rx2] = SpotControl.DX_Station[holder[ii]];
                            }

                            if (vfo_hz >= 50000000) // 50000000 or 50mhz
                            {
                                // dont display GRID on panadapter if on an FT8 freq
                                if ((SpotControl.DX_Freq[holder[ii]] != 1840000) && (SpotControl.DX_Freq[holder[ii]] != 3573000) && (SpotControl.DX_Freq[holder[ii]] != 7074000) && (SpotControl.DX_Freq[holder[ii]] != 10136000) &&
                                    (SpotControl.DX_Freq[holder[ii]] != 14074000) && (SpotControl.DX_Freq[holder[ii]] != 18100000) && (SpotControl.DX_Freq[holder[ii]] != 21074000) && (SpotControl.DX_Freq[holder[ii]] != 24915000) &&
                                    (SpotControl.DX_Freq[holder[ii]] != 50313000) && (SpotControl.DX_Freq[holder[ii]] != 50323000))
                                {
                                    iii = iii + 11;
                                    g.DrawString(SpotControl.DX_Grid[holder[ii]], font1, grid_text_brush, holder1[ii], H1b + iii); // DX grid name
                                }

                            }

                        } // USB side

                        iii = iii + 11;
                        if (iii > 90) iii = 0;

                    }// for loop through DX_Index

                } // SP_Active DX SSB CLUSTER

            } // do above only if BandText is not on

            //===============================================================================================================================================================
            //===============================================================================================================================================================


        } // draw panadapter grid




        //==========================================================================================================================================
        //================================================================
        // ke9ns drawwaterfall text
        //       continuum mode draws db numbers instead of freq
        //================================================================

        private static void DrawWaterfallGrid(ref Graphics g, int W, int H, int rx, bool bottom)
        {
            //  g.TextRenderingHint = TextRenderingHint.ClearTypeGridFit;
            //  g.CompositingMode = CompositingMode.SourceOver;
            //   g.CompositingQuality = CompositingQuality.HighQuality;
            //  g.InterpolationMode = InterpolationMode.HighQualityBicubic;
            //   g.SmoothingMode = SmoothingMode.HighQuality;
            //   g.PixelOffsetMode = PixelOffsetMode.HighQuality;

            // draw background
            // full screen W = 1607, H = 541  (shurnk W=1168, H=303)

          //    Debug.WriteLine("KE9NS DRAWWATERFALLGRID....H................. "+ H);
          //  Console.H10 = H; // ke9ns .197

            //   Debug.WriteLine("KE9NS DRAWWATERFALLGRID....W................. " + W);


            // ke9ns: this assures a black line for the waterfall frequencies to go into
            if (bottom) g.FillRectangle(new SolidBrush(display_background_color), 0, H, W, H);  // fill black on bottom half of display
            else g.FillRectangle(new SolidBrush(display_background_color), 0, 0, W, H);  // fill black into entire display


          

            // Low frequency to High frequency ?
            int low = rx_display_low;   // ke9ns  BASED ON SAMPLE RATE (192000, or 96000, etc) -4000 initial  but reads -97370 
            int high = rx_display_high; //  = 4000 initial but reads 79371

            if (rx == 2) //.219
            {
                low = rx_display_low2;           // 
                high = rx_display_high2;         // 

            }

            int mid_w = W / 2; // mid point of display window (horizontal)

            int[] step_list = { 10, 20, 25, 50 };

            int step_power = 1;
            int step_index = 0;
            int freq_step_size = 50;



            System.Drawing.Font font = new System.Drawing.Font("Swis721 BT", 9, FontStyle.Italic); // Arial size and style of freq text for waterfall

            SolidBrush grid_text_brush = new SolidBrush(grid_text_color);
            Pen grid_pen = new Pen(grid_color);
            Pen tx_filter_pen = new Pen(display_filter_tx_color);


            int y_range = spectrum_grid_max - spectrum_grid_min; // ke9ns 0 - -160 :     y_range = 160 default, but reads 120


            int filter_low, filter_high;  // ke9ns based on your audio filter settings

            int center_line_x = (int)(-(double)low / (high - low) * W); // ke9ns 885 full screen (shrunk 643) =(97370/(176741))*1607

            //  Debug.WriteLine("KE9NS Y-Range................. " + y_range);

            //  Debug.WriteLine("KE9NS Centerlinex................. " + center_line_x);

            if (mox) // get filter limits
            {
                filter_low = tx_filter_low;
                filter_high = tx_filter_high;
            }
            else if (rx == 1)
            {
                filter_low = rx1_filter_low;
                filter_high = rx1_filter_high;
            }
            else //if(rx==2)
            {
                filter_low = rx2_filter_low;
                filter_high = rx2_filter_high;
            }

            if ((rx1_dsp_mode == DSPMode.DRM && rx == 1) ||
                (rx2_dsp_mode == DSPMode.DRM && rx == 2))
            {
                filter_low = -5000;
                filter_high = 5000;
            }

            // Calculate hor step size (left to right)
            int width = high - low; // high freq - low freq

            while (width / freq_step_size > 10)
            {
                freq_step_size = step_list[step_index] * (int)Math.Pow(10.0, step_power);
                step_index = (step_index + 1) % 4;
                if (step_index == 0) step_power++;
            }
            double w_pixel_step = (double)W * freq_step_size / width;
            int w_steps = width / freq_step_size;


            //================================================================
            // ke9ns drawwaterfall vertical tick marks
            //================================================================

            // calculate vertical step size
            int h_steps = (spectrum_grid_max - spectrum_grid_min) / spectrum_grid_step;

            if ((rx == 1) && (continuum == 1)) // ke9ns add (20 db steps listed on the top line)
            {
                h_steps = 20;
            }

            double h_pixel_step = (double)H / h_steps;

            int top = top1 = (int)((double)spectrum_grid_step * H / y_range); // ke9ns top=12

            if (bottom) top = top * 2;

            //   Debug.WriteLine("KE9NS top................. " + top);

            if ((continuum == 0)) // || (rx == 2))
            {
                if (rx == 1) // was !bottom
                {

                    //===========================================================================================
                    // ke9ns RX1 draw sub rec bandpass area
                    //===========================================================================================
                    if (!mox && sub_rx1_enabled && (!bottom))
                    {
                        // draw Sub RX 0Hz line
                        int x = (int)((float)(vfoa_sub_hz - vfoa_hz - low) / (high - low) * W);

                        g.DrawLine(new Pen(sub_rx_zero_line_color), x, 0, x, top);
                        g.DrawLine(new Pen(sub_rx_zero_line_color), x - 1, 0, x - 1, top);

                        // draw Sub RX filter
                        // get filter screen coordinates
                        int filter_left_x = (int)((float)(filter_low - low + vfoa_sub_hz - vfoa_hz) / (high - low) * W);
                        int filter_right_x = (int)((float)(filter_high - low + vfoa_sub_hz - vfoa_hz) / (high - low) * W);

                        // make the filter display at least one pixel wide.
                        if (filter_left_x == filter_right_x) filter_right_x = filter_left_x + 1;

                        // draw rx filter
                        g.FillRectangle(new SolidBrush(sub_rx_filter_color),    // draw filter overlay
                            filter_left_x, 0, filter_right_x - filter_left_x, top);

                    } // sub rx1 on


                    //===========================================================================================
                    // ke9ns RX1 draw main bandpass area
                    //===========================================================================================
                    if (!(mox && (rx1_dsp_mode == DSPMode.CWL || rx1_dsp_mode == DSPMode.CWU)))  // draw bandpass for RX or bandpass for TX (but not in cW mode)
                    {

                        // get filter screen coordinates
                        int filter_left_x;
                        int filter_right_x;

                        filter_left_x = (int)((float)(filter_low - low) / (high - low) * W);
                        filter_right_x = (int)((float)(filter_high - low) / (high - low) * W);

                        // make the filter display at least one pixel wide.
                        if (filter_left_x == filter_right_x) filter_right_x = filter_left_x + 1;

                        if (bottom) // bottom half K9==3 or K9==5 if rx2 enabled
                        {

                            //   if (K9 == 3 )
                            //  {
                            //      g.FillRectangle(new SolidBrush(display_filter_color),   // draw filter overlay
                            //          filter_left_x, H, filter_right_x - filter_left_x, H + top); 
                            //  }
                        }
                        else // top half this would be water only K9 == 1
                        {
                            g.FillRectangle(new SolidBrush(display_filter_color),   // draw filter overlay
                            filter_left_x, 0, filter_right_x - filter_left_x, top);
                        }
                    } // main RX1 waterfall bandpass

                    //===========================================================================================
                    // ke9ns RX1 draw tx anything but cw lines
                    //===========================================================================================
                    if ((!mox) && (draw_tx_filter) && (rx1_dsp_mode != DSPMode.CWL && rx1_dsp_mode != DSPMode.CWU))
                    {
                        // get tx filter limits
                        int filter_left_x;
                        int filter_right_x;

                        if (!split_enabled)
                        {
                            filter_left_x = (int)((float)(tx_filter_low - low + xit_hz) / (high - low) * W);
                            filter_right_x = (int)((float)(tx_filter_high - low + xit_hz) / (high - low) * W);
                        }
                        else
                        {
                            filter_left_x = (int)((float)(tx_filter_low - low + xit_hz + (vfoa_sub_hz - vfoa_hz)) / (high - low) * W);
                            filter_right_x = (int)((float)(tx_filter_high - low + xit_hz + (vfoa_sub_hz - vfoa_hz)) / (high - low) * W);
                        }

                        if (!bottom) // top half 
                        {
                            g.DrawLine(tx_filter_pen, filter_left_x, 0, filter_left_x, top);        // draw tx filter overlay  0. H + top
                            g.DrawLine(tx_filter_pen, filter_right_x, 0, filter_right_x, top);      // draw tx filter overlay
                        }
                        else // bottom half  K9 ==3 or K9==5 if rX2 on
                        {

                            if (K9 == 3)
                            {
                                g.DrawLine(tx_filter_pen, filter_left_x, H, filter_left_x, H + top);        // draw tx filter overlay  0. H + top
                                g.DrawLine(tx_filter_pen, filter_right_x, H, filter_right_x, H + top);      // draw tx filter overlay
                            }

                        }

                    } // 

                    //===========================================================================================
                    // ke9ns RX1 draw tx cw line (waterfall grid)
                    //===========================================================================================
                    if ((draw_tx_cw_freq || console.setupForm.chkCWDisplay.Checked) && (rx1_dsp_mode == DSPMode.CWL || rx1_dsp_mode == DSPMode.CWU)) // ke9ns mod
                    {
                        int pitch = cw_pitch;
                        if (rx1_dsp_mode == DSPMode.CWL) pitch = -cw_pitch;


                        //  int cw_line_x;
                        if (!split_enabled)
                        {
                            cw_line_x = (int)((float)(pitch - low + xit_hz) / (high - low) * W);
                        }
                        else
                        {
                            if ((!mox)) // rx
                            {
                                cw_line_x = (int)((float)(pitch - low + xit_hz + (vfoa_sub_hz - vfoa_hz)) / (high - low) * W);
                            }
                            else // tx
                            {
                                cw_line_x = (int)((float)(pitch - low + xit_hz) / (high - low) * W);

                            }

                        }

                        if (!mox && draw_tx_cw_freq)
                        {
                            if (!bottom) // top
                            {
                                g.DrawLine(tx_filter_pen, cw_line_x, 0, cw_line_x, top); // top1
                                g.DrawLine(tx_filter_pen, cw_line_x + 1, 0, cw_line_x + 1, top);
                            }
                            else // bottom half  K9 ==3 or K9==5 if rX2 on
                            {
                                if (K9 == 3 || K9 == 7)
                                {
                                    g.DrawLine(tx_filter_pen, cw_line_x, H, cw_line_x, H + top);
                                    g.DrawLine(tx_filter_pen, cw_line_x + 1, H, cw_line_x + 1, H + top);
                                }

                            }
                        }
                    }

                } // rx == 1
                else // rx == 2
                {

                    if (K10 == 1) // if RX2 only on water mode
                    {
                        //===========================================================================================
                        // ke9ns RX2 draw main  bandpass area
                        //===========================================================================================
                        if (!(mox && (rx2_dsp_mode == DSPMode.CWL || rx2_dsp_mode == DSPMode.CWU)))  // draw bandpass for RX or bandpass for TX (but not in cW mode)) 
                        {
                            // get filter screen coordinates
                            int filter_left_x;
                            int filter_right_x;

                            filter_left_x = (int)((float)(filter_low - low) / (high - low) * W);
                            filter_right_x = (int)((float)(filter_high - low) / (high - low) * W);

                            // make the filter display at least one pixel wide.
                            if (filter_left_x == filter_right_x) filter_right_x = filter_left_x + 1;

                            // draw rx filter
                            g.FillRectangle(new SolidBrush(display_filter_color),   // draw filter overlay
                                filter_left_x, H, filter_right_x - filter_left_x, H + top);

                        } // RX2 main rx2 bandpass in the waterfall


                        //===========================================================================================
                        // ke9ns RX2 draw tx anything but cw lines
                        //===========================================================================================
                        if (!mox && draw_tx_filter && (rx2_dsp_mode != DSPMode.CWL && rx2_dsp_mode != DSPMode.CWU) && (tx_on_vfob))
                        {
                            // get tx filter limits
                            int filter_left_x;
                            int filter_right_x;

                            if (!split_enabled)
                            {
                                filter_left_x = (int)((float)(tx_filter_low - low + xit_hz) / (high - low) * W);
                                filter_right_x = (int)((float)(tx_filter_high - low + xit_hz) / (high - low) * W);
                            }
                            else
                            {
                                filter_left_x = (int)((float)(tx_filter_low - low + xit_hz + (vfoa_sub_hz - vfoa_hz)) / (high - low) * W);
                                filter_right_x = (int)((float)(tx_filter_high - low + xit_hz + (vfoa_sub_hz - vfoa_hz)) / (high - low) * W);
                            }

                            g.DrawLine(tx_filter_pen, filter_left_x, H, filter_left_x, H + top);        // draw tx filter overlay
                            g.DrawLine(tx_filter_pen, filter_right_x, H, filter_right_x, H + top);      // draw tx filter overlay

                        } // TX2 transmit lines

                        //===========================================================================================
                        // ke9ns RX2 draw tx cw line (waterfall grid)
                        //===========================================================================================
                        if ((!mox) && (draw_tx_cw_freq || console.setupForm.chkCWDisplay.Checked) && (rx2_dsp_mode == DSPMode.CWL || rx2_dsp_mode == DSPMode.CWU) && (tx_on_vfob)) // ke9ns mod
                        {
                            int pitch = cw_pitch;
                            if (rx2_dsp_mode == DSPMode.CWL) pitch = -cw_pitch;

                            int cw_line_x;
                            if (!split_enabled)

                                cw_line_x = (int)((float)(pitch - low + xit_hz) / (high - low) * W);

                            else
                                cw_line_x = (int)((float)(pitch - low + xit_hz + (vfoa_sub_hz - vfoa_hz)) / (high - low) * W);

                            if (draw_tx_cw_freq)
                            {
                                g.DrawLine(tx_filter_pen, cw_line_x, H, cw_line_x, H + top);
                                g.DrawLine(tx_filter_pen, cw_line_x + 1, H, cw_line_x + 1, H + top);
                            }

                        } // cw transmit line

                    }
                } // rx==2



            } // no continuum mode

            double vfo;


            //===========================================================================================
            // 
            if (mox) // ke9ns mod everythingin the MOX section 
            {
                if (split_enabled) // means just RX1
                {
                    vfo = vfoa_sub_hz + xit_hz;

                    switch (rx1_dsp_mode) // ke9ns add: because waterfall freq text didnt shift the pitch amount during transmit
                    {
                        case DSPMode.CWL:
                            vfo += cw_pitch;
                            break;
                        case DSPMode.CWU:
                            vfo -= cw_pitch;
                            break;
                        default:
                            break;
                    }
                }
                else
                {

                    if (console.chkVFOATX.Checked == true)
                    {
                        if (rx == 1)
                        {
                            vfo = vfoa_hz + xit_hz;  // ke9ns natural choice

                            switch (rx1_dsp_mode) // ke9ns add: because waterfall freq text didnt shift the pitch amount during transmit
                            {
                                case DSPMode.CWL:
                                    vfo += cw_pitch;
                                    break;
                                case DSPMode.CWU:
                                    vfo -= cw_pitch;
                                    break;
                                default:
                                    break;
                            }


                        }
                        else // rx == 2
                        {
                            vfo = vfob_hz + rit_hz; // this is still in receive

                            switch (rx2_dsp_mode)
                            {
                                case DSPMode.CWL:
                                    vfo += cw_pitch;
                                    break;
                                case DSPMode.CWU:
                                    vfo -= cw_pitch;
                                    break;
                                default:
                                    break;
                            }

                        }
                    } // VFOA TX
                    else // VFOB TX
                    {
                        if (rx == 1) // ke9ns: RX1 is still in receive now 
                        {
                            vfo = vfoa_hz + rit_hz;

                            switch (rx1_dsp_mode)
                            {
                                case DSPMode.CWL:
                                    vfo += cw_pitch;
                                    break;
                                case DSPMode.CWU:
                                    vfo -= cw_pitch;
                                    break;
                                default:
                                    break;
                            }
                        }
                        else // rx==2
                        {
                            vfo = vfob_hz + xit_hz;

                            switch (rx2_dsp_mode)
                            {
                                case DSPMode.CWL:
                                    vfo += cw_pitch;
                                    break;
                                case DSPMode.CWU:
                                    vfo -= cw_pitch;
                                    break;
                                default:
                                    break;
                            }

                        }

                    } // VFOB TX

                } // no split mode



            } // TX above
            else if (rx == 1) // rx mode
            {
                vfo = vfoa_hz + rit_hz;

                switch (rx1_dsp_mode)
                {
                    case DSPMode.CWL:
                        vfo += cw_pitch;
                        break;
                    case DSPMode.CWU:
                        vfo -= cw_pitch;
                        break;
                    default:
                        break;
                }
            }
            else //if(rx==2)
            {
                vfo = vfob_hz + rit_hz;

                switch (rx2_dsp_mode)
                {
                    case DSPMode.CWL:
                        vfo += cw_pitch;
                        break;
                    case DSPMode.CWU:
                        vfo -= cw_pitch;
                        break;
                    default:
                        break;
                }
            }



            long vfo_round = ((long)(vfo / freq_step_size)) * freq_step_size;  // round freq you are currently on
            long vfo_delta = (long)(vfo - vfo_round); // difference between real and rounded

            //   Debug.WriteLine("round " + vfo_round);
            //   Debug.WriteLine("delta " + vfo_delta);
            //  Debug.WriteLine("vfo " + vfo);



            if ((rx == 1) && (continuum == 1)) // ke9ns add
            {

                for (int i = 0; i <= h_steps + 1; i++)  // ke9ns draw freq numbers in line just above waterfall
                {

                    int temp = (W) / h_steps;

                    int temp1 = i * temp; //ke9ns x pixel position to print text string (left to right: 0 to W*3)  (W = 1388, so W*3 = 4164)

                    int temp2 = (W) - temp1;                                     // ke9ns add reverse function (left to right: W*3 to 0)
                                                                                 //  int temp4 = (int)(50)* 1;          // ke9ns add (50)

                    int temp3 = (int)((float)temp2 * ((float)150 / (float)(W)));     // ke9ns add (4164*(107 / 4164))                               convert postition to -dbm 

                    string label1 = temp3.ToString("d3");

                    g.DrawString(label1, font, grid_text_brush, temp1, (float)Math.Floor(H * .005)); // ke9ns shift labels over 100 to allow room for time stamp on left side


                    //  Debug.WriteLine("W " + W + " temp " + temp + " temp1 " + temp1 + " temp2 " + temp2 + " temp3 " + temp3);
                } // horz steps

            } // continuum mode
            else // not in continuum mode
            {

                // Draw vertical lines
                switch (console.CurrentRegion)
                {
                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.US:
                        //  Debug.Write("low " + waterfall_low_threshold + " high " + waterfall_high_threshold);


                        for (int i = 0; i <= h_steps + 1; i++)  // ke9ns draw freq numbers in line just above waterfall
                        {


                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;  // freq to print out

                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            //   Debug.WriteLine("fgrid " + fgrid);
                            //   Debug.WriteLine("Afgrid " + actual_fgrid);
                            //   Debug.WriteLine("vgrid " + vgrid);


                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 0.1357 || actual_fgrid == 0.1358 ||   // 2200m band edges
                                    actual_fgrid == 0.472 || actual_fgrid == 0.479 ||   // 630m band edges
                                    actual_fgrid == 1.8 || actual_fgrid == 2.0 ||   // 160m band edges
                                    actual_fgrid == 3.5 || actual_fgrid == 4.0 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||

                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 148.0)
                                {

                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H); // ke9ns draw little tick lines under freq at band edges only
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005)); // was .01 ke9ns draw frequency at band edges in RED
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005)); // .01

                                } // actual_fgrid
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }


                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                    grid_pen.DashStyle = DashStyle.Solid;

                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (((double)((int)(actual_fgrid * 1000))) == actual_fgrid * 1000)
                                    {
                                        label = actual_fgrid.ToString("f3"); //wa6ahl

                                        //if(actual_fgrid > 1300.0)
                                        //	label = label.Substring(label.Length-4);

                                        if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                        else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                        else offsetL = (int)((label.Length + 1) * 4.1) - 8;
                                    }
                                    else
                                    {
                                        string temp_string;
                                        int jper;
                                        label = actual_fgrid.ToString("f4");
                                        temp_string = label;
                                        jper = label.IndexOf('.') + 4;
                                        label = label.Insert(jper, " ");

                                        //if(actual_fgrid > 1300.0)
                                        //	label = label.Substring(label.Length-4);

                                        if (actual_fgrid < 10) offsetL = (int)((label.Length) * 4.1) - 14;
                                        else if (actual_fgrid < 100.0) offsetL = (int)((label.Length) * 4.1) - 11;
                                        else offsetL = (int)((label.Length) * 4.1) - 8;
                                    } */

                                    //================================================================
                                    // ke9ns draw waterfall actually draw text
                                    //================================================================


                                    if (bottom) // ke9ns: this can be RX1 on the bottom if in Panafall mode (and always RX2)
                                    {
                                        g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005)); // .01
                                    }
                                    else // just RX1 in waterfall mode only
                                    {
                                        g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                    }

                                    // Debug.WriteLine("KE9NS H................. " + H);

                                } // no actual fgrid (these are the remaining frequences to show in the strip above the waterfall)

                            } // no showfreqoffset
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            } // show freq offset


                        } // for i loop

                        //  actual_fgrid == 0.1357 || actual_fgrid == 0.1358 ||   // 2200m band edges
                        //          actual_fgrid == 0.472 || actual_fgrid == 0.479 ||   // 630m band edges


                        int[] band_edge_list_r2 = { 0135700, 0137800, 0472000, 0479000, 1800000, 2000000, 3500000, 4000000, 5250000,5450000,
                                       7000000, 7300000, 10100000, 10150000, 14000000, 14350000, 18068000, 18168000, 21000000, 21450000,
                                       24890000, 24990000, 26960000, 27410000, 28000000, 29700000, 50000000, 54000000, 144000000, 148000000 }; //ke9ns add CB

                        for (int i = 0; i < band_edge_list_r2.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r2[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break;  // ke9ns US region end of drawing freq values for waterfall FRSREGION.US


                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Europe:      // EU00 (IARU1 60m) Germany


                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.03 || actual_fgrid == 51.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1 = {  1810000, 2000000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50030000, 51000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU00





                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.UK:          // EU01 (no 60m) (UK+ has its own special segments)
                    case FRSRegion.France:      // EU01 (no 60m)
                    case FRSRegion.Slovakia:    // EU01 (no 60m)
                    case FRSRegion.UK_Plus:     // EU02
                    case FRSRegion.Norway:      // EU03  (5.25 to 5.45 60m) (also includes Czech rep)
                    case FRSRegion.Denmark:     // EU03 
                    case FRSRegion.Sweden:      // EU06 (IARU1 60m)& (52mhz for 6m)
                    case FRSRegion.ES_CH_FIN:   // EU12(IARU1 60m) & (52mhz for 6m)
                    case FRSRegion.EU_Travel:   // EU14 (5.25 to 5.45 60m) & (52mhz 6m)


                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.74 || actual_fgrid == 24.99 || // was 24.89
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.00 || actual_fgrid == 52.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1a = {  1810000, 2000000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1a.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1a[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU01,EU02,EU03,EU06, EU12,EU14




                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Belgium:     // EU04 (IARU1 60m)

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.00 || actual_fgrid == 52.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1b = {  1810000, 1880000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1b.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1b[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU04



                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Hungary:     // EU05 

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 2.00 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.201 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.00 || actual_fgrid == 52.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1c = {  1810000, 2000000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1c.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1c[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU05



                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Bulgaria:    // EU07 (no 60m)

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 1.85 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.05 || actual_fgrid == 50.2 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1d = {  1810000, 1850000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50050000, 50200000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1d.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1d[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU07


                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Latvia:      // EU08 (no 60m)

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 2.0 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 51.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1e = {  1810000, 2000000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 51000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1e.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1e[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU08


                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Greece:      // EU09 (no 60m)

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 1.85 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1f = {  1810000, 1850000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1f.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1f[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU09



                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Italy:       // EU10 (no 60m)

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.83 || actual_fgrid == 1.85 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 51.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1g = {  1830000, 1850000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 51000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1g.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1g[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU10



                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Italy_Plus:  // EU11 (no 60m)

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.83 || actual_fgrid == 1.85 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 6.975 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 51.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1j = {  1830000, 1850000, 3500000, 3800000, 5250000,5450000,
                                    6975000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1j.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1j[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU11


                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Netherlands: // EU13 (5.35 to 5.45 60m)

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 1.88 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1k = {  1810000, 1880000, 3500000, 3800000, 5350000, 5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1k.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1k[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // EU13



                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Luxembourg:  // EU15 (IARU1 60m) & (52mhz 6m)

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.81 || actual_fgrid == 2.00 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.2 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 52.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1u = {  1810000, 2000000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7200000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 52000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1u.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1u[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // Luxembourg EU15


                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.IARU2:  // IARU2

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.80 || actual_fgrid == 2.00 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 4.0 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 148.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1q = {  1800000, 2000000, 3500000, 4000000, 5250000,5450000,
                                    7000000, 7300000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 54000000, 144000000, 148000000 };

                        for (int i = 0; i < band_edge_list_r1q.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1q[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // IARU2


                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.Australia:  // 

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.80 || actual_fgrid == 1.875 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.8 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns no transmit
                                    actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 147.975)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1h = {  1800000, 1875000, 3500000, 3800000, 5250000,5450000,
                                    7000000, 7300000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 54000000, 144000000, 147975000 };

                        for (int i = 0; i < band_edge_list_r1h.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1h[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // Australia


                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.IARU3:  // IARU3

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.80 || actual_fgrid == 2.00 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.9 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL = (int)((label.Length + 1) * 4.1);
                                offsetR = (int)(label.Length * 4.1);
                                if ((vgrid - offsetL >= 0) && (vgrid + offsetR < W) && (fgrid != 0))
                                {
                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                        }


                        int[] band_edge_list_r1w = {  1800000, 2000000, 3500000, 3900000, 5250000,5450000,
                                    7000000, 7300000, 10100000, 10150000, 14000000, 14350000,18068000, 18168000, 21000000, 21450000,
                                    24890000, 24990000, 28000000, 29700000, 50000000, 54000000, 144000000, 146000000 };

                        for (int i = 0; i < band_edge_list_r1w.Length; i++)
                        {
                            double band_edge_offset = band_edge_list_r1w[i] - vfo;
                            if (band_edge_offset >= low && band_edge_offset <= high)
                            {
                                int temp_vline = (int)((double)(band_edge_offset - low) / (high - low) * W);//wa6ahl
                                if (bottom) g.DrawLine(new Pen(band_edge_color), temp_vline, H, temp_vline, H + top);//wa6ahl
                                else g.DrawLine(new Pen(band_edge_color), temp_vline, 0, temp_vline, top);
                            }
                            if (i == 1 && !show_freq_offset) break;
                        }


                        break; // IARU3


                    //============================================================================================================
                    //============================================================================================================
                    //============================================================================================================
                    //===============================================
                    case FRSRegion.China:  // 25

                        for (int i = 0; i <= h_steps + 1; i++)
                        {
                            string label;
                            int offsetL;
                            int offsetR;

                            int fgrid = i * freq_step_size + (low / freq_step_size) * freq_step_size;
                            double actual_fgrid = ((double)(vfo_round + fgrid)) / 1000000;
                            int vgrid = (int)((double)(fgrid - vfo_delta - low) / (high - low) * W);

                            if (!show_freq_offset)
                            {
                                if (actual_fgrid == 1.80 || actual_fgrid == 2.00 ||
                                    actual_fgrid == 3.5 || actual_fgrid == 3.9 ||
                                    actual_fgrid == 5.250 || actual_fgrid == 5.45 ||   // ke9ns add
                                    actual_fgrid == 7.0 || actual_fgrid == 7.3 ||
                                    actual_fgrid == 10.1 || actual_fgrid == 10.15 ||
                                    actual_fgrid == 14.0 || actual_fgrid == 14.35 ||
                                    actual_fgrid == 18.068 || actual_fgrid == 18.168 ||
                                    actual_fgrid == 21.0 || actual_fgrid == 21.45 ||
                                    actual_fgrid == 24.89 || actual_fgrid == 24.99 ||
                                    actual_fgrid == 28.0 || actual_fgrid == 29.7 ||
                                    actual_fgrid == 50.0 || actual_fgrid == 54.0 ||
                                    actual_fgrid == 144.0 || actual_fgrid == 146.0)
                                {
                                    if (bottom) g.DrawLine(new Pen(band_edge_color), vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(new Pen(band_edge_color), vgrid, top, vgrid, H);

                                    label = actual_fgrid.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    /* if (actual_fgrid < 10) offsetL = (int)((label.Length + 1) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length + 1) * 4.1) - 8; */

                                    if (bottom) g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, new SolidBrush(band_edge_color), vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                                else
                                {

                                    if (freq_step_size >= 2000)
                                    {
                                        double t100;
                                        double t1000;
                                        t100 = (actual_fgrid * 100);
                                        t1000 = (actual_fgrid * 1000);

                                        int it100 = (int)t100;
                                        int it1000 = (int)t1000;

                                        int it100x10 = it100 * 10;

                                        if (it100x10 == it1000)
                                        {
                                        }
                                        else
                                        {
                                            grid_pen.DashStyle = DashStyle.Dot;
                                        }
                                    }
                                    else
                                    {
                                        if (freq_step_size == 1000)
                                        {
                                            double t200;
                                            double t2000;
                                            t200 = (actual_fgrid * 200);
                                            t2000 = (actual_fgrid * 2000);

                                            int it200 = (int)t200;
                                            int it2000 = (int)t2000;

                                            int it200x10 = it200 * 10;

                                            if (it200x10 == it2000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                        else
                                        {
                                            double t1000;
                                            double t10000;
                                            t1000 = (actual_fgrid * 1000);
                                            t10000 = (actual_fgrid * 10000);

                                            int it1000 = (int)t1000;
                                            int it10000 = (int)t10000;

                                            int it1000x10 = it1000 * 10;

                                            if (it1000x10 == it10000)
                                            {
                                            }
                                            else
                                            {
                                                grid_pen.DashStyle = DashStyle.Dot;
                                            }
                                        }
                                    }
                                    if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                    else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl
                                    grid_pen.DashStyle = DashStyle.Solid;

                                    // make freq grid labels
                                    double actual_fgrid_label = Math.Round(actual_fgrid, 4);
                                    label = actual_fgrid_label.ToString("f4");
                                    label = label.Replace(",", ".");    // handle Windows localization issues
                                    int offset = label.IndexOf('.') + 4;
                                    label = label.Insert(offset, ".");

                                    if (actual_fgrid < 10) offsetL = (int)((label.Length + 2) * 4.1) - 14;
                                    else if (actual_fgrid < 100.0) offsetL = (int)((label.Length + 1) * 4.1) - 11;
                                    else offsetL = (int)((label.Length) * 4.1) - 8;

                                    if (bottom) g.DrawString(label, font, grid_text_brush, vgrid - offsetL, H + (float)Math.Floor(H * .005));
                                    else g.DrawString(label, font, grid_text_brush, vgrid - offsetL, (float)Math.Floor(H * .005));
                                }
                            }
                            else
                            {
                                vgrid = Convert.ToInt32((double)-(fgrid - low) / (low - high) * W); //wa6ahl
                                if (bottom) g.DrawLine(grid_pen, vgrid, H + top, vgrid, H + H);
                                else g.DrawLine(grid_pen, vgrid, top, vgrid, H);            //wa6ahl

                                double new_fgrid = (vfoa_hz + fgrid) / 1000000;

                                label = fgrid.ToString();
                                offsetL 