//=================================================================
// setup.cs
//=================================================================
// PowerSDR is a C# implementation of a Software Defined Radio.
// Copyright (C) 2003-2013  FlexRadio Systems
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// You may contact us via email at: gpl@flexradio.com.
// Paper mail may be sent to: 
//    FlexRadio Systems
//    4616 W. Howard Lane  Suite 1-150
//    Austin, TX 78728
//    USA
//=================================================================



namespace PowerSDR
{
    public partial class Setup : System.Windows.Forms.Form
    {
       
        #region Windows Form Designer generated code

        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Setup));
            this.tcSetup = new System.Windows.Forms.TabControl();
            this.tpGeneral = new System.Windows.Forms.TabPage();
            this.tcGeneral = new System.Windows.Forms.TabControl();
            this.tpGeneralHardware = new System.Windows.Forms.TabPage();
			this.chkExtended = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxShutdown = new System.Windows.Forms.CheckBoxTS();
            this.chkBox30min = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxPTTLatch = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxPTT = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxAutoFocus = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxAutoStart = new System.Windows.Forms.CheckBoxTS();
            this.textBoxRestart = new System.Windows.Forms.TextBoxTS();
            this.chkBoxRestart = new System.Windows.Forms.CheckBoxTS();
            this.grpGeneralHardwareFLEX5000 = new System.Windows.Forms.GroupBoxTS();
            this.lblversion = new System.Windows.Forms.LabelTS();
            this.labelTS42 = new System.Windows.Forms.LabelTS();
            this.lblFlexControlRev = new System.Windows.Forms.LabelTS();
            this.lblVURev = new System.Windows.Forms.LabelTS();
            this.udF3KFanTempThresh = new System.Windows.Forms.NumericUpDownTS();
            this.lblF3KFanTempThresh = new System.Windows.Forms.LabelTS();
            this.chkGenFLEX5000ExtRef = new System.Windows.Forms.CheckBoxTS();
            this.lblFirmwareRev = new System.Windows.Forms.LabelTS();
            this.lblRX2Rev = new System.Windows.Forms.LabelTS();
            this.lblATURev = new System.Windows.Forms.LabelTS();
            this.lblRFIORev = new System.Windows.Forms.LabelTS();
            this.lblPARev = new System.Windows.Forms.LabelTS();
            this.lblTRXRev = new System.Windows.Forms.LabelTS();
            this.lblSerialNum = new System.Windows.Forms.LabelTS();
            this.lblModel = new System.Windows.Forms.LabelTS();
            this.grpGeneralHardwareSDR1000 = new System.Windows.Forms.GroupBoxTS();
            this.lblFlexControlRev1K = new System.Windows.Forms.LabelTS();
            this.chkEnableRFEPATR = new System.Windows.Forms.CheckBoxTS();
            this.chkGeneralUSBPresent = new System.Windows.Forms.CheckBoxTS();
            this.chkGeneralATUPresent = new System.Windows.Forms.CheckBoxTS();
            this.chkGeneralPAPresent = new System.Windows.Forms.CheckBoxTS();
            this.chkGeneralXVTRPresent = new System.Windows.Forms.CheckBoxTS();
            this.lblGeneralLPTDelay = new System.Windows.Forms.LabelTS();
            this.udGeneralLPTDelay = new System.Windows.Forms.NumericUpDownTS();
            this.lblGeneralLPTAddr = new System.Windows.Forms.LabelTS();
            this.comboGeneralLPTAddr = new System.Windows.Forms.ComboBoxTS();
            this.comboGeneralXVTR = new System.Windows.Forms.ComboBoxTS();
            this.labelTS31 = new System.Windows.Forms.LabelTS();
            this.udPTTHT = new System.Windows.Forms.NumericUpDownTS();
            this.chkBoxPTTHT = new System.Windows.Forms.CheckBoxTS();
            this.textBoxTOT = new System.Windows.Forms.TextBoxTS();
            this.labelTS23 = new System.Windows.Forms.LabelTS();
            this.udTOT = new System.Windows.Forms.NumericUpDownTS();
            this.chkBoxTOT = new System.Windows.Forms.CheckBoxTS();
            this.grpHWSoftRock = new System.Windows.Forms.GroupBoxTS();
            this.lblGenSoftRockCenterFreq = new System.Windows.Forms.LabelTS();
            this.udSoftRockCenterFreq = new System.Windows.Forms.NumericUpDownTS();
            this.grpGeneralDDS = new System.Windows.Forms.GroupBoxTS();
            this.chkGenDDSExpert = new System.Windows.Forms.CheckBox();
            this.udDDSCorrection = new System.Windows.Forms.NumericUpDownTS();
            this.lblClockCorrection = new System.Windows.Forms.LabelTS();
            this.udDDSIFFreq = new System.Windows.Forms.NumericUpDownTS();
            this.lblIFFrequency = new System.Windows.Forms.LabelTS();
            this.udDDSPLLMult = new System.Windows.Forms.NumericUpDownTS();
            this.lblPLLMult = new System.Windows.Forms.LabelTS();
            this.grpGeneralModel = new System.Windows.Forms.GroupBoxTS();
            this.radGenModelFLEX1500 = new System.Windows.Forms.RadioButtonTS();
            this.radGenModelFLEX5000 = new System.Windows.Forms.RadioButtonTS();
            this.radGenModelDemoNone = new System.Windows.Forms.RadioButtonTS();
            this.radGenModelSoftRock40 = new System.Windows.Forms.RadioButtonTS();
            this.radGenModelSDR1000 = new System.Windows.Forms.RadioButtonTS();
            this.btnWizard = new System.Windows.Forms.ButtonTS();
            this.chkGeneralRXOnly = new System.Windows.Forms.CheckBoxTS();
            this.grpGeneralHardwareFLEX1500 = new System.Windows.Forms.GroupBoxTS();
            this.labelTS43 = new System.Windows.Forms.LabelTS();
            this.labelTS44 = new System.Windows.Forms.LabelTS();
            this.lblFlexControlRev1500 = new System.Windows.Forms.LabelTS();
            this.chkGenFLEX1500Xref = new System.Windows.Forms.CheckBoxTS();
            this.lbl1500FWRev = new System.Windows.Forms.LabelTS();
            this.lbl1500PARev = new System.Windows.Forms.LabelTS();
            this.lbl1500TRXRev = new System.Windows.Forms.LabelTS();
            this.lbl1500SN = new System.Windows.Forms.LabelTS();
            this.tpGeneralOptions = new System.Windows.Forms.TabPage();
            this.chkPM2 = new System.Windows.Forms.CheckBoxTS();
            this.udPwrMstrCOM = new System.Windows.Forms.NumericUpDownTS();
            this.chkBoxWheelRev = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxPM1 = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxIICON = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxIIC = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxVFOLockAB = new System.Windows.Forms.CheckBoxTS();
            this.buttonTS2 = new System.Windows.Forms.ButtonTS();
            this.chkBoxBandStack = new System.Windows.Forms.CheckBoxTS();
            this.chkGenOptionsShowATUPopup = new System.Windows.Forms.CheckBoxTS();
            this.chkImportDBRestrict = new System.Windows.Forms.CheckBoxTS();
            this.grpOptUSBBuf = new System.Windows.Forms.GroupBoxTS();
            this.lblOptUSBBufConservative = new System.Windows.Forms.LabelTS();
            this.lblOptUSBBufAggressive = new System.Windows.Forms.LabelTS();
            this.tbOptUSBBuf = new System.Windows.Forms.TrackBarTS();
            this.grpGenCustomTitleText = new System.Windows.Forms.GroupBoxTS();
            this.txtGenCustomTitle = new System.Windows.Forms.TextBoxTS();
            this.grpOptMisc = new System.Windows.Forms.GroupBoxTS();
            this.chkWheelTuneVFOB = new System.Windows.Forms.CheckBoxTS();
            this.chkMouseTuneStep = new System.Windows.Forms.CheckBoxTS();
            this.chkZeroBeatRIT = new System.Windows.Forms.CheckBoxTS();
            this.chkSnapClickTune = new System.Windows.Forms.CheckBoxTS();
            this.chkDisableToolTips = new System.Windows.Forms.CheckBoxTS();
            this.chkOptAlwaysOnTop = new System.Windows.Forms.CheckBoxTS();
            this.grpOptQuickQSY = new System.Windows.Forms.GroupBoxTS();
            this.chkOptEnableKBShortcuts = new System.Windows.Forms.CheckBoxTS();
            this.chkOptQuickQSY = new System.Windows.Forms.CheckBoxTS();
            this.grpGenAutoMute = new System.Windows.Forms.GroupBoxTS();
            this.chkGenAutoMute = new System.Windows.Forms.CheckBoxTS();
            this.grpGenTuningOptions = new System.Windows.Forms.GroupBoxTS();
            this.udOptClickTuneOffsetDIGU = new System.Windows.Forms.NumericUpDownTS();
            this.lblOptClickTuneDIGL = new System.Windows.Forms.LabelTS();
            this.udOptClickTuneOffsetDIGL = new System.Windows.Forms.NumericUpDownTS();
            this.lblOptClickTuneDIGU = new System.Windows.Forms.LabelTS();
            this.grpGeneralOptions = new System.Windows.Forms.GroupBoxTS();
            this.udGenTX1Delay = new System.Windows.Forms.NumericUpDownTS();
            this.chkSplitOffOnModeChange = new System.Windows.Forms.CheckBoxTS();
            this.lblGenTX1Delay = new System.Windows.Forms.LabelTS();
            this.chkGenTX1Delay = new System.Windows.Forms.CheckBoxTS();
            this.chkSplitOff = new System.Windows.Forms.CheckBoxTS();
            this.chkGenAllModeMicPTT = new System.Windows.Forms.CheckBoxTS();
            this.chkGeneralCustomFilter = new System.Windows.Forms.CheckBoxTS();
            this.lblGeneralX2Delay = new System.Windows.Forms.LabelTS();
            this.udGeneralX2Delay = new System.Windows.Forms.NumericUpDownTS();
            this.chkGeneralEnableX2 = new System.Windows.Forms.CheckBoxTS();
            this.chkGeneralSoftwareGainCorr = new System.Windows.Forms.CheckBoxTS();
            this.chkGeneralDisablePTT = new System.Windows.Forms.CheckBoxTS();
            this.chkGeneralSpurRed = new System.Windows.Forms.CheckBoxTS();
            this.grpGeneralProcessPriority = new System.Windows.Forms.GroupBoxTS();
            this.comboGeneralProcessPriority = new System.Windows.Forms.ComboBoxTS();
            this.tpGeneralCalibration = new System.Windows.Forms.TabPage();
            this.chkCalExpert = new System.Windows.Forms.CheckBox();
            this.grpGenCalRXImage = new System.Windows.Forms.GroupBoxTS();
            this.udGeneralCalFreq3 = new System.Windows.Forms.NumericUpDownTS();
            this.lblGenCalRXImageFreq = new System.Windows.Forms.LabelTS();
            this.btnGeneralCalImageStart = new System.Windows.Forms.ButtonTS();
            this.grpGenCalLevel = new System.Windows.Forms.GroupBoxTS();
            this.udGeneralCalLevel = new System.Windows.Forms.NumericUpDownTS();
            this.udGeneralCalFreq2 = new System.Windows.Forms.NumericUpDownTS();
            this.lblGenCalLevelFreq = new System.Windows.Forms.LabelTS();
            this.lblGeneralCalLevel = new System.Windows.Forms.LabelTS();
            this.btnGeneralCalLevelStart = new System.Windows.Forms.ButtonTS();
            this.grpGeneralCalibration = new System.Windows.Forms.GroupBoxTS();
            this.btnGeneralCalFreqUseVFOA = new System.Windows.Forms.ButtonTS();
            this.btnGeneralCalFreqStart = new System.Windows.Forms.ButtonTS();
            this.udGeneralCalFreq1 = new System.Windows.Forms.NumericUpDownTS();
            this.lblGeneralCalFrequency = new System.Windows.Forms.LabelTS();
            this.tpFilters = new System.Windows.Forms.TabPage();
            this.grpOptFilterControls = new System.Windows.Forms.GroupBoxTS();
            this.chkOptCWFilterPitch = new System.Windows.Forms.CheckBoxTS();
            this.udFilterDefaultLowCut = new System.Windows.Forms.NumericUpDownTS();
            this.lblDefaultLowCut = new System.Windows.Forms.LabelTS();
            this.udOptMaxFilterShift = new System.Windows.Forms.NumericUpDownTS();
            this.lblOptMaxFilterShift = new System.Windows.Forms.LabelTS();
            this.comboOptFilterWidthMode = new System.Windows.Forms.ComboBoxTS();
            this.lblOptWidthSliderMode = new System.Windows.Forms.LabelTS();
            this.udOptMaxFilterWidth = new System.Windows.Forms.NumericUpDownTS();
            this.lblOptMaxFilter = new System.Windows.Forms.LabelTS();
            this.chkOptFilterSaveChanges = new System.Windows.Forms.CheckBoxTS();
            this.tpRX2 = new System.Windows.Forms.TabPage();
            this.richTextBox2 = new System.Windows.Forms.RichTextBox();
            this.richTextBox1 = new System.Windows.Forms.RichTextBox();
            this.chkRX2AutoVAC2 = new System.Windows.Forms.CheckBoxTS();
            this.chkRX2AutoOn = new System.Windows.Forms.CheckBoxTS();
            this.chkRX2DisconnectOnTX = new System.Windows.Forms.CheckBoxTS();
            this.chkRX2AutoMuteRX1OnVFOBTX = new System.Windows.Forms.CheckBoxTS();
            this.chkRX2AutoMuteRX2OnVFOATX = new System.Windows.Forms.CheckBoxTS();
            this.tpGeneralNavigation = new System.Windows.Forms.TabPage();
            this.grpOptSpaceNav = new System.Windows.Forms.GroupBoxTS();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.chkSpaceNavFlyPanadapter = new System.Windows.Forms.CheckBoxTS();
            this.chkSpaceNavControlVFOs = new System.Windows.Forms.CheckBoxTS();
            this.tpUserInterface = new System.Windows.Forms.TabPage();
            this.chkBoxHERO = new System.Windows.Forms.CheckBoxTS();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.checkBoxRX2 = new System.Windows.Forms.CheckBoxTS();
            this.labelTS39 = new System.Windows.Forms.LabelTS();
            this.udN1MMfps = new System.Windows.Forms.NumericUpDownTS();
            this.labelTS29 = new System.Windows.Forms.LabelTS();
            this.udN1MMscale = new System.Windows.Forms.NumericUpDownTS();
            this.labelTS27 = new System.Windows.Forms.LabelTS();
            this.udN1MMport = new System.Windows.Forms.NumericUpDownTS();
            this.checkBoxN1MM = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxHTTP1 = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxHttp2 = new System.Windows.Forms.CheckBoxTS();
            this.labelTS19 = new System.Windows.Forms.LabelTS();
            this.udHttpRefresh = new System.Windows.Forms.NumericUpDownTS();
            this.txtHttpPass = new System.Windows.Forms.TextBoxTS();
            this.txtHttpUser = new System.Windows.Forms.TextBoxTS();
            this.labelTS18 = new System.Windows.Forms.LabelTS();
            this.labelTS17 = new System.Windows.Forms.LabelTS();
            this.labelTS16 = new System.Windows.Forms.LabelTS();
            this.udHttpPort = new System.Windows.Forms.NumericUpDownTS();
            this.chkBoxHTTP = new System.Windows.Forms.CheckBoxTS();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.labelTS30 = new System.Windows.Forms.LabelTS();
            this.label1 = new System.Windows.Forms.Label();
            this.btnConfigure = new System.Windows.Forms.Button();
            this.cbConsoleSelect = new System.Windows.Forms.ComboBox();
            this.groupBoxTS1 = new System.Windows.Forms.GroupBoxTS();
            this.txtWheelTune9 = new System.Windows.Forms.TextBoxTS();
            this.txtWheelTune8 = new System.Windows.Forms.TextBoxTS();
            this.txtWheelTune7 = new System.Windows.Forms.TextBoxTS();
            this.txtWheelTune6 = new System.Windows.Forms.TextBoxTS();
            this.txtWheelTune5 = new System.Windows.Forms.TextBoxTS();
            this.txtWheelTune4 = new System.Windows.Forms.TextBoxTS();
            this.labelTS35 = new System.Windows.Forms.LabelTS();
            this.labelTS34 = new System.Windows.Forms.LabelTS();
            this.btnTuneStepChangeLarger3 = new System.Windows.Forms.ButtonTS();
            this.btnTuneStepChangeSmaller3 = new System.Windows.Forms.ButtonTS();
            this.txtWheelTune3 = new System.Windows.Forms.TextBoxTS();
            this.chkBoxIND2 = new System.Windows.Forms.CheckBoxTS();
            this.labelTS26 = new System.Windows.Forms.LabelTS();
            this.btnTuneStepChangeLarger2 = new System.Windows.Forms.ButtonTS();
            this.btnTuneStepChangeSmaller2 = new System.Windows.Forms.ButtonTS();
            this.txtWheelTune2 = new System.Windows.Forms.TextBoxTS();
            this.chkBoxIND = new System.Windows.Forms.CheckBoxTS();
            this.labelTS15 = new System.Windows.Forms.LabelTS();
            this.chkBoxPM = new System.Windows.Forms.CheckBoxTS();
            this.udSpeedPM = new System.Windows.Forms.NumericUpDownTS();
            this.tpAudio = new System.Windows.Forms.TabPage();
            this.tcAudio = new System.Windows.Forms.TabControl();
            this.tpAudioCard1 = new System.Windows.Forms.TabPage();
            this.groupBoxTS7 = new System.Windows.Forms.GroupBoxTS();
            this.udIQCorrection = new System.Windows.Forms.NumericUpDownTS();
            this.groupBoxTS8 = new System.Windows.Forms.GroupBoxTS();
            this.udIQCorrection_TX = new System.Windows.Forms.NumericUpDownTS();
            this.chkTXIQswap = new System.Windows.Forms.CheckBoxTS();
            this.chkRXIQswap = new System.Windows.Forms.CheckBoxTS();
            this.chkAudioExpert = new System.Windows.Forms.CheckBoxTS();
            this.grpAudioMicBoost = new System.Windows.Forms.GroupBoxTS();
            this.grpAudioChannels = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioChannels1 = new System.Windows.Forms.ComboBoxTS();
            this.grpAudioMicInGain1 = new System.Windows.Forms.GroupBoxTS();
            this.udAudioMicGain1 = new System.Windows.Forms.NumericUpDownTS();
            this.grpAudioLineInGain1 = new System.Windows.Forms.GroupBoxTS();
            this.udAudioLineIn1 = new System.Windows.Forms.NumericUpDownTS();
            this.grpAudioVolts1 = new System.Windows.Forms.GroupBoxTS();
            this.btnAudioVoltTest1 = new System.Windows.Forms.ButtonTS();
            this.udAudioVoltage1 = new System.Windows.Forms.NumericUpDownTS();
            this.grpAudioDetails1 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioTransmit1 = new System.Windows.Forms.ComboBoxTS();
            this.lblAudioMixer1 = new System.Windows.Forms.LabelTS();
            this.lblAudioOutput1 = new System.Windows.Forms.LabelTS();
            this.comboAudioOutput1 = new System.Windows.Forms.ComboBoxTS();
            this.lblAudioInput1 = new System.Windows.Forms.LabelTS();
            this.lblAudioDriver1 = new System.Windows.Forms.LabelTS();
            this.comboAudioInput1 = new System.Windows.Forms.ComboBoxTS();
            this.comboAudioDriver1 = new System.Windows.Forms.ComboBoxTS();
            this.comboAudioMixer1 = new System.Windows.Forms.ComboBoxTS();
            this.lblAudioTransmit1 = new System.Windows.Forms.LabelTS();
            this.lblAudioReceive1 = new System.Windows.Forms.LabelTS();
            this.comboAudioReceive1 = new System.Windows.Forms.ComboBoxTS();
            this.grpAudioLatency1 = new System.Windows.Forms.GroupBoxTS();
            this.chkAudioLatencyManual1 = new System.Windows.Forms.CheckBoxTS();
            this.udAudioLatency1 = new System.Windows.Forms.NumericUpDownTS();
            this.grpAudioCard = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioSoundCard = new System.Windows.Forms.ComboBoxTS();
            this.grpAudioBufferSize1 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioBuffer1 = new System.Windows.Forms.ComboBoxTS();
            this.grpAudioSampleRate1 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioSampleRate1 = new System.Windows.Forms.ComboBoxTS();
            this.tpVAC = new System.Windows.Forms.TabPage();
            this.radVAC1SelectB = new System.Windows.Forms.RadioButtonTS();
            this.radVAC1SelectA = new System.Windows.Forms.RadioButtonTS();
            this.groupBoxTS6 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioOutput2B = new System.Windows.Forms.ComboBoxTS();
            this.labelTS58 = new System.Windows.Forms.LabelTS();
            this.labelTS59 = new System.Windows.Forms.LabelTS();
            this.labelTS60 = new System.Windows.Forms.LabelTS();
            this.comboAudioInput2B = new System.Windows.Forms.ComboBoxTS();
            this.comboAudioDriver2B = new System.Windows.Forms.ComboBoxTS();
            this.chkVACReset = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxMixAudio = new System.Windows.Forms.CheckBoxTS();
            this.grpDirectIQOutput = new System.Windows.Forms.GroupBoxTS();
            this.chkAudioRX2toVAC = new System.Windows.Forms.CheckBoxTS();
            this.chkAudioCorrectIQ = new System.Windows.Forms.CheckBoxTS();
            this.chkAudioIQtoVAC = new System.Windows.Forms.CheckBoxTS();
            this.chkVACCombine = new System.Windows.Forms.CheckBoxTS();
            this.chkVACAllowBypass = new System.Windows.Forms.CheckBoxTS();
            this.grpAudioVACAutoEnable = new System.Windows.Forms.GroupBoxTS();
            this.chkAudioVACAutoEnable = new System.Windows.Forms.CheckBoxTS();
            this.grpAudioVACGain = new System.Windows.Forms.GroupBoxTS();
            this.lblAudioVACGainTX = new System.Windows.Forms.LabelTS();
            this.udAudioVACGainTX = new System.Windows.Forms.NumericUpDownTS();
            this.lblAudioVACGainRX = new System.Windows.Forms.LabelTS();
            this.udAudioVACGainRX = new System.Windows.Forms.NumericUpDownTS();
            this.grpAudio2Stereo = new System.Windows.Forms.GroupBoxTS();
            this.chkAudio2Stereo = new System.Windows.Forms.CheckBoxTS();
            this.grpAudioLatency2 = new System.Windows.Forms.GroupBoxTS();
            this.chkAudioLatencyManual2 = new System.Windows.Forms.CheckBoxTS();
            this.udAudioLatency2 = new System.Windows.Forms.NumericUpDownTS();
            this.grpAudioSampleRate2 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioSampleRate2 = new System.Windows.Forms.ComboBoxTS();
            this.grpAudioBuffer2 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioBuffer2 = new System.Windows.Forms.ComboBoxTS();
            this.grpAudioDetails2 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioOutput2 = new System.Windows.Forms.ComboBoxTS();
            this.lblAudioOutput2 = new System.Windows.Forms.LabelTS();
            this.lblAudioInput2 = new System.Windows.Forms.LabelTS();
            this.lblAudioDriver2 = new System.Windows.Forms.LabelTS();
            this.comboAudioInput2 = new System.Windows.Forms.ComboBoxTS();
            this.comboAudioDriver2 = new System.Windows.Forms.ComboBoxTS();
            this.chkAudioEnableVAC = new System.Windows.Forms.CheckBoxTS();
            this.tpVAC2 = new System.Windows.Forms.TabPage();
            this.chkVAC2UseRX2 = new System.Windows.Forms.CheckBoxTS();
            this.grpVAC2DirectIQ = new System.Windows.Forms.GroupBoxTS();
            this.chkVAC2DirectIQCal = new System.Windows.Forms.CheckBoxTS();
            this.chkVAC2DirectIQ = new System.Windows.Forms.CheckBoxTS();
            this.chkVAC2Combine = new System.Windows.Forms.CheckBoxTS();
            this.grpVAC2AutoEnable = new System.Windows.Forms.GroupBoxTS();
            this.chkVAC2AutoEnable = new System.Windows.Forms.CheckBoxTS();
            this.grpVAC2Gain = new System.Windows.Forms.GroupBoxTS();
            this.lblVAC2GainTX = new System.Windows.Forms.LabelTS();
            this.udVAC2GainTX = new System.Windows.Forms.NumericUpDownTS();
            this.lblVAC2GainRX = new System.Windows.Forms.LabelTS();
            this.udVAC2GainRX = new System.Windows.Forms.NumericUpDownTS();
            this.grpAudioStereo3 = new System.Windows.Forms.GroupBoxTS();
            this.chkAudioStereo3 = new System.Windows.Forms.CheckBoxTS();
            this.grpVAC2Latency = new System.Windows.Forms.GroupBoxTS();
            this.chkVAC2LatencyManual = new System.Windows.Forms.CheckBoxTS();
            this.udVAC2Latency = new System.Windows.Forms.NumericUpDownTS();
            this.grpAudioSampleRate3 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioSampleRate3 = new System.Windows.Forms.ComboBoxTS();
            this.grpAudioBuffer3 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioBuffer3 = new System.Windows.Forms.ComboBoxTS();
            this.grpAudioDetails3 = new System.Windows.Forms.GroupBoxTS();
            this.comboAudioOutput3 = new System.Windows.Forms.ComboBoxTS();
            this.comboAudioInput3 = new System.Windows.Forms.ComboBoxTS();
            this.lblAudioOutput3 = new System.Windows.Forms.LabelTS();
            this.lblAudioInput3 = new System.Windows.Forms.LabelTS();
            this.lblAudioDriver3 = new System.Windows.Forms.LabelTS();
            this.comboAudioDriver3 = new System.Windows.Forms.ComboBoxTS();
            this.chkVAC2Enable = new System.Windows.Forms.CheckBoxTS();
            this.tpDisplay = new System.Windows.Forms.TabPage();
            this.tbAGCTadj = new System.Windows.Forms.TrackBarTS();
            this.labelTS38 = new System.Windows.Forms.LabelTS();
            this.chkSpectrumHiRes = new System.Windows.Forms.CheckBoxTS();
            this.chkSpectrumPolyphase = new System.Windows.Forms.CheckBoxTS();
            this.check3DPan = new System.Windows.Forms.CheckBoxTS();
            this.chkAvgMove = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxSplitListen = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxDial = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxMRX = new System.Windows.Forms.CheckBoxTS();
            this.labelTS14 = new System.Windows.Forms.LabelTS();
            this.tbWaterOffset = new System.Windows.Forms.TrackBarTS();
            this.labelTS13 = new System.Windows.Forms.LabelTS();
            this.tbGridOffset = new System.Windows.Forms.TrackBarTS();
            this.grpDisplayMultimeter = new System.Windows.Forms.GroupBoxTS();
            this.udSS2H = new System.Windows.Forms.NumericUpDownTS();
            this.udSS1H = new System.Windows.Forms.NumericUpDownTS();
            this.udSS1 = new System.Windows.Forms.NumericUpDownTS();
            this.udSS2 = new System.Windows.Forms.NumericUpDownTS();
            this.chkDisplayMeterShowDecimal = new System.Windows.Forms.CheckBoxTS();
            this.udMeterDigitalDelay = new System.Windows.Forms.NumericUpDownTS();
            this.lblMultimeterDigitalDelay = new System.Windows.Forms.LabelTS();
            this.udDisplayMeterAvg = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayMeterAvg = new System.Windows.Forms.LabelTS();
            this.udDisplayMultiTextHoldTime = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayMeterTextHoldTime = new System.Windows.Forms.LabelTS();
            this.udDisplayMultiPeakHoldTime = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayMultiPeakHoldTime = new System.Windows.Forms.LabelTS();
            this.udDisplayMeterDelay = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayMeterDelay = new System.Windows.Forms.LabelTS();
            this.grpDisplayDriverEngine = new System.Windows.Forms.GroupBoxTS();
            this.comboDisplayDriver = new System.Windows.Forms.ComboBoxTS();
            this.grpDisplayScopeMode = new System.Windows.Forms.GroupBoxTS();
            this.checkBoxScopeAC = new System.Windows.Forms.CheckBoxTS();
            this.udDisplayScopeTime = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayScopeTime = new System.Windows.Forms.LabelTS();
            this.grpDisplayWaterfall = new System.Windows.Forms.GroupBoxTS();
            this.checkWaterMoveSize = new System.Windows.Forms.CheckBoxTS();
            this.labelTS6 = new System.Windows.Forms.LabelTS();
            this.udDisplayWaterfallMicLevel = new System.Windows.Forms.NumericUpDownTS();
            this.udDisplayWaterfallRX2Level = new System.Windows.Forms.NumericUpDownTS();
            this.labelTS5 = new System.Windows.Forms.LabelTS();
            this.chkWeakSignalWaterfallSettings = new System.Windows.Forms.CheckBoxTS();
            this.lblWaterfallLevels = new System.Windows.Forms.Label();
            this.txtWaterFallBandLevel = new System.Windows.Forms.TextBox();
            this.udDisplayWaterfallUpdatePeriod = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayWaterfallUpdatePeriod = new System.Windows.Forms.LabelTS();
            this.udDisplayWaterfallAvgTime = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayWaterfallAverageTime = new System.Windows.Forms.LabelTS();
            this.clrbtnWaterfallLow = new PowerSDR.ColorButton();
            this.lblDisplayWaterfallLowColor = new System.Windows.Forms.LabelTS();
            this.lblDisplayWaterfallLowLevel = new System.Windows.Forms.LabelTS();
            this.udDisplayWaterfallLowLevel = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayWaterfallHighLevel = new System.Windows.Forms.LabelTS();
            this.udDisplayWaterfallHighLevel = new System.Windows.Forms.NumericUpDownTS();
            this.grpDisplayRefreshRates = new System.Windows.Forms.GroupBoxTS();
            this.gridBoxTS = new System.Windows.Forms.CheckBoxTS();
            this.chkDisplayPanFill = new System.Windows.Forms.CheckBoxTS();
            this.udDisplayCPUMeter = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayCPUMeter = new System.Windows.Forms.LabelTS();
            this.udDisplayPeakText = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayPeakText = new System.Windows.Forms.LabelTS();
            this.udDisplayFPS = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayFPS = new System.Windows.Forms.LabelTS();
            this.grpDisplayAverage = new System.Windows.Forms.GroupBoxTS();
            this.udDisplayAVGTime = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayAVGTime = new System.Windows.Forms.LabelTS();
            this.grpDisplayPhase = new System.Windows.Forms.GroupBoxTS();
            this.lblDisplayPhasePts = new System.Windows.Forms.LabelTS();
            this.udDisplayPhasePts = new System.Windows.Forms.NumericUpDownTS();
            this.grpDisplaySpectrumGrid = new System.Windows.Forms.GroupBoxTS();
            this.comboDisplayLabelAlign = new System.Windows.Forms.ComboBoxTS();
            this.lblDisplayAlign = new System.Windows.Forms.LabelTS();
            this.udDisplayGridStep = new System.Windows.Forms.NumericUpDownTS();
            this.udDisplayGridMin = new System.Windows.Forms.NumericUpDownTS();
            this.udDisplayGridMax = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayGridStep = new System.Windows.Forms.LabelTS();
            this.lblDisplayGridMin = new System.Windows.Forms.LabelTS();
            this.lblDisplayGridMax = new System.Windows.Forms.LabelTS();
            this.chkBoxAutoWtrPan = new System.Windows.Forms.CheckBoxTS();
            this.tpDSP = new System.Windows.Forms.TabPage();
            this.tcDSP = new System.Windows.Forms.TabControl();
            this.tpDSPOptions = new System.Windows.Forms.TabPage();
            this.chkDSPRX2 = new System.Windows.Forms.CheckBoxTS();
            this.labelTS28 = new System.Windows.Forms.LabelTS();
            this.btnRSTNB2 = new System.Windows.Forms.ButtonTS();
            this.btnRSTNB = new System.Windows.Forms.ButtonTS();
            this.btnRSTANF = new System.Windows.Forms.ButtonTS();
            this.btnRSTNR = new System.Windows.Forms.ButtonTS();
            this.labelTS7 = new System.Windows.Forms.LabelTS();
            this.udTNFWidth = new System.Windows.Forms.NumericUpDownTS();
            this.chkDSPTXMeterPeak = new System.Windows.Forms.CheckBoxTS();
            this.grpDSPBufferSize = new System.Windows.Forms.GroupBoxTS();
            this.grpDSPBufDig = new System.Windows.Forms.GroupBoxTS();
            this.comboDSPDigTXBuf = new System.Windows.Forms.ComboBoxTS();
            this.lblDSPDigBufferRX = new System.Windows.Forms.LabelTS();
            this.comboDSPDigRXBuf = new System.Windows.Forms.ComboBoxTS();
            this.lblDSPDigBufferTX = new System.Windows.Forms.LabelTS();
            this.grpDSPBufCW = new System.Windows.Forms.GroupBoxTS();
            this.comboDSPCWTXBuf = new System.Windows.Forms.ComboBoxTS();
            this.lblDSPCWBufferRX = new System.Windows.Forms.LabelTS();
            this.comboDSPCWRXBuf = new System.Windows.Forms.ComboBoxTS();
            this.grpDSPBufPhone = new System.Windows.Forms.GroupBoxTS();
            this.comboDSPPhoneTXBuf = new System.Windows.Forms.ComboBoxTS();
            this.lblDSPPhoneBufferRX = new System.Windows.Forms.LabelTS();
            this.comboDSPPhoneRXBuf = new System.Windows.Forms.ComboBoxTS();
            this.lblDSPPhoneBufferTX = new System.Windows.Forms.LabelTS();
            this.grpDSPNB = new System.Windows.Forms.GroupBoxTS();
            this.udDSPHT = new System.Windows.Forms.ComboBoxTS();
            this.udDSPDLY = new System.Windows.Forms.NumericUpDownTS();
            this.labelTS55 = new System.Windows.Forms.LabelTS();
            this.labelTS54 = new System.Windows.Forms.LabelTS();
            this.udDSPNB = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPNBThreshold = new System.Windows.Forms.LabelTS();
            this.grpDSPLMSNR = new System.Windows.Forms.GroupBoxTS();
            this.udLMSNRLeak = new System.Windows.Forms.NumericUpDownTS();
            this.lblLMSNRLeak = new System.Windows.Forms.LabelTS();
            this.lblLMSNRgain = new System.Windows.Forms.LabelTS();
            this.udLMSNRgain = new System.Windows.Forms.NumericUpDownTS();
            this.lblLMSNRdelay = new System.Windows.Forms.LabelTS();
            this.udLMSNRtaps = new System.Windows.Forms.NumericUpDownTS();
            this.udLMSNRdelay = new System.Windows.Forms.NumericUpDownTS();
            this.lblLMSNRtaps = new System.Windows.Forms.LabelTS();
            this.grpDSPLMSANF = new System.Windows.Forms.GroupBoxTS();
            this.udLMSANFLeak = new System.Windows.Forms.NumericUpDownTS();
            this.lblLMSANFLeak = new System.Windows.Forms.LabelTS();
            this.lblLMSANFgain = new System.Windows.Forms.LabelTS();
            this.udLMSANFgain = new System.Windows.Forms.NumericUpDownTS();
            this.lblLMSANFdelay = new System.Windows.Forms.LabelTS();
            this.udLMSANFdelay = new System.Windows.Forms.NumericUpDownTS();
            this.lblLMSANFTaps = new System.Windows.Forms.LabelTS();
            this.udLMSANFtaps = new System.Windows.Forms.NumericUpDownTS();
            this.grpDSPWindow = new System.Windows.Forms.GroupBoxTS();
            this.comboDSPWindow = new System.Windows.Forms.ComboBoxTS();
            this.grpDSPNB2 = new System.Windows.Forms.GroupBoxTS();
            this.udDSPNB2 = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPNB2Threshold = new System.Windows.Forms.LabelTS();
            this.tpDSPImageReject = new System.Windows.Forms.TabPage();
            this.chkDSPImageExpert = new System.Windows.Forms.CheckBox();
            this.grpDSPImageRejectTX = new System.Windows.Forms.GroupBoxTS();
            this.checkboxTXImagCal = new System.Windows.Forms.CheckBoxTS();
            this.lblDSPGainValTX = new System.Windows.Forms.LabelTS();
            this.lblDSPPhaseValTX = new System.Windows.Forms.LabelTS();
            this.udDSPImageGainTX = new System.Windows.Forms.NumericUpDownTS();
            this.udDSPImagePhaseTX = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPImageGainTX = new System.Windows.Forms.LabelTS();
            this.tbDSPImagePhaseTX = new System.Windows.Forms.TrackBarTS();
            this.lblDSPImagePhaseTX = new System.Windows.Forms.LabelTS();
            this.tbDSPImageGainTX = new System.Windows.Forms.TrackBarTS();
            this.tpDSPKeyer = new System.Windows.Forms.TabPage();
            this.labelTS25 = new System.Windows.Forms.LabelTS();
            this.chkKeyPoll = new System.Windows.Forms.CheckBoxTS();
            this.chkCWDisableUI = new System.Windows.Forms.CheckBoxTS();
            this.grpKeyerConnections = new System.Windows.Forms.GroupBoxTS();
            this.comboKeyerConnKeyLine = new System.Windows.Forms.ComboBoxTS();
            this.comboKeyerConnSecondary = new System.Windows.Forms.ComboBoxTS();
            this.lblKeyerConnSecondary = new System.Windows.Forms.LabelTS();
            this.lblKeyerConnKeyLine = new System.Windows.Forms.LabelTS();
            this.comboKeyerConnPTTLine = new System.Windows.Forms.ComboBoxTS();
            this.lblKeyerConnPrimary = new System.Windows.Forms.LabelTS();
            this.lblKeyerConnPTTLine = new System.Windows.Forms.LabelTS();
            this.comboKeyerConnPrimary = new System.Windows.Forms.ComboBoxTS();
            this.grpDSPCWPitch = new System.Windows.Forms.GroupBoxTS();
            this.lblDSPCWPitchFreq = new System.Windows.Forms.LabelTS();
            this.udDSPCWPitch = new System.Windows.Forms.NumericUpDownTS();
            this.grpDSPKeyerOptions = new System.Windows.Forms.GroupBoxTS();
            this.chkCWDisplay = new System.Windows.Forms.CheckBoxTS();
            this.chkModeBStrict = new System.Windows.Forms.CheckBoxTS();
            this.chkStrictCharSpacing = new System.Windows.Forms.CheckBoxTS();
            this.chkCWKeyerMonoCable = new System.Windows.Forms.CheckBoxTS();
            this.chkCWKeyerMode = new System.Windows.Forms.CheckBoxTS();
            this.chkCWKeyerRevPdl = new System.Windows.Forms.CheckBoxTS();
            this.chkDSPKeyerSidetone = new System.Windows.Forms.CheckBoxTS();
            this.chkCWKeyerIambic = new System.Windows.Forms.CheckBoxTS();
            this.chkCWAutoSwitchMode = new System.Windows.Forms.CheckBoxTS();
            this.grpDSPKeyerSignalShaping = new System.Windows.Forms.GroupBoxTS();
            this.udCWKeyerWeight = new System.Windows.Forms.NumericUpDownTS();
            this.lblCWWeight = new System.Windows.Forms.LabelTS();
            this.udCWKeyerRamp = new System.Windows.Forms.NumericUpDownTS();
            this.lblCWRamp = new System.Windows.Forms.LabelTS();
            this.grpDSPKeyerSemiBreakIn = new System.Windows.Forms.GroupBoxTS();
            this.chkCWBreakInEnabled = new System.Windows.Forms.CheckBoxTS();
            this.lblCWBreakInDelay = new System.Windows.Forms.LabelTS();
            this.udCWBreakInDelay = new System.Windows.Forms.NumericUpDownTS();
            this.tpDSPAGCALC = new System.Windows.Forms.TabPage();
            this.grpDSPLeveler = new System.Windows.Forms.GroupBoxTS();
            this.chkDSPLevelerEnabled = new System.Windows.Forms.CheckBoxTS();
            this.lblDSPLevelerHangThreshold = new System.Windows.Forms.LabelTS();
            this.udDSPLevelerHangTime = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPLevelerHangTime = new System.Windows.Forms.LabelTS();
            this.udDSPLevelerThreshold = new System.Windows.Forms.NumericUpDownTS();
            this.udDSPLevelerSlope = new System.Windows.Forms.NumericUpDownTS();
            this.udDSPLevelerDecay = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPLevelerSlope = new System.Windows.Forms.LabelTS();
            this.udDSPLevelerAttack = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPLevelerDecay = new System.Windows.Forms.LabelTS();
            this.lblDSPLevelerAttack = new System.Windows.Forms.LabelTS();
            this.lblDSPLevelerThreshold = new System.Windows.Forms.LabelTS();
            this.tbDSPLevelerHangThreshold = new System.Windows.Forms.TrackBarTS();
            this.grpDSPALC = new System.Windows.Forms.GroupBoxTS();
            this.lblDSPALCHangThreshold = new System.Windows.Forms.LabelTS();
            this.tbDSPALCHangThreshold = new System.Windows.Forms.TrackBarTS();
            this.udDSPALCHangTime = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPALCHangTime = new System.Windows.Forms.LabelTS();
            this.udDSPALCThreshold = new System.Windows.Forms.NumericUpDownTS();
            this.udDSPALCSlope = new System.Windows.Forms.NumericUpDownTS();
            this.udDSPALCDecay = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPALCSlope = new System.Windows.Forms.LabelTS();
            this.udDSPALCAttack = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPALCDecay = new System.Windows.Forms.LabelTS();
            this.lblDSPALCAttack = new System.Windows.Forms.LabelTS();
            this.lblDSPALCThreshold = new System.Windows.Forms.LabelTS();
            this.grpDSPAGC = new System.Windows.Forms.GroupBoxTS();
            this.tbDSPAGCHangThreshold = new System.Windows.Forms.TrackBarTS();
            this.lblDSPAGCHangThreshold = new System.Windows.Forms.LabelTS();
            this.lblDSPAGCHangTime = new System.Windows.Forms.LabelTS();
            this.udDSPAGCHangTime = new System.Windows.Forms.NumericUpDownTS();
            this.udDSPAGCMaxGaindB = new System.Windows.Forms.NumericUpDownTS();
            this.udDSPAGCSlope = new System.Windows.Forms.NumericUpDownTS();
            this.udDSPAGCDecay = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPAGCSlope = new System.Windows.Forms.LabelTS();
            this.udDSPAGCAttack = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPAGCDecay = new System.Windows.Forms.LabelTS();
            this.lblDSPAGCAttack = new System.Windows.Forms.LabelTS();
            this.lblDSPAGCMaxGain = new System.Windows.Forms.LabelTS();
            this.udDSPAGCFixedGaindB = new System.Windows.Forms.NumericUpDownTS();
            this.lblDSPAGCFixed = new System.Windows.Forms.LabelTS();
            this.tpTransmit = new System.Windows.Forms.TabPage();
            this.chkBandModeSave = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxTNTX3 = new System.Windows.Forms.CheckBoxTS();
            this.chkPhaseRotate = new System.Windows.Forms.CheckBoxTS();
            this.chkFMDataMic = new System.Windows.Forms.CheckBoxTS();
            this.grpTXVOX = new System.Windows.Forms.GroupBoxTS();
            this.lblTXVOXHangTime = new System.Windows.Forms.LabelTS();
            this.udTXVOXHangTime = new System.Windows.Forms.NumericUpDownTS();
            this.chkTXVOXEnabled = new System.Windows.Forms.CheckBoxTS();
            this.lblTXVOXThreshold = new System.Windows.Forms.LabelTS();
            this.udTXVOXThreshold = new System.Windows.Forms.NumericUpDownTS();
            this.chk2ndMeter = new System.Windows.Forms.CheckBoxTS();
            this.chkTXWtrID = new System.Windows.Forms.CheckBoxTS();
            this.chkTXMeter2 = new System.Windows.Forms.CheckBoxTS();
            this.chkRememberTXProfileOnModeChange = new System.Windows.Forms.CheckBoxTS();
            this.chkAudioMicBoost = new System.Windows.Forms.CheckBoxTS();
            this.chkSaveTXProfileOnExit = new System.Windows.Forms.CheckBoxTS();
            this.chkAutoSaveTXProfile = new System.Windows.Forms.CheckBoxTS();
            this.chkTXLimitSlew = new System.Windows.Forms.CheckBoxTS();
            this.chkTXExpert = new System.Windows.Forms.CheckBoxTS();
            this.grpTXProfileDef = new System.Windows.Forms.GroupBoxTS();
            this.btnTXProfileDefImport = new System.Windows.Forms.ButtonTS();
            this.lstTXProfileDef = new System.Windows.Forms.ListBox();
            this.grpTXAM = new System.Windows.Forms.GroupBoxTS();
            this.lblTXAMCarrierLevel = new System.Windows.Forms.LabelTS();
            this.udTXAMCarrierLevel = new System.Windows.Forms.NumericUpDownTS();
            this.grpTXMonitor = new System.Windows.Forms.GroupBoxTS();
            this.lblTXAF = new System.Windows.Forms.LabelTS();
            this.udTXAF = new System.Windows.Forms.NumericUpDownTS();
            this.grpTXNoiseGate = new System.Windows.Forms.GroupBoxTS();
            this.udTXNoiseGateAttenuate = new System.Windows.Forms.NumericUpDownTS();
            this.lblTXNoiseGateAttenuate = new System.Windows.Forms.LabelTS();
            this.chkTXNoiseGateEnabled = new System.Windows.Forms.CheckBoxTS();
            this.udTXNoiseGate = new System.Windows.Forms.NumericUpDownTS();
            this.lblTXNoiseGateThreshold = new System.Windows.Forms.LabelTS();
            this.grpTXProfile = new System.Windows.Forms.GroupBoxTS();
            this.btnTXProfileDelete = new System.Windows.Forms.ButtonTS();
            this.btnTXProfileSave = new System.Windows.Forms.ButtonTS();
            this.comboTXProfileName = new System.Windows.Forms.ComboBoxTS();
            this.grpPATune = new System.Windows.Forms.GroupBoxTS();
            this.labelTS22 = new System.Windows.Forms.LabelTS();
            this.labelTS21 = new System.Windows.Forms.LabelTS();
            this.tbPulseRate1 = new System.Windows.Forms.TrackBarTS();
            this.tbDutyCycle = new System.Windows.Forms.TrackBarTS();
            this.chkBoxPulser = new System.Windows.Forms.CheckBoxTS();
            this.comboTXTUNMeter = new System.Windows.Forms.ComboBoxTS();
            this.lblTXTUNMeter = new System.Windows.Forms.LabelTS();
            this.lblTransmitTunePower = new System.Windows.Forms.LabelTS();
            this.udTXTunePower = new System.Windows.Forms.NumericUpDownTS();
            this.grpTXFilter = new System.Windows.Forms.GroupBoxTS();
            this.labelTS33 = new System.Windows.Forms.LabelTS();
            this.udTXDriveMax = new System.Windows.Forms.NumericUpDownTS();
            this.lblTXFilterHigh = new System.Windows.Forms.LabelTS();
            this.udTXFilterLow = new System.Windows.Forms.NumericUpDownTS();
            this.lblTXFilterLow = new System.Windows.Forms.LabelTS();
            this.udTXFilterHigh = new System.Windows.Forms.NumericUpDownTS();
            this.chkDCBlock = new System.Windows.Forms.CheckBoxTS();
            this.grpTX1500 = new System.Windows.Forms.GroupBoxTS();
            this.lblTX1500Blanking = new System.Windows.Forms.LabelTS();
            this.udTX1500PhoneBlanking = new System.Windows.Forms.NumericUpDownTS();
            this.tpPowerAmplifier = new System.Windows.Forms.TabPage();
            this.rtxtPACalReq = new System.Windows.Forms.RichTextBox();
            this.grpPABandOffset = new System.Windows.Forms.GroupBoxTS();
            this.lblPABandOffset10 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset12 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset15 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset17 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset20 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset30 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset40 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset60 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset80 = new System.Windows.Forms.LabelTS();
            this.lblPABandOffset160 = new System.Windows.Forms.LabelTS();
            this.udPAADC17 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC15 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC20 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC12 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC10 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC160 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC80 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC60 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC40 = new System.Windows.Forms.NumericUpDownTS();
            this.udPAADC30 = new System.Windows.Forms.NumericUpDownTS();
            this.chkPANewCal = new System.Windows.Forms.CheckBoxTS();
            this.grpPAGainByBand = new System.Windows.Forms.GroupBoxTS();
            this.udPACalPower = new System.Windows.Forms.NumericUpDownTS();
            this.lblPACalTarget = new System.Windows.Forms.LabelTS();
            this.chkPA10 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA12 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA15 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA17 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA20 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA30 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA40 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA60 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA80 = new System.Windows.Forms.CheckBoxTS();
            this.chkPA160 = new System.Windows.Forms.CheckBoxTS();
            this.radPACalSelBands = new System.Windows.Forms.RadioButtonTS();
            this.radPACalAllBands = new System.Windows.Forms.RadioButtonTS();
            this.btnPAGainReset = new System.Windows.Forms.ButtonTS();
            this.btnPAGainCalibration = new System.Windows.Forms.ButtonTS();
            this.lblPAGainByBand10 = new System.Windows.Forms.LabelTS();
            this.udPAGain10 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand12 = new System.Windows.Forms.LabelTS();
            this.udPAGain12 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand15 = new System.Windows.Forms.LabelTS();
            this.udPAGain15 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand17 = new System.Windows.Forms.LabelTS();
            this.udPAGain17 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand20 = new System.Windows.Forms.LabelTS();
            this.udPAGain20 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand30 = new System.Windows.Forms.LabelTS();
            this.udPAGain30 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand40 = new System.Windows.Forms.LabelTS();
            this.udPAGain40 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand60 = new System.Windows.Forms.LabelTS();
            this.udPAGain60 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand80 = new System.Windows.Forms.LabelTS();
            this.udPAGain80 = new System.Windows.Forms.NumericUpDownTS();
            this.lblPAGainByBand160 = new System.Windows.Forms.LabelTS();
            this.udPAGain160 = new System.Windows.Forms.NumericUpDownTS();
            this.chkPA6 = new System.Windows.Forms.CheckBoxTS();
            this.tpAppearance = new System.Windows.Forms.TabPage();
            this.tcAppearance = new System.Windows.Forms.TabControl();
            this.tpAppearanceGeneral = new System.Windows.Forms.TabPage();
            this.labelTS46 = new System.Windows.Forms.LabelTS();
            this.labelTS45 = new System.Windows.Forms.LabelTS();
            this.number3DY = new System.Windows.Forms.NumericUpDownTS();
            this.number3DX = new System.Windows.Forms.NumericUpDownTS();
            this.groupBoxTS3 = new System.Windows.Forms.GroupBoxTS();
            this.chkBoxConsoleRing = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxTitle = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxMax = new System.Windows.Forms.CheckBoxTS();
            this.btnSkinExport = new System.Windows.Forms.ButtonTS();
            this.grpAppSkins = new System.Windows.Forms.GroupBoxTS();
            this.comboAppSkin = new System.Windows.Forms.ComboBoxTS();
            this.lblGenBackground = new System.Windows.Forms.LabelTS();
            this.clrbtnGenBackground = new PowerSDR.ColorButton();
            this.grpAppearanceBand = new System.Windows.Forms.GroupBoxTS();
            this.clrbtnBandBackground = new PowerSDR.ColorButton();
            this.lblBandBackground = new System.Windows.Forms.LabelTS();
            this.clrbtnBandLight = new PowerSDR.ColorButton();
            this.clrbtnBandDark = new PowerSDR.ColorButton();
            this.lblBandLight = new System.Windows.Forms.LabelTS();
            this.lblBandDark = new System.Windows.Forms.LabelTS();
            this.clrbtnOutOfBand = new PowerSDR.ColorButton();
            this.lblOutOfBand = new System.Windows.Forms.LabelTS();
            this.grpAppearanceVFO = new System.Windows.Forms.GroupBoxTS();
            this.chkVFOLargeWindow = new System.Windows.Forms.CheckBoxTS();
            this.chkVFOOpenFont = new System.Windows.Forms.CheckBoxTS();
            this.chkVFOBoldFont = new System.Windows.Forms.CheckBoxTS();
            this.labelTS24 = new System.Windows.Forms.LabelTS();
            this.clrbtnVFORing = new PowerSDR.ColorButton();
            this.clrbtnVFOBackground = new PowerSDR.ColorButton();
            this.lblVFOBackground = new System.Windows.Forms.LabelTS();
            this.clrbtnVFOSmallColor = new PowerSDR.ColorButton();
            this.lblVFOSmallColor = new System.Windows.Forms.LabelTS();
            this.chkVFOSmallLSD = new System.Windows.Forms.CheckBoxTS();
            this.clrbtnVFOLight = new PowerSDR.ColorButton();
            this.clrbtnVFODark = new PowerSDR.ColorButton();
            this.lblVFOPowerOn = new System.Windows.Forms.LabelTS();
            this.lblVFOPowerOff = new System.Windows.Forms.LabelTS();
            this.clrbtnBtnSel = new PowerSDR.ColorButton();
            this.lblAppearanceGenBtnSel = new System.Windows.Forms.LabelTS();
            this.tpAppearanceDisplay = new System.Windows.Forms.TabPage();
            this.grpMainDisplay = new System.Windows.Forms.GroupBoxTS();
            this.tbPan3DAlpha = new System.Windows.Forms.TrackBarTS();
            this.labelTS41 = new System.Windows.Forms.LabelTS();
            this.labelTS40 = new System.Windows.Forms.LabelTS();
            this.clrbtn3DDataLine = new PowerSDR.ColorButton();
            this.labelTS32 = new System.Windows.Forms.LabelTS();
            this.tbPanGrid = new System.Windows.Forms.TrackBarTS();
            this.clrbtnText = new PowerSDR.ColorButton();
            this.lblDisplayBackgroundColor = new System.Windows.Forms.LabelTS();
            this.udDisplayLineWidth = new System.Windows.Forms.NumericUpDownTS();
            this.lblDisplayDataLineColor = new System.Windows.Forms.LabelTS();
            this.lblDisplayTextColor = new System.Windows.Forms.LabelTS();
            this.lblDisplayLineWidth = new System.Windows.Forms.LabelTS();
            this.clrbtnBackground = new PowerSDR.ColorButton();
            this.clrbtnGrid = new PowerSDR.ColorButton();
            this.lblDisplayZeroLineColor = new System.Windows.Forms.LabelTS();
            this.clrbtnZeroLine = new PowerSDR.ColorButton();
            this.lblDisplayGridColor = new System.Windows.Forms.LabelTS();
            this.clrbtnDataLine = new PowerSDR.ColorButton();
            this.grpAppPanadapter = new System.Windows.Forms.GroupBoxTS();
            this.labelTS9 = new System.Windows.Forms.LabelTS();
            this.chkBoxChannels = new System.Windows.Forms.CheckBoxTS();
            this.labelTS37 = new System.Windows.Forms.LabelTS();
            this.tbMapBright = new System.Windows.Forms.TrackBarTS();
            this.chkBoxPanFillColor = new System.Windows.Forms.CheckBoxTS();
            this.labelTS11 = new System.Windows.Forms.LabelTS();
            this.labelTS10 = new System.Windows.Forms.LabelTS();
            this.tbPanAlpha = new System.Windows.Forms.TrackBarTS();
            this.clrbtnPan = new PowerSDR.ColorButton();
            this.tbGrayLineBright = new System.Windows.Forms.TrackBarTS();
            this.lblBandSegmentBoxLineWidth = new System.Windows.Forms.LabelTS();
            this.udBandSegmentBoxLineWidth = new System.Windows.Forms.NumericUpDownTS();
            this.lblBandSegmentBox = new System.Windows.Forms.LabelTS();
            this.clrbtnBandSegmentBox = new PowerSDR.ColorButton();
            this.lblMultiRXFilterAlpha = new System.Windows.Forms.LabelTS();
            this.chkShowFreqOffset = new System.Windows.Forms.CheckBoxTS();
            this.tbMultiRXFilterAlpha = new System.Windows.Forms.TrackBarTS();
            this.clrbtnTXFilter = new PowerSDR.ColorButton();
            this.lblRX1FilterAlpha = new System.Windows.Forms.LabelTS();
            this.lblTXFilterColor = new System.Windows.Forms.LabelTS();
            this.clrbtnSubRXZero = new PowerSDR.ColorButton();
            this.tbRX1FilterAlpha = new System.Windows.Forms.TrackBarTS();
            this.lblSubRXZeroLine = new System.Windows.Forms.LabelTS();
            this.clrbtnSubRXFilter = new PowerSDR.ColorButton();
            this.lblSubRXFilterColor = new System.Windows.Forms.LabelTS();
            this.clrbtnBandEdge = new PowerSDR.ColorButton();
            this.lblBandEdge = new System.Windows.Forms.LabelTS();
            this.lblDisplayFilterColor = new System.Windows.Forms.LabelTS();
            this.clrbtnFilter = new PowerSDR.ColorButton();
            this.labelTS36 = new System.Windows.Forms.LabelTS();
            this.labelTS8 = new System.Windows.Forms.LabelTS();
            this.grpDisplayPeakCursor = new System.Windows.Forms.GroupBoxTS();
            this.clrbtnPeakBackground = new PowerSDR.ColorButton();
            this.lblPeakBackground = new System.Windows.Forms.LabelTS();
            this.clrbtnPeakText = new PowerSDR.ColorButton();
            this.lblPeakText = new System.Windows.Forms.LabelTS();
            this.tpAppearanceMeter = new System.Windows.Forms.TabPage();
            this.chkDock = new System.Windows.Forms.CheckBoxTS();
            this.labelTS2 = new System.Windows.Forms.LabelTS();
            this.clrbtnMeterDigBackground = new PowerSDR.ColorButton();
            this.clrbtnMeterRight = new PowerSDR.ColorButton();
            this.lblMeterDigitalText = new System.Windows.Forms.LabelTS();
            this.clrbtnMeterDigText = new PowerSDR.ColorButton();
            this.grpMeterEdge = new System.Windows.Forms.GroupBoxTS();
            this.clrbtnEdgeIndicator = new PowerSDR.ColorButton();
            this.labelTS1 = new System.Windows.Forms.LabelTS();
            this.clrbtnMeterEdgeBackground = new PowerSDR.ColorButton();
            this.lblMeterEdgeBackground = new System.Windows.Forms.LabelTS();
            this.clrbtnMeterEdgeHigh = new PowerSDR.ColorButton();
            this.lblMeterEdgeHigh = new System.Windows.Forms.LabelTS();
            this.lblMeterEdgeLow = new System.Windows.Forms.LabelTS();
            this.clrbtnMeterEdgeLow = new PowerSDR.ColorButton();
            this.clrbtnMeterLeft = new PowerSDR.ColorButton();
            this.grpAppearanceMeter = new System.Windows.Forms.GroupBoxTS();
            this.chkBoxMeterMenus = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxMeterTop = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxPointer = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxDMB = new System.Windows.Forms.CheckBoxTS();
            this.chkBoxLMB = new System.Windows.Forms.CheckBoxTS();
            this.clrbtnMeterHigh = new PowerSDR.ColorButton();
            this.clrbtnMeterIndicator = new PowerSDR.ColorButton();
            this.clrbtnMeterLow = new PowerSDR.ColorButton();
            this.labelTS12 = new System.Windows.Forms.LabelTS();
            this.clrbtnMeterBackground = new PowerSDR.ColorButton();
            this.lblMeterBackground = new System.Windows.Forms.LabelTS();
            this.lblAppearanceMeterRight = new System.Windows.Forms.LabelTS();
            this.lblAppearanceMeterLeft = new System.Windows.Forms.LabelTS();
            this.lblMeterType = new System.Windows.Forms.LabelTS();
            this.comboMeterType = new System.Windows.Forms.ComboBoxTS();
            this.tpKeyboard = new System.Windows.Forms.TabPage();
            this.groupBoxTS5 = new System.Windows.Forms.GroupBoxTS();
            this.labelTS56 = new System.Windows.Forms.LabelTS();
            this.udQuindarTonesVol = new System.Windows.Forms.NumericUpDownTS();
            this.checkQuindarToneON = new System.Windows.Forms.CheckBoxTS();
            this.chkQuindarEnd = new System.Windows.Forms.CheckBoxTS();
            this.chkQuindarStart = new System.Windows.Forms.CheckBoxTS();
            this.groupBoxTS2 = new System.Windows.Forms.GroupBoxTS();
            this.checkBoxDTMF11 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF10 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF0 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF9 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF8 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF7 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF6 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF5 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF4 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF3 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF2 = new System.Windows.Forms.CheckBoxTS();
            this.checkBoxDTMF1 = new System.Windows.Forms.CheckBoxTS();
            this.grpKBXIT = new System.Windows.Forms.GroupBoxTS();
            this.lblKBXITUp = new System.Windows.Forms.LabelTS();
            this.lblKBXITDown = new System.Windows.Forms.LabelTS();
            this.comboKBXITUp = new System.Windows.Forms.ComboBoxTS();
            this.comboKBXITDown = new System.Windows.Forms.ComboBoxTS();
            this.grpKBRIT = new System.Windows.Forms.GroupBoxTS();
            this.lblKBRitUp = new System.Windows.Forms.LabelTS();
            this.lblKBRITDown = new System.Windows.Forms.LabelTS();
            this.comboKBRITUp = new System.Windows.Forms.ComboBoxTS();
            this.comboKBRITDown = new System.Windows.Forms.ComboBoxTS();
            this.grpKBMode = new System.Windows.Forms.GroupBoxTS();
            this.lblKBModeUp = new System.Windows.Forms.LabelTS();
            this.lblKBModeDown = new System.Windows.Forms.LabelTS();
            this.comboKBModeUp = new System.Windows.Forms.ComboBoxTS();
            this.comboKBModeDown = new System.Windows.Forms.ComboBoxTS();
            this.grpKBBand = new System.Windows.Forms.GroupBoxTS();
            this.lblKBBandUp = new System.Windows.Forms.LabelTS();
            this.lblKBBandDown = new System.Windows.Forms.LabelTS();
            this.comboKBBandUp = new System.Windows.Forms.ComboBoxTS();
            this.comboKBBandDown = new System.Windows.Forms.ComboBoxTS();
            this.grpKBTune = new System.Windows.Forms.GroupBoxTS();
            this.lblKBTuneDigit = new System.Windows.Forms.LabelTS();
            this.lblKBTune7 = new System.Windows.Forms.LabelTS();
            this.lblKBTune6 = new System.Windows.Forms.LabelTS();
            this.lblKBTune5 = new System.Windows.Forms.LabelTS();
            this.lblKBTune4 = new System.Windows.Forms.LabelTS();
            this.lblKBTune3 = new System.Windows.Forms.LabelTS();
            this.lblKBTune2 = new System.Windows.Forms.LabelTS();
            this.comboKBTuneUp7 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneDown7 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneUp6 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneDown6 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneUp5 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneDown5 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneUp4 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneDown4 = new System.Windows.Forms.ComboBoxTS();
            this.lblKBTune1 = new System.Windows.Forms.LabelTS();
            this.lblKBTuneUp = new System.Windows.Forms.LabelTS();
            this.lblKBTuneDown = new System.Windows.Forms.LabelTS();
            this.comboKBTuneUp3 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneDown3 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneUp1 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneUp2 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneDown1 = new System.Windows.Forms.ComboBoxTS();
            this.comboKBTuneDown2 = new System.Windows.Forms.ComboBoxTS();
            this.grpKBFilter = new System.Windows.Forms.GroupBoxTS();
            this.lblKBFilterUp = new System.Windows.Forms.LabelTS();
            this.lblKBFilterDown = new System.Windows.Forms.LabelTS();
            this.comboKBFilterUp = new System.Windows.Forms.ComboBoxTS();
            this.comboKBFilterDown = new System.Windows.Forms.ComboBoxTS();
            this.grpKBCW = new System.Windows.Forms.GroupBoxTS();
            this.lblKBCWDot = new System.Windows.Forms.LabelTS();
            this.lblKBCWDash = new System.Windows.Forms.LabelTS();
            this.comboKBCWDot = new System.Windows.Forms.ComboBoxTS();
            this.comboKBCWDash = new System.Windows.Forms.ComboBoxTS();
            this.tpExtCtrl = new System.Windows.Forms.TabPage();
            this.chkExtEnable = new System.Windows.Forms.CheckBoxTS();
            this.grpExtTX = new System.Windows.Forms.GroupBoxTS();
            this.lblExtTXX26 = new System.Windows.Forms.LabelTS();
            this.chkExtTX26 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX66 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX106 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX126 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX156 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX176 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX206 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX306 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX406 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX606 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX806 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX1606 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTXX25 = new System.Windows.Forms.LabelTS();
            this.lblExtTXX24 = new System.Windows.Forms.LabelTS();
            this.lblExtTXX23 = new System.Windows.Forms.LabelTS();
            this.lblExtTXX22 = new System.Windows.Forms.LabelTS();
            this.lblExtTX2 = new System.Windows.Forms.LabelTS();
            this.chkExtTX23 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX22 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX21 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX25 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX24 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX6 = new System.Windows.Forms.LabelTS();
            this.chkExtTX63 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX62 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX61 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX65 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX64 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX10 = new System.Windows.Forms.LabelTS();
            this.chkExtTX103 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX102 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX101 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX105 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX104 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX12 = new System.Windows.Forms.LabelTS();
            this.chkExtTX123 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX122 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX121 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX125 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX124 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX15 = new System.Windows.Forms.LabelTS();
            this.chkExtTX153 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX152 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX151 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX155 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX154 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX17 = new System.Windows.Forms.LabelTS();
            this.chkExtTX173 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX172 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX171 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX175 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX174 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX20 = new System.Windows.Forms.LabelTS();
            this.chkExtTX203 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX202 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX201 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX205 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX204 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX30 = new System.Windows.Forms.LabelTS();
            this.chkExtTX303 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX302 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX301 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX305 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX304 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX40 = new System.Windows.Forms.LabelTS();
            this.chkExtTX403 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX402 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX401 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX405 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX404 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX60 = new System.Windows.Forms.LabelTS();
            this.chkExtTX603 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX602 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX601 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX605 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX604 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTX80 = new System.Windows.Forms.LabelTS();
            this.chkExtTX803 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX802 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX801 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX805 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX804 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTXX2Pins = new System.Windows.Forms.LabelTS();
            this.lblExtTXBand = new System.Windows.Forms.LabelTS();
            this.lblExtTX160 = new System.Windows.Forms.LabelTS();
            this.chkExtTX1603 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX1602 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX1601 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtTXX21 = new System.Windows.Forms.LabelTS();
            this.chkExtTX1605 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtTX1604 = new System.Windows.Forms.CheckBoxTS();
            this.grpExtRX = new System.Windows.Forms.GroupBoxTS();
            this.lblExtRXX26 = new System.Windows.Forms.LabelTS();
            this.chkExtRX26 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX66 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX106 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX126 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX156 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX176 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX206 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX306 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX406 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX606 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX806 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX1606 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRXX25 = new System.Windows.Forms.LabelTS();
            this.lblExtRXX24 = new System.Windows.Forms.LabelTS();
            this.lblExtRXX23 = new System.Windows.Forms.LabelTS();
            this.lblExtRXX22 = new System.Windows.Forms.LabelTS();
            this.lblExtRX2 = new System.Windows.Forms.LabelTS();
            this.chkExtRX23 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX22 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX21 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX25 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX24 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX6 = new System.Windows.Forms.LabelTS();
            this.chkExtRX63 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX62 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX61 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX65 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX64 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX10 = new System.Windows.Forms.LabelTS();
            this.chkExtRX103 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX102 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX101 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX105 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX104 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX12 = new System.Windows.Forms.LabelTS();
            this.chkExtRX123 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX122 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX121 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX125 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX124 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX15 = new System.Windows.Forms.LabelTS();
            this.chkExtRX153 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX152 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX151 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX155 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX154 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX17 = new System.Windows.Forms.LabelTS();
            this.chkExtRX173 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX172 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX171 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX175 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX174 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX20 = new System.Windows.Forms.LabelTS();
            this.chkExtRX203 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX202 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX201 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX205 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX204 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX30 = new System.Windows.Forms.LabelTS();
            this.chkExtRX303 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX302 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX301 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX305 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX304 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX40 = new System.Windows.Forms.LabelTS();
            this.chkExtRX403 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX402 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX401 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX405 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX404 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX60 = new System.Windows.Forms.LabelTS();
            this.chkExtRX603 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX602 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX601 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX605 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX604 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRX80 = new System.Windows.Forms.LabelTS();
            this.chkExtRX803 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX802 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX801 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX805 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX804 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRXX2Pins = new System.Windows.Forms.LabelTS();
            this.lblExtRXBand = new System.Windows.Forms.LabelTS();
            this.lblExtRX160 = new System.Windows.Forms.LabelTS();
            this.chkExtRX1603 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX1602 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX1601 = new System.Windows.Forms.CheckBoxTS();
            this.lblExtRXX21 = new System.Windows.Forms.LabelTS();
            this.chkExtRX1605 = new System.Windows.Forms.CheckBoxTS();
            this.chkExtRX1604 = new System.Windows.Forms.CheckBoxTS();
            this.tpCAT = new System.Windows.Forms.TabPage();
            this.groupBoxTS4 = new System.Windows.Forms.GroupBoxTS();
            this.chkKWAI7 = new System.Windows.Forms.CheckBoxTS();
            this.txtCatURL2 = new System.Windows.Forms.TextBoxTS();
            this.radioButtonCAT = new System.Windows.Forms.RadioButton();
            this.chkCatURLON = new System.Windows.Forms.CheckBoxTS();
            this.txtCatPort = new System.Windows.Forms.TextBoxTS();
            this.txtCatURL = new System.Windows.Forms.TextBoxTS();
            this.labelTS61 = new System.Windows.Forms.LabelTS();
            this.labelTS62 = new System.Windows.Forms.LabelTS();
            this.chkCatURLALT = new System.Windows.Forms.CheckBoxTS();
            this.chkFPInstalled = new System.Windows.Forms.CheckBoxTS();
            this.chkDigUIsUSB = new System.Windows.Forms.CheckBoxTS();
            this.lblCATRigType = new System.Windows.Forms.LabelTS();
            this.comboCATRigType = new System.Windows.Forms.ComboBoxTS();
            this.btnCATTest = new System.Windows.Forms.ButtonTS();
            this.grpPTTBitBang = new System.Windows.Forms.GroupBoxTS();
            this.comboCATPTTPort = new System.Windows.Forms.ComboBoxTS();
            this.lblCATPTTPort = new System.Windows.Forms.LabelTS();
            this.chkCATPTT_RTS = new System.Windows.Forms.CheckBoxTS();
            this.chkCATPTT_DTR = new System.Windows.Forms.CheckBoxTS();
            this.chkCATPTTEnabled = new System.Windows.Forms.CheckBoxTS();
            this.grpCatControlBox = new System.Windows.Forms.GroupBoxTS();
            this.chkKWAI6 = new System.Windows.Forms.CheckBoxTS();
            this.chkKWAI5 = new System.Windows.Forms.CheckBoxTS();
            this.chkKWAI4 = new System.Windows.Forms.CheckBoxTS();
            this.chkKWAI3 = new System.Windows.Forms.CheckBoxTS();
            this.chkKWAI2 = new System.Windows.Forms.CheckBoxTS();
            this.labelTS63 = new System.Windows.Forms.LabelTS();
            this.comboCATPort6 = new System.Windows.Forms.ComboBoxTS();
            this.chkCATEnable6 = new System.Windows.Forms.CheckBoxTS();
            this.comboROTORPort = new System.Windows.Forms.ComboBoxTS();
            this.labelTS53 = new System.Windows.Forms.LabelTS();
            this.labelTS52 = new System.Windows.Forms.LabelTS();
            this.labelTS51 = new System.Windows.Forms.LabelTS();
            this.chkCATEnable5 = new System.Windows.Forms.CheckBoxTS();
            this.chkCATEnable4 = new System.Windows.Forms.CheckBoxTS();
            this.chkCATEnable3 = new System.Windows.Forms.CheckBoxTS();
            this.chkKWAI = new System.Windows.Forms.CheckBoxTS();
            this.chkCATEnable2 = new System.Windows.Forms.CheckBoxTS();
            this.txtCATPort5 = new System.Windows.Forms.TextBoxTS();
            this.txtCATPort4 = new System.Windows.Forms.TextBoxTS();
            this.txtCATPort3 = new System.Windows.Forms.TextBoxTS();
            this.txtCATPort2 = new System.Windows.Forms.TextBoxTS();
            this.txtCATPort1 = new System.Windows.Forms.TextBoxTS();
            this.comboCATPort5 = new System.Windows.Forms.ComboBoxTS();
            this.comboCATPort4 = new System.Windows.Forms.ComboBoxTS();
            this.comboCATPort3 = new System.Windows.Forms.ComboBoxTS();
            this.comboCATPort2 = new System.Windows.Forms.ComboBoxTS();
            this.labelTS50 = new System.Windows.Forms.LabelTS();
            this.labelTS49 = new System.Windows.Forms.LabelTS();
            this.labelTS48 = new System.Windows.Forms.LabelTS();
            this.labelTS47 = new System.Windows.Forms.LabelTS();
            this.labelTS20 = new System.Windows.Forms.LabelTS();
            this.chkROTOREnable = new System.Windows.Forms.CheckBoxTS();
            this.comboCATPort = new System.Windows.Forms.ComboBoxTS();
            this.comboCATbaud = new System.Windows.Forms.ComboBoxTS();
            this.lblCATBaud = new System.Windows.Forms.LabelTS();
            this.lblCATPort = new System.Windows.Forms.LabelTS();
            this.chkCATEnable = new System.Windows.Forms.CheckBoxTS();
            this.lblCATParity = new System.Windows.Forms.LabelTS();
            this.lblCATData = new System.Windows.Forms.LabelTS();
            this.lblCATStop = new System.Windows.Forms.LabelTS();
            this.comboCATparity = new System.Windows.Forms.ComboBoxTS();
            this.comboCATdatabits = new System.Windows.Forms.ComboBoxTS();
            this.comboCATstopbits = new System.Windows.Forms.ComboBoxTS();
            this.labelTS57 = new System.Windows.Forms.LabelTS();
            this.grpRTTYOffset = new System.Windows.Forms.GroupBoxTS();
            this.labelTS4 = new System.Windows.Forms.LabelTS();
            this.labelTS3 = new System.Windows.Forms.LabelTS();
            this.udRTTYU = new System.Windows.Forms.NumericUpDownTS();
            this.udRTTYL = new System.Windows.Forms.NumericUpDownTS();
            this.chkRTTYOffsetEnableB = new System.Windows.Forms.CheckBoxTS();
            this.chkRTTYOffsetEnableA = new System.Windows.Forms.CheckBoxTS();
            this.tpTests = new System.Windows.Forms.TabPage();
            this.grpBoxTS1 = new System.Windows.Forms.GroupBoxTS();
            this.udPulsePeriod = new System.Windows.Forms.NumericUpDownTS();
            this.lblPulsePeriod = new System.Windows.Forms.LabelTS();
            this.udPulseDuty = new System.Windows.Forms.NumericUpDownTS();
            this.lblPulseDuty = new System.Windows.Forms.LabelTS();
            this.grpSigGenTransmit = new System.Windows.Forms.GroupBoxTS();
            this.lblSigGenTXMode = new System.Windows.Forms.LabelTS();
            this.cmboSigGenTXMode = new System.Windows.Forms.ComboBoxTS();
            this.rdSigGenTXInput = new System.Windows.Forms.RadioButtonTS();
            this.rdSigGenTXOutput = new System.Windows.Forms.RadioButtonTS();
            this.grpSigGenReceive = new System.Windows.Forms.GroupBoxTS();
            this.chkSigGenRX2 = new System.Windows.Forms.CheckBox();
            this.lblSigGenRXMode = new System.Windows.Forms.LabelTS();
            this.cmboSigGenRXMode = new System.Windows.Forms.ComboBoxTS();
            this.rdSigGenRXInput = new System.Windows.Forms.RadioButtonTS();
            this.rdSigGenRXOutput = new System.Windows.Forms.RadioButtonTS();
            this.lblTestGenScale = new System.Windows.Forms.LabelTS();
            this.udTestGenScale = new System.Windows.Forms.NumericUpDownTS();
            this.lblTestSigGenFreqCallout = new System.Windows.Forms.LabelTS();
            this.tkbarTestGenFreq = new System.Windows.Forms.TrackBarTS();
            this.lblTestGenHzSec = new System.Windows.Forms.LabelTS();
            this.udTestGenHzSec = new System.Windows.Forms.NumericUpDownTS();
            this.lblTestGenHigh = new System.Windows.Forms.LabelTS();
            this.udTestGenHigh = new System.Windows.Forms.NumericUpDownTS();
            this.lblTestGenLow = new System.Windows.Forms.LabelTS();
            this.udTestGenLow = new System.Windows.Forms.NumericUpDownTS();
            this.btnTestGenSweep = new System.Windows.Forms.ButtonTS();
            this.ckEnableSigGen = new System.Windows.Forms.CheckBoxTS();
            this.grpTestX2 = new System.Windows.Forms.GroupBoxTS();
            this.lblTestX2 = new System.Windows.Forms.LabelTS();
            this.chkTestX2Pin6 = new System.Windows.Forms.CheckBoxTS();
            this.chkTestX2Pin5 = new System.Windows.Forms.CheckBoxTS();
            this.chkTestX2Pin4 = new System.Windows.Forms.CheckBoxTS();
            this.chkTestX2Pin3 = new System.Windows.Forms.CheckBoxTS();
            this.chkTestX2Pin2 = new System.Windows.Forms.CheckBoxTS();
            this.chkTestX2Pin1 = new System.Windows.Forms.CheckBoxTS();
            this.grpTestAudioBalance = new System.Windows.Forms.GroupBoxTS();
            this.btnTestAudioBalStart = new System.Windows.Forms.ButtonTS();
            this.grpTestTXIMD = new System.Windows.Forms.GroupBoxTS();
            this.lblTestToneFreq2 = new System.Windows.Forms.LabelTS();
            this.udTestIMDFreq2 = new System.Windows.Forms.NumericUpDownTS();
            this.lblTestIMDPower = new System.Windows.Forms.LabelTS();
            this.udTestIMDPower = new System.Windows.Forms.NumericUpDownTS();
            this.chekTestIMD = new System.Windows.Forms.CheckBoxTS();
            this.lblTestToneFreq1 = new System.Windows.Forms.LabelTS();
            this.udTestIMDFreq1 = new System.Windows.Forms.NumericUpDownTS();
            this.grpImpulseTest = new System.Windows.Forms.GroupBoxTS();
            this.udImpulseNum = new System.Windows.Forms.NumericUpDownTS();
            this.btnImpulse = new System.Windows.Forms.ButtonTS();
            this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.buttonExit = new System.Windows.Forms.ButtonTS();
            this.buttonTS1 = new System.Windows.Forms.ButtonTS();
            this.btnExportDB = new System.Windows.Forms.ButtonTS();
            this.btnImportDB = new System.Windows.Forms.ButtonTS();
            this.btnApply = new System.Windows.Forms.ButtonTS();
            this.btnCancel = new System.Windows.Forms.ButtonTS();
            this.btnOK = new System.Windows.Forms.ButtonTS();
            this.timer_sweep = new System.Windows.Forms.Timer(this.components);
            this.mainMenu1 = new System.Windows.Forms.MainMenu(this.components);
            this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
            this.textBoxSAVE = new System.Windows.Forms.TextBoxTS();
            this.btnResetDB = new System.Windows.Forms.ButtonTS();
            this.chkAlwaysOnTop1 = new System.Windows.Forms.CheckBoxTS();
            this.tcSetup.SuspendLayout();
            this.tpGeneral.SuspendLayout();
            this.tcGeneral.SuspendLayout();
            this.tpGeneralHardware.SuspendLayout();
            this.grpGeneralHardwareFLEX5000.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udF3KFanTempThresh)).BeginInit();
            this.grpGeneralHardwareSDR1000.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralLPTDelay)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPTTHT)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTOT)).BeginInit();
            this.grpHWSoftRock.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udSoftRockCenterFreq)).BeginInit();
            this.grpGeneralDDS.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDDSCorrection)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDDSIFFreq)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDDSPLLMult)).BeginInit();
            this.grpGeneralModel.SuspendLayout();
            this.grpGeneralHardwareFLEX1500.SuspendLayout();
            this.tpGeneralOptions.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udPwrMstrCOM)).BeginInit();
            this.grpOptUSBBuf.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.tbOptUSBBuf)).BeginInit();
            this.grpGenCustomTitleText.SuspendLayout();
            this.grpOptMisc.SuspendLayout();
            this.grpOptQuickQSY.SuspendLayout();
            this.grpGenAutoMute.SuspendLayout();
            this.grpGenTuningOptions.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udOptClickTuneOffsetDIGU)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udOptClickTuneOffsetDIGL)).BeginInit();
            this.grpGeneralOptions.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udGenTX1Delay)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralX2Delay)).BeginInit();
            this.grpGeneralProcessPriority.SuspendLayout();
            this.tpGeneralCalibration.SuspendLayout();
            this.grpGenCalRXImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralCalFreq3)).BeginInit();
            this.grpGenCalLevel.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralCalLevel)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralCalFreq2)).BeginInit();
            this.grpGeneralCalibration.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralCalFreq1)).BeginInit();
            this.tpFilters.SuspendLayout();
            this.grpOptFilterControls.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udFilterDefaultLowCut)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udOptMaxFilterShift)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udOptMaxFilterWidth)).BeginInit();
            this.tpRX2.SuspendLayout();
            this.tpGeneralNavigation.SuspendLayout();
            this.grpOptSpaceNav.SuspendLayout();
            this.tpUserInterface.SuspendLayout();
            this.groupBox2.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udN1MMfps)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udN1MMscale)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udN1MMport)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udHttpRefresh)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udHttpPort)).BeginInit();
            this.groupBox1.SuspendLayout();
            this.groupBoxTS1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udSpeedPM)).BeginInit();
            this.tpAudio.SuspendLayout();
            this.tcAudio.SuspendLayout();
            this.tpAudioCard1.SuspendLayout();
            this.groupBoxTS7.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udIQCorrection)).BeginInit();
            this.groupBoxTS8.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udIQCorrection_TX)).BeginInit();
            this.grpAudioChannels.SuspendLayout();
            this.grpAudioMicInGain1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udAudioMicGain1)).BeginInit();
            this.grpAudioLineInGain1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udAudioLineIn1)).BeginInit();
            this.grpAudioVolts1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udAudioVoltage1)).BeginInit();
            this.grpAudioDetails1.SuspendLayout();
            this.grpAudioLatency1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udAudioLatency1)).BeginInit();
            this.grpAudioCard.SuspendLayout();
            this.grpAudioBufferSize1.SuspendLayout();
            this.grpAudioSampleRate1.SuspendLayout();
            this.tpVAC.SuspendLayout();
            this.groupBoxTS6.SuspendLayout();
            this.grpDirectIQOutput.SuspendLayout();
            this.grpAudioVACAutoEnable.SuspendLayout();
            this.grpAudioVACGain.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udAudioVACGainTX)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udAudioVACGainRX)).BeginInit();
            this.grpAudio2Stereo.SuspendLayout();
            this.grpAudioLatency2.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udAudioLatency2)).BeginInit();
            this.grpAudioSampleRate2.SuspendLayout();
            this.grpAudioBuffer2.SuspendLayout();
            this.grpAudioDetails2.SuspendLayout();
            this.tpVAC2.SuspendLayout();
            this.grpVAC2DirectIQ.SuspendLayout();
            this.grpVAC2AutoEnable.SuspendLayout();
            this.grpVAC2Gain.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udVAC2GainTX)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udVAC2GainRX)).BeginInit();
            this.grpAudioStereo3.SuspendLayout();
            this.grpVAC2Latency.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udVAC2Latency)).BeginInit();
            this.grpAudioSampleRate3.SuspendLayout();
            this.grpAudioBuffer3.SuspendLayout();
            this.grpAudioDetails3.SuspendLayout();
            this.tpDisplay.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.tbAGCTadj)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbWaterOffset)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbGridOffset)).BeginInit();
            this.grpDisplayMultimeter.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udSS2H)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udSS1H)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udSS1)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udSS2)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udMeterDigitalDelay)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayMeterAvg)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayMultiTextHoldTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayMultiPeakHoldTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayMeterDelay)).BeginInit();
            this.grpDisplayDriverEngine.SuspendLayout();
            this.grpDisplayScopeMode.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayScopeTime)).BeginInit();
            this.grpDisplayWaterfall.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallMicLevel)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallRX2Level)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallUpdatePeriod)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallAvgTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallLowLevel)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallHighLevel)).BeginInit();
            this.grpDisplayRefreshRates.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayCPUMeter)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayPeakText)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayFPS)).BeginInit();
            this.grpDisplayAverage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayAVGTime)).BeginInit();
            this.grpDisplayPhase.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayPhasePts)).BeginInit();
            this.grpDisplaySpectrumGrid.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayGridStep)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayGridMin)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayGridMax)).BeginInit();
            this.tpDSP.SuspendLayout();
            this.tcDSP.SuspendLayout();
            this.tpDSPOptions.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTNFWidth)).BeginInit();
            this.grpDSPBufferSize.SuspendLayout();
            this.grpDSPBufDig.SuspendLayout();
            this.grpDSPBufCW.SuspendLayout();
            this.grpDSPBufPhone.SuspendLayout();
            this.grpDSPNB.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPDLY)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPNB)).BeginInit();
            this.grpDSPLMSNR.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSNRLeak)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSNRgain)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSNRtaps)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSNRdelay)).BeginInit();
            this.grpDSPLMSANF.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSANFLeak)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSANFgain)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSANFdelay)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSANFtaps)).BeginInit();
            this.grpDSPWindow.SuspendLayout();
            this.grpDSPNB2.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPNB2)).BeginInit();
            this.tpDSPImageReject.SuspendLayout();
            this.grpDSPImageRejectTX.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPImageGainTX)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPImagePhaseTX)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPImagePhaseTX)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPImageGainTX)).BeginInit();
            this.tpDSPKeyer.SuspendLayout();
            this.grpKeyerConnections.SuspendLayout();
            this.grpDSPCWPitch.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPCWPitch)).BeginInit();
            this.grpDSPKeyerOptions.SuspendLayout();
            this.grpDSPKeyerSignalShaping.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udCWKeyerWeight)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udCWKeyerRamp)).BeginInit();
            this.grpDSPKeyerSemiBreakIn.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udCWBreakInDelay)).BeginInit();
            this.tpDSPAGCALC.SuspendLayout();
            this.grpDSPLeveler.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerHangTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerThreshold)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerSlope)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerDecay)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerAttack)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPLevelerHangThreshold)).BeginInit();
            this.grpDSPALC.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPALCHangThreshold)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCHangTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCThreshold)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCSlope)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCDecay)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCAttack)).BeginInit();
            this.grpDSPAGC.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPAGCHangThreshold)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCHangTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCMaxGaindB)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCSlope)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCDecay)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCAttack)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCFixedGaindB)).BeginInit();
            this.tpTransmit.SuspendLayout();
            this.grpTXVOX.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTXVOXHangTime)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXVOXThreshold)).BeginInit();
            this.grpTXProfileDef.SuspendLayout();
            this.grpTXAM.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTXAMCarrierLevel)).BeginInit();
            this.grpTXMonitor.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTXAF)).BeginInit();
            this.grpTXNoiseGate.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTXNoiseGateAttenuate)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXNoiseGate)).BeginInit();
            this.grpTXProfile.SuspendLayout();
            this.grpPATune.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.tbPulseRate1)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbDutyCycle)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXTunePower)).BeginInit();
            this.grpTXFilter.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTXDriveMax)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXFilterLow)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXFilterHigh)).BeginInit();
            this.grpTX1500.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTX1500PhoneBlanking)).BeginInit();
            this.tpPowerAmplifier.SuspendLayout();
            this.grpPABandOffset.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC17)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC15)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC20)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC12)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC10)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC160)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC80)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC60)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC40)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC30)).BeginInit();
            this.grpPAGainByBand.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udPACalPower)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain10)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain12)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain15)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain17)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain20)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain30)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain40)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain60)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain80)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain160)).BeginInit();
            this.tpAppearance.SuspendLayout();
            this.tcAppearance.SuspendLayout();
            this.tpAppearanceGeneral.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.number3DY)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.number3DX)).BeginInit();
            this.groupBoxTS3.SuspendLayout();
            this.grpAppSkins.SuspendLayout();
            this.grpAppearanceBand.SuspendLayout();
            this.grpAppearanceVFO.SuspendLayout();
            this.tpAppearanceDisplay.SuspendLayout();
            this.grpMainDisplay.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.tbPan3DAlpha)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbPanGrid)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayLineWidth)).BeginInit();
            this.grpAppPanadapter.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.tbMapBright)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbPanAlpha)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbGrayLineBright)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udBandSegmentBoxLineWidth)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbMultiRXFilterAlpha)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbRX1FilterAlpha)).BeginInit();
            this.grpDisplayPeakCursor.SuspendLayout();
            this.tpAppearanceMeter.SuspendLayout();
            this.grpMeterEdge.SuspendLayout();
            this.grpAppearanceMeter.SuspendLayout();
            this.tpKeyboard.SuspendLayout();
            this.groupBoxTS5.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udQuindarTonesVol)).BeginInit();
            this.groupBoxTS2.SuspendLayout();
            this.grpKBXIT.SuspendLayout();
            this.grpKBRIT.SuspendLayout();
            this.grpKBMode.SuspendLayout();
            this.grpKBBand.SuspendLayout();
            this.grpKBTune.SuspendLayout();
            this.grpKBFilter.SuspendLayout();
            this.grpKBCW.SuspendLayout();
            this.tpExtCtrl.SuspendLayout();
            this.grpExtTX.SuspendLayout();
            this.grpExtRX.SuspendLayout();
            this.tpCAT.SuspendLayout();
            this.groupBoxTS4.SuspendLayout();
            this.grpPTTBitBang.SuspendLayout();
            this.grpCatControlBox.SuspendLayout();
            this.grpRTTYOffset.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udRTTYU)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udRTTYL)).BeginInit();
            this.tpTests.SuspendLayout();
            this.grpBoxTS1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udPulsePeriod)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPulseDuty)).BeginInit();
            this.grpSigGenTransmit.SuspendLayout();
            this.grpSigGenReceive.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTestGenScale)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tkbarTestGenFreq)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestGenHzSec)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestGenHigh)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestGenLow)).BeginInit();
            this.grpTestX2.SuspendLayout();
            this.grpTestAudioBalance.SuspendLayout();
            this.grpTestTXIMD.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udTestIMDFreq2)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestIMDPower)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestIMDFreq1)).BeginInit();
            this.grpImpulseTest.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udImpulseNum)).BeginInit();
            this.SuspendLayout();
            // 
            // tcSetup
            // 
            this.tcSetup.Controls.Add(this.tpGeneral);
            this.tcSetup.Controls.Add(this.tpAudio);
            this.tcSetup.Controls.Add(this.tpDisplay);
            this.tcSetup.Controls.Add(this.tpDSP);
            this.tcSetup.Controls.Add(this.tpTransmit);
            this.tcSetup.Controls.Add(this.tpPowerAmplifier);
            this.tcSetup.Controls.Add(this.tpAppearance);
            this.tcSetup.Controls.Add(this.tpKeyboard);
            this.tcSetup.Controls.Add(this.tpExtCtrl);
            this.tcSetup.Controls.Add(this.tpCAT);
            this.tcSetup.Controls.Add(this.tpTests);
            this.tcSetup.Location = new System.Drawing.Point(8, 12);
            this.tcSetup.Name = "tcSetup";
            this.tcSetup.SelectedIndex = 0;
            this.tcSetup.Size = new System.Drawing.Size(592, 367);
            this.tcSetup.TabIndex = 16;
            // 
            // tpGeneral
            // 
            this.tpGeneral.Controls.Add(this.tcGeneral);
            this.tpGeneral.Location = new System.Drawing.Point(4, 22);
            this.tpGeneral.Name = "tpGeneral";
            this.tpGeneral.Size = new System.Drawing.Size(584, 341);
            this.tpGeneral.TabIndex = 3;
            this.tpGeneral.Text = "General";
            // 
            // tcGeneral
            // 
            this.tcGeneral.Controls.Add(this.tpGeneralHardware);
            this.tcGeneral.Controls.Add(this.tpGeneralOptions);
            this.tcGeneral.Controls.Add(this.tpGeneralCalibration);
            this.tcGeneral.Controls.Add(this.tpFilters);
            this.tcGeneral.Controls.Add(this.tpRX2);
            this.tcGeneral.Controls.Add(this.tpGeneralNavigation);
            this.tcGeneral.Controls.Add(this.tpUserInterface);
            this.tcGeneral.Location = new System.Drawing.Point(0, 0);
            this.tcGeneral.Name = "tcGeneral";
            this.tcGeneral.SelectedIndex = 0;
            this.tcGeneral.Size = new System.Drawing.Size(600, 344);
            this.tcGeneral.TabIndex = 26;
            // 
            // tpGeneralHardware
            // 
            this.tpGeneralHardware.BackColor = System.Drawing.SystemColors.Control;
			this.tpGeneralHardware.Controls.Add(this.chkExtended);
            this.tpGeneralHardware.Controls.Add(this.chkBoxShutdown);
            this.tpGeneralHardware.Controls.Add(this.chkBox30min);
            this.tpGeneralHardware.Controls.Add(this.chkBoxPTTLatch);
            this.tpGeneralHardware.Controls.Add(this.chkBoxPTT);
            this.tpGeneralHardware.Controls.Add(this.chkBoxAutoFocus);
            this.tpGeneralHardware.Controls.Add(this.chkBoxAutoStart);
            this.tpGeneralHardware.Controls.Add(this.textBoxRestart);
            this.tpGeneralHardware.Controls.Add(this.chkBoxRestart);
            this.tpGeneralHardware.Controls.Add(this.grpGeneralHardwareFLEX5000);
            this.tpGeneralHardware.Controls.Add(this.grpGeneralHardwareSDR1000);
            this.tpGeneralHardware.Controls.Add(this.labelTS31);
            this.tpGeneralHardware.Controls.Add(this.udPTTHT);
            this.tpGeneralHardware.Controls.Add(this.chkBoxPTTHT);
            this.tpGeneralHardware.Controls.Add(this.textBoxTOT);
            this.tpGeneralHardware.Controls.Add(this.labelTS23);
            this.tpGeneralHardware.Controls.Add(this.udTOT);
            this.tpGeneralHardware.Controls.Add(this.chkBoxTOT);
            this.tpGeneralHardware.Controls.Add(this.grpHWSoftRock);
            this.tpGeneralHardware.Controls.Add(this.grpGeneralDDS);
            this.tpGeneralHardware.Controls.Add(this.grpGeneralModel);
            this.tpGeneralHardware.Controls.Add(this.btnWizard);
            this.tpGeneralHardware.Controls.Add(this.chkGeneralRXOnly);
            this.tpGeneralHardware.Controls.Add(this.grpGeneralHardwareFLEX1500);
            this.tpGeneralHardware.Location = new System.Drawing.Point(4, 22);
            this.tpGeneralHardware.Name = "tpGeneralHardware";
            this.tpGeneralHardware.Size = new System.Drawing.Size(592, 318);
            this.tpGeneralHardware.TabIndex = 0;
            this.tpGeneralHardware.Text = "Hardware Config";
            this.tpGeneralHardware.MouseEnter += new System.EventHandler(this.Setup_MouseEnter);
            // 
            // chkExtended
            // 
            this.chkExtended.Image = null;
            this.chkExtended.Location = new System.Drawing.Point(432, 261);
            this.chkExtended.Name = "chkExtended";
            this.chkExtended.Size = new System.Drawing.Size(145, 29);
            this.chkExtended.TabIndex = 24;
            this.chkExtended.Text = "Extended Freq.";
            this.toolTip1.SetToolTip(this.chkExtended, "Check to enable Extended Frequency Range");
            this.chkExtended.CheckedChanged += new System.EventHandler(this.chkExtended_CheckedChanged);
            // 
            // chkBoxShutdown
            // 
            this.chkBoxShutdown.Image = null;
            this.chkBoxShutdown.Location = new System.Drawing.Point(336, 290);
            this.chkBoxShutdown.Name = "chkBoxShutdown";
            this.chkBoxShutdown.Size = new System.Drawing.Size(168, 17);
            this.chkBoxShutdown.TabIndex = 40;
            this.chkBoxShutdown.Text = "Allow Windows Shutdown";
            this.toolTip1.SetToolTip(this.chkBoxShutdown, resources.GetString("chkBoxShutdown.ToolTip"));
            // 
            // chkBox30min
            // 
            this.chkBox30min.Image = null;
            this.chkBox30min.Location = new System.Drawing.Point(336, 267);
            this.chkBox30min.Name = "chkBox30min";
            this.chkBox30min.Size = new System.Drawing.Size(140, 16);
            this.chkBox30min.TabIndex = 39;
            this.chkBox30min.Text = "30min ID timer";
            this.toolTip1.SetToolTip(this.chkBox30min, "ID Timer will run 30min (instead of the standard 10min)");
            // 
            // chkBoxPTTLatch
            // 
            this.chkBoxPTTLatch.Image = null;
            this.chkBoxPTTLatch.Location = new System.Drawing.Point(8, 262);
            this.chkBoxPTTLatch.Name = "chkBoxPTTLatch";
            this.chkBoxPTTLatch.Size = new System.Drawing.Size(152, 16);
            this.chkBoxPTTLatch.TabIndex = 38;
            this.chkBoxPTTLatch.Text = "SpaceBar Latch ON/OFF PTT";
            this.toolTip1.SetToolTip(this.chkBoxPTTLatch, "Hit SpaceBar to Activate PTT\r\nHit SpaceBar (again) to Release PTT\r\n\r\nUse in remot" +
        "e operation along with Time-Out Timer");
            this.chkBoxPTTLatch.CheckedChanged += new System.EventHandler(this.ChkBoxPTTLatch_CheckedChanged);
            // 
            // chkBoxPTT
            // 
            this.chkBoxPTT.Image = null;
            this.chkBoxPTT.Location = new System.Drawing.Point(8, 243);
            this.chkBoxPTT.Name = "chkBoxPTT";
            this.chkBoxPTT.Size = new System.Drawing.Size(136, 16);
            this.chkBoxPTT.TabIndex = 37;
            this.chkBoxPTT.Text = "SpaceBar Hold to PTT";
            this.toolTip1.SetToolTip(this.chkBoxPTT, "Hold SpaceBar to PTT \r\nRelease SpaceBar to Relase PTT \r\n\r\nDo not use with Remote " +
        "operation");
            this.chkBoxPTT.CheckedChanged += new System.EventHandler(this.ChkBoxPTT_CheckedChanged);
            // 
            // chkBoxAutoFocus
            // 
            this.chkBoxAutoFocus.Image = null;
            this.chkBoxAutoFocus.Location = new System.Drawing.Point(176, 267);
            this.chkBoxAutoFocus.Name = "chkBoxAutoFocus";
            this.chkBoxAutoFocus.Size = new System.Drawing.Size(140, 16);
            this.chkBoxAutoFocus.TabIndex = 36;
            this.chkBoxAutoFocus.Text = "Auto Focus PowerSDR";
            this.toolTip1.SetToolTip(this.chkBoxAutoFocus, resources.GetString("chkBoxAutoFocus.ToolTip"));
            // 
            // chkBoxAutoStart
            // 
            this.chkBoxAutoStart.Image = null;
            this.chkBoxAutoStart.Location = new System.Drawing.Point(176, 289);
            this.chkBoxAutoStart.Name = "chkBoxAutoStart";
            this.chkBoxAutoStart.Size = new System.Drawing.Size(140, 16);
            this.chkBoxAutoStart.TabIndex = 35;
            this.chkBoxAutoStart.Text = "Auto Start PowerSDR";
            this.toolTip1.SetToolTip(this.chkBoxAutoStart, "When Checked: Will Start PowerSDR running immediately after launching and loading" +
        ".");
            this.chkBoxAutoStart.CheckedChanged += new System.EventHandler(this.chkBoxAutoStart_CheckedChanged);
            // 
            // textBoxRestart
            // 
            this.textBoxRestart.Location = new System.Drawing.Point(126, 287);
            this.textBoxRestart.MaxLength = 3;
            this.textBoxRestart.Name = "textBoxRestart";
            this.textBoxRestart.ReadOnly = true;
            this.textBoxRestart.Size = new System.Drawing.Size(26, 20);
            this.textBoxRestart.TabIndex = 34;
            this.textBoxRestart.Text = "0";
            this.toolTip1.SetToolTip(this.textBoxRestart, "Displays # of times DttSP has frozen.");
            // 
            // chkBoxRestart
            // 
            this.chkBoxRestart.Image = null;
            this.chkBoxRestart.Location = new System.Drawing.Point(8, 289);
            this.chkBoxRestart.Name = "chkBoxRestart";
            this.chkBoxRestart.Size = new System.Drawing.Size(124, 16);
            this.chkBoxRestart.TabIndex = 33;
            this.chkBoxRestart.Text = "DttSP Auto Restart";
            this.toolTip1.SetToolTip(this.chkBoxRestart, resources.GetString("chkBoxRestart.ToolTip"));
            // 
            // grpGeneralHardwareFLEX5000
            // 
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblversion);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.labelTS42);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblFlexControlRev);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblVURev);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.udF3KFanTempThresh);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblF3KFanTempThresh);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.chkGenFLEX5000ExtRef);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblFirmwareRev);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblRX2Rev);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblATURev);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblRFIORev);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblPARev);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblTRXRev);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblSerialNum);
            this.grpGeneralHardwareFLEX5000.Controls.Add(this.lblModel);
            this.grpGeneralHardwareFLEX5000.Location = new System.Drawing.Point(160, 8);
            this.grpGeneralHardwareFLEX5000.Name = "grpGeneralHardwareFLEX5000";
            this.grpGeneralHardwareFLEX5000.Size = new System.Drawing.Size(167, 248);
            this.grpGeneralHardwareFLEX5000.TabIndex = 11;
            this.grpGeneralHardwareFLEX5000.TabStop = false;
            this.grpGeneralHardwareFLEX5000.Text = "FLEX-5000 Config";
            this.grpGeneralHardwareFLEX5000.Visible = false;
            // 
            // lblversion
            // 
            this.lblversion.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblversion.Image = null;
            this.lblversion.Location = new System.Drawing.Point(45, 32);
            this.lblversion.Name = "lblversion";
            this.lblversion.Size = new System.Drawing.Size(122, 16);
            this.lblversion.TabIndex = 31;
            this.lblversion.Text = "v2.8.0.000";
            // 
            // labelTS42
            // 
            this.labelTS42.Image = null;
            this.labelTS42.Location = new System.Drawing.Point(3, 32);
            this.labelTS42.Name = "labelTS42";
            this.labelTS42.Size = new System.Drawing.Size(52, 16);
            this.labelTS42.TabIndex = 30;
            this.labelTS42.Text = "Soft ver:";
            // 
            // lblFlexControlRev
            // 
            this.lblFlexControlRev.Image = null;
            this.lblFlexControlRev.Location = new System.Drawing.Point(6, 160);
            this.lblFlexControlRev.Name = "lblFlexControlRev";
            this.lblFlexControlRev.Size = new System.Drawing.Size(136, 16);
            this.lblFlexControlRev.TabIndex = 29;
            this.lblFlexControlRev.Text = "FlexControl: v0.2.0.9";
            this.lblFlexControlRev.Visible = false;
            // 
            // lblVURev
            // 
            this.lblVURev.Image = null;
            this.lblVURev.Location = new System.Drawing.Point(6, 144);
            this.lblVURev.Name = "lblVURev";
            this.lblVURev.Size = new System.Drawing.Size(136, 16);
            this.lblVURev.TabIndex = 28;
            this.lblVURev.Text = "VU: 8888-8888 (8.8.8.8)";
            // 
            // udF3KFanTempThresh
            // 
            this.udF3KFanTempThresh.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udF3KFanTempThresh.Location = new System.Drawing.Point(104, 216);
            this.udF3KFanTempThresh.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udF3KFanTempThresh.Minimum = new decimal(new int[] {
            30,
            0,
            0,
            0});
            this.udF3KFanTempThresh.Name = "udF3KFanTempThresh";
            this.udF3KFanTempThresh.Size = new System.Drawing.Size(40, 20);
            this.udF3KFanTempThresh.TabIndex = 14;
            this.toolTip1.SetToolTip(this.udF3KFanTempThresh, "Temperature in degrees Celsius at which the fan will stay on.");
            this.udF3KFanTempThresh.Value = new decimal(new int[] {
            40,
            0,
            0,
            0});
            this.udF3KFanTempThresh.Visible = false;
            this.udF3KFanTempThresh.ValueChanged += new System.EventHandler(this.udF3KFanTempThresh_ValueChanged);
            // 
            // lblF3KFanTempThresh
            // 
            this.lblF3KFanTempThresh.Image = null;
            this.lblF3KFanTempThresh.Location = new System.Drawing.Point(16, 208);
            this.lblF3KFanTempThresh.Name = "lblF3KFanTempThresh";
            this.lblF3KFanTempThresh.Size = new System.Drawing.Size(88, 32);
            this.lblF3KFanTempThresh.TabIndex = 13;
            this.lblF3KFanTempThresh.Text = "Fan Temp Threshold (C):";
            this.lblF3KFanTempThresh.Visible = false;
            // 
            // chkGenFLEX5000ExtRef
            // 
            this.chkGenFLEX5000ExtRef.Image = null;
            this.chkGenFLEX5000ExtRef.Location = new System.Drawing.Point(16, 184);
            this.chkGenFLEX5000ExtRef.Name = "chkGenFLEX5000ExtRef";
            this.chkGenFLEX5000ExtRef.Size = new System.Drawing.Size(120, 16);
            this.chkGenFLEX5000ExtRef.TabIndex = 12;
            this.chkGenFLEX5000ExtRef.Text = "Use Ext. Ref Input";
            this.toolTip1.SetToolTip(this.chkGenFLEX5000ExtRef, "Check to use an externally supplied 10MHz clock with the FLEX-5000 or FLEX-1500");
            this.chkGenFLEX5000ExtRef.CheckedChanged += new System.EventHandler(this.chkGenFLEX5000ExtRef_CheckedChanged);
            // 
            // lblFirmwareRev
            // 
            this.lblFirmwareRev.Image = null;
            this.lblFirmwareRev.Location = new System.Drawing.Point(6, 48);
            this.lblFirmwareRev.Name = "lblFirmwareRev";
            this.lblFirmwareRev.Size = new System.Drawing.Size(120, 16);
            this.lblFirmwareRev.TabIndex = 7;
            this.lblFirmwareRev.Text = "Firmware: 0.0.0.0";
            // 
            // lblRX2Rev
            // 
            this.lblRX2Rev.Image = null;
            this.lblRX2Rev.Location = new System.Drawing.Point(6, 128);
            this.lblRX2Rev.Name = "lblRX2Rev";
            this.lblRX2Rev.Size = new System.Drawing.Size(136, 16);
            this.lblRX2Rev.TabIndex = 6;
            this.lblRX2Rev.Text = "RX2: 8888-8888 (8.8.8.8)";
            // 
            // lblATURev
            // 
            this.lblATURev.Image = null;
            this.lblATURev.Location = new System.Drawing.Point(6, 112);
            this.lblATURev.Name = "lblATURev";
            this.lblATURev.Size = new System.Drawing.Size(136, 16);
            this.lblATURev.TabIndex = 5;
            this.lblATURev.Text = "ATU: 8888-8888 (8.8.8.8)";
            // 
            // lblRFIORev
            // 
            this.lblRFIORev.Image = null;
            this.lblRFIORev.Location = new System.Drawing.Point(6, 96);
            this.lblRFIORev.Name = "lblRFIORev";
            this.lblRFIORev.Size = new System.Drawing.Size(140, 16);
            this.lblRFIORev.TabIndex = 4;
            this.lblRFIORev.Text = "RFIO: 8888-8888 (8.8.8.8)";
            // 
            // lblPARev
            // 
            this.lblPARev.Image = null;
            this.lblPARev.Location = new System.Drawing.Point(6, 80);
            this.lblPARev.Name = "lblPARev";
            this.lblPARev.Size = new System.Drawing.Size(136, 16);
            this.lblPARev.TabIndex = 3;
            this.lblPARev.Text = "PA: 8888-8888 (8.8.8.8)";
            // 
            // lblTRXRev
            // 
            this.lblTRXRev.Image = null;
            this.lblTRXRev.Location = new System.Drawing.Point(6, 64);
            this.lblTRXRev.Name = "lblTRXRev";
            this.lblTRXRev.Size = new System.Drawing.Size(136, 16);
            this.lblTRXRev.TabIndex = 2;
            this.lblTRXRev.Text = "TRX: 8888-8888 (28F)";
            // 
            // lblSerialNum
            // 
            this.lblSerialNum.Image = null;
            this.lblSerialNum.Location = new System.Drawing.Point(53, 16);
            this.lblSerialNum.Name = "lblSerialNum";
            this.lblSerialNum.Size = new System.Drawing.Size(100, 16);
            this.lblSerialNum.TabIndex = 1;
            this.lblSerialNum.Text = "S/N: 0000-0000";
            // 
            // lblModel
            // 
            this.lblModel.Image = null;
            this.lblModel.Location = new System.Drawing.Point(6, 16);
            this.lblModel.Name = "lblModel";
            this.lblModel.Size = new System.Drawing.Size(52, 16);
            this.lblModel.TabIndex = 0;
            this.lblModel.Text = "Model: A";
            // 
            // grpGeneralHardwareSDR1000
            // 
            this.grpGeneralHardwareSDR1000.Controls.Add(this.lblFlexControlRev1K);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.chkEnableRFEPATR);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.chkGeneralUSBPresent);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.chkGeneralATUPresent);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.chkGeneralPAPresent);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.chkGeneralXVTRPresent);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.lblGeneralLPTDelay);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.udGeneralLPTDelay);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.lblGeneralLPTAddr);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.comboGeneralLPTAddr);
            this.grpGeneralHardwareSDR1000.Controls.Add(this.comboGeneralXVTR);
            this.grpGeneralHardwareSDR1000.Location = new System.Drawing.Point(160, 8);
            this.grpGeneralHardwareSDR1000.Name = "grpGeneralHardwareSDR1000";
            this.grpGeneralHardwareSDR1000.Size = new System.Drawing.Size(160, 248);
            this.grpGeneralHardwareSDR1000.TabIndex = 1;
            this.grpGeneralHardwareSDR1000.TabStop = false;
            this.grpGeneralHardwareSDR1000.Text = "SDR-1000 Config";
            // 
            // lblFlexControlRev1K
            // 
            this.lblFlexControlRev1K.Image = null;
            this.lblFlexControlRev1K.Location = new System.Drawing.Point(13, 220);
            this.lblFlexControlRev1K.Name = "lblFlexControlRev1K";
            this.lblFlexControlRev1K.Size = new System.Drawing.Size(136, 16);
            this.lblFlexControlRev1K.TabIndex = 30;
            this.lblFlexControlRev1K.Text = "FlexControl: v0.2.0.9";
            this.lblFlexControlRev1K.Visible = false;
            // 
            // chkEnableRFEPATR
            // 
            this.chkEnableRFEPATR.Image = null;
            this.chkEnableRFEPATR.Location = new System.Drawing.Point(16, 192);
            this.chkEnableRFEPATR.Name = "chkEnableRFEPATR";
            this.chkEnableRFEPATR.Size = new System.Drawing.Size(120, 16);
            this.chkEnableRFEPATR.TabIndex = 12;
            this.chkEnableRFEPATR.Text = "Enable RFE PA TR";
            this.toolTip1.SetToolTip(this.chkEnableRFEPATR, "Enabled the RFE PA TR line to toggle with MOX (for use with non-FLEX PA).");
            this.chkEnableRFEPATR.CheckedChanged += new System.EventHandler(this.chkEnableRFEPATR_CheckedChanged);
            // 
            // chkGeneralUSBPresent
            // 
            this.chkGeneralUSBPresent.Image = null;
            this.chkGeneralUSBPresent.Location = new System.Drawing.Point(16, 88);
            this.chkGeneralUSBPresent.Name = "chkGeneralUSBPresent";
            this.chkGeneralUSBPresent.Size = new System.Drawing.Size(96, 16);
            this.chkGeneralUSBPresent.TabIndex = 10;
            this.chkGeneralUSBPresent.Text = "USB Adapter";
            this.toolTip1.SetToolTip(this.chkGeneralUSBPresent, "Check if the USB adapter is being used.");
            this.chkGeneralUSBPresent.CheckedChanged += new System.EventHandler(this.chkGeneralUSBPresent_CheckedChanged);
            // 
            // chkGeneralATUPresent
            // 
            this.chkGeneralATUPresent.Image = null;
            this.chkGeneralATUPresent.Location = new System.Drawing.Point(16, 120);
            this.chkGeneralATUPresent.Name = "chkGeneralATUPresent";
            this.chkGeneralATUPresent.Size = new System.Drawing.Size(88, 16);
            this.chkGeneralATUPresent.TabIndex = 9;
            this.chkGeneralATUPresent.Text = "ATU Present";
            this.toolTip1.SetToolTip(this.chkGeneralATUPresent, "Check if integrated LDG Z-100 is installed.");
            this.chkGeneralATUPresent.Visible = false;
            this.chkGeneralATUPresent.CheckedChanged += new System.EventHandler(this.chkGeneralATUPresent_CheckedChanged);
            // 
            // chkGeneralPAPresent
            // 
            this.chkGeneralPAPresent.Image = null;
            this.chkGeneralPAPresent.Location = new System.Drawing.Point(16, 104);
            this.chkGeneralPAPresent.Name = "chkGeneralPAPresent";
            this.chkGeneralPAPresent.Size = new System.Drawing.Size(88, 16);
            this.chkGeneralPAPresent.TabIndex = 8;
            this.chkGeneralPAPresent.Text = "PA Present";
            this.toolTip1.SetToolTip(this.chkGeneralPAPresent, "Check if FlexRadio Systems 100W PA is installed.");
            this.chkGeneralPAPresent.CheckedChanged += new System.EventHandler(this.chkGeneralPAPresent_CheckedChanged);
            // 
            // chkGeneralXVTRPresent
            // 
            this.chkGeneralXVTRPresent.Image = null;
            this.chkGeneralXVTRPresent.Location = new System.Drawing.Point(16, 136);
            this.chkGeneralXVTRPresent.Name = "chkGeneralXVTRPresent";
            this.chkGeneralXVTRPresent.Size = new System.Drawing.Size(104, 16);
            this.chkGeneralXVTRPresent.TabIndex = 7;
            this.chkGeneralXVTRPresent.Text = "XVTR Present";
            this.toolTip1.SetToolTip(this.chkGeneralXVTRPresent, "Check if DEMI XVTR is installed.");
            this.chkGeneralXVTRPresent.CheckedChanged += new System.EventHandler(this.chkXVTRPresent_CheckedChanged);
            // 
            // lblGeneralLPTDelay
            // 
            this.lblGeneralLPTDelay.Image = null;
            this.lblGeneralLPTDelay.Location = new System.Drawing.Point(16, 56);
            this.lblGeneralLPTDelay.Name = "lblGeneralLPTDelay";
            this.lblGeneralLPTDelay.Size = new System.Drawing.Size(80, 16);
            this.lblGeneralLPTDelay.TabIndex = 6;
            this.lblGeneralLPTDelay.Text = "LPT Delay:";
            // 
            // udGeneralLPTDelay
            // 
            this.udGeneralLPTDelay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udGeneralLPTDelay.Location = new System.Drawing.Point(96, 56);
            this.udGeneralLPTDelay.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udGeneralLPTDelay.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udGeneralLPTDelay.Name = "udGeneralLPTDelay";
            this.udGeneralLPTDelay.Size = new System.Drawing.Size(56, 20);
            this.udGeneralLPTDelay.TabIndex = 5;
            this.toolTip1.SetToolTip(this.udGeneralLPTDelay, "Delay to compensate for longer Parallel cables.");
            this.udGeneralLPTDelay.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udGeneralLPTDelay.ValueChanged += new System.EventHandler(this.udGeneralLPTDelay_ValueChanged);
            this.udGeneralLPTDelay.LostFocus += new System.EventHandler(this.udGeneralLPTDelay_LostFocus);
            // 
            // lblGeneralLPTAddr
            // 
            this.lblGeneralLPTAddr.Image = null;
            this.lblGeneralLPTAddr.Location = new System.Drawing.Point(16, 24);
            this.lblGeneralLPTAddr.Name = "lblGeneralLPTAddr";
            this.lblGeneralLPTAddr.Size = new System.Drawing.Size(80, 16);
            this.lblGeneralLPTAddr.TabIndex = 3;
            this.lblGeneralLPTAddr.Text = "LPT Address:";
            // 
            // comboGeneralLPTAddr
            // 
            this.comboGeneralLPTAddr.DropDownWidth = 56;
            this.comboGeneralLPTAddr.Items.AddRange(new object[] {
            "278",
            "378",
            "3BC",
            "B800",
            "BC00"});
            this.comboGeneralLPTAddr.Location = new System.Drawing.Point(96, 24);
            this.comboGeneralLPTAddr.Name = "comboGeneralLPTAddr";
            this.comboGeneralLPTAddr.Size = new System.Drawing.Size(56, 21);
            this.comboGeneralLPTAddr.TabIndex = 0;
            this.comboGeneralLPTAddr.Text = "378";
            this.toolTip1.SetToolTip(this.comboGeneralLPTAddr, "Parallel Port Address");
            this.comboGeneralLPTAddr.SelectedIndexChanged += new System.EventHandler(this.comboGeneralLPTAddr_SelectedIndexChanged);
            this.comboGeneralLPTAddr.KeyDown += new System.Windows.Forms.KeyEventHandler(this.comboGeneralLPTAddr_KeyDown);
            this.comboGeneralLPTAddr.LostFocus += new System.EventHandler(this.comboGeneralLPTAddr_LostFocus);
            // 
            // comboGeneralXVTR
            // 
            this.comboGeneralXVTR.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboGeneralXVTR.DropDownWidth = 136;
            this.comboGeneralXVTR.Items.AddRange(new object[] {
            "Negative TR Logic",
            "Positive TR Logic",
            "No TR Logic"});
            this.comboGeneralXVTR.Location = new System.Drawing.Point(16, 160);
            this.comboGeneralXVTR.Name = "comboGeneralXVTR";
            this.comboGeneralXVTR.Size = new System.Drawing.Size(136, 21);
            this.comboGeneralXVTR.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboGeneralXVTR, "XVTR TR Logic Selection -- Negative for XVTR FlexRadio Systems provides.  Positiv" +
        "e for 25W version.  No TR logic for other XVTRs.");
            this.comboGeneralXVTR.Visible = false;
            this.comboGeneralXVTR.SelectedIndexChanged += new System.EventHandler(this.comboGeneralXVTR_SelectedIndexChanged);
            // 
            // labelTS31
            // 
            this.labelTS31.Image = null;
            this.labelTS31.Location = new System.Drawing.Point(525, 190);
            this.labelTS31.Name = "labelTS31";
            this.labelTS31.Size = new System.Drawing.Size(52, 20);
            this.labelTS31.TabIndex = 32;
            this.labelTS31.Text = "mSec";
            // 
            // udPTTHT
            // 
            this.udPTTHT.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udPTTHT.Location = new System.Drawing.Point(460, 188);
            this.udPTTHT.Maximum = new decimal(new int[] {
            999,
            0,
            0,
            0});
            this.udPTTHT.Minimum = new decimal(new int[] {
            30,
            0,
            0,
            0});
            this.udPTTHT.Name = "udPTTHT";
            this.udPTTHT.Size = new System.Drawing.Size(62, 20);
            this.udPTTHT.TabIndex = 31;
            this.toolTip1.SetToolTip(this.udPTTHT, "The PTT delays release for set period of Time (in milliseconds) for the MIC, Rear" +
        " PTT, or CAT commands.\r\nMOX and VOX are unaffected.");
            this.udPTTHT.Value = new decimal(new int[] {
            150,
            0,
            0,
            0});
            this.udPTTHT.ValueChanged += new System.EventHandler(this.udPTTHT_ValueChanged);
            // 
            // chkBoxPTTHT
            // 
            this.chkBoxPTTHT.Image = null;
            this.chkBoxPTTHT.Location = new System.Drawing.Point(336, 186);
            this.chkBoxPTTHT.Name = "chkBoxPTTHT";
            this.chkBoxPTTHT.Size = new System.Drawing.Size(118, 22);
            this.chkBoxPTTHT.TabIndex = 30;
            this.chkBoxPTTHT.Text = "PTT Hang Timer";
            this.toolTip1.SetToolTip(this.chkBoxPTTHT, "When Checked:  The PTT delays release for set period of Time (in milliseconds) fo" +
        "r the MIC, Rear PTT, or CAT commands.\r\nMOX and VOX are unaffected.");
            this.chkBoxPTTHT.CheckedChanged += new System.EventHandler(this.chkBoxPTTHT_CheckedChanged);
            // 
            // textBoxTOT
            // 
            this.textBoxTOT.Location = new System.Drawing.Point(446, 216);
            this.textBoxTOT.MaxLength = 50;
            this.textBoxTOT.Name = "textBoxTOT";
            this.textBoxTOT.ReadOnly = true;
            this.textBoxTOT.Size = new System.Drawing.Size(76, 20);
            this.textBoxTOT.TabIndex = 29;
            this.toolTip1.SetToolTip(this.textBoxTOT, "ToT Status");
            // 
            // labelTS23
            // 
            this.labelTS23.Image = null;
            this.labelTS23.Location = new System.Drawing.Point(404, 239);
            this.labelTS23.Name = "labelTS23";
            this.labelTS23.Size = new System.Drawing.Size(52, 23);
            this.labelTS23.TabIndex = 9;
            this.labelTS23.Text = "Seconds";
            // 
            // udTOT
            // 
            this.udTOT.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udTOT.Location = new System.Drawing.Point(336, 236);
            this.udTOT.Maximum = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udTOT.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udTOT.Name = "udTOT";
            this.udTOT.Size = new System.Drawing.Size(62, 20);
            this.udTOT.TabIndex = 9;
            this.toolTip1.SetToolTip(this.udTOT, "Transmitter will shut off and PowerSDR will go into STOP condition when the ToT M" +
        "ax Time is exceeded.\r\n(ToT Max Time in Seconds)\r\n");
            this.udTOT.Value = new decimal(new int[] {
            180,
            0,
            0,
            0});
            // 
            // chkBoxTOT
            // 
            this.chkBoxTOT.Checked = true;
            this.chkBoxTOT.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkBoxTOT.Image = null;
            this.chkBoxTOT.Location = new System.Drawing.Point(336, 218);
            this.chkBoxTOT.Name = "chkBoxTOT";
            this.chkBoxTOT.Size = new System.Drawing.Size(104, 16);
            this.chkBoxTOT.TabIndex = 28;
            this.chkBoxTOT.Text = "Time-Out Timer";
            this.toolTip1.SetToolTip(this.chkBoxTOT, "When Checked: Transmitter will shut off and PowerSDR will go into STOP condition " +
        "when the Time-Out-Timer Max Time setpoint is exceeded.");
            this.chkBoxTOT.CheckedChanged += new System.EventHandler(this.chkBoxTOT_CheckedChanged);
            // 
            // grpHWSoftRock
            // 
            this.grpHWSoftRock.Controls.Add(this.lblGenSoftRockCenterFreq);
            this.grpHWSoftRock.Controls.Add(this.udSoftRockCenterFreq);
            this.grpHWSoftRock.Location = new System.Drawing.Point(8, 140);
            this.grpHWSoftRock.Name = "grpHWSoftRock";
            this.grpHWSoftRock.Size = new System.Drawing.Size(144, 72);
            this.grpHWSoftRock.TabIndex = 26;
            this.grpHWSoftRock.TabStop = false;
            this.grpHWSoftRock.Text = "SoftRock Options";
            this.grpHWSoftRock.Visible = false;
            // 
            // lblGenSoftRockCenterFreq
            // 
            this.lblGenSoftRockCenterFreq.Image = null;
            this.lblGenSoftRockCenterFreq.Location = new System.Drawing.Point(16, 24);
            this.lblGenSoftRockCenterFreq.Name = "lblGenSoftRockCenterFreq";
            this.lblGenSoftRockCenterFreq.Size = new System.Drawing.Size(104, 16);
            this.lblGenSoftRockCenterFreq.TabIndex = 1;
            this.lblGenSoftRockCenterFreq.Text = "Center Freq (MHz):";
            // 
            // udSoftRockCenterFreq
            // 
            this.udSoftRockCenterFreq.DecimalPlaces = 6;
            this.udSoftRockCenterFreq.Increment = new decimal(new int[] {
            1,
            0,
            0,
            196608});
            this.udSoftRockCenterFreq.Location = new System.Drawing.Point(16, 40);
            this.udSoftRockCenterFreq.Maximum = new decimal(new int[] {
            65,
            0,
            0,
            0});
            this.udSoftRockCenterFreq.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udSoftRockCenterFreq.Name = "udSoftRockCenterFreq";
            this.udSoftRockCenterFreq.Size = new System.Drawing.Size(80, 20);
            this.udSoftRockCenterFreq.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udSoftRockCenterFreq, "Sets the center frequency for the SoftRock 40.");
            this.udSoftRockCenterFreq.Value = new decimal(new int[] {
            7056,
            0,
            0,
            196608});
            this.udSoftRockCenterFreq.ValueChanged += new System.EventHandler(this.udSoftRockCenterFreq_ValueChanged);
            this.udSoftRockCenterFreq.LostFocus += new System.EventHandler(this.udSoftRockCenterFreq_LostFocus);
            // 
            // grpGeneralDDS
            // 
            this.grpGeneralDDS.Controls.Add(this.chkGenDDSExpert);
            this.grpGeneralDDS.Controls.Add(this.udDDSCorrection);
            this.grpGeneralDDS.Controls.Add(this.lblClockCorrection);
            this.grpGeneralDDS.Controls.Add(this.udDDSIFFreq);
            this.grpGeneralDDS.Controls.Add(this.lblIFFrequency);
            this.grpGeneralDDS.Controls.Add(this.udDDSPLLMult);
            this.grpGeneralDDS.Controls.Add(this.lblPLLMult);
            this.grpGeneralDDS.Location = new System.Drawing.Point(333, 8);
            this.grpGeneralDDS.Name = "grpGeneralDDS";
            this.grpGeneralDDS.Size = new System.Drawing.Size(176, 136);
            this.grpGeneralDDS.TabIndex = 4;
            this.grpGeneralDDS.TabStop = false;
            this.grpGeneralDDS.Text = "DDS";
            // 
            // chkGenDDSExpert
            // 
            this.chkGenDDSExpert.Location = new System.Drawing.Point(56, 104);
            this.chkGenDDSExpert.Name = "chkGenDDSExpert";
            this.chkGenDDSExpert.Size = new System.Drawing.Size(56, 24);
            this.chkGenDDSExpert.TabIndex = 8;
            this.chkGenDDSExpert.Text = "Expert";
            this.chkGenDDSExpert.CheckedChanged += new System.EventHandler(this.chkGenDDSExpert_CheckedChanged);
            // 
            // udDDSCorrection
            // 
            this.udDDSCorrection.DecimalPlaces = 1;
            this.udDDSCorrection.Increment = new decimal(new int[] {
            5,
            0,
            0,
            65536});
            this.udDDSCorrection.Location = new System.Drawing.Point(104, 24);
            this.udDDSCorrection.Maximum = new decimal(new int[] {
            1000000,
            0,
            0,
            0});
            this.udDDSCorrection.Minimum = new decimal(new int[] {
            1000000,
            0,
            0,
            -2147483648});
            this.udDDSCorrection.Name = "udDDSCorrection";
            this.udDDSCorrection.Size = new System.Drawing.Size(64, 20);
            this.udDDSCorrection.TabIndex = 7;
            this.toolTip1.SetToolTip(this.udDDSCorrection, resources.GetString("udDDSCorrection.ToolTip"));
            this.udDDSCorrection.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDDSCorrection.Visible = false;
            this.udDDSCorrection.ValueChanged += new System.EventHandler(this.udDDSCorrection_ValueChanged);
            this.udDDSCorrection.LostFocus += new System.EventHandler(this.udDDSCorrection_LostFocus);
            // 
            // lblClockCorrection
            // 
            this.lblClockCorrection.Image = null;
            this.lblClockCorrection.Location = new System.Drawing.Point(16, 24);
            this.lblClockCorrection.Name = "lblClockCorrection";
            this.lblClockCorrection.Size = new System.Drawing.Size(72, 23);
            this.lblClockCorrection.TabIndex = 6;
            this.lblClockCorrection.Text = "Clock Offset:";
            this.toolTip1.SetToolTip(this.lblClockCorrection, resources.GetString("lblClockCorrection.ToolTip"));
            this.lblClockCorrection.Visible = false;
            // 
            // udDDSIFFreq
            // 
            this.udDDSIFFreq.DecimalPlaces = 1;
            this.udDDSIFFreq.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDDSIFFreq.Location = new System.Drawing.Point(104, 72);
            this.udDDSIFFreq.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udDDSIFFreq.Minimum = new decimal(new int[] {
            20000,
            0,
            0,
            -2147483648});
            this.udDDSIFFreq.Name = "udDDSIFFreq";
            this.udDDSIFFreq.Size = new System.Drawing.Size(64, 20);
            this.udDDSIFFreq.TabIndex = 5;
            this.toolTip1.SetToolTip(this.udDDSIFFreq, "Intermediate Frequency\r\nDefault Values:\r\nFlex-5000: 9000hz\r\nFlex-3000: 9000hz\r\nFl" +
        "ex-1500: 3800hz\r\n\r\nThis prevents a noise spike from occuring at 0hz every time y" +
        "ou unkey the radio\r\n");
            this.udDDSIFFreq.Value = new decimal(new int[] {
            9000,
            0,
            0,
            0});
            this.udDDSIFFreq.Visible = false;
            this.udDDSIFFreq.ValueChanged += new System.EventHandler(this.udDDSIFFreq_ValueChanged);
            this.udDDSIFFreq.LostFocus += new System.EventHandler(this.udDDSIFFreq_LostFocus);
            // 
            // lblIFFrequency
            // 
            this.lblIFFrequency.Image = null;
            this.lblIFFrequency.Location = new System.Drawing.Point(16, 72);
            this.lblIFFrequency.Name = "lblIFFrequency";
            this.lblIFFrequency.Size = new System.Drawing.Size(48, 23);
            this.lblIFFrequency.TabIndex = 4;
            this.lblIFFrequency.Text = "IF (Hz):";
            this.lblIFFrequency.Visible = false;
            // 
            // udDDSPLLMult
            // 
            this.udDDSPLLMult.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDDSPLLMult.Location = new System.Drawing.Point(120, 48);
            this.udDDSPLLMult.Maximum = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udDDSPLLMult.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDDSPLLMult.Name = "udDDSPLLMult";
            this.udDDSPLLMult.Size = new System.Drawing.Size(48, 20);
            this.udDDSPLLMult.TabIndex = 3;
            this.toolTip1.SetToolTip(this.udDDSPLLMult, "Multiplier for external clock (1 if using internal clock)");
            this.udDDSPLLMult.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDDSPLLMult.Visible = false;
            this.udDDSPLLMult.ValueChanged += new System.EventHandler(this.udDDSPLLMult_ValueChanged);
            this.udDDSPLLMult.LostFocus += new System.EventHandler(this.udDDSPLLMult_LostFocus);
            // 
            // lblPLLMult
            // 
            this.lblPLLMult.Image = null;
            this.lblPLLMult.Location = new System.Drawing.Point(16, 48);
            this.lblPLLMult.Name = "lblPLLMult";
            this.lblPLLMult.Size = new System.Drawing.Size(80, 23);
            this.lblPLLMult.TabIndex = 2;
            this.lblPLLMult.Text = "PLL Multiplier:";
            this.lblPLLMult.Visible = false;
            // 
            // grpGeneralModel
            // 
            this.grpGeneralModel.Controls.Add(this.radGenModelFLEX1500);
            this.grpGeneralModel.Controls.Add(this.radGenModelFLEX5000);
            this.grpGeneralModel.Controls.Add(this.radGenModelDemoNone);
            this.grpGeneralModel.Controls.Add(this.radGenModelSoftRock40);
            this.grpGeneralModel.Controls.Add(this.radGenModelSDR1000);
            this.grpGeneralModel.Location = new System.Drawing.Point(8, 8);
            this.grpGeneralModel.Name = "grpGeneralModel";
            this.grpGeneralModel.Size = new System.Drawing.Size(144, 128);
            this.grpGeneralModel.TabIndex = 25;
            this.grpGeneralModel.TabStop = false;
            this.grpGeneralModel.Text = "Radio Model";
            // 
            // radGenModelFLEX1500
            // 
            this.radGenModelFLEX1500.Image = null;
            this.radGenModelFLEX1500.Location = new System.Drawing.Point(16, 36);
            this.radGenModelFLEX1500.Name = "radGenModelFLEX1500";
            this.radGenModelFLEX1500.Size = new System.Drawing.Size(88, 24);
            this.radGenModelFLEX1500.TabIndex = 4;
            this.radGenModelFLEX1500.Text = "FLEX-1500";
            this.toolTip1.SetToolTip(this.radGenModelFLEX1500, "Select if using the FLEX-1500 Hardware");
            this.radGenModelFLEX1500.CheckedChanged += new System.EventHandler(this.radGenModelFLEX1500_CheckedChanged);
            // 
            // radGenModelFLEX5000
            // 
            this.radGenModelFLEX5000.Checked = true;
            this.radGenModelFLEX5000.Image = null;
            this.radGenModelFLEX5000.Location = new System.Drawing.Point(16, 16);
            this.radGenModelFLEX5000.Name = "radGenModelFLEX5000";
            this.radGenModelFLEX5000.Size = new System.Drawing.Size(88, 24);
            this.radGenModelFLEX5000.TabIndex = 3;
            this.radGenModelFLEX5000.TabStop = true;
            this.radGenModelFLEX5000.Text = "FLEX-5000";
            this.toolTip1.SetToolTip(this.radGenModelFLEX5000, "Select if using the FLEX-5000 Hardware");
            this.radGenModelFLEX5000.CheckedChanged += new System.EventHandler(this.radGenModelFLEX5000_CheckedChanged);
            // 
            // radGenModelDemoNone
            // 
            this.radGenModelDemoNone.Image = null;
            this.radGenModelDemoNone.Location = new System.Drawing.Point(16, 96);
            this.radGenModelDemoNone.Name = "radGenModelDemoNone";
            this.radGenModelDemoNone.Size = new System.Drawing.Size(88, 24);
            this.radGenModelDemoNone.TabIndex = 2;
            this.radGenModelDemoNone.Text = "Demo/None";
            this.toolTip1.SetToolTip(this.radGenModelDemoNone, "Select if using without any SDR hardware.");
            this.radGenModelDemoNone.CheckedChanged += new System.EventHandler(this.radGenModelDemoNone_CheckedChanged);
            // 
            // radGenModelSoftRock40
            // 
            this.radGenModelSoftRock40.Image = null;
            this.radGenModelSoftRock40.Location = new System.Drawing.Point(16, 76);
            this.radGenModelSoftRock40.Name = "radGenModelSoftRock40";
            this.radGenModelSoftRock40.Size = new System.Drawing.Size(88, 24);
            this.radGenModelSoftRock40.TabIndex = 1;
            this.radGenModelSoftRock40.Text = "Soft Rock 40";
            this.toolTip1.SetToolTip(this.radGenModelSoftRock40, "Select if using the SoftRock 40");
            this.radGenModelSoftRock40.Visible = false;
            this.radGenModelSoftRock40.CheckedChanged += new System.EventHandler(this.radGenModelSoftRock40_CheckedChanged);
            // 
            // radGenModelSDR1000
            // 
            this.radGenModelSDR1000.Image = null;
            this.radGenModelSDR1000.Location = new System.Drawing.Point(16, 56);
            this.radGenModelSDR1000.Name = "radGenModelSDR1000";
            this.radGenModelSDR1000.Size = new System.Drawing.Size(88, 24);
            this.radGenModelSDR1000.TabIndex = 0;
            this.radGenModelSDR1000.Text = "SDR-1000";
            this.toolTip1.SetToolTip(this.radGenModelSDR1000, "Select if using the SDR-1000 Hardware");
            this.radGenModelSDR1000.Visible = false;
            this.radGenModelSDR1000.CheckedChanged += new System.EventHandler(this.radGenModelSDR1000_CheckedChanged);
            // 
            // btnWizard
            // 
            this.btnWizard.Image = null;
            this.btnWizard.Location = new System.Drawing.Point(24, 214);
            this.btnWizard.Name = "btnWizard";
            this.btnWizard.Size = new System.Drawing.Size(75, 23);
            this.btnWizard.TabIndex = 22;
            this.btnWizard.Text = "Wizard...";
            this.toolTip1.SetToolTip(this.btnWizard, "Run the Startup Wizard.");
            this.btnWizard.Visible = false;
            this.btnWizard.Click += new System.EventHandler(this.btnWizard_Click);
            // 
            // chkGeneralRXOnly
            // 
            this.chkGeneralRXOnly.Image = null;
            this.chkGeneralRXOnly.Location = new System.Drawing.Point(336, 144);
            this.chkGeneralRXOnly.Name = "chkGeneralRXOnly";
            this.chkGeneralRXOnly.Size = new System.Drawing.Size(222, 44);
            this.chkGeneralRXOnly.TabIndex = 11;
            this.chkGeneralRXOnly.Text = "Receive Only.  But PTT performs a Start-Stop of the Receiver";
            this.toolTip1.SetToolTip(this.chkGeneralRXOnly, "Check to disable transmit functionality.\r\nBut Toggling PTT will Toggle the PowerS" +
        "DR Receiver ON/OFF");
            this.chkGeneralRXOnly.CheckedChanged += new System.EventHandler(this.chkGeneralRXOnly_CheckedChanged);
            // 
            // grpGeneralHardwareFLEX1500
            // 
            this.grpGeneralHardwareFLEX1500.Controls.Add(this.labelTS43);
            this.grpGeneralHardwareFLEX1500.Controls.Add(this.labelTS44);
            this.grpGeneralHardwareFLEX1500.Controls.Add(this.lblFlexControlRev1500);
            this.grpGeneralHardwareFLEX1500.Controls.Add(this.chkGenFLEX1500Xref);
            this.grpGeneralHardwareFLEX1500.Controls.Add(this.lbl1500FWRev);
            this.grpGeneralHardwareFLEX1500.Controls.Add(this.lbl1500PARev);
            this.grpGeneralHardwareFLEX1500.Controls.Add(this.lbl1500TRXRev);
            this.grpGeneralHardwareFLEX1500.Controls.Add(this.lbl1500SN);
            this.grpGeneralHardwareFLEX1500.Location = new System.Drawing.Point(160, 8);
            this.grpGeneralHardwareFLEX1500.Name = "grpGeneralHardwareFLEX1500";
            this.grpGeneralHardwareFLEX1500.Size = new System.Drawing.Size(160, 248);
            this.grpGeneralHardwareFLEX1500.TabIndex = 27;
            this.grpGeneralHardwareFLEX1500.TabStop = false;
            this.grpGeneralHardwareFLEX1500.Text = "FLEX-1500 Config";
            this.grpGeneralHardwareFLEX1500.Visible = false;
            // 
            // labelTS43
            // 
            this.labelTS43.Image = null;
            this.labelTS43.Location = new System.Drawing.Point(50, 120);
            this.labelTS43.Name = "labelTS43";
            this.labelTS43.Size = new System.Drawing.Size(104, 16);
            this.labelTS43.TabIndex = 33;
            this.labelTS43.Text = "v2.8.0.000";
            // 
            // labelTS44
            // 
            this.labelTS44.Image = null;
            this.labelTS44.Location = new System.Drawing.Point(6, 120);
            this.labelTS44.Name = "labelTS44";
            this.labelTS44.Size = new System.Drawing.Size(52, 16);
            this.labelTS44.TabIndex = 32;
            this.labelTS44.Text = "Soft ver:";
            // 
            // lblFlexControlRev1500
            // 
            this.lblFlexControlRev1500.Image = null;
            this.lblFlexControlRev1500.Location = new System.Drawing.Point(18, 96);
            this.lblFlexControlRev1500.Name = "lblFlexControlRev1500";
            this.lblFlexControlRev1500.Size = new System.Drawing.Size(136, 16);
            this.lblFlexControlRev1500.TabIndex = 31;
            this.lblFlexControlRev1500.Text = "FlexControl: v0.2.0.9";
            this.lblFlexControlRev1500.Visible = false;
            // 
            // chkGenFLEX1500Xref
            // 
            this.chkGenFLEX1500Xref.Image = null;
            this.chkGenFLEX1500Xref.Location = new System.Drawing.Point(16, 184);
            this.chkGenFLEX1500Xref.Name = "chkGenFLEX1500Xref";
            this.chkGenFLEX1500Xref.Size = new System.Drawing.Size(120, 16);
            this.chkGenFLEX1500Xref.TabIndex = 12;
            this.chkGenFLEX1500Xref.Text = "Use Ext. Ref Input";
            this.toolTip1.SetToolTip(this.chkGenFLEX1500Xref, "Check to use an externally supplied 10MHz clock with the FLEX-5000");
            this.chkGenFLEX1500Xref.CheckedChanged += new System.EventHandler(this.chkGenFLEX1500Xref_CheckedChanged);
            // 
            // lbl1500FWRev
            // 
            this.lbl1500FWRev.Image = null;
            this.lbl1500FWRev.Location = new System.Drawing.Point(18, 44);
            this.lbl1500FWRev.Name = "lbl1500FWRev";
            this.lbl1500FWRev.Size = new System.Drawing.Size(120, 16);
            this.lbl1500FWRev.TabIndex = 7;
            this.lbl1500FWRev.Text = "Firmware: 0.0.0.0";
            // 
            // lbl1500PARev
            // 
            this.lbl1500PARev.Image = null;
            this.lbl1500PARev.Location = new System.Drawing.Point(18, 80);
            this.lbl1500PARev.Name = "lbl1500PARev";
            this.lbl1500PARev.Size = new System.Drawing.Size(136, 16);
            this.lbl1500PARev.TabIndex = 3;
            this.lbl1500PARev.Text = "PA: 8888-8888 (8.8.8.8)";
            // 
            // lbl1500TRXRev
            // 
            this.lbl1500TRXRev.Image = null;
            this.lbl1500TRXRev.Location = new System.Drawing.Point(16, 64);
            this.lbl1500TRXRev.Name = "lbl1500TRXRev";
            this.lbl1500TRXRev.Size = new System.Drawing.Size(136, 16);
            this.lbl1500TRXRev.TabIndex = 2;
            this.lbl1500TRXRev.Text = "TRX: 8888-8888 (28F)";
            // 
            // lbl1500SN
            // 
            this.lbl1500SN.Image = null;
            this.lbl1500SN.Location = new System.Drawing.Point(18, 16);
            this.lbl1500SN.Name = "lbl1500SN";
            this.lbl1500SN.Size = new System.Drawing.Size(86, 16);
            this.lbl1500SN.TabIndex = 1;
            this.lbl1500SN.Text = "S/N: 0000-0000";
            // 
            // tpGeneralOptions
            // 
            this.tpGeneralOptions.BackColor = System.Drawing.SystemColors.Control;
            this.tpGeneralOptions.Controls.Add(this.chkPM2);
            this.tpGeneralOptions.Controls.Add(this.udPwrMstrCOM);
            this.tpGeneralOptions.Controls.Add(this.chkBoxWheelRev);
            this.tpGeneralOptions.Controls.Add(this.chkBoxPM1);
            this.tpGeneralOptions.Controls.Add(this.chkBoxIICON);
            this.tpGeneralOptions.Controls.Add(this.chkBoxIIC);
            this.tpGeneralOptions.Controls.Add(this.chkBoxVFOLockAB);
            this.tpGeneralOptions.Controls.Add(this.buttonTS2);
            this.tpGeneralOptions.Controls.Add(this.chkBoxBandStack);
            this.tpGeneralOptions.Controls.Add(this.chkGenOptionsShowATUPopup);
            this.tpGeneralOptions.Controls.Add(this.chkImportDBRestrict);
            this.tpGeneralOptions.Controls.Add(this.grpOptUSBBuf);
            this.tpGeneralOptions.Controls.Add(this.grpGenCustomTitleText);
            this.tpGeneralOptions.Controls.Add(this.grpOptMisc);
            this.tpGeneralOptions.Controls.Add(this.grpOptQuickQSY);
            this.tpGeneralOptions.Controls.Add(this.grpGenAutoMute);
            this.tpGeneralOptions.Controls.Add(this.grpGenTuningOptions);
            this.tpGeneralOptions.Controls.Add(this.grpGeneralOptions);
            this.tpGeneralOptions.Controls.Add(this.grpGeneralProcessPriority);
            this.tpGeneralOptions.Location = new System.Drawing.Point(4, 22);
            this.tpGeneralOptions.Name = "tpGeneralOptions";
            this.tpGeneralOptions.Size = new System.Drawing.Size(592, 318);
            this.tpGeneralOptions.TabIndex = 1;
            this.tpGeneralOptions.Text = "Options";
            // 
            // chkPM2
            // 
            this.chkPM2.AllowDrop = true;
            this.chkPM2.Image = null;
            this.chkPM2.Location = new System.Drawing.Point(245, 294);
            this.chkPM2.Name = "chkPM2";
            this.chkPM2.Size = new System.Drawing.Size(52, 18);
            this.chkPM2.TabIndex = 88;
            this.chkPM2.Text = "PM2";
            this.toolTip1.SetToolTip(this.chkPM2, "Check box if using PowerMaster II (instead of PowerMaster I)\r\n\r\nYou must configur" +
        "e your PowerMaster (via its menu) for 38400 baud\r\nand select a real COM port to " +
        "talk to the PowerMaster.\r\n");
            // 
            // udPwrMstrCOM
            // 
            this.udPwrMstrCOM.Increment = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udPwrMstrCOM.Location = new System.Drawing.Point(529, 294);
            this.udPwrMstrCOM.Maximum = new decimal(new int[] {
            9,
            0,
            0,
            0});
            this.udPwrMstrCOM.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPwrMstrCOM.Name = "udPwrMstrCOM";
            this.udPwrMstrCOM.Size = new System.Drawing.Size(37, 20);
            this.udPwrMstrCOM.TabIndex = 87;
            this.toolTip1.SetToolTip(this.udPwrMstrCOM, "PowerMaster Real physical COM port# 1-9\r\n\r\nYou must configure your PowerMaster (v" +
        "ia its menu) for 38400 baud\r\nand select a real COM port to talk to the PowerMast" +
        "er.\r\n");
            this.udPwrMstrCOM.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPwrMstrCOM.ValueChanged += new System.EventHandler(this.udPwrMstrCOM_ValueChanged);
            // 
            // chkBoxWheelRev
            // 
            this.chkBoxWheelRev.AllowDrop = true;
            this.chkBoxWheelRev.Image = null;
            this.chkBoxWheelRev.Location = new System.Drawing.Point(184, 250);
            this.chkBoxWheelRev.Name = "chkBoxWheelRev";
            this.chkBoxWheelRev.Size = new System.Drawing.Size(117, 18);
            this.chkBoxWheelRev.TabIndex = 63;
            this.chkBoxWheelRev.Text = "Wheel Reverse";
            this.toolTip1.SetToolTip(this.chkBoxWheelRev, "Reverse direction of mouse or trackball Wheel for freqency changes\r\n\r\n\r\n");
            // 
            // chkBoxPM1
            // 
            this.chkBoxPM1.AllowDrop = true;
            this.chkBoxPM1.Image = null;
            this.chkBoxPM1.Location = new System.Drawing.Point(303, 294);
            this.chkBoxPM1.Name = "chkBoxPM1";
            this.chkBoxPM1.Size = new System.Drawing.Size(220, 18);
            this.chkBoxPM1.TabIndex = 62;
            this.chkBoxPM1.Text = "Use PowerMaster for Watts and SWR";
            this.toolTip1.SetToolTip(this.chkBoxPM1, resources.GetString("chkBoxPM1.ToolTip"));
            this.chkBoxPM1.CheckedChanged += new System.EventHandler(this.chkBoxPwrMst_CheckedChanged);
            // 
            // chkBoxIICON
            // 
            this.chkBoxIICON.AllowDrop = true;
            this.chkBoxIICON.Image = null;
            this.chkBoxIICON.Location = new System.Drawing.Point(351, 272);
            this.chkBoxIICON.Name = "chkBoxIICON";
            this.chkBoxIICON.Size = new System.Drawing.Size(161, 18);
            this.chkBoxIICON.TabIndex = 61;
            this.chkBoxIICON.Text = "IIC FlexWire AMP ON/OFF";
            this.toolTip1.SetToolTip(this.chkBoxIICON, resources.GetString("chkBoxIICON.ToolTip"));
            this.chkBoxIICON.CheckedChanged += new System.EventHandler(this.chkBoxIICON_CheckedChanged);
            // 
            // chkBoxIIC
            // 
            this.chkBoxIIC.AllowDrop = true;
            this.chkBoxIIC.Image = null;
            this.chkBoxIIC.Location = new System.Drawing.Point(324, 250);
            this.chkBoxIIC.Name = "chkBoxIIC";
            this.chkBoxIIC.Size = new System.Drawing.Size(247, 25);
            this.chkBoxIIC.TabIndex = 59;
            this.chkBoxIIC.Text = "Use IIC FlexWire for External AMP control";
            this.toolTip1.SetToolTip(this.chkBoxIIC, resources.GetString("chkBoxIIC.ToolTip"));
            this.chkBoxIIC.CheckedChanged += new System.EventHandler(this.chkBoxIIC_CheckedChanged);
            // 
            // chkBoxVFOLockAB
            // 
            this.chkBoxVFOLockAB.AllowDrop = true;
            this.chkBoxVFOLockAB.Image = null;
            this.chkBoxVFOLockAB.Location = new System.Drawing.Point(184, 272);
            this.chkBoxVFOLockAB.Name = "chkBoxVFOLockAB";
            this.chkBoxVFOLockAB.Size = new System.Drawing.Size(117, 18);
            this.chkBoxVFOLockAB.TabIndex = 58;
            this.chkBoxVFOLockAB.Text = "VFO Lock A / B";
            this.toolTip1.SetToolTip(this.chkBoxVFOLockAB, "Check to allow VFO Lock button to toggle between VFOA, VFOAB, and VFOB Lock\r\n");
            // 
            // buttonTS2
            // 
            this.buttonTS2.Image = null;
            this.buttonTS2.Location = new System.Drawing.Point(17, 267);
            this.buttonTS2.Name = "buttonTS2";
            this.buttonTS2.Size = new System.Drawing.Size(117, 23);
            this.buttonTS2.TabIndex = 57;
            this.buttonTS2.Text = "Update BandText \r\n\r\nClick when you change TURF region for your Flex Radio\r\nOR the" +
    "re is a PowerSDR software update that contains changes or \r\nUpdates to the Band " +
    "Text";
            this.toolTip1.SetToolTip(this.buttonTS2, "Update the BandText found in your Database file to the BandText found in this ver" +
        "sion of PowerSDR, \r\nwithout having to do a Setup->Factory Defaults\r\n");
            this.buttonTS2.Click += new System.EventHandler(this.buttonTS2_Click);
            // 
            // chkBoxBandStack
            // 
            this.chkBoxBandStack.AllowDrop = true;
            this.chkBoxBandStack.Image = null;
            this.chkBoxBandStack.Location = new System.Drawing.Point(17, 296);
            this.chkBoxBandStack.Name = "chkBoxBandStack";
            this.chkBoxBandStack.Size = new System.Drawing.Size(161, 18);
            this.chkBoxBandStack.TabIndex = 33;
            this.chkBoxBandStack.Text = "Reset/Update Band Stack";
            this.toolTip1.SetToolTip(this.chkBoxBandStack, "When Checked and you \"Update BandText\", your BandStack will also reset to new Fac" +
        "tory Defaults.\r\n\r\nLeave UNCHECKED to preserve your current Band Stack when you \"" +
        "Update BandText\" \r\n");
            // 
            // chkGenOptionsShowATUPopup
            // 
            this.chkGenOptionsShowATUPopup.Image = null;
            this.chkGenOptionsShowATUPopup.Location = new System.Drawing.Point(174, 214);
            this.chkGenOptionsShowATUPopup.Name = "chkGenOptionsShowATUPopup";
            this.chkGenOptionsShowATUPopup.Size = new System.Drawing.Size(84, 34);
            this.chkGenOptionsShowATUPopup.TabIndex = 16;
            this.chkGenOptionsShowATUPopup.Text = "Show ATU Popup";
            this.toolTip1.SetToolTip(this.chkGenOptionsShowATUPopup, "Check this box to receive feedback popups when running the FLEX-3000 ATU");
            this.chkGenOptionsShowATUPopup.Visible = false;
            this.chkGenOptionsShowATUPopup.CheckedChanged += new System.EventHandler(this.chkGenOptionsShowATUPopup_CheckedChanged);
            // 
            // chkImportDBRestrict
            // 
            this.chkImportDBRestrict.AllowDrop = true;
            this.chkImportDBRestrict.Image = null;
            this.chkImportDBRestrict.Location = new System.Drawing.Point(17, 243);
            this.chkImportDBRestrict.Name = "chkImportDBRestrict";
            this.chkImportDBRestrict.Size = new System.Drawing.Size(187, 18);
            this.chkImportDBRestrict.TabIndex = 31;
            this.chkImportDBRestrict.Text = "Strict DB Import Compliance";
            this.toolTip1.SetToolTip(this.chkImportDBRestrict, "Uncheck this box to allow DB import using a DB from a earlier or later version of" +
        " PowerSDR.  May cause import errors");
            // 
            // grpOptUSBBuf
            // 
            this.grpOptUSBBuf.Controls.Add(this.lblOptUSBBufConservative);
            this.grpOptUSBBuf.Controls.Add(this.lblOptUSBBufAggressive);
            this.grpOptUSBBuf.Controls.Add(this.tbOptUSBBuf);
            this.grpOptUSBBuf.Location = new System.Drawing.Point(416, 8);
            this.grpOptUSBBuf.Name = "grpOptUSBBuf";
            this.grpOptUSBBuf.Size = new System.Drawing.Size(161, 98);
            this.grpOptUSBBuf.TabIndex = 30;
            this.grpOptUSBBuf.TabStop = false;
            this.grpOptUSBBuf.Text = "USB Driver Buffer";
            this.grpOptUSBBuf.Visible = false;
            // 
            // lblOptUSBBufConservative
            // 
            this.lblOptUSBBufConservative.AutoSize = true;
            this.lblOptUSBBufConservative.Image = null;
            this.lblOptUSBBufConservative.Location = new System.Drawing.Point(6, 59);
            this.lblOptUSBBufConservative.Name = "lblOptUSBBufConservative";
            this.lblOptUSBBufConservative.Size = new System.Drawing.Size(69, 13);
            this.lblOptUSBBufConservative.TabIndex = 2;
            this.lblOptUSBBufConservative.Text = "Conservative";
            // 
            // lblOptUSBBufAggressive
            // 
            this.lblOptUSBBufAggressive.AutoSize = true;
            this.lblOptUSBBufAggressive.Image = null;
            this.lblOptUSBBufAggressive.Location = new System.Drawing.Point(96, 59);
            this.lblOptUSBBufAggressive.Name = "lblOptUSBBufAggressive";
            this.lblOptUSBBufAggressive.Size = new System.Drawing.Size(59, 13);
            this.lblOptUSBBufAggressive.TabIndex = 1;
            this.lblOptUSBBufAggressive.Text = "Aggressive";
            // 
            // tbOptUSBBuf
            // 
            this.tbOptUSBBuf.LargeChange = 1;
            this.tbOptUSBBuf.Location = new System.Drawing.Point(22, 20);
            this.tbOptUSBBuf.Maximum = 4;
            this.tbOptUSBBuf.Name = "tbOptUSBBuf";
            this.tbOptUSBBuf.Size = new System.Drawing.Size(112, 45);
            this.tbOptUSBBuf.TabIndex = 0;
            this.tbOptUSBBuf.Value = 1;
            this.tbOptUSBBuf.Scroll += new System.EventHandler(this.tbOptUSBBuf_Scroll);
            // 
            // grpGenCustomTitleText
            // 
            this.grpGenCustomTitleText.Controls.Add(this.txtGenCustomTitle);
            this.grpGenCustomTitleText.Location = new System.Drawing.Point(416, 192);
            this.grpGenCustomTitleText.Name = "grpGenCustomTitleText";
            this.grpGenCustomTitleText.Size = new System.Drawing.Size(144, 56);
            this.grpGenCustomTitleText.TabIndex = 29;
            this.grpGenCustomTitleText.TabStop = false;
            this.grpGenCustomTitleText.Text = "Custom Title Text";
            // 
            // txtGenCustomTitle
            // 
            this.txtGenCustomTitle.Location = new System.Drawing.Point(16, 24);
            this.txtGenCustomTitle.MaxLength = 50;
            this.txtGenCustomTitle.Name = "txtGenCustomTitle";
            this.txtGenCustomTitle.Size = new System.Drawing.Size(112, 20);
            this.txtGenCustomTitle.TabIndex = 0;
            this.txtGenCustomTitle.TextChanged += new System.EventHandler(this.txtGenCustomTitle_TextChanged);
            // 
            // grpOptMisc
            // 
            this.grpOptMisc.Controls.Add(this.chkWheelTuneVFOB);
            this.grpOptMisc.Controls.Add(this.chkMouseTuneStep);
            this.grpOptMisc.Controls.Add(this.chkZeroBeatRIT);
            this.grpOptMisc.Controls.Add(this.chkSnapClickTune);
            this.grpOptMisc.Controls.Add(this.chkDisableToolTips);
            this.grpOptMisc.Controls.Add(this.chkOptAlwaysOnTop);
            this.grpOptMisc.Location = new System.Drawing.Point(264, 72);
            this.grpOptMisc.Name = "grpOptMisc";
            this.grpOptMisc.Size = new System.Drawing.Size(144, 176);
            this.grpOptMisc.TabIndex = 28;
            this.grpOptMisc.TabStop = false;
            this.grpOptMisc.Text = "Miscellaneous";
            // 
            // chkWheelTuneVFOB
            // 
            this.chkWheelTuneVFOB.Image = null;
            this.chkWheelTuneVFOB.Location = new System.Drawing.Point(16, 140);
            this.chkWheelTuneVFOB.Name = "chkWheelTuneVFOB";
            this.chkWheelTuneVFOB.Size = new System.Drawing.Size(122, 32);
            this.chkWheelTuneVFOB.TabIndex = 5;
            this.chkWheelTuneVFOB.Text = "Wheel Tunes VFOB (red x-hairs)";
            this.toolTip1.SetToolTip(this.chkWheelTuneVFOB, "When checked, the mouse wheel will tune VFO B when the red crosshairs are active." +
        "");
            this.chkWheelTuneVFOB.CheckedChanged += new System.EventHandler(this.chkWheelTuneVFOB_CheckedChanged);
            // 
            // chkMouseTuneStep
            // 
            this.chkMouseTuneStep.Image = null;
            this.chkMouseTuneStep.Location = new System.Drawing.Point(16, 120);
            this.chkMouseTuneStep.Name = "chkMouseTuneStep";
            this.chkMouseTuneStep.Size = new System.Drawing.Size(112, 16);
            this.chkMouseTuneStep.TabIndex = 4;
            this.chkMouseTuneStep.Text = "Mouse Tune Step";
            this.toolTip1.SetToolTip(this.chkMouseTuneStep, "When checked, the middle mouse button/wheel will cycle through the Tuning Steps.");
            this.chkMouseTuneStep.CheckedChanged += new System.EventHandler(this.chkMouseTuneStep_CheckedChanged);
            // 
            // chkZeroBeatRIT
            // 
            this.chkZeroBeatRIT.Image = null;
            this.chkZeroBeatRIT.Location = new System.Drawing.Point(16, 96);
            this.chkZeroBeatRIT.Name = "chkZeroBeatRIT";
            this.chkZeroBeatRIT.Size = new System.Drawing.Size(112, 16);
            this.chkZeroBeatRIT.TabIndex = 3;
            this.chkZeroBeatRIT.Text = "Zero Beat -  RIT";
            this.toolTip1.SetToolTip(this.chkZeroBeatRIT, "When checked, the zero beat function uses RIT instead of adjusting the VFO direct" +
        "ly.  This leaves the transmit frequency alone.");
            this.chkZeroBeatRIT.CheckedChanged += new System.EventHandler(this.chkZeroBeatRIT_CheckedChanged);
            // 
            // chkSnapClickTune
            // 
            this.chkSnapClickTune.Checked = true;
            this.chkSnapClickTune.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkSnapClickTune.Image = null;
            this.chkSnapClickTune.Location = new System.Drawing.Point(16, 72);
            this.chkSnapClickTune.Name = "chkSnapClickTune";
            this.chkSnapClickTune.Size = new System.Drawing.Size(112, 16);
            this.chkSnapClickTune.TabIndex = 2;
            this.chkSnapClickTune.Text = "Snap Click Tune";
            this.toolTip1.SetToolTip(this.chkSnapClickTune, "Forces the VFO to the closest tuning step when click tuning.");
            this.chkSnapClickTune.CheckedChanged += new System.EventHandler(this.chkSnapClickTune_CheckedChanged);
            // 
            // chkDisableToolTips
            // 
            this.chkDisableToolTips.Image = null;
            this.chkDisableToolTips.Location = new System.Drawing.Point(16, 48);
            this.chkDisableToolTips.Name = "chkDisableToolTips";
            this.chkDisableToolTips.Size = new System.Drawing.Size(112, 16);
            this.chkDisableToolTips.TabIndex = 1;
            this.chkDisableToolTips.Text = "Disable ToolTips";
            this.toolTip1.SetToolTip(this.chkDisableToolTips, "Check this box to hide all of the tooltips (including this one).");
            this.chkDisableToolTips.CheckedChanged += new System.EventHandler(this.chkDisableToolTips_CheckedChanged);
            // 
            // chkOptAlwaysOnTop
            // 
            this.chkOptAlwaysOnTop.Image = null;
            this.chkOptAlwaysOnTop.Location = new System.Drawing.Point(16, 24);
            this.chkOptAlwaysOnTop.Name = "chkOptAlwaysOnTop";
            this.chkOptAlwaysOnTop.Size = new System.Drawing.Size(104, 16);
            this.chkOptAlwaysOnTop.TabIndex = 0;
            this.chkOptAlwaysOnTop.Text = "Always On Top";
            this.toolTip1.SetToolTip(this.chkOptAlwaysOnTop, "Check this box to set the main console to always be on top (visible).");
            this.chkOptAlwaysOnTop.CheckedChanged += new System.EventHandler(this.chkOptAlwaysOnTop_CheckedChanged);
            // 
            // grpOptQuickQSY
            // 
            this.grpOptQuickQSY.Controls.Add(this.chkOptEnableKBShortcuts);
            this.grpOptQuickQSY.Controls.Add(this.chkOptQuickQSY);
            this.grpOptQuickQSY.Location = new System.Drawing.Point(416, 112);
            this.grpOptQuickQSY.Name = "grpOptQuickQSY";
            this.grpOptQuickQSY.Size = new System.Drawing.Size(128, 72);
            this.grpOptQuickQSY.TabIndex = 27;
            this.grpOptQuickQSY.TabStop = false;
            this.grpOptQuickQSY.Text = "Keyboard";
            // 
            // chkOptEnableKBShortcuts
            // 
            this.chkOptEnableKBShortcuts.Checked = true;
            this.chkOptEnableKBShortcuts.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkOptEnableKBShortcuts.Image = null;
            this.chkOptEnableKBShortcuts.Location = new System.Drawing.Point(16, 24);
            this.chkOptEnableKBShortcuts.Name = "chkOptEnableKBShortcuts";
            this.chkOptEnableKBShortcuts.Size = new System.Drawing.Size(109, 16);
            this.chkOptEnableKBShortcuts.TabIndex = 1;
            this.chkOptEnableKBShortcuts.Text = "Enable Shortcuts";
            this.toolTip1.SetToolTip(this.chkOptEnableKBShortcuts, "Enable keyboard shortcuts.  If this box is not checked, none of the keyboard shor" +
        "tcuts other than those that are built into windows will function.");
            this.chkOptEnableKBShortcuts.CheckedChanged += new System.EventHandler(this.chkOptEnableKBShortcuts_CheckedChanged);
            // 
            // chkOptQuickQSY
            // 
            this.chkOptQuickQSY.Checked = true;
            this.chkOptQuickQSY.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkOptQuickQSY.Image = null;
            this.chkOptQuickQSY.Location = new System.Drawing.Point(16, 48);
            this.chkOptQuickQSY.Name = "chkOptQuickQSY";
            this.chkOptQuickQSY.Size = new System.Drawing.Size(80, 16);
            this.chkOptQuickQSY.TabIndex = 0;
            this.chkOptQuickQSY.Text = "Quick QSY";
            this.toolTip1.SetToolTip(this.chkOptQuickQSY, "Enabled the Quick QSY feature -- directly enter the frequency in MHz while the ma" +
        "in form has the focus and hit enter.");
            this.chkOptQuickQSY.CheckedChanged += new System.EventHandler(this.chkOptQuickQSY_CheckedChanged);
            // 
            // grpGenAutoMute
            // 
            this.grpGenAutoMute.Controls.Add(this.chkGenAutoMute);
            this.grpGenAutoMute.Location = new System.Drawing.Point(158, 160);
            this.grpGenAutoMute.Name = "grpGenAutoMute";
            this.grpGenAutoMute.Size = new System.Drawing.Size(96, 48);
            this.grpGenAutoMute.TabIndex = 26;
            this.grpGenAutoMute.TabStop = false;
            this.grpGenAutoMute.Text = "Auto Mute";
            // 
            // chkGenAutoMute
            // 
            this.chkGenAutoMute.Image = null;
            this.chkGenAutoMute.Location = new System.Drawing.Point(16, 24);
            this.chkGenAutoMute.Name = "chkGenAutoMute";
            this.chkGenAutoMute.Size = new System.Drawing.Size(72, 16);
            this.chkGenAutoMute.TabIndex = 0;
            this.chkGenAutoMute.Text = "Enabled";
            this.toolTip1.SetToolTip(this.chkGenAutoMute, "Check this box to enable the software to poll Pin X2-12 to look for a signal to m" +
        "ute the radio.");
            this.chkGenAutoMute.CheckedChanged += new System.EventHandler(this.chkGenAutoMute_CheckedChanged);
            // 
            // grpGenTuningOptions
            // 
            this.grpGenTuningOptions.Controls.Add(this.udOptClickTuneOffsetDIGU);
            this.grpGenTuningOptions.Controls.Add(this.lblOptClickTuneDIGL);
            this.grpGenTuningOptions.Controls.Add(this.udOptClickTuneOffsetDIGL);
            this.grpGenTuningOptions.Controls.Add(this.lblOptClickTuneDIGU);
            this.grpGenTuningOptions.Location = new System.Drawing.Point(8, 160);
            this.grpGenTuningOptions.Name = "grpGenTuningOptions";
            this.grpGenTuningOptions.Size = new System.Drawing.Size(144, 80);
            this.grpGenTuningOptions.TabIndex = 25;
            this.grpGenTuningOptions.TabStop = false;
            this.grpGenTuningOptions.Text = "Click Tune / Filter Offsets";
            // 
            // udOptClickTuneOffsetDIGU
            // 
            this.udOptClickTuneOffsetDIGU.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udOptClickTuneOffsetDIGU.Location = new System.Drawing.Point(72, 24);
            this.udOptClickTuneOffsetDIGU.Maximum = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udOptClickTuneOffsetDIGU.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udOptClickTuneOffsetDIGU.Name = "udOptClickTuneOffsetDIGU";
            this.udOptClickTuneOffsetDIGU.Size = new System.Drawing.Size(56, 20);
            this.udOptClickTuneOffsetDIGU.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udOptClickTuneOffsetDIGU, "Determines the frequency offset for click tuning and \r\nthe RX filter\'s center fre" +
        "quency");
            this.udOptClickTuneOffsetDIGU.Value = new decimal(new int[] {
            1500,
            0,
            0,
            0});
            this.udOptClickTuneOffsetDIGU.ValueChanged += new System.EventHandler(this.udOptClickTuneOffsetDIGU_ValueChanged);
            this.udOptClickTuneOffsetDIGU.LostFocus += new System.EventHandler(this.udOptClickTuneOffsetDIGU_LostFocus);
            // 
            // lblOptClickTuneDIGL
            // 
            this.lblOptClickTuneDIGL.Image = null;
            this.lblOptClickTuneDIGL.Location = new System.Drawing.Point(6, 48);
            this.lblOptClickTuneDIGL.Name = "lblOptClickTuneDIGL";
            this.lblOptClickTuneDIGL.Size = new System.Drawing.Size(64, 23);
            this.lblOptClickTuneDIGL.TabIndex = 12;
            this.lblOptClickTuneDIGL.Text = "DIGL (Hz):";
            this.toolTip1.SetToolTip(this.lblOptClickTuneDIGL, "Determines the frequency offset for click tuning and \r\nthe RX filter\'s center fre" +
        "quency");
            // 
            // udOptClickTuneOffsetDIGL
            // 
            this.udOptClickTuneOffsetDIGL.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udOptClickTuneOffsetDIGL.Location = new System.Drawing.Point(72, 48);
            this.udOptClickTuneOffsetDIGL.Maximum = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udOptClickTuneOffsetDIGL.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udOptClickTuneOffsetDIGL.Name = "udOptClickTuneOffsetDIGL";
            this.udOptClickTuneOffsetDIGL.Size = new System.Drawing.Size(56, 20);
            this.udOptClickTuneOffsetDIGL.TabIndex = 11;
            this.toolTip1.SetToolTip(this.udOptClickTuneOffsetDIGL, "Determines the frequency offset for click tuning and \r\nthe RX filter\'s center fre" +
        "quency");
            this.udOptClickTuneOffsetDIGL.Value = new decimal(new int[] {
            2210,
            0,
            0,
            0});
            this.udOptClickTuneOffsetDIGL.ValueChanged += new System.EventHandler(this.udOptClickTuneOffsetDIGL_ValueChanged);
            this.udOptClickTuneOffsetDIGL.LostFocus += new System.EventHandler(this.udOptClickTuneOffsetDIGL_LostFocus);
            // 
            // lblOptClickTuneDIGU
            // 
            this.lblOptClickTuneDIGU.Image = null;
            this.lblOptClickTuneDIGU.Location = new System.Drawing.Point(6, 24);
            this.lblOptClickTuneDIGU.Name = "lblOptClickTuneDIGU";
            this.lblOptClickTuneDIGU.Size = new System.Drawing.Size(64, 23);
            this.lblOptClickTuneDIGU.TabIndex = 10;
            this.lblOptClickTuneDIGU.Text = "DIGU (Hz):";
            this.toolTip1.SetToolTip(this.lblOptClickTuneDIGU, "Determines the frequency offset for click tuning and \r\nthe RX filter\'s center fre" +
        "quency");
            // 
            // grpGeneralOptions
            // 
            this.grpGeneralOptions.Controls.Add(this.udGenTX1Delay);
            this.grpGeneralOptions.Controls.Add(this.chkSplitOffOnModeChange);
            this.grpGeneralOptions.Controls.Add(this.lblGenTX1Delay);
            this.grpGeneralOptions.Controls.Add(this.chkGenTX1Delay);
            this.grpGeneralOptions.Controls.Add(this.chkSplitOff);
            this.grpGeneralOptions.Controls.Add(this.chkGenAllModeMicPTT);
            this.grpGeneralOptions.Controls.Add(this.chkGeneralCustomFilter);
            this.grpGeneralOptions.Controls.Add(this.lblGeneralX2Delay);
            this.grpGeneralOptions.Controls.Add(this.udGeneralX2Delay);
            this.grpGeneralOptions.Controls.Add(this.chkGeneralEnableX2);
            this.grpGeneralOptions.Controls.Add(this.chkGeneralSoftwareGainCorr);
            this.grpGeneralOptions.Controls.Add(this.chkGeneralDisablePTT);
            this.grpGeneralOptions.Controls.Add(this.chkGeneralSpurRed);
            this.grpGeneralOptions.Location = new System.Drawing.Point(8, 8);
            this.grpGeneralOptions.Name = "grpGeneralOptions";
            this.grpGeneralOptions.Size = new System.Drawing.Size(248, 144);
            this.grpGeneralOptions.TabIndex = 6;
            this.grpGeneralOptions.TabStop = false;
            this.grpGeneralOptions.Text = "Options";
            // 
            // udGenTX1Delay
            // 
            this.udGenTX1Delay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udGenTX1Delay.Location = new System.Drawing.Point(184, 56);
            this.udGenTX1Delay.Maximum = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udGenTX1Delay.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udGenTX1Delay.Name = "udGenTX1Delay";
            this.udGenTX1Delay.Size = new System.Drawing.Size(48, 20);
            this.udGenTX1Delay.TabIndex = 15;
            this.udGenTX1Delay.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udGenTX1Delay.Visible = false;
            this.udGenTX1Delay.ValueChanged += new System.EventHandler(this.udGenTX1Delay_ValueChanged);
            // 
            // chkSplitOffOnModeChange
            // 
            this.chkSplitOffOnModeChange.Image = null;
            this.chkSplitOffOnModeChange.Location = new System.Drawing.Point(126, 80);
            this.chkSplitOffOnModeChange.Name = "chkSplitOffOnModeChange";
            this.chkSplitOffOnModeChange.Size = new System.Drawing.Size(104, 28);
            this.chkSplitOffOnModeChange.TabIndex = 32;
            this.chkSplitOffOnModeChange.Text = "Disable Split on Mode Change";
            this.toolTip1.SetToolTip(this.chkSplitOffOnModeChange, "Split will be disabled when mode is changed");
            this.chkSplitOffOnModeChange.CheckedChanged += new System.EventHandler(this.chkSplitOffOnModeChange_CheckedChanged);
            // 
            // lblGenTX1Delay
            // 
            this.lblGenTX1Delay.Image = null;
            this.lblGenTX1Delay.Location = new System.Drawing.Point(128, 48);
            this.lblGenTX1Delay.Name = "lblGenTX1Delay";
            this.lblGenTX1Delay.Size = new System.Drawing.Size(56, 26);
            this.lblGenTX1Delay.TabIndex = 14;
            this.lblGenTX1Delay.Text = "TX Out Delay:";
            this.lblGenTX1Delay.Visible = false;
            // 
            // chkGenTX1Delay
            // 
            this.chkGenTX1Delay.Checked = true;
            this.chkGenTX1Delay.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkGenTX1Delay.Image = null;
            this.chkGenTX1Delay.Location = new System.Drawing.Point(126, 20);
            this.chkGenTX1Delay.Name = "chkGenTX1Delay";
            this.chkGenTX1Delay.Size = new System.Drawing.Size(96, 32);
            this.chkGenTX1Delay.TabIndex = 13;
            this.chkGenTX1Delay.Text = "Enable TX Out Delay";
            this.toolTip1.SetToolTip(this.chkGenTX1Delay, "Check this box to delay after switching TX Out (before switch TR) with the value " +
        "set below.");
            this.chkGenTX1Delay.Visible = false;
            this.chkGenTX1Delay.CheckedChanged += new System.EventHandler(this.chkGenTX1Delay_CheckedChanged);
            // 
            // chkSplitOff
            // 
            this.chkSplitOff.Checked = true;
            this.chkSplitOff.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkSplitOff.Image = null;
            this.chkSplitOff.Location = new System.Drawing.Point(126, 109);
            this.chkSplitOff.Name = "chkSplitOff";
            this.chkSplitOff.Size = new System.Drawing.Size(104, 28);
            this.chkSplitOff.TabIndex = 12;
            this.chkSplitOff.Text = "Disable Split on Band Change";
            this.toolTip1.SetToolTip(this.chkSplitOff, "Split will be disabled when band is changed");
            this.chkSplitOff.CheckedChanged += new System.EventHandler(this.chkSplitOff_CheckedChanged);
            // 
            // chkGenAllModeMicPTT
            // 
            this.chkGenAllModeMicPTT.Checked = true;
            this.chkGenAllModeMicPTT.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkGenAllModeMicPTT.Image = null;
            this.chkGenAllModeMicPTT.Location = new System.Drawing.Point(16, 104);
            this.chkGenAllModeMicPTT.Name = "chkGenAllModeMicPTT";
            this.chkGenAllModeMicPTT.Size = new System.Drawing.Size(104, 32);
            this.chkGenAllModeMicPTT.TabIndex = 11;
            this.chkGenAllModeMicPTT.Text = "All Mode Mic PTT";
            this.toolTip1.SetToolTip(this.chkGenAllModeMicPTT, "If checked, the Mic PTT is no longer limited to just voice modes.");
            this.chkGenAllModeMicPTT.CheckedChanged += new System.EventHandler(this.chkGenAllModeMicPTT_CheckedChanged);
            // 
            // chkGeneralCustomFilter
            // 
            this.chkGeneralCustomFilter.Image = null;
            this.chkGeneralCustomFilter.Location = new System.Drawing.Point(128, 80);
            this.chkGeneralCustomFilter.Name = "chkGeneralCustomFilter";
            this.chkGeneralCustomFilter.Size = new System.Drawing.Size(104, 26);
            this.chkGeneralCustomFilter.TabIndex = 10;
            this.chkGeneralCustomFilter.Text = "Enable 300kHz Filter";
            this.toolTip1.SetToolTip(this.chkGeneralCustomFilter, "If the custom filter bank on the RFE is configured for 300kHz LPF, use this setti" +
        "ng.");
            this.chkGeneralCustomFilter.CheckedChanged += new System.EventHandler(this.chkGeneralCustomFilter_CheckedChanged);
            // 
            // lblGeneralX2Delay
            // 
            this.lblGeneralX2Delay.Image = null;
            this.lblGeneralX2Delay.Location = new System.Drawing.Point(128, 56);
            this.lblGeneralX2Delay.Name = "lblGeneralX2Delay";
            this.lblGeneralX2Delay.Size = new System.Drawing.Size(56, 23);
            this.lblGeneralX2Delay.TabIndex = 9;
            this.lblGeneralX2Delay.Text = "X2 Delay:";
            // 
            // udGeneralX2Delay
            // 
            this.udGeneralX2Delay.Enabled = false;
            this.udGeneralX2Delay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udGeneralX2Delay.Location = new System.Drawing.Point(184, 56);
            this.udGeneralX2Delay.Maximum = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udGeneralX2Delay.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udGeneralX2Delay.Name = "udGeneralX2Delay";
            this.udGeneralX2Delay.Size = new System.Drawing.Size(48, 20);
            this.udGeneralX2Delay.TabIndex = 8;
            this.toolTip1.SetToolTip(this.udGeneralX2Delay, "Sets the Delay on TR switching when the sequencing above is enabled.");
            this.udGeneralX2Delay.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udGeneralX2Delay.ValueChanged += new System.EventHandler(this.udGeneralX2Delay_ValueChanged);
            this.udGeneralX2Delay.LostFocus += new System.EventHandler(this.udGeneralX2Delay_LostFocus);
            // 
            // chkGeneralEnableX2
            // 
            this.chkGeneralEnableX2.Image = null;
            this.chkGeneralEnableX2.Location = new System.Drawing.Point(128, 20);
            this.chkGeneralEnableX2.Name = "chkGeneralEnableX2";
            this.chkGeneralEnableX2.Size = new System.Drawing.Size(96, 32);
            this.chkGeneralEnableX2.TabIndex = 7;
            this.chkGeneralEnableX2.Text = "Enable X2 TR Sequencing";
            this.toolTip1.SetToolTip(this.chkGeneralEnableX2, "Check this box to enable X2-7 TR sequencing using the delay set below.");
            this.chkGeneralEnableX2.CheckedChanged += new System.EventHandler(this.chkGeneralEnableX2_CheckedChanged);
            // 
            // chkGeneralSoftwareGainCorr
            // 
            this.chkGeneralSoftwareGainCorr.Image = null;
            this.chkGeneralSoftwareGainCorr.Location = new System.Drawing.Point(16, 72);
            this.chkGeneralSoftwareGainCorr.Name = "chkGeneralSoftwareGainCorr";
            this.chkGeneralSoftwareGainCorr.Size = new System.Drawing.Size(112, 32);
            this.chkGeneralSoftwareGainCorr.TabIndex = 6;
            this.chkGeneralSoftwareGainCorr.Text = "Disable Software Gain Correction";
            this.toolTip1.SetToolTip(this.chkGeneralSoftwareGainCorr, "Don\'t compensate in software for hardware gain or attenuation.");
            this.chkGeneralSoftwareGainCorr.CheckedChanged += new System.EventHandler(this.chkGeneralSoftwareGainCorr_CheckedChanged);
            // 
            // chkGeneralDisablePTT
            // 
            this.chkGeneralDisablePTT.Image = null;
            this.chkGeneralDisablePTT.Location = new System.Drawing.Point(16, 48);
            this.chkGeneralDisablePTT.Name = "chkGeneralDisablePTT";
            this.chkGeneralDisablePTT.Size = new System.Drawing.Size(104, 24);
            this.chkGeneralDisablePTT.TabIndex = 4;
            this.chkGeneralDisablePTT.Text = "Disable PTT";
            this.toolTip1.SetToolTip(this.chkGeneralDisablePTT, "Disable Push To Talk detection.");
            this.chkGeneralDisablePTT.CheckedChanged += new System.EventHandler(this.chkGeneralDisablePTT_CheckedChanged);
            // 
            // chkGeneralSpurRed
            // 
            this.chkGeneralSpurRed.Checked = true;
            this.chkGeneralSpurRed.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkGeneralSpurRed.Image = null;
            this.chkGeneralSpurRed.Location = new System.Drawing.Point(16, 24);
            this.chkGeneralSpurRed.Name = "chkGeneralSpurRed";
            this.chkGeneralSpurRed.Size = new System.Drawing.Size(104, 24);
            this.chkGeneralSpurRed.TabIndex = 3;
            this.chkGeneralSpurRed.Text = "Spur Reduction";
            this.toolTip1.SetToolTip(this.chkGeneralSpurRed, "Enable Spur Reduction/Avoidance Routine");
            this.chkGeneralSpurRed.CheckedChanged += new System.EventHandler(this.chkGeneralSpurRed_CheckedChanged);
            // 
            // grpGeneralProcessPriority
            // 
            this.grpGeneralProcessPriority.Controls.Add(this.comboGeneralProcessPriority);
            this.grpGeneralProcessPriority.Location = new System.Drawing.Point(264, 8);
            this.grpGeneralProcessPriority.Name = "grpGeneralProcessPriority";
            this.grpGeneralProcessPriority.Size = new System.Drawing.Size(144, 56);
            this.grpGeneralProcessPriority.TabIndex = 23;
            this.grpGeneralProcessPriority.TabStop = false;
            this.grpGeneralProcessPriority.Text = "Process Priority";
            // 
            // comboGeneralProcessPriority
            // 
            this.comboGeneralProcessPriority.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboGeneralProcessPriority.DropDownWidth = 112;
            this.comboGeneralProcessPriority.Items.AddRange(new object[] {
            "Idle",
            "Below Normal",
            "Normal",
            "Above Normal",
            "High",
            "Real Time"});
            this.comboGeneralProcessPriority.Location = new System.Drawing.Point(16, 24);
            this.comboGeneralProcessPriority.Name = "comboGeneralProcessPriority";
            this.comboGeneralProcessPriority.Size = new System.Drawing.Size(112, 21);
            this.comboGeneralProcessPriority.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboGeneralProcessPriority, "Sets the process priority of the PowerSDR software.");
            this.comboGeneralProcessPriority.SelectedIndexChanged += new System.EventHandler(this.comboGeneralProcessPriority_SelectedIndexChanged);
            // 
            // tpGeneralCalibration
            // 
            this.tpGeneralCalibration.BackColor = System.Drawing.SystemColors.Control;
            this.tpGeneralCalibration.Controls.Add(this.chkCalExpert);
            this.tpGeneralCalibration.Controls.Add(this.grpGenCalRXImage);
            this.tpGeneralCalibration.Controls.Add(this.grpGenCalLevel);
            this.tpGeneralCalibration.Controls.Add(this.grpGeneralCalibration);
            this.tpGeneralCalibration.Location = new System.Drawing.Point(4, 22);
            this.tpGeneralCalibration.Name = "tpGeneralCalibration";
            this.tpGeneralCalibration.Size = new System.Drawing.Size(592, 318);
            this.tpGeneralCalibration.TabIndex = 2;
            this.tpGeneralCalibration.Text = "Calibration";
            // 
            // chkCalExpert
            // 
            this.chkCalExpert.Location = new System.Drawing.Point(16, 136);
            this.chkCalExpert.Name = "chkCalExpert";
            this.chkCalExpert.Size = new System.Drawing.Size(56, 24);
            this.chkCalExpert.TabIndex = 10;
            this.chkCalExpert.Text = "Expert";
            this.chkCalExpert.Visible = false;
            this.chkCalExpert.CheckedChanged += new System.EventHandler(this.chkCalExpert_CheckedChanged);
            // 
            // grpGenCalRXImage
            // 
            this.grpGenCalRXImage.Controls.Add(this.udGeneralCalFreq3);
            this.grpGenCalRXImage.Controls.Add(this.lblGenCalRXImageFreq);
            this.grpGenCalRXImage.Controls.Add(this.btnGeneralCalImageStart);
            this.grpGenCalRXImage.Location = new System.Drawing.Point(360, 8);
            this.grpGenCalRXImage.Name = "grpGenCalRXImage";
            this.grpGenCalRXImage.Size = new System.Drawing.Size(168, 112);
            this.grpGenCalRXImage.TabIndex = 9;
            this.grpGenCalRXImage.TabStop = false;
            this.grpGenCalRXImage.Text = "RX Image Reject Cal";
            // 
            // udGeneralCalFreq3
            // 
            this.udGeneralCalFreq3.DecimalPlaces = 6;
            this.udGeneralCalFreq3.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udGeneralCalFreq3.Location = new System.Drawing.Point(80, 24);
            this.udGeneralCalFreq3.Maximum = new decimal(new int[] {
            65,
            0,
            0,
            0});
            this.udGeneralCalFreq3.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udGeneralCalFreq3.Name = "udGeneralCalFreq3";
            this.udGeneralCalFreq3.Size = new System.Drawing.Size(72, 20);
            this.udGeneralCalFreq3.TabIndex = 1;
            this.toolTip1.SetToolTip(this.udGeneralCalFreq3, "RX Image calibration reference frequency");
            this.udGeneralCalFreq3.Value = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udGeneralCalFreq3.LostFocus += new System.EventHandler(this.udGeneralCalFreq3_LostFocus);
            // 
            // lblGenCalRXImageFreq
            // 
            this.lblGenCalRXImageFreq.Image = null;
            this.lblGenCalRXImageFreq.Location = new System.Drawing.Point(16, 24);
            this.lblGenCalRXImageFreq.Name = "lblGenCalRXImageFreq";
            this.lblGenCalRXImageFreq.Size = new System.Drawing.Size(64, 23);
            this.lblGenCalRXImageFreq.TabIndex = 0;
            this.lblGenCalRXImageFreq.Text = "Frequency:";
            // 
            // btnGeneralCalImageStart
            // 
            this.btnGeneralCalImageStart.Image = null;
            this.btnGeneralCalImageStart.Location = new System.Drawing.Point(48, 80);
            this.btnGeneralCalImageStart.Name = "btnGeneralCalImageStart";
            this.btnGeneralCalImageStart.Size = new System.Drawing.Size(75, 23);
            this.btnGeneralCalImageStart.TabIndex = 7;
            this.btnGeneralCalImageStart.Text = "Start";
            this.toolTip1.SetToolTip(this.btnGeneralCalImageStart, "Click to start the RX Image rejection calibration using the above frequency refer" +
        "ence.");
            this.btnGeneralCalImageStart.Click += new System.EventHandler(this.btnGeneralCalImageStart_Click);
            // 
            // grpGenCalLevel
            // 
            this.grpGenCalLevel.Controls.Add(this.udGeneralCalLevel);
            this.grpGenCalLevel.Controls.Add(this.udGeneralCalFreq2);
            this.grpGenCalLevel.Controls.Add(this.lblGenCalLevelFreq);
            this.grpGenCalLevel.Controls.Add(this.lblGeneralCalLevel);
            this.grpGenCalLevel.Controls.Add(this.btnGeneralCalLevelStart);
            this.grpGenCalLevel.Location = new System.Drawing.Point(184, 8);
            this.grpGenCalLevel.Name = "grpGenCalLevel";
            this.grpGenCalLevel.Size = new System.Drawing.Size(168, 112);
            this.grpGenCalLevel.TabIndex = 8;
            this.grpGenCalLevel.TabStop = false;
            this.grpGenCalLevel.Text = "Level Cal";
            // 
            // udGeneralCalLevel
            // 
            this.udGeneralCalLevel.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udGeneralCalLevel.Location = new System.Drawing.Point(80, 48);
            this.udGeneralCalLevel.Maximum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udGeneralCalLevel.Minimum = new decimal(new int[] {
            150,
            0,
            0,
            -2147483648});
            this.udGeneralCalLevel.Name = "udGeneralCalLevel";
            this.udGeneralCalLevel.Size = new System.Drawing.Size(72, 20);
            this.udGeneralCalLevel.TabIndex = 3;
            this.toolTip1.SetToolTip(this.udGeneralCalLevel, "Level calibration reference level");
            this.udGeneralCalLevel.Value = new decimal(new int[] {
            70,
            0,
            0,
            -2147483648});
            this.udGeneralCalLevel.LostFocus += new System.EventHandler(this.udGeneralCalLevel_LostFocus);
            // 
            // udGeneralCalFreq2
            // 
            this.udGeneralCalFreq2.DecimalPlaces = 6;
            this.udGeneralCalFreq2.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udGeneralCalFreq2.Location = new System.Drawing.Point(80, 24);
            this.udGeneralCalFreq2.Maximum = new decimal(new int[] {
            65,
            0,
            0,
            0});
            this.udGeneralCalFreq2.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udGeneralCalFreq2.Name = "udGeneralCalFreq2";
            this.udGeneralCalFreq2.Size = new System.Drawing.Size(72, 20);
            this.udGeneralCalFreq2.TabIndex = 1;
            this.toolTip1.SetToolTip(this.udGeneralCalFreq2, "Level calibration reference frequency");
            this.udGeneralCalFreq2.Value = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udGeneralCalFreq2.LostFocus += new System.EventHandler(this.udGeneralCalFreq2_LostFocus);
            // 
            // lblGenCalLevelFreq
            // 
            this.lblGenCalLevelFreq.Image = null;
            this.lblGenCalLevelFreq.Location = new System.Drawing.Point(16, 24);
            this.lblGenCalLevelFreq.Name = "lblGenCalLevelFreq";
            this.lblGenCalLevelFreq.Size = new System.Drawing.Size(64, 23);
            this.lblGenCalLevelFreq.TabIndex = 0;
            this.lblGenCalLevelFreq.Text = "Frequency:";
            // 
            // lblGeneralCalLevel
            // 
            this.lblGeneralCalLevel.Image = null;
            this.lblGeneralCalLevel.Location = new System.Drawing.Point(16, 48);
            this.lblGeneralCalLevel.Name = "lblGeneralCalLevel";
            this.lblGeneralCalLevel.Size = new System.Drawing.Size(68, 23);
            this.lblGeneralCalLevel.TabIndex = 2;
            this.lblGeneralCalLevel.Text = "Level (dBm):";
            // 
            // btnGeneralCalLevelStart
            // 
            this.btnGeneralCalLevelStart.Image = null;
            this.btnGeneralCalLevelStart.Location = new System.Drawing.Point(48, 80);
            this.btnGeneralCalLevelStart.Name = "btnGeneralCalLevelStart";
            this.btnGeneralCalLevelStart.Size = new System.Drawing.Size(75, 23);
            this.btnGeneralCalLevelStart.TabIndex = 4;
            this.btnGeneralCalLevelStart.Text = "Start";
            this.toolTip1.SetToolTip(this.btnGeneralCalLevelStart, "Click to start the level calibration using the frequency and level references abo" +
        "ve.");
            this.btnGeneralCalLevelStart.Click += new System.EventHandler(this.btnGeneralCalLevelStart_Click);
            // 
            // grpGeneralCalibration
            // 
            this.grpGeneralCalibration.Controls.Add(this.btnGeneralCalFreqUseVFOA);
            this.grpGeneralCalibration.Controls.Add(this.btnGeneralCalFreqStart);
            this.grpGeneralCalibration.Controls.Add(this.udGeneralCalFreq1);
            this.grpGeneralCalibration.Controls.Add(this.lblGeneralCalFrequency);
            this.grpGeneralCalibration.Location = new System.Drawing.Point(8, 8);
            this.grpGeneralCalibration.Name = "grpGeneralCalibration";
            this.grpGeneralCalibration.Size = new System.Drawing.Size(168, 112);
            this.grpGeneralCalibration.TabIndex = 5;
            this.grpGeneralCalibration.TabStop = false;
            this.grpGeneralCalibration.Text = "Freq Cal";
            // 
            // btnGeneralCalFreqUseVFOA
            // 
            this.btnGeneralCalFreqUseVFOA.Image = null;
            this.btnGeneralCalFreqUseVFOA.Location = new System.Drawing.Point(48, 50);
            this.btnGeneralCalFreqUseVFOA.Name = "btnGeneralCalFreqUseVFOA";
            this.btnGeneralCalFreqUseVFOA.Size = new System.Drawing.Size(75, 23);
            this.btnGeneralCalFreqUseVFOA.TabIndex = 6;
            this.btnGeneralCalFreqUseVFOA.Text = "Use VFO-A";
            this.toolTip1.SetToolTip(this.btnGeneralCalFreqUseVFOA, "Click to use the current VFO-A frequency.  Must be 65 MHz or below.");
            this.btnGeneralCalFreqUseVFOA.Click += new System.EventHandler(this.btnGeneralCalFreqUseVFOA_Click);
            // 
            // btnGeneralCalFreqStart
            // 
            this.btnGeneralCalFreqStart.Image = null;
            this.btnGeneralCalFreqStart.Location = new System.Drawing.Point(48, 80);
            this.btnGeneralCalFreqStart.Name = "btnGeneralCalFreqStart";
            this.btnGeneralCalFreqStart.Size = new System.Drawing.Size(75, 23);
            this.btnGeneralCalFreqStart.TabIndex = 5;
            this.btnGeneralCalFreqStart.Text = "Start";
            this.toolTip1.SetToolTip(this.btnGeneralCalFreqStart, "Click to start the frequency calibration using the reference frequency above.");
            this.btnGeneralCalFreqStart.Click += new System.EventHandler(this.btnGeneralCalFreqStart_Click);
            // 
            // udGeneralCalFreq1
            // 
            this.udGeneralCalFreq1.DecimalPlaces = 6;
            this.udGeneralCalFreq1.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udGeneralCalFreq1.Location = new System.Drawing.Point(80, 24);
            this.udGeneralCalFreq1.Maximum = new decimal(new int[] {
            65,
            0,
            0,
            0});
            this.udGeneralCalFreq1.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udGeneralCalFreq1.Name = "udGeneralCalFreq1";
            this.udGeneralCalFreq1.Size = new System.Drawing.Size(72, 20);
            this.udGeneralCalFreq1.TabIndex = 1;
            this.toolTip1.SetToolTip(this.udGeneralCalFreq1, "Frequency calibration reference frequency");
            this.udGeneralCalFreq1.Value = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udGeneralCalFreq1.LostFocus += new System.EventHandler(this.udGeneralCalFreq1_LostFocus);
            // 
            // lblGeneralCalFrequency
            // 
            this.lblGeneralCalFrequency.Image = null;
            this.lblGeneralCalFrequency.Location = new System.Drawing.Point(16, 24);
            this.lblGeneralCalFrequency.Name = "lblGeneralCalFrequency";
            this.lblGeneralCalFrequency.Size = new System.Drawing.Size(64, 23);
            this.lblGeneralCalFrequency.TabIndex = 0;
            this.lblGeneralCalFrequency.Text = "Frequency:";
            // 
            // tpFilters
            // 
            this.tpFilters.BackColor = System.Drawing.SystemColors.Control;
            this.tpFilters.Controls.Add(this.grpOptFilterControls);
            this.tpFilters.Location = new System.Drawing.Point(4, 22);
            this.tpFilters.Name = "tpFilters";
            this.tpFilters.Size = new System.Drawing.Size(592, 318);
            this.tpFilters.TabIndex = 3;
            this.tpFilters.Text = "Filters";
            // 
            // grpOptFilterControls
            // 
            this.grpOptFilterControls.Controls.Add(this.chkOptCWFilterPitch);
            this.grpOptFilterControls.Controls.Add(this.udFilterDefaultLowCut);
            this.grpOptFilterControls.Controls.Add(this.lblDefaultLowCut);
            this.grpOptFilterControls.Controls.Add(this.udOptMaxFilterShift);
            this.grpOptFilterControls.Controls.Add(this.lblOptMaxFilterShift);
            this.grpOptFilterControls.Controls.Add(this.comboOptFilterWidthMode);
            this.grpOptFilterControls.Controls.Add(this.lblOptWidthSliderMode);
            this.grpOptFilterControls.Controls.Add(this.udOptMaxFilterWidth);
            this.grpOptFilterControls.Controls.Add(this.lblOptMaxFilter);
            this.grpOptFilterControls.Controls.Add(this.chkOptFilterSaveChanges);
            this.grpOptFilterControls.Location = new System.Drawing.Point(8, 8);
            this.grpOptFilterControls.Name = "grpOptFilterControls";
            this.grpOptFilterControls.Size = new System.Drawing.Size(217, 208);
            this.grpOptFilterControls.TabIndex = 29;
            this.grpOptFilterControls.TabStop = false;
            this.grpOptFilterControls.Text = "Filter Controls";
            // 
            // chkOptCWFilterPitch
            // 
            this.chkOptCWFilterPitch.Image = null;
            this.chkOptCWFilterPitch.Location = new System.Drawing.Point(14, 146);
            this.chkOptCWFilterPitch.Name = "chkOptCWFilterPitch";
            this.chkOptCWFilterPitch.Size = new System.Drawing.Size(178, 42);
            this.chkOptCWFilterPitch.TabIndex = 18;
            this.chkOptCWFilterPitch.Text = "CW RX Low-High Filters will not shift above/below CW Pitch.\r\n";
            this.toolTip1.SetToolTip(this.chkOptCWFilterPitch, resources.GetString("chkOptCWFilterPitch.ToolTip"));
            // 
            // udFilterDefaultLowCut
            // 
            this.udFilterDefaultLowCut.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udFilterDefaultLowCut.Location = new System.Drawing.Point(128, 120);
            this.udFilterDefaultLowCut.Maximum = new decimal(new int[] {
            500,
            0,
            0,
            0});
            this.udFilterDefaultLowCut.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udFilterDefaultLowCut.Name = "udFilterDefaultLowCut";
            this.udFilterDefaultLowCut.Size = new System.Drawing.Size(48, 20);
            this.udFilterDefaultLowCut.TabIndex = 17;
            this.toolTip1.SetToolTip(this.udFilterDefaultLowCut, "Sets the default low cut filter for filter changes");
            this.udFilterDefaultLowCut.Value = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udFilterDefaultLowCut.ValueChanged += new System.EventHandler(this.udFilterDefaultLowCut_ValueChanged);
            this.udFilterDefaultLowCut.LostFocus += new System.EventHandler(this.udFilterDefaultLowCut_LostFocus);
            // 
            // lblDefaultLowCut
            // 
            this.lblDefaultLowCut.Image = null;
            this.lblDefaultLowCut.Location = new System.Drawing.Point(16, 120);
            this.lblDefaultLowCut.Name = "lblDefaultLowCut";
            this.lblDefaultLowCut.Size = new System.Drawing.Size(120, 23);
            this.lblDefaultLowCut.TabIndex = 16;
            this.lblDefaultLowCut.Text = "Default Low Cut (Hz):";
            // 
            // udOptMaxFilterShift
            // 
            this.udOptMaxFilterShift.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udOptMaxFilterShift.Location = new System.Drawing.Point(128, 72);
            this.udOptMaxFilterShift.Maximum = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udOptMaxFilterShift.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udOptMaxFilterShift.Name = "udOptMaxFilterShift";
            this.udOptMaxFilterShift.Size = new System.Drawing.Size(66, 20);
            this.udOptMaxFilterShift.TabIndex = 13;
            this.toolTip1.SetToolTip(this.udOptMaxFilterShift, "Sets the maximum amount for the Shift control.  Set lower for finer resolution co" +
        "ntrol");
            this.udOptMaxFilterShift.Value = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udOptMaxFilterShift.ValueChanged += new System.EventHandler(this.udOptMaxFilterShift_ValueChanged);
            this.udOptMaxFilterShift.LostFocus += new System.EventHandler(this.udOptMaxFilterShift_LostFocus);
            // 
            // lblOptMaxFilterShift
            // 
            this.lblOptMaxFilterShift.Image = null;
            this.lblOptMaxFilterShift.Location = new System.Drawing.Point(16, 72);
            this.lblOptMaxFilterShift.Name = "lblOptMaxFilterShift";
            this.lblOptMaxFilterShift.Size = new System.Drawing.Size(120, 23);
            this.lblOptMaxFilterShift.TabIndex = 14;
            this.lblOptMaxFilterShift.Text = "Max Filter Shift (Hz):";
            // 
            // comboOptFilterWidthMode
            // 
            this.comboOptFilterWidthMode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboOptFilterWidthMode.DropDownWidth = 112;
            this.comboOptFilterWidthMode.Items.AddRange(new object[] {
            "Linear",
            "Log",
            "Log10"});
            this.comboOptFilterWidthMode.Location = new System.Drawing.Point(138, 48);
            this.comboOptFilterWidthMode.Name = "comboOptFilterWidthMode";
            this.comboOptFilterWidthMode.Size = new System.Drawing.Size(56, 21);
            this.comboOptFilterWidthMode.TabIndex = 12;
            this.toolTip1.SetToolTip(this.comboOptFilterWidthMode, "Sets the mapping for the filter width slider.");
            this.comboOptFilterWidthMode.SelectedIndexChanged += new System.EventHandler(this.comboOptFilterWidthMode_SelectedIndexChanged);
            // 
            // lblOptWidthSliderMode
            // 
            this.lblOptWidthSliderMode.Image = null;
            this.lblOptWidthSliderMode.Location = new System.Drawing.Point(16, 48);
            this.lblOptWidthSliderMode.Name = "lblOptWidthSliderMode";
            this.lblOptWidthSliderMode.Size = new System.Drawing.Size(104, 16);
            this.lblOptWidthSliderMode.TabIndex = 11;
            this.lblOptWidthSliderMode.Text = "Width Slider Mode:";
            // 
            // udOptMaxFilterWidth
            // 
            this.udOptMaxFilterWidth.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udOptMaxFilterWidth.Location = new System.Drawing.Point(128, 24);
            this.udOptMaxFilterWidth.Maximum = new decimal(new int[] {
            15000,
            0,
            0,
            0});
            this.udOptMaxFilterWidth.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udOptMaxFilterWidth.Name = "udOptMaxFilterWidth";
            this.udOptMaxFilterWidth.Size = new System.Drawing.Size(64, 20);
            this.udOptMaxFilterWidth.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udOptMaxFilterWidth, "Sets the maximum filter bandwidth");
            this.udOptMaxFilterWidth.Value = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udOptMaxFilterWidth.ValueChanged += new System.EventHandler(this.udOptMaxFilterWidth_ValueChanged);
            this.udOptMaxFilterWidth.LostFocus += new System.EventHandler(this.udOptMaxFilterWidth_LostFocus);
            // 
            // lblOptMaxFilter
            // 
            this.lblOptMaxFilter.Image = null;
            this.lblOptMaxFilter.Location = new System.Drawing.Point(16, 24);
            this.lblOptMaxFilter.Name = "lblOptMaxFilter";
            this.lblOptMaxFilter.Size = new System.Drawing.Size(120, 23);
            this.lblOptMaxFilter.TabIndex = 10;
            this.lblOptMaxFilter.Text = "Max Filter Width (Hz):";
            // 
            // chkOptFilterSaveChanges
            // 
            this.chkOptFilterSaveChanges.Checked = true;
            this.chkOptFilterSaveChanges.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkOptFilterSaveChanges.Image = null;
            this.chkOptFilterSaveChanges.Location = new System.Drawing.Point(16, 96);
            this.chkOptFilterSaveChanges.Name = "chkOptFilterSaveChanges";
            this.chkOptFilterSaveChanges.Size = new System.Drawing.Size(176, 16);
            this.chkOptFilterSaveChanges.TabIndex = 15;
            this.chkOptFilterSaveChanges.Text = "Save Slider/Display Changes";
            this.toolTip1.SetToolTip(this.chkOptFilterSaveChanges, "If checked, changes made to the filters via the display or sliders will be saved " +
        "in the Variable filter.");
            this.chkOptFilterSaveChanges.CheckedChanged += new System.EventHandler(this.chkOptFilterSaveChanges_CheckedChanged);
            // 
            // tpRX2
            // 
            this.tpRX2.BackColor = System.Drawing.SystemColors.Control;
            this.tpRX2.Controls.Add(this.richTextBox2);
            this.tpRX2.Controls.Add(this.richTextBox1);
            this.tpRX2.Controls.Add(this.chkRX2AutoVAC2);
            this.tpRX2.Controls.Add(this.chkRX2AutoOn);
            this.tpRX2.Controls.Add(this.chkRX2DisconnectOnTX);
            this.tpRX2.Controls.Add(this.chkRX2AutoMuteRX1OnVFOBTX);
            this.tpRX2.Controls.Add(this.chkRX2AutoMuteRX2OnVFOATX);
            this.tpRX2.Location = new System.Drawing.Point(4, 22);
            this.tpRX2.Name = "tpRX2";
            this.tpRX2.Size = new System.Drawing.Size(592, 318);
            this.tpRX2.TabIndex = 4;
            this.tpRX2.Text = "RX2";
            // 
            // richTextBox2
            // 
            this.richTextBox2.Location = new System.Drawing.Point(208, 10);
            this.richTextBox2.Name = "richTextBox2";
            this.richTextBox2.Size = new System.Drawing.Size(369, 98);
            this.richTextBox2.TabIndex = 6;
            this.richTextBox2.Text = resources.GetString("richTextBox2.Text");
            // 
            // richTextBox1
            // 
            this.richTextBox1.Location = new System.Drawing.Point(8, 151);
            this.richTextBox1.Name = "richTextBox1";
            this.richTextBox1.Size = new System.Drawing.Size(569, 53);
            this.richTextBox1.TabIndex = 5;
            this.richTextBox1.Text = resources.GetString("richTextBox1.Text");
            // 
            // chkRX2AutoVAC2
            // 
            this.chkRX2AutoVAC2.Image = null;
            this.chkRX2AutoVAC2.Location = new System.Drawing.Point(44, 222);
            this.chkRX2AutoVAC2.Name = "chkRX2AutoVAC2";
            this.chkRX2AutoVAC2.Size = new System.Drawing.Size(233, 32);
            this.chkRX2AutoVAC2.TabIndex = 4;
            this.chkRX2AutoVAC2.Text = "Turn ON VAC2 when RX2 turned ON";
            this.toolTip1.SetToolTip(this.chkRX2AutoVAC2, "When checked, will turn VAC2 ON/OFF with RX2 ON/OFF");
            // 
            // chkRX2AutoOn
            // 
            this.chkRX2AutoOn.Image = null;
            this.chkRX2AutoOn.Location = new System.Drawing.Point(8, 199);
            this.chkRX2AutoOn.Name = "chkRX2AutoOn";
            this.chkRX2AutoOn.Size = new System.Drawing.Size(457, 32);
            this.chkRX2AutoOn.TabIndex = 3;
            this.chkRX2AutoOn.Text = "Sending Spotter, Memory, or Scanner Freq to VFOB turns on RX2 automatically";
            this.toolTip1.SetToolTip(this.chkRX2AutoOn, "When checked, will turn RX2 ON when sending Frequency to VFOB");
            // 
            // chkRX2DisconnectOnTX
            // 
            this.chkRX2DisconnectOnTX.Checked = true;
            this.chkRX2DisconnectOnTX.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkRX2DisconnectOnTX.Image = null;
            this.chkRX2DisconnectOnTX.Location = new System.Drawing.Point(8, 68);
            this.chkRX2DisconnectOnTX.Name = "chkRX2DisconnectOnTX";
            this.chkRX2DisconnectOnTX.Size = new System.Drawing.Size(196, 24);
            this.chkRX2DisconnectOnTX.TabIndex = 2;
            this.chkRX2DisconnectOnTX.Text = "Disconnect RX2 RF Input on TX";
            this.toolTip1.SetToolTip(this.chkRX2DisconnectOnTX, "Disconnects the RX2 RF signal path when transmitting to prevent front-end overloa" +
        "d when checked.");
            this.chkRX2DisconnectOnTX.CheckedChanged += new System.EventHandler(this.chkRX2DisconnectOnTX_CheckedChanged);
            // 
            // chkRX2AutoMuteRX1OnVFOBTX
            // 
            this.chkRX2AutoMuteRX1OnVFOBTX.Checked = true;
            this.chkRX2AutoMuteRX1OnVFOBTX.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkRX2AutoMuteRX1OnVFOBTX.Image = null;
            this.chkRX2AutoMuteRX1OnVFOBTX.Location = new System.Drawing.Point(8, 38);
            this.chkRX2AutoMuteRX1OnVFOBTX.Name = "chkRX2AutoMuteRX1OnVFOBTX";
            this.chkRX2AutoMuteRX1OnVFOBTX.Size = new System.Drawing.Size(176, 24);
            this.chkRX2AutoMuteRX1OnVFOBTX.TabIndex = 1;
            this.chkRX2AutoMuteRX1OnVFOBTX.Text = "Auto Mute RX1 on VFO B TX";
            this.toolTip1.SetToolTip(this.chkRX2AutoMuteRX1OnVFOBTX, "Mutes RX1 when transmitting on VFO B when checked.  Uncheck to continue to hear R" +
        "X1 while operating with VFO B TX enabled");
            this.chkRX2AutoMuteRX1OnVFOBTX.CheckedChanged += new System.EventHandler(this.chkRX2AutoMuteRX1OnVFOBTX_CheckedChanged);
            // 
            // chkRX2AutoMuteRX2OnVFOATX
            // 
            this.chkRX2AutoMuteRX2OnVFOATX.Checked = true;
            this.chkRX2AutoMuteRX2OnVFOATX.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkRX2AutoMuteRX2OnVFOATX.Image = null;
            this.chkRX2AutoMuteRX2OnVFOATX.Location = new System.Drawing.Point(8, 8);
            this.chkRX2AutoMuteRX2OnVFOATX.Name = "chkRX2AutoMuteRX2OnVFOATX";
            this.chkRX2AutoMuteRX2OnVFOATX.Size = new System.Drawing.Size(176, 24);
            this.chkRX2AutoMuteRX2OnVFOATX.TabIndex = 0;
            this.chkRX2AutoMuteRX2OnVFOATX.Text = "Auto Mute RX2 on VFO A TX";
            this.toolTip1.SetToolTip(this.chkRX2AutoMuteRX2OnVFOATX, "Mutes RX2 when transmitting when checked.  Uncheck to monitor your transmit signa" +
        "l or other signals with RX2 while transmitting");
            this.chkRX2AutoMuteRX2OnVFOATX.CheckedChanged += new System.EventHandler(this.chkRX2AutoMuteRX2OnVFOATX_CheckedChanged);
            // 
            // tpGeneralNavigation
            // 
            this.tpGeneralNavigation.BackColor = System.Drawing.SystemColors.Control;
            this.tpGeneralNavigation.Controls.Add(this.grpOptSpaceNav);
            this.tpGeneralNavigation.Location = new System.Drawing.Point(4, 22);
            this.tpGeneralNavigation.Name = "tpGeneralNavigation";
            this.tpGeneralNavigation.Size = new System.Drawing.Size(592, 318);
            this.tpGeneralNavigation.TabIndex = 5;
            this.tpGeneralNavigation.Text = "Navigation";
            // 
            // grpOptSpaceNav
            // 
            this.grpOptSpaceNav.Controls.Add(this.textBox1);
            this.grpOptSpaceNav.Controls.Add(this.chkSpaceNavFlyPanadapter);
            this.grpOptSpaceNav.Controls.Add(this.chkSpaceNavControlVFOs);
            this.grpOptSpaceNav.Location = new System.Drawing.Point(3, 3);
            this.grpOptSpaceNav.Name = "grpOptSpaceNav";
            this.grpOptSpaceNav.Size = new System.Drawing.Size(399, 220);
            this.grpOptSpaceNav.TabIndex = 0;
            this.grpOptSpaceNav.TabStop = false;
            this.grpOptSpaceNav.Text = "Space Navigator";
            // 
            // textBox1
            // 
            this.textBox1.Location = new System.Drawing.Point(15, 67);
            this.textBox1.Multiline = true;
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(320, 132);
            this.textBox1.TabIndex = 2;
            this.textBox1.Text = "Twist controls VFOA(or if in split, VFOB)\r\nPush forward/ backward Zooms the panad" +
    "apter\r\nPush left / right Pans the panadapter\r\nPush up / down controls the filter" +
    " width";
            // 
            // chkSpaceNavFlyPanadapter
            // 
            this.chkSpaceNavFlyPanadapter.AutoSize = true;
            this.chkSpaceNavFlyPanadapter.Image = null;
            this.chkSpaceNavFlyPanadapter.Location = new System.Drawing.Point(6, 44);
            this.chkSpaceNavFlyPanadapter.Name = "chkSpaceNavFlyPanadapter";
            this.chkSpaceNavFlyPanadapter.Size = new System.Drawing.Size(109, 17);
            this.chkSpaceNavFlyPanadapter.TabIndex = 1;
            this.chkSpaceNavFlyPanadapter.Text = "Panadapter Flight";
            this.toolTip1.SetToolTip(this.chkSpaceNavFlyPanadapter, "Use the Tilt features to adjust the Pan Slider, Zoom Slider,and step size");
            this.chkSpaceNavFlyPanadapter.UseVisualStyleBackColor = true;
            // 
            // chkSpaceNavControlVFOs
            // 
            this.chkSpaceNavControlVFOs.AutoSize = true;
            this.chkSpaceNavControlVFOs.Checked = true;
            this.chkSpaceNavControlVFOs.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkSpaceNavControlVFOs.Image = null;
            this.chkSpaceNavControlVFOs.Location = new System.Drawing.Point(6, 21);
            this.chkSpaceNavControlVFOs.Name = "chkSpaceNavControlVFOs";
            this.chkSpaceNavControlVFOs.Size = new System.Drawing.Size(83, 17);
            this.chkSpaceNavControlVFOs.TabIndex = 0;
            this.chkSpaceNavControlVFOs.Text = "VFO Control";
            this.chkSpaceNavControlVFOs.UseVisualStyleBackColor = true;
            // 
            // tpUserInterface
            // 
            this.tpUserInterface.BackColor = System.Drawing.Color.Gray;
            this.tpUserInterface.Controls.Add(this.chkBoxHERO);
            this.tpUserInterface.Controls.Add(this.groupBox2);
            this.tpUserInterface.Controls.Add(this.groupBox1);
            this.tpUserInterface.Controls.Add(this.groupBoxTS1);
            this.tpUserInterface.Location = new System.Drawing.Point(4, 22);
            this.tpUserInterface.Name = "tpUserInterface";
            this.tpUserInterface.Size = new System.Drawing.Size(592, 318);
            this.tpUserInterface.TabIndex = 6;
            this.tpUserInterface.Text = "User Interface";
            // 
            // chkBoxHERO
            // 
            this.chkBoxHERO.Image = null;
            this.chkBoxHERO.Location = new System.Drawing.Point(134, 176);
            this.chkBoxHERO.Name = "chkBoxHERO";
            this.chkBoxHERO.Size = new System.Drawing.Size(205, 22);
            this.chkBoxHERO.TabIndex = 86;
            this.chkBoxHERO.Text = "I2C Band output (see tooltip)";
            this.toolTip1.SetToolTip(this.chkBoxHERO, resources.GetString("chkBoxHERO.ToolTip"));
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.checkBoxRX2);
            this.groupBox2.Controls.Add(this.labelTS39);
            this.groupBox2.Controls.Add(this.udN1MMfps);
            this.groupBox2.Controls.Add(this.labelTS29);
            this.groupBox2.Controls.Add(this.udN1MMscale);
            this.groupBox2.Controls.Add(this.labelTS27);
            this.groupBox2.Controls.Add(this.udN1MMport);
            this.groupBox2.Controls.Add(this.checkBoxN1MM);
            this.groupBox2.Controls.Add(this.checkBoxHTTP1);
            this.groupBox2.Controls.Add(this.chkBoxHttp2);
            this.groupBox2.Controls.Add(this.labelTS19);
            this.groupBox2.Controls.Add(this.udHttpRefresh);
            this.groupBox2.Controls.Add(this.txtHttpPass);
            this.groupBox2.Controls.Add(this.txtHttpUser);
            this.groupBox2.Controls.Add(this.labelTS18);
            this.groupBox2.Controls.Add(this.labelTS17);
            this.groupBox2.Controls.Add(this.labelTS16);
            this.groupBox2.Controls.Add(this.udHttpPort);
            this.groupBox2.Controls.Add(this.chkBoxHTTP);
            this.groupBox2.Location = new System.Drawing.Point(33, 204);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(521, 100);
            this.groupBox2.TabIndex = 54;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "HttpServer";
            // 
            // checkBoxRX2
            // 
            this.checkBoxRX2.Image = null;
            this.checkBoxRX2.Location = new System.Drawing.Point(464, 74);
            this.checkBoxRX2.Name = "checkBoxRX2";
            this.checkBoxRX2.Size = new System.Drawing.Size(56, 24);
            this.checkBoxRX2.TabIndex = 88;
            this.checkBoxRX2.Text = "RX2";
            this.toolTip1.SetToolTip(this.checkBoxRX2, "N1MM Spectrum data transmit\r\n\r\nRX2 sent to spectrum is checked, otherwise RX1\r\n\r\n" +
        "Or click on either RX1 or RX2 pan to select.");
            this.checkBoxRX2.Visible = false;
            this.checkBoxRX2.CheckedChanged += new System.EventHandler(this.checkBoxRX2_CheckedChanged);
            // 
            // labelTS39
            // 
            this.labelTS39.Image = null;
            this.labelTS39.Location = new System.Drawing.Point(264, 61);
            this.labelTS39.Name = "labelTS39";
            this.labelTS39.Size = new System.Drawing.Size(34, 16);
            this.labelTS39.TabIndex = 87;
            this.labelTS39.Text = "FPS:";
            // 
            // udN1MMfps
            // 
            this.udN1MMfps.Increment = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udN1MMfps.Location = new System.Drawing.Point(267, 76);
            this.udN1MMfps.Maximum = new decimal(new int[] {
            7,
            0,
            0,
            0});
            this.udN1MMfps.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udN1MMfps.Name = "udN1MMfps";
            this.udN1MMfps.Size = new System.Drawing.Size(48, 20);
            this.udN1MMfps.TabIndex = 86;
            this.toolTip1.SetToolTip(this.udN1MMfps, "N1MM Frames per second (fps) sent from PowerSDR to N1MM.\r\nSlow down the fps if yo" +
        "u find the N1MM Spectrum is freezing up.");
            this.udN1MMfps.Value = new decimal(new int[] {
            5,
            0,
            0,
            0});
            // 
            // labelTS29
            // 
            this.labelTS29.Image = null;
            this.labelTS29.Location = new System.Drawing.Point(332, 60);
            this.labelTS29.Name = "labelTS29";
            this.labelTS29.Size = new System.Drawing.Size(34, 16);
            this.labelTS29.TabIndex = 85;
            this.labelTS29.Text = "Scale:";
            // 
            // udN1MMscale
            // 
            this.udN1MMscale.DecimalPlaces = 2;
            this.udN1MMscale.Increment = new decimal(new int[] {
            1,
            0,
            0,
            131072});
            this.udN1MMscale.Location = new System.Drawing.Point(332, 76);
            this.udN1MMscale.Maximum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udN1MMscale.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            131072});
            this.udN1MMscale.Name = "udN1MMscale";
            this.udN1MMscale.Size = new System.Drawing.Size(53, 20);
            this.udN1MMscale.TabIndex = 81;
            this.toolTip1.SetToolTip(this.udN1MMscale, "Scale of the Panadapter Spectrum signal on the N1MM side");
            this.udN1MMscale.Value = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            // 
            // labelTS27
            // 
            this.labelTS27.Image = null;
            this.labelTS27.Location = new System.Drawing.Point(394, 60);
            this.labelTS27.Name = "labelTS27";
            this.labelTS27.Size = new System.Drawing.Size(34, 16);
            this.labelTS27.TabIndex = 84;
            this.labelTS27.Text = "Port:";
            // 
            // udN1MMport
            // 
            this.udN1MMport.Increment = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udN1MMport.Location = new System.Drawing.Point(397, 77);
            this.udN1MMport.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udN1MMport.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udN1MMport.Name = "udN1MMport";
            this.udN1MMport.Size = new System.Drawing.Size(61, 20);
            this.udN1MMport.TabIndex = 83;
            this.toolTip1.SetToolTip(this.udN1MMport, "N1MM default port# 13064 to UDP spectrum data\r\nvia localhost (127.0.0.1)");
            this.udN1MMport.Value = new decimal(new int[] {
            13064,
            0,
            0,
            0});
            // 
            // checkBoxN1MM
            // 
            this.checkBoxN1MM.Image = null;
            this.checkBoxN1MM.Location = new System.Drawing.Point(149, 72);
            this.checkBoxN1MM.Name = "checkBoxN1MM";
            this.checkBoxN1MM.Size = new System.Drawing.Size(112, 24);
            this.checkBoxN1MM.TabIndex = 82;
            this.checkBoxN1MM.Text = "N1MM Spectrum";
            this.toolTip1.SetToolTip(this.checkBoxN1MM, "N1MM Spectrum data transmit\r\n\r\nSelect a port#.\r\nPowerSDR communicates with N1MM l" +
        "ogger via localhost:port");
            this.checkBoxN1MM.CheckedChanged += new System.EventHandler(this.checkBoxN1MM_CheckedChanged);
            // 
            // checkBoxHTTP1
            // 
            this.checkBoxHTTP1.Image = null;
            this.checkBoxHTTP1.Location = new System.Drawing.Point(27, 38);
            this.checkBoxHTTP1.Name = "checkBoxHTTP1";
            this.checkBoxHTTP1.Size = new System.Drawing.Size(90, 24);
            this.checkBoxHTTP1.TabIndex = 81;
            this.checkBoxHTTP1.Text = "Full Console";
            this.toolTip1.SetToolTip(this.checkBoxHTTP1, "Hit F1 for more Help.\r\n\r\nWhen Basic is ON, you can transmit the full Console wind" +
        "ow or just the Panadapter area\r\n");
            // 
            // chkBoxHttp2
            // 
            this.chkBoxHttp2.Image = null;
            this.chkBoxHttp2.Location = new System.Drawing.Point(6, 68);
            this.chkBoxHttp2.Name = "chkBoxHttp2";
            this.chkBoxHttp2.Size = new System.Drawing.Size(105, 22);
            this.chkBoxHttp2.TabIndex = 14;
            this.chkBoxHttp2.Text = "On: Advanced";
            this.toolTip1.SetToolTip(this.chkBoxHttp2, "Check to turn ON/OFF Http Server.\r\n\r\nAdvanced: View Display and control Frequency" +
        ", Mode and Filter\r\n");
            this.chkBoxHttp2.CheckedChanged += new System.EventHandler(this.chkBoxHttp2_CheckedChanged);
            // 
            // labelTS19
            // 
            this.labelTS19.Image = null;
            this.labelTS19.Location = new System.Drawing.Point(192, 19);
            this.labelTS19.Name = "labelTS19";
            this.labelTS19.Size = new System.Drawing.Size(103, 16);
            this.labelTS19.TabIndex = 13;
            this.labelTS19.Text = "Refresh Rate (ms):";
            // 
            // udHttpRefresh
            // 
            this.udHttpRefresh.Increment = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udHttpRefresh.Location = new System.Drawing.Point(195, 37);
            this.udHttpRefresh.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this.udHttpRefresh.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udHttpRefresh.Name = "udHttpRefresh";
            this.udHttpRefresh.Size = new System.Drawing.Size(75, 20);
            this.udHttpRefresh.TabIndex = 12;
            this.udHttpRefresh.Value = new decimal(new int[] {
            400,
            0,
            0,
            0});
            // 
            // txtHttpPass
            // 
            this.txtHttpPass.Location = new System.Drawing.Point(396, 35);
            this.txtHttpPass.MaxLength = 50;
            this.txtHttpPass.Name = "txtHttpPass";
            this.txtHttpPass.Size = new System.Drawing.Size(90, 20);
            this.txtHttpPass.TabIndex = 11;
            this.txtHttpPass.Text = "powersdr";
            this.toolTip1.SetToolTip(this.txtHttpPass, "Select Password to login with Remotely");
            this.txtHttpPass.TextChanged += new System.EventHandler(this.txtHttpPass_TextChanged);
            this.txtHttpPass.MouseDown += new System.Windows.Forms.MouseEventHandler(this.txtHttpPass_MouseDown);
            // 
            // txtHttpUser
            // 
            this.txtHttpUser.Location = new System.Drawing.Point(298, 36);
            this.txtHttpUser.MaxLength = 50;
            this.txtHttpUser.Name = "txtHttpUser";
            this.txtHttpUser.Size = new System.Drawing.Size(90, 20);
            this.txtHttpUser.TabIndex = 10;
            this.txtHttpUser.Text = "powersdr";
            this.toolTip1.SetToolTip(this.txtHttpUser, "User Name to login with Remotely");
            this.txtHttpUser.TextChanged += new System.EventHandler(this.txtHttpUser_TextChanged);
            this.txtHttpUser.MouseDown += new System.Windows.Forms.MouseEventHandler(this.txtHttpUser_MouseDown);
            // 
            // labelTS18
            // 
            this.labelTS18.Image = null;
            this.labelTS18.Location = new System.Drawing.Point(396, 19);
            this.labelTS18.Name = "labelTS18";
            this.labelTS18.Size = new System.Drawing.Size(73, 16);
            this.labelTS18.TabIndex = 9;
            this.labelTS18.Text = "Password:";
            // 
            // labelTS17
            // 
            this.labelTS17.Image = null;
            this.labelTS17.Location = new System.Drawing.Point(301, 19);
            this.labelTS17.Name = "labelTS17";
            this.labelTS17.Size = new System.Drawing.Size(73, 16);
            this.labelTS17.TabIndex = 8;
            this.labelTS17.Text = "User Name:";
            // 
            // labelTS16
            // 
            this.labelTS16.Image = null;
            this.labelTS16.Location = new System.Drawing.Point(120, 19);
            this.labelTS16.Name = "labelTS16";
            this.labelTS16.Size = new System.Drawing.Size(34, 16);
            this.labelTS16.TabIndex = 7;
            this.labelTS16.Text = "Port:";
            // 
            // udHttpPort
            // 
            this.udHttpPort.Increment = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udHttpPort.Location = new System.Drawing.Point(123, 35);
            this.udHttpPort.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this.udHttpPort.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udHttpPort.Name = "udHttpPort";
            this.udHttpPort.Size = new System.Drawing.Size(54, 20);
            this.udHttpPort.TabIndex = 7;
            this.udHttpPort.Value = new decimal(new int[] {
            8081,
            0,
            0,
            0});
            this.udHttpPort.ValueChanged += new System.EventHandler(this.udHttpPort_ValueChanged);
            this.udHttpPort.MouseDown += new System.Windows.Forms.MouseEventHandler(this.udHttpPort_MouseDown);
            // 
            // chkBoxHTTP
            // 
            this.chkBoxHTTP.Image = null;
            this.chkBoxHTTP.Location = new System.Drawing.Point(6, 14);
            this.chkBoxHTTP.Name = "chkBoxHTTP";
            this.chkBoxHTTP.Size = new System.Drawing.Size(105, 24);
            this.chkBoxHTTP.TabIndex = 7;
            this.chkBoxHTTP.Text = "On: Basic (pan)";
            this.toolTip1.SetToolTip(this.chkBoxHTTP, resources.GetString("chkBoxHTTP.ToolTip"));
            this.chkBoxHTTP.CheckedChanged += new System.EventHandler(this.chkBoxHTTP_CheckedChanged);
            this.chkBoxHTTP.KeyDown += new System.Windows.Forms.KeyEventHandler(this.chkBoxHTTP_KeyDown);
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.labelTS30);
            this.groupBox1.Controls.Add(this.label1);
            this.groupBox1.Controls.Add(this.btnConfigure);
            this.groupBox1.Controls.Add(this.cbConsoleSelect);
            this.groupBox1.Location = new System.Drawing.Point(32, 11);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(307, 155);
            this.groupBox1.TabIndex = 3;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "DJ Console DH1TW 0.997 User Interface Controller";
            // 
            // labelTS30
            // 
            this.labelTS30.Image = null;
            this.labelTS30.Location = new System.Drawing.Point(20, 133);
            this.labelTS30.Name = "labelTS30";
            this.labelTS30.Size = new System.Drawing.Size(268, 16);
            this.labelTS30.TabIndex = 82;
            this.labelTS30.Text = "Supports Hercules MP3e2, MK2, MP3LE";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(20, 37);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(54, 13);
            this.label1.TabIndex = 6;
            this.label1.Text = "Controller:";
            // 
            // btnConfigure
            // 
            this.btnConfigure.BackColor = System.Drawing.SystemColors.ButtonFace;
            this.btnConfigure.Location = new System.Drawing.Point(23, 97);
            this.btnConfigure.Name = "btnConfigure";
            this.btnConfigure.Size = new System.Drawing.Size(272, 30);
            this.btnConfigure.TabIndex = 5;
            this.btnConfigure.Text = "Configure ";
            this.btnConfigure.UseVisualStyleBackColor = false;
            this.btnConfigure.Click += new System.EventHandler(this.btnConfigure_Click);
            // 
            // cbConsoleSelect
            // 
            this.cbConsoleSelect.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cbConsoleSelect.FormattingEnabled = true;
            this.cbConsoleSelect.Location = new System.Drawing.Point(80, 34);
            this.cbConsoleSelect.Name = "cbConsoleSelect";
            this.cbConsoleSelect.Size = new System.Drawing.Size(215, 21);
            this.cbConsoleSelect.TabIndex = 4;
            this.toolTip1.SetToolTip(this.cbConsoleSelect, "Supports Hercules MP3e2, MK2, MP3LE");
            // 
            // groupBoxTS1
            // 
            this.groupBoxTS1.Controls.Add(this.txtWheelTune9);
            this.groupBoxTS1.Controls.Add(this.txtWheelTune8);
            this.groupBoxTS1.Controls.Add(this.txtWheelTune7);
            this.groupBoxTS1.Controls.Add(this.txtWheelTune6);
            this.groupBoxTS1.Controls.Add(this.txtWheelTune5);
            this.groupBoxTS1.Controls.Add(this.txtWheelTune4);
            this.groupBoxTS1.Controls.Add(this.labelTS35);
            this.groupBoxTS1.Controls.Add(this.labelTS34);
            this.groupBoxTS1.Controls.Add(this.btnTuneStepChangeLarger3);
            this.groupBoxTS1.Controls.Add(this.btnTuneStepChangeSmaller3);
            this.groupBoxTS1.Controls.Add(this.txtWheelTune3);
            this.groupBoxTS1.Controls.Add(this.chkBoxIND2);
            this.groupBoxTS1.Controls.Add(this.labelTS26);
            this.groupBoxTS1.Controls.Add(this.btnTuneStepChangeLarger2);
            this.groupBoxTS1.Controls.Add(this.btnTuneStepChangeSmaller2);
            this.groupBoxTS1.Controls.Add(this.txtWheelTune2);
            this.groupBoxTS1.Controls.Add(this.chkBoxIND);
            this.groupBoxTS1.Controls.Add(this.labelTS15);
            this.groupBoxTS1.Controls.Add(this.chkBoxPM);
            this.groupBoxTS1.Controls.Add(this.udSpeedPM);
            this.groupBoxTS1.Location = new System.Drawing.Point(362, 11);
            this.groupBoxTS1.Name = "groupBoxTS1";
            this.groupBoxTS1.Size = new System.Drawing.Size(192, 187);
            this.groupBoxTS1.TabIndex = 53;
            this.groupBoxTS1.TabStop = false;
            this.groupBoxTS1.Text = "PowerMate and FlexControl";
            // 
            // txtWheelTune9
            // 
            this.txtWheelTune9.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(46)))), ((int)(((byte)(46)))), ((int)(((byte)(46)))));
            this.txtWheelTune9.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.txtWheelTune9.Cursor = System.Windows.Forms.Cursors.Default;
            this.txtWheelTune9.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.txtWheelTune9.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.txtWheelTune9.Location = new System.Drawing.Point(84, 161);
            this.txtWheelTune9.Name = "txtWheelTune9";
            this.txtWheelTune9.ReadOnly = true;
            this.txtWheelTune9.Size = new System.Drawing.Size(48, 20);
            this.txtWheelTune9.TabIndex = 92;
            this.txtWheelTune9.Text = "500Hz";
            this.toolTip1.SetToolTip(this.txtWheelTune9, "SSB\r\nMain console Tune_Step_Index\r\n");
            this.txtWheelTune9.Visible = false;
            // 
            // txtWheelTune8
            // 
            this.txtWheelTune8.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(46)))), ((int)(((byte)(46)))), ((int)(((byte)(46)))));
            this.txtWheelTune8.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.txtWheelTune8.Cursor = System.Windows.Forms.Cursors.Default;
            this.txtWheelTune8.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.txtWheelTune8.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.txtWheelTune8.Location = new System.Drawing.Point(138, 155);
            this.txtWheelTune8.Name = "txtWheelTune8";
            this.txtWheelTune8.ReadOnly = true;
            this.txtWheelTune8.Size = new System.Drawing.Size(48, 20);
            this.txtWheelTune8.TabIndex = 91;
            this.txtWheelTune8.Text = "100Hz";
            this.toolTip1.SetToolTip(this.txtWheelTune8, "SSB Alternative2 Tune Step Rate \r\nWorks with both PowerMate and FlexControl when " +
        "ON\r\n");
            this.txtWheelTune8.Visible = false;
            // 
            // txtWheelTune7
            // 
            this.txtWheelTune7.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(46)))), ((int)(((byte)(46)))), ((int)(((byte)(46)))));
            this.txtWheelTune7.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.txtWheelTune7.Cursor = System.Windows.Forms.Cursors.Default;
            this.txtWheelTune7.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.txtWheelTune7.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.txtWheelTune7.Location = new System.Drawing.Point(138, 129);
            this.txtWheelTune7.Name = "txtWheelTune7";
            this.txtWheelTune7.ReadOnly = true;
            this.txtWheelTune7.Size = new System.Drawing.Size(48, 20);
            this.txtWheelTune7.TabIndex = 90;
            this.txtWheelTune7.Text = "50Hz";
            this.toolTip1.SetToolTip(this.txtWheelTune7, "SSB Alternative 1Tune Step Rate \r\nWorks with both PowerMate and FlexControl when " +
        "ON\r\n");
            this.txtWheelTune7.Visible = false;
            // 
            // txtWheelTune6
            // 
            this.txtWheelTune6.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(46)))), ((int)(((byte)(46)))), ((int)(((byte)(46)))));
            this.txtWheelTune6.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.txtWheelTune6.Cursor = System.Windows.Forms.Cursors.Default;
            this.txtWheelTune6.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.txtWheelTune6.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.txtWheelTune6.Location = new System.Drawing.Point(138, 107);
            this.txtWheelTune6.Name = "txtWheelTune6";
            this.txtWheelTune6.ReadOnly = true;
            this.txtWheelTune6.Size = new System.Drawing.Size(48, 20);
            this.txtWheelTune6.TabIndex = 89;
            this.txtWheelTune6.Text = "100Hz";
            this.toolTip1.SetToolTip(this.txtWheelTune6, "CW MODE ONLY  Alternative2 Tune Step Rate \r\nWorks with both PowerMate and FlexCon" +
        "trol when ON\r\n");
            this.txtWheelTune6.Visible = false;
            // 
            // txtWheelTune5
            // 
            this.txtWheelTune5.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(46)))), ((int)(((byte)(46)))), ((int)(((byte)(46)))));
            this.txtWheelTune5.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.txtWheelTune5.Cursor = System.Windows.Forms.Cursors.Default;
            this.txtWheelTune5.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.txtWheelTune5.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.txtWheelTune5.Location = new System.Drawing.Point(138, 88);
            this.txtWheelTune5.Name = "txtWheelTune5";
            this.txtWheelTune5.ReadOnly = true;
            this.txtWheelTune5.Size = new System.Drawing.Size(48, 20);
            this.txtWheelTune5.TabIndex = 88;
            this.txtWheelTune5.Text = "50Hz";
            this.toolTip1.SetToolTip(this.txtWheelTune5, "CW MODE ONLY Alternative 1Tune Step Rate \r\nWorks with both PowerMate and FlexCont" +
        "rol when ON\r\n");
            this.txtWheelTune5.Visible = false;
            // 
            // txtWheelTune4
            // 
            this.txtWheelTune4.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(46)))), ((int)(((byte)(46)))), ((int)(((byte)(46)))));
            this.txtWheelTune4.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.txtWheelTune4.Cursor = System.Windows.Forms.Cursors.Default;
            this.txtWheelTune4.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.txtWheelTune4.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.txtWheelTune4.Location = new System.Drawing.Point(138, 71);
            this.txtWheelTune4.Name = "txtWheelTune4";
            this.txtWheelTune4.ReadOnly = true;
            this.txtWheelTune4.Size = new System.Drawing.Size(48, 20);
            this.txtWheelTune4.TabIndex = 87;
            this.txtWheelTune4.Text = "100Hz";
            this.toolTip1.SetToolTip(this.txtWheelTune4, "CW MODE ONLY \r\nMain console Tune_Step_Index\r\n");
            this.txtWheelTune4.Visible = false;
            // 
            // labelTS35
            // 
            this.labelTS35.Image = null;
            this.labelTS35.Location = new System.Drawing.Point(104, 91);
            this.labelTS35.Name = "labelTS35";
            this.labelTS35.Size = new System.Drawing.Size(64, 21);
            this.labelTS35.TabIndex = 86;
            this.labelTS35.Text = "Alt #1";
            // 
            // labelTS34
            // 
            this.labelTS34.Image = null;
            this.labelTS34.Location = new System.Drawing.Point(104, 112);
            this.labelTS34.Name = "labelTS34";
            this.labelTS34.Size = new System.Drawing.Size(64, 27);
            this.labelTS34.TabIndex = 85;
            this.labelTS34.Text = "Alt #2 (knob push)";
            // 
            // btnTuneStepChangeLarger3
            // 
            this.btnTuneStepChangeLarger3.FlatAppearance.BorderSize = 0;
            this.btnTuneStepChangeLarger3.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.btnTuneStepChangeLarger3.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F);
            this.btnTuneStepChangeLarger3.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.btnTuneStepChangeLarger3.Image = null;
            this.btnTuneStepChangeLarger3.ImeMode = System.Windows.Forms.ImeMode.Off;
            this.btnTuneStepChangeLarger3.Location = new System.Drawing.Point(84, 115);
            this.btnTuneStepChangeLarger3.Name = "btnTuneStepChangeLarger3";
            this.btnTuneStepChangeLarger3.Size = new System.Drawing.Size(16, 19);
            this.btnTuneStepChangeLarger3.TabIndex = 84;
            this.btnTuneStepChangeLarger3.Text = "+";
            this.toolTip1.SetToolTip(this.btnTuneStepChangeLarger3, "Change to the next larger tuning step");
            this.btnTuneStepChangeLarger3.Click += new System.EventHandler(this.btnTuneStepChangeLarger3_Click);
            // 
            // btnTuneStepChangeSmaller3
            // 
            this.btnTuneStepChangeSmaller3.FlatAppearance.BorderSize = 0;
            this.btnTuneStepChangeSmaller3.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.btnTuneStepChangeSmaller3.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F);
            this.btnTuneStepChangeSmaller3.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.btnTuneStepChangeSmaller3.Image = null;
            this.btnTuneStepChangeSmaller3.ImeMode = System.Windows.Forms.ImeMode.Off;
            this.btnTuneStepChangeSmaller3.Location = new System.Drawing.Point(11, 112);
            this.btnTuneStepChangeSmaller3.Name = "btnTuneStepChangeSmaller3";
            this.btnTuneStepChangeSmaller3.Size = new System.Drawing.Size(16, 19);
            this.btnTuneStepChangeSmaller3.TabIndex = 83;
            this.btnTuneStepChangeSmaller3.Text = "-";
            this.toolTip1.SetToolTip(this.btnTuneStepChangeSmaller3, "Change to the next smaller tuning step");
            this.btnTuneStepChangeSmaller3.Click += new System.EventHandler(this.btnTuneStepChangeSmaller3_Click);
            // 
            // txtWheelTune3
            // 
            this.txtWheelTune3.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(46)))), ((int)(((byte)(46)))), ((int)(((byte)(46)))));
            this.txtWheelTune3.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.txtWheelTune3.Cursor = System.Windows.Forms.Cursors.Default;
            this.txtWheelTune3.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.txtWheelTune3.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.txtWheelTune3.Location = new System.Drawing.Point(30, 116);
            this.txtWheelTune3.Name = "txtWheelTune3";
            this.txtWheelTune3.ReadOnly = true;
            this.txtWheelTune3.Size = new System.Drawing.Size(48, 20);
            this.txtWheelTune3.TabIndex = 82;
            this.txtWheelTune3.Text = "100Hz";
            this.toolTip1.SetToolTip(this.txtWheelTune3, "Alternative Tune Step Rate \r\nWorks with both PowerMate and FlexControl when ON\r\n");
            this.txtWheelTune3.TextChanged += new System.EventHandler(this.txtWheelTune3_TextChanged);
            // 
            // chkBoxIND2
            // 
            this.chkBoxIND2.Image = null;
            this.chkBoxIND2.Location = new System.Drawing.Point(9, 165);
            this.chkBoxIND2.Name = "chkBoxIND2";
            this.chkBoxIND2.Size = new System.Drawing.Size(182, 16);
            this.chkBoxIND2.TabIndex = 81;
            this.chkBoxIND2.Text = "Alt1 Tune Step for FlexControl\r\n";
            this.toolTip1.SetToolTip(this.chkBoxIND2, "Check to use the  Alternative Tune Step \r\nFor the FlexControl\r\n\r\nUncheck to use t" +
        "he main cosnsole PowerSDR Tune Step");
            // 
            // labelTS26
            // 
            this.labelTS26.Image = null;
            this.labelTS26.Location = new System.Drawing.Point(8, 71);
            this.labelTS26.Name = "labelTS26";
            this.labelTS26.Size = new System.Drawing.Size(149, 16);
            this.labelTS26.TabIndex = 80;
            this.labelTS26.Text = "Alt Tune Step Rate(s):";
            // 
            // btnTuneStepChangeLarger2
            // 
            this.btnTuneStepChangeLarger2.FlatAppearance.BorderSize = 0;
            this.btnTuneStepChangeLarger2.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.btnTuneStepChangeLarger2.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F);
            this.btnTuneStepChangeLarger2.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.btnTuneStepChangeLarger2.Image = null;
            this.btnTuneStepChangeLarger2.ImeMode = System.Windows.Forms.ImeMode.Off;
            this.btnTuneStepChangeLarger2.Location = new System.Drawing.Point(84, 89);
            this.btnTuneStepChangeLarger2.Name = "btnTuneStepChangeLarger2";
            this.btnTuneStepChangeLarger2.Size = new System.Drawing.Size(16, 19);
            this.btnTuneStepChangeLarger2.TabIndex = 79;
            this.btnTuneStepChangeLarger2.Text = "+";
            this.toolTip1.SetToolTip(this.btnTuneStepChangeLarger2, "Change to the next larger tuning step");
            this.btnTuneStepChangeLarger2.Click += new System.EventHandler(this.btnTuneStepChangeLarger2_Click);
            // 
            // btnTuneStepChangeSmaller2
            // 
            this.btnTuneStepChangeSmaller2.FlatAppearance.BorderSize = 0;
            this.btnTuneStepChangeSmaller2.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.btnTuneStepChangeSmaller2.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F);
            this.btnTuneStepChangeSmaller2.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.btnTuneStepChangeSmaller2.Image = null;
            this.btnTuneStepChangeSmaller2.ImeMode = System.Windows.Forms.ImeMode.Off;
            this.btnTuneStepChangeSmaller2.Location = new System.Drawing.Point(11, 89);
            this.btnTuneStepChangeSmaller2.Name = "btnTuneStepChangeSmaller2";
            this.btnTuneStepChangeSmaller2.Size = new System.Drawing.Size(16, 19);
            this.btnTuneStepChangeSmaller2.TabIndex = 78;
            this.btnTuneStepChangeSmaller2.Text = "-";
            this.toolTip1.SetToolTip(this.btnTuneStepChangeSmaller2, "Change to the next smaller tuning step");
            this.btnTuneStepChangeSmaller2.Click += new System.EventHandler(this.btnTuneStepChangeSmaller2_Click);
            // 
            // txtWheelTune2
            // 
            this.txtWheelTune2.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(46)))), ((int)(((byte)(46)))), ((int)(((byte)(46)))));
            this.txtWheelTune2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.txtWheelTune2.Cursor = System.Windows.Forms.Cursors.Default;
            this.txtWheelTune2.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.txtWheelTune2.ForeColor = System.Drawing.SystemColors.ControlLightLight;
            this.txtWheelTune2.Location = new System.Drawing.Point(30, 90);
            this.txtWheelTune2.Name = "txtWheelTune2";
            this.txtWheelTune2.ReadOnly = true;
            this.txtWheelTune2.Size = new System.Drawing.Size(48, 20);
            this.txtWheelTune2.TabIndex = 16;
            this.txtWheelTune2.Text = "50Hz";
            this.toolTip1.SetToolTip(this.txtWheelTune2, "Alternative Tune Step Rate \r\nWorks with both PowerMate and FlexControl when ON\r\n");
            this.txtWheelTune2.TextChanged += new System.EventHandler(this.txtWheelTune2_TextChanged);
            this.txtWheelTune2.MouseDown += new System.Windows.Forms.MouseEventHandler(this.txtWheelTune2_MouseDown);
            // 
            // chkBoxIND
            // 
            this.chkBoxIND.Image = null;
            this.chkBoxIND.Location = new System.Drawing.Point(9, 142);
            this.chkBoxIND.Name = "chkBoxIND";
            this.chkBoxIND.Size = new System.Drawing.Size(182, 17);
            this.chkBoxIND.TabIndex = 7;
            this.chkBoxIND.Text = "Alt1-2 Tune Step for PowerMate\r\n";
            this.toolTip1.SetToolTip(this.chkBoxIND, "Check to use the Alternative Tune Step \r\nFor PowerMate Knob\r\n\r\nUncheck to use the" +
        " main cosnsole PowerSDR Tune Step");
            // 
            // labelTS15
            // 
            this.labelTS15.Image = null;
            this.labelTS15.Location = new System.Drawing.Point(6, 42);
            this.labelTS15.Name = "labelTS15";
            this.labelTS15.Size = new System.Drawing.Size(108, 16);
            this.labelTS15.TabIndex = 5;
            this.labelTS15.Text = "PowerMate Speed:";
            // 
            // chkBoxPM
            // 
            this.chkBoxPM.Image = null;
            this.chkBoxPM.Location = new System.Drawing.Point(26, 12);
            this.chkBoxPM.Name = "chkBoxPM";
            this.chkBoxPM.Size = new System.Drawing.Size(149, 27);
            this.chkBoxPM.TabIndex = 6;
            this.chkBoxPM.Text = "PowerMate Knob Active";
            this.chkBoxPM.CheckedChanged += new System.EventHandler(this.chkBoxPM_CheckedChanged);
            // 
            // udSpeedPM
            // 
            this.udSpeedPM.DecimalPlaces = 1;
            this.udSpeedPM.Increment = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udSpeedPM.Location = new System.Drawing.Point(119, 40);
            this.udSpeedPM.Maximum = new decimal(new int[] {
            8,
            0,
            0,
            0});
            this.udSpeedPM.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udSpeedPM.Name = "udSpeedPM";
            this.udSpeedPM.Size = new System.Drawing.Size(49, 20);
            this.udSpeedPM.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udSpeedPM, "Speed of Freq Change");
            this.udSpeedPM.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udSpeedPM.ValueChanged += new System.EventHandler(this.udSpeedPM_ValueChanged);
            // 
            // tpAudio
            // 
            this.tpAudio.Controls.Add(this.tcAudio);
            this.tpAudio.Location = new System.Drawing.Point(4, 22);
            this.tpAudio.Name = "tpAudio";
            this.tpAudio.Size = new System.Drawing.Size(584, 341);
            this.tpAudio.TabIndex = 0;
            this.tpAudio.Text = "Audio";
            // 
            // tcAudio
            // 
            this.tcAudio.Controls.Add(this.tpAudioCard1);
            this.tcAudio.Controls.Add(this.tpVAC);
            this.tcAudio.Controls.Add(this.tpVAC2);
            this.tcAudio.Location = new System.Drawing.Point(0, 0);
            this.tcAudio.Name = "tcAudio";
            this.tcAudio.SelectedIndex = 0;
            this.tcAudio.Size = new System.Drawing.Size(600, 344);
            this.tcAudio.TabIndex = 35;
            // 
            // tpAudioCard1
            // 
            this.tpAudioCard1.Controls.Add(this.groupBoxTS7);
            this.tpAudioCard1.Controls.Add(this.groupBoxTS8);
            this.tpAudioCard1.Controls.Add(this.chkTXIQswap);
            this.tpAudioCard1.Controls.Add(this.chkRXIQswap);
            this.tpAudioCard1.Controls.Add(this.chkAudioExpert);
            this.tpAudioCard1.Controls.Add(this.grpAudioMicBoost);
            this.tpAudioCard1.Controls.Add(this.grpAudioChannels);
            this.tpAudioCard1.Controls.Add(this.grpAudioMicInGain1);
            this.tpAudioCard1.Controls.Add(this.grpAudioLineInGain1);
            this.tpAudioCard1.Controls.Add(this.grpAudioVolts1);
            this.tpAudioCard1.Controls.Add(this.grpAudioDetails1);
            this.tpAudioCard1.Controls.Add(this.grpAudioLatency1);
            this.tpAudioCard1.Controls.Add(this.grpAudioCard);
            this.tpAudioCard1.Controls.Add(this.grpAudioBufferSize1);
            this.tpAudioCard1.Controls.Add(this.grpAudioSampleRate1);
            this.tpAudioCard1.Location = new System.Drawing.Point(4, 22);
            this.tpAudioCard1.Name = "tpAudioCard1";
            this.tpAudioCard1.Size = new System.Drawing.Size(592, 318);
            this.tpAudioCard1.TabIndex = 0;
            this.tpAudioCard1.Text = "Primary";
            // 
            // groupBoxTS7
            // 
            this.groupBoxTS7.Controls.Add(this.udIQCorrection);
            this.groupBoxTS7.Location = new System.Drawing.Point(3, 259);
            this.groupBoxTS7.Name = "groupBoxTS7";
            this.groupBoxTS7.Size = new System.Drawing.Size(135, 56);
            this.groupBoxTS7.TabIndex = 51;
            this.groupBoxTS7.TabStop = false;
            this.groupBoxTS7.Text = "IQ Correction RX";
            this.groupBoxTS7.Enter += new System.EventHandler(this.groupBoxTS7_Enter);
            // 
            // udIQCorrection
            // 
            this.udIQCorrection.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udIQCorrection.Location = new System.Drawing.Point(16, 24);
            this.udIQCorrection.Maximum = new decimal(new int[] {
            32,
            0,
            0,
            0});
            this.udIQCorrection.Minimum = new decimal(new int[] {
            32,
            0,
            0,
            -2147483648});
            this.udIQCorrection.Name = "udIQCorrection";
            this.udIQCorrection.Size = new System.Drawing.Size(72, 20);
            this.udIQCorrection.TabIndex = 51;
            this.toolTip1.SetToolTip(this.udIQCorrection, "Corrects sample shift for Left and Right Soundcard input.  ");
            this.udIQCorrection.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udIQCorrection.ValueChanged += new System.EventHandler(this.udIQCorrection_ValueChanged);
            // 
            // groupBoxTS8
            // 
            this.groupBoxTS8.Controls.Add(this.udIQCorrection_TX);
            this.groupBoxTS8.Location = new System.Drawing.Point(132, 258);
            this.groupBoxTS8.Name = "groupBoxTS8";
            this.groupBoxTS8.Size = new System.Drawing.Size(142, 57);
            this.groupBoxTS8.TabIndex = 51;
            this.groupBoxTS8.TabStop = false;
            this.groupBoxTS8.Text = "IQ Correction TX";
            this.groupBoxTS8.Enter += new System.EventHandler(this.groupBoxTS8_Enter);
            // 
            // udIQCorrection_TX
            // 
            this.udIQCorrection_TX.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udIQCorrection_TX.Location = new System.Drawing.Point(16, 24);
            this.udIQCorrection_TX.Maximum = new decimal(new int[] {
            32,
            0,
            0,
            0});
            this.udIQCorrection_TX.Minimum = new decimal(new int[] {
            32,
            0,
            0,
            -2147483648});
            this.udIQCorrection_TX.Name = "udIQCorrection_TX";
            this.udIQCorrection_TX.Size = new System.Drawing.Size(72, 20);
            this.udIQCorrection_TX.TabIndex = 51;
            this.toolTip1.SetToolTip(this.udIQCorrection_TX, "Corrects sample shift for Left and Right Soundcard output.  ");
            this.udIQCorrection_TX.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udIQCorrection_TX.ValueChanged += new System.EventHandler(this.udIQCorrection_ValueChanged);
            // 
            // chkTXIQswap
            // 
            this.chkTXIQswap.AutoSize = true;
            this.chkTXIQswap.Image = null;
            this.chkTXIQswap.Location = new System.Drawing.Point(480, 49);
            this.chkTXIQswap.Name = "chkTXIQswap";
            this.chkTXIQswap.Size = new System.Drawing.Size(87, 17);
            this.chkTXIQswap.TabIndex = 48;
            this.chkTXIQswap.Text = "TX swap I/Q";
            this.toolTip1.SetToolTip(this.chkTXIQswap, "Swap Left and Right channel during transmition period");
            this.chkTXIQswap.UseVisualStyleBackColor = true;
            this.chkTXIQswap.CheckedChanged += new System.EventHandler(this.chkTXIQswap_CheckedChanged);
            // 
            // chkRXIQswap
            // 
            this.chkRXIQswap.AutoSize = true;
            this.chkRXIQswap.Image = null;
            this.chkRXIQswap.Location = new System.Drawing.Point(480, 31);
            this.chkRXIQswap.Name = "chkRXIQswap";
            this.chkRXIQswap.Size = new System.Drawing.Size(88, 17);
            this.chkRXIQswap.TabIndex = 47;
            this.chkRXIQswap.Text = "RX swap I/Q";
            this.toolTip1.SetToolTip(this.chkRXIQswap, "Swap Left and Right channel on receive mode");
            this.chkRXIQswap.UseVisualStyleBackColor = true;
            this.chkRXIQswap.CheckedChanged += new System.EventHandler(this.chkIQswap_CheckedChanged);
            // 
            // chkAudioExpert
            // 
            this.chkAudioExpert.Image = null;
            this.chkAudioExpert.Location = new System.Drawing.Point(480, 8);
            this.chkAudioExpert.Name = "chkAudioExpert";
            this.chkAudioExpert.Size = new System.Drawing.Size(56, 24);
            this.chkAudioExpert.TabIndex = 50;
            this.chkAudioExpert.Text = "Expert";
            this.chkAudioExpert.CheckedChanged += new System.EventHandler(this.chkAudioExpert_CheckedChanged);
            // 
            // grpAudioMicBoost
            // 
            this.grpAudioMicBoost.Location = new System.Drawing.Point(440, 216);
            this.grpAudioMicBoost.Name = "grpAudioMicBoost";
            this.grpAudioMicBoost.Size = new System.Drawing.Size(72, 48);
            this.grpAudioMicBoost.TabIndex = 43;
            this.grpAudioMicBoost.TabStop = false;
            this.grpAudioMicBoost.Text = "Mic Boost";
            this.grpAudioMicBoost.Visible = false;
            // 
            // grpAudioChannels
            // 
            this.grpAudioChannels.Controls.Add(this.comboAudioChannels1);
            this.grpAudioChannels.Location = new System.Drawing.Point(440, 72);
            this.grpAudioChannels.Name = "grpAudioChannels";
            this.grpAudioChannels.Size = new System.Drawing.Size(96, 56);
            this.grpAudioChannels.TabIndex = 42;
            this.grpAudioChannels.TabStop = false;
            this.grpAudioChannels.Text = "Channels";
            // 
            // comboAudioChannels1
            // 
            this.comboAudioChannels1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioChannels1.DropDownWidth = 56;
            this.comboAudioChannels1.Items.AddRange(new object[] {
            "2",
            "4",
            "6"});
            this.comboAudioChannels1.Location = new System.Drawing.Point(16, 24);
            this.comboAudioChannels1.Name = "comboAudioChannels1";
            this.comboAudioChannels1.Size = new System.Drawing.Size(56, 21);
            this.comboAudioChannels1.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboAudioChannels1, "Number of channels to open");
            this.comboAudioChannels1.SelectedIndexChanged += new System.EventHandler(this.comboAudioChannels1_SelectedIndexChanged);
            // 
            // grpAudioMicInGain1
            // 
            this.grpAudioMicInGain1.Controls.Add(this.udAudioMicGain1);
            this.grpAudioMicInGain1.Location = new System.Drawing.Point(344, 136);
            this.grpAudioMicInGain1.Name = "grpAudioMicInGain1";
            this.grpAudioMicInGain1.Size = new System.Drawing.Size(88, 56);
            this.grpAudioMicInGain1.TabIndex = 41;
            this.grpAudioMicInGain1.TabStop = false;
            this.grpAudioMicInGain1.Text = "Mic In Gain";
            // 
            // udAudioMicGain1
            // 
            this.udAudioMicGain1.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udAudioMicGain1.Location = new System.Drawing.Point(16, 24);
            this.udAudioMicGain1.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udAudioMicGain1.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udAudioMicGain1.Name = "udAudioMicGain1";
            this.udAudioMicGain1.Size = new System.Drawing.Size(40, 20);
            this.udAudioMicGain1.TabIndex = 51;
            this.toolTip1.SetToolTip(this.udAudioMicGain1, "MIC Gain - Input Volume");
            this.udAudioMicGain1.Value = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udAudioMicGain1.ValueChanged += new System.EventHandler(this.udAudioMicGain1_ValueChanged);
            this.udAudioMicGain1.LostFocus += new System.EventHandler(this.udAudioMicGain1_LostFocus);
            // 
            // grpAudioLineInGain1
            // 
            this.grpAudioLineInGain1.Controls.Add(this.udAudioLineIn1);
            this.grpAudioLineInGain1.Location = new System.Drawing.Point(344, 72);
            this.grpAudioLineInGain1.Name = "grpAudioLineInGain1";
            this.grpAudioLineInGain1.Size = new System.Drawing.Size(88, 56);
            this.grpAudioLineInGain1.TabIndex = 40;
            this.grpAudioLineInGain1.TabStop = false;
            this.grpAudioLineInGain1.Text = "Line In Gain";
            // 
            // udAudioLineIn1
            // 
            this.udAudioLineIn1.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udAudioLineIn1.Location = new System.Drawing.Point(16, 24);
            this.udAudioLineIn1.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udAudioLineIn1.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udAudioLineIn1.Name = "udAudioLineIn1";
            this.udAudioLineIn1.Size = new System.Drawing.Size(40, 20);
            this.udAudioLineIn1.TabIndex = 51;
            this.toolTip1.SetToolTip(this.udAudioLineIn1, "IF Gain - Input Volume");
            this.udAudioLineIn1.Value = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udAudioLineIn1.ValueChanged += new System.EventHandler(this.udAudioLineIn1_ValueChanged);
            this.udAudioLineIn1.LostFocus += new System.EventHandler(this.udAudioLineIn1_LostFocus);
            // 
            // grpAudioVolts1
            // 
            this.grpAudioVolts1.Controls.Add(this.btnAudioVoltTest1);
            this.grpAudioVolts1.Controls.Add(this.udAudioVoltage1);
            this.grpAudioVolts1.Location = new System.Drawing.Point(240, 200);
            this.grpAudioVolts1.Name = "grpAudioVolts1";
            this.grpAudioVolts1.Size = new System.Drawing.Size(128, 56);
            this.grpAudioVolts1.TabIndex = 39;
            this.grpAudioVolts1.TabStop = false;
            this.grpAudioVolts1.Text = "Output Voltage";
            // 
            // btnAudioVoltTest1
            // 
            this.btnAudioVoltTest1.Image = null;
            this.btnAudioVoltTest1.Location = new System.Drawing.Point(72, 24);
            this.btnAudioVoltTest1.Name = "btnAudioVoltTest1";
            this.btnAudioVoltTest1.Size = new System.Drawing.Size(40, 23);
            this.btnAudioVoltTest1.TabIndex = 2;
            this.btnAudioVoltTest1.Text = "Test";
            this.toolTip1.SetToolTip(this.btnAudioVoltTest1, "Outputs a full scale sinewave at the CW pitch for determining the RMS Voltage of " +
        "the sound card.");
            this.btnAudioVoltTest1.Click += new System.EventHandler(this.btnAudioVoltTest1_Click);
            // 
            // udAudioVoltage1
            // 
            this.udAudioVoltage1.DecimalPlaces = 2;
            this.udAudioVoltage1.Increment = new decimal(new int[] {
            1,
            0,
            0,
            131072});
            this.udAudioVoltage1.Location = new System.Drawing.Point(16, 24);
            this.udAudioVoltage1.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udAudioVoltage1.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udAudioVoltage1.Name = "udAudioVoltage1";
            this.udAudioVoltage1.Size = new System.Drawing.Size(48, 20);
            this.udAudioVoltage1.TabIndex = 1;
            this.toolTip1.SetToolTip(this.udAudioVoltage1, "The measured VRMS on the sound card output when outputting a full range tone.");
            this.udAudioVoltage1.Value = new decimal(new int[] {
            223,
            0,
            0,
            131072});
            this.udAudioVoltage1.ValueChanged += new System.EventHandler(this.udAudioVoltage1_ValueChanged);
            this.udAudioVoltage1.LostFocus += new System.EventHandler(this.udAudioVoltage1_LostFocus);
            // 
            // grpAudioDetails1
            // 
            this.grpAudioDetails1.Controls.Add(this.comboAudioTransmit1);
            this.grpAudioDetails1.Controls.Add(this.lblAudioMixer1);
            this.grpAudioDetails1.Controls.Add(this.lblAudioOutput1);
            this.grpAudioDetails1.Controls.Add(this.comboAudioOutput1);
            this.grpAudioDetails1.Controls.Add(this.lblAudioInput1);
            this.grpAudioDetails1.Controls.Add(this.lblAudioDriver1);
            this.grpAudioDetails1.Controls.Add(this.comboAudioInput1);
            this.grpAudioDetails1.Controls.Add(this.comboAudioDriver1);
            this.grpAudioDetails1.Controls.Add(this.comboAudioMixer1);
            this.grpAudioDetails1.Controls.Add(this.lblAudioTransmit1);
            this.grpAudioDetails1.Controls.Add(this.lblAudioReceive1);
            this.grpAudioDetails1.Controls.Add(this.comboAudioReceive1);
            this.grpAudioDetails1.Location = new System.Drawing.Point(8, 8);
            this.grpAudioDetails1.Name = "grpAudioDetails1";
            this.grpAudioDetails1.Size = new System.Drawing.Size(224, 216);
            this.grpAudioDetails1.TabIndex = 34;
            this.grpAudioDetails1.TabStop = false;
            this.grpAudioDetails1.Text = "Primary Sound Card Setup Details";
            // 
            // comboAudioTransmit1
            // 
            this.comboAudioTransmit1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioTransmit1.DropDownWidth = 160;
            this.comboAudioTransmit1.ItemHeight = 13;
            this.comboAudioTransmit1.Location = new System.Drawing.Point(56, 184);
            this.comboAudioTransmit1.Name = "comboAudioTransmit1";
            this.comboAudioTransmit1.Size = new System.Drawing.Size(160, 21);
            this.comboAudioTransmit1.TabIndex = 2;
            this.toolTip1.SetToolTip(this.comboAudioTransmit1, "Transmit mode mixer MUX setting.");
            this.comboAudioTransmit1.SelectedIndexChanged += new System.EventHandler(this.comboAudioTransmit1_SelectedIndexChanged);
            // 
            // lblAudioMixer1
            // 
            this.lblAudioMixer1.Image = null;
            this.lblAudioMixer1.Location = new System.Drawing.Point(8, 120);
            this.lblAudioMixer1.Name = "lblAudioMixer1";
            this.lblAudioMixer1.Size = new System.Drawing.Size(48, 23);
            this.lblAudioMixer1.TabIndex = 22;
            this.lblAudioMixer1.Text = "Mixer:";
            // 
            // lblAudioOutput1
            // 
            this.lblAudioOutput1.Image = null;
            this.lblAudioOutput1.Location = new System.Drawing.Point(8, 88);
            this.lblAudioOutput1.Name = "lblAudioOutput1";
            this.lblAudioOutput1.Size = new System.Drawing.Size(48, 16);
            this.lblAudioOutput1.TabIndex = 6;
            this.lblAudioOutput1.Text = "Output:";
            // 
            // comboAudioOutput1
            // 
            this.comboAudioOutput1.DisplayMember = "sdfg";
            this.comboAudioOutput1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioOutput1.DropDownWidth = 160;
            this.comboAudioOutput1.ItemHeight = 13;
            this.comboAudioOutput1.Location = new System.Drawing.Point(56, 88);
            this.comboAudioOutput1.Name = "comboAudioOutput1";
            this.comboAudioOutput1.Size = new System.Drawing.Size(160, 21);
            this.comboAudioOutput1.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboAudioOutput1, "Output Audio Device");
            this.comboAudioOutput1.SelectedIndexChanged += new System.EventHandler(this.comboAudioOutput1_SelectedIndexChanged);
            // 
            // lblAudioInput1
            // 
            this.lblAudioInput1.Image = null;
            this.lblAudioInput1.Location = new System.Drawing.Point(8, 56);
            this.lblAudioInput1.Name = "lblAudioInput1";
            this.lblAudioInput1.Size = new System.Drawing.Size(48, 16);
            this.lblAudioInput1.TabIndex = 4;
            this.lblAudioInput1.Text = "Input:";
            // 
            // lblAudioDriver1
            // 
            this.lblAudioDriver1.Image = null;
            this.lblAudioDriver1.Location = new System.Drawing.Point(8, 24);
            this.lblAudioDriver1.Name = "lblAudioDriver1";
            this.lblAudioDriver1.Size = new System.Drawing.Size(48, 16);
            this.lblAudioDriver1.TabIndex = 3;
            this.lblAudioDriver1.Text = "Driver:";
            // 
            // comboAudioInput1
            // 
            this.comboAudioInput1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioInput1.DropDownWidth = 160;
            this.comboAudioInput1.ItemHeight = 13;
            this.comboAudioInput1.Location = new System.Drawing.Point(56, 56);
            this.comboAudioInput1.Name = "comboAudioInput1";
            this.comboAudioInput1.Size = new System.Drawing.Size(160, 21);
            this.comboAudioInput1.TabIndex = 1;
            this.toolTip1.SetToolTip(this.comboAudioInput1, "Input Audio Device");
            this.comboAudioInput1.SelectedIndexChanged += new System.EventHandler(this.comboAudioInput1_SelectedIndexChanged);
            // 
            // comboAudioDriver1
            // 
            this.comboAudioDriver1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioDriver1.DropDownWidth = 160;
            this.comboAudioDriver1.ItemHeight = 13;
            this.comboAudioDriver1.Location = new System.Drawing.Point(56, 24);
            this.comboAudioDriver1.Name = "comboAudioDriver1";
            this.comboAudioDriver1.Size = new System.Drawing.Size(160, 21);
            this.comboAudioDriver1.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboAudioDriver1, "Sound Card Driver Selection");
            this.comboAudioDriver1.SelectedIndexChanged += new System.EventHandler(this.comboAudioDriver1_SelectedIndexChanged);
            // 
            // comboAudioMixer1
            // 
            this.comboAudioMixer1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioMixer1.DropDownWidth = 160;
            this.comboAudioMixer1.ItemHeight = 13;
            this.comboAudioMixer1.Location = new System.Drawing.Point(56, 120);
            this.comboAudioMixer1.Name = "comboAudioMixer1";
            this.comboAudioMixer1.Size = new System.Drawing.Size(160, 21);
            this.comboAudioMixer1.TabIndex = 21;
            this.toolTip1.SetToolTip(this.comboAudioMixer1, "Audio Mixer Device ");
            this.comboAudioMixer1.SelectedIndexChanged += new System.EventHandler(this.comboAudioMixer1_SelectedIndexChanged);
            // 
            // lblAudioTransmit1
            // 
            this.lblAudioTransmit1.Image = null;
            this.lblAudioTransmit1.Location = new System.Drawing.Point(8, 184);
            this.lblAudioTransmit1.Name = "lblAudioTransmit1";
            this.lblAudioTransmit1.Size = new System.Drawing.Size(56, 16);
            this.lblAudioTransmit1.TabIndex = 3;
            this.lblAudioTransmit1.Text = "Transmit:";
            // 
            // lblAudioReceive1
            // 
            this.lblAudioReceive1.Image = null;
            this.lblAudioReceive1.Location = new System.Drawing.Point(8, 152);
            this.lblAudioReceive1.Name = "lblAudioReceive1";
            this.lblAudioReceive1.Size = new System.Drawing.Size(48, 16);
            this.lblAudioReceive1.TabIndex = 1;
            this.lblAudioReceive1.Text = "Receive:";
            // 
            // comboAudioReceive1
            // 
            this.comboAudioReceive1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioReceive1.DropDownWidth = 160;
            this.comboAudioReceive1.ItemHeight = 13;
            this.comboAudioReceive1.Location = new System.Drawing.Point(56, 152);
            this.comboAudioReceive1.Name = "comboAudioReceive1";
            this.comboAudioReceive1.Size = new System.Drawing.Size(160, 21);
            this.comboAudioReceive1.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboAudioReceive1, "Receive mode Mixer MUX setting");
            this.comboAudioReceive1.SelectedIndexChanged += new System.EventHandler(this.comboAudioReceive1_SelectedIndexChanged);
            // 
            // grpAudioLatency1
            // 
            this.grpAudioLatency1.Controls.Add(this.chkAudioLatencyManual1);
            this.grpAudioLatency1.Controls.Add(this.udAudioLatency1);
            this.grpAudioLatency1.Location = new System.Drawing.Point(440, 136);
            this.grpAudioLatency1.Name = "grpAudioLatency1";
            this.grpAudioLatency1.Size = new System.Drawing.Size(96, 80);
            this.grpAudioLatency1.TabIndex = 38;
            this.grpAudioLatency1.TabStop = false;
            this.grpAudioLatency1.Text = "Latency (ms)";
            this.grpAudioLatency1.Visible = false;
            // 
            // chkAudioLatencyManual1
            // 
            this.chkAudioLatencyManual1.Image = null;
            this.chkAudioLatencyManual1.Location = new System.Drawing.Point(16, 24);
            this.chkAudioLatencyManual1.Name = "chkAudioLatencyManual1";
            this.chkAudioLatencyManual1.Size = new System.Drawing.Size(64, 16);
            this.chkAudioLatencyManual1.TabIndex = 5;
            this.chkAudioLatencyManual1.Text = "Manual";
            this.chkAudioLatencyManual1.CheckedChanged += new System.EventHandler(this.chkAudioLatencyManual1_CheckedChanged);
            // 
            // udAudioLatency1
            // 
            this.udAudioLatency1.Enabled = false;
            this.udAudioLatency1.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udAudioLatency1.Location = new System.Drawing.Point(16, 48);
            this.udAudioLatency1.Maximum = new decimal(new int[] {
            240,
            0,
            0,
            0});
            this.udAudioLatency1.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udAudioLatency1.Name = "udAudioLatency1";
            this.udAudioLatency1.Size = new System.Drawing.Size(48, 20);
            this.udAudioLatency1.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udAudioLatency1, "Adds latency/stability to the audio subsystem.  Not needed when using ASIO driver" +
        ".  Mainly for compatibility.  The Manual setting should only be used for unsuppo" +
        "rted cards.");
            this.udAudioLatency1.Value = new decimal(new int[] {
            120,
            0,
            0,
            0});
            this.udAudioLatency1.ValueChanged += new System.EventHandler(this.udAudioLatency1_ValueChanged);
            this.udAudioLatency1.LostFocus += new System.EventHandler(this.udAudioLatency1_LostFocus);
            // 
            // grpAudioCard
            // 
            this.grpAudioCard.Controls.Add(this.comboAudioSoundCard);
            this.grpAudioCard.Location = new System.Drawing.Point(240, 8);
            this.grpAudioCard.Name = "grpAudioCard";
            this.grpAudioCard.Size = new System.Drawing.Size(224, 56);
            this.grpAudioCard.TabIndex = 37;
            this.grpAudioCard.TabStop = false;
            this.grpAudioCard.Text = "Sound Card Selection";
            // 
            // comboAudioSoundCard
            // 
            this.comboAudioSoundCard.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioSoundCard.DropDownWidth = 184;
            this.comboAudioSoundCard.Items.AddRange(new object[] {
            "M-Audio Delta 44 (PCI)",
            "PreSonus FireBox (FireWire)",
            "Edirol FA-66 (FireWire)",
            "SB Audigy (PCI)",
            "SB Audigy 2 (PCI)",
            "SB Audigy 2 ZS (PCI)",
            "Sound Blaster Extigy (USB)",
            "Sound Blaster MP3+ (USB)",
            "Turtle Beach Santa Cruz (PCI)",
            "Unsupported Card"});
            this.comboAudioSoundCard.Location = new System.Drawing.Point(24, 24);
            this.comboAudioSoundCard.MaxDropDownItems = 11;
            this.comboAudioSoundCard.Name = "comboAudioSoundCard";
            this.comboAudioSoundCard.Size = new System.Drawing.Size(184, 21);
            this.comboAudioSoundCard.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboAudioSoundCard, "Sound Card Selection (use Unsupported Card if your card isn\'t in the list -- this" +
        " will require manual setup of the below controls).");
            this.comboAudioSoundCard.SelectedIndexChanged += new System.EventHandler(this.comboAudioSoundCard_SelectedIndexChanged);
            // 
            // grpAudioBufferSize1
            // 
            this.grpAudioBufferSize1.Controls.Add(this.comboAudioBuffer1);
            this.grpAudioBufferSize1.Location = new System.Drawing.Point(240, 72);
            this.grpAudioBufferSize1.Name = "grpAudioBufferSize1";
            this.grpAudioBufferSize1.Size = new System.Drawing.Size(96, 56);
            this.grpAudioBufferSize1.TabIndex = 36;
            this.grpAudioBufferSize1.TabStop = false;
            this.grpAudioBufferSize1.Text = "Buffer Size";
            // 
            // comboAudioBuffer1
            // 
            this.comboAudioBuffer1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioBuffer1.DropDownWidth = 56;
            this.comboAudioBuffer1.Items.AddRange(new object[] {
            "128",
            "256",
            "512",
            "1024",
            "2048"});
            this.comboAudioBuffer1.Location = new System.Drawing.Point(16, 24);
            this.comboAudioBuffer1.Name = "comboAudioBuffer1";
            this.comboAudioBuffer1.Size = new System.Drawing.Size(56, 21);
            this.comboAudioBuffer1.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboAudioBuffer1, "Samples per audio buffer.  Smaller settings give less latency, more CPU load.");
            this.comboAudioBuffer1.SelectedIndexChanged += new System.EventHandler(this.comboAudioBuffer1_SelectedIndexChanged);
            // 
            // grpAudioSampleRate1
            // 
            this.grpAudioSampleRate1.Controls.Add(this.comboAudioSampleRate1);
            this.grpAudioSampleRate1.Location = new System.Drawing.Point(240, 136);
            this.grpAudioSampleRate1.Name = "grpAudioSampleRate1";
            this.grpAudioSampleRate1.Size = new System.Drawing.Size(96, 56);
            this.grpAudioSampleRate1.TabIndex = 35;
            this.grpAudioSampleRate1.TabStop = false;
            this.grpAudioSampleRate1.Text = "Sample Rate";
            // 
            // comboAudioSampleRate1
            // 
            this.comboAudioSampleRate1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioSampleRate1.DropDownWidth = 64;
            this.comboAudioSampleRate1.Items.AddRange(new object[] {
            "48000"});
            this.comboAudioSampleRate1.Location = new System.Drawing.Point(16, 24);
            this.comboAudioSampleRate1.Name = "comboAudioSampleRate1";
            this.comboAudioSampleRate1.Size = new System.Drawing.Size(64, 21);
            this.comboAudioSampleRate1.TabIndex = 4;
            this.toolTip1.SetToolTip(this.comboAudioSampleRate1, "Sample Rate -- Higher sampling rates yield a wider panadapter and less latency at" +
        " a cost of CPU% and filter sharpness");
            this.comboAudioSampleRate1.SelectedIndexChanged += new System.EventHandler(this.comboAudioSampleRate1_SelectedIndexChanged);
            // 
            // tpVAC
            // 
            this.tpVAC.Controls.Add(this.radVAC1SelectB);
            this.tpVAC.Controls.Add(this.radVAC1SelectA);
            this.tpVAC.Controls.Add(this.groupBoxTS6);
            this.tpVAC.Controls.Add(this.chkVACReset);
            this.tpVAC.Controls.Add(this.checkBoxMixAudio);
            this.tpVAC.Controls.Add(this.grpDirectIQOutput);
            this.tpVAC.Controls.Add(this.chkVACCombine);
            this.tpVAC.Controls.Add(this.chkVACAllowBypass);
            this.tpVAC.Controls.Add(this.grpAudioVACAutoEnable);
            this.tpVAC.Controls.Add(this.grpAudioVACGain);
            this.tpVAC.Controls.Add(this.grpAudio2Stereo);
            this.tpVAC.Controls.Add(this.grpAudioLatency2);
            this.tpVAC.Controls.Add(this.grpAudioSampleRate2);
            this.tpVAC.Controls.Add(this.grpAudioBuffer2);
            this.tpVAC.Controls.Add(this.grpAudioDetails2);
            this.tpVAC.Controls.Add(this.chkAudioEnableVAC);
            this.tpVAC.Location = new System.Drawing.Point(4, 22);
            this.tpVAC.Name = "tpVAC";
            this.tpVAC.Size = new System.Drawing.Size(592, 318);
            this.tpVAC.TabIndex = 1;
            this.tpVAC.Text = "VAC 1";
            this.toolTip1.SetToolTip(this.tpVAC, resources.GetString("tpVAC.ToolTip"));
            // 
            // radVAC1SelectB
            // 
            this.radVAC1SelectB.AutoSize = true;
            this.radVAC1SelectB.Image = null;
            this.radVAC1SelectB.Location = new System.Drawing.Point(167, 171);
            this.radVAC1SelectB.Name = "radVAC1SelectB";
            this.radVAC1SelectB.Size = new System.Drawing.Size(65, 17);
            this.radVAC1SelectB.TabIndex = 86;
            this.radVAC1SelectB.TabStop = true;
            this.radVAC1SelectB.Text = "Select B";
            this.toolTip1.SetToolTip(this.radVAC1SelectB, resources.GetString("radVAC1SelectB.ToolTip"));
            this.radVAC1SelectB.UseVisualStyleBackColor = true;
            this.radVAC1SelectB.CheckedChanged += new System.EventHandler(this.chkVAC1SelectB_CheckedChanged);
            this.radVAC1SelectB.Click += new System.EventHandler(this.chkVAC1SelectB_Click);
            // 
            // radVAC1SelectA
            // 
            this.radVAC1SelectA.AutoSize = true;
            this.radVAC1SelectA.Image = null;
            this.radVAC1SelectA.Location = new System.Drawing.Point(167, 15);
            this.radVAC1SelectA.Name = "radVAC1SelectA";
            this.radVAC1SelectA.Size = new System.Drawing.Size(65, 17);
            this.radVAC1SelectA.TabIndex = 85;
            this.radVAC1SelectA.TabStop = true;
            this.radVAC1SelectA.Text = "Select A";
            this.toolTip1.SetToolTip(this.radVAC1SelectA, "Select the Virtual Cable A setup\r\n\r\nExample setup A:\r\nDriver:   DirectSound\r\nInpu" +
        "t:    VoiceMeeter Output\r\nOutput: VoiceMeeter Aux Input\r\n\r\nUse for Digital Mode " +
        "communications (WSJT-X or FLDIGI)");
            this.radVAC1SelectA.UseVisualStyleBackColor = true;
            this.radVAC1SelectA.CheckedChanged += new System.EventHandler(this.chkVAC1SelectA_CheckedChanged);
            this.radVAC1SelectA.Click += new System.EventHandler(this.chkVAC1SelectA_Click);
            // 
            // groupBoxTS6
            // 
            this.groupBoxTS6.Controls.Add(this.comboAudioOutput2B);
            this.groupBoxTS6.Controls.Add(this.labelTS58);
            this.groupBoxTS6.Controls.Add(this.labelTS59);
            this.groupBoxTS6.Controls.Add(this.labelTS60);
            this.groupBoxTS6.Controls.Add(this.comboAudioInput2B);
            this.groupBoxTS6.Controls.Add(this.comboAudioDriver2B);
            this.groupBoxTS6.Location = new System.Drawing.Point(8, 194);
            this.groupBoxTS6.Name = "groupBoxTS6";
            this.groupBoxTS6.Size = new System.Drawing.Size(224, 120);
            this.groupBoxTS6.TabIndex = 81;
            this.groupBoxTS6.TabStop = false;
            this.groupBoxTS6.Text = "Virtual Audio Cable Setup (to/from PC)  B";
            this.toolTip1.SetToolTip(this.groupBoxTS6, resources.GetString("groupBoxTS6.ToolTip"));
            // 
            // comboAudioOutput2B
            // 
            this.comboAudioOutput2B.DisplayMember = "sdfg";
            this.comboAudioOutput2B.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioOutput2B.DropDownWidth = 160;
            this.comboAudioOutput2B.ItemHeight = 13;
            this.comboAudioOutput2B.Location = new System.Drawing.Point(56, 88);
            this.comboAudioOutput2B.Name = "comboAudioOutput2B";
            this.comboAudioOutput2B.Size = new System.Drawing.Size(160, 21);
            this.comboAudioOutput2B.TabIndex = 34;
            this.toolTip1.SetToolTip(this.comboAudioOutput2B, "Select PC device for Audio Output FROM PowerSDR:\r\nOn your PC->Sound->Playback dev" +
        "ices");
            this.comboAudioOutput2B.SelectedIndexChanged += new System.EventHandler(this.comboAudioOutput2B_SelectedIndexChanged);
            // 
            // labelTS58
            // 
            this.labelTS58.Image = null;
            this.labelTS58.Location = new System.Drawing.Point(3, 85);
            this.labelTS58.Name = "labelTS58";
            this.labelTS58.Size = new System.Drawing.Size(57, 29);
            this.labelTS58.TabIndex = 35;
            this.labelTS58.Text = "Output: PC play";
            this.toolTip1.SetToolTip(this.labelTS58, "Select PC device for Audio Output FROM PowerSDR:\r\nOn your PC->Sound->Playback dev" +
        "ices");
            // 
            // labelTS59
            // 
            this.labelTS59.Image = null;
            this.labelTS59.Location = new System.Drawing.Point(3, 53);
            this.labelTS59.Name = "labelTS59";
            this.labelTS59.Size = new System.Drawing.Size(48, 32);
            this.labelTS59.TabIndex = 33;
            this.labelTS59.Text = "Input: PC rec:";
            this.toolTip1.SetToolTip(this.labelTS59, "Select PC device for Audio Input TO PowerSDR:\r\nOn your PC->Sound->Recording devic" +
        "es.");
            // 
            // labelTS60
            // 
            this.labelTS60.Image = null;
            this.labelTS60.Location = new System.Drawing.Point(8, 24);
            this.labelTS60.Name = "labelTS60";
            this.labelTS60.Size = new System.Drawing.Size(40, 16);
            this.labelTS60.TabIndex = 32;
            this.labelTS60.Text = "Driver:";
            // 
            // comboAudioInput2B
            // 
            this.comboAudioInput2B.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioInput2B.DropDownWidth = 160;
            this.comboAudioInput2B.ItemHeight = 13;
            this.comboAudioInput2B.Location = new System.Drawing.Point(56, 56);
            this.comboAudioInput2B.Name = "comboAudioInput2B";
            this.comboAudioInput2B.Size = new System.Drawing.Size(160, 21);
            this.comboAudioInput2B.TabIndex = 28;
            this.toolTip1.SetToolTip(this.comboAudioInput2B, "Select PC device for Audio Input TO PowerSDR:\r\nOn your PC->Sound->Recording devic" +
        "es.");
            this.comboAudioInput2B.SelectedIndexChanged += new System.EventHandler(this.comboAudioInput2B_SelectedIndexChanged);
            // 
            // comboAudioDriver2B
            // 
            this.comboAudioDriver2B.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioDriver2B.DropDownWidth = 160;
            this.comboAudioDriver2B.ItemHeight = 13;
            this.comboAudioDriver2B.Location = new System.Drawing.Point(56, 24);
            this.comboAudioDriver2B.Name = "comboAudioDriver2B";
            this.comboAudioDriver2B.Size = new System.Drawing.Size(160, 21);
            this.comboAudioDriver2B.TabIndex = 26;
            this.toolTip1.SetToolTip(this.comboAudioDriver2B, "Sound Card Driver Selection");
            this.comboAudioDriver2B.SelectedIndexChanged += new System.EventHandler(this.comboAudioDriver2B_SelectedIndexChanged);
            // 
            // chkVACReset
            // 
            this.chkVACReset.Image = null;
            this.chkVACReset.Location = new System.Drawing.Point(242, 210);
            this.chkVACReset.Name = "chkVACReset";
            this.chkVACReset.Size = new System.Drawing.Size(147, 32);
            this.chkVACReset.TabIndex = 80;
            this.chkVACReset.Text = "Reset VAC every hour";
            this.toolTip1.SetToolTip(this.chkVACReset, "With VAC Enabled, it will cycle ON-OFF-ON every hour to prevent a time lag on the" +
        " Audio stream.");
            this.chkVACReset.CheckedChanged += new System.EventHandler(this.checkBoxTS1_CheckedChanged_1);
            // 
            // checkBoxMixAudio
            // 
            this.checkBoxMixAudio.Image = null;
            this.checkBoxMixAudio.Location = new System.Drawing.Point(242, 184);
            this.checkBoxMixAudio.Name = "checkBoxMixAudio";
            this.checkBoxMixAudio.Size = new System.Drawing.Size(184, 32);
            this.checkBoxMixAudio.TabIndex = 79;
            this.checkBoxMixAudio.Text = "Mix VAC1 and MIC audio ";
            this.toolTip1.SetToolTip(this.checkBoxMixAudio, "Will mix audio streams from your PC (VAC1) and MIC (Flex radio input) together.\r\n" +
        "Allows you to inject PC Audio into your transmit Mic audio");
            this.checkBoxMixAudio.CheckedChanged += new System.EventHandler(this.checkBoxMixAudio_CheckedChanged);
            // 
            // grpDirectIQOutput
            // 
            this.grpDirectIQOutput.Controls.Add(this.chkAudioRX2toVAC);
            this.grpDirectIQOutput.Controls.Add(this.chkAudioCorrectIQ);
            this.grpDirectIQOutput.Controls.Add(this.chkAudioIQtoVAC);
            this.grpDirectIQOutput.Location = new System.Drawing.Point(448, 56);
            this.grpDirectIQOutput.Name = "grpDirectIQOutput";
            this.grpDirectIQOutput.Size = new System.Drawing.Size(120, 88);
            this.grpDirectIQOutput.TabIndex = 78;
            this.grpDirectIQOutput.TabStop = false;
            this.grpDirectIQOutput.Text = "Direct I/Q";
            this.toolTip1.SetToolTip(this.grpDirectIQOutput, "Direct I/Q send the entire Panadapter (Sample Rate) contents\r\nacross the Virtual " +
        "Audio Cable.\r\n\r\nWhen Direct I/Q is disabled, only the bandpass audio is sent \r\no" +
        "ver the  the Virtual Audio Cable.");
            // 
            // chkAudioRX2toVAC
            // 
            this.chkAudioRX2toVAC.Enabled = false;
            this.chkAudioRX2toVAC.Image = null;
            this.chkAudioRX2toVAC.Location = new System.Drawing.Point(16, 68);
            this.chkAudioRX2toVAC.Name = "chkAudioRX2toVAC";
            this.chkAudioRX2toVAC.Size = new System.Drawing.Size(88, 16);
            this.chkAudioRX2toVAC.TabIndex = 2;
            this.chkAudioRX2toVAC.Text = "Use RX2";
            this.chkAudioRX2toVAC.Visible = false;
            this.chkAudioRX2toVAC.CheckedChanged += new System.EventHandler(this.chkAudioRX2toVAC_CheckedChanged);
            // 
            // chkAudioCorrectIQ
            // 
            this.chkAudioCorrectIQ.Checked = true;
            this.chkAudioCorrectIQ.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkAudioCorrectIQ.Enabled = false;
            this.chkAudioCorrectIQ.Image = null;
            this.chkAudioCorrectIQ.Location = new System.Drawing.Point(16, 46);
            this.chkAudioCorrectIQ.Name = "chkAudioCorrectIQ";
            this.chkAudioCorrectIQ.Size = new System.Drawing.Size(88, 16);
            this.chkAudioCorrectIQ.TabIndex = 1;
            this.chkAudioCorrectIQ.Text = "Calibrate I/Q";
            this.chkAudioCorrectIQ.CheckedChanged += new System.EventHandler(this.chkAudioCorrectIQ_CheckChanged);
            // 
            // chkAudioIQtoVAC
            // 
            this.chkAudioIQtoVAC.Image = null;
            this.chkAudioIQtoVAC.Location = new System.Drawing.Point(16, 24);
            this.chkAudioIQtoVAC.Name = "chkAudioIQtoVAC";
            this.chkAudioIQtoVAC.Size = new System.Drawing.Size(96, 16);
            this.chkAudioIQtoVAC.TabIndex = 0;
            this.chkAudioIQtoVAC.Text = "Output to VAC";
            this.chkAudioIQtoVAC.CheckedChanged += new System.EventHandler(this.chkAudioIQtoVAC_CheckedChanged);
            // 
            // chkVACCombine
            // 
            this.chkVACCombine.Enabled = false;
            this.chkVACCombine.Image = null;
            this.chkVACCombine.Location = new System.Drawing.Point(448, 16);
            this.chkVACCombine.Name = "chkVACCombine";
            this.chkVACCombine.Size = new System.Drawing.Size(104, 40);
            this.chkVACCombine.TabIndex = 76;
            this.chkVACCombine.Text = "Combine VAC Input Channels";
            this.toolTip1.SetToolTip(this.chkVACCombine, "When this feature is enabled, the left and right VAC channels are combined into t" +
        "he DSP transmit channel (left).");
            this.chkVACCombine.CheckedChanged += new System.EventHandler(this.chkVACCombine_CheckedChanged);
            // 
            // chkVACAllowBypass
            // 
            this.chkVACAllowBypass.Checked = true;
            this.chkVACAllowBypass.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkVACAllowBypass.Image = null;
            this.chkVACAllowBypass.Location = new System.Drawing.Point(242, 156);
            this.chkVACAllowBypass.Name = "chkVACAllowBypass";
            this.chkVACAllowBypass.Size = new System.Drawing.Size(184, 32);
            this.chkVACAllowBypass.TabIndex = 75;
            this.chkVACAllowBypass.Text = "Allow PTT to override/bypass VAC for Phone";
            this.toolTip1.SetToolTip(this.chkVACAllowBypass, "Using the hardware PTT inputs will override the PTT input to allow for easy phone" +
        " operation while VAC is enabled.");
            this.chkVACAllowBypass.CheckedChanged += new System.EventHandler(this.chkVACAllowBypass_CheckedChanged);
            // 
            // grpAudioVACAutoEnable
            // 
            this.grpAudioVACAutoEnable.Controls.Add(this.chkAudioVACAutoEnable);
            this.grpAudioVACAutoEnable.Location = new System.Drawing.Point(240, 248);
            this.grpAudioVACAutoEnable.Name = "grpAudioVACAutoEnable";
            this.grpAudioVACAutoEnable.Size = new System.Drawing.Size(224, 66);
            this.grpAudioVACAutoEnable.TabIndex = 74;
            this.grpAudioVACAutoEnable.TabStop = false;
            this.grpAudioVACAutoEnable.Text = "Auto Enable";
            // 
            // chkAudioVACAutoEnable
            // 
            this.chkAudioVACAutoEnable.Image = null;
            this.chkAudioVACAutoEnable.Location = new System.Drawing.Point(16, 24);
            this.chkAudioVACAutoEnable.Name = "chkAudioVACAutoEnable";
            this.chkAudioVACAutoEnable.Size = new System.Drawing.Size(200, 32);
            this.chkAudioVACAutoEnable.TabIndex = 0;
            this.chkAudioVACAutoEnable.Text = "Enable for Digital modes on Mode change.  Disable for all other modes.";
            this.toolTip1.SetToolTip(this.chkAudioVACAutoEnable, "Click this button to automatically enable VAC when in Digital modes (DIGL, DIGU, " +
        "DRM)");
            this.chkAudioVACAutoEnable.CheckedChanged += new System.EventHandler(this.chkAudioVACAutoEnable_CheckedChanged);
            // 
            // grpAudioVACGain
            // 
            this.grpAudioVACGain.Controls.Add(this.lblAudioVACGainTX);
            this.grpAudioVACGain.Controls.Add(this.udAudioVACGainTX);
            this.grpAudioVACGain.Controls.Add(this.lblAudioVACGainRX);
            this.grpAudioVACGain.Controls.Add(this.udAudioVACGainRX);
            this.grpAudioVACGain.Location = new System.Drawing.Point(344, 8);
            this.grpAudioVACGain.Name = "grpAudioVACGain";
            this.grpAudioVACGain.Size = new System.Drawing.Size(96, 80);
            this.grpAudioVACGain.TabIndex = 72;
            this.grpAudioVACGain.TabStop = false;
            this.grpAudioVACGain.Text = "Gain (dB)";
            // 
            // lblAudioVACGainTX
            // 
            this.lblAudioVACGainTX.Image = null;
            this.lblAudioVACGainTX.Location = new System.Drawing.Point(16, 48);
            this.lblAudioVACGainTX.Name = "lblAudioVACGainTX";
            this.lblAudioVACGainTX.Size = new System.Drawing.Size(32, 16);
            this.lblAudioVACGainTX.TabIndex = 39;
            this.lblAudioVACGainTX.Text = "TX:";
            // 
            // udAudioVACGainTX
            // 
            this.udAudioVACGainTX.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udAudioVACGainTX.Location = new System.Drawing.Point(48, 48);
            this.udAudioVACGainTX.Maximum = new decimal(new int[] {
            40,
            0,
            0,
            0});
            this.udAudioVACGainTX.Minimum = new decimal(new int[] {
            40,
            0,
            0,
            -2147483648});
            this.udAudioVACGainTX.Name = "udAudioVACGainTX";
            this.udAudioVACGainTX.Size = new System.Drawing.Size(40, 20);
            this.udAudioVACGainTX.TabIndex = 38;
            this.toolTip1.SetToolTip(this.udAudioVACGainTX, "Controls the gain on the audio coming from third party applications.");
            this.udAudioVACGainTX.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udAudioVACGainTX.ValueChanged += new System.EventHandler(this.udAudioVACGainTX_ValueChanged);
            this.udAudioVACGainTX.LostFocus += new System.EventHandler(this.udAudioVACGainTX_LostFocus);
            // 
            // lblAudioVACGainRX
            // 
            this.lblAudioVACGainRX.Image = null;
            this.lblAudioVACGainRX.Location = new System.Drawing.Point(16, 24);
            this.lblAudioVACGainRX.Name = "lblAudioVACGainRX";
            this.lblAudioVACGainRX.Size = new System.Drawing.Size(24, 16);
            this.lblAudioVACGainRX.TabIndex = 37;
            this.lblAudioVACGainRX.Text = "RX:";
            // 
            // udAudioVACGainRX
            // 
            this.udAudioVACGainRX.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udAudioVACGainRX.Location = new System.Drawing.Point(48, 24);
            this.udAudioVACGainRX.Maximum = new decimal(new int[] {
            40,
            0,
            0,
            0});
            this.udAudioVACGainRX.Minimum = new decimal(new int[] {
            40,
            0,
            0,
            -2147483648});
            this.udAudioVACGainRX.Name = "udAudioVACGainRX";
            this.udAudioVACGainRX.Size = new System.Drawing.Size(40, 20);
            this.udAudioVACGainRX.TabIndex = 36;
            this.toolTip1.SetToolTip(this.udAudioVACGainRX, "Controls the gain applied to the RX audio before it is sent to the third party ap" +
        "plication.");
            this.udAudioVACGainRX.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udAudioVACGainRX.ValueChanged += new System.EventHandler(this.udAudioVACGainRX_ValueChanged);
            this.udAudioVACGainRX.LostFocus += new System.EventHandler(this.udAudioVACGainRX_LostFocus);
            // 
            // grpAudio2Stereo
            // 
            this.grpAudio2Stereo.Controls.Add(this.chkAudio2Stereo);
            this.grpAudio2Stereo.Location = new System.Drawing.Point(346, 94);
            this.grpAudio2Stereo.Name = "grpAudio2Stereo";
            this.grpAudio2Stereo.Size = new System.Drawing.Size(96, 56);
            this.grpAudio2Stereo.TabIndex = 71;
            this.grpAudio2Stereo.TabStop = false;
            this.grpAudio2Stereo.Text = "Mono/Stereo";
            // 
            // chkAudio2Stereo
            // 
            this.chkAudio2Stereo.Image = null;
            this.chkAudio2Stereo.Location = new System.Drawing.Point(16, 24);
            this.chkAudio2Stereo.Name = "chkAudio2Stereo";
            this.chkAudio2Stereo.Size = new System.Drawing.Size(64, 16);
            this.chkAudio2Stereo.TabIndex = 0;
            this.chkAudio2Stereo.Text = "Stereo";
            this.toolTip1.SetToolTip(this.chkAudio2Stereo, "Click this button if the third party software will open the Virtual Audio Cable i" +
        "n 2 channel (stereo) mode.");
            this.chkAudio2Stereo.CheckedChanged += new System.EventHandler(this.chkAudio2Stereo_CheckedChanged);
            // 
            // grpAudioLatency2
            // 
            this.grpAudioLatency2.Controls.Add(this.chkAudioLatencyManual2);
            this.grpAudioLatency2.Controls.Add(this.udAudioLatency2);
            this.grpAudioLatency2.Location = new System.Drawing.Point(448, 160);
            this.grpAudioLatency2.Name = "grpAudioLatency2";
            this.grpAudioLatency2.Size = new System.Drawing.Size(120, 64);
            this.grpAudioLatency2.TabIndex = 67;
            this.grpAudioLatency2.TabStop = false;
            this.grpAudioLatency2.Text = "Buffer Latency (ms)";
            // 
            // chkAudioLatencyManual2
            // 
            this.chkAudioLatencyManual2.Checked = true;
            this.chkAudioLatencyManual2.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkAudioLatencyManual2.Image = null;
            this.chkAudioLatencyManual2.Location = new System.Drawing.Point(19, 50);
            this.chkAudioLatencyManual2.Name = "chkAudioLatencyManual2";
            this.chkAudioLatencyManual2.Size = new System.Drawing.Size(64, 16);
            this.chkAudioLatencyManual2.TabIndex = 5;
            this.chkAudioLatencyManual2.Text = "Manual";
            this.chkAudioLatencyManual2.Visible = false;
            this.chkAudioLatencyManual2.CheckedChanged += new System.EventHandler(this.chkAudioLatencyManual2_CheckedChanged);
            // 
            // udAudioLatency2
            // 
            this.udAudioLatency2.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udAudioLatency2.Location = new System.Drawing.Point(35, 24);
            this.udAudioLatency2.Maximum = new decimal(new int[] {
            240,
            0,
            0,
            0});
            this.udAudioLatency2.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udAudioLatency2.Name = "udAudioLatency2";
            this.udAudioLatency2.Size = new System.Drawing.Size(48, 20);
            this.udAudioLatency2.TabIndex = 36;
            this.toolTip1.SetToolTip(this.udAudioLatency2, "Buffer latency for VAC1 audio stream.  Set to 0 for lowest latency.  \r\nIncrease t" +
        "his value if audio quality becomes unreliable or glitches");
            this.udAudioLatency2.Value = new decimal(new int[] {
            120,
            0,
            0,
            0});
            this.udAudioLatency2.ValueChanged += new System.EventHandler(this.udAudioLatency2_ValueChanged);
            this.udAudioLatency2.LostFocus += new System.EventHandler(this.udAudioLatency2_LostFocus);
            // 
            // grpAudioSampleRate2
            // 
            this.grpAudioSampleRate2.Controls.Add(this.comboAudioSampleRate2);
            this.grpAudioSampleRate2.Location = new System.Drawing.Point(240, 72);
            this.grpAudioSampleRate2.Name = "grpAudioSampleRate2";
            this.grpAudioSampleRate2.Size = new System.Drawing.Size(96, 56);
            this.grpAudioSampleRate2.TabIndex = 66;
            this.grpAudioSampleRate2.TabStop = false;
            this.grpAudioSampleRate2.Text = "Sample Rate";
            // 
            // comboAudioSampleRate2
            // 
            this.comboAudioSampleRate2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioSampleRate2.DropDownWidth = 64;
            this.comboAudioSampleRate2.Items.AddRange(new object[] {
            "8000",
            "11025",
            "12000",
            "24000",
            "22050",
            "44100",
            "48000",
            "96000",
            "192000"});
            this.comboAudioSampleRate2.Location = new System.Drawing.Point(16, 24);
            this.comboAudioSampleRate2.Name = "comboAudioSampleRate2";
            this.comboAudioSampleRate2.Size = new System.Drawing.Size(64, 21);
            this.comboAudioSampleRate2.TabIndex = 60;
            this.comboAudioSampleRate2.SelectedIndexChanged += new System.EventHandler(this.comboAudioSampleRate2_SelectedIndexChanged);
            // 
            // grpAudioBuffer2
            // 
            this.grpAudioBuffer2.Controls.Add(this.comboAudioBuffer2);
            this.grpAudioBuffer2.Location = new System.Drawing.Point(240, 8);
            this.grpAudioBuffer2.Name = "grpAudioBuffer2";
            this.grpAudioBuffer2.Size = new System.Drawing.Size(96, 56);
            this.grpAudioBuffer2.TabIndex = 65;
            this.grpAudioBuffer2.TabStop = false;
            this.grpAudioBuffer2.Text = "Buffer Size";
            // 
            // comboAudioBuffer2
            // 
            this.comboAudioBuffer2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioBuffer2.DropDownWidth = 56;
            this.comboAudioBuffer2.Items.AddRange(new object[] {
            "512",
            "1024",
            "2048"});
            this.comboAudioBuffer2.Location = new System.Drawing.Point(16, 24);
            this.comboAudioBuffer2.Name = "comboAudioBuffer2";
            this.comboAudioBuffer2.Size = new System.Drawing.Size(56, 21);
            this.comboAudioBuffer2.TabIndex = 58;
            this.toolTip1.SetToolTip(this.comboAudioBuffer2, "Samples per buffer.");
            this.comboAudioBuffer2.SelectedIndexChanged += new System.EventHandler(this.comboAudioBuffer2_SelectedIndexChanged);
            // 
            // grpAudioDetails2
            // 
            this.grpAudioDetails2.Controls.Add(this.comboAudioOutput2);
            this.grpAudioDetails2.Controls.Add(this.lblAudioOutput2);
            this.grpAudioDetails2.Controls.Add(this.lblAudioInput2);
            this.grpAudioDetails2.Controls.Add(this.lblAudioDriver2);
            this.grpAudioDetails2.Controls.Add(this.comboAudioInput2);
            this.grpAudioDetails2.Controls.Add(this.comboAudioDriver2);
            this.grpAudioDetails2.Location = new System.Drawing.Point(8, 40);
            this.grpAudioDetails2.Name = "grpAudioDetails2";
            this.grpAudioDetails2.Size = new System.Drawing.Size(224, 120);
            this.grpAudioDetails2.TabIndex = 35;
            this.grpAudioDetails2.TabStop = false;
            this.grpAudioDetails2.Text = "Virtual Audio Cable Setup (to/from PC)  A";
            this.toolTip1.SetToolTip(this.grpAudioDetails2, resources.GetString("grpAudioDetails2.ToolTip"));
            // 
            // comboAudioOutput2
            // 
            this.comboAudioOutput2.DisplayMember = "sdfg";
            this.comboAudioOutput2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioOutput2.DropDownWidth = 160;
            this.comboAudioOutput2.ItemHeight = 13;
            this.comboAudioOutput2.Location = new System.Drawing.Point(56, 88);
            this.comboAudioOutput2.Name = "comboAudioOutput2";
            this.comboAudioOutput2.Size = new System.Drawing.Size(160, 21);
            this.comboAudioOutput2.TabIndex = 34;
            this.toolTip1.SetToolTip(this.comboAudioOutput2, "Select PC device for Audio Output FROM PowerSDR:\r\nOn your PC->Sound->Playback dev" +
        "ices");
            this.comboAudioOutput2.SelectedIndexChanged += new System.EventHandler(this.comboAudioOutput2_SelectedIndexChanged);
            // 
            // lblAudioOutput2
            // 
            this.lblAudioOutput2.Image = null;
            this.lblAudioOutput2.Location = new System.Drawing.Point(3, 85);
            this.lblAudioOutput2.Name = "lblAudioOutput2";
            this.lblAudioOutput2.Size = new System.Drawing.Size(57, 29);
            this.lblAudioOutput2.TabIndex = 35;
            this.lblAudioOutput2.Text = "Output: PC play";
            this.toolTip1.SetToolTip(this.lblAudioOutput2, "Select PC device for Audio Output FROM PowerSDR:\r\nOn your PC->Sound->Playback dev" +
        "ices");
            // 
            // lblAudioInput2
            // 
            this.lblAudioInput2.Image = null;
            this.lblAudioInput2.Location = new System.Drawing.Point(3, 53);
            this.lblAudioInput2.Name = "lblAudioInput2";
            this.lblAudioInput2.Size = new System.Drawing.Size(48, 32);
            this.lblAudioInput2.TabIndex = 33;
            this.lblAudioInput2.Text = "Input: PC rec:";
            this.toolTip1.SetToolTip(this.lblAudioInput2, "Select PC device for Audio Input TO PowerSDR:\r\nOn your PC->Sound->Recording devic" +
        "es.");
            // 
            // lblAudioDriver2
            // 
            this.lblAudioDriver2.Image = null;
            this.lblAudioDriver2.Location = new System.Drawing.Point(8, 24);
            this.lblAudioDriver2.Name = "lblAudioDriver2";
            this.lblAudioDriver2.Size = new System.Drawing.Size(40, 16);
            this.lblAudioDriver2.TabIndex = 32;
            this.lblAudioDriver2.Text = "Driver:";
            // 
            // comboAudioInput2
            // 
            this.comboAudioInput2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioInput2.DropDownWidth = 160;
            this.comboAudioInput2.ItemHeight = 13;
            this.comboAudioInput2.Location = new System.Drawing.Point(56, 56);
            this.comboAudioInput2.Name = "comboAudioInput2";
            this.comboAudioInput2.Size = new System.Drawing.Size(160, 21);
            this.comboAudioInput2.TabIndex = 28;
            this.toolTip1.SetToolTip(this.comboAudioInput2, "Select PC device for Audio Input TO PowerSDR:\r\nOn your PC->Sound->Recording devic" +
        "es.");
            this.comboAudioInput2.SelectedIndexChanged += new System.EventHandler(this.comboAudioInput2_SelectedIndexChanged);
            // 
            // comboAudioDriver2
            // 
            this.comboAudioDriver2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioDriver2.DropDownWidth = 160;
            this.comboAudioDriver2.ItemHeight = 13;
            this.comboAudioDriver2.Location = new System.Drawing.Point(56, 24);
            this.comboAudioDriver2.Name = "comboAudioDriver2";
            this.comboAudioDriver2.Size = new System.Drawing.Size(160, 21);
            this.comboAudioDriver2.TabIndex = 26;
            this.toolTip1.SetToolTip(this.comboAudioDriver2, "Sound Card Driver Selection");
            this.comboAudioDriver2.SelectedIndexChanged += new System.EventHandler(this.comboAudioDriver2_SelectedIndexChanged);
            // 
            // chkAudioEnableVAC
            // 
            this.chkAudioEnableVAC.Image = null;
            this.chkAudioEnableVAC.Location = new System.Drawing.Point(16, 8);
            this.chkAudioEnableVAC.Name = "chkAudioEnableVAC";
            this.chkAudioEnableVAC.Size = new System.Drawing.Size(96, 24);
            this.chkAudioEnableVAC.TabIndex = 25;
            this.chkAudioEnableVAC.Text = "Enable VAC1";
            this.toolTip1.SetToolTip(this.chkAudioEnableVAC, "Enable Virtual Audio Cable Support for VAC 1 (RX1)");
            this.chkAudioEnableVAC.CheckedChanged += new System.EventHandler(this.chkAudioEnableVAC_CheckedChanged);
            // 
            // tpVAC2
            // 
            this.tpVAC2.BackColor = System.Drawing.SystemColors.Control;
            this.tpVAC2.Controls.Add(this.chkVAC2UseRX2);
            this.tpVAC2.Controls.Add(this.grpVAC2DirectIQ);
            this.tpVAC2.Controls.Add(this.chkVAC2Combine);
            this.tpVAC2.Controls.Add(this.grpVAC2AutoEnable);
            this.tpVAC2.Controls.Add(this.grpVAC2Gain);
            this.tpVAC2.Controls.Add(this.grpAudioStereo3);
            this.tpVAC2.Controls.Add(this.grpVAC2Latency);
            this.tpVAC2.Controls.Add(this.grpAudioSampleRate3);
            this.tpVAC2.Controls.Add(this.grpAudioBuffer3);
            this.tpVAC2.Controls.Add(this.grpAudioDetails3);
            this.tpVAC2.Controls.Add(this.chkVAC2Enable);
            this.tpVAC2.Location = new System.Drawing.Point(4, 22);
            this.tpVAC2.Name = "tpVAC2";
            this.tpVAC2.Padding = new System.Windows.Forms.Padding(3);
            this.tpVAC2.Size = new System.Drawing.Size(592, 318);
            this.tpVAC2.TabIndex = 2;
            this.tpVAC2.Text = "VAC 2";
            this.toolTip1.SetToolTip(this.tpVAC2, resources.GetString("tpVAC2.ToolTip"));
            // 
            // chkVAC2UseRX2
            // 
            this.chkVAC2UseRX2.Checked = true;
            this.chkVAC2UseRX2.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkVAC2UseRX2.Enabled = false;
            this.chkVAC2UseRX2.Image = null;
            this.chkVAC2UseRX2.Location = new System.Drawing.Point(132, 8);
            this.chkVAC2UseRX2.Name = "chkVAC2UseRX2";
            this.chkVAC2UseRX2.Size = new System.Drawing.Size(92, 24);
            this.chkVAC2UseRX2.TabIndex = 90;
            this.chkVAC2UseRX2.Text = "Use RX2";
            this.toolTip1.SetToolTip(this.chkVAC2UseRX2, "Use RX2 for VAC2");
            this.chkVAC2UseRX2.Visible = false;
            this.chkVAC2UseRX2.CheckedChanged += new System.EventHandler(this.chkVAC2UseRX2_CheckedChanged);
            // 
            // grpVAC2DirectIQ
            // 
            this.grpVAC2DirectIQ.Controls.Add(this.chkVAC2DirectIQCal);
            this.grpVAC2DirectIQ.Controls.Add(this.chkVAC2DirectIQ);
            this.grpVAC2DirectIQ.Location = new System.Drawing.Point(448, 56);
            this.grpVAC2DirectIQ.Name = "grpVAC2DirectIQ";
            this.grpVAC2DirectIQ.Size = new System.Drawing.Size(120, 88);
            this.grpVAC2DirectIQ.TabIndex = 89;
            this.grpVAC2DirectIQ.TabStop = false;
            this.grpVAC2DirectIQ.Text = "Direct I/Q";
            this.toolTip1.SetToolTip(this.grpVAC2DirectIQ, "Direct I/Q send the entire Panadapter (Sample Rate) contents\r\nacross the Virtual " +
        "Audio Cable.\r\n\r\nWhen Direct I/Q is disabled, only the bandpass audio is sent \r\no" +
        "ver the  the Virtual Audio Cable.");
            // 
            // chkVAC2DirectIQCal
            // 
            this.chkVAC2DirectIQCal.Checked = true;
            this.chkVAC2DirectIQCal.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkVAC2DirectIQCal.Enabled = false;
            this.chkVAC2DirectIQCal.Image = null;
            this.chkVAC2DirectIQCal.Location = new System.Drawing.Point(16, 46);
            this.chkVAC2DirectIQCal.Name = "chkVAC2DirectIQCal";
            this.chkVAC2DirectIQCal.Size = new System.Drawing.Size(88, 16);
            this.chkVAC2DirectIQCal.TabIndex = 1;
            this.chkVAC2DirectIQCal.Text = "Calibrate I/Q";
            this.chkVAC2DirectIQCal.CheckedChanged += new System.EventHandler(this.chkVAC2DirectIQCal_CheckedChanged);
            // 
            // chkVAC2DirectIQ
            // 
            this.chkVAC2DirectIQ.Image = null;
            this.chkVAC2DirectIQ.Location = new System.Drawing.Point(16, 24);
            this.chkVAC2DirectIQ.Name = "chkVAC2DirectIQ";
            this.chkVAC2DirectIQ.Size = new System.Drawing.Size(96, 16);
            this.chkVAC2DirectIQ.TabIndex = 0;
            this.chkVAC2DirectIQ.Text = "Output to VAC";
            this.chkVAC2DirectIQ.CheckedChanged += new System.EventHandler(this.chkVAC2DirectIQ_CheckedChanged);
            // 
            // chkVAC2Combine
            // 
            this.chkVAC2Combine.Enabled = false;
            this.chkVAC2Combine.Image = null;
            this.chkVAC2Combine.Location = new System.Drawing.Point(448, 16);
            this.chkVAC2Combine.Name = "chkVAC2Combine";
            this.chkVAC2Combine.Size = new System.Drawing.Size(104, 40);
            this.chkVAC2Combine.TabIndex = 88;
            this.chkVAC2Combine.Text = "Combine VAC Input Channels";
            this.toolTip1.SetToolTip(this.chkVAC2Combine, "When this feature is enabled, the left and right VAC channels are combined into t" +
        "he DSP transmit channel (left).");
            // 
            // grpVAC2AutoEnable
            // 
            this.grpVAC2AutoEnable.Controls.Add(this.chkVAC2AutoEnable);
            this.grpVAC2AutoEnable.Location = new System.Drawing.Point(8, 168);
            this.grpVAC2AutoEnable.Name = "grpVAC2AutoEnable";
            this.grpVAC2AutoEnable.Size = new System.Drawing.Size(224, 64);
            this.grpVAC2AutoEnable.TabIndex = 86;
            this.grpVAC2AutoEnable.TabStop = false;
            this.grpVAC2AutoEnable.Text = "Auto Enable";
            // 
            // chkVAC2AutoEnable
            // 
            this.chkVAC2AutoEnable.Enabled = false;
            this.chkVAC2AutoEnable.Image = null;
            this.chkVAC2AutoEnable.Location = new System.Drawing.Point(16, 24);
            this.chkVAC2AutoEnable.Name = "chkVAC2AutoEnable";
            this.chkVAC2AutoEnable.Size = new System.Drawing.Size(200, 32);
            this.chkVAC2AutoEnable.TabIndex = 0;
            this.chkVAC2AutoEnable.Text = "Enable for Digital modes on Mode change.  Disable for all other modes.";
            this.toolTip1.SetToolTip(this.chkVAC2AutoEnable, "Click this button to automatically enable VAC when in Digital modes (DIGL, DIGU, " +
        "DRM)");
            this.chkVAC2AutoEnable.CheckedChanged += new System.EventHandler(this.chkVAC2AutoEnable_CheckedChanged);
            // 
            // grpVAC2Gain
            // 
            this.grpVAC2Gain.Controls.Add(this.lblVAC2GainTX);
            this.grpVAC2Gain.Controls.Add(this.udVAC2GainTX);
            this.grpVAC2Gain.Controls.Add(this.lblVAC2GainRX);
            this.grpVAC2Gain.Controls.Add(this.udVAC2GainRX);
            this.grpVAC2Gain.Location = new System.Drawing.Point(344, 8);
            this.grpVAC2Gain.Name = "grpVAC2Gain";
            this.grpVAC2Gain.Size = new System.Drawing.Size(96, 80);
            this.grpVAC2Gain.TabIndex = 85;
            this.grpVAC2Gain.TabStop = false;
            this.grpVAC2Gain.Text = "Gain (dB)";
            // 
            // lblVAC2GainTX
            // 
            this.lblVAC2GainTX.Image = null;
            this.lblVAC2GainTX.Location = new System.Drawing.Point(16, 48);
            this.lblVAC2GainTX.Name = "lblVAC2GainTX";
            this.lblVAC2GainTX.Size = new System.Drawing.Size(32, 16);
            this.lblVAC2GainTX.TabIndex = 39;
            this.lblVAC2GainTX.Text = "TX:";
            // 
            // udVAC2GainTX
            // 
            this.udVAC2GainTX.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udVAC2GainTX.Location = new System.Drawing.Point(48, 48);
            this.udVAC2GainTX.Maximum = new decimal(new int[] {
            40,
            0,
            0,
            0});
            this.udVAC2GainTX.Minimum = new decimal(new int[] {
            40,
            0,
            0,
            -2147483648});
            this.udVAC2GainTX.Name = "udVAC2GainTX";
            this.udVAC2GainTX.Size = new System.Drawing.Size(40, 20);
            this.udVAC2GainTX.TabIndex = 38;
            this.toolTip1.SetToolTip(this.udVAC2GainTX, "Controls the gain on the audio coming from third party applications.");
            this.udVAC2GainTX.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udVAC2GainTX.ValueChanged += new System.EventHandler(this.udVAC2GainTX_ValueChanged);
            // 
            // lblVAC2GainRX
            // 
            this.lblVAC2GainRX.Image = null;
            this.lblVAC2GainRX.Location = new System.Drawing.Point(16, 24);
            this.lblVAC2GainRX.Name = "lblVAC2GainRX";
            this.lblVAC2GainRX.Size = new System.Drawing.Size(24, 16);
            this.lblVAC2GainRX.TabIndex = 37;
            this.lblVAC2GainRX.Text = "RX:";
            // 
            // udVAC2GainRX
            // 
            this.udVAC2GainRX.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udVAC2GainRX.Location = new System.Drawing.Point(48, 24);
            this.udVAC2GainRX.Maximum = new decimal(new int[] {
            40,
            0,
            0,
            0});
            this.udVAC2GainRX.Minimum = new decimal(new int[] {
            40,
            0,
            0,
            -2147483648});
            this.udVAC2GainRX.Name = "udVAC2GainRX";
            this.udVAC2GainRX.Size = new System.Drawing.Size(40, 20);
            this.udVAC2GainRX.TabIndex = 36;
            this.toolTip1.SetToolTip(this.udVAC2GainRX, "Controls the gain applied to the RX audio before it is sent to the third party ap" +
        "plication.");
            this.udVAC2GainRX.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udVAC2GainRX.ValueChanged += new System.EventHandler(this.udVAC2GainRX_ValueChanged);
            // 
            // grpAudioStereo3
            // 
            this.grpAudioStereo3.Controls.Add(this.chkAudioStereo3);
            this.grpAudioStereo3.Location = new System.Drawing.Point(240, 136);
            this.grpAudioStereo3.Name = "grpAudioStereo3";
            this.grpAudioStereo3.Size = new System.Drawing.Size(96, 56);
            this.grpAudioStereo3.TabIndex = 84;
            this.grpAudioStereo3.TabStop = false;
            this.grpAudioStereo3.Text = "Mono/Stereo";
            // 
            // chkAudioStereo3
            // 
            this.chkAudioStereo3.Image = null;
            this.chkAudioStereo3.Location = new System.Drawing.Point(16, 24);
            this.chkAudioStereo3.Name = "chkAudioStereo3";
            this.chkAudioStereo3.Size = new System.Drawing.Size(64, 16);
            this.chkAudioStereo3.TabIndex = 0;
            this.chkAudioStereo3.Text = "Stereo";
            this.toolTip1.SetToolTip(this.chkAudioStereo3, "Click this button if the third party software will open the Virtual Audio Cable i" +
        "n 2 channel (stereo) mode.");
            this.chkAudioStereo3.CheckedChanged += new System.EventHandler(this.chkAudioStereo3_CheckedChanged);
            // 
            // grpVAC2Latency
            // 
            this.grpVAC2Latency.Controls.Add(this.chkVAC2LatencyManual);
            this.grpVAC2Latency.Controls.Add(this.udVAC2Latency);
            this.grpVAC2Latency.Location = new System.Drawing.Point(448, 160);
            this.grpVAC2Latency.Name = "grpVAC2Latency";
            this.grpVAC2Latency.Size = new System.Drawing.Size(120, 64);
            this.grpVAC2Latency.TabIndex = 83;
            this.grpVAC2Latency.TabStop = false;
            this.grpVAC2Latency.Text = "Buffer Latency (ms)";
            // 
            // chkVAC2LatencyManual
            // 
            this.chkVAC2LatencyManual.Checked = true;
            this.chkVAC2LatencyManual.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkVAC2LatencyManual.Image = null;
            this.chkVAC2LatencyManual.Location = new System.Drawing.Point(19, 50);
            this.chkVAC2LatencyManual.Name = "chkVAC2LatencyManual";
            this.chkVAC2LatencyManual.Size = new System.Drawing.Size(64, 16);
            this.chkVAC2LatencyManual.TabIndex = 5;
            this.chkVAC2LatencyManual.Text = "Manual";
            this.chkVAC2LatencyManual.Visible = false;
            this.chkVAC2LatencyManual.CheckedChanged += new System.EventHandler(this.chkVAC2LatencyManual_CheckedChanged);
            // 
            // udVAC2Latency
            // 
            this.udVAC2Latency.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udVAC2Latency.Location = new System.Drawing.Point(35, 24);
            this.udVAC2Latency.Maximum = new decimal(new int[] {
            240,
            0,
            0,
            0});
            this.udVAC2Latency.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udVAC2Latency.Name = "udVAC2Latency";
            this.udVAC2Latency.Size = new System.Drawing.Size(48, 20);
            this.udVAC2Latency.TabIndex = 36;
            this.toolTip1.SetToolTip(this.udVAC2Latency, "Buffer latency for VAC2 audio stream.  Set to 0 for lowest latency.  \r\nIncrease t" +
        "his value if audio quality becomes unreliable or glitches ");
            this.udVAC2Latency.Value = new decimal(new int[] {
            120,
            0,
            0,
            0});
            this.udVAC2Latency.ValueChanged += new System.EventHandler(this.udVAC2Latency_ValueChanged);
            this.udVAC2Latency.LostFocus += new System.EventHandler(this.udVAC2Latency_LostFocus);
            // 
            // grpAudioSampleRate3
            // 
            this.grpAudioSampleRate3.Controls.Add(this.comboAudioSampleRate3);
            this.grpAudioSampleRate3.Location = new System.Drawing.Point(240, 72);
            this.grpAudioSampleRate3.Name = "grpAudioSampleRate3";
            this.grpAudioSampleRate3.Size = new System.Drawing.Size(96, 56);
            this.grpAudioSampleRate3.TabIndex = 82;
            this.grpAudioSampleRate3.TabStop = false;
            this.grpAudioSampleRate3.Text = "Sample Rate";
            // 
            // comboAudioSampleRate3
            // 
            this.comboAudioSampleRate3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioSampleRate3.DropDownWidth = 64;
            this.comboAudioSampleRate3.Items.AddRange(new object[] {
            "8000",
            "11025",
            "12000",
            "24000",
            "22050",
            "44100",
            "48000",
            "96000",
            "192000"});
            this.comboAudioSampleRate3.Location = new System.Drawing.Point(16, 24);
            this.comboAudioSampleRate3.Name = "comboAudioSampleRate3";
            this.comboAudioSampleRate3.Size = new System.Drawing.Size(64, 21);
            this.comboAudioSampleRate3.TabIndex = 60;
            this.comboAudioSampleRate3.SelectedIndexChanged += new System.EventHandler(this.comboAudioSampleRate3_SelectedIndexChanged);
            // 
            // grpAudioBuffer3
            // 
            this.grpAudioBuffer3.Controls.Add(this.comboAudioBuffer3);
            this.grpAudioBuffer3.Location = new System.Drawing.Point(240, 8);
            this.grpAudioBuffer3.Name = "grpAudioBuffer3";
            this.grpAudioBuffer3.Size = new System.Drawing.Size(96, 56);
            this.grpAudioBuffer3.TabIndex = 81;
            this.grpAudioBuffer3.TabStop = false;
            this.grpAudioBuffer3.Text = "Buffer Size";
            // 
            // comboAudioBuffer3
            // 
            this.comboAudioBuffer3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioBuffer3.DropDownWidth = 56;
            this.comboAudioBuffer3.Items.AddRange(new object[] {
            "512",
            "1024",
            "2048"});
            this.comboAudioBuffer3.Location = new System.Drawing.Point(16, 24);
            this.comboAudioBuffer3.Name = "comboAudioBuffer3";
            this.comboAudioBuffer3.Size = new System.Drawing.Size(56, 21);
            this.comboAudioBuffer3.TabIndex = 58;
            this.toolTip1.SetToolTip(this.comboAudioBuffer3, "Samples per buffer.");
            this.comboAudioBuffer3.SelectedIndexChanged += new System.EventHandler(this.comboAudioBuffer3_SelectedIndexChanged);
            // 
            // grpAudioDetails3
            // 
            this.grpAudioDetails3.Controls.Add(this.comboAudioOutput3);
            this.grpAudioDetails3.Controls.Add(this.comboAudioInput3);
            this.grpAudioDetails3.Controls.Add(this.lblAudioOutput3);
            this.grpAudioDetails3.Controls.Add(this.lblAudioInput3);
            this.grpAudioDetails3.Controls.Add(this.lblAudioDriver3);
            this.grpAudioDetails3.Controls.Add(this.comboAudioDriver3);
            this.grpAudioDetails3.Location = new System.Drawing.Point(8, 40);
            this.grpAudioDetails3.Name = "grpAudioDetails3";
            this.grpAudioDetails3.Size = new System.Drawing.Size(224, 120);
            this.grpAudioDetails3.TabIndex = 80;
            this.grpAudioDetails3.TabStop = false;
            this.grpAudioDetails3.Text = "Virtual Audio Cable Setup (to/from PC)";
            this.toolTip1.SetToolTip(this.grpAudioDetails3, resources.GetString("grpAudioDetails3.ToolTip"));
            // 
            // comboAudioOutput3
            // 
            this.comboAudioOutput3.DisplayMember = "sdfg";
            this.comboAudioOutput3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioOutput3.DropDownWidth = 160;
            this.comboAudioOutput3.ItemHeight = 13;
            this.comboAudioOutput3.Location = new System.Drawing.Point(56, 88);
            this.comboAudioOutput3.Name = "comboAudioOutput3";
            this.comboAudioOutput3.Size = new System.Drawing.Size(160, 21);
            this.comboAudioOutput3.TabIndex = 34;
            this.toolTip1.SetToolTip(this.comboAudioOutput3, "Select PC device for Audio Output FROM PowerSDR:\r\nOn your PC->Sound->Playback dev" +
        "ices");
            this.comboAudioOutput3.SelectedIndexChanged += new System.EventHandler(this.comboAudioOutput3_SelectedIndexChanged);
            // 
            // comboAudioInput3
            // 
            this.comboAudioInput3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioInput3.DropDownWidth = 160;
            this.comboAudioInput3.ItemHeight = 13;
            this.comboAudioInput3.Location = new System.Drawing.Point(56, 56);
            this.comboAudioInput3.Name = "comboAudioInput3";
            this.comboAudioInput3.Size = new System.Drawing.Size(160, 21);
            this.comboAudioInput3.TabIndex = 28;
            this.toolTip1.SetToolTip(this.comboAudioInput3, "Select PC device for Audio Input TO PowerSDR:\r\nOn your PC->Sound->Recording devic" +
        "es");
            this.comboAudioInput3.SelectedIndexChanged += new System.EventHandler(this.comboAudioInput3_SelectedIndexChanged);
            // 
            // lblAudioOutput3
            // 
            this.lblAudioOutput3.Image = null;
            this.lblAudioOutput3.Location = new System.Drawing.Point(3, 85);
            this.lblAudioOutput3.Name = "lblAudioOutput3";
            this.lblAudioOutput3.Size = new System.Drawing.Size(56, 32);
            this.lblAudioOutput3.TabIndex = 35;
            this.lblAudioOutput3.Text = "Output: PC play";
            this.toolTip1.SetToolTip(this.lblAudioOutput3, "Select PC device for Audio Output FROM PowerSDR:\r\nOn your PC->Sound->Playback dev" +
        "ices");
            // 
            // lblAudioInput3
            // 
            this.lblAudioInput3.Image = null;
            this.lblAudioInput3.Location = new System.Drawing.Point(3, 53);
            this.lblAudioInput3.Name = "lblAudioInput3";
            this.lblAudioInput3.Size = new System.Drawing.Size(51, 32);
            this.lblAudioInput3.TabIndex = 33;
            this.lblAudioInput3.Text = "Input:  PC rec";
            this.toolTip1.SetToolTip(this.lblAudioInput3, "Select PC device for Audio Input TO PowerSDR:\r\nOn your PC->Sound->Recording devic" +
        "es");
            // 
            // lblAudioDriver3
            // 
            this.lblAudioDriver3.Image = null;
            this.lblAudioDriver3.Location = new System.Drawing.Point(8, 24);
            this.lblAudioDriver3.Name = "lblAudioDriver3";
            this.lblAudioDriver3.Size = new System.Drawing.Size(40, 16);
            this.lblAudioDriver3.TabIndex = 32;
            this.lblAudioDriver3.Text = "Driver:";
            // 
            // comboAudioDriver3
            // 
            this.comboAudioDriver3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAudioDriver3.DropDownWidth = 160;
            this.comboAudioDriver3.ItemHeight = 13;
            this.comboAudioDriver3.Location = new System.Drawing.Point(56, 24);
            this.comboAudioDriver3.Name = "comboAudioDriver3";
            this.comboAudioDriver3.Size = new System.Drawing.Size(160, 21);
            this.comboAudioDriver3.TabIndex = 26;
            this.toolTip1.SetToolTip(this.comboAudioDriver3, "Sound Card Driver Selection");
            this.comboAudioDriver3.SelectedIndexChanged += new System.EventHandler(this.comboAudioDriver3_SelectedIndexChanged);
            // 
            // chkVAC2Enable
            // 
            this.chkVAC2Enable.Enabled = false;
            this.chkVAC2Enable.Image = null;
            this.chkVAC2Enable.Location = new System.Drawing.Point(16, 8);
            this.chkVAC2Enable.Name = "chkVAC2Enable";
            this.chkVAC2Enable.Size = new System.Drawing.Size(110, 24);
            this.chkVAC2Enable.TabIndex = 79;
            this.chkVAC2Enable.Text = "Enable VAC 2";
            this.toolTip1.SetToolTip(this.chkVAC2Enable, "Enable Virtual Audio Cable for VAC 2 (RX2 only)");
            this.chkVAC2Enable.CheckedChanged += new System.EventHandler(this.chkVAC2Enable_CheckedChanged);
            // 
            // tpDisplay
            // 
            this.tpDisplay.Controls.Add(this.tbAGCTadj);
            this.tpDisplay.Controls.Add(this.labelTS38);
            this.tpDisplay.Controls.Add(this.chkSpectrumHiRes);
            this.tpDisplay.Controls.Add(this.chkSpectrumPolyphase);
            this.tpDisplay.Controls.Add(this.check3DPan);
            this.tpDisplay.Controls.Add(this.chkAvgMove);
            this.tpDisplay.Controls.Add(this.chkBoxSplitListen);
            this.tpDisplay.Controls.Add(this.chkBoxDial);
            this.tpDisplay.Controls.Add(this.chkBoxMRX);
            this.tpDisplay.Controls.Add(this.labelTS14);
            this.tpDisplay.Controls.Add(this.tbWaterOffset);
            this.tpDisplay.Controls.Add(this.labelTS13);
            this.tpDisplay.Controls.Add(this.tbGridOffset);
            this.tpDisplay.Controls.Add(this.grpDisplayMultimeter);
            this.tpDisplay.Controls.Add(this.grpDisplayDriverEngine);
            this.tpDisplay.Controls.Add(this.grpDisplayScopeMode);
            this.tpDisplay.Controls.Add(this.grpDisplayWaterfall);
            this.tpDisplay.Controls.Add(this.grpDisplayRefreshRates);
            this.tpDisplay.Controls.Add(this.grpDisplayAverage);
            this.tpDisplay.Controls.Add(this.grpDisplayPhase);
            this.tpDisplay.Controls.Add(this.grpDisplaySpectrumGrid);
            this.tpDisplay.Controls.Add(this.chkBoxAutoWtrPan);
            this.tpDisplay.Location = new System.Drawing.Point(4, 22);
            this.tpDisplay.Name = "tpDisplay";
            this.tpDisplay.Size = new System.Drawing.Size(584, 341);
            this.tpDisplay.TabIndex = 2;
            this.tpDisplay.Text = "Display";
            // 
            // tbAGCTadj
            // 
            this.tbAGCTadj.AutoSize = false;
            this.tbAGCTadj.LargeChange = 10;
            this.tbAGCTadj.Location = new System.Drawing.Point(350, 315);
            this.tbAGCTadj.Maximum = 1900;
            this.tbAGCTadj.Minimum = 1300;
            this.tbAGCTadj.Name = "tbAGCTadj";
            this.tbAGCTadj.Size = new System.Drawing.Size(66, 18);
            this.tbAGCTadj.TabIndex = 96;
            this.tbAGCTadj.TickFrequency = 100;
            this.toolTip1.SetToolTip(this.tbAGCTadj, "Right Click on AGC-T (main console screen) to activate AGC-T Green line on Panada" +
        "pter.\r\n\r\nUse this slider to adjust where the Green line falls on the panadapter " +
        "vs the AGC-T gain value.\r\n");
            this.tbAGCTadj.Value = 1615;
            this.tbAGCTadj.Scroll += new System.EventHandler(this.tbAGCTadj_Scroll);
            // 
            // labelTS38
            // 
            this.labelTS38.Image = null;
            this.labelTS38.Location = new System.Drawing.Point(270, 314);
            this.labelTS38.Name = "labelTS38";
            this.labelTS38.Size = new System.Drawing.Size(86, 18);
            this.labelTS38.TabIndex = 95;
            this.labelTS38.Text = "AGC-T line adj:";
            this.toolTip1.SetToolTip(this.labelTS38, resources.GetString("labelTS38.ToolTip"));
            // 
            // chkSpectrumHiRes
            // 
            this.chkSpectrumHiRes.Checked = true;
            this.chkSpectrumHiRes.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkSpectrumHiRes.Image = null;
            this.chkSpectrumHiRes.Location = new System.Drawing.Point(417, 104);
            this.chkSpectrumHiRes.Name = "chkSpectrumHiRes";
            this.chkSpectrumHiRes.Size = new System.Drawing.Size(159, 16);
            this.chkSpectrumHiRes.TabIndex = 94;
            this.chkSpectrumHiRes.Text = "Hi-Res PanaFall";
            this.toolTip1.SetToolTip(this.chkSpectrumHiRes, resources.GetString("chkSpectrumHiRes.ToolTip"));
            this.chkSpectrumHiRes.CheckedChanged += new System.EventHandler(this.ChkSpectrumHiRes_CheckedChanged);
            // 
            // chkSpectrumPolyphase
            // 
            this.chkSpectrumPolyphase.Image = null;
            this.chkSpectrumPolyphase.Location = new System.Drawing.Point(417, 123);
            this.chkSpectrumPolyphase.Name = "chkSpectrumPolyphase";
            this.chkSpectrumPolyphase.Size = new System.Drawing.Size(159, 16);
            this.chkSpectrumPolyphase.TabIndex = 39;
            this.chkSpectrumPolyphase.Text = "Enable PolyPhaseFFT";
            this.toolTip1.SetToolTip(this.chkSpectrumPolyphase, "Check to enable FFT Polyphase spectrum display mode. \r\nWhile adding latency, this" +
        " adds resolution to the display.");
            this.chkSpectrumPolyphase.CheckedChanged += new System.EventHandler(this.chkSpectrumPolyphase_CheckedChanged);
            // 
            // check3DPan
            // 
            this.check3DPan.Image = null;
            this.check3DPan.Location = new System.Drawing.Point(312, 100);
            this.check3DPan.Name = "check3DPan";
            this.check3DPan.Size = new System.Drawing.Size(105, 23);
            this.check3DPan.TabIndex = 93;
            this.check3DPan.Text = "3D Pan";
            this.toolTip1.SetToolTip(this.check3DPan, "When Checked, the Panadapter will show history be showing depth.\r\nThe deeper in, " +
        "the older the signal.");
            // 
            // chkAvgMove
            // 
            this.chkAvgMove.Checked = false;
            this.chkAvgMove.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkAvgMove.Image = null;
            this.chkAvgMove.Location = new System.Drawing.Point(312, 120);
            this.chkAvgMove.Name = "chkAvgMove";
            this.chkAvgMove.Size = new System.Drawing.Size(105, 23);
            this.chkAvgMove.TabIndex = 92;
            this.chkAvgMove.Text = "Avg Pan Move";
            this.toolTip1.SetToolTip(this.chkAvgMove, "When Checked, will attempt to correctly move the Panadapter display left/right wh" +
        "en AVG enabled\r\nto prevent loss of signals on display while scrolling left/right" +
        "");
            // 
            // chkBoxSplitListen
            // 
            this.chkBoxSplitListen.Image = null;
            this.chkBoxSplitListen.Location = new System.Drawing.Point(430, 289);
            this.chkBoxSplitListen.Name = "chkBoxSplitListen";
            this.chkBoxSplitListen.Size = new System.Drawing.Size(138, 15);
            this.chkBoxSplitListen.TabIndex = 90;
            this.chkBoxSplitListen.Text = "Split TX Listen";
            this.toolTip1.SetToolTip(this.chkBoxSplitListen, "Check to automatically listen to the Split TX frequency\r\n (XFC)");
            // 
            // chkBoxDial
            // 
            this.chkBoxDial.Image = null;
            this.chkBoxDial.Location = new System.Drawing.Point(430, 307);
            this.chkBoxDial.Name = "chkBoxDial";
            this.chkBoxDial.Size = new System.Drawing.Size(138, 15);
            this.chkBoxDial.TabIndex = 89;
            this.chkBoxDial.Text = "VFO Dials";
            this.toolTip1.SetToolTip(this.chkBoxDial, "Mechanical Dials next to each VFOA and VFOB\r\n\r\nWill only turn ON when the Console" +
        " WIDTH > 1400 pixels");
            this.chkBoxDial.CheckedChanged += new System.EventHandler(this.chkBoxDial_CheckedChanged);
            // 
            // chkBoxMRX
            // 
            this.chkBoxMRX.Image = null;
            this.chkBoxMRX.Location = new System.Drawing.Point(430, 272);
            this.chkBoxMRX.Name = "chkBoxMRX";
            this.chkBoxMRX.Size = new System.Drawing.Size(138, 15);
            this.chkBoxMRX.TabIndex = 88;
            this.chkBoxMRX.Text = "MultiRX Auto Reset";
            this.toolTip1.SetToolTip(this.chkBoxMRX, "Check to Zero out MultiRX every time you turn in OFF and Back ON");
            this.chkBoxMRX.CheckedChanged += new System.EventHandler(this.chkBoxMRX_CheckedChanged);
            // 
            // labelTS14
            // 
            this.labelTS14.Image = null;
            this.labelTS14.Location = new System.Drawing.Point(270, 295);
            this.labelTS14.Name = "labelTS14";
            this.labelTS14.Size = new System.Drawing.Size(75, 18);
            this.labelTS14.TabIndex = 87;
            this.labelTS14.Text = "auto wtr level:";
            this.toolTip1.SetToolTip(this.labelTS14, resources.GetString("labelTS14.ToolTip"));
            // 
            // tbWaterOffset
            // 
            this.tbWaterOffset.AutoSize = false;
            this.tbWaterOffset.LargeChange = 1;
            this.tbWaterOffset.Location = new System.Drawing.Point(350, 295);
            this.tbWaterOffset.Maximum = 40;
            this.tbWaterOffset.Name = "tbWaterOffset";
            this.tbWaterOffset.Size = new System.Drawing.Size(66, 18);
            this.tbWaterOffset.TabIndex = 86;
            this.tbWaterOffset.TickFrequency = 4;
            this.toolTip1.SetToolTip(this.tbWaterOffset, resources.GetString("tbWaterOffset.ToolTip"));
            this.tbWaterOffset.Value = 20;
            this.tbWaterOffset.Scroll += new System.EventHandler(this.tbWaterOffset_Scroll);
            // 
            // labelTS13
            // 
            this.labelTS13.Image = null;
            this.labelTS13.Location = new System.Drawing.Point(270, 277);
            this.labelTS13.Name = "labelTS13";
            this.labelTS13.Size = new System.Drawing.Size(86, 18);
            this.labelTS13.TabIndex = 85;
            this.labelTS13.Text = "auto grid level:";
            this.toolTip1.SetToolTip(this.labelTS13, resources.GetString("labelTS13.ToolTip"));
            // 
            // tbGridOffset
            // 
            this.tbGridOffset.AutoSize = false;
            this.tbGridOffset.LargeChange = 1;
            this.tbGridOffset.Location = new System.Drawing.Point(350, 273);
            this.tbGridOffset.Maximum = 40;
            this.tbGridOffset.Name = "tbGridOffset";
            this.tbGridOffset.Size = new System.Drawing.Size(66, 18);
            this.tbGridOffset.TabIndex = 84;
            this.tbGridOffset.TickFrequency = 4;
            this.toolTip1.SetToolTip(this.tbGridOffset, resources.GetString("tbGridOffset.ToolTip"));
            this.tbGridOffset.Value = 20;
            this.tbGridOffset.Scroll += new System.EventHandler(this.tbGridOffset_Scroll);
            // 
            // grpDisplayMultimeter
            // 
            this.grpDisplayMultimeter.Controls.Add(this.udSS2H);
            this.grpDisplayMultimeter.Controls.Add(this.udSS1H);
            this.grpDisplayMultimeter.Controls.Add(this.udSS1);
            this.grpDisplayMultimeter.Controls.Add(this.udSS2);
            this.grpDisplayMultimeter.Controls.Add(this.chkDisplayMeterShowDecimal);
            this.grpDisplayMultimeter.Controls.Add(this.udMeterDigitalDelay);
            this.grpDisplayMultimeter.Controls.Add(this.lblMultimeterDigitalDelay);
            this.grpDisplayMultimeter.Controls.Add(this.udDisplayMeterAvg);
            this.grpDisplayMultimeter.Controls.Add(this.lblDisplayMeterAvg);
            this.grpDisplayMultimeter.Controls.Add(this.udDisplayMultiTextHoldTime);
            this.grpDisplayMultimeter.Controls.Add(this.lblDisplayMeterTextHoldTime);
            this.grpDisplayMultimeter.Controls.Add(this.udDisplayMultiPeakHoldTime);
            this.grpDisplayMultimeter.Controls.Add(this.lblDisplayMultiPeakHoldTime);
            this.grpDisplayMultimeter.Controls.Add(this.udDisplayMeterDelay);
            this.grpDisplayMultimeter.Controls.Add(this.lblDisplayMeterDelay);
            this.grpDisplayMultimeter.Location = new System.Drawing.Point(272, 140);
            this.grpDisplayMultimeter.Name = "grpDisplayMultimeter";
            this.grpDisplayMultimeter.Size = new System.Drawing.Size(304, 129);
            this.grpDisplayMultimeter.TabIndex = 41;
            this.grpDisplayMultimeter.TabStop = false;
            this.grpDisplayMultimeter.Text = "Multimeter";
            // 
            // udSS2H
            // 
            this.udSS2H.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udSS2H.Location = new System.Drawing.Point(216, 61);
            this.udSS2H.Maximum = new decimal(new int[] {
            999,
            0,
            0,
            0});
            this.udSS2H.Minimum = new decimal(new int[] {
            999,
            0,
            0,
            -2147483648});
            this.udSS2H.Name = "udSS2H";
            this.udSS2H.Size = new System.Drawing.Size(72, 20);
            this.udSS2H.TabIndex = 44;
            this.toolTip1.SetToolTip(this.udSS2H, "position of panafall8020");
            this.udSS2H.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udSS2H.Visible = false;
            // 
            // udSS1H
            // 
            this.udSS1H.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udSS1H.Location = new System.Drawing.Point(216, 37);
            this.udSS1H.Maximum = new decimal(new int[] {
            999,
            0,
            0,
            0});
            this.udSS1H.Minimum = new decimal(new int[] {
            999,
            0,
            0,
            -2147483648});
            this.udSS1H.Name = "udSS1H";
            this.udSS1H.Size = new System.Drawing.Size(72, 20);
            this.udSS1H.TabIndex = 43;
            this.toolTip1.SetToolTip(this.udSS1H, "position of panafall8020");
            this.udSS1H.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udSS1H.Visible = false;
            // 
            // udSS1
            // 
            this.udSS1.DecimalPlaces = 5;
            this.udSS1.Increment = new decimal(new int[] {
            1,
            0,
            0,
            196608});
            this.udSS1.Location = new System.Drawing.Point(216, 85);
            this.udSS1.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            131072});
            this.udSS1.Minimum = new decimal(new int[] {
            5,
            0,
            0,
            65536});
            this.udSS1.Name = "udSS1";
            this.udSS1.Size = new System.Drawing.Size(72, 20);
            this.udSS1.TabIndex = 42;
            this.toolTip1.SetToolTip(this.udSS1, "position of panafall8020");
            this.udSS1.Value = new decimal(new int[] {
            83333,
            0,
            0,
            327680});
            this.udSS1.Visible = false;
            // 
            // udSS2
            // 
            this.udSS2.DecimalPlaces = 5;
            this.udSS2.Increment = new decimal(new int[] {
            1,
            0,
            0,
            196608});
            this.udSS2.Location = new System.Drawing.Point(216, 105);
            this.udSS2.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udSS2.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udSS2.Name = "udSS2";
            this.udSS2.Size = new System.Drawing.Size(72, 20);
            this.udSS2.TabIndex = 41;
            this.toolTip1.SetToolTip(this.udSS2, "position of panafall");
            this.udSS2.Value = new decimal(new int[] {
            5,
            0,
            0,
            65536});
            this.udSS2.Visible = false;
            // 
            // chkDisplayMeterShowDecimal
            // 
            this.chkDisplayMeterShowDecimal.Image = null;
            this.chkDisplayMeterShowDecimal.Location = new System.Drawing.Point(200, 16);
            this.chkDisplayMeterShowDecimal.Name = "chkDisplayMeterShowDecimal";
            this.chkDisplayMeterShowDecimal.Size = new System.Drawing.Size(96, 16);
            this.chkDisplayMeterShowDecimal.TabIndex = 40;
            this.chkDisplayMeterShowDecimal.Text = "Show Decimal";
            this.toolTip1.SetToolTip(this.chkDisplayMeterShowDecimal, "Check to show detailed meter info");
            this.chkDisplayMeterShowDecimal.CheckedChanged += new System.EventHandler(this.chkDisplayMeterShowDecimal_CheckedChanged);
            // 
            // udMeterDigitalDelay
            // 
            this.udMeterDigitalDelay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udMeterDigitalDelay.Location = new System.Drawing.Point(136, 106);
            this.udMeterDigitalDelay.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udMeterDigitalDelay.Minimum = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udMeterDigitalDelay.Name = "udMeterDigitalDelay";
            this.udMeterDigitalDelay.Size = new System.Drawing.Size(56, 20);
            this.udMeterDigitalDelay.TabIndex = 36;
            this.toolTip1.SetToolTip(this.udMeterDigitalDelay, "Digital (text) Multimeter Refresh Rate.");
            this.udMeterDigitalDelay.Value = new decimal(new int[] {
            500,
            0,
            0,
            0});
            this.udMeterDigitalDelay.ValueChanged += new System.EventHandler(this.udMeterDigitalDelay_ValueChanged);
            // 
            // lblMultimeterDigitalDelay
            // 
            this.lblMultimeterDigitalDelay.Image = null;
            this.lblMultimeterDigitalDelay.Location = new System.Drawing.Point(16, 108);
            this.lblMultimeterDigitalDelay.Name = "lblMultimeterDigitalDelay";
            this.lblMultimeterDigitalDelay.Size = new System.Drawing.Size(120, 16);
            this.lblMultimeterDigitalDelay.TabIndex = 35;
            this.lblMultimeterDigitalDelay.Text = "Digital Refresh (ms):";
            // 
            // udDisplayMeterAvg
            // 
            this.udDisplayMeterAvg.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayMeterAvg.Location = new System.Drawing.Point(136, 60);
            this.udDisplayMeterAvg.Maximum = new decimal(new int[] {
            99999,
            0,
            0,
            0});
            this.udDisplayMeterAvg.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayMeterAvg.Name = "udDisplayMeterAvg";
            this.udDisplayMeterAvg.Size = new System.Drawing.Size(56, 20);
            this.udDisplayMeterAvg.TabIndex = 8;
            this.toolTip1.SetToolTip(this.udDisplayMeterAvg, "Controls the length of time to average for the meter.");
            this.udDisplayMeterAvg.Value = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udDisplayMeterAvg.ValueChanged += new System.EventHandler(this.udDisplayMeterAvg_ValueChanged);
            this.udDisplayMeterAvg.LostFocus += new System.EventHandler(this.udDisplayMeterAvg_LostFocus);
            // 
            // lblDisplayMeterAvg
            // 
            this.lblDisplayMeterAvg.Image = null;
            this.lblDisplayMeterAvg.Location = new System.Drawing.Point(16, 63);
            this.lblDisplayMeterAvg.Name = "lblDisplayMeterAvg";
            this.lblDisplayMeterAvg.Size = new System.Drawing.Size(112, 16);
            this.lblDisplayMeterAvg.TabIndex = 7;
            this.lblDisplayMeterAvg.Text = "Average Time (ms):";
            this.toolTip1.SetToolTip(this.lblDisplayMeterAvg, "The time to average the value when Sig Avg is selected on the RX Meter.");
            // 
            // udDisplayMultiTextHoldTime
            // 
            this.udDisplayMultiTextHoldTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayMultiTextHoldTime.Location = new System.Drawing.Point(136, 37);
            this.udDisplayMultiTextHoldTime.Maximum = new decimal(new int[] {
            99999,
            0,
            0,
            0});
            this.udDisplayMultiTextHoldTime.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayMultiTextHoldTime.Name = "udDisplayMultiTextHoldTime";
            this.udDisplayMultiTextHoldTime.Size = new System.Drawing.Size(56, 20);
            this.udDisplayMultiTextHoldTime.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udDisplayMultiTextHoldTime, "Controls how long the meter will hold the digital peak value when in the Peak Pow" +
        "er mode.");
            this.udDisplayMultiTextHoldTime.Value = new decimal(new int[] {
            500,
            0,
            0,
            0});
            this.udDisplayMultiTextHoldTime.ValueChanged += new System.EventHandler(this.udDisplayMultiTextHoldTime_ValueChanged);
            this.udDisplayMultiTextHoldTime.LostFocus += new System.EventHandler(this.udDisplayMultiTextHoldTime_LostFocus);
            // 
            // lblDisplayMeterTextHoldTime
            // 
            this.lblDisplayMeterTextHoldTime.Image = null;
            this.lblDisplayMeterTextHoldTime.Location = new System.Drawing.Point(16, 40);
            this.lblDisplayMeterTextHoldTime.Name = "lblDisplayMeterTextHoldTime";
            this.lblDisplayMeterTextHoldTime.Size = new System.Drawing.Size(120, 16);
            this.lblDisplayMeterTextHoldTime.TabIndex = 3;
            this.lblDisplayMeterTextHoldTime.Text = "Digital Peak Hold (ms):";
            // 
            // udDisplayMultiPeakHoldTime
            // 
            this.udDisplayMultiPeakHoldTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayMultiPeakHoldTime.Location = new System.Drawing.Point(136, 14);
            this.udDisplayMultiPeakHoldTime.Maximum = new decimal(new int[] {
            99999,
            0,
            0,
            0});
            this.udDisplayMultiPeakHoldTime.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDisplayMultiPeakHoldTime.Name = "udDisplayMultiPeakHoldTime";
            this.udDisplayMultiPeakHoldTime.Size = new System.Drawing.Size(56, 20);
            this.udDisplayMultiPeakHoldTime.TabIndex = 1;
            this.toolTip1.SetToolTip(this.udDisplayMultiPeakHoldTime, "Controls how long the analog peak red line will be held on the multimeter.");
            this.udDisplayMultiPeakHoldTime.Value = new decimal(new int[] {
            2500,
            0,
            0,
            0});
            this.udDisplayMultiPeakHoldTime.ValueChanged += new System.EventHandler(this.udDisplayMultiPeakHoldTime_ValueChanged);
            this.udDisplayMultiPeakHoldTime.LostFocus += new System.EventHandler(this.udDisplayMultiPeakHoldTime_LostFocus);
            // 
            // lblDisplayMultiPeakHoldTime
            // 
            this.lblDisplayMultiPeakHoldTime.Image = null;
            this.lblDisplayMultiPeakHoldTime.Location = new System.Drawing.Point(16, 18);
            this.lblDisplayMultiPeakHoldTime.Name = "lblDisplayMultiPeakHoldTime";
            this.lblDisplayMultiPeakHoldTime.Size = new System.Drawing.Size(128, 16);
            this.lblDisplayMultiPeakHoldTime.TabIndex = 0;
            this.lblDisplayMultiPeakHoldTime.Text = "Analog Peak Hold (ms):";
            // 
            // udDisplayMeterDelay
            // 
            this.udDisplayMeterDelay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayMeterDelay.Location = new System.Drawing.Point(136, 83);
            this.udDisplayMeterDelay.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udDisplayMeterDelay.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDisplayMeterDelay.Name = "udDisplayMeterDelay";
            this.udDisplayMeterDelay.Size = new System.Drawing.Size(56, 20);
            this.udDisplayMeterDelay.TabIndex = 34;
            this.toolTip1.SetToolTip(this.udDisplayMeterDelay, "Analog Multimeter Refresh Rate.");
            this.udDisplayMeterDelay.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udDisplayMeterDelay.ValueChanged += new System.EventHandler(this.udDisplayMeterDelay_ValueChanged);
            this.udDisplayMeterDelay.LostFocus += new System.EventHandler(this.udDisplayMeterDelay_LostFocus);
            // 
            // lblDisplayMeterDelay
            // 
            this.lblDisplayMeterDelay.Image = null;
            this.lblDisplayMeterDelay.Location = new System.Drawing.Point(16, 85);
            this.lblDisplayMeterDelay.Name = "lblDisplayMeterDelay";
            this.lblDisplayMeterDelay.Size = new System.Drawing.Size(128, 16);
            this.lblDisplayMeterDelay.TabIndex = 33;
            this.lblDisplayMeterDelay.Text = "Analog Refresh (ms):";
            // 
            // grpDisplayDriverEngine
            // 
            this.grpDisplayDriverEngine.Controls.Add(this.comboDisplayDriver);
            this.grpDisplayDriverEngine.Location = new System.Drawing.Point(480, 144);
            this.grpDisplayDriverEngine.Name = "grpDisplayDriverEngine";
            this.grpDisplayDriverEngine.Size = new System.Drawing.Size(96, 56);
            this.grpDisplayDriverEngine.TabIndex = 46;
            this.grpDisplayDriverEngine.TabStop = false;
            this.grpDisplayDriverEngine.Text = "Driver Engine";
            this.grpDisplayDriverEngine.Visible = false;
            // 
            // comboDisplayDriver
            // 
            this.comboDisplayDriver.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDisplayDriver.DropDownWidth = 48;
            this.comboDisplayDriver.Items.AddRange(new object[] {
            "GDI+"});
            this.comboDisplayDriver.Location = new System.Drawing.Point(8, 24);
            this.comboDisplayDriver.Name = "comboDisplayDriver";
            this.comboDisplayDriver.Size = new System.Drawing.Size(80, 21);
            this.comboDisplayDriver.TabIndex = 45;
            this.toolTip1.SetToolTip(this.comboDisplayDriver, "Sets the driver to be used for the display.");
            this.comboDisplayDriver.SelectedIndexChanged += new System.EventHandler(this.comboDisplayDriver_SelectedIndexChanged);
            // 
            // grpDisplayScopeMode
            // 
            this.grpDisplayScopeMode.Controls.Add(this.checkBoxScopeAC);
            this.grpDisplayScopeMode.Controls.Add(this.udDisplayScopeTime);
            this.grpDisplayScopeMode.Controls.Add(this.lblDisplayScopeTime);
            this.grpDisplayScopeMode.Location = new System.Drawing.Point(440, 8);
            this.grpDisplayScopeMode.Name = "grpDisplayScopeMode";
            this.grpDisplayScopeMode.Size = new System.Drawing.Size(136, 82);
            this.grpDisplayScopeMode.TabIndex = 43;
            this.grpDisplayScopeMode.TabStop = false;
            this.grpDisplayScopeMode.Text = "Scope Mode";
            // 
            // checkBoxScopeAC
            // 
            this.checkBoxScopeAC.Image = null;
            this.checkBoxScopeAC.Location = new System.Drawing.Point(11, 52);
            this.checkBoxScopeAC.Name = "checkBoxScopeAC";
            this.checkBoxScopeAC.Size = new System.Drawing.Size(109, 16);
            this.checkBoxScopeAC.TabIndex = 40;
            this.checkBoxScopeAC.Text = "View AC mode";
            this.toolTip1.SetToolTip(this.checkBoxScopeAC, "When checked the Scope displays as though in AC mode.");
            this.checkBoxScopeAC.Visible = false;
            // 
            // udDisplayScopeTime
            // 
            this.udDisplayScopeTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayScopeTime.Location = new System.Drawing.Point(64, 19);
            this.udDisplayScopeTime.Maximum = new decimal(new int[] {
            1000000,
            0,
            0,
            0});
            this.udDisplayScopeTime.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayScopeTime.Name = "udDisplayScopeTime";
            this.udDisplayScopeTime.Size = new System.Drawing.Size(64, 20);
            this.udDisplayScopeTime.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udDisplayScopeTime, "Amount of time to display across the width of the scope display window.");
            this.udDisplayScopeTime.Value = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udDisplayScopeTime.ValueChanged += new System.EventHandler(this.udDisplayScopeTime_ValueChanged);
            this.udDisplayScopeTime.LostFocus += new System.EventHandler(this.udDisplayScopeTime_LostFocus);
            // 
            // lblDisplayScopeTime
            // 
            this.lblDisplayScopeTime.Image = null;
            this.lblDisplayScopeTime.Location = new System.Drawing.Point(6, 19);
            this.lblDisplayScopeTime.Name = "lblDisplayScopeTime";
            this.lblDisplayScopeTime.Size = new System.Drawing.Size(64, 23);
            this.lblDisplayScopeTime.TabIndex = 1;
            this.lblDisplayScopeTime.Text = "Time (us):";
            // 
            // grpDisplayWaterfall
            // 
            this.grpDisplayWaterfall.Controls.Add(this.checkWaterMoveSize);
            this.grpDisplayWaterfall.Controls.Add(this.labelTS6);
            this.grpDisplayWaterfall.Controls.Add(this.udDisplayWaterfallMicLevel);
            this.grpDisplayWaterfall.Controls.Add(this.udDisplayWaterfallRX2Level);
            this.grpDisplayWaterfall.Controls.Add(this.labelTS5);
            this.grpDisplayWaterfall.Controls.Add(this.chkWeakSignalWaterfallSettings);
            this.grpDisplayWaterfall.Controls.Add(this.lblWaterfallLevels);
            this.grpDisplayWaterfall.Controls.Add(this.txtWaterFallBandLevel);
            this.grpDisplayWaterfall.Controls.Add(this.udDisplayWaterfallUpdatePeriod);
            this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallUpdatePeriod);
            this.grpDisplayWaterfall.Controls.Add(this.udDisplayWaterfallAvgTime);
            this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallAverageTime);
            this.grpDisplayWaterfall.Controls.Add(this.clrbtnWaterfallLow);
            this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallLowColor);
            this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallLowLevel);
            this.grpDisplayWaterfall.Controls.Add(this.udDisplayWaterfallLowLevel);
            this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallHighLevel);
            this.grpDisplayWaterfall.Controls.Add(this.udDisplayWaterfallHighLevel);
            this.grpDisplayWaterfall.Location = new System.Drawing.Point(8, 140);
            this.grpDisplayWaterfall.Name = "grpDisplayWaterfall";
            this.grpDisplayWaterfall.Size = new System.Drawing.Size(256, 193);
            this.grpDisplayWaterfall.TabIndex = 40;
            this.grpDisplayWaterfall.TabStop = false;
            this.grpDisplayWaterfall.Text = "Waterfall";
            // 
            // checkWaterMoveSize
            // 
            this.checkWaterMoveSize.Checked = true;
            this.checkWaterMoveSize.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkWaterMoveSize.Image = null;
            this.checkWaterMoveSize.Location = new System.Drawing.Point(11, 157);
            this.checkWaterMoveSize.Name = "checkWaterMoveSize";
            this.checkWaterMoveSize.Size = new System.Drawing.Size(217, 18);
            this.checkWaterMoveSize.TabIndex = 80;
            this.checkWaterMoveSize.Text = "Enable wider waterfall before refresh";
            this.toolTip1.SetToolTip(this.checkWaterMoveSize, "Check to enable a wider moving waterfall history.\r\nThis allows for more scanning " +
        "left/right before a waterfall \r\nrefresh is needed. But takes more time to displa" +
        "y.");
            this.checkWaterMoveSize.CheckedChanged += new System.EventHandler(this.checkWaterMoveSize_CheckedChanged);
            // 
            // labelTS6
            // 
            this.labelTS6.Image = null;
            this.labelTS6.Location = new System.Drawing.Point(126, 66);
            this.labelTS6.Name = "labelTS6";
            this.labelTS6.Size = new System.Drawing.Size(64, 23);
            this.labelTS6.TabIndex = 79;
            this.labelTS6.Text = "TX Level:";
            // 
            // udDisplayWaterfallMicLevel
            // 
            this.udDisplayWaterfallMicLevel.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDisplayWaterfallMicLevel.Location = new System.Drawing.Point(192, 66);
            this.udDisplayWaterfallMicLevel.Maximum = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDisplayWaterfallMicLevel.Minimum = new decimal(new int[] {
            200,
            0,
            0,
            -2147483648});
            this.udDisplayWaterfallMicLevel.Name = "udDisplayWaterfallMicLevel";
            this.udDisplayWaterfallMicLevel.Size = new System.Drawing.Size(48, 20);
            this.udDisplayWaterfallMicLevel.TabIndex = 78;
            this.toolTip1.SetToolTip(this.udDisplayWaterfallMicLevel, "Waterfall TX Low Signal - Show Low Color below this value (gradient in between).");
            this.udDisplayWaterfallMicLevel.Value = new decimal(new int[] {
            110,
            0,
            0,
            -2147483648});
            this.udDisplayWaterfallMicLevel.ValueChanged += new System.EventHandler(this.udDisplayWaterfallMicLevel_ValueChanged);
            // 
            // udDisplayWaterfallRX2Level
            // 
            this.udDisplayWaterfallRX2Level.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDisplayWaterfallRX2Level.Location = new System.Drawing.Point(72, 66);
            this.udDisplayWaterfallRX2Level.Maximum = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDisplayWaterfallRX2Level.Minimum = new decimal(new int[] {
            200,
            0,
            0,
            -2147483648});
            this.udDisplayWaterfallRX2Level.Name = "udDisplayWaterfallRX2Level";
            this.udDisplayWaterfallRX2Level.Size = new System.Drawing.Size(48, 20);
            this.udDisplayWaterfallRX2Level.TabIndex = 77;
            this.toolTip1.SetToolTip(this.udDisplayWaterfallRX2Level, "Waterfall RX2 Low Signal - Show Low Color below this value (gradient in between)." +
        "");
            this.udDisplayWaterfallRX2Level.Value = new decimal(new int[] {
            110,
            0,
            0,
            -2147483648});
            this.udDisplayWaterfallRX2Level.ValueChanged += new System.EventHandler(this.udDisplayWaterfallRX2Level_ValueChanged);
            // 
            // labelTS5
            // 
            this.labelTS5.Image = null;
            this.labelTS5.Location = new System.Drawing.Point(8, 69);
            this.labelTS5.Name = "labelTS5";
            this.labelTS5.Size = new System.Drawing.Size(64, 23);
            this.labelTS5.TabIndex = 76;
            this.labelTS5.Text = "RX2 Level:";
            // 
            // chkWeakSignalWaterfallSettings
            // 
            this.chkWeakSignalWaterfallSettings.Image = null;
            this.chkWeakSignalWaterfallSettings.Location = new System.Drawing.Point(11, 134);
            this.chkWeakSignalWaterfallSettings.Name = "chkWeakSignalWaterfallSettings";
            this.chkWeakSignalWaterfallSettings.Size = new System.Drawing.Size(225, 18);
            this.chkWeakSignalWaterfallSettings.TabIndex = 75;
            this.chkWeakSignalWaterfallSettings.Text = "Enable weak signal display optimization";
            this.toolTip1.SetToolTip(this.chkWeakSignalWaterfallSettings, "Check to optimize waterfall settings for displaying weak signals");
            this.chkWeakSignalWaterfallSettings.CheckedChanged += new System.EventHandler(this.chkWeakSignalWaterfallSettings_CheckedChanged);
            // 
            // lblWaterfallLevels
            // 
            this.lblWaterfallLevels.AutoSize = true;
            this.lblWaterfallLevels.Location = new System.Drawing.Point(8, 18);
            this.lblWaterfallLevels.Name = "lblWaterfallLevels";
            this.lblWaterfallLevels.Size = new System.Drawing.Size(134, 13);
            this.lblWaterfallLevels.TabIndex = 74;
            this.lblWaterfallLevels.Text = "Band for Low/High Levels:";
            this.toolTip1.SetToolTip(this.lblWaterfallLevels, "Waterfall Low/High levels can be set by band.  RX2 bands inherit RX1 band\'s Water" +
        "fall Settings.");
            // 
            // txtWaterFallBandLevel
            // 
            this.txtWaterFallBandLevel.Location = new System.Drawing.Point(146, 13);
            this.txtWaterFallBandLevel.Name = "txtWaterFallBandLevel";
            this.txtWaterFallBandLevel.ReadOnly = true;
            this.txtWaterFallBandLevel.Size = new System.Drawing.Size(94, 20);
            this.txtWaterFallBandLevel.TabIndex = 73;
            this.txtWaterFallBandLevel.Text = "Current Band";
            this.toolTip1.SetToolTip(this.txtWaterFallBandLevel, "Current RX1 band selected for setting Waterfall Low/High level settings");
            // 
            // udDisplayWaterfallUpdatePeriod
            // 
            this.udDisplayWaterfallUpdatePeriod.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayWaterfallUpdatePeriod.Location = new System.Drawing.Point(192, 114);
            this.udDisplayWaterfallUpdatePeriod.Maximum = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udDisplayWaterfallUpdatePeriod.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayWaterfallUpdatePeriod.Name = "udDisplayWaterfallUpdatePeriod";
            this.udDisplayWaterfallUpdatePeriod.Size = new System.Drawing.Size(48, 20);
            this.udDisplayWaterfallUpdatePeriod.TabIndex = 71;
            this.toolTip1.SetToolTip(this.udDisplayWaterfallUpdatePeriod, "How often to update (scroll another pixel line) on the waterfall display.  Note t" +
        "hat this is tamed by the FPS setting.");
            this.udDisplayWaterfallUpdatePeriod.Value = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udDisplayWaterfallUpdatePeriod.ValueChanged += new System.EventHandler(this.udDisplayWaterfallUpdatePeriod_ValueChanged);
            // 
            // lblDisplayWaterfallUpdatePeriod
            // 
            this.lblDisplayWaterfallUpdatePeriod.Image = null;
            this.lblDisplayWaterfallUpdatePeriod.Location = new System.Drawing.Point(83, 116);
            this.lblDisplayWaterfallUpdatePeriod.Name = "lblDisplayWaterfallUpdatePeriod";
            this.lblDisplayWaterfallUpdatePeriod.Size = new System.Drawing.Size(118, 18);
            this.lblDisplayWaterfallUpdatePeriod.TabIndex = 72;
            this.lblDisplayWaterfallUpdatePeriod.Text = "Update Period (ms):";
            this.toolTip1.SetToolTip(this.lblDisplayWaterfallUpdatePeriod, "How often to update (scroll another pixel line) on the waterfall display.  Note t" +
        "hat this is tamed by the FPS setting.");
            // 
            // udDisplayWaterfallAvgTime
            // 
            this.udDisplayWaterfallAvgTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayWaterfallAvgTime.Location = new System.Drawing.Point(192, 90);
            this.udDisplayWaterfallAvgTime.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udDisplayWaterfallAvgTime.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayWaterfallAvgTime.Name = "udDisplayWaterfallAvgTime";
            this.udDisplayWaterfallAvgTime.Size = new System.Drawing.Size(48, 20);
            this.udDisplayWaterfallAvgTime.TabIndex = 69;
            this.toolTip1.SetToolTip(this.udDisplayWaterfallAvgTime, "The time to average signals for each line (1 pixel high) on the waterfall.");
            this.udDisplayWaterfallAvgTime.Value = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDisplayWaterfallAvgTime.ValueChanged += new System.EventHandler(this.udDisplayWaterfallAvgTime_ValueChanged);
            // 
            // lblDisplayWaterfallAverageTime
            // 
            this.lblDisplayWaterfallAverageTime.Image = null;
            this.lblDisplayWaterfallAverageTime.Location = new System.Drawing.Point(83, 92);
            this.lblDisplayWaterfallAverageTime.Name = "lblDisplayWaterfallAverageTime";
            this.lblDisplayWaterfallAverageTime.Size = new System.Drawing.Size(118, 18);
            this.lblDisplayWaterfallAverageTime.TabIndex = 70;
            this.lblDisplayWaterfallAverageTime.Text = "Averaging Time (ms):";
            this.toolTip1.SetToolTip(this.lblDisplayWaterfallAverageTime, "The time to average signals for each line (1 pixel high) on the waterfall.");
            // 
            // clrbtnWaterfallLow
            // 
            this.clrbtnWaterfallLow.Automatic = "Automatic";
            this.clrbtnWaterfallLow.Color = System.Drawing.Color.Navy;
            this.clrbtnWaterfallLow.Image = null;
            this.clrbtnWaterfallLow.Location = new System.Drawing.Point(11, 105);
            this.clrbtnWaterfallLow.MoreColors = "More Colors...";
            this.clrbtnWaterfallLow.Name = "clrbtnWaterfallLow";
            this.clrbtnWaterfallLow.Size = new System.Drawing.Size(40, 23);
            this.clrbtnWaterfallLow.TabIndex = 68;
            this.toolTip1.SetToolTip(this.clrbtnWaterfallLow, "The Color to use when the signal level is at or below the low level set above.");
            this.clrbtnWaterfallLow.Changed += new System.EventHandler(this.clrbtnWaterfallLow_Changed);
            // 
            // lblDisplayWaterfallLowColor
            // 
            this.lblDisplayWaterfallLowColor.Image = null;
            this.lblDisplayWaterfallLowColor.Location = new System.Drawing.Point(6, 92);
            this.lblDisplayWaterfallLowColor.Name = "lblDisplayWaterfallLowColor";
            this.lblDisplayWaterfallLowColor.Size = new System.Drawing.Size(64, 16);
            this.lblDisplayWaterfallLowColor.TabIndex = 57;
            this.lblDisplayWaterfallLowColor.Text = "Low Color:";
            // 
            // lblDisplayWaterfallLowLevel
            // 
            this.lblDisplayWaterfallLowLevel.Image = null;
            this.lblDisplayWaterfallLowLevel.Location = new System.Drawing.Point(8, 42);
            this.lblDisplayWaterfallLowLevel.Name = "lblDisplayWaterfallLowLevel";
            this.lblDisplayWaterfallLowLevel.Size = new System.Drawing.Size(64, 23);
            this.lblDisplayWaterfallLowLevel.TabIndex = 3;
            this.lblDisplayWaterfallLowLevel.Text = "Low Level:";
            // 
            // udDisplayWaterfallLowLevel
            // 
            this.udDisplayWaterfallLowLevel.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDisplayWaterfallLowLevel.Location = new System.Drawing.Point(72, 40);
            this.udDisplayWaterfallLowLevel.Maximum = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDisplayWaterfallLowLevel.Minimum = new decimal(new int[] {
            200,
            0,
            0,
            -2147483648});
            this.udDisplayWaterfallLowLevel.Name = "udDisplayWaterfallLowLevel";
            this.udDisplayWaterfallLowLevel.Size = new System.Drawing.Size(48, 20);
            this.udDisplayWaterfallLowLevel.TabIndex = 2;
            this.toolTip1.SetToolTip(this.udDisplayWaterfallLowLevel, "Waterfall Low Signal - Show Low Color below this value (gradient in between).");
            this.udDisplayWaterfallLowLevel.Value = new decimal(new int[] {
            100,
            0,
            0,
            -2147483648});
            this.udDisplayWaterfallLowLevel.ValueChanged += new System.EventHandler(this.udDisplayWaterfallLowLevel_ValueChanged);
            this.udDisplayWaterfallLowLevel.LostFocus += new System.EventHandler(this.udDisplayWaterfallLowLevel_LostFocus);
            // 
            // lblDisplayWaterfallHighLevel
            // 
            this.lblDisplayWaterfallHighLevel.Image = null;
            this.lblDisplayWaterfallHighLevel.Location = new System.Drawing.Point(126, 42);
            this.lblDisplayWaterfallHighLevel.Name = "lblDisplayWaterfallHighLevel";
            this.lblDisplayWaterfallHighLevel.Size = new System.Drawing.Size(64, 23);
            this.lblDisplayWaterfallHighLevel.TabIndex = 1;
            this.lblDisplayWaterfallHighLevel.Text = "High Level:";
            // 
            // udDisplayWaterfallHighLevel
            // 
            this.udDisplayWaterfallHighLevel.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDisplayWaterfallHighLevel.Location = new System.Drawing.Point(192, 40);
            this.udDisplayWaterfallHighLevel.Maximum = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDisplayWaterfallHighLevel.Minimum = new decimal(new int[] {
            200,
            0,
            0,
            -2147483648});
            this.udDisplayWaterfallHighLevel.Name = "udDisplayWaterfallHighLevel";
            this.udDisplayWaterfallHighLevel.Size = new System.Drawing.Size(48, 20);
            this.udDisplayWaterfallHighLevel.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udDisplayWaterfallHighLevel, "Waterfall High Signal - Show High Color above this value (gradient in between).");
            this.udDisplayWaterfallHighLevel.Value = new decimal(new int[] {
            40,
            0,
            0,
            -2147483648});
            this.udDisplayWaterfallHighLevel.ValueChanged += new System.EventHandler(this.udDisplayWaterfallHighLevel_ValueChanged);
            this.udDisplayWaterfallHighLevel.LostFocus += new System.EventHandler(this.udDisplayWaterfallHighLevel_LostFocus);
            // 
            // grpDisplayRefreshRates
            // 
            this.grpDisplayRefreshRates.Controls.Add(this.gridBoxTS);
            this.grpDisplayRefreshRates.Controls.Add(this.chkDisplayPanFill);
            this.grpDisplayRefreshRates.Controls.Add(this.udDisplayCPUMeter);
            this.grpDisplayRefreshRates.Controls.Add(this.lblDisplayCPUMeter);
            this.grpDisplayRefreshRates.Controls.Add(this.udDisplayPeakText);
            this.grpDisplayRefreshRates.Controls.Add(this.lblDisplayPeakText);
            this.grpDisplayRefreshRates.Controls.Add(this.udDisplayFPS);
            this.grpDisplayRefreshRates.Controls.Add(this.lblDisplayFPS);
            this.grpDisplayRefreshRates.Location = new System.Drawing.Point(128, 8);
            this.grpDisplayRefreshRates.Name = "grpDisplayRefreshRates";
            this.grpDisplayRefreshRates.Size = new System.Drawing.Size(176, 128);
            this.grpDisplayRefreshRates.TabIndex = 39;
            this.grpDisplayRefreshRates.TabStop = false;
            this.grpDisplayRefreshRates.Text = "Refresh Rates";
            // 
            // gridBoxTS
            // 
            this.gridBoxTS.Image = null;
            this.gridBoxTS.Location = new System.Drawing.Point(19, 106);
            this.gridBoxTS.Name = "gridBoxTS";
            this.gridBoxTS.Size = new System.Drawing.Size(101, 16);
            this.gridBoxTS.TabIndex = 41;
            this.gridBoxTS.Text = "Grid Lines OFF";
            this.toolTip1.SetToolTip(this.gridBoxTS, "Check to turn off Grid Lines (if you Skin gets in the way of the grid lines)");
            this.gridBoxTS.CheckedChanged += new System.EventHandler(this.gridBoxTS_CheckedChanged);
            // 
            // chkDisplayPanFill
            // 
            this.chkDisplayPanFill.Checked = true;
            this.chkDisplayPanFill.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkDisplayPanFill.Image = null;
            this.chkDisplayPanFill.Location = new System.Drawing.Point(19, 43);
            this.chkDisplayPanFill.Name = "chkDisplayPanFill";
            this.chkDisplayPanFill.Size = new System.Drawing.Size(101, 16);
            this.chkDisplayPanFill.TabIndex = 40;
            this.chkDisplayPanFill.Text = "Fill Panadapter";
            this.toolTip1.SetToolTip(this.chkDisplayPanFill, "Check to fill the panadapter display line below the data.");
            this.chkDisplayPanFill.CheckedChanged += new System.EventHandler(this.chkDisplayPanFill_CheckedChanged);
            // 
            // udDisplayCPUMeter
            // 
            this.udDisplayCPUMeter.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayCPUMeter.Location = new System.Drawing.Point(120, 86);
            this.udDisplayCPUMeter.Maximum = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udDisplayCPUMeter.Minimum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udDisplayCPUMeter.Name = "udDisplayCPUMeter";
            this.udDisplayCPUMeter.Size = new System.Drawing.Size(48, 20);
            this.udDisplayCPUMeter.TabIndex = 38;
            this.toolTip1.SetToolTip(this.udDisplayCPUMeter, "CPU Meter Refresh Rate.");
            this.udDisplayCPUMeter.Value = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udDisplayCPUMeter.ValueChanged += new System.EventHandler(this.udDisplayCPUMeter_ValueChanged);
            this.udDisplayCPUMeter.LostFocus += new System.EventHandler(this.udDisplayCPUMeter_LostFocus);
            // 
            // lblDisplayCPUMeter
            // 
            this.lblDisplayCPUMeter.Image = null;
            this.lblDisplayCPUMeter.Location = new System.Drawing.Point(16, 85);
            this.lblDisplayCPUMeter.Name = "lblDisplayCPUMeter";
            this.lblDisplayCPUMeter.Size = new System.Drawing.Size(100, 23);
            this.lblDisplayCPUMeter.TabIndex = 37;
            this.lblDisplayCPUMeter.Text = "CPU Meter (ms)";
            // 
            // udDisplayPeakText
            // 
            this.udDisplayPeakText.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayPeakText.Location = new System.Drawing.Point(120, 64);
            this.udDisplayPeakText.Maximum = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udDisplayPeakText.Minimum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udDisplayPeakText.Name = "udDisplayPeakText";
            this.udDisplayPeakText.Size = new System.Drawing.Size(48, 20);
            this.udDisplayPeakText.TabIndex = 36;
            this.toolTip1.SetToolTip(this.udDisplayPeakText, "Peak Text Refresh Rate.");
            this.udDisplayPeakText.Value = new decimal(new int[] {
            500,
            0,
            0,
            0});
            this.udDisplayPeakText.ValueChanged += new System.EventHandler(this.udDisplayPeakText_ValueChanged);
            this.udDisplayPeakText.LostFocus += new System.EventHandler(this.udDisplayPeakText_LostFocus);
            // 
            // lblDisplayPeakText
            // 
            this.lblDisplayPeakText.Image = null;
            this.lblDisplayPeakText.Location = new System.Drawing.Point(16, 66);
            this.lblDisplayPeakText.Name = "lblDisplayPeakText";
            this.lblDisplayPeakText.Size = new System.Drawing.Size(100, 23);
            this.lblDisplayPeakText.TabIndex = 35;
            this.lblDisplayPeakText.Text = "Peak Text (ms)";
            // 
            // udDisplayFPS
            // 
            this.udDisplayFPS.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayFPS.Location = new System.Drawing.Point(120, 24);
            this.udDisplayFPS.Maximum = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udDisplayFPS.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayFPS.Name = "udDisplayFPS";
            this.udDisplayFPS.Size = new System.Drawing.Size(48, 20);
            this.udDisplayFPS.TabIndex = 32;
            this.toolTip1.SetToolTip(this.udDisplayFPS, "Frames Per Second (approximate)");
            this.udDisplayFPS.Value = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udDisplayFPS.ValueChanged += new System.EventHandler(this.udDisplayFPS_ValueChanged);
            this.udDisplayFPS.LostFocus += new System.EventHandler(this.udDisplayFPS_LostFocus);
            // 
            // lblDisplayFPS
            // 
            this.lblDisplayFPS.Image = null;
            this.lblDisplayFPS.Location = new System.Drawing.Point(16, 24);
            this.lblDisplayFPS.Name = "lblDisplayFPS";
            this.lblDisplayFPS.Size = new System.Drawing.Size(104, 16);
            this.lblDisplayFPS.TabIndex = 31;
            this.lblDisplayFPS.Text = "Main Display FPS:";
            // 
            // grpDisplayAverage
            // 
            this.grpDisplayAverage.Controls.Add(this.udDisplayAVGTime);
            this.grpDisplayAverage.Controls.Add(this.lblDisplayAVGTime);
            this.grpDisplayAverage.Location = new System.Drawing.Point(310, 56);
            this.grpDisplayAverage.Name = "grpDisplayAverage";
            this.grpDisplayAverage.Size = new System.Drawing.Size(120, 44);
            this.grpDisplayAverage.TabIndex = 38;
            this.grpDisplayAverage.TabStop = false;
            this.grpDisplayAverage.Text = "Averaging";
            // 
            // udDisplayAVGTime
            // 
            this.udDisplayAVGTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayAVGTime.Location = new System.Drawing.Point(66, 18);
            this.udDisplayAVGTime.Maximum = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udDisplayAVGTime.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayAVGTime.Name = "udDisplayAVGTime";
            this.udDisplayAVGTime.Size = new System.Drawing.Size(48, 20);
            this.udDisplayAVGTime.TabIndex = 2;
            this.toolTip1.SetToolTip(this.udDisplayAVGTime, "When averaging, use this number of buffers to calculate the average.");
            this.udDisplayAVGTime.Value = new decimal(new int[] {
            350,
            0,
            0,
            0});
            this.udDisplayAVGTime.ValueChanged += new System.EventHandler(this.udDisplayAVGTime_ValueChanged);
            this.udDisplayAVGTime.LostFocus += new System.EventHandler(this.udDisplayAVGTime_LostFocus);
            // 
            // lblDisplayAVGTime
            // 
            this.lblDisplayAVGTime.Image = null;
            this.lblDisplayAVGTime.Location = new System.Drawing.Point(8, 19);
            this.lblDisplayAVGTime.Name = "lblDisplayAVGTime";
            this.lblDisplayAVGTime.Size = new System.Drawing.Size(64, 23);
            this.lblDisplayAVGTime.TabIndex = 3;
            this.lblDisplayAVGTime.Text = "Time (ms):";
            // 
            // grpDisplayPhase
            // 
            this.grpDisplayPhase.Controls.Add(this.lblDisplayPhasePts);
            this.grpDisplayPhase.Controls.Add(this.udDisplayPhasePts);
            this.grpDisplayPhase.Location = new System.Drawing.Point(312, 8);
            this.grpDisplayPhase.Name = "grpDisplayPhase";
            this.grpDisplayPhase.Size = new System.Drawing.Size(120, 49);
            this.grpDisplayPhase.TabIndex = 37;
            this.grpDisplayPhase.TabStop = false;
            this.grpDisplayPhase.Text = "Phase Mode";
            // 
            // lblDisplayPhasePts
            // 
            this.lblDisplayPhasePts.Image = null;
            this.lblDisplayPhasePts.Location = new System.Drawing.Point(6, 19);
            this.lblDisplayPhasePts.Name = "lblDisplayPhasePts";
            this.lblDisplayPhasePts.Size = new System.Drawing.Size(56, 23);
            this.lblDisplayPhasePts.TabIndex = 1;
            this.lblDisplayPhasePts.Text = "Num Pts:";
            // 
            // udDisplayPhasePts
            // 
            this.udDisplayPhasePts.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayPhasePts.Location = new System.Drawing.Point(64, 20);
            this.udDisplayPhasePts.Maximum = new decimal(new int[] {
            500,
            0,
            0,
            0});
            this.udDisplayPhasePts.Minimum = new decimal(new int[] {
            25,
            0,
            0,
            0});
            this.udDisplayPhasePts.Name = "udDisplayPhasePts";
            this.udDisplayPhasePts.Size = new System.Drawing.Size(48, 20);
            this.udDisplayPhasePts.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udDisplayPhasePts, "Number of points to display in Phase Mode.");
            this.udDisplayPhasePts.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udDisplayPhasePts.ValueChanged += new System.EventHandler(this.udDisplayPhasePts_ValueChanged);
            this.udDisplayPhasePts.LostFocus += new System.EventHandler(this.udDisplayPhasePts_LostFocus);
            // 
            // grpDisplaySpectrumGrid
            // 
            this.grpDisplaySpectrumGrid.Controls.Add(this.comboDisplayLabelAlign);
            this.grpDisplaySpectrumGrid.Controls.Add(this.lblDisplayAlign);
            this.grpDisplaySpectrumGrid.Controls.Add(this.udDisplayGridStep);
            this.grpDisplaySpectrumGrid.Controls.Add(this.udDisplayGridMin);
            this.grpDisplaySpectrumGrid.Controls.Add(this.udDisplayGridMax);
            this.grpDisplaySpectrumGrid.Controls.Add(this.lblDisplayGridStep);
            this.grpDisplaySpectrumGrid.Controls.Add(this.lblDisplayGridMin);
            this.grpDisplaySpectrumGrid.Controls.Add(this.lblDisplayGridMax);
            this.grpDisplaySpectrumGrid.Location = new System.Drawing.Point(8, 8);
            this.grpDisplaySpectrumGrid.Name = "grpDisplaySpectrumGrid";
            this.grpDisplaySpectrumGrid.Size = new System.Drawing.Size(112, 128);
            this.grpDisplaySpectrumGrid.TabIndex = 29;
            this.grpDisplaySpectrumGrid.TabStop = false;
            this.grpDisplaySpectrumGrid.Text = "Spectrum Grid";
            this.toolTip1.SetToolTip(this.grpDisplaySpectrumGrid, resources.GetString("grpDisplaySpectrumGrid.ToolTip"));
            // 
            // comboDisplayLabelAlign
            // 
            this.comboDisplayLabelAlign.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDisplayLabelAlign.DropDownWidth = 48;
            this.comboDisplayLabelAlign.Items.AddRange(new object[] {
            "Left",
            "Cntr",
            "Right",
            "Auto",
            "S-Unit",
            "Off"});
            this.comboDisplayLabelAlign.Location = new System.Drawing.Point(48, 96);
            this.comboDisplayLabelAlign.Name = "comboDisplayLabelAlign";
            this.comboDisplayLabelAlign.Size = new System.Drawing.Size(56, 21);
            this.comboDisplayLabelAlign.TabIndex = 30;
            this.toolTip1.SetToolTip(this.comboDisplayLabelAlign, resources.GetString("comboDisplayLabelAlign.ToolTip"));
            this.comboDisplayLabelAlign.SelectedIndexChanged += new System.EventHandler(this.comboDisplayLabelAlign_SelectedIndexChanged);
            // 
            // lblDisplayAlign
            // 
            this.lblDisplayAlign.Image = null;
            this.lblDisplayAlign.Location = new System.Drawing.Point(8, 96);
            this.lblDisplayAlign.Name = "lblDisplayAlign";
            this.lblDisplayAlign.Size = new System.Drawing.Size(40, 16);
            this.lblDisplayAlign.TabIndex = 29;
            this.lblDisplayAlign.Text = "Align:";
            // 
            // udDisplayGridStep
            // 
            this.udDisplayGridStep.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayGridStep.Location = new System.Drawing.Point(48, 72);
            this.udDisplayGridStep.Maximum = new decimal(new int[] {
            40,
            0,
            0,
            0});
            this.udDisplayGridStep.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDisplayGridStep.Name = "udDisplayGridStep";
            this.udDisplayGridStep.Size = new System.Drawing.Size(56, 20);
            this.udDisplayGridStep.TabIndex = 25;
            this.toolTip1.SetToolTip(this.udDisplayGridStep, resources.GetString("udDisplayGridStep.ToolTip"));
            this.udDisplayGridStep.Value = new decimal(new int[] {
            6,
            0,
            0,
            0});
            this.udDisplayGridStep.ValueChanged += new System.EventHandler(this.udDisplayGridStep_ValueChanged);
            this.udDisplayGridStep.LostFocus += new System.EventHandler(this.udDisplayGridStep_LostFocus);
            // 
            // udDisplayGridMin
            // 
            this.udDisplayGridMin.Increment = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.udDisplayGridMin.Location = new System.Drawing.Point(48, 48);
            this.udDisplayGridMin.Maximum = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDisplayGridMin.Minimum = new decimal(new int[] {
            200,
            0,
            0,
            -2147483648});
            this.udDisplayGridMin.Name = "udDisplayGridMin";
            this.udDisplayGridMin.Size = new System.Drawing.Size(56, 20);
            this.udDisplayGridMin.TabIndex = 24;
            this.toolTip1.SetToolTip(this.udDisplayGridMin, resources.GetString("udDisplayGridMin.ToolTip"));
            this.udDisplayGridMin.Value = new decimal(new int[] {
            135,
            0,
            0,
            -2147483648});
            this.udDisplayGridMin.ValueChanged += new System.EventHandler(this.udDisplayGridMin_ValueChanged);
            this.udDisplayGridMin.LostFocus += new System.EventHandler(this.udDisplayGridMin_LostFocus);
            // 
            // udDisplayGridMax
            // 
            this.udDisplayGridMax.Increment = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.udDisplayGridMax.Location = new System.Drawing.Point(48, 24);
            this.udDisplayGridMax.Maximum = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDisplayGridMax.Minimum = new decimal(new int[] {
            200,
            0,
            0,
            -2147483648});
            this.udDisplayGridMax.Name = "udDisplayGridMax";
            this.udDisplayGridMax.Size = new System.Drawing.Size(56, 20);
            this.udDisplayGridMax.TabIndex = 23;
            this.toolTip1.SetToolTip(this.udDisplayGridMax, resources.GetString("udDisplayGridMax.ToolTip"));
            this.udDisplayGridMax.Value = new decimal(new int[] {
            19,
            0,
            0,
            -2147483648});
            this.udDisplayGridMax.ValueChanged += new System.EventHandler(this.udDisplayGridMax_ValueChanged);
            this.udDisplayGridMax.LostFocus += new System.EventHandler(this.udDisplayGridMax_LostFocus);
            // 
            // lblDisplayGridStep
            // 
            this.lblDisplayGridStep.Image = null;
            this.lblDisplayGridStep.Location = new System.Drawing.Point(8, 72);
            this.lblDisplayGridStep.Name = "lblDisplayGridStep";
            this.lblDisplayGridStep.Size = new System.Drawing.Size(32, 16);
            this.lblDisplayGridStep.TabIndex = 28;
            this.lblDisplayGridStep.Text = "Step:";
            // 
            // lblDisplayGridMin
            // 
            this.lblDisplayGridMin.Image = null;
            this.lblDisplayGridMin.Location = new System.Drawing.Point(8, 48);
            this.lblDisplayGridMin.Name = "lblDisplayGridMin";
            this.lblDisplayGridMin.Size = new System.Drawing.Size(32, 16);
            this.lblDisplayGridMin.TabIndex = 27;
            this.lblDisplayGridMin.Text = "Min:";
            // 
            // lblDisplayGridMax
            // 
            this.lblDisplayGridMax.Image = null;
            this.lblDisplayGridMax.Location = new System.Drawing.Point(8, 24);
            this.lblDisplayGridMax.Name = "lblDisplayGridMax";
            this.lblDisplayGridMax.Size = new System.Drawing.Size(32, 16);
            this.lblDisplayGridMax.TabIndex = 26;
            this.lblDisplayGridMax.Text = "Max:";
            // 
            // chkBoxAutoWtrPan
            // 
            this.chkBoxAutoWtrPan.Checked = true;
            this.chkBoxAutoWtrPan.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkBoxAutoWtrPan.Image = null;
            this.chkBoxAutoWtrPan.Location = new System.Drawing.Point(430, 320);
            this.chkBoxAutoWtrPan.Name = "chkBoxAutoWtrPan";
            this.chkBoxAutoWtrPan.Size = new System.Drawing.Size(105, 23);
            this.chkBoxAutoWtrPan.TabIndex = 91;
            this.chkBoxAutoWtrPan.Text = "auto wtr/pan";
            this.toolTip1.SetToolTip(this.chkBoxAutoWtrPan, resources.GetString("chkBoxAutoWtrPan.ToolTip"));
            this.chkBoxAutoWtrPan.CheckedChanged += new System.EventHandler(this.chkBoxAutoWtrPan_CheckedChanged);
            // 
            // tpDSP
            // 
            this.tpDSP.Controls.Add(this.tcDSP);
            this.tpDSP.Location = new System.Drawing.Point(4, 22);
            this.tpDSP.Name = "tpDSP";
            this.tpDSP.Size = new System.Drawing.Size(584, 341);
            this.tpDSP.TabIndex = 1;
            this.tpDSP.Text = "DSP";
            // 
            // tcDSP
            // 
            this.tcDSP.Controls.Add(this.tpDSPOptions);
            this.tcDSP.Controls.Add(this.tpDSPImageReject);
            this.tcDSP.Controls.Add(this.tpDSPKeyer);
            this.tcDSP.Controls.Add(this.tpDSPAGCALC);
            this.tcDSP.Location = new System.Drawing.Point(-8, 0);
            this.tcDSP.Name = "tcDSP";
            this.tcDSP.SelectedIndex = 0;
            this.tcDSP.Size = new System.Drawing.Size(608, 344);
            this.tcDSP.TabIndex = 0;
            // 
            // tpDSPOptions
            // 
            this.tpDSPOptions.Controls.Add(this.chkDSPRX2);
            this.tpDSPOptions.Controls.Add(this.labelTS28);
            this.tpDSPOptions.Controls.Add(this.btnRSTNB2);
            this.tpDSPOptions.Controls.Add(this.btnRSTNB);
            this.tpDSPOptions.Controls.Add(this.btnRSTANF);
            this.tpDSPOptions.Controls.Add(this.btnRSTNR);
            this.tpDSPOptions.Controls.Add(this.labelTS7);
            this.tpDSPOptions.Controls.Add(this.udTNFWidth);
            this.tpDSPOptions.Controls.Add(this.chkDSPTXMeterPeak);
            this.tpDSPOptions.Controls.Add(this.grpDSPBufferSize);
            this.tpDSPOptions.Controls.Add(this.grpDSPNB);
            this.tpDSPOptions.Controls.Add(this.grpDSPLMSNR);
            this.tpDSPOptions.Controls.Add(this.grpDSPLMSANF);
            this.tpDSPOptions.Controls.Add(this.grpDSPWindow);
            this.tpDSPOptions.Controls.Add(this.grpDSPNB2);
            this.tpDSPOptions.Location = new System.Drawing.Point(4, 22);
            this.tpDSPOptions.Name = "tpDSPOptions";
            this.tpDSPOptions.Size = new System.Drawing.Size(600, 318);
            this.tpDSPOptions.TabIndex = 2;
            this.tpDSPOptions.Text = "Options";
            // 
            // chkDSPRX2
            // 
            this.chkDSPRX2.Checked = true;
            this.chkDSPRX2.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkDSPRX2.Image = null;
            this.chkDSPRX2.Location = new System.Drawing.Point(395, 216);
            this.chkDSPRX2.Name = "chkDSPRX2";
            this.chkDSPRX2.Size = new System.Drawing.Size(144, 32);
            this.chkDSPRX2.TabIndex = 43;
            this.chkDSPRX2.Text = "Use NR,ANF, and NB settings for RX2";
            // 
            // labelTS28
            // 
            this.labelTS28.Image = null;
            this.labelTS28.Location = new System.Drawing.Point(24, 171);
            this.labelTS28.Name = "labelTS28";
            this.labelTS28.Size = new System.Drawing.Size(208, 26);
            this.labelTS28.TabIndex = 42;
            this.labelTS28.Text = "Set RX buffer size to 2048 or less for NR or ANF to work.";
            // 
            // btnRSTNB2
            // 
            this.btnRSTNB2.Image = null;
            this.btnRSTNB2.Location = new System.Drawing.Point(510, 89);
            this.btnRSTNB2.Name = "btnRSTNB2";
            this.btnRSTNB2.Size = new System.Drawing.Size(70, 23);
            this.btnRSTNB2.TabIndex = 41;
            this.btnRSTNB2.Text = "Reset NB2";
            this.toolTip1.SetToolTip(this.btnRSTNB2, "Reset to Factory Setting");
            this.btnRSTNB2.Click += new System.EventHandler(this.btnRSTNB2_Click);
            // 
            // btnRSTNB
            // 
            this.btnRSTNB.Image = null;
            this.btnRSTNB.Location = new System.Drawing.Point(510, 27);
            this.btnRSTNB.Name = "btnRSTNB";
            this.btnRSTNB.Size = new System.Drawing.Size(70, 23);
            this.btnRSTNB.TabIndex = 40;
            this.btnRSTNB.Text = "Reset NB";
            this.toolTip1.SetToolTip(this.btnRSTNB, "Reset to Factory Setting");
            this.btnRSTNB.Click += new System.EventHandler(this.btnRSTNB_Click);
            // 
            // btnRSTANF
            // 
            this.btnRSTANF.Image = null;
            this.btnRSTANF.Location = new System.Drawing.Point(164, 142);
            this.btnRSTANF.Name = "btnRSTANF";
            this.btnRSTANF.Size = new System.Drawing.Size(68, 23);
            this.btnRSTANF.TabIndex = 39;
            this.btnRSTANF.Text = "Reset ANF";
            this.toolTip1.SetToolTip(this.btnRSTANF, "Reset to Factory Setting");
            this.btnRSTANF.Click += new System.EventHandler(this.btnRSTANF_Click);
            // 
            // btnRSTNR
            // 
            this.btnRSTNR.Image = null;
            this.btnRSTNR.Location = new System.Drawing.Point(44, 142);
            this.btnRSTNR.Name = "btnRSTNR";
            this.btnRSTNR.Size = new System.Drawing.Size(68, 23);
            this.btnRSTNR.TabIndex = 23;
            this.btnRSTNR.Text = "Reset NR";
            this.toolTip1.SetToolTip(this.btnRSTNR, "Reset to Factory Setting");
            this.btnRSTNR.Click += new System.EventHandler(this.btnRSTNR_Click);
            // 
            // labelTS7
            // 
            this.labelTS7.Image = null;
            this.labelTS7.Location = new System.Drawing.Point(13, 254);
            this.labelTS7.Name = "labelTS7";
            this.labelTS7.Size = new System.Drawing.Size(96, 26);
            this.labelTS7.TabIndex = 10;
            this.labelTS7.Text = "TNF Notch Width (Default 100):";
            // 
            // udTNFWidth
            // 
            this.udTNFWidth.Increment = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udTNFWidth.Location = new System.Drawing.Point(115, 260);
            this.udTNFWidth.Maximum = new decimal(new int[] {
            600,
            0,
            0,
            0});
            this.udTNFWidth.Minimum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTNFWidth.Name = "udTNFWidth";
            this.udTNFWidth.Size = new System.Drawing.Size(45, 20);
            this.udTNFWidth.TabIndex = 10;
            this.toolTip1.SetToolTip(this.udTNFWidth, "TNF Notch Width");
            this.udTNFWidth.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTNFWidth.ValueChanged += new System.EventHandler(this.udTNFWidth_ValueChanged);
            // 
            // chkDSPTXMeterPeak
            // 
            this.chkDSPTXMeterPeak.Checked = true;
            this.chkDSPTXMeterPeak.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkDSPTXMeterPeak.Image = null;
            this.chkDSPTXMeterPeak.Location = new System.Drawing.Point(16, 210);
            this.chkDSPTXMeterPeak.Name = "chkDSPTXMeterPeak";
            this.chkDSPTXMeterPeak.Size = new System.Drawing.Size(144, 32);
            this.chkDSPTXMeterPeak.TabIndex = 38;
            this.chkDSPTXMeterPeak.Text = "Use Peak Readings for TX Meter DSP Values";
            this.chkDSPTXMeterPeak.CheckedChanged += new System.EventHandler(this.chkDSPTXMeterPeak_CheckedChanged);
            // 
            // grpDSPBufferSize
            // 
            this.grpDSPBufferSize.Controls.Add(this.grpDSPBufDig);
            this.grpDSPBufferSize.Controls.Add(this.grpDSPBufCW);
            this.grpDSPBufferSize.Controls.Add(this.grpDSPBufPhone);
            this.grpDSPBufferSize.Location = new System.Drawing.Point(256, 8);
            this.grpDSPBufferSize.Name = "grpDSPBufferSize";
            this.grpDSPBufferSize.Size = new System.Drawing.Size(120, 248);
            this.grpDSPBufferSize.TabIndex = 37;
            this.grpDSPBufferSize.TabStop = false;
            this.grpDSPBufferSize.Text = "Buffer Size";
            // 
            // grpDSPBufDig
            // 
            this.grpDSPBufDig.Controls.Add(this.comboDSPDigTXBuf);
            this.grpDSPBufDig.Controls.Add(this.lblDSPDigBufferRX);
            this.grpDSPBufDig.Controls.Add(this.comboDSPDigRXBuf);
            this.grpDSPBufDig.Controls.Add(this.lblDSPDigBufferTX);
            this.grpDSPBufDig.Location = new System.Drawing.Point(8, 160);
            this.grpDSPBufDig.Name = "grpDSPBufDig";
            this.grpDSPBufDig.Size = new System.Drawing.Size(104, 72);
            this.grpDSPBufDig.TabIndex = 41;
            this.grpDSPBufDig.TabStop = false;
            this.grpDSPBufDig.Text = "Digital";
            // 
            // comboDSPDigTXBuf
            // 
            this.comboDSPDigTXBuf.DisplayMember = "2048";
            this.comboDSPDigTXBuf.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDSPDigTXBuf.DropDownWidth = 64;
            this.comboDSPDigTXBuf.Items.AddRange(new object[] {
            "256",
            "512",
            "1024",
            "2048",
            "4096"});
            this.comboDSPDigTXBuf.Location = new System.Drawing.Point(32, 48);
            this.comboDSPDigTXBuf.Name = "comboDSPDigTXBuf";
            this.comboDSPDigTXBuf.Size = new System.Drawing.Size(64, 21);
            this.comboDSPDigTXBuf.TabIndex = 20;
            this.toolTip1.SetToolTip(this.comboDSPDigTXBuf, "Sets DSP internal Buffer Size -- larger yields sharper filters, more latency");
            this.comboDSPDigTXBuf.ValueMember = "1024";
            this.comboDSPDigTXBuf.SelectedIndexChanged += new System.EventHandler(this.comboDSPDigTXBuf_SelectedIndexChanged);
            // 
            // lblDSPDigBufferRX
            // 
            this.lblDSPDigBufferRX.Image = null;
            this.lblDSPDigBufferRX.Location = new System.Drawing.Point(8, 24);
            this.lblDSPDigBufferRX.Name = "lblDSPDigBufferRX";
            this.lblDSPDigBufferRX.Size = new System.Drawing.Size(24, 16);
            this.lblDSPDigBufferRX.TabIndex = 19;
            this.lblDSPDigBufferRX.Text = "RX:";
            // 
            // comboDSPDigRXBuf
            // 
            this.comboDSPDigRXBuf.DisplayMember = "2048";
            this.comboDSPDigRXBuf.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDSPDigRXBuf.DropDownWidth = 64;
            this.comboDSPDigRXBuf.Items.AddRange(new object[] {
            "256",
            "512",
            "1024",
            "2048",
            "4096"});
            this.comboDSPDigRXBuf.Location = new System.Drawing.Point(32, 24);
            this.comboDSPDigRXBuf.Name = "comboDSPDigRXBuf";
            this.comboDSPDigRXBuf.Size = new System.Drawing.Size(64, 21);
            this.comboDSPDigRXBuf.TabIndex = 18;
            this.toolTip1.SetToolTip(this.comboDSPDigRXBuf, "Sets DSP internal Buffer Size -- larger yields sharper filters, more latency");
            this.comboDSPDigRXBuf.ValueMember = "1024";
            this.comboDSPDigRXBuf.SelectedIndexChanged += new System.EventHandler(this.comboDSPDigRXBuf_SelectedIndexChanged);
            // 
            // lblDSPDigBufferTX
            // 
            this.lblDSPDigBufferTX.Image = null;
            this.lblDSPDigBufferTX.Location = new System.Drawing.Point(8, 48);
            this.lblDSPDigBufferTX.Name = "lblDSPDigBufferTX";
            this.lblDSPDigBufferTX.Size = new System.Drawing.Size(24, 16);
            this.lblDSPDigBufferTX.TabIndex = 21;
            this.lblDSPDigBufferTX.Text = "TX:";
            // 
            // grpDSPBufCW
            // 
            this.grpDSPBufCW.Controls.Add(this.comboDSPCWTXBuf);
            this.grpDSPBufCW.Controls.Add(this.lblDSPCWBufferRX);
            this.grpDSPBufCW.Controls.Add(this.comboDSPCWRXBuf);
            this.grpDSPBufCW.Location = new System.Drawing.Point(8, 88);
            this.grpDSPBufCW.Name = "grpDSPBufCW";
            this.grpDSPBufCW.Size = new System.Drawing.Size(104, 72);
            this.grpDSPBufCW.TabIndex = 40;
            this.grpDSPBufCW.TabStop = false;
            this.grpDSPBufCW.Text = "CW";
            // 
            // comboDSPCWTXBuf
            // 
            this.comboDSPCWTXBuf.DisplayMember = "2048";
            this.comboDSPCWTXBuf.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDSPCWTXBuf.DropDownWidth = 64;
            this.comboDSPCWTXBuf.Items.AddRange(new object[] {
            "256",
            "512",
            "1024",
            "2048"});
            this.comboDSPCWTXBuf.Location = new System.Drawing.Point(32, 48);
            this.comboDSPCWTXBuf.Name = "comboDSPCWTXBuf";
            this.comboDSPCWTXBuf.Size = new System.Drawing.Size(64, 21);
            this.comboDSPCWTXBuf.TabIndex = 20;
            this.toolTip1.SetToolTip(this.comboDSPCWTXBuf, "Sets DSP internal Buffer Size -- larger yields sharper filters, more latency");
            this.comboDSPCWTXBuf.ValueMember = "512";
            this.comboDSPCWTXBuf.Visible = false;
            this.comboDSPCWTXBuf.SelectedIndexChanged += new System.EventHandler(this.comboDSPCWTXBuf_SelectedIndexChanged);
            // 
            // lblDSPCWBufferRX
            // 
            this.lblDSPCWBufferRX.Image = null;
            this.lblDSPCWBufferRX.Location = new System.Drawing.Point(8, 24);
            this.lblDSPCWBufferRX.Name = "lblDSPCWBufferRX";
            this.lblDSPCWBufferRX.Size = new System.Drawing.Size(24, 16);
            this.lblDSPCWBufferRX.TabIndex = 19;
            this.lblDSPCWBufferRX.Text = "RX:";
            // 
            // comboDSPCWRXBuf
            // 
            this.comboDSPCWRXBuf.DisplayMember = "2048";
            this.comboDSPCWRXBuf.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDSPCWRXBuf.DropDownWidth = 64;
            this.comboDSPCWRXBuf.Items.AddRange(new object[] {
            "256",
            "512",
            "1024",
            "2048",
            "4096"});
            this.comboDSPCWRXBuf.Location = new System.Drawing.Point(32, 24);
            this.comboDSPCWRXBuf.Name = "comboDSPCWRXBuf";
            this.comboDSPCWRXBuf.Size = new System.Drawing.Size(64, 21);
            this.comboDSPCWRXBuf.TabIndex = 18;
            this.toolTip1.SetToolTip(this.comboDSPCWRXBuf, "Sets DSP internal Buffer Size -- larger yields sharper filters, more latency");
            this.comboDSPCWRXBuf.ValueMember = "1024";
            this.comboDSPCWRXBuf.SelectedIndexChanged += new System.EventHandler(this.comboDSPCWRXBuf_SelectedIndexChanged);
            // 
            // grpDSPBufPhone
            // 
            this.grpDSPBufPhone.Controls.Add(this.comboDSPPhoneTXBuf);
            this.grpDSPBufPhone.Controls.Add(this.lblDSPPhoneBufferRX);
            this.grpDSPBufPhone.Controls.Add(this.comboDSPPhoneRXBuf);
            this.grpDSPBufPhone.Controls.Add(this.lblDSPPhoneBufferTX);
            this.grpDSPBufPhone.Location = new System.Drawing.Point(8, 16);
            this.grpDSPBufPhone.Name = "grpDSPBufPhone";
            this.grpDSPBufPhone.Size = new System.Drawing.Size(104, 72);
            this.grpDSPBufPhone.TabIndex = 39;
            this.grpDSPBufPhone.TabStop = false;
            this.grpDSPBufPhone.Text = "Phone";
            // 
            // comboDSPPhoneTXBuf
            // 
            this.comboDSPPhoneTXBuf.DisplayMember = "2048";
            this.comboDSPPhoneTXBuf.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDSPPhoneTXBuf.DropDownWidth = 64;
            this.comboDSPPhoneTXBuf.Items.AddRange(new object[] {
            "256",
            "512",
            "1024",
            "2048",
            "4096"});
            this.comboDSPPhoneTXBuf.Location = new System.Drawing.Point(32, 48);
            this.comboDSPPhoneTXBuf.Name = "comboDSPPhoneTXBuf";
            this.comboDSPPhoneTXBuf.Size = new System.Drawing.Size(64, 21);
            this.comboDSPPhoneTXBuf.TabIndex = 20;
            this.toolTip1.SetToolTip(this.comboDSPPhoneTXBuf, "Sets DSP internal Buffer Size -- larger yields sharper filters, more latency");
            this.comboDSPPhoneTXBuf.ValueMember = "1024";
            this.comboDSPPhoneTXBuf.SelectedIndexChanged += new System.EventHandler(this.comboDSPPhoneTXBuf_SelectedIndexChanged);
            // 
            // lblDSPPhoneBufferRX
            // 
            this.lblDSPPhoneBufferRX.Image = null;
            this.lblDSPPhoneBufferRX.Location = new System.Drawing.Point(8, 24);
            this.lblDSPPhoneBufferRX.Name = "lblDSPPhoneBufferRX";
            this.lblDSPPhoneBufferRX.Size = new System.Drawing.Size(24, 16);
            this.lblDSPPhoneBufferRX.TabIndex = 19;
            this.lblDSPPhoneBufferRX.Text = "RX:";
            // 
            // comboDSPPhoneRXBuf
            // 
            this.comboDSPPhoneRXBuf.DisplayMember = "2048";
            this.comboDSPPhoneRXBuf.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDSPPhoneRXBuf.DropDownWidth = 64;
            this.comboDSPPhoneRXBuf.Items.AddRange(new object[] {
            "256",
            "512",
            "1024",
            "2048",
            "4096"});
            this.comboDSPPhoneRXBuf.Location = new System.Drawing.Point(32, 24);
            this.comboDSPPhoneRXBuf.Name = "comboDSPPhoneRXBuf";
            this.comboDSPPhoneRXBuf.Size = new System.Drawing.Size(64, 21);
            this.comboDSPPhoneRXBuf.TabIndex = 18;
            this.toolTip1.SetToolTip(this.comboDSPPhoneRXBuf, "Sets DSP internal Buffer Size -- larger yields sharper filters, more latency");
            this.comboDSPPhoneRXBuf.ValueMember = "1024";
            this.comboDSPPhoneRXBuf.SelectedIndexChanged += new System.EventHandler(this.comboDSPPhoneRXBuf_SelectedIndexChanged);
            // 
            // lblDSPPhoneBufferTX
            // 
            this.lblDSPPhoneBufferTX.Image = null;
            this.lblDSPPhoneBufferTX.Location = new System.Drawing.Point(8, 48);
            this.lblDSPPhoneBufferTX.Name = "lblDSPPhoneBufferTX";
            this.lblDSPPhoneBufferTX.Size = new System.Drawing.Size(24, 16);
            this.lblDSPPhoneBufferTX.TabIndex = 21;
            this.lblDSPPhoneBufferTX.Text = "TX:";
            // 
            // grpDSPNB
            // 
            this.grpDSPNB.Controls.Add(this.udDSPHT);
            this.grpDSPNB.Controls.Add(this.udDSPDLY);
            this.grpDSPNB.Controls.Add(this.labelTS55);
            this.grpDSPNB.Controls.Add(this.labelTS54);
            this.grpDSPNB.Controls.Add(this.udDSPNB);
            this.grpDSPNB.Controls.Add(this.lblDSPNBThreshold);
            this.grpDSPNB.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.grpDSPNB.Location = new System.Drawing.Point(384, 8);
            this.grpDSPNB.Name = "grpDSPNB";
            this.grpDSPNB.Size = new System.Drawing.Size(120, 141);
            this.grpDSPNB.TabIndex = 35;
            this.grpDSPNB.TabStop = false;
            this.grpDSPNB.Text = "Noise Blanker";
            // 
            // udDSPHT
            // 
            this.udDSPHT.FormattingEnabled = true;
            this.udDSPHT.Items.AddRange(new object[] {
            "3",
            "7",
            "15",
            "31"});
            this.udDSPHT.Location = new System.Drawing.Point(65, 45);
            this.udDSPHT.Name = "udDSPHT";
            this.udDSPHT.Size = new System.Drawing.Size(40, 21);
            this.udDSPHT.TabIndex = 15;
            this.udDSPHT.Text = "7";
            this.toolTip1.SetToolTip(this.udDSPHT, "Width of noise blanking\r\n\r\nSmall values 3 or 7 may not blank noise\r\nLarge values " +
        " may cause distortion\r\n\r\n7 was original value");
            this.udDSPHT.SelectedIndexChanged += new System.EventHandler(this.udDSPHT_SelectedIndexChanged_1);
            // 
            // udDSPDLY
            // 
            this.udDSPDLY.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPDLY.Location = new System.Drawing.Point(65, 73);
            this.udDSPDLY.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPDLY.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPDLY.Name = "udDSPDLY";
            this.udDSPDLY.Size = new System.Drawing.Size(40, 20);
            this.udDSPDLY.TabIndex = 11;
            this.toolTip1.SetToolTip(this.udDSPDLY, "2 = default");
            this.udDSPDLY.Value = new decimal(new int[] {
            2,
            0,
            0,
            0});
            this.udDSPDLY.ValueChanged += new System.EventHandler(this.udDSPDLY_ValueChanged);
            // 
            // labelTS55
            // 
            this.labelTS55.Image = null;
            this.labelTS55.Location = new System.Drawing.Point(23, 75);
            this.labelTS55.Name = "labelTS55";
            this.labelTS55.Size = new System.Drawing.Size(50, 13);
            this.labelTS55.TabIndex = 13;
            this.labelTS55.Text = "Delay:";
            // 
            // labelTS54
            // 
            this.labelTS54.Image = null;
            this.labelTS54.Location = new System.Drawing.Point(24, 48);
            this.labelTS54.Name = "labelTS54";
            this.labelTS54.Size = new System.Drawing.Size(49, 16);
            this.labelTS54.TabIndex = 12;
            this.labelTS54.Text = "Width:";
            // 
            // udDSPNB
            // 
            this.udDSPNB.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPNB.Location = new System.Drawing.Point(65, 19);
            this.udDSPNB.Maximum = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDSPNB.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPNB.Name = "udDSPNB";
            this.udDSPNB.Size = new System.Drawing.Size(40, 20);
            this.udDSPNB.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udDSPNB, resources.GetString("udDSPNB.ToolTip"));
            this.udDSPNB.Value = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udDSPNB.ValueChanged += new System.EventHandler(this.udDSPNB_ValueChanged);
            this.udDSPNB.LostFocus += new System.EventHandler(this.udDSPNB_LostFocus);
            // 
            // lblDSPNBThreshold
            // 
            this.lblDSPNBThreshold.Image = null;
            this.lblDSPNBThreshold.Location = new System.Drawing.Point(9, 19);
            this.lblDSPNBThreshold.Name = "lblDSPNBThreshold";
            this.lblDSPNBThreshold.Size = new System.Drawing.Size(64, 16);
            this.lblDSPNBThreshold.TabIndex = 9;
            this.lblDSPNBThreshold.Text = "Threshold:";
            // 
            // grpDSPLMSNR
            // 
            this.grpDSPLMSNR.Controls.Add(this.udLMSNRLeak);
            this.grpDSPLMSNR.Controls.Add(this.lblLMSNRLeak);
            this.grpDSPLMSNR.Controls.Add(this.lblLMSNRgain);
            this.grpDSPLMSNR.Controls.Add(this.udLMSNRgain);
            this.grpDSPLMSNR.Controls.Add(this.lblLMSNRdelay);
            this.grpDSPLMSNR.Controls.Add(this.udLMSNRtaps);
            this.grpDSPLMSNR.Controls.Add(this.udLMSNRdelay);
            this.grpDSPLMSNR.Controls.Add(this.lblLMSNRtaps);
            this.grpDSPLMSNR.Location = new System.Drawing.Point(8, 8);
            this.grpDSPLMSNR.Name = "grpDSPLMSNR";
            this.grpDSPLMSNR.Size = new System.Drawing.Size(112, 128);
            this.grpDSPLMSNR.TabIndex = 33;
            this.grpDSPLMSNR.TabStop = false;
            this.grpDSPLMSNR.Text = "NR";
            this.toolTip1.SetToolTip(this.grpDSPLMSNR, "Noise Reduction");
            // 
            // udLMSNRLeak
            // 
            this.udLMSNRLeak.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSNRLeak.Location = new System.Drawing.Point(56, 96);
            this.udLMSNRLeak.Maximum = new decimal(new int[] {
            100000,
            0,
            0,
            0});
            this.udLMSNRLeak.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSNRLeak.Name = "udLMSNRLeak";
            this.udLMSNRLeak.Size = new System.Drawing.Size(48, 20);
            this.udLMSNRLeak.TabIndex = 10;
            this.toolTip1.SetToolTip(this.udLMSNRLeak, "Keeps the filter within a reasonable range once converged");
            this.udLMSNRLeak.Value = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udLMSNRLeak.ValueChanged += new System.EventHandler(this.udLMSNR_ValueChanged);
            // 
            // lblLMSNRLeak
            // 
            this.lblLMSNRLeak.Image = null;
            this.lblLMSNRLeak.Location = new System.Drawing.Point(8, 96);
            this.lblLMSNRLeak.Name = "lblLMSNRLeak";
            this.lblLMSNRLeak.Size = new System.Drawing.Size(40, 16);
            this.lblLMSNRLeak.TabIndex = 11;
            this.lblLMSNRLeak.Text = "Leak:";
            // 
            // lblLMSNRgain
            // 
            this.lblLMSNRgain.Image = null;
            this.lblLMSNRgain.Location = new System.Drawing.Point(8, 48);
            this.lblLMSNRgain.Name = "lblLMSNRgain";
            this.lblLMSNRgain.Size = new System.Drawing.Size(40, 16);
            this.lblLMSNRgain.TabIndex = 9;
            this.lblLMSNRgain.Text = "Gain:";
            // 
            // udLMSNRgain
            // 
            this.udLMSNRgain.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSNRgain.Location = new System.Drawing.Point(56, 48);
            this.udLMSNRgain.Maximum = new decimal(new int[] {
            9999,
            0,
            0,
            0});
            this.udLMSNRgain.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSNRgain.Name = "udLMSNRgain";
            this.udLMSNRgain.Size = new System.Drawing.Size(48, 20);
            this.udLMSNRgain.TabIndex = 7;
            this.toolTip1.SetToolTip(this.udLMSNRgain, "Determines the adaptation rate of the filter.");
            this.udLMSNRgain.Value = new decimal(new int[] {
            16,
            0,
            0,
            0});
            this.udLMSNRgain.ValueChanged += new System.EventHandler(this.udLMSNR_ValueChanged);
            this.udLMSNRgain.LostFocus += new System.EventHandler(this.udLMSNRgain_LostFocus);
            // 
            // lblLMSNRdelay
            // 
            this.lblLMSNRdelay.Image = null;
            this.lblLMSNRdelay.Location = new System.Drawing.Point(8, 72);
            this.lblLMSNRdelay.Name = "lblLMSNRdelay";
            this.lblLMSNRdelay.Size = new System.Drawing.Size(40, 16);
            this.lblLMSNRdelay.TabIndex = 5;
            this.lblLMSNRdelay.Text = "Delay:";
            // 
            // udLMSNRtaps
            // 
            this.udLMSNRtaps.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSNRtaps.Location = new System.Drawing.Point(56, 24);
            this.udLMSNRtaps.Maximum = new decimal(new int[] {
            128,
            0,
            0,
            0});
            this.udLMSNRtaps.Minimum = new decimal(new int[] {
            31,
            0,
            0,
            0});
            this.udLMSNRtaps.Name = "udLMSNRtaps";
            this.udLMSNRtaps.Size = new System.Drawing.Size(48, 20);
            this.udLMSNRtaps.TabIndex = 5;
            this.toolTip1.SetToolTip(this.udLMSNRtaps, "Determines the length of the NR computed filter.  ");
            this.udLMSNRtaps.Value = new decimal(new int[] {
            40,
            0,
            0,
            0});
            this.udLMSNRtaps.ValueChanged += new System.EventHandler(this.udLMSNR_ValueChanged);
            this.udLMSNRtaps.LostFocus += new System.EventHandler(this.udLMSNRtaps_LostFocus);
            // 
            // udLMSNRdelay
            // 
            this.udLMSNRdelay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSNRdelay.Location = new System.Drawing.Point(56, 72);
            this.udLMSNRdelay.Maximum = new decimal(new int[] {
            126,
            0,
            0,
            0});
            this.udLMSNRdelay.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSNRdelay.Name = "udLMSNRdelay";
            this.udLMSNRdelay.Size = new System.Drawing.Size(48, 20);
            this.udLMSNRdelay.TabIndex = 6;
            this.toolTip1.SetToolTip(this.udLMSNRdelay, "Determines how far back you look in the signal before you begin to compute a cohe" +
        "rent signal enhancement filter.  ");
            this.udLMSNRdelay.Value = new decimal(new int[] {
            30,
            0,
            0,
            0});
            this.udLMSNRdelay.ValueChanged += new System.EventHandler(this.udLMSNR_ValueChanged);
            this.udLMSNRdelay.LostFocus += new System.EventHandler(this.udLMSNRdelay_LostFocus);
            // 
            // lblLMSNRtaps
            // 
            this.lblLMSNRtaps.Image = null;
            this.lblLMSNRtaps.Location = new System.Drawing.Point(8, 24);
            this.lblLMSNRtaps.Name = "lblLMSNRtaps";
            this.lblLMSNRtaps.Size = new System.Drawing.Size(40, 16);
            this.lblLMSNRtaps.TabIndex = 3;
            this.lblLMSNRtaps.Text = "Taps:";
            // 
            // grpDSPLMSANF
            // 
            this.grpDSPLMSANF.Controls.Add(this.udLMSANFLeak);
            this.grpDSPLMSANF.Controls.Add(this.lblLMSANFLeak);
            this.grpDSPLMSANF.Controls.Add(this.lblLMSANFgain);
            this.grpDSPLMSANF.Controls.Add(this.udLMSANFgain);
            this.grpDSPLMSANF.Controls.Add(this.lblLMSANFdelay);
            this.grpDSPLMSANF.Controls.Add(this.udLMSANFdelay);
            this.grpDSPLMSANF.Controls.Add(this.lblLMSANFTaps);
            this.grpDSPLMSANF.Controls.Add(this.udLMSANFtaps);
            this.grpDSPLMSANF.Location = new System.Drawing.Point(128, 8);
            this.grpDSPLMSANF.Name = "grpDSPLMSANF";
            this.grpDSPLMSANF.Size = new System.Drawing.Size(120, 128);
            this.grpDSPLMSANF.TabIndex = 32;
            this.grpDSPLMSANF.TabStop = false;
            this.grpDSPLMSANF.Text = "ANF";
            this.toolTip1.SetToolTip(this.grpDSPLMSANF, "Automatic Notch Filter");
            // 
            // udLMSANFLeak
            // 
            this.udLMSANFLeak.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSANFLeak.Location = new System.Drawing.Point(56, 96);
            this.udLMSANFLeak.Maximum = new decimal(new int[] {
            100000,
            0,
            0,
            0});
            this.udLMSANFLeak.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSANFLeak.Name = "udLMSANFLeak";
            this.udLMSANFLeak.Size = new System.Drawing.Size(48, 20);
            this.udLMSANFLeak.TabIndex = 8;
            this.toolTip1.SetToolTip(this.udLMSANFLeak, "Keeps the filter within a reasonable range once converged");
            this.udLMSANFLeak.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSANFLeak.ValueChanged += new System.EventHandler(this.udLMSANF_ValueChanged);
            // 
            // lblLMSANFLeak
            // 
            this.lblLMSANFLeak.Image = null;
            this.lblLMSANFLeak.Location = new System.Drawing.Point(8, 96);
            this.lblLMSANFLeak.Name = "lblLMSANFLeak";
            this.lblLMSANFLeak.Size = new System.Drawing.Size(40, 16);
            this.lblLMSANFLeak.TabIndex = 9;
            this.lblLMSANFLeak.Text = "Leak:";
            // 
            // lblLMSANFgain
            // 
            this.lblLMSANFgain.Image = null;
            this.lblLMSANFgain.Location = new System.Drawing.Point(8, 48);
            this.lblLMSANFgain.Name = "lblLMSANFgain";
            this.lblLMSANFgain.Size = new System.Drawing.Size(40, 16);
            this.lblLMSANFgain.TabIndex = 6;
            this.lblLMSANFgain.Text = "Gain:";
            // 
            // udLMSANFgain
            // 
            this.udLMSANFgain.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSANFgain.Location = new System.Drawing.Point(56, 48);
            this.udLMSANFgain.Maximum = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udLMSANFgain.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSANFgain.Name = "udLMSANFgain";
            this.udLMSANFgain.Size = new System.Drawing.Size(48, 20);
            this.udLMSANFgain.TabIndex = 3;
            this.toolTip1.SetToolTip(this.udLMSANFgain, "Determines the adaptation rate of the filter.");
            this.udLMSANFgain.Value = new decimal(new int[] {
            25,
            0,
            0,
            0});
            this.udLMSANFgain.ValueChanged += new System.EventHandler(this.udLMSANF_ValueChanged);
            this.udLMSANFgain.LostFocus += new System.EventHandler(this.udLMSANFgain_LostFocus);
            // 
            // lblLMSANFdelay
            // 
            this.lblLMSANFdelay.Image = null;
            this.lblLMSANFdelay.Location = new System.Drawing.Point(8, 72);
            this.lblLMSANFdelay.Name = "lblLMSANFdelay";
            this.lblLMSANFdelay.Size = new System.Drawing.Size(40, 16);
            this.lblLMSANFdelay.TabIndex = 4;
            this.lblLMSANFdelay.Text = "Delay:";
            // 
            // udLMSANFdelay
            // 
            this.udLMSANFdelay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSANFdelay.Location = new System.Drawing.Point(56, 72);
            this.udLMSANFdelay.Maximum = new decimal(new int[] {
            126,
            0,
            0,
            0});
            this.udLMSANFdelay.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSANFdelay.Name = "udLMSANFdelay";
            this.udLMSANFdelay.Size = new System.Drawing.Size(48, 20);
            this.udLMSANFdelay.TabIndex = 2;
            this.toolTip1.SetToolTip(this.udLMSANFdelay, "Determines how far back you look in the signal before you begin to compute a canc" +
        "ellation filter");
            this.udLMSANFdelay.Value = new decimal(new int[] {
            60,
            0,
            0,
            0});
            this.udLMSANFdelay.ValueChanged += new System.EventHandler(this.udLMSANF_ValueChanged);
            this.udLMSANFdelay.LostFocus += new System.EventHandler(this.udLMSANFdelay_LostFocus);
            // 
            // lblLMSANFTaps
            // 
            this.lblLMSANFTaps.Image = null;
            this.lblLMSANFTaps.Location = new System.Drawing.Point(8, 24);
            this.lblLMSANFTaps.Name = "lblLMSANFTaps";
            this.lblLMSANFTaps.Size = new System.Drawing.Size(40, 16);
            this.lblLMSANFTaps.TabIndex = 2;
            this.lblLMSANFTaps.Text = "Taps:";
            // 
            // udLMSANFtaps
            // 
            this.udLMSANFtaps.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udLMSANFtaps.Location = new System.Drawing.Point(56, 24);
            this.udLMSANFtaps.Maximum = new decimal(new int[] {
            128,
            0,
            0,
            0});
            this.udLMSANFtaps.Minimum = new decimal(new int[] {
            31,
            0,
            0,
            0});
            this.udLMSANFtaps.Name = "udLMSANFtaps";
            this.udLMSANFtaps.Size = new System.Drawing.Size(48, 20);
            this.udLMSANFtaps.TabIndex = 1;
            this.toolTip1.SetToolTip(this.udLMSANFtaps, "Determines the length of the computed notch filter.");
            this.udLMSANFtaps.Value = new decimal(new int[] {
            68,
            0,
            0,
            0});
            this.udLMSANFtaps.ValueChanged += new System.EventHandler(this.udLMSANF_ValueChanged);
            this.udLMSANFtaps.LostFocus += new System.EventHandler(this.udLMSANFtaps_LostFocus);
            // 
            // grpDSPWindow
            // 
            this.grpDSPWindow.Controls.Add(this.comboDSPWindow);
            this.grpDSPWindow.Location = new System.Drawing.Point(395, 254);
            this.grpDSPWindow.Name = "grpDSPWindow";
            this.grpDSPWindow.Size = new System.Drawing.Size(120, 56);
            this.grpDSPWindow.TabIndex = 36;
            this.grpDSPWindow.TabStop = false;
            this.grpDSPWindow.Text = "Window";
            // 
            // comboDSPWindow
            // 
            this.comboDSPWindow.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboDSPWindow.DropDownWidth = 88;
            this.comboDSPWindow.Location = new System.Drawing.Point(16, 24);
            this.comboDSPWindow.Name = "comboDSPWindow";
            this.comboDSPWindow.Size = new System.Drawing.Size(88, 21);
            this.comboDSPWindow.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboDSPWindow, "Selects the DSP windowing function that will be applied to the power spectrum in " +
        "the main display when in Spectrum, Panadapter, and Waterfall modes.   ");
            this.comboDSPWindow.SelectedIndexChanged += new System.EventHandler(this.comboDSPWindow_SelectedIndexChanged);
            // 
            // grpDSPNB2
            // 
            this.grpDSPNB2.Controls.Add(this.udDSPNB2);
            this.grpDSPNB2.Controls.Add(this.lblDSPNB2Threshold);
            this.grpDSPNB2.Location = new System.Drawing.Point(385, 155);
            this.grpDSPNB2.Name = "grpDSPNB2";
            this.grpDSPNB2.Size = new System.Drawing.Size(120, 53);
            this.grpDSPNB2.TabIndex = 34;
            this.grpDSPNB2.TabStop = false;
            this.grpDSPNB2.Text = "Noise Blanker 2";
            // 
            // udDSPNB2
            // 
            this.udDSPNB2.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPNB2.Location = new System.Drawing.Point(64, 24);
            this.udDSPNB2.Maximum = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udDSPNB2.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPNB2.Name = "udDSPNB2";
            this.udDSPNB2.Size = new System.Drawing.Size(40, 20);
            this.udDSPNB2.TabIndex = 7;
            this.toolTip1.SetToolTip(this.udDSPNB2, "Controls the detection threshold for a pulse.  \r\n\r\nNB2 does not use hangtime or d" +
        "elay like NB1");
            this.udDSPNB2.Value = new decimal(new int[] {
            15,
            0,
            0,
            0});
            this.udDSPNB2.ValueChanged += new System.EventHandler(this.udDSPNB2_ValueChanged);
            this.udDSPNB2.LostFocus += new System.EventHandler(this.udDSPNB2_LostFocus);
            // 
            // lblDSPNB2Threshold
            // 
            this.lblDSPNB2Threshold.Image = null;
            this.lblDSPNB2Threshold.Location = new System.Drawing.Point(8, 24);
            this.lblDSPNB2Threshold.Name = "lblDSPNB2Threshold";
            this.lblDSPNB2Threshold.Size = new System.Drawing.Size(64, 16);
            this.lblDSPNB2Threshold.TabIndex = 10;
            this.lblDSPNB2Threshold.Text = "Threshold:";
            // 
            // tpDSPImageReject
            // 
            this.tpDSPImageReject.Controls.Add(this.chkDSPImageExpert);
            this.tpDSPImageReject.Controls.Add(this.grpDSPImageRejectTX);
            this.tpDSPImageReject.Location = new System.Drawing.Point(4, 22);
            this.tpDSPImageReject.Name = "tpDSPImageReject";
            this.tpDSPImageReject.Size = new System.Drawing.Size(600, 318);
            this.tpDSPImageReject.TabIndex = 1;
            this.tpDSPImageReject.Text = "Image Reject";
            // 
            // chkDSPImageExpert
            // 
            this.chkDSPImageExpert.Location = new System.Drawing.Point(3, 193);
            this.chkDSPImageExpert.Name = "chkDSPImageExpert";
            this.chkDSPImageExpert.Size = new System.Drawing.Size(56, 24);
            this.chkDSPImageExpert.TabIndex = 35;
            this.chkDSPImageExpert.Text = "Expert";
            this.chkDSPImageExpert.CheckedChanged += new System.EventHandler(this.chkDSPImageExpert_CheckedChanged);
            // 
            // grpDSPImageRejectTX
            // 
            this.grpDSPImageRejectTX.Controls.Add(this.checkboxTXImagCal);
            this.grpDSPImageRejectTX.Controls.Add(this.lblDSPGainValTX);
            this.grpDSPImageRejectTX.Controls.Add(this.lblDSPPhaseValTX);
            this.grpDSPImageRejectTX.Controls.Add(this.udDSPImageGainTX);
            this.grpDSPImageRejectTX.Controls.Add(this.udDSPImagePhaseTX);
            this.grpDSPImageRejectTX.Controls.Add(this.lblDSPImageGainTX);
            this.grpDSPImageRejectTX.Controls.Add(this.tbDSPImagePhaseTX);
            this.grpDSPImageRejectTX.Controls.Add(this.lblDSPImagePhaseTX);
            this.grpDSPImageRejectTX.Controls.Add(this.tbDSPImageGainTX);
            this.grpDSPImageRejectTX.Location = new System.Drawing.Point(3, 3);
            this.grpDSPImageRejectTX.Name = "grpDSPImageRejectTX";
            this.grpDSPImageRejectTX.Size = new System.Drawing.Size(240, 184);
            this.grpDSPImageRejectTX.TabIndex = 33;
            this.grpDSPImageRejectTX.TabStop = false;
            this.grpDSPImageRejectTX.Text = "Transmit Rejection";
            // 
            // checkboxTXImagCal
            // 
            this.checkboxTXImagCal.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.checkboxTXImagCal.Image = null;
            this.checkboxTXImagCal.Location = new System.Drawing.Point(48, 144);
            this.checkboxTXImagCal.Name = "checkboxTXImagCal";
            this.checkboxTXImagCal.Size = new System.Drawing.Size(144, 16);
            this.checkboxTXImagCal.TabIndex = 37;
            this.checkboxTXImagCal.Text = "Enable TX Image Tone";
            this.toolTip1.SetToolTip(this.checkboxTXImagCal, "Check this box while in MOX on USB to calibrate the Transmit Rejection using the " +
        "controls above.");
            this.checkboxTXImagCal.CheckedChanged += new System.EventHandler(this.chkTXImagCal_CheckedChanged);
            // 
            // lblDSPGainValTX
            // 
            this.lblDSPGainValTX.Image = null;
            this.lblDSPGainValTX.Location = new System.Drawing.Point(72, 104);
            this.lblDSPGainValTX.Name = "lblDSPGainValTX";
            this.lblDSPGainValTX.Size = new System.Drawing.Size(163, 16);
            this.lblDSPGainValTX.TabIndex = 15;
            this.lblDSPGainValTX.Text = "-500    -250       0       250     500";
            // 
            // lblDSPPhaseValTX
            // 
            this.lblDSPPhaseValTX.Image = null;
            this.lblDSPPhaseValTX.Location = new System.Drawing.Point(72, 56);
            this.lblDSPPhaseValTX.Name = "lblDSPPhaseValTX";
            this.lblDSPPhaseValTX.Size = new System.Drawing.Size(163, 16);
            this.lblDSPPhaseValTX.TabIndex = 14;
            this.lblDSPPhaseValTX.Text = "-400    -200       0       200     400";
            // 
            // udDSPImageGainTX
            // 
            this.udDSPImageGainTX.DecimalPlaces = 2;
            this.udDSPImageGainTX.Increment = new decimal(new int[] {
            1,
            0,
            0,
            131072});
            this.udDSPImageGainTX.Location = new System.Drawing.Point(16, 88);
            this.udDSPImageGainTX.Maximum = new decimal(new int[] {
            500,
            0,
            0,
            0});
            this.udDSPImageGainTX.Minimum = new decimal(new int[] {
            500,
            0,
            0,
            -2147483648});
            this.udDSPImageGainTX.Name = "udDSPImageGainTX";
            this.udDSPImageGainTX.Size = new System.Drawing.Size(56, 20);
            this.udDSPImageGainTX.TabIndex = 8;
            this.toolTip1.SetToolTip(this.udDSPImageGainTX, "Sets the amplitude/gain offset between the I and Q channels.  ");
            this.udDSPImageGainTX.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPImageGainTX.ValueChanged += new System.EventHandler(this.udDSPImageGainTX_ValueChanged);
            this.udDSPImageGainTX.LostFocus += new System.EventHandler(this.udDSPImageGainTX_LostFocus);
            // 
            // udDSPImagePhaseTX
            // 
            this.udDSPImagePhaseTX.DecimalPlaces = 2;
            this.udDSPImagePhaseTX.Increment = new decimal(new int[] {
            1,
            0,
            0,
            131072});
            this.udDSPImagePhaseTX.Location = new System.Drawing.Point(16, 40);
            this.udDSPImagePhaseTX.Maximum = new decimal(new int[] {
            400,
            0,
            0,
            0});
            this.udDSPImagePhaseTX.Minimum = new decimal(new int[] {
            400,
            0,
            0,
            -2147483648});
            this.udDSPImagePhaseTX.Name = "udDSPImagePhaseTX";
            this.udDSPImagePhaseTX.Size = new System.Drawing.Size(56, 20);
            this.udDSPImagePhaseTX.TabIndex = 7;
            this.toolTip1.SetToolTip(this.udDSPImagePhaseTX, "Sets the phase offset between the I and Q channels.  ");
            this.udDSPImagePhaseTX.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPImagePhaseTX.ValueChanged += new System.EventHandler(this.udDSPImagePhaseTX_ValueChanged);
            this.udDSPImagePhaseTX.LostFocus += new System.EventHandler(this.udDSPImagePhaseTX_LostFocus);
            // 
            // lblDSPImageGainTX
            // 
            this.lblDSPImageGainTX.Image = null;
            this.lblDSPImageGainTX.Location = new System.Drawing.Point(16, 72);
            this.lblDSPImageGainTX.Name = "lblDSPImageGainTX";
            this.lblDSPImageGainTX.Size = new System.Drawing.Size(48, 16);
            this.lblDSPImageGainTX.TabIndex = 6;
            this.lblDSPImageGainTX.Text = "Gain:";
            // 
            // tbDSPImagePhaseTX
            // 
            this.tbDSPImagePhaseTX.LargeChange = 1;
            this.tbDSPImagePhaseTX.Location = new System.Drawing.Point(72, 24);
            this.tbDSPImagePhaseTX.Maximum = 400;
            this.tbDSPImagePhaseTX.Minimum = -400;
            this.tbDSPImagePhaseTX.Name = "tbDSPImagePhaseTX";
            this.tbDSPImagePhaseTX.Size = new System.Drawing.Size(160, 45);
            this.tbDSPImagePhaseTX.TabIndex = 3;
            this.tbDSPImagePhaseTX.TickFrequency = 50;
            this.toolTip1.SetToolTip(this.tbDSPImagePhaseTX, "Sets the phase offset between the I and Q channels.  ");
            this.tbDSPImagePhaseTX.Scroll += new System.EventHandler(this.tbDSPImagePhaseTX_Scroll);
            // 
            // lblDSPImagePhaseTX
            // 
            this.lblDSPImagePhaseTX.Image = null;
            this.lblDSPImagePhaseTX.Location = new System.Drawing.Point(16, 24);
            this.lblDSPImagePhaseTX.Name = "lblDSPImagePhaseTX";
            this.lblDSPImagePhaseTX.Size = new System.Drawing.Size(48, 16);
            this.lblDSPImagePhaseTX.TabIndex = 5;
            this.lblDSPImagePhaseTX.Text = "Phase:";
            // 
            // tbDSPImageGainTX
            // 
            this.tbDSPImageGainTX.LargeChange = 1;
            this.tbDSPImageGainTX.Location = new System.Drawing.Point(72, 72);
            this.tbDSPImageGainTX.Maximum = 500;
            this.tbDSPImageGainTX.Minimum = -500;
            this.tbDSPImageGainTX.Name = "tbDSPImageGainTX";
            this.tbDSPImageGainTX.Size = new System.Drawing.Size(160, 45);
            this.tbDSPImageGainTX.TabIndex = 4;
            this.tbDSPImageGainTX.TickFrequency = 50;
            this.toolTip1.SetToolTip(this.tbDSPImageGainTX, "Sets the amplitude/gain offset between the I and Q channels.  ");
            this.tbDSPImageGainTX.Scroll += new System.EventHandler(this.tbDSPImageGainTX_Scroll);
            // 
            // tpDSPKeyer
            // 
            this.tpDSPKeyer.Controls.Add(this.labelTS25);
            this.tpDSPKeyer.Controls.Add(this.chkKeyPoll);
            this.tpDSPKeyer.Controls.Add(this.chkCWDisableUI);
            this.tpDSPKeyer.Controls.Add(this.grpKeyerConnections);
            this.tpDSPKeyer.Controls.Add(this.grpDSPCWPitch);
            this.tpDSPKeyer.Controls.Add(this.grpDSPKeyerOptions);
            this.tpDSPKeyer.Controls.Add(this.grpDSPKeyerSignalShaping);
            this.tpDSPKeyer.Controls.Add(this.grpDSPKeyerSemiBreakIn);
            this.tpDSPKeyer.Location = new System.Drawing.Point(4, 22);
            this.tpDSPKeyer.Name = "tpDSPKeyer";
            this.tpDSPKeyer.Size = new System.Drawing.Size(600, 318);
            this.tpDSPKeyer.TabIndex = 0;
            this.tpDSPKeyer.Text = "Keyer";
            // 
            // labelTS25
            // 
            this.labelTS25.ForeColor = System.Drawing.Color.Black;
            this.labelTS25.Image = null;
            this.labelTS25.ImeMode = System.Windows.Forms.ImeMode.NoControl;
            this.labelTS25.Location = new System.Drawing.Point(193, 226);
            this.labelTS25.Name = "labelTS25";
            this.labelTS25.Size = new System.Drawing.Size(34, 15);
            this.labelTS25.TabIndex = 117;
            this.labelTS25.Text = "CWP";
            this.labelTS25.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.toolTip1.SetToolTip(this.labelTS25, "Allows you to use the CWX panel without going into CW mode");
            // 
            // chkKeyPoll
            // 
            this.chkKeyPoll.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F);
            this.chkKeyPoll.Image = null;
            this.chkKeyPoll.ImeMode = System.Windows.Forms.ImeMode.Off;
            this.chkKeyPoll.Location = new System.Drawing.Point(161, 226);
            this.chkKeyPoll.Name = "chkKeyPoll";
            this.chkKeyPoll.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
            this.chkKeyPoll.Size = new System.Drawing.Size(16, 15);
            this.chkKeyPoll.TabIndex = 115;
            this.chkKeyPoll.Text = "Drive Lock";
            this.toolTip1.SetToolTip(this.chkKeyPoll, "Allows you to use the CWX panel without going into CW mode.");
            this.chkKeyPoll.CheckedChanged += new System.EventHandler(this.chkKeyPoll_CheckedChanged);
            // 
            // chkCWDisableUI
            // 
            this.chkCWDisableUI.Checked = true;
            this.chkCWDisableUI.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkCWDisableUI.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkCWDisableUI.Image = null;
            this.chkCWDisableUI.Location = new System.Drawing.Point(161, 152);
            this.chkCWDisableUI.Name = "chkCWDisableUI";
            this.chkCWDisableUI.Size = new System.Drawing.Size(109, 32);
            this.chkCWDisableUI.TabIndex = 42;
            this.chkCWDisableUI.Text = "Disable UI MOX Changes";
            this.toolTip1.SetToolTip(this.chkCWDisableUI, "If enabled, will automatically switch to CW mode when paddles are used no matter " +
        "the current mode ");
            this.chkCWDisableUI.CheckedChanged += new System.EventHandler(this.chkCWDisableUI_CheckedChanged);
            // 
            // grpKeyerConnections
            // 
            this.grpKeyerConnections.Controls.Add(this.comboKeyerConnKeyLine);
            this.grpKeyerConnections.Controls.Add(this.comboKeyerConnSecondary);
            this.grpKeyerConnections.Controls.Add(this.lblKeyerConnSecondary);
            this.grpKeyerConnections.Controls.Add(this.lblKeyerConnKeyLine);
            this.grpKeyerConnections.Controls.Add(this.comboKeyerConnPTTLine);
            this.grpKeyerConnections.Controls.Add(this.lblKeyerConnPrimary);
            this.grpKeyerConnections.Controls.Add(this.lblKeyerConnPTTLine);
            this.grpKeyerConnections.Controls.Add(this.comboKeyerConnPrimary);
            this.grpKeyerConnections.Location = new System.Drawing.Point(112, 8);
            this.grpKeyerConnections.Name = "grpKeyerConnections";
            this.grpKeyerConnections.Size = new System.Drawing.Size(176, 128);
            this.grpKeyerConnections.TabIndex = 40;
            this.grpKeyerConnections.TabStop = false;
            this.grpKeyerConnections.Text = "Connections";
            // 
            // comboKeyerConnKeyLine
            // 
            this.comboKeyerConnKeyLine.DisplayMember = "None";
            this.comboKeyerConnKeyLine.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKeyerConnKeyLine.DropDownWidth = 64;
            this.comboKeyerConnKeyLine.Items.AddRange(new object[] {
            "None",
            "DTR",
            "RTS"});
            this.comboKeyerConnKeyLine.Location = new System.Drawing.Point(104, 96);
            this.comboKeyerConnKeyLine.Name = "comboKeyerConnKeyLine";
            this.comboKeyerConnKeyLine.Size = new System.Drawing.Size(64, 21);
            this.comboKeyerConnKeyLine.TabIndex = 51;
            this.toolTip1.SetToolTip(this.comboKeyerConnKeyLine, "Sets the COM port line that triggers the tone on the Keyer Port selected above.");
            this.comboKeyerConnKeyLine.ValueMember = "None";
            this.comboKeyerConnKeyLine.Visible = false;
            this.comboKeyerConnKeyLine.SelectedIndexChanged += new System.EventHandler(this.comboKeyerConnKeyLine_SelectedIndexChanged);
            // 
            // comboKeyerConnSecondary
            // 
            this.comboKeyerConnSecondary.DisplayMember = "None";
            this.comboKeyerConnSecondary.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKeyerConnSecondary.DropDownWidth = 64;
            this.comboKeyerConnSecondary.Items.AddRange(new object[] {
            "None"});
            this.comboKeyerConnSecondary.Location = new System.Drawing.Point(104, 48);
            this.comboKeyerConnSecondary.Name = "comboKeyerConnSecondary";
            this.comboKeyerConnSecondary.Size = new System.Drawing.Size(64, 21);
            this.comboKeyerConnSecondary.TabIndex = 53;
            this.toolTip1.SetToolTip(this.comboKeyerConnSecondary, "Sets Keyer Input COM port.  This can be an external keyer or a virtual COM port b" +
        "eing driven by a third party program.");
            this.comboKeyerConnSecondary.ValueMember = "None";
            this.comboKeyerConnSecondary.SelectedIndexChanged += new System.EventHandler(this.comboKeyerConnSecondary_SelectedIndexChanged);
            // 
            // lblKeyerConnSecondary
            // 
            this.lblKeyerConnSecondary.Image = null;
            this.lblKeyerConnSecondary.Location = new System.Drawing.Point(16, 48);
            this.lblKeyerConnSecondary.Name = "lblKeyerConnSecondary";
            this.lblKeyerConnSecondary.Size = new System.Drawing.Size(68, 16);
            this.lblKeyerConnSecondary.TabIndex = 52;
            this.lblKeyerConnSecondary.Text = "Secondary:";
            // 
            // lblKeyerConnKeyLine
            // 
            this.lblKeyerConnKeyLine.Image = null;
            this.lblKeyerConnKeyLine.Location = new System.Drawing.Point(16, 96);
            this.lblKeyerConnKeyLine.Name = "lblKeyerConnKeyLine";
            this.lblKeyerConnKeyLine.Size = new System.Drawing.Size(68, 16);
            this.lblKeyerConnKeyLine.TabIndex = 50;
            this.lblKeyerConnKeyLine.Text = "Key Line:";
            this.lblKeyerConnKeyLine.Visible = false;
            // 
            // comboKeyerConnPTTLine
            // 
            this.comboKeyerConnPTTLine.DisplayMember = "None";
            this.comboKeyerConnPTTLine.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKeyerConnPTTLine.DropDownWidth = 64;
            this.comboKeyerConnPTTLine.Items.AddRange(new object[] {
            "None",
            "DTR",
            "RTS"});
            this.comboKeyerConnPTTLine.Location = new System.Drawing.Point(104, 72);
            this.comboKeyerConnPTTLine.Name = "comboKeyerConnPTTLine";
            this.comboKeyerConnPTTLine.Size = new System.Drawing.Size(64, 21);
            this.comboKeyerConnPTTLine.TabIndex = 49;
            this.toolTip1.SetToolTip(this.comboKeyerConnPTTLine, "Sets the line on the Keyer Port above that triggers PTT.");
            this.comboKeyerConnPTTLine.ValueMember = "None";
            this.comboKeyerConnPTTLine.Visible = false;
            this.comboKeyerConnPTTLine.SelectedIndexChanged += new System.EventHandler(this.comboKeyerConnPTTLine_SelectedIndexChanged);
            // 
            // lblKeyerConnPrimary
            // 
            this.lblKeyerConnPrimary.Image = null;
            this.lblKeyerConnPrimary.Location = new System.Drawing.Point(16, 24);
            this.lblKeyerConnPrimary.Name = "lblKeyerConnPrimary";
            this.lblKeyerConnPrimary.Size = new System.Drawing.Size(88, 16);
            this.lblKeyerConnPrimary.TabIndex = 41;
            this.lblKeyerConnPrimary.Text = "Primary:";
            // 
            // lblKeyerConnPTTLine
            // 
            this.lblKeyerConnPTTLine.Image = null;
            this.lblKeyerConnPTTLine.Location = new System.Drawing.Point(16, 72);
            this.lblKeyerConnPTTLine.Name = "lblKeyerConnPTTLine";
            this.lblKeyerConnPTTLine.Size = new System.Drawing.Size(68, 16);
            this.lblKeyerConnPTTLine.TabIndex = 48;
            this.lblKeyerConnPTTLine.Text = "PTT Line:";
            this.lblKeyerConnPTTLine.Visible = false;
            // 
            // comboKeyerConnPrimary
            // 
            this.comboKeyerConnPrimary.DisplayMember = "LPT";
            this.comboKeyerConnPrimary.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKeyerConnPrimary.DropDownWidth = 64;
            this.comboKeyerConnPrimary.Items.AddRange(new object[] {
            "5000"});
            this.comboKeyerConnPrimary.Location = new System.Drawing.Point(104, 24);
            this.comboKeyerConnPrimary.Name = "comboKeyerConnPrimary";
            this.comboKeyerConnPrimary.Size = new System.Drawing.Size(64, 21);
            this.comboKeyerConnPrimary.TabIndex = 40;
            this.toolTip1.SetToolTip(this.comboKeyerConnPrimary, "Sets Key Paddle Input port");
            this.comboKeyerConnPrimary.ValueMember = "LPT";
            this.comboKeyerConnPrimary.SelectedIndexChanged += new System.EventHandler(this.comboKeyerConnPrimary_SelectedIndexChanged);
            // 
            // grpDSPCWPitch
            // 
            this.grpDSPCWPitch.Controls.Add(this.lblDSPCWPitchFreq);
            this.grpDSPCWPitch.Controls.Add(this.udDSPCWPitch);
            this.grpDSPCWPitch.Location = new System.Drawing.Point(8, 8);
            this.grpDSPCWPitch.Name = "grpDSPCWPitch";
            this.grpDSPCWPitch.Size = new System.Drawing.Size(96, 64);
            this.grpDSPCWPitch.TabIndex = 39;
            this.grpDSPCWPitch.TabStop = false;
            this.grpDSPCWPitch.Text = "CW Pitch (Hz)";
            // 
            // lblDSPCWPitchFreq
            // 
            this.lblDSPCWPitchFreq.Image = null;
            this.lblDSPCWPitchFreq.Location = new System.Drawing.Point(8, 24);
            this.lblDSPCWPitchFreq.Name = "lblDSPCWPitchFreq";
            this.lblDSPCWPitchFreq.Size = new System.Drawing.Size(32, 16);
            this.lblDSPCWPitchFreq.TabIndex = 8;
            this.lblDSPCWPitchFreq.Text = "Freq:";
            // 
            // udDSPCWPitch
            // 
            this.udDSPCWPitch.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPCWPitch.Location = new System.Drawing.Point(40, 24);
            this.udDSPCWPitch.Maximum = new decimal(new int[] {
            2250,
            0,
            0,
            0});
            this.udDSPCWPitch.Minimum = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udDSPCWPitch.Name = "udDSPCWPitch";
            this.udDSPCWPitch.Size = new System.Drawing.Size(48, 20);
            this.udDSPCWPitch.TabIndex = 7;
            this.toolTip1.SetToolTip(this.udDSPCWPitch, "Selects the preferred CW tone frequency.");
            this.udDSPCWPitch.Value = new decimal(new int[] {
            600,
            0,
            0,
            0});
            this.udDSPCWPitch.ValueChanged += new System.EventHandler(this.udDSPCWPitch_ValueChanged);
            this.udDSPCWPitch.LostFocus += new System.EventHandler(this.udDSPCWPitch_LostFocus);
            // 
            // grpDSPKeyerOptions
            // 
            this.grpDSPKeyerOptions.Controls.Add(this.chkCWDisplay);
            this.grpDSPKeyerOptions.Controls.Add(this.chkModeBStrict);
            this.grpDSPKeyerOptions.Controls.Add(this.chkStrictCharSpacing);
            this.grpDSPKeyerOptions.Controls.Add(this.chkCWKeyerMonoCable);
            this.grpDSPKeyerOptions.Controls.Add(this.chkCWKeyerMode);
            this.grpDSPKeyerOptions.Controls.Add(this.chkCWKeyerRevPdl);
            this.grpDSPKeyerOptions.Controls.Add(this.chkDSPKeyerSidetone);
            this.grpDSPKeyerOptions.Controls.Add(this.chkCWKeyerIambic);
            this.grpDSPKeyerOptions.Controls.Add(this.chkCWAutoSwitchMode);
            this.grpDSPKeyerOptions.Location = new System.Drawing.Point(296, 8);
            this.grpDSPKeyerOptions.Name = "grpDSPKeyerOptions";
            this.grpDSPKeyerOptions.Size = new System.Drawing.Size(142, 288);
            this.grpDSPKeyerOptions.TabIndex = 37;
            this.grpDSPKeyerOptions.TabStop = false;
            this.grpDSPKeyerOptions.Text = "Options";
            // 
            // chkCWDisplay
            // 
            this.chkCWDisplay.Image = null;
            this.chkCWDisplay.Location = new System.Drawing.Point(16, 212);
            this.chkCWDisplay.Name = "chkCWDisplay";
            this.chkCWDisplay.Size = new System.Drawing.Size(100, 70);
            this.chkCWDisplay.TabIndex = 70;
            this.chkCWDisplay.Text = "Visual display of CW pulses on Panadapter";
            this.toolTip1.SetToolTip(this.chkCWDisplay, "Visual display of CW pulses on Panadapter\r\n\r\nSuggest you narrow your transmit fil" +
        "ter around your CW carrier \r\n500 - 700 hz");
            this.chkCWDisplay.CheckedChanged += new System.EventHandler(this.chkCWDisplay_CheckedChanged);
            // 
            // chkModeBStrict
            // 
            this.chkModeBStrict.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkModeBStrict.Image = null;
            this.chkModeBStrict.Location = new System.Drawing.Point(16, 144);
            this.chkModeBStrict.Name = "chkModeBStrict";
            this.chkModeBStrict.Size = new System.Drawing.Size(113, 16);
            this.chkModeBStrict.TabIndex = 44;
            this.chkModeBStrict.Text = "Mode B Strict";
            this.toolTip1.SetToolTip(this.chkModeBStrict, "Sets the detection threshold to halfway into the current element.");
            this.chkModeBStrict.CheckedChanged += new System.EventHandler(this.chkModeBStrict_CheckedChanged);
            // 
            // chkStrictCharSpacing
            // 
            this.chkStrictCharSpacing.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkStrictCharSpacing.Image = null;
            this.chkStrictCharSpacing.Location = new System.Drawing.Point(16, 192);
            this.chkStrictCharSpacing.Name = "chkStrictCharSpacing";
            this.chkStrictCharSpacing.Size = new System.Drawing.Size(113, 16);
            this.chkStrictCharSpacing.TabIndex = 43;
            this.chkStrictCharSpacing.Text = "Strict Char Space";
            this.toolTip1.SetToolTip(this.chkStrictCharSpacing, "If enabled, will automatically force a full space after each character.");
            this.chkStrictCharSpacing.CheckedChanged += new System.EventHandler(this.chkStrictCharSpacing_CheckedChanged);
            // 
            // chkCWKeyerMonoCable
            // 
            this.chkCWKeyerMonoCable.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkCWKeyerMonoCable.Image = null;
            this.chkCWKeyerMonoCable.Location = new System.Drawing.Point(16, 96);
            this.chkCWKeyerMonoCable.Name = "chkCWKeyerMonoCable";
            this.chkCWKeyerMonoCable.Size = new System.Drawing.Size(113, 16);
            this.chkCWKeyerMonoCable.TabIndex = 42;
            this.chkCWKeyerMonoCable.Text = "2-Wire Cable";
            this.toolTip1.SetToolTip(this.chkCWKeyerMonoCable, "Allows the use of a straight key and other devices suce as paddles on the \r\nFLEX-" +
        "xx00 series of radios that use only 2 wires to make the connection.");
            this.chkCWKeyerMonoCable.CheckedChanged += new System.EventHandler(this.chkCWKeyerMonoCable_CheckedChanged);
            // 
            // chkCWKeyerMode
            // 
            this.chkCWKeyerMode.Checked = true;
            this.chkCWKeyerMode.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkCWKeyerMode.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkCWKeyerMode.Image = null;
            this.chkCWKeyerMode.Location = new System.Drawing.Point(16, 120);
            this.chkCWKeyerMode.Name = "chkCWKeyerMode";
            this.chkCWKeyerMode.Size = new System.Drawing.Size(113, 16);
            this.chkCWKeyerMode.TabIndex = 40;
            this.chkCWKeyerMode.Text = "Mode B";
            this.toolTip1.SetToolTip(this.chkCWKeyerMode, "Set Keyer Mode");
            this.chkCWKeyerMode.CheckedChanged += new System.EventHandler(this.chkCWKeyerMode_CheckedChanged);
            // 
            // chkCWKeyerRevPdl
            // 
            this.chkCWKeyerRevPdl.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkCWKeyerRevPdl.Image = null;
            this.chkCWKeyerRevPdl.Location = new System.Drawing.Point(16, 72);
            this.chkCWKeyerRevPdl.Name = "chkCWKeyerRevPdl";
            this.chkCWKeyerRevPdl.Size = new System.Drawing.Size(113, 16);
            this.chkCWKeyerRevPdl.TabIndex = 38;
            this.chkCWKeyerRevPdl.Text = "Reverse Paddles";
            this.toolTip1.SetToolTip(this.chkCWKeyerRevPdl, "Reverses the input paddle -- Dot becomes Dash and vice versa.");
            this.chkCWKeyerRevPdl.CheckedChanged += new System.EventHandler(this.chkCWKeyerRevPdl_CheckedChanged);
            // 
            // chkDSPKeyerSidetone
            // 
            this.chkDSPKeyerSidetone.Checked = true;
            this.chkDSPKeyerSidetone.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkDSPKeyerSidetone.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkDSPKeyerSidetone.Image = null;
            this.chkDSPKeyerSidetone.Location = new System.Drawing.Point(16, 48);
            this.chkDSPKeyerSidetone.Name = "chkDSPKeyerSidetone";
            this.chkDSPKeyerSidetone.Size = new System.Drawing.Size(113, 16);
            this.chkDSPKeyerSidetone.TabIndex = 37;
            this.chkDSPKeyerSidetone.Text = "Sidetone";
            this.toolTip1.SetToolTip(this.chkDSPKeyerSidetone, "Turns the sidetone in the speakers on/off");
            this.chkDSPKeyerSidetone.CheckedChanged += new System.EventHandler(this.chkDSPKeyerSidetone_CheckedChanged);
            // 
            // chkCWKeyerIambic
            // 
            this.chkCWKeyerIambic.Checked = true;
            this.chkCWKeyerIambic.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkCWKeyerIambic.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkCWKeyerIambic.Image = null;
            this.chkCWKeyerIambic.Location = new System.Drawing.Point(16, 24);
            this.chkCWKeyerIambic.Name = "chkCWKeyerIambic";
            this.chkCWKeyerIambic.Size = new System.Drawing.Size(113, 16);
            this.chkCWKeyerIambic.TabIndex = 36;
            this.chkCWKeyerIambic.Text = "Iambic";
            this.toolTip1.SetToolTip(this.chkCWKeyerIambic, "Iambic or Straight Key?");
            this.chkCWKeyerIambic.CheckedChanged += new System.EventHandler(this.chkCWKeyerIambic_CheckedChanged);
            // 
            // chkCWAutoSwitchMode
            // 
            this.chkCWAutoSwitchMode.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkCWAutoSwitchMode.Image = null;
            this.chkCWAutoSwitchMode.Location = new System.Drawing.Point(16, 168);
            this.chkCWAutoSwitchMode.Name = "chkCWAutoSwitchMode";
            this.chkCWAutoSwitchMode.Size = new System.Drawing.Size(113, 16);
            this.chkCWAutoSwitchMode.TabIndex = 41;
            this.chkCWAutoSwitchMode.Text = "Auto Mode Swch";
            this.toolTip1.SetToolTip(this.chkCWAutoSwitchMode, "If enabled, will automatically switch to CW mode when paddles are used no matter " +
        "the current mode ");
            this.chkCWAutoSwitchMode.CheckedChanged += new System.EventHandler(this.chkCWAutoSwitchMode_CheckedChanged);
            // 
            // grpDSPKeyerSignalShaping
            // 
            this.grpDSPKeyerSignalShaping.Controls.Add(this.udCWKeyerWeight);
            this.grpDSPKeyerSignalShaping.Controls.Add(this.lblCWWeight);
            this.grpDSPKeyerSignalShaping.Controls.Add(this.udCWKeyerRamp);
            this.grpDSPKeyerSignalShaping.Controls.Add(this.lblCWRamp);
            this.grpDSPKeyerSignalShaping.Location = new System.Drawing.Point(444, 8);
            this.grpDSPKeyerSignalShaping.Name = "grpDSPKeyerSignalShaping";
            this.grpDSPKeyerSignalShaping.Size = new System.Drawing.Size(124, 128);
            this.grpDSPKeyerSignalShaping.TabIndex = 34;
            this.grpDSPKeyerSignalShaping.TabStop = false;
            this.grpDSPKeyerSignalShaping.Text = "Signal Shaping";
            // 
            // udCWKeyerWeight
            // 
            this.udCWKeyerWeight.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udCWKeyerWeight.Location = new System.Drawing.Point(80, 24);
            this.udCWKeyerWeight.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udCWKeyerWeight.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udCWKeyerWeight.Name = "udCWKeyerWeight";
            this.udCWKeyerWeight.Size = new System.Drawing.Size(40, 20);
            this.udCWKeyerWeight.TabIndex = 40;
            this.toolTip1.SetToolTip(this.udCWKeyerWeight, "Sets the weight of the tones when sending Iambic.");
            this.udCWKeyerWeight.Value = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udCWKeyerWeight.ValueChanged += new System.EventHandler(this.udCWKeyerWeight_ValueChanged);
            this.udCWKeyerWeight.LostFocus += new System.EventHandler(this.udCWKeyerWeight_LostFocus);
            // 
            // lblCWWeight
            // 
            this.lblCWWeight.Image = null;
            this.lblCWWeight.Location = new System.Drawing.Point(16, 24);
            this.lblCWWeight.Name = "lblCWWeight";
            this.lblCWWeight.Size = new System.Drawing.Size(48, 16);
            this.lblCWWeight.TabIndex = 39;
            this.lblCWWeight.Text = "Weight:";
            // 
            // udCWKeyerRamp
            // 
            this.udCWKeyerRamp.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udCWKeyerRamp.Location = new System.Drawing.Point(80, 48);
            this.udCWKeyerRamp.Maximum = new decimal(new int[] {
            25,
            0,
            0,
            0});
            this.udCWKeyerRamp.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udCWKeyerRamp.Name = "udCWKeyerRamp";
            this.udCWKeyerRamp.Size = new System.Drawing.Size(40, 20);
            this.udCWKeyerRamp.TabIndex = 40;
            this.toolTip1.SetToolTip(this.udCWKeyerRamp, "The width of the ramp on the leading and trailing edge of the tone.");
            this.udCWKeyerRamp.Value = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.udCWKeyerRamp.ValueChanged += new System.EventHandler(this.udCWKeyerRamp_ValueChanged);
            this.udCWKeyerRamp.LostFocus += new System.EventHandler(this.udCWKeyerRamp_LostFocus);
            // 
            // lblCWRamp
            // 
            this.lblCWRamp.Image = null;
            this.lblCWRamp.Location = new System.Drawing.Point(16, 48);
            this.lblCWRamp.Name = "lblCWRamp";
            this.lblCWRamp.Size = new System.Drawing.Size(64, 16);
            this.lblCWRamp.TabIndex = 39;
            this.lblCWRamp.Text = "Ramp (ms):";
            // 
            // grpDSPKeyerSemiBreakIn
            // 
            this.grpDSPKeyerSemiBreakIn.Controls.Add(this.chkCWBreakInEnabled);
            this.grpDSPKeyerSemiBreakIn.Controls.Add(this.lblCWBreakInDelay);
            this.grpDSPKeyerSemiBreakIn.Controls.Add(this.udCWBreakInDelay);
            this.grpDSPKeyerSemiBreakIn.Location = new System.Drawing.Point(8, 144);
            this.grpDSPKeyerSemiBreakIn.Name = "grpDSPKeyerSemiBreakIn";
            this.grpDSPKeyerSemiBreakIn.Size = new System.Drawing.Size(136, 88);
            this.grpDSPKeyerSemiBreakIn.TabIndex = 38;
            this.grpDSPKeyerSemiBreakIn.TabStop = false;
            this.grpDSPKeyerSemiBreakIn.Text = "Break In";
            // 
            // chkCWBreakInEnabled
            // 
            this.chkCWBreakInEnabled.Checked = true;
            this.chkCWBreakInEnabled.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkCWBreakInEnabled.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkCWBreakInEnabled.Image = null;
            this.chkCWBreakInEnabled.Location = new System.Drawing.Point(16, 24);
            this.chkCWBreakInEnabled.Name = "chkCWBreakInEnabled";
            this.chkCWBreakInEnabled.Size = new System.Drawing.Size(80, 16);
            this.chkCWBreakInEnabled.TabIndex = 36;
            this.chkCWBreakInEnabled.Text = "Enabled";
            this.toolTip1.SetToolTip(this.chkCWBreakInEnabled, "Enables Semi Break In operation.");
            this.chkCWBreakInEnabled.CheckedChanged += new System.EventHandler(this.chkDSPKeyerSemiBreakInEnabled_CheckedChanged);
            // 
            // lblCWBreakInDelay
            // 
            this.lblCWBreakInDelay.Image = null;
            this.lblCWBreakInDelay.Location = new System.Drawing.Point(8, 48);
            this.lblCWBreakInDelay.Name = "lblCWBreakInDelay";
            this.lblCWBreakInDelay.Size = new System.Drawing.Size(64, 16);
            this.lblCWBreakInDelay.TabIndex = 34;
            this.lblCWBreakInDelay.Text = "Delay (ms):";
            // 
            // udCWBreakInDelay
            // 
            this.udCWBreakInDelay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udCWBreakInDelay.Location = new System.Drawing.Point(72, 48);
            this.udCWBreakInDelay.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udCWBreakInDelay.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udCWBreakInDelay.Name = "udCWBreakInDelay";
            this.udCWBreakInDelay.Size = new System.Drawing.Size(48, 20);
            this.udCWBreakInDelay.TabIndex = 35;
            this.toolTip1.SetToolTip(this.udCWBreakInDelay, "Amount of time to stay in TX after the last detected CW signal.");
            this.udCWBreakInDelay.Value = new decimal(new int[] {
            300,
            0,
            0,
            0});
            this.udCWBreakInDelay.ValueChanged += new System.EventHandler(this.udCWKeyerSemiBreakInDelay_ValueChanged);
            this.udCWBreakInDelay.LostFocus += new System.EventHandler(this.udCWBreakInDelay_LostFocus);
            // 
            // tpDSPAGCALC
            // 
            this.tpDSPAGCALC.Controls.Add(this.grpDSPLeveler);
            this.tpDSPAGCALC.Controls.Add(this.grpDSPALC);
            this.tpDSPAGCALC.Controls.Add(this.grpDSPAGC);
            this.tpDSPAGCALC.Location = new System.Drawing.Point(4, 22);
            this.tpDSPAGCALC.Name = "tpDSPAGCALC";
            this.tpDSPAGCALC.Size = new System.Drawing.Size(600, 318);
            this.tpDSPAGCALC.TabIndex = 3;
            this.tpDSPAGCALC.Text = "AGC/ALC";
            // 
            // grpDSPLeveler
            // 
            this.grpDSPLeveler.Controls.Add(this.chkDSPLevelerEnabled);
            this.grpDSPLeveler.Controls.Add(this.lblDSPLevelerHangThreshold);
            this.grpDSPLeveler.Controls.Add(this.udDSPLevelerHangTime);
            this.grpDSPLeveler.Controls.Add(this.lblDSPLevelerHangTime);
            this.grpDSPLeveler.Controls.Add(this.udDSPLevelerThreshold);
            this.grpDSPLeveler.Controls.Add(this.udDSPLevelerSlope);
            this.grpDSPLeveler.Controls.Add(this.udDSPLevelerDecay);
            this.grpDSPLeveler.Controls.Add(this.lblDSPLevelerSlope);
            this.grpDSPLeveler.Controls.Add(this.udDSPLevelerAttack);
            this.grpDSPLeveler.Controls.Add(this.lblDSPLevelerDecay);
            this.grpDSPLeveler.Controls.Add(this.lblDSPLevelerAttack);
            this.grpDSPLeveler.Controls.Add(this.lblDSPLevelerThreshold);
            this.grpDSPLeveler.Controls.Add(this.tbDSPLevelerHangThreshold);
            this.grpDSPLeveler.Location = new System.Drawing.Point(264, 8);
            this.grpDSPLeveler.Name = "grpDSPLeveler";
            this.grpDSPLeveler.Size = new System.Drawing.Size(144, 216);
            this.grpDSPLeveler.TabIndex = 39;
            this.grpDSPLeveler.TabStop = false;
            this.grpDSPLeveler.Text = "Leveler (Stage 4)";
            this.toolTip1.SetToolTip(this.grpDSPLeveler, resources.GetString("grpDSPLeveler.ToolTip"));
            // 
            // chkDSPLevelerEnabled
            // 
            this.chkDSPLevelerEnabled.Checked = true;
            this.chkDSPLevelerEnabled.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkDSPLevelerEnabled.Image = null;
            this.chkDSPLevelerEnabled.Location = new System.Drawing.Point(16, 24);
            this.chkDSPLevelerEnabled.Name = "chkDSPLevelerEnabled";
            this.chkDSPLevelerEnabled.Size = new System.Drawing.Size(104, 16);
            this.chkDSPLevelerEnabled.TabIndex = 42;
            this.chkDSPLevelerEnabled.Text = "Enabled";
            this.toolTip1.SetToolTip(this.chkDSPLevelerEnabled, resources.GetString("chkDSPLevelerEnabled.ToolTip"));
            this.chkDSPLevelerEnabled.CheckedChanged += new System.EventHandler(this.chkDSPLevelerEnabled_CheckedChanged);
            // 
            // lblDSPLevelerHangThreshold
            // 
            this.lblDSPLevelerHangThreshold.Image = null;
            this.lblDSPLevelerHangThreshold.Location = new System.Drawing.Point(8, 168);
            this.lblDSPLevelerHangThreshold.Name = "lblDSPLevelerHangThreshold";
            this.lblDSPLevelerHangThreshold.Size = new System.Drawing.Size(88, 16);
            this.lblDSPLevelerHangThreshold.TabIndex = 41;
            this.lblDSPLevelerHangThreshold.Text = "Hang Threshold:";
            this.lblDSPLevelerHangThreshold.Visible = false;
            // 
            // udDSPLevelerHangTime
            // 
            this.udDSPLevelerHangTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPLevelerHangTime.Location = new System.Drawing.Point(88, 144);
            this.udDSPLevelerHangTime.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udDSPLevelerHangTime.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPLevelerHangTime.Name = "udDSPLevelerHangTime";
            this.udDSPLevelerHangTime.Size = new System.Drawing.Size(48, 20);
            this.udDSPLevelerHangTime.TabIndex = 15;
            this.udDSPLevelerHangTime.Value = new decimal(new int[] {
            170,
            0,
            0,
            0});
            this.udDSPLevelerHangTime.ValueChanged += new System.EventHandler(this.udDSPLevelerHangTime_ValueChanged);
            this.udDSPLevelerHangTime.LostFocus += new System.EventHandler(this.udDSPLevelerHangTime_LostFocus);
            // 
            // lblDSPLevelerHangTime
            // 
            this.lblDSPLevelerHangTime.Image = null;
            this.lblDSPLevelerHangTime.Location = new System.Drawing.Point(8, 144);
            this.lblDSPLevelerHangTime.Name = "lblDSPLevelerHangTime";
            this.lblDSPLevelerHangTime.Size = new System.Drawing.Size(72, 16);
            this.lblDSPLevelerHangTime.TabIndex = 14;
            this.lblDSPLevelerHangTime.Text = "Hang (ms):";
            // 
            // udDSPLevelerThreshold
            // 
            this.udDSPLevelerThreshold.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPLevelerThreshold.Location = new System.Drawing.Point(88, 72);
            this.udDSPLevelerThreshold.Maximum = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udDSPLevelerThreshold.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPLevelerThreshold.Name = "udDSPLevelerThreshold";
            this.udDSPLevelerThreshold.Size = new System.Drawing.Size(40, 20);
            this.udDSPLevelerThreshold.TabIndex = 6;
            this.toolTip1.SetToolTip(this.udDSPLevelerThreshold, "This provides for a threshold AGC.  Irrespective of how weak a signal is, no ga" +
        "in over this Max Gain is applied.");
            this.udDSPLevelerThreshold.Value = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.udDSPLevelerThreshold.ValueChanged += new System.EventHandler(this.udDSPLevelerThreshold_ValueChanged);
            this.udDSPLevelerThreshold.LostFocus += new System.EventHandler(this.udDSPLevelerThreshold_LostFocus);
            // 
            // udDSPLevelerSlope
            // 
            this.udDSPLevelerSlope.Enabled = false;
            this.udDSPLevelerSlope.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPLevelerSlope.Location = new System.Drawing.Point(88, 48);
            this.udDSPLevelerSlope.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udDSPLevelerSlope.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPLevelerSlope.Name = "udDSPLevelerSlope";
            this.udDSPLevelerSlope.Size = new System.Drawing.Size(40, 20);
            this.udDSPLevelerSlope.TabIndex = 13;
            this.udDSPLevelerSlope.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPLevelerSlope.Visible = false;
            this.udDSPLevelerSlope.LostFocus += new System.EventHandler(this.udDSPLevelerSlope_LostFocus);
            // 
            // udDSPLevelerDecay
            // 
            this.udDSPLevelerDecay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPLevelerDecay.Location = new System.Drawing.Point(88, 120);
            this.udDSPLevelerDecay.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udDSPLevelerDecay.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPLevelerDecay.Name = "udDSPLevelerDecay";
            this.udDSPLevelerDecay.Size = new System.Drawing.Size(48, 20);
            this.udDSPLevelerDecay.TabIndex = 12;
            this.udDSPLevelerDecay.Value = new decimal(new int[] {
            125,
            0,
            0,
            0});
            this.udDSPLevelerDecay.ValueChanged += new System.EventHandler(this.udDSPLevelerDecay_ValueChanged);
            this.udDSPLevelerDecay.LostFocus += new System.EventHandler(this.udDSPLevelerDecay_LostFocus);
            // 
            // lblDSPLevelerSlope
            // 
            this.lblDSPLevelerSlope.Enabled = false;
            this.lblDSPLevelerSlope.Image = null;
            this.lblDSPLevelerSlope.Location = new System.Drawing.Point(8, 48);
            this.lblDSPLevelerSlope.Name = "lblDSPLevelerSlope";
            this.lblDSPLevelerSlope.Size = new System.Drawing.Size(64, 16);
            this.lblDSPLevelerSlope.TabIndex = 11;
            this.lblDSPLevelerSlope.Text = "Slope (dB):";
            this.lblDSPLevelerSlope.Visible = false;
            // 
            // udDSPLevelerAttack
            // 
            this.udDSPLevelerAttack.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPLevelerAttack.Location = new System.Drawing.Point(88, 96);
            this.udDSPLevelerAttack.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPLevelerAttack.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPLevelerAttack.Name = "udDSPLevelerAttack";
            this.udDSPLevelerAttack.Size = new System.Drawing.Size(40, 20);
            this.udDSPLevelerAttack.TabIndex = 10;
            this.udDSPLevelerAttack.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPLevelerAttack.ValueChanged += new System.EventHandler(this.udDSPLevelerAttack_ValueChanged);
            this.udDSPLevelerAttack.LostFocus += new System.EventHandler(this.udDSPLevelerAttack_LostFocus);
            // 
            // lblDSPLevelerDecay
            // 
            this.lblDSPLevelerDecay.Image = null;
            this.lblDSPLevelerDecay.Location = new System.Drawing.Point(8, 120);
            this.lblDSPLevelerDecay.Name = "lblDSPLevelerDecay";
            this.lblDSPLevelerDecay.Size = new System.Drawing.Size(72, 16);
            this.lblDSPLevelerDecay.TabIndex = 9;
            this.lblDSPLevelerDecay.Text = "Decay (ms):";
            // 
            // lblDSPLevelerAttack
            // 
            this.lblDSPLevelerAttack.Image = null;
            this.lblDSPLevelerAttack.Location = new System.Drawing.Point(8, 96);
            this.lblDSPLevelerAttack.Name = "lblDSPLevelerAttack";
            this.lblDSPLevelerAttack.Size = new System.Drawing.Size(64, 16);
            this.lblDSPLevelerAttack.TabIndex = 8;
            this.lblDSPLevelerAttack.Text = "Attack (ms):";
            // 
            // lblDSPLevelerThreshold
            // 
            this.lblDSPLevelerThreshold.Image = null;
            this.lblDSPLevelerThreshold.Location = new System.Drawing.Point(8, 72);
            this.lblDSPLevelerThreshold.Name = "lblDSPLevelerThreshold";
            this.lblDSPLevelerThreshold.Size = new System.Drawing.Size(88, 24);
            this.lblDSPLevelerThreshold.TabIndex = 7;
            this.lblDSPLevelerThreshold.Text = "Max.Gain (dB):";
            // 
            // tbDSPLevelerHangThreshold
            // 
            this.tbDSPLevelerHangThreshold.AutoSize = false;
            this.tbDSPLevelerHangThreshold.Enabled = false;
            this.tbDSPLevelerHangThreshold.LargeChange = 1;
            this.tbDSPLevelerHangThreshold.Location = new System.Drawing.Point(8, 184);
            this.tbDSPLevelerHangThreshold.Maximum = 100;
            this.tbDSPLevelerHangThreshold.Name = "tbDSPLevelerHangThreshold";
            this.tbDSPLevelerHangThreshold.Size = new System.Drawing.Size(128, 16);
            this.tbDSPLevelerHangThreshold.TabIndex = 40;
            this.tbDSPLevelerHangThreshold.TickFrequency = 10;
            this.tbDSPLevelerHangThreshold.Visible = false;
            // 
            // grpDSPALC
            // 
            this.grpDSPALC.Controls.Add(this.lblDSPALCHangThreshold);
            this.grpDSPALC.Controls.Add(this.tbDSPALCHangThreshold);
            this.grpDSPALC.Controls.Add(this.udDSPALCHangTime);
            this.grpDSPALC.Controls.Add(this.lblDSPALCHangTime);
            this.grpDSPALC.Controls.Add(this.udDSPALCThreshold);
            this.grpDSPALC.Controls.Add(this.udDSPALCSlope);
            this.grpDSPALC.Controls.Add(this.udDSPALCDecay);
            this.grpDSPALC.Controls.Add(this.lblDSPALCSlope);
            this.grpDSPALC.Controls.Add(this.udDSPALCAttack);
            this.grpDSPALC.Controls.Add(this.lblDSPALCDecay);
            this.grpDSPALC.Controls.Add(this.lblDSPALCAttack);
            this.grpDSPALC.Controls.Add(this.lblDSPALCThreshold);
            this.grpDSPALC.Location = new System.Drawing.Point(416, 8);
            this.grpDSPALC.Name = "grpDSPALC";
            this.grpDSPALC.Size = new System.Drawing.Size(144, 192);
            this.grpDSPALC.TabIndex = 38;
            this.grpDSPALC.TabStop = false;
            this.grpDSPALC.Text = "ALC (Stage 5: Final)";
            this.toolTip1.SetToolTip(this.grpDSPALC, resources.GetString("grpDSPALC.ToolTip"));
            // 
            // lblDSPALCHangThreshold
            // 
            this.lblDSPALCHangThreshold.Image = null;
            this.lblDSPALCHangThreshold.Location = new System.Drawing.Point(8, 144);
            this.lblDSPALCHangThreshold.Name = "lblDSPALCHangThreshold";
            this.lblDSPALCHangThreshold.Size = new System.Drawing.Size(88, 16);
            this.lblDSPALCHangThreshold.TabIndex = 43;
            this.lblDSPALCHangThreshold.Text = "Hang Threshold:";
            this.lblDSPALCHangThreshold.Visible = false;
            // 
            // tbDSPALCHangThreshold
            // 
            this.tbDSPALCHangThreshold.AutoSize = false;
            this.tbDSPALCHangThreshold.Enabled = false;
            this.tbDSPALCHangThreshold.LargeChange = 1;
            this.tbDSPALCHangThreshold.Location = new System.Drawing.Point(8, 160);
            this.tbDSPALCHangThreshold.Maximum = 100;
            this.tbDSPALCHangThreshold.Name = "tbDSPALCHangThreshold";
            this.tbDSPALCHangThreshold.Size = new System.Drawing.Size(128, 16);
            this.tbDSPALCHangThreshold.TabIndex = 42;
            this.tbDSPALCHangThreshold.TickFrequency = 10;
            this.tbDSPALCHangThreshold.Visible = false;
            // 
            // udDSPALCHangTime
            // 
            this.udDSPALCHangTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPALCHangTime.Location = new System.Drawing.Point(88, 120);
            this.udDSPALCHangTime.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udDSPALCHangTime.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPALCHangTime.Name = "udDSPALCHangTime";
            this.udDSPALCHangTime.Size = new System.Drawing.Size(48, 20);
            this.udDSPALCHangTime.TabIndex = 17;
            this.udDSPALCHangTime.Value = new decimal(new int[] {
            170,
            0,
            0,
            0});
            this.udDSPALCHangTime.ValueChanged += new System.EventHandler(this.udDSPALCHangTime_ValueChanged);
            this.udDSPALCHangTime.LostFocus += new System.EventHandler(this.udDSPALCHangTime_LostFocus);
            // 
            // lblDSPALCHangTime
            // 
            this.lblDSPALCHangTime.Image = null;
            this.lblDSPALCHangTime.Location = new System.Drawing.Point(8, 120);
            this.lblDSPALCHangTime.Name = "lblDSPALCHangTime";
            this.lblDSPALCHangTime.Size = new System.Drawing.Size(72, 16);
            this.lblDSPALCHangTime.TabIndex = 16;
            this.lblDSPALCHangTime.Text = "Hang (ms):";
            // 
            // udDSPALCThreshold
            // 
            this.udDSPALCThreshold.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPALCThreshold.Location = new System.Drawing.Point(88, 48);
            this.udDSPALCThreshold.Maximum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPALCThreshold.Minimum = new decimal(new int[] {
            120,
            0,
            0,
            -2147483648});
            this.udDSPALCThreshold.Name = "udDSPALCThreshold";
            this.udDSPALCThreshold.Size = new System.Drawing.Size(48, 20);
            this.udDSPALCThreshold.TabIndex = 6;
            this.toolTip1.SetToolTip(this.udDSPALCThreshold, "This provides for a threshold AGC.  Irrespective of how weak a signal is, no ga" +
        "in over this Max Gain is applied.");
            this.udDSPALCThreshold.Value = new decimal(new int[] {
            120,
            0,
            0,
            -2147483648});
            this.udDSPALCThreshold.Visible = false;
            this.udDSPALCThreshold.ValueChanged += new System.EventHandler(this.udDSPALCThreshold_ValueChanged);
            this.udDSPALCThreshold.LostFocus += new System.EventHandler(this.udDSPALCThreshold_LostFocus);
            // 
            // udDSPALCSlope
            // 
            this.udDSPALCSlope.Enabled = false;
            this.udDSPALCSlope.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPALCSlope.Location = new System.Drawing.Point(88, 24);
            this.udDSPALCSlope.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udDSPALCSlope.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPALCSlope.Name = "udDSPALCSlope";
            this.udDSPALCSlope.Size = new System.Drawing.Size(40, 20);
            this.udDSPALCSlope.TabIndex = 13;
            this.udDSPALCSlope.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPALCSlope.Visible = false;
            this.udDSPALCSlope.LostFocus += new System.EventHandler(this.udDSPALCSlope_LostFocus);
            // 
            // udDSPALCDecay
            // 
            this.udDSPALCDecay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPALCDecay.Location = new System.Drawing.Point(88, 96);
            this.udDSPALCDecay.Maximum = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udDSPALCDecay.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPALCDecay.Name = "udDSPALCDecay";
            this.udDSPALCDecay.Size = new System.Drawing.Size(48, 20);
            this.udDSPALCDecay.TabIndex = 12;
            this.udDSPALCDecay.Value = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udDSPALCDecay.ValueChanged += new System.EventHandler(this.udDSPALCDecay_ValueChanged);
            this.udDSPALCDecay.LostFocus += new System.EventHandler(this.udDSPALCDecay_LostFocus);
            // 
            // lblDSPALCSlope
            // 
            this.lblDSPALCSlope.Image = null;
            this.lblDSPALCSlope.Location = new System.Drawing.Point(8, 24);
            this.lblDSPALCSlope.Name = "lblDSPALCSlope";
            this.lblDSPALCSlope.Size = new System.Drawing.Size(64, 16);
            this.lblDSPALCSlope.TabIndex = 11;
            this.lblDSPALCSlope.Text = "Slope (dB):";
            this.lblDSPALCSlope.Visible = false;
            // 
            // udDSPALCAttack
            // 
            this.udDSPALCAttack.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPALCAttack.Location = new System.Drawing.Point(88, 72);
            this.udDSPALCAttack.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPALCAttack.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPALCAttack.Name = "udDSPALCAttack";
            this.udDSPALCAttack.Size = new System.Drawing.Size(40, 20);
            this.udDSPALCAttack.TabIndex = 10;
            this.udDSPALCAttack.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPALCAttack.ValueChanged += new System.EventHandler(this.udDSPALCAttack_ValueChanged);
            this.udDSPALCAttack.LostFocus += new System.EventHandler(this.udDSPALCAttack_LostFocus);
            // 
            // lblDSPALCDecay
            // 
            this.lblDSPALCDecay.Image = null;
            this.lblDSPALCDecay.Location = new System.Drawing.Point(8, 96);
            this.lblDSPALCDecay.Name = "lblDSPALCDecay";
            this.lblDSPALCDecay.Size = new System.Drawing.Size(72, 16);
            this.lblDSPALCDecay.TabIndex = 9;
            this.lblDSPALCDecay.Text = "Decay (ms):";
            // 
            // lblDSPALCAttack
            // 
            this.lblDSPALCAttack.Image = null;
            this.lblDSPALCAttack.Location = new System.Drawing.Point(8, 72);
            this.lblDSPALCAttack.Name = "lblDSPALCAttack";
            this.lblDSPALCAttack.Size = new System.Drawing.Size(64, 16);
            this.lblDSPALCAttack.TabIndex = 8;
            this.lblDSPALCAttack.Text = "Attack (ms):";
            // 
            // lblDSPALCThreshold
            // 
            this.lblDSPALCThreshold.Image = null;
            this.lblDSPALCThreshold.Location = new System.Drawing.Point(8, 48);
            this.lblDSPALCThreshold.Name = "lblDSPALCThreshold";
            this.lblDSPALCThreshold.Size = new System.Drawing.Size(88, 24);
            this.lblDSPALCThreshold.TabIndex = 7;
            this.lblDSPALCThreshold.Text = "Neg. Gain (dB):";
            this.lblDSPALCThreshold.Visible = false;
            // 
            // grpDSPAGC
            // 
            this.grpDSPAGC.Controls.Add(this.tbDSPAGCHangThreshold);
            this.grpDSPAGC.Controls.Add(this.lblDSPAGCHangThreshold);
            this.grpDSPAGC.Controls.Add(this.lblDSPAGCHangTime);
            this.grpDSPAGC.Controls.Add(this.udDSPAGCHangTime);
            this.grpDSPAGC.Controls.Add(this.udDSPAGCMaxGaindB);
            this.grpDSPAGC.Controls.Add(this.udDSPAGCSlope);
            this.grpDSPAGC.Controls.Add(this.udDSPAGCDecay);
            this.grpDSPAGC.Controls.Add(this.lblDSPAGCSlope);
            this.grpDSPAGC.Controls.Add(this.udDSPAGCAttack);
            this.grpDSPAGC.Controls.Add(this.lblDSPAGCDecay);
            this.grpDSPAGC.Controls.Add(this.lblDSPAGCAttack);
            this.grpDSPAGC.Controls.Add(this.lblDSPAGCMaxGain);
            this.grpDSPAGC.Controls.Add(this.udDSPAGCFixedGaindB);
            this.grpDSPAGC.Controls.Add(this.lblDSPAGCFixed);
            this.grpDSPAGC.Location = new System.Drawing.Point(8, 8);
            this.grpDSPAGC.Name = "grpDSPAGC";
            this.grpDSPAGC.Size = new System.Drawing.Size(168, 232);
            this.grpDSPAGC.TabIndex = 31;
            this.grpDSPAGC.TabStop = false;
            this.grpDSPAGC.Text = "AGC";
            this.toolTip1.SetToolTip(this.grpDSPAGC, resources.GetString("grpDSPAGC.ToolTip"));
            // 
            // tbDSPAGCHangThreshold
            // 
            this.tbDSPAGCHangThreshold.AutoSize = false;
            this.tbDSPAGCHangThreshold.LargeChange = 1;
            this.tbDSPAGCHangThreshold.Location = new System.Drawing.Point(8, 168);
            this.tbDSPAGCHangThreshold.Maximum = 100;
            this.tbDSPAGCHangThreshold.Name = "tbDSPAGCHangThreshold";
            this.tbDSPAGCHangThreshold.Size = new System.Drawing.Size(144, 16);
            this.tbDSPAGCHangThreshold.TabIndex = 47;
            this.tbDSPAGCHangThreshold.TickFrequency = 10;
            this.tbDSPAGCHangThreshold.Scroll += new System.EventHandler(this.tbDSPAGCHangThreshold_Scroll);
            // 
            // lblDSPAGCHangThreshold
            // 
            this.lblDSPAGCHangThreshold.Image = null;
            this.lblDSPAGCHangThreshold.Location = new System.Drawing.Point(8, 144);
            this.lblDSPAGCHangThreshold.Name = "lblDSPAGCHangThreshold";
            this.lblDSPAGCHangThreshold.Size = new System.Drawing.Size(88, 16);
            this.lblDSPAGCHangThreshold.TabIndex = 46;
            this.lblDSPAGCHangThreshold.Text = "Hang Threshold:";
            // 
            // lblDSPAGCHangTime
            // 
            this.lblDSPAGCHangTime.Image = null;
            this.lblDSPAGCHangTime.Location = new System.Drawing.Point(8, 120);
            this.lblDSPAGCHangTime.Name = "lblDSPAGCHangTime";
            this.lblDSPAGCHangTime.Size = new System.Drawing.Size(72, 16);
            this.lblDSPAGCHangTime.TabIndex = 45;
            this.lblDSPAGCHangTime.Text = "Hang (ms):";
            // 
            // udDSPAGCHangTime
            // 
            this.udDSPAGCHangTime.Enabled = false;
            this.udDSPAGCHangTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPAGCHangTime.Location = new System.Drawing.Point(104, 120);
            this.udDSPAGCHangTime.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udDSPAGCHangTime.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPAGCHangTime.Name = "udDSPAGCHangTime";
            this.udDSPAGCHangTime.Size = new System.Drawing.Size(48, 20);
            this.udDSPAGCHangTime.TabIndex = 44;
            this.toolTip1.SetToolTip(this.udDSPAGCHangTime, "10 - 5000. Used only in Custom");
            this.udDSPAGCHangTime.Value = new decimal(new int[] {
            250,
            0,
            0,
            0});
            this.udDSPAGCHangTime.ValueChanged += new System.EventHandler(this.udDSPAGCHangTime_ValueChanged);
            this.udDSPAGCHangTime.LostFocus += new System.EventHandler(this.udDSPAGCHangTime_LostFocus);
            // 
            // udDSPAGCMaxGaindB
            // 
            this.udDSPAGCMaxGaindB.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPAGCMaxGaindB.Location = new System.Drawing.Point(104, 48);
            this.udDSPAGCMaxGaindB.Maximum = new decimal(new int[] {
            120,
            0,
            0,
            0});
            this.udDSPAGCMaxGaindB.Minimum = new decimal(new int[] {
            20,
            0,
            0,
            -2147483648});
            this.udDSPAGCMaxGaindB.Name = "udDSPAGCMaxGaindB";
            this.udDSPAGCMaxGaindB.Size = new System.Drawing.Size(40, 20);
            this.udDSPAGCMaxGaindB.TabIndex = 6;
            this.toolTip1.SetToolTip(this.udDSPAGCMaxGaindB, resources.GetString("udDSPAGCMaxGaindB.ToolTip"));
            this.udDSPAGCMaxGaindB.Value = new decimal(new int[] {
            90,
            0,
            0,
            0});
            this.udDSPAGCMaxGaindB.ValueChanged += new System.EventHandler(this.udDSPAGCMaxGaindB_ValueChanged);
            this.udDSPAGCMaxGaindB.LostFocus += new System.EventHandler(this.udDSPAGCMaxGaindB_LostFocus);
            // 
            // udDSPAGCSlope
            // 
            this.udDSPAGCSlope.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPAGCSlope.Location = new System.Drawing.Point(104, 24);
            this.udDSPAGCSlope.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPAGCSlope.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPAGCSlope.Name = "udDSPAGCSlope";
            this.udDSPAGCSlope.Size = new System.Drawing.Size(40, 20);
            this.udDSPAGCSlope.TabIndex = 13;
            this.udDSPAGCSlope.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.toolTip1.SetToolTip(this.udDSPAGCSlope, "0 to 10");
            this.udDSPAGCSlope.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udDSPAGCSlope.ValueChanged += new System.EventHandler(this.udDSPAGCSlope_ValueChanged);
            this.udDSPAGCSlope.LostFocus += new System.EventHandler(this.udDSPAGCSlope_LostFocus);
            // 
            // udDSPAGCDecay
            // 
            this.udDSPAGCDecay.Enabled = false;
            this.udDSPAGCDecay.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPAGCDecay.Location = new System.Drawing.Point(104, 96);
            this.udDSPAGCDecay.Maximum = new decimal(new int[] {
            5000,
            0,
            0,
            0});
            this.udDSPAGCDecay.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPAGCDecay.Name = "udDSPAGCDecay";
            this.udDSPAGCDecay.Size = new System.Drawing.Size(48, 20);
            this.udDSPAGCDecay.TabIndex = 12;
            this.toolTip1.SetToolTip(this.udDSPAGCDecay, "10 - 5000. Used only in Custom");
            this.udDSPAGCDecay.Value = new decimal(new int[] {
            250,
            0,
            0,
            0});
            this.udDSPAGCDecay.ValueChanged += new System.EventHandler(this.udDSPAGCDecay_ValueChanged);
            this.udDSPAGCDecay.LostFocus += new System.EventHandler(this.udDSPAGCDecay_LostFocus);
            // 
            // lblDSPAGCSlope
            // 
            this.lblDSPAGCSlope.Image = null;
            this.lblDSPAGCSlope.Location = new System.Drawing.Point(8, 24);
            this.lblDSPAGCSlope.Name = "lblDSPAGCSlope";
            this.lblDSPAGCSlope.Size = new System.Drawing.Size(80, 16);
            this.lblDSPAGCSlope.TabIndex = 11;
            this.lblDSPAGCSlope.Text = "Slope (dB):";
            // 
            // udDSPAGCAttack
            // 
            this.udDSPAGCAttack.Enabled = false;
            this.udDSPAGCAttack.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPAGCAttack.Location = new System.Drawing.Point(104, 72);
            this.udDSPAGCAttack.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udDSPAGCAttack.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPAGCAttack.Name = "udDSPAGCAttack";
            this.udDSPAGCAttack.Size = new System.Drawing.Size(40, 20);
            this.udDSPAGCAttack.TabIndex = 10;
            this.toolTip1.SetToolTip(this.udDSPAGCAttack, "0 to 10 Used only in Custom");
            this.udDSPAGCAttack.Value = new decimal(new int[] {
            2,
            0,
            0,
            0});
            this.udDSPAGCAttack.ValueChanged += new System.EventHandler(this.udDSPAGCAttack_ValueChanged);
            this.udDSPAGCAttack.LostFocus += new System.EventHandler(this.udDSPAGCAttack_LostFocus);
            // 
            // lblDSPAGCDecay
            // 
            this.lblDSPAGCDecay.Image = null;
            this.lblDSPAGCDecay.Location = new System.Drawing.Point(8, 96);
            this.lblDSPAGCDecay.Name = "lblDSPAGCDecay";
            this.lblDSPAGCDecay.Size = new System.Drawing.Size(72, 16);
            this.lblDSPAGCDecay.TabIndex = 9;
            this.lblDSPAGCDecay.Text = "Decay (ms):";
            // 
            // lblDSPAGCAttack
            // 
            this.lblDSPAGCAttack.Image = null;
            this.lblDSPAGCAttack.Location = new System.Drawing.Point(8, 72);
            this.lblDSPAGCAttack.Name = "lblDSPAGCAttack";
            this.lblDSPAGCAttack.Size = new System.Drawing.Size(64, 16);
            this.lblDSPAGCAttack.TabIndex = 8;
            this.lblDSPAGCAttack.Text = "Attack (ms):";
            // 
            // lblDSPAGCMaxGain
            // 
            this.lblDSPAGCMaxGain.Image = null;
            this.lblDSPAGCMaxGain.Location = new System.Drawing.Point(8, 48);
            this.lblDSPAGCMaxGain.Name = "lblDSPAGCMaxGain";
            this.lblDSPAGCMaxGain.Size = new System.Drawing.Size(88, 24);
            this.lblDSPAGCMaxGain.TabIndex = 7;
            this.lblDSPAGCMaxGain.Text = "Max Gain (dB):";
            this.toolTip1.SetToolTip(this.lblDSPAGCMaxGain, resources.GetString("lblDSPAGCMaxGain.ToolTip"));
            // 
            // udDSPAGCFixedGaindB
            // 
            this.udDSPAGCFixedGaindB.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udDSPAGCFixedGaindB.Location = new System.Drawing.Point(104, 200);
            this.udDSPAGCFixedGaindB.Maximum = new decimal(new int[] {
            120,
            0,
            0,
            0});
            this.udDSPAGCFixedGaindB.Minimum = new decimal(new int[] {
            20,
            0,
            0,
            -2147483648});
            this.udDSPAGCFixedGaindB.Name = "udDSPAGCFixedGaindB";
            this.udDSPAGCFixedGaindB.Size = new System.Drawing.Size(40, 20);
            this.udDSPAGCFixedGaindB.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udDSPAGCFixedGaindB, "When you choose Fixed AGC on the front panel, this number is used to multiply the" +
        " signal.");
            this.udDSPAGCFixedGaindB.Value = new decimal(new int[] {
            75,
            0,
            0,
            0});
            this.udDSPAGCFixedGaindB.ValueChanged += new System.EventHandler(this.udDSPAGCFixedGaindB_ValueChanged);
            this.udDSPAGCFixedGaindB.LostFocus += new System.EventHandler(this.udDSPAGCFixedGaindB_LostFocus);
            // 
            // lblDSPAGCFixed
            // 
            this.lblDSPAGCFixed.Image = null;
            this.lblDSPAGCFixed.Location = new System.Drawing.Point(8, 200);
            this.lblDSPAGCFixed.Name = "lblDSPAGCFixed";
            this.lblDSPAGCFixed.Size = new System.Drawing.Size(88, 16);
            this.lblDSPAGCFixed.TabIndex = 5;
            this.lblDSPAGCFixed.Text = "Fixed Gain (dB):";
            // 
            // tpTransmit
            // 
            this.tpTransmit.Controls.Add(this.chkBandModeSave);
            this.tpTransmit.Controls.Add(this.chkBoxTNTX3);
            this.tpTransmit.Controls.Add(this.chkPhaseRotate);
            this.tpTransmit.Controls.Add(this.chkFMDataMic);
            this.tpTransmit.Controls.Add(this.grpTXVOX);
            this.tpTransmit.Controls.Add(this.chk2ndMeter);
            this.tpTransmit.Controls.Add(this.chkTXWtrID);
            this.tpTransmit.Controls.Add(this.chkTXMeter2);
            this.tpTransmit.Controls.Add(this.chkRememberTXProfileOnModeChange);
            this.tpTransmit.Controls.Add(this.chkAudioMicBoost);
            this.tpTransmit.Controls.Add(this.chkSaveTXProfileOnExit);
            this.tpTransmit.Controls.Add(this.chkAutoSaveTXProfile);
            this.tpTransmit.Controls.Add(this.chkTXLimitSlew);
            this.tpTransmit.Controls.Add(this.chkTXExpert);
            this.tpTransmit.Controls.Add(this.grpTXProfileDef);
            this.tpTransmit.Controls.Add(this.grpTXAM);
            this.tpTransmit.Controls.Add(this.grpTXMonitor);
            this.tpTransmit.Controls.Add(this.grpTXNoiseGate);
            this.tpTransmit.Controls.Add(this.grpTXProfile);
            this.tpTransmit.Controls.Add(this.grpPATune);
            this.tpTransmit.Controls.Add(this.grpTXFilter);
            this.tpTransmit.Controls.Add(this.chkDCBlock);
            this.tpTransmit.Controls.Add(this.grpTX1500);
            this.tpTransmit.Location = new System.Drawing.Point(4, 22);
            this.tpTransmit.Name = "tpTransmit";
            this.tpTransmit.Size = new System.Drawing.Size(584, 341);
            this.tpTransmit.TabIndex = 5;
            this.tpTransmit.Text = "Transmit";
            // 
            // chkBandModeSave
            // 
            this.chkBandModeSave.Image = null;
            this.chkBandModeSave.Location = new System.Drawing.Point(306, 284);
            this.chkBandModeSave.Name = "chkBandModeSave";
            this.chkBandModeSave.Size = new System.Drawing.Size(218, 26);
            this.chkBandModeSave.TabIndex = 68;
            this.chkBandModeSave.Text = "Save Drive per Band and per Mode";
            this.toolTip1.SetToolTip(this.chkBandModeSave, resources.GetString("chkBandModeSave.ToolTip"));
            // 
            // chkBoxTNTX3
            // 
            this.chkBoxTNTX3.Image = null;
            this.chkBoxTNTX3.Location = new System.Drawing.Point(155, 290);
            this.chkBoxTNTX3.Name = "chkBoxTNTX3";
            this.chkBoxTNTX3.Size = new System.Drawing.Size(133, 26);
            this.chkBoxTNTX3.TabIndex = 67;
            this.chkBoxTNTX3.Text = "TUN uses TX3 Jack";
            this.toolTip1.SetToolTip(this.chkBoxTNTX3, "When Checked, the TUN button activates TX3 RCA Jack.\r\nUse to trigger external Tun" +
        "er");
            this.chkBoxTNTX3.CheckedChanged += new System.EventHandler(this.chkBoxTNTX3_CheckedChanged);
            // 
            // chkPhaseRotate
            // 
            this.chkPhaseRotate.Image = null;
            this.chkPhaseRotate.Location = new System.Drawing.Point(306, 161);
            this.chkPhaseRotate.Name = "chkPhaseRotate";
            this.chkPhaseRotate.Size = new System.Drawing.Size(118, 26);
            this.chkPhaseRotate.TabIndex = 66;
            this.chkPhaseRotate.Text = "Phase Invert";
            this.toolTip1.SetToolTip(this.chkPhaseRotate, "Audio Phase Invert. Check your audio with the Panascope.");
            // 
            // chkFMDataMic
            // 
            this.chkFMDataMic.Image = null;
            this.chkFMDataMic.Location = new System.Drawing.Point(378, 82);
            this.chkFMDataMic.Name = "chkFMDataMic";
            this.chkFMDataMic.Size = new System.Drawing.Size(61, 43);
            this.chkFMDataMic.TabIndex = 65;
            this.chkFMDataMic.Text = "FM Wide MIC";
            this.toolTip1.SetToolTip(this.chkFMDataMic, "When in WFM Data mode: 17khz Dev\r\n(To get into WFM mode, Right Click on the FM bu" +
        "tton)\r\n\r\nWhen Checked, uses MIC input\r\nUnchecked, acts like DIGU or DIGL input b" +
        "ypassing MIC\r\n");
            this.chkFMDataMic.CheckedChanged += new System.EventHandler(this.chkFMDataMic_CheckedChanged);
            // 
            // grpTXVOX
            // 
            this.grpTXVOX.Controls.Add(this.lblTXVOXHangTime);
            this.grpTXVOX.Controls.Add(this.udTXVOXHangTime);
            this.grpTXVOX.Controls.Add(this.chkTXVOXEnabled);
            this.grpTXVOX.Controls.Add(this.lblTXVOXThreshold);
            this.grpTXVOX.Controls.Add(this.udTXVOXThreshold);
            this.grpTXVOX.Location = new System.Drawing.Point(8, 242);
            this.grpTXVOX.Name = "grpTXVOX";
            this.grpTXVOX.Size = new System.Drawing.Size(136, 96);
            this.grpTXVOX.TabIndex = 50;
            this.grpTXVOX.TabStop = false;
            this.grpTXVOX.Text = "VOX";
            // 
            // lblTXVOXHangTime
            // 
            this.lblTXVOXHangTime.Image = null;
            this.lblTXVOXHangTime.Location = new System.Drawing.Point(8, 72);
            this.lblTXVOXHangTime.Name = "lblTXVOXHangTime";
            this.lblTXVOXHangTime.Size = new System.Drawing.Size(64, 16);
            this.lblTXVOXHangTime.TabIndex = 52;
            this.lblTXVOXHangTime.Text = "Delay (ms):";
            // 
            // udTXVOXHangTime
            // 
            this.udTXVOXHangTime.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTXVOXHangTime.Location = new System.Drawing.Point(72, 72);
            this.udTXVOXHangTime.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this.udTXVOXHangTime.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXVOXHangTime.Name = "udTXVOXHangTime";
            this.udTXVOXHangTime.Size = new System.Drawing.Size(56, 20);
            this.udTXVOXHangTime.TabIndex = 51;
            this.toolTip1.SetToolTip(this.udTXVOXHangTime, "The amount of time in ms to stay in TX mode after the last signal above the thres" +
        "hold.");
            this.udTXVOXHangTime.Value = new decimal(new int[] {
            250,
            0,
            0,
            0});
            this.udTXVOXHangTime.ValueChanged += new System.EventHandler(this.udTXVOXHangTime_ValueChanged);
            this.udTXVOXHangTime.LostFocus += new System.EventHandler(this.udTXVOXHangTime_LostFocus);
            // 
            // chkTXVOXEnabled
            // 
            this.chkTXVOXEnabled.Image = null;
            this.chkTXVOXEnabled.Location = new System.Drawing.Point(16, 24);
            this.chkTXVOXEnabled.Name = "chkTXVOXEnabled";
            this.chkTXVOXEnabled.Size = new System.Drawing.Size(72, 16);
            this.chkTXVOXEnabled.TabIndex = 50;
            this.chkTXVOXEnabled.Text = "Enabled";
            this.toolTip1.SetToolTip(this.chkTXVOXEnabled, "Enables VOX operation using the parameters below.");
            this.chkTXVOXEnabled.CheckedChanged += new System.EventHandler(this.chkTXVOXEnabled_CheckedChanged);
            // 
            // lblTXVOXThreshold
            // 
            this.lblTXVOXThreshold.Image = null;
            this.lblTXVOXThreshold.Location = new System.Drawing.Point(8, 48);
            this.lblTXVOXThreshold.Name = "lblTXVOXThreshold";
            this.lblTXVOXThreshold.Size = new System.Drawing.Size(64, 16);
            this.lblTXVOXThreshold.TabIndex = 5;
            this.lblTXVOXThreshold.Text = "Sensitivity:";
            // 
            // udTXVOXThreshold
            // 
            this.udTXVOXThreshold.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTXVOXThreshold.Location = new System.Drawing.Point(72, 48);
            this.udTXVOXThreshold.Maximum = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udTXVOXThreshold.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXVOXThreshold.Name = "udTXVOXThreshold";
            this.udTXVOXThreshold.Size = new System.Drawing.Size(48, 20);
            this.udTXVOXThreshold.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udTXVOXThreshold, "Numeric sample value above which triggers the VOX circuit.");
            this.udTXVOXThreshold.Value = new decimal(new int[] {
            90,
            0,
            0,
            0});
            this.udTXVOXThreshold.ValueChanged += new System.EventHandler(this.udTXVOXThreshold_ValueChanged);
            this.udTXVOXThreshold.LostFocus += new System.EventHandler(this.udTXVOXThreshold_LostFocus);
            // 
            // chk2ndMeter
            // 
            this.chk2ndMeter.Image = null;
            this.chk2ndMeter.Location = new System.Drawing.Point(445, 259);
            this.chk2ndMeter.Name = "chk2ndMeter";
            this.chk2ndMeter.Size = new System.Drawing.Size(118, 26);
            this.chk2ndMeter.TabIndex = 64;
            this.chk2ndMeter.Text = "Move 2nd Meter";
            this.toolTip1.SetToolTip(this.chk2ndMeter, "Move 2nd Meter to the TOP");
            this.chk2ndMeter.CheckedChanged += new System.EventHandler(this.chk2ndMeter_CheckedChanged);
            // 
            // chkTXWtrID
            // 
            this.chkTXWtrID.Checked = true;
            this.chkTXWtrID.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkTXWtrID.Image = null;
            this.chkTXWtrID.Location = new System.Drawing.Point(155, 312);
            this.chkTXWtrID.Name = "chkTXWtrID";
            this.chkTXWtrID.Size = new System.Drawing.Size(133, 26);
            this.chkTXWtrID.TabIndex = 63;
            this.chkTXWtrID.Text = "Wider TXWaterID";
            this.toolTip1.SetToolTip(this.chkTXWtrID, "Normally TX WaterFall ID is 2.4khz wide.\r\nWhen Checked, the Width is your current" +
        " TX width");
            this.chkTXWtrID.CheckedChanged += new System.EventHandler(this.chkTXWtrID_CheckedChanged);
            // 
            // chkTXMeter2
            // 
            this.chkTXMeter2.Image = null;
            this.chkTXMeter2.Location = new System.Drawing.Point(306, 260);
            this.chkTXMeter2.Name = "chkTXMeter2";
            this.chkTXMeter2.Size = new System.Drawing.Size(133, 26);
            this.chkTXMeter2.TabIndex = 62;
            this.chkTXMeter2.Text = "TX 2nd Meter Active";
            this.toolTip1.SetToolTip(this.chkTXMeter2, "check to enable the 2nd TX meter");
            this.chkTXMeter2.CheckedChanged += new System.EventHandler(this.chkTXMeter2_CheckedChanged);
            // 
            // chkRememberTXProfileOnModeChange
            // 
            this.chkRememberTXProfileOnModeChange.Image = null;
            this.chkRememberTXProfileOnModeChange.Location = new System.Drawing.Point(306, 186);
            this.chkRememberTXProfileOnModeChange.Name = "chkRememberTXProfileOnModeChange";
            this.chkRememberTXProfileOnModeChange.Size = new System.Drawing.Size(235, 26);
            this.chkRememberTXProfileOnModeChange.TabIndex = 61;
            this.chkRememberTXProfileOnModeChange.Text = "Remember TX Profile on Mode Change";
            this.toolTip1.SetToolTip(this.chkRememberTXProfileOnModeChange, resources.GetString("chkRememberTXProfileOnModeChange.ToolTip"));
            this.chkRememberTXProfileOnModeChange.CheckedChanged += new System.EventHandler(this.chkRememberTXProfileOnModeChange_CheckedChanged);
            // 
            // chkAudioMicBoost
            // 
            this.chkAudioMicBoost.Image = null;
            this.chkAudioMicBoost.Location = new System.Drawing.Point(306, 138);
            this.chkAudioMicBoost.Name = "chkAudioMicBoost";
            this.chkAudioMicBoost.Size = new System.Drawing.Size(83, 26);
            this.chkAudioMicBoost.TabIndex = 60;
            this.chkAudioMicBoost.Text = "Mic Boost";
            this.toolTip1.SetToolTip(this.chkAudioMicBoost, "Provided extra audio gain for low output microphones (usually not needed)");
            this.chkAudioMicBoost.CheckedChanged += new System.EventHandler(this.chkAudioMicBoost_CheckedChanged);
            // 
            // chkSaveTXProfileOnExit
            // 
            this.chkSaveTXProfileOnExit.Image = null;
            this.chkSaveTXProfileOnExit.Location = new System.Drawing.Point(306, 229);
            this.chkSaveTXProfileOnExit.Name = "chkSaveTXProfileOnExit";
            this.chkSaveTXProfileOnExit.Size = new System.Drawing.Size(235, 26);
            this.chkSaveTXProfileOnExit.TabIndex = 59;
            this.chkSaveTXProfileOnExit.Text = "Auto Save TX Profile on PowerSDR close";
            this.toolTip1.SetToolTip(this.chkSaveTXProfileOnExit, "Automatically saves the current TX Profile when PowerSDR is closed");
            this.chkSaveTXProfileOnExit.CheckedChanged += new System.EventHandler(this.chkSaveTXProfileOnExit_CheckedChanged);
            // 
            // chkAutoSaveTXProfile
            // 
            this.chkAutoSaveTXProfile.Image = null;
            this.chkAutoSaveTXProfile.Location = new System.Drawing.Point(306, 210);
            this.chkAutoSaveTXProfile.Name = "chkAutoSaveTXProfile";
            this.chkAutoSaveTXProfile.Size = new System.Drawing.Size(189, 26);
            this.chkAutoSaveTXProfile.TabIndex = 58;
            this.chkAutoSaveTXProfile.Text = "Auto Save TX Profile on change";
            this.toolTip1.SetToolTip(this.chkAutoSaveTXProfile, "Automatically saves the current TX Profile if another profile is selected");
            // 
            // chkTXLimitSlew
            // 
            this.chkTXLimitSlew.Image = null;
            this.chkTXLimitSlew.Location = new System.Drawing.Point(306, 82);
            this.chkTXLimitSlew.Name = "chkTXLimitSlew";
            this.chkTXLimitSlew.Size = new System.Drawing.Size(83, 26);
            this.chkTXLimitSlew.TabIndex = 57;
            this.chkTXLimitSlew.Text = "Limit Slew";
            this.toolTip1.SetToolTip(this.chkTXLimitSlew, "Ramps key-up to avoid unkey artifacts (induces additional delay) - This is useful" +
        " to avoid tripping amplifiers");
            this.chkTXLimitSlew.CheckedChanged += new System.EventHandler(this.chkTXLimitSlew_CheckedChanged);
            // 
            // chkTXExpert
            // 
            this.chkTXExpert.Image = null;
            this.chkTXExpert.Location = new System.Drawing.Point(477, 3);
            this.chkTXExpert.Name = "chkTXExpert";
            this.chkTXExpert.Size = new System.Drawing.Size(96, 24);
            this.chkTXExpert.TabIndex = 55;
            this.chkTXExpert.Text = "More Profiles";
            this.toolTip1.SetToolTip(this.chkTXExpert, "Check to display additional default preset TX Profiles");
            this.chkTXExpert.CheckedChanged += new System.EventHandler(this.chkTXExpert_CheckedChanged);
            // 
            // grpTXProfileDef
            // 
            this.grpTXProfileDef.Controls.Add(this.btnTXProfileDefImport);
            this.grpTXProfileDef.Controls.Add(this.lstTXProfileDef);
            this.grpTXProfileDef.Location = new System.Drawing.Point(445, 28);
            this.grpTXProfileDef.Name = "grpTXProfileDef";
            this.grpTXProfileDef.Size = new System.Drawing.Size(136, 152);
            this.grpTXProfileDef.TabIndex = 54;
            this.grpTXProfileDef.TabStop = false;
            this.grpTXProfileDef.Text = "Additional TX Profiles";
            this.grpTXProfileDef.Visible = false;
            // 
            // btnTXProfileDefImport
            // 
            this.btnTXProfileDefImport.Image = null;
            this.btnTXProfileDefImport.Location = new System.Drawing.Point(32, 120);
            this.btnTXProfileDefImport.Name = "btnTXProfileDefImport";
            this.btnTXProfileDefImport.Size = new System.Drawing.Size(64, 24);
            this.btnTXProfileDefImport.TabIndex = 54;
            this.btnTXProfileDefImport.Text = "Import";
            this.toolTip1.SetToolTip(this.btnTXProfileDefImport, "Highlight an additional preset TX Profile and then click on Import to add it to y" +
        "our active profiles");
            this.btnTXProfileDefImport.Click += new System.EventHandler(this.btnTXProfileDefImport_Click);
            // 
            // lstTXProfileDef
            // 
            this.lstTXProfileDef.Location = new System.Drawing.Point(8, 16);
            this.lstTXProfileDef.Name = "lstTXProfileDef";
            this.lstTXProfileDef.Size = new System.Drawing.Size(120, 95);
            this.lstTXProfileDef.TabIndex = 53;
            // 
            // grpTXAM
            // 
            this.grpTXAM.Controls.Add(this.lblTXAMCarrierLevel);
            this.grpTXAM.Controls.Add(this.udTXAMCarrierLevel);
            this.grpTXAM.Location = new System.Drawing.Point(302, 21);
            this.grpTXAM.Name = "grpTXAM";
            this.grpTXAM.Size = new System.Drawing.Size(137, 56);
            this.grpTXAM.TabIndex = 52;
            this.grpTXAM.TabStop = false;
            this.grpTXAM.Text = "AM";
            // 
            // lblTXAMCarrierLevel
            // 
            this.lblTXAMCarrierLevel.Image = null;
            this.lblTXAMCarrierLevel.Location = new System.Drawing.Point(1, 24);
            this.lblTXAMCarrierLevel.Name = "lblTXAMCarrierLevel";
            this.lblTXAMCarrierLevel.Size = new System.Drawing.Size(72, 16);
            this.lblTXAMCarrierLevel.TabIndex = 5;
            this.lblTXAMCarrierLevel.Text = "Carrier Level:";
            // 
            // udTXAMCarrierLevel
            // 
            this.udTXAMCarrierLevel.DecimalPlaces = 1;
            this.udTXAMCarrierLevel.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udTXAMCarrierLevel.Location = new System.Drawing.Point(76, 20);
            this.udTXAMCarrierLevel.Maximum = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udTXAMCarrierLevel.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXAMCarrierLevel.Name = "udTXAMCarrierLevel";
            this.udTXAMCarrierLevel.Size = new System.Drawing.Size(56, 20);
            this.udTXAMCarrierLevel.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udTXAMCarrierLevel, resources.GetString("udTXAMCarrierLevel.ToolTip"));
            this.udTXAMCarrierLevel.Value = new decimal(new int[] {
            8,
            0,
            0,
            0});
            this.udTXAMCarrierLevel.ValueChanged += new System.EventHandler(this.udTXAMCarrierLevel_ValueChanged);
            this.udTXAMCarrierLevel.LostFocus += new System.EventHandler(this.udTXAMCarrierLevel_LostFocus);
            // 
            // grpTXMonitor
            // 
            this.grpTXMonitor.Controls.Add(this.lblTXAF);
            this.grpTXMonitor.Controls.Add(this.udTXAF);
            this.grpTXMonitor.Location = new System.Drawing.Point(152, 229);
            this.grpTXMonitor.Name = "grpTXMonitor";
            this.grpTXMonitor.Size = new System.Drawing.Size(144, 56);
            this.grpTXMonitor.TabIndex = 51;
            this.grpTXMonitor.TabStop = false;
            this.grpTXMonitor.Text = "Monitor";
            // 
            // lblTXAF
            // 
            this.lblTXAF.Image = null;
            this.lblTXAF.Location = new System.Drawing.Point(8, 24);
            this.lblTXAF.Name = "lblTXAF";
            this.lblTXAF.Size = new System.Drawing.Size(74, 16);
            this.lblTXAF.TabIndex = 5;
            this.lblTXAF.Text = "MON Vol:";
            this.toolTip1.SetToolTip(this.lblTXAF, "MON (monitor) Volume level  when in TX or QuickAudio Playback");
            // 
            // udTXAF
            // 
            this.udTXAF.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTXAF.Location = new System.Drawing.Point(88, 22);
            this.udTXAF.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTXAF.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXAF.Name = "udTXAF";
            this.udTXAF.Size = new System.Drawing.Size(48, 20);
            this.udTXAF.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udTXAF, "MON (monitor) Volume level  when in TX or QuickAudio Playback");
            this.udTXAF.Value = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udTXAF.ValueChanged += new System.EventHandler(this.udTXAF_ValueChanged);
            this.udTXAF.LostFocus += new System.EventHandler(this.udTXAF_LostFocus);
            // 
            // grpTXNoiseGate
            // 
            this.grpTXNoiseGate.Controls.Add(this.udTXNoiseGateAttenuate);
            this.grpTXNoiseGate.Controls.Add(this.lblTXNoiseGateAttenuate);
            this.grpTXNoiseGate.Controls.Add(this.chkTXNoiseGateEnabled);
            this.grpTXNoiseGate.Controls.Add(this.udTXNoiseGate);
            this.grpTXNoiseGate.Controls.Add(this.lblTXNoiseGateThreshold);
            this.grpTXNoiseGate.Location = new System.Drawing.Point(152, 121);
            this.grpTXNoiseGate.Name = "grpTXNoiseGate";
            this.grpTXNoiseGate.Size = new System.Drawing.Size(144, 102);
            this.grpTXNoiseGate.TabIndex = 49;
            this.grpTXNoiseGate.TabStop = false;
            this.grpTXNoiseGate.Text = "DE / Noise Gate";
            // 
            // udTXNoiseGateAttenuate
            // 
            this.udTXNoiseGateAttenuate.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTXNoiseGateAttenuate.Location = new System.Drawing.Point(88, 71);
            this.udTXNoiseGateAttenuate.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTXNoiseGateAttenuate.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXNoiseGateAttenuate.Name = "udTXNoiseGateAttenuate";
            this.udTXNoiseGateAttenuate.Size = new System.Drawing.Size(48, 20);
            this.udTXNoiseGateAttenuate.TabIndex = 50;
            this.toolTip1.SetToolTip(this.udTXNoiseGateAttenuate, "Percent to attenuate when below DE threshold");
            this.udTXNoiseGateAttenuate.Value = new decimal(new int[] {
            80,
            0,
            0,
            0});
            this.udTXNoiseGateAttenuate.ValueChanged += new System.EventHandler(this.udTXNoiseGateAttenuate_ValueChanged);
            // 
            // lblTXNoiseGateAttenuate
            // 
            this.lblTXNoiseGateAttenuate.Image = null;
            this.lblTXNoiseGateAttenuate.Location = new System.Drawing.Point(8, 71);
            this.lblTXNoiseGateAttenuate.Name = "lblTXNoiseGateAttenuate";
            this.lblTXNoiseGateAttenuate.Size = new System.Drawing.Size(82, 23);
            this.lblTXNoiseGateAttenuate.TabIndex = 51;
            this.lblTXNoiseGateAttenuate.Text = "Attenuate (%):";
            // 
            // chkTXNoiseGateEnabled
            // 
            this.chkTXNoiseGateEnabled.Image = null;
            this.chkTXNoiseGateEnabled.Location = new System.Drawing.Point(16, 24);
            this.chkTXNoiseGateEnabled.Name = "chkTXNoiseGateEnabled";
            this.chkTXNoiseGateEnabled.Size = new System.Drawing.Size(72, 16);
            this.chkTXNoiseGateEnabled.TabIndex = 49;
            this.chkTXNoiseGateEnabled.Text = "Enabled";
            this.toolTip1.SetToolTip(this.chkTXNoiseGateEnabled, "Enables the Downward Expander/Noise Gate to operate by setting the Threshold and " +
        "the Attenuate percentage factor");
            this.chkTXNoiseGateEnabled.CheckedChanged += new System.EventHandler(this.chkTXNoiseGateEnabled_CheckedChanged);
            // 
            // udTXNoiseGate
            // 
            this.udTXNoiseGate.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTXNoiseGate.Location = new System.Drawing.Point(88, 48);
            this.udTXNoiseGate.Maximum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXNoiseGate.Minimum = new decimal(new int[] {
            160,
            0,
            0,
            -2147483648});
            this.udTXNoiseGate.Name = "udTXNoiseGate";
            this.udTXNoiseGate.Size = new System.Drawing.Size(48, 20);
            this.udTXNoiseGate.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udTXNoiseGate, "Signal level in dB above which to transmit audio.");
            this.udTXNoiseGate.Value = new decimal(new int[] {
            40,
            0,
            0,
            -2147483648});
            this.udTXNoiseGate.ValueChanged += new System.EventHandler(this.udTXNoiseGate_ValueChanged);
            this.udTXNoiseGate.LostFocus += new System.EventHandler(this.udTXNoiseGate_LostFocus);
            // 
            // lblTXNoiseGateThreshold
            // 
            this.lblTXNoiseGateThreshold.Image = null;
            this.lblTXNoiseGateThreshold.Location = new System.Drawing.Point(8, 48);
            this.lblTXNoiseGateThreshold.Name = "lblTXNoiseGateThreshold";
            this.lblTXNoiseGateThreshold.Size = new System.Drawing.Size(82, 23);
            this.lblTXNoiseGateThreshold.TabIndex = 5;
            this.lblTXNoiseGateThreshold.Text = "Threshold (dB):";
            // 
            // grpTXProfile
            // 
            this.grpTXProfile.Controls.Add(this.btnTXProfileDelete);
            this.grpTXProfile.Controls.Add(this.btnTXProfileSave);
            this.grpTXProfile.Controls.Add(this.comboTXProfileName);
            this.grpTXProfile.Location = new System.Drawing.Point(8, 8);
            this.grpTXProfile.Name = "grpTXProfile";
            this.grpTXProfile.Size = new System.Drawing.Size(136, 80);
            this.grpTXProfile.TabIndex = 23;
            this.grpTXProfile.TabStop = false;
            this.grpTXProfile.Text = "Profiles";
            // 
            // btnTXProfileDelete
            // 
            this.btnTXProfileDelete.Image = null;
            this.btnTXProfileDelete.Location = new System.Drawing.Point(72, 48);
            this.btnTXProfileDelete.Name = "btnTXProfileDelete";
            this.btnTXProfileDelete.Size = new System.Drawing.Size(48, 21);
            this.btnTXProfileDelete.TabIndex = 2;
            this.btnTXProfileDelete.Text = "Delete";
            this.toolTip1.SetToolTip(this.btnTXProfileDelete, "Click to delete the currently selected TX Profile.");
            this.btnTXProfileDelete.Click += new System.EventHandler(this.btnTXProfileDelete_Click);
            // 
            // btnTXProfileSave
            // 
            this.btnTXProfileSave.Image = null;
            this.btnTXProfileSave.Location = new System.Drawing.Point(16, 48);
            this.btnTXProfileSave.Name = "btnTXProfileSave";
            this.btnTXProfileSave.Size = new System.Drawing.Size(48, 21);
            this.btnTXProfileSave.TabIndex = 1;
            this.btnTXProfileSave.Text = "Save";
            this.toolTip1.SetToolTip(this.btnTXProfileSave, "Click to save the current settings to a TX Profile.\r\nIncluding Mode.\r\n\r\nWill NOT " +
        "change modes if \"Remember TX Profile on Mode Change is Checked.");
            this.btnTXProfileSave.Click += new System.EventHandler(this.btnTXProfileSave_Click);
            // 
            // comboTXProfileName
            // 
            this.comboTXProfileName.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboTXProfileName.DropDownWidth = 104;
            this.comboTXProfileName.Location = new System.Drawing.Point(16, 24);
            this.comboTXProfileName.Name = "comboTXProfileName";
            this.comboTXProfileName.Size = new System.Drawing.Size(104, 21);
            this.comboTXProfileName.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboTXProfileName, resources.GetString("comboTXProfileName.ToolTip"));
            this.comboTXProfileName.SelectedIndexChanged += new System.EventHandler(this.comboTXProfileName_SelectedIndexChanged);
            // 
            // grpPATune
            // 
            this.grpPATune.Controls.Add(this.labelTS22);
            this.grpPATune.Controls.Add(this.labelTS21);
            this.grpPATune.Controls.Add(this.tbPulseRate1);
            this.grpPATune.Controls.Add(this.tbDutyCycle);
            this.grpPATune.Controls.Add(this.chkBoxPulser);
            this.grpPATune.Controls.Add(this.comboTXTUNMeter);
            this.grpPATune.Controls.Add(this.lblTXTUNMeter);
            this.grpPATune.Controls.Add(this.lblTransmitTunePower);
            this.grpPATune.Controls.Add(this.udTXTunePower);
            this.grpPATune.Location = new System.Drawing.Point(8, 90);
            this.grpPATune.Name = "grpPATune";
            this.grpPATune.Size = new System.Drawing.Size(136, 146);
            this.grpPATune.TabIndex = 22;
            this.grpPATune.TabStop = false;
            this.grpPATune.Text = "Tune";
            // 
            // labelTS22
            // 
            this.labelTS22.Image = null;
            this.labelTS22.Location = new System.Drawing.Point(6, 50);
            this.labelTS22.Name = "labelTS22";
            this.labelTS22.Size = new System.Drawing.Size(44, 16);
            this.labelTS22.TabIndex = 95;
            this.labelTS22.Text = "P/Sec";
            // 
            // labelTS21
            // 
            this.labelTS21.Image = null;
            this.labelTS21.Location = new System.Drawing.Point(6, 74);
            this.labelTS21.Name = "labelTS21";
            this.labelTS21.Size = new System.Drawing.Size(44, 16);
            this.labelTS21.TabIndex = 94;
            this.labelTS21.Text = "Duty %";
            // 
            // tbPulseRate1
            // 
            this.tbPulseRate1.AutoSize = false;
            this.tbPulseRate1.LargeChange = 1;
            this.tbPulseRate1.Location = new System.Drawing.Point(56, 48);
            this.tbPulseRate1.Maximum = 20;
            this.tbPulseRate1.Minimum = 10;
            this.tbPulseRate1.Name = "tbPulseRate1";
            this.tbPulseRate1.Size = new System.Drawing.Size(66, 18);
            this.tbPulseRate1.TabIndex = 93;
            this.tbPulseRate1.TickFrequency = 3;
            this.toolTip1.SetToolTip(this.tbPulseRate1, "Pulse Rate of 10 to 20 Pulses / Second");
            this.tbPulseRate1.Value = 15;
            this.tbPulseRate1.Scroll += new System.EventHandler(this.tbPulseRate_Scroll);
            this.tbPulseRate1.ValueChanged += new System.EventHandler(this.tbPulseRate_ValueChanged);
            this.tbPulseRate1.MouseDown += new System.Windows.Forms.MouseEventHandler(this.tbPulseRate_MouseDown);
            this.tbPulseRate1.MouseUp += new System.Windows.Forms.MouseEventHandler(this.tbPulseRate_MouseUp);
            // 
            // tbDutyCycle
            // 
            this.tbDutyCycle.AutoSize = false;
            this.tbDutyCycle.Location = new System.Drawing.Point(56, 77);
            this.tbDutyCycle.Maximum = 80;
            this.tbDutyCycle.Minimum = 10;
            this.tbDutyCycle.Name = "tbDutyCycle";
            this.tbDutyCycle.Size = new System.Drawing.Size(66, 18);
            this.tbDutyCycle.TabIndex = 92;
            this.tbDutyCycle.TickFrequency = 10;
            this.toolTip1.SetToolTip(this.tbDutyCycle, "Duty Cycle of 10% to 80% ON to OFF time");
            this.tbDutyCycle.Value = 40;
            this.tbDutyCycle.Scroll += new System.EventHandler(this.tbDutyCycle_Scroll);
            this.tbDutyCycle.ValueChanged += new System.EventHandler(this.tbDutyCycle_ValueChanged);
            this.tbDutyCycle.MouseDown += new System.Windows.Forms.MouseEventHandler(this.tbDutyCycle_MouseDown);
            this.tbDutyCycle.MouseUp += new System.Windows.Forms.MouseEventHandler(this.tbDutyCycle_MouseUp);
            // 
            // chkBoxPulser
            // 
            this.chkBoxPulser.Image = null;
            this.chkBoxPulser.Location = new System.Drawing.Point(2, 30);
            this.chkBoxPulser.Name = "chkBoxPulser";
            this.chkBoxPulser.Size = new System.Drawing.Size(64, 26);
            this.chkBoxPulser.TabIndex = 53;
            this.chkBoxPulser.Text = "Pulser";
            this.toolTip1.SetToolTip(this.chkBoxPulser, "For Tuning Amplifiers with a pulse train");
            this.chkBoxPulser.CheckedChanged += new System.EventHandler(this.chkBoxPulser_CheckedChanged);
            // 
            // comboTXTUNMeter
            // 
            this.comboTXTUNMeter.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboTXTUNMeter.DropDownWidth = 104;
            this.comboTXTUNMeter.Items.AddRange(new object[] {
            "Fwd Pwr",
            "Ref Pwr",
            "SWR",
            "Off"});
            this.comboTXTUNMeter.Location = new System.Drawing.Point(58, 104);
            this.comboTXTUNMeter.Name = "comboTXTUNMeter";
            this.comboTXTUNMeter.Size = new System.Drawing.Size(64, 21);
            this.comboTXTUNMeter.TabIndex = 9;
            this.toolTip1.SetToolTip(this.comboTXTUNMeter, "Sets the TX Meter setting when using the TUN botton on the  front panel");
            this.comboTXTUNMeter.SelectedIndexChanged += new System.EventHandler(this.comboTXTUNMeter_SelectedIndexChanged);
            // 
            // lblTXTUNMeter
            // 
            this.lblTXTUNMeter.Image = null;
            this.lblTXTUNMeter.Location = new System.Drawing.Point(-1, 101);
            this.lblTXTUNMeter.Name = "lblTXTUNMeter";
            this.lblTXTUNMeter.Size = new System.Drawing.Size(56, 24);
            this.lblTXTUNMeter.TabIndex = 8;
            this.lblTXTUNMeter.Text = "TX Meter:";
            this.lblTXTUNMeter.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTransmitTunePower
            // 
            this.lblTransmitTunePower.Image = null;
            this.lblTransmitTunePower.Location = new System.Drawing.Point(25, 17);
            this.lblTransmitTunePower.Name = "lblTransmitTunePower";
            this.lblTransmitTunePower.Size = new System.Drawing.Size(47, 16);
            this.lblTransmitTunePower.TabIndex = 5;
            this.lblTransmitTunePower.Text = "Drive:";
            // 
            // udTXTunePower
            // 
            this.udTXTunePower.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTXTunePower.Location = new System.Drawing.Point(72, 15);
            this.udTXTunePower.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTXTunePower.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXTunePower.Name = "udTXTunePower";
            this.udTXTunePower.Size = new System.Drawing.Size(48, 20);
            this.udTXTunePower.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udTXTunePower, "Power used when using the TUN button on the front panel.");
            this.udTXTunePower.Value = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udTXTunePower.ValueChanged += new System.EventHandler(this.udTransmitTunePower_ValueChanged);
            this.udTXTunePower.LostFocus += new System.EventHandler(this.udTXTunePower_LostFocus);
            // 
            // grpTXFilter
            // 
            this.grpTXFilter.Controls.Add(this.labelTS33);
            this.grpTXFilter.Controls.Add(this.udTXDriveMax);
            this.grpTXFilter.Controls.Add(this.lblTXFilterHigh);
            this.grpTXFilter.Controls.Add(this.udTXFilterLow);
            this.grpTXFilter.Controls.Add(this.lblTXFilterLow);
            this.grpTXFilter.Controls.Add(this.udTXFilterHigh);
            this.grpTXFilter.Location = new System.Drawing.Point(152, 8);
            this.grpTXFilter.Name = "grpTXFilter";
            this.grpTXFilter.Size = new System.Drawing.Size(144, 107);
            this.grpTXFilter.TabIndex = 19;
            this.grpTXFilter.TabStop = false;
            this.grpTXFilter.Text = "Transmit Filter";
            // 
            // labelTS33
            // 
            this.labelTS33.Image = null;
            this.labelTS33.Location = new System.Drawing.Point(6, 76);
            this.labelTS33.Name = "labelTS33";
            this.labelTS33.Size = new System.Drawing.Size(58, 17);
            this.labelTS33.TabIndex = 5;
            this.labelTS33.Text = "Drive Max:";
            // 
            // udTXDriveMax
            // 
            this.udTXDriveMax.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udTXDriveMax.Location = new System.Drawing.Point(70, 73);
            this.udTXDriveMax.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTXDriveMax.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXDriveMax.Name = "udTXDriveMax";
            this.udTXDriveMax.Size = new System.Drawing.Size(49, 20);
            this.udTXDriveMax.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udTXDriveMax, "Set to MAX Drive Value allowed\r\n\r\nReduce MAX Deive Value for Amp\'s that do not re" +
        "quire full power.");
            this.udTXDriveMax.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTXDriveMax.ValueChanged += new System.EventHandler(this.udTXDriveMax_ValueChanged);
            // 
            // lblTXFilterHigh
            // 
            this.lblTXFilterHigh.Image = null;
            this.lblTXFilterHigh.Location = new System.Drawing.Point(16, 24);
            this.lblTXFilterHigh.Name = "lblTXFilterHigh";
            this.lblTXFilterHigh.Size = new System.Drawing.Size(40, 18);
            this.lblTXFilterHigh.TabIndex = 3;
            this.lblTXFilterHigh.Text = "High:";
            // 
            // udTXFilterLow
            // 
            this.udTXFilterLow.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udTXFilterLow.Location = new System.Drawing.Point(56, 45);
            this.udTXFilterLow.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udTXFilterLow.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXFilterLow.Name = "udTXFilterLow";
            this.udTXFilterLow.Size = new System.Drawing.Size(56, 20);
            this.udTXFilterLow.TabIndex = 2;
            this.toolTip1.SetToolTip(this.udTXFilterLow, "Low Frequency TX Filter Cutoff");
            this.udTXFilterLow.Value = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udTXFilterLow.ValueChanged += new System.EventHandler(this.udTXFilterLow_ValueChanged);
            this.udTXFilterLow.LostFocus += new System.EventHandler(this.udTXFilterLow_LostFocus);
            // 
            // lblTXFilterLow
            // 
            this.lblTXFilterLow.Image = null;
            this.lblTXFilterLow.Location = new System.Drawing.Point(16, 48);
            this.lblTXFilterLow.Name = "lblTXFilterLow";
            this.lblTXFilterLow.Size = new System.Drawing.Size(40, 17);
            this.lblTXFilterLow.TabIndex = 1;
            this.lblTXFilterLow.Text = "Low:";
            // 
            // udTXFilterHigh
            // 
            this.udTXFilterHigh.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.udTXFilterHigh.Location = new System.Drawing.Point(56, 19);
            this.udTXFilterHigh.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udTXFilterHigh.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTXFilterHigh.Name = "udTXFilterHigh";
            this.udTXFilterHigh.Size = new System.Drawing.Size(56, 20);
            this.udTXFilterHigh.TabIndex = 0;
            this.toolTip1.SetToolTip(this.udTXFilterHigh, "High Frequency TX Filter Cutoff");
            this.udTXFilterHigh.Value = new decimal(new int[] {
            3100,
            0,
            0,
            0});
            this.udTXFilterHigh.ValueChanged += new System.EventHandler(this.udTXFilterHigh_ValueChanged);
            this.udTXFilterHigh.LostFocus += new System.EventHandler(this.udTXFilterHigh_LostFocus);
            // 
            // chkDCBlock
            // 
            this.chkDCBlock.Image = null;
            this.chkDCBlock.Location = new System.Drawing.Point(306, 110);
            this.chkDCBlock.Name = "chkDCBlock";
            this.chkDCBlock.Size = new System.Drawing.Size(72, 26);
            this.chkDCBlock.TabIndex = 48;
            this.chkDCBlock.Text = "DC Block";
            this.toolTip1.SetToolTip(this.chkDCBlock, "Enable this to engage a digital LPF");
            this.chkDCBlock.CheckedChanged += new System.EventHandler(this.chkDCBlock_CheckedChanged);
            // 
            // grpTX1500
            // 
            this.grpTX1500.Controls.Add(this.lblTX1500Blanking);
            this.grpTX1500.Controls.Add(this.udTX1500PhoneBlanking);
            this.grpTX1500.Location = new System.Drawing.Point(8, 242);
            this.grpTX1500.Name = "grpTX1500";
            this.grpTX1500.Size = new System.Drawing.Size(136, 96);
            this.grpTX1500.TabIndex = 56;
            this.grpTX1500.TabStop = false;
            this.grpTX1500.Text = "FLEX-1500";
            this.grpTX1500.Visible = false;
            // 
            // lblTX1500Blanking
            // 
            this.lblTX1500Blanking.Image = null;
            this.lblTX1500Blanking.Location = new System.Drawing.Point(8, 18);
            this.lblTX1500Blanking.Name = "lblTX1500Blanking";
            this.lblTX1500Blanking.Size = new System.Drawing.Size(64, 42);
            this.lblTX1500Blanking.TabIndex = 5;
            this.lblTX1500Blanking.Text = "Phone Transition Blanking:";
            // 
            // udTX1500PhoneBlanking
            // 
            this.udTX1500PhoneBlanking.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTX1500PhoneBlanking.Location = new System.Drawing.Point(72, 23);
            this.udTX1500PhoneBlanking.Maximum = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.udTX1500PhoneBlanking.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTX1500PhoneBlanking.Name = "udTX1500PhoneBlanking";
            this.udTX1500PhoneBlanking.Size = new System.Drawing.Size(48, 20);
            this.udTX1500PhoneBlanking.TabIndex = 4;
            this.toolTip1.SetToolTip(this.udTX1500PhoneBlanking, "Sets the time to blank the audio during RX/TX transitions.  The optimal value for" +
        " this will vary depending on the system and driver in use.");
            this.udTX1500PhoneBlanking.Value = new decimal(new int[] {
            200,
            0,
            0,
            0});
            this.udTX1500PhoneBlanking.ValueChanged += new System.EventHandler(this.udTX1500Blanking_ValueChanged);
            // 
            // tpPowerAmplifier
            // 
            this.tpPowerAmplifier.Controls.Add(this.rtxtPACalReq);
            this.tpPowerAmplifier.Controls.Add(this.grpPABandOffset);
            this.tpPowerAmplifier.Controls.Add(this.chkPANewCal);
            this.tpPowerAmplifier.Controls.Add(this.grpPAGainByBand);
            this.tpPowerAmplifier.Location = new System.Drawing.Point(4, 22);
            this.tpPowerAmplifier.Name = "tpPowerAmplifier";
            this.tpPowerAmplifier.Size = new System.Drawing.Size(584, 341);
            this.tpPowerAmplifier.TabIndex = 8;
            this.tpPowerAmplifier.Text = "PA Settings";
            // 
            // rtxtPACalReq
            // 
            this.rtxtPACalReq.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rtxtPACalReq.Location = new System.Drawing.Point(272, 16);
            this.rtxtPACalReq.Name = "rtxtPACalReq";
            this.rtxtPACalReq.ReadOnly = true;
            this.rtxtPACalReq.Size = new System.Drawing.Size(224, 112);
            this.rtxtPACalReq.TabIndex = 82;
            this.rtxtPACalReq.Text = "";
            // 
            // grpPABandOffset
            // 
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset10);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset12);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset15);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset17);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset20);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset30);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset40);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset60);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset80);
            this.grpPABandOffset.Controls.Add(this.lblPABandOffset160);
            this.grpPABandOffset.Controls.Add(this.udPAADC17);
            this.grpPABandOffset.Controls.Add(this.udPAADC15);
            this.grpPABandOffset.Controls.Add(this.udPAADC20);
            this.grpPABandOffset.Controls.Add(this.udPAADC12);
            this.grpPABandOffset.Controls.Add(this.udPAADC10);
            this.grpPABandOffset.Controls.Add(this.udPAADC160);
            this.grpPABandOffset.Controls.Add(this.udPAADC80);
            this.grpPABandOffset.Controls.Add(this.udPAADC60);
            this.grpPABandOffset.Controls.Add(this.udPAADC40);
            this.grpPABandOffset.Controls.Add(this.udPAADC30);
            this.grpPABandOffset.Location = new System.Drawing.Point(272, 8);
            this.grpPABandOffset.Name = "grpPABandOffset";
            this.grpPABandOffset.Size = new System.Drawing.Size(208, 152);
            this.grpPABandOffset.TabIndex = 81;
            this.grpPABandOffset.TabStop = false;
            this.grpPABandOffset.Text = "ADC Offset (ADC bits)";
            this.grpPABandOffset.Visible = false;
            // 
            // lblPABandOffset10
            // 
            this.lblPABandOffset10.Image = null;
            this.lblPABandOffset10.Location = new System.Drawing.Point(104, 120);
            this.lblPABandOffset10.Name = "lblPABandOffset10";
            this.lblPABandOffset10.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset10.TabIndex = 90;
            this.lblPABandOffset10.Text = "10m:";
            // 
            // lblPABandOffset12
            // 
            this.lblPABandOffset12.Image = null;
            this.lblPABandOffset12.Location = new System.Drawing.Point(104, 96);
            this.lblPABandOffset12.Name = "lblPABandOffset12";
            this.lblPABandOffset12.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset12.TabIndex = 89;
            this.lblPABandOffset12.Text = "12m:";
            // 
            // lblPABandOffset15
            // 
            this.lblPABandOffset15.Image = null;
            this.lblPABandOffset15.Location = new System.Drawing.Point(104, 72);
            this.lblPABandOffset15.Name = "lblPABandOffset15";
            this.lblPABandOffset15.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset15.TabIndex = 88;
            this.lblPABandOffset15.Text = "15m:";
            // 
            // lblPABandOffset17
            // 
            this.lblPABandOffset17.Image = null;
            this.lblPABandOffset17.Location = new System.Drawing.Point(104, 48);
            this.lblPABandOffset17.Name = "lblPABandOffset17";
            this.lblPABandOffset17.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset17.TabIndex = 87;
            this.lblPABandOffset17.Text = "17m:";
            // 
            // lblPABandOffset20
            // 
            this.lblPABandOffset20.Image = null;
            this.lblPABandOffset20.Location = new System.Drawing.Point(104, 24);
            this.lblPABandOffset20.Name = "lblPABandOffset20";
            this.lblPABandOffset20.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset20.TabIndex = 86;
            this.lblPABandOffset20.Text = "20m:";
            // 
            // lblPABandOffset30
            // 
            this.lblPABandOffset30.Image = null;
            this.lblPABandOffset30.Location = new System.Drawing.Point(16, 120);
            this.lblPABandOffset30.Name = "lblPABandOffset30";
            this.lblPABandOffset30.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset30.TabIndex = 85;
            this.lblPABandOffset30.Text = "30m:";
            // 
            // lblPABandOffset40
            // 
            this.lblPABandOffset40.Image = null;
            this.lblPABandOffset40.Location = new System.Drawing.Point(16, 96);
            this.lblPABandOffset40.Name = "lblPABandOffset40";
            this.lblPABandOffset40.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset40.TabIndex = 84;
            this.lblPABandOffset40.Text = "40m:";
            // 
            // lblPABandOffset60
            // 
            this.lblPABandOffset60.Image = null;
            this.lblPABandOffset60.Location = new System.Drawing.Point(16, 72);
            this.lblPABandOffset60.Name = "lblPABandOffset60";
            this.lblPABandOffset60.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset60.TabIndex = 83;
            this.lblPABandOffset60.Text = "60m:";
            // 
            // lblPABandOffset80
            // 
            this.lblPABandOffset80.Image = null;
            this.lblPABandOffset80.Location = new System.Drawing.Point(16, 48);
            this.lblPABandOffset80.Name = "lblPABandOffset80";
            this.lblPABandOffset80.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset80.TabIndex = 82;
            this.lblPABandOffset80.Text = "80m:";
            // 
            // lblPABandOffset160
            // 
            this.lblPABandOffset160.Image = null;
            this.lblPABandOffset160.Location = new System.Drawing.Point(16, 24);
            this.lblPABandOffset160.Name = "lblPABandOffset160";
            this.lblPABandOffset160.Size = new System.Drawing.Size(40, 16);
            this.lblPABandOffset160.TabIndex = 81;
            this.lblPABandOffset160.Text = "160m:";
            // 
            // udPAADC17
            // 
            this.udPAADC17.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC17.Location = new System.Drawing.Point(144, 48);
            this.udPAADC17.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC17.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC17.Name = "udPAADC17";
            this.udPAADC17.Size = new System.Drawing.Size(48, 20);
            this.udPAADC17.TabIndex = 77;
            this.udPAADC17.Value = new decimal(new int[] {
            108,
            0,
            0,
            0});
            this.udPAADC17.LostFocus += new System.EventHandler(this.udPAADC17_LostFocus);
            // 
            // udPAADC15
            // 
            this.udPAADC15.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC15.Location = new System.Drawing.Point(144, 72);
            this.udPAADC15.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC15.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC15.Name = "udPAADC15";
            this.udPAADC15.Size = new System.Drawing.Size(48, 20);
            this.udPAADC15.TabIndex = 78;
            this.udPAADC15.Value = new decimal(new int[] {
            108,
            0,
            0,
            0});
            this.udPAADC15.LostFocus += new System.EventHandler(this.udPAADC15_LostFocus);
            // 
            // udPAADC20
            // 
            this.udPAADC20.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC20.Location = new System.Drawing.Point(144, 24);
            this.udPAADC20.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC20.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC20.Name = "udPAADC20";
            this.udPAADC20.Size = new System.Drawing.Size(48, 20);
            this.udPAADC20.TabIndex = 76;
            this.udPAADC20.Value = new decimal(new int[] {
            108,
            0,
            0,
            0});
            this.udPAADC20.LostFocus += new System.EventHandler(this.udPAADC20_LostFocus);
            // 
            // udPAADC12
            // 
            this.udPAADC12.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC12.Location = new System.Drawing.Point(144, 96);
            this.udPAADC12.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC12.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC12.Name = "udPAADC12";
            this.udPAADC12.Size = new System.Drawing.Size(48, 20);
            this.udPAADC12.TabIndex = 79;
            this.udPAADC12.Value = new decimal(new int[] {
            110,
            0,
            0,
            0});
            this.udPAADC12.LostFocus += new System.EventHandler(this.udPAADC12_LostFocus);
            // 
            // udPAADC10
            // 
            this.udPAADC10.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC10.Location = new System.Drawing.Point(144, 120);
            this.udPAADC10.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC10.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC10.Name = "udPAADC10";
            this.udPAADC10.Size = new System.Drawing.Size(48, 20);
            this.udPAADC10.TabIndex = 80;
            this.udPAADC10.Value = new decimal(new int[] {
            111,
            0,
            0,
            0});
            this.udPAADC10.LostFocus += new System.EventHandler(this.udPAADC10_LostFocus);
            // 
            // udPAADC160
            // 
            this.udPAADC160.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC160.Location = new System.Drawing.Point(56, 24);
            this.udPAADC160.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC160.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC160.Name = "udPAADC160";
            this.udPAADC160.Size = new System.Drawing.Size(48, 20);
            this.udPAADC160.TabIndex = 71;
            this.udPAADC160.Value = new decimal(new int[] {
            107,
            0,
            0,
            0});
            this.udPAADC160.LostFocus += new System.EventHandler(this.udPAADC160_LostFocus);
            // 
            // udPAADC80
            // 
            this.udPAADC80.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC80.Location = new System.Drawing.Point(56, 48);
            this.udPAADC80.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC80.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC80.Name = "udPAADC80";
            this.udPAADC80.Size = new System.Drawing.Size(48, 20);
            this.udPAADC80.TabIndex = 72;
            this.udPAADC80.Value = new decimal(new int[] {
            107,
            0,
            0,
            0});
            this.udPAADC80.LostFocus += new System.EventHandler(this.udPAADC80_LostFocus);
            // 
            // udPAADC60
            // 
            this.udPAADC60.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC60.Location = new System.Drawing.Point(56, 72);
            this.udPAADC60.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC60.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC60.Name = "udPAADC60";
            this.udPAADC60.Size = new System.Drawing.Size(48, 20);
            this.udPAADC60.TabIndex = 73;
            this.udPAADC60.Value = new decimal(new int[] {
            107,
            0,
            0,
            0});
            this.udPAADC60.LostFocus += new System.EventHandler(this.udPAADC60_LostFocus);
            // 
            // udPAADC40
            // 
            this.udPAADC40.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC40.Location = new System.Drawing.Point(56, 96);
            this.udPAADC40.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC40.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC40.Name = "udPAADC40";
            this.udPAADC40.Size = new System.Drawing.Size(48, 20);
            this.udPAADC40.TabIndex = 74;
            this.udPAADC40.Value = new decimal(new int[] {
            106,
            0,
            0,
            0});
            this.udPAADC40.LostFocus += new System.EventHandler(this.udPAADC40_LostFocus);
            // 
            // udPAADC30
            // 
            this.udPAADC30.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPAADC30.Location = new System.Drawing.Point(56, 120);
            this.udPAADC30.Maximum = new decimal(new int[] {
            255,
            0,
            0,
            0});
            this.udPAADC30.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPAADC30.Name = "udPAADC30";
            this.udPAADC30.Size = new System.Drawing.Size(48, 20);
            this.udPAADC30.TabIndex = 75;
            this.udPAADC30.Value = new decimal(new int[] {
            108,
            0,
            0,
            0});
            this.udPAADC30.LostFocus += new System.EventHandler(this.udPAADC30_LostFocus);
            // 
            // chkPANewCal
            // 
            this.chkPANewCal.Image = null;
            this.chkPANewCal.Location = new System.Drawing.Point(280, 176);
            this.chkPANewCal.Name = "chkPANewCal";
            this.chkPANewCal.Size = new System.Drawing.Size(120, 32);
            this.chkPANewCal.TabIndex = 83;
            this.chkPANewCal.Text = "Use Advanced Calibration Routine";
            this.chkPANewCal.CheckedChanged += new System.EventHandler(this.chkPANewCal_CheckedChanged);
            // 
            // grpPAGainByBand
            // 
            this.grpPAGainByBand.Controls.Add(this.udPACalPower);
            this.grpPAGainByBand.Controls.Add(this.lblPACalTarget);
            this.grpPAGainByBand.Controls.Add(this.chkPA10);
            this.grpPAGainByBand.Controls.Add(this.chkPA12);
            this.grpPAGainByBand.Controls.Add(this.chkPA15);
            this.grpPAGainByBand.Controls.Add(this.chkPA17);
            this.grpPAGainByBand.Controls.Add(this.chkPA20);
            this.grpPAGainByBand.Controls.Add(this.chkPA30);
            this.grpPAGainByBand.Controls.Add(this.chkPA40);
            this.grpPAGainByBand.Controls.Add(this.chkPA60);
            this.grpPAGainByBand.Controls.Add(this.chkPA80);
            this.grpPAGainByBand.Controls.Add(this.chkPA160);
            this.grpPAGainByBand.Controls.Add(this.radPACalSelBands);
            this.grpPAGainByBand.Controls.Add(this.radPACalAllBands);
            this.grpPAGainByBand.Controls.Add(this.btnPAGainReset);
            this.grpPAGainByBand.Controls.Add(this.btnPAGainCalibration);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand10);
            this.grpPAGainByBand.Controls.Add(this.udPAGain10);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand12);
            this.grpPAGainByBand.Controls.Add(this.udPAGain12);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand15);
            this.grpPAGainByBand.Controls.Add(this.udPAGain15);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand17);
            this.grpPAGainByBand.Controls.Add(this.udPAGain17);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand20);
            this.grpPAGainByBand.Controls.Add(this.udPAGain20);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand30);
            this.grpPAGainByBand.Controls.Add(this.udPAGain30);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand40);
            this.grpPAGainByBand.Controls.Add(this.udPAGain40);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand60);
            this.grpPAGainByBand.Controls.Add(this.udPAGain60);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand80);
            this.grpPAGainByBand.Controls.Add(this.udPAGain80);
            this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand160);
            this.grpPAGainByBand.Controls.Add(this.udPAGain160);
            this.grpPAGainByBand.Controls.Add(this.chkPA6);
            this.grpPAGainByBand.Location = new System.Drawing.Point(8, 8);
            this.grpPAGainByBand.Name = "grpPAGainByBand";
            this.grpPAGainByBand.Size = new System.Drawing.Size(256, 272);
            this.grpPAGainByBand.TabIndex = 1;
            this.grpPAGainByBand.TabStop = false;
            this.grpPAGainByBand.Text = "Gain By Band (dB)";
            this.grpPAGainByBand.Visible = false;
            // 
            // udPACalPower
            // 
            this.udPACalPower.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPACalPower.Location = new System.Drawing.Point(96, 160);
            this.udPACalPower.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPACalPower.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPACalPower.Name = "udPACalPower";
            this.udPACalPower.Size = new System.Drawing.Size(40, 20);
            this.udPACalPower.TabIndex = 35;
            this.udPACalPower.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            // 
            // lblPACalTarget
            // 
            this.lblPACalTarget.Image = null;
            this.lblPACalTarget.Location = new System.Drawing.Point(88, 144);
            this.lblPACalTarget.Name = "lblPACalTarget";
            this.lblPACalTarget.Size = new System.Drawing.Size(64, 16);
            this.lblPACalTarget.TabIndex = 34;
            this.lblPACalTarget.Text = "Cal Target:";
            // 
            // chkPA10
            // 
            this.chkPA10.Image = null;
            this.chkPA10.Location = new System.Drawing.Point(176, 248);
            this.chkPA10.Name = "chkPA10";
            this.chkPA10.Size = new System.Drawing.Size(36, 16);
            this.chkPA10.TabIndex = 33;
            this.chkPA10.Text = "10";
            this.chkPA10.Visible = false;
            // 
            // chkPA12
            // 
            this.chkPA12.Image = null;
            this.chkPA12.Location = new System.Drawing.Point(136, 248);
            this.chkPA12.Name = "chkPA12";
            this.chkPA12.Size = new System.Drawing.Size(36, 16);
            this.chkPA12.TabIndex = 32;
            this.chkPA12.Text = "12";
            this.chkPA12.Visible = false;
            // 
            // chkPA15
            // 
            this.chkPA15.Image = null;
            this.chkPA15.Location = new System.Drawing.Point(96, 248);
            this.chkPA15.Name = "chkPA15";
            this.chkPA15.Size = new System.Drawing.Size(36, 16);
            this.chkPA15.TabIndex = 31;
            this.chkPA15.Text = "15";
            this.chkPA15.Visible = false;
            // 
            // chkPA17
            // 
            this.chkPA17.Image = null;
            this.chkPA17.Location = new System.Drawing.Point(56, 248);
            this.chkPA17.Name = "chkPA17";
            this.chkPA17.Size = new System.Drawing.Size(36, 16);
            this.chkPA17.TabIndex = 30;
            this.chkPA17.Text = "17";
            this.chkPA17.Visible = false;
            // 
            // chkPA20
            // 
            this.chkPA20.Image = null;
            this.chkPA20.Location = new System.Drawing.Point(8, 248);
            this.chkPA20.Name = "chkPA20";
            this.chkPA20.Size = new System.Drawing.Size(36, 16);
            this.chkPA20.TabIndex = 29;
            this.chkPA20.Text = "20";
            this.chkPA20.Visible = false;
            // 
            // chkPA30
            // 
            this.chkPA30.Image = null;
            this.chkPA30.Location = new System.Drawing.Point(176, 224);
            this.chkPA30.Name = "chkPA30";
            this.chkPA30.Size = new System.Drawing.Size(36, 16);
            this.chkPA30.TabIndex = 28;
            this.chkPA30.Text = "30";
            this.chkPA30.Visible = false;
            // 
            // chkPA40
            // 
            this.chkPA40.Image = null;
            this.chkPA40.Location = new System.Drawing.Point(136, 224);
            this.chkPA40.Name = "chkPA40";
            this.chkPA40.Size = new System.Drawing.Size(40, 16);
            this.chkPA40.TabIndex = 27;
            this.chkPA40.Text = "40";
            this.chkPA40.Visible = false;
            // 
            // chkPA60
            // 
            this.chkPA60.Image = null;
            this.chkPA60.Location = new System.Drawing.Point(96, 224);
            this.chkPA60.Name = "chkPA60";
            this.chkPA60.Size = new System.Drawing.Size(40, 16);
            this.chkPA60.TabIndex = 26;
            this.chkPA60.Text = "60";
            this.chkPA60.Visible = false;
            // 
            // chkPA80
            // 
            this.chkPA80.Image = null;
            this.chkPA80.Location = new System.Drawing.Point(56, 224);
            this.chkPA80.Name = "chkPA80";
            this.chkPA80.Size = new System.Drawing.Size(40, 16);
            this.chkPA80.TabIndex = 25;
            this.chkPA80.Text = "80";
            this.chkPA80.Visible = false;
            // 
            // chkPA160
            // 
            this.chkPA160.Image = null;
            this.chkPA160.Location = new System.Drawing.Point(8, 224);
            this.chkPA160.Name = "chkPA160";
            this.chkPA160.Size = new System.Drawing.Size(48, 16);
            this.chkPA160.TabIndex = 24;
            this.chkPA160.Text = "160";
            this.chkPA160.Visible = false;
            // 
            // radPACalSelBands
            // 
            this.radPACalSelBands.Image = null;
            this.radPACalSelBands.Location = new System.Drawing.Point(96, 184);
            this.radPACalSelBands.Name = "radPACalSelBands";
            this.radPACalSelBands.Size = new System.Drawing.Size(112, 32);
            this.radPACalSelBands.TabIndex = 23;
            this.radPACalSelBands.Text = "Selected Bands (checked below)";
            // 
            // radPACalAllBands
            // 
            this.radPACalAllBands.Checked = true;
            this.radPACalAllBands.Image = null;
            this.radPACalAllBands.Location = new System.Drawing.Point(16, 184);
            this.radPACalAllBands.Name = "radPACalAllBands";
            this.radPACalAllBands.Size = new System.Drawing.Size(72, 32);
            this.radPACalAllBands.TabIndex = 22;
            this.radPACalAllBands.TabStop = true;
            this.radPACalAllBands.Text = "All Bands";
            this.radPACalAllBands.CheckedChanged += new System.EventHandler(this.radPACalAllBands_CheckedChanged);
            // 
            // btnPAGainReset
            // 
            this.btnPAGainReset.Image = null;
            this.btnPAGainReset.Location = new System.Drawing.Point(152, 152);
            this.btnPAGainReset.Name = "btnPAGainReset";
            this.btnPAGainReset.Size = new System.Drawing.Size(48, 23);
            this.btnPAGainReset.TabIndex = 21;
            this.btnPAGainReset.Text = "Reset";
            this.toolTip1.SetToolTip(this.btnPAGainReset, "Reset all Gain values to the default 48.0dB");
            this.btnPAGainReset.Click += new System.EventHandler(this.btnPAGainReset_Click);
            // 
            // btnPAGainCalibration
            // 
            this.btnPAGainCalibration.Image = null;
            this.btnPAGainCalibration.Location = new System.Drawing.Point(16, 152);
            this.btnPAGainCalibration.Name = "btnPAGainCalibration";
            this.btnPAGainCalibration.Size = new System.Drawing.Size(64, 23);
            this.btnPAGainCalibration.TabIndex = 20;
            this.btnPAGainCalibration.Text = "Calibrate";
            this.btnPAGainCalibration.Click += new System.EventHandler(this.btnPAGainCalibration_Click);
            // 
            // lblPAGainByBand10
            // 
            this.lblPAGainByBand10.Image = null;
            this.lblPAGainByBand10.Location = new System.Drawing.Point(112, 120);
            this.lblPAGainByBand10.Name = "lblPAGainByBand10";
            this.lblPAGainByBand10.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand10.TabIndex = 19;
            this.lblPAGainByBand10.Text = "10m:";
            // 
            // udPAGain10
            // 
            this.udPAGain10.DecimalPlaces = 1;
            this.udPAGain10.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain10.Location = new System.Drawing.Point(152, 120);
            this.udPAGain10.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain10.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain10.Name = "udPAGain10";
            this.udPAGain10.Size = new System.Drawing.Size(48, 20);
            this.udPAGain10.TabIndex = 18;
            this.udPAGain10.Value = new decimal(new int[] {
            430,
            0,
            0,
            65536});
            this.udPAGain10.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain10.LostFocus += new System.EventHandler(this.udPAGain10_LostFocus);
            // 
            // lblPAGainByBand12
            // 
            this.lblPAGainByBand12.Image = null;
            this.lblPAGainByBand12.Location = new System.Drawing.Point(112, 96);
            this.lblPAGainByBand12.Name = "lblPAGainByBand12";
            this.lblPAGainByBand12.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand12.TabIndex = 17;
            this.lblPAGainByBand12.Text = "12m:";
            // 
            // udPAGain12
            // 
            this.udPAGain12.DecimalPlaces = 1;
            this.udPAGain12.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain12.Location = new System.Drawing.Point(152, 96);
            this.udPAGain12.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain12.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain12.Name = "udPAGain12";
            this.udPAGain12.Size = new System.Drawing.Size(48, 20);
            this.udPAGain12.TabIndex = 16;
            this.udPAGain12.Value = new decimal(new int[] {
            474,
            0,
            0,
            65536});
            this.udPAGain12.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain12.LostFocus += new System.EventHandler(this.udPAGain12_LostFocus);
            // 
            // lblPAGainByBand15
            // 
            this.lblPAGainByBand15.Image = null;
            this.lblPAGainByBand15.Location = new System.Drawing.Point(112, 72);
            this.lblPAGainByBand15.Name = "lblPAGainByBand15";
            this.lblPAGainByBand15.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand15.TabIndex = 15;
            this.lblPAGainByBand15.Text = "15m:";
            // 
            // udPAGain15
            // 
            this.udPAGain15.DecimalPlaces = 1;
            this.udPAGain15.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain15.Location = new System.Drawing.Point(152, 72);
            this.udPAGain15.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain15.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain15.Name = "udPAGain15";
            this.udPAGain15.Size = new System.Drawing.Size(48, 20);
            this.udPAGain15.TabIndex = 14;
            this.udPAGain15.Value = new decimal(new int[] {
            481,
            0,
            0,
            65536});
            this.udPAGain15.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain15.LostFocus += new System.EventHandler(this.udPAGain15_LostFocus);
            // 
            // lblPAGainByBand17
            // 
            this.lblPAGainByBand17.Image = null;
            this.lblPAGainByBand17.Location = new System.Drawing.Point(112, 48);
            this.lblPAGainByBand17.Name = "lblPAGainByBand17";
            this.lblPAGainByBand17.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand17.TabIndex = 13;
            this.lblPAGainByBand17.Text = "17m:";
            // 
            // udPAGain17
            // 
            this.udPAGain17.DecimalPlaces = 1;
            this.udPAGain17.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain17.Location = new System.Drawing.Point(152, 48);
            this.udPAGain17.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain17.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain17.Name = "udPAGain17";
            this.udPAGain17.Size = new System.Drawing.Size(48, 20);
            this.udPAGain17.TabIndex = 12;
            this.udPAGain17.Value = new decimal(new int[] {
            493,
            0,
            0,
            65536});
            this.udPAGain17.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain17.LostFocus += new System.EventHandler(this.udPAGain17_LostFocus);
            // 
            // lblPAGainByBand20
            // 
            this.lblPAGainByBand20.Image = null;
            this.lblPAGainByBand20.Location = new System.Drawing.Point(112, 24);
            this.lblPAGainByBand20.Name = "lblPAGainByBand20";
            this.lblPAGainByBand20.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand20.TabIndex = 11;
            this.lblPAGainByBand20.Text = "20m:";
            // 
            // udPAGain20
            // 
            this.udPAGain20.DecimalPlaces = 1;
            this.udPAGain20.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain20.Location = new System.Drawing.Point(152, 24);
            this.udPAGain20.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain20.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain20.Name = "udPAGain20";
            this.udPAGain20.Size = new System.Drawing.Size(48, 20);
            this.udPAGain20.TabIndex = 10;
            this.udPAGain20.Value = new decimal(new int[] {
            483,
            0,
            0,
            65536});
            this.udPAGain20.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain20.LostFocus += new System.EventHandler(this.udPAGain20_LostFocus);
            // 
            // lblPAGainByBand30
            // 
            this.lblPAGainByBand30.Image = null;
            this.lblPAGainByBand30.Location = new System.Drawing.Point(16, 120);
            this.lblPAGainByBand30.Name = "lblPAGainByBand30";
            this.lblPAGainByBand30.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand30.TabIndex = 9;
            this.lblPAGainByBand30.Text = "30m:";
            // 
            // udPAGain30
            // 
            this.udPAGain30.DecimalPlaces = 1;
            this.udPAGain30.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain30.Location = new System.Drawing.Point(56, 120);
            this.udPAGain30.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain30.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain30.Name = "udPAGain30";
            this.udPAGain30.Size = new System.Drawing.Size(48, 20);
            this.udPAGain30.TabIndex = 8;
            this.udPAGain30.Value = new decimal(new int[] {
            489,
            0,
            0,
            65536});
            this.udPAGain30.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain30.LostFocus += new System.EventHandler(this.udPAGain30_LostFocus);
            // 
            // lblPAGainByBand40
            // 
            this.lblPAGainByBand40.Image = null;
            this.lblPAGainByBand40.Location = new System.Drawing.Point(16, 96);
            this.lblPAGainByBand40.Name = "lblPAGainByBand40";
            this.lblPAGainByBand40.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand40.TabIndex = 7;
            this.lblPAGainByBand40.Text = "40m:";
            // 
            // udPAGain40
            // 
            this.udPAGain40.DecimalPlaces = 1;
            this.udPAGain40.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain40.Location = new System.Drawing.Point(56, 96);
            this.udPAGain40.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain40.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain40.Name = "udPAGain40";
            this.udPAGain40.Size = new System.Drawing.Size(48, 20);
            this.udPAGain40.TabIndex = 6;
            this.udPAGain40.Value = new decimal(new int[] {
            469,
            0,
            0,
            65536});
            this.udPAGain40.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain40.LostFocus += new System.EventHandler(this.udPAGain40_LostFocus);
            // 
            // lblPAGainByBand60
            // 
            this.lblPAGainByBand60.Image = null;
            this.lblPAGainByBand60.Location = new System.Drawing.Point(16, 72);
            this.lblPAGainByBand60.Name = "lblPAGainByBand60";
            this.lblPAGainByBand60.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand60.TabIndex = 5;
            this.lblPAGainByBand60.Text = "60m:";
            // 
            // udPAGain60
            // 
            this.udPAGain60.DecimalPlaces = 1;
            this.udPAGain60.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain60.Location = new System.Drawing.Point(56, 72);
            this.udPAGain60.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain60.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain60.Name = "udPAGain60";
            this.udPAGain60.Size = new System.Drawing.Size(48, 20);
            this.udPAGain60.TabIndex = 4;
            this.udPAGain60.Value = new decimal(new int[] {
            474,
            0,
            0,
            65536});
            this.udPAGain60.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain60.LostFocus += new System.EventHandler(this.udPAGain60_LostFocus);
            // 
            // lblPAGainByBand80
            // 
            this.lblPAGainByBand80.Image = null;
            this.lblPAGainByBand80.Location = new System.Drawing.Point(16, 48);
            this.lblPAGainByBand80.Name = "lblPAGainByBand80";
            this.lblPAGainByBand80.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand80.TabIndex = 3;
            this.lblPAGainByBand80.Text = "80m:";
            // 
            // udPAGain80
            // 
            this.udPAGain80.DecimalPlaces = 1;
            this.udPAGain80.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain80.Location = new System.Drawing.Point(56, 48);
            this.udPAGain80.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain80.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain80.Name = "udPAGain80";
            this.udPAGain80.Size = new System.Drawing.Size(48, 20);
            this.udPAGain80.TabIndex = 2;
            this.udPAGain80.Value = new decimal(new int[] {
            480,
            0,
            0,
            65536});
            this.udPAGain80.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain80.LostFocus += new System.EventHandler(this.udPAGain80_LostFocus);
            // 
            // lblPAGainByBand160
            // 
            this.lblPAGainByBand160.Image = null;
            this.lblPAGainByBand160.Location = new System.Drawing.Point(16, 24);
            this.lblPAGainByBand160.Name = "lblPAGainByBand160";
            this.lblPAGainByBand160.Size = new System.Drawing.Size(40, 16);
            this.lblPAGainByBand160.TabIndex = 1;
            this.lblPAGainByBand160.Text = "160m:";
            // 
            // udPAGain160
            // 
            this.udPAGain160.DecimalPlaces = 1;
            this.udPAGain160.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udPAGain160.Location = new System.Drawing.Point(56, 24);
            this.udPAGain160.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPAGain160.Minimum = new decimal(new int[] {
            38,
            0,
            0,
            0});
            this.udPAGain160.Name = "udPAGain160";
            this.udPAGain160.Size = new System.Drawing.Size(48, 20);
            this.udPAGain160.TabIndex = 0;
            this.udPAGain160.Value = new decimal(new int[] {
            490,
            0,
            0,
            65536});
            this.udPAGain160.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
            this.udPAGain160.LostFocus += new System.EventHandler(this.udPAGain160_LostFocus);
            // 
            // chkPA6
            // 
            this.chkPA6.Image = null;
            this.chkPA6.Location = new System.Drawing.Point(216, 248);
            this.chkPA6.Name = "chkPA6";
            this.chkPA6.Size = new System.Drawing.Size(36, 16);
            this.chkPA6.TabIndex = 84;
            this.chkPA6.Text = "6";
            this.chkPA6.Visible = false;
            // 
            // tpAppearance
            // 
            this.tpAppearance.Controls.Add(this.tcAppearance);
            this.tpAppearance.Location = new System.Drawing.Point(4, 22);
            this.tpAppearance.Name = "tpAppearance";
            this.tpAppearance.Size = new System.Drawing.Size(584, 341);
            this.tpAppearance.TabIndex = 6;
            this.tpAppearance.Text = "Appearance";
            // 
            // tcAppearance
            // 
            this.tcAppearance.Controls.Add(this.tpAppearanceGeneral);
            this.tcAppearance.Controls.Add(this.tpAppearanceDisplay);
            this.tcAppearance.Controls.Add(this.tpAppearanceMeter);
            this.tcAppearance.Location = new System.Drawing.Point(0, 0);
            this.tcAppearance.Name = "tcAppearance";
            this.tcAppearance.SelectedIndex = 0;
            this.tcAppearance.Size = new System.Drawing.Size(600, 344);
            this.tcAppearance.TabIndex = 40;
            // 
            // tpAppearanceGeneral
            // 
            this.tpAppearanceGeneral.BackColor = System.Drawing.SystemColors.Control;
            this.tpAppearanceGeneral.Controls.Add(this.labelTS46);
            this.tpAppearanceGeneral.Controls.Add(this.labelTS45);
            this.tpAppearanceGeneral.Controls.Add(this.number3DY);
            this.tpAppearanceGeneral.Controls.Add(this.number3DX);
            this.tpAppearanceGeneral.Controls.Add(this.groupBoxTS3);
            this.tpAppearanceGeneral.Controls.Add(this.btnSkinExport);
            this.tpAppearanceGeneral.Controls.Add(this.grpAppSkins);
            this.tpAppearanceGeneral.Controls.Add(this.lblGenBackground);
            this.tpAppearanceGeneral.Controls.Add(this.clrbtnGenBackground);
            this.tpAppearanceGeneral.Controls.Add(this.grpAppearanceBand);
            this.tpAppearanceGeneral.Controls.Add(this.grpAppearanceVFO);
            this.tpAppearanceGeneral.Controls.Add(this.clrbtnBtnSel);
            this.tpAppearanceGeneral.Controls.Add(this.lblAppearanceGenBtnSel);
            this.tpAppearanceGeneral.Location = new System.Drawing.Point(4, 22);
            this.tpAppearanceGeneral.Name = "tpAppearanceGeneral";
            this.tpAppearanceGeneral.Size = new System.Drawing.Size(592, 318);
            this.tpAppearanceGeneral.TabIndex = 0;
            this.tpAppearanceGeneral.Text = "General";
            // 
            // labelTS46
            // 
            this.labelTS46.Image = null;
            this.labelTS46.Location = new System.Drawing.Point(7, 243);
            this.labelTS46.Name = "labelTS46";
            this.labelTS46.Size = new System.Drawing.Size(64, 24);
            this.labelTS46.TabIndex = 89;
            this.labelTS46.Text = "3D y offset:";
            // 
            // labelTS45
            // 
            this.labelTS45.Image = null;
            this.labelTS45.Location = new System.Drawing.Point(7, 216);
            this.labelTS45.Name = "labelTS45";
            this.labelTS45.Size = new System.Drawing.Size(64, 24);
            this.labelTS45.TabIndex = 80;
            this.labelTS45.Text = "3D x offset:";
            // 
            // number3DY
            // 
            this.number3DY.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.number3DY.Location = new System.Drawing.Point(77, 243);
            this.number3DY.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.number3DY.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.number3DY.Name = "number3DY";
            this.number3DY.Size = new System.Drawing.Size(40, 20);
            this.number3DY.TabIndex = 88;
            this.toolTip1.SetToolTip(this.number3DY, "3D y offset");
            this.number3DY.Value = new decimal(new int[] {
            4,
            0,
            0,
            0});
            // 
            // number3DX
            // 
            this.number3DX.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.number3DX.Location = new System.Drawing.Point(77, 217);
            this.number3DX.Maximum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.number3DX.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.number3DX.Name = "number3DX";
            this.number3DX.Size = new System.Drawing.Size(40, 20);
            this.number3DX.TabIndex = 87;
            this.toolTip1.SetToolTip(this.number3DX, "3D x offset");
            this.number3DX.Value = new decimal(new int[] {
            2,
            0,
            0,
            0});
            // 
            // groupBoxTS3
            // 
            this.groupBoxTS3.Controls.Add(this.chkBoxConsoleRing);
            this.groupBoxTS3.Controls.Add(this.chkBoxTitle);
            this.groupBoxTS3.Controls.Add(this.chkBoxMax);
            this.groupBoxTS3.Location = new System.Drawing.Point(296, 167);
            this.groupBoxTS3.Name = "groupBoxTS3";
            this.groupBoxTS3.Size = new System.Drawing.Size(269, 148);
            this.groupBoxTS3.TabIndex = 76;
            this.groupBoxTS3.TabStop = false;
            this.groupBoxTS3.Text = "PowerSDR Console";
            // 
            // chkBoxConsoleRing
            // 
            this.chkBoxConsoleRing.AllowDrop = true;
            this.chkBoxConsoleRing.Enabled = false;
            this.chkBoxConsoleRing.Image = null;
            this.chkBoxConsoleRing.Location = new System.Drawing.Point(21, 41);
            this.chkBoxConsoleRing.Name = "chkBoxConsoleRing";
            this.chkBoxConsoleRing.Size = new System.Drawing.Size(213, 18);
            this.chkBoxConsoleRing.TabIndex = 88;
            this.chkBoxConsoleRing.Text = "Console Ring (when Title Bar is OFF)";
            this.toolTip1.SetToolTip(this.chkBoxConsoleRing, "\r\n");
            this.chkBoxConsoleRing.Click += new System.EventHandler(this.chkBoxConsoleRing_Click);
            // 
            // chkBoxTitle
            // 
            this.chkBoxTitle.AllowDrop = true;
            this.chkBoxTitle.Image = null;
            this.chkBoxTitle.Location = new System.Drawing.Point(6, 19);
            this.chkBoxTitle.Name = "chkBoxTitle";
            this.chkBoxTitle.Size = new System.Drawing.Size(184, 18);
            this.chkBoxTitle.TabIndex = 87;
            this.chkBoxTitle.Text = "Console (Top) Title Bar OFF";
            this.toolTip1.SetToolTip(this.chkBoxTitle, "Toggle ON/OFF the PowerSDR Console Title Bar (top line of console)\r\n");
            this.chkBoxTitle.CheckedChanged += new System.EventHandler(this.chkBoxTitle_CheckedChanged_1);
            // 
            // chkBoxMax
            // 
            this.chkBoxMax.AllowDrop = true;
            this.chkBoxMax.Image = null;
            this.chkBoxMax.Location = new System.Drawing.Point(6, 65);
            this.chkBoxMax.Name = "chkBoxMax";
            this.chkBoxMax.Size = new System.Drawing.Size(152, 18);
            this.chkBoxMax.TabIndex = 89;
            this.chkBoxMax.Text = "Console Maximize";
            this.toolTip1.SetToolTip(this.chkBoxMax, "Maximize the console screen when CHECKED\r\nThis disables the Windows Tray at the b" +
        "ottom of the screen.\r\n\r\nNormal size when UNCHECKED.\r\n");
            this.chkBoxMax.CheckedChanged += new System.EventHandler(this.chkBoxMax_CheckedChanged);
            // 
            // btnSkinExport
            // 
            this.btnSkinExport.Image = null;
            this.btnSkinExport.Location = new System.Drawing.Point(16, 65);
            this.btnSkinExport.Name = "btnSkinExport";
            this.btnSkinExport.Size = new System.Drawing.Size(51, 23);
            this.btnSkinExport.TabIndex = 86;
            this.btnSkinExport.Text = "Export";
            this.btnSkinExport.UseVisualStyleBackColor = true;
            this.btnSkinExport.Visible = false;
            this.btnSkinExport.Click += new System.EventHandler(this.btnSkinExport_Click);
            // 
            // grpAppSkins
            // 
            this.grpAppSkins.Controls.Add(this.comboAppSkin);
            this.grpAppSkins.Location = new System.Drawing.Point(10, 8);
            this.grpAppSkins.Name = "grpAppSkins";
            this.grpAppSkins.Size = new System.Drawing.Size(128, 48);
            this.grpAppSkins.TabIndex = 85;
            this.grpAppSkins.TabStop = false;
            this.grpAppSkins.Text = "Skins";
            // 
            // comboAppSkin
            // 
            this.comboAppSkin.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboAppSkin.FormattingEnabled = true;
            this.comboAppSkin.Location = new System.Drawing.Point(6, 19);
            this.comboAppSkin.Name = "comboAppSkin";
            this.comboAppSkin.Size = new System.Drawing.Size(116, 21);
            this.comboAppSkin.TabIndex = 0;
            this.comboAppSkin.SelectedIndexChanged += new System.EventHandler(this.comboAppSkin_SelectedIndexChanged);
            this.comboAppSkin.MouseDown += new System.Windows.Forms.MouseEventHandler(this.comboAppSkin_MouseDown);
            // 
            // lblGenBackground
            // 
            this.lblGenBackground.Image = null;
            this.lblGenBackground.Location = new System.Drawing.Point(16, 136);
            this.lblGenBackground.Name = "lblGenBackground";
            this.lblGenBackground.Size = new System.Drawing.Size(72, 32);
            this.lblGenBackground.TabIndex = 84;
            this.lblGenBackground.Text = "Overall Background:";
            this.lblGenBackground.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.lblGenBackground.Visible = false;
            // 
            // clrbtnGenBackground
            // 
            this.clrbtnGenBackground.Automatic = "Automatic";
            this.clrbtnGenBackground.Color = System.Drawing.SystemColors.ControlDark;
            this.clrbtnGenBackground.Image = null;
            this.clrbtnGenBackground.Location = new System.Drawing.Point(88, 136);
            this.clrbtnGenBackground.MoreColors = "More Colors...";
            this.clrbtnGenBackground.Name = "clrbtnGenBackground";
            this.clrbtnGenBackground.Size = new System.Drawing.Size(40, 23);
            this.clrbtnGenBackground.TabIndex = 83;
            this.clrbtnGenBackground.Visible = false;
            this.clrbtnGenBackground.Changed += new System.EventHandler(this.clrbtnGenBackground_Changed);
            // 
            // grpAppearanceBand
            // 
            this.grpAppearanceBand.Controls.Add(this.clrbtnBandBackground);
            this.grpAppearanceBand.Controls.Add(this.lblBandBackground);
            this.grpAppearanceBand.Controls.Add(this.clrbtnBandLight);
            this.grpAppearanceBand.Controls.Add(this.clrbtnBandDark);
            this.grpAppearanceBand.Controls.Add(this.lblBandLight);
            this.grpAppearanceBand.Controls.Add(this.lblBandDark);
            this.grpAppearanceBand.Controls.Add(this.clrbtnOutOfBand);
            this.grpAppearanceBand.Controls.Add(this.lblOutOfBand);
            this.grpAppearanceBand.Location = new System.Drawing.Point(296, 8);
            this.grpAppearanceBand.Name = "grpAppearanceBand";
            this.grpAppearanceBand.Size = new System.Drawing.Size(144, 152);
            this.grpAppearanceBand.TabIndex = 74;
            this.grpAppearanceBand.TabStop = false;
            this.grpAppearanceBand.Text = "Band Data";
            // 
            // clrbtnBandBackground
            // 
            this.clrbtnBandBackground.Automatic = "Automatic";
            this.clrbtnBandBackground.Color = System.Drawing.Color.Black;
            this.clrbtnBandBackground.Image = null;
            this.clrbtnBandBackground.Location = new System.Drawing.Point(88, 120);
            this.clrbtnBandBackground.MoreColors = "More Colors...";
            this.clrbtnBandBackground.Name = "clrbtnBandBackground";
            this.clrbtnBandBackground.Size = new System.Drawing.Size(40, 23);
            this.clrbtnBandBackground.TabIndex = 75;
            this.clrbtnBandBackground.Changed += new System.EventHandler(this.clrbtnBandBackground_Changed);
            // 
            // lblBandBackground
            // 
            this.lblBandBackground.Image = null;
            this.lblBandBackground.Location = new System.Drawing.Point(16, 120);
            this.lblBandBackground.Name = "lblBandBackground";
            this.lblBandBackground.Size = new System.Drawing.Size(72, 24);
            this.lblBandBackground.TabIndex = 74;
            this.lblBandBackground.Text = "Background:";
            // 
            // clrbtnBandLight
            // 
            this.clrbtnBandLight.Automatic = "Automatic";
            this.clrbtnBandLight.Color = System.Drawing.Color.Lime;
            this.clrbtnBandLight.Image = null;
            this.clrbtnBandLight.Location = new System.Drawing.Point(88, 56);
            this.clrbtnBandLight.MoreColors = "More Colors...";
            this.clrbtnBandLight.Name = "clrbtnBandLight";
            this.clrbtnBandLight.Size = new System.Drawing.Size(40, 23);
            this.clrbtnBandLight.TabIndex = 70;
            this.clrbtnBandLight.Changed += new System.EventHandler(this.clrbtnBandLight_Changed);
            // 
            // clrbtnBandDark
            // 
            this.clrbtnBandDark.Automatic = "Automatic";
            this.clrbtnBandDark.Color = System.Drawing.Color.Green;
            this.clrbtnBandDark.Image = null;
            this.clrbtnBandDark.Location = new System.Drawing.Point(88, 24);
            this.clrbtnBandDark.MoreColors = "More Colors...";
            this.clrbtnBandDark.Name = "clrbtnBandDark";
            this.clrbtnBandDark.Size = new System.Drawing.Size(40, 23);
            this.clrbtnBandDark.TabIndex = 69;
            this.clrbtnBandDark.Changed += new System.EventHandler(this.clrbtnBandDark_Changed);
            // 
            // lblBandLight
            // 
            this.lblBandLight.Image = null;
            this.lblBandLight.Location = new System.Drawing.Point(16, 56);
            this.lblBandLight.Name = "lblBandLight";
            this.lblBandLight.Size = new System.Drawing.Size(64, 24);
            this.lblBandLight.TabIndex = 63;
            this.lblBandLight.Text = "Active:";
            // 
            // lblBandDark
            // 
            this.lblBandDark.Image = null;
            this.lblBandDark.Location = new System.Drawing.Point(16, 24);
            this.lblBandDark.Name = "lblBandDark";
            this.lblBandDark.Size = new System.Drawing.Size(64, 24);
            this.lblBandDark.TabIndex = 61;
            this.lblBandDark.Text = "Inactive:";
            // 
            // clrbtnOutOfBand
            // 
            this.clrbtnOutOfBand.Automatic = "Automatic";
            this.clrbtnOutOfBand.Color = System.Drawing.Color.DimGray;
            this.clrbtnOutOfBand.Image = null;
            this.clrbtnOutOfBand.Location = new System.Drawing.Point(88, 88);
            this.clrbtnOutOfBand.MoreColors = "More Colors...";
            this.clrbtnOutOfBand.Name = "clrbtnOutOfBand";
            this.clrbtnOutOfBand.Size = new System.Drawing.Size(40, 23);
            this.clrbtnOutOfBand.TabIndex = 73;
            this.clrbtnOutOfBand.Changed += new System.EventHandler(this.clrbtnOutOfBand_Changed);
            // 
            // lblOutOfBand
            // 
            this.lblOutOfBand.Image = null;
            this.lblOutOfBand.Location = new System.Drawing.Point(16, 88);
            this.lblOutOfBand.Name = "lblOutOfBand";
            this.lblOutOfBand.Size = new System.Drawing.Size(72, 24);
            this.lblOutOfBand.TabIndex = 72;
            this.lblOutOfBand.Text = "Out Of Band:";
            // 
            // grpAppearanceVFO
            // 
            this.grpAppearanceVFO.Controls.Add(this.chkVFOLargeWindow);
            this.grpAppearanceVFO.Controls.Add(this.chkVFOOpenFont);
            this.grpAppearanceVFO.Controls.Add(this.chkVFOBoldFont);
            this.grpAppearanceVFO.Controls.Add(this.labelTS24);
            this.grpAppearanceVFO.Controls.Add(this.clrbtnVFORing);
            this.grpAppearanceVFO.Controls.Add(this.clrbtnVFOBackground);
            this.grpAppearanceVFO.Controls.Add(this.lblVFOBackground);
            this.grpAppearanceVFO.Controls.Add(this.clrbtnVFOSmallColor);
            this.grpAppearanceVFO.Controls.Add(this.lblVFOSmallColor);
            this.grpAppearanceVFO.Controls.Add(this.chkVFOSmallLSD);
            this.grpAppearanceVFO.Controls.Add(this.clrbtnVFOLight);
            this.grpAppearanceVFO.Controls.Add(this.clrbtnVFODark);
            this.grpAppearanceVFO.Controls.Add(this.lblVFOPowerOn);
            this.grpAppearanceVFO.Controls.Add(this.lblVFOPowerOff);
            this.grpAppearanceVFO.Location = new System.Drawing.Point(144, 8);
            this.grpAppearanceVFO.Name = "grpAppearanceVFO";
            this.grpAppearanceVFO.Size = new System.Drawing.Size(144, 307);
            this.grpAppearanceVFO.TabIndex = 39;
            this.grpAppearanceVFO.TabStop = false;
            this.grpAppearanceVFO.Text = "VFO";
            // 
            // chkVFOLargeWindow
            // 
            this.chkVFOLargeWindow.Image = null;
            this.chkVFOLargeWindow.Location = new System.Drawing.Point(9, 136);
            this.chkVFOLargeWindow.Name = "chkVFOLargeWindow";
            this.chkVFOLargeWindow.Size = new System.Drawing.Size(129, 24);
            this.chkVFOLargeWindow.TabIndex = 80;
            this.chkVFOLargeWindow.Text = "Larger VFO window";
            this.toolTip1.SetToolTip(this.chkVFOLargeWindow, "Check when VFO freq is above 10 ghz and above to show extra digits");
            this.chkVFOLargeWindow.CheckedChanged += new System.EventHandler(this.chkVFOLargeWindow_CheckedChanged);
            // 
            // chkVFOOpenFont
            // 
            this.chkVFOOpenFont.Image = null;
            this.chkVFOOpenFont.Location = new System.Drawing.Point(9, 112);
            this.chkVFOOpenFont.Name = "chkVFOOpenFont";
            this.chkVFOOpenFont.Size = new System.Drawing.Size(90, 24);
            this.chkVFOOpenFont.TabIndex = 79;
            this.chkVFOOpenFont.Text = "Outline Font";
            this.toolTip1.SetToolTip(this.chkVFOOpenFont, "Check Bold and Outline boxes to change to Bold Outline Font");
            this.chkVFOOpenFont.CheckedChanged += new System.EventHandler(this.chkVFOOpenFont_CheckedChanged);
            // 
            // chkVFOBoldFont
            // 
            this.chkVFOBoldFont.Checked = true;
            this.chkVFOBoldFont.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkVFOBoldFont.Image = null;
            this.chkVFOBoldFont.Location = new System.Drawing.Point(9, 87);
            this.chkVFOBoldFont.Name = "chkVFOBoldFont";
            this.chkVFOBoldFont.Size = new System.Drawing.Size(104, 24);
            this.chkVFOBoldFont.TabIndex = 78;
            this.chkVFOBoldFont.Text = "Bold Font VFO\r\n";
            this.toolTip1.SetToolTip(this.chkVFOBoldFont, "Check box to use Bold/Italic Font for VFO");
            this.chkVFOBoldFont.CheckedChanged += new System.EventHandler(this.chkVFOBoldFont_CheckedChanged);
            // 
            // labelTS24
            // 
            this.labelTS24.Image = null;
            this.labelTS24.Location = new System.Drawing.Point(16, 267);
            this.labelTS24.Name = "labelTS24";
            this.labelTS24.Size = new System.Drawing.Size(72, 24);
            this.labelTS24.TabIndex = 77;
            this.labelTS24.Text = "Ring Color:";
            this.toolTip1.SetToolTip(this.labelTS24, "Color Around VFOA/B and Meters");
            // 
            // clrbtnVFORing
            // 
            this.clrbtnVFORing.Automatic = "Automatic";
            this.clrbtnVFORing.Color = System.Drawing.Color.DarkGreen;
            this.clrbtnVFORing.Image = null;
            this.clrbtnVFORing.Location = new System.Drawing.Point(88, 262);
            this.clrbtnVFORing.MoreColors = "More Colors...";
            this.clrbtnVFORing.Name = "clrbtnVFORing";
            this.clrbtnVFORing.Size = new System.Drawing.Size(40, 23);
            this.clrbtnVFORing.TabIndex = 76;
            this.toolTip1.SetToolTip(this.clrbtnVFORing, "Color Around VFOA/B and Meters");
            this.clrbtnVFORing.Changed += new System.EventHandler(this.clrbtnVFORing_Changed);
            // 
            // clrbtnVFOBackground
            // 
            this.clrbtnVFOBackground.Automatic = "Automatic";
            this.clrbtnVFOBackground.Color = System.Drawing.Color.Black;
            this.clrbtnVFOBackground.Image = null;
            this.clrbtnVFOBackground.Location = new System.Drawing.Point(88, 173);
            this.clrbtnVFOBackground.MoreColors = "More Colors...";
            this.clrbtnVFOBackground.Name = "clrbtnVFOBackground";
            this.clrbtnVFOBackground.Size = new System.Drawing.Size(40, 23);
            this.clrbtnVFOBackground.TabIndex = 73;
            this.clrbtnVFOBackground.Changed += new System.EventHandler(this.clrbtnVFOBackground_Changed);
            // 
            // lblVFOBackground
            // 
            this.lblVFOBackground.Image = null;
            this.lblVFOBackground.Location = new System.Drawing.Point(13, 178);
            this.lblVFOBackground.Name = "lblVFOBackground";
            this.lblVFOBackground.Size = new System.Drawing.Size(72, 24);
            this.lblVFOBackground.TabIndex = 72;
            this.lblVFOBackground.Text = "Background:";
            // 
            // clrbtnVFOSmallColor
            // 
            this.clrbtnVFOSmallColor.Automatic = "Automatic";
            this.clrbtnVFOSmallColor.Color = System.Drawing.Color.OrangeRed;
            this.clrbtnVFOSmallColor.Image = null;
            this.clrbtnVFOSmallColor.Location = new System.Drawing.Point(88, 232);
            this.clrbtnVFOSmallColor.MoreColors = "More Colors...";
            this.clrbtnVFOSmallColor.Name = "clrbtnVFOSmallColor";
            this.clrbtnVFOSmallColor.Size = new System.Drawing.Size(40, 23);
            this.clrbtnVFOSmallColor.TabIndex = 71;
            this.clrbtnVFOSmallColor.Changed += new System.EventHandler(this.clrbtnVFOSmallColor_Changed);
            // 
            // lblVFOSmallColor
            // 
            this.lblVFOSmallColor.Image = null;
            this.lblVFOSmallColor.Location = new System.Drawing.Point(16, 237);
            this.lblVFOSmallColor.Name = "lblVFOSmallColor";
            this.lblVFOSmallColor.Size = new System.Drawing.Size(72, 24);
            this.lblVFOSmallColor.TabIndex = 70;
            this.lblVFOSmallColor.Text = "Small Color:";
            // 
            // chkVFOSmallLSD
            // 
            this.chkVFOSmallLSD.Checked = true;
            this.chkVFOSmallLSD.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkVFOSmallLSD.Image = null;
            this.chkVFOSmallLSD.Location = new System.Drawing.Point(9, 200);
            this.chkVFOSmallLSD.Name = "chkVFOSmallLSD";
            this.chkVFOSmallLSD.Size = new System.Drawing.Size(104, 24);
            this.chkVFOSmallLSD.TabIndex = 69;
            this.chkVFOSmallLSD.Text = "Small 3 Digits";
            this.chkVFOSmallLSD.CheckedChanged += new System.EventHandler(this.chkVFOSmallLSD_CheckedChanged);
            // 
            // clrbtnVFOLight
            // 
            this.clrbtnVFOLight.Automatic = "Automatic";
            this.clrbtnVFOLight.Color = System.Drawing.Color.Yellow;
            this.clrbtnVFOLight.Image = null;
            this.clrbtnVFOLight.Location = new System.Drawing.Point(88, 56);
            this.clrbtnVFOLight.MoreColors = "More Colors...";
            this.clrbtnVFOLight.Name = "clrbtnVFOLight";
            this.clrbtnVFOLight.Size = new System.Drawing.Size(40, 23);
            this.clrbtnVFOLight.TabIndex = 68;
            this.clrbtnVFOLight.Changed += new System.EventHandler(this.clrbtnVFOLight_Changed);
            // 
            // clrbtnVFODark
            // 
            this.clrbtnVFODark.Automatic = "Automatic";
            this.clrbtnVFODark.Color = System.Drawing.Color.Olive;
            this.clrbtnVFODark.Image = null;
            this.clrbtnVFODark.Location = new System.Drawing.Point(88, 24);
            this.clrbtnVFODark.MoreColors = "More Colors...";
            this.clrbtnVFODark.Name = "clrbtnVFODark";
            this.clrbtnVFODark.Size = new System.Drawing.Size(40, 23);
            this.clrbtnVFODark.TabIndex = 67;
            this.clrbtnVFODark.Changed += new System.EventHandler(this.clrbtnVFODark_Changed);
            // 
            // lblVFOPowerOn
            // 
            this.lblVFOPowerOn.Image = null;
            this.lblVFOPowerOn.Location = new System.Drawing.Point(16, 56);
            this.lblVFOPowerOn.Name = "lblVFOPowerOn";
            this.lblVFOPowerOn.Size = new System.Drawing.Size(64, 24);
            this.lblVFOPowerOn.TabIndex = 59;
            this.lblVFOPowerOn.Text = "Active:";
            // 
            // lblVFOPowerOff
            // 
            this.lblVFOPowerOff.Image = null;
            this.lblVFOPowerOff.Location = new System.Drawing.Point(16, 24);
            this.lblVFOPowerOff.Name = "lblVFOPowerOff";
            this.lblVFOPowerOff.Size = new System.Drawing.Size(64, 24);
            this.lblVFOPowerOff.TabIndex = 57;
            this.lblVFOPowerOff.Text = "Inactive:";
            // 
            // clrbtnBtnSel
            // 
            this.clrbtnBtnSel.Automatic = "Automatic";
            this.clrbtnBtnSel.Color = System.Drawing.Color.Yellow;
            this.clrbtnBtnSel.Image = null;
            this.clrbtnBtnSel.Location = new System.Drawing.Point(88, 101);
            this.clrbtnBtnSel.MoreColors = "More Colors...";
            this.clrbtnBtnSel.Name = "clrbtnBtnSel";
            this.clrbtnBtnSel.Size = new System.Drawing.Size(40, 23);
            this.clrbtnBtnSel.TabIndex = 66;
            this.clrbtnBtnSel.Changed += new System.EventHandler(this.clrbtnBtnSel_Changed);
            // 
            // lblAppearanceGenBtnSel
            // 
            this.lblAppearanceGenBtnSel.Image = null;
            this.lblAppearanceGenBtnSel.Location = new System.Drawing.Point(16, 101);
            this.lblAppearanceGenBtnSel.Name = "lblAppearanceGenBtnSel";
            this.lblAppearanceGenBtnSel.Size = new System.Drawing.Size(64, 32);
            this.lblAppearanceGenBtnSel.TabIndex = 55;
            this.lblAppearanceGenBtnSel.Text = "Button Selected:";
            // 
            // tpAppearanceDisplay
            // 
            this.tpAppearanceDisplay.BackColor = System.Drawing.SystemColors.Control;
            this.tpAppearanceDisplay.Controls.Add(this.grpMainDisplay);
            this.tpAppearanceDisplay.Controls.Add(this.grpAppPanadapter);
            this.tpAppearanceDisplay.Controls.Add(this.grpDisplayPeakCursor);
            this.tpAppearanceDisplay.Location = new System.Drawing.Point(4, 22);
            this.tpAppearanceDisplay.Name = "tpAppearanceDisplay";
            this.tpAppearanceDisplay.Size = new System.Drawing.Size(592, 318);
            this.tpAppearanceDisplay.TabIndex = 1;
            this.tpAppearanceDisplay.Text = "Display";
            // 
            // grpMainDisplay
            // 
            this.grpMainDisplay.Controls.Add(this.tbPan3DAlpha);
            this.grpMainDisplay.Controls.Add(this.labelTS41);
            this.grpMainDisplay.Controls.Add(this.labelTS40);
            this.grpMainDisplay.Controls.Add(this.clrbtn3DDataLine);
            this.grpMainDisplay.Controls.Add(this.labelTS32);
            this.grpMainDisplay.Controls.Add(this.tbPanGrid);
            this.grpMainDisplay.Controls.Add(this.clrbtnText);
            this.grpMainDisplay.Controls.Add(this.lblDisplayBackgroundColor);
            this.grpMainDisplay.Controls.Add(this.udDisplayLineWidth);
            this.grpMainDisplay.Controls.Add(this.lblDisplayDataLineColor);
            this.grpMainDisplay.Controls.Add(this.lblDisplayTextColor);
            this.grpMainDisplay.Controls.Add(this.lblDisplayLineWidth);
            this.grpMainDisplay.Controls.Add(this.clrbtnBackground);
            this.grpMainDisplay.Controls.Add(this.clrbtnGrid);
            this.grpMainDisplay.Controls.Add(this.lblDisplayZeroLineColor);
            this.grpMainDisplay.Controls.Add(this.clrbtnZeroLine);
            this.grpMainDisplay.Controls.Add(this.lblDisplayGridColor);
            this.grpMainDisplay.Controls.Add(this.clrbtnDataLine);
            this.grpMainDisplay.Location = new System.Drawing.Point(8, 6);
            this.grpMainDisplay.Name = "grpMainDisplay";
            this.grpMainDisplay.Size = new System.Drawing.Size(373, 100);
            this.grpMainDisplay.TabIndex = 78;
            this.grpMainDisplay.TabStop = false;
            this.grpMainDisplay.Text = "Main Display";
            // 
            // tbPan3DAlpha
            // 
            this.tbPan3DAlpha.AutoSize = false;
            this.tbPan3DAlpha.Location = new System.Drawing.Point(60, 74);
            this.tbPan3DAlpha.Maximum = 255;
            this.tbPan3DAlpha.Name = "tbPan3DAlpha";
            this.tbPan3DAlpha.Size = new System.Drawing.Size(66, 18);
            this.tbPan3DAlpha.TabIndex = 101;
            this.tbPan3DAlpha.TickFrequency = 64;
            this.toolTip1.SetToolTip(this.tbPan3DAlpha, "Transparency of 3D Panadapter area for RX1 and RX2\r\n");
            this.tbPan3DAlpha.Value = 150;
            this.tbPan3DAlpha.Scroll += new System.EventHandler(this.tbPan3DAlpha_Scroll);
            // 
            // labelTS41
            // 
            this.labelTS41.Image = null;
            this.labelTS41.Location = new System.Drawing.Point(8, 69);
            this.labelTS41.Name = "labelTS41";
            this.labelTS41.Size = new System.Drawing.Size(64, 18);
            this.labelTS41.TabIndex = 101;
            this.labelTS41.Text = "3DAlpha:";
            // 
            // labelTS40
            // 
            this.labelTS40.Image = null;
            this.labelTS40.Location = new System.Drawing.Point(132, 69);
            this.labelTS40.Name = "labelTS40";
            this.labelTS40.Size = new System.Drawing.Size(62, 36);
            this.labelTS40.TabIndex = 98;
            this.labelTS40.Text = "3DPan Data Line:";
            // 
            // clrbtn3DDataLine
            // 
            this.clrbtn3DDataLine.Automatic = "Automatic";
            this.clrbtn3DDataLine.Color = System.Drawing.Color.Aquamarine;
            this.clrbtn3DDataLine.Image = null;
            this.clrbtn3DDataLine.Location = new System.Drawing.Point(200, 73);
            this.clrbtn3DDataLine.MoreColors = "More Colors...";
            this.clrbtn3DDataLine.Name = "clrbtn3DDataLine";
            this.clrbtn3DDataLine.Size = new System.Drawing.Size(40, 23);
            this.clrbtn3DDataLine.TabIndex = 97;
            this.toolTip1.SetToolTip(this.clrbtn3DDataLine, "3D Pan Data line Color for RX1 and RX2");
            this.clrbtn3DDataLine.Changed += new System.EventHandler(this.clrbtn3DDataLine_Changed);
            // 
            // labelTS32
            // 
            this.labelTS32.Image = null;
            this.labelTS32.Location = new System.Drawing.Point(250, 37);
            this.labelTS32.Name = "labelTS32";
            this.labelTS32.Size = new System.Drawing.Size(50, 26);
            this.labelTS32.TabIndex = 96;
            this.labelTS32.Text = "Fill Alpha:";
            this.toolTip1.SetToolTip(this.labelTS32, "Related to BandText\r\n\r\nRight Click on VFOA Band Text to Toggle ON/OFF Band Text a" +
        "t top\r\nof Panadapter screen.\r\n");
            // 
            // tbPanGrid
            // 
            this.tbPanGrid.AutoSize = false;
            this.tbPanGrid.Location = new System.Drawing.Point(301, 41);
            this.tbPanGrid.Maximum = 200;
            this.tbPanGrid.Name = "tbPanGrid";
            this.tbPanGrid.Size = new System.Drawing.Size(66, 18);
            this.tbPanGrid.TabIndex = 96;
            this.tbPanGrid.TickFrequency = 50;
            this.toolTip1.SetToolTip(this.tbPanGrid, "Transparency of BandText fill area \r\n\r\nRight Click on VFOA Band Text to Toggle ON" +
        "/OFF Band Text at top\r\nof Panadapter screen.\r\n");
            this.tbPanGrid.Value = 130;
            this.tbPanGrid.Scroll += new System.EventHandler(this.tbPanGrid_Scroll);
            // 
            // clrbtnText
            // 
            this.clrbtnText.Automatic = "Automatic";
            this.clrbtnText.Color = System.Drawing.Color.Yellow;
            this.clrbtnText.Image = null;
            this.clrbtnText.Location = new System.Drawing.Point(200, 14);
            this.clrbtnText.MoreColors = "More Colors...";
            this.clrbtnText.Name = "clrbtnText";
            this.clrbtnText.Size = new System.Drawing.Size(40, 23);
            this.clrbtnText.TabIndex = 72;
            this.clrbtnText.Changed += new System.EventHandler(this.clrbtnText_Changed);
            // 
            // lblDisplayBackgroundColor
            // 
            this.lblDisplayBackgroundColor.Image = null;
            this.lblDisplayBackgroundColor.Location = new System.Drawing.Point(8, 21);
            this.lblDisplayBackgroundColor.Name = "lblDisplayBackgroundColor";
            this.lblDisplayBackgroundColor.Size = new System.Drawing.Size(73, 24);
            this.lblDisplayBackgroundColor.TabIndex = 34;
            this.lblDisplayBackgroundColor.Text = "Background:";
            // 
            // udDisplayLineWidth
            // 
            this.udDisplayLineWidth.DecimalPlaces = 1;
            this.udDisplayLineWidth.Increment = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udDisplayLineWidth.Location = new System.Drawing.Point(316, 69);
            this.udDisplayLineWidth.Maximum = new decimal(new int[] {
            50,
            0,
            0,
            65536});
            this.udDisplayLineWidth.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            65536});
            this.udDisplayLineWidth.Name = "udDisplayLineWidth";
            this.udDisplayLineWidth.Size = new System.Drawing.Size(40, 20);
            this.udDisplayLineWidth.TabIndex = 42;
            this.udDisplayLineWidth.Value = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udDisplayLineWidth.ValueChanged += new System.EventHandler(this.udDisplayLineWidth_ValueChanged);
            this.udDisplayLineWidth.LostFocus += new System.EventHandler(this.udDisplayLineWidth_LostFocus);
            // 
            // lblDisplayDataLineColor
            // 
            this.lblDisplayDataLineColor.Image = null;
            this.lblDisplayDataLineColor.Location = new System.Drawing.Point(132, 37);
            this.lblDisplayDataLineColor.Name = "lblDisplayDataLineColor";
            this.lblDisplayDataLineColor.Size = new System.Drawing.Size(62, 36);
            this.lblDisplayDataLineColor.TabIndex = 41;
            this.lblDisplayDataLineColor.Text = "Pan Data Line:";
            // 
            // lblDisplayTextColor
            // 
            this.lblDisplayTextColor.Image = null;
            this.lblDisplayTextColor.Location = new System.Drawing.Point(130, 18);
            this.lblDisplayTextColor.Name = "lblDisplayTextColor";
            this.lblDisplayTextColor.Size = new System.Drawing.Size(64, 24);
            this.lblDisplayTextColor.TabIndex = 39;
            this.lblDisplayTextColor.Text = "Text Color:";
            // 
            // lblDisplayLineWidth
            // 
            this.lblDisplayLineWidth.Image = null;
            this.lblDisplayLineWidth.Location = new System.Drawing.Point(250, 68);
            this.lblDisplayLineWidth.Name = "lblDisplayLineWidth";
            this.lblDisplayLineWidth.Size = new System.Drawing.Size(64, 30);
            this.lblDisplayLineWidth.TabIndex = 43;
            this.lblDisplayLineWidth.Text = "Data Line Width:";
            // 
            // clrbtnBackground
            // 
            this.clrbtnBackground.Automatic = "Automatic";
            this.clrbtnBackground.Color = System.Drawing.Color.Black;
            this.clrbtnBackground.Image = null;
            this.clrbtnBackground.Location = new System.Drawing.Point(80, 16);
            this.clrbtnBackground.MoreColors = "More Colors...";
            this.clrbtnBackground.Name = "clrbtnBackground";
            this.clrbtnBackground.Size = new System.Drawing.Size(40, 23);
            this.clrbtnBackground.TabIndex = 68;
            this.clrbtnBackground.Changed += new System.EventHandler(this.clrbtnBackground_Changed);
            // 
            // clrbtnGrid
            // 
            this.clrbtnGrid.Automatic = "Automatic";
            this.clrbtnGrid.Color = System.Drawing.Color.RoyalBlue;
            this.clrbtnGrid.Image = null;
            this.clrbtnGrid.Location = new System.Drawing.Point(316, 12);
            this.clrbtnGrid.MoreColors = "More Colors...";
            this.clrbtnGrid.Name = "clrbtnGrid";
            this.clrbtnGrid.Size = new System.Drawing.Size(40, 23);
            this.clrbtnGrid.TabIndex = 69;
            this.toolTip1.SetToolTip(this.clrbtnGrid, "Display area Grid Color and BandText color\r\n\r\nRight Click on VFOA Band Text to To" +
        "ggle ON/OFF Band Text at top\r\nof Panadapter screen.\r\n");
            this.clrbtnGrid.Changed += new System.EventHandler(this.clrbtnGrid_Changed);
            // 
            // lblDisplayZeroLineColor
            // 
            this.lblDisplayZeroLineColor.Image = null;
            this.lblDisplayZeroLineColor.Location = new System.Drawing.Point(6, 45);
            this.lblDisplayZeroLineColor.Name = "lblDisplayZeroLineColor";
            this.lblDisplayZeroLineColor.Size = new System.Drawing.Size(72, 24);
            this.lblDisplayZeroLineColor.TabIndex = 36;
            this.lblDisplayZeroLineColor.Text = "Zero Line:";
            // 
            // clrbtnZeroLine
            // 
            this.clrbtnZeroLine.Automatic = "Automatic";
            this.clrbtnZeroLine.Color = System.Drawing.Color.Red;
            this.clrbtnZeroLine.Image = null;
            this.clrbtnZeroLine.Location = new System.Drawing.Point(80, 45);
            this.clrbtnZeroLine.MoreColors = "More Colors...";
            this.clrbtnZeroLine.Name = "clrbtnZeroLine";
            this.clrbtnZeroLine.Size = new System.Drawing.Size(40, 23);
            this.clrbtnZeroLine.TabIndex = 70;
            this.clrbtnZeroLine.Changed += new System.EventHandler(this.clrbtnZeroLine_Changed);
            // 
            // lblDisplayGridColor
            // 
            this.lblDisplayGridColor.Image = null;
            this.lblDisplayGridColor.Location = new System.Drawing.Point(248, 10);
            this.lblDisplayGridColor.Name = "lblDisplayGridColor";
            this.lblDisplayGridColor.Size = new System.Drawing.Size(72, 28);
            this.lblDisplayGridColor.TabIndex = 35;
            this.lblDisplayGridColor.Text = "Panadapter BandText ";
            this.toolTip1.SetToolTip(this.lblDisplayGridColor, "Display area Grid Color and BandText color\r\n\r\nRight Click on VFOA Band Text to To" +
        "ggle ON/OFF Band Text at top\r\nof Panadapter screen.");
            // 
            // clrbtnDataLine
            // 
            this.clrbtnDataLine.Automatic = "Automatic";
            this.clrbtnDataLine.Color = System.Drawing.Color.White;
            this.clrbtnDataLine.Image = null;
            this.clrbtnDataLine.Location = new System.Drawing.Point(200, 43);
            this.clrbtnDataLine.MoreColors = "More Colors...";
            this.clrbtnDataLine.Name = "clrbtnDataLine";
            this.clrbtnDataLine.Size = new System.Drawing.Size(40, 23);
            this.clrbtnDataLine.TabIndex = 73;
            this.toolTip1.SetToolTip(this.clrbtnDataLine, "Pan Data line Color for RX1 and RX2");
            this.clrbtnDataLine.Changed += new System.EventHandler(this.clrbtnDataLine_Changed);
            // 
            // grpAppPanadapter
            // 
            this.grpAppPanadapter.Controls.Add(this.labelTS9);
            this.grpAppPanadapter.Controls.Add(this.chkBoxChannels);
            this.grpAppPanadapter.Controls.Add(this.labelTS37);
            this.grpAppPanadapter.Controls.Add(this.tbMapBright);
            this.grpAppPanadapter.Controls.Add(this.chkBoxPanFillColor);
            this.grpAppPanadapter.Controls.Add(this.labelTS11);
            this.grpAppPanadapter.Controls.Add(this.labelTS10);
            this.grpAppPanadapter.Controls.Add(this.tbPanAlpha);
            this.grpAppPanadapter.Controls.Add(this.clrbtnPan);
            this.grpAppPanadapter.Controls.Add(this.tbGrayLineBright);
            this.grpAppPanadapter.Controls.Add(this.lblBandSegmentBoxLineWidth);
            this.grpAppPanadapter.Controls.Add(this.udBandSegmentBoxLineWidth);
            this.grpAppPanadapter.Controls.Add(this.lblBandSegmentBox);
            this.grpAppPanadapter.Controls.Add(this.clrbtnBandSegmentBox);
            this.grpAppPanadapter.Controls.Add(this.lblMultiRXFilterAlpha);
            this.grpAppPanadapter.Controls.Add(this.chkShowFreqOffset);
            this.grpAppPanadapter.Controls.Add(this.tbMultiRXFilterAlpha);
            this.grpAppPanadapter.Controls.Add(this.clrbtnTXFilter);
            this.grpAppPanadapter.Controls.Add(this.lblRX1FilterAlpha);
            this.grpAppPanadapter.Controls.Add(this.lblTXFilterColor);
            this.grpAppPanadapter.Controls.Add(this.clrbtnSubRXZero);
            this.grpAppPanadapter.Controls.Add(this.tbRX1FilterAlpha);
            this.grpAppPanadapter.Controls.Add(this.lblSubRXZeroLine);
            this.grpAppPanadapter.Controls.Add(this.clrbtnSubRXFilter);
            this.grpAppPanadapter.Controls.Add(this.lblSubRXFilterColor);
            this.grpAppPanadapter.Controls.Add(this.clrbtnBandEdge);
            this.grpAppPanadapter.Controls.Add(this.lblBandEdge);
            this.grpAppPanadapter.Controls.Add(this.lblDisplayFilterColor);
            this.grpAppPanadapter.Controls.Add(this.clrbtnFilter);
            this.grpAppPanadapter.Controls.Add(this.labelTS36);
            this.grpAppPanadapter.Controls.Add(this.labelTS8);
            this.grpAppPanadapter.Location = new System.Drawing.Point(8, 112);
            this.grpAppPanadapter.Name = "grpAppPanadapter";
            this.grpAppPanadapter.Size = new System.Drawing.Size(569, 189);
            this.grpAppPanadapter.TabIndex = 77;
            this.grpAppPanadapter.TabStop = false;
            this.grpAppPanadapter.Text = "Panadapter";
            this.grpAppPanadapter.Enter += new System.EventHandler(this.grpAppPanadapter_Enter);
            // 
            // labelTS9
            // 
            this.labelTS9.Image = null;
            this.labelTS9.Location = new System.Drawing.Point(525, 22);
            this.labelTS9.Name = "labelTS9";
            this.labelTS9.Size = new System.Drawing.Size(38, 18);
            this.labelTS9.TabIndex = 101;
            this.labelTS9.Text = "Bright";
            this.toolTip1.SetToolTip(this.labelTS9, "Grayline Area of Map:  Set the Darkness");
            // 
            // chkBoxChannels
            // 
            this.chkBoxChannels.Checked = true;
            this.chkBoxChannels.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkBoxChannels.Image = null;
            this.chkBoxChannels.Location = new System.Drawing.Point(27, 147);
            this.chkBoxChannels.Name = "chkBoxChannels";
            this.chkBoxChannels.Size = new System.Drawing.Size(213, 32);
            this.chkBoxChannels.TabIndex = 100;
            this.chkBoxChannels.Text = "Channel Display ON for 60m and 11m";
            this.toolTip1.SetToolTip(this.chkBoxChannels, "Check to show Channels (in Blue. Dark Blue when inside Channel).\r\n60m Channels 1-" +
        "5 (for USA only)\r\n11m Channels 1-40");
            // 
            // labelTS37
            // 
            this.labelTS37.Image = null;
            this.labelTS37.Location = new System.Drawing.Point(527, 56);
            this.labelTS37.Name = "labelTS37";
            this.labelTS37.Size = new System.Drawing.Size(49, 18);
            this.labelTS37.TabIndex = 99;
            this.labelTS37.Text = "Bright";
            this.toolTip1.SetToolTip(this.labelTS37, "Daylight Area of Map:  Brightness");
            // 
            // tbMapBright
            // 
            this.tbMapBright.AutoSize = false;
            this.tbMapBright.LargeChange = 1;
            this.tbMapBright.Location = new System.Drawing.Point(457, 56);
            this.tbMapBright.Maximum = 70;
            this.tbMapBright.Minimum = -50;
            this.tbMapBright.Name = "tbMapBright";
            this.tbMapBright.Size = new System.Drawing.Size(66, 18);
            this.tbMapBright.TabIndex = 97;
            this.tbMapBright.TickFrequency = 10;
            this.toolTip1.SetToolTip(this.tbMapBright, "Daylight Area of Map:  Brightness");
            this.tbMapBright.ValueChanged += new System.EventHandler(this.tbMapBright_ValueChanged);
            // 
            // chkBoxPanFillColor
            // 
            this.chkBoxPanFillColor.Image = null;
            this.chkBoxPanFillColor.Location = new System.Drawing.Point(432, 151);
            this.chkBoxPanFillColor.Name = "chkBoxPanFillColor";
            this.chkBoxPanFillColor.Size = new System.Drawing.Size(70, 32);
            this.chkBoxPanFillColor.TabIndex = 96;
            this.chkBoxPanFillColor.Text = "Pan Fill Gradient";
            this.toolTip1.SetToolTip(this.chkBoxPanFillColor, "Check to show Color gradient under Panadapter Spectrum line.\r\nColor related to si" +
        "gnal strength (BLUE = LOW, VIOLET = HIGH)");
            this.chkBoxPanFillColor.CheckedChanged += new System.EventHandler(this.chkBoxPanFillColor_CheckedChanged);
            // 
            // labelTS11
            // 
            this.labelTS11.Image = null;
            this.labelTS11.Location = new System.Drawing.Point(376, 93);
            this.labelTS11.Name = "labelTS11";
            this.labelTS11.Size = new System.Drawing.Size(64, 28);
            this.labelTS11.TabIndex = 95;
            this.labelTS11.Text = "Pan Fill Color:\r\n";
            // 
            // labelTS10
            // 
            this.labelTS10.Image = null;
            this.labelTS10.Location = new System.Drawing.Point(376, 123);
            this.labelTS10.Name = "labelTS10";
            this.labelTS10.Size = new System.Drawing.Size(50, 31);
            this.labelTS10.TabIndex = 94;
            this.labelTS10.Text = "Fill Alpha:";
            // 
            // tbPanAlpha
            // 
            this.tbPanAlpha.AutoSize = false;
            this.tbPanAlpha.Location = new System.Drawing.Point(432, 127);
            this.tbPanAlpha.Maximum = 200;
            this.tbPanAlpha.Name = "tbPanAlpha";
            this.tbPanAlpha.Size = new System.Drawing.Size(66, 18);
            this.tbPanAlpha.TabIndex = 93;
            this.tbPanAlpha.TickFrequency = 50;
            this.toolTip1.SetToolTip(this.tbPanAlpha, "Transparency of Panadapter Fill (if turned on)");
            this.tbPanAlpha.Value = 70;
            this.tbPanAlpha.Scroll += new System.EventHandler(this.tbPanAlpha_Scroll);
            // 
            // clrbtnPan
            // 
            this.clrbtnPan.Automatic = "Automatic";
            this.clrbtnPan.Color = System.Drawing.Color.White;
            this.clrbtnPan.Image = null;
            this.clrbtnPan.Location = new System.Drawing.Point(453, 93);
            this.clrbtnPan.MoreColors = "More Colors...";
            this.clrbtnPan.Name = "clrbtnPan";
            this.clrbtnPan.Size = new System.Drawing.Size(40, 23);
            this.clrbtnPan.TabIndex = 92;
            this.toolTip1.SetToolTip(this.clrbtnPan, "Panadapter line fill color for RX1 and RX2");
            this.clrbtnPan.Changed += new System.EventHandler(this.clrbtnPan_Changed);
            // 
            // tbGrayLineBright
            // 
            this.tbGrayLineBright.AutoSize = false;
            this.tbGrayLineBright.LargeChange = 1;
            this.tbGrayLineBright.Location = new System.Drawing.Point(457, 24);
            this.tbGrayLineBright.Maximum = 40;
            this.tbGrayLineBright.Minimum = -30;
            this.tbGrayLineBright.Name = "tbGrayLineBright";
            this.tbGrayLineBright.Size = new System.Drawing.Size(66, 18);
            this.tbGrayLineBright.TabIndex = 91;
            this.tbGrayLineBright.TickFrequency = 10;
            this.toolTip1.SetToolTip(this.tbGrayLineBright, "Grayline Area of Map:  Set the Darkness");
            this.tbGrayLineBright.Value = -10;
            this.tbGrayLineBright.ValueChanged += new System.EventHandler(this.tbGrayLineAlpha_ValueChanged);
            // 
            // lblBandSegmentBoxLineWidth
            // 
            this.lblBandSegmentBoxLineWidth.Image = null;
            this.lblBandSegmentBoxLineWidth.Location = new System.Drawing.Point(228, 107);
            this.lblBandSegmentBoxLineWidth.Name = "lblBandSegmentBoxLineWidth";
            this.lblBandSegmentBoxLineWidth.Size = new System.Drawing.Size(84, 34);
            this.lblBandSegmentBoxLineWidth.TabIndex = 87;
            this.lblBandSegmentBoxLineWidth.Text = "Band Segment Box Line Width:";
            // 
            // udBandSegmentBoxLineWidth
            // 
            this.udBandSegmentBoxLineWidth.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.udBandSegmentBoxLineWidth.DecimalPlaces = 1;
            this.udBandSegmentBoxLineWidth.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udBandSegmentBoxLineWidth.Location = new System.Drawing.Point(316, 110);
            this.udBandSegmentBoxLineWidth.Maximum = new decimal(new int[] {
            50,
            0,
            0,
            65536});
            this.udBandSegmentBoxLineWidth.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udBandSegmentBoxLineWidth.Name = "udBandSegmentBoxLineWidth";
            this.udBandSegmentBoxLineWidth.Size = new System.Drawing.Size(40, 20);
            this.udBandSegmentBoxLineWidth.TabIndex = 86;
            this.udBandSegmentBoxLineWidth.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udBandSegmentBoxLineWidth.ValueChanged += new System.EventHandler(this.udBandSegmentBoxLineWidth_ValueChanged);
            this.udBandSegmentBoxLineWidth.LostFocus += new System.EventHandler(this.udBandSegmentBoxLineWidth_LostFocus);
            // 
            // lblBandSegmentBox
            // 
            this.lblBandSegmentBox.Image = null;
            this.lblBandSegmentBox.Location = new System.Drawing.Point(256, 57);
            this.lblBandSegmentBox.Name = "lblBandSegmentBox";
            this.lblBandSegmentBox.Size = new System.Drawing.Size(56, 40);
            this.lblBandSegmentBox.TabIndex = 85;
            this.lblBandSegmentBox.Text = "Band Segment Box Color:";
            // 
            // clrbtnBandSegmentBox
            // 
            this.clrbtnBandSegmentBox.Automatic = "Automatic";
            this.clrbtnBandSegmentBox.Color = System.Drawing.Color.Lime;
            this.clrbtnBandSegmentBox.Image = null;
            this.clrbtnBandSegmentBox.Location = new System.Drawing.Point(316, 65);
            this.clrbtnBandSegmentBox.MoreColors = "More Colors...";
            this.clrbtnBandSegmentBox.Name = "clrbtnBandSegmentBox";
            this.clrbtnBandSegmentBox.Size = new System.Drawing.Size(40, 23);
            this.clrbtnBandSegmentBox.TabIndex = 84;
            this.toolTip1.SetToolTip(this.clrbtnBandSegmentBox, "Changes the color of Band Segment boxes");
            this.clrbtnBandSegmentBox.Changed += new System.EventHandler(this.clrbtnBandSegmentBox_Changed);
            // 
            // lblMultiRXFilterAlpha
            // 
            this.lblMultiRXFilterAlpha.Image = null;
            this.lblMultiRXFilterAlpha.Location = new System.Drawing.Point(9, 120);
            this.lblMultiRXFilterAlpha.Name = "lblMultiRXFilterAlpha";
            this.lblMultiRXFilterAlpha.Size = new System.Drawing.Size(40, 18);
            this.lblMultiRXFilterAlpha.TabIndex = 83;
            this.lblMultiRXFilterAlpha.Text = "Alpha:";
            // 
            // chkShowFreqOffset
            // 
            this.chkShowFreqOffset.Image = null;
            this.chkShowFreqOffset.Location = new System.Drawing.Point(135, 105);
            this.chkShowFreqOffset.Name = "chkShowFreqOffset";
            this.chkShowFreqOffset.Size = new System.Drawing.Size(87, 32);
            this.chkShowFreqOffset.TabIndex = 77;
            this.chkShowFreqOffset.Text = "Show Freq Offset";
            this.toolTip1.SetToolTip(this.chkShowFreqOffset, "Show the frequency offset from the VFO rather than the actual frequency in MHz on" +
        " the display.");
            this.chkShowFreqOffset.CheckedChanged += new System.EventHandler(this.chkShowFreqOffset_CheckedChanged);
            // 
            // tbMultiRXFilterAlpha
            // 
            this.tbMultiRXFilterAlpha.AutoSize = false;
            this.tbMultiRXFilterAlpha.Location = new System.Drawing.Point(54, 123);
            this.tbMultiRXFilterAlpha.Maximum = 255;
            this.tbMultiRXFilterAlpha.Name = "tbMultiRXFilterAlpha";
            this.tbMultiRXFilterAlpha.Size = new System.Drawing.Size(66, 18);
            this.tbMultiRXFilterAlpha.TabIndex = 82;
            this.tbMultiRXFilterAlpha.TickFrequency = 64;
            this.tbMultiRXFilterAlpha.Value = 97;
            this.tbMultiRXFilterAlpha.Scroll += new System.EventHandler(this.tbMultiRXFilterAlpha_Scroll);
            // 
            // clrbtnTXFilter
            // 
            this.clrbtnTXFilter.Automatic = "Automatic";
            this.clrbtnTXFilter.Color = System.Drawing.Color.Yellow;
            this.clrbtnTXFilter.Image = null;
            this.clrbtnTXFilter.Location = new System.Drawing.Point(200, 24);
            this.clrbtnTXFilter.MoreColors = "More Colors...";
            this.clrbtnTXFilter.Name = "clrbtnTXFilter";
            this.clrbtnTXFilter.Size = new System.Drawing.Size(40, 23);
            this.clrbtnTXFilter.TabIndex = 76;
            this.clrbtnTXFilter.Changed += new System.EventHandler(this.clrbtnTXFilter_Changed);
            // 
            // lblRX1FilterAlpha
            // 
            this.lblRX1FilterAlpha.Image = null;
            this.lblRX1FilterAlpha.Location = new System.Drawing.Point(8, 57);
            this.lblRX1FilterAlpha.Name = "lblRX1FilterAlpha";
            this.lblRX1FilterAlpha.Size = new System.Drawing.Size(40, 18);
            this.lblRX1FilterAlpha.TabIndex = 79;
            this.lblRX1FilterAlpha.Text = "Alpha:";
            // 
            // lblTXFilterColor
            // 
            this.lblTXFilterColor.Image = null;
            this.lblTXFilterColor.Location = new System.Drawing.Point(130, 24);
            this.lblTXFilterColor.Name = "lblTXFilterColor";
            this.lblTXFilterColor.Size = new System.Drawing.Size(64, 32);
            this.lblTXFilterColor.TabIndex = 75;
            this.lblTXFilterColor.Text = "TX Filter Color:";
            // 
            // clrbtnSubRXZero
            // 
            this.clrbtnSubRXZero.Automatic = "Automatic";
            this.clrbtnSubRXZero.Color = System.Drawing.Color.LightSkyBlue;
            this.clrbtnSubRXZero.Image = null;
            this.clrbtnSubRXZero.Location = new System.Drawing.Point(200, 65);
            this.clrbtnSubRXZero.MoreColors = "More Colors...";
            this.clrbtnSubRXZero.Name = "clrbtnSubRXZero";
            this.clrbtnSubRXZero.Size = new System.Drawing.Size(40, 23);
            this.clrbtnSubRXZero.TabIndex = 81;
            this.clrbtnSubRXZero.Changed += new System.EventHandler(this.clrbtnSubRXZero_Changed);
            // 
            // tbRX1FilterAlpha
            // 
            this.tbRX1FilterAlpha.AutoSize = false;
            this.tbRX1FilterAlpha.Location = new System.Drawing.Point(54, 57);
            this.tbRX1FilterAlpha.Maximum = 255;
            this.tbRX1FilterAlpha.Name = "tbRX1FilterAlpha";
            this.tbRX1FilterAlpha.Size = new System.Drawing.Size(66, 18);
            this.tbRX1FilterAlpha.TabIndex = 78;
            this.tbRX1FilterAlpha.TickFrequency = 64;
            this.toolTip1.SetToolTip(this.tbRX1FilterAlpha, "Transparency of RX1 and RX2 Bandpass window");
            this.tbRX1FilterAlpha.Value = 97;
            this.tbRX1FilterAlpha.Scroll += new System.EventHandler(this.tbRX1FilterAlpha_Scroll);
            // 
            // lblSubRXZeroLine
            // 
            this.lblSubRXZeroLine.Image = null;
            this.lblSubRXZeroLine.Location = new System.Drawing.Point(132, 65);
            this.lblSubRXZeroLine.Name = "lblSubRXZeroLine";
            this.lblSubRXZeroLine.Size = new System.Drawing.Size(64, 32);
            this.lblSubRXZeroLine.TabIndex = 80;
            this.lblSubRXZeroLine.Text = "MultiRX Zero Line:";
            // 
            // clrbtnSubRXFilter
            // 
            this.clrbtnSubRXFilter.Automatic = "Automatic";
            this.clrbtnSubRXFilter.Color = System.Drawing.Color.Blue;
            this.clrbtnSubRXFilter.Image = null;
            this.clrbtnSubRXFilter.Location = new System.Drawing.Point(80, 88);
            this.clrbtnSubRXFilter.MoreColors = "More Colors...";
            this.clrbtnSubRXFilter.Name = "clrbtnSubRXFilter";
            this.clrbtnSubRXFilter.Size = new System.Drawing.Size(40, 23);
            this.clrbtnSubRXFilter.TabIndex = 79;
            this.clrbtnSubRXFilter.Changed += new System.EventHandler(this.clrbtnSubRXFilter_Changed);
            // 
            // lblSubRXFilterColor
            // 
            this.lblSubRXFilterColor.Image = null;
            this.lblSubRXFilterColor.Location = new System.Drawing.Point(9, 88);
            this.lblSubRXFilterColor.Name = "lblSubRXFilterColor";
            this.lblSubRXFilterColor.Size = new System.Drawing.Size(64, 32);
            this.lblSubRXFilterColor.TabIndex = 78;
            this.lblSubRXFilterColor.Text = "MultiRX Filter Color:";
            // 
            // clrbtnBandEdge
            // 
            this.clrbtnBandEdge.Automatic = "Automatic";
            this.clrbtnBandEdge.Color = System.Drawing.Color.Red;
            this.clrbtnBandEdge.Image = null;
            this.clrbtnBandEdge.Location = new System.Drawing.Point(316, 24);
            this.clrbtnBandEdge.MoreColors = "More Colors...";
            this.clrbtnBandEdge.Name = "clrbtnBandEdge";
            this.clrbtnBandEdge.Size = new System.Drawing.Size(40, 23);
            this.clrbtnBandEdge.TabIndex = 71;
            this.clrbtnBandEdge.Changed += new System.EventHandler(this.clrbtnBandEdge_Changed);
            // 
            // lblBandEdge
            // 
            this.lblBandEdge.Image = null;
            this.lblBandEdge.Location = new System.Drawing.Point(256, 22);
            this.lblBandEdge.Name = "lblBandEdge";
            this.lblBandEdge.Size = new System.Drawing.Size(64, 34);
            this.lblBandEdge.TabIndex = 65;
            this.lblBandEdge.Text = "Band Edge Color:";
            this.lblBandEdge.Click += new System.EventHandler(this.lblBandEdge_Click);
            // 
            // lblDisplayFilterColor
            // 
            this.lblDisplayFilterColor.Image = null;
            this.lblDisplayFilterColor.Location = new System.Drawing.Point(8, 24);
            this.lblDisplayFilterColor.Name = "lblDisplayFilterColor";
            this.lblDisplayFilterColor.Size = new System.Drawing.Size(64, 32);
            this.lblDisplayFilterColor.TabIndex = 45;
            this.lblDisplayFilterColor.Text = "Main RX Filter Color:";
            // 
            // clrbtnFilter
            // 
            this.clrbtnFilter.Automatic = "Automatic";
            this.clrbtnFilter.Color = System.Drawing.Color.White;
            this.clrbtnFilter.Image = null;
            this.clrbtnFilter.Location = new System.Drawing.Point(80, 24);
            this.clrbtnFilter.MoreColors = "More Colors...";
            this.clrbtnFilter.Name = "clrbtnFilter";
            this.clrbtnFilter.Size = new System.Drawing.Size(40, 23);
            this.clrbtnFilter.TabIndex = 71;
            this.toolTip1.SetToolTip(this.clrbtnFilter, "Color of RX1 and RX2 Bandpass window");
            this.clrbtnFilter.Changed += new System.EventHandler(this.clrbtnFilter_Changed);
            // 
            // labelTS36
            // 
            this.labelTS36.Image = null;
            this.labelTS36.Location = new System.Drawing.Point(395, 56);
            this.labelTS36.Name = "labelTS36";
            this.labelTS36.Size = new System.Drawing.Size(64, 18);
            this.labelTS36.TabIndex = 98;
            this.labelTS36.Text = "Map Dark";
            this.toolTip1.SetToolTip(this.labelTS36, "Daylight Area of Map:  Brightness");
            // 
            // labelTS8
            // 
            this.labelTS8.Image = null;
            this.labelTS8.Location = new System.Drawing.Point(376, 22);
            this.labelTS8.Name = "labelTS8";
            this.labelTS8.Size = new System.Drawing.Size(92, 23);
            this.labelTS8.TabIndex = 88;
            this.labelTS8.Text = "GrayLine Dark\r\n";
            this.toolTip1.SetToolTip(this.labelTS8, "Grayline Area of Map:  Set the Darkness");
            // 
            // grpDisplayPeakCursor
            // 
            this.grpDisplayPeakCursor.Controls.Add(this.clrbtnPeakBackground);
            this.grpDisplayPeakCursor.Controls.Add(this.lblPeakBackground);
            this.grpDisplayPeakCursor.Controls.Add(this.clrbtnPeakText);
            this.grpDisplayPeakCursor.Controls.Add(this.lblPeakText);
            this.grpDisplayPeakCursor.Location = new System.Drawing.Point(387, 6);
            this.grpDisplayPeakCursor.Name = "grpDisplayPeakCursor";
            this.grpDisplayPeakCursor.Size = new System.Drawing.Size(190, 100);
            this.grpDisplayPeakCursor.TabIndex = 74;
            this.grpDisplayPeakCursor.TabStop = false;
            this.grpDisplayPeakCursor.Text = "Cursor/Peak Readout";
            // 
            // clrbtnPeakBackground
            // 
            this.clrbtnPeakBackground.Automatic = "Automatic";
            this.clrbtnPeakBackground.Color = System.Drawing.Color.Black;
            this.clrbtnPeakBackground.Image = null;
            this.clrbtnPeakBackground.Location = new System.Drawing.Point(78, 57);
            this.clrbtnPeakBackground.MoreColors = "More Colors...";
            this.clrbtnPeakBackground.Name = "clrbtnPeakBackground";
            this.clrbtnPeakBackground.Size = new System.Drawing.Size(40, 23);
            this.clrbtnPeakBackground.TabIndex = 73;
            this.clrbtnPeakBackground.Changed += new System.EventHandler(this.clrbtnPeakBackground_Changed);
            // 
            // lblPeakBackground
            // 
            this.lblPeakBackground.Image = null;
            this.lblPeakBackground.Location = new System.Drawing.Point(8, 61);
            this.lblPeakBackground.Name = "lblPeakBackground";
            this.lblPeakBackground.Size = new System.Drawing.Size(72, 24);
            this.lblPeakBackground.TabIndex = 72;
            this.lblPeakBackground.Text = "Background:";
            // 
            // clrbtnPeakText
            // 
            this.clrbtnPeakText.Automatic = "Automatic";
            this.clrbtnPeakText.Color = System.Drawing.Color.DodgerBlue;
            this.clrbtnPeakText.Image = null;
            this.clrbtnPeakText.Location = new System.Drawing.Point(78, 16);
            this.clrbtnPeakText.MoreColors = "More Colors...";
            this.clrbtnPeakText.Name = "clrbtnPeakText";
            this.clrbtnPeakText.Size = new System.Drawing.Size(40, 23);
            this.clrbtnPeakText.TabIndex = 71;
            this.clrbtnPeakText.Changed += new System.EventHandler(this.clrbtnPeakText_Changed);
            // 
            // lblPeakText
            // 
            this.lblPeakText.Image = null;
            this.lblPeakText.Location = new System.Drawing.Point(8, 24);
            this.lblPeakText.Name = "lblPeakText";
            this.lblPeakText.Size = new System.Drawing.Size(64, 24);
            this.lblPeakText.TabIndex = 65;
            this.lblPeakText.Text = "Peak Text:";
            // 
            // tpAppearanceMeter
            // 
            this.tpAppearanceMeter.BackColor = System.Drawing.SystemColors.Control;
            this.tpAppearanceMeter.Controls.Add(this.chkDock);
            this.tpAppearanceMeter.Controls.Add(this.labelTS2);
            this.tpAppearanceMeter.Controls.Add(this.clrbtnMeterDigBackground);
            this.tpAppearanceMeter.Controls.Add(this.clrbtnMeterRight);
            this.tpAppearanceMeter.Controls.Add(this.lblMeterDigitalText);
            this.tpAppearanceMeter.Controls.Add(this.clrbtnMeterDigText);
            this.tpAppearanceMeter.Controls.Add(this.grpMeterEdge);
            this.tpAppearanceMeter.Controls.Add(this.clrbtnMeterLeft);
            this.tpAppearanceMeter.Controls.Add(this.grpAppearanceMeter);
            this.tpAppearanceMeter.Controls.Add(this.lblMeterType);
            this.tpAppearanceMeter.Controls.Add(this.comboMeterType);
            this.tpAppearanceMeter.Location = new System.Drawing.Point(4, 22);
            this.tpAppearanceMeter.Name = "tpAppearanceMeter";
            this.tpAppearanceMeter.Size = new System.Drawing.Size(592, 318);
            this.tpAppearanceMeter.TabIndex = 2;
            this.tpAppearanceMeter.Text = "Meter";
            // 
            // chkDock
            // 
            this.chkDock.Image = null;
            this.chkDock.Location = new System.Drawing.Point(12, 257);
            this.chkDock.Name = "chkDock";
            this.chkDock.Size = new System.Drawing.Size(124, 32);
            this.chkDock.TabIndex = 90;
            this.chkDock.Text = "ESC Docked";
            this.toolTip1.SetToolTip(this.chkDock, "If you have a Flex-5000 with 2nd RX (RX2) you can dock the \r\nEnhanced Signal Clar" +
        "ity (ESC) panel in the lower right corner \r\nof the Console screen.\r\n\r\n");
            this.chkDock.Visible = false;
            // 
            // labelTS2
            // 
            this.labelTS2.Image = null;
            this.labelTS2.Location = new System.Drawing.Point(24, 80);
            this.labelTS2.Name = "labelTS2";
            this.labelTS2.Size = new System.Drawing.Size(72, 32);
            this.labelTS2.TabIndex = 83;
            this.labelTS2.Text = "Digital Background:";
            // 
            // clrbtnMeterDigBackground
            // 
            this.clrbtnMeterDigBackground.Automatic = "Automatic";
            this.clrbtnMeterDigBackground.Color = System.Drawing.Color.Black;
            this.clrbtnMeterDigBackground.Image = null;
            this.clrbtnMeterDigBackground.Location = new System.Drawing.Point(96, 80);
            this.clrbtnMeterDigBackground.MoreColors = "More Colors...";
            this.clrbtnMeterDigBackground.Name = "clrbtnMeterDigBackground";
            this.clrbtnMeterDigBackground.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterDigBackground.TabIndex = 84;
            this.clrbtnMeterDigBackground.Changed += new System.EventHandler(this.clrbtnMeterDigBackground_Changed);
            // 
            // clrbtnMeterRight
            // 
            this.clrbtnMeterRight.Automatic = "Automatic";
            this.clrbtnMeterRight.Color = System.Drawing.Color.Red;
            this.clrbtnMeterRight.Image = null;
            this.clrbtnMeterRight.Location = new System.Drawing.Point(461, 209);
            this.clrbtnMeterRight.MoreColors = "More Colors...";
            this.clrbtnMeterRight.Name = "clrbtnMeterRight";
            this.clrbtnMeterRight.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterRight.TabIndex = 75;
            this.clrbtnMeterRight.Visible = false;
            this.clrbtnMeterRight.Changed += new System.EventHandler(this.clrbtnMeterRight_Changed);
            // 
            // lblMeterDigitalText
            // 
            this.lblMeterDigitalText.Image = null;
            this.lblMeterDigitalText.Location = new System.Drawing.Point(24, 48);
            this.lblMeterDigitalText.Name = "lblMeterDigitalText";
            this.lblMeterDigitalText.Size = new System.Drawing.Size(72, 24);
            this.lblMeterDigitalText.TabIndex = 81;
            this.lblMeterDigitalText.Text = "Digital Text:";
            // 
            // clrbtnMeterDigText
            // 
            this.clrbtnMeterDigText.Automatic = "Automatic";
            this.clrbtnMeterDigText.Color = System.Drawing.Color.Yellow;
            this.clrbtnMeterDigText.Image = null;
            this.clrbtnMeterDigText.Location = new System.Drawing.Point(96, 48);
            this.clrbtnMeterDigText.MoreColors = "More Colors...";
            this.clrbtnMeterDigText.Name = "clrbtnMeterDigText";
            this.clrbtnMeterDigText.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterDigText.TabIndex = 82;
            this.clrbtnMeterDigText.Changed += new System.EventHandler(this.clrbtnMeterDigText_Changed);
            // 
            // grpMeterEdge
            // 
            this.grpMeterEdge.Controls.Add(this.clrbtnEdgeIndicator);
            this.grpMeterEdge.Controls.Add(this.labelTS1);
            this.grpMeterEdge.Controls.Add(this.clrbtnMeterEdgeBackground);
            this.grpMeterEdge.Controls.Add(this.lblMeterEdgeBackground);
            this.grpMeterEdge.Controls.Add(this.clrbtnMeterEdgeHigh);
            this.grpMeterEdge.Controls.Add(this.lblMeterEdgeHigh);
            this.grpMeterEdge.Controls.Add(this.lblMeterEdgeLow);
            this.grpMeterEdge.Controls.Add(this.clrbtnMeterEdgeLow);
            this.grpMeterEdge.Location = new System.Drawing.Point(312, 8);
            this.grpMeterEdge.Name = "grpMeterEdge";
            this.grpMeterEdge.Size = new System.Drawing.Size(136, 160);
            this.grpMeterEdge.TabIndex = 80;
            this.grpMeterEdge.TabStop = false;
            this.grpMeterEdge.Text = "Edge Style";
            // 
            // clrbtnEdgeIndicator
            // 
            this.clrbtnEdgeIndicator.Automatic = "Automatic";
            this.clrbtnEdgeIndicator.Color = System.Drawing.Color.Yellow;
            this.clrbtnEdgeIndicator.ForeColor = System.Drawing.Color.Black;
            this.clrbtnEdgeIndicator.Image = null;
            this.clrbtnEdgeIndicator.Location = new System.Drawing.Point(80, 120);
            this.clrbtnEdgeIndicator.MoreColors = "More Colors...";
            this.clrbtnEdgeIndicator.Name = "clrbtnEdgeIndicator";
            this.clrbtnEdgeIndicator.Size = new System.Drawing.Size(40, 23);
            this.clrbtnEdgeIndicator.TabIndex = 79;
            this.clrbtnEdgeIndicator.Changed += new System.EventHandler(this.clrbtnEdgeIndicator_Changed);
            // 
            // labelTS1
            // 
            this.labelTS1.Image = null;
            this.labelTS1.Location = new System.Drawing.Point(8, 120);
            this.labelTS1.Name = "labelTS1";
            this.labelTS1.Size = new System.Drawing.Size(56, 24);
            this.labelTS1.TabIndex = 78;
            this.labelTS1.Text = "Indicator:";
            // 
            // clrbtnMeterEdgeBackground
            // 
            this.clrbtnMeterEdgeBackground.Automatic = "Automatic";
            this.clrbtnMeterEdgeBackground.Color = System.Drawing.Color.Black;
            this.clrbtnMeterEdgeBackground.ForeColor = System.Drawing.Color.Black;
            this.clrbtnMeterEdgeBackground.Image = null;
            this.clrbtnMeterEdgeBackground.Location = new System.Drawing.Point(80, 88);
            this.clrbtnMeterEdgeBackground.MoreColors = "More Colors...";
            this.clrbtnMeterEdgeBackground.Name = "clrbtnMeterEdgeBackground";
            this.clrbtnMeterEdgeBackground.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterEdgeBackground.TabIndex = 77;
            this.clrbtnMeterEdgeBackground.Changed += new System.EventHandler(this.clrbtnMeterEdgeBackground_Changed);
            // 
            // lblMeterEdgeBackground
            // 
            this.lblMeterEdgeBackground.Image = null;
            this.lblMeterEdgeBackground.Location = new System.Drawing.Point(8, 88);
            this.lblMeterEdgeBackground.Name = "lblMeterEdgeBackground";
            this.lblMeterEdgeBackground.Size = new System.Drawing.Size(72, 24);
            this.lblMeterEdgeBackground.TabIndex = 76;
            this.lblMeterEdgeBackground.Text = "Background:";
            // 
            // clrbtnMeterEdgeHigh
            // 
            this.clrbtnMeterEdgeHigh.Automatic = "Automatic";
            this.clrbtnMeterEdgeHigh.Color = System.Drawing.Color.Red;
            this.clrbtnMeterEdgeHigh.Image = null;
            this.clrbtnMeterEdgeHigh.Location = new System.Drawing.Point(80, 56);
            this.clrbtnMeterEdgeHigh.MoreColors = "More Colors...";
            this.clrbtnMeterEdgeHigh.Name = "clrbtnMeterEdgeHigh";
            this.clrbtnMeterEdgeHigh.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterEdgeHigh.TabIndex = 75;
            this.clrbtnMeterEdgeHigh.Changed += new System.EventHandler(this.clrbtnMeterEdgeHigh_Changed);
            // 
            // lblMeterEdgeHigh
            // 
            this.lblMeterEdgeHigh.Image = null;
            this.lblMeterEdgeHigh.Location = new System.Drawing.Point(8, 56);
            this.lblMeterEdgeHigh.Name = "lblMeterEdgeHigh";
            this.lblMeterEdgeHigh.Size = new System.Drawing.Size(72, 24);
            this.lblMeterEdgeHigh.TabIndex = 53;
            this.lblMeterEdgeHigh.Text = "High Color:";
            // 
            // lblMeterEdgeLow
            // 
            this.lblMeterEdgeLow.Image = null;
            this.lblMeterEdgeLow.Location = new System.Drawing.Point(8, 24);
            this.lblMeterEdgeLow.Name = "lblMeterEdgeLow";
            this.lblMeterEdgeLow.Size = new System.Drawing.Size(72, 24);
            this.lblMeterEdgeLow.TabIndex = 51;
            this.lblMeterEdgeLow.Text = "Low Color:";
            // 
            // clrbtnMeterEdgeLow
            // 
            this.clrbtnMeterEdgeLow.Automatic = "Automatic";
            this.clrbtnMeterEdgeLow.Color = System.Drawing.Color.White;
            this.clrbtnMeterEdgeLow.Image = null;
            this.clrbtnMeterEdgeLow.Location = new System.Drawing.Point(80, 24);
            this.clrbtnMeterEdgeLow.MoreColors = "More Colors...";
            this.clrbtnMeterEdgeLow.Name = "clrbtnMeterEdgeLow";
            this.clrbtnMeterEdgeLow.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterEdgeLow.TabIndex = 74;
            this.clrbtnMeterEdgeLow.Changed += new System.EventHandler(this.clrbtnMeterEdgeLow_Changed);
            // 
            // clrbtnMeterLeft
            // 
            this.clrbtnMeterLeft.Automatic = "Automatic";
            this.clrbtnMeterLeft.Color = System.Drawing.Color.White;
            this.clrbtnMeterLeft.Image = null;
            this.clrbtnMeterLeft.Location = new System.Drawing.Point(507, 209);
            this.clrbtnMeterLeft.MoreColors = "More Colors...";
            this.clrbtnMeterLeft.Name = "clrbtnMeterLeft";
            this.clrbtnMeterLeft.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterLeft.TabIndex = 74;
            this.clrbtnMeterLeft.Visible = false;
            this.clrbtnMeterLeft.Changed += new System.EventHandler(this.clrbtnMeterLeft_Changed);
            // 
            // grpAppearanceMeter
            // 
            this.grpAppearanceMeter.Controls.Add(this.chkBoxMeterMenus);
            this.grpAppearanceMeter.Controls.Add(this.chkBoxMeterTop);
            this.grpAppearanceMeter.Controls.Add(this.chkBoxPointer);
            this.grpAppearanceMeter.Controls.Add(this.chkBoxDMB);
            this.grpAppearanceMeter.Controls.Add(this.chkBoxLMB);
            this.grpAppearanceMeter.Controls.Add(this.clrbtnMeterHigh);
            this.grpAppearanceMeter.Controls.Add(this.clrbtnMeterIndicator);
            this.grpAppearanceMeter.Controls.Add(this.clrbtnMeterLow);
            this.grpAppearanceMeter.Controls.Add(this.labelTS12);
            this.grpAppearanceMeter.Controls.Add(this.clrbtnMeterBackground);
            this.grpAppearanceMeter.Controls.Add(this.lblMeterBackground);
            this.grpAppearanceMeter.Controls.Add(this.lblAppearanceMeterRight);
            this.grpAppearanceMeter.Controls.Add(this.lblAppearanceMeterLeft);
            this.grpAppearanceMeter.Location = new System.Drawing.Point(168, 8);
            this.grpAppearanceMeter.Name = "grpAppearanceMeter";
            this.grpAppearanceMeter.Size = new System.Drawing.Size(136, 307);
            this.grpAppearanceMeter.TabIndex = 38;
            this.grpAppearanceMeter.TabStop = false;
            this.grpAppearanceMeter.Text = "Analog";
            // 
            // chkBoxMeterMenus
            // 
            this.chkBoxMeterMenus.Checked = true;
            this.chkBoxMeterMenus.CheckState = System.Windows.Forms.CheckState.Checked;
            this.chkBoxMeterMenus.Image = null;
            this.chkBoxMeterMenus.Location = new System.Drawing.Point(6, 240);
            this.chkBoxMeterMenus.Name = "chkBoxMeterMenus";
            this.chkBoxMeterMenus.Size = new System.Drawing.Size(124, 32);
            this.chkBoxMeterMenus.TabIndex = 89;
            this.chkBoxMeterMenus.Text = "Meter Menus ON";
            this.toolTip1.SetToolTip(this.chkBoxMeterMenus, "unchecked Removes the Console RX and TX pulldown Meter Menus\r\n");
            this.chkBoxMeterMenus.CheckedChanged += new System.EventHandler(this.chkBoxMeterMenus_CheckedChanged);
            // 
            // chkBoxMeterTop
            // 
            this.chkBoxMeterTop.Image = null;
            this.chkBoxMeterTop.Location = new System.Drawing.Point(6, 269);
            this.chkBoxMeterTop.Name = "chkBoxMeterTop";
            this.chkBoxMeterTop.Size = new System.Drawing.Size(124, 32);
            this.chkBoxMeterTop.TabIndex = 88;
            this.chkBoxMeterTop.Text = "Meters on Top\r\n";
            this.toolTip1.SetToolTip(this.chkBoxMeterTop, "Moves both Meters to the Top of the Console\r\n(if your Window is larger than 850 p" +
        "ixels wide)\r\n\r\nSetup->Display->VFO Dials to add dials\r\n(requires windows > 1400 " +
        "pixels wide\r\n\r\n");
            this.chkBoxMeterTop.CheckedChanged += new System.EventHandler(this.chkBoxMeterTop_CheckedChanged);
            // 
            // chkBoxPointer
            // 
            this.chkBoxPointer.Image = null;
            this.chkBoxPointer.Location = new System.Drawing.Point(6, 213);
            this.chkBoxPointer.Name = "chkBoxPointer";
            this.chkBoxPointer.Size = new System.Drawing.Size(124, 32);
            this.chkBoxPointer.TabIndex = 87;
            this.chkBoxPointer.Text = "Alternate Pointer (Image)";
            this.toolTip1.SetToolTip(this.chkBoxPointer, "Uses a light colored graphic image for the meter background \r\nalong with a dark g" +
        "raphic image pointer");
            this.chkBoxPointer.CheckedChanged += new System.EventHandler(this.chkBoxPointer_CheckedChanged);
            // 
            // chkBoxDMB
            // 
            this.chkBoxDMB.Image = null;
            this.chkBoxDMB.Location = new System.Drawing.Point(6, 152);
            this.chkBoxDMB.Name = "chkBoxDMB";
            this.chkBoxDMB.Size = new System.Drawing.Size(124, 32);
            this.chkBoxDMB.TabIndex = 86;
            this.chkBoxDMB.Text = "Alternate Dark Meter background";
            this.toolTip1.SetToolTip(this.chkBoxDMB, "Uses a dark graphic image for the meter background \r\nalong with a light graphic i" +
        "mage pointer");
            this.chkBoxDMB.CheckedChanged += new System.EventHandler(this.chkBoxDMB_CheckedChanged);
            // 
            // chkBoxLMB
            // 
            this.chkBoxLMB.Image = null;
            this.chkBoxLMB.Location = new System.Drawing.Point(6, 117);
            this.chkBoxLMB.Name = "chkBoxLMB";
            this.chkBoxLMB.Size = new System.Drawing.Size(124, 32);
            this.chkBoxLMB.TabIndex = 85;
            this.chkBoxLMB.Text = "Alternate Light Meter background";
            this.toolTip1.SetToolTip(this.chkBoxLMB, "Uses a light colored graphic image for the meter background \r\nalong with a dark g" +
        "raphic image pointer");
            this.chkBoxLMB.CheckedChanged += new System.EventHandler(this.chkBoxLMB_CheckedChanged);
            // 
            // clrbtnMeterHigh
            // 
            this.clrbtnMeterHigh.Automatic = "Automatic";
            this.clrbtnMeterHigh.Color = System.Drawing.Color.Red;
            this.clrbtnMeterHigh.Image = null;
            this.clrbtnMeterHigh.Location = new System.Drawing.Point(80, 56);
            this.clrbtnMeterHigh.MoreColors = "More Colors...";
            this.clrbtnMeterHigh.Name = "clrbtnMeterHigh";
            this.clrbtnMeterHigh.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterHigh.TabIndex = 85;
            this.clrbtnMeterHigh.Changed += new System.EventHandler(this.clrbtnMeterHigh_Changed);
            // 
            // clrbtnMeterIndicator
            // 
            this.clrbtnMeterIndicator.Automatic = "Automatic";
            this.clrbtnMeterIndicator.Color = System.Drawing.Color.Yellow;
            this.clrbtnMeterIndicator.ForeColor = System.Drawing.Color.Black;
            this.clrbtnMeterIndicator.Image = null;
            this.clrbtnMeterIndicator.Location = new System.Drawing.Point(80, 184);
            this.clrbtnMeterIndicator.MoreColors = "More Colors...";
            this.clrbtnMeterIndicator.Name = "clrbtnMeterIndicator";
            this.clrbtnMeterIndicator.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterIndicator.TabIndex = 80;
            this.clrbtnMeterIndicator.Changed += new System.EventHandler(this.clrbtnMeterIndicator_Changed);
            // 
            // clrbtnMeterLow
            // 
            this.clrbtnMeterLow.Automatic = "Automatic";
            this.clrbtnMeterLow.Color = System.Drawing.Color.CornflowerBlue;
            this.clrbtnMeterLow.Image = null;
            this.clrbtnMeterLow.Location = new System.Drawing.Point(80, 24);
            this.clrbtnMeterLow.MoreColors = "More Colors...";
            this.clrbtnMeterLow.Name = "clrbtnMeterLow";
            this.clrbtnMeterLow.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterLow.TabIndex = 81;
            this.clrbtnMeterLow.Changed += new System.EventHandler(this.clrbtnMeterLow_Changed);
            // 
            // labelTS12
            // 
            this.labelTS12.Image = null;
            this.labelTS12.Location = new System.Drawing.Point(8, 184);
            this.labelTS12.Name = "labelTS12";
            this.labelTS12.Size = new System.Drawing.Size(56, 29);
            this.labelTS12.TabIndex = 80;
            this.labelTS12.Text = "Indicator:\r\n(Pointer)";
            // 
            // clrbtnMeterBackground
            // 
            this.clrbtnMeterBackground.Automatic = "Automatic";
            this.clrbtnMeterBackground.Color = System.Drawing.Color.Black;
            this.clrbtnMeterBackground.Image = null;
            this.clrbtnMeterBackground.Location = new System.Drawing.Point(80, 88);
            this.clrbtnMeterBackground.MoreColors = "More Colors...";
            this.clrbtnMeterBackground.Name = "clrbtnMeterBackground";
            this.clrbtnMeterBackground.Size = new System.Drawing.Size(40, 23);
            this.clrbtnMeterBackground.TabIndex = 77;
            this.clrbtnMeterBackground.Changed += new System.EventHandler(this.clrbtnMeterBackground_Changed);
            // 
            // lblMeterBackground
            // 
            this.lblMeterBackground.Image = null;
            this.lblMeterBackground.Location = new System.Drawing.Point(8, 88);
            this.lblMeterBackground.Name = "lblMeterBackground";
            this.lblMeterBackground.Size = new System.Drawing.Size(72, 24);
            this.lblMeterBackground.TabIndex = 76;
            this.lblMeterBackground.Text = "Background:";
            // 
            // lblAppearanceMeterRight
            // 
            this.lblAppearanceMeterRight.Image = null;
            this.lblAppearanceMeterRight.Location = new System.Drawing.Point(8, 56);
            this.lblAppearanceMeterRight.Name = "lblAppearanceMeterRight";
            this.lblAppearanceMeterRight.Size = new System.Drawing.Size(72, 24);
            this.lblAppearanceMeterRight.TabIndex = 53;
            this.lblAppearanceMeterRight.Text = "High Color:";
            // 
            // lblAppearanceMeterLeft
            // 
            this.lblAppearanceMeterLeft.Image = null;
            this.lblAppearanceMeterLeft.Location = new System.Drawing.Point(8, 24);
            this.lblAppearanceMeterLeft.Name = "lblAppearanceMeterLeft";
            this.lblAppearanceMeterLeft.Size = new System.Drawing.Size(72, 24);
            this.lblAppearanceMeterLeft.TabIndex = 51;
            this.lblAppearanceMeterLeft.Text = "Low Color:";
            // 
            // lblMeterType
            // 
            this.lblMeterType.Image = null;
            this.lblMeterType.Location = new System.Drawing.Point(16, 16);
            this.lblMeterType.Name = "lblMeterType";
            this.lblMeterType.Size = new System.Drawing.Size(64, 24);
            this.lblMeterType.TabIndex = 79;
            this.lblMeterType.Text = "Meter Type:";
            // 
            // comboMeterType
            // 
            this.comboMeterType.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboMeterType.DropDownWidth = 80;
            this.comboMeterType.ForeColor = System.Drawing.SystemColors.WindowText;
            this.comboMeterType.Items.AddRange(new object[] {
            "AnalogTR7",
            "Edge",
            "Analog",
            "Bar"});
            this.comboMeterType.Location = new System.Drawing.Point(80, 16);
            this.comboMeterType.Name = "comboMeterType";
            this.comboMeterType.Size = new System.Drawing.Size(80, 21);
            this.comboMeterType.TabIndex = 78;
            this.toolTip1.SetToolTip(this.comboMeterType, "Changes the appearance of the Multimeter on the front panel.");
            this.comboMeterType.SelectedIndexChanged += new System.EventHandler(this.comboMeterType_SelectedIndexChanged);
            // 
            // tpKeyboard
            // 
            this.tpKeyboard.Controls.Add(this.groupBoxTS5);
            this.tpKeyboard.Controls.Add(this.groupBoxTS2);
            this.tpKeyboard.Controls.Add(this.grpKBXIT);
            this.tpKeyboard.Controls.Add(this.grpKBRIT);
            this.tpKeyboard.Controls.Add(this.grpKBMode);
            this.tpKeyboard.Controls.Add(this.grpKBBand);
            this.tpKeyboard.Controls.Add(this.grpKBTune);
            this.tpKeyboard.Controls.Add(this.grpKBFilter);
            this.tpKeyboard.Controls.Add(this.grpKBCW);
            this.tpKeyboard.Location = new System.Drawing.Point(4, 22);
            this.tpKeyboard.Name = "tpKeyboard";
            this.tpKeyboard.Size = new System.Drawing.Size(584, 341);
            this.tpKeyboard.TabIndex = 4;
            this.tpKeyboard.Text = "Keyboard";
            // 
            // groupBoxTS5
            // 
            this.groupBoxTS5.Controls.Add(this.labelTS56);
            this.groupBoxTS5.Controls.Add(this.udQuindarTonesVol);
            this.groupBoxTS5.Controls.Add(this.checkQuindarToneON);
            this.groupBoxTS5.Controls.Add(this.chkQuindarEnd);
            this.groupBoxTS5.Controls.Add(this.chkQuindarStart);
            this.groupBoxTS5.Location = new System.Drawing.Point(455, 128);
            this.groupBoxTS5.Name = "groupBoxTS5";
            this.groupBoxTS5.Size = new System.Drawing.Size(112, 136);
            this.groupBoxTS5.TabIndex = 14;
            this.groupBoxTS5.TabStop = false;
            this.groupBoxTS5.Text = "Quindar Tones";
            // 
            // labelTS56
            // 
            this.labelTS56.Image = null;
            this.labelTS56.Location = new System.Drawing.Point(8, 104);
            this.labelTS56.Name = "labelTS56";
            this.labelTS56.Size = new System.Drawing.Size(32, 16);
            this.labelTS56.TabIndex = 74;
            this.labelTS56.Text = "TX:";
            // 
            // udQuindarTonesVol
            // 
            this.udQuindarTonesVol.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udQuindarTonesVol.Location = new System.Drawing.Point(46, 102);
            this.udQuindarTonesVol.Maximum = new decimal(new int[] {
            40,
            0,
            0,
            0});
            this.udQuindarTonesVol.Minimum = new decimal(new int[] {
            60,
            0,
            0,
            -2147483648});
            this.udQuindarTonesVol.Name = "udQuindarTonesVol";
            this.udQuindarTonesVol.Size = new System.Drawing.Size(40, 20);
            this.udQuindarTonesVol.TabIndex = 73;
            this.toolTip1.SetToolTip(this.udQuindarTonesVol, "Controls the TX volume of the Quindar Tones.");
            this.udQuindarTonesVol.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udQuindarTonesVol.ValueChanged += new System.EventHandler(this.udQuindarTonesVol_ValueChanged);
            // 
            // checkQuindarToneON
            // 
            this.checkQuindarToneON.Image = null;
            this.checkQuindarToneON.Location = new System.Drawing.Point(19, 70);
            this.checkQuindarToneON.Name = "checkQuindarToneON";
            this.checkQuindarToneON.Size = new System.Drawing.Size(87, 24);
            this.checkQuindarToneON.TabIndex = 72;
            this.checkQuindarToneON.Text = "ON (F8 key)";
            this.toolTip1.SetToolTip(this.checkQuindarToneON, "Quindar Tones: ON/OFF switch\r\nOr F8 key when console in focus");
            // 
            // chkQuindarEnd
            // 
            this.chkQuindarEnd.Image = null;
            this.chkQuindarEnd.Location = new System.Drawing.Point(19, 42);
            this.chkQuindarEnd.Name = "chkQuindarEnd";
            this.chkQuindarEnd.Size = new System.Drawing.Size(67, 24);
            this.chkQuindarEnd.TabIndex = 71;
            this.chkQuindarEnd.Text = "End";
            this.toolTip1.SetToolTip(this.chkQuindarEnd, "Quindar Tone when you unkey the radio");
            this.chkQuindarEnd.CheckedChanged += new System.EventHandler(this.chkQuindarEnd_CheckedChanged);
            // 
            // chkQuindarStart
            // 
            this.chkQuindarStart.Image = null;
            this.chkQuindarStart.Location = new System.Drawing.Point(19, 19);
            this.chkQuindarStart.Name = "chkQuindarStart";
            this.chkQuindarStart.Size = new System.Drawing.Size(67, 24);
            this.chkQuindarStart.TabIndex = 70;
            this.chkQuindarStart.Text = "Start";
            this.toolTip1.SetToolTip(this.chkQuindarStart, "Quindar tone when you key the radio");
            this.chkQuindarStart.CheckedChanged += new System.EventHandler(this.chkQuindarStart_CheckedChanged);
            // 
            // groupBoxTS2
            // 
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF11);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF10);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF0);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF9);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF8);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF7);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF6);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF5);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF4);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF3);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF2);
            this.groupBoxTS2.Controls.Add(this.checkBoxDTMF1);
            this.groupBoxTS2.Location = new System.Drawing.Point(19, 270);
            this.groupBoxTS2.Name = "groupBoxTS2";
            this.groupBoxTS2.Size = new System.Drawing.Size(548, 55);
            this.groupBoxTS2.TabIndex = 90;
            this.groupBoxTS2.TabStop = false;
            this.groupBoxTS2.Text = "DTMF keypad (hold down button while in TX mode) or use ALT + KEY";
            this.toolTip1.SetToolTip(this.groupBoxTS2, "Mouse Click on any Button while in TX mode, to transmit DTMF ");
            // 
            // checkBoxDTMF11
            // 
            this.checkBoxDTMF11.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF11.Image = null;
            this.checkBoxDTMF11.Location = new System.Drawing.Point(426, 23);
            this.checkBoxDTMF11.Name = "checkBoxDTMF11";
            this.checkBoxDTMF11.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF11.TabIndex = 104;
            this.checkBoxDTMF11.Text = "#";
            this.checkBoxDTMF11.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF11.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF11_MouseDown);
            this.checkBoxDTMF11.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF10
            // 
            this.checkBoxDTMF10.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF10.Image = null;
            this.checkBoxDTMF10.Location = new System.Drawing.Point(388, 23);
            this.checkBoxDTMF10.Name = "checkBoxDTMF10";
            this.checkBoxDTMF10.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF10.TabIndex = 103;
            this.checkBoxDTMF10.Text = "*";
            this.checkBoxDTMF10.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF10.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF0_MouseDown);
            this.checkBoxDTMF10.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF0
            // 
            this.checkBoxDTMF0.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF0.Image = null;
            this.checkBoxDTMF0.Location = new System.Drawing.Point(348, 23);
            this.checkBoxDTMF0.Name = "checkBoxDTMF0";
            this.checkBoxDTMF0.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF0.TabIndex = 102;
            this.checkBoxDTMF0.Text = "0";
            this.checkBoxDTMF0.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF0.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF10_MouseDown);
            this.checkBoxDTMF0.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF9
            // 
            this.checkBoxDTMF9.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF9.Image = null;
            this.checkBoxDTMF9.Location = new System.Drawing.Point(310, 23);
            this.checkBoxDTMF9.Name = "checkBoxDTMF9";
            this.checkBoxDTMF9.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF9.TabIndex = 101;
            this.checkBoxDTMF9.Text = "9";
            this.checkBoxDTMF9.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF9.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF9_MouseDown);
            this.checkBoxDTMF9.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF8
            // 
            this.checkBoxDTMF8.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF8.Image = null;
            this.checkBoxDTMF8.Location = new System.Drawing.Point(274, 23);
            this.checkBoxDTMF8.Name = "checkBoxDTMF8";
            this.checkBoxDTMF8.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF8.TabIndex = 100;
            this.checkBoxDTMF8.Text = "8";
            this.checkBoxDTMF8.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF8.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF8_MouseDown);
            this.checkBoxDTMF8.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF7
            // 
            this.checkBoxDTMF7.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF7.Image = null;
            this.checkBoxDTMF7.Location = new System.Drawing.Point(236, 23);
            this.checkBoxDTMF7.Name = "checkBoxDTMF7";
            this.checkBoxDTMF7.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF7.TabIndex = 99;
            this.checkBoxDTMF7.Text = "7";
            this.checkBoxDTMF7.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF7.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF7_MouseDown);
            this.checkBoxDTMF7.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF6
            // 
            this.checkBoxDTMF6.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF6.Image = null;
            this.checkBoxDTMF6.Location = new System.Drawing.Point(196, 23);
            this.checkBoxDTMF6.Name = "checkBoxDTMF6";
            this.checkBoxDTMF6.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF6.TabIndex = 98;
            this.checkBoxDTMF6.Text = "6";
            this.checkBoxDTMF6.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF6.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF6_MouseDown);
            this.checkBoxDTMF6.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF5
            // 
            this.checkBoxDTMF5.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF5.Image = null;
            this.checkBoxDTMF5.Location = new System.Drawing.Point(158, 23);
            this.checkBoxDTMF5.Name = "checkBoxDTMF5";
            this.checkBoxDTMF5.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF5.TabIndex = 97;
            this.checkBoxDTMF5.Text = "5";
            this.checkBoxDTMF5.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF5.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF5_MouseDown);
            this.checkBoxDTMF5.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF4
            // 
            this.checkBoxDTMF4.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF4.Image = null;
            this.checkBoxDTMF4.Location = new System.Drawing.Point(122, 23);
            this.checkBoxDTMF4.Name = "checkBoxDTMF4";
            this.checkBoxDTMF4.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF4.TabIndex = 96;
            this.checkBoxDTMF4.Text = "4";
            this.checkBoxDTMF4.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF4.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF4_MouseDown);
            this.checkBoxDTMF4.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF3
            // 
            this.checkBoxDTMF3.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF3.Image = null;
            this.checkBoxDTMF3.Location = new System.Drawing.Point(84, 23);
            this.checkBoxDTMF3.Name = "checkBoxDTMF3";
            this.checkBoxDTMF3.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF3.TabIndex = 95;
            this.checkBoxDTMF3.Text = "3";
            this.checkBoxDTMF3.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF3.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF3_MouseDown);
            this.checkBoxDTMF3.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF2
            // 
            this.checkBoxDTMF2.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF2.Image = null;
            this.checkBoxDTMF2.Location = new System.Drawing.Point(44, 23);
            this.checkBoxDTMF2.Name = "checkBoxDTMF2";
            this.checkBoxDTMF2.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF2.TabIndex = 94;
            this.checkBoxDTMF2.Text = "2";
            this.checkBoxDTMF2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF2.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF2_MouseDown);
            this.checkBoxDTMF2.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // checkBoxDTMF1
            // 
            this.checkBoxDTMF1.Appearance = System.Windows.Forms.Appearance.Button;
            this.checkBoxDTMF1.Image = null;
            this.checkBoxDTMF1.Location = new System.Drawing.Point(6, 23);
            this.checkBoxDTMF1.Name = "checkBoxDTMF1";
            this.checkBoxDTMF1.Size = new System.Drawing.Size(32, 24);
            this.checkBoxDTMF1.TabIndex = 93;
            this.checkBoxDTMF1.Text = "1";
            this.checkBoxDTMF1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.checkBoxDTMF1.MouseDown += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseDown);
            this.checkBoxDTMF1.MouseUp += new System.Windows.Forms.MouseEventHandler(this.checkBoxDTMF1_MouseUp);
            // 
            // grpKBXIT
            // 
            this.grpKBXIT.Controls.Add(this.lblKBXITUp);
            this.grpKBXIT.Controls.Add(this.lblKBXITDown);
            this.grpKBXIT.Controls.Add(this.comboKBXITUp);
            this.grpKBXIT.Controls.Add(this.comboKBXITDown);
            this.grpKBXIT.Location = new System.Drawing.Point(136, 192);
            this.grpKBXIT.Name = "grpKBXIT";
            this.grpKBXIT.Size = new System.Drawing.Size(112, 72);
            this.grpKBXIT.TabIndex = 16;
            this.grpKBXIT.TabStop = false;
            this.grpKBXIT.Text = "XIT";
            // 
            // lblKBXITUp
            // 
            this.lblKBXITUp.Image = null;
            this.lblKBXITUp.Location = new System.Drawing.Point(8, 16);
            this.lblKBXITUp.Name = "lblKBXITUp";
            this.lblKBXITUp.Size = new System.Drawing.Size(40, 16);
            this.lblKBXITUp.TabIndex = 10;
            this.lblKBXITUp.Text = "Up:";
            this.lblKBXITUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBXITDown
            // 
            this.lblKBXITDown.Image = null;
            this.lblKBXITDown.Location = new System.Drawing.Point(8, 40);
            this.lblKBXITDown.Name = "lblKBXITDown";
            this.lblKBXITDown.Size = new System.Drawing.Size(40, 16);
            this.lblKBXITDown.TabIndex = 9;
            this.lblKBXITDown.Text = "Down:";
            this.lblKBXITDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // comboKBXITUp
            // 
            this.comboKBXITUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBXITUp.DropDownWidth = 56;
            this.comboKBXITUp.Location = new System.Drawing.Point(48, 16);
            this.comboKBXITUp.Name = "comboKBXITUp";
            this.comboKBXITUp.Size = new System.Drawing.Size(56, 21);
            this.comboKBXITUp.TabIndex = 6;
            this.toolTip1.SetToolTip(this.comboKBXITUp, "Adjust XIT control up 1kHz.");
            this.comboKBXITUp.SelectedIndexChanged += new System.EventHandler(this.comboKBXITUp_SelectedIndexChanged);
            // 
            // comboKBXITDown
            // 
            this.comboKBXITDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBXITDown.DropDownWidth = 56;
            this.comboKBXITDown.Location = new System.Drawing.Point(48, 40);
            this.comboKBXITDown.Name = "comboKBXITDown";
            this.comboKBXITDown.Size = new System.Drawing.Size(56, 21);
            this.comboKBXITDown.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboKBXITDown, "Adjust the XIT control down 1kHz.");
            this.comboKBXITDown.SelectedIndexChanged += new System.EventHandler(this.comboKBXITDown_SelectedIndexChanged);
            // 
            // grpKBRIT
            // 
            this.grpKBRIT.Controls.Add(this.lblKBRitUp);
            this.grpKBRIT.Controls.Add(this.lblKBRITDown);
            this.grpKBRIT.Controls.Add(this.comboKBRITUp);
            this.grpKBRIT.Controls.Add(this.comboKBRITDown);
            this.grpKBRIT.Location = new System.Drawing.Point(8, 192);
            this.grpKBRIT.Name = "grpKBRIT";
            this.grpKBRIT.Size = new System.Drawing.Size(112, 72);
            this.grpKBRIT.TabIndex = 15;
            this.grpKBRIT.TabStop = false;
            this.grpKBRIT.Text = "RIT";
            // 
            // lblKBRitUp
            // 
            this.lblKBRitUp.Image = null;
            this.lblKBRitUp.Location = new System.Drawing.Point(8, 16);
            this.lblKBRitUp.Name = "lblKBRitUp";
            this.lblKBRitUp.Size = new System.Drawing.Size(40, 16);
            this.lblKBRitUp.TabIndex = 10;
            this.lblKBRitUp.Text = "Up:";
            this.lblKBRitUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBRITDown
            // 
            this.lblKBRITDown.Image = null;
            this.lblKBRITDown.Location = new System.Drawing.Point(8, 40);
            this.lblKBRITDown.Name = "lblKBRITDown";
            this.lblKBRITDown.Size = new System.Drawing.Size(40, 16);
            this.lblKBRITDown.TabIndex = 9;
            this.lblKBRITDown.Text = "Down:";
            this.lblKBRITDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // comboKBRITUp
            // 
            this.comboKBRITUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBRITUp.DropDownWidth = 56;
            this.comboKBRITUp.Location = new System.Drawing.Point(48, 16);
            this.comboKBRITUp.Name = "comboKBRITUp";
            this.comboKBRITUp.Size = new System.Drawing.Size(56, 21);
            this.comboKBRITUp.TabIndex = 6;
            this.toolTip1.SetToolTip(this.comboKBRITUp, "Adjust RIT control up 1kHz.");
            this.comboKBRITUp.SelectedIndexChanged += new System.EventHandler(this.comboKBRITUp_SelectedIndexChanged);
            // 
            // comboKBRITDown
            // 
            this.comboKBRITDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBRITDown.DropDownWidth = 56;
            this.comboKBRITDown.Location = new System.Drawing.Point(48, 40);
            this.comboKBRITDown.Name = "comboKBRITDown";
            this.comboKBRITDown.Size = new System.Drawing.Size(56, 21);
            this.comboKBRITDown.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboKBRITDown, "Adjust RIT control down 1kHz.");
            this.comboKBRITDown.SelectedIndexChanged += new System.EventHandler(this.comboKBRITDown_SelectedIndexChanged);
            // 
            // grpKBMode
            // 
            this.grpKBMode.Controls.Add(this.lblKBModeUp);
            this.grpKBMode.Controls.Add(this.lblKBModeDown);
            this.grpKBMode.Controls.Add(this.comboKBModeUp);
            this.grpKBMode.Controls.Add(this.comboKBModeDown);
            this.grpKBMode.Location = new System.Drawing.Point(264, 112);
            this.grpKBMode.Name = "grpKBMode";
            this.grpKBMode.Size = new System.Drawing.Size(112, 72);
            this.grpKBMode.TabIndex = 14;
            this.grpKBMode.TabStop = false;
            this.grpKBMode.Text = "Mode";
            // 
            // lblKBModeUp
            // 
            this.lblKBModeUp.Image = null;
            this.lblKBModeUp.Location = new System.Drawing.Point(8, 16);
            this.lblKBModeUp.Name = "lblKBModeUp";
            this.lblKBModeUp.Size = new System.Drawing.Size(40, 16);
            this.lblKBModeUp.TabIndex = 10;
            this.lblKBModeUp.Text = "Up:";
            this.lblKBModeUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBModeDown
            // 
            this.lblKBModeDown.Image = null;
            this.lblKBModeDown.Location = new System.Drawing.Point(8, 40);
            this.lblKBModeDown.Name = "lblKBModeDown";
            this.lblKBModeDown.Size = new System.Drawing.Size(40, 16);
            this.lblKBModeDown.TabIndex = 9;
            this.lblKBModeDown.Text = "Down:";
            this.lblKBModeDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // comboKBModeUp
            // 
            this.comboKBModeUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBModeUp.DropDownWidth = 56;
            this.comboKBModeUp.Location = new System.Drawing.Point(48, 16);
            this.comboKBModeUp.Name = "comboKBModeUp";
            this.comboKBModeUp.Size = new System.Drawing.Size(56, 21);
            this.comboKBModeUp.TabIndex = 6;
            this.toolTip1.SetToolTip(this.comboKBModeUp, "Select the Next mode.");
            this.comboKBModeUp.SelectedIndexChanged += new System.EventHandler(this.comboKBModeUp_SelectedIndexChanged);
            // 
            // comboKBModeDown
            // 
            this.comboKBModeDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBModeDown.DropDownWidth = 56;
            this.comboKBModeDown.Location = new System.Drawing.Point(48, 40);
            this.comboKBModeDown.Name = "comboKBModeDown";
            this.comboKBModeDown.Size = new System.Drawing.Size(56, 21);
            this.comboKBModeDown.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboKBModeDown, "Select the Previous mode.");
            this.comboKBModeDown.SelectedIndexChanged += new System.EventHandler(this.comboKBModeDown_SelectedIndexChanged);
            // 
            // grpKBBand
            // 
            this.grpKBBand.Controls.Add(this.lblKBBandUp);
            this.grpKBBand.Controls.Add(this.lblKBBandDown);
            this.grpKBBand.Controls.Add(this.comboKBBandUp);
            this.grpKBBand.Controls.Add(this.comboKBBandDown);
            this.grpKBBand.Location = new System.Drawing.Point(8, 112);
            this.grpKBBand.Name = "grpKBBand";
            this.grpKBBand.Size = new System.Drawing.Size(112, 72);
            this.grpKBBand.TabIndex = 12;
            this.grpKBBand.TabStop = false;
            this.grpKBBand.Text = "Band";
            // 
            // lblKBBandUp
            // 
            this.lblKBBandUp.Image = null;
            this.lblKBBandUp.Location = new System.Drawing.Point(8, 16);
            this.lblKBBandUp.Name = "lblKBBandUp";
            this.lblKBBandUp.Size = new System.Drawing.Size(40, 16);
            this.lblKBBandUp.TabIndex = 10;
            this.lblKBBandUp.Text = "Up:";
            this.lblKBBandUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBBandDown
            // 
            this.lblKBBandDown.Image = null;
            this.lblKBBandDown.Location = new System.Drawing.Point(8, 40);
            this.lblKBBandDown.Name = "lblKBBandDown";
            this.lblKBBandDown.Size = new System.Drawing.Size(40, 16);
            this.lblKBBandDown.TabIndex = 9;
            this.lblKBBandDown.Text = "Down:";
            this.lblKBBandDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // comboKBBandUp
            // 
            this.comboKBBandUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBBandUp.DropDownWidth = 56;
            this.comboKBBandUp.Location = new System.Drawing.Point(48, 16);
            this.comboKBBandUp.Name = "comboKBBandUp";
            this.comboKBBandUp.Size = new System.Drawing.Size(56, 21);
            this.comboKBBandUp.TabIndex = 6;
            this.toolTip1.SetToolTip(this.comboKBBandUp, "Jump to the next band stack memory.");
            this.comboKBBandUp.SelectedIndexChanged += new System.EventHandler(this.comboKBBandUp_SelectedIndexChanged);
            // 
            // comboKBBandDown
            // 
            this.comboKBBandDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBBandDown.DropDownWidth = 56;
            this.comboKBBandDown.Location = new System.Drawing.Point(48, 40);
            this.comboKBBandDown.Name = "comboKBBandDown";
            this.comboKBBandDown.Size = new System.Drawing.Size(56, 21);
            this.comboKBBandDown.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboKBBandDown, "Jump to the previous band stack memory.");
            this.comboKBBandDown.SelectedIndexChanged += new System.EventHandler(this.comboKBBandDown_SelectedIndexChanged);
            // 
            // grpKBTune
            // 
            this.grpKBTune.Controls.Add(this.lblKBTuneDigit);
            this.grpKBTune.Controls.Add(this.lblKBTune7);
            this.grpKBTune.Controls.Add(this.lblKBTune6);
            this.grpKBTune.Controls.Add(this.lblKBTune5);
            this.grpKBTune.Controls.Add(this.lblKBTune4);
            this.grpKBTune.Controls.Add(this.lblKBTune3);
            this.grpKBTune.Controls.Add(this.lblKBTune2);
            this.grpKBTune.Controls.Add(this.comboKBTuneUp7);
            this.grpKBTune.Controls.Add(this.comboKBTuneDown7);
            this.grpKBTune.Controls.Add(this.comboKBTuneUp6);
            this.grpKBTune.Controls.Add(this.comboKBTuneDown6);
            this.grpKBTune.Controls.Add(this.comboKBTuneUp5);
            this.grpKBTune.Controls.Add(this.comboKBTuneDown5);
            this.grpKBTune.Controls.Add(this.comboKBTuneUp4);
            this.grpKBTune.Controls.Add(this.comboKBTuneDown4);
            this.grpKBTune.Controls.Add(this.lblKBTune1);
            this.grpKBTune.Controls.Add(this.lblKBTuneUp);
            this.grpKBTune.Controls.Add(this.lblKBTuneDown);
            this.grpKBTune.Controls.Add(this.comboKBTuneUp3);
            this.grpKBTune.Controls.Add(this.comboKBTuneDown3);
            this.grpKBTune.Controls.Add(this.comboKBTuneUp1);
            this.grpKBTune.Controls.Add(this.comboKBTuneUp2);
            this.grpKBTune.Controls.Add(this.comboKBTuneDown1);
            this.grpKBTune.Controls.Add(this.comboKBTuneDown2);
            this.grpKBTune.Location = new System.Drawing.Point(8, 8);
            this.grpKBTune.Name = "grpKBTune";
            this.grpKBTune.Size = new System.Drawing.Size(456, 96);
            this.grpKBTune.TabIndex = 11;
            this.grpKBTune.TabStop = false;
            this.grpKBTune.Text = "Tune";
            // 
            // lblKBTuneDigit
            // 
            this.lblKBTuneDigit.Image = null;
            this.lblKBTuneDigit.Location = new System.Drawing.Point(16, 16);
            this.lblKBTuneDigit.Name = "lblKBTuneDigit";
            this.lblKBTuneDigit.Size = new System.Drawing.Size(32, 16);
            this.lblKBTuneDigit.TabIndex = 26;
            this.lblKBTuneDigit.Text = "Digit";
            // 
            // lblKBTune7
            // 
            this.lblKBTune7.Image = null;
            this.lblKBTune7.Location = new System.Drawing.Point(392, 16);
            this.lblKBTune7.Name = "lblKBTune7";
            this.lblKBTune7.Size = new System.Drawing.Size(56, 16);
            this.lblKBTune7.TabIndex = 25;
            this.lblKBTune7.Text = "0.00000x";
            this.lblKBTune7.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBTune6
            // 
            this.lblKBTune6.Image = null;
            this.lblKBTune6.Location = new System.Drawing.Point(336, 16);
            this.lblKBTune6.Name = "lblKBTune6";
            this.lblKBTune6.Size = new System.Drawing.Size(56, 16);
            this.lblKBTune6.TabIndex = 24;
            this.lblKBTune6.Text = "0.0000x0";
            this.lblKBTune6.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBTune5
            // 
            this.lblKBTune5.Image = null;
            this.lblKBTune5.Location = new System.Drawing.Point(280, 16);
            this.lblKBTune5.Name = "lblKBTune5";
            this.lblKBTune5.Size = new System.Drawing.Size(56, 16);
            this.lblKBTune5.TabIndex = 23;
            this.lblKBTune5.Text = "0.000x00";
            this.lblKBTune5.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBTune4
            // 
            this.lblKBTune4.Image = null;
            this.lblKBTune4.Location = new System.Drawing.Point(224, 16);
            this.lblKBTune4.Name = "lblKBTune4";
            this.lblKBTune4.Size = new System.Drawing.Size(56, 16);
            this.lblKBTune4.TabIndex = 22;
            this.lblKBTune4.Text = "0.00x000";
            this.lblKBTune4.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBTune3
            // 
            this.lblKBTune3.Image = null;
            this.lblKBTune3.Location = new System.Drawing.Point(168, 16);
            this.lblKBTune3.Name = "lblKBTune3";
            this.lblKBTune3.Size = new System.Drawing.Size(56, 16);
            this.lblKBTune3.TabIndex = 21;
            this.lblKBTune3.Text = "0.0x0000";
            this.lblKBTune3.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBTune2
            // 
            this.lblKBTune2.Image = null;
            this.lblKBTune2.Location = new System.Drawing.Point(112, 16);
            this.lblKBTune2.Name = "lblKBTune2";
            this.lblKBTune2.Size = new System.Drawing.Size(56, 16);
            this.lblKBTune2.TabIndex = 20;
            this.lblKBTune2.Text = "0.x00000";
            this.lblKBTune2.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // comboKBTuneUp7
            // 
            this.comboKBTuneUp7.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneUp7.DropDownWidth = 56;
            this.comboKBTuneUp7.Location = new System.Drawing.Point(392, 40);
            this.comboKBTuneUp7.Name = "comboKBTuneUp7";
            this.comboKBTuneUp7.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneUp7.TabIndex = 19;
            this.toolTip1.SetToolTip(this.comboKBTuneUp7, "Tune Up 1Hz");
            this.comboKBTuneUp7.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp7_SelectedIndexChanged);
            // 
            // comboKBTuneDown7
            // 
            this.comboKBTuneDown7.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneDown7.DropDownWidth = 56;
            this.comboKBTuneDown7.Location = new System.Drawing.Point(392, 64);
            this.comboKBTuneDown7.Name = "comboKBTuneDown7";
            this.comboKBTuneDown7.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneDown7.TabIndex = 18;
            this.toolTip1.SetToolTip(this.comboKBTuneDown7, "Tune Down 1Hz");
            this.comboKBTuneDown7.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown7_SelectedIndexChanged);
            // 
            // comboKBTuneUp6
            // 
            this.comboKBTuneUp6.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneUp6.DropDownWidth = 56;
            this.comboKBTuneUp6.Location = new System.Drawing.Point(336, 40);
            this.comboKBTuneUp6.Name = "comboKBTuneUp6";
            this.comboKBTuneUp6.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneUp6.TabIndex = 17;
            this.toolTip1.SetToolTip(this.comboKBTuneUp6, "Tune Up 10Hz");
            this.comboKBTuneUp6.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp6_SelectedIndexChanged);
            // 
            // comboKBTuneDown6
            // 
            this.comboKBTuneDown6.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneDown6.DropDownWidth = 56;
            this.comboKBTuneDown6.Location = new System.Drawing.Point(336, 64);
            this.comboKBTuneDown6.Name = "comboKBTuneDown6";
            this.comboKBTuneDown6.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneDown6.TabIndex = 16;
            this.toolTip1.SetToolTip(this.comboKBTuneDown6, "Tune Down 10Hz");
            this.comboKBTuneDown6.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown6_SelectedIndexChanged);
            // 
            // comboKBTuneUp5
            // 
            this.comboKBTuneUp5.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneUp5.DropDownWidth = 56;
            this.comboKBTuneUp5.Location = new System.Drawing.Point(280, 40);
            this.comboKBTuneUp5.Name = "comboKBTuneUp5";
            this.comboKBTuneUp5.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneUp5.TabIndex = 15;
            this.toolTip1.SetToolTip(this.comboKBTuneUp5, "Tune Up 100Hz");
            this.comboKBTuneUp5.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp5_SelectedIndexChanged);
            // 
            // comboKBTuneDown5
            // 
            this.comboKBTuneDown5.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneDown5.DropDownWidth = 56;
            this.comboKBTuneDown5.Location = new System.Drawing.Point(280, 64);
            this.comboKBTuneDown5.Name = "comboKBTuneDown5";
            this.comboKBTuneDown5.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneDown5.TabIndex = 14;
            this.toolTip1.SetToolTip(this.comboKBTuneDown5, "Tune Down 100Hz");
            this.comboKBTuneDown5.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown5_SelectedIndexChanged);
            // 
            // comboKBTuneUp4
            // 
            this.comboKBTuneUp4.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneUp4.DropDownWidth = 56;
            this.comboKBTuneUp4.Location = new System.Drawing.Point(224, 40);
            this.comboKBTuneUp4.Name = "comboKBTuneUp4";
            this.comboKBTuneUp4.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneUp4.TabIndex = 13;
            this.toolTip1.SetToolTip(this.comboKBTuneUp4, "Tune Up 1kHz");
            this.comboKBTuneUp4.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp4_SelectedIndexChanged);
            // 
            // comboKBTuneDown4
            // 
            this.comboKBTuneDown4.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneDown4.DropDownWidth = 56;
            this.comboKBTuneDown4.Location = new System.Drawing.Point(224, 64);
            this.comboKBTuneDown4.Name = "comboKBTuneDown4";
            this.comboKBTuneDown4.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneDown4.TabIndex = 12;
            this.toolTip1.SetToolTip(this.comboKBTuneDown4, "Tune Down 1kHz");
            this.comboKBTuneDown4.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown4_SelectedIndexChanged);
            // 
            // lblKBTune1
            // 
            this.lblKBTune1.Image = null;
            this.lblKBTune1.Location = new System.Drawing.Point(48, 16);
            this.lblKBTune1.Name = "lblKBTune1";
            this.lblKBTune1.Size = new System.Drawing.Size(56, 16);
            this.lblKBTune1.TabIndex = 11;
            this.lblKBTune1.Text = "x.000000";
            this.lblKBTune1.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBTuneUp
            // 
            this.lblKBTuneUp.Image = null;
            this.lblKBTuneUp.Location = new System.Drawing.Point(8, 40);
            this.lblKBTuneUp.Name = "lblKBTuneUp";
            this.lblKBTuneUp.Size = new System.Drawing.Size(40, 16);
            this.lblKBTuneUp.TabIndex = 8;
            this.lblKBTuneUp.Text = "Up:";
            this.lblKBTuneUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBTuneDown
            // 
            this.lblKBTuneDown.Image = null;
            this.lblKBTuneDown.Location = new System.Drawing.Point(8, 64);
            this.lblKBTuneDown.Name = "lblKBTuneDown";
            this.lblKBTuneDown.Size = new System.Drawing.Size(40, 16);
            this.lblKBTuneDown.TabIndex = 7;
            this.lblKBTuneDown.Text = "Down:";
            this.lblKBTuneDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // comboKBTuneUp3
            // 
            this.comboKBTuneUp3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneUp3.DropDownWidth = 56;
            this.comboKBTuneUp3.Location = new System.Drawing.Point(168, 40);
            this.comboKBTuneUp3.Name = "comboKBTuneUp3";
            this.comboKBTuneUp3.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneUp3.TabIndex = 6;
            this.toolTip1.SetToolTip(this.comboKBTuneUp3, "Tune Up 10kHz");
            this.comboKBTuneUp3.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp3_SelectedIndexChanged);
            // 
            // comboKBTuneDown3
            // 
            this.comboKBTuneDown3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneDown3.DropDownWidth = 56;
            this.comboKBTuneDown3.Location = new System.Drawing.Point(168, 64);
            this.comboKBTuneDown3.Name = "comboKBTuneDown3";
            this.comboKBTuneDown3.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneDown3.TabIndex = 1;
            this.toolTip1.SetToolTip(this.comboKBTuneDown3, "Tune Down 10kHz");
            this.comboKBTuneDown3.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown3_SelectedIndexChanged);
            // 
            // comboKBTuneUp1
            // 
            this.comboKBTuneUp1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneUp1.DropDownWidth = 56;
            this.comboKBTuneUp1.Location = new System.Drawing.Point(48, 40);
            this.comboKBTuneUp1.Name = "comboKBTuneUp1";
            this.comboKBTuneUp1.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneUp1.TabIndex = 4;
            this.toolTip1.SetToolTip(this.comboKBTuneUp1, "Tune Up 1MHz");
            this.comboKBTuneUp1.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp1_SelectedIndexChanged);
            // 
            // comboKBTuneUp2
            // 
            this.comboKBTuneUp2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneUp2.DropDownWidth = 56;
            this.comboKBTuneUp2.Location = new System.Drawing.Point(112, 40);
            this.comboKBTuneUp2.Name = "comboKBTuneUp2";
            this.comboKBTuneUp2.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneUp2.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboKBTuneUp2, "Tune Up 100kHz");
            this.comboKBTuneUp2.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp2_SelectedIndexChanged);
            // 
            // comboKBTuneDown1
            // 
            this.comboKBTuneDown1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneDown1.DropDownWidth = 56;
            this.comboKBTuneDown1.Location = new System.Drawing.Point(48, 64);
            this.comboKBTuneDown1.Name = "comboKBTuneDown1";
            this.comboKBTuneDown1.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneDown1.TabIndex = 0;
            this.toolTip1.SetToolTip(this.comboKBTuneDown1, "Tune Down 1MHz");
            this.comboKBTuneDown1.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown1_SelectedIndexChanged);
            // 
            // comboKBTuneDown2
            // 
            this.comboKBTuneDown2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBTuneDown2.DropDownWidth = 56;
            this.comboKBTuneDown2.Location = new System.Drawing.Point(112, 64);
            this.comboKBTuneDown2.Name = "comboKBTuneDown2";
            this.comboKBTuneDown2.Size = new System.Drawing.Size(56, 21);
            this.comboKBTuneDown2.TabIndex = 2;
            this.toolTip1.SetToolTip(this.comboKBTuneDown2, "Tune Down 100kHz");
            this.comboKBTuneDown2.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown2_SelectedIndexChanged);
            // 
            // grpKBFilter
            // 
            this.grpKBFilter.Controls.Add(this.lblKBFilterUp);
            this.grpKBFilter.Controls.Add(this.lblKBFilterDown);
            this.grpKBFilter.Controls.Add(this.comboKBFilterUp);
            this.grpKBFilter.Controls.Add(this.comboKBFilterDown);
            this.grpKBFilter.Location = new System.Drawing.Point(136, 112);
            this.grpKBFilter.Name = "grpKBFilter";
            this.grpKBFilter.Size = new System.Drawing.Size(112, 72);
            this.grpKBFilter.TabIndex = 13;
            this.grpKBFilter.TabStop = false;
            this.grpKBFilter.Text = "Filter";
            // 
            // lblKBFilterUp
            // 
            this.lblKBFilterUp.Image = null;
            this.lblKBFilterUp.Location = new System.Drawing.Point(8, 16);
            this.lblKBFilterUp.Name = "lblKBFilterUp";
            this.lblKBFilterUp.Size = new System.Drawing.Size(40, 16);
            this.lblKBFilterUp.TabIndex = 10;
            this.lblKBFilterUp.Text = "Up:";
            this.lblKBFilterUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBFilterDown
            // 
            this.lblKBFilterDown.Image = null;
            this.lblKBFilterDown.Location = new System.Drawing.Point(8, 40);
            this.lblKBFilterDown.Name = "lblKBFilterDown";
            this.lblKBFilterDown.Size = new System.Drawing.Size(40, 16);
            this.lblKBFilterDown.TabIndex = 9;
            this.lblKBFilterDown.Text = "Down:";
            this.lblKBFilterDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // comboKBFilterUp
            // 
            this.comboKBFilterUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBFilterUp.DropDownWidth = 56;
            this.comboKBFilterUp.Location = new System.Drawing.Point(48, 16);
            this.comboKBFilterUp.Name = "comboKBFilterUp";
            this.comboKBFilterUp.Size = new System.Drawing.Size(56, 21);
            this.comboKBFilterUp.TabIndex = 6;
            this.toolTip1.SetToolTip(this.comboKBFilterUp, "Select the Next filter.");
            this.comboKBFilterUp.SelectedIndexChanged += new System.EventHandler(this.comboKBFilterUp_SelectedIndexChanged);
            // 
            // comboKBFilterDown
            // 
            this.comboKBFilterDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBFilterDown.DropDownWidth = 56;
            this.comboKBFilterDown.Location = new System.Drawing.Point(48, 40);
            this.comboKBFilterDown.Name = "comboKBFilterDown";
            this.comboKBFilterDown.Size = new System.Drawing.Size(56, 21);
            this.comboKBFilterDown.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboKBFilterDown, "Select the Previous filter.");
            this.comboKBFilterDown.SelectedIndexChanged += new System.EventHandler(this.comboKBFilterDown_SelectedIndexChanged);
            // 
            // grpKBCW
            // 
            this.grpKBCW.Controls.Add(this.lblKBCWDot);
            this.grpKBCW.Controls.Add(this.lblKBCWDash);
            this.grpKBCW.Controls.Add(this.comboKBCWDot);
            this.grpKBCW.Controls.Add(this.comboKBCWDash);
            this.grpKBCW.Location = new System.Drawing.Point(264, 192);
            this.grpKBCW.Name = "grpKBCW";
            this.grpKBCW.Size = new System.Drawing.Size(112, 72);
            this.grpKBCW.TabIndex = 13;
            this.grpKBCW.TabStop = false;
            this.grpKBCW.Text = "CW";
            this.grpKBCW.Visible = false;
            // 
            // lblKBCWDot
            // 
            this.lblKBCWDot.Image = null;
            this.lblKBCWDot.Location = new System.Drawing.Point(8, 16);
            this.lblKBCWDot.Name = "lblKBCWDot";
            this.lblKBCWDot.Size = new System.Drawing.Size(40, 16);
            this.lblKBCWDot.TabIndex = 10;
            this.lblKBCWDot.Text = "Dot:";
            this.lblKBCWDot.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // lblKBCWDash
            // 
            this.lblKBCWDash.Image = null;
            this.lblKBCWDash.Location = new System.Drawing.Point(8, 40);
            this.lblKBCWDash.Name = "lblKBCWDash";
            this.lblKBCWDash.Size = new System.Drawing.Size(40, 16);
            this.lblKBCWDash.TabIndex = 9;
            this.lblKBCWDash.Text = "Dash:";
            this.lblKBCWDash.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // comboKBCWDot
            // 
            this.comboKBCWDot.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBCWDot.DropDownWidth = 56;
            this.comboKBCWDot.Location = new System.Drawing.Point(48, 16);
            this.comboKBCWDot.Name = "comboKBCWDot";
            this.comboKBCWDot.Size = new System.Drawing.Size(56, 21);
            this.comboKBCWDot.TabIndex = 6;
            this.toolTip1.SetToolTip(this.comboKBCWDot, "Note: Only works with old keyer.");
            this.comboKBCWDot.SelectedIndexChanged += new System.EventHandler(this.comboKBCWDot_SelectedIndexChanged);
            // 
            // comboKBCWDash
            // 
            this.comboKBCWDash.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboKBCWDash.DropDownWidth = 56;
            this.comboKBCWDash.Location = new System.Drawing.Point(48, 40);
            this.comboKBCWDash.Name = "comboKBCWDash";
            this.comboKBCWDash.Size = new System.Drawing.Size(56, 21);
            this.comboKBCWDash.TabIndex = 5;
            this.toolTip1.SetToolTip(this.comboKBCWDash, "Note: Only works with old keyer.");
            this.comboKBCWDash.SelectedIndexChanged += new System.EventHandler(this.comboKBCWDash_SelectedIndexChanged);
            // 
            // tpExtCtrl
            // 
            this.tpExtCtrl.Controls.Add(this.chkExtEnable);
            this.tpExtCtrl.Controls.Add(this.grpExtTX);
            this.tpExtCtrl.Controls.Add(this.grpExtRX);
            this.tpExtCtrl.Location = new System.Drawing.Point(4, 22);
            this.tpExtCtrl.Name = "tpExtCtrl";
            this.tpExtCtrl.Size = new System.Drawing.Size(584, 341);
            this.tpExtCtrl.TabIndex = 11;
            this.tpExtCtrl.Text = "Ext. Ctrl";
            // 
            // chkExtEnable
            // 
            this.chkExtEnable.Image = null;
            this.chkExtEnable.Location = new System.Drawing.Point(360, 16);
            this.chkExtEnable.Name = "chkExtEnable";
            this.chkExtEnable.Size = new System.Drawing.Size(64, 24);
            this.chkExtEnable.TabIndex = 9;
            this.chkExtEnable.Text = "Enable";
            this.toolTip1.SetToolTip(this.chkExtEnable, "Check this box to enable the matrix to the left to control the X2 pins.");
            this.chkExtEnable.CheckedChanged += new System.EventHandler(this.chkExtEnable_CheckedChanged);
            // 
            // grpExtTX
            // 
            this.grpExtTX.Controls.Add(this.lblExtTXX26);
            this.grpExtTX.Controls.Add(this.chkExtTX26);
            this.grpExtTX.Controls.Add(this.chkExtTX66);
            this.grpExtTX.Controls.Add(this.chkExtTX106);
            this.grpExtTX.Controls.Add(this.chkExtTX126);
            this.grpExtTX.Controls.Add(this.chkExtTX156);
            this.grpExtTX.Controls.Add(this.chkExtTX176);
            this.grpExtTX.Controls.Add(this.chkExtTX206);
            this.grpExtTX.Controls.Add(this.chkExtTX306);
            this.grpExtTX.Controls.Add(this.chkExtTX406);
            this.grpExtTX.Controls.Add(this.chkExtTX606);
            this.grpExtTX.Controls.Add(this.chkExtTX806);
            this.grpExtTX.Controls.Add(this.chkExtTX1606);
            this.grpExtTX.Controls.Add(this.lblExtTXX25);
            this.grpExtTX.Controls.Add(this.lblExtTXX24);
            this.grpExtTX.Controls.Add(this.lblExtTXX23);
            this.grpExtTX.Controls.Add(this.lblExtTXX22);
            this.grpExtTX.Controls.Add(this.lblExtTX2);
            this.grpExtTX.Controls.Add(this.chkExtTX23);
            this.grpExtTX.Controls.Add(this.chkExtTX22);
            this.grpExtTX.Controls.Add(this.chkExtTX21);
            this.grpExtTX.Controls.Add(this.chkExtTX25);
            this.grpExtTX.Controls.Add(this.chkExtTX24);
            this.grpExtTX.Controls.Add(this.lblExtTX6);
            this.grpExtTX.Controls.Add(this.chkExtTX63);
            this.grpExtTX.Controls.Add(this.chkExtTX62);
            this.grpExtTX.Controls.Add(this.chkExtTX61);
            this.grpExtTX.Controls.Add(this.chkExtTX65);
            this.grpExtTX.Controls.Add(this.chkExtTX64);
            this.grpExtTX.Controls.Add(this.lblExtTX10);
            this.grpExtTX.Controls.Add(this.chkExtTX103);
            this.grpExtTX.Controls.Add(this.chkExtTX102);
            this.grpExtTX.Controls.Add(this.chkExtTX101);
            this.grpExtTX.Controls.Add(this.chkExtTX105);
            this.grpExtTX.Controls.Add(this.chkExtTX104);
            this.grpExtTX.Controls.Add(this.lblExtTX12);
            this.grpExtTX.Controls.Add(this.chkExtTX123);
            this.grpExtTX.Controls.Add(this.chkExtTX122);
            this.grpExtTX.Controls.Add(this.chkExtTX121);
            this.grpExtTX.Controls.Add(this.chkExtTX125);
            this.grpExtTX.Controls.Add(this.chkExtTX124);
            this.grpExtTX.Controls.Add(this.lblExtTX15);
            this.grpExtTX.Controls.Add(this.chkExtTX153);
            this.grpExtTX.Controls.Add(this.chkExtTX152);
            this.grpExtTX.Controls.Add(this.chkExtTX151);
            this.grpExtTX.Controls.Add(this.chkExtTX155);
            this.grpExtTX.Controls.Add(this.chkExtTX154);
            this.grpExtTX.Controls.Add(this.lblExtTX17);
            this.grpExtTX.Controls.Add(this.chkExtTX173);
            this.grpExtTX.Controls.Add(this.chkExtTX172);
            this.grpExtTX.Controls.Add(this.chkExtTX171);
            this.grpExtTX.Controls.Add(this.chkExtTX175);
            this.grpExtTX.Controls.Add(this.chkExtTX174);
            this.grpExtTX.Controls.Add(this.lblExtTX20);
            this.grpExtTX.Controls.Add(this.chkExtTX203);
            this.grpExtTX.Controls.Add(this.chkExtTX202);
            this.grpExtTX.Controls.Add(this.chkExtTX201);
            this.grpExtTX.Controls.Add(this.chkExtTX205);
            this.grpExtTX.Controls.Add(this.chkExtTX204);
            this.grpExtTX.Controls.Add(this.lblExtTX30);
            this.grpExtTX.Controls.Add(this.chkExtTX303);
            this.grpExtTX.Controls.Add(this.chkExtTX302);
            this.grpExtTX.Controls.Add(this.chkExtTX301);
            this.grpExtTX.Controls.Add(this.chkExtTX305);
            this.grpExtTX.Controls.Add(this.chkExtTX304);
            this.grpExtTX.Controls.Add(this.lblExtTX40);
            this.grpExtTX.Controls.Add(this.chkExtTX403);
            this.grpExtTX.Controls.Add(this.chkExtTX402);
            this.grpExtTX.Controls.Add(this.chkExtTX401);
            this.grpExtTX.Controls.Add(this.chkExtTX405);
            this.grpExtTX.Controls.Add(this.chkExtTX404);
            this.grpExtTX.Controls.Add(this.lblExtTX60);
            this.grpExtTX.Controls.Add(this.chkExtTX603);
            this.grpExtTX.Controls.Add(this.chkExtTX602);
            this.grpExtTX.Controls.Add(this.chkExtTX601);
            this.grpExtTX.Controls.Add(this.chkExtTX605);
            this.grpExtTX.Controls.Add(this.chkExtTX604);
            this.grpExtTX.Controls.Add(this.lblExtTX80);
            this.grpExtTX.Controls.Add(this.chkExtTX803);
            this.grpExtTX.Controls.Add(this.chkExtTX802);
            this.grpExtTX.Controls.Add(this.chkExtTX801);
            this.grpExtTX.Controls.Add(this.chkExtTX805);
            this.grpExtTX.Controls.Add(this.chkExtTX804);
            this.grpExtTX.Controls.Add(this.lblExtTXX2Pins);
            this.grpExtTX.Controls.Add(this.lblExtTXBand);
            this.grpExtTX.Controls.Add(this.lblExtTX160);
            this.grpExtTX.Controls.Add(this.chkExtTX1603);
            this.grpExtTX.Controls.Add(this.chkExtTX1602);
            this.grpExtTX.Controls.Add(this.chkExtTX1601);
            this.grpExtTX.Controls.Add(this.lblExtTXX21);
            this.grpExtTX.Controls.Add(this.chkExtTX1605);
            this.grpExtTX.Controls.Add(this.chkExtTX1604);
            this.grpExtTX.Enabled = false;
            this.grpExtTX.Location = new System.Drawing.Point(184, 8);
            this.grpExtTX.Name = "grpExtTX";
            this.grpExtTX.Size = new System.Drawing.Size(168, 264);
            this.grpExtTX.TabIndex = 8;
            this.grpExtTX.TabStop = false;
            this.grpExtTX.Text = "Transmit";
            // 
            // lblExtTXX26
            // 
            this.lblExtTXX26.Image = null;
            this.lblExtTXX26.Location = new System.Drawing.Point(144, 40);
            this.lblExtTXX26.Name = "lblExtTXX26";
            this.lblExtTXX26.Size = new System.Drawing.Size(16, 16);
            this.lblExtTXX26.TabIndex = 171;
            this.lblExtTXX26.Text = "6";
            this.lblExtTXX26.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // chkExtTX26
            // 
            this.chkExtTX26.Image = null;
            this.chkExtTX26.Location = new System.Drawing.Point(144, 240);
            this.chkExtTX26.Name = "chkExtTX26";
            this.chkExtTX26.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX26.TabIndex = 170;
            this.chkExtTX26.CheckedChanged += new System.EventHandler(this.chkExtTX2_CheckedChanged);
            // 
            // chkExtTX66
            // 
            this.chkExtTX66.Image = null;
            this.chkExtTX66.Location = new System.Drawing.Point(144, 224);
            this.chkExtTX66.Name = "chkExtTX66";
            this.chkExtTX66.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX66.TabIndex = 169;
            this.chkExtTX66.CheckedChanged += new System.EventHandler(this.chkExtTX6_CheckedChanged);
            // 
            // chkExtTX106
            // 
            this.chkExtTX106.Image = null;
            this.chkExtTX106.Location = new System.Drawing.Point(144, 208);
            this.chkExtTX106.Name = "chkExtTX106";
            this.chkExtTX106.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX106.TabIndex = 168;
            this.chkExtTX106.CheckedChanged += new System.EventHandler(this.chkExtTX10_CheckedChanged);
            // 
            // chkExtTX126
            // 
            this.chkExtTX126.Image = null;
            this.chkExtTX126.Location = new System.Drawing.Point(144, 192);
            this.chkExtTX126.Name = "chkExtTX126";
            this.chkExtTX126.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX126.TabIndex = 167;
            this.chkExtTX126.CheckedChanged += new System.EventHandler(this.chkExtTX12_CheckedChanged);
            // 
            // chkExtTX156
            // 
            this.chkExtTX156.Image = null;
            this.chkExtTX156.Location = new System.Drawing.Point(144, 176);
            this.chkExtTX156.Name = "chkExtTX156";
            this.chkExtTX156.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX156.TabIndex = 166;
            this.chkExtTX156.CheckedChanged += new System.EventHandler(this.chkExtTX15_CheckedChanged);
            // 
            // chkExtTX176
            // 
            this.chkExtTX176.Image = null;
            this.chkExtTX176.Location = new System.Drawing.Point(144, 160);
            this.chkExtTX176.Name = "chkExtTX176";
            this.chkExtTX176.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX176.TabIndex = 165;
            this.chkExtTX176.CheckedChanged += new System.EventHandler(this.chkExtTX17_CheckedChanged);
            // 
            // chkExtTX206
            // 
            this.chkExtTX206.Image = null;
            this.chkExtTX206.Location = new System.Drawing.Point(144, 144);
            this.chkExtTX206.Name = "chkExtTX206";
            this.chkExtTX206.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX206.TabIndex = 164;
            this.chkExtTX206.CheckedChanged += new System.EventHandler(this.chkExtTX20_CheckedChanged);
            // 
            // chkExtTX306
            // 
            this.chkExtTX306.Image = null;
            this.chkExtTX306.Location = new System.Drawing.Point(144, 128);
            this.chkExtTX306.Name = "chkExtTX306";
            this.chkExtTX306.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX306.TabIndex = 163;
            this.chkExtTX306.CheckedChanged += new System.EventHandler(this.chkExtTX30_CheckedChanged);
            // 
            // chkExtTX406
            // 
            this.chkExtTX406.Image = null;
            this.chkExtTX406.Location = new System.Drawing.Point(144, 112);
            this.chkExtTX406.Name = "chkExtTX406";
            this.chkExtTX406.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX406.TabIndex = 162;
            this.chkExtTX406.CheckedChanged += new System.EventHandler(this.chkExtTX40_CheckedChanged);
            // 
            // chkExtTX606
            // 
            this.chkExtTX606.Image = null;
            this.chkExtTX606.Location = new System.Drawing.Point(144, 96);
            this.chkExtTX606.Name = "chkExtTX606";
            this.chkExtTX606.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX606.TabIndex = 161;
            this.chkExtTX606.CheckedChanged += new System.EventHandler(this.chkExtTX60_CheckedChanged);
            // 
            // chkExtTX806
            // 
            this.chkExtTX806.Image = null;
            this.chkExtTX806.Location = new System.Drawing.Point(144, 80);
            this.chkExtTX806.Name = "chkExtTX806";
            this.chkExtTX806.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX806.TabIndex = 160;
            this.chkExtTX806.CheckedChanged += new System.EventHandler(this.chkExtTX80_CheckedChanged);
            // 
            // chkExtTX1606
            // 
            this.chkExtTX1606.Image = null;
            this.chkExtTX1606.Location = new System.Drawing.Point(144, 64);
            this.chkExtTX1606.Name = "chkExtTX1606";
            this.chkExtTX1606.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX1606.TabIndex = 159;
            this.chkExtTX1606.CheckedChanged += new System.EventHandler(this.chkExtTX160_CheckedChanged);
            // 
            // lblExtTXX25
            // 
            this.lblExtTXX25.Image = null;
            this.lblExtTXX25.Location = new System.Drawing.Point(128, 40);
            this.lblExtTXX25.Name = "lblExtTXX25";
            this.lblExtTXX25.Size = new System.Drawing.Size(16, 16);
            this.lblExtTXX25.TabIndex = 158;
            this.lblExtTXX25.Text = "5";
            this.lblExtTXX25.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtTXX24
            // 
            this.lblExtTXX24.Image = null;
            this.lblExtTXX24.Location = new System.Drawing.Point(112, 40);
            this.lblExtTXX24.Name = "lblExtTXX24";
            this.lblExtTXX24.Size = new System.Drawing.Size(16, 16);
            this.lblExtTXX24.TabIndex = 157;
            this.lblExtTXX24.Text = "4";
            this.lblExtTXX24.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtTXX23
            // 
            this.lblExtTXX23.Image = null;
            this.lblExtTXX23.Location = new System.Drawing.Point(96, 40);
            this.lblExtTXX23.Name = "lblExtTXX23";
            this.lblExtTXX23.Size = new System.Drawing.Size(16, 16);
            this.lblExtTXX23.TabIndex = 156;
            this.lblExtTXX23.Text = "3";
            this.lblExtTXX23.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtTXX22
            // 
            this.lblExtTXX22.Image = null;
            this.lblExtTXX22.Location = new System.Drawing.Point(80, 40);
            this.lblExtTXX22.Name = "lblExtTXX22";
            this.lblExtTXX22.Size = new System.Drawing.Size(16, 16);
            this.lblExtTXX22.TabIndex = 155;
            this.lblExtTXX22.Text = "2";
            this.lblExtTXX22.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtTX2
            // 
            this.lblExtTX2.Image = null;
            this.lblExtTX2.Location = new System.Drawing.Point(12, 240);
            this.lblExtTX2.Name = "lblExtTX2";
            this.lblExtTX2.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX2.TabIndex = 154;
            this.lblExtTX2.Text = "2m";
            // 
            // chkExtTX23
            // 
            this.chkExtTX23.Image = null;
            this.chkExtTX23.Location = new System.Drawing.Point(96, 240);
            this.chkExtTX23.Name = "chkExtTX23";
            this.chkExtTX23.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX23.TabIndex = 151;
            this.chkExtTX23.CheckedChanged += new System.EventHandler(this.chkExtTX2_CheckedChanged);
            // 
            // chkExtTX22
            // 
            this.chkExtTX22.Image = null;
            this.chkExtTX22.Location = new System.Drawing.Point(80, 240);
            this.chkExtTX22.Name = "chkExtTX22";
            this.chkExtTX22.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX22.TabIndex = 150;
            this.chkExtTX22.CheckedChanged += new System.EventHandler(this.chkExtTX2_CheckedChanged);
            // 
            // chkExtTX21
            // 
            this.chkExtTX21.Image = null;
            this.chkExtTX21.Location = new System.Drawing.Point(64, 240);
            this.chkExtTX21.Name = "chkExtTX21";
            this.chkExtTX21.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX21.TabIndex = 149;
            this.chkExtTX21.CheckedChanged += new System.EventHandler(this.chkExtTX2_CheckedChanged);
            // 
            // chkExtTX25
            // 
            this.chkExtTX25.Image = null;
            this.chkExtTX25.Location = new System.Drawing.Point(128, 240);
            this.chkExtTX25.Name = "chkExtTX25";
            this.chkExtTX25.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX25.TabIndex = 153;
            this.chkExtTX25.CheckedChanged += new System.EventHandler(this.chkExtTX2_CheckedChanged);
            // 
            // chkExtTX24
            // 
            this.chkExtTX24.Image = null;
            this.chkExtTX24.Location = new System.Drawing.Point(112, 240);
            this.chkExtTX24.Name = "chkExtTX24";
            this.chkExtTX24.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX24.TabIndex = 152;
            this.chkExtTX24.CheckedChanged += new System.EventHandler(this.chkExtTX2_CheckedChanged);
            // 
            // lblExtTX6
            // 
            this.lblExtTX6.Image = null;
            this.lblExtTX6.Location = new System.Drawing.Point(12, 224);
            this.lblExtTX6.Name = "lblExtTX6";
            this.lblExtTX6.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX6.TabIndex = 148;
            this.lblExtTX6.Text = "6m";
            // 
            // chkExtTX63
            // 
            this.chkExtTX63.Image = null;
            this.chkExtTX63.Location = new System.Drawing.Point(96, 224);
            this.chkExtTX63.Name = "chkExtTX63";
            this.chkExtTX63.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX63.TabIndex = 145;
            this.chkExtTX63.CheckedChanged += new System.EventHandler(this.chkExtTX6_CheckedChanged);
            // 
            // chkExtTX62
            // 
            this.chkExtTX62.Image = null;
            this.chkExtTX62.Location = new System.Drawing.Point(80, 224);
            this.chkExtTX62.Name = "chkExtTX62";
            this.chkExtTX62.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX62.TabIndex = 144;
            this.chkExtTX62.CheckedChanged += new System.EventHandler(this.chkExtTX6_CheckedChanged);
            // 
            // chkExtTX61
            // 
            this.chkExtTX61.Image = null;
            this.chkExtTX61.Location = new System.Drawing.Point(64, 224);
            this.chkExtTX61.Name = "chkExtTX61";
            this.chkExtTX61.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX61.TabIndex = 143;
            this.chkExtTX61.CheckedChanged += new System.EventHandler(this.chkExtTX6_CheckedChanged);
            // 
            // chkExtTX65
            // 
            this.chkExtTX65.Image = null;
            this.chkExtTX65.Location = new System.Drawing.Point(128, 224);
            this.chkExtTX65.Name = "chkExtTX65";
            this.chkExtTX65.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX65.TabIndex = 147;
            this.chkExtTX65.CheckedChanged += new System.EventHandler(this.chkExtTX6_CheckedChanged);
            // 
            // chkExtTX64
            // 
            this.chkExtTX64.Image = null;
            this.chkExtTX64.Location = new System.Drawing.Point(112, 224);
            this.chkExtTX64.Name = "chkExtTX64";
            this.chkExtTX64.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX64.TabIndex = 146;
            this.chkExtTX64.CheckedChanged += new System.EventHandler(this.chkExtTX6_CheckedChanged);
            // 
            // lblExtTX10
            // 
            this.lblExtTX10.Image = null;
            this.lblExtTX10.Location = new System.Drawing.Point(12, 208);
            this.lblExtTX10.Name = "lblExtTX10";
            this.lblExtTX10.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX10.TabIndex = 142;
            this.lblExtTX10.Text = "10m";
            // 
            // chkExtTX103
            // 
            this.chkExtTX103.Image = null;
            this.chkExtTX103.Location = new System.Drawing.Point(96, 208);
            this.chkExtTX103.Name = "chkExtTX103";
            this.chkExtTX103.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX103.TabIndex = 139;
            this.chkExtTX103.CheckedChanged += new System.EventHandler(this.chkExtTX10_CheckedChanged);
            // 
            // chkExtTX102
            // 
            this.chkExtTX102.Image = null;
            this.chkExtTX102.Location = new System.Drawing.Point(80, 208);
            this.chkExtTX102.Name = "chkExtTX102";
            this.chkExtTX102.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX102.TabIndex = 138;
            this.chkExtTX102.CheckedChanged += new System.EventHandler(this.chkExtTX10_CheckedChanged);
            // 
            // chkExtTX101
            // 
            this.chkExtTX101.Image = null;
            this.chkExtTX101.Location = new System.Drawing.Point(64, 208);
            this.chkExtTX101.Name = "chkExtTX101";
            this.chkExtTX101.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX101.TabIndex = 137;
            this.chkExtTX101.CheckedChanged += new System.EventHandler(this.chkExtTX10_CheckedChanged);
            // 
            // chkExtTX105
            // 
            this.chkExtTX105.Image = null;
            this.chkExtTX105.Location = new System.Drawing.Point(128, 208);
            this.chkExtTX105.Name = "chkExtTX105";
            this.chkExtTX105.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX105.TabIndex = 141;
            this.chkExtTX105.CheckedChanged += new System.EventHandler(this.chkExtTX10_CheckedChanged);
            // 
            // chkExtTX104
            // 
            this.chkExtTX104.Image = null;
            this.chkExtTX104.Location = new System.Drawing.Point(112, 208);
            this.chkExtTX104.Name = "chkExtTX104";
            this.chkExtTX104.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX104.TabIndex = 140;
            this.chkExtTX104.CheckedChanged += new System.EventHandler(this.chkExtTX10_CheckedChanged);
            // 
            // lblExtTX12
            // 
            this.lblExtTX12.Image = null;
            this.lblExtTX12.Location = new System.Drawing.Point(12, 192);
            this.lblExtTX12.Name = "lblExtTX12";
            this.lblExtTX12.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX12.TabIndex = 136;
            this.lblExtTX12.Text = "12m";
            // 
            // chkExtTX123
            // 
            this.chkExtTX123.Image = null;
            this.chkExtTX123.Location = new System.Drawing.Point(96, 192);
            this.chkExtTX123.Name = "chkExtTX123";
            this.chkExtTX123.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX123.TabIndex = 133;
            this.chkExtTX123.CheckedChanged += new System.EventHandler(this.chkExtTX12_CheckedChanged);
            // 
            // chkExtTX122
            // 
            this.chkExtTX122.Image = null;
            this.chkExtTX122.Location = new System.Drawing.Point(80, 192);
            this.chkExtTX122.Name = "chkExtTX122";
            this.chkExtTX122.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX122.TabIndex = 132;
            this.chkExtTX122.CheckedChanged += new System.EventHandler(this.chkExtTX12_CheckedChanged);
            // 
            // chkExtTX121
            // 
            this.chkExtTX121.Image = null;
            this.chkExtTX121.Location = new System.Drawing.Point(64, 192);
            this.chkExtTX121.Name = "chkExtTX121";
            this.chkExtTX121.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX121.TabIndex = 131;
            this.chkExtTX121.CheckedChanged += new System.EventHandler(this.chkExtTX12_CheckedChanged);
            // 
            // chkExtTX125
            // 
            this.chkExtTX125.Image = null;
            this.chkExtTX125.Location = new System.Drawing.Point(128, 192);
            this.chkExtTX125.Name = "chkExtTX125";
            this.chkExtTX125.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX125.TabIndex = 135;
            this.chkExtTX125.CheckedChanged += new System.EventHandler(this.chkExtTX12_CheckedChanged);
            // 
            // chkExtTX124
            // 
            this.chkExtTX124.Image = null;
            this.chkExtTX124.Location = new System.Drawing.Point(112, 192);
            this.chkExtTX124.Name = "chkExtTX124";
            this.chkExtTX124.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX124.TabIndex = 134;
            this.chkExtTX124.CheckedChanged += new System.EventHandler(this.chkExtTX12_CheckedChanged);
            // 
            // lblExtTX15
            // 
            this.lblExtTX15.Image = null;
            this.lblExtTX15.Location = new System.Drawing.Point(12, 176);
            this.lblExtTX15.Name = "lblExtTX15";
            this.lblExtTX15.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX15.TabIndex = 130;
            this.lblExtTX15.Text = "15m";
            // 
            // chkExtTX153
            // 
            this.chkExtTX153.Image = null;
            this.chkExtTX153.Location = new System.Drawing.Point(96, 176);
            this.chkExtTX153.Name = "chkExtTX153";
            this.chkExtTX153.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX153.TabIndex = 127;
            this.chkExtTX153.CheckedChanged += new System.EventHandler(this.chkExtTX15_CheckedChanged);
            // 
            // chkExtTX152
            // 
            this.chkExtTX152.Image = null;
            this.chkExtTX152.Location = new System.Drawing.Point(80, 176);
            this.chkExtTX152.Name = "chkExtTX152";
            this.chkExtTX152.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX152.TabIndex = 126;
            this.chkExtTX152.CheckedChanged += new System.EventHandler(this.chkExtTX15_CheckedChanged);
            // 
            // chkExtTX151
            // 
            this.chkExtTX151.Image = null;
            this.chkExtTX151.Location = new System.Drawing.Point(64, 176);
            this.chkExtTX151.Name = "chkExtTX151";
            this.chkExtTX151.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX151.TabIndex = 125;
            this.chkExtTX151.CheckedChanged += new System.EventHandler(this.chkExtTX15_CheckedChanged);
            // 
            // chkExtTX155
            // 
            this.chkExtTX155.Image = null;
            this.chkExtTX155.Location = new System.Drawing.Point(128, 176);
            this.chkExtTX155.Name = "chkExtTX155";
            this.chkExtTX155.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX155.TabIndex = 129;
            this.chkExtTX155.CheckedChanged += new System.EventHandler(this.chkExtTX15_CheckedChanged);
            // 
            // chkExtTX154
            // 
            this.chkExtTX154.Image = null;
            this.chkExtTX154.Location = new System.Drawing.Point(112, 176);
            this.chkExtTX154.Name = "chkExtTX154";
            this.chkExtTX154.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX154.TabIndex = 128;
            this.chkExtTX154.CheckedChanged += new System.EventHandler(this.chkExtTX15_CheckedChanged);
            // 
            // lblExtTX17
            // 
            this.lblExtTX17.Image = null;
            this.lblExtTX17.Location = new System.Drawing.Point(12, 160);
            this.lblExtTX17.Name = "lblExtTX17";
            this.lblExtTX17.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX17.TabIndex = 124;
            this.lblExtTX17.Text = "17m";
            // 
            // chkExtTX173
            // 
            this.chkExtTX173.Image = null;
            this.chkExtTX173.Location = new System.Drawing.Point(96, 160);
            this.chkExtTX173.Name = "chkExtTX173";
            this.chkExtTX173.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX173.TabIndex = 121;
            this.chkExtTX173.CheckedChanged += new System.EventHandler(this.chkExtTX17_CheckedChanged);
            // 
            // chkExtTX172
            // 
            this.chkExtTX172.Image = null;
            this.chkExtTX172.Location = new System.Drawing.Point(80, 160);
            this.chkExtTX172.Name = "chkExtTX172";
            this.chkExtTX172.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX172.TabIndex = 120;
            this.chkExtTX172.CheckedChanged += new System.EventHandler(this.chkExtTX17_CheckedChanged);
            // 
            // chkExtTX171
            // 
            this.chkExtTX171.Image = null;
            this.chkExtTX171.Location = new System.Drawing.Point(64, 160);
            this.chkExtTX171.Name = "chkExtTX171";
            this.chkExtTX171.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX171.TabIndex = 119;
            this.chkExtTX171.CheckedChanged += new System.EventHandler(this.chkExtTX17_CheckedChanged);
            // 
            // chkExtTX175
            // 
            this.chkExtTX175.Image = null;
            this.chkExtTX175.Location = new System.Drawing.Point(128, 160);
            this.chkExtTX175.Name = "chkExtTX175";
            this.chkExtTX175.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX175.TabIndex = 123;
            this.chkExtTX175.CheckedChanged += new System.EventHandler(this.chkExtTX17_CheckedChanged);
            // 
            // chkExtTX174
            // 
            this.chkExtTX174.Image = null;
            this.chkExtTX174.Location = new System.Drawing.Point(112, 160);
            this.chkExtTX174.Name = "chkExtTX174";
            this.chkExtTX174.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX174.TabIndex = 122;
            this.chkExtTX174.CheckedChanged += new System.EventHandler(this.chkExtTX17_CheckedChanged);
            // 
            // lblExtTX20
            // 
            this.lblExtTX20.Image = null;
            this.lblExtTX20.Location = new System.Drawing.Point(12, 144);
            this.lblExtTX20.Name = "lblExtTX20";
            this.lblExtTX20.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX20.TabIndex = 118;
            this.lblExtTX20.Text = "20m";
            // 
            // chkExtTX203
            // 
            this.chkExtTX203.Image = null;
            this.chkExtTX203.Location = new System.Drawing.Point(96, 144);
            this.chkExtTX203.Name = "chkExtTX203";
            this.chkExtTX203.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX203.TabIndex = 115;
            this.chkExtTX203.CheckedChanged += new System.EventHandler(this.chkExtTX20_CheckedChanged);
            // 
            // chkExtTX202
            // 
            this.chkExtTX202.Image = null;
            this.chkExtTX202.Location = new System.Drawing.Point(80, 144);
            this.chkExtTX202.Name = "chkExtTX202";
            this.chkExtTX202.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX202.TabIndex = 114;
            this.chkExtTX202.CheckedChanged += new System.EventHandler(this.chkExtTX20_CheckedChanged);
            // 
            // chkExtTX201
            // 
            this.chkExtTX201.Image = null;
            this.chkExtTX201.Location = new System.Drawing.Point(64, 144);
            this.chkExtTX201.Name = "chkExtTX201";
            this.chkExtTX201.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX201.TabIndex = 113;
            this.chkExtTX201.CheckedChanged += new System.EventHandler(this.chkExtTX20_CheckedChanged);
            // 
            // chkExtTX205
            // 
            this.chkExtTX205.Image = null;
            this.chkExtTX205.Location = new System.Drawing.Point(128, 144);
            this.chkExtTX205.Name = "chkExtTX205";
            this.chkExtTX205.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX205.TabIndex = 117;
            this.chkExtTX205.CheckedChanged += new System.EventHandler(this.chkExtTX20_CheckedChanged);
            // 
            // chkExtTX204
            // 
            this.chkExtTX204.Image = null;
            this.chkExtTX204.Location = new System.Drawing.Point(112, 144);
            this.chkExtTX204.Name = "chkExtTX204";
            this.chkExtTX204.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX204.TabIndex = 116;
            this.chkExtTX204.CheckedChanged += new System.EventHandler(this.chkExtTX20_CheckedChanged);
            // 
            // lblExtTX30
            // 
            this.lblExtTX30.Image = null;
            this.lblExtTX30.Location = new System.Drawing.Point(12, 128);
            this.lblExtTX30.Name = "lblExtTX30";
            this.lblExtTX30.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX30.TabIndex = 112;
            this.lblExtTX30.Text = "30m";
            // 
            // chkExtTX303
            // 
            this.chkExtTX303.Image = null;
            this.chkExtTX303.Location = new System.Drawing.Point(96, 128);
            this.chkExtTX303.Name = "chkExtTX303";
            this.chkExtTX303.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX303.TabIndex = 109;
            this.chkExtTX303.CheckedChanged += new System.EventHandler(this.chkExtTX30_CheckedChanged);
            // 
            // chkExtTX302
            // 
            this.chkExtTX302.Image = null;
            this.chkExtTX302.Location = new System.Drawing.Point(80, 128);
            this.chkExtTX302.Name = "chkExtTX302";
            this.chkExtTX302.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX302.TabIndex = 108;
            this.chkExtTX302.CheckedChanged += new System.EventHandler(this.chkExtTX30_CheckedChanged);
            // 
            // chkExtTX301
            // 
            this.chkExtTX301.Image = null;
            this.chkExtTX301.Location = new System.Drawing.Point(64, 128);
            this.chkExtTX301.Name = "chkExtTX301";
            this.chkExtTX301.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX301.TabIndex = 107;
            this.chkExtTX301.CheckedChanged += new System.EventHandler(this.chkExtTX30_CheckedChanged);
            // 
            // chkExtTX305
            // 
            this.chkExtTX305.Image = null;
            this.chkExtTX305.Location = new System.Drawing.Point(128, 128);
            this.chkExtTX305.Name = "chkExtTX305";
            this.chkExtTX305.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX305.TabIndex = 111;
            this.chkExtTX305.CheckedChanged += new System.EventHandler(this.chkExtTX30_CheckedChanged);
            // 
            // chkExtTX304
            // 
            this.chkExtTX304.Image = null;
            this.chkExtTX304.Location = new System.Drawing.Point(112, 128);
            this.chkExtTX304.Name = "chkExtTX304";
            this.chkExtTX304.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX304.TabIndex = 110;
            this.chkExtTX304.CheckedChanged += new System.EventHandler(this.chkExtTX30_CheckedChanged);
            // 
            // lblExtTX40
            // 
            this.lblExtTX40.Image = null;
            this.lblExtTX40.Location = new System.Drawing.Point(12, 112);
            this.lblExtTX40.Name = "lblExtTX40";
            this.lblExtTX40.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX40.TabIndex = 106;
            this.lblExtTX40.Text = "40m";
            // 
            // chkExtTX403
            // 
            this.chkExtTX403.Image = null;
            this.chkExtTX403.Location = new System.Drawing.Point(96, 112);
            this.chkExtTX403.Name = "chkExtTX403";
            this.chkExtTX403.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX403.TabIndex = 103;
            this.chkExtTX403.CheckedChanged += new System.EventHandler(this.chkExtTX40_CheckedChanged);
            // 
            // chkExtTX402
            // 
            this.chkExtTX402.Image = null;
            this.chkExtTX402.Location = new System.Drawing.Point(80, 112);
            this.chkExtTX402.Name = "chkExtTX402";
            this.chkExtTX402.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX402.TabIndex = 102;
            this.chkExtTX402.CheckedChanged += new System.EventHandler(this.chkExtTX40_CheckedChanged);
            // 
            // chkExtTX401
            // 
            this.chkExtTX401.Image = null;
            this.chkExtTX401.Location = new System.Drawing.Point(64, 112);
            this.chkExtTX401.Name = "chkExtTX401";
            this.chkExtTX401.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX401.TabIndex = 101;
            this.chkExtTX401.CheckedChanged += new System.EventHandler(this.chkExtTX40_CheckedChanged);
            // 
            // chkExtTX405
            // 
            this.chkExtTX405.Image = null;
            this.chkExtTX405.Location = new System.Drawing.Point(128, 112);
            this.chkExtTX405.Name = "chkExtTX405";
            this.chkExtTX405.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX405.TabIndex = 105;
            this.chkExtTX405.CheckedChanged += new System.EventHandler(this.chkExtTX40_CheckedChanged);
            // 
            // chkExtTX404
            // 
            this.chkExtTX404.Image = null;
            this.chkExtTX404.Location = new System.Drawing.Point(112, 112);
            this.chkExtTX404.Name = "chkExtTX404";
            this.chkExtTX404.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX404.TabIndex = 104;
            this.chkExtTX404.CheckedChanged += new System.EventHandler(this.chkExtTX40_CheckedChanged);
            // 
            // lblExtTX60
            // 
            this.lblExtTX60.Image = null;
            this.lblExtTX60.Location = new System.Drawing.Point(12, 96);
            this.lblExtTX60.Name = "lblExtTX60";
            this.lblExtTX60.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX60.TabIndex = 100;
            this.lblExtTX60.Text = "60m";
            // 
            // chkExtTX603
            // 
            this.chkExtTX603.Image = null;
            this.chkExtTX603.Location = new System.Drawing.Point(96, 96);
            this.chkExtTX603.Name = "chkExtTX603";
            this.chkExtTX603.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX603.TabIndex = 97;
            this.chkExtTX603.CheckedChanged += new System.EventHandler(this.chkExtTX60_CheckedChanged);
            // 
            // chkExtTX602
            // 
            this.chkExtTX602.Image = null;
            this.chkExtTX602.Location = new System.Drawing.Point(80, 96);
            this.chkExtTX602.Name = "chkExtTX602";
            this.chkExtTX602.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX602.TabIndex = 96;
            this.chkExtTX602.CheckedChanged += new System.EventHandler(this.chkExtTX60_CheckedChanged);
            // 
            // chkExtTX601
            // 
            this.chkExtTX601.Image = null;
            this.chkExtTX601.Location = new System.Drawing.Point(64, 96);
            this.chkExtTX601.Name = "chkExtTX601";
            this.chkExtTX601.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX601.TabIndex = 95;
            this.chkExtTX601.CheckedChanged += new System.EventHandler(this.chkExtTX60_CheckedChanged);
            // 
            // chkExtTX605
            // 
            this.chkExtTX605.Image = null;
            this.chkExtTX605.Location = new System.Drawing.Point(128, 96);
            this.chkExtTX605.Name = "chkExtTX605";
            this.chkExtTX605.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX605.TabIndex = 99;
            this.chkExtTX605.CheckedChanged += new System.EventHandler(this.chkExtTX60_CheckedChanged);
            // 
            // chkExtTX604
            // 
            this.chkExtTX604.Image = null;
            this.chkExtTX604.Location = new System.Drawing.Point(112, 96);
            this.chkExtTX604.Name = "chkExtTX604";
            this.chkExtTX604.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX604.TabIndex = 98;
            this.chkExtTX604.CheckedChanged += new System.EventHandler(this.chkExtTX60_CheckedChanged);
            // 
            // lblExtTX80
            // 
            this.lblExtTX80.Image = null;
            this.lblExtTX80.Location = new System.Drawing.Point(12, 80);
            this.lblExtTX80.Name = "lblExtTX80";
            this.lblExtTX80.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX80.TabIndex = 94;
            this.lblExtTX80.Text = "80m";
            // 
            // chkExtTX803
            // 
            this.chkExtTX803.Image = null;
            this.chkExtTX803.Location = new System.Drawing.Point(96, 80);
            this.chkExtTX803.Name = "chkExtTX803";
            this.chkExtTX803.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX803.TabIndex = 91;
            this.chkExtTX803.CheckedChanged += new System.EventHandler(this.chkExtTX80_CheckedChanged);
            // 
            // chkExtTX802
            // 
            this.chkExtTX802.Image = null;
            this.chkExtTX802.Location = new System.Drawing.Point(80, 80);
            this.chkExtTX802.Name = "chkExtTX802";
            this.chkExtTX802.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX802.TabIndex = 90;
            this.chkExtTX802.CheckedChanged += new System.EventHandler(this.chkExtTX80_CheckedChanged);
            // 
            // chkExtTX801
            // 
            this.chkExtTX801.Image = null;
            this.chkExtTX801.Location = new System.Drawing.Point(64, 80);
            this.chkExtTX801.Name = "chkExtTX801";
            this.chkExtTX801.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX801.TabIndex = 89;
            this.chkExtTX801.CheckedChanged += new System.EventHandler(this.chkExtTX80_CheckedChanged);
            // 
            // chkExtTX805
            // 
            this.chkExtTX805.Image = null;
            this.chkExtTX805.Location = new System.Drawing.Point(128, 80);
            this.chkExtTX805.Name = "chkExtTX805";
            this.chkExtTX805.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX805.TabIndex = 93;
            this.chkExtTX805.CheckedChanged += new System.EventHandler(this.chkExtTX80_CheckedChanged);
            // 
            // chkExtTX804
            // 
            this.chkExtTX804.Image = null;
            this.chkExtTX804.Location = new System.Drawing.Point(112, 80);
            this.chkExtTX804.Name = "chkExtTX804";
            this.chkExtTX804.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX804.TabIndex = 92;
            this.chkExtTX804.CheckedChanged += new System.EventHandler(this.chkExtTX80_CheckedChanged);
            // 
            // lblExtTXX2Pins
            // 
            this.lblExtTXX2Pins.Image = null;
            this.lblExtTXX2Pins.Location = new System.Drawing.Point(60, 24);
            this.lblExtTXX2Pins.Name = "lblExtTXX2Pins";
            this.lblExtTXX2Pins.Size = new System.Drawing.Size(100, 16);
            this.lblExtTXX2Pins.TabIndex = 88;
            this.lblExtTXX2Pins.Text = "X2 Pins";
            this.lblExtTXX2Pins.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtTXBand
            // 
            this.lblExtTXBand.Image = null;
            this.lblExtTXBand.Location = new System.Drawing.Point(12, 24);
            this.lblExtTXBand.Name = "lblExtTXBand";
            this.lblExtTXBand.Size = new System.Drawing.Size(32, 16);
            this.lblExtTXBand.TabIndex = 87;
            this.lblExtTXBand.Text = "Band";
            // 
            // lblExtTX160
            // 
            this.lblExtTX160.Image = null;
            this.lblExtTX160.Location = new System.Drawing.Point(12, 64);
            this.lblExtTX160.Name = "lblExtTX160";
            this.lblExtTX160.Size = new System.Drawing.Size(40, 16);
            this.lblExtTX160.TabIndex = 86;
            this.lblExtTX160.Text = "160m";
            // 
            // chkExtTX1603
            // 
            this.chkExtTX1603.Image = null;
            this.chkExtTX1603.Location = new System.Drawing.Point(96, 64);
            this.chkExtTX1603.Name = "chkExtTX1603";
            this.chkExtTX1603.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX1603.TabIndex = 82;
            this.chkExtTX1603.CheckedChanged += new System.EventHandler(this.chkExtTX160_CheckedChanged);
            // 
            // chkExtTX1602
            // 
            this.chkExtTX1602.Image = null;
            this.chkExtTX1602.Location = new System.Drawing.Point(80, 64);
            this.chkExtTX1602.Name = "chkExtTX1602";
            this.chkExtTX1602.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX1602.TabIndex = 81;
            this.chkExtTX1602.CheckedChanged += new System.EventHandler(this.chkExtTX160_CheckedChanged);
            // 
            // chkExtTX1601
            // 
            this.chkExtTX1601.Image = null;
            this.chkExtTX1601.Location = new System.Drawing.Point(64, 64);
            this.chkExtTX1601.Name = "chkExtTX1601";
            this.chkExtTX1601.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX1601.TabIndex = 80;
            this.chkExtTX1601.CheckedChanged += new System.EventHandler(this.chkExtTX160_CheckedChanged);
            // 
            // lblExtTXX21
            // 
            this.lblExtTXX21.Image = null;
            this.lblExtTXX21.Location = new System.Drawing.Point(64, 40);
            this.lblExtTXX21.Name = "lblExtTXX21";
            this.lblExtTXX21.Size = new System.Drawing.Size(16, 16);
            this.lblExtTXX21.TabIndex = 85;
            this.lblExtTXX21.Text = "1";
            this.lblExtTXX21.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // chkExtTX1605
            // 
            this.chkExtTX1605.Image = null;
            this.chkExtTX1605.Location = new System.Drawing.Point(128, 64);
            this.chkExtTX1605.Name = "chkExtTX1605";
            this.chkExtTX1605.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX1605.TabIndex = 84;
            this.chkExtTX1605.CheckedChanged += new System.EventHandler(this.chkExtTX160_CheckedChanged);
            // 
            // chkExtTX1604
            // 
            this.chkExtTX1604.Image = null;
            this.chkExtTX1604.Location = new System.Drawing.Point(112, 64);
            this.chkExtTX1604.Name = "chkExtTX1604";
            this.chkExtTX1604.Size = new System.Drawing.Size(16, 16);
            this.chkExtTX1604.TabIndex = 83;
            this.chkExtTX1604.CheckedChanged += new System.EventHandler(this.chkExtTX160_CheckedChanged);
            // 
            // grpExtRX
            // 
            this.grpExtRX.Controls.Add(this.lblExtRXX26);
            this.grpExtRX.Controls.Add(this.chkExtRX26);
            this.grpExtRX.Controls.Add(this.chkExtRX66);
            this.grpExtRX.Controls.Add(this.chkExtRX106);
            this.grpExtRX.Controls.Add(this.chkExtRX126);
            this.grpExtRX.Controls.Add(this.chkExtRX156);
            this.grpExtRX.Controls.Add(this.chkExtRX176);
            this.grpExtRX.Controls.Add(this.chkExtRX206);
            this.grpExtRX.Controls.Add(this.chkExtRX306);
            this.grpExtRX.Controls.Add(this.chkExtRX406);
            this.grpExtRX.Controls.Add(this.chkExtRX606);
            this.grpExtRX.Controls.Add(this.chkExtRX806);
            this.grpExtRX.Controls.Add(this.chkExtRX1606);
            this.grpExtRX.Controls.Add(this.lblExtRXX25);
            this.grpExtRX.Controls.Add(this.lblExtRXX24);
            this.grpExtRX.Controls.Add(this.lblExtRXX23);
            this.grpExtRX.Controls.Add(this.lblExtRXX22);
            this.grpExtRX.Controls.Add(this.lblExtRX2);
            this.grpExtRX.Controls.Add(this.chkExtRX23);
            this.grpExtRX.Controls.Add(this.chkExtRX22);
            this.grpExtRX.Controls.Add(this.chkExtRX21);
            this.grpExtRX.Controls.Add(this.chkExtRX25);
            this.grpExtRX.Controls.Add(this.chkExtRX24);
            this.grpExtRX.Controls.Add(this.lblExtRX6);
            this.grpExtRX.Controls.Add(this.chkExtRX63);
            this.grpExtRX.Controls.Add(this.chkExtRX62);
            this.grpExtRX.Controls.Add(this.chkExtRX61);
            this.grpExtRX.Controls.Add(this.chkExtRX65);
            this.grpExtRX.Controls.Add(this.chkExtRX64);
            this.grpExtRX.Controls.Add(this.lblExtRX10);
            this.grpExtRX.Controls.Add(this.chkExtRX103);
            this.grpExtRX.Controls.Add(this.chkExtRX102);
            this.grpExtRX.Controls.Add(this.chkExtRX101);
            this.grpExtRX.Controls.Add(this.chkExtRX105);
            this.grpExtRX.Controls.Add(this.chkExtRX104);
            this.grpExtRX.Controls.Add(this.lblExtRX12);
            this.grpExtRX.Controls.Add(this.chkExtRX123);
            this.grpExtRX.Controls.Add(this.chkExtRX122);
            this.grpExtRX.Controls.Add(this.chkExtRX121);
            this.grpExtRX.Controls.Add(this.chkExtRX125);
            this.grpExtRX.Controls.Add(this.chkExtRX124);
            this.grpExtRX.Controls.Add(this.lblExtRX15);
            this.grpExtRX.Controls.Add(this.chkExtRX153);
            this.grpExtRX.Controls.Add(this.chkExtRX152);
            this.grpExtRX.Controls.Add(this.chkExtRX151);
            this.grpExtRX.Controls.Add(this.chkExtRX155);
            this.grpExtRX.Controls.Add(this.chkExtRX154);
            this.grpExtRX.Controls.Add(this.lblExtRX17);
            this.grpExtRX.Controls.Add(this.chkExtRX173);
            this.grpExtRX.Controls.Add(this.chkExtRX172);
            this.grpExtRX.Controls.Add(this.chkExtRX171);
            this.grpExtRX.Controls.Add(this.chkExtRX175);
            this.grpExtRX.Controls.Add(this.chkExtRX174);
            this.grpExtRX.Controls.Add(this.lblExtRX20);
            this.grpExtRX.Controls.Add(this.chkExtRX203);
            this.grpExtRX.Controls.Add(this.chkExtRX202);
            this.grpExtRX.Controls.Add(this.chkExtRX201);
            this.grpExtRX.Controls.Add(this.chkExtRX205);
            this.grpExtRX.Controls.Add(this.chkExtRX204);
            this.grpExtRX.Controls.Add(this.lblExtRX30);
            this.grpExtRX.Controls.Add(this.chkExtRX303);
            this.grpExtRX.Controls.Add(this.chkExtRX302);
            this.grpExtRX.Controls.Add(this.chkExtRX301);
            this.grpExtRX.Controls.Add(this.chkExtRX305);
            this.grpExtRX.Controls.Add(this.chkExtRX304);
            this.grpExtRX.Controls.Add(this.lblExtRX40);
            this.grpExtRX.Controls.Add(this.chkExtRX403);
            this.grpExtRX.Controls.Add(this.chkExtRX402);
            this.grpExtRX.Controls.Add(this.chkExtRX401);
            this.grpExtRX.Controls.Add(this.chkExtRX405);
            this.grpExtRX.Controls.Add(this.chkExtRX404);
            this.grpExtRX.Controls.Add(this.lblExtRX60);
            this.grpExtRX.Controls.Add(this.chkExtRX603);
            this.grpExtRX.Controls.Add(this.chkExtRX602);
            this.grpExtRX.Controls.Add(this.chkExtRX601);
            this.grpExtRX.Controls.Add(this.chkExtRX605);
            this.grpExtRX.Controls.Add(this.chkExtRX604);
            this.grpExtRX.Controls.Add(this.lblExtRX80);
            this.grpExtRX.Controls.Add(this.chkExtRX803);
            this.grpExtRX.Controls.Add(this.chkExtRX802);
            this.grpExtRX.Controls.Add(this.chkExtRX801);
            this.grpExtRX.Controls.Add(this.chkExtRX805);
            this.grpExtRX.Controls.Add(this.chkExtRX804);
            this.grpExtRX.Controls.Add(this.lblExtRXX2Pins);
            this.grpExtRX.Controls.Add(this.lblExtRXBand);
            this.grpExtRX.Controls.Add(this.lblExtRX160);
            this.grpExtRX.Controls.Add(this.chkExtRX1603);
            this.grpExtRX.Controls.Add(this.chkExtRX1602);
            this.grpExtRX.Controls.Add(this.chkExtRX1601);
            this.grpExtRX.Controls.Add(this.lblExtRXX21);
            this.grpExtRX.Controls.Add(this.chkExtRX1605);
            this.grpExtRX.Controls.Add(this.chkExtRX1604);
            this.grpExtRX.Enabled = false;
            this.grpExtRX.Location = new System.Drawing.Point(8, 8);
            this.grpExtRX.Name = "grpExtRX";
            this.grpExtRX.Size = new System.Drawing.Size(168, 264);
            this.grpExtRX.TabIndex = 7;
            this.grpExtRX.TabStop = false;
            this.grpExtRX.Text = "Receive";
            // 
            // lblExtRXX26
            // 
            this.lblExtRXX26.Image = null;
            this.lblExtRXX26.Location = new System.Drawing.Point(144, 40);
            this.lblExtRXX26.Name = "lblExtRXX26";
            this.lblExtRXX26.Size = new System.Drawing.Size(16, 16);
            this.lblExtRXX26.TabIndex = 92;
            this.lblExtRXX26.Text = "6";
            this.lblExtRXX26.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // chkExtRX26
            // 
            this.chkExtRX26.Image = null;
            this.chkExtRX26.Location = new System.Drawing.Point(144, 240);
            this.chkExtRX26.Name = "chkExtRX26";
            this.chkExtRX26.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX26.TabIndex = 91;
            this.chkExtRX26.CheckedChanged += new System.EventHandler(this.chkExtRX2_CheckedChanged);
            // 
            // chkExtRX66
            // 
            this.chkExtRX66.Image = null;
            this.chkExtRX66.Location = new System.Drawing.Point(144, 224);
            this.chkExtRX66.Name = "chkExtRX66";
            this.chkExtRX66.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX66.TabIndex = 90;
            this.chkExtRX66.CheckedChanged += new System.EventHandler(this.chkExtRX6_CheckedChanged);
            // 
            // chkExtRX106
            // 
            this.chkExtRX106.Image = null;
            this.chkExtRX106.Location = new System.Drawing.Point(144, 208);
            this.chkExtRX106.Name = "chkExtRX106";
            this.chkExtRX106.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX106.TabIndex = 89;
            this.chkExtRX106.CheckedChanged += new System.EventHandler(this.chkExtRX10_CheckedChanged);
            // 
            // chkExtRX126
            // 
            this.chkExtRX126.Image = null;
            this.chkExtRX126.Location = new System.Drawing.Point(144, 192);
            this.chkExtRX126.Name = "chkExtRX126";
            this.chkExtRX126.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX126.TabIndex = 88;
            this.chkExtRX126.CheckedChanged += new System.EventHandler(this.chkExtRX12_CheckedChanged);
            // 
            // chkExtRX156
            // 
            this.chkExtRX156.Image = null;
            this.chkExtRX156.Location = new System.Drawing.Point(144, 176);
            this.chkExtRX156.Name = "chkExtRX156";
            this.chkExtRX156.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX156.TabIndex = 87;
            this.chkExtRX156.CheckedChanged += new System.EventHandler(this.chkExtRX15_CheckedChanged);
            // 
            // chkExtRX176
            // 
            this.chkExtRX176.Image = null;
            this.chkExtRX176.Location = new System.Drawing.Point(144, 160);
            this.chkExtRX176.Name = "chkExtRX176";
            this.chkExtRX176.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX176.TabIndex = 86;
            this.chkExtRX176.CheckedChanged += new System.EventHandler(this.chkExtRX17_CheckedChanged);
            // 
            // chkExtRX206
            // 
            this.chkExtRX206.Image = null;
            this.chkExtRX206.Location = new System.Drawing.Point(144, 144);
            this.chkExtRX206.Name = "chkExtRX206";
            this.chkExtRX206.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX206.TabIndex = 85;
            this.chkExtRX206.CheckedChanged += new System.EventHandler(this.chkExtRX20_CheckedChanged);
            // 
            // chkExtRX306
            // 
            this.chkExtRX306.Image = null;
            this.chkExtRX306.Location = new System.Drawing.Point(144, 128);
            this.chkExtRX306.Name = "chkExtRX306";
            this.chkExtRX306.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX306.TabIndex = 84;
            this.chkExtRX306.CheckedChanged += new System.EventHandler(this.chkExtRX30_CheckedChanged);
            // 
            // chkExtRX406
            // 
            this.chkExtRX406.Image = null;
            this.chkExtRX406.Location = new System.Drawing.Point(144, 112);
            this.chkExtRX406.Name = "chkExtRX406";
            this.chkExtRX406.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX406.TabIndex = 83;
            this.chkExtRX406.CheckedChanged += new System.EventHandler(this.chkExtRX40_CheckedChanged);
            // 
            // chkExtRX606
            // 
            this.chkExtRX606.Image = null;
            this.chkExtRX606.Location = new System.Drawing.Point(144, 96);
            this.chkExtRX606.Name = "chkExtRX606";
            this.chkExtRX606.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX606.TabIndex = 82;
            this.chkExtRX606.CheckedChanged += new System.EventHandler(this.chkExtRX60_CheckedChanged);
            // 
            // chkExtRX806
            // 
            this.chkExtRX806.Image = null;
            this.chkExtRX806.Location = new System.Drawing.Point(144, 80);
            this.chkExtRX806.Name = "chkExtRX806";
            this.chkExtRX806.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX806.TabIndex = 81;
            this.chkExtRX806.CheckedChanged += new System.EventHandler(this.chkExtRX80_CheckedChanged);
            // 
            // chkExtRX1606
            // 
            this.chkExtRX1606.Image = null;
            this.chkExtRX1606.Location = new System.Drawing.Point(144, 64);
            this.chkExtRX1606.Name = "chkExtRX1606";
            this.chkExtRX1606.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX1606.TabIndex = 80;
            this.chkExtRX1606.CheckedChanged += new System.EventHandler(this.chkExtRX160_CheckedChanged);
            // 
            // lblExtRXX25
            // 
            this.lblExtRXX25.Image = null;
            this.lblExtRXX25.Location = new System.Drawing.Point(128, 40);
            this.lblExtRXX25.Name = "lblExtRXX25";
            this.lblExtRXX25.Size = new System.Drawing.Size(16, 16);
            this.lblExtRXX25.TabIndex = 79;
            this.lblExtRXX25.Text = "5";
            this.lblExtRXX25.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtRXX24
            // 
            this.lblExtRXX24.Image = null;
            this.lblExtRXX24.Location = new System.Drawing.Point(112, 40);
            this.lblExtRXX24.Name = "lblExtRXX24";
            this.lblExtRXX24.Size = new System.Drawing.Size(16, 16);
            this.lblExtRXX24.TabIndex = 78;
            this.lblExtRXX24.Text = "4";
            this.lblExtRXX24.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtRXX23
            // 
            this.lblExtRXX23.Image = null;
            this.lblExtRXX23.Location = new System.Drawing.Point(96, 40);
            this.lblExtRXX23.Name = "lblExtRXX23";
            this.lblExtRXX23.Size = new System.Drawing.Size(16, 16);
            this.lblExtRXX23.TabIndex = 77;
            this.lblExtRXX23.Text = "3";
            this.lblExtRXX23.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtRXX22
            // 
            this.lblExtRXX22.Image = null;
            this.lblExtRXX22.Location = new System.Drawing.Point(80, 40);
            this.lblExtRXX22.Name = "lblExtRXX22";
            this.lblExtRXX22.Size = new System.Drawing.Size(16, 16);
            this.lblExtRXX22.TabIndex = 76;
            this.lblExtRXX22.Text = "2";
            this.lblExtRXX22.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtRX2
            // 
            this.lblExtRX2.Image = null;
            this.lblExtRX2.Location = new System.Drawing.Point(16, 240);
            this.lblExtRX2.Name = "lblExtRX2";
            this.lblExtRX2.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX2.TabIndex = 75;
            this.lblExtRX2.Text = "2m";
            // 
            // chkExtRX23
            // 
            this.chkExtRX23.Image = null;
            this.chkExtRX23.Location = new System.Drawing.Point(96, 240);
            this.chkExtRX23.Name = "chkExtRX23";
            this.chkExtRX23.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX23.TabIndex = 72;
            this.chkExtRX23.CheckedChanged += new System.EventHandler(this.chkExtRX2_CheckedChanged);
            // 
            // chkExtRX22
            // 
            this.chkExtRX22.Image = null;
            this.chkExtRX22.Location = new System.Drawing.Point(80, 240);
            this.chkExtRX22.Name = "chkExtRX22";
            this.chkExtRX22.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX22.TabIndex = 71;
            this.chkExtRX22.CheckedChanged += new System.EventHandler(this.chkExtRX2_CheckedChanged);
            // 
            // chkExtRX21
            // 
            this.chkExtRX21.Image = null;
            this.chkExtRX21.Location = new System.Drawing.Point(64, 240);
            this.chkExtRX21.Name = "chkExtRX21";
            this.chkExtRX21.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX21.TabIndex = 70;
            this.chkExtRX21.CheckedChanged += new System.EventHandler(this.chkExtRX2_CheckedChanged);
            // 
            // chkExtRX25
            // 
            this.chkExtRX25.Image = null;
            this.chkExtRX25.Location = new System.Drawing.Point(128, 240);
            this.chkExtRX25.Name = "chkExtRX25";
            this.chkExtRX25.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX25.TabIndex = 74;
            this.chkExtRX25.CheckedChanged += new System.EventHandler(this.chkExtRX2_CheckedChanged);
            // 
            // chkExtRX24
            // 
            this.chkExtRX24.Image = null;
            this.chkExtRX24.Location = new System.Drawing.Point(112, 240);
            this.chkExtRX24.Name = "chkExtRX24";
            this.chkExtRX24.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX24.TabIndex = 73;
            this.chkExtRX24.CheckedChanged += new System.EventHandler(this.chkExtRX2_CheckedChanged);
            // 
            // lblExtRX6
            // 
            this.lblExtRX6.Image = null;
            this.lblExtRX6.Location = new System.Drawing.Point(16, 224);
            this.lblExtRX6.Name = "lblExtRX6";
            this.lblExtRX6.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX6.TabIndex = 69;
            this.lblExtRX6.Text = "6m";
            // 
            // chkExtRX63
            // 
            this.chkExtRX63.Image = null;
            this.chkExtRX63.Location = new System.Drawing.Point(96, 224);
            this.chkExtRX63.Name = "chkExtRX63";
            this.chkExtRX63.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX63.TabIndex = 66;
            this.chkExtRX63.CheckedChanged += new System.EventHandler(this.chkExtRX6_CheckedChanged);
            // 
            // chkExtRX62
            // 
            this.chkExtRX62.Image = null;
            this.chkExtRX62.Location = new System.Drawing.Point(80, 224);
            this.chkExtRX62.Name = "chkExtRX62";
            this.chkExtRX62.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX62.TabIndex = 65;
            this.chkExtRX62.CheckedChanged += new System.EventHandler(this.chkExtRX6_CheckedChanged);
            // 
            // chkExtRX61
            // 
            this.chkExtRX61.Image = null;
            this.chkExtRX61.Location = new System.Drawing.Point(64, 224);
            this.chkExtRX61.Name = "chkExtRX61";
            this.chkExtRX61.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX61.TabIndex = 64;
            this.chkExtRX61.CheckedChanged += new System.EventHandler(this.chkExtRX6_CheckedChanged);
            // 
            // chkExtRX65
            // 
            this.chkExtRX65.Image = null;
            this.chkExtRX65.Location = new System.Drawing.Point(128, 224);
            this.chkExtRX65.Name = "chkExtRX65";
            this.chkExtRX65.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX65.TabIndex = 68;
            this.chkExtRX65.CheckedChanged += new System.EventHandler(this.chkExtRX6_CheckedChanged);
            // 
            // chkExtRX64
            // 
            this.chkExtRX64.Image = null;
            this.chkExtRX64.Location = new System.Drawing.Point(112, 224);
            this.chkExtRX64.Name = "chkExtRX64";
            this.chkExtRX64.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX64.TabIndex = 67;
            this.chkExtRX64.CheckedChanged += new System.EventHandler(this.chkExtRX6_CheckedChanged);
            // 
            // lblExtRX10
            // 
            this.lblExtRX10.Image = null;
            this.lblExtRX10.Location = new System.Drawing.Point(16, 208);
            this.lblExtRX10.Name = "lblExtRX10";
            this.lblExtRX10.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX10.TabIndex = 63;
            this.lblExtRX10.Text = "10m";
            // 
            // chkExtRX103
            // 
            this.chkExtRX103.Image = null;
            this.chkExtRX103.Location = new System.Drawing.Point(96, 208);
            this.chkExtRX103.Name = "chkExtRX103";
            this.chkExtRX103.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX103.TabIndex = 60;
            this.chkExtRX103.CheckedChanged += new System.EventHandler(this.chkExtRX10_CheckedChanged);
            // 
            // chkExtRX102
            // 
            this.chkExtRX102.Image = null;
            this.chkExtRX102.Location = new System.Drawing.Point(80, 208);
            this.chkExtRX102.Name = "chkExtRX102";
            this.chkExtRX102.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX102.TabIndex = 59;
            this.chkExtRX102.CheckedChanged += new System.EventHandler(this.chkExtRX10_CheckedChanged);
            // 
            // chkExtRX101
            // 
            this.chkExtRX101.Image = null;
            this.chkExtRX101.Location = new System.Drawing.Point(64, 208);
            this.chkExtRX101.Name = "chkExtRX101";
            this.chkExtRX101.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX101.TabIndex = 58;
            this.chkExtRX101.CheckedChanged += new System.EventHandler(this.chkExtRX10_CheckedChanged);
            // 
            // chkExtRX105
            // 
            this.chkExtRX105.Image = null;
            this.chkExtRX105.Location = new System.Drawing.Point(128, 208);
            this.chkExtRX105.Name = "chkExtRX105";
            this.chkExtRX105.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX105.TabIndex = 62;
            this.chkExtRX105.CheckedChanged += new System.EventHandler(this.chkExtRX10_CheckedChanged);
            // 
            // chkExtRX104
            // 
            this.chkExtRX104.Image = null;
            this.chkExtRX104.Location = new System.Drawing.Point(112, 208);
            this.chkExtRX104.Name = "chkExtRX104";
            this.chkExtRX104.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX104.TabIndex = 61;
            this.chkExtRX104.CheckedChanged += new System.EventHandler(this.chkExtRX10_CheckedChanged);
            // 
            // lblExtRX12
            // 
            this.lblExtRX12.Image = null;
            this.lblExtRX12.Location = new System.Drawing.Point(16, 192);
            this.lblExtRX12.Name = "lblExtRX12";
            this.lblExtRX12.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX12.TabIndex = 57;
            this.lblExtRX12.Text = "12m";
            // 
            // chkExtRX123
            // 
            this.chkExtRX123.Image = null;
            this.chkExtRX123.Location = new System.Drawing.Point(96, 192);
            this.chkExtRX123.Name = "chkExtRX123";
            this.chkExtRX123.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX123.TabIndex = 54;
            this.chkExtRX123.CheckedChanged += new System.EventHandler(this.chkExtRX12_CheckedChanged);
            // 
            // chkExtRX122
            // 
            this.chkExtRX122.Image = null;
            this.chkExtRX122.Location = new System.Drawing.Point(80, 192);
            this.chkExtRX122.Name = "chkExtRX122";
            this.chkExtRX122.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX122.TabIndex = 53;
            this.chkExtRX122.CheckedChanged += new System.EventHandler(this.chkExtRX12_CheckedChanged);
            // 
            // chkExtRX121
            // 
            this.chkExtRX121.Image = null;
            this.chkExtRX121.Location = new System.Drawing.Point(64, 192);
            this.chkExtRX121.Name = "chkExtRX121";
            this.chkExtRX121.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX121.TabIndex = 52;
            this.chkExtRX121.CheckedChanged += new System.EventHandler(this.chkExtRX12_CheckedChanged);
            // 
            // chkExtRX125
            // 
            this.chkExtRX125.Image = null;
            this.chkExtRX125.Location = new System.Drawing.Point(128, 192);
            this.chkExtRX125.Name = "chkExtRX125";
            this.chkExtRX125.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX125.TabIndex = 56;
            this.chkExtRX125.CheckedChanged += new System.EventHandler(this.chkExtRX12_CheckedChanged);
            // 
            // chkExtRX124
            // 
            this.chkExtRX124.Image = null;
            this.chkExtRX124.Location = new System.Drawing.Point(112, 192);
            this.chkExtRX124.Name = "chkExtRX124";
            this.chkExtRX124.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX124.TabIndex = 55;
            this.chkExtRX124.CheckedChanged += new System.EventHandler(this.chkExtRX12_CheckedChanged);
            // 
            // lblExtRX15
            // 
            this.lblExtRX15.Image = null;
            this.lblExtRX15.Location = new System.Drawing.Point(16, 176);
            this.lblExtRX15.Name = "lblExtRX15";
            this.lblExtRX15.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX15.TabIndex = 51;
            this.lblExtRX15.Text = "15m";
            // 
            // chkExtRX153
            // 
            this.chkExtRX153.Image = null;
            this.chkExtRX153.Location = new System.Drawing.Point(96, 176);
            this.chkExtRX153.Name = "chkExtRX153";
            this.chkExtRX153.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX153.TabIndex = 48;
            this.chkExtRX153.CheckedChanged += new System.EventHandler(this.chkExtRX15_CheckedChanged);
            // 
            // chkExtRX152
            // 
            this.chkExtRX152.Image = null;
            this.chkExtRX152.Location = new System.Drawing.Point(80, 176);
            this.chkExtRX152.Name = "chkExtRX152";
            this.chkExtRX152.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX152.TabIndex = 47;
            this.chkExtRX152.CheckedChanged += new System.EventHandler(this.chkExtRX15_CheckedChanged);
            // 
            // chkExtRX151
            // 
            this.chkExtRX151.Image = null;
            this.chkExtRX151.Location = new System.Drawing.Point(64, 176);
            this.chkExtRX151.Name = "chkExtRX151";
            this.chkExtRX151.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX151.TabIndex = 46;
            this.chkExtRX151.CheckedChanged += new System.EventHandler(this.chkExtRX15_CheckedChanged);
            // 
            // chkExtRX155
            // 
            this.chkExtRX155.Image = null;
            this.chkExtRX155.Location = new System.Drawing.Point(128, 176);
            this.chkExtRX155.Name = "chkExtRX155";
            this.chkExtRX155.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX155.TabIndex = 50;
            this.chkExtRX155.CheckedChanged += new System.EventHandler(this.chkExtRX15_CheckedChanged);
            // 
            // chkExtRX154
            // 
            this.chkExtRX154.Image = null;
            this.chkExtRX154.Location = new System.Drawing.Point(112, 176);
            this.chkExtRX154.Name = "chkExtRX154";
            this.chkExtRX154.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX154.TabIndex = 49;
            this.chkExtRX154.CheckedChanged += new System.EventHandler(this.chkExtRX15_CheckedChanged);
            // 
            // lblExtRX17
            // 
            this.lblExtRX17.Image = null;
            this.lblExtRX17.Location = new System.Drawing.Point(16, 160);
            this.lblExtRX17.Name = "lblExtRX17";
            this.lblExtRX17.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX17.TabIndex = 45;
            this.lblExtRX17.Text = "17m";
            // 
            // chkExtRX173
            // 
            this.chkExtRX173.Image = null;
            this.chkExtRX173.Location = new System.Drawing.Point(96, 160);
            this.chkExtRX173.Name = "chkExtRX173";
            this.chkExtRX173.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX173.TabIndex = 42;
            this.chkExtRX173.CheckedChanged += new System.EventHandler(this.chkExtRX17_CheckedChanged);
            // 
            // chkExtRX172
            // 
            this.chkExtRX172.Image = null;
            this.chkExtRX172.Location = new System.Drawing.Point(80, 160);
            this.chkExtRX172.Name = "chkExtRX172";
            this.chkExtRX172.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX172.TabIndex = 41;
            this.chkExtRX172.CheckedChanged += new System.EventHandler(this.chkExtRX17_CheckedChanged);
            // 
            // chkExtRX171
            // 
            this.chkExtRX171.Image = null;
            this.chkExtRX171.Location = new System.Drawing.Point(64, 160);
            this.chkExtRX171.Name = "chkExtRX171";
            this.chkExtRX171.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX171.TabIndex = 40;
            this.chkExtRX171.CheckedChanged += new System.EventHandler(this.chkExtRX17_CheckedChanged);
            // 
            // chkExtRX175
            // 
            this.chkExtRX175.Image = null;
            this.chkExtRX175.Location = new System.Drawing.Point(128, 160);
            this.chkExtRX175.Name = "chkExtRX175";
            this.chkExtRX175.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX175.TabIndex = 44;
            this.chkExtRX175.CheckedChanged += new System.EventHandler(this.chkExtRX17_CheckedChanged);
            // 
            // chkExtRX174
            // 
            this.chkExtRX174.Image = null;
            this.chkExtRX174.Location = new System.Drawing.Point(112, 160);
            this.chkExtRX174.Name = "chkExtRX174";
            this.chkExtRX174.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX174.TabIndex = 43;
            this.chkExtRX174.CheckedChanged += new System.EventHandler(this.chkExtRX17_CheckedChanged);
            // 
            // lblExtRX20
            // 
            this.lblExtRX20.Image = null;
            this.lblExtRX20.Location = new System.Drawing.Point(16, 144);
            this.lblExtRX20.Name = "lblExtRX20";
            this.lblExtRX20.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX20.TabIndex = 39;
            this.lblExtRX20.Text = "20m";
            // 
            // chkExtRX203
            // 
            this.chkExtRX203.Image = null;
            this.chkExtRX203.Location = new System.Drawing.Point(96, 144);
            this.chkExtRX203.Name = "chkExtRX203";
            this.chkExtRX203.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX203.TabIndex = 36;
            this.chkExtRX203.CheckedChanged += new System.EventHandler(this.chkExtRX20_CheckedChanged);
            // 
            // chkExtRX202
            // 
            this.chkExtRX202.Image = null;
            this.chkExtRX202.Location = new System.Drawing.Point(80, 144);
            this.chkExtRX202.Name = "chkExtRX202";
            this.chkExtRX202.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX202.TabIndex = 35;
            this.chkExtRX202.CheckedChanged += new System.EventHandler(this.chkExtRX20_CheckedChanged);
            // 
            // chkExtRX201
            // 
            this.chkExtRX201.Image = null;
            this.chkExtRX201.Location = new System.Drawing.Point(64, 144);
            this.chkExtRX201.Name = "chkExtRX201";
            this.chkExtRX201.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX201.TabIndex = 34;
            this.chkExtRX201.CheckedChanged += new System.EventHandler(this.chkExtRX20_CheckedChanged);
            // 
            // chkExtRX205
            // 
            this.chkExtRX205.Image = null;
            this.chkExtRX205.Location = new System.Drawing.Point(128, 144);
            this.chkExtRX205.Name = "chkExtRX205";
            this.chkExtRX205.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX205.TabIndex = 38;
            this.chkExtRX205.CheckedChanged += new System.EventHandler(this.chkExtRX20_CheckedChanged);
            // 
            // chkExtRX204
            // 
            this.chkExtRX204.Image = null;
            this.chkExtRX204.Location = new System.Drawing.Point(112, 144);
            this.chkExtRX204.Name = "chkExtRX204";
            this.chkExtRX204.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX204.TabIndex = 37;
            this.chkExtRX204.CheckedChanged += new System.EventHandler(this.chkExtRX20_CheckedChanged);
            // 
            // lblExtRX30
            // 
            this.lblExtRX30.Image = null;
            this.lblExtRX30.Location = new System.Drawing.Point(16, 128);
            this.lblExtRX30.Name = "lblExtRX30";
            this.lblExtRX30.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX30.TabIndex = 33;
            this.lblExtRX30.Text = "30m";
            // 
            // chkExtRX303
            // 
            this.chkExtRX303.Image = null;
            this.chkExtRX303.Location = new System.Drawing.Point(96, 128);
            this.chkExtRX303.Name = "chkExtRX303";
            this.chkExtRX303.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX303.TabIndex = 30;
            this.chkExtRX303.CheckedChanged += new System.EventHandler(this.chkExtRX30_CheckedChanged);
            // 
            // chkExtRX302
            // 
            this.chkExtRX302.Image = null;
            this.chkExtRX302.Location = new System.Drawing.Point(80, 128);
            this.chkExtRX302.Name = "chkExtRX302";
            this.chkExtRX302.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX302.TabIndex = 29;
            this.chkExtRX302.CheckedChanged += new System.EventHandler(this.chkExtRX30_CheckedChanged);
            // 
            // chkExtRX301
            // 
            this.chkExtRX301.Image = null;
            this.chkExtRX301.Location = new System.Drawing.Point(64, 128);
            this.chkExtRX301.Name = "chkExtRX301";
            this.chkExtRX301.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX301.TabIndex = 28;
            this.chkExtRX301.CheckedChanged += new System.EventHandler(this.chkExtRX30_CheckedChanged);
            // 
            // chkExtRX305
            // 
            this.chkExtRX305.Image = null;
            this.chkExtRX305.Location = new System.Drawing.Point(128, 128);
            this.chkExtRX305.Name = "chkExtRX305";
            this.chkExtRX305.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX305.TabIndex = 32;
            this.chkExtRX305.CheckedChanged += new System.EventHandler(this.chkExtRX30_CheckedChanged);
            // 
            // chkExtRX304
            // 
            this.chkExtRX304.Image = null;
            this.chkExtRX304.Location = new System.Drawing.Point(112, 128);
            this.chkExtRX304.Name = "chkExtRX304";
            this.chkExtRX304.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX304.TabIndex = 31;
            this.chkExtRX304.CheckedChanged += new System.EventHandler(this.chkExtRX30_CheckedChanged);
            // 
            // lblExtRX40
            // 
            this.lblExtRX40.Image = null;
            this.lblExtRX40.Location = new System.Drawing.Point(16, 112);
            this.lblExtRX40.Name = "lblExtRX40";
            this.lblExtRX40.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX40.TabIndex = 27;
            this.lblExtRX40.Text = "40m";
            // 
            // chkExtRX403
            // 
            this.chkExtRX403.Image = null;
            this.chkExtRX403.Location = new System.Drawing.Point(96, 112);
            this.chkExtRX403.Name = "chkExtRX403";
            this.chkExtRX403.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX403.TabIndex = 24;
            this.chkExtRX403.CheckedChanged += new System.EventHandler(this.chkExtRX40_CheckedChanged);
            // 
            // chkExtRX402
            // 
            this.chkExtRX402.Image = null;
            this.chkExtRX402.Location = new System.Drawing.Point(80, 112);
            this.chkExtRX402.Name = "chkExtRX402";
            this.chkExtRX402.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX402.TabIndex = 23;
            this.chkExtRX402.CheckedChanged += new System.EventHandler(this.chkExtRX40_CheckedChanged);
            // 
            // chkExtRX401
            // 
            this.chkExtRX401.Image = null;
            this.chkExtRX401.Location = new System.Drawing.Point(64, 112);
            this.chkExtRX401.Name = "chkExtRX401";
            this.chkExtRX401.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX401.TabIndex = 22;
            this.chkExtRX401.CheckedChanged += new System.EventHandler(this.chkExtRX40_CheckedChanged);
            // 
            // chkExtRX405
            // 
            this.chkExtRX405.Image = null;
            this.chkExtRX405.Location = new System.Drawing.Point(128, 112);
            this.chkExtRX405.Name = "chkExtRX405";
            this.chkExtRX405.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX405.TabIndex = 26;
            this.chkExtRX405.CheckedChanged += new System.EventHandler(this.chkExtRX40_CheckedChanged);
            // 
            // chkExtRX404
            // 
            this.chkExtRX404.Image = null;
            this.chkExtRX404.Location = new System.Drawing.Point(112, 112);
            this.chkExtRX404.Name = "chkExtRX404";
            this.chkExtRX404.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX404.TabIndex = 25;
            this.chkExtRX404.CheckedChanged += new System.EventHandler(this.chkExtRX40_CheckedChanged);
            // 
            // lblExtRX60
            // 
            this.lblExtRX60.Image = null;
            this.lblExtRX60.Location = new System.Drawing.Point(16, 96);
            this.lblExtRX60.Name = "lblExtRX60";
            this.lblExtRX60.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX60.TabIndex = 21;
            this.lblExtRX60.Text = "60m";
            // 
            // chkExtRX603
            // 
            this.chkExtRX603.Image = null;
            this.chkExtRX603.Location = new System.Drawing.Point(96, 96);
            this.chkExtRX603.Name = "chkExtRX603";
            this.chkExtRX603.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX603.TabIndex = 18;
            this.chkExtRX603.CheckedChanged += new System.EventHandler(this.chkExtRX60_CheckedChanged);
            // 
            // chkExtRX602
            // 
            this.chkExtRX602.Image = null;
            this.chkExtRX602.Location = new System.Drawing.Point(80, 96);
            this.chkExtRX602.Name = "chkExtRX602";
            this.chkExtRX602.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX602.TabIndex = 17;
            this.chkExtRX602.CheckedChanged += new System.EventHandler(this.chkExtRX60_CheckedChanged);
            // 
            // chkExtRX601
            // 
            this.chkExtRX601.Image = null;
            this.chkExtRX601.Location = new System.Drawing.Point(64, 96);
            this.chkExtRX601.Name = "chkExtRX601";
            this.chkExtRX601.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX601.TabIndex = 16;
            this.chkExtRX601.CheckedChanged += new System.EventHandler(this.chkExtRX60_CheckedChanged);
            // 
            // chkExtRX605
            // 
            this.chkExtRX605.Image = null;
            this.chkExtRX605.Location = new System.Drawing.Point(128, 96);
            this.chkExtRX605.Name = "chkExtRX605";
            this.chkExtRX605.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX605.TabIndex = 20;
            this.chkExtRX605.CheckedChanged += new System.EventHandler(this.chkExtRX60_CheckedChanged);
            // 
            // chkExtRX604
            // 
            this.chkExtRX604.Image = null;
            this.chkExtRX604.Location = new System.Drawing.Point(112, 96);
            this.chkExtRX604.Name = "chkExtRX604";
            this.chkExtRX604.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX604.TabIndex = 19;
            this.chkExtRX604.CheckedChanged += new System.EventHandler(this.chkExtRX60_CheckedChanged);
            // 
            // lblExtRX80
            // 
            this.lblExtRX80.Image = null;
            this.lblExtRX80.Location = new System.Drawing.Point(16, 80);
            this.lblExtRX80.Name = "lblExtRX80";
            this.lblExtRX80.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX80.TabIndex = 15;
            this.lblExtRX80.Text = "80m";
            // 
            // chkExtRX803
            // 
            this.chkExtRX803.Image = null;
            this.chkExtRX803.Location = new System.Drawing.Point(96, 80);
            this.chkExtRX803.Name = "chkExtRX803";
            this.chkExtRX803.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX803.TabIndex = 12;
            this.chkExtRX803.CheckedChanged += new System.EventHandler(this.chkExtRX80_CheckedChanged);
            // 
            // chkExtRX802
            // 
            this.chkExtRX802.Image = null;
            this.chkExtRX802.Location = new System.Drawing.Point(80, 80);
            this.chkExtRX802.Name = "chkExtRX802";
            this.chkExtRX802.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX802.TabIndex = 11;
            this.chkExtRX802.CheckedChanged += new System.EventHandler(this.chkExtRX80_CheckedChanged);
            // 
            // chkExtRX801
            // 
            this.chkExtRX801.Image = null;
            this.chkExtRX801.Location = new System.Drawing.Point(64, 80);
            this.chkExtRX801.Name = "chkExtRX801";
            this.chkExtRX801.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX801.TabIndex = 10;
            this.chkExtRX801.CheckedChanged += new System.EventHandler(this.chkExtRX80_CheckedChanged);
            // 
            // chkExtRX805
            // 
            this.chkExtRX805.Image = null;
            this.chkExtRX805.Location = new System.Drawing.Point(128, 80);
            this.chkExtRX805.Name = "chkExtRX805";
            this.chkExtRX805.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX805.TabIndex = 14;
            this.chkExtRX805.CheckedChanged += new System.EventHandler(this.chkExtRX80_CheckedChanged);
            // 
            // chkExtRX804
            // 
            this.chkExtRX804.Image = null;
            this.chkExtRX804.Location = new System.Drawing.Point(112, 80);
            this.chkExtRX804.Name = "chkExtRX804";
            this.chkExtRX804.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX804.TabIndex = 13;
            this.chkExtRX804.CheckedChanged += new System.EventHandler(this.chkExtRX80_CheckedChanged);
            // 
            // lblExtRXX2Pins
            // 
            this.lblExtRXX2Pins.Image = null;
            this.lblExtRXX2Pins.Location = new System.Drawing.Point(64, 24);
            this.lblExtRXX2Pins.Name = "lblExtRXX2Pins";
            this.lblExtRXX2Pins.Size = new System.Drawing.Size(96, 16);
            this.lblExtRXX2Pins.TabIndex = 9;
            this.lblExtRXX2Pins.Text = "X2 Pins";
            this.lblExtRXX2Pins.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblExtRXBand
            // 
            this.lblExtRXBand.Image = null;
            this.lblExtRXBand.Location = new System.Drawing.Point(16, 24);
            this.lblExtRXBand.Name = "lblExtRXBand";
            this.lblExtRXBand.Size = new System.Drawing.Size(32, 16);
            this.lblExtRXBand.TabIndex = 8;
            this.lblExtRXBand.Text = "Band";
            // 
            // lblExtRX160
            // 
            this.lblExtRX160.Image = null;
            this.lblExtRX160.Location = new System.Drawing.Point(16, 64);
            this.lblExtRX160.Name = "lblExtRX160";
            this.lblExtRX160.Size = new System.Drawing.Size(40, 16);
            this.lblExtRX160.TabIndex = 7;
            this.lblExtRX160.Text = "160m";
            // 
            // chkExtRX1603
            // 
            this.chkExtRX1603.Image = null;
            this.chkExtRX1603.Location = new System.Drawing.Point(96, 64);
            this.chkExtRX1603.Name = "chkExtRX1603";
            this.chkExtRX1603.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX1603.TabIndex = 3;
            this.chkExtRX1603.CheckedChanged += new System.EventHandler(this.chkExtRX160_CheckedChanged);
            // 
            // chkExtRX1602
            // 
            this.chkExtRX1602.Image = null;
            this.chkExtRX1602.Location = new System.Drawing.Point(80, 64);
            this.chkExtRX1602.Name = "chkExtRX1602";
            this.chkExtRX1602.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX1602.TabIndex = 2;
            this.chkExtRX1602.CheckedChanged += new System.EventHandler(this.chkExtRX160_CheckedChanged);
            // 
            // chkExtRX1601
            // 
            this.chkExtRX1601.Image = null;
            this.chkExtRX1601.Location = new System.Drawing.Point(64, 64);
            this.chkExtRX1601.Name = "chkExtRX1601";
            this.chkExtRX1601.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX1601.TabIndex = 1;
            this.chkExtRX1601.CheckedChanged += new System.EventHandler(this.chkExtRX160_CheckedChanged);
            // 
            // lblExtRXX21
            // 
            this.lblExtRXX21.Image = null;
            this.lblExtRXX21.Location = new System.Drawing.Point(64, 40);
            this.lblExtRXX21.Name = "lblExtRXX21";
            this.lblExtRXX21.Size = new System.Drawing.Size(16, 16);
            this.lblExtRXX21.TabIndex = 6;
            this.lblExtRXX21.Text = "1";
            this.lblExtRXX21.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // chkExtRX1605
            // 
            this.chkExtRX1605.Image = null;
            this.chkExtRX1605.Location = new System.Drawing.Point(128, 64);
            this.chkExtRX1605.Name = "chkExtRX1605";
            this.chkExtRX1605.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX1605.TabIndex = 5;
            this.chkExtRX1605.CheckedChanged += new System.EventHandler(this.chkExtRX160_CheckedChanged);
            // 
            // chkExtRX1604
            // 
            this.chkExtRX1604.Image = null;
            this.chkExtRX1604.Location = new System.Drawing.Point(112, 64);
            this.chkExtRX1604.Name = "chkExtRX1604";
            this.chkExtRX1604.Size = new System.Drawing.Size(16, 16);
            this.chkExtRX1604.TabIndex = 4;
            this.chkExtRX1604.CheckedChanged += new System.EventHandler(this.chkExtRX160_CheckedChanged);
            // 
            // tpCAT
            // 
            this.tpCAT.Controls.Add(this.groupBoxTS4);
            this.tpCAT.Controls.Add(this.chkFPInstalled);
            this.tpCAT.Controls.Add(this.chkDigUIsUSB);
            this.tpCAT.Controls.Add(this.lblCATRigType);
            this.tpCAT.Controls.Add(this.comboCATRigType);
            this.tpCAT.Controls.Add(this.btnCATTest);
            this.tpCAT.Controls.Add(this.grpPTTBitBang);
            this.tpCAT.Controls.Add(this.grpCatControlBox);
            this.tpCAT.Controls.Add(this.grpRTTYOffset);
            this.tpCAT.Location = new System.Drawing.Point(4, 22);
            this.tpCAT.Name = "tpCAT";
            this.tpCAT.Size = new System.Drawing.Size(584, 341);
            this.tpCAT.TabIndex = 10;
            this.tpCAT.Text = "CAT Control";
            this.tpCAT.Paint += new System.Windows.Forms.PaintEventHandler(this.tpCAT_Paint);
            // 
            // groupBoxTS4
            // 
            this.groupBoxTS4.Controls.Add(this.chkKWAI7);
            this.groupBoxTS4.Controls.Add(this.txtCatURL2);
            this.groupBoxTS4.Controls.Add(this.radioButtonCAT);
            this.groupBoxTS4.Controls.Add(this.chkCatURLON);
            this.groupBoxTS4.Controls.Add(this.txtCatPort);
            this.groupBoxTS4.Controls.Add(this.txtCatURL);
            this.groupBoxTS4.Controls.Add(this.labelTS61);
            this.groupBoxTS4.Controls.Add(this.labelTS62);
            this.groupBoxTS4.Controls.Add(this.chkCatURLALT);
            this.groupBoxTS4.Location = new System.Drawing.Point(254, 267);
            this.groupBoxTS4.Name = "groupBoxTS4";
            this.groupBoxTS4.Size = new System.Drawing.Size(314, 71);
            this.groupBoxTS4.TabIndex = 99;
            this.groupBoxTS4.TabStop = false;
            this.groupBoxTS4.Text = "CAT TCP Server:  Your URL and User selected Port";
            this.toolTip1.SetToolTip(this.groupBoxTS4, "TCP Server based on this computers IP address and a user selected PORT.\r\n\r\nThis a" +
        "llows CAT commands to/from PowerSDR form any TCP/IP device linked to your IP and" +
        " Port");
            // 
            // chkKWAI7
            // 
            this.chkKWAI7.Image = null;
            this.chkKWAI7.Location = new System.Drawing.Point(268, 45);
            this.chkKWAI7.Name = "chkKWAI7";
            this.chkKWAI7.Size = new System.Drawing.Size(40, 24);
            this.chkKWAI7.TabIndex = 127;
            this.chkKWAI7.Text = "AI";
            this.toolTip1.SetToolTip(this.chkKWAI7, resources.GetString("chkKWAI7.ToolTip"));
            this.chkKWAI7.Visible = false;
            this.chkKWAI7.CheckedChanged += new System.EventHandler(this.chkKWAI7_CheckedChanged);
            // 
            // txtCatURL2
            // 
            this.txtCatURL2.Location = new System.Drawing.Point(35, 43);
            this.txtCatURL2.MaxLength = 50;
            this.txtCatURL2.Name = "txtCatURL2";
            this.txtCatURL2.ReadOnly = true;
            this.txtCatURL2.Size = new System.Drawing.Size(133, 20);
            this.txtCatURL2.TabIndex = 4;
            this.txtCatURL2.Text = "192.168.0.103";
            this.toolTip1.SetToolTip(this.txtCatURL2, "Select URL to TX/RX CAT commands");
            // 
            // radioButtonCAT
            // 
            this.radioButtonCAT.AutoSize = true;
            this.radioButtonCAT.Location = new System.Drawing.Point(294, 13);
            this.radioButtonCAT.Name = "radioButtonCAT";
            this.radioButtonCAT.Size = new System.Drawing.Size(14, 13);
            this.radioButtonCAT.TabIndex = 3;
            this.radioButtonCAT.TabStop = true;
            this.radioButtonCAT.UseVisualStyleBackColor = true;
            // 
            // chkCatURLON
            // 
            this.chkCatURLON.Image = null;
            this.chkCatURLON.Location = new System.Drawing.Point(238, 19);
            this.chkCatURLON.Name = "chkCatURLON";
            this.chkCatURLON.Size = new System.Drawing.Size(46, 16);
            this.chkCatURLON.TabIndex = 2;
            this.chkCatURLON.Text = "ON";
            this.toolTip1.SetToolTip(this.chkCatURLON, resources.GetString("chkCatURLON.ToolTip"));
            this.chkCatURLON.CheckedChanged += new System.EventHandler(this.chkCatURLON_CheckedChanged);
            this.chkCatURLON.MouseDown += new System.Windows.Forms.MouseEventHandler(this.chkCatURLON_MouseDown);
            // 
            // txtCatPort
            // 
            this.txtCatPort.Location = new System.Drawing.Point(174, 19);
            this.txtCatPort.MaxLength = 50;
            this.txtCatPort.Name = "txtCatPort";
            this.txtCatPort.Size = new System.Drawing.Size(58, 20);
            this.txtCatPort.TabIndex = 1;
            this.txtCatPort.Text = "1000";
            this.toolTip1.SetToolTip(this.txtCatPort, "TCP Server based on this computers IP address and a user selected PORT.\r\n\r\nThis a" +
        "llows CAT commands to/from PowerSDR form any TCP/IP device linked to your IP and" +
        " Port\r\n");
            this.txtCatPort.TextChanged += new System.EventHandler(this.txtCatPort_TextChanged);
            // 
            // txtCatURL
            // 
            this.txtCatURL.Location = new System.Drawing.Point(35, 19);
            this.txtCatURL.MaxLength = 50;
            this.txtCatURL.Name = "txtCatURL";
            this.txtCatURL.ReadOnly = true;
            this.txtCatURL.Size = new System.Drawing.Size(133, 20);
            this.txtCatURL.TabIndex = 0;
            this.txtCatURL.Text = "192.168.0.102";
            this.toolTip1.SetToolTip(this.txtCatURL, "Select URL to TX/RX CAT commands");
            // 
            // labelTS61
            // 
            this.labelTS61.Image = null;
            this.labelTS61.Location = new System.Drawing.Point(6, 21);
            this.labelTS61.Name = "labelTS61";
            this.labelTS61.Size = new System.Drawing.Size(33, 23);
            this.labelTS61.TabIndex = 97;
            this.labelTS61.Text = "#1";
            // 
            // labelTS62
            // 
            this.labelTS62.Image = null;
            this.labelTS62.Location = new System.Drawing.Point(6, 42);
            this.labelTS62.Name = "labelTS62";
            this.labelTS62.Size = new System.Drawing.Size(33, 19);
            this.labelTS62.TabIndex = 98;
            this.labelTS62.Text = "#2";
            // 
            // chkCatURLALT
            // 
            this.chkCatURLALT.Image = null;
            this.chkCatURLALT.Location = new System.Drawing.Point(174, 49);
            this.chkCatURLALT.Name = "chkCatURLALT";
            this.chkCatURLALT.Size = new System.Drawing.Size(127, 16);
            this.chkCatURLALT.TabIndex = 99;
            this.chkCatURLALT.Text = "Select #2 Alt";
            this.toolTip1.SetToolTip(this.chkCatURLALT, "If you have multiple Ethernet devices (Wired vs Wi-Fi) on your PC.\r\nSelect to use" +
        " the #2 IP address\r\nOtherwise #1 is used by default");
            this.chkCatURLALT.Visible = false;
            // 
            // chkFPInstalled
            // 
            this.chkFPInstalled.Image = null;
            this.chkFPInstalled.Location = new System.Drawing.Point(251, 204);
            this.chkFPInstalled.Name = "chkFPInstalled";
            this.chkFPInstalled.Size = new System.Drawing.Size(132, 24);
            this.chkFPInstalled.TabIndex = 97;
            this.chkFPInstalled.Text = "FlexProfiler Installed";
            this.toolTip1.SetToolTip(this.chkFPInstalled, "Check if FlexProfiler installed");
            this.chkFPInstalled.Visible = false;
            this.chkFPInstalled.CheckedChanged += new System.EventHandler(this.chkFPInstalled_CheckedChanged);
            // 
            // chkDigUIsUSB
            // 
            this.chkDigUIsUSB.Image = null;
            this.chkDigUIsUSB.Location = new System.Drawing.Point(251, 234);
            this.chkDigUIsUSB.Name = "chkDigUIsUSB";
            this.chkDigUIsUSB.Size = new System.Drawing.Size(154, 24);
            this.chkDigUIsUSB.TabIndex = 96;
            this.chkDigUIsUSB.Text = "DigL/U Returns LSB/USB";
            this.toolTip1.SetToolTip(this.chkDigUIsUSB, "Lies to the Kenwood CAT Interface to fool certain programs");
            // 
            // lblCATRigType
            // 
            this.lblCATRigType.Image = null;
            this.lblCATRigType.Location = new System.Drawing.Point(400, 27);
            this.lblCATRigType.Name = "lblCATRigType";
            this.lblCATRigType.Size = new System.Drawing.Size(36, 18);
            this.lblCATRigType.TabIndex = 95;
            this.lblCATRigType.Text = "ID as:";
            // 
            // comboCATRigType
            // 
            this.comboCATRigType.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATRigType.DropDownWidth = 56;
            this.comboCATRigType.Items.AddRange(new object[] {
            "PowerSDR",
            "TS-2000",
            "TS-50S",
            "TS-480"});
            this.comboCATRigType.Location = new System.Drawing.Point(442, 24);
            this.comboCATRigType.Name = "comboCATRigType";
            this.comboCATRigType.Size = new System.Drawing.Size(88, 21);
            this.comboCATRigType.TabIndex = 94;
            this.toolTip1.SetToolTip(this.comboCATRigType, "Returns the selected CAT ID value when queried by the Kenwood \"ID\" CAT command");
            this.comboCATRigType.SelectedIndexChanged += new System.EventHandler(this.comboCATRigType_SelectedIndexChanged);
            // 
            // btnCATTest
            // 
            this.btnCATTest.Image = null;
            this.btnCATTest.Location = new System.Drawing.Point(403, 64);
            this.btnCATTest.Name = "btnCATTest";
            this.btnCATTest.Size = new System.Drawing.Size(77, 40);
            this.btnCATTest.TabIndex = 92;
            this.btnCATTest.Text = "Test CAT Commands";
            this.toolTip1.SetToolTip(this.btnCATTest, "A test utility to verify CAT command responses");
            this.btnCATTest.Click += new System.EventHandler(this.btnCATTest_Click);
            // 
            // grpPTTBitBang
            // 
            this.grpPTTBitBang.Controls.Add(this.comboCATPTTPort);
            this.grpPTTBitBang.Controls.Add(this.lblCATPTTPort);
            this.grpPTTBitBang.Controls.Add(this.chkCATPTT_RTS);
            this.grpPTTBitBang.Controls.Add(this.chkCATPTT_DTR);
            this.grpPTTBitBang.Controls.Add(this.chkCATPTTEnabled);
            this.grpPTTBitBang.Location = new System.Drawing.Point(262, 20);
            this.grpPTTBitBang.Name = "grpPTTBitBang";
            this.grpPTTBitBang.Size = new System.Drawing.Size(128, 152);
            this.grpPTTBitBang.TabIndex = 91;
            this.grpPTTBitBang.TabStop = false;
            this.grpPTTBitBang.Text = "PTT Control";
            // 
            // comboCATPTTPort
            // 
            this.comboCATPTTPort.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATPTTPort.DropDownWidth = 56;
            this.comboCATPTTPort.Location = new System.Drawing.Point(40, 56);
            this.comboCATPTTPort.Name = "comboCATPTTPort";
            this.comboCATPTTPort.Size = new System.Drawing.Size(80, 21);
            this.comboCATPTTPort.TabIndex = 96;
            this.toolTip1.SetToolTip(this.comboCATPTTPort, "Selects the COM port for use with PTT control");
            this.comboCATPTTPort.SelectedIndexChanged += new System.EventHandler(this.comboCATPTTPort_SelectedIndexChanged);
            // 
            // lblCATPTTPort
            // 
            this.lblCATPTTPort.Image = null;
            this.lblCATPTTPort.Location = new System.Drawing.Point(8, 56);
            this.lblCATPTTPort.Name = "lblCATPTTPort";
            this.lblCATPTTPort.Size = new System.Drawing.Size(40, 23);
            this.lblCATPTTPort.TabIndex = 6;
            this.lblCATPTTPort.Text = "Port:";
            // 
            // chkCATPTT_RTS
            // 
            this.chkCATPTT_RTS.Image = null;
            this.chkCATPTT_RTS.Location = new System.Drawing.Point(40, 88);
            this.chkCATPTT_RTS.Name = "chkCATPTT_RTS";
            this.chkCATPTT_RTS.Size = new System.Drawing.Size(48, 24);
            this.chkCATPTT_RTS.TabIndex = 0;
            this.chkCATPTT_RTS.Text = "RTS";
            this.chkCATPTT_RTS.CheckedChanged += new System.EventHandler(this.chkCATPTT_RTS_CheckedChanged);
            // 
            // chkCATPTT_DTR
            // 
            this.chkCATPTT_DTR.Image = null;
            this.chkCATPTT_DTR.Location = new System.Drawing.Point(40, 120);
            this.chkCATPTT_DTR.Name = "chkCATPTT_DTR";
            this.chkCATPTT_DTR.Size = new System.Drawing.Size(60, 16);
            this.chkCATPTT_DTR.TabIndex = 1;
            this.chkCATPTT_DTR.Text = "DTR";
            this.chkCATPTT_DTR.CheckedChanged += new System.EventHandler(this.chkCATPTT_DTR_CheckedChanged);
            // 
            // chkCATPTTEnabled
            // 
            this.chkCATPTTEnabled.Image = null;
            this.chkCATPTTEnabled.Location = new System.Drawing.Point(8, 16);
            this.chkCATPTTEnabled.Name = "chkCATPTTEnabled";
            this.chkCATPTTEnabled.Size = new System.Drawing.Size(104, 24);
            this.chkCATPTTEnabled.TabIndex = 4;
            this.chkCATPTTEnabled.Text = "Enable PTT";
            this.chkCATPTTEnabled.CheckedChanged += new System.EventHandler(this.chkCATPTTEnabled_CheckedChanged);
            // 
            // grpCatControlBox
            // 
            this.grpCatControlBox.Controls.Add(this.chkKWAI6);
            this.grpCatControlBox.Controls.Add(this.chkKWAI5);
            this.grpCatControlBox.Controls.Add(this.chkKWAI4);
            this.grpCatControlBox.Controls.Add(this.chkKWAI3);
            this.grpCatControlBox.Controls.Add(this.chkKWAI2);
            this.grpCatControlBox.Controls.Add(this.labelTS63);
            this.grpCatControlBox.Controls.Add(this.comboCATPort6);
            this.grpCatControlBox.Controls.Add(this.chkCATEnable6);
            this.grpCatControlBox.Controls.Add(this.comboROTORPort);
            this.grpCatControlBox.Controls.Add(this.labelTS53);
            this.grpCatControlBox.Controls.Add(this.labelTS52);
            this.grpCatControlBox.Controls.Add(this.labelTS51);
            this.grpCatControlBox.Controls.Add(this.chkCATEnable5);
            this.grpCatControlBox.Controls.Add(this.chkCATEnable4);
            this.grpCatControlBox.Controls.Add(this.chkCATEnable3);
            this.grpCatControlBox.Controls.Add(this.chkKWAI);
            this.grpCatControlBox.Controls.Add(this.chkCATEnable2);
            this.grpCatControlBox.Controls.Add(this.txtCATPort5);
            this.grpCatControlBox.Controls.Add(this.txtCATPort4);
            this.grpCatControlBox.Controls.Add(this.txtCATPort3);
            this.grpCatControlBox.Controls.Add(this.txtCATPort2);
            this.grpCatControlBox.Controls.Add(this.txtCATPort1);
            this.grpCatControlBox.Controls.Add(this.comboCATPort5);
            this.grpCatControlBox.Controls.Add(this.comboCATPort4);
            this.grpCatControlBox.Controls.Add(this.comboCATPort3);
            this.grpCatControlBox.Controls.Add(this.comboCATPort2);
            this.grpCatControlBox.Controls.Add(this.labelTS50);
            this.grpCatControlBox.Controls.Add(this.labelTS49);
            this.grpCatControlBox.Controls.Add(this.labelTS48);
            this.grpCatControlBox.Controls.Add(this.labelTS47);
            this.grpCatControlBox.Controls.Add(this.labelTS20);
            this.grpCatControlBox.Controls.Add(this.chkROTOREnable);
            this.grpCatControlBox.Controls.Add(this.comboCATPort);
            this.grpCatControlBox.Controls.Add(this.comboCATbaud);
            this.grpCatControlBox.Controls.Add(this.lblCATBaud);
            this.grpCatControlBox.Controls.Add(this.lblCATPort);
            this.grpCatControlBox.Controls.Add(this.chkCATEnable);
            this.grpCatControlBox.Controls.Add(this.lblCATParity);
            this.grpCatControlBox.Controls.Add(this.lblCATData);
            this.grpCatControlBox.Controls.Add(this.lblCATStop);
            this.grpCatControlBox.Controls.Add(this.comboCATparity);
            this.grpCatControlBox.Controls.Add(this.comboCATdatabits);
            this.grpCatControlBox.Controls.Add(this.comboCATstopbits);
            this.grpCatControlBox.Controls.Add(this.labelTS57);
            this.grpCatControlBox.Location = new System.Drawing.Point(16, 16);
            this.grpCatControlBox.Name = "grpCatControlBox";
            this.grpCatControlBox.Size = new System.Drawing.Size(229, 322);
            this.grpCatControlBox.TabIndex = 90;
            this.grpCatControlBox.TabStop = false;
            this.grpCatControlBox.Text = "CAT Control";
            // 
            // chkKWAI6
            // 
            this.chkKWAI6.Image = null;
            this.chkKWAI6.Location = new System.Drawing.Point(187, 164);
            this.chkKWAI6.Name = "chkKWAI6";
            this.chkKWAI6.Size = new System.Drawing.Size(40, 24);
            this.chkKWAI6.TabIndex = 126;
            this.chkKWAI6.Text = "AI";
            this.toolTip1.SetToolTip(this.chkKWAI6, resources.GetString("chkKWAI6.ToolTip"));
            this.chkKWAI6.CheckedChanged += new System.EventHandler(this.chkKWAI6_CheckedChanged);
            // 
            // chkKWAI5
            // 
            this.chkKWAI5.Image = null;
            this.chkKWAI5.Location = new System.Drawing.Point(187, 136);
            this.chkKWAI5.Name = "chkKWAI5";
            this.chkKWAI5.Size = new System.Drawing.Size(40, 24);
            this.chkKWAI5.TabIndex = 125;
            this.chkKWAI5.Text = "AI";
            this.toolTip1.SetToolTip(this.chkKWAI5, resources.GetString("chkKWAI5.ToolTip"));
            this.chkKWAI5.CheckedChanged += new System.EventHandler(this.chkKWAI5_CheckedChanged);
            // 
            // chkKWAI4
            // 
            this.chkKWAI4.Image = null;
            this.chkKWAI4.Location = new System.Drawing.Point(187, 111);
            this.chkKWAI4.Name = "chkKWAI4";
            this.chkKWAI4.Size = new System.Drawing.Size(40, 24);
            this.chkKWAI4.TabIndex = 124;
            this.chkKWAI4.Text = "AI";
            this.toolTip1.SetToolTip(this.chkKWAI4, resources.GetString("chkKWAI4.ToolTip"));
            this.chkKWAI4.CheckedChanged += new System.EventHandler(this.chkKWAI4_CheckedChanged);
            // 
            // chkKWAI3
            // 
            this.chkKWAI3.Image = null;
            this.chkKWAI3.Location = new System.Drawing.Point(187, 85);
            this.chkKWAI3.Name = "chkKWAI3";
            this.chkKWAI3.Size = new System.Drawing.Size(40, 24);
            this.chkKWAI3.TabIndex = 123;
            this.chkKWAI3.Text = "AI";
            this.toolTip1.SetToolTip(this.chkKWAI3, resources.GetString("chkKWAI3.ToolTip"));
            this.chkKWAI3.CheckedChanged += new System.EventHandler(this.chkKWAI3_CheckedChanged);
            // 
            // chkKWAI2
            // 
            this.chkKWAI2.Image = null;
            this.chkKWAI2.Location = new System.Drawing.Point(187, 61);
            this.chkKWAI2.Name = "chkKWAI2";
            this.chkKWAI2.Size = new System.Drawing.Size(40, 24);
            this.chkKWAI2.TabIndex = 122;
            this.chkKWAI2.Text = "AI";
            this.toolTip1.SetToolTip(this.chkKWAI2, resources.GetString("chkKWAI2.ToolTip"));
            this.chkKWAI2.CheckedChanged += new System.EventHandler(this.chkKWAI2_CheckedChanged);
            // 
            // labelTS63
            // 
            this.labelTS63.Image = null;
            this.labelTS63.Location = new System.Drawing.Point(189, 16);
            this.labelTS63.Name = "labelTS63";
            this.labelTS63.Size = new System.Drawing.Size(34, 17);
            this.labelTS63.TabIndex = 121;
            this.labelTS63.Text = "Poll";
            // 
            // comboCATPort6
            // 
            this.comboCATPort6.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATPort6.DropDownWidth = 56;
            this.comboCATPort6.Location = new System.Drawing.Point(72, 163);
            this.comboCATPort6.Name = "comboCATPort6";
            this.comboCATPort6.Size = new System.Drawing.Size(72, 21);
            this.comboCATPort6.TabIndex = 119;
            this.toolTip1.SetToolTip(this.comboCATPort6, resources.GetString("comboCATPort6.ToolTip"));
            this.comboCATPort6.SelectedIndexChanged += new System.EventHandler(this.comboCATPort6_SelectedIndexChanged);
            // 
            // chkCATEnable6
            // 
            this.chkCATEnable6.Enabled = false;
            this.chkCATEnable6.Image = null;
            this.chkCATEnable6.Location = new System.Drawing.Point(150, 164);
            this.chkCATEnable6.Name = "chkCATEnable6";
            this.chkCATEnable6.Size = new System.Drawing.Size(40, 24);
            this.chkCATEnable6.TabIndex = 118;
            this.chkCATEnable6.Text = "on";
            this.toolTip1.SetToolTip(this.chkCATEnable6, resources.GetString("chkCATEnable6.ToolTip"));
            this.chkCATEnable6.CheckedChanged += new System.EventHandler(this.chkCATEnable6_CheckedChanged);
            // 
            // comboROTORPort
            // 
            this.comboROTORPort.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboROTORPort.DropDownWidth = 56;
            this.comboROTORPort.Location = new System.Drawing.Point(72, 293);
            this.comboROTORPort.Name = "comboROTORPort";
            this.comboROTORPort.Size = new System.Drawing.Size(72, 21);
            this.comboROTORPort.TabIndex = 97;
            this.toolTip1.SetToolTip(this.comboROTORPort, "This is one end of a Virtual COM port pair (see VspMgr).\r\n\r\nEnables Hygain Rotor " +
        "control directly OR thru DDUtil for other types of Rotors\r\n\r\n");
            this.comboROTORPort.SelectedIndexChanged += new System.EventHandler(this.comboROTORPort_SelectedIndexChanged);
            // 
            // labelTS53
            // 
            this.labelTS53.Image = null;
            this.labelTS53.Location = new System.Drawing.Point(145, 16);
            this.labelTS53.Name = "labelTS53";
            this.labelTS53.Size = new System.Drawing.Size(42, 17);
            this.labelTS53.TabIndex = 117;
            this.labelTS53.Text = "Enable";
            // 
            // labelTS52
            // 
            this.labelTS52.Image = null;
            this.labelTS52.Location = new System.Drawing.Point(86, 15);
            this.labelTS52.Name = "labelTS52";
            this.labelTS52.Size = new System.Drawing.Size(55, 17);
            this.labelTS52.TabIndex = 116;
            this.labelTS52.Text = "Com Port";
            // 
            // labelTS51
            // 
            this.labelTS51.Image = null;
            this.labelTS51.Location = new System.Drawing.Point(11, 16);
            this.labelTS51.Name = "labelTS51";
            this.labelTS51.Size = new System.Drawing.Size(55, 17);
            this.labelTS51.TabIndex = 115;
            this.labelTS51.Text = "Program";
            // 
            // chkCATEnable5
            // 
            this.chkCATEnable5.Image = null;
            this.chkCATEnable5.Location = new System.Drawing.Point(150, 134);
            this.chkCATEnable5.Name = "chkCATEnable5";
            this.chkCATEnable5.Size = new System.Drawing.Size(40, 24);
            this.chkCATEnable5.TabIndex = 114;
            this.chkCATEnable5.Text = "on";
            this.chkCATEnable5.CheckedChanged += new System.EventHandler(this.chkCATEnable5_CheckedChanged);
            // 
            // chkCATEnable4
            // 
            this.chkCATEnable4.Image = null;
            this.chkCATEnable4.Location = new System.Drawing.Point(150, 109);
            this.chkCATEnable4.Name = "chkCATEnable4";
            this.chkCATEnable4.Size = new System.Drawing.Size(40, 24);
            this.chkCATEnable4.TabIndex = 113;
            this.chkCATEnable4.Text = "on";
            this.chkCATEnable4.CheckedChanged += new System.EventHandler(this.chkCATEnable4_CheckedChanged);
            // 
            // chkCATEnable3
            // 
            this.chkCATEnable3.Image = null;
            this.chkCATEnable3.Location = new System.Drawing.Point(150, 83);
            this.chkCATEnable3.Name = "chkCATEnable3";
            this.chkCATEnable3.Size = new System.Drawing.Size(40, 24);
            this.chkCATEnable3.TabIndex = 112;
            this.chkCATEnable3.Text = "on";
            this.chkCATEnable3.CheckedChanged += new System.EventHandler(this.chkCATEnable3_CheckedChanged);
            // 
            // chkKWAI
            // 
            this.chkKWAI.Image = null;
            this.chkKWAI.Location = new System.Drawing.Point(187, 36);
            this.chkKWAI.Name = "chkKWAI";
            this.chkKWAI.Size = new System.Drawing.Size(40, 24);
            this.chkKWAI.TabIndex = 98;
            this.chkKWAI.Text = "AI";
            this.toolTip1.SetToolTip(this.chkKWAI, resources.GetString("chkKWAI.ToolTip"));
            this.chkKWAI.CheckedChanged += new System.EventHandler(this.chkKWAI_CheckedChanged);
            // 
            // chkCATEnable2
            // 
            this.chkCATEnable2.Image = null;
            this.chkCATEnable2.Location = new System.Drawing.Point(150, 59);
            this.chkCATEnable2.Name = "chkCATEnable2";
            this.chkCATEnable2.Size = new System.Drawing.Size(40, 24);
            this.chkCATEnable2.TabIndex = 111;
            this.chkCATEnable2.Text = "on";
            this.chkCATEnable2.CheckedChanged += new System.EventHandler(this.chkCATEnable2_CheckedChanged);
            // 
            // txtCATPort5
            // 
            this.txtCATPort5.Location = new System.Drawing.Point(6, 136);
            this.txtCATPort5.MaxLength = 10;
            this.txtCATPort5.Name = "txtCATPort5";
            this.txtCATPort5.Size = new System.Drawing.Size(58, 20);
            this.txtCATPort5.TabIndex = 110;
            this.txtCATPort5.Text = "Logging";
            this.txtCATPort5.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.toolTip1.SetToolTip(this.txtCATPort5, "Assign a name to this COM port, used to send/receive CAT commands with PowerSDR.");
            // 
            // txtCATPort4
            // 
            this.txtCATPort4.Location = new System.Drawing.Point(6, 112);
            this.txtCATPort4.MaxLength = 10;
            this.txtCATPort4.Name = "txtCATPort4";
            this.txtCATPort4.Size = new System.Drawing.Size(58, 20);
            this.txtCATPort4.TabIndex = 109;
            this.txtCATPort4.Text = "FreeDV";
            this.txtCATPort4.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.toolTip1.SetToolTip(this.txtCATPort4, "Assign a name to this COM port, used to send/receive CAT commands with PowerSDR.");
            // 
            // txtCATPort3
            // 
            this.txtCATPort3.Location = new System.Drawing.Point(6, 85);
            this.txtCATPort3.MaxLength = 10;
            this.txtCATPort3.Name = "txtCATPort3";
            this.txtCATPort3.Size = new System.Drawing.Size(58, 20);
            this.txtCATPort3.TabIndex = 108;
            this.txtCATPort3.Text = "WSJT-X";
            this.txtCATPort3.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.toolTip1.SetToolTip(this.txtCATPort3, "Assign a name to this COM port, used to send/receive CAT commands with PowerSDR.");
            // 
            // txtCATPort2
            // 
            this.txtCATPort2.Location = new System.Drawing.Point(6, 59);
            this.txtCATPort2.MaxLength = 10;
            this.txtCATPort2.Name = "txtCATPort2";
            this.txtCATPort2.Size = new System.Drawing.Size(58, 20);
            this.txtCATPort2.TabIndex = 107;
            this.txtCATPort2.Text = "FLDIGI";
            this.txtCATPort2.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.toolTip1.SetToolTip(this.txtCATPort2, "Assign a name to this COM port, used to send/receive CAT commands with PowerSDR.");
            // 
            // txtCATPort1
            // 
            this.txtCATPort1.Location = new System.Drawing.Point(6, 36);
            this.txtCATPort1.MaxLength = 10;
            this.txtCATPort1.Name = "txtCATPort1";
            this.txtCATPort1.Size = new System.Drawing.Size(58, 20);
            this.txtCATPort1.TabIndex = 4;
            this.txtCATPort1.Text = "DDUtil";
            this.txtCATPort1.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.toolTip1.SetToolTip(this.txtCATPort1, resources.GetString("txtCATPort1.ToolTip"));
            // 
            // comboCATPort5
            // 
            this.comboCATPort5.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATPort5.DropDownWidth = 56;
            this.comboCATPort5.Location = new System.Drawing.Point(72, 136);
            this.comboCATPort5.Name = "comboCATPort5";
            this.comboCATPort5.Size = new System.Drawing.Size(72, 21);
            this.comboCATPort5.TabIndex = 106;
            this.toolTip1.SetToolTip(this.comboCATPort5, resources.GetString("comboCATPort5.ToolTip"));
            this.comboCATPort5.SelectedIndexChanged += new System.EventHandler(this.comboCATPort5_SelectedIndexChanged);
            // 
            // comboCATPort4
            // 
            this.comboCATPort4.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATPort4.DropDownWidth = 56;
            this.comboCATPort4.Location = new System.Drawing.Point(72, 111);
            this.comboCATPort4.Name = "comboCATPort4";
            this.comboCATPort4.Size = new System.Drawing.Size(72, 21);
            this.comboCATPort4.TabIndex = 105;
            this.toolTip1.SetToolTip(this.comboCATPort4, resources.GetString("comboCATPort4.ToolTip"));
            this.comboCATPort4.SelectedIndexChanged += new System.EventHandler(this.comboCATPort4_SelectedIndexChanged);
            // 
            // comboCATPort3
            // 
            this.comboCATPort3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATPort3.DropDownWidth = 56;
            this.comboCATPort3.Location = new System.Drawing.Point(72, 85);
            this.comboCATPort3.Name = "comboCATPort3";
            this.comboCATPort3.Size = new System.Drawing.Size(72, 21);
            this.comboCATPort3.TabIndex = 104;
            this.toolTip1.SetToolTip(this.comboCATPort3, resources.GetString("comboCATPort3.ToolTip"));
            this.comboCATPort3.SelectedIndexChanged += new System.EventHandler(this.comboCATPort3_SelectedIndexChanged);
            // 
            // comboCATPort2
            // 
            this.comboCATPort2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATPort2.DropDownWidth = 56;
            this.comboCATPort2.Location = new System.Drawing.Point(72, 60);
            this.comboCATPort2.Name = "comboCATPort2";
            this.comboCATPort2.Size = new System.Drawing.Size(72, 21);
            this.comboCATPort2.TabIndex = 103;
            this.toolTip1.SetToolTip(this.comboCATPort2, resources.GetString("comboCATPort2.ToolTip"));
            this.comboCATPort2.SelectedIndexChanged += new System.EventHandler(this.comboCATPort2_SelectedIndexChanged);
            // 
            // labelTS50
            // 
            this.labelTS50.Image = null;
            this.labelTS50.Location = new System.Drawing.Point(26, 139);
            this.labelTS50.Name = "labelTS50";
            this.labelTS50.Size = new System.Drawing.Size(40, 23);
            this.labelTS50.TabIndex = 102;
            this.labelTS50.Text = "Port5:";
            // 
            // labelTS49
            // 
            this.labelTS49.Image = null;
            this.labelTS49.Location = new System.Drawing.Point(26, 114);
            this.labelTS49.Name = "labelTS49";
            this.labelTS49.Size = new System.Drawing.Size(40, 23);
            this.labelTS49.TabIndex = 101;
            this.labelTS49.Text = "Port4:";
            // 
            // labelTS48
            // 
            this.labelTS48.Image = null;
            this.labelTS48.Location = new System.Drawing.Point(26, 88);
            this.labelTS48.Name = "labelTS48";
            this.labelTS48.Size = new System.Drawing.Size(40, 23);
            this.labelTS48.TabIndex = 100;
            this.labelTS48.Text = "Port3:";
            // 
            // labelTS47
            // 
            this.labelTS47.Image = null;
            this.labelTS47.Location = new System.Drawing.Point(26, 62);
            this.labelTS47.Name = "labelTS47";
            this.labelTS47.Size = new System.Drawing.Size(40, 23);
            this.labelTS47.TabIndex = 99;
            this.labelTS47.Text = "Port2:";
            // 
            // labelTS20
            // 
            this.labelTS20.Image = null;
            this.labelTS20.Location = new System.Drawing.Point(3, 296);
            this.labelTS20.Name = "labelTS20";
            this.labelTS20.Size = new System.Drawing.Size(77, 23);
            this.labelTS20.TabIndex = 98;
            this.labelTS20.Text = "Rotor Control";
            this.toolTip1.SetToolTip(this.labelTS20, "This is one end of a Virtual COM port pair (see VspMgr).\r\n\r\nEnables Hygain Rotor " +
        "control directly or thru DDUtil.\r\n");
            // 
            // chkROTOREnable
            // 
            this.chkROTOREnable.Image = null;
            this.chkROTOREnable.Location = new System.Drawing.Point(150, 291);
            this.chkROTOREnable.Name = "chkROTOREnable";
            this.chkROTOREnable.Size = new System.Drawing.Size(44, 24);
            this.chkROTOREnable.TabIndex = 96;
            this.chkROTOREnable.Text = "on";
            this.toolTip1.SetToolTip(this.chkROTOREnable, "This is one end of a Virtual COM port pair (see VspMgr).\r\n\r\nEnables Hygain Rotor " +
        "control directly or thru DDUtil.\r\n");
            this.chkROTOREnable.CheckedChanged += new System.EventHandler(this.chkROTOREnable_CheckedChanged);
            // 
            // comboCATPort
            // 
            this.comboCATPort.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATPort.DropDownWidth = 56;
            this.comboCATPort.Location = new System.Drawing.Point(72, 35);
            this.comboCATPort.Name = "comboCATPort";
            this.comboCATPort.Size = new System.Drawing.Size(72, 21);
            this.comboCATPort.TabIndex = 95;
            this.toolTip1.SetToolTip(this.comboCATPort, resources.GetString("comboCATPort.ToolTip"));
            this.comboCATPort.SelectedIndexChanged += new System.EventHandler(this.comboCATPort_SelectedIndexChanged);
            // 
            // comboCATbaud
            // 
            this.comboCATbaud.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATbaud.DropDownWidth = 56;
            this.comboCATbaud.Items.AddRange(new object[] {
            "300",
            "1200",
            "2400",
            "4800",
            "9600",
            "19200",
            "38400",
            "57600",
            "115200"});
            this.comboCATbaud.Location = new System.Drawing.Point(72, 192);
            this.comboCATbaud.Name = "comboCATbaud";
            this.comboCATbaud.Size = new System.Drawing.Size(72, 21);
            this.comboCATbaud.TabIndex = 93;
            this.comboCATbaud.SelectedIndexChanged += new System.EventHandler(this.comboCATbaud_SelectedIndexChanged);
            // 
            // lblCATBaud
            // 
            this.lblCATBaud.Image = null;
            this.lblCATBaud.Location = new System.Drawing.Point(26, 195);
            this.lblCATBaud.Name = "lblCATBaud";
            this.lblCATBaud.Size = new System.Drawing.Size(40, 23);
            this.lblCATBaud.TabIndex = 5;
            this.lblCATBaud.Text = "Baud";
            // 
            // lblCATPort
            // 
            this.lblCATPort.Image = null;
            this.lblCATPort.Location = new System.Drawing.Point(26, 38);
            this.lblCATPort.Name = "lblCATPort";
            this.lblCATPort.Size = new System.Drawing.Size(40, 23);
            this.lblCATPort.TabIndex = 3;
            this.lblCATPort.Text = "Port1:";
            // 
            // chkCATEnable
            // 
            this.chkCATEnable.Image = null;
            this.chkCATEnable.Location = new System.Drawing.Point(150, 35);
            this.chkCATEnable.Name = "chkCATEnable";
            this.chkCATEnable.Size = new System.Drawing.Size(38, 24);
            this.chkCATEnable.TabIndex = 0;
            this.chkCATEnable.Text = "on";
            this.chkCATEnable.CheckedChanged += new System.EventHandler(this.chkCATEnable_CheckedChanged);
            // 
            // lblCATParity
            // 
            this.lblCATParity.Image = null;
            this.lblCATParity.Location = new System.Drawing.Point(24, 218);
            this.lblCATParity.Name = "lblCATParity";
            this.lblCATParity.Size = new System.Drawing.Size(48, 23);
            this.lblCATParity.TabIndex = 92;
            this.lblCATParity.Text = "Parity";
            // 
            // lblCATData
            // 
            this.lblCATData.Image = null;
            this.lblCATData.Location = new System.Drawing.Point(26, 243);
            this.lblCATData.Name = "lblCATData";
            this.lblCATData.Size = new System.Drawing.Size(40, 23);
            this.lblCATData.TabIndex = 92;
            this.lblCATData.Text = "Data";
            // 
            // lblCATStop
            // 
            this.lblCATStop.Image = null;
            this.lblCATStop.Location = new System.Drawing.Point(26, 264);
            this.lblCATStop.Name = "lblCATStop";
            this.lblCATStop.Size = new System.Drawing.Size(40, 23);
            this.lblCATStop.TabIndex = 92;
            this.lblCATStop.Text = "Stop";
            // 
            // comboCATparity
            // 
            this.comboCATparity.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATparity.DropDownWidth = 56;
            this.comboCATparity.Items.AddRange(new object[] {
            "none",
            "odd ",
            "even",
            "mark",
            "space"});
            this.comboCATparity.Location = new System.Drawing.Point(72, 215);
            this.comboCATparity.Name = "comboCATparity";
            this.comboCATparity.Size = new System.Drawing.Size(72, 21);
            this.comboCATparity.TabIndex = 92;
            this.comboCATparity.SelectedIndexChanged += new System.EventHandler(this.comboCATparity_SelectedIndexChanged);
            // 
            // comboCATdatabits
            // 
            this.comboCATdatabits.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATdatabits.DropDownWidth = 56;
            this.comboCATdatabits.Items.AddRange(new object[] {
            "8",
            "7",
            "6"});
            this.comboCATdatabits.Location = new System.Drawing.Point(72, 238);
            this.comboCATdatabits.Name = "comboCATdatabits";
            this.comboCATdatabits.Size = new System.Drawing.Size(72, 21);
            this.comboCATdatabits.TabIndex = 93;
            this.comboCATdatabits.SelectedIndexChanged += new System.EventHandler(this.comboCATdatabits_SelectedIndexChanged);
            // 
            // comboCATstopbits
            // 
            this.comboCATstopbits.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCATstopbits.DropDownWidth = 56;
            this.comboCATstopbits.Items.AddRange(new object[] {
            "1",
            "1.5",
            "2"});
            this.comboCATstopbits.Location = new System.Drawing.Point(72, 261);
            this.comboCATstopbits.Name = "comboCATstopbits";
            this.comboCATstopbits.Size = new System.Drawing.Size(72, 21);
            this.comboCATstopbits.TabIndex = 94;
            this.comboCATstopbits.SelectedIndexChanged += new System.EventHandler(this.comboCATstopbits_SelectedIndexChanged);
            // 
            // labelTS57
            // 
            this.labelTS57.Image = null;
            this.labelTS57.Location = new System.Drawing.Point(3, 165);
            this.labelTS57.Name = "labelTS57";
            this.labelTS57.Size = new System.Drawing.Size(77, 23);
            this.labelTS57.TabIndex = 120;
            this.labelTS57.Text = "RX2 VFOB";
            this.toolTip1.SetToolTip(this.labelTS57, resources.GetString("labelTS57.ToolTip"));
            // 
            // grpRTTYOffset
            // 
            this.grpRTTYOffset.Controls.Add(this.labelTS4);
            this.grpRTTYOffset.Controls.Add(this.labelTS3);
            this.grpRTTYOffset.Controls.Add(this.udRTTYU);
            this.grpRTTYOffset.Controls.Add(this.udRTTYL);
            this.grpRTTYOffset.Controls.Add(this.chkRTTYOffsetEnableB);
            this.grpRTTYOffset.Controls.Add(this.chkRTTYOffsetEnableA);
            this.grpRTTYOffset.Location = new System.Drawing.Point(400, 120);
            this.grpRTTYOffset.Name = "grpRTTYOffset";
            this.grpRTTYOffset.Size = new System.Drawing.Size(168, 120);
            this.grpRTTYOffset.TabIndex = 97;
            this.grpRTTYOffset.TabStop = false;
            this.grpRTTYOffset.Text = "RTTY Offset";
            // 
            // labelTS4
            // 
            this.labelTS4.Image = null;
            this.labelTS4.Location = new System.Drawing.Point(108, 69);
            this.labelTS4.Name = "labelTS4";
            this.labelTS4.Size = new System.Drawing.Size(40, 16);
            this.labelTS4.TabIndex = 101;
            this.labelTS4.Text = "DIGU";
            // 
            // labelTS3
            // 
            this.labelTS3.Image = null;
            this.labelTS3.Location = new System.Drawing.Point(24, 69);
            this.labelTS3.Name = "labelTS3";
            this.labelTS3.Size = new System.Drawing.Size(40, 16);
            this.labelTS3.TabIndex = 100;
            this.labelTS3.Text = "DIGL";
            // 
            // udRTTYU
            // 
            this.udRTTYU.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udRTTYU.Location = new System.Drawing.Point(104, 88);
            this.udRTTYU.Maximum = new decimal(new int[] {
            3000,
            0,
            0,
            0});
            this.udRTTYU.Minimum = new decimal(new int[] {
            3000,
            0,
            0,
            -2147483648});
            this.udRTTYU.Name = "udRTTYU";
            this.udRTTYU.Size = new System.Drawing.Size(48, 20);
            this.udRTTYU.TabIndex = 99;
            this.toolTip1.SetToolTip(this.udRTTYU, "Sets the DIGU frequency offset");
            this.udRTTYU.Value = new decimal(new int[] {
            2125,
            0,
            0,
            0});
            this.udRTTYU.ValueChanged += new System.EventHandler(this.udRTTYU_ValueChanged);
            // 
            // udRTTYL
            // 
            this.udRTTYL.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udRTTYL.Location = new System.Drawing.Point(16, 88);
            this.udRTTYL.Maximum = new decimal(new int[] {
            3000,
            0,
            0,
            0});
            this.udRTTYL.Minimum = new decimal(new int[] {
            3000,
            0,
            0,
            -2147483648});
            this.udRTTYL.Name = "udRTTYL";
            this.udRTTYL.Size = new System.Drawing.Size(48, 20);
            this.udRTTYL.TabIndex = 98;
            this.toolTip1.SetToolTip(this.udRTTYL, "Sets the DIGL frequency offset");
            this.udRTTYL.Value = new decimal(new int[] {
            2125,
            0,
            0,
            0});
            this.udRTTYL.ValueChanged += new System.EventHandler(this.udRTTYL_ValueChanged);
            // 
            // chkRTTYOffsetEnableB
            // 
            this.chkRTTYOffsetEnableB.Image = null;
            this.chkRTTYOffsetEnableB.Location = new System.Drawing.Point(16, 40);
            this.chkRTTYOffsetEnableB.Name = "chkRTTYOffsetEnableB";
            this.chkRTTYOffsetEnableB.Size = new System.Drawing.Size(136, 24);
            this.chkRTTYOffsetEnableB.TabIndex = 97;
            this.chkRTTYOffsetEnableB.Text = "Enable Offset VFO B";
            this.chkRTTYOffsetEnableB.CheckedChanged += new System.EventHandler(this.chkRTTYOffsetEnableB_CheckedChanged);
            // 
            // chkRTTYOffsetEnableA
            // 
            this.chkRTTYOffsetEnableA.Image = null;
            this.chkRTTYOffsetEnableA.Location = new System.Drawing.Point(16, 16);
            this.chkRTTYOffsetEnableA.Name = "chkRTTYOffsetEnableA";
            this.chkRTTYOffsetEnableA.Size = new System.Drawing.Size(136, 24);
            this.chkRTTYOffsetEnableA.TabIndex = 96;
            this.chkRTTYOffsetEnableA.Text = "Enable Offset VFO A";
            this.chkRTTYOffsetEnableA.CheckedChanged += new System.EventHandler(this.chkRTTYOffsetEnableA_CheckedChanged);
            // 
            // tpTests
            // 
            this.tpTests.Controls.Add(this.grpBoxTS1);
            this.tpTests.Controls.Add(this.ckEnableSigGen);
            this.tpTests.Controls.Add(this.grpTestX2);
            this.tpTests.Controls.Add(this.grpTestAudioBalance);
            this.tpTests.Controls.Add(this.grpTestTXIMD);
            this.tpTests.Controls.Add(this.grpImpulseTest);
            this.tpTests.Location = new System.Drawing.Point(4, 22);
            this.tpTests.Name = "tpTests";
            this.tpTests.Size = new System.Drawing.Size(584, 341);
            this.tpTests.TabIndex = 7;
            this.tpTests.Text = "Tests";
            // 
            // grpBoxTS1
            // 
            this.grpBoxTS1.Controls.Add(this.udPulsePeriod);
            this.grpBoxTS1.Controls.Add(this.lblPulsePeriod);
            this.grpBoxTS1.Controls.Add(this.udPulseDuty);
            this.grpBoxTS1.Controls.Add(this.lblPulseDuty);
            this.grpBoxTS1.Controls.Add(this.grpSigGenTransmit);
            this.grpBoxTS1.Controls.Add(this.grpSigGenReceive);
            this.grpBoxTS1.Controls.Add(this.lblTestGenScale);
            this.grpBoxTS1.Controls.Add(this.udTestGenScale);
            this.grpBoxTS1.Controls.Add(this.lblTestSigGenFreqCallout);
            this.grpBoxTS1.Controls.Add(this.tkbarTestGenFreq);
            this.grpBoxTS1.Controls.Add(this.lblTestGenHzSec);
            this.grpBoxTS1.Controls.Add(this.udTestGenHzSec);
            this.grpBoxTS1.Controls.Add(this.lblTestGenHigh);
            this.grpBoxTS1.Controls.Add(this.udTestGenHigh);
            this.grpBoxTS1.Controls.Add(this.lblTestGenLow);
            this.grpBoxTS1.Controls.Add(this.udTestGenLow);
            this.grpBoxTS1.Controls.Add(this.btnTestGenSweep);
            this.grpBoxTS1.Location = new System.Drawing.Point(176, 80);
            this.grpBoxTS1.Name = "grpBoxTS1";
            this.grpBoxTS1.Size = new System.Drawing.Size(400, 192);
            this.grpBoxTS1.TabIndex = 88;
            this.grpBoxTS1.TabStop = false;
            this.grpBoxTS1.Text = "Signal Generator";
            // 
            // udPulsePeriod
            // 
            this.udPulsePeriod.DecimalPlaces = 2;
            this.udPulsePeriod.Increment = new decimal(new int[] {
            1,
            0,
            0,
            131072});
            this.udPulsePeriod.Location = new System.Drawing.Point(351, 86);
            this.udPulsePeriod.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPulsePeriod.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPulsePeriod.Name = "udPulsePeriod";
            this.udPulsePeriod.Size = new System.Drawing.Size(43, 20);
            this.udPulsePeriod.TabIndex = 105;
            this.toolTip1.SetToolTip(this.udPulsePeriod, "Pulses per second");
            this.udPulsePeriod.Value = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udPulsePeriod.Visible = false;
            this.udPulsePeriod.ValueChanged += new System.EventHandler(this.udPulsePeriod_ValueChanged);
            // 
            // lblPulsePeriod
            // 
            this.lblPulsePeriod.Image = null;
            this.lblPulsePeriod.Location = new System.Drawing.Point(310, 88);
            this.lblPulsePeriod.Name = "lblPulsePeriod";
            this.lblPulsePeriod.Size = new System.Drawing.Size(40, 16);
            this.lblPulsePeriod.TabIndex = 106;
            this.lblPulsePeriod.Text = "Period:";
            this.lblPulsePeriod.Visible = false;
            // 
            // udPulseDuty
            // 
            this.udPulseDuty.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udPulseDuty.Location = new System.Drawing.Point(351, 64);
            this.udPulseDuty.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udPulseDuty.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udPulseDuty.Name = "udPulseDuty";
            this.udPulseDuty.Size = new System.Drawing.Size(40, 20);
            this.udPulseDuty.TabIndex = 103;
            this.toolTip1.SetToolTip(this.udPulseDuty, "Duty cycle of ON to OFF ratio (1% to 100%)");
            this.udPulseDuty.Value = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udPulseDuty.Visible = false;
            this.udPulseDuty.ValueChanged += new System.EventHandler(this.udPulseDuty_ValueChanged);
            // 
            // lblPulseDuty
            // 
            this.lblPulseDuty.Image = null;
            this.lblPulseDuty.Location = new System.Drawing.Point(318, 66);
            this.lblPulseDuty.Name = "lblPulseDuty";
            this.lblPulseDuty.Size = new System.Drawing.Size(32, 16);
            this.lblPulseDuty.TabIndex = 104;
            this.lblPulseDuty.Text = "Duty:";
            this.lblPulseDuty.Visible = false;
            // 
            // grpSigGenTransmit
            // 
            this.grpSigGenTransmit.Controls.Add(this.lblSigGenTXMode);
            this.grpSigGenTransmit.Controls.Add(this.cmboSigGenTXMode);
            this.grpSigGenTransmit.Controls.Add(this.rdSigGenTXInput);
            this.grpSigGenTransmit.Controls.Add(this.rdSigGenTXOutput);
            this.grpSigGenTransmit.Location = new System.Drawing.Point(160, 16);
            this.grpSigGenTransmit.Name = "grpSigGenTransmit";
            this.grpSigGenTransmit.Size = new System.Drawing.Size(152, 64);
            this.grpSigGenTransmit.TabIndex = 102;
            this.grpSigGenTransmit.TabStop = false;
            this.grpSigGenTransmit.Text = "Transmit";
            // 
            // lblSigGenTXMode
            // 
            this.lblSigGenTXMode.Image = null;
            this.lblSigGenTXMode.Location = new System.Drawing.Point(16, 16);
            this.lblSigGenTXMode.Name = "lblSigGenTXMode";
            this.lblSigGenTXMode.Size = new System.Drawing.Size(40, 16);
            this.lblSigGenTXMode.TabIndex = 96;
            this.lblSigGenTXMode.Text = "Mode:";
            // 
            // cmboSigGenTXMode
            // 
            this.cmboSigGenTXMode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmboSigGenTXMode.DropDownWidth = 121;
            this.cmboSigGenTXMode.Items.AddRange(new object[] {
            "Radio",
            "Tone",
            "Noise",
            "Triangle",
            "Sawtooth",
            "Pulse",
            "Silence"});
            this.cmboSigGenTXMode.Location = new System.Drawing.Point(56, 16);
            this.cmboSigGenTXMode.Name = "cmboSigGenTXMode";
            this.cmboSigGenTXMode.Size = new System.Drawing.Size(88, 21);
            this.cmboSigGenTXMode.TabIndex = 91;
            this.toolTip1.SetToolTip(this.cmboSigGenTXMode, "Select the signal type.");
            this.cmboSigGenTXMode.SelectedIndexChanged += new System.EventHandler(this.cmboSigGenTXMode_SelectedIndexChanged);
            // 
            // rdSigGenTXInput
            // 
            this.rdSigGenTXInput.Checked = true;
            this.rdSigGenTXInput.Image = null;
            this.rdSigGenTXInput.Location = new System.Drawing.Point(24, 40);
            this.rdSigGenTXInput.Name = "rdSigGenTXInput";
            this.rdSigGenTXInput.Size = new System.Drawing.Size(50, 16);
            this.rdSigGenTXInput.TabIndex = 99;
            this.rdSigGenTXInput.TabStop = true;
            this.rdSigGenTXInput.Text = "Input";
            this.rdSigGenTXInput.CheckedChanged += new System.EventHandler(this.rdSigGenTXInput_CheckedChanged);
            // 
            // rdSigGenTXOutput
            // 
            this.rdSigGenTXOutput.Image = null;
            this.rdSigGenTXOutput.Location = new System.Drawing.Point(80, 40);
            this.rdSigGenTXOutput.Name = "rdSigGenTXOutput";
            this.rdSigGenTXOutput.Size = new System.Drawing.Size(64, 16);
            this.rdSigGenTXOutput.TabIndex = 100;
            this.rdSigGenTXOutput.Text = "Output";
            this.rdSigGenTXOutput.Visible = false;
            this.rdSigGenTXOutput.CheckedChanged += new System.EventHandler(this.rdSigGenTXOutput_CheckedChanged);
            // 
            // grpSigGenReceive
            // 
            this.grpSigGenReceive.Controls.Add(this.chkSigGenRX2);
            this.grpSigGenReceive.Controls.Add(this.lblSigGenRXMode);
            this.grpSigGenReceive.Controls.Add(this.cmboSigGenRXMode);
            this.grpSigGenReceive.Controls.Add(this.rdSigGenRXInput);
            this.grpSigGenReceive.Controls.Add(this.rdSigGenRXOutput);
            this.grpSigGenReceive.Location = new System.Drawing.Point(8, 16);
            this.grpSigGenReceive.Name = "grpSigGenReceive";
            this.grpSigGenReceive.Size = new System.Drawing.Size(152, 88);
            this.grpSigGenReceive.TabIndex = 101;
            this.grpSigGenReceive.TabStop = false;
            this.grpSigGenReceive.Text = "Receive";
            // 
            // chkSigGenRX2
            // 
            this.chkSigGenRX2.Location = new System.Drawing.Point(16, 56);
            this.chkSigGenRX2.Name = "chkSigGenRX2";
            this.chkSigGenRX2.Size = new System.Drawing.Size(48, 24);
            this.chkSigGenRX2.TabIndex = 101;
            this.chkSigGenRX2.Text = "RX2";
            this.chkSigGenRX2.CheckedChanged += new System.EventHandler(this.chkSigGenRX2_CheckedChanged);
            // 
            // lblSigGenRXMode
            // 
            this.lblSigGenRXMode.Image = null;
            this.lblSigGenRXMode.Location = new System.Drawing.Point(16, 16);
            this.lblSigGenRXMode.Name = "lblSigGenRXMode";
            this.lblSigGenRXMode.Size = new System.Drawing.Size(40, 16);
            this.lblSigGenRXMode.TabIndex = 96;
            this.lblSigGenRXMode.Text = "Mode:";
            // 
            // cmboSigGenRXMode
            // 
            this.cmboSigGenRXMode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmboSigGenRXMode.DropDownWidth = 121;
            this.cmboSigGenRXMode.Items.AddRange(new object[] {
            "Radio",
            "Tone",
            "Noise",
            "Triangle",
            "Sawtooth",
            "Pulse",
            "Silence"});
            this.cmboSigGenRXMode.Location = new System.Drawing.Point(56, 16);
            this.cmboSigGenRXMode.Name = "cmboSigGenRXMode";
            this.cmboSigGenRXMode.Size = new System.Drawing.Size(88, 21);
            this.cmboSigGenRXMode.TabIndex = 91;
            this.toolTip1.SetToolTip(this.cmboSigGenRXMode, "Select the signal type.");
            this.cmboSigGenRXMode.SelectedIndexChanged += new System.EventHandler(this.cmboSigGenRXMode_SelectedIndexChanged);
            // 
            // rdSigGenRXInput
            // 
            this.rdSigGenRXInput.Checked = true;
            this.rdSigGenRXInput.Image = null;
            this.rdSigGenRXInput.Location = new System.Drawing.Point(24, 40);
            this.rdSigGenRXInput.Name = "rdSigGenRXInput";
            this.rdSigGenRXInput.Size = new System.Drawing.Size(51, 16);
            this.rdSigGenRXInput.TabIndex = 99;
            this.rdSigGenRXInput.TabStop = true;
            this.rdSigGenRXInput.Text = "Input";
            this.rdSigGenRXInput.CheckedChanged += new System.EventHandler(this.rdSigGenRXInput_CheckedChanged);
            // 
            // rdSigGenRXOutput
            // 
            this.rdSigGenRXOutput.Image = null;
            this.rdSigGenRXOutput.Location = new System.Drawing.Point(80, 40);
            this.rdSigGenRXOutput.Name = "rdSigGenRXOutput";
            this.rdSigGenRXOutput.Size = new System.Drawing.Size(64, 16);
            this.rdSigGenRXOutput.TabIndex = 100;
            this.rdSigGenRXOutput.Text = "Output";
            this.rdSigGenRXOutput.CheckedChanged += new System.EventHandler(this.rdSigGenRXOutput_CheckedChanged);
            // 
            // lblTestGenScale
            // 
            this.lblTestGenScale.Image = null;
            this.lblTestGenScale.Location = new System.Drawing.Point(320, 24);
            this.lblTestGenScale.Name = "lblTestGenScale";
            this.lblTestGenScale.Size = new System.Drawing.Size(40, 16);
            this.lblTestGenScale.TabIndex = 95;
            this.lblTestGenScale.Text = "Scale:";
            this.lblTestGenScale.Visible = false;
            // 
            // udTestGenScale
            // 
            this.udTestGenScale.DecimalPlaces = 6;
            this.udTestGenScale.Increment = new decimal(new int[] {
            1,
            0,
            0,
            196608});
            this.udTestGenScale.Location = new System.Drawing.Point(320, 40);
            this.udTestGenScale.Maximum = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udTestGenScale.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTestGenScale.Name = "udTestGenScale";
            this.udTestGenScale.Size = new System.Drawing.Size(72, 20);
            this.udTestGenScale.TabIndex = 94;
            this.toolTip1.SetToolTip(this.udTestGenScale, "Sets the amplitude of the signal (typically between 0 and 1.0)");
            this.udTestGenScale.Value = new decimal(new int[] {
            10,
            0,
            0,
            65536});
            this.udTestGenScale.Visible = false;
            this.udTestGenScale.ValueChanged += new System.EventHandler(this.updnTestGenScale_ValueChanged);
            this.udTestGenScale.LostFocus += new System.EventHandler(this.udTestGenScale_LostFocus);
            // 
            // lblTestSigGenFreqCallout
            // 
            this.lblTestSigGenFreqCallout.Image = null;
            this.lblTestSigGenFreqCallout.Location = new System.Drawing.Point(24, 136);
            this.lblTestSigGenFreqCallout.Name = "lblTestSigGenFreqCallout";
            this.lblTestSigGenFreqCallout.Size = new System.Drawing.Size(336, 16);
            this.lblTestSigGenFreqCallout.TabIndex = 90;
            this.lblTestSigGenFreqCallout.Text = "0                                                 10k                            " +
    "                   20k";
            // 
            // tkbarTestGenFreq
            // 
            this.tkbarTestGenFreq.Location = new System.Drawing.Point(16, 104);
            this.tkbarTestGenFreq.Maximum = 20000;
            this.tkbarTestGenFreq.Name = "tkbarTestGenFreq";
            this.tkbarTestGenFreq.Size = new System.Drawing.Size(344, 45);
            this.tkbarTestGenFreq.TabIndex = 1;
            this.tkbarTestGenFreq.TickFrequency = 1000;
            this.toolTip1.SetToolTip(this.tkbarTestGenFreq, "Sets the frequency of the signal.");
            this.tkbarTestGenFreq.Value = 10000;
            this.tkbarTestGenFreq.Scroll += new System.EventHandler(this.tkbarTestGenFreq_Scroll);
            // 
            // lblTestGenHzSec
            // 
            this.lblTestGenHzSec.Image = null;
            this.lblTestGenHzSec.Location = new System.Drawing.Point(200, 160);
            this.lblTestGenHzSec.Name = "lblTestGenHzSec";
            this.lblTestGenHzSec.Size = new System.Drawing.Size(48, 16);
            this.lblTestGenHzSec.TabIndex = 88;
            this.lblTestGenHzSec.Text = "Hz/Sec:";
            // 
            // udTestGenHzSec
            // 
            this.udTestGenHzSec.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTestGenHzSec.Location = new System.Drawing.Point(248, 160);
            this.udTestGenHzSec.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udTestGenHzSec.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTestGenHzSec.Name = "udTestGenHzSec";
            this.udTestGenHzSec.Size = new System.Drawing.Size(56, 20);
            this.udTestGenHzSec.TabIndex = 87;
            this.toolTip1.SetToolTip(this.udTestGenHzSec, "See the Sweep Button to the right.");
            this.udTestGenHzSec.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTestGenHzSec.LostFocus += new System.EventHandler(this.udTestGenHzSec_LostFocus);
            // 
            // lblTestGenHigh
            // 
            this.lblTestGenHigh.Image = null;
            this.lblTestGenHigh.Location = new System.Drawing.Point(104, 160);
            this.lblTestGenHigh.Name = "lblTestGenHigh";
            this.lblTestGenHigh.Size = new System.Drawing.Size(32, 16);
            this.lblTestGenHigh.TabIndex = 86;
            this.lblTestGenHigh.Text = "High:";
            // 
            // udTestGenHigh
            // 
            this.udTestGenHigh.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTestGenHigh.Location = new System.Drawing.Point(136, 160);
            this.udTestGenHigh.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udTestGenHigh.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTestGenHigh.Name = "udTestGenHigh";
            this.udTestGenHigh.Size = new System.Drawing.Size(56, 20);
            this.udTestGenHigh.TabIndex = 85;
            this.toolTip1.SetToolTip(this.udTestGenHigh, "See the Sweep Button to the right.");
            this.udTestGenHigh.Value = new decimal(new int[] {
            4000,
            0,
            0,
            0});
            this.udTestGenHigh.LostFocus += new System.EventHandler(this.udTestGenHigh_LostFocus);
            // 
            // lblTestGenLow
            // 
            this.lblTestGenLow.Image = null;
            this.lblTestGenLow.Location = new System.Drawing.Point(8, 160);
            this.lblTestGenLow.Name = "lblTestGenLow";
            this.lblTestGenLow.Size = new System.Drawing.Size(32, 16);
            this.lblTestGenLow.TabIndex = 84;
            this.lblTestGenLow.Text = "Low:";
            // 
            // udTestGenLow
            // 
            this.udTestGenLow.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTestGenLow.Location = new System.Drawing.Point(40, 160);
            this.udTestGenLow.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udTestGenLow.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTestGenLow.Name = "udTestGenLow";
            this.udTestGenLow.Size = new System.Drawing.Size(56, 20);
            this.udTestGenLow.TabIndex = 83;
            this.toolTip1.SetToolTip(this.udTestGenLow, "See the Sweep Button to the right.");
            this.udTestGenLow.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTestGenLow.LostFocus += new System.EventHandler(this.udTestGenLow_LostFocus);
            // 
            // btnTestGenSweep
            // 
            this.btnTestGenSweep.Image = null;
            this.btnTestGenSweep.Location = new System.Drawing.Point(336, 160);
            this.btnTestGenSweep.Name = "btnTestGenSweep";
            this.btnTestGenSweep.Size = new System.Drawing.Size(48, 23);
            this.btnTestGenSweep.TabIndex = 0;
            this.btnTestGenSweep.Text = "Sweep";
            this.toolTip1.SetToolTip(this.btnTestGenSweep, "Click this button to sweep from the Low setting to the High setting using the Hz/" +
        "Sec setting.");
            this.btnTestGenSweep.Click += new System.EventHandler(this.buttonTestGenSweep_Click);
            // 
            // ckEnableSigGen
            // 
            this.ckEnableSigGen.Image = null;
            this.ckEnableSigGen.Location = new System.Drawing.Point(8, 240);
            this.ckEnableSigGen.Name = "ckEnableSigGen";
            this.ckEnableSigGen.Size = new System.Drawing.Size(176, 40);
            this.ckEnableSigGen.TabIndex = 92;
            this.ckEnableSigGen.Text = "Enable HW Signal Generator";
            this.ckEnableSigGen.Visible = false;
            this.ckEnableSigGen.CheckedChanged += new System.EventHandler(this.ckEnableSigGen_CheckedChanged);
            // 
            // grpTestX2
            // 
            this.grpTestX2.Controls.Add(this.lblTestX2);
            this.grpTestX2.Controls.Add(this.chkTestX2Pin6);
            this.grpTestX2.Controls.Add(this.chkTestX2Pin5);
            this.grpTestX2.Controls.Add(this.chkTestX2Pin4);
            this.grpTestX2.Controls.Add(this.chkTestX2Pin3);
            this.grpTestX2.Controls.Add(this.chkTestX2Pin2);
            this.grpTestX2.Controls.Add(this.chkTestX2Pin1);
            this.grpTestX2.Location = new System.Drawing.Point(8, 160);
            this.grpTestX2.Name = "grpTestX2";
            this.grpTestX2.Size = new System.Drawing.Size(160, 72);
            this.grpTestX2.TabIndex = 87;
            this.grpTestX2.TabStop = false;
            this.grpTestX2.Text = "X2";
            // 
            // lblTestX2
            // 
            this.lblTestX2.Image = null;
            this.lblTestX2.Location = new System.Drawing.Point(16, 48);
            this.lblTestX2.Name = "lblTestX2";
            this.lblTestX2.Size = new System.Drawing.Size(136, 16);
            this.lblTestX2.TabIndex = 6;
            this.lblTestX2.Text = "1      2      3      4      5      6";
            // 
            // chkTestX2Pin6
            // 
            this.chkTestX2Pin6.Image = null;
            this.chkTestX2Pin6.Location = new System.Drawing.Point(136, 24);
            this.chkTestX2Pin6.Name = "chkTestX2Pin6";
            this.chkTestX2Pin6.Size = new System.Drawing.Size(16, 24);
            this.chkTestX2Pin6.TabIndex = 5;
            this.chkTestX2Pin6.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
            // 
            // chkTestX2Pin5
            // 
            this.chkTestX2Pin5.Image = null;
            this.chkTestX2Pin5.Location = new System.Drawing.Point(112, 24);
            this.chkTestX2Pin5.Name = "chkTestX2Pin5";
            this.chkTestX2Pin5.Size = new System.Drawing.Size(16, 24);
            this.chkTestX2Pin5.TabIndex = 4;
            this.chkTestX2Pin5.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
            // 
            // chkTestX2Pin4
            // 
            this.chkTestX2Pin4.Image = null;
            this.chkTestX2Pin4.Location = new System.Drawing.Point(88, 24);
            this.chkTestX2Pin4.Name = "chkTestX2Pin4";
            this.chkTestX2Pin4.Size = new System.Drawing.Size(16, 24);
            this.chkTestX2Pin4.TabIndex = 3;
            this.chkTestX2Pin4.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
            // 
            // chkTestX2Pin3
            // 
            this.chkTestX2Pin3.Image = null;
            this.chkTestX2Pin3.Location = new System.Drawing.Point(64, 24);
            this.chkTestX2Pin3.Name = "chkTestX2Pin3";
            this.chkTestX2Pin3.Size = new System.Drawing.Size(16, 24);
            this.chkTestX2Pin3.TabIndex = 2;
            this.chkTestX2Pin3.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
            // 
            // chkTestX2Pin2
            // 
            this.chkTestX2Pin2.Image = null;
            this.chkTestX2Pin2.Location = new System.Drawing.Point(40, 24);
            this.chkTestX2Pin2.Name = "chkTestX2Pin2";
            this.chkTestX2Pin2.Size = new System.Drawing.Size(16, 24);
            this.chkTestX2Pin2.TabIndex = 1;
            this.chkTestX2Pin2.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
            // 
            // chkTestX2Pin1
            // 
            this.chkTestX2Pin1.Image = null;
            this.chkTestX2Pin1.Location = new System.Drawing.Point(16, 24);
            this.chkTestX2Pin1.Name = "chkTestX2Pin1";
            this.chkTestX2Pin1.Size = new System.Drawing.Size(16, 24);
            this.chkTestX2Pin1.TabIndex = 0;
            this.chkTestX2Pin1.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
            // 
            // grpTestAudioBalance
            // 
            this.grpTestAudioBalance.Controls.Add(this.btnTestAudioBalStart);
            this.grpTestAudioBalance.Location = new System.Drawing.Point(344, 8);
            this.grpTestAudioBalance.Name = "grpTestAudioBalance";
            this.grpTestAudioBalance.Size = new System.Drawing.Size(120, 64);
            this.grpTestAudioBalance.TabIndex = 86;
            this.grpTestAudioBalance.TabStop = false;
            this.grpTestAudioBalance.Text = "Audio Balance Test";
            // 
            // btnTestAudioBalStart
            // 
            this.btnTestAudioBalStart.Image = null;
            this.btnTestAudioBalStart.Location = new System.Drawing.Point(24, 24);
            this.btnTestAudioBalStart.Name = "btnTestAudioBalStart";
            this.btnTestAudioBalStart.Size = new System.Drawing.Size(75, 23);
            this.btnTestAudioBalStart.TabIndex = 0;
            this.btnTestAudioBalStart.Text = "Start";
            this.btnTestAudioBalStart.Click += new System.EventHandler(this.btnTestAudioBalStart_Click);
            // 
            // grpTestTXIMD
            // 
            this.grpTestTXIMD.Controls.Add(this.lblTestToneFreq2);
            this.grpTestTXIMD.Controls.Add(this.udTestIMDFreq2);
            this.grpTestTXIMD.Controls.Add(this.lblTestIMDPower);
            this.grpTestTXIMD.Controls.Add(this.udTestIMDPower);
            this.grpTestTXIMD.Controls.Add(this.chekTestIMD);
            this.grpTestTXIMD.Controls.Add(this.lblTestToneFreq1);
            this.grpTestTXIMD.Controls.Add(this.udTestIMDFreq1);
            this.grpTestTXIMD.Location = new System.Drawing.Point(8, 8);
            this.grpTestTXIMD.Name = "grpTestTXIMD";
            this.grpTestTXIMD.Size = new System.Drawing.Size(152, 144);
            this.grpTestTXIMD.TabIndex = 83;
            this.grpTestTXIMD.TabStop = false;
            this.grpTestTXIMD.Text = "Two Tone Test";
            // 
            // lblTestToneFreq2
            // 
            this.lblTestToneFreq2.Image = null;
            this.lblTestToneFreq2.Location = new System.Drawing.Point(16, 48);
            this.lblTestToneFreq2.Name = "lblTestToneFreq2";
            this.lblTestToneFreq2.Size = new System.Drawing.Size(64, 16);
            this.lblTestToneFreq2.TabIndex = 88;
            this.lblTestToneFreq2.Text = "Freq #2:";
            // 
            // udTestIMDFreq2
            // 
            this.udTestIMDFreq2.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTestIMDFreq2.Location = new System.Drawing.Point(80, 48);
            this.udTestIMDFreq2.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udTestIMDFreq2.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTestIMDFreq2.Name = "udTestIMDFreq2";
            this.udTestIMDFreq2.Size = new System.Drawing.Size(56, 20);
            this.udTestIMDFreq2.TabIndex = 87;
            this.udTestIMDFreq2.Value = new decimal(new int[] {
            19000,
            0,
            0,
            65536});
            this.udTestIMDFreq2.LostFocus += new System.EventHandler(this.udTestIMDFreq2_LostFocus);
            // 
            // lblTestIMDPower
            // 
            this.lblTestIMDPower.Image = null;
            this.lblTestIMDPower.Location = new System.Drawing.Point(16, 72);
            this.lblTestIMDPower.Name = "lblTestIMDPower";
            this.lblTestIMDPower.Size = new System.Drawing.Size(64, 16);
            this.lblTestIMDPower.TabIndex = 86;
            this.lblTestIMDPower.Text = "Power:";
            // 
            // udTestIMDPower
            // 
            this.udTestIMDPower.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTestIMDPower.Location = new System.Drawing.Point(80, 72);
            this.udTestIMDPower.Maximum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udTestIMDPower.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTestIMDPower.Name = "udTestIMDPower";
            this.udTestIMDPower.Size = new System.Drawing.Size(56, 20);
            this.udTestIMDPower.TabIndex = 85;
            this.udTestIMDPower.Value = new decimal(new int[] {
            50,
            0,
            0,
            0});
            this.udTestIMDPower.LostFocus += new System.EventHandler(this.udTestIMDPower_LostFocus);
            // 
            // chekTestIMD
            // 
            this.chekTestIMD.Appearance = System.Windows.Forms.Appearance.Button;
            this.chekTestIMD.Image = null;
            this.chekTestIMD.Location = new System.Drawing.Point(48, 104);
            this.chekTestIMD.Name = "chekTestIMD";
            this.chekTestIMD.Size = new System.Drawing.Size(64, 24);
            this.chekTestIMD.TabIndex = 84;
            this.chekTestIMD.Text = "Start";
            this.chekTestIMD.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chekTestIMD.CheckedChanged += new System.EventHandler(this.chkTestIMD_CheckedChanged);
            // 
            // lblTestToneFreq1
            // 
            this.lblTestToneFreq1.Image = null;
            this.lblTestToneFreq1.Location = new System.Drawing.Point(16, 24);
            this.lblTestToneFreq1.Name = "lblTestToneFreq1";
            this.lblTestToneFreq1.Size = new System.Drawing.Size(64, 16);
            this.lblTestToneFreq1.TabIndex = 83;
            this.lblTestToneFreq1.Text = "Freq #1:";
            // 
            // udTestIMDFreq1
            // 
            this.udTestIMDFreq1.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udTestIMDFreq1.Location = new System.Drawing.Point(80, 24);
            this.udTestIMDFreq1.Maximum = new decimal(new int[] {
            20000,
            0,
            0,
            0});
            this.udTestIMDFreq1.Minimum = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.udTestIMDFreq1.Name = "udTestIMDFreq1";
            this.udTestIMDFreq1.Size = new System.Drawing.Size(56, 20);
            this.udTestIMDFreq1.TabIndex = 82;
            this.udTestIMDFreq1.Value = new decimal(new int[] {
            7000,
            0,
            0,
            65536});
            this.udTestIMDFreq1.LostFocus += new System.EventHandler(this.udTestIMDFreq1_LostFocus);
            // 
            // grpImpulseTest
            // 
            this.grpImpulseTest.Controls.Add(this.udImpulseNum);
            this.grpImpulseTest.Controls.Add(this.btnImpulse);
            this.grpImpulseTest.Location = new System.Drawing.Point(168, 8);
            this.grpImpulseTest.Name = "grpImpulseTest";
            this.grpImpulseTest.Size = new System.Drawing.Size(160, 64);
            this.grpImpulseTest.TabIndex = 91;
            this.grpImpulseTest.TabStop = false;
            this.grpImpulseTest.Text = "Impulse Test";
            // 
            // udImpulseNum
            // 
            this.udImpulseNum.Increment = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udImpulseNum.Location = new System.Drawing.Point(104, 24);
            this.udImpulseNum.Maximum = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udImpulseNum.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.udImpulseNum.Name = "udImpulseNum";
            this.udImpulseNum.Size = new System.Drawing.Size(40, 20);
            this.udImpulseNum.TabIndex = 92;
            this.udImpulseNum.Value = new decimal(new int[] {
            20,
            0,
            0,
            0});
            this.udImpulseNum.LostFocus += new System.EventHandler(this.udImpulseNum_LostFocus);
            // 
            // btnImpulse
            // 
            this.btnImpulse.Image = null;
            this.btnImpulse.Location = new System.Drawing.Point(16, 24);
            this.btnImpulse.Name = "btnImpulse";
            this.btnImpulse.Size = new System.Drawing.Size(75, 23);
            this.btnImpulse.TabIndex = 90;
            this.btnImpulse.Text = "Impulse";
            this.btnImpulse.Click += new System.EventHandler(this.btnImpulse_Click);
            // 
            // openFileDialog1
            // 
            this.openFileDialog1.FileOk += new System.ComponentModel.CancelEventHandler(this.openFileDialog1_FileOk);
            // 
            // toolTip1
            // 
            this.toolTip1.AutomaticDelay = 200;
            this.toolTip1.AutoPopDelay = 15000;
            this.toolTip1.InitialDelay = 500;
            this.toolTip1.ReshowDelay = 40;
            // 
            // buttonExit
            // 
            this.buttonExit.Image = null;
            this.buttonExit.Location = new System.Drawing.Point(4, 414);
            this.buttonExit.Name = "buttonExit";
            this.buttonExit.Size = new System.Drawing.Size(96, 23);
            this.buttonExit.TabIndex = 60;
            this.buttonExit.Text = "Console EXIT";
            this.toolTip1.SetToolTip(this.buttonExit, "Click to EXIT PowerSDR \r\n\r\nNote: It will take approx 5 seconds to close");
            this.buttonExit.Click += new System.EventHandler(this.buttonExit_Click);
            // 
            // buttonTS1
            // 
            this.buttonTS1.Image = null;
            this.buttonTS1.Location = new System.Drawing.Point(106, 414);
            this.buttonTS1.Name = "buttonTS1";
            this.buttonTS1.Size = new System.Drawing.Size(112, 23);
            this.buttonTS1.TabIndex = 23;
            this.buttonTS1.Text = "Check for Updates";
            this.toolTip1.SetToolTip(this.buttonTS1, "Check for Software updates to ke9ns PowerSDR");
            this.buttonTS1.Click += new System.EventHandler(this.buttonTS1_Click);
            // 
            // btnExportDB
            // 
            this.btnExportDB.Image = null;
            this.btnExportDB.Location = new System.Drawing.Point(224, 385);
            this.btnExportDB.Name = "btnExportDB";
            this.btnExportDB.Size = new System.Drawing.Size(112, 23);
            this.btnExportDB.TabIndex = 22;
            this.btnExportDB.Text = "Export Database...";
            this.toolTip1.SetToolTip(this.btnExportDB, "Copy the saved PowerSDR Database to the folder location of your choice.");
            this.btnExportDB.Click += new System.EventHandler(this.btnExportDB_Click);
            // 
            // btnImportDB
            // 
            this.btnImportDB.Image = null;
            this.btnImportDB.Location = new System.Drawing.Point(106, 385);
            this.btnImportDB.Name = "btnImportDB";
            this.btnImportDB.Size = new System.Drawing.Size(112, 23);
            this.btnImportDB.TabIndex = 21;
            this.btnImportDB.Text = "Import Database...";
            this.toolTip1.SetToolTip(this.btnImportDB, "Replace the current PowerSDR database with a previously exported database.");
            this.btnImportDB.Click += new System.EventHandler(this.btnImportDB_Click);
            // 
            // btnApply
            // 
            this.btnApply.Image = null;
            this.btnApply.Location = new System.Drawing.Point(522, 385);
            this.btnApply.Name = "btnApply";
            this.btnApply.Size = new System.Drawing.Size(75, 23);
            this.btnApply.TabIndex = 19;
            this.btnApply.Text = "Apply";
            this.toolTip1.SetToolTip(this.btnApply, "Save current settings to the database.");
            this.btnApply.Click += new System.EventHandler(this.btnApply_Click);
            // 
            // btnCancel
            // 
            this.btnCancel.Image = null;
            this.btnCancel.Location = new System.Drawing.Point(438, 385);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 18;
            this.btnCancel.Text = "Cancel";
            this.toolTip1.SetToolTip(this.btnCancel, "Load settings from database and close form.");
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(357, 384);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 17;
            this.btnOK.Text = "OK";
            this.toolTip1.SetToolTip(this.btnOK, "Keep current settings and close form.");
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // timer_sweep
            // 
            this.timer_sweep.Tick += new System.EventHandler(this.timer_sweep_Tick);
            // 
            // saveFileDialog1
            // 
            this.saveFileDialog1.Filter = "PowerSDR Database Files (*.xml)|*.xml|All files|*.*";
            this.saveFileDialog1.InitialDirectory = "Environment.GetFolderPath(Environment.SpecialFolder.Desktop)";
            this.saveFileDialog1.FileOk += new System.ComponentModel.CancelEventHandler(this.saveFileDialog1_FileOk);
            // 
            // textBoxSAVE
            // 
            this.textBoxSAVE.Location = new System.Drawing.Point(333, 417);
            this.textBoxSAVE.MaxLength = 50;
            this.textBoxSAVE.Name = "textBoxSAVE";
            this.textBoxSAVE.Size = new System.Drawing.Size(263, 20);
            this.textBoxSAVE.TabIndex = 30;
            // 
            // btnResetDB
            // 
            this.btnResetDB.Image = null;
            this.btnResetDB.Location = new System.Drawing.Point(4, 385);
            this.btnResetDB.Name = "btnResetDB";
            this.btnResetDB.Size = new System.Drawing.Size(96, 23);
            this.btnResetDB.TabIndex = 20;
            this.btnResetDB.Text = "Factory Defaults";
            this.btnResetDB.Click += new System.EventHandler(this.btnResetDB_Click);
            // 
            // chkAlwaysOnTop1
            // 
            this.chkAlwaysOnTop1.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
            this.chkAlwaysOnTop1.Image = null;
            this.chkAlwaysOnTop1.Location = new System.Drawing.Point(224, 413);
            this.chkAlwaysOnTop1.Name = "chkAlwaysOnTop1";
            this.chkAlwaysOnTop1.Size = new System.Drawing.Size(103, 24);
            this.chkAlwaysOnTop1.TabIndex = 59;
            this.chkAlwaysOnTop1.Text = "Always On Top";
            this.chkAlwaysOnTop1.CheckedChanged += new System.EventHandler(this.ChkAlwaysOnTop1_CheckedChanged);
            // 
            // Setup
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(606, 448);
            this.Controls.Add(this.buttonExit);
            this.Controls.Add(this.textBoxSAVE);
            this.Controls.Add(this.buttonTS1);
            this.Controls.Add(this.btnExportDB);
            this.Controls.Add(this.btnImportDB);
            this.Controls.Add(this.btnResetDB);
            this.Controls.Add(this.btnApply);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.tcSetup);
            this.Controls.Add(this.chkAlwaysOnTop1);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.KeyPreview = true;
            this.MaximumSize = new System.Drawing.Size(622, 487);
            this.Menu = this.mainMenu1;
            this.MinimumSize = new System.Drawing.Size(622, 487);
            this.Name = "Setup";
            this.Text = "PowerSDR Setup";
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Setup_Closing);
            this.Deactivate += new System.EventHandler(this.Setup_Deactivate);
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.Setup_KeyDown);
            this.MouseEnter += new System.EventHandler(this.Setup_MouseEnter);
            this.tcSetup.ResumeLayout(false);
            this.tpGeneral.ResumeLayout(false);
            this.tcGeneral.ResumeLayout(false);
            this.tpGeneralHardware.ResumeLayout(false);
            this.tpGeneralHardware.PerformLayout();
            this.grpGeneralHardwareFLEX5000.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udF3KFanTempThresh)).EndInit();
            this.grpGeneralHardwareSDR1000.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralLPTDelay)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPTTHT)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTOT)).EndInit();
            this.grpHWSoftRock.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udSoftRockCenterFreq)).EndInit();
            this.grpGeneralDDS.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDDSCorrection)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDDSIFFreq)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDDSPLLMult)).EndInit();
            this.grpGeneralModel.ResumeLayout(false);
            this.grpGeneralHardwareFLEX1500.ResumeLayout(false);
            this.tpGeneralOptions.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udPwrMstrCOM)).EndInit();
            this.grpOptUSBBuf.ResumeLayout(false);
            this.grpOptUSBBuf.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.tbOptUSBBuf)).EndInit();
            this.grpGenCustomTitleText.ResumeLayout(false);
            this.grpGenCustomTitleText.PerformLayout();
            this.grpOptMisc.ResumeLayout(false);
            this.grpOptQuickQSY.ResumeLayout(false);
            this.grpGenAutoMute.ResumeLayout(false);
            this.grpGenTuningOptions.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udOptClickTuneOffsetDIGU)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udOptClickTuneOffsetDIGL)).EndInit();
            this.grpGeneralOptions.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udGenTX1Delay)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralX2Delay)).EndInit();
            this.grpGeneralProcessPriority.ResumeLayout(false);
            this.tpGeneralCalibration.ResumeLayout(false);
            this.grpGenCalRXImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralCalFreq3)).EndInit();
            this.grpGenCalLevel.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralCalLevel)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralCalFreq2)).EndInit();
            this.grpGeneralCalibration.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udGeneralCalFreq1)).EndInit();
            this.tpFilters.ResumeLayout(false);
            this.grpOptFilterControls.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udFilterDefaultLowCut)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udOptMaxFilterShift)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udOptMaxFilterWidth)).EndInit();
            this.tpRX2.ResumeLayout(false);
            this.tpGeneralNavigation.ResumeLayout(false);
            this.grpOptSpaceNav.ResumeLayout(false);
            this.grpOptSpaceNav.PerformLayout();
            this.tpUserInterface.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.groupBox2.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udN1MMfps)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udN1MMscale)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udN1MMport)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udHttpRefresh)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udHttpPort)).EndInit();
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this.groupBoxTS1.ResumeLayout(false);
            this.groupBoxTS1.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udSpeedPM)).EndInit();
            this.tpAudio.ResumeLayout(false);
            this.tcAudio.ResumeLayout(false);
            this.tpAudioCard1.ResumeLayout(false);
            this.tpAudioCard1.PerformLayout();
            this.groupBoxTS7.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udIQCorrection)).EndInit();
            this.groupBoxTS8.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udIQCorrection_TX)).EndInit();
            this.grpAudioChannels.ResumeLayout(false);
            this.grpAudioMicInGain1.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udAudioMicGain1)).EndInit();
            this.grpAudioLineInGain1.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udAudioLineIn1)).EndInit();
            this.grpAudioVolts1.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udAudioVoltage1)).EndInit();
            this.grpAudioDetails1.ResumeLayout(false);
            this.grpAudioLatency1.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udAudioLatency1)).EndInit();
            this.grpAudioCard.ResumeLayout(false);
            this.grpAudioBufferSize1.ResumeLayout(false);
            this.grpAudioSampleRate1.ResumeLayout(false);
            this.tpVAC.ResumeLayout(false);
            this.tpVAC.PerformLayout();
            this.groupBoxTS6.ResumeLayout(false);
            this.grpDirectIQOutput.ResumeLayout(false);
            this.grpAudioVACAutoEnable.ResumeLayout(false);
            this.grpAudioVACGain.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udAudioVACGainTX)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udAudioVACGainRX)).EndInit();
            this.grpAudio2Stereo.ResumeLayout(false);
            this.grpAudioLatency2.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udAudioLatency2)).EndInit();
            this.grpAudioSampleRate2.ResumeLayout(false);
            this.grpAudioBuffer2.ResumeLayout(false);
            this.grpAudioDetails2.ResumeLayout(false);
            this.tpVAC2.ResumeLayout(false);
            this.grpVAC2DirectIQ.ResumeLayout(false);
            this.grpVAC2AutoEnable.ResumeLayout(false);
            this.grpVAC2Gain.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udVAC2GainTX)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udVAC2GainRX)).EndInit();
            this.grpAudioStereo3.ResumeLayout(false);
            this.grpVAC2Latency.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udVAC2Latency)).EndInit();
            this.grpAudioSampleRate3.ResumeLayout(false);
            this.grpAudioBuffer3.ResumeLayout(false);
            this.grpAudioDetails3.ResumeLayout(false);
            this.tpDisplay.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.tbAGCTadj)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbWaterOffset)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbGridOffset)).EndInit();
            this.grpDisplayMultimeter.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udSS2H)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udSS1H)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udSS1)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udSS2)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udMeterDigitalDelay)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayMeterAvg)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayMultiTextHoldTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayMultiPeakHoldTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayMeterDelay)).EndInit();
            this.grpDisplayDriverEngine.ResumeLayout(false);
            this.grpDisplayScopeMode.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayScopeTime)).EndInit();
            this.grpDisplayWaterfall.ResumeLayout(false);
            this.grpDisplayWaterfall.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallMicLevel)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallRX2Level)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallUpdatePeriod)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallAvgTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallLowLevel)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallHighLevel)).EndInit();
            this.grpDisplayRefreshRates.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayCPUMeter)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayPeakText)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayFPS)).EndInit();
            this.grpDisplayAverage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayAVGTime)).EndInit();
            this.grpDisplayPhase.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayPhasePts)).EndInit();
            this.grpDisplaySpectrumGrid.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayGridStep)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayGridMin)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayGridMax)).EndInit();
            this.tpDSP.ResumeLayout(false);
            this.tcDSP.ResumeLayout(false);
            this.tpDSPOptions.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTNFWidth)).EndInit();
            this.grpDSPBufferSize.ResumeLayout(false);
            this.grpDSPBufDig.ResumeLayout(false);
            this.grpDSPBufCW.ResumeLayout(false);
            this.grpDSPBufPhone.ResumeLayout(false);
            this.grpDSPNB.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDSPDLY)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPNB)).EndInit();
            this.grpDSPLMSNR.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udLMSNRLeak)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSNRgain)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSNRtaps)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSNRdelay)).EndInit();
            this.grpDSPLMSANF.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udLMSANFLeak)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSANFgain)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSANFdelay)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udLMSANFtaps)).EndInit();
            this.grpDSPWindow.ResumeLayout(false);
            this.grpDSPNB2.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDSPNB2)).EndInit();
            this.tpDSPImageReject.ResumeLayout(false);
            this.grpDSPImageRejectTX.ResumeLayout(false);
            this.grpDSPImageRejectTX.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPImageGainTX)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPImagePhaseTX)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPImagePhaseTX)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPImageGainTX)).EndInit();
            this.tpDSPKeyer.ResumeLayout(false);
            this.grpKeyerConnections.ResumeLayout(false);
            this.grpDSPCWPitch.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDSPCWPitch)).EndInit();
            this.grpDSPKeyerOptions.ResumeLayout(false);
            this.grpDSPKeyerSignalShaping.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udCWKeyerWeight)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udCWKeyerRamp)).EndInit();
            this.grpDSPKeyerSemiBreakIn.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udCWBreakInDelay)).EndInit();
            this.tpDSPAGCALC.ResumeLayout(false);
            this.grpDSPLeveler.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerHangTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerThreshold)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerSlope)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerDecay)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPLevelerAttack)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPLevelerHangThreshold)).EndInit();
            this.grpDSPALC.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPALCHangThreshold)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCHangTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCThreshold)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCSlope)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCDecay)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPALCAttack)).EndInit();
            this.grpDSPAGC.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.tbDSPAGCHangThreshold)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCHangTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCMaxGaindB)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCSlope)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCDecay)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCAttack)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDSPAGCFixedGaindB)).EndInit();
            this.tpTransmit.ResumeLayout(false);
            this.grpTXVOX.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTXVOXHangTime)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXVOXThreshold)).EndInit();
            this.grpTXProfileDef.ResumeLayout(false);
            this.grpTXAM.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTXAMCarrierLevel)).EndInit();
            this.grpTXMonitor.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTXAF)).EndInit();
            this.grpTXNoiseGate.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTXNoiseGateAttenuate)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXNoiseGate)).EndInit();
            this.grpTXProfile.ResumeLayout(false);
            this.grpPATune.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.tbPulseRate1)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbDutyCycle)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXTunePower)).EndInit();
            this.grpTXFilter.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTXDriveMax)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXFilterLow)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTXFilterHigh)).EndInit();
            this.grpTX1500.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTX1500PhoneBlanking)).EndInit();
            this.tpPowerAmplifier.ResumeLayout(false);
            this.grpPABandOffset.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC17)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC15)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC20)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC12)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC10)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC160)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC80)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC60)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC40)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAADC30)).EndInit();
            this.grpPAGainByBand.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udPACalPower)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain10)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain12)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain15)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain17)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain20)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain30)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain40)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain60)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain80)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPAGain160)).EndInit();
            this.tpAppearance.ResumeLayout(false);
            this.tcAppearance.ResumeLayout(false);
            this.tpAppearanceGeneral.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.number3DY)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.number3DX)).EndInit();
            this.groupBoxTS3.ResumeLayout(false);
            this.grpAppSkins.ResumeLayout(false);
            this.grpAppearanceBand.ResumeLayout(false);
            this.grpAppearanceVFO.ResumeLayout(false);
            this.tpAppearanceDisplay.ResumeLayout(false);
            this.grpMainDisplay.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.tbPan3DAlpha)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbPanGrid)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udDisplayLineWidth)).EndInit();
            this.grpAppPanadapter.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.tbMapBright)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbPanAlpha)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbGrayLineBright)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udBandSegmentBoxLineWidth)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbMultiRXFilterAlpha)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tbRX1FilterAlpha)).EndInit();
            this.grpDisplayPeakCursor.ResumeLayout(false);
            this.tpAppearanceMeter.ResumeLayout(false);
            this.grpMeterEdge.ResumeLayout(false);
            this.grpAppearanceMeter.ResumeLayout(false);
            this.tpKeyboard.ResumeLayout(false);
            this.groupBoxTS5.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udQuindarTonesVol)).EndInit();
            this.groupBoxTS2.ResumeLayout(false);
            this.grpKBXIT.ResumeLayout(false);
            this.grpKBRIT.ResumeLayout(false);
            this.grpKBMode.ResumeLayout(false);
            this.grpKBBand.ResumeLayout(false);
            this.grpKBTune.ResumeLayout(false);
            this.grpKBFilter.ResumeLayout(false);
            this.grpKBCW.ResumeLayout(false);
            this.tpExtCtrl.ResumeLayout(false);
            this.grpExtTX.ResumeLayout(false);
            this.grpExtRX.ResumeLayout(false);
            this.tpCAT.ResumeLayout(false);
            this.groupBoxTS4.ResumeLayout(false);
            this.groupBoxTS4.PerformLayout();
            this.grpPTTBitBang.ResumeLayout(false);
            this.grpCatControlBox.ResumeLayout(false);
            this.grpCatControlBox.PerformLayout();
            this.grpRTTYOffset.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udRTTYU)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udRTTYL)).EndInit();
            this.tpTests.ResumeLayout(false);
            this.grpBoxTS1.ResumeLayout(false);
            this.grpBoxTS1.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udPulsePeriod)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udPulseDuty)).EndInit();
            this.grpSigGenTransmit.ResumeLayout(false);
            this.grpSigGenReceive.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTestGenScale)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tkbarTestGenFreq)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestGenHzSec)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestGenHigh)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestGenLow)).EndInit();
            this.grpTestX2.ResumeLayout(false);
            this.grpTestAudioBalance.ResumeLayout(false);
            this.grpTestTXIMD.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udTestIMDFreq2)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestIMDPower)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.udTestIMDFreq1)).EndInit();
            this.grpImpulseTest.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udImpulseNum)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

       

        public System.Windows.Forms.TabPage tpDSP;
        private System.Windows.Forms.TabPage tpDisplay;
        public System.Windows.Forms.NumericUpDownTS udDisplayGridStep;
        public System.Windows.Forms.NumericUpDownTS udDisplayGridMin;
        public System.Windows.Forms.NumericUpDownTS udDisplayGridMax;
        private System.Windows.Forms.LabelTS lblDisplayGridStep;
        private System.Windows.Forms.LabelTS lblDisplayGridMin;
        private System.Windows.Forms.LabelTS lblDisplayGridMax;
        public System.Windows.Forms.TabPage tpGeneral;
        private System.Windows.Forms.ComboBoxTS comboGeneralLPTAddr;
        private System.Windows.Forms.GroupBoxTS grpDisplaySpectrumGrid;
        private System.Windows.Forms.ButtonTS btnOK;
        private System.Windows.Forms.ButtonTS btnCancel;
        public System.Windows.Forms.ButtonTS btnApply;
        public System.Windows.Forms.CheckBoxTS chkGeneralSpurRed;
        private System.Windows.Forms.LabelTS lblGeneralLPTAddr;
        private System.Windows.Forms.NumericUpDownTS udGeneralLPTDelay;
        private System.Windows.Forms.LabelTS lblGeneralLPTDelay;
        public System.Windows.Forms.TabControl tcSetup;
        private System.Windows.Forms.TabPage tpKeyboard;
        private System.Windows.Forms.LabelTS lblKBTuneDown;
        private System.Windows.Forms.LabelTS lblKBTuneUp;
        private System.Windows.Forms.ComboBoxTS comboKBTuneDown1;
        private System.Windows.Forms.ComboBoxTS comboKBTuneDown3;
        private System.Windows.Forms.ComboBoxTS comboKBTuneDown2;
        private System.Windows.Forms.ComboBoxTS comboKBTuneUp1;
        private System.Windows.Forms.ComboBoxTS comboKBTuneUp2;
        private System.Windows.Forms.ComboBoxTS comboKBTuneUp3;
        private System.Windows.Forms.ComboBoxTS comboKBTuneUp4;
        private System.Windows.Forms.ComboBoxTS comboKBTuneDown4;
        private System.Windows.Forms.ComboBoxTS comboKBTuneUp5;
        private System.Windows.Forms.ComboBoxTS comboKBTuneDown5;
        private System.Windows.Forms.ComboBoxTS comboKBTuneDown6;
        private System.Windows.Forms.ComboBoxTS comboKBTuneUp7;
        private System.Windows.Forms.ComboBoxTS comboKBTuneDown7;
        private System.Windows.Forms.ComboBoxTS comboKBTuneUp6;
        private System.Windows.Forms.GroupBoxTS grpKBTune;
		private System.Windows.Forms.GroupBoxTS groupBoxTS7; //US1GHQ
		private System.Windows.Forms.GroupBoxTS groupBoxTS8; //US1GHQ
		private System.Windows.Forms.NumericUpDownTS udIQCorrection; //US1GHQ
		private System.Windows.Forms.NumericUpDownTS udIQCorrection_TX; //US1GHQ
		private System.Windows.Forms.CheckBoxTS checkBoxTS5; //US1GHQ
		private System.Windows.Forms.CheckBoxTS chkExtended; //US1GHQ
		private System.Windows.Forms.CheckBoxTS chkRXIQswap; //US1GHQ
		private System.Windows.Forms.CheckBoxTS chkTXIQswap; //US1GHQ
        private System.Windows.Forms.LabelTS lblKBTuneDigit;
        private System.Windows.Forms.LabelTS lblKBTune7;
        private System.Windows.Forms.LabelTS lblKBTune6;
        private System.Windows.Forms.LabelTS lblKBTune5;
        private System.Windows.Forms.LabelTS lblKBTune4;
        private System.Windows.Forms.LabelTS lblKBTune3;
        private System.Windows.Forms.LabelTS lblKBTune2;
        private System.Windows.Forms.LabelTS lblKBTune1;
        private System.Windows.Forms.GroupBoxTS grpKBBand;
        private System.Windows.Forms.LabelTS lblKBBandUp;
        private System.Windows.Forms.LabelTS lblKBBandDown;
        private System.Windows.Forms.GroupBoxTS grpKBFilter;
        private System.Windows.Forms.LabelTS lblKBFilterUp;
        private System.Windows.Forms.LabelTS lblKBFilterDown;
        private System.Windows.Forms.GroupBoxTS grpKBMode;
        private System.Windows.Forms.LabelTS lblKBModeUp;
        private System.Windows.Forms.LabelTS lblKBModeDown;
        private System.Windows.Forms.ComboBoxTS comboKBBandUp;
        private System.Windows.Forms.ComboBoxTS comboKBBandDown;
        private System.Windows.Forms.ComboBoxTS comboKBFilterUp;
        private System.Windows.Forms.ComboBoxTS comboKBFilterDown;
        private System.Windows.Forms.ComboBoxTS comboKBModeUp;
        private System.Windows.Forms.ComboBoxTS comboKBModeDown;
        private System.Windows.Forms.LabelTS lblDisplayFPS;
        public System.Windows.Forms.NumericUpDownTS udDisplayFPS;
        private System.Windows.Forms.CheckBoxTS chkGeneralXVTRPresent;
        private System.Windows.Forms.GroupBoxTS grpGeneralDDS;
        private System.Windows.Forms.LabelTS lblPLLMult;
        private System.Windows.Forms.NumericUpDownTS udDDSPLLMult;
        private System.Windows.Forms.LabelTS lblIFFrequency;
        private System.Windows.Forms.NumericUpDownTS udDDSIFFreq;
        private System.Windows.Forms.LabelTS lblClockCorrection;
        private System.Windows.Forms.NumericUpDownTS udDDSCorrection;
        public System.Windows.Forms.TabPage tpAudio;
        public System.Windows.Forms.TabPage tpTransmit;
        public System.Windows.Forms.NumericUpDownTS udTXFilterHigh;
        private System.Windows.Forms.LabelTS lblTXFilterLow;
        private System.Windows.Forms.LabelTS lblTXFilterHigh;
        public System.Windows.Forms.NumericUpDownTS udTXFilterLow;
        private System.Windows.Forms.GroupBoxTS grpTXFilter;
        private System.Windows.Forms.GroupBoxTS grpDisplayPhase;
        private System.Windows.Forms.NumericUpDownTS udDisplayPhasePts;
        private System.Windows.Forms.GroupBoxTS grpDisplayAverage;
        private System.Windows.Forms.LabelTS lblDisplayPhasePts;
        private System.Windows.Forms.GroupBoxTS grpGeneralCalibration;
        private System.Windows.Forms.LabelTS lblGeneralCalFrequency;
        private System.Windows.Forms.LabelTS lblGeneralCalLevel;
        private System.Windows.Forms.NumericUpDownTS udGeneralCalLevel;
        private System.Windows.Forms.GroupBoxTS grpDisplayRefreshRates;
        private System.Windows.Forms.LabelTS lblDisplayMeterDelay;
        private System.Windows.Forms.NumericUpDownTS udDisplayMeterDelay;
        private System.Windows.Forms.TabPage tpAppearance;
        private System.Windows.Forms.LabelTS lblDisplayFilterColor;
        private System.Windows.Forms.LabelTS lblDisplayLineWidth;
        private System.Windows.Forms.NumericUpDownTS udDisplayLineWidth;
        private System.Windows.Forms.LabelTS lblDisplayDataLineColor;
        private System.Windows.Forms.LabelTS lblDisplayTextColor;
        private System.Windows.Forms.LabelTS lblDisplayZeroLineColor;
        private System.Windows.Forms.LabelTS lblDisplayGridColor;
        private System.Windows.Forms.LabelTS lblDisplayBackgroundColor;
        private System.Windows.Forms.GroupBoxTS grpAppearanceMeter;
        private System.Windows.Forms.LabelTS lblAppearanceMeterRight;
        private System.Windows.Forms.LabelTS lblAppearanceMeterLeft;
        private System.Windows.Forms.LabelTS lblAppearanceGenBtnSel;
        private System.Windows.Forms.GroupBoxTS grpGeneralOptions;
        private System.Windows.Forms.CheckBoxTS chkGeneralDisablePTT;
        private System.Windows.Forms.LabelTS lblDisplayPeakText;
        private System.Windows.Forms.NumericUpDownTS udDisplayPeakText;
        private System.Windows.Forms.NumericUpDownTS udDisplayCPUMeter;
        private System.Windows.Forms.LabelTS lblDisplayCPUMeter;
        private System.Windows.Forms.ComboBoxTS comboGeneralXVTR;
        public System.Windows.Forms.GroupBoxTS grpDisplayWaterfall;
        private System.Windows.Forms.NumericUpDownTS udDisplayWaterfallHighLevel;
        private System.Windows.Forms.LabelTS lblDisplayWaterfallHighLevel;
        private System.Windows.Forms.LabelTS lblDisplayWaterfallLowLevel;
        public System.Windows.Forms.NumericUpDownTS udDisplayWaterfallLowLevel;
        private System.Windows.Forms.LabelTS lblDisplayWaterfallLowColor;
        private System.Windows.Forms.CheckBoxTS chkGeneralPAPresent;
        private System.Windows.Forms.ButtonTS btnGeneralCalLevelStart;
        private System.Windows.Forms.ButtonTS btnGeneralCalFreqStart;
        private System.Windows.Forms.ButtonTS btnGeneralCalFreqUseVFOA;
        private System.Windows.Forms.ButtonTS btnGeneralCalImageStart;
        private System.Windows.Forms.CheckBoxTS chkGeneralSoftwareGainCorr;
        private System.Windows.Forms.LabelTS lblBandLight;
        private System.Windows.Forms.LabelTS lblBandDark;
        private System.Windows.Forms.LabelTS lblPeakText;
        private System.Windows.Forms.ButtonTS btnWizard;
        private System.Windows.Forms.ButtonTS btnImportDB;
        private System.Windows.Forms.OpenFileDialog openFileDialog1;
        private System.Windows.Forms.TabPage tpTests;
        private System.Windows.Forms.LabelTS lblPAGainByBand160;
        private System.Windows.Forms.LabelTS lblPAGainByBand80;
        private System.Windows.Forms.LabelTS lblPAGainByBand60;
        private System.Windows.Forms.LabelTS lblPAGainByBand40;
        private System.Windows.Forms.LabelTS lblPAGainByBand30;
        private System.Windows.Forms.LabelTS lblPAGainByBand10;
        private System.Windows.Forms.LabelTS lblPAGainByBand12;
        private System.Windows.Forms.LabelTS lblPAGainByBand15;
        private System.Windows.Forms.LabelTS lblPAGainByBand17;
        private System.Windows.Forms.LabelTS lblPAGainByBand20;
        private System.Windows.Forms.TabPage tpPowerAmplifier;
        private System.Windows.Forms.ToolTip toolTip1;
        private System.Windows.Forms.NumericUpDownTS udPAGain10;
        private System.Windows.Forms.NumericUpDownTS udPAGain12;
        private System.Windows.Forms.NumericUpDownTS udPAGain15;
        private System.Windows.Forms.NumericUpDownTS udPAGain17;
        private System.Windows.Forms.NumericUpDownTS udPAGain20;
        private System.Windows.Forms.NumericUpDownTS udPAGain30;
        private System.Windows.Forms.NumericUpDownTS udPAGain40;
        private System.Windows.Forms.NumericUpDownTS udPAGain60;
        private System.Windows.Forms.NumericUpDownTS udPAGain80;
        private System.Windows.Forms.NumericUpDownTS udPAGain160;
        private System.Windows.Forms.GroupBoxTS grpPAGainByBand;
        private System.Windows.Forms.ButtonTS btnPAGainCalibration;
        private System.Windows.Forms.CheckBoxTS chkGeneralEnableX2;
        private System.Windows.Forms.LabelTS lblGeneralX2Delay;
        private System.Windows.Forms.NumericUpDownTS udGeneralX2Delay;
        private System.Windows.Forms.GroupBoxTS grpPABandOffset;
        private System.Windows.Forms.LabelTS lblPABandOffset30;
        private System.Windows.Forms.LabelTS lblPABandOffset40;
        private System.Windows.Forms.LabelTS lblPABandOffset60;
        private System.Windows.Forms.LabelTS lblPABandOffset80;
        private System.Windows.Forms.LabelTS lblPABandOffset160;
        private System.Windows.Forms.LabelTS lblPABandOffset10;
        private System.Windows.Forms.LabelTS lblPABandOffset12;
        private System.Windows.Forms.LabelTS lblPABandOffset15;
        private System.Windows.Forms.LabelTS lblPABandOffset17;
        private System.Windows.Forms.LabelTS lblPABandOffset20;
        private System.Windows.Forms.CheckBoxTS chkGeneralATUPresent;
        private System.Windows.Forms.ButtonTS btnPAGainReset;
        private System.Windows.Forms.ComboBoxTS comboGeneralProcessPriority;
        private System.Windows.Forms.GroupBoxTS grpGeneralProcessPriority;
        private System.Windows.Forms.GroupBoxTS grpTestTXIMD;
        private PowerSDR.ColorButton clrbtnBtnSel;
        private PowerSDR.ColorButton clrbtnVFODark;
        private PowerSDR.ColorButton clrbtnVFOLight;
        private PowerSDR.ColorButton clrbtnBandDark;
        private PowerSDR.ColorButton clrbtnBandLight;
        private PowerSDR.ColorButton clrbtnPeakText;
        private PowerSDR.ColorButton clrbtnBackground;
        private PowerSDR.ColorButton clrbtnGrid;
        private PowerSDR.ColorButton clrbtnZeroLine;
        private PowerSDR.ColorButton clrbtnFilter;
        private PowerSDR.ColorButton clrbtnText;
        private PowerSDR.ColorButton clrbtnDataLine;
        private PowerSDR.ColorButton clrbtnMeterLeft;
        private PowerSDR.ColorButton clrbtnMeterRight;
        private PowerSDR.ColorButton clrbtnWaterfallLow;
        private System.Windows.Forms.LabelTS lblTestIMDPower;
        private System.Windows.Forms.NumericUpDownTS udTestIMDPower;
        private System.Windows.Forms.CheckBoxTS chkGeneralCustomFilter;
        private System.Windows.Forms.NumericUpDownTS udTestIMDFreq1;
        private System.Windows.Forms.NumericUpDownTS udTestIMDFreq2;
        private System.Windows.Forms.ButtonTS btnTestAudioBalStart;
        private System.Windows.Forms.CheckBoxTS chkTestX2Pin1;
        private System.Windows.Forms.CheckBoxTS chkTestX2Pin2;
        private System.Windows.Forms.CheckBoxTS chkTestX2Pin3;
        private System.Windows.Forms.CheckBoxTS chkTestX2Pin4;
        private System.Windows.Forms.CheckBoxTS chkTestX2Pin5;
        private System.Windows.Forms.CheckBoxTS chkTestX2Pin6;
        private System.Windows.Forms.NumericUpDownTS udDisplayAVGTime;
        private System.Windows.Forms.LabelTS lblDisplayAVGTime;
        private System.Windows.Forms.GroupBoxTS grpTestX2;
        private System.Windows.Forms.GroupBoxTS grpTestAudioBalance;
        private System.Windows.Forms.NumericUpDownTS udPAADC17;
        private System.Windows.Forms.NumericUpDownTS udPAADC15;
        private System.Windows.Forms.NumericUpDownTS udPAADC20;
        private System.Windows.Forms.NumericUpDownTS udPAADC12;
        private System.Windows.Forms.NumericUpDownTS udPAADC10;
        private System.Windows.Forms.NumericUpDownTS udPAADC160;
        private System.Windows.Forms.NumericUpDownTS udPAADC80;
        private System.Windows.Forms.NumericUpDownTS udPAADC60;
        private System.Windows.Forms.NumericUpDownTS udPAADC40;
        private System.Windows.Forms.NumericUpDownTS udPAADC30;
        private System.Windows.Forms.CheckBoxTS chkGeneralUSBPresent;
        private System.Windows.Forms.GroupBoxTS grpPATune;
        public System.Windows.Forms.LabelTS lblTransmitTunePower;
        public System.Windows.Forms.NumericUpDownTS udTXTunePower;
        public System.Windows.Forms.GroupBoxTS grpDisplayMultimeter;
        private System.Windows.Forms.LabelTS lblDisplayMultiPeakHoldTime;
        private System.Windows.Forms.NumericUpDownTS udDisplayMultiPeakHoldTime;
        private System.Windows.Forms.NumericUpDownTS udDisplayMultiTextHoldTime;
        private System.Windows.Forms.LabelTS lblDisplayMeterTextHoldTime;
        private System.Windows.Forms.CheckBoxTS chkGeneralRXOnly;
        private System.Windows.Forms.LabelTS lblTestX2;
        private System.Windows.Forms.LabelTS lblTestToneFreq2;
        private System.Windows.Forms.LabelTS lblTestToneFreq1;
        private System.Windows.Forms.TabPage tpCAT;
        private System.Windows.Forms.GroupBoxTS grpPTTBitBang;
        private System.Windows.Forms.LabelTS lblCATPTTPort;
        private System.Windows.Forms.CheckBoxTS chkCATPTT_RTS;
        private System.Windows.Forms.CheckBoxTS chkCATPTT_DTR;
        private System.Windows.Forms.GroupBoxTS grpCatControlBox;
        private System.Windows.Forms.ComboBoxTS comboCATbaud;
        private System.Windows.Forms.LabelTS lblCATBaud;
        private System.Windows.Forms.CheckBoxTS chkCATEnable;
        private System.Windows.Forms.LabelTS lblCATParity;
        private System.Windows.Forms.LabelTS lblCATData;
        private System.Windows.Forms.LabelTS lblCATStop;
        private System.Windows.Forms.ComboBoxTS comboCATparity;
        private System.Windows.Forms.ComboBoxTS comboCATdatabits;
        private System.Windows.Forms.ComboBoxTS comboCATstopbits;
        private System.Windows.Forms.GroupBoxTS grpKBCW;
        private System.Windows.Forms.LabelTS lblKBCWDot;
        private System.Windows.Forms.LabelTS lblKBCWDash;
        private System.Windows.Forms.ComboBoxTS comboKBCWDot;
        private System.Windows.Forms.ComboBoxTS comboKBCWDash;
        private System.Windows.Forms.GroupBoxTS grpKBRIT;
        private System.Windows.Forms.LabelTS lblKBRitUp;
        private System.Windows.Forms.LabelTS lblKBRITDown;
        private System.Windows.Forms.ComboBoxTS comboKBRITUp;
        private System.Windows.Forms.ComboBoxTS comboKBRITDown;
        private System.Windows.Forms.GroupBoxTS grpKBXIT;
        private System.Windows.Forms.LabelTS lblKBXITUp;
        private System.Windows.Forms.LabelTS lblKBXITDown;
        private System.Windows.Forms.ComboBoxTS comboKBXITUp;
        private System.Windows.Forms.ComboBoxTS comboKBXITDown;
        private System.Windows.Forms.CheckBoxTS chkDCBlock;
        private System.Windows.Forms.TabPage tpExtCtrl;
        private System.Windows.Forms.GroupBoxTS grpExtTX;
        private System.Windows.Forms.LabelTS lblExtTXX25;
        private System.Windows.Forms.LabelTS lblExtTXX24;
        private System.Windows.Forms.LabelTS lblExtTXX23;
        private System.Windows.Forms.LabelTS lblExtTXX22;
        private System.Windows.Forms.LabelTS lblExtTX2;
        private System.Windows.Forms.LabelTS lblExtTX6;
        private System.Windows.Forms.LabelTS lblExtTX10;
        private System.Windows.Forms.LabelTS lblExtTX12;
        private System.Windows.Forms.LabelTS lblExtTX15;
        private System.Windows.Forms.LabelTS lblExtTX17;
        private System.Windows.Forms.LabelTS lblExtTX20;
        private System.Windows.Forms.LabelTS lblExtTX30;
        private System.Windows.Forms.LabelTS lblExtTX40;
        private System.Windows.Forms.LabelTS lblExtTX60;
        private System.Windows.Forms.LabelTS lblExtTX80;
        private System.Windows.Forms.LabelTS lblExtTXX2Pins;
        private System.Windows.Forms.LabelTS lblExtTXBand;
        private System.Windows.Forms.LabelTS lblExtTX160;
        private System.Windows.Forms.CheckBoxTS chkExtTX1603;
        private System.Windows.Forms.CheckBoxTS chkExtTX1602;
        private System.Windows.Forms.CheckBoxTS chkExtTX1601;
        private System.Windows.Forms.LabelTS lblExtTXX21;
        private System.Windows.Forms.CheckBoxTS chkExtTX1605;
        private System.Windows.Forms.CheckBoxTS chkExtTX1604;
        private System.Windows.Forms.GroupBoxTS grpExtRX;
        private System.Windows.Forms.LabelTS lblExtRXX25;
        private System.Windows.Forms.LabelTS lblExtRXX24;
        private System.Windows.Forms.LabelTS lblExtRXX23;
        private System.Windows.Forms.LabelTS lblExtRXX22;
        private System.Windows.Forms.LabelTS lblExtRX2;
        private System.Windows.Forms.LabelTS lblExtRX6;
        private System.Windows.Forms.LabelTS lblExtRX10;
        private System.Windows.Forms.LabelTS lblExtRX12;
        private System.Windows.Forms.LabelTS lblExtRX15;
        private System.Windows.Forms.LabelTS lblExtRX17;
        private System.Windows.Forms.LabelTS lblExtRX20;
        private System.Windows.Forms.LabelTS lblExtRX30;
        private System.Windows.Forms.LabelTS lblExtRX40;
        private System.Windows.Forms.LabelTS lblExtRX60;
        private System.Windows.Forms.LabelTS lblExtRX80;
        private System.Windows.Forms.LabelTS lblExtRXX2Pins;
        private System.Windows.Forms.LabelTS lblExtRXBand;
        private System.Windows.Forms.LabelTS lblExtRX160;
        private System.Windows.Forms.CheckBoxTS chkExtRX1603;
        private System.Windows.Forms.CheckBoxTS chkExtRX1602;
        private System.Windows.Forms.CheckBoxTS chkExtRX1601;
        private System.Windows.Forms.LabelTS lblExtRXX21;
        private System.Windows.Forms.CheckBoxTS chkExtRX1605;
        private System.Windows.Forms.CheckBoxTS chkExtRX1604;
        private System.Windows.Forms.CheckBoxTS chkExtTX23;
        private System.Windows.Forms.CheckBoxTS chkExtTX22;
        private System.Windows.Forms.CheckBoxTS chkExtTX21;
        private System.Windows.Forms.CheckBoxTS chkExtTX25;
        private System.Windows.Forms.CheckBoxTS chkExtTX24;
        private System.Windows.Forms.CheckBoxTS chkExtTX63;
        private System.Windows.Forms.CheckBoxTS chkExtTX62;
        private System.Windows.Forms.CheckBoxTS chkExtTX61;
        private System.Windows.Forms.CheckBoxTS chkExtTX65;
        private System.Windows.Forms.CheckBoxTS chkExtTX64;
        private System.Windows.Forms.CheckBoxTS chkExtTX103;
        private System.Windows.Forms.CheckBoxTS chkExtTX102;
        private System.Windows.Forms.CheckBoxTS chkExtTX101;
        private System.Windows.Forms.CheckBoxTS chkExtTX105;
        private System.Windows.Forms.CheckBoxTS chkExtTX104;
        private System.Windows.Forms.CheckBoxTS chkExtTX123;
        private System.Windows.Forms.CheckBoxTS chkExtTX122;
        private System.Windows.Forms.CheckBoxTS chkExtTX121;
        private System.Windows.Forms.CheckBoxTS chkExtTX125;
        private System.Windows.Forms.CheckBoxTS chkExtTX124;
        private System.Windows.Forms.CheckBoxTS chkExtTX153;
        private System.Windows.Forms.CheckBoxTS chkExtTX152;
        private System.Windows.Forms.CheckBoxTS chkExtTX151;
        private System.Windows.Forms.CheckBoxTS chkExtTX155;
        private System.Windows.Forms.CheckBoxTS chkExtTX154;
        private System.Windows.Forms.CheckBoxTS chkExtTX173;
        private System.Windows.Forms.CheckBoxTS chkExtTX172;
        private System.Windows.Forms.CheckBoxTS chkExtTX171;
        private System.Windows.Forms.CheckBoxTS chkExtTX175;
        private System.Windows.Forms.CheckBoxTS chkExtTX174;
        private System.Windows.Forms.CheckBoxTS chkExtTX203;
        private System.Windows.Forms.CheckBoxTS chkExtTX202;
        private System.Windows.Forms.CheckBoxTS chkExtTX201;
        private System.Windows.Forms.CheckBoxTS chkExtTX205;
        private System.Windows.Forms.CheckBoxTS chkExtTX204;
        private System.Windows.Forms.CheckBoxTS chkExtTX303;
        private System.Windows.Forms.CheckBoxTS chkExtTX302;
        private System.Windows.Forms.CheckBoxTS chkExtTX301;
        private System.Windows.Forms.CheckBoxTS chkExtTX305;
        private System.Windows.Forms.CheckBoxTS chkExtTX304;
        private System.Windows.Forms.CheckBoxTS chkExtTX403;
        private System.Windows.Forms.CheckBoxTS chkExtTX402;
        private System.Windows.Forms.CheckBoxTS chkExtTX401;
        private System.Windows.Forms.CheckBoxTS chkExtTX405;
        private System.Windows.Forms.CheckBoxTS chkExtTX404;
        private System.Windows.Forms.CheckBoxTS chkExtTX603;
        private System.Windows.Forms.CheckBoxTS chkExtTX602;
        private System.Windows.Forms.CheckBoxTS chkExtTX601;
        private System.Windows.Forms.CheckBoxTS chkExtTX605;
        private System.Windows.Forms.CheckBoxTS chkExtTX604;
        private System.Windows.Forms.CheckBoxTS chkExtTX803;
        private System.Windows.Forms.CheckBoxTS chkExtTX802;
        private System.Windows.Forms.CheckBoxTS chkExtTX801;
        private System.Windows.Forms.CheckBoxTS chkExtTX805;
        private System.Windows.Forms.CheckBoxTS chkExtTX804;
        private System.Windows.Forms.CheckBoxTS chkExtRX23;
        private System.Windows.Forms.CheckBoxTS chkExtRX22;
        private System.Windows.Forms.CheckBoxTS chkExtRX21;
        private System.Windows.Forms.CheckBoxTS chkExtRX25;
        private System.Windows.Forms.CheckBoxTS chkExtRX24;
        private System.Windows.Forms.CheckBoxTS chkExtRX63;
        private System.Windows.Forms.CheckBoxTS chkExtRX62;
        private System.Windows.Forms.CheckBoxTS chkExtRX61;
        private System.Windows.Forms.CheckBoxTS chkExtRX65;
        private System.Windows.Forms.CheckBoxTS chkExtRX64;
        private System.Windows.Forms.CheckBoxTS chkExtRX103;
        private System.Windows.Forms.CheckBoxTS chkExtRX102;
        private System.Windows.Forms.CheckBoxTS chkExtRX101;
        private System.Windows.Forms.CheckBoxTS chkExtRX105;
        private System.Windows.Forms.CheckBoxTS chkExtRX104;
        private System.Windows.Forms.CheckBoxTS chkExtRX123;
        private System.Windows.Forms.CheckBoxTS chkExtRX122;
        private System.Windows.Forms.CheckBoxTS chkExtRX121;
        private System.Windows.Forms.CheckBoxTS chkExtRX125;
        private System.Windows.Forms.CheckBoxTS chkExtRX124;
        private System.Windows.Forms.CheckBoxTS chkExtRX153;
        private System.Windows.Forms.CheckBoxTS chkExtRX152;
        private System.Windows.Forms.CheckBoxTS chkExtRX151;
        private System.Windows.Forms.CheckBoxTS chkExtRX155;
        private System.Windows.Forms.CheckBoxTS chkExtRX154;
        private System.Windows.Forms.CheckBoxTS chkExtRX173;
        private System.Windows.Forms.CheckBoxTS chkExtRX172;
        private System.Windows.Forms.CheckBoxTS chkExtRX171;
        private System.Windows.Forms.CheckBoxTS chkExtRX175;
        private System.Windows.Forms.CheckBoxTS chkExtRX174;
        private System.Windows.Forms.CheckBoxTS chkExtRX203;
        private System.Windows.Forms.CheckBoxTS chkExtRX202;
        private System.Windows.Forms.CheckBoxTS chkExtRX201;
        private System.Windows.Forms.CheckBoxTS chkExtRX205;
        private System.Windows.Forms.CheckBoxTS chkExtRX204;
        private System.Windows.Forms.CheckBoxTS chkExtRX303;
        private System.Windows.Forms.CheckBoxTS chkExtRX302;
        private System.Windows.Forms.CheckBoxTS chkExtRX301;
        private System.Windows.Forms.CheckBoxTS chkExtRX305;
        private System.Windows.Forms.CheckBoxTS chkExtRX304;
        private System.Windows.Forms.CheckBoxTS chkExtRX403;
        private System.Windows.Forms.CheckBoxTS chkExtRX402;
        private System.Windows.Forms.CheckBoxTS chkExtRX401;
        private System.Windows.Forms.CheckBoxTS chkExtRX405;
        private System.Windows.Forms.CheckBoxTS chkExtRX404;
        private System.Windows.Forms.CheckBoxTS chkExtRX603;
        private System.Windows.Forms.CheckBoxTS chkExtRX602;
        private System.Windows.Forms.CheckBoxTS chkExtRX601;
        private System.Windows.Forms.CheckBoxTS chkExtRX605;
        private System.Windows.Forms.CheckBoxTS chkExtRX604;
        private System.Windows.Forms.CheckBoxTS chkExtRX803;
        private System.Windows.Forms.CheckBoxTS chkExtRX802;
        private System.Windows.Forms.CheckBoxTS chkExtRX801;
        private System.Windows.Forms.CheckBoxTS chkExtRX805;
        private System.Windows.Forms.CheckBoxTS chkExtRX804;
        private System.Windows.Forms.ButtonTS btnCATTest;
        public System.Windows.Forms.TabControl tcAudio;               // ke9ns change
        private System.Windows.Forms.NumericUpDownTS udAudioLineIn1;
        private System.Windows.Forms.ButtonTS btnAudioVoltTest1;
        private System.Windows.Forms.NumericUpDownTS udAudioVoltage1;
        public System.Windows.Forms.GroupBoxTS grpAudioDetails1;
        private System.Windows.Forms.ComboBoxTS comboAudioTransmit1;
        private System.Windows.Forms.LabelTS lblAudioMixer1;
        public System.Windows.Forms.LabelTS lblAudioOutput1;
        private System.Windows.Forms.ComboBoxTS comboAudioOutput1;
        public System.Windows.Forms.LabelTS lblAudioInput1;
        public System.Windows.Forms.LabelTS lblAudioDriver1;
        private System.Windows.Forms.ComboBoxTS comboAudioInput1;
        private System.Windows.Forms.ComboBoxTS comboAudioDriver1;
        private System.Windows.Forms.ComboBoxTS comboAudioMixer1;
        private System.Windows.Forms.LabelTS lblAudioTransmit1;
        private System.Windows.Forms.LabelTS lblAudioReceive1;
        private System.Windows.Forms.ComboBoxTS comboAudioReceive1;
        private System.Windows.Forms.NumericUpDownTS udAudioLatency1;
        private System.Windows.Forms.GroupBoxTS grpAudioCard;
        private System.Windows.Forms.ComboBoxTS comboAudioSoundCard;
        private System.Windows.Forms.ComboBoxTS comboAudioBuffer1;
        public System.Windows.Forms.ComboBoxTS comboAudioSampleRate1;
        private System.Windows.Forms.GroupBoxTS grpAudioLineInGain1;
        private System.Windows.Forms.GroupBoxTS grpAudioLatency1;
        private System.Windows.Forms.CheckBoxTS chkAudioLatencyManual1;
        private System.Windows.Forms.GroupBoxTS grpAudioBufferSize1;
        private System.Windows.Forms.GroupBoxTS grpAudioSampleRate1;
        private System.Windows.Forms.GroupBoxTS grpAudioDetails2;
        public System.Windows.Forms.LabelTS lblAudioOutput2;
        private System.Windows.Forms.ComboBoxTS comboAudioOutput2;
        public System.Windows.Forms.LabelTS lblAudioInput2;
        public System.Windows.Forms.LabelTS lblAudioDriver2;
        private System.Windows.Forms.ComboBoxTS comboAudioInput2;
        private System.Windows.Forms.ComboBoxTS comboAudioDriver2;
        private System.Windows.Forms.NumericUpDownTS udAudioLatency2;
        private System.Windows.Forms.ComboBoxTS comboAudioBuffer2;
        private System.Windows.Forms.ComboBoxTS comboAudioSampleRate2;
        private System.Windows.Forms.GroupBoxTS grpAudioMicInGain1;
        private System.Windows.Forms.NumericUpDownTS udAudioMicGain1;
        private System.Windows.Forms.GroupBoxTS grpAudioBuffer2;
        private System.Windows.Forms.GroupBoxTS grpAudioSampleRate2;
        private System.Windows.Forms.GroupBoxTS grpAudioLatency2;
        private System.Windows.Forms.CheckBoxTS chkAudioLatencyManual2;
        private System.Windows.Forms.GroupBoxTS grpAudioVolts1;
        private System.Windows.Forms.ComboBoxTS comboCATRigType;
        private System.Windows.Forms.ComboBoxTS comboDisplayLabelAlign;
        private System.Windows.Forms.LabelTS lblDisplayAlign;
        private System.Windows.Forms.LabelTS lblCATRigType;
        private System.Windows.Forms.TabPage tpAudioCard1;
        private System.Windows.Forms.TabPage tpDSPKeyer;
        private System.Windows.Forms.NumericUpDownTS udCWKeyerRamp;
        private System.Windows.Forms.LabelTS lblCWRamp;
        private System.Windows.Forms.CheckBoxTS chkCWKeyerIambic;
        private System.Windows.Forms.GroupBoxTS grpDSPKeyerSignalShaping;
        private System.Windows.Forms.NumericUpDownTS udCWKeyerWeight;
        private System.Windows.Forms.LabelTS lblCWWeight;
        private System.Windows.Forms.GroupBoxTS grpDSPKeyerOptions;
        private System.Windows.Forms.GroupBoxTS grpDSPKeyerSemiBreakIn;
        private System.Windows.Forms.GroupBoxTS grpDSPCWPitch;
        private System.Windows.Forms.LabelTS lblDSPCWPitchFreq;
        public System.Windows.Forms.NumericUpDownTS udDSPCWPitch;
        private System.Windows.Forms.CheckBoxTS chkDSPKeyerSidetone;
        public System.Windows.Forms.TabControl tcDSP;
        private System.Windows.Forms.TabPage tpDSPImageReject;
        private System.Windows.Forms.GroupBoxTS grpDSPImageRejectTX;
        private System.Windows.Forms.LabelTS lblDSPGainValTX;
        private System.Windows.Forms.LabelTS lblDSPPhaseValTX;
        private System.Windows.Forms.NumericUpDownTS udDSPImageGainTX;
        private System.Windows.Forms.NumericUpDownTS udDSPImagePhaseTX;
        private System.Windows.Forms.LabelTS lblDSPImageGainTX;
        private System.Windows.Forms.TrackBarTS tbDSPImagePhaseTX;
        private System.Windows.Forms.LabelTS lblDSPImagePhaseTX;
        private System.Windows.Forms.TrackBarTS tbDSPImageGainTX;
        private System.Windows.Forms.TabPage tpDSPOptions;
        private System.Windows.Forms.GroupBoxTS grpDSPBufferSize;
        private System.Windows.Forms.GroupBoxTS grpDSPNB;
        private System.Windows.Forms.NumericUpDownTS udDSPNB;
        private System.Windows.Forms.LabelTS lblDSPNBThreshold;
        private System.Windows.Forms.GroupBoxTS grpDSPLMSNR;
        private System.Windows.Forms.LabelTS lblLMSNRgain;
        private System.Windows.Forms.NumericUpDownTS udLMSNRgain;
        private System.Windows.Forms.NumericUpDownTS udLMSNRdelay;
        private System.Windows.Forms.LabelTS lblLMSNRdelay;
        private System.Windows.Forms.NumericUpDownTS udLMSNRtaps;
        private System.Windows.Forms.LabelTS lblLMSNRtaps;
        private System.Windows.Forms.GroupBoxTS grpDSPLMSANF;
        private System.Windows.Forms.LabelTS lblLMSANFgain;
        private System.Windows.Forms.NumericUpDownTS udLMSANFgain;
        private System.Windows.Forms.LabelTS lblLMSANFdelay;
        private System.Windows.Forms.NumericUpDownTS udLMSANFdelay;
        private System.Windows.Forms.LabelTS lblLMSANFTaps;
        private System.Windows.Forms.NumericUpDownTS udLMSANFtaps;
        private System.Windows.Forms.GroupBoxTS grpDSPAGC;
        private System.Windows.Forms.LabelTS lblDSPAGCMaxGain;
        private System.Windows.Forms.NumericUpDownTS udDSPAGCMaxGaindB;
        private System.Windows.Forms.NumericUpDownTS udDSPAGCFixedGaindB;
        private System.Windows.Forms.LabelTS lblDSPAGCFixed;
        private System.Windows.Forms.GroupBoxTS grpDSPWindow;
        private System.Windows.Forms.ComboBoxTS comboDSPWindow;
        private System.Windows.Forms.GroupBoxTS grpDSPNB2;
        private System.Windows.Forms.LabelTS lblDSPNB2Threshold;
        private System.Windows.Forms.NumericUpDownTS udDSPNB2;
        private System.Windows.Forms.CheckBoxTS chkCWKeyerRevPdl;
        private System.Windows.Forms.CheckBoxTS chkExtEnable;
        private System.Windows.Forms.CheckBoxTS chkExtRX26;
        private System.Windows.Forms.CheckBoxTS chkExtRX66;
        private System.Windows.Forms.CheckBoxTS chkExtRX106;
        private System.Windows.Forms.CheckBoxTS chkExtRX126;
        private System.Windows.Forms.CheckBoxTS chkExtRX156;
        private System.Windows.Forms.CheckBoxTS chkExtRX176;
        private System.Windows.Forms.CheckBoxTS chkExtRX206;
        private System.Windows.Forms.CheckBoxTS chkExtRX306;
        private System.Windows.Forms.CheckBoxTS chkExtRX406;
        private System.Windows.Forms.CheckBoxTS chkExtRX606;
        private System.Windows.Forms.CheckBoxTS chkExtRX806;
        private System.Windows.Forms.CheckBoxTS chkExtRX1606;
        private System.Windows.Forms.LabelTS lblExtRXX26;
        private System.Windows.Forms.LabelTS lblExtTXX26;
        private System.Windows.Forms.CheckBoxTS chkExtTX26;
        private System.Windows.Forms.CheckBoxTS chkExtTX66;
        private System.Windows.Forms.CheckBoxTS chkExtTX106;
        private System.Windows.Forms.CheckBoxTS chkExtTX126;
        private System.Windows.Forms.CheckBoxTS chkExtTX156;
       