/** 
* @file filterbank.h
* @brief Functions to implement a filter bank 
* @author Frank Brickle, AB2KT and Bob McGwier, N4HY

This file is part of a program that implements a Software-Defined Radio.

Copyright (C) 2004, 2005, 2006, 2007, 2008 by Frank Brickle, AB2KT and Bob McGwier, N4HY
Doxygen comments added by Dave Larsen, KV0S

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

The authors can be reached by email at

ab2kt@arrl.net
or
rwmcgwier@gmail.com

or by paper mail at

The DTTS Microwave Society
6 Kathleen Place
Bridgewater, NJ 08807
*/

#ifndef _FILTERBANK_H
#define _FILTERBANK_H
#include <filter.h>

typedef struct _firpfb {
  COMPLEX *sigin;
  COMPLEX *sigout;
  COMPLEX *fftbuffer;
  REAL    **filter_partition;
  COMPLEX **filter_delayline;
  unsigned int numchans;
  unsigned int depth;
  fftwf_plan pchan;
} firpfb,*FIRPFB;

typedef struct _firdownsampler {
  COMPLEX *sigin;
  COMPLEX *sigout;
  REAL    **filter_partition;
  COMPLEX **filter_delayline;
  unsigned int downsample;
  unsigned int depth;
  COMPLEX *rotator;
} firdownsampler, *FIRDownsampler;

typedef struct _firupsampler {
  COMPLEX *sigin;
  COMPLEX *sigout;
  REAL    **filter_partition;
  COMPLEX **filter_delayline;
  unsigned int upsample;
  unsigned int depth;
  COMPLEX *rotator;
} firupsampler, *FIRUpsampler;

extern FIRDownsampler
newFIRDownsampler(RealFIR filter,unsigned int downsample, unsigned int channel, COMPLEX *in, COMPLEX *out);

extern FIRUpsampler
newFIRUpsampler(RealFIR filter,unsigned int upsample, unsigned int channel, COMPLEX *in, COMPLEX *out);

extern FIRPFB
newFIRPFBChannelizer(RealFIR filter,unsigned int numchans, COMPLEX *in, COMPLEX *out, int pbits);

extern FIRPFB
newFIRHBPFBChannelizer(RealFIR filter, COMPLEX *sigin, COMPLEX *sigout);

extern void delFIRPFBChannelizer(FIRPFB p);
extern void delFIRDownsampler(FIRDownsampler p);
extern void doFIRPFBChannelizer(FIRPFB p);
extern void doFIRDownsampler(FIRDownsampler p);
extern void doFIRUpsampler(FIRUpsampler p);

#endif
